<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulao da rea de exames" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Insere uma alternativa na pergunta
	-- cristofer 22/04/2006 11:57:50 - CRIADO
	--->
	<cffunction name='ins_alternativa' displayname='Insere uma alternativa na pergunta' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PERGUNTA_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='CERTA' required='yes'>
				<cfstoredproc procedure='exame.pkg_exame.prc_ins_alternativa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERGUNTA_ID'  value='#arguments.PERGUNTA_ID#'  null='#iif(len(trim(arguments.PERGUNTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CERTA'  value='#arguments.CERTA#'  null='#iif(len(trim(arguments.CERTA)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTERNATIVA_ID' variable='retorno.ALTERNATIVA_ID'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma alternativa na pergunta
	-- cristofer 22/04/2006 11:58:28 - CRIADO
	--->
	<cffunction name='upd_alternativa' displayname='Altera uma alternativa na pergunta' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ALTERNATIVA_ID' required='yes'>
		<cfargument name='PERGUNTA_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='CERTA' required='yes'>
				<cfstoredproc procedure='exame.pkg_exame.prc_alt_alternativa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTERNATIVA_ID'  value='#arguments.ALTERNATIVA_ID#'  null='#iif(len(trim(arguments.ALTERNATIVA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERGUNTA_ID'  value='#arguments.PERGUNTA_ID#'  null='#iif(len(trim(arguments.PERGUNTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CERTA'  value='#arguments.CERTA#'  null='#iif(len(trim(arguments.CERTA)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma alternativa na pergunta
	-- cristofer 22/04/2006 11:58:50 - CRIADO
	--->
	<cffunction name='del_alternativa' displayname='Exclui uma alternativa na pergunta' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ALTERNATIVA_ID' required='yes'>
				<cfstoredproc procedure='exame.pkg_exame.prc_del_alternativa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTERNATIVA_ID'  value='#arguments.ALTERNATIVA_ID#'  null='#iif(len(trim(arguments.ALTERNATIVA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um exame para o examinado
	-- cristofer 22/04/2006 12:00:22 - CRIADO
	--->
	<cffunction name='ins_exame' displayname='Insere um exame para o examinado' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROGRAMACAO_ID' required='yes'>
		<cfargument name='EXAMINADO_ID' required='yes'>
		<cfargument name='DATA_EXECUCAO' required='no' default="#LSDAteFormat(now())#">
		<cfargument name='SITUACAO' required='no' default="0">
				<cfstoredproc procedure='exame.pkg_exame.prc_ins_exame' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROGRAMACAO_ID'  value='#arguments.PROGRAMACAO_ID#'  null='#iif(len(trim(arguments.PROGRAMACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXAMINADO_ID'  value='#arguments.EXAMINADO_ID#'  null='#iif(len(trim(arguments.EXAMINADO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EXECUCAO'  value='#arguments.DATA_EXECUCAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO'  value='#arguments.SITUACAO#'  null='#iif(len(trim(arguments.SITUACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXAME_ID' variable='retorno.EXAME_ID'  >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um exame
	-- cristofer 22/04/2006 12:01:21 - CRIADO
	--->
	<cffunction name='upd_exame' displayname='Altera um exame' access='remote' returntype='Struct' output='true'>;
		<cfargument name='EXAME_ID' required='yes'>
		<cfargument name='DATA_EXECUCAO' required='yes'>
		<cfargument name='SITUACAO' required='yes'>

			<cftransaction action='begin'>
				<cfstoredproc procedure='exame.pkg_exame.prc_alt_exame' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXAME_ID'  value='#arguments.EXAME_ID#'  null='#iif(len(trim(arguments.EXAME_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_TIMESTAMP' dbvarname='P_DATA_EXECUCAO'  value='#arguments.DATA_EXECUCAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO'  value='#arguments.SITUACAO#'  null='#iif(len(trim(arguments.SITUACAO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Exame atualizado com sucesso!')>
			</cftransaction>

		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um exame
	-- cristofer 22/04/2006 12:02:09 - CRIADO
	--->
	<cffunction name='del_exame' displayname='Exclui um exame' access='remote' returntype='Struct' output='true'>;
		<cfargument name='EXAME_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='exame.pkg_exame.prc_del_exame' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXAME_ID'  value='#arguments.EXAME_ID#'  null='#iif(len(trim(arguments.EXAME_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Exame excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma resposta no exame
	-- cristofer 22/04/2006 12:03:58 - CRIADO
	--->
	<cffunction name='ins_exame_resposta' displayname='Insere uma resposta no exame' access='remote' returntype='Struct' output='true'>;
		<cfargument name='EXAME_ID' required='yes'>
		<cfargument name='ALTERNATIVA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfloop list="#arguments.ALTERNATIVA_ID#" delimiters="," index="alt_id">
					<cfstoredproc procedure='exame.pkg_exame.prc_ins_exame_resposta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXAME_ID'  value='#arguments.EXAME_ID#'  null='#iif(len(trim(arguments.EXAME_ID)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTERNATIVA_ID'  value='#alt_id#'  null='#iif(len(trim(alt_id)), de('no'), de('yes'))#'>
					</cfstoredproc>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Resposta computada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>			
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Limpa as respostas da pergunta
	-- cristofer 22/04/2006 12:08:24 - CRIADO
	--->
	<cffunction name='clean_exame_resposta' displayname='Limpa as respostas da pergunta' access='remote' returntype='Struct' output='true'>;
		<cfargument name='EXAME_ID' required='yes'>
		<cfargument name='PERGUNTA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='exame.pkg_exame.prc_clean_exame_resposta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXAME_ID'  value='#arguments.EXAME_ID#'  null='#iif(len(trim(arguments.EXAME_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERGUNTA_ID'  value='#arguments.PERGUNTA_ID#'  null='#iif(len(trim(arguments.PERGUNTA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Resposta computada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um examinado
	-- cristofer 22/04/2006 12:10:22 - CRIADO
	--->
	<cffunction name='ins_examinado' displayname='Insere um examinado' access='remote' returntype='Struct' output='true'>;
		<cfargument name='NOME' required='yes'>
		<cfargument name='COD_ACESSO' required='yes'>
		<cfargument name='SENHA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='exame.pkg_exame.prc_ins_examinado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ACESSO'  value='#arguments.COD_ACESSO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SENHA'  value='#arguments.SENHA#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXAMINADO_ID' variable='retorno.EXAMINADO_ID' >
				</cfstoredproc>
				<cfscript>
					v_exame_id = this.ListaToArray (lista = arguments, variavel = "EXAME_ID_EXAMES");
					v_programacao_id = this.ListaToArray (lista = arguments, variavel = "PROGRAMACAO_ID_EXAMES");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_EXAMES, lista2 = ArrayToList(v_exame_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_exame (exame_id = arguments.EXAME_ID);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_programacao_id)#" index="count">
					<cfscript>
						if(not len(trim(v_exame_id[count]))) {
							this.ins_exame(	examinado_id = retorno.EXAMINADO_ID,
											programacao_id = v_programacao_id[count]);
						}
					</cfscript>
				</cfloop>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Examinado inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um examinado
	-- cristofer 22/04/2006 12:11:09 - CRIADO
	--->
	<cffunction name='upd_examinado' displayname='Altera um examinado' access='remote' returntype='Struct' output='true'>;
		<cfargument name='EXAMINADO_ID' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='COD_ACESSO' required='yes'>
		<cfargument name='SENHA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='exame.pkg_exame.prc_alt_examinado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXAMINADO_ID'  value='#arguments.EXAMINADO_ID#'  null='#iif(len(trim(arguments.EXAMINADO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ACESSO'  value='#arguments.COD_ACESSO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SENHA'  value='#arguments.SENHA#' >
				</cfstoredproc>
				<cfscript>
					retorno.examinado_id = arguments.examinado_id;
					v_exame_id = this.ListaToArray (lista = arguments, variavel = "EXAME_ID_EXAMES");
					v_programacao_id = this.ListaToArray (lista = arguments, variavel = "PROGRAMACAO_ID_EXAMES");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_EXAMES, lista2 = ArrayToList(v_exame_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_exame (exame_id = arguments.EXAME_ID);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_programacao_id)#" index="count">
					<cfscript>
						if(not len(trim(v_exame_id[count]))) {
							this.ins_exame(	examinado_id = retorno.EXAMINADO_ID,
											programacao_id = v_programacao_id[count]);
						}
					</cfscript>
				</cfloop>					
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Examinado alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um examinado
	-- cristofer 22/04/2006 12:14:31 - CRIADO
	--->
	<cffunction name='del_examinado' displayname='Exclui um examinado' access='remote' returntype='Struct' output='true'>;
		<cfargument name='EXAMINADO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='exame.pkg_exame.prc_del_examinado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXAMINADO_ID'  value='#arguments.EXAMINADO_ID#'  null='#iif(len(trim(arguments.EXAMINADO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Examinado excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma pergunta no tema
	-- cristofer 22/04/2006 12:15:39 - CRIADO
	--->
	<cffunction name='ins_pergunta' displayname='Insere uma pergunta no tema' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TEMA_ID' required='yes'>
		<cfargument name='PERGUNTA' required='yes'>
		<cfargument name='NIVEL_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='exame.pkg_exame.prc_ins_pergunta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TEMA_ID'  value='#arguments.TEMA_ID#'  null='#iif(len(trim(arguments.TEMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PERGUNTA'  value='#arguments.PERGUNTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NIVEL_ID'  value='#arguments.NIVEL_ID#'  null='#iif(len(trim(arguments.NIVEL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERGUNTA_ID' variable='retorno.PERGUNTA_ID'  null='#iif(len(trim(arguments.PERGUNTA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfscript>
					v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_ALTERNATIVAS");
					v_alternativa_id = this.ListaToArray (lista = arguments, variavel = "ALTERNATIVA_ID_ALTERNATIVAS");
					v_certa = this.ListaToArray (lista = arguments, variavel = "CERTA_ALTERNATIVAS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ALTERNATIVAS, lista2 = ArrayToList(v_alternativa_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_alternativa (alternativa_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
					<cfscript>
						if(not len(trim(v_alternativa_id[count]))) {
							this.ins_alternativa(	descricao = v_descricao[count],
													pergunta_id = retorno.pergunta_id,
													certa = v_certa[count]);
						} else {
							this.upd_alternativa(	alternativa_id = v_alternativa_id[count],
													descricao = v_descricao[count],
													certa = v_certa[count],
													pergunta_id = retorno.pergunta_id);
						}
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pergunta inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma pergunta no tema
	-- cristofer 22/04/2006 12:16:36 - CRIADO
	--->
	<cffunction name='upd_pergunta' displayname='Altera uma pergunta no tema' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PERGUNTA_ID' required='yes'>
		<cfargument name='TEMA_ID' required='yes'>
		<cfargument name='PERGUNTA' required='yes'>
		<cfargument name='NIVEL_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='exame.pkg_exame.prc_alt_pergunta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERGUNTA_ID'  value='#arguments.PERGUNTA_ID#'  null='#iif(len(trim(arguments.PERGUNTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TEMA_ID'  value='#arguments.TEMA_ID#'  null='#iif(len(trim(arguments.TEMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PERGUNTA'  value='#arguments.PERGUNTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NIVEL_ID'  value='#arguments.NIVEL_ID#'  null='#iif(len(trim(arguments.NIVEL_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfscript>
					retorno.pergunta_id = arguments.pergunta_id;
					v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_ALTERNATIVAS");
					v_alternativa_id = this.ListaToArray (lista = arguments, variavel = "ALTERNATIVA_ID_ALTERNATIVAS");
					v_certa = this.ListaToArray (lista = arguments, variavel = "CERTA_ALTERNATIVAS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ALTERNATIVAS, lista2 = ArrayToList(v_alternativa_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_alternativa (alternativa_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
					<cfscript>
						if(not len(trim(v_alternativa_id[count]))) {
							this.ins_alternativa(	descricao = v_descricao[count],
													pergunta_id = retorno.pergunta_id,
													certa = v_certa[count]);
						} else {
							this.upd_alternativa(	alternativa_id = v_alternativa_id[count],
													descricao = v_descricao[count],
													certa = v_certa[count],
													pergunta_id = retorno.pergunta_id);
						}
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pergunta alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma pergunta no tema
	-- cristofer 22/04/2006 12:17:07 - CRIADO
	--->
	<cffunction name='del_pergunta' displayname='Exclui uma pergunta no tema' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PERGUNTA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='exame.pkg_exame.prc_del_pergunta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERGUNTA_ID'  value='#arguments.PERGUNTA_ID#'  null='#iif(len(trim(arguments.PERGUNTA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pergunta excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um nivel de pergunta
	-- cristofer 22/04/2006 12:18:06 - CRIADO
	--->
	<cffunction name='ins_pergunta_nivel' displayname='Insere um nivel de pergunta' access='remote' returntype='Struct' output='true'>;
		<cfargument name='NIVEL_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='exame.pkg_exame.prc_ins_pergunta_nivel' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NIVEL_ID'  value='#arguments.NIVEL_ID#'  null='#iif(len(trim(arguments.NIVEL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Nivel inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um nivel de pergunta
	-- cristofer 22/04/2006 12:20:34 - CRIADO
	--->
	<cffunction name='del_pergunta_nivel' displayname='Exclui um nivel de pergunta' access='remote' returntype='Struct' output='true'>;
		<cfargument name='NIVEL_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='exame.pkg_exame.prc_del_pergunta_nivel' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NIVEL_ID'  value='#arguments.NIVEL_ID#'  null='#iif(len(trim(arguments.NIVEL_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Nivel excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma programacao de exame
	-- cristofer 22/04/2006 12:21:23 - CRIADO
	--->
	<cffunction name='ins_programacao' displayname='Insere uma programacao de exame' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='TEMPO_EXECUCAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='exame.pkg_exame.prc_ins_programacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TEMPO_EXECUCAO' value='00 #arguments.TEMPO_EXECUCAO#:00'  null='#iif(len(trim(arguments.TEMPO_EXECUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROGRAMACAO_ID' variable='retorno.PROGRAMACAO_ID'>
				</cfstoredproc>
				<cfscript>
					v_tema_id = this.ListaToArray (lista = arguments, variavel = "TEMA_ID_TEMAS");
					v_numero_questoes = this.ListaToArray (lista = arguments, variavel = "NUMERO_QUESTOES_TEMAS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_TEMAS, lista2 = ArrayToList(v_tema_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_programacao_tema (tema_id = l_id,
													programacao_id = retorno.programacao_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_tema_id)#" index="count">
					<cfscript>
							this.ins_programacao_tema(	tema_id = v_tema_id[count],
														programacao_id = retorno.programacao_id,
														numero_questoes = v_numero_questoes[count]);
					</cfscript>
				</cfloop>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Programao inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma programacao de exame
	-- cristofer 22/04/2006 12:22:07 - CRIADO
	--->
	<cffunction name='upd_programacao' displayname='Altera uma programacao de exame' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROGRAMACAO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='TEMPO_EXECUCAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='exame.pkg_exame.prc_alt_programacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROGRAMACAO_ID'  value='#arguments.PROGRAMACAO_ID#'  null='#iif(len(trim(arguments.PROGRAMACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TEMPO_EXECUCAO' value='00 #arguments.TEMPO_EXECUCAO#:00'  null='#iif(len(trim(arguments.TEMPO_EXECUCAO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfscript>
					retorno.programacao_id = arguments.programacao_id;
					v_tema_id = this.ListaToArray (lista = arguments, variavel = "TEMA_ID_TEMAS");
					v_numero_questoes = this.ListaToArray (lista = arguments, variavel = "NUMERO_QUESTOES_TEMAS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_TEMAS, lista2 = ArrayToList(v_tema_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_programacao_tema (tema_id = l_id,
													programacao_id = retorno.programacao_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_tema_id)#" index="count">
					<cfscript>
							this.ins_programacao_tema(	tema_id = v_tema_id[count],
														programacao_id = retorno.programacao_id,
														numero_questoes = v_numero_questoes[count]);
					</cfscript>
				</cfloop>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Programao alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma programacao de exame
	-- cristofer 22/04/2006 12:22:57 - CRIADO
	--->
	<cffunction name='del_programacao' displayname='Exclui uma programacao de exame' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROGRAMACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='exame.pkg_exame.prc_del_programacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROGRAMACAO_ID'  value='#arguments.PROGRAMACAO_ID#'  null='#iif(len(trim(arguments.PROGRAMACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Programao excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um tema na programacao
	-- cristofer 22/04/2006 12:24:00 - CRIADO
	--->
	<cffunction name='ins_programacao_tema' displayname='Insere um tema na programacao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROGRAMACAO_ID' required='yes'>
		<cfargument name='TEMA_ID' required='yes'>
		<cfargument name='NUMERO_QUESTOES' required='yes'>
				<cfstoredproc procedure='exame.pkg_exame.prc_ins_programacao_tema' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROGRAMACAO_ID'  value='#arguments.PROGRAMACAO_ID#'  null='#iif(len(trim(arguments.PROGRAMACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TEMA_ID'  value='#arguments.TEMA_ID#'  null='#iif(len(trim(arguments.TEMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUMERO_QUESTOES'  value='#arguments.NUMERO_QUESTOES#'  null='#iif(len(trim(arguments.NUMERO_QUESTOES)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um tema na programacao
	-- cristofer 22/04/2006 12:24:50 - CRIADO
	--->
	<cffunction name='del_programacao_tema' displayname='Exclui um tema na programacao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROGRAMACAO_ID' required='yes'>
		<cfargument name='TEMA_ID' required='yes'>
				<cfstoredproc procedure='exame.pkg_exame.prc_del_programacao_tema' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROGRAMACAO_ID'  value='#arguments.PROGRAMACAO_ID#'  null='#iif(len(trim(arguments.PROGRAMACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TEMA_ID'  value='#arguments.TEMA_ID#'  null='#iif(len(trim(arguments.TEMA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere tema
	-- cristofer 22/04/2006 12:25:43 - CRIADO
	--->
	<cffunction name='ins_tema' displayname='Insere tema' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='exame.pkg_exame.prc_ins_tema' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TEMA_ID' variable='retorno.TEMA_ID'  null='#iif(len(trim(arguments.TEMA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tema inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um tema
	-- cristofer 22/04/2006 12:26:21 - CRIADO
	--->
	<cffunction name='upd_tema' displayname='Altera um tema' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TEMA_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='exame.pkg_exame.prc_alt_tema' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TEMA_ID'  value='#arguments.TEMA_ID#'  null='#iif(len(trim(arguments.TEMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tema alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um tema
	-- cristofer 22/04/2006 12:26:49 - CRIADO
	--->
	<cffunction name='del_tema' displayname='Exclui um tema' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TEMA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='exame.pkg_exame.prc_del_tema' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TEMA_ID'  value='#arguments.TEMA_ID#'  null='#iif(len(trim(arguments.TEMA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tema excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>