

<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de emissao de documentos" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Gera o complemento, seja de romaneio ou por CTRC
	-- Para complemento do CTRC NUM_ROMANEIO deve ser 0
	-- ANDERSON 10/06/2009 - ALTERADO
	--->
	<cffunction name='ins_relacao_complemento' displayname='Gera o complemento, seja de romaneio ou por CTRC' access='remote' returntype='Struct' output='true'>;
        <cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='PESO_CORRETO' required='yes'>
		<cfargument name='VALOR_UNITARIO' required='yes'>
		<cfargument name='FRETE_CORRETO' required='yes'>
		<cfargument name='DIFERENCA' required='no' default=''>
        <cfargument name='M3_CORRETO' required='no' default=''>
        <cfargument name='PESO_COBRADO_CORRETO' required='no' default=''>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_conhecimento_dml.prc_ins_complemento_relacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_CORRETO'  value='#arguments.PESO_CORRETO#'  null='#iif(len(trim(arguments.PESO_CORRETO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_UNITARIO'  value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_CORRETO'  value='#arguments.FRETE_CORRETO#'  null='#iif(len(trim(arguments.FRETE_CORRETO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RELACAO_ID' variable='retorno.RELACAO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIFERENCA'  value='#arguments.DIFERENCA#'  null='#iif(len(trim(arguments.DIFERENCA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_M3_CORRETO'  value='#arguments.M3_CORRETO#'  null='#iif(len(trim(arguments.M3_CORRETO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_COBRADO_CORRETO'  value='#arguments.PESO_COBRADO_CORRETO#'  null='#iif(len(trim(arguments.PESO_COBRADO_CORRETO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Complemento '&#retorno.RELACAO_ID#&' inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui um CTRC de uma rela??o de complemento
	-- guto 04/04/2006 10:34:55 - CRIADO
	--->
	<cffunction name='del_conhecimento_complemento' displayname='Exclui um CTRC de uma relacao de complemento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_del_complemento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Complemento excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Registra um conhecimento com o numero pr-definido
	-- guto 12/04/2006 18:04:25 - CRIADO
	--->
	<cffunction name='registra_conhecimento' displayname='Registra um conhecimento com o numero pr-definido' access='remote' returntype='Struct' output='false'>;
		<cfargument name='NUM_CONHECIMENTO' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='NUM_PRODUTO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='PAGADOR' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='REM_RAZAO_SOCIAL' required='yes'>
		<cfargument name='REM_ENDERECO' required='yes'>
		<cfargument name='REM_MUNICIPIO' required='yes'>
		<cfargument name='REM_UF' required='yes'>
		<cfargument name='REM_CEP' required='yes'>
		<cfargument name='REM_CNPJ_CPF' required='yes'>
		<cfargument name='REM_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='DEST_RAZAO_SOCIAL' required='yes'>
		<cfargument name='DEST_ENDERECO' required='yes'>
		<cfargument name='DEST_MUNICIPIO' required='yes'>
		<cfargument name='DEST_UF' required='yes'>
		<cfargument name='DEST_CEP' required='yes'>
		<cfargument name='DEST_CNPJ_CPF' required='yes'>
		<cfargument name='DEST_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='COD_CONSIGNATARIO' required='yes'>
		<cfargument name='CONS_RAZAO_SOCIAL' required='yes'>
		<cfargument name='CONS_ENDERECO' required='yes'>
		<cfargument name='CONS_MUNICIPIO' required='yes'>
		<cfargument name='CONS_UF' required='yes'>
		<cfargument name='CONS_CEP' required='yes'>
		<cfargument name='CONS_CNPJ_CPF' required='yes'>
		<cfargument name='CONS_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='M3' required='no' default="0">
		<cfargument name='FRETE_UNITARIO' required='yes'>
		<cfargument name='FRETE_PESO' required='no' default="0" >
		<cfargument name='FRETE_VALOR' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='PEDAGIO' required='yes'>
		<cfargument name='BASE_CALCULO_ICMS' required='yes'>
		<cfargument name='ALIQUOTA_ICMS' required='yes'>
		<cfargument name='ADEME' required='yes'>
		<cfargument name='DESCONTO' required='yes'>
		<cfargument name='VALOR_ICMS' required='yes'>
		<cfargument name='VALOR_ICMS_SUBSTIT' required='yes'>
		<cfargument name='COLETA_ENTREGA' required='yes'>
		<cfargument name='IMPOSTOS' required='yes'>
		<cfargument name='TOTAL_CONHECIMENTO' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='COLETA_COD_UF' required='yes'>
		<cfargument name='COLETA_COD_MUNICIPIO' required='yes'>
		<cfargument name='COLETA_COD_DISTRITO' required='yes'>
		<cfargument name='COLETA_COD_DV' required='yes'>
		<cfargument name='ENTREGA_COD_UF' required='yes'>
		<cfargument name='ENTREGA_COD_MUNICIPIO' required='yes'>
		<cfargument name='ENTREGA_COD_DISTRITO' required='yes'>
		<cfargument name='ENTREGA_COD_DV' required='yes'>
		<cfargument name='PLACA_REFERENCIA' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='NOME_MOTORISTA' required='yes'>
		<cfargument name='COD_PROPRIETARIO' required='yes'>
		<cfargument name='PROP_CNPJ_CPF' required='yes'>
		<cfargument name='PROP_RAZAO_SOCIAL' required='yes'>
		<cfargument name='PROP_ENDERECO' required='yes'>
		<cfargument name='PROP_UF' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='RODAPE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfif (isdefined("session.site") and session.site eq "verdescampos/" and arguments.NUM_CONHECIMENTO eq -1)
				or (isdefined("session.site") and session.site eq "rodomar/" and arguments.NUM_CONHECIMENTO eq -1)>					
					<!---Se a filial for de MG ento deve chamar a funo de insere CTRC para que o numero seja gerado automaticamento(Removido)--->
					<cfscript>
						retorno = this.ins_conhecimento_private(argumentCollection = arguments);
					</cfscript>			
				<cfelse>
					<!---Registra o CTRC com o numero definido--->
					<cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_registra_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_CONHECIMENTO'  value='#arguments.NUM_CONHECIMENTO#' variable='retorno.NUM_CONHECIMENTO'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO)), de('no'), de('yes'))#'>
						<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#' variable='retorno.ITEM_ID'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#session.COD_PESSOA#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DEPARTAMENTO'  value='#session.COD_DEPARTAMENTO#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SETOR'  value='#session.COD_SETOR#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#session.COD_CENTRO_CUSTO#'>
						<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' variable='retorno.DATA_EMISSAO' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_PRODUTO'  value='#arguments.NUM_PRODUTO#'  null='#iif(len(trim(arguments.NUM_PRODUTO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ORIGEM_ID'  value='0' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#trim(arguments.ST_ICMS_ID)#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PAGADOR'  value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_RAZAO_SOCIAL'  value='#arguments.REM_RAZAO_SOCIAL#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_ENDERECO'  value='#arguments.REM_ENDERECO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_MUNICIPIO'  value='#arguments.REM_MUNICIPIO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_UF'  value='#arguments.REM_UF#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_CEP'  value='#arguments.REM_CEP#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_CNPJ_CPF'  value='#arguments.REM_CNPJ_CPF#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_INSCRICAO_ESTADUAL'  value='#arguments.REM_INSCRICAO_ESTADUAL#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_RAZAO_SOCIAL'  value='#arguments.DEST_RAZAO_SOCIAL#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_ENDERECO'  value='#arguments.DEST_ENDERECO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_MUNICIPIO'  value='#arguments.DEST_MUNICIPIO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_UF'  value='#arguments.DEST_UF#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CEP'  value='#arguments.DEST_CEP#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CNPJ_CPF'  value='#arguments.DEST_CNPJ_CPF#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_INSCRICAO_ESTADUAL'  value='#arguments.DEST_INSCRICAO_ESTADUAL#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONSIGNATARIO'  value='#arguments.COD_CONSIGNATARIO#'  null='#iif(len(trim(arguments.COD_CONSIGNATARIO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_RAZAO_SOCIAL'  value='#arguments.CONS_RAZAO_SOCIAL#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_ENDERECO'  value='#arguments.CONS_ENDERECO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_MUNICIPIO'  value='#arguments.CONS_MUNICIPIO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_UF'  value='#arguments.CONS_UF#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_CEP'  value='#arguments.CONS_CEP#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_CNPJ_CPF'  value='#arguments.CONS_CNPJ_CPF#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_INSCRICAO_ESTADUAL'  value='#arguments.CONS_INSCRICAO_ESTADUAL#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_REDESPACHO'  null='yes'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_RAZAO_SOCIAL'  value='' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_ENDERECO'  value='' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_MUNICIPIO'  value='' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_UF'  value='' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_CEP'  value='' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_CNPJ_CPF'  value='' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_INSCRICAO_ESTADUAL'  value='' >
						<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO'  value='#arguments.PESO#' variable='retorno.PESO'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VOLUME'  value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_UNITARIO'  value='#arguments.FRETE_UNITARIO#'  null='#iif(len(trim(arguments.FRETE_UNITARIO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_PESO'  value='#arguments.FRETE_PESO#'  null='#iif(len(trim(arguments.FRETE_PESO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_VALOR'  value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESPACHO'  value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BASE_CALCULO_ICMS'  value='#arguments.BASE_CALCULO_ICMS#'  null='#iif(len(trim(arguments.BASE_CALCULO_ICMS)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALIQUOTA_ICMS'  value='#arguments.ALIQUOTA_ICMS#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ADEME'  value='#arguments.ADEME#'  null='#iif(len(trim(arguments.ADEME)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCONTO'  value='#arguments.DESCONTO#'  null='#iif(len(trim(arguments.DESCONTO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SEC_CAT'  value='0'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRIS'  value='0'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PEDAGIO'  value='#arguments.PEDAGIO#'  null='#iif(len(trim(arguments.PEDAGIO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ICMS'  value='#arguments.VALOR_ICMS#'  null='#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ICMS_SUBSTIT'  value='#arguments.VALOR_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.VALOR_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_ENTREGA'  value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMPOSTOS'  value='#arguments.IMPOSTOS#'  null='#iif(len(trim(arguments.IMPOSTOS)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TOTAL_CONHECIMENTO'  value='#arguments.TOTAL_CONHECIMENTO#'  null='#iif(len(trim(arguments.TOTAL_CONHECIMENTO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_LOGRADOURO'  value='' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_COMPLEMENTO'  value='' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_BAIRRO'  value='' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_CEP'  value='' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_UF'  value='' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_UF'  value='#arguments.COLETA_COD_UF#'  null='#iif(len(trim(arguments.COLETA_COD_UF)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_MUNICIPIO'  value='#arguments.COLETA_COD_MUNICIPIO#'  null='#iif(len(trim(arguments.COLETA_COD_MUNICIPIO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_DISTRITO'  value='#arguments.COLETA_COD_DISTRITO#'  null='#iif(len(trim(arguments.COLETA_COD_DISTRITO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_DV'  value='#arguments.COLETA_COD_DV#'  null='#iif(len(trim(arguments.COLETA_COD_DV)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_LOGRADOURO'  value='' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_COMPLEMENTO'  value='' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_BAIRRO'  value='' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_CEP'  value='' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_UF'  value='' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_UF'  value='#arguments.ENTREGA_COD_UF#'  null='#iif(len(trim(arguments.ENTREGA_COD_UF)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_MUNICIPIO'  value='#arguments.ENTREGA_COD_MUNICIPIO#'  null='#iif(len(trim(arguments.ENTREGA_COD_MUNICIPIO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_DISTRITO'  value='#arguments.ENTREGA_COD_DISTRITO#'  null='#iif(len(trim(arguments.ENTREGA_COD_DISTRITO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_DV'  value='#arguments.ENTREGA_COD_DV#'  null='#iif(len(trim(arguments.ENTREGA_COD_DV)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA_REFERENCIA#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_MOTORISTA'  value='#arguments.NOME_MOTORISTA#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROPRIETARIO'  value='#arguments.COD_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PROPRIETARIO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_CNPJ_CPF'  value='#arguments.PROP_CNPJ_CPF#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_RAZAO_SOCIAL'  value='#arguments.PROP_RAZAO_SOCIAL#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_ENDERECO'  value='#arguments.PROP_ENDERECO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_UF'  value='#trim(arguments.PROP_UF)#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='0'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMPRESSO'  value='1'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RODAPE'  value='#arguments.RODAPE#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTRADA_DADOS'  value='2'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_COMPLEMENTO'  value='0'>
						<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID' variable='retorno.CONHECIMENTO_ID'  >
						<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_tem_nota" value="1">
					</cfstoredproc>
				</cfif>

				<!--- Insere Notas fiscais --->
				
				<cfscript>
					v_numero 	   		= this.ListaToArray (lista = arguments, variavel = "NOTA_NUMERO_NOTAS_FISCAIS");
					v_data_emissao 		= this.ListaToArray (lista = arguments, variavel = "NOTA_DATA_EMISSAO_NOTAS_FISCAIS");
					v_serie 	   		= this.ListaToArray (lista = arguments, variavel = "NOTA_SERIE_NOTAS_FISCAIS");
					v_sub_serie    		= this.ListaToArray (lista = arguments, variavel = "NOTA_SUB_SERIE_NOTAS_FISCAIS");
					v_modelo       		= this.ListaToArray (lista = arguments, variavel = "NOTA_MODELO_NOTAS_FISCAIS");
					v_valor		   		= this.ListaToArray (lista = arguments, variavel = "NOTA_VALOR_NOTAS_FISCAIS");
					v_nf_eletronica	    = this.ListaToArray (lista = arguments, variavel = "NF_ELETRONICA_NOTAS_FISCAIS");
				</cfscript>

				<cfloop from="1" to="#ArrayLen(v_numero)#" index="count">
					<cfscript>
						this.ins_nf_conhecimento(conhecimento_id = retorno.conhecimento_id,
												 numero			 = v_numero[count],
												 data_emissao	 = v_data_emissao[count],
												 modelo 		 = v_modelo[count],
												 serie 			 = v_serie[count],
												 sub_serie 		 = v_sub_serie[count],
												 valor_total 	 = v_valor[count],
												 nf_eletronica   = v_nf_eletronica[count]);
					</cfscript>
				</cfloop>
            
                <cfstoredproc procedure='fiscal.pkg_conhecimento.prc_valida_seguro_ctrc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#retorno.conhecimento_id#'>
				</cfstoredproc>                

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Conhecimento inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
				<cfif IsDefined("retorno.mensagem.nativeerrorcode") and retorno.mensagem.nativeerrorcode eq 20302>
					<cfset retorno.mensagem.mensagem = 'Impossvel emitir conhecimento para a mesma cidade.'>
				</cfif>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	
	<!--- 
	-- PROPSITO
	-- Insere um novo conhecimento
	-- guto 19/04/2006 10:08:35 - CRIADO
	--->
	<cffunction name='ins_conhecimento_private' displayname='' access='remote' returntype='Struct' output='true'>;
        <cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_ins_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
            <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_CONHECIMENTO'  value='-1' variable='retorno.NUM_CONHECIMENTO'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO)), de('no'), de('yes'))#'>
            <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#' variable='retorno.ITEM_ID'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#session.COD_PESSOA#'  null='#iif(len(trim(session.COD_PESSOA)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DEPARTAMENTO'  value='#session.COD_DEPARTAMENTO#'  null='#iif(len(trim(session.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SETOR'  value='#session.COD_SETOR#'  null='#iif(len(trim(session.COD_SETOR)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#session.COD_CENTRO_CUSTO#'  null='#iif(len(trim(session.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
            <cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' variable='retorno.DATA_EMISSAO' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_PRODUTO'  value='#arguments.NUM_PRODUTO#'  null='#iif(len(trim(arguments.NUM_PRODUTO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ORIGEM_ID'  value='0' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#trim(arguments.ST_ICMS_ID)#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PAGADOR'  value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_RAZAO_SOCIAL'  value='#arguments.REM_RAZAO_SOCIAL#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_ENDERECO'  value='#arguments.REM_ENDERECO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_MUNICIPIO'  value='#arguments.REM_MUNICIPIO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_UF'  value='#arguments.REM_UF#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_CEP'  value='#arguments.REM_CEP#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_CNPJ_CPF'  value='#arguments.REM_CNPJ_CPF#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_INSCRICAO_ESTADUAL'  value='#arguments.REM_INSCRICAO_ESTADUAL#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_RAZAO_SOCIAL'  value='#arguments.DEST_RAZAO_SOCIAL#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_ENDERECO'  value='#arguments.DEST_ENDERECO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_MUNICIPIO'  value='#arguments.DEST_MUNICIPIO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_UF'  value='#arguments.DEST_UF#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CEP'  value='#arguments.DEST_CEP#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CNPJ_CPF'  value='#arguments.DEST_CNPJ_CPF#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_INSCRICAO_ESTADUAL'  value='#arguments.DEST_INSCRICAO_ESTADUAL#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONSIGNATARIO'  value='#arguments.COD_CONSIGNATARIO#'  null='#iif(len(trim(arguments.COD_CONSIGNATARIO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_RAZAO_SOCIAL'  value='#arguments.CONS_RAZAO_SOCIAL#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_ENDERECO'  value='#arguments.CONS_ENDERECO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_MUNICIPIO'  value='#arguments.CONS_MUNICIPIO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_UF'  value='#arguments.CONS_UF#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_CEP'  value='#arguments.CONS_CEP#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_CNPJ_CPF'  value='#arguments.CONS_CNPJ_CPF#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_INSCRICAO_ESTADUAL'  value='#arguments.CONS_INSCRICAO_ESTADUAL#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_REDESPACHO'  null='yes'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_RAZAO_SOCIAL'  value='' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_ENDERECO'  value='' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_MUNICIPIO'  value='' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_UF'  value='' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_CEP'  value='' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_CNPJ_CPF'  value='' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_INSCRICAO_ESTADUAL'  value='' >
            <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO'  value='#arguments.PESO#' variable='retorno.PESO'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VOLUME'  value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_UNITARIO'  value='#arguments.FRETE_UNITARIO#'  null='#iif(len(trim(arguments.FRETE_UNITARIO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_PESO'  value='#arguments.FRETE_PESO#'  null='#iif(len(trim(arguments.FRETE_PESO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_VALOR'  value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESPACHO'  value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BASE_CALCULO_ICMS'  value='#arguments.BASE_CALCULO_ICMS#'  null='#iif(len(trim(arguments.BASE_CALCULO_ICMS)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALIQUOTA_ICMS'  value='#arguments.ALIQUOTA_ICMS#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ADEME'  value='#arguments.ADEME#'  null='#iif(len(trim(arguments.ADEME)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCONTO'  value='#arguments.DESCONTO#'  null='#iif(len(trim(arguments.DESCONTO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SEC_CAT'  value='0'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRIS'  value='0'  >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PEDAGIO'  value='#arguments.PEDAGIO#'  null='#iif(len(trim(arguments.PEDAGIO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ICMS'  value='#arguments.VALOR_ICMS#'  null='#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ICMS_SUBSTIT'  value='#arguments.VALOR_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.VALOR_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_ENTREGA'  value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMPOSTOS'  value='#arguments.IMPOSTOS#'  null='#iif(len(trim(arguments.IMPOSTOS)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TOTAL_CONHECIMENTO'  value='#arguments.TOTAL_CONHECIMENTO#'  null='#iif(len(trim(arguments.TOTAL_CONHECIMENTO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_LOGRADOURO'  value='' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_COMPLEMENTO'  value='' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_BAIRRO'  value='' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_CEP'  value='' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_UF'  value='' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_UF'  value='#arguments.COLETA_COD_UF#'  null='#iif(len(trim(arguments.COLETA_COD_UF)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_MUNICIPIO'  value='#arguments.COLETA_COD_MUNICIPIO#'  null='#iif(len(trim(arguments.COLETA_COD_MUNICIPIO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_DISTRITO'  value='#arguments.COLETA_COD_DISTRITO#'  null='#iif(len(trim(arguments.COLETA_COD_DISTRITO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_DV'  value='#arguments.COLETA_COD_DV#'  null='#iif(len(trim(arguments.COLETA_COD_DV)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_LOGRADOURO'  value='' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_COMPLEMENTO'  value='' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_BAIRRO'  value='' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_CEP'  value='' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_UF'  value='' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_UF'  value='#arguments.ENTREGA_COD_UF#'  null='#iif(len(trim(arguments.ENTREGA_COD_UF)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_MUNICIPIO'  value='#arguments.ENTREGA_COD_MUNICIPIO#'  null='#iif(len(trim(arguments.ENTREGA_COD_MUNICIPIO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_DISTRITO'  value='#arguments.ENTREGA_COD_DISTRITO#'  null='#iif(len(trim(arguments.ENTREGA_COD_DISTRITO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_DV'  value='#arguments.ENTREGA_COD_DV#'  null='#iif(len(trim(arguments.ENTREGA_COD_DV)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA_REFERENCIA#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_MOTORISTA'  value='#arguments.NOME_MOTORISTA#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROPRIETARIO'  value='#arguments.COD_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PROPRIETARIO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_CNPJ_CPF'  value='#arguments.PROP_CNPJ_CPF#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_RAZAO_SOCIAL'  value='#arguments.PROP_RAZAO_SOCIAL#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_ENDERECO'  value='#arguments.PROP_ENDERECO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_UF'  value='#trim(arguments.PROP_UF)#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='0'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RODAPE'  value='#arguments.RODAPE#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTRADA_DADOS'  value='2'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_COMPLEMENTO'  value='0'>
            <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID' variable='retorno.CONHECIMENTO_ID'>
            <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_tem_nota" value="1">
        </cfstoredproc>	    
		<cfreturn retorno>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Deleta a relao de complemento por CTRC
	-- guto 19/04/2006 10:08:35 - CRIADO
	--->
	
	<cffunction name="del_relacao_complemento" displayname="Apaga relao" access="remote" returntype="struct" output="true">
		<cfargument name="relacao_id" displayname="identificador da relao" required="yes">
		<cfargument name="conhecimento_id" displayname="identificador da relao" required="yes">
		<cftry>
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				delete oper.v$conhecimento_complemento
				 where relacao_id = #arguments.relacao_id#
				and conhecimento_id = #arguments.conhecimento_id#
			</cfquery>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Relao excluda com sucesso!')>	
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera dados do CTRC
	-- guto 19/04/2006 10:08:35 - CRIADO
	--->
	
	<cffunction name='upd_conhecimento' displayname='Altera dados do CTRC' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='NUM_CONHECIMENTO' required='yes'>
		<cfargument name='CONHECIMENTO_COMPLEMENTO' required='no' default="0">
		<cfargument name='SERIE' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='NUM_PRODUTO' required='yes'>
		<cfargument name='CFOP_ID' required='yes'>
		<cfargument name='CFOP' required='yes'>
		<cfargument name='NATUREZA_OPERACAO' required='yes'>
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='PAGADOR' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='REM_RAZAO_SOCIAL' required='yes'>
		<cfargument name='REM_ENDERECO' required='yes'>
		<cfargument name='REM_MUNICIPIO' required='yes'>
		<cfargument name='REM_UF' required='yes'>
		<cfargument name='REM_CEP' required='yes'>
		<cfargument name='REM_CNPJ_CPF' required='yes'>
		<cfargument name='REM_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='DEST_RAZAO_SOCIAL' required='yes'>
		<cfargument name='DEST_ENDERECO' required='yes'>
		<cfargument name='DEST_MUNICIPIO' required='yes'>
		<cfargument name='DEST_UF' required='yes'>
		<cfargument name='DEST_CEP' required='yes'>
		<cfargument name='DEST_CNPJ_CPF' required='yes'>
		<cfargument name='DEST_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='COD_CONSIGNATARIO' required='yes'>
		<cfargument name='CONS_RAZAO_SOCIAL' required='yes'>
		<cfargument name='CONS_ENDERECO' required='yes'>
		<cfargument name='CONS_MUNICIPIO' required='yes'>
		<cfargument name='CONS_UF' required='yes'>
		<cfargument name='CONS_CEP' required='yes'>
		<cfargument name='CONS_CNPJ_CPF' required='yes'>
		<cfargument name='CONS_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='FRETE_UNITARIO' required='yes'>
		<cfargument name='FRETE_PESO' required='yes'>
		<cfargument name='FRETE_VALOR' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='BASE_CALCULO_ICMS' required='yes'>
		<cfargument name='ALIQUOTA_ICMS' required='yes'>
		<cfargument name='ADEME' required='yes'>
		<cfargument name='DESCONTO' required='yes'>
		<cfargument name='PEDAGIO' required='yes'>
		<cfargument name='VALOR_ICMS' required='yes'>
		<cfargument name='VALOR_ICMS_SUBSTIT' required='yes'>
		<cfargument name='COLETA_ENTREGA' required='yes'>
		<cfargument name='IMPOSTOS' required='yes'>
		<cfargument name='TOTAL_CONHECIMENTO' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='COLETA_COD_UF' required='yes'>
		<cfargument name='COLETA_COD_MUNICIPIO' required='yes'>
		<cfargument name='COLETA_COD_DISTRITO' required='yes'>
		<cfargument name='COLETA_COD_DV' required='yes'>
		<cfargument name='ENTREGA_COD_UF' required='yes'>
		<cfargument name='ENTREGA_COD_MUNICIPIO' required='yes'>
		<cfargument name='ENTREGA_COD_DISTRITO' required='yes'>
		<cfargument name='ENTREGA_COD_DV' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='NOME_MOTORISTA' required='yes'>
		<cfargument name='COD_PROPRIETARIO' required='yes'>
		<cfargument name='PROP_CNPJ_CPF' required='yes'>
		<cfargument name='PROP_RAZAO_SOCIAL' required='yes'>
		<cfargument name='PROP_ENDERECO' required='yes'>
		<cfargument name='PROP_UF' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
		<cfargument name='IMPRESSO' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='RODAPE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_alt_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_CONHECIMENTO'  value='#arguments.NUM_CONHECIMENTO#'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_COMPLEMENTO'  value='#arguments.CONHECIMENTO_COMPLEMENTO#'  null='#iif(len(trim(arguments.CONHECIMENTO_COMPLEMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#' variable='retorno.ITEM_ID'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#' variable='retorno.NUM_ROMANEIO'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#session.COD_PESSOA#'  null='#iif(len(trim(session.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DEPARTAMENTO'  value='#session.COD_DEPARTAMENTO#'  null='#iif(len(trim(session.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SETOR'  value='#session.COD_SETOR#'  null='#iif(len(trim(session.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#session.COD_CENTRO_CUSTO#'  null='#iif(len(trim(session.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_PRODUTO'  value='#arguments.NUM_PRODUTO#'  null='#iif(len(trim(arguments.NUM_PRODUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP_ID'  value='#arguments.CFOP_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CFOP'  value='#arguments.CFOP#'  null='#iif(len(trim(arguments.CFOP)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_OPERACAO'  value='#arguments.NATUREZA_OPERACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ORIGEM_ID'  value='0' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#mid(arguments.ST_ICMS_ID,1,2)#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PAGADOR'  value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_RAZAO_SOCIAL'  value='#arguments.REM_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_ENDERECO'  value='#arguments.REM_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_MUNICIPIO'  value='#arguments.REM_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_UF'  value='#arguments.REM_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_CEP'  value='#arguments.REM_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_CNPJ_CPF'  value='#arguments.REM_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_INSCRICAO_ESTADUAL'  value='#arguments.REM_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_RAZAO_SOCIAL'  value='#arguments.DEST_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_ENDERECO'  value='#arguments.DEST_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_MUNICIPIO'  value='#arguments.DEST_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_UF'  value='#arguments.DEST_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CEP'  value='#arguments.DEST_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CNPJ_CPF'  value='#arguments.DEST_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_INSCRICAO_ESTADUAL'  value='#arguments.DEST_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONSIGNATARIO'  value='#arguments.COD_CONSIGNATARIO#'  null='#iif(len(trim(arguments.COD_CONSIGNATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_RAZAO_SOCIAL'  value='#arguments.CONS_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_ENDERECO'  value='#arguments.CONS_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_MUNICIPIO'  value='#arguments.CONS_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_UF'  value='#arguments.CONS_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_CEP'  value='#arguments.CONS_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_CNPJ_CPF'  value='#arguments.CONS_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_INSCRICAO_ESTADUAL'  value='#arguments.CONS_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_REDESPACHO'  value='#arguments.COD_REDESPACHO#'  null='#iif(len(trim(arguments.COD_REDESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_RAZAO_SOCIAL'  value='#arguments.RED_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_ENDERECO'  value='#arguments.RED_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_MUNICIPIO'  value='#arguments.RED_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_UF'  value='#arguments.RED_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_CEP'  value='#arguments.RED_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_CNPJ_CPF'  value='#arguments.RED_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_INSCRICAO_ESTADUAL'  value='#arguments.RED_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO'  value='#arguments.PESO#' variable='retorno.PESO'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VOLUME'  value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_UNITARIO'  value='#arguments.FRETE_UNITARIO#'  null='#iif(len(trim(arguments.FRETE_UNITARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_PESO'  value='#arguments.FRETE_PESO#'  null='#iif(len(trim(arguments.FRETE_PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_VALOR'  value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESPACHO'  value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BASE_CALCULO_ICMS'  value='#arguments.BASE_CALCULO_ICMS#'  null='#iif(len(trim(arguments.BASE_CALCULO_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALIQUOTA_ICMS'  value='#arguments.ALIQUOTA_ICMS#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ADEME'  value='#arguments.ADEME#'  null='#iif(len(trim(arguments.ADEME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCONTO'  value='#arguments.DESCONTO#'  null='#iif(len(trim(arguments.DESCONTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SEC_CAT'  value='0'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRIS'  value='0'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PEDAGIO'  value='#arguments.PEDAGIO#'  null='#iif(len(trim(arguments.PEDAGIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ICMS'  value='#arguments.VALOR_ICMS#'  null='#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ICMS_SUBSTIT'  value='#arguments.VALOR_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.VALOR_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_ENTREGA'  value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMPOSTOS'  value='#arguments.IMPOSTOS#'  null='#iif(len(trim(arguments.IMPOSTOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TOTAL_CONHECIMENTO'  value='#arguments.TOTAL_CONHECIMENTO#'  null='#iif(len(trim(arguments.TOTAL_CONHECIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_LOGRADOURO'  value='' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_COMPLEMENTO'  value='' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_BAIRRO'  value='' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_CEP'  value='' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_UF'  value='#arguments.COLETA_COD_UF#'  null='#iif(len(trim(arguments.COLETA_COD_UF)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_MUNICIPIO'  value='#arguments.COLETA_COD_MUNICIPIO#'  null='#iif(len(trim(arguments.COLETA_COD_MUNICIPIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_DISTRITO'  value='#arguments.COLETA_COD_DISTRITO#'  null='#iif(len(trim(arguments.COLETA_COD_DISTRITO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_DV'  value='#arguments.COLETA_COD_DV#'  null='#iif(len(trim(arguments.COLETA_COD_DV)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_LOGRADOURO'  value='' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_COMPLEMENTO'  value='' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_BAIRRO'  value='' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_CEP'  value='' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_UF'  value='#arguments.ENTREGA_COD_UF#'  null='#iif(len(trim(arguments.ENTREGA_COD_UF)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_MUNICIPIO'  value='#arguments.ENTREGA_COD_MUNICIPIO#'  null='#iif(len(trim(arguments.ENTREGA_COD_MUNICIPIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_DISTRITO'  value='#arguments.ENTREGA_COD_DISTRITO#'  null='#iif(len(trim(arguments.ENTREGA_COD_DISTRITO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_DV'  value='#arguments.ENTREGA_COD_DV#'  null='#iif(len(trim(arguments.ENTREGA_COD_DV)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_MOTORISTA'  value='#arguments.NOME_MOTORISTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROPRIETARIO'  value='#arguments.COD_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_CNPJ_CPF'  value='#arguments.PROP_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_RAZAO_SOCIAL'  value='#arguments.PROP_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_ENDERECO'  value='#arguments.PROP_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_UF'  value='#arguments.PROP_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMPRESSO'  value='#arguments.IMPRESSO#'  null='#iif(len(trim(arguments.IMPRESSO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' variable='retorno.OBSERVACAO' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RODAPE'  value='#arguments.RODAPE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTRADA_DADOS'  value='2'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CORRECAO'  null="yes">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Conhecimento alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui Conhecimento
	-- guto 19/04/2006 10:15:21 - CRIADO
	--->
	<cffunction name='del_conhecimento' displayname='Exclui Conhecimento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='MOTIVO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_del_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO'  value='#arguments.MOTIVO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Conhecimento excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Cancela Conhecimento
	-- guto 19/04/2006 10:16:03 - CRIADO
	--->
	<cffunction name='can_conhecimento' displayname='Cancela Conhecimento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='MOTIVO' required='yes'>
		<cftry>
				<cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_can_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO'  value='#arguments.MOTIVO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Conhecimento cancelado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Cancela Conhecimento
	-- guto 19/04/2006 10:16:03 - CRIADO
	--->

	<cffunction name="cancela_conhecimento" displayname="Cancela conhecimento" access="remote" returntype="struct" output="true">
		<cfargument name="conhecimento_id" displayname="Identificador do conhecimento" required="true">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="fiscal.pkg_conhecimento_dml.prc_can_conhecimento" username="#session.usuario#" password="#session.senha#">
				<cfprocparam cfsqltype="cf_sql_float" dbvarname="p_conhecimento_id" value="#arguments.conhecimento_id#">
				<cfprocparam cfsqltype="cf_sql_varchar" dbvarname="p_motivo" value="Cancelado pelo site">
			</cfstoredproc>
			<cfset retorno.erro = false>		
			<cfset retorno.mensagem = 'Conhecimento cancelado com sucesso'>		
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Registra impresso do CTRC e para aqueles inseridos no sistema sem numerao gera o numero
	-- guto 19/04/2006 10:17:43 - CRIADO
	--->
	<cffunction name='imprime_conhecimento' displayname='Registra impresso do CTRC e para aqueles inseridos no sistema sem numerao gera o numero' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
        <cfargument name='NUM_CONHECIMENTO' required='no' default=''>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_ctrc_imprime' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_CONHECIMENTO' variable='retorno.NUM_CONHECIMENTO'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Registro de impresso feito com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	
	<!--- 
	-- PROPSITO
	-- Insere nota fiscal ao conhecimento
	-- rafael 19/05/2009 10:49:20 - ALTERADO
	--->
	<cffunction name='ins_nf_conhecimento' displayname='Insere nota fiscal ao conhecimento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='NUMERO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='MODELO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='SUB_SERIE' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
        <cfargument name='NF_ELETRONICA' required='yes' default="0">
				<cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_ins_nf_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUMERO'  value='#arguments.NUMERO#'  null='#iif(len(trim(arguments.NUMERO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUMERO_OLD'  value='#arguments.NUMERO#'  null='#iif(len(trim(arguments.NUMERO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MODELO'  value='#arguments.MODELO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUB_SERIE'  value='#arguments.SUB_SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_ELETRONICA'  value='#arguments.NF_ELETRONICA#'  null='#iif(len(trim(arguments.NF_ELETRONICA)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn StructNew() />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui um nota fiscal vinculada a um conhecimento
	-- guto 19/04/2006 10:55:48 - CRIADO
	--->
	<cffunction name='del_nf_conhecimento' displayname='Exclui um nota fiscal vinculada a um conhecimento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='NUMERO' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_del_nf_conhecimemento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUMERO'  value='#arguments.NUMERO#'  null='#iif(len(trim(arguments.NUMERO)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere fatura para os CTRCs
	-- guto 26/04/2006 09:37:01 - CRIADO
	--->
	<cffunction name='ins_fatura_ctrc' displayname='Insere fatura para os CTRCs' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PAGADOR' required='NO'>
		<cfargument name='COD_PESSOA_FILIAL' required='NO'>
		<cfargument name='DOCTO_ID' required='yes'>
		<cfargument name='NUM_FATURA' required='yes'>
		<cfargument name='CC_FAVORECIDO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='DATA_VENCIMENTO' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
		<cfargument name='CONHECIMENTOS' required='yes'>
		<cfargument name="ORGANOGRAMA" required="no" default="">
		<cfargument name="BLOQUETO_AUTOMATICO" required="no" default="0">
		<cfif Len(Trim(arguments.ORGANOGRAMA))>
			<cfset arguments.cod_pessoa_filial = ListGetAt(arguments.organograma,1,'_')>
			<cfset arguments.cod_departamento = ListGetAt(arguments.organograma,2,'_')>
			<cfset arguments.cod_setor = ListGetAt(arguments.organograma,3,'_')>
			<cfset arguments.cod_centro_custo = ListGetAt(arguments.organograma,4,'_')>
		</cfif>
		<cftry>
		
		     <cftransaction action='begin'>
				<cfloop index="i" list="#arguments.conhecimentos#" delimiters=",">
					<cfquery name="qrDoctos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
						select oper.pkg_fluxo_docto.fnc_verifica_doctos_fatura(c.num_romaneio, c.item_id, c.conhecimento_id) 
						  from oper.v$conhecimento c
						 where c.conhecimento_id = #i#
						 and c.num_romaneio is not null
						 and c.item_id is not null
					</cfquery>					
				</cfloop>
				
				<cfstoredproc procedure='fiscal.pkg_conhecimento.prc_ins_fatura_ctrc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DOCTO_ID'  value='#arguments.DOCTO_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_DOCTO'  value='#arguments.NUM_FATURA#'  null='#iif(len(trim(arguments.NUM_FATURA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CC_FAVORECIDO'  value='#arguments.CC_FAVORECIDO#'  null='#iif(len(trim(arguments.CC_FAVORECIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCIMENTO'  value='#arguments.DATA_VENCIMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_DOCTO'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTA_RECEBER_ID' variable='retorno.CONTA_RECEBER_ID'  null='yes'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_RECIBO' variable='retorno.NUM_RECIBO'  null='yes'>
				</cfstoredproc>
			
				<cfloop index="i" list="#arguments.conhecimentos#" delimiters=",">
					<cfquery name="qr_data" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
						select data_emissao,
							   to_date('#arguments.DATA_EMISSAO#') data_emissao_fatura,
							   case when trunc(to_date('#arguments.DATA_EMISSAO#','dd/mm/yyyy')) < trunc(data_emissao) then 0 else 1 end data_ok
						  from fiscal.v$conhecimento
						 where conhecimento_id = #i#
					</cfquery>
					
					<cfif qr_data.data_ok neq 1>
						<cfthrow errorcode="20000" type="Application" message="As datas de emisso dos conhecimentos devem ser inferiores a data de emisso da fatura!">
					</cfif>
					
					<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
						insert into oper.v$conhecimento_receber
						  (conhecimento_id, contas_receber_id)
						values
						  (#i#, #retorno.CONTA_RECEBER_ID#)
					</cfquery>					
					
					<cfquery name="qrDoctos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
						select fd.num_romaneio, fd.item_id, fd.docto_id
						  from oper.v$conhecimento c
						 inner join oper.v$fluxo_docto fd
								 on fd.docto_id = c.conhecimento_id
								and fd.num_romaneio = c.num_romaneio
								and fd.item_id = c.item_id
						where c.conhecimento_id = #i#
					</cfquery>					
					
					<cfif qrDoctos.recordcount>
						<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_fluxo_docto.PRC_FECHA_FLUXO_FATURA" username="#session.usuario#" password="#session.senha#">
							<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_romaneio" value="#qrDoctos.num_romaneio#">
							<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_item_id" value="#qrDoctos.item_id#">
							<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_docto_id" value="#qrDoctos.docto_id#">
						</cfstoredproc>
					</cfif>
				</cfloop>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Fatura inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
			
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Fecha a relacao complementos
	-- CRISTOFER 05/06/2006 
	--->
	<cffunction name="fecha_relacao" access="remote" returntype="struct" output="true">
		<cfargument name="relacao_id" required="true">
		<cftry>
			<cftransaction action="begin">
			<cfquery datasource="#session.dsn#" name="qr_carta_frete" username="#session.usuario#" password="#session.senha#">
				update oper.v$conhecimento_complemento
				   set situacao = 1   
				 where relacao_id = #arguments.relacao_id#
			</cfquery>		
			<cfset retorno.erro = false>		
			<cfset retorno.mensagem = 'Relao fechada com sucesso!'>		
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Altera os Valores do Conhecimento
	-- WAGNER 08/06/2006 
	--->
	
	<cffunction name="upd_conhecimento_valores" displayname="Altera dados do conhecimento" access="remote" returntype="struct" output="true">
		<cfargument name="conhecimento_id" required="true">
		<cfargument name="total_servicos" required="true">
		<cfargument name="base_calculo_icms" required="true">
		<cfargument name="aliquota_icms" required="true">
		<cfargument name="valor_icms" required="true">
		<cftry>
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				update oper.v$conhecimento
				   set base_calculo_icms = #arguments.base_calculo_icms#,  
					   aliquota_icms = #arguments.aliquota_icms#, 
					   valor_icms = #arguments.valor_icms#, 
					   total_conhecimento = #arguments.total_servicos#
				 where conhecimento_id = #arguments.conhecimento_id#
 			</cfquery>			
			<cfif isDefined("arguments.num_romaneio") and Len(Trim(arguments.num_romaneio))>
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_romaneio.prc_soma_itens_romaneio" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" dbvarname="p_num_romaneio" cfsqltype="cf_sql_integer" value="#arguments.num_romaneio#">
					<cfprocparam type="in" dbvarname="p_item_id" cfsqltype="cf_sql_integer" value="#arguments.item_id#">
				</cfstoredproc>
			</cfif>
			<cfset retorno.erro = false>		
			<cfset retorno.mensagem = 'Conhecimento alterado com sucesso.'>		
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Desvincula o Conhecimento da Carta Frete
	-- WAGNER 12/06/2006 
	--->
	
	<cffunction name="set_desvincula_ctrc_cf" displayname="Desvincula o CTRC das cartas frete" access="remote" returntype="struct" output="true">
		<cfargument name="conhecimento_id" required="true">
		<cftry>
		 <cfquery datasource="#session.dsn#" name="qr_carta_frete" username="#session.usuario#" password="#session.senha#">
				update oper.v$carta_frete
				   set conhecimento_id = null					   
				 where conhecimento_id = #arguments.conhecimento_id#
			</cfquery>		
			<cfset retorno.erro = false>		
			<cfset retorno.mensagem = 'Conhecimento desvinculado com sucesso.'>		
		<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Gera Conhecimento de Acerto
	-- WAGNER 12/06/2006 
	--->
	
	<cffunction name="set_gera_conhecimento_acerto" displayname="Gera conhecimento de complemento" access="remote" returntype="struct" output="true">
		<cfargument name="num_conhecimento" required="true">
		<cfargument name="cod_pessoa_filial" required="true">
		<cfargument name="cod_departamento" required="true">
		<cfargument name="cod_setor" required="true">
		<cfargument name="cod_centro_custo" required="true">
		<cfargument name="serie" required="true">
		<cfargument name="data_emissao" required="true">
		<cfargument name="cod_remetente" required="true">
		<cfargument name="lancto_id" required="true">
		<cfargument name="peso" required="true">
		<cfargument name="unitario" required="true">
		<cfargument name="valor_liquido" required="true">
		<cfargument name="total_pedagio" required="true">
		<cfargument name="total_descontos" required="true">
		<cfargument name="total_servicos" required="true">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_carta_frete.prc_ins_ctrc_acerto_financeiro" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_conhecimento" value="#arguments.num_conhecimento#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" dbvarname="p_cod_pessoa_filial" value="#arguments.cod_pessoa_filial#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_departamento" value="#arguments.cod_departamento#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_setor" value="#arguments.cod_setor#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_centro_custo" value="#arguments.cod_centro_custo#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_serie" value="#arguments.serie#">
				<cfprocparam type="inout" cfsqltype="cf_sql_varchar" dbvarname="p_data_emissao" value="#arguments.data_emissao#" variable="retorno.data_emissao">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_remetente" value="#arguments.cod_remetente#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_lancto_id" value="#arguments.lancto_id#">
				<cfprocparam type="inout" cfsqltype="cf_sql_numeric" scale="5" dbvarname="p_peso" value="#arguments.peso#" variable="retorno.peso"> 
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" dbvarname="p_valor_unitario" value="#arguments.unitario#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" dbvarname="p_valor_frete_total_liquido" value="#arguments.valor_liquido#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" dbvarname="p_total_pedagio" value="#arguments.total_pedagio#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" dbvarname="p_total_descontos" value="#arguments.total_descontos#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" dbvarname="p_total_servicos" value="#arguments.total_servicos#">
				<cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="p_conhecimento_id" variable="retorno.conhecimento_id">
			</cfstoredproc> 
			<cfset retorno.erro = false>		
			<cfset retorno.mensagem = 'Conhecimento gerado com sucesso.'>		
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Gera Conhecimento de Acerto
	-- WAGNER 12/06/2006 
	--->
	
	<cffunction name="set_gera_conhecimento_complemento" displayname="Gera conhecimento de complemento" access="remote" returntype="struct" output="true">
		<cfargument name="relacao_id" required="true">
		<cfargument name="num_conhecimento" required="true">
		<cfargument name="total_conhecimento" required="true">
		<cfargument name="serie" required="true">
		<cfargument name="data_emissao" required="true">
		<cfargument name="observacao" required="true">
		
		<cfargument name="cod_destinatario" required="true">
		<cfargument name="cod_uf" required="true">
		<cfargument name="cod_municipio" required="true">
		<cfargument name="cod_distrito" required="true">
		<cfargument name="cod_dv" required="true">
		
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_conhecimento_dml.prc_gera_ctrc_complemento" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_relacao_id" value="#arguments.relacao_id#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_conhecimento" value="#arguments.num_conhecimento#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" dbvarname="p_total_conhecimento" value="#arguments.total_conhecimento#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_serie" value="#Trim(arguments.serie)#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_data_emissao" value="#arguments.data_emissao#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_observacao" value="#arguments.observacao#">
				
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_destinatario" value="#val(arguments.cod_destinatario)#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_uf" value="#Val(arguments.cod_uf)#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_municipio" value="#Val(arguments.cod_municipio)#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_distrito" value="#Val(arguments.cod_distrito)#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_dv" value="#Val(arguments.cod_dv)#">
				
				<cfprocparam type="out" cfsqltype="cf_sql_float" dbvarname="p_conhecimento_complemento_id" variable="retorno.conhecimento_id">
			</cfstoredproc>
			<cfset retorno.erro = false>		
			<cfset retorno.mensagem = 'Conhecimento gerado com sucesso.'>
		<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
	    
    <!--- 
	-- PROPSITO
	-- Gera Relacao de Complemento
	-- ANDERSONC 10/06/2009 14:38:58 - CRIADO
	--->
	<cffunction name='set_gera_relacao' displayname='Gera Relacao de Complemento' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='PESO_CORRETO' required='yes'>
		<cfargument name='VALOR_UNITARIO' required='yes'>
		<cfargument name='FRETE_CORRETO' required='yes'>
		<cfargument name='DIFERENCA' required='no' default=''>
        <cfargument name='M3_CORRETO' required='no' default=''>
		<cfargument name='PESO_COBRADO_CORRETO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_conhecimento_dml.prc_ins_complemento_relacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_CORRETO'  value='#arguments.PESO_CORRETO#'  null='#iif(len(trim(arguments.PESO_CORRETO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_UNITARIO'  value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_CORRETO'  value='#arguments.FRETE_CORRETO#'  null='#iif(len(trim(arguments.FRETE_CORRETO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RELACAO_ID' variable='retorno.RELACAO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIFERENCA'  value='#arguments.DIFERENCA#'  null='#iif(len(trim(arguments.DIFERENCA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_M3_CORRETO'  value='#arguments.M3_CORRETO#'  null='#iif(len(trim(arguments.M3_CORRETO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_COBRADO_CORRETO'  value='#arguments.PESO_COBRADO_CORRETO#'  null='#iif(len(trim(arguments.PESO_COBRADO_CORRETO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Relao Gerada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Gera Relacao de Complemento
	-- WAGNER 21/08/2006 
	--->
	<cffunction name="confirma_impressao_gera_numero" displayname="Confirma Impresso e gera numero do CTRC" access="remote" returntype="struct" output="true">
		<cfargument name="conhecimento_id" displayname="Identificador do conhecimento" required="true">
		<cfargument name="data_emissao" displayname="Identificador do conhecimento" required="true">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_conhecimento_dml.prc_ctrc_imprime" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_conhecimento_id" value="#arguments.conhecimento_id#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_data_emissao" value="#arguments.DATA_EMISSAO#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_conhecimento" value="1">
			</cfstoredproc>
			<cfset retorno.erro = false>		
			<cfset retorno.mensagem = 'Conhecimento impresso com sucesso'>		
	    <cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
		</cfcatch>
	    </cftry>
		<cfreturn retorno>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Marca um ctrc como impresso
	-- WAGNER 21/08/2006 
	--->
	<cffunction name="ctrc_impresso" displayname="Confirma Impresso e gera numero do CTRC" access="remote" returntype="struct" output="true">
		<cfargument name="conhecimento_id" required="true">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="fiscal.pkg_conhecimento_dml.prc_ctrc_impresso" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_conhecimento_id" value="#arguments.conhecimento_id#">
			</cfstoredproc>
			<cfset retorno.erro = false>		
			<cfset retorno.mensagem = 'Conhecimento impresso com sucesso!'>		
	    <cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
		</cfcatch>
	    </cftry>
		<cfreturn retorno>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Gera Relacao de Complemento
	-- WAGNER 21/08/2006 
	--->
	
	<cffunction name="confirma_impressao" displayname="Confirma Impresso" access="remote" returntype="struct" output="true">
		<cfargument name="conhecimento_id" displayname="Identificador do conhecimento" required="true">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_conhecimento_dml.prc_alt_sit_conhecimento" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_conhecimento_id" value="#arguments.conhecimento_id#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_situacao_id" value="0">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_impresso" value="1">
			</cfstoredproc>
			<cfset retorno.erro = false>		
			<cfset retorno.mensagem = 'Conhecimento impresso com sucesso'>		
			 <cfcatch>
					<cftransaction action='rollback'/>
					<cfset retorno.erro = true>
					<cfset retorno.mensagem = cfcatch>
					<cfset request.erro = cfcatch>
			</cfcatch>
	    </cftry>
		<cfreturn retorno>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere nota fiscal.
	-- wagner 17/10/2006 10:36:12 - CRIADO
	--->
	
	<cffunction name='ins_nf_es' displayname='Insere nota fiscal' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_GESTAO' required='yes'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='COD_MODELO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='SUBSERIE' required='yes'>
		<cfargument name='E_S' required='yes'>
		<cfargument name='SERVICO' required='yes'>
		<cfargument name='INSCRICAO_ESTADUAL_SUBSTITUT' required='yes'>
		<cfargument name='NATUREZA_ID' required='yes'>
		<cfargument name='NATUREZA_DESCRICAO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='DATA_ES' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='DEST_RAZAO_SOCIAL' required='yes'>
		<cfargument name='DEST_ENDERECO' required='yes'>
		<cfargument name='DEST_BAIRRO' required='yes'>
		<cfargument name='DEST_MUNICIPIO' required='yes'>
		<cfargument name='DEST_UF' required='yes'>
		<cfargument name='DEST_CEP' required='yes'>
		<cfargument name='DEST_TELEFONE' required='yes'>
		<cfargument name='DEST_CNPJ_CPF' required='yes'>
		<cfargument name='DEST_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='NF_IMPOSTO_ID' required='yes'>
		<cfargument name='SERV_TOTAL_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_NAO_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_NOTA' required='yes'>
		<cfargument name='SERV_ISS_ALIQUOTA' required='yes'>
		<cfargument name='SERV_ISS_DEDUCAO' required='yes'>
		<cfargument name='SERV_ISS_VALOR' required='yes'>
		<cfargument name='CALC_BASE_ICMS' required='yes'>
		<cfargument name='CALC_VALOR_ICMS' required='yes'>
		<cfargument name='CALC_BASE_ICMS_SUBST' required='yes'>
		<cfargument name='CALC_VALOR_ICMS_SUBST' required='yes'>
		<cfargument name='CALC_VALOR_TOTAL_PRODUTOS' required='yes'>
		<cfargument name='CALC_VALOR_FRETE' required='yes'>
		<cfargument name='CALC_VALOR_SEGURO' required='yes'>
		<cfargument name='CALC_OUTRAS_DESPESAS' required='yes'>
		<cfargument name='CALC_VALOR_TOTAL_IPI' required='yes'>
		<cfargument name='CALC_VALOR_TOTAL_NOTA' required='yes'>
		<cfargument name='COD_TRANSPORTADOR' required='yes'>
		<cfargument name='TRP_RAZAO_SOCIAL' required='yes'>
		<cfargument name='TRP_ENDERECO' required='yes'>
		<cfargument name='TRP_MUNICIPIO' required='yes'>
		<cfargument name='TRP_UF' required='yes'>
		<cfargument name='TRP_CNPJ_CPF' required='yes'>
		<cfargument name='TRP_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='TRP_PLACA' required='yes'>
		<cfargument name='TRP_PLACA_UF' required='yes'>
		<cfargument name='TRP_FRETE_POR' required='yes'>
		<cfargument name='TRP_QUANTIDADE' required='yes'>
		<cfargument name='TRP_ESPECIE' required='yes'>
		<cfargument name='TRP_MARCA' required='yes'>
		<cfargument name='TRP_NUMERO' required='yes'>
		<cfargument name='TRP_PESO_BRUTO' required='yes'>
		<cfargument name='TRP_PESO_LIQUIDO' required='yes'>
		<cfargument name='INFO_COMPLEMENTARES' required='yes'>
		<cfargument name='RESERVADO_FISCO' required='yes'>
		<cfargument name='OBSERVACAO_FISCAL' required='yes'>
		<cfargument name='OBSERVACAO_USUARIO' required='yes'>
		<cfargument name='EMITIDA' required='yes'>
		<cfargument name='CANCELADA' required='yes'>
		<cfargument name='CONFERIDA' required='yes'>
		<cfargument name='CONVERSAO_TAXA' required='yes'>
		<cfargument name='CONVERSAO_MOEDA' required='yes'>
		<cfargument name='INCLUIR_SISS' required='yes'>
		<cfargument name='TIPO_RECOLHIMENTO_ISS' required='yes'>
		<cfargument name='COD_SERVICO_DES' required='yes'>
		<cfargument name='NATUREZA_SISS_ID' required='yes'>
		<cfargument name='AVISTA_APRAZO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_nf_es.prc_ins_nf_es' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER' dbvarname='PARAMETER' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_GESTAO'  value='#arguments.COD_GESTAO#'  null='#iif(len(trim(arguments.COD_GESTAO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#' variable='retorno.NUM_NOTA_ID'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_MODELO'  value='#arguments.COD_MODELO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUBSERIE'  value='#arguments.SUBSERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_E_S'  value='#arguments.E_S#'  null='#iif(len(trim(arguments.E_S)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERVICO'  value='#arguments.SERVICO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INSCRICAO_ESTADUAL_SUBSTITUT'  value='#arguments.INSCRICAO_ESTADUAL_SUBSTITUT#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NATUREZA_ID'  value='#arguments.NATUREZA_ID#'  null='#iif(len(trim(arguments.NATUREZA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_DESCRICAO'  value='#arguments.NATUREZA_DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ES'  value='#arguments.DATA_ES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_RAZAO_SOCIAL'  value='#arguments.DEST_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_ENDERECO'  value='#arguments.DEST_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_BAIRRO'  value='#arguments.DEST_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_MUNICIPIO'  value='#arguments.DEST_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_UF'  value='#arguments.DEST_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CEP'  value='#arguments.DEST_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_TELEFONE'  value='#arguments.DEST_TELEFONE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CNPJ_CPF'  value='#arguments.DEST_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_INSCRICAO_ESTADUAL'  value='#arguments.DEST_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_IMPOSTO_ID'  value='#arguments.NF_IMPOSTO_ID#'  null='#iif(len(trim(arguments.NF_IMPOSTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_TOTAL_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_TRIBUTAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_TOTAL_NAO_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_NAO_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_NAO_TRIBUTAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_TOTAL_NOTA'  value='#arguments.SERV_TOTAL_NOTA#'  null='#iif(len(trim(arguments.SERV_TOTAL_NOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_ISS_ALIQUOTA'  value='#arguments.SERV_ISS_ALIQUOTA#'  null='#iif(len(trim(arguments.SERV_ISS_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_ISS_DEDUCAO'  value='#arguments.SERV_ISS_DEDUCAO#'  null='#iif(len(trim(arguments.SERV_ISS_DEDUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_ISS_VALOR'  value='#arguments.SERV_ISS_VALOR#'  null='#iif(len(trim(arguments.SERV_ISS_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_BASE_ICMS'  value='#arguments.CALC_BASE_ICMS#'  null='#iif(len(trim(arguments.CALC_BASE_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_ICMS'  value='#arguments.CALC_VALOR_ICMS#'  null='#iif(len(trim(arguments.CALC_VALOR_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_BASE_ICMS_SUBST'  value='#arguments.CALC_BASE_ICMS_SUBST#'  null='#iif(len(trim(arguments.CALC_BASE_ICMS_SUBST)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_ICMS_SUBST'  value='#arguments.CALC_VALOR_ICMS_SUBST#'  null='#iif(len(trim(arguments.CALC_VALOR_ICMS_SUBST)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_TOTAL_PRODUTOS'  value='#arguments.CALC_VALOR_TOTAL_PRODUTOS#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_PRODUTOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_FRETE'  value='#arguments.CALC_VALOR_FRETE#'  null='#iif(len(trim(arguments.CALC_VALOR_FRETE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_SEGURO'  value='#arguments.CALC_VALOR_SEGURO#'  null='#iif(len(trim(arguments.CALC_VALOR_SEGURO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_OUTRAS_DESPESAS'  value='#arguments.CALC_OUTRAS_DESPESAS#'  null='#iif(len(trim(arguments.CALC_OUTRAS_DESPESAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_TOTAL_IPI'  value='#arguments.CALC_VALOR_TOTAL_IPI#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_IPI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_TOTAL_NOTA'  value='#arguments.CALC_VALOR_TOTAL_NOTA#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_NOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_TRANSPORTADOR'  value='#arguments.COD_TRANSPORTADOR#'  null='#iif(len(trim(arguments.COD_TRANSPORTADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_RAZAO_SOCIAL'  value='#arguments.TRP_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_ENDERECO'  value='#arguments.TRP_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_MUNICIPIO'  value='#arguments.TRP_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_UF'  value='#arguments.TRP_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_CNPJ_CPF'  value='#arguments.TRP_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_INSCRICAO_ESTADUAL'  value='#arguments.TRP_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_PLACA'  value='#arguments.TRP_PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_PLACA_UF'  value='#arguments.TRP_PLACA_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRP_FRETE_POR'  value='#arguments.TRP_FRETE_POR#'  null='#iif(len(trim(arguments.TRP_FRETE_POR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRP_QUANTIDADE'  value='#arguments.TRP_QUANTIDADE#'  null='#iif(len(trim(arguments.TRP_QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_ESPECIE'  value='#arguments.TRP_ESPECIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_MARCA'  value='#arguments.TRP_MARCA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_NUMERO'  value='#arguments.TRP_NUMERO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRP_PESO_BRUTO'  value='#arguments.TRP_PESO_BRUTO#'  null='#iif(len(trim(arguments.TRP_PESO_BRUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRP_PESO_LIQUIDO'  value='#arguments.TRP_PESO_LIQUIDO#'  null='#iif(len(trim(arguments.TRP_PESO_LIQUIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INFO_COMPLEMENTARES'  value='#arguments.INFO_COMPLEMENTARES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESERVADO_FISCO'  value='#arguments.RESERVADO_FISCO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_FISCAL'  value='#arguments.OBSERVACAO_FISCAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_USUARIO'  value='#arguments.OBSERVACAO_USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMITIDA'  value='#arguments.EMITIDA#'  null='#iif(len(trim(arguments.EMITIDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CANCELADA'  value='#arguments.CANCELADA#'  null='#iif(len(trim(arguments.CANCELADA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONFERIDA'  value='#arguments.CONFERIDA#'  null='#iif(len(trim(arguments.CONFERIDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONVERSAO_TAXA'  value='#arguments.CONVERSAO_TAXA#'  null='#iif(len(trim(arguments.CONVERSAO_TAXA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONVERSAO_MOEDA'  value='#arguments.CONVERSAO_MOEDA#'  null='#iif(len(trim(arguments.CONVERSAO_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INCLUIR_SISS'  value='#arguments.INCLUIR_SISS#'  null='#iif(len(trim(arguments.INCLUIR_SISS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_RECOLHIMENTO_ISS'  value='#arguments.TIPO_RECOLHIMENTO_ISS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_SERVICO_DES'  value='#arguments.COD_SERVICO_DES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_SISS_ID'  value='#arguments.NATUREZA_SISS_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AVISTA_APRAZO'  value='#arguments.AVISTA_APRAZO#'  null='#iif(len(trim(arguments.AVISTA_APRAZO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Nota fiscal inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere nota fiscal.
	-- wagner 17/10/2006 10:39:13 - CRIADO
	--->
	
	<cffunction name='ins_nf_es_it' displayname='Insere nota fiscal.' access='remote' returntype='Struct' output='true'>
		<cfargument name='ES' required='yes'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='CFOP' required='yes'>
		<cfargument name='CFOP_ID' required='yes'>
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='DESCRICAO_COMPLEMENTO' required='yes'>
		<cfargument name='COD_NCM' required='yes'>
		<cfargument name='ST_ORIGEM_ID' required='yes'>
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='QTDE_PESO' required='yes'>
		<cfargument name='QTDE_VOLUME' required='yes'>
		<cfargument name='QTDE_METRO' required='yes'>
		<cfargument name='VALOR_EM' required='yes'>
		<cfargument name='VALOR_EM_UNIDADE' required='yes'>
		<cfargument name='VALOR_UNITARIO' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
		<cfargument name='ICMS_REDUCAO_BASE' required='yes'>
		<cfargument name='ICMS_BASE_CALCULO' required='yes'>
		<cfargument name='ICMS_ALIQUOTA' required='yes'>
		<cfargument name='ICMS_VALOR' required='yes'>
		<cfargument name='ICMS_BASE_CALC_SUBST' required='yes'>
		<cfargument name='ICMS_VALOR_SUBST' required='yes'>
		<cfargument name='IPI_REDUCAO_BASE' required='yes'>
		<cfargument name='IPI_BASE_CALCULO' required='yes'>
		<cfargument name='IPI_ALIQUOTA' required='yes'>
		<cfargument name='IPI_VALOR' required='yes'>
		<cfargument name='SERV_TOTAL_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_NAO_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_PRODUTO' required='yes'>
		<cfargument name='SERV_ISS_ALIQUOTA' required='yes'>
		<cfargument name='SERV_ISS_DEDUCAO' required='yes'>
		<cfargument name='SERV_ISS_VALOR' required='yes'>
		<cfargument name='DESCONTO_PERCENTUAL' required='yes'>
		<cfargument name='DESCONTO_VALOR' required='yes'>
		<cfargument name='INCLUIR_ESTOQUE' required='yes'>
		<cfargument name='INCLUIR_LIVRO_FISCAL' required='yes'>
		<cfargument name='UF_UNIDADE_NEGOCIO' required='yes'>
		<cfargument name='UF_DESTINATARIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_nf_es.prc_ins_nf_es_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER' dbvarname='PARAMETER' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ES'  value='#arguments.ES#'  null='#iif(len(trim(arguments.ES)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_IT_ID' variable='retorno.NUM_NOTA_IT_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CFOP'  value='#arguments.CFOP#'  null='#iif(len(trim(arguments.CFOP)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP_ID'  value='#arguments.CFOP_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_COMPLEMENTO'  value='#arguments.DESCRICAO_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_NCM'  value='#arguments.COD_NCM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ORIGEM_ID'  value='#arguments.ST_ORIGEM_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#arguments.ST_ICMS_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_PESO'  value='#arguments.QTDE_PESO#'  null='#iif(len(trim(arguments.QTDE_PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_VOLUME'  value='#arguments.QTDE_VOLUME#'  null='#iif(len(trim(arguments.QTDE_VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_METRO'  value='#arguments.QTDE_METRO#'  null='#iif(len(trim(arguments.QTDE_METRO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_EM'  value='#arguments.VALOR_EM#'  null='#iif(len(trim(arguments.VALOR_EM)), de('no'), de('yes'))#'>
                    <cfif session.site eq 'rodomar/'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_EM_UNIDADE'  value='#arguments.VALOR_EM_UNIDADE#'  null='#iif(len(trim(arguments.VALOR_EM_UNIDADE)), de('no'), de('yes'))#'>
					<cfelse>
                    	<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR_EM_UNIDADE'  value='#arguments.VALOR_EM_UNIDADE#' >
                    </cfif>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_UNITARIO'  value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ICMS_REDUCAO_BASE'  value='#arguments.ICMS_REDUCAO_BASE#'  null='#iif(len(trim(arguments.ICMS_REDUCAO_BASE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ICMS_BASE_CALCULO'  value='#arguments.ICMS_BASE_CALCULO#'  null='#iif(len(trim(arguments.ICMS_BASE_CALCULO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ICMS_ALIQUOTA'  value='#arguments.ICMS_ALIQUOTA#'  null='#iif(len(trim(arguments.ICMS_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ICMS_VALOR'  value='#arguments.ICMS_VALOR#'  null='#iif(len(trim(arguments.ICMS_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ICMS_BASE_CALC_SUBST'  value='#arguments.ICMS_BASE_CALC_SUBST#'  null='#iif(len(trim(arguments.ICMS_BASE_CALC_SUBST)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ICMS_VALOR_SUBST'  value='#arguments.ICMS_VALOR_SUBST#'  null='#iif(len(trim(arguments.ICMS_VALOR_SUBST)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IPI_REDUCAO_BASE'  value='#arguments.IPI_REDUCAO_BASE#'  null='#iif(len(trim(arguments.IPI_REDUCAO_BASE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IPI_BASE_CALCULO'  value='#arguments.IPI_BASE_CALCULO#'  null='#iif(len(trim(arguments.IPI_BASE_CALCULO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IPI_ALIQUOTA'  value='#arguments.IPI_ALIQUOTA#'  null='#iif(len(trim(arguments.IPI_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IPI_VALOR'  value='#arguments.IPI_VALOR#'  null='#iif(len(trim(arguments.IPI_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_TOTAL_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_TRIBUTAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_TOTAL_NAO_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_NAO_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_NAO_TRIBUTAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_TOTAL_PRODUTO'  value='#arguments.SERV_TOTAL_PRODUTO#'  null='#iif(len(trim(arguments.SERV_TOTAL_PRODUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_ISS_ALIQUOTA'  value='#arguments.SERV_ISS_ALIQUOTA#'  null='#iif(len(trim(arguments.SERV_ISS_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_ISS_DEDUCAO'  value='#arguments.SERV_ISS_DEDUCAO#'  null='#iif(len(trim(arguments.SERV_ISS_DEDUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_ISS_VALOR'  value='#arguments.SERV_ISS_VALOR#'  null='#iif(len(trim(arguments.SERV_ISS_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCONTO_PERCENTUAL'  value='#arguments.DESCONTO_PERCENTUAL#'  null='#iif(len(trim(arguments.DESCONTO_PERCENTUAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCONTO_VALOR'  value='#arguments.DESCONTO_VALOR#'  null='#iif(len(trim(arguments.DESCONTO_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INCLUIR_ESTOQUE'  value='#arguments.INCLUIR_ESTOQUE#'  null='#iif(len(trim(arguments.INCLUIR_ESTOQUE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INCLUIR_LIVRO_FISCAL'  value='#arguments.INCLUIR_LIVRO_FISCAL#'  null='#iif(len(trim(arguments.INCLUIR_LIVRO_FISCAL)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_UNIDADE_NEGOCIO'  value='#arguments.UF_UNIDADE_NEGOCIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_DESTINATARIO'  value='#arguments.UF_DESTINATARIO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Nota fiscal inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere imposto da nota fiscal
	-- wagner 17/10/2006 10:44:17 - CRIADO
	--->
	<cffunction name='ins_nf_es_it_imposto' displayname='Insere imposto da nota fiscal' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='IMPOSTO_ID' required='yes'>
		<cfargument name='IMPOSTO_REDUCAO_BASE' required='yes'>
		<cfargument name='IMPOSTO_BASE_CALCULO' required='yes'>
		<cfargument name='IMPOSTO_ALIQUOTA' required='yes'>
		<cfargument name='IMPOSTO_TOTAL' required='yes'>
		<cfargument name='IMPOSTO_RETIDO_FONTE' required='yes'>
		<cfargument name='DATA_VENCIMENTO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_nf_es.prc_ins_nf_es_imposto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER' dbvarname='PARAMETER' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMPOSTO_ID'  value='#arguments.IMPOSTO_ID#'  null='#iif(len(trim(arguments.IMPOSTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_IMPOSTO_REDUCAO_BASE'  value='#arguments.IMPOSTO_REDUCAO_BASE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMPOSTO_BASE_CALCULO'  value='#arguments.IMPOSTO_BASE_CALCULO#'  null='#iif(len(trim(arguments.IMPOSTO_BASE_CALCULO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMPOSTO_ALIQUOTA'  value='#arguments.IMPOSTO_ALIQUOTA#'  null='#iif(len(trim(arguments.IMPOSTO_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMPOSTO_TOTAL'  value='#arguments.IMPOSTO_TOTAL#'  null='#iif(len(trim(arguments.IMPOSTO_TOTAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMPOSTO_RETIDO_FONTE'  value='#arguments.IMPOSTO_RETIDO_FONTE#'  null='#iif(len(trim(arguments.IMPOSTO_RETIDO_FONTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCIMENTO'  value='#arguments.DATA_VENCIMENTO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Nota fiscal inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere contas a receber da nota fiscal
	-- wagner 17/10/2006 10:47:31 - CRIADO
	--->
	<cffunction name='ins_nf_es_contas_receber' displayname='Insere contas a receber da nota fiscal' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='CONTAS_RECEBER_ID' required='yes'>
		<cfargument name='DOCTO_ID' required='yes'>
		<cfargument name='NUM_DOCTO' required='yes'>
		<cfargument name='COD_HISTORICO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='DATA_VENCTO' required='yes'>
		<cfargument name='VALOR_DOCTO' required='yes'>
		<cfargument name='BLOQUETO_AUTOMATICO' required='yes'>
		<cfargument name='CC_FAVORECIDO' required='yes'>
		<cfargument name='FEBRABAN_LAYOUT_ARQUIVO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_nf_es.prc_nfes_insere_contas_receber' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER' dbvarname='PARAMETER' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTAS_RECEBER_ID'  value='#arguments.CONTAS_RECEBER_ID#' variable='retorno.CONTAS_RECEBER_ID'  null='#iif(len(trim(arguments.CONTAS_RECEBER_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DOCTO_ID'  value='#arguments.DOCTO_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_DOCTO'  value='#arguments.NUM_DOCTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_HISTORICO'  value='#arguments.COD_HISTORICO#'  null='#iif(len(trim(arguments.COD_HISTORICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCTO'  value='#arguments.DATA_VENCTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_DOCTO'  value='#arguments.VALOR_DOCTO#'  null='#iif(len(trim(arguments.VALOR_DOCTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BLOQUETO_AUTOMATICO'  value='#arguments.BLOQUETO_AUTOMATICO#'  null='#iif(len(trim(arguments.BLOQUETO_AUTOMATICO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CC_FAVORECIDO'  value='#arguments.CC_FAVORECIDO#'  null='#iif(len(trim(arguments.CC_FAVORECIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FEBRABAN_LAYOUT_ARQUIVO'  value='#arguments.FEBRABAN_LAYOUT_ARQUIVO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Nota fiscal inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere nota fiscal de terceiro
	-- guto 20/12/2006 11:23:50 - CRIADO
	--->
	<cffunction name='ins_nf_terceiro' displayname='Insere nota fiscal de terceiro' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='NUM_NOTA_FISCAL' required='yes'>
		<cfargument name='COD_MODELO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='SUBSERIE' required='yes'>
		<cfargument name='NATUREZA_ID' required='yes'>
		<cfargument name='NATUREZA_DESCRICAO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='DATA_ENTRADA' required='yes'>
		<cfargument name='COD_EMITENTE' required='yes'>
		<cfargument name='EMIT_RAZAO_SOCIAL' required='yes'>
		<cfargument name='EMIT_ENDERECO' required='yes'>
		<cfargument name='EMIT_BAIRRO' required='yes'>
		<cfargument name='EMIT_MUNICIPIO' required='yes'>
		<cfargument name='EMIT_UF' required='yes'>
		<cfargument name='EMIT_CEP' required='yes'>
		<cfargument name='EMIT_TELEFONE' required='yes'>
		<cfargument name='EMIT_CNPJ_CPF' required='yes'>
		<cfargument name='EMIT_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='COD_CLIENTE' required='yes'>
		<cfargument name='NF_IMPOSTO_ID' required='no' default="">
		<cfargument name='CALC_BASE_ICMS' required='yes'>
		<cfargument name='CALC_VALOR_ICMS' required='yes'>
		<cfargument name='CALC_BASE_ICMS_SUBST' required='yes'>
		<cfargument name='CALC_VALOR_ICMS_SUBST' required='yes'>
		<cfargument name='CALC_VALOR_TOTAL_PRODUTOS' required='yes'>
		<cfargument name='CALC_VALOR_FRETE' required='yes'>
		<cfargument name='CALC_VALOR_SEGURO' required='yes'>
		<cfargument name='CALC_OUTRAS_DESPESAS' required='yes'>
		<cfargument name='CALC_VALOR_TOTAL_IPI' required='yes'>
		<cfargument name='CALC_VALOR_TOTAL_NOTA' required='yes'>
		<cfargument name='OBSERVACAO_FISCAL' required='yes'>
		<cfargument name='OBSERVACAO_USUARIO' required='yes'>
		<cfargument name='COD_CONTABIL' required='yes'>
		<cfargument name='INCLUIR_SISS' required='no' default="1">
		<cfargument name='COD_SERVICO_DES' required='no' default="">
		<cfargument name='NATUREZA_SISS_ID' required='yes'>
		<cfargument name='AVISTA_APRAZO' required='yes'>
		<cfargument name='ALMOXARIFADO' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_ins_nf_terceiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_GESTAO'  value='#session.COD_GESTAO#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID' variable='retorno.NUM_NOTA_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_FISCAL'  value='#arguments.NUM_NOTA_FISCAL#'  null='#iif(len(trim(arguments.NUM_NOTA_FISCAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_MODELO'  value='#arguments.COD_MODELO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUBSERIE'  value='#arguments.SUBSERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NATUREZA_ID'  value='#arguments.NATUREZA_ID#'  null='#iif(len(trim(arguments.NATUREZA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_DESCRICAO'  value='#arguments.NATUREZA_DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTRADA'  value='#arguments.DATA_ENTRADA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_EMITENTE'  value='#arguments.COD_EMITENTE#'  null='#iif(len(trim(arguments.COD_EMITENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_RAZAO_SOCIAL'  value='#Left(arguments.EMIT_RAZAO_SOCIAL,59)#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_ENDERECO'  value='#Left(arguments.EMIT_ENDERECO,59)#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_BAIRRO'  value='#Left(arguments.EMIT_BAIRRO,30)#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_MUNICIPIO'  value='#arguments.EMIT_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_UF'  value='#arguments.EMIT_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_CEP'  value='#arguments.EMIT_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_TELEFONE'  value='#arguments.EMIT_TELEFONE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_CNPJ_CPF'  value='#arguments.EMIT_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_INSCRICAO_ESTADUAL'  value='#arguments.EMIT_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CLIENTE'  value='#arguments.COD_CLIENTE#'  null='#iif(len(trim(arguments.COD_CLIENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_IMPOSTO_ID'  value='#arguments.NF_IMPOSTO_ID#'  null='#iif(len(trim(arguments.NF_IMPOSTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_BASE_ICMS'  value='#arguments.CALC_BASE_ICMS#'  null='#iif(len(trim(arguments.CALC_BASE_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_ICMS'  value='#arguments.CALC_VALOR_ICMS#'  null='#iif(len(trim(arguments.CALC_VALOR_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_BASE_ICMS_SUBST'  value='#arguments.CALC_BASE_ICMS_SUBST#'  null='#iif(len(trim(arguments.CALC_BASE_ICMS_SUBST)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_ICMS_SUBST'  value='#arguments.CALC_VALOR_ICMS_SUBST#'  null='#iif(len(trim(arguments.CALC_VALOR_ICMS_SUBST)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_TOTAL_PRODUTOS'  value='#arguments.CALC_VALOR_TOTAL_PRODUTOS#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_PRODUTOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_FRETE'  value='#arguments.CALC_VALOR_FRETE#'  null='#iif(len(trim(arguments.CALC_VALOR_FRETE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_SEGURO'  value='#arguments.CALC_VALOR_SEGURO#'  null='#iif(len(trim(arguments.CALC_VALOR_SEGURO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_OUTRAS_DESPESAS'  value='#arguments.CALC_OUTRAS_DESPESAS#'  null='#iif(len(trim(arguments.CALC_OUTRAS_DESPESAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_TOTAL_IPI'  value='#arguments.CALC_VALOR_TOTAL_IPI#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_IPI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_TOTAL_NOTA'  value='#arguments.CALC_VALOR_TOTAL_NOTA#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_NOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_FISCAL'  value='#arguments.OBSERVACAO_FISCAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_USUARIO'  value='#arguments.OBSERVACAO_USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONFERIDA'  value='0'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_CONTABIL'  value='#arguments.COD_CONTABIL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INCLUIR_SISS'  value='#arguments.INCLUIR_SISS#'  null='#iif(len(trim(arguments.INCLUIR_SISS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SERVICO_DES'  value='#arguments.COD_SERVICO_DES#'  null='#iif(len(trim(arguments.COD_SERVICO_DES)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_SISS_ID'  value='#arguments.NATUREZA_SISS_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AVISTA_APRAZO'  value='#arguments.AVISTA_APRAZO#'  null='#iif(len(trim(arguments.AVISTA_APRAZO)), de('no'), de('yes'))#'>
                    <cfif session.site eq 'rodomar/'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_MANUTENCAO_ID'  value='0'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TELEFONE_NUMERO'  null="yes" >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_USUARIO_TELEFONE'  null="yes" >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PEDIDO_ID'  null="yes">
                    </cfif>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				
				<cfscript>
					// Insere itens da nota
					v_cfop = this.ListaToArray(lista = arguments, variavel = "CFOP_PRODUTOS");
					v_cfop_id = this.ListaToArray(lista = arguments, variavel = "CFOP_ID_PRODUTOS");
					v_uf_unidade_negocio = this.ListaToArray(lista = arguments, variavel = "UF_UNIDADE_NEGOCIO_PRODUTOS");
					v_uf_emitente = this.ListaToArray(lista = arguments, variavel = "UF_EMITENTE_PRODUTOS");
					v_produto_id = this.ListaToArray(lista = arguments, variavel = "PRODUTO_ID_PRODUTOS");
					v_descricao = this.ListaToArray(lista = arguments, variavel = "PRODUTO_DESCRICAO_PRODUTOS");
					v_descricao_complemento = this.ListaToArray(lista = arguments, variavel = "DESCRICAO_COMPLEMENTO_PRODUTOS");
					v_cod_ncm = this.ListaToArray(lista = arguments, variavel = "COD_NCM_PRODUTOS");
					v_st_origem_id = this.ListaToArray(lista = arguments, variavel = "ST_ORIGEM_ID_PRODUTOS");
					v_st_icms_id = this.ListaToArray(lista = arguments, variavel = "ST_ICMS_ID_PRODUTOS");
					v_cod_unidade = this.ListaToArray(lista = arguments, variavel = "COD_UNIDADE_PRODUTOS");
					v_qtde_peso = this.ListaToArray(lista = arguments, variavel = "PRODUTO_PESO_PRODUTOS");
					v_qtde_volume = this.ListaToArray(lista = arguments, variavel = "PRODUTO_VOLUME_PRODUTOS");
					v_qtde_metro = this.ListaToArray(lista = arguments, variavel = "PRODUTO_METRO_PRODUTOS");
					v_valor_em = this.ListaToArray(lista = arguments, variavel = "PRODUTO_VALOR_EM_PRODUTOS");
					v_valor_em_unidade = this.ListaToArray(lista = arguments, variavel = "VALOR_EM_UNIDADE_PRODUTOS");
					v_valor_unitario = this.ListaToArray(lista = arguments, variavel = "PRODUTO_VALOR_UNITARIO_PRODUTOS");
					v_valor_total = this.ListaToArray(lista = arguments, variavel = "PRODUTO_VALOR_TOTAL_PRODUTOS");
					v_icms_reducao_base = this.ListaToArray(lista = arguments, variavel = "PRODUTO_ICMS_REDUCAO_BASE_PRODUTOS");
					v_icms_base_calculo = this.ListaToArray(lista = arguments, variavel = "PRODUTO_ICMS_BASE_CALCULO_PRODUTOS");
					v_icms_aliquota = this.ListaToArray(lista = arguments, variavel = "PRODUTO_ICMS_ALIQUOTA_PRODUTOS");
					v_icms_valor = this.ListaToArray(lista = arguments, variavel = "PRODUTO_ICMS_VALOR_PRODUTOS");
					v_ipi_reducao_base = this.ListaToArray(lista = arguments, variavel = "PRODUTO_IPI_REDUCAO_BASE_PRODUTOS");
					v_ipi_base_calculo = this.ListaToArray(lista = arguments, variavel = "PRODUTO_IPI_BASE_CALCULO_PRODUTOS");
					v_ipi_aliquota = this.ListaToArray(lista = arguments, variavel = "PRODUTO_IPI_ALIQUOTA_PRODUTOS");
					v_ipi_valor = this.ListaToArray(lista = arguments, variavel = "PRODUTO_IPI_VALOR_PRODUTOS");
					v_serv_total_tributavel = this.ListaToArray(lista = arguments, variavel = "SERV_TOTAL_TRIBUTAVEL_PRODUTOS");
					v_serv_total_nao_tributavel = this.ListaToArray(lista = arguments, variavel = "SERV_TOTAL_NAO_TRIBUTAVEL_PRODUTOS");
					v_serv_total_produto = this.ListaToArray(lista = arguments, variavel = "SERV_TOTAL_PRODUTO_PRODUTOS");
					v_serv_iss_aliquota = this.ListaToArray(lista = arguments, variavel = "SERV_ISS_ALIQUOTA_PRODUTOS");
					v_serv_iss_deducao = this.ListaToArray(lista = arguments, variavel = "SERV_ISS_DEDUCAO_PRODUTOS");
					v_serv_iss_valor = this.ListaToArray(lista = arguments, variavel = "SERV_ISS_VALOR_PRODUTOS");
					v_desconto_percentual = this.ListaToArray(lista = arguments, variavel = "PRODUTO_DESCONTO_PERCENTUAL_PRODUTOS");
					v_desconto_valor = this.ListaToArray(lista = arguments, variavel = "PRODUTO_VALOR_DESCONTO_PRODUTOS");
					v_incluir_livro_fiscal = this.ListaToArray(lista = arguments, variavel = "INCLUIR_LIVRO_FISCAL_PRODUTOS");
					if (session.site eq 'rodomar/') {
						v_cod_contabil = this.ListaToArray(lista = arguments, variavel = "PROD_COD_CONTABIL_PRODUTOS");					
					} else {
						v_cod_contabil[1] = '';
					}
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_cfop)#" index="count">
				    <cfscript>
						this.ins_nf_terceiro_it ( num_nota_id = retorno.num_nota_id,
														  cfop = v_cfop[count],
														  cfop_id = v_cfop_id[count],
														  uf_unidade_negocio = v_uf_unidade_negocio[count],
														  uf_emitente = v_uf_emitente[count],
														  produto_id = v_produto_id[count],
														  descricao = v_descricao[count],
														  descricao_complemento = v_descricao_complemento[count],
														  cod_ncm = v_cod_ncm[count],
														  st_origem_id = v_st_origem_id[count],
														  st_icms_id = v_st_icms_id[count],
														  cod_unidade = v_cod_unidade[count],
														  qtde_peso = v_qtde_peso[count],
														  qtde_volume = v_qtde_volume[count],
														  qtde_metro = v_qtde_metro[count],
														  valor_em = v_qtde_volume[count],
														  valor_em_unidade = v_valor_em[count],
														  valor_unitario = v_valor_unitario[count],
														  valor_total = v_valor_total[count],
														  icms_reducao_base = v_icms_reducao_base[count],
														  icms_base_calculo = v_icms_base_calculo[count],
														  icms_aliquota = v_icms_aliquota[count],
														  icms_valor = v_icms_valor[count],
														  ipi_reducao_base = v_ipi_reducao_base[count],
														  ipi_base_calculo = v_ipi_base_calculo[count],
														  ipi_aliquota = v_ipi_aliquota[count],
														  ipi_valor = v_ipi_valor[count],
														  serv_total_tributavel = v_serv_total_tributavel[count],
														  serv_total_nao_tributavel = v_serv_total_nao_tributavel[count],
														  serv_total_produto = v_serv_total_produto[count],
														  serv_iss_aliquota = v_serv_iss_aliquota[count],
														  serv_iss_deducao = v_serv_iss_deducao[count],
														  serv_iss_valor = v_serv_iss_valor[count],
														  desconto_percentual = v_desconto_percentual[count],
														  desconto_valor = v_desconto_valor[count],
														  incluir_estoque = 1,
														  incluir_livro_fiscal = v_incluir_livro_fiscal[count]);
              	 </cfscript>									  
				</cfloop>
				<!---Insere Rateio--->
				<cfscript>
					this.ins_nf_terceiro_rateio(num_nota_id = retorno.num_nota_id,
														 cod_pessoa = arguments.COD_PESSOA_FILIAL,
														 cod_departamento = arguments.COD_DEPARTAMENTO,
														 cod_setor = arguments.COD_SETOR,
														 cod_centro_custo = arguments.COD_CENTRO_CUSTO,
														 perc_rateio = 100,
														 valor_rateio = arguments.CALC_VALOR_TOTAL_NOTA,
														 cod_contabil = v_cod_contabil[1]
														 );
				</cfscript>
				 
				<!---Vincula a um oramento--->
				<cfscript>
						v_num_controle = this.ListaToArray(lista = arguments, variavel = "NUM_CONTROLE_ORDEM_COMPRA");
						v_valor_utilizado = this.ListaToArray(lista = arguments, variavel = "VALOR_UTILIZADO_ORDEM_COMPRA");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_num_controle)#" index="count">
					<cfscript>
						conn = CreateObject("component","_transportes.manipulacao.cfc_manutencao");
						conn.vincula_nf_terceiro_ordem_compra(NF_TERCEIRO_ID = retorno.num_nota_id,
														      ORDEM_COMPRA_ID = v_num_controle[count],
															  VALOR_UTILIZADO = v_valor_utilizado[count]);
					</cfscript>
				</cfloop>
				
				<!--- Lana materiais no almoxarifado --->
				<cfif Len(Trim(arguments.ALMOXARIFADO))>
					<cfscript>
						v_lancamento_id = this.ListaToArray(lista = arguments, variavel = "LANCAMENTO_ID_ALMOX");
						v_material_id = this.ListaToArray(lista = arguments, variavel = "MATERIAL_ID_ALMOX");
						v_quantidade = this.ListaToArray(lista = arguments, variavel = "QUANTIDADE_ALMOX");
						v_solicitacao_id = this.ListaToArray(lista = arguments, variavel = "SOLICITACAO_ID_ALMOX");
						v_atributo_id = this.ListaToArray(lista = arguments, variavel = "ATRIBUTO_ID_ALMOX");
						v_atributo_valor = this.ListaToArray(lista = arguments, variavel = "ATRIBUTO_VALOR_ALMOX");
						
						conn = CreateObject("component","_transportes.manipulacao.cfc_almoxarifado");
					</cfscript>
					<cfloop from="1" to="#ArrayLen(v_lancamento_id)#" index="count">
						 <cfscript>
								v_movimentacao = conn.ins_movimentacao_private(OPERACAO_TIPO_ID = arguments.OPERACAO_TIPO_ID,
																			   DATA_LANCAMENTO = arguments.DATA_ENTRADA,
																			   MATERIAL_ID = v_material_id[count],
																			   QUANTIDADE = v_quantidade[count],
																			   COD_PESSOA_FILIAL = arguments.COD_PESSOA_FILIAL,
																			   SOLICITACAO_ID	 = v_solicitacao_id[count],
																			   nUM_NOTA_ID = retorno.NUM_NOTA_ID);
								v_lista_id = ListToArray(v_atributo_id[count],'||');															  
								v_lista_valor = ListToArray(v_atributo_valor[count],'||');
						 </cfscript>
						 
						 <cfif ArrayLen(v_lista_id) gt ArrayLen(v_lista_valor)>
						 	<cfloop index="i" from="#ArrayLen(v_lista_valor)#" to="#ArrayLen(v_lista_id)#">
								<cfset v_lista_valor[i] = ''>
							</cfloop>
						 </cfif>
						 
						 <cfloop from="1" to="#ArrayLen(v_lista_id)#" index="it">
							<cfif (v_lista_id[it] eq '23') and not Len(Trim(v_lista_valor[it])) >
                            	<cfthrow detail="Valor unitrio nulo. No foi possvel gravar a movimentao" errorcode="1">
                            </cfif>
						 	<cfscript>
								conn.ins_movimentacao_atributo( lancamento_id = v_movimentacao.lancamento_id,
																material_id	  = v_material_id[count],
																atributo_id   = v_lista_id[it],
																valor		  = v_lista_valor[it]);
						 	</cfscript>
						 </cfloop>
					</cfloop>					
				</cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Nota fiscal inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Excluir nota fiscal de terceiro
	-- guto 20/12/2006 11:28:40 - CRIADO
	--->
	<cffunction name='del_nf_terceiro' displayname='Excluir nota fiscal de terceiro' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='MOTIVO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_del_nf_terceiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO'  value='#arguments.MOTIVO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Nota fiscal excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere item a nota fiscal de terceiro
	-- guto 20/12/2006 11:42:32 - CRIADO
	--->
	<cffunction name='ins_nf_terceiro_it' displayname='Insere item a nota fiscal de terceiro' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='CFOP' required='yes'>
		<cfargument name='CFOP_ID' required='yes'>
		<cfargument name='UF_UNIDADE_NEGOCIO' required='yes'>
		<cfargument name='UF_EMITENTE' required='yes'>
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='DESCRICAO_COMPLEMENTO' required='yes'>
		<cfargument name='COD_NCM' required='yes'>
		<cfargument name='ST_ORIGEM_ID' required='yes'>
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='QTDE_PESO' required='yes'>
		<cfargument name='QTDE_VOLUME' required='yes'>
		<cfargument name='QTDE_METRO' required='yes'>
		<cfargument name='VALOR_EM' required='yes'>
		<cfargument name='VALOR_EM_UNIDADE' required='yes'>
		<cfargument name='VALOR_UNITARIO' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
		<cfargument name='ICMS_REDUCAO_BASE' required='yes'>
		<cfargument name='ICMS_BASE_CALCULO' required='yes'>
		<cfargument name='ICMS_ALIQUOTA' required='yes'>
		<cfargument name='ICMS_VALOR' required='yes'>
		<cfargument name='IPI_REDUCAO_BASE' required='yes'>
		<cfargument name='IPI_BASE_CALCULO' required='yes'>
		<cfargument name='IPI_ALIQUOTA' required='yes'>
		<cfargument name='IPI_VALOR' required='yes'>
		<cfargument name='SERV_TOTAL_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_NAO_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_PRODUTO' required='yes'>
		<cfargument name='SERV_ISS_ALIQUOTA' required='yes'>
		<cfargument name='SERV_ISS_DEDUCAO' required='yes'>
		<cfargument name='SERV_ISS_VALOR' required='yes'>
		<cfargument name='DESCONTO_PERCENTUAL' required='yes'>
		<cfargument name='DESCONTO_VALOR' required='yes'>
		<cfargument name='INCLUIR_ESTOQUE' required='no' default="0">
		<cfargument name='INCLUIR_LIVRO_FISCAL' required='no' default="0">
            <cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_ins_nf_terceiro_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_IT_ID' variable='retorno.NUM_NOTA_IT_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CFOP'  value='#arguments.CFOP#'  null='#iif(len(trim(arguments.CFOP)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP_ID'  value='#arguments.CFOP_ID#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_UNIDADE_NEGOCIO'  value='#arguments.UF_UNIDADE_NEGOCIO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_EMITENTE'  value='#arguments.UF_EMITENTE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_COMPLEMENTO'  value='#arguments.DESCRICAO_COMPLEMENTO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_NCM'  value='#arguments.COD_NCM#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ORIGEM_ID'  value='#arguments.ST_ORIGEM_ID#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#arguments.ST_ICMS_ID#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_PESO'  value='#arguments.QTDE_PESO#'  null='#iif(len(trim(arguments.QTDE_PESO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_VOLUME'  value='#arguments.QTDE_VOLUME#'  null='#iif(len(trim(arguments.QTDE_VOLUME)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_METRO'  value='#arguments.QTDE_METRO#'  null='#iif(len(trim(arguments.QTDE_METRO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_EM'  value='#arguments.VALOR_EM#'  null='#iif(len(trim(arguments.VALOR_EM)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR_EM_UNIDADE'  value='#arguments.VALOR_EM_UNIDADE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_UNITARIO'  value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ICMS_REDUCAO_BASE'  value='#arguments.ICMS_REDUCAO_BASE#'  null='#iif(len(trim(arguments.ICMS_REDUCAO_BASE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ICMS_BASE_CALCULO'  value='#arguments.ICMS_BASE_CALCULO#'  null='#iif(len(trim(arguments.ICMS_BASE_CALCULO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ICMS_ALIQUOTA'  value='#arguments.ICMS_ALIQUOTA#'  null='#iif(len(trim(arguments.ICMS_ALIQUOTA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ICMS_VALOR'  value='#arguments.ICMS_VALOR#'  null='#iif(len(trim(arguments.ICMS_VALOR)), de('no'), de('yes'))#'>
                <cfif session.site neq 'delpozo/'>
                	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ICMS_BASE_CALC_SUBST' value="0">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ICMS_VALOR_SUBST'  value='0'>
                </cfif>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IPI_REDUCAO_BASE'  value='#arguments.IPI_REDUCAO_BASE#'  null='#iif(len(trim(arguments.IPI_REDUCAO_BASE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IPI_BASE_CALCULO'  value='#arguments.IPI_BASE_CALCULO#'  null='#iif(len(trim(arguments.IPI_BASE_CALCULO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IPI_ALIQUOTA'  value='#arguments.IPI_ALIQUOTA#'  null='#iif(len(trim(arguments.IPI_ALIQUOTA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IPI_VALOR'  value='#arguments.IPI_VALOR#'  null='#iif(len(trim(arguments.IPI_VALOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_TOTAL_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_TRIBUTAVEL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_TOTAL_NAO_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_NAO_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_NAO_TRIBUTAVEL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_TOTAL_PRODUTO'  value='#arguments.SERV_TOTAL_PRODUTO#'  null='#iif(len(trim(arguments.SERV_TOTAL_PRODUTO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_ISS_ALIQUOTA'  value='#arguments.SERV_ISS_ALIQUOTA#'  null='#iif(len(trim(arguments.SERV_ISS_ALIQUOTA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_ISS_DEDUCAO'  value='#arguments.SERV_ISS_DEDUCAO#'  null='#iif(len(trim(arguments.SERV_ISS_DEDUCAO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_ISS_VALOR'  value='#arguments.SERV_ISS_VALOR#'  null='#iif(len(trim(arguments.SERV_ISS_VALOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCONTO_PERCENTUAL'  value='#arguments.DESCONTO_PERCENTUAL#'  null='#iif(len(trim(arguments.DESCONTO_PERCENTUAL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCONTO_VALOR'  value='#arguments.DESCONTO_VALOR#'  null='#iif(len(trim(arguments.DESCONTO_VALOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INCLUIR_ESTOQUE'  value='#arguments.INCLUIR_ESTOQUE#'  null='#iif(len(trim(arguments.INCLUIR_ESTOQUE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INCLUIR_LIVRO_FISCAL'  value='#arguments.INCLUIR_LIVRO_FISCAL#'  null='#iif(len(trim(arguments.INCLUIR_LIVRO_FISCAL)), de('no'), de('yes'))#'>
                <cfif session.site eq 'rodomar/'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INCLUIR_SINTEGRA'  value="0">
                </cfif>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                
            </cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera item a nota fiscal de terceiro
	-- guto 20/12/2006 11:43:41 - CRIADO
	--->
	<cffunction name='alt_nf_terceiro_it' displayname='Altera item a nota fiscal de terceiro' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='NUM_NOTA_IT_ID' required='yes'>
		<cfargument name='CFOP' required='yes'>
		<cfargument name='CFOP_ID' required='yes'>
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='UF_UNIDADE_NEGOCIO' required='yes'>
		<cfargument name='UF_EMITENTE' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='DESCRICAO_COMPLEMENTO' required='yes'>
		<cfargument name='COD_NCM' required='yes'>
		<cfargument name='ST_ORIGEM_ID' required='yes'>
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='QTDE_PESO' required='yes'>
		<cfargument name='QTDE_VOLUME' required='yes'>
		<cfargument name='QTDE_METRO' required='yes'>
		<cfargument name='VALOR_EM' required='yes'>
		<cfargument name='VALOR_EM_UNIDADE' required='yes'>
		<cfargument name='VALOR_UNITARIO' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
		<cfargument name='ICMS_REDUCAO_BASE' required='yes'>
		<cfargument name='ICMS_BASE_CALCULO' required='yes'>
		<cfargument name='ICMS_ALIQUOTA' required='yes'>
		<cfargument name='ICMS_VALOR' required='yes'>
		<cfargument name='IPI_REDUCAO_BASE' required='yes'>
		<cfargument name='IPI_BASE_CALCULO' required='yes'>
		<cfargument name='IPI_ALIQUOTA' required='yes'>
		<cfargument name='IPI_VALOR' required='yes'>
		<cfargument name='SERV_TOTAL_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_NAO_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_PRODUTO' required='yes'>
		<cfargument name='SERV_ISS_ALIQUOTA' required='yes'>
		<cfargument name='SERV_ISS_DEDUCAO' required='yes'>
		<cfargument name='SERV_ISS_VALOR' required='yes'>
		<cfargument name='DESCONTO_PERCENTUAL' required='yes'>
		<cfargument name='DESCONTO_VALOR' required='yes'>
		<cfargument name='INCLUIR_ESTOQUE' required='no' default="1">
		<cfargument name='INCLUIR_LIVRO_FISCAL' required='no' default="0">
				<cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_alt_nf_terceiro_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_IT_ID'  value='#arguments.NUM_NOTA_IT_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_IT_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CFOP'  value='#arguments.CFOP#'  null='#iif(len(trim(arguments.CFOP)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP_ID'  value='#arguments.CFOP_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_UNIDADE_NEGOCIO'  value='#arguments.UF_UNIDADE_NEGOCIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_EMITENTE'  value='#arguments.UF_EMITENTE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_COMPLEMENTO'  value='#arguments.DESCRICAO_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_NCM'  value='#arguments.COD_NCM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ORIGEM_ID'  value='#arguments.ST_ORIGEM_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#arguments.ST_ICMS_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_PESO'  value='#arguments.QTDE_PESO#'  null='#iif(len(trim(arguments.QTDE_PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_VOLUME'  value='#arguments.QTDE_VOLUME#'  null='#iif(len(trim(arguments.QTDE_VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_METRO'  value='#arguments.QTDE_METRO#'  null='#iif(len(trim(arguments.QTDE_METRO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_EM'  value='#arguments.VALOR_EM#'  null='#iif(len(trim(arguments.VALOR_EM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR_EM_UNIDADE'  value='#arguments.VALOR_EM_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_UNITARIO'  value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ICMS_REDUCAO_BASE'  value='#arguments.ICMS_REDUCAO_BASE#'  null='#iif(len(trim(arguments.ICMS_REDUCAO_BASE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ICMS_BASE_CALCULO'  value='#arguments.ICMS_BASE_CALCULO#'  null='#iif(len(trim(arguments.ICMS_BASE_CALCULO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ICMS_ALIQUOTA'  value='#arguments.ICMS_ALIQUOTA#'  null='#iif(len(trim(arguments.ICMS_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ICMS_VALOR'  value='#arguments.ICMS_VALOR#'  null='#iif(len(trim(arguments.ICMS_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IPI_REDUCAO_BASE'  value='#arguments.IPI_REDUCAO_BASE#'  null='#iif(len(trim(arguments.IPI_REDUCAO_BASE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IPI_BASE_CALCULO'  value='#arguments.IPI_BASE_CALCULO#'  null='#iif(len(trim(arguments.IPI_BASE_CALCULO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IPI_ALIQUOTA'  value='#arguments.IPI_ALIQUOTA#'  null='#iif(len(trim(arguments.IPI_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IPI_VALOR'  value='#arguments.IPI_VALOR#'  null='#iif(len(trim(arguments.IPI_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_TOTAL_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_TRIBUTAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_TOTAL_NAO_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_NAO_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_NAO_TRIBUTAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_TOTAL_PRODUTO'  value='#arguments.SERV_TOTAL_PRODUTO#'  null='#iif(len(trim(arguments.SERV_TOTAL_PRODUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_ISS_ALIQUOTA'  value='#arguments.SERV_ISS_ALIQUOTA#'  null='#iif(len(trim(arguments.SERV_ISS_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_ISS_DEDUCAO'  value='#arguments.SERV_ISS_DEDUCAO#'  null='#iif(len(trim(arguments.SERV_ISS_DEDUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_ISS_VALOR'  value='#arguments.SERV_ISS_VALOR#'  null='#iif(len(trim(arguments.SERV_ISS_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCONTO_PERCENTUAL'  value='#arguments.DESCONTO_PERCENTUAL#'  null='#iif(len(trim(arguments.DESCONTO_PERCENTUAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCONTO_VALOR'  value='#arguments.DESCONTO_VALOR#'  null='#iif(len(trim(arguments.DESCONTO_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INCLUIR_ESTOQUE'  value='#arguments.INCLUIR_ESTOQUE#'  null='#iif(len(trim(arguments.INCLUIR_ESTOQUE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INCLUIR_LIVRO_FISCAL'  value='#arguments.INCLUIR_LIVRO_FISCAL#'  null='#iif(len(trim(arguments.INCLUIR_LIVRO_FISCAL)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Excluir item a nota fiscal de terceiro
	-- guto 20/12/2006 11:45:59 - CRIADO
	--->
	<cffunction name='del_nf_terceiro_it' displayname='Excluir item a nota fiscal de terceiro' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='NUM_NOTA_IT_ID' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_del_nf_terceiro_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_IT_ID'  value='#arguments.NUM_NOTA_IT_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_IT_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere item rateio nota
	-- guto 20/12/2006 11:55:01 - CRIADO
	--->
	<cffunction name='ins_nf_terceiro_rateio' displayname='Insere item rateio nota' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='PERC_RATEIO' required='yes'>
		<cfargument name='VALOR_RATEIO' required='yes'>
		<cfargument name='COD_CONTABIL' required='no' default="">
				<cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_ins_nf_terceiro_rateio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_RATEIO_ID' variable='retorno.NF_RATEIO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfif session.site eq 'rodomar/'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONTABIL' value='#arguments.COD_CONTABIL#'  null='#iif(len(trim(arguments.COD_CONTABIL)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='' >
                    </cfif>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERC_RATEIO'  value='#arguments.PERC_RATEIO#'  null='#iif(len(trim(arguments.PERC_RATEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_RATEIO'  value='#arguments.VALOR_RATEIO#'  null='#iif(len(trim(arguments.VALOR_RATEIO)), de('no'), de('yes'))#'>
                    <cfif session.site eq 'rodomar/'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_HORA'  value='' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE' null="yes">
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_KM' null="yes">
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID' null="yes">
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_CUPOM_FISCAL' null="yes">
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_UNITARIO' null="yes">
                    </cfif>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera item rateio nota
	-- guto 20/12/2006 11:56:46 - CRIADO
	--->
	<cffunction name='alt_nf_terceiro_rateio' displayname='Altera item rateio nota' access='remote' returntype='Struct' output='true'>
		<cfargument name='NF_RATEIO_ID' required='yes'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='PERC_RATEIO' required='yes'>
		<cfargument name='VALOR_RATEIO' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_upd_nf_terceiro_rateio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_RATEIO_ID'  value='#arguments.NF_RATEIO_ID#'  null='#iif(len(trim(arguments.NF_RATEIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERC_RATEIO'  value='#arguments.PERC_RATEIO#'  null='#iif(len(trim(arguments.PERC_RATEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_RATEIO'  value='#arguments.VALOR_RATEIO#'  null='#iif(len(trim(arguments.VALOR_RATEIO)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Excluir item rateio nota
	-- guto 20/12/2006 11:57:26 - CRIADO
	--->
	<cffunction name='del_nf_terceiro_rateio' displayname='Excluir item rateio nota' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='NF_RATEIO_ID' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_del_nf_terceiro_rateio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_RATEIO_ID'  value='#arguments.NF_RATEIO_ID#'  null='#iif(len(trim(arguments.NF_RATEIO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Gera o arquivo dos CTRCs da GERDAU
	-- GUTO 06/01/2007 18:10:00 - CRIADO
	--->
	<cffunction name='gera_arquivo_gerdau' displayname='Gera o arquivo dos CTRCs da GERDAU' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='OPER.pkg_gerdau.prc_gera_arquivo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Arquivo gerado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
    
    <!--- 
	-- PROPSITO
	-- Transferir blocos entre os setores de uma filial - Envio
	-- LOUIS 16/07/2007 09:52 - CRIADO 
	--->
	<cffunction name='transf_blocos_setores' displayname='Transferir blocos entre os setores de uma filial' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ALOCACAO_ID' required='no' default="">
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='DATA_TRANSFERENCIA' required='no' default="">
	    <cftry>
			<cftransaction action='begin'>
            	<cfscript>
					v_num_blocos = ListLen(arguments.alocacao_id);
				</cfscript>
                <cfset count_1 = 1>
                <cfloop list="#arguments.alocacao_id#" delimiters="," index="count">
                	<cfstoredproc procedure='fiscal.pkg_ctrl_docto.prc_enviar_blocos' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ALOCACAO_ID'  value='#ListGetAt(arguments.alocacao_id,count_1)#' >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SETOR_DESTINO'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TRANSFERENCIA'  value='#arguments.DATA_TRANSFERENCIA#' >
					</cfstoredproc>
                    <cfset count_1 = count_1 + 1>
                </cfloop> 
                <cfset retorno.erro = false>
			    <cfset retorno.mensagem = JSStringFormat('Blocos transferidos com sucesso!')>
            </cftransaction>
         		<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Transferir blocos entre os setores de uma filial - Recebimento
	-- LOUIS 16/07/2007 09:52 - CRIADO
	--->
	<cffunction name='transf_blocos_setores_recb' displayname='Transferir blocos entre os setores de uma filial' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ALOCACAO_ID' required='no' default="">
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='DATA_TRANSFERENCIA' required='no' default="">
	    <cftry>
			<cftransaction action='begin'>
            	<cfscript>
					v_num_blocos = ListLen(arguments.alocacao_id);
				</cfscript>
                <cfset count_1 = 1>
                <cfloop list="#arguments.alocacao_id#" delimiters="," index="count">
                	<cfstoredproc procedure='fiscal.pkg_ctrl_docto.prc_receber_blocos' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ALOCACAO_ID'  value='#ListGetAt(arguments.alocacao_id,count_1)#' >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTRADA'  value='#DateFormat(Now(),"dd/mm/yyyy")#' >
					</cfstoredproc>
                    <cfset count_1 = count_1 + 1>
                </cfloop> 
                <cfset retorno.erro = false>
			    <cfset retorno.mensagem = JSStringFormat('Blocos recebidos com sucesso!')>
            </cftransaction>
         		<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
        
    <!--- 
    -- PROPSITO
    -- Insere ou altera uma nota fiscal do conhecimento
    -- cristofer 19/10/2007 15:00:51 - CRIADO
    --->
    <cffunction name='ins_conhecimento_nota_fiscal' displayname='Insere ou altera uma nota fiscal do conhecimento' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cfargument name='NUMERO' required='yes'>
        <cfargument name='NUMERO_OLD' required='no'>
        <cfargument name='DATA_EMISSAO' required='yes'>
        <cfargument name='MODELO' required='yes'>
        <cfargument name='SERIE' required='no'>
        <cfargument name='SUB_SERIE' required='no'>
        <cfargument name='VALOR_TOTAL' required='yes'>
               
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_ins_nf_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUMERO'  value='#arguments.NUMERO#'  null='#iif(len(trim(arguments.NUMERO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUMERO_OLD'  value='#arguments.NUMERO_OLD#'  null='#iif(len(trim(arguments.NUMERO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MODELO'  value='#arguments.MODELO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUB_SERIE'  value='#arguments.SUB_SERIE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Nota fiscal salva com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui uma nota fiscal do conhecimento
    -- cristofer 19/10/2007 15:01:40 - CRIADO
    --->
    <cffunction name='del_conhecimento_nota_fiscal' displayname='Exclui uma nota fiscal do conhecimento' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cfargument name='NUMERO' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_del_nf_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUMERO'  value='#arguments.NUMERO#'  null='#iif(len(trim(arguments.NUMERO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Nota fiscal excluida com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Executa alteraes dos valores de frete do conhecimento
    -- cristofer 19/10/2007 15:01:40 - CRIADO
    --->
    <cffunction name='upd_conhecimento_frete' displayname='Executa alteraes dos valores de frete do conhecimento' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cfargument name='FRETE_UNITARIO' required='yes'>
        <cfargument name='FRETE_VALOR' required='yes'>
        <cfargument name='DESPACHO' required='yes'>
        <cfargument name='ADEME' required='yes'>
        <cfargument name='DESCONTO' required='yes'>
        <cfargument name='COLETA_ENTREGA' required='yes'>
        <cfargument name='IMPOSTOS' required='yes'>
        <cfargument name='TOTAL_CONHECIMENTO' required='yes'>
        <cfargument name='BASE_CALCULO_ICMS' required='yes'>
        <cfargument name='VALOR_ICMS' required='yes'>
        <cfargument name='VALOR_ICMS_SUBSTIT' required='yes'>
               
        <cftry>
        	<cftransaction action="begin">
                <cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_alt_conhecimento_frete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_UNITARIO'  value='#arguments.FRETE_UNITARIO#'  null='#iif(len(trim(arguments.FRETE_UNITARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_VALOR'  value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESPACHO'  value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ADEME'  value='#arguments.ADEME#'  null='#iif(len(trim(arguments.ADEME)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCONTO'  value='#arguments.DESCONTO#'  null='#iif(len(trim(arguments.DESCONTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_ENTREGA'  value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMPOSTOS'  value='#arguments.IMPOSTOS#'  null='#iif(len(trim(arguments.IMPOSTOS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TOTAL_CONHECIMENTO'  value='#arguments.TOTAL_CONHECIMENTO#'  null='#iif(len(trim(arguments.TOTAL_CONHECIMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BASE_CALCULO_ICMS'  value='#arguments.BASE_CALCULO_ICMS#'  null='#iif(len(trim(arguments.BASE_CALCULO_ICMS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ICMS'  value='#arguments.VALOR_ICMS#'  null='#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ICMS_SUBSTIT'  value='#arguments.VALOR_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.VALOR_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
                </cfstoredproc>

				<cfscript>
                    v_numero = this.ListaToArray (lista = arguments, variavel = "NOTA_NUMERO_NOTAS_FISCAIS");
					v_numero_old = this.ListaToArray (lista = arguments, variavel = "NOTA_NUMERO_NOTAS_FISCAIS");
                    v_data_emissao = this.ListaToArray (lista = arguments, variavel = "NOTA_DATA_EMISSAO_NOTAS_FISCAIS");
                    v_modelo = this.ListaToArray (lista = arguments, variavel = "NOTA_MODELO_NOTAS_FISCAIS");
                    v_serie = this.ListaToArray (lista = arguments, variavel = "NOTA_SERIE_NOTAS_FISCAIS");
                    v_sub_serie = this.ListaToArray (lista = arguments, variavel = "NOTA_SUB_SERIE_NOTAS_FISCAIS");
                    v_valor_total = this.ListaToArray (lista = arguments, variavel = "NOTA_VALOR_NOTAS_FISCAIS");
                    v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_NOTAS_FISCAIS, lista2 = ArrayToList(v_numero));
                </cfscript>
                
                <cfloop list="#v_excluir#" delimiters="," index="l_id">
                	<cfscript>
						ret = this.del_conhecimento_nota_fiscal(
												conhecimento_id = arguments.conhecimento_id,
												numero			= l_id);
					</cfscript>
                    <cfif ret.erro>
                    	<cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_numero)#" index="count">
                	<cfscript>
						ret = this.ins_conhecimento_nota_fiscal(
												conhecimento_id = arguments.conhecimento_id,
												numero			= v_numero[count],
												numero_old		= v_numero[count],
												data_emissao	= v_data_emissao[count],
												modelo			= v_modelo[count],
												serie			= v_serie[count],
												sub_serie		= v_sub_serie[count],
												valor_total		= v_valor_total[count]);
					</cfscript>
                    <cfif ret.erro>
                    	<cfthrow object="#ret.mensagem#">
					</cfif>
                </cfloop>			


                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Conhecimento alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
            	<cftransaction action="rollback">
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Faturar os impostos para uma determinada NF
	-- ANDERSONC 09/06/2009 11:27:57 - CRIADO
	--->
	<cffunction name='faturar_impostos' displayname='Faturar os impostos para uma determinada NF' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_faturamento_nf_terceiro.prc_faturamento_imposto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Impostos faturados com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Cancela uma ou mais Notas Fiscais de Entrada e Sada
	-- ANDERSONC 21/07/2009 17:25:23 - CRIADO
	--->
	<cffunction name='cancelar_nf_es' displayname='Cancela uma Nota Fiscal de Servio' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='MOTIVO' required='yes'>
		<cftry>
			<cfloop list="#arguments.NUM_NOTA_ID#" delimiters="," index="i">
            	<cfscript>
					ret = this.upd_nf_es_cancela(NUM_NOTA_ID = i,
												 MOTIVO = arguments.MOTIVO);
				</cfscript>
                <cfif ret.erro>
                	<cfthrow object="#ret.mensagem#">
                </cfif>
			</cfloop>
            
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Nota(s) Fiscal(s) cancelada(s) com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Cancela uma Nota Fiscal de Entrada e Sada
	-- ANDERSONC 21/07/2009 17:25:23 - CRIADO
	--->
	<cffunction name='upd_nf_es_cancela' displayname='Cancela uma Nota Fiscal de Servio' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='MOTIVO' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_nf_es.prc_alt_nf_es_cancela' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO'  value='#arguments.MOTIVO#' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Nota Fiscal cancelada com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere uma nota fiscal de fornecedor
    -- ANDERSON - 17/11/2009 - CRIADO
    --->
    <cffunction name='ins_nf_fornecedor' displayname='Insere nota fiscal de terceiro' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_PESSOA_FILIAL' required='yes'>
        <cfargument name='COD_DEPARTAMENTO' required='yes'>
        <cfargument name='COD_SETOR' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='NUM_NOTA_FISCAL' required='yes'>
        <cfargument name='COD_MODELO' required='yes'>
        <cfargument name='SERIE' required='yes'>
        <cfargument name='SUBSERIE' required='yes'>
        <cfargument name='NATUREZA_ID' required='yes'>
        <cfargument name='NATUREZA_DESCRICAO' required='yes'>
        <cfargument name='DATA_EMISSAO' required='yes'>
        <cfargument name='DATA_ENTRADA' required='yes'>
        <cfargument name='COD_EMITENTE' required='yes'>
        <cfargument name='EMIT_RAZAO_SOCIAL' required='yes'>
        <cfargument name='EMIT_ENDERECO' required='yes'>
        <cfargument name='EMIT_BAIRRO' required='yes'>
        <cfargument name='EMIT_MUNICIPIO' required='yes'>
        <cfargument name='EMIT_UF' required='yes'>
        <cfargument name='EMIT_CEP' required='yes'>
        <cfargument name='EMIT_TELEFONE' required='yes'>
        <cfargument name='EMIT_CNPJ_CPF' required='yes'>
        <cfargument name='EMIT_INSCRICAO_ESTADUAL' required='yes'>
        <cfargument name='COD_CLIENTE' required='yes'>
        <cfargument name='NF_IMPOSTO_ID' required='no' default="">
        <cfargument name='CALC_BASE_ICMS' required='yes'>
        <cfargument name='CALC_VALOR_ICMS' required='yes'>
        <cfargument name='CALC_BASE_ICMS_SUBST' required='yes'>
        <cfargument name='CALC_VALOR_ICMS_SUBST' required='yes'>
        <cfargument name='CALC_VALOR_TOTAL_PRODUTOS' required='yes'>
        <cfargument name='CALC_VALOR_FRETE' required='yes'>
        <cfargument name='CALC_VALOR_SEGURO' required='yes'>
        <cfargument name='CALC_OUTRAS_DESPESAS' required='yes'>
        <cfargument name='CALC_VALOR_TOTAL_IPI' required='yes'>
        <cfargument name='CALC_VALOR_TOTAL_NOTA' required='yes'>
        <cfargument name='OBSERVACAO_FISCAL' required='yes'>
        <cfargument name='OBSERVACAO_USUARIO' required='yes'>
        <cfargument name='CONFERIDA' required='no' default="0">
        <cfargument name='COD_CONTABIL' required='yes'>
        <cfargument name='INCLUIR_SISS' required='yes'>
        <cfargument name='COD_SERVICO_DES' required='yes'>
        <cfargument name='NATUREZA_SISS_ID' required='yes'>
        <cfargument name='AVISTA_APRAZO' required='yes'>
        <cfargument name='ORGANIZACIONAL_ID_GERENCIAL' required='yes'>
        <cfargument name='CALC_VALOR_DESCONTO' required='yes'>
        <cfargument name='PEDIDO_ITEM_ID' required='yes'>
        <cfargument name='MANUAL' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_ins_nf_terceiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID' variable='retorno.NUM_NOTA_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_FISCAL'  value='#arguments.NUM_NOTA_FISCAL#'  null='#iif(len(trim(arguments.NUM_NOTA_FISCAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_MODELO'  value='#arguments.COD_MODELO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUBSERIE'  value='#arguments.SUBSERIE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NATUREZA_ID'  value='#arguments.NATUREZA_ID#'  null='#iif(len(trim(arguments.NATUREZA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_DESCRICAO'  value='#arguments.NATUREZA_DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTRADA'  value='#arguments.DATA_ENTRADA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_EMITENTE'  value='#arguments.COD_EMITENTE#'  null='#iif(len(trim(arguments.COD_EMITENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_RAZAO_SOCIAL'  value='#arguments.EMIT_RAZAO_SOCIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_ENDERECO'  value='#arguments.EMIT_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_BAIRRO'  value='#arguments.EMIT_BAIRRO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_MUNICIPIO'  value='#arguments.EMIT_MUNICIPIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_UF'  value='#arguments.EMIT_UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_CEP'  value='#arguments.EMIT_CEP#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_TELEFONE'  value='#arguments.EMIT_TELEFONE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_CNPJ_CPF'  value='#arguments.EMIT_CNPJ_CPF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_INSCRICAO_ESTADUAL'  value='#arguments.EMIT_INSCRICAO_ESTADUAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CLIENTE'  value='#arguments.COD_CLIENTE#'  null='#iif(len(trim(arguments.COD_CLIENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NF_IMPOSTO_ID'  value='#arguments.NF_IMPOSTO_ID#'  null='#iif(len(trim(arguments.NF_IMPOSTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_BASE_ICMS'  value='#arguments.CALC_BASE_ICMS#'  null='#iif(len(trim(arguments.CALC_BASE_ICMS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_ICMS'  value='#arguments.CALC_VALOR_ICMS#'  null='#iif(len(trim(arguments.CALC_VALOR_ICMS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_BASE_ICMS_SUBST'  value='#arguments.CALC_BASE_ICMS_SUBST#'  null='#iif(len(trim(arguments.CALC_BASE_ICMS_SUBST)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_ICMS_SUBST'  value='#arguments.CALC_VALOR_ICMS_SUBST#'  null='#iif(len(trim(arguments.CALC_VALOR_ICMS_SUBST)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_TOTAL_PRODUTOS'  value='#arguments.CALC_VALOR_TOTAL_PRODUTOS#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_PRODUTOS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_FRETE'  value='#arguments.CALC_VALOR_FRETE#'  null='#iif(len(trim(arguments.CALC_VALOR_FRETE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_SEGURO'  value='#arguments.CALC_VALOR_SEGURO#'  null='#iif(len(trim(arguments.CALC_VALOR_SEGURO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_OUTRAS_DESPESAS'  value='#arguments.CALC_OUTRAS_DESPESAS#'  null='#iif(len(trim(arguments.CALC_OUTRAS_DESPESAS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_TOTAL_IPI'  value='#arguments.CALC_VALOR_TOTAL_IPI#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_IPI)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_TOTAL_NOTA'  value='#arguments.CALC_VALOR_TOTAL_NOTA#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_NOTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_FISCAL'  value='#arguments.OBSERVACAO_FISCAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_USUARIO'  value='#arguments.OBSERVACAO_USUARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONFERIDA'  value='#arguments.CONFERIDA#'  null='#iif(len(trim(arguments.CONFERIDA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_CONTABIL'  value='#arguments.COD_CONTABIL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INCLUIR_SISS'  value='#arguments.INCLUIR_SISS#'  null='#iif(len(trim(arguments.INCLUIR_SISS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SERVICO_DES'  value='#arguments.COD_SERVICO_DES#'  null='#iif(len(trim(arguments.COD_SERVICO_DES)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_SISS_ID'  value='#arguments.NATUREZA_SISS_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_AVISTA_APRAZO'  value='#arguments.AVISTA_APRAZO#'  null='#iif(len(trim(arguments.AVISTA_APRAZO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ORGANIZACIONAL_ID_GERENCIAL'  value='#arguments.ORGANIZACIONAL_ID_GERENCIAL#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID_GERENCIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_DESCONTO'  value='#arguments.CALC_VALOR_DESCONTO#'  null='#iif(len(trim(arguments.CALC_VALOR_DESCONTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                
                <!---Itens--->
                <cfloop list="#arguments.PEDIDO_ITEM_ID#" index="i" delimiters=";">
                	<cfscript>
						set_pedido_item = this.ins_nf_terceiro_pedido_item(num_nota_id 	  = retorno.NUM_NOTA_ID,
																		   pedido_item_id = ListGetAt(i, 1, '_'),
																		   quantidade	  = ListGetAt(i, 2, '_'));
					</cfscript>
                    <cfif set_pedido_item.erro>
                    	<cfthrow object="#set_pedido_item.mensagem#">
                    </cfif>
                </cfloop>
                
                <!---Impostos--->
                <cfscript>
					v_imposto_id = this.ListaToArray(lista=arguments,variavel="IMPOSTO_ID_ITENS_IMPOSTO");
					v_imposto_reducao_base = this.ListaToArray(lista=arguments,variavel="IMPOSTO_REDUCAO_BASE_ITENS_IMPOSTO");
					v_imposto_base_calculo = this.ListaToArray(lista=arguments,variavel="IMPOSTO_BASE_CALCULO_ITENS_IMPOSTO");
					v_imposto_aliquota = this.ListaToArray(lista=arguments,variavel="IMPOSTO_ALIQUOTA_ITENS_IMPOSTO");
					v_imposto_total = this.ListaToArray(lista=arguments,variavel="IMPOSTO_TOTAL_ITENS_IMPOSTO");
					v_imposto_data_vencimento = this.ListaToArray(lista=arguments,variavel="IMPOSTO_DATA_VENCIMENTO_ITENS_IMPOSTO");
					v_imposto_retido_fonte = this.ListaToArray(lista=arguments,variavel="IMPOSTO_RETIDO_FONTE_ITENS_IMPOSTO");
				</cfscript>
                <cfloop from="1" to="#ArrayLen(v_imposto_id)#" index="count">
					<cfscript>
                        set_impostos = this.ins_nf_terceiro_imposto(NUM_NOTA_ID = retorno.NUM_NOTA_ID
                                                                   ,IMPOSTO_ID = v_imposto_id[count]
                                                                   ,IMPOSTO_REDUCAO_BASE = v_imposto_reducao_base[count]
                                                                   ,IMPOSTO_BASE_CALCULO = v_imposto_base_calculo[count]
                                                                   ,IMPOSTO_ALIQUOTA = v_imposto_aliquota[count]
                                                                   ,IMPOSTO_TOTAL = v_imposto_total[count]
                                                                   ,DATA_VENCIMENTO = v_imposto_data_vencimento[count]
                                                                   ,IMPOSTO_RETIDO_FONTE = v_imposto_retido_fonte[count]);				
                    </cfscript>      
                    <cfif set_impostos.erro>
                    	<cfthrow object="#set_impostos.mensagem#">
                    </cfif>
                </cfloop>     
                
                <!---Rateio--->
                <cfscript>
					v_apelido = this.ListaToArray(lista=arguments,variavel="APELIDO_RATEIO");
					v_cod_contabil_rateio = this.ListaToArray(lista=arguments,variavel="COD_CONTABIL_RATEIO_RATEIO");
					v_historico = this.ListaToArray(lista=arguments,variavel="HISTORICO_RATEIO");
					v_cod_centro_custo_rateio = this.ListaToArray(lista=arguments,variavel="COD_CENTRO_CUSTO_RATEIO_RATEIO");
					v_centro_custo_rateio = this.ListaToArray(lista=arguments,variavel="CENTRO_CUSTO_RATEIO_RATEIO");
					v_percentual_rateio = this.ListaToArray(lista=arguments,variavel="PERCENTUAL_RATEIO_RATEIO");
					v_valor_rateio = this.ListaToArray(lista=arguments,variavel="VALOR_RATEIO_RATEIO");
					v_cod_pessoa_rateio = this.ListaToArray(lista=arguments,variavel="COD_PESSOA_RATEIO_RATEIO");
					v_cod_departamento_rateio = this.ListaToArray(lista=arguments,variavel="COD_DEPARTAMENTO_RATEIO_RATEIO");
					v_cod_setor_rateio = this.ListaToArray(lista=arguments,variavel="COD_SETOR_RATEIO_RATEIO");
					v_organizacional_id_gerencial = this.ListaToArray(lista=arguments,variavel="ORGANIZACIONAL_ID_GERENCIAL_RATEIO_RATEIO");
				</cfscript>
                
                <cfloop from="1" to="#ArrayLen(v_percentual_rateio)#" index="count">
                	<cfscript>
						set_rateio = this.ins_nf_terceiro_rateio(NUM_NOTA_ID = retorno.NUM_NOTA_ID
																,COD_PESSOA = v_cod_pessoa_rateio[count]
																,COD_DEPARTAMENTO = v_cod_departamento_rateio[count]
																,COD_SETOR = v_cod_setor_rateio[count]
																,COD_CENTRO_CUSTO = v_cod_centro_custo_rateio[count]
																,COD_CONTABIL = v_cod_contabil_rateio[count]
																,PERC_RATEIO = v_percentual_rateio[count]
																,VALOR_RATEIO = v_valor_rateio[count]
																,ORGANIZACIONAL_ID_GERENCIAL = v_organizacional_id_gerencial[count]
																,MANUAL = arguments.MANUAL);
					</cfscript>
                    <cfif set_rateio.erro>
                    	<cfthrow object="#set_rateio.mensagem#">
                    </cfif>
                </cfloop>
                
                <!---Contas a Pagar--->
                <cfscript>
					v_contas_pagar_id = this.ListaToArray(lista=arguments,variavel="CONTAS_PAGAR_ID_FATURAMENTO");
					v_fat_num_docto = this.ListaToArray(lista=arguments,variavel="FAT_NUM_DOCTO_FATURAMENTO");
					v_fat_data_vencto = this.ListaToArray(lista=arguments,variavel="FAT_DATA_VENCTO_FATURAMENTO");
					v_fat_valor_docto = this.ListaToArray(lista=arguments,variavel="FAT_VALOR_DOCTO_FATURAMENTO");
					v_fat_num_historico = this.ListaToArray(lista=arguments,variavel="FAT_NUM_HISTORICO_FATURAMENTO");
					v_fat_historico = this.ListaToArray(lista=arguments,variavel="FAT_HISTORICO_FATURAMENTO");
					v_fat_tipo_pagto = this.ListaToArray(lista=arguments,variavel="FAT_TIPO_PAGTO_FATURAMENTO");
					v_fat_docto_id = this.ListaToArray(lista=arguments,variavel="FAT_DOCTO_ID_FATURAMENTO");				
					v_fat_caixa_id = this.ListaToArray(lista=arguments,variavel="CAIXA_ID_FATURAMENTO");
					v_parcela = 1;
                    conn = CreateComponent("_transportes.manipulacao.cfc_caixa");
				</cfscript>
	                
                <cfloop from="1" to="#ArrayLen(v_fat_num_docto)#" index="count">
                	<cfscript>
						set_contas_pagar  = this.ins_nft_contas_pagar(NUM_NOTA_ID = retorno.NUM_NOTA_ID
																	 ,CONTAS_PAGAR_ID = v_contas_pagar_id[count]
																	 ,DOCTO_ID = v_fat_docto_id[count]
																	 ,NUM_DOCTO = v_fat_num_docto[count]
																	 ,PARC_DOCTO = v_parcela
																	 ,COD_HISTORICO = v_fat_num_historico[count]
																	 ,BANCO_ID = ''
																	 ,AGENCIA_ID = ''
																	 ,CONTA = ''
																	 ,TIPO_PAGTO_ID = v_fat_tipo_pagto[count]
																	 ,DATA_EMISSAO = arguments.DATA_EMISSAO
																	 ,DATA_VENCTO = v_fat_data_vencto[count]
																	 ,VALOR_DOCTO = v_fat_valor_docto[count]
																	 ,CODIGO_BARRAS = ''
																	 ,COMENTARIO = arguments.OBSERVACAO_USUARIO);				
						v_parcela = v_parcela + 1;
					</cfscript>
                    <cfif set_contas_pagar.erro>
                    	<cfthrow object="#set_contas_pagar.mensagem#">
                    </cfif>       
                    
                    <cfloop from="1" to="#ArrayLen(v_percentual_rateio)#" index="cr">
                        <cfscript>
						   set_rateio = conn.ins_finan_contas_pagar_rateio(CONTAS_PAGAR_ID = set_contas_pagar.CONTAS_PAGAR_ID
																		  ,COD_PESSOA = v_cod_pessoa_rateio[cr]
																		  ,COD_DEPARTAMENTO = v_cod_departamento_rateio[cr]
																		  ,COD_SETOR = v_cod_setor_rateio[cr]
																		  ,COD_CENTRO_CUSTO = v_cod_centro_custo_rateio[cr]
																		  ,PERC_RATEIO = v_percentual_rateio[cr]
																		  ,VALOR_RATEIO = v_fat_valor_docto[count]*(v_percentual_rateio[cr]/100));
                        </cfscript>
                        <cfif set_rateio.erro>
                            <cfthrow object="#set_rateio.mensagem#">
                        </cfif>
                    </cfloop>                             

					<!---Pagamento--->
                    <cfif Len(Trim(v_fat_caixa_id[count])) and v_fat_tipo_pagto[count] eq 1>
                        <cfscript>
                            set_pagto = conn.ins_pagto_caixa(contas_pagar_id  = set_contas_pagar.CONTAS_PAGAR_ID
                                                            ,num_recibo = ''
                                                            ,data_amortizacao = arguments.DATA_EMISSAO
															,valor_amortizacao = v_fat_valor_docto[count]
															,TIPO_PAGTO_ID = v_fat_tipo_pagto[count]
															,COD_HISTORICO = v_fat_historico[count]
															,CAIXA_ID = v_fat_caixa_id[count]
															,COD_PESSOA_PAGAMENTO = arguments.COD_EMITENTE);
															
                        </cfscript>

						<cfif set_pagto.erro>
                            <cfthrow object="#set_pagto.mensagem#">
                        </cfif>                
                    </cfif>
                </cfloop>
                
                <!--- Ajusta os valores de acordo com o reajuste aplicado --->
				<cfscript>
                    set_ajusta_valores = this.ajusta_valores_nf_terceiro(NUM_NOTA_ID = retorno.NUM_NOTA_ID);
                </cfscript>
                <cfif set_ajusta_valores.erro>
                    <cfthrow object="#set_ajusta_valores.mensagem#">
                </cfif>
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Nota fiscal inserida com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
	
	<!--- 
	-- PROPSITO
	-- Vincula um item de pedido a uma nota fiscal
	-- ANDERSONC 21/01/2010 - ALTERADO
	--->
	<cffunction name='ins_nf_terceiro_pedido_item' displayname='Vincula um item de pedido a uma nota fiscal' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='PEDIDO_ITEM_ID' required='yes'>
        <cfargument name='QUANTIDADE' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_ins_nf_terc_pedido_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PEDIDO_ITEM_ID'  value='#arguments.PEDIDO_ITEM_ID#'  null='#iif(len(trim(arguments.PEDIDO_ITEM_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Item de pedido vinculado com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Ajusta os valores de uma nota fiscal de fornecedor
	-- ANDERSONC 18/01/2010 16:24:27 - CRIADO
	--->
	<cffunction name='ajusta_valores_nf_terceiro' displayname='Ajusta os valores de uma nota fiscal de fornecedor' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_ajusta_valores_nf_terceiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Valores ajustados com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere nota fiscal de ES
	-- guto 10/02/2007 10:11:33 - CRIADO
	--->
	<cffunction name='ins_nota_fiscal_es_embalagem' displayname='Insere nota fiscal de ES' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='NUM_NOTA_FISCAL' required='yes'>
		<cfargument name='COD_MODELO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='SUBSERIE' required='yes'>
		<cfargument name='E_S' required='yes'>
		<cfargument name='SERVICO' required='yes'>
		<cfargument name='INSCRICAO_ESTADUAL_SUBSTITUT' required='no' default="">
		<cfargument name='NATUREZA_ID' required='yes'>
		<cfargument name='NATUREZA_DESCRICAO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='DATA_ES' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='DEST_RAZAO_SOCIAL' required='yes'>
		<cfargument name='DEST_ENDERECO' required='yes'>
		<cfargument name='DEST_BAIRRO' required='yes'>
		<cfargument name='DEST_MUNICIPIO' required='yes'>
		<cfargument name='DEST_UF' required='yes'>
		<cfargument name='DEST_CEP' required='yes'>
		<cfargument name='DEST_TELEFONE' required='yes'>
		<cfargument name='DEST_CNPJ_CPF' required='yes'>
		<cfargument name='DEST_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='NF_IMPOSTO_ID' required='no' default="">
		<cfargument name='SERV_TOTAL_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_NAO_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_NOTA' required='yes'>
		<cfargument name='SERV_ISS_ALIQUOTA' required='yes'>
		<cfargument name='SERV_ISS_DEDUCAO' required='yes'>
		<cfargument name='SERV_ISS_VALOR' required='yes'>
		<cfargument name='CALC_BASE_ICMS' required='no' default="0">
		<cfargument name='CALC_VALOR_ICMS' required='no' default="0">
		<cfargument name='CALC_BASE_ICMS_SUBST' required='no' default="0">
		<cfargument name='CALC_VALOR_ICMS_SUBST' required='no' default="0">
		<cfargument name='CALC_VALOR_TOTAL_PRODUTOS' required='no' default="0">
		<cfargument name='CALC_VALOR_FRETE' required='no' default="0">
		<cfargument name='CALC_VALOR_SEGURO' required='no' default="0">
		<cfargument name='CALC_OUTRAS_DESPESAS' required='no' default="0">
		<cfargument name='CALC_VALOR_TOTAL_IPI' required='no' default="0">
		<cfargument name='CALC_VALOR_TOTAL_NOTA' required='yes'>
		<cfargument name='COD_TRANSPORTADOR' required='no' default="">
		<cfargument name='TRP_RAZAO_SOCIAL' required='no' default="">
		<cfargument name='TRP_ENDERECO' required='no' default="">
		<cfargument name='TRP_MUNICIPIO' required='no' default="">
		<cfargument name='TRP_UF' required='no' default="">
		<cfargument name='TRP_CNPJ_CPF' required='no' default="">
		<cfargument name='TRP_INSCRICAO_ESTADUAL' required='no' default="">
		<cfargument name='TRP_PLACA' required='no' default="">
		<cfargument name='TRP_PLACA_UF' required='no' default="1">
		<cfargument name='TRP_FRETE_POR' required='no' default="1">
		<cfargument name='TRP_QUANTIDADE' required='no' default="">
		<cfargument name='TRP_ESPECIE' required='no' default="">
		<cfargument name='TRP_MARCA' required='no' default="">
		<cfargument name='TRP_NUMERO' required='no' default="">
		<cfargument name='TRP_PESO_BRUTO' required='no' default="0">
		<cfargument name='TRP_PESO_LIQUIDO' required='no' default="0">
		<cfargument name='INFO_COMPLEMENTARES' required='yes'>
		<cfargument name='RESERVADO_FISCO' required='no' default="Este campo destina-se a preencher o campo Reservado ao Fisco da nota fiscal de E/S, quando da insero da mesma.">
		<cfargument name='OBSERVACAO_FISCAL' required='no' default="">
		<cfargument name='OBSERVACAO_USUARIO' required='no' default="">
		<cfargument name='CONVERSAO_TAXA' required='no' default="">



		<cfargument name='EMITIDA' required='no' default="0">
		<cfargument name='MANUAL' required='no' default="1">
		<cfargument name='CONVERSAO_MOEDA' required='no' default="790">
		<cfargument name='TIPO_RECOLHIMENTO_ISS' required='yes'>
		<cfargument name='COD_SERVICO_DES' required='no' default="">
		<cfargument name='NATUREZA_SISS_ID' required='no' default="">
		<cfargument name='INCLUIR_SISS' required='no' default="1">
		<cfargument name='AVISTA_APRAZO' required='yes'>
		<cfargument name='DATA_VENCTO' required='yes'>
        <cfargument name='CONTABILIZA' required='no' default="1">
        
        <cfargument name='PONTO_ESTOQUE_ENTRADA' required='yes'>
		<cfargument name='PONTO_ESTOQUE_SAIDA' required='yes'>
        
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_nf_es.prc_ins_nf_es_manual' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#' variable='retorno.NUM_NOTA_ID'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_FISCAL'  value='#arguments.NUM_NOTA_FISCAL#'  null='#iif(len(trim(arguments.NUM_NOTA_FISCAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_MODELO'  value='#arguments.COD_MODELO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUBSERIE'  value='#arguments.SUBSERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_E_S'  value='#arguments.E_S#'  null='#iif(len(trim(arguments.E_S)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERVICO'  value='#arguments.SERVICO#'  null='#iif(len(trim(arguments.SERVICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INSCRICAO_ESTADUAL_SUBSTITUT'  value='#arguments.INSCRICAO_ESTADUAL_SUBSTITUT#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NATUREZA_ID'  value='#arguments.NATUREZA_ID#'  null='#iif(len(trim(arguments.NATUREZA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_DESCRICAO'  value='#arguments.NATUREZA_DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ES'  value='#arguments.DATA_ES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_RAZAO_SOCIAL'  value='#arguments.DEST_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_ENDERECO'  value='#arguments.DEST_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_BAIRRO'  value='#arguments.DEST_BAIRRO#' >

					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_MUNICIPIO'  value='#arguments.DEST_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_UF'  value='#arguments.DEST_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CEP'  value='#arguments.DEST_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_TELEFONE'  value='#arguments.DEST_TELEFONE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CNPJ_CPF'  value='#arguments.DEST_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_INSCRICAO_ESTADUAL'  value='#arguments.DEST_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NF_IMPOSTO_ID'  value='#arguments.NF_IMPOSTO_ID#'  null='#iif(len(trim(arguments.NF_IMPOSTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_TRIBUTAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_NAO_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_NAO_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_NAO_TRIBUTAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_NOTA'  value='#arguments.SERV_TOTAL_NOTA#'  null='#iif(len(trim(arguments.SERV_TOTAL_NOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_ALIQUOTA'  value='#arguments.SERV_ISS_ALIQUOTA#'  null='#iif(len(trim(arguments.SERV_ISS_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_DEDUCAO'  value='#arguments.SERV_ISS_DEDUCAO#'  null='#iif(len(trim(arguments.SERV_ISS_DEDUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_VALOR'  value='#arguments.SERV_ISS_VALOR#'  null='#iif(len(trim(arguments.SERV_ISS_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_BASE_ICMS'  value='#arguments.CALC_BASE_ICMS#'  null='#iif(len(trim(arguments.CALC_BASE_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_ICMS'  value='#arguments.CALC_VALOR_ICMS#'  null='#iif(len(trim(arguments.CALC_VALOR_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_BASE_ICMS_SUBST'  value='#arguments.CALC_BASE_ICMS_SUBST#'  null='#iif(len(trim(arguments.CALC_BASE_ICMS_SUBST)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_ICMS_SUBST'  value='#arguments.CALC_VALOR_ICMS_SUBST#'  null='#iif(len(trim(arguments.CALC_VALOR_ICMS_SUBST)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_TOTAL_PRODUTOS'  value='#arguments.CALC_VALOR_TOTAL_PRODUTOS#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_PRODUTOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_FRETE'  value='#arguments.CALC_VALOR_FRETE#'  null='#iif(len(trim(arguments.CALC_VALOR_FRETE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_SEGURO'  value='#arguments.CALC_VALOR_SEGURO#'  null='#iif(len(trim(arguments.CALC_VALOR_SEGURO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_OUTRAS_DESPESAS'  value='#arguments.CALC_OUTRAS_DESPESAS#'  null='#iif(len(trim(arguments.CALC_OUTRAS_DESPESAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_TOTAL_IPI'  value='#arguments.CALC_VALOR_TOTAL_IPI#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_IPI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_TOTAL_NOTA'  value='#arguments.CALC_VALOR_TOTAL_NOTA#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_NOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_TRANSPORTADOR'  value='#arguments.COD_TRANSPORTADOR#'  null='#iif(len(trim(arguments.COD_TRANSPORTADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_RAZAO_SOCIAL'  value='#arguments.TRP_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_ENDERECO'  value='#arguments.TRP_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_MUNICIPIO'  value='#arguments.TRP_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_UF'  value='#arguments.TRP_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_CNPJ_CPF'  value='#arguments.TRP_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_INSCRICAO_ESTADUAL'  value='#arguments.TRP_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_PLACA'  value='#arguments.TRP_PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_PLACA_UF'  value='#arguments.TRP_PLACA_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TRP_FRETE_POR'  value='#arguments.TRP_FRETE_POR#'  null='#iif(len(trim(arguments.TRP_FRETE_POR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TRP_QUANTIDADE'  value='#arguments.TRP_QUANTIDADE#'  null='#iif(len(trim(arguments.TRP_QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_ESPECIE'  value='#arguments.TRP_ESPECIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_MARCA'  value='#arguments.TRP_MARCA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_NUMERO'  value='#arguments.TRP_NUMERO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TRP_PESO_BRUTO'  value='#arguments.TRP_PESO_BRUTO#'  null='#iif(len(trim(arguments.TRP_PESO_BRUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TRP_PESO_LIQUIDO'  value='#arguments.TRP_PESO_LIQUIDO#'  null='#iif(len(trim(arguments.TRP_PESO_LIQUIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INFO_COMPLEMENTARES'  value='#arguments.INFO_COMPLEMENTARES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESERVADO_FISCO'  value='#arguments.RESERVADO_FISCO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_FISCAL'  value='#arguments.OBSERVACAO_FISCAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_USUARIO'  value='#REReplace(arguments.OBSERVACAO_USUARIO,'','-')#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONVERSAO_TAXA'  value='#arguments.CONVERSAO_TAXA#'  null='#iif(len(trim(arguments.CONVERSAO_TAXA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_EMITIDA'  value='#arguments.EMITIDA#'  null='#iif(len(trim(arguments.EMITIDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MANUAL'  value='#arguments.MANUAL#'  null='#iif(len(trim(arguments.MANUAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONVERSAO_MOEDA'  value='#arguments.CONVERSAO_MOEDA#'  null='#iif(len(trim(arguments.CONVERSAO_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_RECOLHIMENTO_ISS'  value='#arguments.TIPO_RECOLHIMENTO_ISS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_SERVICO_DES'  value='#arguments.COD_SERVICO_DES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_SISS_ID'  value='#arguments.NATUREZA_SISS_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INCLUIR_SISS'  value='#arguments.INCLUIR_SISS#'  null='#iif(len(trim(arguments.INCLUIR_SISS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_AVISTA_APRAZO'  value='#arguments.AVISTA_APRAZO#'  null='#iif(len(trim(arguments.AVISTA_APRAZO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='CONTABILIZA'  value='#arguments.CONTABILIZA#'  null='#iif(len(trim(arguments.CONTABILIZA)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				
                <cfscript>
				 v_num_nota_id = retorno.NUM_NOTA_ID;
				</cfscript>
                
				<!---Insere Embalagens--->
                
                <!---Criao das Variveis--->
                <cfscript>
                	v_embalagem_id   	= this.ListaToArray(lista = arguments, variavel = 'EMBALAGEM_ID_EMBALAGENS');
					v_numero_embalagem  = this.ListaToArray(lista = arguments, variavel = 'NUMERO_EMBALAGEM');
					v_quantidade   		= this.ListaToArray(lista = arguments, variavel = 'QUANTIDADE_EMBALAGENS');
					v_tipo_embalagem_id = this.ListaToArray(lista = arguments, variavel = 'TIPO_EMBALAGEM_ID_EMBALAGENS');
					v_controlada		= this.ListaToArray(lista = arguments, variavel = 'CONTROLADA_EMBALAGENS');
					v_valor				= this.ListaToArray(lista = arguments, variavel = 'VALOR_EMBALAGENS');
				</cfscript>
                
                <cfscript>
					conn_manip = CreateComponent("_transportes.manipulacao.transporte.cfc_embalagens");
					conn	   = CreateComponent("_transportes.consulta.transporte.cfc_embalagens");
				</cfscript>
                
                <!---Insere agrupamento--->
                <cfscript>
					retorno = conn_manip.ins_movimentacao_agrup(MOVIMENTACAO_TIPO_ID     = arguments.MOVIMENTACAO_TIPO
															   ,DATA_MOVIMENTACAO        = arguments.DATA_EMISSAO
															   ,COD_CENTRO_CUSTO         = arguments.COD_CENTRO_CUSTO
															   ,PONTO_ESTOQUE_SAIDA_ID   = arguments.PONTO_ESTOQUE_SAIDA
															   ,ESTOQUE_TIPO_SAIDA       = arguments.MOVIMENTACAO_TIPO_SAIDA
															   ,PONTO_ESTOQUE_ENTRADA_ID = arguments.PONTO_ESTOQUE_ENTRADA
															   ,ESTOQUE_TIPO_ENTRADA     = arguments.MOVIMENTACAO_TIPO_ENTRADA
															   ,NUM_NOTA_ID              = retorno.NUM_NOTA_ID
															   );
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
                <!---Gera Movimentaes das Embalagens--->
                <cfif arguments.ENTRADA eq 0>
                	<cfif arguments.MOVIMENTACAO_TIPO_ENTRADA eq 1> <!--estoque-->
                		<cfloop from="1" to="#ArrayLen(v_embalagem_id)#" index="count">
                            <!---Insere transferncia--->
                            <cfscript>
                                ret_estoque = conn_manip.ins_transf_filial(TIPO_EMBALAGEM_ID 	 = v_tipo_embalagem_id[count]
                                                                          ,MOVIMENTACAO_AGRUP_ID = retorno.MOVIMENTACAO_AGRUPAMENTO_ID
																		  );
                            </cfscript>
                            <cfif ret_estoque.erro>
                                <cfthrow object="#ret_estoque.mensagem#">
                            </cfif>
                            
                            <cfif v_controlada[count] eq 1>
                                <cfscript>
                                    ret = conn_manip.ins_transf_filial_it(TRANSFERENCIA_FILIAL_ID = ret_estoque.TRANSFERENCIA_FILIAL_ID
                                                                         ,EMBALAGEM_ID     		  = v_embalagem_id[count]
                                                                         ,QUANTIDADE 	   		  = 1
                                                                         ,VALOR 		   		  = v_valor[count]
																	     );
                                </cfscript>
                                <cfif ret.erro>
                                    <cfthrow object="#ret.mensagem#">
                                </cfif>
                            <cfelse>
                                <cfscript>
                                    ret = conn_manip.ins_transf_filial_it(TRANSFERENCIA_FILIAL_ID = ret_estoque.TRANSFERENCIA_FILIAL_ID
                                                                    	 ,EMBALAGEM_ID     		  = ''
																		 ,QUANTIDADE 	   		  = v_quantidade[count]
                                                                      	 ,VALOR 		   		  = v_valor[count]
																		 );								
                                </cfscript>
                                <cfif ret.erro>
                                    <cfthrow object="#ret.mensagem#">
                                </cfif>
                            </cfif>
                        </cfloop>
                        
					<cfelseif arguments.MOVIMENTACAO_TIPO_ENTRADA eq 2> <!--Cliente-->
                        <cfloop from="1" to="#ArrayLen(v_embalagem_id)#" index="count">
                            <!---Insere transferncia--->
                            <cfscript>
                                ret_transf = conn_manip.ins_transferencia_cliente(TIPO_EMBALAGEM_ID 	= v_tipo_embalagem_id[count]
                                                                            	 ,MOVIMENTACAO_AGRUP_ID = retorno.MOVIMENTACAO_AGRUPAMENTO_ID
																				 );
                            </cfscript>
                            <cfif ret_transf.erro>
                                <cfthrow object="#ret_transf.mensagem#">
                            </cfif>
                            
                            <cfif v_controlada[count] eq 1>
                                <cfscript>
                                    ret = conn_manip.ins_transf_cliente_it(TRANSFERENCIA_ID = ret_transf.TRANSFERENCIA_ID
                                                                          ,EMBALAGEM_ID     = v_embalagem_id[count]
                                                                          ,QUANTIDADE 	    = 1
                                                                          ,VALOR 		    = v_valor[count]
																		  );
                                </cfscript>
                                <cfif ret.erro>
                                    <cfthrow object="#ret.mensagem#">
                                </cfif>
                            <cfelse>
                                <cfscript>
                                    ret = conn_manip.ins_transf_cliente_it(TRANSFERENCIA_ID = ret_transf.TRANSFERENCIA_ID
                                                                    	  ,EMBALAGEM_ID     = ''
																		  ,QUANTIDADE 	    = v_quantidade[count]
                                                                      	  ,VALOR 			= v_valor[count]);								
                                </cfscript>
                                <cfif ret.erro>
                                    <cfthrow object="#ret.mensagem#">
                                </cfif>
                            </cfif>
                        </cfloop>
                        
					<cfelseif arguments.MOVIMENTACAO_TIPO_ENTRADA eq 3>  <!--Reformadora-->
                    	<cfloop from="1" to="#ArrayLen(v_embalagem_id)#" index="count">
                            <!---Insere transferncia--->
                            
                            <cfscript>
								qrReformadora = conn.get_reformadora(ponto_estoque_id = arguments.PONTO_ESTOQUE_ENTRADA);
                                ret_ref	  	  = conn_manip.ins_envio_reforma(TIPO_EMBALAGEM_ID     = v_tipo_embalagem_id[count]
															    	  	    ,REFORMADORA_ID    	   = qrReformadora.REFORMADORA_ID
																			,MOVIMENTACAO_AGRUP_ID = retorno.MOVIMENTACAO_AGRUPAMENTO_ID
															    	  		);
							</cfscript>
                            
                            
                            <cfif ret_ref.erro>
                                <cfthrow object="#ret_ref.mensagem#">
                            </cfif>
                            <cfif v_controlada[count] eq 1>
                                <cfscript>
									ret = conn_manip.ins_embalagem_reforma(EMBALAGEM_ID = v_embalagem_id[count]
																		  ,REFORMA_ID	= ret_ref.REFORMA_ID
																		  ,QUANTIDADE	= 1
																		  ,DATA_ENTRADA	= arguments.DATA_ES
																		  ,DATA_SAIDA	= ''
																		  ,OBSERVACAO	= arguments.OBSERVACAO_USUARIO
																		  );   
                                </cfscript>
                                <cfif ret.erro>
                                    <cfthrow object="#ret.mensagem#">
                                </cfif>
                            <cfelse>
                                <cfscript>
									ret = conn_manip.ins_embalagem_reforma(EMBALAGEM_ID = ''
																		  ,REFORMA_ID	= ret_ref.REFORMA_ID
															        	  ,QUANTIDADE	= v_quantidade[count]
																    	  ,DATA_ENTRADA	= arguments.DATA_ES
																    	  ,DATA_SAIDA	= ''
																		  ,OBSERVACAO	= arguments.OBSERVACAO_USUARIO
																		  );			
                                </cfscript>
                                <cfif ret.erro>
                                    <cfthrow object="#ret.mensagem#">
                                </cfif>
                            </cfif>
                        </cfloop>
                    </cfif>
                <cfelse>
                	<cfloop from="1" to="#ArrayLen(v_embalagem_id)#" index="count"> 
						<cfif v_controlada[count] eq 1>
							<cfscript>
                                ret = conn_manip.ins_entrada_embalagem_nf(TIPO_EMBALAGEM_ID 	= v_tipo_embalagem_id[count]
																		 ,NUM_EMBALAGEM 		= v_numero_embalagem[count]
																		 ,MOVIMENTACAO_AGRUP_ID = retorno.MOVIMENTACAO_AGRUPAMENTO_ID
																		 ,VALOR 			    = v_valor[count]
																		 );
                            </cfscript>
                            <cfif ret.erro>
                                <cfthrow object="#ret.mensagem#">
                            </cfif>
                        <cfelse>
                        	<cfscript>
                                ret = conn_manip.ins_entrada_embalagem_nf(TIPO_EMBALAGEM_ID 	= v_tipo_embalagem_id[count]
																		 ,NUM_EMBALAGEM 		= v_quantidade[count]
																		 ,MOVIMENTACAO_AGRUP_ID = retorno.MOVIMENTACAO_AGRUPAMENTO_ID
																		 ,VALOR 				= v_valor[count]
																		 );
                            </cfscript>
                            <cfif ret.erro>
                                <cfthrow object="#ret.mensagem#">
                            </cfif>
                        </cfif>
                    </cfloop>
                </cfif>
                
                <!---Gera Itens--->
                <cfscript>
						retorno = this.ins_nf_es_it_embalagem(MOVIMENTACAO_AGRUPAMENTO_ID  = retorno.MOVIMENTACAO_AGRUPAMENTO_ID
															 ,CFOP        				   = arguments.CFOP
															 ,CFOP_ID					   = arguments.CFOP_ID)
															 ;
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
                <cfscript>
					V_IMPOSTO_ID 				= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_ID_ITENS_IMPOSTO");
					V_NF_IMPOSTO_ID 			= this.ListaToArray(lista = arguments, variavel = "NF_IMPOSTO_ID_ITENS_IMPOSTO");
					V_IMPOSTO_REDUCAO_BASE 		= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_REDUCAO_BASE_ITENS_IMPOSTO");
					V_IMPOSTO_BASE_CALCULO 		= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_BASE_CALCULO_ITENS_IMPOSTO");
					V_IMPOSTO_ALIQUOTA 			= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_ALIQUOTA_ITENS_IMPOSTO");
					V_IMPOSTO_TOTAL 			= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_TOTAL_ITENS_IMPOSTO");
					V_IMPOSTO_DATA_VENCIMENTO 	= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_DATA_VENCIMENTO_ITENS_IMPOSTO");
					V_IMPOSTO_RETIDO_FONTE 		= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_RETIDO_FONTE_ITENS_IMPOSTO");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ITENS_IMPOSTO, lista2 = ArrayToList(V_NF_IMPOSTO_ID));
				</cfscript>	
				<cfloop list="#v_excluir#" index="l_id">
					<cfscript>
						ret = this.del_nf_es_imposto(num_nota_id = v_num_nota_id,
													 nf_imposto_id = l_id);
					</cfscript>
					<cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>				
				</cfloop>
				<cfloop from="1" to="#ArrayLen(V_NF_IMPOSTO_ID)#" index="count">
					<cfscript>
						if(len(trim(V_NF_IMPOSTO_ID[count]))) {
							ret = this.upd_nf_es_imposto(	num_nota_id 			= v_num_nota_id,
															nf_imposto_id 			= v_nf_imposto_id[count],
															imposto_id				= v_imposto_id[count],
															imposto_reducao_base	= v_imposto_reducao_base[count],
															imposto_base_calculo	= v_imposto_base_calculo[count],
															imposto_aliquota		= v_imposto_aliquota[count],
															imposto_total			= v_imposto_total[count],
															imposto_retido_fonte	= v_imposto_retido_fonte[count],
															data_vencimento			= v_imposto_data_vencimento[count]);
						} else {
							ret = this.ins_nf_es_imposto(	num_nota_id 			= v_num_nota_id,
															imposto_id				= v_imposto_id[count],
															imposto_reducao_base	= v_imposto_reducao_base[count],
															imposto_base_calculo	= v_imposto_base_calculo[count],
															imposto_aliquota		= v_imposto_aliquota[count],
															imposto_total			= v_imposto_total[count],
															imposto_retido_fonte	= v_imposto_retido_fonte[count],
															data_vencimento			= v_imposto_data_vencimento[count]);
						}
					</cfscript>	
					<cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>
				</cfloop>
                
                <cfset retorno.num_nota_id = v_num_nota_id>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Nota fiscal inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
   
    <!--- 
	-- PROPSITO
	-- Inseir Item da nota atravs das Embalagens
	-- RAFAEL 17/02/2010 15:48:50 - CRIADO
	--->
	<cffunction name='ins_nf_es_it_embalagem' displayname='Inseir Item da nota atravs das Embalagens' access='remote' returntype='Struct' output='true'>
		<cfargument name='MOVIMENTACAO_AGRUPAMENTO_ID' required='yes'>
		<cfargument name='CFOP' required='yes'>
		<cfargument name='CFOP_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='fiscal.pkg_nf_es.prc_ins_nf_es_it_embalagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUPAMENTO_ID'  value='#arguments.MOVIMENTACAO_AGRUPAMENTO_ID#'  null='#iif(len(trim(arguments.MOVIMENTACAO_AGRUPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CFOP'  value='#arguments.CFOP#'  null='#iif(len(trim(arguments.CFOP)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP_ID'  value='#arguments.CFOP_ID#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Libera o CTRC para impresso
	-- ANDERSONC 05/04/2010 13:47:08 - CRIADO
	--->
	<cffunction name='ctrc_liberado_impressao' displayname='Libera o CTRC para impresso' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_ctrc_liberado_impressao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Conhecimento liberado para impresso com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Estorna a liberao de impresso do CTRC
	-- ANDERSONC 05/04/2010 13:48:30 - CRIADO
	--->
	<cffunction name='ctrc_estorna_liberacao_imp' displayname='Estorna a liberao de impresso do CTRC' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_ctrc_estorna_liberacao_imp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Liberao de impresso estornada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Executa o clculo da tabela de frete para o CTRC
	-- ANDERSONC 20/07/2010 15:40:55 - CRIADO
	--->
	<cffunction name='calcula_ctrc_tabela_frete' displayname='Executa o clculo da tabela de frete para o CTRC' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='TABELA_FRETE_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_calcula_ctrc_tabela_frete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TABELA_FRETE_ID'  value='#arguments.TABELA_FRETE_ID#'  null='#iif(len(trim(arguments.TABELA_FRETE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Executa o clculo da tabela de frete para o CTRC
	-- ANDERSONC 04/08/2010 15:26:41 - CRIADO
	--->
	<cffunction name='calcula_nfes_tabela_frete' displayname='Executa o clculo da tabela de frete para o CTRC' access='remote' returntype='Struct' output='true'>
		<cfargument name='NF_ES_ID' required='yes'>
		<cfargument name='TABELA_FRETE_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_nf_es.prc_calcula_nfes_tabela_frete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_ES_ID'  value='#arguments.NF_ES_ID#'  null='#iif(len(trim(arguments.NF_ES_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TABELA_FRETE_ID'  value='#arguments.TABELA_FRETE_ID#'  null='#iif(len(trim(arguments.TABELA_FRETE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Envia o e-mail de Carga/Descarga de acordo com a operao
	-- ANDERSONC 26/08/2010 13:49:30 - CRIADO
	--->
	<cffunction name='envia_email_operacao' displayname='Envia o e-mail de Carga/Descarga de acordo com a operao' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
        	<cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_envia_email_operacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset v_retorno.erro = false>
                <cfset v_retorno.mensagem = JSStringFormat('E-mail enviado com sucesso.')>
			</cftransaction>
			<cfcatch>
            	<cftransaction action='rollback'/>
				<cfset v_retorno.erro = true>
				<cfset v_retorno.mensagem = cfcatch>
				<cfset v_retorno.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn v_retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Valida a negociao comercial de um CTRC
	-- ANDERSONC 07/10/2010 11:03:23 - CRIADO
	--->
	<cffunction name='valida_ctrc_tabela_frete' displayname='Valida a negociao comercial de um CTRC' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_valida_ctrc_tabela_frete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
    
    
    <!--- 
	-- PROPSITO
	-- Gera o pdf de uma ordem de carregamento
	-- WAGNERS 07/03/2011 10:17:28 - CRIADO
	--->
	<cffunction name='gerar_ordem_carregamento' displayname='Gera o pdf de uma ordem de carregamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ordem_carregamento.prc_gerar_ordem_carregamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB' dbvarname='P_ARQUIVO' variable='retorno.ARQUIVO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ordem de carregamento gerada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Envia ordem de carregamento para lista de e-mails informada
	-- WAGNERS 04/03/2011 15:53:56 - CRIADO
	--->
	<cffunction name='enviar_ordem_carreg_email' displayname='Envia ordem de carregamento para lista de e-mails informada' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='LISTA_EMAILS' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ordem_carregamento.prc_enviar_ordem_carreg_email' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_LISTA_EMAILS'  value='#arguments.LISTA_EMAILS#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('E-mail(s) enviado(s) com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Insere um tipo de conhecimento
	-- WAGNERS 29/03/2011 08:47:59 - CRIADO
	--->
	<cffunction name='ins_conhecimento_tipo' displayname='Insere um tipo de conhecimento' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_conhecimento.prc_ins_conhecimento_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_TIPO_ID' variable='retorno.CONHECIMENTO_TIPO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de conhecimento cadastrado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Altera um tipo de conhecimento
	-- WAGNERS 29/03/2011 08:49:19 - CRIADO
	--->
	<cffunction name='upd_conhecimento_tipo' displayname='Altera um tipo de conhecimento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_TIPO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_conhecimento.prc_alt_conhecimento_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_TIPO_ID'  value='#arguments.CONHECIMENTO_TIPO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de conhecimento alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Exclui um tipo de conhecimento
	-- WAGNERS 29/03/2011 08:50:01 - CRIADO
	--->
	<cffunction name='del_conhecimento_tipo' displayname='Exclui um tipo de conhecimento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_TIPO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_conhecimento.prc_del_conhecimento_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_TIPO_ID'  value='#arguments.CONHECIMENTO_TIPO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_TIPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de conhecimento excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere NFSE
	-- RAFAEL 29/10/2010 15:47:22 - CRIADO
	--->
		<cffunction name='ins_nfse' displayname='Insere NFSE' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='COD_MODELO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='SUBSERIE' required='yes'>
		<cfargument name='E_S' required='yes'>
		<cfargument name='SERVICO' required='yes'>
		<cfargument name='INSCRICAO_ESTADUAL_SUBSTITUT' required='no' default="">
		<cfargument name='NATUREZA_ID' required='yes'>
		<cfargument name='NATUREZA_DESCRICAO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='DATA_ES' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='DEST_RAZAO_SOCIAL' required='yes'>
		<cfargument name='DEST_ENDERECO' required='yes'>
		<cfargument name='DEST_BAIRRO' required='yes'>
		<cfargument name='DEST_MUNICIPIO' required='yes'>
		<cfargument name='DEST_UF' required='yes'>
		<cfargument name='DEST_CEP' required='yes'>
		<cfargument name='DEST_TELEFONE' required='yes'>
		<cfargument name='DEST_CNPJ_CPF' required='yes'>
		<cfargument name='DEST_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='NF_IMPOSTO_ID' required='no' default="">
		<cfargument name='SERV_TOTAL_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_NAO_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_NOTA' required='yes'>
		<cfargument name='SERV_ISS_ALIQUOTA' required='yes'>
		<cfargument name='SERV_ISS_DEDUCAO' required='yes'>
		<cfargument name='SERV_ISS_VALOR' required='yes'>
		<cfargument name='CALC_BASE_ICMS' required='no' default="0">
		<cfargument name='CALC_VALOR_ICMS' required='no' default="0">
		<cfargument name='CALC_BASE_ICMS_SUBST' required='no' default="0">
		<cfargument name='CALC_VALOR_ICMS_SUBST' required='no' default="0">
		<cfargument name='CALC_VALOR_TOTAL_PRODUTOS' required='no' default="0">
		<cfargument name='CALC_VALOR_FRETE' required='no' default="0">
		<cfargument name='CALC_VALOR_SEGURO' required='no' default="0">
		<cfargument name='CALC_OUTRAS_DESPESAS' required='no' default="0">
		<cfargument name='CALC_VALOR_TOTAL_IPI' required='no' default="0">
		<cfargument name='CALC_VALOR_TOTAL_NOTA' required='yes'>
		<cfargument name='COD_TRANSPORTADOR' required='no' default="">
		<cfargument name='TRP_RAZAO_SOCIAL' required='no' default="">
		<cfargument name='TRP_ENDERECO' required='no' default="">
		<cfargument name='TRP_MUNICIPIO' required='no' default="">
		<cfargument name='TRP_UF' required='no' default="">
		<cfargument name='TRP_CNPJ_CPF' required='no' default="">
		<cfargument name='TRP_INSCRICAO_ESTADUAL' required='no' default="">
		<cfargument name='TRP_PLACA' required='no' default="">
		<cfargument name='TRP_PLACA_UF' required='no' default="1">
		<cfargument name='TRP_FRETE_POR' required='no' default="1">
		<cfargument name='TRP_QUANTIDADE' required='no' default="">
		<cfargument name='TRP_ESPECIE' required='no' default="">
		<cfargument name='TRP_MARCA' required='no' default="">
		<cfargument name='TRP_NUMERO' required='no' default="">
		<cfargument name='TRP_PESO_BRUTO' required='no' default="0">
		<cfargument name='TRP_PESO_LIQUIDO' required='no' default="0">
		<cfargument name='INFO_COMPLEMENTARES' required='yes'>
		<cfargument name='RESERVADO_FISCO' required='no' default="Este campo destina-se a preencher o campo Reservado ao Fisco da nota fiscal de E/S, quando da insero da mesma.">
		<cfargument name='OBSERVACAO_FISCAL' required='no' default="">
		<cfargument name='OBSERVACAO_USUARIO' required='no' default="">
		<cfargument name='EMITIDA' required='no' default="0">
		<cfargument name='CANCELADA' required='no' default="0">
		<cfargument name='CONFERIDA' required='no' default="0">
		<cfargument name='CONVERSAO_TAXA' required='no' default="">
		<cfargument name='CONVERSAO_MOEDA' required='no' default="220">
		<cfargument name='INCLUIR_SISS' required='yes'>
		<cfargument name='TIPO_RECOLHIMENTO_ISS' required='yes'>
		<cfargument name='COD_SERVICO_DES' required='no' default="">
		<cfargument name='NATUREZA_SISS_ID' required='no' default="">
		<cfargument name='AVISTA_APRAZO' required='yes'>
		<cfargument name='NATUREZA_OPERACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_nf_es.prc_ins_nf_es' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#' variable='retorno.NUM_NOTA_ID'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_MODELO'  value='#arguments.COD_MODELO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUBSERIE'  value='#arguments.SUBSERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_E_S'  value='#arguments.E_S#'  null='#iif(len(trim(arguments.E_S)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERVICO'  value='#arguments.SERVICO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INSCRICAO_ESTADUAL_SUBSTITUT'  value='#arguments.INSCRICAO_ESTADUAL_SUBSTITUT#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NATUREZA_ID'  value='#arguments.NATUREZA_ID#'  null='#iif(len(trim(arguments.NATUREZA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_DESCRICAO'  value='#arguments.NATUREZA_DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ES'  value='#arguments.DATA_ES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_RAZAO_SOCIAL'  value='#arguments.DEST_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_ENDERECO'  value='#arguments.DEST_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_BAIRRO'  value='#arguments.DEST_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_MUNICIPIO'  value='#arguments.DEST_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_UF'  value='#arguments.DEST_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CEP'  value='#arguments.DEST_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_TELEFONE'  value='#arguments.DEST_TELEFONE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CNPJ_CPF'  value='#arguments.DEST_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_INSCRICAO_ESTADUAL'  value='#arguments.DEST_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_IMPOSTO_ID'  value='#arguments.NF_IMPOSTO_ID#'  null='#iif(len(trim(arguments.NF_IMPOSTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_TOTAL_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_TRIBUTAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_TOTAL_NAO_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_NAO_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_NAO_TRIBUTAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_TOTAL_NOTA'  value='#arguments.SERV_TOTAL_NOTA#'  null='#iif(len(trim(arguments.SERV_TOTAL_NOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_ISS_ALIQUOTA'  value='#arguments.SERV_ISS_ALIQUOTA#'  null='#iif(len(trim(arguments.SERV_ISS_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_ISS_DEDUCAO'  value='#arguments.SERV_ISS_DEDUCAO#'  null='#iif(len(trim(arguments.SERV_ISS_DEDUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_ISS_VALOR'  value='#arguments.SERV_ISS_VALOR#'  null='#iif(len(trim(arguments.SERV_ISS_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_BASE_ICMS'  value='#arguments.CALC_BASE_ICMS#'  null='#iif(len(trim(arguments.CALC_BASE_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_ICMS'  value='#arguments.CALC_VALOR_ICMS#'  null='#iif(len(trim(arguments.CALC_VALOR_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_BASE_ICMS_SUBST'  value='#arguments.CALC_BASE_ICMS_SUBST#'  null='#iif(len(trim(arguments.CALC_BASE_ICMS_SUBST)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_ICMS_SUBST'  value='#arguments.CALC_VALOR_ICMS_SUBST#'  null='#iif(len(trim(arguments.CALC_VALOR_ICMS_SUBST)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_TOTAL_PRODUTOS'  value='#arguments.CALC_VALOR_TOTAL_PRODUTOS#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_PRODUTOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_FRETE'  value='#arguments.CALC_VALOR_FRETE#'  null='#iif(len(trim(arguments.CALC_VALOR_FRETE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_SEGURO'  value='#arguments.CALC_VALOR_SEGURO#'  null='#iif(len(trim(arguments.CALC_VALOR_SEGURO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_OUTRAS_DESPESAS'  value='#arguments.CALC_OUTRAS_DESPESAS#'  null='#iif(len(trim(arguments.CALC_OUTRAS_DESPESAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_TOTAL_IPI'  value='#arguments.CALC_VALOR_TOTAL_IPI#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_IPI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_TOTAL_NOTA'  value='#arguments.CALC_VALOR_TOTAL_NOTA#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_NOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_TRANSPORTADOR'  value='#arguments.COD_TRANSPORTADOR#'  null='#iif(len(trim(arguments.COD_TRANSPORTADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_RAZAO_SOCIAL'  value='#arguments.TRP_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_ENDERECO'  value='#arguments.TRP_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_MUNICIPIO'  value='#arguments.TRP_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_UF'  value='#arguments.TRP_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_CNPJ_CPF'  value='#arguments.TRP_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_INSCRICAO_ESTADUAL'  value='#arguments.TRP_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_PLACA'  value='#arguments.TRP_PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_PLACA_UF'  value='#arguments.TRP_PLACA_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRP_FRETE_POR'  value='#arguments.TRP_FRETE_POR#'  null='#iif(len(trim(arguments.TRP_FRETE_POR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRP_QUANTIDADE'  value='#arguments.TRP_QUANTIDADE#'  null='#iif(len(trim(arguments.TRP_QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_ESPECIE'  value='#arguments.TRP_ESPECIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_MARCA'  value='#arguments.TRP_MARCA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_NUMERO'  value='#arguments.TRP_NUMERO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRP_PESO_BRUTO'  value='#arguments.TRP_PESO_BRUTO#'  null='#iif(len(trim(arguments.TRP_PESO_BRUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRP_PESO_LIQUIDO'  value='#arguments.TRP_PESO_LIQUIDO#'  null='#iif(len(trim(arguments.TRP_PESO_LIQUIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INFO_COMPLEMENTARES'  value='#arguments.INFO_COMPLEMENTARES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESERVADO_FISCO'  value='#arguments.RESERVADO_FISCO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_FISCAL'  value='#arguments.OBSERVACAO_FISCAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_USUARIO'  value='#arguments.OBSERVACAO_USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMITIDA'  value='#arguments.EMITIDA#'  null='#iif(len(trim(arguments.EMITIDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CANCELADA'  value='#arguments.CANCELADA#'  null='#iif(len(trim(arguments.CANCELADA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONFERIDA'  value='#arguments.CONFERIDA#'  null='#iif(len(trim(arguments.CONFERIDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONVERSAO_TAXA'  value='#arguments.CONVERSAO_TAXA#'  null='#iif(len(trim(arguments.CONVERSAO_TAXA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONVERSAO_MOEDA'  value='#arguments.CONVERSAO_MOEDA#'  null='#iif(len(trim(arguments.CONVERSAO_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INCLUIR_SISS'  value='#arguments.INCLUIR_SISS#'  null='#iif(len(trim(arguments.INCLUIR_SISS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_RECOLHIMENTO_ISS'  value='#arguments.TIPO_RECOLHIMENTO_ISS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_SERVICO_DES'  value='#arguments.COD_SERVICO_DES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_SISS_ID'  value='#arguments.NATUREZA_SISS_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AVISTA_APRAZO'  value='#arguments.AVISTA_APRAZO#'  null='#iif(len(trim(arguments.AVISTA_APRAZO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NATUREZA_OPERACAO'  value='#arguments.NATUREZA_OPERACAO#'  null='#iif(len(trim(arguments.NATUREZA_OPERACAO)), de('no'), de('yes'))#'>
				</cfstoredproc>
					<!---Insere Itens--->
					<cfscript>
						arguments.num_nota_id = retorno.num_nota_id;
						V_ES = this.ListaToArray(lista = arguments, variavel = "ES_SERVICOS");
						V_NUM_NOTA_IT_ID = this.ListaToArray(lista = arguments, variavel = "NUM_NOTA_IT_ID_SERVICOS");
						V_CFOP = this.ListaToArray(lista = arguments, variavel = "CFOP_SERVICOS");
						V_CFOP_ID = this.ListaToArray(lista = arguments, variavel = "CFOP_ID_SERVICOS");
						V_PRODUTO_ID = this.ListaToArray(lista = arguments, variavel = "PRODUTO_ID_SERVICOS");
						V_DESCRICAO = this.ListaToArray(lista = arguments, variavel = "DESCRICAO_SERVICOS");
						V_DESCRICAO_COMPLEMENTO = this.ListaToArray(lista = arguments, variavel = "DESCRICAO_COMPLEMENTO_SERVICOS");
						V_COD_NCM = this.ListaToArray(lista = arguments, variavel = "COD_NCM_SERVICOS");
						V_ST_ORIGEM_ID = this.ListaToArray(lista = arguments, variavel = "ST_ORIGEM_ID_SERVICOS");
						V_ST_ICMS_ID = this.ListaToArray(lista = arguments, variavel = "ST_ICMS_ID_SERVICOS");
						V_COD_UNIDADE = this.ListaToArray(lista = arguments, variavel = "COD_UNIDADE_SERVICOS");
						V_QTDE_PESO = this.ListaToArray(lista = arguments, variavel = "QTDE_PESO_SERVICOS");
						V_QTDE_VOLUME = this.ListaToArray(lista = arguments, variavel = "QTDE_VOLUME_SERVICOS");
						V_QTDE_METRO = this.ListaToArray(lista = arguments, variavel = "QTDE_METRO_SERVICOS");
						V_VALOR_EM = this.ListaToArray(lista = arguments, variavel = "VALOR_EM_SERVICOS");
						V_VALOR_EM_UNIDADE = this.ListaToArray(lista = arguments, variavel = "VALOR_EM_UNIDADE_SERVICOS");
						V_VALOR_UNITARIO = this.ListaToArray(lista = arguments, variavel = "VALOR_UNITARIO_SERVICOS");
						V_VALOR_TOTAL = this.ListaToArray(lista = arguments, variavel = "VALOR_TOTAL_SERVICOS");
						V_SERV_TOTAL_TRIBUTAVEL = this.ListaToArray(lista = arguments, variavel = "SERVICO_TOTAL_TRIBUTAVEL_SERVICOS");
						V_SERV_TOTAL_NAO_TRIBUTAVEL = this.ListaToArray(lista = arguments, variavel = "SERVICO_TOTAL_NAO_TRIBUTAVEL_SERVICOS");
						V_SERV_TOTAL_PRODUTO = this.ListaToArray(lista = arguments, variavel = "SERVICO_TOTAL_PRODUTO_SERVICOS");
						V_SERV_ISS_ALIQUOTA = this.ListaToArray(lista = arguments, variavel = "SERVICO_ISS_ALIQUOTA_SERVICOS");
						V_SERV_ISS_DEDUCAO = this.ListaToArray(lista = arguments, variavel = "SERVICO_ISS_DEDUCAO_SERVICOS");
						V_SERV_ISS_VALOR = this.ListaToArray(lista = arguments, variavel = "SERVICO_ISS_VALOR_SERVICOS");
						V_INCLUIR_LIVRO_FISCAL = this.ListaToArray(lista = arguments, variavel = "INCLUIR_LIVRO_FISCAL_SERVICOS");
						V_INCLUIR_SINTEGRA = this.ListaToArray(lista = arguments, variavel = "INCLUIR_SINTEGRA_SERVICOS");
						V_UF_UNIDADE_NEGOCIO = this.ListaToArray(lista = arguments, variavel = "UF_UNIDADE_NEGOCIO_SERVICOS");
						V_UF_DESTINATARIO = this.ListaToArray(lista = arguments, variavel = "UF_DESTINATARIO_SERVICOS");
					</cfscript>			
					<cfloop from="1" to="#ArrayLen(V_ES)#" index="count">
						<cfscript>
							this.ins_nota_fiscal_es_it( es = v_es[count],
														num_nota_id = retorno.NUM_NOTA_ID,
														cfop = v_cfop[count],
														cfop_id = v_cfop_id[count],
														produto_id = v_produto_id[count],
														descricao = v_descricao[count],
														descricao_complemento = v_descricao_complemento[count],
														cod_ncm = v_cod_ncm[count],
														st_origem_id = v_st_origem_id[count], 
														st_icms_id = v_st_icms_id[count],
														cod_unidade = v_cod_unidade[count],
														qtde_peso = v_qtde_peso[count],
														qtde_volume = v_qtde_volume[count],
														qtde_metro = v_qtde_metro[count],
														valor_em = v_valor_em[count],
														valor_em_unidade = v_valor_em_unidade[count],
														valor_unitario = v_valor_unitario[count],
														valor_total = v_valor_total[count],
														serv_total_tributavel = v_serv_total_tributavel[count],
														serv_total_nao_tributavel = v_serv_total_nao_tributavel[count],
														serv_total_produto = v_serv_total_produto[count],
														serv_iss_aliquota = v_serv_iss_aliquota[count],
														serv_iss_deducao = v_serv_iss_deducao[count],
														serv_iss_valor = v_serv_iss_valor[count],
														incluir_livro_fiscal = v_incluir_livro_fiscal[count],
														uf_unidade_negocio = v_uf_unidade_negocio[count],
														uf_destinatario = v_uf_destinatario[count],
														incluir_sintegra = v_incluir_sintegra[count]);
						</cfscript>	
					</cfloop>
					
					<cfscript>
						V_IMPOSTO_ID 				= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_ID_ITENS_IMPOSTO");
						V_NF_IMPOSTO_ID 			= this.ListaToArray(lista = arguments, variavel = "NF_IMPOSTO_ID_ITENS_IMPOSTO");
						V_IMPOSTO_REDUCAO_BASE 		= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_REDUCAO_BASE_ITENS_IMPOSTO");
						V_IMPOSTO_BASE_CALCULO 		= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_BASE_CALCULO_ITENS_IMPOSTO");
						V_IMPOSTO_ALIQUOTA 			= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_ALIQUOTA_ITENS_IMPOSTO");
						V_IMPOSTO_TOTAL 			= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_TOTAL_ITENS_IMPOSTO");
						V_IMPOSTO_DATA_VENCIMENTO 	= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_DATA_VENCIMENTO_ITENS_IMPOSTO");
						V_IMPOSTO_RETIDO_FONTE 		= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_RETIDO_FONTE_ITENS_IMPOSTO");
						v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ITENS_IMPOSTO, lista2 = ArrayToList(V_NF_IMPOSTO_ID));
					</cfscript>	
					<cfloop list="#v_excluir#" index="l_id">
						<cfscript>
							ret = this.del_nf_es_imposto(num_nota_id = arguments.num_nota_id,
														 nf_imposto_id = l_id);
						</cfscript>
						<cfif ret.erro>
							<cfthrow object="#ret.mensagem#">
						</cfif>				
					</cfloop>
					<cfloop from="1" to="#ArrayLen(V_NF_IMPOSTO_ID)#" index="count">
						<cfscript>
							if(len(trim(V_NF_IMPOSTO_ID[count]))) {
								ret = this.upd_nf_es_imposto(	num_nota_id 			= arguments.num_nota_id,
																nf_imposto_id 			= v_nf_imposto_id[count],
																imposto_id				= v_imposto_id[count],
																imposto_reducao_base	= v_imposto_reducao_base[count],
																imposto_base_calculo	= v_imposto_base_calculo[count],
																imposto_aliquota		= v_imposto_aliquota[count],
																imposto_total			= v_imposto_total[count],
																imposto_retido_fonte	= v_imposto_retido_fonte[count],
																data_vencimento			= v_imposto_data_vencimento[count]);
							} else {
								ret = this.ins_nf_es_imposto(	num_nota_id 			= arguments.num_nota_id,
																imposto_id				= v_imposto_id[count],
																imposto_reducao_base	= v_imposto_reducao_base[count],
																imposto_base_calculo	= v_imposto_base_calculo[count],
																imposto_aliquota		= v_imposto_aliquota[count],
																imposto_total			= v_imposto_total[count],
																imposto_retido_fonte	= v_imposto_retido_fonte[count],
																data_vencimento			= v_imposto_data_vencimento[count]);
							}
						</cfscript>	
						<cfif ret.erro>
							<cfthrow object="#ret.mensagem#">
						</cfif>
					</cfloop>
                    
                    <!---Gerar RPS--->
                    <cfscript>
						ret_rps = this.gerar_rps(num_nota_id = arguments.num_nota_id);
					</cfscript>
					<cfif ret_rps.erro>
						<cfthrow object="#ret_rps.mensagem#">
					</cfif>
                    
				<cfset retorno.erro = false>
					<cfset retorno.mensagem = JSStringFormat('Nota fiscal inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Gerar RPS
	-- RAFAEL 29/10/2010 16:24:26 - CRIADO
	--->
	<cffunction name='gerar_rps' displayname='Gerar RPS' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='nfse.pkg_nfse.prc_rps_gerar' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>				
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Gerar PDF do RPS(Recibo Provisrio de Servios)
	-- RAFAEL 03/11/2010 16:20:28 - CRIADO
	--->
	<cffunction name='gerar_rps_pdf' displayname='Gerar PDF do RPS(Recibo Provisrio de Servios)' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='nfse.pkg_impressao_rps.prc_gerar_rps_pdf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB' dbvarname='P_ARQUIVO' variable='retorno.ARQUIVO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('RPS gerado com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
</cfcomponent>