<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de clientes" extends="_transportes.funcoes.cfc_init">
			
	<!--- 
	-- PROPSITO
	-- Inserir Arquivo Temporrio para EDI
	-- RAFAEL 08/06/2010 10:36:37 - CRIADO
	--->
	<cffunction name='upload_arquivo_web' displayname='Inserir Arquivo Temporrio para EDI' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTEUDO' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_edi.prc_upload_arquivo_web' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_CONTEUDO'  value='#arguments.CONTEUDO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Excluir Arquivo Temporrio para EDI
	-- RAFAEL 08/06/2010 10:36:37 - CRIADO
	--->
	<cffunction name='del_arquivo_web' displayname='Excluir Arquivo Temporrio para EDI' access='remote' returntype='Struct' output='true'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_edi.prc_del_arquivo_web' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- I(sere Arquivo do EDI
	-- RAFAEL 08/06/2010 11:10:54 - CRIADO
	--->
	<cffunction name='prc_ins_edi_arquivo' displayname='Enviar Arquivo do PREFAT' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='PREFIXO_ARQUIVO' required='yes'>
		<cfargument name='ORIGEM' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_edi.prc_ins_edi_arquivo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PREFIXO_ARQUIVO'  value='#arguments.PREFIXO_ARQUIVO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ORIGEM'  value='#arguments.ORIGEM#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMP_LOG_ID' variable='retorno.IMP_LOG_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere Arquivo do OT / NF
	-- RAFAEL 17/06/2010 14:53:17 - CRIADO
	--->
	<cffunction name='prc_ins_edi_arquivo_ot_nf' displayname='fdgfdg' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='PREFIXO_ARQUIVO' required='yes'>
		<cfargument name='ORIGEM' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_edi.prc_ins_edi_arquivo_ot_nf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PREFIXO_ARQUIVO'  value='#arguments.PREFIXO_ARQUIVO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ORIGEM'  value='#arguments.ORIGEM#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMP_LOG_ID' variable='retorno.IMP_LOG_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction> 

    
    <!--- 
	-- PROPSITO
	-- Gerar PREFAT
	-- RAFAEL 08/06/2010 10:43:47 - CRIADO
	--->
	<cffunction name='prc_prefat' displayname='Enviar Arquivo do PREFAT' access='remote' returntype='Struct' output='true'>
		<cfargument name='IMP_LOG_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_edi.prc_prefat' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMP_LOG_ID'  value='#arguments.IMP_LOG_ID#'  null='#iif(len(trim(arguments.IMP_LOG_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Enviar Arqivo do PREFAT
	-- RAFAEL 08/06/2010 10:36:37 - CRIADO
	--->
	<cffunction name='ins_prefat' displayname='Enviar Arquivo do PREFAT' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTEUDO' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='ARQUIVO' required='yes'>
        <cfargument name='PREFIXO' required='yes'>        
		<cftry>
			<cftransaction action='begin'>
            	<!---Nome do Arquivo--->
				<cfscript>
                	v_nome = ListToArray(ARQUIVO, '\');
				</cfscript>
                
                <!---Leitura do Arquivo--->
        		<cffile action="read" file="#arguments.CONTEUDO#" variable="VCONTEUDO">
                
                <cfset VCONTEUDO = reReplace(VCONTEUDO, chr(13), '', 'all')>
                
                <!---Salva arquivo temporario--->
                <cfscript>
						upload = this.upload_arquivo_web(CONTEUDO = VCONTEUDO);
				</cfscript>
				<cfif upload.erro>
					<cfthrow object="#upload.mensagem#">
				</cfif>
                
                <!---Insere arquivo do edi--->
                <cfscript>
						insere = this.prc_ins_edi_arquivo(COD_PESSOA = arguments.COD_PESSOA,
														  PREFIXO_ARQUIVO = arguments.PREFIXO,
														  ORIGEM = v_nome[ArrayLen(v_nome)]);
				</cfscript>
				<cfif insere.erro>
					<cfthrow object="#insere.mensagem#">
				</cfif>
                
                <!---Faz o PREFAT--->
                <cfscript>
						prefat = this.prc_prefat(IMP_LOG_ID = insere.IMP_LOG_ID);
				</cfscript>
				<cfif prefat.erro>
					<cfthrow object="#prefat.mensagem#">
				</cfif>
                
                <!---Exclui arquivo temporario--->
                <cfscript>
						deletar = this.del_arquivo_web();
				</cfscript>
				<cfif deletar.erro>
					<cfthrow object="#deletar.mensagem#">
				</cfif>
                
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('PREFAT gerado com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Gera o NOTFIS
	-- RAFAEL 10/06/2010 15:43:57 - CRIADO
	--->
	<cffunction name='prc_notfis' displayname='Gera o NOTFIS' access='remote' returntype='Struct' output='true'>
		<cfargument name='IMP_LOG_ID' required='yes'>
		<cfargument name='OPERACAO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_edi.prc_notfis' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMP_LOG_ID'  value='#arguments.IMP_LOG_ID#'  null='#iif(len(trim(arguments.IMP_LOG_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Enviar Arquivo do NOTFIS
	-- RAFAEL 08/06/2010 10:36:37 - CRIADO
	--->
	<cffunction name='ins_notfis' displayname='Enviar Arquivo do NOTFIS' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTEUDO' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='ARQUIVO' required='yes'>
        <cfargument name='PREFIXO' required='yes'>
        <cfargument name='OPERACAO_ID' required='yes'>        
		<cftry>
			<cftransaction action='begin'>
            	<!---Nome do Arquivo--->
				<cfscript>
                	v_nome = ListToArray(ARQUIVO, '\');
				</cfscript>
                
                <!---Leitura do Arquivo--->
        		<cffile action="read" file="#arguments.CONTEUDO#" variable="VCONTEUDO">
                
                <cfset VCONTEUDO = reReplace(VCONTEUDO, chr(13), '', 'all')>
                
                <!---Salva arquivo temporario--->
                <cfscript>
						upload = this.upload_arquivo_web(CONTEUDO = VCONTEUDO);
				</cfscript>
				<cfif upload.erro>
					<cfthrow object="#upload.mensagem#">
				</cfif>
                
				<!---Insere arquivo do edi--->
                <cfscript>
						insere = this.prc_ins_edi_arquivo(COD_PESSOA = arguments.COD_PESSOA,
														  PREFIXO_ARQUIVO = arguments.PREFIXO,
														  ORIGEM = v_nome[ArrayLen(v_nome)]);
				</cfscript>
				<cfif insere.erro>
					<cfthrow object="#insere.mensagem#">
				</cfif>
                
                <!---Faz o NOTFIS--->
                <cfscript>
						notfis = this.prc_notfis(IMP_LOG_ID  = insere.IMP_LOG_ID,
												 OPERACAO_ID = arguments.OPERACAO_ID);
				</cfscript>
				<cfif notfis.erro>
					<cfthrow object="#notfis.mensagem#">
				</cfif>
                
                <!---Exclui arquivo temporario--->
                <cfscript>
						deletar = this.del_arquivo_web();
				</cfscript>
				<cfif deletar.erro>
					<cfthrow object="#deletar.mensagem#">
				</cfif>
                
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('NOTFIS gerado com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Procedimento para Gerar a Ordem de Transporte
	-- RAFAEL 17/06/2010 09:06:00 - CRIADO
	--->
	<cffunction name='prc_ot' displayname='Procedimento para Gerar a Ordem de Transporte' access='remote' returntype='Struct' output='true'>
		<cfargument name='IMP_LOG_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_edi_bayer.prc_ot' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMP_LOG_ID'  value='#arguments.IMP_LOG_ID#'  null='#iif(len(trim(arguments.IMP_LOG_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Procedimento para Gerar a Ordem de Transporte
	-- RAFAEL 08/06/2010 10:36:37 - CRIADO
	--->
	<cffunction name='ins_ot' displayname='Procedimento para Gerar a Ordem de Transporte' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTEUDO' required='yes'>
        <cfargument name='ARQUIVO' required='yes'>
        <cftry>
			<cftransaction action='begin'>
            	<!---Nome do Arquivo--->
				<cfscript>
                	v_nome = ListToArray(ARQUIVO, '\');
				</cfscript>
                
                <!---Leitura do Arquivo--->
        		<cffile action="read" file="#arguments.CONTEUDO#" variable="VCONTEUDO">
                
                <cfset VCONTEUDO = reReplace(VCONTEUDO, chr(13), '', 'all')>
                
                <!---Salva arquivo temporario--->
                <cfscript>
						upload = this.upload_arquivo_web(CONTEUDO = VCONTEUDO);
				</cfscript>
				<cfif upload.erro>
					<cfthrow object="#upload.mensagem#">
				</cfif>
                
				<!---Insere arquivo do edi--->
                <cfscript>
						insere = this.prc_ins_edi_arquivo_ot_nf(COD_PESSOA = 27,
															    PREFIXO_ARQUIVO = 'OT',
															    ORIGEM = v_nome[ArrayLen(v_nome)]);
				</cfscript>
				<cfif insere.erro>
					<cfthrow object="#insere.mensagem#">
				</cfif>
                
                <!---Faz o OT--->
                <cfscript>
						notfis = this.prc_ot(IMP_LOG_ID  = insere.IMP_LOG_ID);
				</cfscript>
				<cfif notfis.erro>
					<cfthrow object="#notfis.mensagem#">
				</cfif>
                
                <!---Exclui arquivo temporario--->
                <cfscript>
						deletar = this.del_arquivo_web();
				</cfscript>
				<cfif deletar.erro>
					<cfthrow object="#deletar.mensagem#">
				</cfif>
                
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Planejamento de Carga importado com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Gerar o NF
	-- RAFAEL 17/06/2010 15:28:11 - CRIADO
	--->
	<cffunction name='prc_nf' displayname='Gerar o NF' access='remote' returntype='Struct' output='true'>
		<cfargument name='IMP_LOG_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_edi_bayer.prc_nf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMP_LOG_ID'  value='#arguments.IMP_LOG_ID#'  null='#iif(len(trim(arguments.IMP_LOG_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Procedimento para Gerar a NF
	-- RAFAEL 08/06/2010 10:36:37 - CRIADO
	--->
	<cffunction name='ins_nf' displayname='Procedimento para Gerar a Ordem de Transporte' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTEUDO' required='yes'>
        <cfargument name='ARQUIVO' required='yes'>
        <cftry>
			<cftransaction action='begin'>
            	<!---Nome do Arquivo--->
				<cfscript>
                	v_nome = ListToArray(ARQUIVO, '\');
				</cfscript>
                
                <!---Leitura do Arquivo--->
        		<cffile action="read" file="#arguments.CONTEUDO#" variable="VCONTEUDO">
                
                <cfset VCONTEUDO = reReplace(VCONTEUDO, chr(13), '', 'all')>
                
                <!---Salva arquivo temporario--->
                <cfscript>
						upload = this.upload_arquivo_web(CONTEUDO = VCONTEUDO);
				</cfscript>
				<cfif upload.erro>
					<cfthrow object="#upload.mensagem#">
				</cfif>
                
				<!---Insere arquivo do edi--->
                <cfscript>
						insere = this.prc_ins_edi_arquivo_ot_nf(COD_PESSOA = 27,
															    PREFIXO_ARQUIVO = 'NF',
															    ORIGEM = v_nome[ArrayLen(v_nome)]);
				</cfscript>
				<cfif insere.erro>
					<cfthrow object="#insere.mensagem#">
				</cfif>
                
                <!---Faz o OT--->
                <cfscript>
						notfis = this.prc_nf(IMP_LOG_ID  = insere.IMP_LOG_ID);
				</cfscript>
				<cfif notfis.erro>
					<cfthrow object="#notfis.mensagem#">
				</cfif>
                
                <!---Exclui arquivo temporario--->
                <cfscript>
						deletar = this.del_arquivo_web();
				</cfscript>
				<cfif deletar.erro>
					<cfthrow object="#deletar.mensagem#">
				</cfif>
                
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('NF importado com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

</cfcomponent> 