<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulao de acesso do sistema" extends="_transportes.funcoes.cfc_init">

<!--- 
-- PROPSITO
-- Altera o texto da home toque de pimenta
-- wagnerlv 12/03/2008 15:01:17 - CRIADO
--->
<cffunction name='altera_texto' displayname='Altera o texto da home toque de pimenta' access='remote' returntype='Struct' output='true'>
	<cfargument name='TEXTO_ID' required='no' default="">
	<cfargument name='TITULO' required='yes'>
	<cfargument name='TEXTO' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='toquepimenta.pkg_produtos.prc_altera_texto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TEXTO_ID'  value='#arguments.TEXTO_ID#'  null='#iif(len(trim(arguments.TEXTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_TEXTO'  value='#arguments.TEXTO#' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Texto alterado com sucesso')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>


<!--- 
-- PROPSITO
-- insere o texto na home toque de pimenta
-- wagnerlv 12/03/2008 14:20:09 - CRIADO
--->
<cffunction name='ins_texto_home' displayname='.' access='remote' returntype='Struct' output='true'>
	<cfargument name='TEXTO_ID' required='NO' default="">
	<cfargument name='TITULO' required='yes'>
	<cfargument name='TEXTO' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='toquepimenta.pkg_produtos.prc_ins_texto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TEXTO_ID'  value='#arguments.TEXTO_ID#'  null='#iif(len(trim(arguments.TEXTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_TEXTO'  value='#arguments.TEXTO#' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Texto inserido com sucesso')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

	
	<!--- 
	-- PROPSITO
	-- Insere uma circular
	-- cristofer 19/04/2006 17:18:23 - CRIADO
	--->
	<cffunction name='ins_circular' displayname='Insere uma circular' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='MES' required='yes'>
		<cfargument name='ANO' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='RESUMO' required='yes'>
		<cfargument name='FILE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_enquete.prc_ins_circular' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MES'  value='#arguments.MES#'  null='#iif(len(trim(arguments.MES)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANO'  value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESUMO'  value='#arguments.RESUMO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CIRCULAR_ID' variable='retorno.CIRCULAR_ID'>
				</cfstoredproc>
				<cfif len(trim(arguments.file))>
					<cffile action="readbinary" file="#arguments.file#" variable="v_ARQUIVO">
					<cfstoredproc procedure='site.pkg_enquete.prc_set_arquivo_circular' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CIRCULAR_ID'  value='#retorno.CIRCULAR_ID#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB' dbvarname='P_ARQUIVO'  value='#v_ARQUIVO#' >
					</cfstoredproc>
				</cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Circular inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma circular
	-- cristofer 19/04/2006 17:19:42 - CRIADO
	--->
	<cffunction name='upd_circular' displayname='Altera uma circular' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CIRCULAR_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='MES' required='yes'>
		<cfargument name='ANO' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='RESUMO' required='yes'>
		<cfargument name='FILE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_enquete.prc_alt_circular' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CIRCULAR_ID'  value='#arguments.CIRCULAR_ID#'  null='#iif(len(trim(arguments.CIRCULAR_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MES'  value='#arguments.MES#'  null='#iif(len(trim(arguments.MES)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANO'  value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESUMO'  value='#arguments.RESUMO#' >
				</cfstoredproc>
				<cfif len(trim(arguments.file))>
					<cffile action="readbinary" file="#arguments.file#" variable="arguments.arquivo">
					<cfstoredproc procedure='site.pkg_enquete.prc_set_arquivo_circular' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CIRCULAR_ID'  value='#arguments.CIRCULAR_ID#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB' dbvarname='P_ARQUIVO'  value='#arguments.ARQUIVO#' >
					</cfstoredproc>
				</cfif>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Circular alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma circular
	-- cristofer 19/04/2006 17:20:24 - CRIADO
	--->
	<cffunction name='del_circular' displayname='Exclui uma circular' access='remote' returntype='Struct' output='true'>
		<cfargument name='CIRCULAR_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_enquete.prc_del_circular' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CIRCULAR_ID'  value='#arguments.CIRCULAR_ID#'  null='#iif(len(trim(arguments.CIRCULAR_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Circular excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Atualiza a cotacao de um produto
	-- cristofer 04/05/2006 11:27:48 - CRIADO
	--->
	<cffunction name='ins_cotacao_lista' displayname='Atualiza a cotacao de um produto' access='remote' returntype='Struct' output='true'>

		<cftry>
			<cftransaction action="begin">
				<cfscript>
					v_produto_id = this.ListaToArray (lista = arguments, variavel = "PRODUTO_ID");
					v_data = this.ListaToArray (lista = arguments, variavel = "DATA");
					v_compra = this.ListaToArray (lista = arguments, variavel = "COMPRA");
					v_venda = this.ListaToArray (lista = arguments, variavel = "VENDA_PROD");
					v_venda_a_prazo = this.ListaToArray (lista = arguments, variavel = "VENDA_A_PRAZO");
					v_venda_prazo = this.ListaToArray (lista = arguments, variavel = "VENDA_PRAZO");
				</cfscript>
				
				<cfloop from="1" to="#ArrayLen(v_produto_id)#" index="count">
					<cfscript>
						this.ins_cotacao(	produto_id 		= v_produto_id[count],
											data			= v_data[count],
											compra			= v_compra[count],
											venda			= v_venda[count],
											venda_a_prazo	= v_venda_a_prazo[count],
											venda_prazo		= v_venda_prazo[count]);
					</cfscript>
				</cfloop>
				</cftransaction>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Cotao atualizada com sucesso!')>
			<cfcatch>
				<cftransaction action="rollback" />
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Atualiza a cotacao de um produto
	-- cristofer 04/05/2006 11:27:48 - CRIADO
	--->
	<cffunction name='ins_cotacao' displayname='Atualiza a cotacao de um produto' access='remote' returntype='Struct' output='true'>
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='COMPRA' required='yes'>
		<cfargument name='VENDA' required='yes'>
		<cfargument name='VENDA_A_PRAZO' required='yes'>
		<cfargument name='VENDA_PRAZO' required='yes'>
		<cfstoredproc procedure='site.pkg_enquete.prc_ins_cotacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_TIMESTAMP' dbvarname='P_DATA'  value='#DateFormat(arguments.DATA, "dd/mm/yyyy")# #TimeFormat(arguments.DATA, "HH:MM:SS")#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COMPRA'  value='#arguments.COMPRA#'  null='#iif(len(trim(arguments.COMPRA)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VENDA'  value='#arguments.VENDA#'  null='#iif(len(trim(arguments.VENDA)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VENDA_A_PRAZO'  value='#arguments.VENDA_A_PRAZO#'  null='#iif(len(trim(arguments.VENDA_A_PRAZO)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VENDA_PRAZO'  value='#arguments.VENDA_PRAZO#' >
			<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COTACAO_ID' variable='retorno.COTACAO_ID'>
		</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um produto para as cotaes
	-- cristofer 04/05/2006 11:24:20 - CRIADO
	--->
	<cffunction name='ins_cotacao_public' displayname='Insere um produto para as cotaes' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='COMPRA' required='yes'>
		<cfargument name='VENDA' required='yes'>
		<cfargument name='VENDA_A_PRAZO' required='yes'>
		<cfargument name='VENDA_PRAZO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfscript>
					this.ins_cotacao(argumentCollection = arguments);
				</cfscript>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produto inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um produto para as cotaes
	-- cristofer 04/05/2006 11:24:20 - CRIADO
	--->
	<cffunction name='ins_cotacao_produto' displayname='Insere um produto para as cotaes' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='UNIDADE' required='yes'>
		<cfargument name='MERCADO' required='yes'>
		<cfargument name='SEMENTE' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_enquete.prc_ins_cotacao_produto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UNIDADE'  value='#arguments.UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MERCADO'  value='#arguments.MERCADO#'  null='#iif(len(trim(arguments.MERCADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SEMENTE'  value='#arguments.SEMENTE#'  null='#iif(len(trim(arguments.SEMENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID' variable='retorno.PRODUTO_ID'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produto inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um produto para as cotaes
	-- cristofer 04/05/2006 11:25:29 - CRIADO
	--->
	<cffunction name='upd_cotacao_produto' displayname='Altera um produto para as cotaes' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='UNIDADE' required='yes'>
		<cfargument name='MERCADO' required='yes'>
		<cfargument name='SEMENTE' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_enquete.prc_alt_cotacao_produto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UNIDADE'  value='#arguments.UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MERCADO'  value='#arguments.MERCADO#'  null='#iif(len(trim(arguments.MERCADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SEMENTE'  value='#arguments.SEMENTE#'  null='#iif(len(trim(arguments.SEMENTE)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produto alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um produto para as cotaes
	-- cristofer 04/05/2006 11:26:40 - CRIADO
	--->
	<cffunction name='del_cotacao_produto' displayname='Exclui um produto para as cotaes' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PRODUTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_enquete.prc_del_cotacao_produto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produto excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere uma nova enquete
	-- cristofer 18/04/2006 08:56:11 - CRIADO
	--->
	<cffunction name='ins_enquete' displayname='Insere uma nova enquete' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DATA_INICIAL' required='yes'>
		<cfargument name='DATA_FINAL' required='yes'>
		<cfargument name='PERGUNTA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_enquete.prc_ins_enquete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIAL'  value='#arguments.DATA_INICIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FINAL'  value='#arguments.DATA_FINAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PERGUNTA'  value='#arguments.PERGUNTA#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENQUETE_ID' variable='retorno.ENQUETE_ID'>
				</cfstoredproc>
				<!---Alteraes de Alternativas--->
				<cfscript>
					v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_ALTERNATIVAS");
					v_alternativa_id = this.ListaToArray (lista = arguments, variavel = "ALTERNATIVA_ID_ALTERNATIVAS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_alternativas, lista2 = ArrayToList(v_alternativa_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_enquete_alternativa (enquete_id = retorno.enquete_id,
										alternativa_id   = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_alternativa_id)#" index="count">
					<cfscript>
						if(not len(trim(v_alternativa_id[count]))) {
							this.ins_enquete_alternativa(enquete_id = retorno.enquete_id,
										   				 descricao = v_descricao[count]);
						} else {
							this.upd_enquete_alternativa(enquete_id = retorno.enquete_id,
										   				 descricao = v_descricao[count],
														 alternativa_id = v_alternativa_id[count]);
						}
					</cfscript>
				</cfloop>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Enquete inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera uma enquete
	-- cristofer 18/04/2006 08:58:26 - CRIADO
	--->
	<cffunction name='upd_enquete' displayname='Altera uma enquete' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ENQUETE_ID' required='yes'>
		<cfargument name='DATA_INICIAL' required='yes'>
		<cfargument name='DATA_FINAL' required='yes'>
		<cfargument name='PERGUNTA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_enquete.prc_alt_enquete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENQUETE_ID'  value='#arguments.ENQUETE_ID#'  null='#iif(len(trim(arguments.ENQUETE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIAL'  value='#arguments.DATA_INICIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FINAL'  value='#arguments.DATA_FINAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PERGUNTA'  value='#arguments.PERGUNTA#' >
				</cfstoredproc>
				<!---Alteraes de Alternativas--->
				<cfscript>
					retorno.enquete_id = arguments.enquete_id;
					v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_ALTERNATIVAS");
					v_alternativa_id = this.ListaToArray (lista = arguments, variavel = "ALTERNATIVA_ID_ALTERNATIVAS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_alternativas, lista2 = ArrayToList(v_alternativa_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_enquete_alternativa (enquete_id = retorno.enquete_id,
										alternativa_id   = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_alternativa_id)#" index="count">
					<cfscript>
						if(not len(trim(v_alternativa_id[count]))) {
							this.ins_enquete_alternativa(enquete_id = retorno.enquete_id,
										   				 descricao = v_descricao[count]);
						} else {
							this.upd_enquete_alternativa(enquete_id = retorno.enquete_id,
										   				 descricao = v_descricao[count],
														 alternativa_id = v_alternativa_id[count]);
						}
					</cfscript>
				</cfloop>						
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Enquete alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma enquete
	-- cristofer 18/04/2006 08:59:16 - CRIADO
	--->
	<cffunction name='del_enquete' displayname='Exclui uma enquete' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ENQUETE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_enquete.prc_del_enquete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENQUETE_ID'  value='#arguments.ENQUETE_ID#'  null='#iif(len(trim(arguments.ENQUETE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Enquete excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma alternativa para a enquete
	-- cristofer 18/04/2006 09:01:05 - CRIADO
	--->
	<cffunction name='ins_enquete_alternativa' displayname='Insere uma alternativa para a enquete' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ENQUETE_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfstoredproc procedure='site.pkg_enquete.prc_ins_enquete_alternativa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENQUETE_ID'  value='#arguments.ENQUETE_ID#'  null='#iif(len(trim(arguments.ENQUETE_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
			<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTERNATIVA_ID' variable='retorno.ALTERNATIVA_ID'>
		</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma alternativa para a enquete
	-- cristofer 18/04/2006 09:02:01 - CRIADO
	--->
	<cffunction name='upd_enquete_alternativa' displayname='Altera uma alternativa para a enquete' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ALTERNATIVA_ID' required='yes'>
		<cfargument name='ENQUETE_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfstoredproc procedure='site.pkg_enquete.prc_alt_enquete_alternativa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTERNATIVA_ID'  value='#arguments.ALTERNATIVA_ID#'  null='#iif(len(trim(arguments.ALTERNATIVA_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENQUETE_ID'  value='#arguments.ENQUETE_ID#'  null='#iif(len(trim(arguments.ENQUETE_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
		</cfstoredproc>
		<cfreturn StructNew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma alternativa para a enquete
	-- cristofer 18/04/2006 09:03:49 - CRIADO
	--->
	<cffunction name='del_enquete_alternativa' displayname='Exclui uma alternativa para a enquete' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ALTERNATIVA_ID' required='yes'>
		<cfargument name='ENQUETE_ID' required='yes'>
				<cfstoredproc procedure='site.pkg_enquete.prc_del_enquete_alternativa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTERNATIVA_ID'  value='#arguments.ALTERNATIVA_ID#'  null='#iif(len(trim(arguments.ALTERNATIVA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENQUETE_ID'  value='#arguments.ENQUETE_ID#'  null='#iif(len(trim(arguments.ENQUETE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma reposta para a enquete
	-- cristofer 18/04/2006 09:05:12 - CRIADO
	--->
	<cffunction name='ins_enquete_resposta' displayname='Insere uma reposta para a enquete' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ALTERNATIVA_ID' required='yes'>
		<cfargument name='ENQUETE_ID' required='yes'>
		<cfargument name='IP' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_enquete.prc_ins_enquete_resposta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTERNATIVA_ID'  value='#arguments.ALTERNATIVA_ID#'  null='#iif(len(trim(arguments.ALTERNATIVA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENQUETE_ID'  value='#arguments.ENQUETE_ID#'  null='#iif(len(trim(arguments.ENQUETE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_IP'  value='#arguments.IP#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RESPOSTA_ID' variable='retorno.RESPOSTA_ID'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Voto computado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma noticia
	-- cristofer 08/05/2006 16:13:01 - CRIADO
	--->
	<cffunction name='ins_noticia' displayname='Insere uma noticia' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TITULO' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='TEXTO' required='yes'>
		<cfargument name='OCEPAR' required='no' default="0">
		<cfargument name='COD_OCEPAR' required='no' default="">
		<cftry>
			<cfif not len(trim(arguments.ocepar))>
				<cfset arguments.ocepar = 0>
			</cfif>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_enquete.prc_ins_noticia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_TIMESTAMP' dbvarname='P_DATA'  value='#DateFormat(arguments.DATA, 'dd/mm/yyyy')# #TimeFormat(arguments.DATA, 'HH:mm:ss')#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TEXTO'  value='#left(arguments.texto,4000)#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OCEPAR'  value='#arguments.OCEPAR#'  null='#iif(len(trim(arguments.OCEPAR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_OCEPAR'  value='#arguments.COD_OCEPAR#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NOTICIA_ID' variable='retorno.NOTICIA_ID'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Noticia inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma noticia
	-- cristofer 08/05/2006 16:13:53 - CRIADO
	--->
	<cffunction name='upd_noticia' displayname='Altera uma noticia' access='remote' returntype='Struct' output='true'>;
		<cfargument name='NOTICIA_ID' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='TEXTO' required='yes'>
		<cfargument name='OCEPAR' required='no' default="0">
		<cfargument name='COD_OCEPAR' required='no' default="">
		<cfargument name='ATIVA' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_enquete.prc_alt_noticia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NOTICIA_ID'  value='#arguments.NOTICIA_ID#'  null='#iif(len(trim(arguments.NOTICIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_TIMESTAMP' dbvarname='P_DATA'  value='#DateFormat(arguments.DATA, 'dd/mm/yyyy')#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TEXTO'  value='#arguments.TEXTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OCEPAR'  value='#arguments.OCEPAR#'  null='#iif(len(trim(arguments.OCEPAR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_OCEPAR'  value='#arguments.COD_OCEPAR#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVA'  value='#arguments.ATIVA#'  null='#iif(len(trim(arguments.ATIVA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Noticia alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma noticia
	-- cristofer 08/05/2006 16:14:29 - CRIADO
	--->
	<cffunction name='del_noticia' displayname='Exclui uma noticia' access='remote' returntype='Struct' output='true'>;
		<cfargument name='NOTICIA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_enquete.prc_del_noticia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NOTICIA_ID'  value='#arguments.NOTICIA_ID#'  null='#iif(len(trim(arguments.NOTICIA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Noticia excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere um produto
	-- cristofer 27/05/2006 11:34:40 - CRIADO
	--->
	<cffunction name='ins_produto' displayname='Insere um produto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CATEGORIA_ID' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='INATIVO' required='no' default="0">
		<cfargument name='DESTAQUE' required='no' default="0">
		<cfargument name='FOTO_1' required='no' default="">
		<cfargument name='FOTO_2' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='toquepimenta.pkg_produtos.prc_ins_produto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CATEGORIA_ID'  value='#arguments.CATEGORIA_ID#'  null='#iif(len(trim(arguments.CATEGORIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#'  null='#iif(len(trim(arguments.DESCRICAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INATIVO'  value='#arguments.INATIVO#'  null='#iif(len(trim(arguments.INATIVO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESTAQUE'  value='#arguments.DESTAQUE#'  null='#iif(len(trim(arguments.DESTAQUE)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID' variable='retorno.PRODUTO_ID'>
				</cfstoredproc>
				<cfscript>
					if(len(trim(arguments.foto_1))) {
						foto1 = this.ins_produto_foto(  produto_id 	= retorno.produto_id,
														nro_foto 	= 1,
														filefield	= "FOTO_1");
					}
					if(len(trim(arguments.foto_2))) {
						foto2 = this.ins_produto_foto(  produto_id 	= retorno.produto_id,
														nro_foto 	= 2,
														filefield	= "FOTO_2");
					}
				</cfscript>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produto inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um produto
	-- cristofer 27/05/2006 11:35:40 - CRIADO
	--->
	<cffunction name='upd_produto' displayname='Altera um produto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='CATEGORIA_ID' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='INATIVO' required='yes'>
		<cfargument name='DESTAQUE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='toquepimenta.pkg_produtos.prc_alt_produto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CATEGORIA_ID'  value='#arguments.CATEGORIA_ID#'  null='#iif(len(trim(arguments.CATEGORIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#'  null='#iif(len(trim(arguments.DESCRICAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INATIVO'  value='#arguments.INATIVO#'  null='#iif(len(trim(arguments.INATIVO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESTAQUE'  value='#arguments.DESTAQUE#'  null='#iif(len(trim(arguments.DESTAQUE)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfscript>
					retorno.produto_id = arguments.produto_id;
					if(len(trim(arguments.foto_1))) {
						foto1 = this.ins_produto_foto(  produto_id 	= retorno.produto_id,
														nro_foto 	= 1,
														filefield	= "FOTO_1");
					}
					if(len(trim(arguments.foto_2))) {
						foto2 = this.ins_produto_foto(  produto_id 	= retorno.produto_id,
														nro_foto 	= 2,
														filefield	= "FOTO_2");
					}
				</cfscript>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produto alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um produto
	-- cristofer 27/05/2006 11:36:15 - CRIADO
	--->
	<cffunction name='del_produto' displayname='Exclui um produto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PRODUTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='toquepimenta.pkg_produtos.prc_del_produto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produto excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma foto no produto
	-- cristofer 27/05/2006 11:49:27 - CRIADO
	--->
	<cffunction name='ins_produto_foto' displayname='Insere uma foto no produto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='NRO_FOTO' required='yes'>
		<cfargument name='FILEFIELD' required='yes'>
				<cfstoredproc procedure='toquepimenta.pkg_produtos.prc_ins_produto_foto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NRO_FOTO'  value='#arguments.NRO_FOTO#'  null='#iif(len(trim(arguments.NRO_FOTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_URL'  value='' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMAGEM_ID' variable='retorno.IMAGEM_ID'>
				</cfstoredproc>
				<cfset retorno.url = "#ExpandPath('/')#/toquedepimenta/fotos/#numberformat(retorno.imagem_id,'0')#.jpg">
				<cfset retorno.url_mini = "#ExpandPath('/')#/toquedepimenta/fotos/mini/#numberformat(retorno.imagem_id,'0')#.jpg">
				<cffile action="upload"
						filefield="#arguments.filefield#" 
						nameconflict="overwrite"
						destination="#retorno.url#"
						result="retorno.dados">
				<cfscript>
					conn_imagem = CreateObject("component","_transportes.funcoes.cfc_image_utils");	
					v_image = conn_imagem.load(filename = '#retorno.url#');	
					if (conn_imagem.getHeight() neq 72 and conn_imagem.getWidth() neq 120) {
						larga = (conn_imagem.getWidth()/conn_imagem.getHeight() gt 120/72);
						if (larga) {
							conn_imagem.setWidth(120);
						} else {
							conn_imagem.setHeight(72);
						}
						v_image = conn_imagem.writeResult(filename = '#retorno.url_mini#', type = 'jpeg');	
					}
				 </cfscript>						
				<cfstoredproc procedure='toquepimenta.pkg_produtos.prc_ins_produto_foto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NRO_FOTO'  value='#arguments.NRO_FOTO#'  null='#iif(len(trim(arguments.NRO_FOTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_URL'  value='#replace(retorno.url,"#ExpandPath('/')#/","http://www.toquedepimenta.com.br/","one")#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMAGEM_ID' variable='retorno.IMAGEM_ID'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma foto no produto
	-- cristofer 27/05/2006 11:54:55 - CRIADO
	--->
	<cffunction name='del_produto_foto' displayname='Exclui uma foto no produto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='NRO_FOTO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='toquepimenta.pkg_produtos.prc_del_produto_foto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NRO_FOTO'  value='#arguments.NRO_FOTO#'  null='#iif(len(trim(arguments.NRO_FOTO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_URL'  variable="retorno.url" >
				</cfstoredproc>
				<cftry>
					<cffile action="delete" 
							file='#replace(retorno.url,"http://www.toquedepimenta.com.br/","#ExpandPath('/')#/","one")#'>
					<cfcatch>
						<cfset retorno.info_adicional = "No foi possvel excluir o arquivo: #replace(retorno.url,"http://www.toquedepimenta.com.br/","#ExpandPath('/')#/","one")#">
					</cfcatch>
				</cftry>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Foto excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere classificado e envia e-mail
	-- wagner 30/05/2006 16:45:15 - CRIADO
	--->
	<cffunction name='ins_classificado' displayname='Insere classificado' access='remote' returntype='Struct' output='true'>;
		<cfargument name='NOME' required='yes'>
		<cfargument name='ENDERECO' required='yes'>
		<cfargument name='TELEFONE' required='yes'>
		<cfargument name='CIDADE' required='yes'>
		<cfargument name='EMAIL' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='TEXTO' required='yes'>
		<cfargument name='URL_IMAGEM' required='yes'>
		<cfargument name='INICIO' required='no' default="">
		<cfargument name='TERMINO' required='no' default="">
		<cfargument name='COM_FOTO' required='yes'>
		<cfargument name='ENVIA_EMAIL' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_enquete.prc_ins_classificado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENDERECO'  value='#arguments.ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TELEFONE'  value='#arguments.TELEFONE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CIDADE'  value='#arguments.CIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL'  value='#arguments.EMAIL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TEXTO'  value='#arguments.TEXTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_URL_IMAGEM'  value='' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INICIO'  value='#lsDateFormat(arguments.INICIO)#' null='#iif(len(trim(arguments.INICIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TERMINO'  value='#lsDateFormat(arguments.TERMINO)#' null='#iif(len(trim(arguments.TERMINO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COM_FOTO'  value='#arguments.COM_FOTO#'  null='#iif(len(trim(arguments.COM_FOTO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLASSIFICADO_ID' variable='retorno.CLASSIFICADO_ID'>
				</cfstoredproc>
				<cfif len(trim(arguments.url_imagem))>
					<!-- Upload -->
					<cfset url_novo = "/coopagricola/classificados/fotos/#numberformat(retorno.classificado_id,'0')#.jpg" >
					<cfset retorno.url = expandPath("/coopagricola/classificados/fotos/#numberformat(retorno.classificado_id,'0')#.jpg")>
					<cfset retorno.url_mini = expandPath("/coopagricola/classificados/fotos/mini/#numberformat(retorno.classificado_id,'0')#.jpg")>
						<cffile action="upload"
								filefield="url_imagem" 
								nameconflict="overwrite"
								destination="#retorno.url#"
								result="retorno.dados">
						<cfscript>
							conn_imagem = CreateObject("component","_transportes.funcoes.cfc_image_utils");	
							v_image = conn_imagem.load(filename = '#retorno.url#');	
							if (conn_imagem.getHeight() neq 72 and conn_imagem.getWidth() neq 120) {
								larga = (conn_imagem.getWidth()/conn_imagem.getHeight() gt 120/72);
								if (larga) {
									conn_imagem.setWidth(120);
								} else {
									conn_imagem.setHeight(72);
								}
								v_image = conn_imagem.writeResult(filename = '#retorno.url_mini#', type = 'jpeg');	
							}
						 </cfscript>
					
					<!-- Upload -->
					<cfstoredproc procedure='site.pkg_enquete.prc_alt_classificado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLASSIFICADO_ID'  value='#retorno.CLASSIFICADO_ID#'  null='#iif(len(trim(retorno.CLASSIFICADO_ID)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENDERECO'  value='#arguments.ENDERECO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TELEFONE'  value='#arguments.TELEFONE#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CIDADE'  value='#arguments.CIDADE#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL'  value='#arguments.EMAIL#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TEXTO'  value='#arguments.TEXTO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_URL_IMAGEM'  value='#url_novo#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INICIO'  value='#lsDateFormat(arguments.INICIO)#' null='#iif(len(trim(arguments.INICIO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TERMINO'  value='#lsDateFormat(arguments.TERMINO)#' null='#iif(len(trim(arguments.TERMINO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COM_FOTO'  value='#arguments.COM_FOTO#'  null='#iif(len(trim(arguments.COM_FOTO)), de('no'), de('yes'))#'>
					</cfstoredproc>
				
				</cfif>
				
				
				<cfif arguments.envia_email eq 1>
					<cfscript>
						subtitulo = #arguments.titulo#;
						titulo = 'Classificado Inserido';
						mensagem = "<span class='texto_negrito'>Dados do Cooperado:</span> #arguments.nome#<br/><br/>
						<span class='texto_negrito'>Dados do Anncio:</span><br/>#Replace(arguments.texto, chr(10), '<br>', 'all')#";
						</cfscript>
						<cfmail to="sandra@coopagricola.com.br" from="#arguments.email#" subject="#arguments.titulo#" type="html">
							<cfinclude template="../../coopagricola/aplicacoes/mensagem/email.cfm">
						</cfmail>
				</cfif>
				<cfif arguments.envia_email eq 1>
					<cfset retorno.erro = false>
					<cfset retorno.mensagem = JSStringFormat('Classificado inserido com sucesso! Ser publicado aps aprovao.')>
				
				<cfelse>
					<cfset retorno.erro = false>
					<cfset retorno.mensagem = JSStringFormat('Classificado inserido com sucesso!')>
				</cfif> 	
				</cftransaction>
				
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera classificado
	-- wagner 30/05/2006 16:48:30 - CRIADO
	--->
	<cffunction name='upd_classificado' displayname='Altera classificado' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CLASSIFICADO_ID' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='ENDERECO' required='yes'>
		<cfargument name='TELEFONE' required='yes'>
		<cfargument name='CIDADE' required='yes'>
		<cfargument name='EMAIL' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='TEXTO' required='yes'>
		<cfargument name='URL_IMAGEM' required='yes'>
		<cfargument name='INICIO' required='yes'>
		<cfargument name='TERMINO' required='yes'>
		<cfargument name='COM_FOTO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfset url_novo = "/coopagricola/classificados/fotos/#numberformat(arguments.classificado_id,'0')#.jpg" >
				<cfif len(trim(arguments.URL_IMAGEM))>
					<!-- Upload -->
					<cfset retorno.url = expandPath("/coopagricola/classificados/fotos/#numberformat(arguments.classificado_id,'0')#.jpg")>
					<cfset retorno.url_mini = expandPath("/coopagricola/classificados/fotos/mini/#numberformat(arguments.classificado_id,'0')#.jpg")>
					<cffile action="upload"
							filefield="url_imagem" 
							nameconflict="overwrite"
							destination="#retorno.url#"
							result="retorno.dados">
					<cfscript>
						conn_imagem = CreateObject("component","_transportes.funcoes.cfc_image_utils");	
						v_image = conn_imagem.load(filename = '#retorno.url#');	
						if (conn_imagem.getHeight() neq 72 and conn_imagem.getWidth() neq 120) {
							larga = (conn_imagem.getWidth()/conn_imagem.getHeight() gt 120/72);
							if (larga) {
								conn_imagem.setWidth(120);
							} else {
								conn_imagem.setHeight(72);
							}
							v_image = conn_imagem.writeResult(filename = '#retorno.url_mini#', type = 'jpeg');	
						}
					 </cfscript>
					
					<!-- Upload -->
				</cfif>	
				<cfstoredproc procedure='site.pkg_enquete.prc_alt_classificado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLASSIFICADO_ID'  value='#arguments.CLASSIFICADO_ID#'  null='#iif(len(trim(arguments.CLASSIFICADO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENDERECO'  value='#arguments.ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TELEFONE'  value='#arguments.TELEFONE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CIDADE'  value='#arguments.CIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL'  value='#arguments.EMAIL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TEXTO'  value='#arguments.TEXTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_URL_IMAGEM'  value='#url_novo#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INICIO'  value='#lsDateFormat(arguments.INICIO)#' null='#iif(len(trim(arguments.INICIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TERMINO'  value='#lsDateFormat(arguments.TERMINO)#' null='#iif(len(trim(arguments.TERMINO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COM_FOTO'  value='#arguments.COM_FOTO#'  null='#iif(len(trim(arguments.COM_FOTO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				
				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Classificado Alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Excluir classificado
	-- wagner 30/05/2006 16:52:09 - CRIADO
	--->
	<cffunction name='del_classificado' displayname='Excluir classificado' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CLASSIFICADO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_enquete.prc_del_classificado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLASSIFICADO_ID'  value='#arguments.CLASSIFICADO_ID#'  null='#iif(len(trim(arguments.CLASSIFICADO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Classificado Excluido com sucesso!')>
				
			
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
</cfcomponent>