<cfcomponent displayname="Controle e manipulao de diagramas">
	<!--- 
	-- PROPSITO
	-- Insere um novo diagrama
	-- guto 08/07/2006 11:36:37 - CRIADO
	--->
	<cffunction name='ins_diagrama' displayname='Insere um novo diagrama' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TITULO' required='yes'>
		<cfargument name='CONTEUDO' required='yes'>
		<cfargument name='DIAGRAMA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_diagrama.prc_ins_diagrama' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONTEUDO'  value='#arguments.CONTEUDO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIAGRAMA_ID'  value='#arguments.DIAGRAMA_ID#' variable='retorno.DIAGRAMA_ID'  null='#iif(len(trim(arguments.DIAGRAMA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Diagrama inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera dados do diagrama
	-- guto 08/07/2006 11:37:38 - CRIADO
	--->
	<cffunction name='alt_diagrama' displayname='Altera dados do diagrama' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DIAGRAMA_ID' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='CONTEUDO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_diagrama.prc_alt_diagrama' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIAGRAMA_ID'  value='#arguments.DIAGRAMA_ID#'  null='#iif(len(trim(arguments.DIAGRAMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONTEUDO'  value='#arguments.CONTEUDO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Diagrama alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui diagrama
	-- guto 08/07/2006 11:40:16 - CRIADO
	--->
	<cffunction name='del_diagrama' displayname='Exclui diagrama' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DIAGRAMA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_diagrama.prc_del_diagrama' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIAGRAMA_ID'  value='#arguments.DIAGRAMA_ID#'  null='#iif(len(trim(arguments.DIAGRAMA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Diagrama excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um novo objeto ao diagrama
	-- guto 08/07/2006 11:42:02 - CRIADO
	--->
	<cffunction name='ins_objeto' displayname='Insere um novo objeto ao diagrama' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DIAGRAMA_ID' required='yes'>
		<cfargument name='X' required='yes'>
		<cfargument name='Y' required='yes'>
		<cfargument name='FORMA_ID' required='yes'>
		<cfargument name='ALTURA' required='yes'>
		<cfargument name='LARGURA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_diagrama.prc_ins_objeto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIAGRAMA_ID'  value='#arguments.DIAGRAMA_ID#'  null='#iif(len(trim(arguments.DIAGRAMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_X'  value='#arguments.X#'  null='#iif(len(trim(arguments.X)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_Y'  value='#arguments.Y#'  null='#iif(len(trim(arguments.Y)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORMA_ID'  value='#arguments.FORMA_ID#'  null='#iif(len(trim(arguments.FORMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTURA'  value='#arguments.ALTURA#'  null='#iif(len(trim(arguments.ALTURA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LARGURA'  value='#arguments.LARGURA#'  null='#iif(len(trim(arguments.LARGURA)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OBJETO_ID' variable='retorno.OBJETO_ID'  null='yes'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Objeto inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>		
	
	<!--- 
	-- PROPSITO
	-- Altera dados do objeto
	-- guto 08/07/2006 11:44:40 - CRIADO
	--->
	<cffunction name='alt_objeto' displayname='Altera dados do objeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='OBJETO_ID' required='yes'>
		<cfargument name='DIAGRAMA_ID' required='yes'>
		<cfargument name='X' required='yes'>
		<cfargument name='Y' required='yes'>
		<cfargument name='FORMA_ID' required='yes'>
		<cfargument name='ALTURA' required='yes'>
		<cfargument name='LARGURA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_diagrama.prc_alt_objeto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OBJETO_ID'  value='#arguments.OBJETO_ID#'  null='#iif(len(trim(arguments.OBJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIAGRAMA_ID'  value='#arguments.DIAGRAMA_ID#'  null='#iif(len(trim(arguments.DIAGRAMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_X'  value='#arguments.X#'  null='#iif(len(trim(arguments.X)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_Y'  value='#arguments.Y#'  null='#iif(len(trim(arguments.Y)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORMA_ID'  value='#arguments.FORMA_ID#'  null='#iif(len(trim(arguments.FORMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTURA'  value='#arguments.ALTURA#'  null='#iif(len(trim(arguments.ALTURA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LARGURA'  value='#arguments.LARGURA#'  null='#iif(len(trim(arguments.LARGURA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Objeto alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Exclui objeto
	-- guto 08/07/2006 11:46:20 - CRIADO
	--->
	<cffunction name='del_objeto' displayname='Exclui objeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='OBJETO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_diagrama.prc_del_objeto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OBJETO_ID'  value='#arguments.OBJETO_ID#'  null='#iif(len(trim(arguments.OBJETO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Objeto excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere uma nova forma
	-- guto 08/07/2006 11:47:28 - CRIADO
	--->
	<cffunction name='ins_forma' displayname='Insere uma nova forma' access='remote' returntype='Struct' output='true'>;
		<cfargument name='NOME' required='yes'>
		<cfargument name='ALTURA_PADRAO' required='yes'>
		<cfargument name='LARGURA_PADRAO' required='yes'>
		<cfargument name='FORMA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_diagrama.prc_ins_forma' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTURA_PADRAO'  value='#arguments.ALTURA_PADRAO#'  null='#iif(len(trim(arguments.ALTURA_PADRAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LARGURA_PADRAO'  value='#arguments.LARGURA_PADRAO#'  null='#iif(len(trim(arguments.LARGURA_PADRAO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORMA_ID'  value='#arguments.FORMA_ID#' variable='retorno.FORMA_ID'  null='#iif(len(trim(arguments.FORMA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Forma inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera dados da forma
	-- guto 08/07/2006 11:48:34 - CRIADO
	--->
	<cffunction name='alt_forma' displayname='Altera dados da forma' access='remote' returntype='Struct' output='true'>;
		<cfargument name='FORMA_ID' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='ALTURA_PADRAO' required='yes'>
		<cfargument name='LARGURA_PADRAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_diagrama.prc_alt_forma' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORMA_ID'  value='#arguments.FORMA_ID#'  null='#iif(len(trim(arguments.FORMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTURA_PADRAO'  value='#arguments.ALTURA_PADRAO#'  null='#iif(len(trim(arguments.ALTURA_PADRAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LARGURA_PADRAO'  value='#arguments.LARGURA_PADRAO#'  null='#iif(len(trim(arguments.LARGURA_PADRAO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Forma alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui forma
	-- guto 08/07/2006 11:49:30 - CRIADO
	--->
	<cffunction name='del_forma' displayname='Exclui forma' access='remote' returntype='Struct' output='true'>;
		<cfargument name='FORMA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_diagrama.prc_del_form' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORMA_ID'  value='#arguments.FORMA_ID#'  null='#iif(len(trim(arguments.FORMA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Forma excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere um vinculo entre os objetos
	-- guto 15/07/2006 12:10:29 - CRIADO
	--->
	<cffunction name='ins_objeto_vinculo' displayname='Insere um vinculo entre os objetos' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DIAGRAMA_ID' required='yes'>
		<cfargument name='OBJETO_ID_1' required='yes'>
		<cfargument name='OBJETO_ID_2' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_diagrama.prc_ins_objeto_vinculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIAGRAMA_ID'  value='#arguments.DIAGRAMA_ID#'  null='#iif(len(trim(arguments.DIAGRAMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OBJETO_ID_1'  value='#arguments.OBJETO_ID_1#'  null='#iif(len(trim(arguments.OBJETO_ID_1)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OBJETO_ID_2'  value='#arguments.OBJETO_ID_2#'  null='#iif(len(trim(arguments.OBJETO_ID_2)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Vinculo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>				

	<!--- 
	-- PROPSITO
	-- Excluir vinculo entre os objetos
	-- guto 15/07/2006 12:12:30 - CRIADO
	--->
	<cffunction name='del_objeto_vinculo' displayname='Excluir vinculo entre os objetos' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DIAGRAMA_ID' required='yes'>
		<cfargument name='OBJETO_ID_1' required='yes'>
		<cfargument name='OBJETO_ID_2' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_diagrama.prc_del_objeto_vinculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIAGRAMA_ID'  value='#arguments.DIAGRAMA_ID#'  null='#iif(len(trim(arguments.DIAGRAMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OBJETO_ID_1'  value='#arguments.OBJETO_ID_1#'  null='#iif(len(trim(arguments.OBJETO_ID_1)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OBJETO_ID_2'  value='#arguments.OBJETO_ID_2#'  null='#iif(len(trim(arguments.OBJETO_ID_2)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Vinculo excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
</cfcomponent>