<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Insere pedgio
	-- 28/12/2005 - criado
	--->
	<cffunction name="ins_pedagio" displayname="Insere pedgio" access="remote" returntype="Struct" output="true">
		<cfargument name="PLACA" required="yes">
		<cfargument name="DATA_HORA" required="yes">
		<cfargument name="POSTO_PEDAGIO_ID" required="yes">
		<cfargument name="CATEGORIA" required="yes">
		<cfargument name="VALOR" required="yes">
		<cfargument name="COD_PESSOA" required="yes">
		<cfargument name="LANCTO_ID" required="yes">
	
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="oper.pkg_pedagio_dml.prc_ins_pedagio_lancto" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_PLACA" value="#UCase(Replace(arguments.PLACA,'-',''))#"  >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA" value="#arguments.DATA_HORA#"  >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_POSTO_PEDAGIO_ID" value="#arguments.POSTO_PEDAGIO_ID#" null="#iif(len(trim(arguments.POSTO_PEDAGIO_ID)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CATEGORIA" value="#arguments.CATEGORIA#" null="#iif(len(trim(arguments.CATEGORIA)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_VALOR_TARIFA" value="#arguments.VALOR#" null="#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_PESSOA" value="#arguments.COD_PESSOA#" null="#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ORIGEM" value="2">
					<cfprocparam type="inout" cfsqltype="cf_sql_integer" dbvarname="P_LANCTO_ID" null="yes" variable="retorno.LANCTO_ID" >
					<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="P_ROWID" variable="retorno.ROWID" >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Pedgio inserido com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	<!--- 
	-- PROPSITO
	-- Altera dados do pedgio
	-- 28/12/2005 - criado
	--->
	<cffunction name="upd_pedagio" displayname="Altera dados do pedgio" access="remote" returntype="Struct" output="true">
		<cfargument name="LANCTO_ID" required="yes">
		<cfargument name="PLACA" required="yes">
		<cfargument name="DATA_HORA" required="yes">
		<cfargument name="POSTO_PEDAGIO_ID" required="yes">
		<cfargument name="CATEGORIA" required="yes">
		<cfargument name="VALOR" required="yes">
		<cfargument name="COD_PESSOA" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="oper.pkg_pedagio_dml.prc_alt_pedagio_lancto" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_LANCTO_ID" value="#arguments.LANCTO_ID#" >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_PLACA" value="#UCase(Replace(arguments.PLACA,'-',''))#"  >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA" value="#arguments.DATA_HORA#"  >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_POSTO_PEDAGIO_ID" value="#arguments.POSTO_PEDAGIO_ID#" null="#iif(len(trim(arguments.POSTO_PEDAGIO_ID)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CATEGORIA" value="#arguments.CATEGORIA#" null="#iif(len(trim(arguments.CATEGORIA)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_VALOR_TARIFA" value="#arguments.VALOR#" null="#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_PESSOA" value="#arguments.COD_PESSOA#" null="#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_RELACAO_ID" null="yes">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_LANCAMENTO_CONTAB" null="yes">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VIA_RASTREADOR" value="0">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Pedgio alterado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui pedgio
	-- 28/12/2005 - criado
	--->
	<cffunction name="del_pedagio" displayname="Exclui pedgio" access="remote" returntype="Struct" output="true">
		<cfargument name="LANCTO_ID" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfloop index="i" list="#arguments.LANCTO_ID#" delimiters=",">
					<cfif ListGetAt(i,2,'_') eq 2>
						<cfstoredproc procedure="oper.pkg_abastecimento.prc_del_viagem_recibo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
							<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_RECIBO_VIAGEM" value="#GetToken(i,1,'_')#">
						</cfstoredproc>
					<cfelse>
						<cfstoredproc procedure="oper.pkg_pedagio_dml.prc_del_pedagio_lancto" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
							<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_LANCTO_ID" value="#GetToken(i,1,'_')#">
						</cfstoredproc>
					</cfif>
				</cfloop>
				<cfset retorno.erro = false>
				<cfif arguments.LANCTO_ID eq 0>
					<cfset retorno.mensagem = JSStringFormat("Nenhum pedgio foi selecionado para a excluso!")>
				<cfelse>
					<cfset retorno.mensagem = JSStringFormat("Pedgio excludo com sucesso!")>
				</cfif>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Imprime relao de documentos em aberto para o usurio conectado.
	-- 29/12/2005 - criado
	--->
	<cffunction name="fecha_relacao_pedagio" displayname="Imprime relao de documentos em aberto para o usurio conectado." access="remote" returntype="Struct" output="true">
		<cfargument name="COD_PESSOA" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="oper.pkg_pedagio_dml.prc_fecha_relacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_PESSOA" value="#arguments.COD_PESSOA#" null="#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#" >
					<cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="P_RELACAO_ID" variable="retorno.RELACAO_ID" >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Relao fechada com sucesso.")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um recibo de despesa de viagem
	-- 30/12/2005 - criado
	--->
	<cffunction name="ins_recibo" displayname="Insere um recibo de despesa de viagem" access="remote" returntype="Struct" output="true">
		<cfargument name="NUM_RECIBO_VIAGEM" required="yes">
		<cfargument name="NUM_DOCUMENTO" required="yes">
		<cfargument name="PRODUTO_ID" required="yes">
		<cfargument name="COMPLEMENTO" required="yes">
		<cfargument name="PLACA" required="yes">
		<cfargument name="DATA" required="yes">
		<cfargument name="VALOR" required="yes">
		<cfargument name="COD_PESSOA" required="yes">
		<cfargument name="QUANTIDADE" required="no" default="">
		<cfargument name="PNEU_ID" required="no" default="">
		<cfargument name="NUM_LIBERACAO" required="yes">
		<cfargument name="KM" required="no" default="">
	
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="oper.pkg_abastecimento.prc_ins_viagem_recibo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="inout" cfsqltype="cf_sql_integer" dbvarname="P_NUM_RECIBO_VIAGEM" value="#arguments.NUM_RECIBO_VIAGEM#" variable="retorno.NUM_RECIBO_VIAGEM" null="#iif(len(trim(arguments.NUM_RECIBO_VIAGEM)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_DOCUMENTO" value="#arguments.NUM_DOCUMENTO#" null="#iif(len(trim(arguments.NUM_DOCUMENTO)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_PRODUTO_ID" value="#arguments.PRODUTO_ID#" null="#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_COMPLEMENTO" value="#arguments.COMPLEMENTO#"  >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_PLACA" value="#UCase(Replace(arguments.PLACA,'-',''))#"  >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA" value="#arguments.DATA#"  >
					<cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_VALOR" value="#arguments.VALOR#" null="#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_PESSOA" value="#arguments.COD_PESSOA#" null="#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_QUANTIDADE" value="#arguments.QUANTIDADE#" null="#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_PNEU_ID" value="#arguments.PNEU_ID#" null="#iif(len(trim(arguments.PNEU_ID)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_LIBERACAO" value="#arguments.NUM_LIBERACAO#" null="#iif(len(trim(arguments.NUM_LIBERACAO)), de('no'), de('yes'))#" >
					<cfprocparam type="inout" cfsqltype="cf_sql_integer" dbvarname="P_KM" value="#arguments.KM#" variable="retorno.KM" null="#iif(len(trim(arguments.KM)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ORIGEM" value="2">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Recibo inserido com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera dados de um recibo lanado
	-- 30/12/2005 - criado
	--->
	<cffunction name="upd_recibo" displayname="Altera dados de um recibo lanado" access="remote" returntype="Struct" output="true">
		<cfargument name="NUM_RECIBO_VIAGEM" required="yes">
		<cfargument name="KM" required="no" default="">
		<cfargument name="NUM_LIBERACAO" required="yes">
		<cfargument name="PNEU_ID" required="no" default="">
		<cfargument name="QUANTIDADE" required="no" default="">
		<cfargument name="COD_PESSOA" required="yes">
		<cfargument name="VALOR" required="yes">
		<cfargument name="DATA" required="yes">
		<cfargument name="PLACA" required="yes">
		<cfargument name="COMPLEMENTO" required="yes">
		<cfargument name="PRODUTO_ID" required="yes">
		<cfargument name="NUM_DOCUMENTO" required="yes">
	
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="oper.pkg_abastecimento.prc_alt_viagem_recibo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_RECIBO_VIAGEM" value="#arguments.NUM_RECIBO_VIAGEM#" null="#iif(len(trim(arguments.NUM_RECIBO_VIAGEM)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_KM" value="#arguments.KM#" null="#iif(len(trim(arguments.KM)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_LIBERACAO" value="#arguments.NUM_LIBERACAO#" null="#iif(len(trim(arguments.NUM_LIBERACAO)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_PNEU_ID" value="#arguments.PNEU_ID#" null="#iif(len(trim(arguments.PNEU_ID)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_LANCTO_CCORRENTE" null="yes" >
					<cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_QUANTIDADE" value="#arguments.QUANTIDADE#" null="#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_PESSOA" value="#arguments.COD_PESSOA#" null="#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_VALOR" value="#arguments.VALOR#" null="#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA" value="#arguments.DATA#"  >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_PLACA" value="#UCase(Replace(arguments.PLACA,'-',''))#"  >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_COMPLEMENTO" value="#arguments.COMPLEMENTO#"  >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_PRODUTO_ID" value="#arguments.PRODUTO_ID#" null="#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_DOCUMENTO" value="#arguments.NUM_DOCUMENTO#" null="#iif(len(trim(arguments.NUM_DOCUMENTO)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_RELACAO_ID" null="yes" >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Recibo de viagem alterado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui recibo de viagem
	-- 28/12/2005 - criado
	--->
	<cffunction name="del_recibo" displayname="Exclui recibo de viagem" access="remote" returntype="Struct" output="true">
		<cfargument name="LANCTO_ID" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfloop index="i" list="#arguments.LANCTO_ID#" delimiters=",">
					<cfif ListGetAt(i,2,'_') eq 2>
						<cfstoredproc procedure="oper.pkg_abastecimento.prc_del_viagem_recibo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
							<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_RECIBO_VIAGEM" value="#GetToken(i,1,'_')#">
						</cfstoredproc>
					<cfelse>						
						<cfstoredproc procedure="oper.pkg_pedagio_dml.prc_del_pedagio_lancto" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
							<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_LANCTO_ID" value="#GetToken(i,1,'_')#">
						</cfstoredproc>
					</cfif>
				</cfloop>
				<cfset retorno.erro = false>
				<cfif arguments.LANCTO_ID eq 0>
					<cfset retorno.mensagem = JSStringFormat("Nenhum recibo foi selecionado para a excluso!")>
				<cfelse>
					<cfset retorno.mensagem = JSStringFormat("Recibo de viagem excludo com sucesso!")>
				</cfif>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere lanamento de dbito para recarga do carto pedgio
	-- 28/12/2005 - criado
	--->
	<cffunction name="ins_debito_cartao_pedagio" displayname="Lanamento de despesas avulsas" access="remote" returntype="struct" output="true">
		<cfargument name="cod_pessoa" required="yes"/>
		<cfargument name="nome_motorista" required="yes" />
		<cfargument name="data_lancamento" required="yes"/>
		<cfargument name="valor" required="yes"/>
		<cftry>
			<cftransaction action="begin">
				<cfquery datasource="#session.dsn#" name="qr_ccorrente" username="#session.usuario#" password="#session.senha#">
					select /*+ORDERED */ cc.cod_conta, oper.pkg_global.fnc_get_parametro(16,'LOGISTICA') as limite_debito_cartao_pedagio
					  from oper.v$ccorrente cc 
					 where cc.cod_pessoa = #arguments.cod_pessoa#
					   and cc.modalidade_id = 4  
					   and cc.ativo = 1 
				</cfquery>
				
				<cfif not qr_ccorrente.RecordCount>
					<cfset retorno.erro = true>		
					<cfset retorno.mensagem = 'Impossvel fazer o lanamento, conta corrente no encontrada.'>					
                    <cfthrow message="Impossvel fazer o lanamento, conta corrente no encontrada." errorcode="20000" >
					<cfreturn retorno>
				</cfif>
	
				<cfif qr_ccorrente.limite_debito_cartao_pedagio lt arguments.valor >
					<cfset retorno.erro = true>		
					<cfset retorno.mensagem = 'Valor do lanamento superior ao permitido para dbito em conta relacionado a carto pedgio.'>					
                    <cfthrow message="Valor do lanamento superior ao permitido para dbito em conta relacionado a carto pedgio." errorcode="20000" >
					<cfreturn retorno>
				</cfif>
	
				<cfset v_debito_credito = 0>
	
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_ccorrente.prc_insere_lancto_ccorrente" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="inout" dbvarname="p_num_lancamento" cfsqltype="cf_sql_integer" null="yes" variable="retorno.num_lancamento">
					<cfprocparam type="in" dbvarname="p_cod_conta" 		   cfsqltype="cf_sql_integer" value="#qr_ccorrente.cod_conta#">
					<cfprocparam type="in" dbvarname="p_cod_pessoa_un" 	   cfsqltype="cf_sql_integer" value="1">
					<cfprocparam type="in" dbvarname="p_cod_documento" 	   cfsqltype="cf_sql_integer" value="375">
					<cfprocparam type="in" dbvarname="p_num_documento" 	   cfsqltype="cf_sql_integer" value="#DateFormat(Now(),'yyyy')##DateFormat(Now(),'mm')#">
					<cfprocparam type="in" dbvarname="p_data_lancamento"   cfsqltype="cf_sql_varchar" value="#arguments.data_lancamento#">
					<cfprocparam type="in" dbvarname="p_data_vencto" 	   cfsqltype="cf_sql_varchar" value="#arguments.data_lancamento#">
					<cfprocparam type="in" dbvarname="p_historico" 		   cfsqltype="cf_sql_varchar" value="Recarga do carto de pedgio.">
					<cfprocparam type="in" dbvarname="p_valor_lancamento"  cfsqltype="cf_sql_float"   value="#arguments.valor#">
					<cfprocparam type="in" dbvarname="p_deb_cred" 		   cfsqltype="cf_sql_integer" value="#v_debito_credito#">
					<cfprocparam type="in" dbvarname="p_favorecido" 	   cfsqltype="cf_sql_varchar" value="#arguments.nome_motorista#">
					<cfprocparam type="inout" dbvarname="p_rowid" 		   cfsqltype="cf_sql_varchar" variable="retorno.rowid" null="yes">					
				</cfstoredproc>
	
				<cfset retorno.erro = false>		
				<cfset retorno.mensagem = 'Lanamento feito com sucesso.'>		
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui lanamento de dbito para recarga do carto pedgio
	-- 28/12/2005 - criado
	--->
	<cffunction name="del_debito_cartao_pedagio" displayname="Exclui lanamento de dbito para recarga do carto pedgio" access="remote" returntype="struct" output="true">
		<cfargument name="num_lancamento" displayname="Nmero do lanamento"  required="true">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_ccorrente.prc_excluir_lancto_ccorrente" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" dbvarname="p_num_lancamento" cfsqltype="cf_sql_integer" value="#arguments.num_lancamento#">
				</cfstoredproc>
				<cfset retorno.erro = false>		
				<cfset retorno.mensagem = 'Lanamento excludo com sucesso.'>		
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>	
	
</cfcomponent>