<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!---  
	-- PROPSITO 
	-- Insere uma SD
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_solicitacao" access="remote" returntype="Struct" output="true">
		<cfargument name="titulo" required="yes">
		<cfargument name="data_limite_programacao" required="yes">
		<cfargument name="data_limite_entrega" required="yes">
		<cfargument name="aplicacao" required="yes">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="cliente" required="yes">
		<cfargument name="tipo_id" required="yes">
		<cfargument name="resp_solicitacao" required="yes">
		<cfargument name="resp_tecnico" required="no" default="">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_ins_solicitacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_titulo" type="in" value="#arguments.titulo#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_data" type="in" value="#DateFormat(now(), 'DD/MM/YYYY')#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_data_limite_programacao" type="in" value="#arguments.data_limite_programacao#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_data_limite_entrega" type="in" value="#arguments.data_limite_entrega#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_aplicacao" type="in" value="#arguments.aplicacao#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_projeto_id" type="in" value="#arguments.projeto_id#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_cliente" type="in" value="#arguments.cliente#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_tipo_id" type="in" value="#arguments.tipo_id#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_resp_solicitacao" type="in" value="#arguments.resp_solicitacao#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_resp_tecnico" type="in" value="#arguments.resp_tecnico#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_solicitacao_id" type="out" variable="retorno.solicitacao_id" cfsqltype="cf_sql_integer">
				</cfstoredproc>
                
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ITEM_ID_DESCRICAO");
					v_grupo_id = this.ListaToArray (lista = arguments, variavel = "GRUPO_ID_DESCRICAO");
					v_texto = this.ListaToArray (lista = arguments, variavel = "TEXTO_DESCRICAO_DESCRICAO");
					v_confirmado = this.ListaToArray (lista = arguments, variavel = "CONFIRMADO_DESCRICAO");
				</cfscript>
				<cfloop list="#arguments.lista_deleted_DESCRICAO#" delimiters="," index="l_id">
					<cfscript>
						this.del_descricao(solicitacao_id = retorno.solicitacao_id,
										   item_id   = ListGetAt(l_id,1,"_"),
										   grupo_id	 = ListGetAt(l_id,2,"_"));
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_descricao(	solicitacao_id = retorno.solicitacao_id,
												grupo_id = v_grupo_id[count],
												conferido = v_confirmado[count],
											   	texto = v_texto[count]);
						} else {
							this.upd_descricao(	solicitacao_id = retorno.solicitacao_id,
												grupo_id = v_grupo_id[count],
												conferido = v_confirmado[count],
											   	texto = v_texto[count],
												item_id = v_item_id[count]);
						}
					</cfscript>
				</cfloop>				


				<cfscript>
					v_anexo_id = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_ANEXOS");
				</cfscript>
				<cfloop list="#arguments.lista_deleted_ANEXOS#" delimiters="," index="l_id">
					<cfscript>
						this.del_anexo_solicitacao(solicitacao_id = retorno.solicitacao_id,
													anexo_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_anexo_id)#" index="count">
					<cfscript>
						this.ins_anexo_solicitacao(	solicitacao_id = retorno.solicitacao_id,
													anexo_id = v_anexo_id[count]);
					</cfscript>
				</cfloop>			
				
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "IMPLEMENTACAO_ID_IMPLEMENTACOES");
					v_texto = this.ListaToArray (lista = arguments, variavel = "TEXTO_IMPLEMENTACAO_IMPLEMENTACOES");
					v_anexo_id = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_IMPL_IMPLEMENTACOES");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_IMPLEMENTACOES, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_implementacao(solicitacao_id = retorno.solicitacao_id,
										   		implementacao_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_implementacao(	solicitacao_id = retorno.solicitacao_id,
												anexo_id = v_anexo_id[count],
											   	texto = v_texto[count]);
						} else {
							this.upd_implementacao(	solicitacao_id = retorno.solicitacao_id,
												implementacao_id = v_item_id[count],
												anexo_id = v_anexo_id[count],
											   	texto = v_texto[count]);
						}
					</cfscript>
				</cfloop>	
				
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "INSTALACAO_ID_INSTALACAO");
					v_texto = this.ListaToArray (lista = arguments, variavel = "TEXTO_INSTALACAO_INSTALACAO");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_INSTALACAO, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_instalacao(solicitacao_id = retorno.solicitacao_id,
										   		orientacao_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_instalacao(solicitacao_id = retorno.solicitacao_id,
											   	texto = v_texto[count]);
						} else {
							this.upd_instalacao(solicitacao_id = retorno.solicitacao_id,
												orientacao_id = v_item_id[count],
												texto = v_texto[count]);
						}
					</cfscript>
				</cfloop>	
				
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "USO_ID_USOS");
					v_texto = this.ListaToArray (lista = arguments, variavel = "TEXTO_USO_USOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_USOS, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_uso(solicitacao_id = retorno.solicitacao_id,
										   		orientacao_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_uso(solicitacao_id = retorno.solicitacao_id,
											   	texto = v_texto[count]);
						} else {
							this.upd_uso(solicitacao_id = retorno.solicitacao_id,
												orientacao_id = v_item_id[count],
												texto = v_texto[count]);
						}
					</cfscript>
				</cfloop>	
				
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "NAO_CONFORMIDADE_ID_NAO_CONFORMIDADES");
					v_texto = this.ListaToArray (lista = arguments, variavel = "OBSERVACAO_NAO_CONF_NAO_CONFORMIDADES");
					v_ocorrencia = this.ListaToArray (lista = arguments, variavel = "OCORRENCIA_NAO_CONFORMIDADES");
					v_registrado_por = this.ListaToArray (lista = arguments, variavel = "REGISTRADO_POR_NAO_CONFORMIDADES");
				</cfscript>
				<cfloop list="#arguments.lista_deleted_NAO_CONFORMIDADES#" delimiters="," index="l_id">
					<cfscript>
						this.del_nao_conformidade_solicitacao(solicitacao_id = retorno.solicitacao_id,
										   					  nao_conformidade_id = listGetAt(l_id, 1, '_'),
															  ocorrencia = listGetAt(l_id, 2, '_'));
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_ocorrencia[count]))) {
							this.ins_nao_conformidade_solicitacao(solicitacao_id = retorno.solicitacao_id,
																	nao_conformidade_id = v_item_id[count],
											   						observacao = v_texto[count],
																	registrado_por = v_registrado_por[count]);
						} else {
							this.upd_nao_conformidade_solicitacao(solicitacao_id = retorno.solicitacao_id,
																	nao_conformidade_id = v_item_id[count],
																	ocorrencia = v_ocorrencia[count],
											   						observacao = v_texto[count],
																	registrado_por = v_registrado_por[count]);
						}
					</cfscript>
				</cfloop>					
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Solicitacao inserida com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Altera uma SD
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_solicitacao" access="remote" returntype="Struct" output="true">
		<cfargument name="solicitacao_id" required="yes">
		<cfargument name="titulo" required="yes">
		<cfargument name="situacao_id" required="no" default="1">
		<cfargument name="data_limite_programacao" required="yes">
		<cfargument name="data_limite_entrega" required="yes">
		<cfargument name="aplicacao" required="yes">
		<cfargument name="projeto_id" required="no" default="0">
		<cfargument name="cliente" required="yes">
		<cfargument name="tipo_id" required="yes">
		<cfargument name="resp_solicitacao" required="yes">
		<cfargument name="resp_tecnico" required="no" default="">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_alt_solicitacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_solicitacao_id" type="in" value="#arguments.solicitacao_id#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_titulo" type="in" value="#arguments.titulo#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_data_limite_programacao" type="in" value="#arguments.data_limite_programacao#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_data_limite_entrega" type="in" value="#arguments.data_limite_entrega#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_aplicacao" type="in" value="#arguments.aplicacao#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_projeto_id" type="in" value="#arguments.projeto_id#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_cliente" type="in" value="#arguments.cliente#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_tipo_id" type="in" value="#arguments.tipo_id#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_resp_solicitacao" type="in" value="#arguments.resp_solicitacao#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_resp_tecnico" type="in" value="#arguments.resp_tecnico#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_situacao_id" type="in" value="#arguments.situacao_id#" cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<cfscript>
					retorno.solicitacao_id = arguments.solicitacao_id;
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ITEM_ID_DESCRICAO");
					v_grupo_id = this.ListaToArray (lista = arguments, variavel = "GRUPO_ID_DESCRICAO");
					v_texto = this.ListaToArray (lista = arguments, variavel = "TEXTO_DESCRICAO_DESCRICAO");
					v_confirmado = this.ListaToArray (lista = arguments, variavel = "CONFIRMADO_DESCRICAO");
				</cfscript>
				<cfloop list="#arguments.lista_deleted_DESCRICAO#" delimiters="," index="l_id">
					<cfscript>
						this.del_descricao(solicitacao_id = retorno.solicitacao_id,
										   item_id   = ListGetAt(l_id,1,"_"),
										   grupo_id	 = ListGetAt(l_id,2,"_"));
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_descricao(	solicitacao_id = retorno.solicitacao_id,
												grupo_id = v_grupo_id[count],
												conferido = v_confirmado[count],
											   	texto = v_texto[count]);
						} else {
							this.upd_descricao(	solicitacao_id = retorno.solicitacao_id,
												grupo_id = v_grupo_id[count],
												conferido = v_confirmado[count],
											   	texto = v_texto[count],
												item_id = v_item_id[count]);
						}
					</cfscript>
				</cfloop>				


				<cfscript>
					v_anexo_id = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_ANEXOS");
				</cfscript>
				<cfloop list="#arguments.lista_deleted_ANEXOS#" delimiters="," index="l_id">
					<cfscript>
						this.del_anexo_solicitacao(solicitacao_id = retorno.solicitacao_id,
													anexo_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_anexo_id)#" index="count">
					<cfscript>
						this.ins_anexo_solicitacao(	solicitacao_id = retorno.solicitacao_id,
													anexo_id = v_anexo_id[count]);
					</cfscript>
				</cfloop>			
				
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "IMPLEMENTACAO_ID_IMPLEMENTACOES");
					v_texto = this.ListaToArray (lista = arguments, variavel = "TEXTO_IMPLEMENTACAO_IMPLEMENTACOES");
					v_anexo_id = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_IMPL_IMPLEMENTACOES");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_IMPLEMENTACOES, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_implementacao(solicitacao_id = retorno.solicitacao_id,
										   		implementacao_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_implementacao(	solicitacao_id = retorno.solicitacao_id,
												anexo_id = v_anexo_id[count],
											   	texto = v_texto[count]);
						} else {
							this.upd_implementacao(	solicitacao_id = retorno.solicitacao_id,
												implementacao_id = v_item_id[count],
												anexo_id = v_anexo_id[count],
											   	texto = v_texto[count]);
						}
					</cfscript>
				</cfloop>	
				
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "INSTALACAO_ID_INSTALACAO");
					v_texto = this.ListaToArray (lista = arguments, variavel = "TEXTO_INSTALACAO_INSTALACAO");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_INSTALACAO, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_instalacao(solicitacao_id = retorno.solicitacao_id,
										   		orientacao_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_instalacao(solicitacao_id = retorno.solicitacao_id,
											   	texto = v_texto[count]);
						} else {
							this.upd_instalacao(solicitacao_id = retorno.solicitacao_id,
												orientacao_id = v_item_id[count],
												texto = v_texto[count]);
						}
					</cfscript>
				</cfloop>	
				
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "USO_ID_USOS");
					v_texto = this.ListaToArray (lista = arguments, variavel = "TEXTO_USO_USOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_USOS, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_uso(solicitacao_id = retorno.solicitacao_id,
										   		orientacao_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_uso(solicitacao_id = retorno.solicitacao_id,
											   	texto = v_texto[count]);
						} else {
							this.upd_uso(solicitacao_id = retorno.solicitacao_id,
												orientacao_id = v_item_id[count],
												texto = v_texto[count]);
						}
					</cfscript>
				</cfloop>	
				
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "NAO_CONFORMIDADE_ID_NAO_CONFORMIDADES");
					v_texto = this.ListaToArray (lista = arguments, variavel = "OBSERVACAO_NAO_CONF_NAO_CONFORMIDADES");
					v_ocorrencia = this.ListaToArray (lista = arguments, variavel = "OCORRENCIA_NAO_CONFORMIDADES");
					v_registrado_por = this.ListaToArray (lista = arguments, variavel = "REGISTRADO_POR_NAO_CONFORMIDADES");
				</cfscript>
				<cfloop list="#arguments.lista_deleted_NAO_CONFORMIDADES#" delimiters="," index="l_id">
					<cfscript>
						this.del_nao_conformidade_solicitacao(solicitacao_id = retorno.solicitacao_id,
										   					  nao_conformidade_id = listGetAt(l_id, 1, '_'),
															  ocorrencia = listGetAt(l_id, 2, '_'));
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_ocorrencia[count]))) {
							this.ins_nao_conformidade_solicitacao(solicitacao_id = retorno.solicitacao_id,
																	nao_conformidade_id = v_item_id[count],
											   						observacao = v_texto[count],
																	registrado_por = v_registrado_por[count]);
						} else {
							this.upd_nao_conformidade_solicitacao(solicitacao_id = retorno.solicitacao_id,
																	nao_conformidade_id = v_item_id[count],
																	ocorrencia = v_ocorrencia[count],
											   						observacao = v_texto[count],
																	registrado_por = v_registrado_por[count]);
						}
					</cfscript>
				</cfloop>	
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Solicitacao alterada com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Exclui uma SD
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_solicitacao" access="remote" returntype="Struct" output="true">
		<cfargument name="solicitacao_id" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_del_solicitacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_solicitacao_id" type="in" value="#arguments.solicitacao_id#" cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Solicitacao excluida com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Aceita uma SD
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="aceite_solicitacao" access="remote" returntype="Struct" output="true">		
		<cfargument name="solicitacao_id" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_aceite_solicitacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_solicitacao_id" type="in" value="#arguments.solicitacao_id#" cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Solicitacao aceita com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Insere uma descricao na SD
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_descricao" access="remote" returntype="Struct" output="true">
		<cfargument name="solicitacao_id" required="yes">
		<cfargument name="grupo_id" required="yes">
		<cfargument name="texto" required="yes">
		<cfargument name="conferido" required="no" default="0">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_ins_descricao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_solicitacao_id" type="in" value="#arguments.solicitacao_id#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_grupo_id" type="in" value="#arguments.grupo_id#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_texto" type="in" value="#arguments.texto#" cfsqltype="cf_sql_varchar">				
			<cfprocparam dbvarname="p_conferido" type="in" value="#arguments.conferido#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_item_id" type="out" variable="retorno.item_id" cfsqltype="cf_sql_integer">				
		</cfstoredproc>
		<cfreturn retorno />		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Altera uma descricao na SD
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_descricao" access="remote" returntype="Struct" output="true">
		<cfargument name="item_id" required="yes">
		<cfargument name="solicitacao_id" required="yes">
		<cfargument name="grupo_id" required="yes">
		<cfargument name="texto" required="yes">
		<cfargument name="conferido" required="no" default="0">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_alt_descricao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_item_id" type="in" value="#arguments.item_id#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_solicitacao_id" type="in" value="#arguments.solicitacao_id#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_grupo_id" type="in" value="#arguments.grupo_id#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_texto" type="in" value="#arguments.texto#" cfsqltype="cf_sql_varchar">				
			<cfprocparam dbvarname="p_conferido" type="in" value="#arguments.conferido#" cfsqltype="cf_sql_integer">				
		</cfstoredproc>
		<cfreturn StructNew() />		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Exclui uma descricao na SD
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_descricao" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
		<cfargument name="item_id" required="yes">
		<cfargument name="solicitacao_id" required="yes">
		<cfargument name="grupo_id" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_del_descricao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_item_id" type="in" value="#arguments.item_id#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_solicitacao_id" type="in" value="#arguments.solicitacao_id#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_grupo_id" type="in" value="#arguments.grupo_id#" cfsqltype="cf_sql_integer">				
		</cfstoredproc>
		<cfreturn structnew() />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Insere um anexo na SD
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_anexo_solicitacao" access="remote" returntype="Struct" output="true">
		<cfargument name="anexo_id" required="yes">
		<cfargument name="solicitacao_id" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_ins_anexo_solicitacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_solicitacao_id" type="in" value="#arguments.solicitacao_id#" cfsqltype="cf_sql_integer">

			<cfprocparam dbvarname="p_anexo_id" type="in" value="#arguments.anexo_id#" cfsqltype="cf_sql_integer">
		</cfstoredproc>
		<cfreturn structnew() />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Exclui um anexo da SD
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_anexo_solicitacao" access="remote" returntype="Struct" output="true">
		<cfargument name="anexo_id" required="yes">
		<cfargument name="solicitacao_id" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_del_anexo_solicitacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_solicitacao_id" type="in" value="#arguments.solicitacao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_anexo_id" type="in" value="#arguments.anexo_id#" cfsqltype="cf_sql_integer">
		</cfstoredproc>
		<cfreturn structNew() />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Insere uma implementacao da SD
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_implementacao" access="remote" returntype="Struct" output="true">
		<cfargument name="solicitacao_id" required="yes">
		<cfargument name="texto" required="yes">
		<cfargument name="anexo_id" required="no" default="">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_ins_implementacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_solicitacao_id" type="in" value="#arguments.solicitacao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_texto" type="in" value="#arguments.texto#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_anexo_id" type="in" value="#arguments.anexo_id#" cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.anexo_id)), de('no'), de('yes'))#">
			<cfprocparam dbvarname="p_implementacao_id" type="out" variable="retorno.implementacao_id" cfsqltype="cf_sql_integer">
		</cfstoredproc>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Altera uma implementacao da SD
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_implementacao" access="remote" returntype="Struct" output="true">
		<cfargument name="implementacao_id" required="yes">
		<cfargument name="solicitacao_id" required="yes">
		<cfargument name="texto" required="yes">
		<cfargument name="anexo_id" required="no" default="">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_alt_implementacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_solicitacao_id" type="in" value="#arguments.solicitacao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_implementacao_id" type="in" value="#arguments.implementacao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_texto" type="in" value="#arguments.texto#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_anexo_id" type="in" value="#arguments.anexo_id#" cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.anexo_id)), de('no'), de('yes'))#">
		</cfstoredproc>
		<cfreturn StructNew() />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Exclui uma implementacao da SD
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_implementacao" access="remote" returntype="Struct" output="true">
		<cfargument name="implementacao_id" required="yes">
		<cfargument name="solicitacao_id" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_del_implementacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_solicitacao_id" type="in" value="#arguments.solicitacao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_implementacao_id" type="in" value="#arguments.implementacao_id#" cfsqltype="cf_sql_integer">
		</cfstoredproc>
		<cfreturn structNew() />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Insere uma instrucao de instalao na SD
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_instalacao" access="remote" returntype="Struct" output="true">
		<cfargument name="solicitacao_id" required="yes">
		<cfargument name="texto" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_ins_instalacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_solicitacao_id" type="in" value="#arguments.solicitacao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_texto" type="in" value="#arguments.texto#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_orientacao_id" type="out" variable="retorno.orientacao_id" cfsqltype="cf_sql_integer">				
		</cfstoredproc>
		<cfreturn retorno />		
	</cffunction> 

	<!--- 
	-- PROPSITO 
	-- Altera uma instalacao da SD
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_instalacao" access="remote" returntype="Struct" output="true">
		<cfargument name="orientacao_id" required="yes">
		<cfargument name="solicitacao_id" required="yes">
		<cfargument name="texto" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_alt_instalacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_orientacao_id" type="in" value="#arguments.orientacao_id#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_solicitacao_id" type="in" value="#arguments.solicitacao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_texto" type="in" value="#arguments.texto#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>
		<cfreturn StructNew() />		
	</cffunction> 

	<!--- 
	-- PROPSITO 
	-- Exclui uma orientacao de instalacao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_instalacao" access="remote" returntype="Struct" output="true">
		<cfargument name="orientacao_id" required="yes">
		<cfargument name="solicitacao_id" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_del_instalacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_orientacao_id" type="in" value="#arguments.orientacao_id#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_solicitacao_id" type="in" value="#arguments.solicitacao_id#" cfsqltype="cf_sql_integer">
		</cfstoredproc>
		<cfreturn StructNew() />		
	</cffunction> 

	<!--- 
	-- PROPSITO 
	-- Insere uma orientacao de uso 
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_uso" access="remote" returntype="Struct" output="true">
		<cfargument name="solicitacao_id" required="yes">
		<cfargument name="texto" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_ins_uso" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_solicitacao_id" type="in" value="#arguments.solicitacao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_texto" type="in" value="#arguments.texto#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_orientacao_id" type="out" variable="retorno.orientacao_id" cfsqltype="cf_sql_integer">				
		</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Altera uma orientacao de uso 
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_uso" access="remote" returntype="Struct" output="true">
		<cfargument name="orientacao_id" required="yes">
		<cfargument name="solicitacao_id" required="yes">
		<cfargument name="texto" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_alt_uso" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_orientacao_id" type="in" value="#arguments.orientacao_id#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_solicitacao_id" type="in" value="#arguments.solicitacao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_texto" type="in" value="#arguments.texto#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>
		<cfreturn StructNew() />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Exclui uma orientacao de uso 
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_uso" access="remote" returntype="Struct" output="true">
		<cfargument name="orientacao_id" required="yes">
		<cfargument name="solicitacao_id" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_del_uso" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_orientacao_id" type="in" value="#arguments.orientacao_id#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_solicitacao_id" type="in" value="#arguments.solicitacao_id#" cfsqltype="cf_sql_integer">
		</cfstoredproc>
		<cfreturn structNew() />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Insere uma nao conformidade da SD
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_nao_conformidade_solicitacao" access="remote" returntype="Struct" output="true">
		<cfargument name="solicitacao_id" required="yes">
		<cfargument name="observacao" required="yes">
		<cfargument name="nao_conformidade_id" required="yes">
		<cfargument name="registrado_por" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_ins_nao_conf_solic" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_nao_conformidade_id" type="in" value="#arguments.nao_conformidade_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_solicitacao_id" type="in" value="#val(arguments.solicitacao_id)#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_observacao" type="in" value="#arguments.observacao#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_registrado_por" type="in" value="#arguments.registrado_por#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_ocorrencia" type="out" variable="retorno.ocorrencia" cfsqltype="cf_sql_integer">
		</cfstoredproc>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Altera uma nao conformidade da SD
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_nao_conformidade_solicitacao" access="remote" returntype="Struct" output="true">
		<cfargument name="nao_conformidade_id" required="yes">
		<cfargument name="solicitacao_id" required="yes">
		<cfargument name="ocorrencia" required="yes">
		<cfargument name="observacao" required="yes">
		<cfargument name="registrado_por" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_alt_nao_conf_solic" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_nao_conformidade_id" type="in" value="#arguments.nao_conformidade_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_solicitacao_id" type="in" value="#arguments.solicitacao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_ocorrencia" type="in" value="#arguments.ocorrencia#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_observacao" type="in" value="#arguments.observacao#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_registrado_por" type="in" value="#arguments.registrado_por#" cfsqltype="cf_sql_integer">
		</cfstoredproc>
		<cfreturn structNew() />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Exclui uma nao conformidade da SD
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_nao_conformidade_solicitacao" access="remote" returntype="Struct" output="true">
		<cfargument name="nao_conformidade_id" required="yes">
		<cfargument name="solicitacao_id" required="yes">
		<cfargument name="ocorrencia" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_del_nao_conf_solic" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_nao_conformidade_id" type="in" value="#arguments.nao_conformidade_id#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_solicitacao_id" type="in" value="#arguments.solicitacao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_ocorrencia" type="in" value="#arguments.ocorrencia#" cfsqltype="cf_sql_integer">
		</cfstoredproc>
		<cfreturn StructNew() />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Insere uma nao conformidade
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_nao_conformidade" access="remote" returntype="Struct" output="true">
		<cfargument name="descricao" required="yes">
		<cfargument name="gravidade" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_ins_nao_conformidade" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_descricao" type="in" value="#arguments.descricao#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_gravidade" type="in" value="#arguments.gravidade#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_nao_conformidade_id" type="out" variable="retorno.nao_conformidade_id" cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Nao-conformidade inserida com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Altera uma nao conformidade
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_nao_conformidade" access="remote" returntype="Struct" output="true">
		<cfargument name="nao_conformidade_id" required="yes">
		<cfargument name="descricao" required="yes">
		<cfargument name="gravidade" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_alt_nao_conformidade" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_nao_conformidade_id" type="in" value="#arguments.nao_conformidade_id#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_descricao" type="in" value="#arguments.descricao#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_gravidade" type="in" value="#arguments.gravidade#" cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Nao conformidade alterada com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Exclui uma nao conformidade
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_nao_conformidade" access="remote" returntype="Struct" output="true">
		<cfargument name="nao_conformidade_id" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_del_nao_conformidade" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_nao_conformidade_id" type="in" value="#arguments.nao_conformidade_id#" cfsqltype="cf_sql_integer">				
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Nao-conformidade excluida com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Insere uma reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_reuniao" access="remote" returntype="Struct" output="true">
		<cfargument name="titulo" 			required="yes">
		<cfargument name="data" 			required="yes">
		<cfargument name="local" 			required="yes">
		<cfargument name="cliente" 			required="yes">
		<cfargument name="responsavel" 		required="yes">
		<cfargument name="inicio_execucao" 	required="yes">
		<cfargument name="termino_execucao" required="yes">
		<cfargument name="situacao_id" 		required="yes">
		<cfargument name="sd_id"	 	required="yes">
		<cfargument name="projeto_id"	 	required="yes">
		<cfargument name="motivo_cancelamento"	 	required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_ins_reuniao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_titulo" type="in" value="#arguments.titulo#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_data_hora" type="in" value="#arguments.data#:00" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_local" type="in" value="#arguments.local#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_cliente" type="in" value="#arguments.cliente#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_responsavel" type="in" value="#arguments.responsavel#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_inicio_execucao" type="in" value="#arguments.inicio_execucao#:00" cfsqltype="cf_sql_varchar" null="#iif(len(trim(arguments.inicio_execucao)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="p_termino_execucao" type="in" value="#arguments.termino_execucao#:00" cfsqltype="cf_sql_varchar" null="#iif(len(trim(arguments.termino_execucao)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="p_situacao_id" type="in" value="#arguments.situacao_id#" cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.situacao_id)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="p_sd_id" type="in" value="#arguments.sd_id#" cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.sd_id)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="p_projeto_id" type="in" value="#arguments.projeto_id#" cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.projeto_id)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="p_motivo_cancelamento" type="in" value="#arguments.motivo_cancelamento#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_reuniao_id" type="out" variable="retorno.reuniao_id" cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "PARTICIPANTE_ID_PARTICIPANTES");
					v_nome = this.ListaToArray (lista = arguments, variavel = "NOME_PARTICIPANTES");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						this.ins_participante_reuniao(reuniao_id = retorno.reuniao_id,
													   nome = v_nome[count]);
					</cfscript>
				</cfloop>			
				<!--- assuntos --->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ASSUNTO_ID_ASSUNTOS");
					v_texto = this.ListaToArray (lista = arguments, variavel = "TEXTO_ASSUNTO_ASSUNTOS");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
							this.ins_assunto_reuniao(reuniao_id = retorno.reuniao_id,
													   texto = v_texto[count]);
					</cfscript>
				</cfloop>			
				<!--- discussoes --->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "DISCUSSAO_ID_DISCUSSOES");
					v_texto = this.ListaToArray (lista = arguments, variavel = "TEXTO_DISCUSSAO_DISCUSSOES");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
							this.ins_discussao_reuniao(reuniao_id = retorno.reuniao_id,
													   texto = v_texto[count]);
					</cfscript>
				</cfloop>			
				<!--- obrigacoes --->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "OBRIGACAO_ID_OBRIGACOES");
					v_nome = this.ListaToArray (lista = arguments, variavel = "NOME_OBRIGACAO_OBRIGACOES");
					v_texto = this.ListaToArray (lista = arguments, variavel = "TEXTO_OBRIGACAO_OBRIGACOES");
					v_situacao_id = this.ListaToArray (lista = arguments, variavel = "OBRIGACAO_STATUS_OBRIGACOES");
					v_tarefa_id = this.ListaToArray (lista = arguments, variavel = "TAREFA_OBRIGACAO_OBRIGACOES");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
							this.ins_obrigacao_reuniao(reuniao_id = retorno.reuniao_id,
													   texto = v_texto[count],
													   nome = v_nome[count],
													   tarefa_id = v_tarefa_id[count],
													   situacao_id = v_situacao_id[count]);
					</cfscript>
				</cfloop>			
				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Reuniao inserida com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Altera uma reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_reuniao" access="remote" returntype="Struct" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfargument name="titulo" required="yes">
		<cfargument name="data" required="yes">
		<cfargument name="local" required="yes">
		<cfargument name="cliente" required="yes">
		<cfargument name="responsavel" required="yes">
		<cfargument name="inicio_execucao" 	required="yes">
		<cfargument name="termino_execucao" required="yes">
		<cfargument name="situacao_id" 		required="yes">
		<cfargument name="sd_id"	 	required="yes">
		<cfargument name="projeto_id"	 	required="yes">
		<cfargument name="motivo_cancelamento"	 	required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_alt_reuniao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_reuniao_id" type="in" value="#arguments.reuniao_id#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_titulo" type="in" value="#arguments.titulo#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_data_hora" type="in" value="#arguments.data#:00" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_local" type="in" value="#arguments.local#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_cliente" type="in" value="#arguments.cliente#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_responsavel" type="in" value="#arguments.responsavel#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_inicio_execucao" type="in" value="#arguments.inicio_execucao#:00" cfsqltype="cf_sql_varchar" null="#iif(len(trim(arguments.inicio_execucao)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="p_termino_execucao" type="in" value="#arguments.termino_execucao#:00" cfsqltype="cf_sql_varchar" null="#iif(len(trim(arguments.termino_execucao)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="p_situacao_id" type="in" value="#arguments.situacao_id#" cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.situacao_id)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="p_sd_id" type="in" value="#arguments.sd_id#" cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.sd_id)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="p_projeto_id" type="in" value="#arguments.projeto_id#" cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.projeto_id)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="p_motivo_cancelamento" type="in" value="#arguments.motivo_cancelamento#" cfsqltype="cf_sql_varchar">
				</cfstoredproc>
				<!--- participantes --->
				<cfscript>
					retorno.reuniao_id = arguments.reuniao_id;
					v_item_id = this.ListaToArray (lista = arguments, variavel = "PARTICIPANTE_ID_PARTICIPANTES");
					v_nome = this.ListaToArray (lista = arguments, variavel = "NOME_PARTICIPANTES");
					v_part_excluir = this.ListDiff(lista1 = arguments.lista_deleted_PARTICIPANTES, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_part_excluir#" delimiters="," index="l_part_excluir">
					<cfscript>
						this.del_participante_reuniao (reuniao_id = retorno.reuniao_id,
													   item_id   = l_part_excluir);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_participante_reuniao(reuniao_id = retorno.reuniao_id,
														   nome = v_nome[count]);
						} else {
							this.upd_participante_reuniao(reuniao_id = retorno.reuniao_id,
														   nome = v_nome[count],
														   item_id = v_item_id[count]);
						}
					</cfscript>
				</cfloop>			
				<!--- assuntos --->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ASSUNTO_ID_ASSUNTOS");
					v_texto = this.ListaToArray (lista = arguments, variavel = "TEXTO_ASSUNTO_ASSUNTOS");
					v_ass_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ASSUNTOS, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_ass_excluir#" delimiters="," index="l_ass_excluir">
					<cfscript>
						this.del_assunto_reuniao (reuniao_id = retorno.reuniao_id,
													   item_id   = l_ass_excluir);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_assunto_reuniao(reuniao_id = retorno.reuniao_id,
													   texto = v_texto[count]);
						} else {
							this.upd_assunto_reuniao(reuniao_id = retorno.reuniao_id,
													   texto = v_texto[count],
													   item_id = v_item_id[count]);
						}
					</cfscript>
				</cfloop>			
				<!--- discussoes --->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "DISCUSSAO_ID_DISCUSSOES");
					v_texto = this.ListaToArray (lista = arguments, variavel = "TEXTO_DISCUSSAO_DISCUSSOES");
					v_disc_excluir = this.ListDiff(lista1 = arguments.lista_deleted_DISCUSSOES, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_disc_excluir#" delimiters="," index="l_disc_excluir">
					<cfscript>
						this.del_discussao_reuniao (reuniao_id = retorno.reuniao_id,
													   item_id   = l_disc_excluir);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_discussao_reuniao(reuniao_id = retorno.reuniao_id,
													   texto = v_texto[count]);
						} else {
							this.upd_discussao_reuniao(reuniao_id = retorno.reuniao_id,
													   texto = v_texto[count],
													   item_id = v_item_id[count]);
						}
					</cfscript>
				</cfloop>			
				<!--- obrigacoes --->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "OBRIGACAO_ID_OBRIGACOES");
					v_nome = this.ListaToArray (lista = arguments, variavel = "NOME_OBRIGACAO_OBRIGACOES");
					v_texto = this.ListaToArray (lista = arguments, variavel = "TEXTO_OBRIGACAO_OBRIGACOES");
					v_situacao_id = this.ListaToArray (lista = arguments, variavel = "OBRIGACAO_STATUS_OBRIGACOES");
					v_tarefa_id = this.ListaToArray (lista = arguments, variavel = "TAREFA_OBRIGACAO_OBRIGACOES");
					v_obr_excluir = this.ListDiff(lista1 = arguments.lista_deleted_OBRIGACOES, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_obr_excluir#" delimiters="," index="l_obr_excluir">
					<cfscript>
						this.del_obrigacao_reuniao (reuniao_id = retorno.reuniao_id,
													   item_id   = l_obr_excluir);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_obrigacao_reuniao(reuniao_id = retorno.reuniao_id,
													   texto = v_texto[count],
													   nome = v_nome[count],
													   tarefa_id = v_tarefa_id[count],
													   situacao_id = v_situacao_id[count]);
						} else {
							this.upd_obrigacao_reuniao(reuniao_id = retorno.reuniao_id,
													   texto = v_texto[count],
													   nome = v_nome[count],
													   item_id = v_item_id[count],
													   tarefa_id = v_tarefa_id[count],
													   situacao_id = v_situacao_id[count]);
						}
					</cfscript>
				</cfloop>			
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Reuniao alterada com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Exclui uma reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_reuniao" access="remote" returntype="Struct" output="true">			
		<cfargument name="reuniao_id" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_del_reuniao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_reuniao_id" type="in" value="#arguments.reuniao_id#" cfsqltype="cf_sql_integer">				
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Reuniao excluida com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Insere um participante da reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_participante_reuniao" access="package" returntype="Struct" output="true">			
		<cfargument name="reuniao_id" required="yes">
		<cfargument name="nome" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_ins_participante_reuniao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_reuniao_id" type="in" value="#arguments.reuniao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_nome" type="in" value="#arguments.nome#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_item_id" type="out" variable="retorno.item_id" cfsqltype="cf_sql_integer">
		</cfstoredproc>
		<cfreturn structNew() />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Altera um participante da reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_participante_reuniao" access="remote" returntype="Struct" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfargument name="nome" required="yes">
		<cfargument name="item_id" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_alt_participante_reuniao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_reuniao" type="in" value="#arguments.reuniao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_item_id" type="in" value="#arguments.item_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_nome" type="in" value="#arguments.nome#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>
		<cfreturn structNew() />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Exclui um participante da reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_participante_reuniao" access="remote" returntype="Struct" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfargument name="item_id" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_del_participante_reuniao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_reuniao_id" type="in" value="#arguments.reuniao_id#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_item_id" type="in" value="#arguments.item_id#" cfsqltype="cf_sql_integer">				
		</cfstoredproc>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Insere um assunto da reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_assunto_reuniao" access="remote" returntype="Struct" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfargument name="texto" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_ins_assunto_reuniao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_reuniao_id" type="in" value="#arguments.reuniao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_texto" type="in" value="#arguments.texto#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_item_id" type="out" variable="retorno.item_id" cfsqltype="cf_sql_integer">
		</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Altera um assunto da reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_assunto_reuniao" access="remote" returntype="Struct" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfargument name="texto" required="yes">
		<cfargument name="item_id" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_alt_assunto_reuniao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_reuniao" type="in" value="#arguments.reuniao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_item_id" type="in" value="#arguments.item_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_texto" type="in" value="#arguments.texto#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>
		<cfreturn structNew() />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Exclui um assunto da reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_assunto_reuniao" access="remote" returntype="Struct" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfargument name="item_id" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_del_assunto_reuniao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_reuniao_id" type="in" value="#arguments.reuniao_id#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_item_id" type="in" value="#arguments.item_id#" cfsqltype="cf_sql_integer">				
		</cfstoredproc>
		<cfreturn structnew() />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Insere uma discussao da reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_discussao_reuniao" access="remote" returntype="Struct" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfargument name="texto" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_ins_discussao_reuniao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_reuniao_id" type="in" value="#arguments.reuniao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_texto" type="in" value="#arguments.texto#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_item_id" type="out" variable="retorno.item_id" cfsqltype="cf_sql_integer">
		</cfstoredproc>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Altera uma discussao da reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_discussao_reuniao" access="remote" returntype="Struct" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfargument name="texto" required="yes">
		<cfargument name="item_id" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_alt_discussao_reuniao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_reuniao" type="in" value="#arguments.reuniao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_item_id" type="in" value="#arguments.item_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_texto" type="in" value="#arguments.texto#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>
		<cfreturn structNew() />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Exclui uma discussao da reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_discussao_reuniao" access="remote" returntype="Struct" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfargument name="item_id" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_del_discussao_reuniao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_reuniao_id" type="in" value="#arguments.reuniao_id#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_item_id" type="in" value="#arguments.item_id#" cfsqltype="cf_sql_integer">				
		</cfstoredproc>
		<cfreturn structNew() />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Insere uma obrigacao da reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_obrigacao_reuniao" access="remote" returntype="Struct" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfargument name="nome" required="yes">
		<cfargument name="texto" required="yes">
		<cfargument name="situacao_id" required="yes">
		<cfargument name="tarefa_id" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_ins_obrigacao_reuniao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_reuniao_id" type="in" value="#arguments.reuniao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_nome" type="in" value="#arguments.nome#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_texto" type="in" value="#arguments.texto#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_situacao_id" type="in" value="#arguments.situacao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_tarefa_id" type="in" value="#arguments.tarefa_id#" cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.tarefa_id)), de('no'), de('yes'))#">
			<cfprocparam dbvarname="p_item_id" type="out" variable="retorno.item_id" cfsqltype="cf_sql_integer">
		</cfstoredproc>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Altera uma obrigacao da reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_obrigacao_reuniao" access="remote" returntype="Struct" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfargument name="nome" required="yes">
		<cfargument name="texto" required="yes">
		<cfargument name="item_id" required="yes">
		<cfargument name="situacao_id" required="yes">
		<cfargument name="tarefa_id" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_alt_obrigacao_reuniao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_reuniao" type="in" value="#arguments.reuniao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_item_id" type="in" value="#arguments.item_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_nome" type="in" value="#arguments.nome#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_texto" type="in" value="#arguments.texto#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_situacao_id" type="in" value="#arguments.situacao_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_tarefa_id" type="in" value="#arguments.tarefa_id#" cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.tarefa_id)), de('no'), de('yes'))#">
		</cfstoredproc>
		<cfreturn structNew() />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Exclui uma obrigacao da reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_obrigacao_reuniao" access="remote" returntype="Struct" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfargument name="item_id" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_del_obrigacao_reuniao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_reuniao_id" type="in" value="#arguments.reuniao_id#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_item_id" type="in" value="#arguments.item_id#" cfsqltype="cf_sql_integer">				
		</cfstoredproc>
		<cfreturn structNew() />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Insere um  projeto
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_projeto" access="remote" returntype="Struct" output="true">
		<cfargument name="codigo" required="yes">
		<cfargument name="cliente" required="yes">
		<cfargument name="tecnico" required="yes">
		<cfargument name="titulo" required="yes">
		<cfargument name="situacao_id" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_ins_projeto" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_codigo" 		type="in" 	value="#arguments.codigo#" 		cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_cliente" 		type="in" 	value="#arguments.cliente#" 	cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_tecnico" 		type="in" 	value="#arguments.tecnico#" 	cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_titulo" 		type="in" 	value="#arguments.titulo#" 		cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_situacao_id" 		type="in" 	value="#arguments.situacao_id#" 		cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_projeto_id" 	type="out" 	variable="retorno.projeto_id" 	cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<!--- escopo --->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ESCOPO_ID_ESCOPO");
					v_item_id_old = this.ListaToArray (lista = arguments, variavel = "ESCOPO_ID_OLD_ESCOPO");
					v_texto = this.ListaToArray (lista = arguments, variavel = "TEXTO_ESCOPO_ESCOPO");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ESCOPO, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_excluir">
					<cfscript>
						this.del_projeto_escopo (projeto_id = retorno.projeto_id,
												 item_id    = l_excluir);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id_old[count]))) {
							this.ins_projeto_escopo(projeto_id = retorno.projeto_id,
													texto = v_texto[count],
													item_id = v_item_id[count]);
						} else {
							this.upd_projeto_escopo(projeto_id = retorno.projeto_id,
													texto = v_texto[count],
													item_id = v_item_id[count],
													item_id_old = v_item_id_old[count]);
						}
					</cfscript>
				</cfloop>			
				<!--- detalhamento --->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "DETALHAMENTO_ID_DETALHAMENTO");
					v_item_id_old = this.ListaToArray (lista = arguments, variavel = "DETALHAMENTO_ID_OLD_DETALHAMENTO");
					v_texto = this.ListaToArray (lista = arguments, variavel = "TEXTO_DETALHAMENTO_DETALHAMENTO");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_DETALHAMENTO, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_excluir">
					<cfscript>
						this.del_projeto_detalhamento (projeto_id = retorno.projeto_id,
														item_id    = l_excluir);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id_old[count]))) {
							this.ins_projeto_detalhamento(projeto_id = retorno.projeto_id,
															texto = v_texto[count],
															item_id = v_item_id[count]);
						} else {
							this.upd_projeto_detalhamento(projeto_id = retorno.projeto_id,
															texto = v_texto[count],
															item_id = v_item_id[count],
															item_id_old = v_item_id_old[count]);
						}
					</cfscript>
				</cfloop>			
				<!--- cronograma --->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "CRONOGRAMA_ID_CRONOGRAMA");
					v_item_id_old = this.ListaToArray (lista = arguments, variavel = "CRONOGRAMA_ID_OLD_CRONOGRAMA");
					v_texto = this.ListaToArray (lista = arguments, variavel = "TEXTO_CRONOGRAMA_CRONOGRAMA");
					v_data_termino = this.ListaToArray (lista = arguments, variavel = "TERMINO_CRONOGRAMA_CRONOGRAMA");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_CRONOGRAMA, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_excluir">
					<cfscript>
						this.del_projeto_cronograma (projeto_id = retorno.projeto_id,
														item_id    = l_excluir);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id_old[count]))) {
							this.ins_projeto_cronograma(projeto_id = retorno.projeto_id,
															texto = v_texto[count],
															item_id = v_item_id[count],
															data_termino = v_data_termino[count]);
						} else {
							this.upd_projeto_cronograma(projeto_id = retorno.projeto_id,
															texto = v_texto[count],
															item_id = v_item_id[count],
															item_id_old = v_item_id_old[count],
															data_termino = v_data_termino[count]);
						}
					</cfscript>
				</cfloop>			
				<!--- anexo --->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_ANEXO");
					v_item_id_old = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_OLD_ANEXO");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ANEXO, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_excluir">
					<cfscript>
						this.del_projeto_anexo (projeto_id = retorno.projeto_id,
														anexo_id    = l_excluir);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id_old[count]))) {
							this.ins_projeto_anexo(projeto_id = retorno.projeto_id,
													anexo_id = v_item_id[count]);
						} else {
							this.upd_projeto_anexo(projeto_id = retorno.projeto_id,
															anexo_id = v_item_id[count],
															anexo_id_old = v_item_id_old[count]);
						}
					</cfscript>
				</cfloop>			
				<!--- Recursos --->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "RECURSO_ITEM_ID_RECURSOS");
					v_recurso_id = this.ListaToArray (lista = arguments, variavel = "RECURSO_ID_RECURSOS");
					v_funcao_id = this.ListaToArray (lista = arguments, variavel = "FUNCAO_ID_RECURSOS");
					v_custo_hora = this.ListaToArray (lista = arguments, variavel = "CUSTO_HORA_RECURSOS");
					v_data_entrada = this.ListaToArray (lista = arguments, variavel = "DATA_ENTRADA_RECURSOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_RECURSOS, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_excluir">
					<cfscript>
						this.del_projeto_recurso (projeto_id = retorno.projeto_id,
														item_id    = l_excluir);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_projeto_recurso(	projeto_id = retorno.projeto_id,
														recurso_id = v_recurso_id[count],
														funcao_id  = v_funcao_id[count],
														custo_hora = v_custo_hora[count],
														data_entrada = v_data_entrada[count]);
						} else {
							this.upd_projeto_recurso(	projeto_id = retorno.projeto_id,
														recurso_id = v_recurso_id[count],
														funcao_id  = v_funcao_id[count],
														custo_hora = v_custo_hora[count],
														data_entrada = v_data_entrada[count],
														item_id = v_item_id[count]);
						}
					</cfscript>
				</cfloop>					
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Projeto inserido com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Altera um  projeto
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_projeto" access="remote" returntype="Struct" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="titulo" required="yes">
		<cfargument name="tecnico" required="yes">
		<cfargument name="codigo" required="yes">
		<cfargument name="cliente" required="yes">
		<cfargument name="situacao_id" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_alt_projeto" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_projeto_id" 	type="in" value="#arguments.projeto_id#" 	cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_codigo" 		type="in" value="#arguments.codigo#" 		cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_cliente"	 	type="in" value="#arguments.cliente#" 		cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_tecnico" 		type="in" value="#arguments.tecnico#" 		cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_titulo" 		type="in" value="#arguments.titulo#"		cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_situacao_id" 		type="in" 	value="#arguments.situacao_id#" 		cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<!--- escopo --->
				<cfscript>
					retorno.projeto_id = arguments.projeto_id;
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ESCOPO_ID_ESCOPO");
					v_item_id_old = this.ListaToArray (lista = arguments, variavel = "ESCOPO_ID_OLD_ESCOPO");
					v_texto = this.ListaToArray (lista = arguments, variavel = "TEXTO_ESCOPO_ESCOPO");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ESCOPO, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_excluir">
					<cfscript>
						this.del_projeto_escopo (projeto_id = retorno.projeto_id,
												 item_id    = l_excluir);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id_old[count]))) {
							this.ins_projeto_escopo(projeto_id = retorno.projeto_id,
													texto = v_texto[count],
													item_id = v_item_id[count]);
						} else {
							this.upd_projeto_escopo(projeto_id = retorno.projeto_id,
													texto = v_texto[count],
													item_id = v_item_id[count],
													item_id_old = v_item_id_old[count]);
						}
					</cfscript>
				</cfloop>			
				<!--- detalhamento --->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "DETALHAMENTO_ID_DETALHAMENTO");
					v_item_id_old = this.ListaToArray (lista = arguments, variavel = "DETALHAMENTO_ID_OLD_DETALHAMENTO");
					v_texto = this.ListaToArray (lista = arguments, variavel = "TEXTO_DETALHAMENTO_DETALHAMENTO");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_DETALHAMENTO, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_excluir">
					<cfscript>
						this.del_projeto_detalhamento (projeto_id = retorno.projeto_id,
														item_id    = l_excluir);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id_old[count]))) {
							this.ins_projeto_detalhamento(projeto_id = retorno.projeto_id,
															texto = v_texto[count],
															item_id = v_item_id[count]);
						} else {
							this.upd_projeto_detalhamento(projeto_id = retorno.projeto_id,
															texto = v_texto[count],
															item_id = v_item_id[count],
															item_id_old = v_item_id_old[count]);
						}
					</cfscript>
				</cfloop>			
				<!--- cronograma --->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "CRONOGRAMA_ID_CRONOGRAMA");
					v_item_id_old = this.ListaToArray (lista = arguments, variavel = "CRONOGRAMA_ID_OLD_CRONOGRAMA");
					v_texto = this.ListaToArray (lista = arguments, variavel = "TEXTO_CRONOGRAMA_CRONOGRAMA");
					v_data_termino = this.ListaToArray (lista = arguments, variavel = "TERMINO_CRONOGRAMA_CRONOGRAMA");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_CRONOGRAMA, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_excluir">
					<cfscript>
						this.del_projeto_cronograma (projeto_id = retorno.projeto_id,
														item_id    = l_excluir);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id_old[count]))) {
							this.ins_projeto_cronograma(projeto_id = retorno.projeto_id,
															texto = v_texto[count],
															item_id = v_item_id[count],
															data_termino = v_data_termino[count]);
						} else {
							this.upd_projeto_cronograma(projeto_id = retorno.projeto_id,
															texto = v_texto[count],
															item_id = v_item_id[count],
															item_id_old = v_item_id_old[count],
															data_termino = v_data_termino[count]);
						}
					</cfscript>
				</cfloop>			
				<!--- anexo --->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_ANEXO");
					v_item_id_old = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_OLD_ANEXO");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ANEXO, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_excluir">
					<cfscript>
						this.del_projeto_anexo (projeto_id = retorno.projeto_id,
														anexo_id    = l_excluir);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id_old[count]))) {
							this.ins_projeto_anexo(projeto_id = retorno.projeto_id,
													anexo_id = v_item_id[count]);
						} else {
							this.upd_projeto_anexo(projeto_id = retorno.projeto_id,
															anexo_id = v_item_id[count],
															anexo_id_old = v_item_id_old[count]);
						}
					</cfscript>
				</cfloop>			
				<!--- Recursos --->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "RECURSO_ITEM_ID_RECURSOS");
					v_recurso_id = this.ListaToArray (lista = arguments, variavel = "RECURSO_ID_RECURSOS");
					v_funcao_id = this.ListaToArray (lista = arguments, variavel = "FUNCAO_ID_RECURSOS");
					v_custo_hora = this.ListaToArray (lista = arguments, variavel = "CUSTO_HORA_RECURSOS");
					v_data_entrada = this.ListaToArray (lista = arguments, variavel = "DATA_ENTRADA_RECURSOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_RECURSOS, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_excluir">
					<cfscript>
						this.del_projeto_recurso (projeto_id = retorno.projeto_id,
														item_id    = l_excluir);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_projeto_recurso(	projeto_id = retorno.projeto_id,
														recurso_id = v_recurso_id[count],
														funcao_id  = v_funcao_id[count],
														custo_hora = v_custo_hora[count],
														data_entrada = v_data_entrada[count]);
						} else {
							this.upd_projeto_recurso(	projeto_id = retorno.projeto_id,
														recurso_id = v_recurso_id[count],
														funcao_id  = v_funcao_id[count],
														custo_hora = v_custo_hora[count],
														data_entrada = v_data_entrada[count],
														item_id = v_item_id[count]);
						}
					</cfscript>
				</cfloop>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Projeto alterado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Exclui um projeto
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_projeto" access="remote" returntype="Struct" output="true">
		<cfargument name="projeto_id" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_del_projeto" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_projeto_id" type="in" value="#arguments.projeto_id#" cfsqltype="cf_sql_integer">				
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Projeto excluido com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Insere um escopo do projeto
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_projeto_escopo" access="remote" returntype="Struct" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="item_id" required="yes">
		<cfargument name="texto" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_ins_projeto_escopo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_projeto_id" type="in" value="#arguments.projeto_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_texto" type="in" value="#arguments.texto#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_item_id" type="inout" variable="retorno.item_id" value="#arguments.item_id#" cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.item_id)), de('no'), de('yes'))#">
		</cfstoredproc>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Altera um escopo do projeto
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_projeto_escopo" access="remote" returntype="Struct" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="texto" required="yes">
		<cfargument name="item_id" required="yes">
		<cfargument name="item_id_old" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_alt_projeto_escopo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_projeto_id" type="in" value="#arguments.projeto_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_item_id" type="in" value="#arguments.item_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_texto" type="in" value="#arguments.texto#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_item_id_old" type="in" value="#arguments.item_id_old#" cfsqltype="cf_sql_integer">
		</cfstoredproc>
		<cfreturn structnew() />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Exclui um escopo do projeto
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_projeto_escopo" access="remote" returntype="Struct" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="item_id" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_del_projeto_escopo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_projeto_id" type="in" value="#arguments.projeto_id#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_item_id" type="in" value="#arguments.item_id#" cfsqltype="cf_sql_integer">				
		</cfstoredproc>
		<cfreturn structNew() />
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Insere um detalhamento do projeto
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_projeto_detalhamento" access="remote" returntype="Struct" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="item_id" required="yes">
		<cfargument name="texto" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_ins_projeto_detalhamento" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_projeto_id" type="in" value="#arguments.projeto_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_texto" type="in" value="#arguments.texto#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_item_id" variable="retorno.item_id" type="inout" value="#arguments.item_id#"  cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.item_id)),de('no'), de('yes'))#">
		</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Altera um detalhamento do projeto
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_projeto_detalhamento" access="remote" returntype="Struct" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="texto" required="yes">
		<cfargument name="item_id" required="yes">
		<cfargument name="item_id_old" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_alt_projeto_detalhamento" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_projeto_id" type="in" value="#arguments.projeto_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_item_id" type="in" value="#arguments.item_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_texto" type="in" value="#arguments.texto#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_item_id_old" type="in" value="#arguments.item_id_old#" cfsqltype="cf_sql_integer">
		</cfstoredproc>
		<cfreturn structNew() />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Exclui um detalhamento do projeto
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_projeto_detalhamento" access="remote" returntype="Struct" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="item_id" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_del_projeto_detalhamento" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_projeto_id" type="in" value="#arguments.projeto_id#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_item_id" type="in" value="#arguments.item_id#" cfsqltype="cf_sql_integer">				
		</cfstoredproc>
		<cfreturn structNew() />
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Insere um cronograma do projeto
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_projeto_cronograma" access="remote" returntype="Struct" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="item_id" required="yes">
		<cfargument name="texto" required="yes">
		<cfargument name="data_termino" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_ins_projeto_cronograma" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_projeto_id" type="in" value="#arguments.projeto_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_texto" type="in" value="#arguments.texto#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_data_termino" type="in" value="#arguments.data_termino#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_item_id" variable="retorno.item_id" type="inout" value="#arguments.item_id#"  cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.item_id)),de('no'), de('yes'))#">
		</cfstoredproc>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Altera um cronograma do projeto
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_projeto_cronograma" access="remote" returntype="Struct" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="texto" required="yes">
		<cfargument name="item_id" required="yes">
		<cfargument name="data_termino" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_alt_projeto_cronograma" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_projeto_id" type="in" value="#arguments.projeto_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_item_id" type="in" value="#arguments.item_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_texto" type="in" value="#arguments.texto#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_data_termino" type="in" value="#arguments.data_termino#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_item_id_old" type="in" value="#arguments.item_id_old#" cfsqltype="cf_sql_integer">
		</cfstoredproc>
		<cfreturn structNew() />
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Exclui um cronograma do projeto
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_projeto_cronograma" access="remote" returntype="Struct" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="item_id" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_del_projeto_cronograma" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_projeto_id" type="in" value="#arguments.projeto_id#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_item_id" type="in" value="#arguments.item_id#" cfsqltype="cf_sql_integer">				
		</cfstoredproc>
		<cfreturn structNew() />
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Insere um anexo do projeto
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_projeto_anexo" access="remote" returntype="Struct" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="anexo_id" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_ins_projeto_anexo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_projeto_id" type="in" value="#arguments.projeto_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_anexo_id" type="in" value="#arguments.anexo_id#" cfsqltype="cf_sql_integer">
		</cfstoredproc>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Altera um anexo do projeto
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_projeto_anexo" access="remote" returntype="Struct" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="anexo_id" required="yes">
		<cfargument name="anexo_id_old" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_alt_projeto_anexo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_projeto_id" type="in" value="#arguments.projeto_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_anexo_id" type="in" value="#arguments.anexo_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_anexo_id_old" type="in" value="#arguments.anexo_id_old#" cfsqltype="cf_sql_integer">
		</cfstoredproc>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Exclui um anexo do projeto
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_projeto_anexo" access="remote" returntype="Struct" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfargument name="anexo_id" required="yes">
		<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_del_projeto_anexo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_projeto_id" type="in" value="#arguments.projeto_id#" cfsqltype="cf_sql_integer">				
			<cfprocparam dbvarname="p_anexo_id" type="in" value="#arguments.anexo_id#" cfsqltype="cf_sql_integer">				
		</cfstoredproc>
		<cfreturn StructNew() />		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Insere um grupo de descrio
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_grupo_descricao" access="remote" returntype="Struct" output="true">
		<cfargument name="descricao" required="yes">
		<cfargument name="observacao" required="yes">
		<cfargument name="exige_confirmacao" required="no" default="0">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_ins_grupo_descricao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_descricao" type="in" value="#arguments.descricao#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_observacao" type="in" value="#arguments.observacao#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_exige_confirmacao" type="in" value="#arguments.exige_confirmacao#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_grupo_id" type="out" variable="retorno.grupo_id" cfsqltype="cf_sql_integer">				
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Grupo de descricao inserido com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Altera um grupo de descricao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_grupo_descricao" access="remote" returntype="Struct" output="true">
		<cfargument name="grupo_id" required="yes">
		<cfargument name="descricao" required="yes">
		<cfargument name="observacao" required="yes">
		<cfargument name="exige_confirmacao" required="no" default="0">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_alt_grupo_descricao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_grupo_id" type="in" value="#arguments.grupo_id#" cfsqltype="cf_sql_integer">				
					<cfprocparam dbvarname="p_descricao" type="in" value="#arguments.descricao#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_observacao" type="in" value="#arguments.observacao#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_exige_confirmacao" type="in" value="#arguments.exige_confirmacao#" cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Grupo de descricao alterado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Exclui um grupo de descricao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_grupo_descricao" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
		<cfargument name="grupo_id" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_del_grupo_descricao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_grupo_id" type="in" value="#arguments.grupo_id#" cfsqltype="cf_sql_integer">				
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Grupo de descricao excluido com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Insere um anexo 
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_anexo" displayname="" access="remote" returntype="Struct" output="true">
		<cfargument name="titulo" required="yes">
		<cfargument name="anexo" required="no" default="">
		<cfargument name="permite_excluir" required="no" default="0">
		<cfargument name="grupo_id" required="no" default="1">
		<cfargument name="filefield" required="no" default="anexo">
		<cftry>
			<cftransaction action="begin">
				<cfscript>
					retorno = this.ins_anexo_private(argumentCollection = arguments);
				</cfscript>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Insere um anexo 
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="ins_anexo_private" displayname="" access="remote" returntype="Struct" output="true">
		<cfargument name="titulo" required="yes">
		<cfargument name="anexo" required="no" default="">
		<cfargument name="permite_excluir" required="no" default="0">
		<cfargument name="grupo_id" required="no" default="1">
		<cfargument name="filefield" required="no" default="anexo">
				<cfset v_anexo = ''>
				<cfset v_arquivo = ''>
				<cfset retorno.url = ''>
				<cfif len(trim(arguments[arguments.filefield]))>
					<cffile action="upload"
							filefield="#arguments.filefield#" 
							nameconflict="makeunique"
							destination="#arguments[arguments.filefield]#2"
							result="arguments.dados">
				<!--- torna o nome do anexo unico --->
					<cfset dest = this.unique_filename(filename = '/var/www/html/portal/documentos/'&arguments.dados.clientfile)>
					<cffile action="copy" 
							source="#arguments[arguments.filefield]#" 
							destination="#dest#"
							nameconflict="error"
							result="arguments.dados">
					<cfif not len(trim(arguments.titulo))>
						<cfset arguments.titulo = ListDeleteAt(arguments.dados.clientfile,listlen(arguments.dados.clientfile,'.'),'.')>
					</cfif>
					<cfset v_anexo = Replace(dest, '/var/www/html/portal/documentos/', 'http://portal.kmm.com.br/documentos/','one')>
					<cfset retorno.url = v_anexo>
				</cfif>
				<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_ins_anexo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_titulo" type="in" value="#arguments.titulo#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_url" type="in" value="#v_anexo#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_permite_excluir" type="in" value="#arguments.permite_excluir#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_grupo_id" type="in" value="#arguments.grupo_id#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_anexo_id" type="out" variable="retorno.anexo_id" cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Anexo inserido com sucesso!")>
		<cfreturn retorno />		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca um nome unico para o anexo
	-- CRISTOFER  16/05/2006
	--->		
	<cffunction name="unique_filename" access="package" output="false" returntype="string">
		<cfargument name="filename" required="yes">
		<cfargument name="original" required="no" default="#arguments.filename#">
		<cfargument name="tentativa" required="no" default="0">
		<cfif not FileExists(arguments.filename)>
			<cfreturn arguments.filename>
		<cfelse>
			<cfscript>
				ext = ListLast(arguments.original,'.');
				t = ListDeleteAt(arguments.original, listlen(arguments.original,'.'), '.');
			</cfscript>
			<cfreturn this.unique_filename(	filename = t&'('&(arguments.tentativa+1)&').'&ext,
											original = arguments.original,
											tentativa = arguments.tentativa+1)>
		</cfif>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Insere um anexo 
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_anexo" displayname="" access="remote" returntype="Struct" output="true">
		<cfargument name="anexo_id" required="yes">
		<cfargument name="titulo" required="yes">
		<cfargument name="anexo" required="no" default="">
		<cfargument name="permite_excluir" required="no" default="0">
		<cfargument name="grupo_id" required="no" default="1">
		<cfargument name="filefield" required="no" default="anexo">
		<cftry>
			<cftransaction action="begin">
				<cfset v_anexo = ''>
				<cfset v_arquivo = ''>
				<cfif len(trim(arguments[arguments.filefield]))>
					<cffile action="upload"
							filefield="#arguments.filefield#" 
							nameconflict="makeunique"
							destination="#arguments[arguments.filefield]#2"
							result="arguments.dados">
				<!--- torna o nome do anexo unico --->
					<cfset dest = this.unique_filename(filename = '/var/www/html/portal/documentos/'&arguments.dados.clientfile)>
					<cffile action="copy" 
							source="#arguments[arguments.filefield]#" 
							destination="#dest#"
							nameconflict="error"
							result="arguments.dados">
					<cfset v_anexo = Replace(dest, '/var/www/html/portal/documentos/', 'http://portal.kmm.com.br/documentos/','one')>
					<cfset retorno.url = v_anexo>
				</cfif>
				<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_alt_anexo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_anexo_id" type="in" value="#arguments.anexo_id#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_titulo" type="in" value="#arguments.titulo#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_url" type="inout" variable="retorno.url" value="#v_anexo#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_permite_excluir" type="in" value="#arguments.permite_excluir#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_grupo_id" type="in" value="#arguments.grupo_id#" cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Anexo alterado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Exclui um anexo 
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_anexo" access="remote" returntype="Struct" output="true">
		<cfargument name="anexo_id" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="desenvolvimento.pkg_desenvolvimento.prc_del_anexo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_anexo_id" type="in" value="#arguments.anexo_id#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_url" type="out" variable="retorno.url" cfsqltype="cf_sql_varchar">
				</cfstoredproc>
				<cfif len(trim(retorno.url))>
					<cftry>
						<cffile action="delete"
								file="#Replace(retorno.url,'http://portal.kmm.com.br/','/var/www/html/portal/','all')#">
						<cfset retorno.erro = false>
						<cfcatch>
						</cfcatch>
					</cftry>
				</cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Anexo excluido com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere um grupo de anexos
	-- cristofer 11/05/2006 11:35:45 - CRIADO
	--->
	<cffunction name='ins_anexo_grupo' displayname='Insere um grupo de anexos' access='remote' returntype='Struct' output='true'>;
		<cfargument name='GRUPO_PAI_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfif not len(trim(arguments.grupo_pai_id))>
					<cfset arguments.grupo_pai_id = 0>
				</cfif>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_ins_anexo_grupo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GRUPO_PAI_ID'  value='#arguments.GRUPO_PAI_ID#'  null='#iif(len(trim(arguments.GRUPO_PAI_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GRUPO_ID' variable='retorno.GRUPO_ID'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Grupo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um grupo de anexos
	-- cristofer 11/05/2006 11:36:40 - CRIADO
	--->
	<cffunction name='upd_anexo_grupo' displayname='Altera um grupo de anexos' access='remote' returntype='Struct' output='true'>;
		<cfargument name='GRUPO_ID' required='yes'>
		<cfargument name='GRUPO_PAI_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfif not len(trim(arguments.grupo_pai_id))>
					<cfset arguments.grupo_pai_id = 0>
				</cfif>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_alt_anexo_grupo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GRUPO_ID'  value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GRUPO_PAI_ID'  value='#arguments.GRUPO_PAI_ID#'  null='#iif(len(trim(arguments.GRUPO_PAI_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Grupo alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um grupo de anexos
	-- cristofer 11/05/2006 11:37:21 - CRIADO
	--->
	<cffunction name='del_anexo_grupo' displayname='Exclui um grupo de anexos' access='remote' returntype='Struct' output='true'>;
		<cfargument name='GRUPO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_del_anexo_grupo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GRUPO_ID'  value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Grupo excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um cliente
	-- cristofer 18/05/2006 15:26:31 - CRIADO
	--->
	<cffunction name='ins_cliente' displayname='Insere um cliente' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CLIENTE' required='yes'>
		<cfargument name="NOME" required="yes">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_ins_cliente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CLIENTE'  value='#arguments.CLIENTE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CLIENTE_ID' variable='retorno.CLIENTE_ID'>
				</cfstoredproc>
				<cfscript>
					v_usuario = this.ListaToArray (lista = arguments, variavel = "USUARIO_USUARIOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_USUARIOS, lista2 = ArrayToList(v_usuario));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_cliente_usuario(cliente_id = retorno.cliente_id,
										   		usuario = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_usuario)#" index="count">
					<cfscript>
						this.ins_cliente_usuario(cliente_id = retorno.cliente_id,
													usuario = v_usuario[count]);
					</cfscript>
				</cfloop>					
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Cliente inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um cliente
	-- cristofer 18/05/2006 15:27:21 - CRIADO
	--->
	<cffunction name='upd_cliente' displayname='Altera um cliente' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='CLIENTE' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_alt_cliente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CLIENTE'  value='#arguments.CLIENTE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
				</cfstoredproc>
				<cfscript>
					retorno.cliente_id = arguments.cliente_id;
					v_usuario = this.ListaToArray (lista = arguments, variavel = "USUARIO_USUARIOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_USUARIOS, lista2 = ArrayToList(v_usuario));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_cliente_usuario(cliente_id = retorno.cliente_id,
										   		usuario = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_usuario)#" index="count">
					<cfscript>
						this.ins_cliente_usuario(cliente_id = retorno.cliente_id,
													usuario = v_usuario[count]);
					</cfscript>
				</cfloop>					
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Cliente alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um cliente
	-- cristofer 18/05/2006 15:27:52 - CRIADO
	--->
	<cffunction name='del_cliente' displayname='Exclui um cliente' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CLIENTE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_del_cliente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Cliente excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um usuario no cliente
	-- cristofer 18/05/2006 15:28:52 - CRIADO
	--->
	<cffunction name='ins_cliente_usuario' displayname='Insere um usuario no cliente' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='USUARIO' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_ins_cliente_usuario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um usuario no cliente
	-- cristofer 18/05/2006 15:29:11 - CRIADO
	--->
	<cffunction name='del_cliente_usuario' displayname='Exclui um usuario no cliente' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='USUARIO' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_del_cliente_usuario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere um recurso
	-- cristofer 19/05/2006 08:30:49 - CRIADO
	--->
	<cffunction name='ins_recurso' displayname='Insere um recurso' access='remote' returntype='Struct' output='true'>;
		<cfargument name='NOME' required='yes'>
		<cfargument name='NOME_COMPLETO' required='yes'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='TECNICO' required='no' default="0">
		<cfargument name='EXIBIR_RANKING' required='no' default="0">
		<cfargument name='EMAIL' required='yes'>
		<cfargument name='CUSTO_HORA' required='no' default="0">
		<cfargument name='ATIVO' required='no' default="0">
		<cftry>
			<cfif not len(trim(arguments.exibir_ranking))>
				<cfset arguments.exibir_ranking = 0>
			</cfif>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_ins_recurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_COMPLETO'  value='#arguments.NOME_COMPLETO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_INTEGER' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TECNICO'  value='#arguments.TECNICO#'  null='#iif(len(trim(arguments.TECNICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_EXIBIR_RANKING'  value='#arguments.EXIBIR_RANKING#'  null='#iif(len(trim(arguments.EXIBIR_RANKING)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL'  value='#arguments.EMAIL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CUSTO_HORA'  value='#arguments.CUSTO_HORA#'  null='#iif(len(trim(arguments.CUSTO_HORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ATIVO'  value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECURSO_ID' variable='retorno.RECURSO_ID'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Recurso inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um recurso
	-- cristofer 19/05/2006 08:31:34 - CRIADO
	--->
	<cffunction name='upd_recurso' displayname='Altera um recurso' access='remote' returntype='Struct' output='true'>;
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='NOME_COMPLETO' required='yes'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='TECNICO' required='no' default="0">
		<cfargument name='EXIBIR_RANKING' required='no' default="0">
		<cfargument name='EMAIL' required='yes'>
		<cfargument name='CUSTO_HORA' required='yes'>
		<cfargument name='ATIVO' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_alt_recurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_COMPLETO'  value='#arguments.NOME_COMPLETO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_INTEGER' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TECNICO'  value='#arguments.TECNICO#'  null='#iif(len(trim(arguments.TECNICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_EXIBIR_RANKING'  value='#arguments.EXIBIR_RANKING#'  null='#iif(len(trim(arguments.EXIBIR_RANKING)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL'  value='#arguments.EMAIL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CUSTO_HORA'  value='#arguments.CUSTO_HORA#'  null='#iif(len(trim(arguments.CUSTO_HORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ATIVO'  value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Recurso alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um recurso
	-- cristofer 19/05/2006 08:32:09 - CRIADO
	--->
	<cffunction name='del_recurso' displayname='Exclui um recurso' access='remote' returntype='Struct' output='true'>;
		<cfargument name='RECURSO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_del_recurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Recurso excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma nova funcao
	-- cristofer 19/05/2006 08:33:26 - CRIADO
	--->
	<cffunction name='ins_recurso_funcao' displayname='Insere uma nova funcao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='RESPONSABILIDADES' required='yes'>
		<cfargument name='COR_HEXADECIMAL' required='yes'>
		<cfargument name='INTERNO' required='no' default='0'>
	<!---	<cftry>
			<cftransaction action='begin'>--->
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_ins_recurso_funcao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESPONSABILIDADES'  value='#arguments.RESPONSABILIDADES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COR_HEXADECIMAL' value='#arguments.COR_HEXADECIMAL#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INTERNO' value='#arguments.INTERNO#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FUNCAO_ID' variable='retorno.FUNCAO_ID'>					
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Funo inserida com sucesso!')>
			<!---</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>--->
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma nova funcao
	-- cristofer 19/05/2006 08:34:37 - CRIADO
	--->
	<cffunction name='upd_recurso_funcao' displayname='Altera uma nova funcao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='FUNCAO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='RESPONSABILIDADES' required='yes'>
		<cfargument name='COR_HEXADECIMAL' required='yes'>
		<cfargument name='INTERNO' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_alt_recurso_funcao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FUNCAO_ID'  value='#arguments.FUNCAO_ID#'  null='#iif(len(trim(arguments.FUNCAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COR_HEXADECIMAL' value='#arguments.COR_HEXADECIMAL#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INTERNO' value='#arguments.INTERNO#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESPONSABILIDADES'  value='#arguments.RESPONSABILIDADES#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Funo alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma funcao
	-- cristofer 19/05/2006 08:35:14 - CRIADO
	--->
	<cffunction name='del_recurso_funcao' displayname='Exclui uma funcao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='FUNCAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_del_recurso_funcao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FUNCAO_ID'  value='#arguments.FUNCAO_ID#'  null='#iif(len(trim(arguments.FUNCAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Funo excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um recurso no projeto
	-- cristofer 19/05/2006 08:36:13 - CRIADO
	--->
	<cffunction name='ins_projeto_recurso' displayname='Insere um recurso no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='FUNCAO_ID' required='yes'>
		<cfargument name='CUSTO_HORA' required='yes'>
		<cfargument name='DATA_ENTRADA' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_ins_projeto_recurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FUNCAO_ID'  value='#arguments.FUNCAO_ID#'  null='#iif(len(trim(arguments.FUNCAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CUSTO_HORA'  value='#arguments.CUSTO_HORA#'  null='#iif(len(trim(arguments.CUSTO_HORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTRADA'  value='#arguments.DATA_ENTRADA#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID' variable='retorno.ITEM_ID'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um recurso no projeto
	-- cristofer 19/05/2006 08:37:11 - CRIADO
	--->
	<cffunction name='upd_projeto_recurso' displayname='Altera um recurso no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='FUNCAO_ID' required='yes'>
		<cfargument name='CUSTO_HORA' required='yes'>
		<cfargument name='DATA_ENTRADA' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_alt_projeto_recurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FUNCAO_ID'  value='#arguments.FUNCAO_ID#'  null='#iif(len(trim(arguments.FUNCAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CUSTO_HORA'  value='#arguments.CUSTO_HORA#'  null='#iif(len(trim(arguments.CUSTO_HORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTRADA'  value='#arguments.DATA_ENTRADA#' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um recurso no projeto
	-- cristofer 19/05/2006 08:37:43 - CRIADO
	--->
	<cffunction name='del_projeto_recurso' displayname='Exclui um recurso no projeto' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_del_projeto_recurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Inicia uma discussao
	-- cristofer 19/05/2006 16:39:33 - CRIADO
	--->
	<cffunction name='ins_discussao' displayname='Inicia uma discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='RESPONSAVEL' required='no' default="#UCase(session.usuario)#">
		<cfargument name='DATA_INICIO' required='no' default="#LSDateFormat(now())# #LSTimeFormat(now(), 'hh:mm:ss')#">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_ins_discussao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SOLICITACAO_ID'  value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESPONSAVEL'  value='#arguments.RESPONSAVEL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_TIMESTAMP' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DISCUSSAO_ID' variable='retorno.DISCUSSAO_ID' >
				</cfstoredproc>
				<cfscript>
					v_recurso_id = this.ListaToArray (lista = arguments, variavel = "RECURSO_ID_RECURSOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_RECURSOS, lista2 = ArrayToList(v_recurso_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_discussao_participante(discussao_id = retorno.discussao_id,
														recurso_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_recurso_id)#" index="count">
					<cfscript>
						this.ins_discussao_participante(discussao_id = retorno.discussao_id,
														recurso_id = v_recurso_id[count]);
					</cfscript>
				</cfloop>			
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Discussao iniciada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma discussao
	-- cristofer 19/05/2006 16:44:11 - CRIADO
	--->
	<cffunction name='upd_discussao' displayname='Altera uma discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DISCUSSAO_ID' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='RESPONSAVEL' required='no' default="">
		<cfargument name='DATA_INICIO' required='no' default="">
		<cfargument name='SITUACAO_ID' required='no' default="1">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_alt_discussao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DISCUSSAO_ID'  value='#arguments.DISCUSSAO_ID#'  null='#iif(len(trim(arguments.DISCUSSAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SOLICITACAO_ID'  value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESPONSAVEL'  value='#arguments.RESPONSAVEL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfscript>
					retorno.discussao_id = arguments.discussao_id;
					v_recurso_id = this.ListaToArray (lista = arguments, variavel = "RECURSO_ID_RECURSOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_RECURSOS, lista2 = ArrayToList(v_recurso_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_discussao_participante(discussao_id = retorno.discussao_id,
														recurso_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_recurso_id)#" index="count">
					<cfscript>
						this.ins_discussao_participante(discussao_id = retorno.discussao_id,
														recurso_id = v_recurso_id[count]);
					</cfscript>
				</cfloop>			
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Discussao alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera a situacao de uma discussao
	-- cristofer 19/05/2006 16:48:11 - CRIADO
	--->
	<cffunction name='situacao_discussao' displayname='Altera a situacao de uma discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DISCUSSAO_ID' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_alt_situacao_discussao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DISCUSSAO_ID'  value='#arguments.DISCUSSAO_ID#'  null='#iif(len(trim(arguments.DISCUSSAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Situacao alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma discussao
	-- cristofer 19/05/2006 16:44:50 - CRIADO
	--->
	<cffunction name='del_discussao' displayname='Exclui uma discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DISCUSSAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_del_discussao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DISCUSSAO_ID'  value='#arguments.DISCUSSAO_ID#'  null='#iif(len(trim(arguments.DISCUSSAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Discussao excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um item na discussao
	-- cristofer 19/05/2006 16:50:16 - CRIADO
	--->
	<cffunction name='ins_discussao_item' displayname='Insere um item na discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DISCUSSAO_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='no' default="">
		<cfargument name='TEXTO' required='yes'>
		<cfargument name='DATA' required='no' default="#LSDateFormat(now())# #LSTimeFormat(now())#:00">
		<cftry>
			<cftransaction action='begin'>
				<cfif not len(trim(arguments.recurso_id))>
					<cfscript>
						conn = CreateObject("component", "_transportes.consulta.cfc_desenvolvimento");
						qrRecurso = conn.get_recurso(usuario = session.usuario);
						qrDiscussao = conn.get_discussao(discussao_id = arguments.discussao_id);
						qrParticipante = conn.get_discussao_participante(discussao_id = arguments.discussao_id);
					</cfscript>
					<cfif not qrRecurso.recordcount>
						<cfthrow detail="Seu usurio no est cadastrado como recurso dos projetos!"
							 message="Seu usurio no est cadastrado como recurso dos projetos!">
					<cfelse>
						<cfset arguments.recurso_id = qrRecurso.recurso_id>
					</cfif>
				</cfif>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_ins_discussao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DISCUSSAO_ID'  value='#arguments.DISCUSSAO_ID#'  null='#iif(len(trim(arguments.DISCUSSAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TEXTO'  value='#arguments.TEXTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID' variable='retorno.ITEM_ID'  >
				</cfstoredproc>
				<cfscript>
	//				retorno.item_id = arguments.item_id;
					v_anexo_file = this.ListaToArray (lista = arguments, variavel = "ANEXO_ANEXOS");
					v_filefield = this.ListaToArray (lista = arguments, variavel = "FILEFIELD_ANEXOS");
					retorno.anexos = arraynew(1);
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_anexo_file)#" index="count">
					<cfscript>
						if(len(trim(v_anexo_file[count]))) {
							retorno.anexos[count] = this.ins_anexo_private(filefield = v_filefield[count],
																		   argumentCollection = arguments,
																		   titulo = '',
																		   permite_excluir = 1,
																		   grupo_id = 11);
							if(not retorno.anexos[count].erro) {
								this.ins_discussao_anexo(item_id = retorno.item_id,
														 anexo_id = retorno.anexos[count].anexo_id);
							}
						}
					</cfscript>
					<cfif len(trim(v_anexo_file[count])) and  retorno.anexos[count].erro>
						<cfthrow object="#retorno.anexos[count].mensagem#">
					</cfif>
				</cfloop>			
				<cfset titulo = "#qrDiscussao.titulo#">
				<cfset subtitulo = "Comentario enviado por #qrRecurso.descricao#">
				<cfset mensagem = "#arguments.TEXTO#<br><br>Clique <a href='http://portal.kmm.com.br/janela.cfm?URL=/aplicacoes/portal/documentacao/discussao/principal.cfm'>aqui</a> para visualizar ou participar das discusses">
				<cfoutput query="qrParticipante">
					<cfmail from="discussoes@kmm.com.br" to="#qrParticipante.email#" type="html" subject="Discusses - #session.usuario#">
						<cfinclude template="/aplicacoes/mensagem/email.cfm">
					</cfmail>
				</cfoutput>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Comentario inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um item na discussao
	-- cristofer 19/05/2006 16:51:00 - CRIADO
	--->
	<cffunction name='upd_discussao_item' displayname='Altera um item na discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='DISCUSSAO_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='TEXTO' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_alt_discussao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DISCUSSAO_ID'  value='#arguments.DISCUSSAO_ID#'  null='#iif(len(trim(arguments.DISCUSSAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TEXTO'  value='#arguments.TEXTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Comentario alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um item na discussao
	-- cristofer 19/05/2006 16:51:42 - CRIADO
	--->
	<cffunction name='del_discussao_item' displayname='Exclui um item na discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ITEM_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_del_discussao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Comentario excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um anexo no item da discussao
	-- cristofer 19/05/2006 16:53:44 - CRIADO
	--->
	<cffunction name='ins_discussao_anexo' displayname='Insere um anexo no item da discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='ANEXO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_ins_discussao_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um anexo no item da discussao
	-- cristofer 19/05/2006 16:54:07 - CRIADO
	--->
	<cffunction name='del_discussao_anexo' displayname='Exclui um anexo no item da discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='ANEXO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_del_discussao_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um participante na discussao
	-- cristofer 19/05/2006 16:55:38 - CRIADO
	--->
	<cffunction name='ins_discussao_participante' displayname='Insere um participante na discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DISCUSSAO_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_ins_discussao_participante' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DISCUSSAO_ID'  value='#arguments.DISCUSSAO_ID#'  null='#iif(len(trim(arguments.DISCUSSAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um participante na discussao
	-- cristofer 19/05/2006 16:55:55 - CRIADO
	--->
	<cffunction name='del_discussao_participante' displayname='Exclui um participante na discussao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DISCUSSAO_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
				<cfstoredproc procedure='kmm.pkg_discussao.prc_del_discussao_participante' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DISCUSSAO_ID'  value='#arguments.DISCUSSAO_ID#'  null='#iif(len(trim(arguments.DISCUSSAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um documento
	-- CRISTOFER 25/05/2006 17:03:52 - CRIADO
	--->
	<cffunction name='ins_documento' displayname='Insere um documento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TITULO' required='yes'>
		<cfargument name='SECAO_ID' required='yes'>
		<cfargument name='GRUPO_ID' required='yes'>
		<cfargument name='DEFINICAO' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='OBJETIVO' required='yes'>
		<cfargument name='DETALHAMENTO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_ins_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SECAO_ID'  value='#arguments.SECAO_ID#'  null='#iif(len(trim(arguments.SECAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GRUPO_ID'  value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEFINICAO'  value='#arguments.DEFINICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#' null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBJETIVO'  value='#arguments.OBJETIVO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DETALHAMENTO'  value='#arguments.DETALHAMENTO#'  null='#iif(len(trim(arguments.DETALHAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DOCUMENTO_ID' variable='retorno.DOCUMENTO_ID'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfscript>
	//				retorno.documento_id = arguments.documento_id;
					v_anexo_id = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_ANEXOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ANEXOS, lista2 = ArrayToList(v_anexo_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_documento_anexo(documento_id = retorno.documento_id,
										   		 anexo_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_anexo_id)#" index="count">
					<cfscript>
						this.ins_documento_anexo(	documento_id = retorno.documento_id,
													anexo_id = v_anexo_id[count]);
					</cfscript>
				</cfloop>			
				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Documento inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um documento
	-- CRISTOFER 25/05/2006 17:09:50 - CRIADO
	--->
	<cffunction name='upd_documento' displayname='Altera um documento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DOCUMENTO_ID' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='SECAO_ID' required='yes'>
		<cfargument name='GRUPO_ID' required='yes'>
		<cfargument name='DEFINICAO' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='OBJETIVO' required='yes'>
		<cfargument name='DETALHAMENTO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_alt_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SECAO_ID'  value='#arguments.SECAO_ID#'  null='#iif(len(trim(arguments.SECAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GRUPO_ID'  value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEFINICAO'  value='#arguments.DEFINICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#' null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBJETIVO'  value='#arguments.OBJETIVO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DETALHAMENTO'  value='#arguments.DETALHAMENTO#'  null='#iif(len(trim(arguments.DETALHAMENTO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfscript>
					retorno.documento_id = arguments.documento_id;
					v_anexo_id = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_ANEXOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ANEXOS, lista2 = ArrayToList(v_anexo_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_documento_anexo(documento_id = retorno.documento_id,
										   		 anexo_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_anexo_id)#" index="count">
					<cfscript>
						this.ins_documento_anexo(	documento_id = retorno.documento_id,
													anexo_id = v_anexo_id[count]);
					</cfscript>
				</cfloop>			
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Documento alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um documento
	-- CRISTOFER 25/05/2006 17:09:13 - CRIADO
	--->
	<cffunction name='del_documento' displayname='Exclui um documento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DOCUMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_del_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Documento excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um anexo no documento
	-- CRISTOFER 25/05/2006 17:10:57 - CRIADO
	--->
	<cffunction name='ins_documento_anexo' displayname='Insere um anexo no documento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DOCUMENTO_ID' required='yes'>
		<cfargument name='ANEXO_ID' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_ins_documento_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um anexo no documento
	-- CRISTOFER 25/05/2006 17:11:17 - CRIADO
	--->
	<cffunction name='del_documento_anexo' displayname='Exclui um anexo no documento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DOCUMENTO_ID' required='yes'>
		<cfargument name='ANEXO_ID' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_del_documento_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma revisao no documento
	-- CRISTOFER 25/05/2006 17:12:10 - CRIADO
	--->
	<cffunction name='ins_documento_revisao' displayname='Insere uma revisao no documento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DOCUMENTO_ID' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ALTERADO_POR' required='yes'>
		<cfargument name='REVISADO_POR' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_ins_documento_revisao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ALTERADO_POR'  value='#arguments.ALTERADO_POR#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REVISADO_POR'  value='#arguments.REVISADO_POR#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REVISAO_ID' variable='retorno.REVISAO_ID'  null='#iif(len(trim(arguments.REVISAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma revisao no documento
	-- CRISTOFER 25/05/2006 17:12:39 - CRIADO
	--->
	<cffunction name='upd_documento_revisao' displayname='Altera uma revisao no documento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='REVISAO_ID' required='yes'>
		<cfargument name='DOCUMENTO_ID' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ALTERADO_POR' required='yes'>
		<cfargument name='REVISADO_POR' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_alt_documento_revisao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REVISAO_ID'  value='#arguments.REVISAO_ID#'  null='#iif(len(trim(arguments.REVISAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ALTERADO_POR'  value='#arguments.ALTERADO_POR#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REVISADO_POR'  value='#arguments.REVISADO_POR#' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma revisao no documento
	-- CRISTOFER 25/05/2006 17:13:04 - CRIADO
	--->
	<cffunction name='del_documento_revisao' displayname='Exclui uma revisao no documento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='REVISAO_ID' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_del_documento_revisao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REVISAO_ID'  value='#arguments.REVISAO_ID#'  null='#iif(len(trim(arguments.REVISAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma secao 
	-- CRISTOFER 25/05/2006 17:14:05 - CRIADO
	--->
	<cffunction name='ins_documento_secao' displayname='Insere uma secao ' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_ins_documento_secao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SECAO_ID' variable='retorno.SECAO_ID'  null='#iif(len(trim(arguments.SECAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Secao inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma secao 
	-- CRISTOFER 25/05/2006 17:14:36 - CRIADO
	--->
	<cffunction name='upd_documento_secao' displayname='Altera uma secao ' access='remote' returntype='Struct' output='true'>;
		<cfargument name='SECAO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_alt_documento_secao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SECAO_ID'  value='#arguments.SECAO_ID#'  null='#iif(len(trim(arguments.SECAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Secao alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma secao 
	-- CRISTOFER 25/05/2006 17:15:07 - CRIADO
	--->
	<cffunction name='del_documento_secao' displayname='Exclui uma secao ' access='remote' returntype='Struct' output='true'>;
		<cfargument name='SECAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_desenvolvimento.prc_del_documento_secao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SECAO_ID'  value='#arguments.SECAO_ID#'  null='#iif(len(trim(arguments.SECAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Secao excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>		
		
	<!--- 
	-- PROPSITO
	-- Insere um atendimento
	-- cristofer 31/05/2006 09:19:02 - CRIADO
	--->
	<cffunction name='ins_atendimento' displayname='Insere um atendimento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='APLICACAO_ID' required='yes'>
		<cfargument name='USUARIO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_atendimento.prc_ins_atendimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_APLICACAO_ID'  value='#arguments.APLICACAO_ID#'  null='#iif(len(trim(arguments.APLICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ATENDIMENTO_ID' variable='retorno.ATENDIMENTO_ID'  >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atendimento inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um atendimento
	-- cristofer 31/05/2006 09:19:53 - CRIADO
	--->
	<cffunction name='upd_atendimento' displayname='Altera um atendimento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ATENDIMENTO_ID' required='yes'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='APLICACAO_ID' required='yes'>
		<cfargument name='USUARIO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_atendimento.prc_alt_atendimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ATENDIMENTO_ID'  value='#arguments.ATENDIMENTO_ID#'  null='#iif(len(trim(arguments.ATENDIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_APLICACAO_ID'  value='#arguments.APLICACAO_ID#'  null='#iif(len(trim(arguments.APLICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atendimento alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera a situacao de um atendimento
	-- cristofer 31/05/2006 09:23:48 - CRIADO
	--->
	<cffunction name='situacao_atendimento' displayname='Altera a situacao de um atendimento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ATENDIMENTO_ID' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_atendimento.prc_set_situacao_atendimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ATENDIMENTO_ID'  value='#arguments.ATENDIMENTO_ID#'  null='#iif(len(trim(arguments.ATENDIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atendimento alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma mensagem no atendimento
	-- cristofer 31/05/2006 09:25:17 - CRIADO
	--->
	<cffunction name='ins_atendimento_mensagem' displayname='Insere uma mensagem no atendimento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ATENDIMENTO_ID' required='yes'>
		<cfargument name='MENSAGEM' required='yes'>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_atendimento.prc_ins_atendimento_mensagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ATENDIMENTO_ID'  value='#arguments.ATENDIMENTO_ID#'  null='#iif(len(trim(arguments.ATENDIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MENSAGEM'  value='#arguments.MENSAGEM#'  null='#iif(len(trim(arguments.MENSAGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MENSAGEM_ID' variable='retorno.MENSAGEM_ID'  >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Mensagem inserida com sucesso!')>
			</cftransaction>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera o status do usuario no atendimento
	-- cristofer 31/05/2006 09:26:16 - CRIADO
	--->
	<cffunction name='status_atendimento' displayname='Altera o status do usuario no atendimento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ATENDIMENTO_ID' required='yes'>
		<cfargument name='DIGITANDO' required='yes'>
		<cfargument name='REFRESH' required='yes'>
		<cfargument name='MENSAGEM_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_atendimento.prc_set_atendimento_status' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ATENDIMENTO_ID'  value='#arguments.ATENDIMENTO_ID#'  null='#iif(len(trim(arguments.ATENDIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DIGITANDO'  value='#arguments.DIGITANDO#'  null='#iif(len(trim(arguments.DIGITANDO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REFRESH'  value='#arguments.REFRESH#'  null='#iif(len(trim(arguments.REFRESH)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MENSAGEM_ID'  value='#arguments.MENSAGEM_ID#'  null='#iif(len(trim(arguments.MENSAGEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Status alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma ferramenta
	-- cristofer 27/06/2006 09:18:44 - CRIADO
	--->
	<cffunction name='ins_ferramenta' displayname='Insere uma ferramenta' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ITEM_ACESSO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_ins_ferramenta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ACESSO_ID'  value='#arguments.ITEM_ACESSO_ID#'  null='#iif(len(trim(arguments.ITEM_ACESSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FERRAMENTA_ID' variable='retorno.FERRAMENTA_ID'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ferramenta inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma ferramenta
	-- cristofer 27/06/2006 09:20:26 - CRIADO
	--->
	<cffunction name='upd_ferramenta' displayname='Altera uma ferramenta' access='remote' returntype='Struct' output='true'>;
		<cfargument name='FERRAMENTA_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ITEM_ACESSO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_alt_ferramenta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FERRAMENTA_ID'  value='#arguments.FERRAMENTA_ID#'  null='#iif(len(trim(arguments.FERRAMENTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ACESSO_ID'  value='#arguments.ITEM_ACESSO_ID#'  null='#iif(len(trim(arguments.ITEM_ACESSO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ferramenta alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma ferramenta
	-- cristofer 27/06/2006 09:21:14 - CRIADO
	--->
	<cffunction name='del_ferramenta' displayname='Exclui uma ferramenta' access='remote' returntype='Struct' output='true'>;
		<cfargument name='FERRAMENTA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_del_ferramenta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FERRAMENTA_ID'  value='#arguments.FERRAMENTA_ID#'  null='#iif(len(trim(arguments.FERRAMENTA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ferramenta excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere uma descrio de processo
	-- cristofer 30/06/2006 15:15:31 - CRIADO
	--->
	<cffunction name='ins_processo' displayname='Insere uma descrio de processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ATIVIDADE' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='RESPONSAVEL' required='yes'>
		<cfargument name='OBSERVACOES' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_ins_processo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ATIVIDADE'  value='#arguments.ATIVIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RESPONSAVEL'  value='#arguments.RESPONSAVEL#'  null='#iif(len(trim(arguments.RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACOES'  value='#arguments.OBSERVACOES#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROCESSO_ID' variable='retorno.PROCESSO_ID'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<!--- Insero dos envolvidos --->
				<cfscript>
//					retorno.processo_id = arguments.processo_id;
					v_envolvido_id = this.ListaToArray (lista = arguments, variavel = "ENVOLVIDO_ID_ENVOLVIDOS");
					v_funcao_id = this.ListaToArray (lista = arguments, variavel = "ENVOLVIDO_ENVOLVIDOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ENVOLVIDOS, lista2 = ArrayToList(v_envolvido_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_processo_envolvido(envolvido_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_funcao_id)#" index="count">
					<cfscript>
						if(not len(trim(v_envolvido_id[count]))) {
							this.ins_processo_envolvido(processo_id = retorno.processo_id,
														funcao_id = v_funcao_id[count]);
						} else {
							this.upd_processo_envolvido(processo_id = retorno.processo_id,
														envolvido_id = v_envolvido_id[count],
														funcao_id = v_funcao_id[count]);
						}
					</cfscript>
				</cfloop>	
				<!--- Insercao das entradas --->
				<cfscript>
					v_entrada_p_id = this.ListaToArray (lista = arguments, variavel = "PROCESSO_ENTRADA_ID_ENTRADAS");
					v_entrada_id = this.ListaToArray (lista = arguments, variavel = "ENTRADA_ID_ENTRADAS");
					v_entrada = this.ListaToArray (lista = arguments, variavel = "ENTRADA_ENTRADAS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ENTRADAS, lista2 = ArrayToList(v_entrada_p_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_processo_evento(processo_evento_id = l_id);
					</cfscript>
				</cfloop>
				<cfdump var="#v_entrada_id#">
				<cfloop from="1" to="#ArrayLen(v_entrada_p_id)#" index="count">
					<cfscript>
						if(not len(trim(v_entrada_p_id[count]))) {
							this.ins_processo_evento(	processo_id = retorno.processo_id,
														evento_id 	= v_entrada_id[count],
														descricao	= v_entrada[count],
														entrada		= 1);
						} else {
							this.upd_processo_evento(	processo_id = retorno.processo_id,
														processo_evento_id = v_entrada_p_id[count],
														evento_id 	= v_entrada_id[count],
														descricao	= v_entrada[count],
														entrada		= 1);
						}
					</cfscript>
				</cfloop>			

				<!--- Insercao das saidas --->
				<cfscript>
					v_saida_p_id = this.ListaToArray (lista = arguments, variavel = "PROCESSO_SAIDA_ID_SAIDAS");
					v_saida_id = this.ListaToArray (lista = arguments, variavel = "SAIDA_ID_SAIDAS");
					v_saida = this.ListaToArray (lista = arguments, variavel = "SAIDA_SAIDAS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_SAIDAS, lista2 = ArrayToList(v_entrada_p_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_processo_evento(processo_evento_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_saida_p_id)#" index="count">
					<cfscript>
						if(not len(trim(v_saida_p_id[count]))) {
							this.ins_processo_evento(	processo_id = retorno.processo_id,
														evento_id 	= v_saida_id[count],
														descricao	= v_saida[count],
														entrada		= 0);
						} else {
							this.upd_processo_evento(	processo_id = retorno.processo_id,
														processo_evento_id = v_saida_p_id[count],
														evento_id 	= v_saida_id[count],
														descricao	= v_saida[count],
														entrada		= 0);
						}
					</cfscript>
				</cfloop>			

				<!--- Insercao das tarefas --->
				<cfscript>
					v_tarefa_id = this.ListaToArray (lista = arguments, variavel = "TAREFA_ID_TAREFAS");
					v_tarefa = this.ListaToArray (lista = arguments, variavel = "TAREFA_TAREFAS");
					v_tarefa_resp_id = this.ListaToArray (lista = arguments, variavel = "TAREFA_RESP_ID_TAREFAS");
					v_tarefa_fer_id = this.ListaToArray (lista = arguments, variavel = "TAREFA_FER_ID_TAREFAS");
					v_tarefa_ordem = this.ListaToArray (lista = arguments, variavel = "TAREFA_ORDEM_TAREFAS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_TAREFAS, lista2 = ArrayToList(v_tarefa_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_processo_tarefa(	processo_id = retorno.processo_id,
													tarefa_id	= l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_tarefa_id)#" index="count">
					<cfscript>
						if(not len(trim(v_tarefa_id[count]))) {
							this.ins_processo_tarefa(	processo_id = retorno.processo_id,
														descricao	= v_tarefa[count],
														responsavel	= v_tarefa_resp_id[count],
														ferramenta_id = v_tarefa_fer_id[count],
														ordem = v_tarefa_ordem[count]);
						} else {
							this.upd_processo_tarefa(	processo_id = retorno.processo_id,
														descricao	= v_tarefa[count],
														responsavel	= v_tarefa_resp_id[count],
														ferramenta_id = v_tarefa_fer_id[count],
														tarefa_id = v_tarefa_id[count],
														ordem = v_tarefa_ordem[count]);
						}
					</cfscript>
				</cfloop>			

				<!--- Insercao dos guias --->
				<cfscript>
					v_anexo_id = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_GUIAS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_GUIAS, lista2 = ArrayToList(v_anexo_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_processo_guia(	processo_id = retorno.processo_id,
												anexo_id	= l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_anexo_id)#" index="count">
					<cfscript>
							this.ins_processo_guia(	processo_id = retorno.processo_id,
													
													anexo_id = v_anexo_id[count]);
					</cfscript>
				</cfloop>		
				
				<!--- Insercao dos resultados --->
				<cfscript>
					v_resultado_id = this.ListaToArray (lista = arguments, variavel = "RESULTADO_ID_RESULTADOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_RESULTADOS, lista2 = ArrayToList(v_resultado_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_processo_resultado(	processo_id = retorno.processo_id,
														resultado_id	= l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_resultado_id)#" index="count">
					<cfscript>
							this.ins_processo_resultado(	processo_id = retorno.processo_id,
													        resultado_id = v_resultado_id[count]);
					</cfscript>
				</cfloop>			
										
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Processo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma descrio de processo
	-- cristofer 30/06/2006 15:16:43 - CRIADO
	--->
	<cffunction name='upd_processo' displayname='Altera uma descrio de processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROCESSO_ID' required='yes'>
		<cfargument name='ATIVIDADE' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='RESPONSAVEL' required='yes'>
		<cfargument name='OBSERVACOES' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_alt_processo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROCESSO_ID'  value='#arguments.PROCESSO_ID#'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ATIVIDADE'  value='#arguments.ATIVIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RESPONSAVEL'  value='#arguments.RESPONSAVEL#'  null='#iif(len(trim(arguments.RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACOES'  value='#arguments.OBSERVACOES#' >
				</cfstoredproc>
				<!--- Insero dos envolvidos ---->
				<cfscript>
					retorno.processo_id = arguments.processo_id;
					v_envolvido_id = this.ListaToArray (lista = arguments, variavel = "ENVOLVIDO_ID_ENVOLVIDOS");
					v_funcao_id = this.ListaToArray (lista = arguments, variavel = "ENVOLVIDO_ENVOLVIDOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ENVOLVIDOS, lista2 = ArrayToList(v_envolvido_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_processo_envolvido(envolvido_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_funcao_id)#" index="count">
					<cfscript>
						if(not len(trim(v_envolvido_id[count]))) {
							this.ins_processo_envolvido(processo_id = retorno.processo_id,
														funcao_id = v_funcao_id[count]);
						} else {
							this.upd_processo_envolvido(processo_id = retorno.processo_id,
														envolvido_id = v_envolvido_id[count],
														funcao_id = v_funcao_id[count]);
						}
					</cfscript>
				</cfloop>	
				<!--- Insercao das entradas --->
				<cfscript>
					v_entrada_p_id = this.ListaToArray (lista = arguments, variavel = "PROCESSO_ENTRADA_ID_ENTRADAS");
					v_entrada_id = this.ListaToArray (lista = arguments, variavel = "ENTRADA_ID_ENTRADAS");
					v_entrada = this.ListaToArray (lista = arguments, variavel = "ENTRADA_ENTRADAS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ENTRADAS, lista2 = ArrayToList(v_entrada_p_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_processo_evento(processo_evento_id = l_id);
					</cfscript>
				</cfloop>
				<cfdump var="#v_entrada_id#">
				<cfloop from="1" to="#ArrayLen(v_entrada_p_id)#" index="count">
					<cfscript>
						if(not len(trim(v_entrada_p_id[count]))) {
							this.ins_processo_evento(	processo_id = retorno.processo_id,
														evento_id 	= v_entrada_id[count],
														descricao	= v_entrada[count],
														entrada		= 1);
						} else {
							this.upd_processo_evento(	processo_id = retorno.processo_id,
														processo_evento_id = v_entrada_p_id[count],
														evento_id 	= v_entrada_id[count],
														descricao	= v_entrada[count],
														entrada		= 1);
						}
					</cfscript>
				</cfloop>			

				<!--- Insercao das saidas --->
				<cfscript>
					v_saida_p_id = this.ListaToArray (lista = arguments, variavel = "PROCESSO_SAIDA_ID_SAIDAS");
					v_saida_id = this.ListaToArray (lista = arguments, variavel = "SAIDA_ID_SAIDAS");
					v_saida = this.ListaToArray (lista = arguments, variavel = "SAIDA_SAIDAS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_SAIDAS, lista2 = ArrayToList(v_entrada_p_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_processo_evento(processo_evento_id = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_saida_p_id)#" index="count">
					<cfscript>
						if(not len(trim(v_saida_p_id[count]))) {
							this.ins_processo_evento(	processo_id = retorno.processo_id,
														evento_id 	= v_saida_id[count],
														descricao	= v_saida[count],
														entrada		= 0);
						} else {
							this.upd_processo_evento(	processo_id = retorno.processo_id,
														processo_evento_id = v_saida_p_id[count],
														evento_id 	= v_saida_id[count],
														descricao	= v_saida[count],
														entrada		= 0);
						}
					</cfscript>
				</cfloop>			

				<!--- Insercao das tarefas --->
				<cfscript>
					v_tarefa_id = this.ListaToArray (lista = arguments, variavel = "TAREFA_ID_TAREFAS");
					v_tarefa = this.ListaToArray (lista = arguments, variavel = "TAREFA_TAREFAS");
					v_tarefa_resp_id = this.ListaToArray (lista = arguments, variavel = "TAREFA_RESP_ID_TAREFAS");
					v_tarefa_fer_id = this.ListaToArray (lista = arguments, variavel = "TAREFA_FER_ID_TAREFAS");
					v_tarefa_ordem = this.ListaToArray (lista = arguments, variavel = "TAREFA_ORDEM_TAREFAS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_TAREFAS, lista2 = ArrayToList(v_tarefa_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_processo_tarefa(	processo_id = retorno.processo_id,
													tarefa_id	= l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_tarefa_id)#" index="count">
					<cfscript>
						if(not len(trim(v_tarefa_id[count]))) {
							this.ins_processo_tarefa(	processo_id = retorno.processo_id,
														descricao	= v_tarefa[count],
														responsavel	= v_tarefa_resp_id[count],
														ferramenta_id = v_tarefa_fer_id[count],
														ordem = v_tarefa_ordem[count]);
						} else {
							this.upd_processo_tarefa(	processo_id = retorno.processo_id,
														descricao	= v_tarefa[count],
														responsavel	= v_tarefa_resp_id[count],
														ferramenta_id = v_tarefa_fer_id[count],
														tarefa_id = v_tarefa_id[count],
														ordem = v_tarefa_ordem[count]);
						}
					</cfscript>
				</cfloop>			

				<!--- Insercao dos guias --->
				<cfscript>
					v_anexo_id = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_GUIAS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_GUIAS, lista2 = ArrayToList(v_anexo_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_processo_guia(	processo_id = retorno.processo_id,
												anexo_id	= l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_anexo_id)#" index="count">
					<cfscript>
							this.ins_processo_guia(	processo_id = retorno.processo_id,
													
													anexo_id = v_anexo_id[count]);
					</cfscript>
				</cfloop>		
				

				<!--- Insercao dos resultados --->
				<cfscript>
					v_resultado_id = this.ListaToArray (lista = arguments, variavel = "RESULTADO_ID_RESULTADOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_RESULTADOS, lista2 = ArrayToList(v_resultado_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_processo_resultado(	processo_id = retorno.processo_id,
														resultado_id	= l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_resultado_id)#" index="count">
					<cfscript>
							this.ins_processo_resultado(	processo_id = retorno.processo_id,
													
													resultado_id = v_resultado_id[count]);
					</cfscript>
				</cfloop>						

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Processo alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma descrio de processo
	-- cristofer 30/06/2006 15:20:45 - CRIADO
	--->
	<cffunction name='del_processo' displayname='Exclui uma descrio de processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROCESSO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_del_processo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROCESSO_ID'  value='#arguments.PROCESSO_ID#'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Processo excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Insere um envolvido no processo
	-- cristofer 30/06/2006 15:42:46 - CRIADO
	--->
	<cffunction name='ins_processo_envolvido' displayname='Insere um envolvido no processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROCESSO_ID' required='yes'>
		<cfargument name='FUNCAO_ID' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_ins_processo_envolvido' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROCESSO_ID'  value='#arguments.PROCESSO_ID#'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FUNCAO_ID'  value='#arguments.FUNCAO_ID#'  null='#iif(len(trim(arguments.FUNCAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENVOLVIDO_ID'  variable='retorno.envolvido_id'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Insere um envolvido no processo
	-- cristofer 30/06/2006 15:42:46 - CRIADO
	--->
	<cffunction name='upd_processo_envolvido' displayname='Insere um envolvido no processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ENVOLVIDO_ID' required='yes'>
		<cfargument name='PROCESSO_ID' required='yes'>
		<cfargument name='FUNCAO_ID' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_alt_processo_envolvido' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENVOLVIDO_ID' value='#arguments.ENVOLVIDO_ID#'  null='#iif(len(trim(arguments.ENVOLVIDO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROCESSO_ID'  value='#arguments.PROCESSO_ID#'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FUNCAO_ID'  value='#arguments.FUNCAO_ID#'  null='#iif(len(trim(arguments.FUNCAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Exclui um envolvido no processo
	-- cristofer 30/06/2006 15:41:55 - CRIADO
	--->
	<cffunction name='del_processo_envolvido' displayname='Exclui um envolvido no processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ENVOLVIDO_ID' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_del_processo_envolvido' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENVOLVIDO_ID' value='#arguments.ENVOLVIDO_ID#'  null='#iif(len(trim(arguments.ENVOLVIDO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um evento no processo
	-- cristofer 30/06/2006 16:37:42 - CRIADO
	--->
	<cffunction name='ins_processo_evento' displayname='Insere um evento no processo' access='remote' returntype='Struct' output='true'>
		<cfargument name='PROCESSO_ID' required='yes'>
		<cfargument name='EVENTO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ENTRADA' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_ins_processo_evento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROCESSO_ID'  value='#arguments.PROCESSO_ID#'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_EVENTO_ID'  value='#arguments.EVENTO_ID#' variable='retorno.EVENTO_ID'  null='#iif(len(trim(arguments.EVENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTRADA'  value='#arguments.ENTRADA#'  null='#iif(len(trim(arguments.ENTRADA)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROCESSO_EVENTO_ID' variable='retorno.PROCESSO_EVENTO_ID' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Altera um evento no processo
	-- cristofer 30/06/2006 16:38:33 - CRIADO
	--->
	<cffunction name='upd_processo_evento' displayname='Altera um evento no processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROCESSO_EVENTO_ID' required='yes'>
		<cfargument name='PROCESSO_ID' required='yes'>
		<cfargument name='EVENTO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ENTRADA' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_alt_processo_evento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROCESSO_EVENTO_ID'  value='#arguments.PROCESSO_EVENTO_ID#'  null='#iif(len(trim(arguments.PROCESSO_EVENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROCESSO_ID'  value='#arguments.PROCESSO_ID#'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_EVENTO_ID'  value='#arguments.EVENTO_ID#' variable='retorno.EVENTO_ID'  null='#iif(len(trim(arguments.EVENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTRADA'  value='#arguments.ENTRADA#'  null='#iif(len(trim(arguments.ENTRADA)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um evento no processo
	-- cristofer 30/06/2006 16:39:04 - CRIADO
	--->
	<cffunction name='del_processo_evento' displayname='Exclui um evento no processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROCESSO_EVENTO_ID' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_del_processo_evento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROCESSO_EVENTO_ID'  value='#arguments.PROCESSO_EVENTO_ID#'  null='#iif(len(trim(arguments.PROCESSO_EVENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere requisito
	-- guto 03/07/2006 09:15:06 - CRIADO
	--->
	<cffunction name='ins_requisito' displayname='Insere requisito' access='remote' returntype='Struct' output='true'>;
		<cfargument name='REQUISITO_PAI' required='no' default="">
		<cfargument name='COD_REQUISITO' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='ESCOPO' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='ESTADO_ID' required='yes'>
		<cfargument name='ESTABILIDADE_ID' required='yes'>
		<cfargument name='REQUISITO_DEPENDE_VINCULADO' required='no' default="">
		<cfargument name='REQUISITO_AFETA_VINCULADO' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_ins_requisito' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REQUISITO_PAI'  value='#arguments.REQUISITO_PAI#'  null='#iif(len(trim(arguments.REQUISITO_PAI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_REQUISITO'  value='#arguments.COD_REQUISITO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_CLOB'  dbvarname='P_ESCOPO'  value='#arguments.ESCOPO#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ESTADO_ID'  value='#arguments.ESTADO_ID#'  null='#iif(len(trim(arguments.ESTADO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ESTABILIDADE_ID'  value='#arguments.ESTABILIDADE_ID#'  null='#iif(len(trim(arguments.ESTABILIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REQUISITO_ID'  value='#arguments.REQUISITO_ID#' variable='retorno.REQUISITO_ID'  null='#iif(len(trim(arguments.REQUISITO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				
				<!---Cria vinculos --->
				<cfloop list="#arguments.REQUISITO_DEPENDE_VINCULADO#" index="i">
					<cfscript>
						this.ins_requisito_vinculo_private(requisito_id_1 = i,
						                           requisito_id_2 = retorno.REQUISITO_ID);
					</cfscript>
				</cfloop>
				<cfloop list="#arguments.REQUISITO_AFETA_VINCULADO#" index="i">
					<cfscript>
						this.ins_requisito_vinculo_private(requisito_id_1 = retorno.REQUISITO_ID,
						                           requisito_id_2 = i);
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Requisito inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera requisito
	-- guto 03/07/2006 09:15:54 - CRIADO
	--->
	<cffunction name='upd_requisito' displayname='Altera requisito' access='remote' returntype='Struct' output='true'>;
		<cfargument name='REQUISITO_ID' required='yes'>
		<cfargument name='REQUISITO_PAI' required='yes'>
		<cfargument name='COD_REQUISITO' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='ESCOPO' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='ESTADO_ID' required='yes'>
		<cfargument name='ESTABILIDADE_ID' required='yes'>
		<cfargument name='REQUISITO_DEPENDE_VINCULADO' required='no' default="">
		<cfargument name='REQUISITO_AFETA_VINCULADO' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_alt_requistio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REQUISITO_ID'  value='#arguments.REQUISITO_ID#'  null='#iif(len(trim(arguments.REQUISITO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_REQUISITO'  value='#arguments.COD_REQUISITO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REQUISITO_PAI'  value='#arguments.REQUISITO_PAI#'  null='#iif(len(trim(arguments.REQUISITO_PAI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_CLOB' dbvarname='P_ESCOPO'  value='#arguments.ESCOPO#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ESTADO_ID'  value='#arguments.ESTADO_ID#'  null='#iif(len(trim(arguments.ESTADO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ESTABILIDADE_ID'  value='#arguments.ESTABILIDADE_ID#'  null='#iif(len(trim(arguments.ESTABILIDADE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>

				<!---Limpa vinculos --->
					<cfscript>
						this.del_all_requisito_vinculo(requisito_id = arguments.REQUISITO_ID);
					</cfscript>				
				<!---Cria vinculos --->
				<cfloop list="#arguments.REQUISITO_DEPENDE_VINCULADO#" index="i">
					<cfscript>
						this.ins_requisito_vinculo_private(requisito_id_1 = i,
						                           requisito_id_2 = arguments.REQUISITO_ID);
					</cfscript>
				</cfloop>
				<cfloop list="#arguments.REQUISITO_AFETA_VINCULADO#" index="i">
					<cfscript>
						this.ins_requisito_vinculo_private(requisito_id_1 = arguments.REQUISITO_ID,
						                           requisito_id_2 = i);
					</cfscript>
				</cfloop>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Requisito alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui requisito
	-- guto 03/07/2006 09:16:47 - CRIADO
	--->
	<cffunction name='del_requisito' displayname='Exclui requisito' access='remote' returntype='Struct' output='true'>;
		<cfargument name='REQUISITO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_del_requisito' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REQUISITO_ID'  value='#arguments.REQUISITO_ID#'  null='#iif(len(trim(arguments.REQUISITO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Requisito excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
		
	<!--- 
	-- PROPSITO
	-- Insere um novo vinculo entre requisitos (PRIVATE)
	-- guto 03/07/2006 16:26:05 - CRIADO
	--->
	<cffunction name='ins_requisito_vinculo_private' displayname='Insere um novo vinculo entre requisitos' access='remote'>;
		<cfargument name='REQUISITO_ID_1' required='yes'>
		<cfargument name='REQUISITO_ID_2' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_ins_requisito_vinculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REQUISITO_ID_1'  value='#arguments.REQUISITO_ID_1#'  null='#iif(len(trim(arguments.REQUISITO_ID_1)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REQUISITO_ID_2'  value='#arguments.REQUISITO_ID_2#'  null='#iif(len(trim(arguments.REQUISITO_ID_2)), de('no'), de('yes'))#'>
				</cfstoredproc>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere um novo vinculo entre requisitos
	-- guto 03/07/2006 16:26:05 - CRIADO
	--->
	<cffunction name='ins_requisito_vinculo' displayname='Insere um novo vinculo entre requisitos' access='remote' returntype="struct">;
		<cfargument name='REQUISITO_ID_1' required='yes'>
		<cfargument name='REQUISITO_ID_2' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_ins_requisito_vinculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REQUISITO_ID_1'  value='#arguments.REQUISITO_ID_1#'  null='#iif(len(trim(arguments.REQUISITO_ID_1)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REQUISITO_ID_2'  value='#arguments.REQUISITO_ID_2#'  null='#iif(len(trim(arguments.REQUISITO_ID_2)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Vinculo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui vinculo entre requisitos
	-- guto 03/07/2006 16:26:48 - CRIADO
	--->
	<cffunction name='del_requisito_vinculo' displayname='Exclui vinculo entre requisitos' access='remote' returntype='Struct' output='true'>;
		<cfargument name='REQUISITO_ID_1' required='yes'>
		<cfargument name='REQUISITO_ID_2' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_del_requisito_vinculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REQUISITO_ID_1'  value='#arguments.REQUISITO_ID_1#'  null='#iif(len(trim(arguments.REQUISITO_ID_1)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REQUISITO_ID_2'  value='#arguments.REQUISITO_ID_2#'  null='#iif(len(trim(arguments.REQUISITO_ID_2)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Vinculo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui todos os vinculos do requisito
	-- guto 03/07/2006 16:27:26 - CRIADO
	--->
	<cffunction name='del_all_requisito_vinculo' displayname='Exclui todos os vinculos do requisito' access='remote' output='false'>;
		<cfargument name='REQUISITO_ID' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_del_all_requisito_vinculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REQUISITO_ID'  value='#arguments.REQUISITO_ID#'  null='#iif(len(trim(arguments.REQUISITO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere uma tarefa no processo
	-- cristofer 03/07/2006 10:49:28 - CRIADO
	--->
	<cffunction name='ins_processo_tarefa' displayname='Insere uma tarefa no processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROCESSO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='RESPONSAVEL' required='yes'>
		<cfargument name='FERRAMENTA_ID' required='yes'>
		<cfargument name='ORDEM' required='yes'>
			<cfdump var="#arguments#">
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_ins_processo_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROCESSO_ID'  value='#arguments.PROCESSO_ID#'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RESPONSAVEL'  value='#arguments.RESPONSAVEL#'  null='#iif(len(trim(arguments.RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FERRAMENTA_ID'  value='#arguments.FERRAMENTA_ID#'  null='#iif(len(trim(arguments.FERRAMENTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ORDEM'  value='#arguments.ORDEM#'  null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TAREFA_ID' variable='retorno.TAREFA_ID'  >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma tarefa no processo
	-- cristofer 03/07/2006 10:52:01 - CRIADO
	--->
	<cffunction name='upd_processo_tarefa' displayname='Altera uma tarefa no processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROCESSO_ID' required='yes'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='RESPONSAVEL' required='yes'>
		<cfargument name='FERRAMENTA_ID' required='yes'>
		<cfargument name='ORDEM' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_alt_processo_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROCESSO_ID'  value='#arguments.PROCESSO_ID#'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RESPONSAVEL'  value='#arguments.RESPONSAVEL#'  null='#iif(len(trim(arguments.RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FERRAMENTA_ID'  value='#arguments.FERRAMENTA_ID#'  null='#iif(len(trim(arguments.FERRAMENTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ORDEM'  value='#arguments.ORDEM#'  null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma tarefa no processo
	-- cristofer 03/07/2006 10:53:02 - CRIADO
	--->
	<cffunction name='del_processo_tarefa' displayname='Exclui uma tarefa no processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROCESSO_ID' required='yes'>
		<cfargument name='TAREFA_ID' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_del_processo_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROCESSO_ID'  value='#arguments.PROCESSO_ID#'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere um guia do processo
	-- cristofer 03/07/2006 14:00:42 - CRIADO
	--->
	<cffunction name='ins_processo_guia' displayname='Insere um guia do processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROCESSO_ID' required='yes'>
		<cfargument name='ANEXO_ID' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_ins_processo_guia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROCESSO_ID'  value='#arguments.PROCESSO_ID#'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um guia do processo
	-- cristofer 03/07/2006 14:00:42 - CRIADO
	--->
	<cffunction name='del_processo_guia' displayname='Exclui um guia do processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROCESSO_ID' required='yes'>
		<cfargument name='ANEXO_ID' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_del_processo_guia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROCESSO_ID'  value='#arguments.PROCESSO_ID#'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere um resultado no processo
	-- cristofer 03/07/2006 16:06:55 - CRIADO
	--->
	<cffunction name='ins_processo_resultado' displayname='Insere um resultado no processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROCESSO_ID' required='yes'>
		<cfargument name='RESULTADO_ID' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_ins_processo_resultado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROCESSO_ID'  value='#arguments.PROCESSO_ID#'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RESULTADO_ID'  value='#arguments.RESULTADO_ID#'  null='#iif(len(trim(arguments.RESULTADO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Exclui um resultado no processo
	-- cristofer 03/07/2006 16:06:55 - CRIADO
	--->
	<cffunction name='del_processo_resultado' displayname='Exclui um resultado no processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROCESSO_ID' required='yes'>
		<cfargument name='RESULTADO_ID' required='yes'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_del_processo_resultado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROCESSO_ID'  value='#arguments.PROCESSO_ID#'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RESULTADO_ID'  value='#arguments.RESULTADO_ID#'  null='#iif(len(trim(arguments.RESULTADO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	
    
    <!--- 
	-- PROPSITO
	-- Insere uma SD
	-- JONAS 02/04/2009 16:23:33 - CRIADO
	--->
	<cffunction name='ins_sd' displayname='Insere uma SD' access='remote' returntype='Struct' output='true'>
		<cfargument name='CODIGO' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='MODULO_ID' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='ESCOPO_REQUISITO' required='yes'>
		<cfargument name='MOTIVO' required='yes'>
	    <cfargument name='OBSERVACOES' required='no' default="">
		<cfargument name='ANALISE_IMPACTO' required='yes'>
		<cfargument name='TEXTO_APROVACAO' required='yes'>
		<cfargument name='TERMO_ENCERRAMENTO' required='yes'>
        <cfargument name='DATA_SOLICITACAO' required='yes'>
		<cfargument name='RESPONSAVEL_SD' required='yes'>
        <cfargument name='TIPO_ID' required='yes'>
        <cfargument name='SD_ID_GERADORA' required='no' default="">
        <cfargument name='TECNICO_APROVACAO' required='no' default="">

		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_producao.prc_ins_sd' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID' variable='retorno.SD_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO'  value='#arguments.CODIGO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MODULO_ID'  value='#arguments.MODULO_ID#'  null='#iif(len(trim(arguments.MODULO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_ESCOPO_REQUISITO'  value='#arguments.ESCOPO_REQUISITO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_MOTIVO'  value='#arguments.MOTIVO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_OBSERVACOES'  value='#arguments.OBSERVACOES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_ANALISE_IMPACTO'  value='#arguments.ANALISE_IMPACTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_TEXTO_APROVACAO'  value='#arguments.TEXTO_APROVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_TERMO_ENCERRAMENTO'  value='#arguments.TERMO_ENCERRAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_SOLICITACAO'  value='#arguments.DATA_SOLICITACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RESPONSAVEL_SD'  value='#arguments.RESPONSAVEL_SD#'  null='#iif(len(trim(arguments.RESPONSAVEL_SD)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID_GERADORA'  value='#arguments.SD_ID_GERADORA#'  null='#iif(len(trim(arguments.SD_ID_GERADORA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TECNICO_APROVACAO'  value='#arguments.TECNICO_APROVACAO#'  null='#iif(len(trim(arguments.TECNICO_APROVACAO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                
                <!--- Insere os responsveis --->
                <cfscript>
					v_recurso_id = this.ListaToArray(lista = arguments, variavel = 'RECURSO_ID_RESPONSAVEIS');
					v_funcao_id  = this.ListaToArray(lista = arguments, variavel = 'FUNCAO_ID_RESPONSAVEIS');
					v_ordem      = this.ListaToArray(lista = arguments, variavel = 'ORDEM_RESPONSAVEIS');
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_recurso_id)#" index="count">
					<cfscript>
						ret = this.ins_sd_responsaveis( SD_ID       = retorno.SD_ID,
														RECURSO_ID  = v_recurso_id[count],
														FUNCAO_ID   = v_funcao_id[count],
														ORDEM		= v_ordem[count]
													  );
					</cfscript>
                    <cfif ret.erro>
                      <cfthrow object="#ret.mensagem#"/>
                    </cfif>
                </cfloop>				
                <!--- Fim --->
                
                <!--- Insere os etapas --->
                <cfscript>
					v_etapa_id = this.ListaToArray(lista = arguments, variavel = 'ETAPA_ID_ETAPA_HORA');
					v_hora  = this.ListaToArray(lista = arguments, variavel = 'HORA_ETAPA_HORA');
					v_minuto  = this.ListaToArray(lista = arguments, variavel = 'MINUTO_ETAPA_HORA');
					v_confirmado  = this.ListaToArray(lista = arguments, variavel = 'CONFIRMADO_ETAPA_HORA');
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_etapa_id)#" index="count">
					<cfscript>
						etp = this.ins_sd_etapa_hora( SD_ID     = retorno.SD_ID,
													  ETAPA_ID  = v_etapa_id[count],
													  HORA      = v_hora[count],
													  MINUTO    = v_minuto[count],
													  CONFIRMADO = v_confirmado[count] 
													  );
					</cfscript>
                    <cfif etp.erro>
                      <cfthrow object="#etp.mensagem#"/>
                    </cfif>
                </cfloop>				
                <!--- Fim --->                
                
                <!--- Insere os anexos --->
               <cfscript>
					v_anexo_id      = this.ListaToArray(lista = arguments, variavel = 'ANEXO_ID_ANEXOS');
					v_anexo_titulo  = this.ListaToArray(lista = arguments, variavel = 'ANEXO_TITULO_ANEXOS');
					v_anexo_url     = this.ListaToArray(lista = arguments, variavel = 'ANEXO_URL_ANEXOS');
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_anexo_id)#" index="count">
					<cfscript>
						ret = this.ins_sd_anexo( SD_ID        = retorno.SD_ID,
												 ANEXO_ID     = v_anexo_id[count]);
					</cfscript>
                    <cfif ret.erro>
                      <cfthrow object="#ret.mensagem#"/>
                    </cfif>
                </cfloop>			
                <!--- Fim --->
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('SD inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Altera uma SD
	-- JONAS 02/04/2009 16:35:04 - CRIADO
	--->
	<cffunction name='upd_sd' displayname='Altera uma SD' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='CODIGO' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='MODULO_ID' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='ESCOPO_REQUISITO' required='yes'>
		<cfargument name='MOTIVO' required='yes'>
		<cfargument name='OBSERVACOES' required='no' default="">
		<cfargument name='ANALISE_IMPACTO' required='yes'>
		<cfargument name='TEXTO_APROVACAO' required='yes'>
		<cfargument name='TERMO_ENCERRAMENTO' required='yes'>
        <cfargument name='DATA_SOLICITACAO' required='yes'>
		<cfargument name='RESPONSAVEL_SD' required='yes'>
        <cfargument name='TIPO_ID' required='yes'>
        <cfargument name='SD_ID_GERADORA' required='no' default="">
        <cfargument name='TECNICO_APROVACAO' required='no' default="">

		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_producao.prc_alt_sd' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO'  value='#arguments.CODIGO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MODULO_ID'  value='#arguments.MODULO_ID#'  null='#iif(len(trim(arguments.MODULO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_ESCOPO_REQUISITO'  value='#arguments.ESCOPO_REQUISITO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_MOTIVO'  value='#arguments.MOTIVO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_OBSERVACOES'  value='#arguments.OBSERVACOES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_ANALISE_IMPACTO'  value='#arguments.ANALISE_IMPACTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_TEXTO_APROVACAO'  value='#arguments.TEXTO_APROVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_TERMO_ENCERRAMENTO'  value='#arguments.TERMO_ENCERRAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_SOLICITACAO'  value='#arguments.DATA_SOLICITACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RESPONSAVEL_SD'  value='#arguments.RESPONSAVEL_SD#'  null='#iif(len(trim(arguments.RESPONSAVEL_SD)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID_GERADORA'  value='#arguments.SD_ID_GERADORA#'  null='#iif(len(trim(arguments.SD_ID_GERADORA)), de('no'), de('yes'))#'>					
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TECNICO_APROVACAO'  value='#arguments.TECNICO_APROVACAO#'  null='#iif(len(trim(arguments.TECNICO_APROVACAO)), de('no'), de('yes'))#'>
				</cfstoredproc>
                
                <cfscript>
					conn = CreateComponent("_transportes.consulta.cfc_desenvolvimento");
				</cfscript>
                
				<!--- Altera os responsveis  --->
                
                <cfscript>
					v_controle_id = this.ListaToArray(lista = arguments, variavel = 'CONTROLE_ID_RESPONSAVEIS');
					v_recurso_id  = this.ListaToArray(lista = arguments, variavel = 'RECURSO_ID_RESPONSAVEIS');
					v_funcao_id   = this.ListaToArray(lista = arguments, variavel = 'FUNCAO_ID_RESPONSAVEIS');
					v_ordem       = this.ListaToArray(lista = arguments, variavel = 'ORDEM_RESPONSAVEIS');
					v_excluir     = this.ListDiff(lista1 = arguments.lista_deleted_RESPONSAVEIS, lista2 = ArrayToList(v_controle_id));
				</cfscript>
				 <!---Excluir os itens---> 
				<cfloop list="#v_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_sd_responsaveis(controle_id  = l_item_id);	
					</cfscript>
				</cfloop>
                
				<cfloop from="1" to="#ArrayLen(v_recurso_id)#" index="count">
					<cfscript>
						if(Not Len(Trim(v_controle_id[count]))) {
							ret = this.ins_sd_responsaveis( SD_ID       = arguments.SD_ID,
															RECURSO_ID  = v_recurso_id[count],
															FUNCAO_ID   = v_funcao_id[count],
															ORDEM	    = v_ordem[count]);
						}
						else {
							ret = this.upd_sd_responsaveis( CONTROLE_ID = v_controle_id[count],
															SD_ID       = arguments.SD_ID,
															RECURSO_ID  = v_recurso_id[count],
															FUNCAO_ID   = v_funcao_id[count],
															ORDEM	    = v_ordem[count]);
						}
					</cfscript>
                    <cfif ret.erro>
                       <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
               <!---  Fim --->
               
                <!--- Insere os etapas --->
                <cfscript>
					v_controle_id = this.ListaToArray(lista = arguments, variavel = 'CONTROLE_ID_ETAPA_ETAPA_HORA');
					v_etapa_id = this.ListaToArray(lista = arguments, variavel = 'ETAPA_ID_ETAPA_HORA');
					v_hora  = this.ListaToArray(lista = arguments, variavel = 'HORA_ETAPA_HORA');
					v_minuto  = this.ListaToArray(lista = arguments, variavel = 'MINUTO_ETAPA_HORA');
					v_confirmado  = this.ListaToArray(lista = arguments, variavel = 'CONFIRMADO_ETAPA_HORA');
					v_excluir     = this.ListDiff(lista1 = arguments.lista_deleted_ETAPA_HORA, lista2 = ArrayToList(v_controle_id));
				</cfscript>
				 <!---Excluir os itens---> 
				<cfloop list="#v_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_sd_etapa_hora(controle_id  = l_item_id);	
					</cfscript>
				</cfloop>
                
				<cfloop from="1" to="#ArrayLen(v_etapa_id)#" index="count">
					<cfscript>
						if(Not Len(Trim(v_controle_id[count]))) {
							etp = this.ins_sd_etapa_hora( SD_ID     = arguments.SD_ID,
														  ETAPA_ID  = v_etapa_id[count],
														  HORA      = v_hora[count],
														  MINUTO    = v_minuto[count],
														  CONFIRMADO = v_confirmado[count] 
														  );
						} else {
							etp = this.upd_sd_etapa_hora( CONTROLE_ID = v_controle_id[count],
														  SD_ID     = arguments.SD_ID,
														  ETAPA_ID  = v_etapa_id[count],
														  HORA      = v_hora[count],
														  MINUTO    = v_minuto[count],
														  CONFIRMADO = v_confirmado[count] 
														  );
						}
					</cfscript>
                    
                    <cfif etp.erro>
                      <cfthrow object="#etp.mensagem#"/>
                    </cfif>
                </cfloop>				
                <!--- Fim --->                  
                
                <!--- Altera os anexos  --->
                
                <cfscript>
					v_sd_anexo_id    = this.ListaToArray(lista = arguments, variavel = 'SD_ANEXO_ID_ANEXOS');
					v_anexo_id       = this.ListaToArray(lista = arguments, variavel = 'ANEXO_ID_ANEXOS');
					v_anexo_titulo   = this.ListaToArray(lista = arguments, variavel = 'ANEXO_TITULO_ANEXOS');
					v_anexo_url      = this.ListaToArray(lista = arguments, variavel = 'ANEXO_URL_ANEXOS');
					v_excluir        = this.ListDiff(lista1 = arguments.lista_deleted_ANEXOS, lista2 = ArrayToList(v_sd_anexo_id));
				</cfscript>
				 <!---Excluir os itens---> 
				<cfloop list="#v_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_sd_anexo(sd_anexo_id  = l_item_id);	
					</cfscript>
				</cfloop>
                
				<cfloop from="1" to="#ArrayLen(v_anexo_id)#" index="count">
					<cfscript>
						if(Not Len(Trim(v_sd_anexo_id[count]))) {
							ret = this.ins_sd_anexo( SD_ID        = arguments.SD_ID,
													 ANEXO_ID     = v_anexo_id[count]);
						}
						else {
							ret = this.upd_sd_anexo( SD_ANEXO_ID  = v_sd_anexo_id[count],
													 SD_ID        = arguments.SD_ID,
													 ANEXO_ID     = v_anexo_id[count]);
						}
					</cfscript>
                    <cfif ret.erro>
                       <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
               <!---  Fim --->
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('SD alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
   <!--- 
	-- PROPSITO
	-- Exclui uma SD
	-- JONAS 02/04/2009 16:28:28 - CRIADO
	--->
	<cffunction name='del_sd' displayname='Exclui uma SD' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_producao.prc_del_sd' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('SD excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Libera o desenvolvimento das tarefas de uma sd
	-- CRISTOFER 10/10/2009 16:40:33 - CRIADO
	--->
	<cffunction name='liberar_desenvolvimento_sd' displayname='Insere uma SD' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='LIBERADA_DESENVOLVIMENTO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_producao.prc_liberar_desenvolvimento_sd' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_LIBERADA_DESENVOLVIMENTO'  value='#arguments.LIBERADA_DESENVOLVIMENTO#'  null='#iif(len(trim(arguments.LIBERADA_DESENVOLVIMENTO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tarefas da SD '&iif(arguments.liberada_desenvolvimento eq 1,de('liberadas'),de('bloqueadas'))&' com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere responsveis de solicitao de desenvolvimento
	-- JONAS 04/04/2009 10:28:46 - CRIADO
	--->
	<cffunction name='ins_sd_responsaveis' displayname='Insere responsvel de solicitao de desenvolvimento' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='FUNCAO_ID' required='yes'>
		<cfargument name='ORDEM' required='yes'>
		<cftry>
            <cfstoredproc procedure='kmm.pkg_producao.prc_ins_sd_responsaveis' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FUNCAO_ID'  value='#arguments.FUNCAO_ID#'  null='#iif(len(trim(arguments.FUNCAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ORDEM'  value='#arguments.ORDEM#'  null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Responsavel de SD inserido com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera responsveis de solicitao de desenvolvimento
	-- JONAS 04/04/2009 10:32:39 - CRIADO
	--->
	<cffunction name='upd_sd_responsaveis' displayname='Altera responsvel de solicitao de desenvolvimento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='FUNCAO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='kmm.pkg_producao.prc_alt_sd_responsaveis' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FUNCAO_ID'  value='#arguments.FUNCAO_ID#'  null='#iif(len(trim(arguments.FUNCAO_ID)), de('no'), de('yes'))#'>
	                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ORDEM'  value='#arguments.ORDEM#'  null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Responsveis de SD alterados com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui responsveis de solicitao de desenvolvimento
	-- JONAS 04/04/2009 10:35:44 - CRIADO
	--->
	<cffunction name='del_sd_responsaveis' displayname='Exclui responsvel de solicitao de desenvolvimento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cftry>
			<!---<cftransaction action='begin'>--->
				<cfstoredproc procedure='kmm.pkg_producao.prc_del_sd_responsaveis' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Responsvel de SD excludo com sucesso!')>
			<!---</cftransaction>--->
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
    -- PROPSITO
    -- Insere detalhamento
    -- guto 08/04/2009 10:38:15 - CRIADO
    --->
    <cffunction name='ins_sd_detalhamento' displayname='Insere detalhamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='SD_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='EXIGE_TAREFA' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kmm.pkg_producao.prc_ins_sd_detalhamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_DETALHAMENTO_ID' variable='retorno.SD_DETALHAMENTO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='cf_sql_clob' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_STATUS'  value='0'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_EXIGE_TAREFA'  value='#arguments.EXIGE_TAREFA#'  null='#iif(len(trim(arguments.EXIGE_TAREFA)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Detalhamento inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera detalhamento
    -- guto 08/04/2009 10:39:20 - CRIADO
    --->
    <cffunction name='upd_sd_detalhamento' displayname='Altera detalhamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='SD_DETALHAMENTO_ID' required='yes'>
        <cfargument name='SD_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='EXIGE_TAREFA' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kmm.pkg_producao.prc_alt_sd_detalhamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_DETALHAMENTO_ID'  value='#arguments.SD_DETALHAMENTO_ID#'  null='#iif(len(trim(arguments.SD_DETALHAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_clob' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_EXIGE_TAREFA'  value='#arguments.EXIGE_TAREFA#'  null='#iif(len(trim(arguments.EXIGE_TAREFA)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Detalhamento alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

    <!--- 
    -- PROPSITO
    -- Altera SD do detalhamento
    -- guto 08/04/2009 10:39:20 - CRIADO
    --->
    <cffunction name='upd_sd_detalhamento_sd' displayname='Altera detalhamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='SD_DETALHAMENTO_ID' required='yes'>
        <cfargument name='SD_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kmm.pkg_producao.prc_alt_sd_detalhamento_sd' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_DETALHAMENTO_ID'  value='#arguments.SD_DETALHAMENTO_ID#'  null='#iif(len(trim(arguments.SD_DETALHAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Detalhamento alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>       
    
    <!--- 
    -- PROPSITO
    -- Exclui detalhamento
    -- guto 08/04/2009 10:41:03 - CRIADO
    --->
    <cffunction name='del_sd_detalhamento' displayname='Exclui detalhamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='SD_DETALHAMENTO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kmm.pkg_producao.prc_del_sd_detalhamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_DETALHAMENTO_ID'  value='#arguments.SD_DETALHAMENTO_ID#'  null='#iif(len(trim(arguments.SD_DETALHAMENTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Detalhamento excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui detalhamento
    -- guto 08/04/2009 10:41:03 - CRIADO
    --->
    <cffunction name='muda_ordem_sd_detalhamento' displayname='Exclui detalhamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='SD_DETALHAMENTO_ID' required='yes'>
        <cfargument name='ORDEM' required='yes'> 
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kmm.pkg_producao.prc_sd_detalhamento_ordem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_DETALHAMENTO_ID'  value='#arguments.SD_DETALHAMENTO_ID#'  null='#iif(len(trim(arguments.SD_DETALHAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ORDEM'  value='#arguments.ORDEM#'  null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ordem alterda com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere anexo de uma SD (solicitao de desenvolvimento)
	-- jonas 14/04/2009 17:13:30 - CRIADO
	--->
	<cffunction name='ins_sd_anexo' displayname='Insere anexo de uma SD (solicitao de desenvolvimento)' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='ANEXO_ID' required='yes'>
		<cftry>
			<!---<cftransaction action='begin'>--->
				<cfstoredproc procedure='kmm.pkg_producao.prc_ins_sd_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ANEXO_ID' variable='retorno.SD_ANEXO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Anexo inserido com sucesso!')>
			<!---</cftransaction>--->
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera anexo de uma SD (solicitao de desenvolvimento)
	-- jonas 14/04/2009 17:15:16 - CRIADO
	--->
	<cffunction name='upd_sd_anexo' displayname='Altera anexo de uma SD (solicitao de desenvolvimento)' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ANEXO_ID' required='yes'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='ANEXO_ID' required='yes'>
		<cftry>
			<!---<cftransaction action='begin'>--->
				<cfstoredproc procedure='kmm.pkg_producao.prc_alt_sd_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ANEXO_ID'  value='#arguments.SD_ANEXO_ID#'  null='#iif(len(trim(arguments.SD_ANEXO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Anexo alterado com sucesso!')>
			<!---</cftransaction>--->
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui anexo de uma SD (solicitao de desenvolvimento)
	-- jonas 14/04/2009 17:16:34 - CRIADO
	--->
	<cffunction name='del_sd_anexo' displayname='Exclui anexo de uma SD (solicitao de desenvolvimento)' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ANEXO_ID' required='yes'>
		<cftry>
			<!---<cftransaction action='begin'>--->
				<cfstoredproc procedure='kmm.pkg_producao.prc_del_sd_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ANEXO_ID'  value='#arguments.SD_ANEXO_ID#'  null='#iif(len(trim(arguments.SD_ANEXO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Anexo excludo com sucesso!')>
			<!---</cftransaction>--->
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>    

    <!--- 
	-- PROPSITO
	-- Altera prioridade 
	-- GUTO 21/04/2009 14:26:34 - CRIADO
	--->
	<cffunction name='upd_sd_prioridade' displayname='Altera prioridade ' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='PRIORIDADE' required='yes'>
		<cftry>
				<cfstoredproc procedure='kmm.pkg_producao.prc_alt_sd_prioridade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PRIORIDADE'  value='#arguments.PRIORIDADE#'  null='#iif(len(trim(arguments.PRIORIDADE)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Prioridade alterada com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!--- 
	-- PROPSITO
	-- Altera prioridade  KMM
	-- GUTO 21/04/2009 14:26:34 - CRIADO
	--->
	<cffunction name='upd_sd_prioridade_kmm' displayname='Altera prioridade ' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='PRIORIDADE' required='yes'>
		<cftry>
				<cfstoredproc procedure='kmm.pkg_producao.prc_alt_sd_prioridade_kmm' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PRIORIDADE'  value='#arguments.PRIORIDADE#'  null='#iif(len(trim(arguments.PRIORIDADE)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Prioridade alterada com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!--- 
	-- PROPSITO
	-- Altera FLAG SD
	-- GUTO 21/04/2009 14:26:34 - CRIADO
	---> 
	<cffunction name='upd_sd_flag' displayname='Altera prioridade ' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='FLAG' required='yes'>
  		    <cftry>
				<cfstoredproc procedure='kmm.pkg_producao.prc_alt_sd_flag' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='cf_sql_varchar' dbvarname='P_FLAG'  value='#arguments.FLAG#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Flag alterado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!--- 
	-- PROPSITO
	-- Altera OBS PRODUCAO
	-- GUTO 21/04/2009 14:26:34 - CRIADO
	---> 
	<cffunction name='upd_sd_obs_producao' displayname='Altera prioridade ' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='OBS_PRODUCAO' required='yes'>
  		    <cftry>
				<cfstoredproc procedure='kmm.pkg_producao.prc_alt_obs_producao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='cf_sql_varchar' dbvarname='P_OBS_PRODUCAO'  value='#arguments.OBS_PRODUCAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Observao alterada com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera SD para finalizada pelo responsvel.
	-- jonas 24/04/2009 14:21:32 - CRIADO
	--->
	<cffunction name='upd_sd_conclusao' displayname='Altera SD para concluda.' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_producao.prc_alt_sd_conclusao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
                <!--- Insere as avaliaes --->
                <cfscript>
					v_item_id    = this.ListaToArray(lista = arguments, variavel = 'ITEM_ID');
					v_nota       = this.ListaToArray(lista = arguments, variavel = 'NOTA_CAMPO');
					v_observacao = this.ListaToArray(lista = arguments, variavel = 'OBSERVACAO_CAMPO');
				</cfscript>
                <cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
                    <cfif Len(trim(v_nota[count]))>
                        <cfscript>
                            ret = this.ins_sd_avaliacao( SD_ID                  = arguments.SD_ID
                                                        ,ITEM_ID                = v_item_id[count]
                                                        ,RESPONSAVEL_NOTA       = v_nota[count]
                                                        ,RESPONSAVEL_OBSERVACAO = v_observacao[count]
                                                        );
                        </cfscript>
                        <cfif ret.erro>
                       		<cfthrow object="#ret.mensagem#">
                    	</cfif>
                    </cfif>                    
                </cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('S.D. concluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>  
    
    <!--- 
	-- PROPSITO
	-- Altera SD para finalizada pelo cliente.
	-- jonas 26/04/2009 10:40 - CRIADO
	--->
    <cffunction name='upd_sd_conclusao_cliente' displayname='Altera SD para concluda pelo cliente.' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='DATA_CONCLUSAO' required='no'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_producao.prc_alt_sd_conclusao_cliente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CONCLUSAO'  value='#arguments.DATA_CONCLUSAO#' >
				</cfstoredproc>
                <!--- Insere as avaliaes --->
                <cfscript>
					v_item_id    = this.ListaToArray(lista = arguments, variavel = 'ITEM_ID');
					v_nota       = this.ListaToArray(lista = arguments, variavel = 'NOTA_CAMPO');
					v_observacao = this.ListaToArray(lista = arguments, variavel = 'OBSERVACAO_CAMPO');
				</cfscript>
                
                <cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
					conn = CreateComponent("_transportes.consulta.cfc_desenvolvimento");
	            	qrItem = conn.get_sd_avaliacao(SD_ID = arguments.SD_ID,ITEM_ID = v_item_id[count]);
					</cfscript>
					<cfif qrItem.RecordCount gt 0> 
                    <cfscript>
                		ret = this.upd_sd_avaliacao( SD_ID                  = arguments.SD_ID
                                                    ,ITEM_ID                = v_item_id[count]
                                                    ,CLIENTE_NOTA           = v_nota[count]
                                                    ,CLIENTE_OBSERVACAO     = v_observacao[count]
                                                    );
                    </cfscript>
                    <cfelse>
                    <cfoutput>
                    <script>
					</script>
                    </cfoutput>
											 
                    <cfscript>
                    	ret = this.ins_sd_avaliacao_cliente( SD_ID                  = arguments.SD_ID
                                                    ,ITEM_ID                = v_item_id[count]
                                                    ,CLIENTE_NOTA       = v_nota[count]
                                                    ,CLIENTE_OBSERVACAO = v_observacao[count]
                                                    );
                    </cfscript>
                    </cfif>
                
                    <cfif ret.erro>
                       <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('S.D. concluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>   
    
    <!--- 
	-- PROPSITO
	-- Insere uma avaliao de SD
	-- jonas 25/04/2009 14:52:32 - CRIADO
	--->
	<cffunction name='ins_sd_avaliacao' displayname='Insere uma avaliao de SD' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='RESPONSAVEL_NOTA' required='yes'>
		<cfargument name='RESPONSAVEL_OBSERVACAO' required='no'>
		<cftry>
			<!---<cftransaction action='begin'>--->
				<cfstoredproc procedure='kmm.pkg_producao.prc_ins_sd_avaliacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RESPONSAVEL_NOTA'  value='#arguments.RESPONSAVEL_NOTA#'  null='#iif(len(trim(arguments.RESPONSAVEL_NOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESPONSAVEL_OBSERVACAO'  value='#arguments.RESPONSAVEL_OBSERVACAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Avaliao feita com sucesso!')>
			<!---</cftransaction>--->
			<cfcatch>
			<!---	<cftransaction action='rollback'/>--->
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
-- PROPSITO
-- Inserir Avaliacao do Cliente
-- rafael 13/05/2009 17:07:37 - CRIADO
--->
<cffunction name='ins_sd_avaliacao_cliente' displayname='Inserir Avaliacao do Cliente' access='remote' returntype='Struct' output='true'>
	<cfargument name='SD_ID' required='yes'>
	<cfargument name='ITEM_ID' required='yes'>
	<cfargument name='CLIENTE_NOTA' required='yes'>
	<cfargument name='CLIENTE_OBSERVACAO' required='yes'>
	<cftry>
		<!---<cftransaction action='begin'>--->
			<cfstoredproc procedure='kmm.pkg_producao.prc_ins_sd_avaliacao_cliente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CLIENTE_NOTA'  value='#arguments.CLIENTE_NOTA#'  null='#iif(len(trim(arguments.CLIENTE_NOTA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CLIENTE_OBSERVACAO'  value='#arguments.CLIENTE_OBSERVACAO#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Avaliao do inserida com sucesso')>
		<!---</cftransaction>--->
		<cfcatch>
			<!---<cftransaction action='rollback'/>--->
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera avaliao de SD do cliente
	-- jonas 25/04/2009 14:53:32 - CRIADO
	--->
	<cffunction name='upd_sd_avaliacao' displayname='Insere uma avaliao do cliente' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='CLIENTE_NOTA' required='yes'>
		<cfargument name='CLIENTE_OBSERVACAO' required='yes'>
		<cftry>
			<!---<cftransaction action='begin'>--->
				<cfstoredproc procedure='kmm.pkg_producao.prc_alt_sd_avaliacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CLIENTE_NOTA'  value='#arguments.CLIENTE_NOTA#'  null='#iif(len(trim(arguments.CLIENTE_NOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CLIENTE_OBSERVACAO'  value='#arguments.CLIENTE_OBSERVACAO#' >
				</cfstoredproc>
                
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Avaliao feita com sucesso!')>
			<!---</cftransaction>--->
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!--- 
	-- PROPSITO
	-- Altera previsao
	-- guto 25/04/2009 14:53:32 - CRIADO
	--->
	<cffunction name='upd_sd_status' displayname='Insere uma avaliao do cliente' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='STATUS_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='kmm.pkg_producao.prc_alt_sd_status' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#'  null='#iif(len(trim(arguments.STATUS_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Status alterado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!--- 
	-- PROPSITO
	-- Altera previsao
	-- guto 25/04/2009 14:53:32 - CRIADO
	--->
	<cffunction name='upd_sd_data_previsao' displayname='Insere uma avaliao do cliente' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='DATA_PREVISAO_ENTREGA' required='yes'>
		<cftry>
				<cfstoredproc procedure='kmm.pkg_producao.prc_sd_data_previsao_entrega' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='cf_sql_varchar' dbvarname='P_DATA_PREVISAO_ENTREGA'  value='#arguments.DATA_PREVISAO_ENTREGA#'  >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Data alterada com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera previsao
	-- guto 25/04/2009 14:53:32 - CRIADO
	--->
	<cffunction name='upd_sd_data_entrega_cliente' displayname='Insere uma avaliao do cliente' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='DATA_ENTREGA_CLIENTE' required='yes'>
		<cfargument name='DATA_ENTREGA_NIVEL' required='yes'>
		<cftry>
				<cfstoredproc procedure='kmm.pkg_producao.prc_alt_sd_data_entrega' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='cf_sql_varchar' dbvarname='P_DATA_ENTREGA_CLIENTE'  value='#arguments.DATA_ENTREGA_CLIENTE#'  >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_DATA_ENTREGA_NIVEL'  value='#arguments.DATA_ENTREGA_NIVEL#'  >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Data alterada com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere autorizao de hora extra
	-- jonas 04/05/2009 16:27:44 - CRIADO
	--->
	<cffunction name='ins_recurso_hora_extra' displayname='Insere autorizao de hora extra' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='COD_CARGO' required='yes'>
		<cfargument name='DESCRICAO_ATIVIDADES' required='yes'>
		<cfargument name='JUSTIFICATIVA' required='yes'>
		<cfargument name='AUTORIZADO_EM' required='yes'>
		<cfargument name='AUTORIZADO_POR' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_producao.prc_ins_recurso_hora_extra' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_AUTORIZACAO_ID' variable='retorno.AUTORIZACAO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CARGO'  value='#arguments.COD_CARGO#'  null='#iif(len(trim(arguments.COD_CARGO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_ATIVIDADES'  value='#arguments.DESCRICAO_ATIVIDADES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_JUSTIFICATIVA'  value='#arguments.JUSTIFICATIVA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_AUTORIZADO_EM'  value='#arguments.AUTORIZADO_EM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_AUTORIZADO_POR'  value='#arguments.AUTORIZADO_POR#'  null='#iif(len(trim(arguments.AUTORIZADO_POR)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
                
                <!--- Insere os items --->
                <cfscript>
					v_data         = this.ListaToArray(lista = arguments, variavel = 'ITEM_DATA_ITEM');
					v_hora_inicio  = this.ListaToArray(lista = arguments, variavel = 'ITEM_HORA_INICIO_ITEM');
					v_hora_termino = this.ListaToArray(lista = arguments, variavel = 'ITEM_HORA_TERMINO_ITEM');
					v_numero_horas =this.ListaToArray(lista = arguments, variavel = 'ITEM_NUMERO_HORAS_ITEM');
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_data)#" index="count">
					<cfscript>
						ret = this.ins_recurso_hora_extra_it( AUTORIZACAO_ID = retorno.AUTORIZACAO_ID
														     ,DATA           = v_data[count]
															 ,HORA_INICIO    = v_hora_inicio[count] 
															 ,HORA_TERMINO   = v_hora_termino[count]
															 ,NUMERO_HORAS   = v_numero_horas[count]
															 );
					</cfscript>
                    <cfif ret.erro>
                      <cfthrow object="#ret.mensagem#"/>
                    </cfif>
                </cfloop>				
                <!--- Fim --->
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Autorizao inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera autorizao de hora extra
	-- jonas 04/05/2009 16:29:13 - CRIADO
	--->
	<cffunction name='upd_recurso_hora_extra' displayname='Altera autorizao de hora extra' access='remote' returntype='Struct' output='true'>
		<cfargument name='AUTORIZACAO_ID' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='COD_CARGO' required='yes'>
		<cfargument name='DESCRICAO_ATIVIDADES' required='yes'>
		<cfargument name='JUSTIFICATIVA' required='yes'>
		<cfargument name='AUTORIZADO_EM' required='yes'>
		<cfargument name='AUTORIZADO_POR' required='yes'>
        <cfdump var="#arguments#">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_producao.prc_alt_recurso_hora_extra' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_AUTORIZACAO_ID'  value='#arguments.AUTORIZACAO_ID#'  null='#iif(len(trim(arguments.AUTORIZACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CARGO'  value='#arguments.COD_CARGO#'  null='#iif(len(trim(arguments.COD_CARGO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_ATIVIDADES'  value='#arguments.DESCRICAO_ATIVIDADES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_JUSTIFICATIVA'  value='#arguments.JUSTIFICATIVA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_AUTORIZADO_EM'  value='#arguments.AUTORIZADO_EM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_AUTORIZADO_POR'  value='#arguments.AUTORIZADO_POR#'  null='#iif(len(trim(arguments.AUTORIZADO_POR)), de('no'), de('yes'))#'>
				</cfstoredproc>
                
                <!--- Altera os items  --->
                
                <cfscript>				
					v_item_id      = this.ListaToArray(lista = arguments, variavel = 'ITEM_ID_ITEM');
					v_data         = this.ListaToArray(lista = arguments, variavel = 'ITEM_DATA_ITEM');
					v_hora_inicio  = this.ListaToArray(lista = arguments, variavel = 'ITEM_HORA_INICIO_ITEM');
					v_hora_termino = this.ListaToArray(lista = arguments, variavel = 'ITEM_HORA_TERMINO_ITEM');
					v_numero_horas =this.ListaToArray(lista = arguments, variavel = 'ITEM_NUMERO_HORAS_ITEM');
					
					v_excluir     = this.ListDiff(lista1 = arguments.lista_deleted_ITEM, lista2 = ArrayToList(v_item_id));
				</cfscript>
				 <!---Excluir os itens---> 
				<cfloop list="#v_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_recurso_hora_extra_it(item_id  = l_item_id);	
					</cfscript>
				</cfloop>
                
				<cfloop from="1" to="#ArrayLen(v_data)#" index="count">
					<cfscript>
						if(Not Len(Trim(v_item_id[count]))) {
							ret = this.ins_recurso_hora_extra_it( AUTORIZACAO_ID = arguments.AUTORIZACAO_ID
																 ,DATA           = v_data[count]
																 ,HORA_INICIO    = v_hora_inicio[count] 
																 ,HORA_TERMINO   = v_hora_termino[count]
																 ,NUMERO_HORAS   = v_numero_horas[count]
																 );
						}
						else {
							ret = this.upd_recurso_hora_extra_it( ITEM_ID        = v_item_id[count]
																 ,AUTORIZACAO_ID = arguments.AUTORIZACAO_ID
																 ,DATA           = v_data[count]
																 ,HORA_INICIO    = v_hora_inicio[count] 
																 ,HORA_TERMINO   = v_hora_termino[count]
																 ,NUMERO_HORAS   = v_numero_horas[count]
																 );
						}
					</cfscript>
                    <cfif ret.erro>
                       <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
               <!---  Fim --->
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Autorizao alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui uma autorizao de hora extra.
	-- jonas 04/05/2009 17:46:53 - CRIADO
	--->
	<cffunction name='del_recurso_hora_extra' displayname='Exclui uma autorizao hora extra.' access='remote' returntype='Struct' output='true'>
		<cfargument name='AUTORIZACAO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='kmm.pkg_producao.prc_del_recurso_hora_extra' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_AUTORIZACAO_ID'  value='#arguments.AUTORIZACAO_ID#'  null='#iif(len(trim(arguments.AUTORIZACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Autorizao de hora extra excluida com sucesso!')>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere um item de hora extra.
	-- jonas 04/05/2009 17:41:27 - CRIADO
	--->
	<cffunction name='ins_recurso_hora_extra_it' displayname='Insere um item de hora extra.' access='remote' returntype='Struct' output='true'>
		<cfargument name='AUTORIZACAO_ID' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='HORA_INICIO' required='yes'>
		<cfargument name='HORA_TERMINO' required='yes'>
		<cfargument name='NUMERO_HORAS' required='yes'>
		<cftry>
				<cfstoredproc procedure='kmm.pkg_producao.prc_ins_recurso_hora_extra_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID' variable='retorno.ITEM_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_AUTORIZACAO_ID'  value='#arguments.AUTORIZACAO_ID#'  null='#iif(len(trim(arguments.AUTORIZACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_HORA_INICIO'  value='#arguments.HORA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_HORA_TERMINO'  value='#arguments.HORA_TERMINO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUMERO_HORAS'  value='#arguments.NUMERO_HORAS#'  null='#iif(len(trim(arguments.NUMERO_HORAS)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Item inserido com sucesso!')>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera um item de hora extra.
	-- jonas 04/05/2009 17:42:43 - CRIADO
	--->
	<cffunction name='upd_recurso_hora_extra_it' displayname='Altera um item de hora extra.' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='AUTORIZACAO_ID' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='HORA_INICIO' required='yes'>
		<cfargument name='HORA_TERMINO' required='yes'>
		<cfargument name='NUMERO_HORAS' required='yes'>
		<cftry>
				<cfstoredproc procedure='kmm.pkg_producao.prc_alt_recurso_hora_extra_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_AUTORIZACAO_ID'  value='#arguments.AUTORIZACAO_ID#'  null='#iif(len(trim(arguments.AUTORIZACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_HORA_INICIO'  value='#arguments.HORA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_HORA_TERMINO'  value='#arguments.HORA_TERMINO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUMERO_HORAS'  value='#arguments.NUMERO_HORAS#'  null='#iif(len(trim(arguments.NUMERO_HORAS)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Item alterado com sucesso!')>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui um item de hora extra.
	-- jonas 04/05/2009 17:46:53 - CRIADO
	--->
	<cffunction name='del_recurso_hora_extra_it' displayname='Exclui um item de hora extra.' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITEM_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='kmm.pkg_producao.prc_del_recurso_hora_extra_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Item excluido com sucesso!')>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Altera tarefa de SD
	-- GUTO 25/04/2009 14:53:32 - CRIADO
	--->
	<cffunction name='altera_tarefa_sd' displayname='Altera uma tarefa de SD' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='SD_DETALHAMENTO_ID' required='yes'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_altera_sd_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_DETALHAMENTO_ID'  value='#arguments.SD_DETALHAMENTO_ID#'  null='#iif(len(trim(arguments.SD_DETALHAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tarefa alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>    

	<!--- 
	-- PROPSITO
	-- Altera tarefa de SD
	-- GUTO 25/04/2009 14:53:32 - CRIADO
	--->
	<cffunction name='ins_tarefa_levantamento' displayname='Altera uma tarefa de SD' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_ins_tarefa_levantamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tarefa de levantamento inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>        
    
	<!--- 
	-- PROPSITO
	-- Altera tarefa de SD
	-- GUTO 25/04/2009 14:53:32 - CRIADO
	--->
	<cffunction name='ins_tarefa_levantamento_detalhado' displayname='Altera uma tarefa de SD' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='contato' required='yes'>
		<cfargument name='tipo_aplicacao_id' required='yes'>
		<cfargument name='urgencia_id' required='yes'>
		<cfargument name='entregar_em' required='yes'>
		<cfargument name='horas_estimado' required='yes'>
		<cfargument name='minutos_estimado' required='yes'>
		<cfargument name='recurso_id' required='yes'>
		<cfargument name='recurso_id_teste' required='yes'>
		<cfargument name='complemento' required='yes'>
		<cfargument name='atribuir' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_tarefa.prc_ins_tarefa_levantamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTATO'  value='#arguments.CONTATO#'  null='#iif(len(trim(arguments.CONTATO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_APLICACAO_ID'  value='#arguments.TIPO_APLICACAO_ID#'  null='#iif(len(trim(arguments.TIPO_APLICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_URGENCIA_ID'  value='#arguments.URGENCIA_ID#'  null='#iif(len(trim(arguments.URGENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGAR_EM'  value='#arguments.ENTREGAR_EM#'  null='#iif(len(trim(arguments.ENTREGAR_EM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_HORAS_ESTIMADO'  value='#arguments.HORAS_ESTIMADO#'  null='#iif(len(trim(arguments.HORAS_ESTIMADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MINUTOS_ESTIMADO'  value='#arguments.MINUTOS_ESTIMADO#'  null='#iif(len(trim(arguments.MINUTOS_ESTIMADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECURSO_ID_TESTE'  value='#arguments.RECURSO_ID_TESTE#'  null='#iif(len(trim(arguments.RECURSO_ID_TESTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_COMPLEMENTO'  value='#replace(arguments.COMPLEMENTO,chr(13),'<br>','all')#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_TAREFA_ID'  variable='retorno.tarefa_id'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_TAREFA_ID_TESTE'  variable='retorno.tarefa_id_teste'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_ATRIBUIR'  value='#arguments.atribuir#' null='#iif(len(trim(arguments.ATRIBUIR)), de('no'), de('yes'))#'>
				</cfstoredproc>                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tarefa #retorno.tarefa_id# de levantamento inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>        

	<!--- 
	-- PROPSITO
	-- Insere um comentrio para uma SD
	-- ANDERSONC 10/08/2009 09:51:19 - CRIADO
	--->
	<cffunction name='ins_sd_comentario' displayname='Insere um comentrio para uma SD' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_producao.prc_ins_sd_comentario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Comentrio inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


	<!--- 
    -- PROPSITO
    -- Altera DATA INICIO do item do cronograma
    -- GUTO 17/08/2009 13:59:37 - CRIADO
    --->
    <cffunction name='upd_data_inicio_cronograma_item' displayname='Altera DATA INICIO do item do cronograma' access='remote' returntype='Struct' output='true'>
        <cfargument name='PROJETO_ID' required='yes'>
        <cfargument name='ITEM_ID' required='yes'>S
        <cfargument name='DATA_INICIO' required='yes'>
        <cfargument name='OBSERVACOES' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kmm.pkg_projeto.prc_alt_data_inicio_cron_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACOES#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Data alterada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction> 

	<!--- 
    -- PROPSITO
    -- Altera DATA FIM do item do cronograma
    -- GUTO 17/08/2009 13:59:37 - CRIADO
    --->
    <cffunction name='upd_data_fim_cronograma_item' displayname='Altera DATA FIM do item do cronograma' access='remote' returntype='Struct' output='true'>
        <cfargument name='PROJETO_ID' required='yes'>
        <cfargument name='ITEM_ID' required='yes'>S
        <cfargument name='DATA_FIM' required='yes'>
        <cfargument name='OBSERVACOES' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kmm.pkg_projeto.prc_alt_data_inicio_cron_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FIM'  value='#arguments.DATA_FIM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACOES#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Data alterada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>     
    
	<!--- 
    -- PROPSITO
    -- Altera status do item do cronograma
    -- GUTO 17/08/2009 13:59:37 - CRIADO
    --->
    <cffunction name='upd_status_cronograma_item' displayname='Altera status do item do cronograma' access='remote' returntype='Struct' output='true'>
        <cfargument name='PROJETO_ID' required='yes'>
        <cfargument name='ITEM_ID' required='yes'>
        <cfargument name='STATUS' required='yes'>
        <cfargument name='OBSERVACOES' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kmm.pkg_projeto.prc_alt_status_cron_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_STATUS'  value='#arguments.STATUS#'  null='#iif(len(trim(arguments.STATUS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACOES#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Status alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Insere analise na SD
    -- GUTO 20/08/2009 10:12:25 - CRIADO
    --->
    <cffunction name='ins_sd_analise' displayname='Insere analise na SD' access='remote' returntype='Struct' output='true'>
        <cfargument name='SD_ID' required='yes'>
        <cfargument name='TITULO' required='yes'>
        <cfargument name='TIPO_APLICACAO_ID' required='yes'>
        <cfargument name='CONTATO_ID' required='yes'>
        <cfargument name='ANALISE' required='yes'>
        <cfargument name='TIPO_ID' required='yes'>
        <cfargument name='URGENCIA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kmm.pkg_producao.prc_ins_sd_analise' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_APLICACAO_ID'  value='#arguments.TIPO_APLICACAO_ID#'  null='#iif(len(trim(arguments.TIPO_APLICACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTATO_ID'  value='#arguments.CONTATO_ID#'  null='#iif(len(trim(arguments.CONTATO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_ANALISE'  value='#arguments.ANALISE#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANALISE_ID' variable='retorno.ANALISE_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_URGENCIA_ID'  value='#arguments.URGENCIA_ID#'  null='#iif(len(trim(arguments.URGENCIA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                
                <cfloop list="#arguments.SD_DETALHAMENTO_ID#" index="sd_det_id">
                	<cfscript>
						set_detalhamento = this.ins_sd_analise_detalhamento(analise_id = retorno.ANALISE_ID,
																			sd_detalhamento_id = sd_det_id); 
					</cfscript>
                    <cfif set_detalhamento.erro>
	                    <cfthrow object="#set_detalhamento.MENSAGEM#">
                    </cfif>
                </cfloop>
                
                <cfloop list="#arguments.etapa_id#" index="v_etapa_id"> 
					<cfscript> 
						set_etapa = this.ins_analise_etapa(analise_id = retorno.analise_id, 
											  etapa_id  = v_etapa_id, 
											  dias = arguments['dias_estimado_etapa_'&v_etapa_id], 
											  hora = arguments['horas_estimado_etapa_'&v_etapa_id], 
											  minuto = arguments['minutos_estimado_etapa_'&v_etapa_id]
						); 
                    </cfscript> 
                    <cfif set_etapa.erro>
	                    <cfthrow object="#set_etapa.MENSAGEM#">
                    </cfif>
                </cfloop>  

				<cfscript> 
                    v_habilidade_id = this.ListaToArray (lista = arguments, variavel = "HABILIDADE_ID"); 
                    v_habilidade_nivel_id = this.ListaToArray (lista = arguments, variavel = "HABILIDADE_NIVEL_ID"); 
                    v_habilidade_etapa_id = this.ListaToArray (lista = arguments, variavel = "HABILIDADE_ETAPA_ID"); 
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_habilidade_id)#" index="count">
                  <cfscript> 
  				    ret.erro = false;
                    if(len(trim(v_habilidade_nivel_id[count])) and listfind(arguments.etapa_id,v_habilidade_etapa_id[count])) {
                        ret = this.ins_analise_habilidade(analise_id = retorno.analise_id
                                                        ,habilidade_id = v_habilidade_id[count]
                                                        ,nivel_id = v_habilidade_nivel_id[count]);
                    }
                  </cfscript>
                  <cfif ret.erro>
	                    <cfthrow object="#set_habilidade.MENSAGEM#">
                    </cfif>
                </cfloop>           
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Anlise inserida com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Altera analise na SD
    -- GUTO 20/08/2009 10:13:26 - CRIADO
    --->
    <cffunction name='upd_sd_analise' displayname='Altera analise na SD' access='remote' returntype='Struct' output='true'>
        <cfargument name='ANALISE_ID' required='yes'>
        <cfargument name='SD_ID' required='yes'>
        <cfargument name='TITULO' required='yes'>
        <cfargument name='TIPO_APLICACAO_ID' required='yes'>
        <cfargument name='CONTATO_ID' required='yes'>
        <cfargument name='ANALISE' required='yes'>
        <cfargument name='TIPO_ID' required='yes'>
        <cfargument name='URGENCIA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kmm.pkg_producao.prc_alt_sd_analise' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANALISE_ID'  value='#arguments.ANALISE_ID#'  null='#iif(len(trim(arguments.ANALISE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_APLICACAO_ID'  value='#arguments.TIPO_APLICACAO_ID#'  null='#iif(len(trim(arguments.TIPO_APLICACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTATO_ID'  value='#arguments.CONTATO_ID#'  null='#iif(len(trim(arguments.CONTATO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_ANALISE'  value='#arguments.ANALISE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_URGENCIA_ID'  value='#arguments.URGENCIA_ID#'  null='#iif(len(trim(arguments.URGENCIA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>

				<cfscript>
                    set_detalhamento = this.del_sd_analise_detalhamento(analise_id = arguments.ANALISE_ID); 
                </cfscript>
                
                <cfif set_detalhamento.erro>
                	<cfthrow object="#set_detalhamento.MENSAGEM#">
                </cfif>

                <cfloop list="#arguments.SD_DETALHAMENTO_ID#" index="sd_det_id">
                	<cfscript>
						set_detalhamento = this.ins_sd_analise_detalhamento(analise_id = arguments.ANALISE_ID,
																			sd_detalhamento_id = sd_det_id); 
					</cfscript>
                    <cfif set_detalhamento.erro>
	                    <cfthrow object="#set_detalhamento.MENSAGEM#">
                    </cfif>
                </cfloop>
				<cfscript>
                    conn = CreateObject("component", "_transportes.consulta.cfc_desenvolvimento"); 
                    qrEtapa = conn.get_sd_analise_etapa(analise_id = arguments.analise_id); 
                  </cfscript>
                  <cfoutput query="qrEtapa">
                    <cfif not listfind(arguments.etapa_id, qrEtapa.etapa_id)>
                      <cfscript> 
                            this.del_analise_etapa_dados(analise_id = arguments.analise_id, 
						                            etapa_id = qrEtapa.etapa_id); 
                      </cfscript>
                    </cfif>
                  </cfoutput>
                
                 <cfloop list="#arguments.etapa_id#" index="v_etapa_id"> 
					<cfscript> 
						set_etapa = this.ins_analise_etapa(analise_id = arguments.analise_id, 
											  etapa_id  = v_etapa_id, 
											  dias = arguments['dias_estimado_etapa_'&v_etapa_id], 
											  hora = arguments['horas_estimado_etapa_'&v_etapa_id], 
											  minuto = arguments['minutos_estimado_etapa_'&v_etapa_id]
						); 
                    </cfscript> 
                    <cfif set_etapa.erro>
	                    <cfthrow object="#set_etapa.MENSAGEM#">
                    </cfif>
                </cfloop>  

				<cfscript> 
                    v_habilidade_id = this.ListaToArray (lista = arguments, variavel = "HABILIDADE_ID"); 
                    v_habilidade_nivel_id = this.ListaToArray (lista = arguments, variavel = "HABILIDADE_NIVEL_ID"); 
                    v_habilidade_etapa_id = this.ListaToArray (lista = arguments, variavel = "HABILIDADE_ETAPA_ID"); 
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_habilidade_id)#" index="count">
                  <cfscript> 
				    if(len(trim(v_habilidade_nivel_id[count])) and listfind(arguments.etapa_id,v_habilidade_etapa_id[count])) {
                        ret = this.ins_analise_habilidade(analise_id = arguments.analise_id
                                                        ,habilidade_id = v_habilidade_id[count]
                                                        ,nivel_id = v_habilidade_nivel_id[count]);
					} else {
//						throw (message = arguments.analise_id&" - "&v_habilidade_id[count]);
						ret = this.del_analise_habilidade_dados(analise_id = arguments.analise_id
                                                         ,habilidade_id = v_habilidade_id[count]
														 );
                    }
                  </cfscript>
                  <cfif ret.erro>
	                    <cfthrow object="#ret.MENSAGEM#">
                    </cfif>
                </cfloop>       
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Anlise alterada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Exclui analise na SD
    -- GUTO 20/08/2009 10:14:15 - CRIADO
    --->
    <cffunction name='del_sd_analise' displayname='Exclui analise na SD' access='remote' returntype='Struct' output='true'>
        <cfargument name='ANALISE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kmm.pkg_producao.prc_del_sd_analise' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANALISE_ID'  value='#arguments.ANALISE_ID#'  null='#iif(len(trim(arguments.ANALISE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Anlise excluda com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Insere vinculo entre o detalhamento da SD e a analise
    -- GUTO 20/08/2009 10:15:37 - CRIADO
    --->
    <cffunction name='ins_sd_analise_detalhamento' displayname='Insere vinculo entre o detalhamento da SD e a analise' access='remote' returntype='Struct' output='true'>
        <cfargument name='ANALISE_ID' required='yes'>
        <cfargument name='SD_DETALHAMENTO_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='kmm.pkg_producao.prc_ins_analise_detalhamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANALISE_ID'  value='#arguments.ANALISE_ID#'  null='#iif(len(trim(arguments.ANALISE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_DETALHAMENTO_ID'  value='#arguments.SD_DETALHAMENTO_ID#'  null='#iif(len(trim(arguments.SD_DETALHAMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DETALHAMENTO_ID' variable='retorno.DETALHAMENTO_ID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Vinculo executado com sucesso!')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Altera vinculo entre o detalhamento da SD e a analise
    -- GUTO 20/08/2009 10:16:39 - CRIADO
    --->
    <cffunction name='upd_sd_analise_detalhamento' displayname='Altera vinculo entre o detalhamento da SD e a analise' access='remote' returntype='Struct' output='true'>
        <cfargument name='DETALHAMENTO_ID' required='yes'>
        <cfargument name='ANALISE_ID' required='yes'>
        <cfargument name='SD_DETALHAMENTO_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='kmm.pkg_producao.prc_alt_analise_detalhamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DETALHAMENTO_ID'  value='#arguments.DETALHAMENTO_ID#'  null='#iif(len(trim(arguments.DETALHAMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANALISE_ID'  value='#arguments.ANALISE_ID#'  null='#iif(len(trim(arguments.ANALISE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_DETALHAMENTO_ID'  value='#arguments.SD_DETALHAMENTO_ID#'  null='#iif(len(trim(arguments.SD_DETALHAMENTO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Vinculo alterado com sucesso!')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Exclui vinculo entre o detalhamento da SD e a analise
    -- GUTO 20/08/2009 10:18:27 - CRIADO
    --->
    <cffunction name='del_sd_analise_detalhamento' displayname='Exclui vinculo entre o detalhamento da SD e a analise' access='remote' returntype='Struct' output='true'>
        <cfargument name='ANALISE_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='kmm.pkg_producao.prc_del_analise_detalhamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANALISE_ID'  value='#arguments.ANALISE_ID#'  null='#iif(len(trim(arguments.ANALISE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Vnculo excludo com sucesso!')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Insere vinculo entre a analise e uma etapa do projeto
    -- GUTO 20/08/2009 10:19:26 - CRIADO
    --->
    <cffunction name='ins_analise_etapa' displayname='Insere vinculo entre a analise e uma etapa do projeto' access='remote' returntype='Struct' output='true'>
        <cfargument name='ANALISE_ID' required='yes'>
        <cfargument name='ETAPA_ID' required='yes'>
        <cfargument name='DIAS' required='no' default="0">
        <cfargument name='HORA' required='yes'>
        <cfargument name='MINUTO' required='yes'>
        <cftry>
            <cfstoredproc procedure='kmm.pkg_producao.prc_ins_analise_etapa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANALISE_ID'  value='#arguments.ANALISE_ID#'  null='#iif(len(trim(arguments.ANALISE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ETAPA_ID'  value='#arguments.ETAPA_ID#'  null='#iif(len(trim(arguments.ETAPA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_HORA' value='#arguments.HORA#'  null='#iif(len(trim(arguments.HORA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MINUTO'  value='#arguments.MINUTO#'  null='#iif(len(trim(arguments.MINUTO)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DIAS' value='#arguments.DIAS#'  null='#iif(len(trim(arguments.DIAS)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Vnculo inserido com sucesso!')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Altera vinculo entre a analise e uma etapa do projeto
    -- GUTO 20/08/2009 10:23:01 - CRIADO
    --->
    <cffunction name='upd_analise_etapa' displayname='Altera vinculo entre a analise e uma etapa do projeto' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='ANALISE_ID' required='yes'>
        <cfargument name='ETAPA_ID' required='yes'>
        <cfargument name='DIAS' required='no' default="0">
        <cfargument name='HORA' required='yes'>
        <cfargument name='MINUTO' required='yes'>
        <cftry>
            <cfstoredproc procedure='kmm.pkg_producao.prc_alt_analise_etapa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANALISE_ID'  value='#arguments.ANALISE_ID#'  null='#iif(len(trim(arguments.ANALISE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ETAPA_ID'  value='#arguments.ETAPA_ID#'  null='#iif(len(trim(arguments.ETAPA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_HORA' value='#arguments.HORA#'  null='#iif(len(trim(arguments.HORA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MINUTO'  value='#arguments.MINUTO#'  null='#iif(len(trim(arguments.MINUTO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DIAS' value='#arguments.DIAS#'  null='#iif(len(trim(arguments.DIAS)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Vnculo alterado com sucesso!')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Exclui vinculo entre a analise e uma etapa do projeto
    -- GUTO 20/08/2009 10:24:07 - CRIADO
    --->
    <cffunction name='del_analise_etapa' displayname='Exclui vinculo entre a analise e uma etapa do projeto' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='kmm.pkg_producao.prc_del_analise_etapa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Vnculo excludo com sucesso!')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Exclui vinculo entre a analise e uma etapa do projeto
    -- GUTO 20/08/2009 10:24:07 - CRIADO
    --->
    <cffunction name='del_analise_etapa_dados' displayname='Exclui vinculo entre a analise e uma etapa do projeto' access='remote' returntype='Struct' output='true'>
        <cfargument name='ANALISE_ID' required='yes'>
        <cfargument name='ETAPA_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='kmm.pkg_producao.prc_del_analise_etapa_dados' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANALISE_ID'  value='#arguments.ANALISE_ID#'  null='#iif(len(trim(arguments.ANALISE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ETAPA_ID'  value='#arguments.ETAPA_ID#'  null='#iif(len(trim(arguments.ETAPA_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>	
            <cfset retorno.mensagem = JSStringFormat('Vnculo excludo com sucesso!')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
	<!--- 
    -- PROPSITO
    -- Insere vinculo entre a analise e habilidade
    -- GUTO 20/08/2009 10:25:21 - CRIADO
    --->
    <cffunction name='ins_analise_habilidade' displayname='Insere vinculo entre a analise e habilidade' access='remote' returntype='Struct' output='true'>
        <cfargument name='ANALISE_ID' required='yes'>
        <cfargument name='HABILIDADE_ID' required='yes'>
        <cfargument name='NIVEL_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='kmm.pkg_producao.prc_ins_analise_habilidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANALISE_ID'  value='#arguments.ANALISE_ID#'  null='#iif(len(trim(arguments.ANALISE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_HABILIDADE_ID'  value='#arguments.HABILIDADE_ID#'  null='#iif(len(trim(arguments.HABILIDADE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NIVEL_ID'  value='#arguments.NIVEL_ID#'  null='#iif(len(trim(arguments.NIVEL_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Vnculo inserido com sucesso!')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Altera vinculo entre a analise e habilidade
    -- GUTO 20/08/2009 10:25:59 - CRIADO
    --->
    <cffunction name='upd_analise_habilidade' displayname='Altera vinculo entre a analise e habilidade' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='ANALISE_ID' required='yes'>
        <cfargument name='HABILIDADE_ID' required='yes'>
        <cfargument name='NIVEL_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='kmm.pkg_producao.prc_alt_analise_habilidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANALISE_ID'  value='#arguments.ANALISE_ID#'  null='#iif(len(trim(arguments.ANALISE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_HABILIDADE_ID'  value='#arguments.HABILIDADE_ID#'  null='#iif(len(trim(arguments.HABILIDADE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NIVEL_ID'  value='#arguments.NIVEL_ID#'  null='#iif(len(trim(arguments.NIVEL_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Vnculo alterado com sucesso!')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
    <!--- 
    -- PROPSITO
    -- Excluir vinculo entre a analise e habilidade
    -- GUTO 20/08/2009 10:26:41 - CRIADO
    --->
    <cffunction name='del_analise_habilidade' displayname='Excluir vinculo entre a analise e habilidade' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='kmm.pkg_producao.prc_del_analise_habilidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vnculo excludo com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>


    <!--- 
    -- PROPSITO
    -- Excluir vinculo entre a analise e habilidade
    -- GUTO 20/08/2009 10:26:41 - CRIADO
    --->
    <cffunction name='del_analise_habilidade_dados' displayname='Excluir vinculo entre a analise e habilidade' access='remote' returntype='Struct' output='true'>
        <cfargument name='ANALISE_ID' required='yes'>
        <cfargument name='HABILIDADE_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='kmm.pkg_producao.prc_del_analise_habilidade_d' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANALISE_ID'  value='#arguments.ANALISE_ID#'  null='#iif(len(trim(arguments.ANALISE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_HABILIDADE_ID'  value='#arguments.HABILIDADE_ID#'  null='#iif(len(trim(arguments.HABILIDADE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vnculo excludo com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
    <!--- 
    -- PROPSITO
    -- Altera a situao de limite para a SD
    -- GUTO 20/08/2009 10:26:41 - CRIADO
    --->
    <cffunction name='upd_sd_data_entrega_situacao' displayname='Excluir vinculo entre a analise e habilidade' access='remote' returntype='Struct' output='true'>
        <cfargument name='SD_ID' required='yes'>
        <cfargument name='DATA_ENTREGA_SITUACAO_ID' required='yes'>
        <cfargument name='COMENTARIO' required='no' default="">
        <cfargument name='REMOVER_ATRIBUICOES' required='no' default="0">
        <cftry>
                <cfstoredproc procedure='kmm.pkg_producao.prc_alt_sd_data_entrega_sit' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DATA_ENTREGA_SITUACAO_ID'  value='#arguments.DATA_ENTREGA_SITUACAO_ID#'  null='#iif(len(trim(arguments.DATA_ENTREGA_SITUACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' scale='5' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#'  null='#iif(len(trim(arguments.COMENTARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REMOVER_ATRIBUICOES'  value='#arguments.REMOVER_ATRIBUICOES#'  null='#iif(len(trim(arguments.REMOVER_ATRIBUICOES)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfswitch expression="#arguments.DATA_ENTREGA_SITUACAO_ID#">
                	<cfcase value="1">
		                <cfset retorno.mensagem = JSStringFormat('Limite da SD colocado como aguardando com sucesso!')>
                    </cfcase>
                	<cfcase value="2">
		                <cfset retorno.mensagem = JSStringFormat('Limite da SD aprovado com sucesso!')>
                    </cfcase>
                    <cfcase value="3">
		                <cfset retorno.mensagem = JSStringFormat('Limite da SD reprovado com sucesso!')>
                    </cfcase>
                    <cfdefaultcase>
		                <cfset retorno.mensagem = JSStringFormat('Situao de Limite da SD alterado com sucesso!')>
                    </cfdefaultcase>
                </cfswitch>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

    <!--- 
    -- PROPSITO
    -- Insere uma ocorrencia para a SD
    -- CRISTOFER 16/02/2010 10:26:41 - CRIADO
    --->
    <cffunction name='ins_sd_ocorrencia' displayname='Excluir vinculo entre a analise e habilidade' access='remote' returntype='Struct' output='true'>
        <cfargument name='SD_ID' required='yes'>
        <cfargument name='OCORRENCIA_TIPO_ID' required='yes'>
        <cfargument name='COMENTARIO' required='yes'>
        <cfargument name='EMAIL_ENVIAR' required='no' default="0">
        <cfargument name='EMAIL_TITULO' required='no' default="">
        <cfargument name='COMPLEMENTO' required='no' default="">
        <cftry>
                <cfstoredproc procedure='kmm.pkg_producao.prc_ins_sd_ocorrencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_OCORRENCIA_TIPO_ID'  value='#arguments.OCORRENCIA_TIPO_ID#'  null='#iif(len(trim(arguments.OCORRENCIA_TIPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' scale='5' dbvarname='P_OCORRENCIA'  value='#arguments.COMENTARIO#'  null='#iif(len(trim(arguments.COMENTARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_EMAIL_ENVIAR'  value='#arguments.EMAIL_ENVIAR#'  null='#iif(len(trim(arguments.EMAIL_ENVIAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL_TITULO'  value='#arguments.EMAIL_TITULO#'  null='#iif(len(trim(arguments.EMAIL_TITULO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#'  null='#iif(len(trim(arguments.COMPLEMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COMENTARIO'  variable='retorno.ocorrencia_id' >
                </cfstoredproc>
                <cfset retorno.erro = false>
	            <cfset retorno.mensagem = JSStringFormat('Ocorrencia inserida com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>   

    <!--- 
    -- PROPSITO
    -- Insere uma ocorrencia para a SD
    -- CRISTOFER 16/02/2010 10:26:41 - CRIADO
    --->
    <cffunction name='sd_tecnico_aprovacao' displayname='Excluir vinculo entre a analise e habilidade' access='remote' returntype='Struct' output='true'>
        <cfargument name='SD_ID' required='yes'>
        <cfargument name='TECNICO_APROVACAO' required='yes'>
        <cftry>
                <cfstoredproc procedure='kmm.pkg_producao.prc_sd_tecnico_aprovacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TECNICO_APROVACAO'  value='#arguments.TECNICO_APROVACAO#'  null='#iif(len(trim(arguments.TECNICO_APROVACAO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
	            <cfset retorno.mensagem = JSStringFormat('Tcnico inserido com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
				<cfset retorno.mensagem_str = cfcatch.Detail>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Insere etapa na SD
    -- GUTO 22/03/2010 11:48:34 - CRIADO
    --->
    <cffunction name='ins_sd_etapa_hora' displayname='Insere etapa na SD' access='remote' returntype='Struct' output='true'>
        <cfargument name='SD_ID' required='yes'>
        <cfargument name='ETAPA_ID' required='yes'>
        <cfargument name='HORA' required='yes'>
        <cfargument name='MINUTO' required='yes'>
        <cfargument name='CONFIRMADO' required='yes'>
        <cftry>
                <cfstoredproc procedure='kmm.pkg_producao.prc_ins_sd_etapa_hora' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ETAPA_ID'  value='#arguments.ETAPA_ID#'  null='#iif(len(trim(arguments.ETAPA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_HORA'  value='#arguments.HORA#'  null='#iif(len(trim(arguments.HORA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MINUTO'  value='#arguments.MINUTO#'  null='#iif(len(trim(arguments.MINUTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONFIRMADO'  value='#arguments.CONFIRMADO#'  null='#iif(len(trim(arguments.CONFIRMADO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Etapa inserida com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Alterada etapa na SD
    -- GUTO 22/03/2010 11:49:50 - CRIADO
    --->
    <cffunction name='upd_sd_etapa_hora' displayname='Alterada etapa na SD' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='SD_ID' required='yes'>
        <cfargument name='ETAPA_ID' required='yes'>
        <cfargument name='HORA' required='yes'>
        <cfargument name='MINUTO' required='yes'>
        <cfargument name='CONFIRMADO' required='yes'>
        <cftry>
                <cfstoredproc procedure='kmm.pkg_producao.prc_alt_sd_etapa_hora' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ETAPA_ID'  value='#arguments.ETAPA_ID#'  null='#iif(len(trim(arguments.ETAPA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_HORA'  value='#arguments.HORA#'  null='#iif(len(trim(arguments.HORA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MINUTO'  value='#arguments.MINUTO#'  null='#iif(len(trim(arguments.MINUTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONFIRMADO'  value='#arguments.CONFIRMADO#'  null='#iif(len(trim(arguments.CONFIRMADO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Etapa alterada com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>   
    
	<!--- 
    -- PROPSITO
    -- Exclui etapa na SD
    -- GUTO 22/03/2010 11:49:50 - CRIADO
    --->
    <cffunction name='del_sd_etapa_hora' displayname='Alterada etapa na SD' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='kmm.pkg_producao.prc_del_sd_etapa_hora' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Etapa excluida com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>     

    <!--- 
    -- PROPSITO
    -- Insere uma ocorrencia para a SD
    -- CRISTOFER 16/02/2010 10:26:41 - CRIADO
    --->
    <cffunction name='sd_lider_tecnico' displayname='Excluir vinculo entre a analise e habilidade' access='remote' returntype='Struct' output='true'>
        <cfargument name='SD_ID' required='yes'>
        <cfargument name='LIDER_TECNICO' required='yes'>
        <cftry>
                <cfstoredproc procedure='kmm.pkg_producao.prc_sd_lider_tecnico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_LIDER_TECNICO'  value='#arguments.LIDER_TECNICO#'  null='#iif(len(trim(arguments.LIDER_TECNICO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
	            <cfset retorno.mensagem = JSStringFormat('Lider tcnico alterado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
				<cfset retorno.mensagem_str = cfcatch.Detail>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>   
    
    <!--- 
    -- PROPSITO
    -- Insere uma ocorrencia para a SD
    -- CRISTOFER 16/02/2010 10:26:41 - CRIADO
    --->
    <cffunction name='sd_gerente_projeto' displayname='Excluir vinculo entre a analise e habilidade' access='remote' returntype='Struct' output='true'>
        <cfargument name='SD_ID' required='yes'>
        <cfargument name='GERENTE_PROJETO' required='yes'>
        <cftry>
                <cfstoredproc procedure='kmm.pkg_producao.prc_sd_gerente_projeto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GERENTE_PROJETO'  value='#arguments.GERENTE_PROJETO#'  null='#iif(len(trim(arguments.GERENTE_PROJETO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
	            <cfset retorno.mensagem = JSStringFormat('Gerente de Projeto alterado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
				<cfset retorno.mensagem_str = cfcatch.Detail>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>   
    
    <!--- 
    -- PROPSITO
    -- Insere uma ocorrencia para a SD
    -- CRISTOFER 16/02/2010 10:26:41 - CRIADO
    --->
    <cffunction name='sd_codigo' displayname='Excluir vinculo entre a analise e habilidade' access='remote' returntype='Struct' output='true'>
        <cfargument name='SD_ID' required='yes'>
        <cfargument name='CODIGO' required='yes'>
        <cftry>
                <cfstoredproc procedure='kmm.pkg_producao.prc_sd_codigo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO'  value='#arguments.CODIGO#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
	            <cfset retorno.mensagem = JSStringFormat('Cdigo da SD alterado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
				<cfset retorno.mensagem_str = cfcatch.Detail>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Cria as tarefas a partir das analises e atribui as etapas
    -- CRISTOFER 30/04/2010 10:26:41 - CRIADO
    --->
    <cffunction name='criar_tarefas_analise' displayname='Cria as tarefas a partir das analises' access='remote' returntype='Struct' output='true'>
        <cfargument name='ANALISE_ID' required='no' default="">
        <cfargument name='ETAPA_ID' required='no' default="">
        <cfargument name='ENTREGAR_EM' required='yes'>
        <cfargument name='ATRIBUIR' required='no' default="0">
        <cftry>
            <cftransaction action='begin'>
            	<cfset v_tarefas = "">
                <cfloop list="#arguments.analise_id#" delimiters="," index="v_analise_id">
                    <cfscript>
						ret = this.criar_tarefa_analise(analise_id = v_analise_id
													   ,entregar_em = arguments.entregar_em);
					</cfscript>
                    <cfif ret.erro>
                    	<cfthrow object="#ret.mensagem#">
                    </cfif>
                    <cfset v_tarefas = ListAppend(v_tarefas,ret.tarefa_id,',')>
                    <cfloop list="#arguments.etapa_id#" delimiters="," index="v_etapa_id">
                        <cfscript>
                            ret2 = this.upd_tarefa_etapa_atribuicao(tarefa_id = ret.tarefa_id
 		                                                           ,etapa_id = v_etapa_id
																   ,recurso_id = arguments['ETAPA_RECURSO_ID_#v_etapa_id#']
																   ,data_limite = arguments['DATA_LIMITE_#v_etapa_id#']);
                        </cfscript>
                        <cfif ret2.erro>
                            <cfthrow object="#ret2.mensagem#">
                        </cfif>
                    </cfloop>
					<cfif arguments.ATRIBUIR eq 1>                
                        <cfstoredproc procedure='kmm.pkg_tarefa.prc_atribui_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TAREFA_ID'  value='#ret.tarefa_id#'  null='#iif(len(trim(ret.TAREFA_ID)), de('no'), de('yes'))#'>
                            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='Atribuio inicial' >
                            <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ATRIBUICAO_ID' variable='retorno.ATRIBUICAO_ID' >
                        </cfstoredproc>
                    </cfif>
                </cfloop>
                <cfset retorno.erro = false>
                <cfif ListLen(arguments.analise_id,',') gt 1>
	                <cfset retorno.mensagem = JSStringFormat('Tarefas #v_tarefas# criadas com sucesso!')>
                <cfelse>
	                <cfset retorno.mensagem = JSStringFormat('Tarefa #v_tarefas# criada com sucesso!')>
                </cfif>
            </cftransaction>
            <cfcatch>
                <cfset retorno.erro = true>
                <cftransaction action="rollback" />
                <cfset retorno.mensagem = cfcatch>
				<cfset retorno.mensagem_str = cfcatch.Detail>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Cria as tarefas a partir das analises e atribui as etapas
    -- CRISTOFER 30/04/2010 10:26:41 - CRIADO
    --->
    <cffunction name='criar_tarefa_analise' displayname='Cria as tarefas a partir das analises' access='remote' returntype='Struct' output='true'>
        <cfargument name='ANALISE_ID' required='yes'>
        <cfargument name='ENTREGAR_EM' required='yes'>
        <cftry>
            <cfstoredproc procedure='kmm.pkg_tarefa.PRC_CRIAR_TAREFA_ANALISE' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANALISE_ID'  value='#arguments.ANALISE_ID#'  null='#iif(len(trim(arguments.ANALISE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGAR_EM'  value='#arguments.ENTREGAR_EM#' null='#iif(len(trim(arguments.ENTREGAR_EM)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_TAREFA_ID' variable="retorno.tarefa_id">
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Tarefa #retorno.tarefa_id# criada com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
				<cfset retorno.mensagem_str = cfcatch.Detail>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Cria as tarefas a partir das analises e atribui as etapas
    -- CRISTOFER 30/04/2010 10:26:41 - CRIADO
    --->
    <cffunction name='upd_tarefa_etapa_atribuicao' displayname='Cria as tarefas a partir das analises' access='remote' returntype='Struct' output='true'>
        <cfargument name='TAREFA_ID' required='yes'>
        <cfargument name='ETAPA_ID' required='yes'>
        <cfargument name='RECURSO_ID' required='yes'>
        <cfargument name='DATA_LIMITE' required='yes'>
        <cftry>
            <cfstoredproc procedure='kmm.pkg_tarefa.PRC_ALT_TAREFA_ETAPA_ATRIB' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ETAPA_ID'  value='#arguments.ETAPA_ID#'  null='#iif(len(trim(arguments.ETAPA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LIMITE'  value='#arguments.DATA_LIMITE#' null='#iif(len(trim(arguments.DATA_LIMITE)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Etapa alterada com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
				<cfset retorno.mensagem_str = cfcatch.Detail>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Altera o sprint de uma SD
	-- WAGNERS 22/03/2011 16:29:41 - CRIADO
	--->
	<cffunction name='upd_sd_sprint' displayname='Altera o sprint de uma SD' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='SPRINT_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_sd.prc_alt_sd_sprint' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SPRINT_ID'  value='#arguments.SPRINT_ID#'  null='#iif(len(trim(arguments.SPRINT_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Sprint alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera o sprint de uma SD
	-- WAGNERS 22/03/2011 16:29:41 - CRIADO
	--->
	<cffunction name='ins_sd_prazo_desenvolvimento' displayname='Altera o sprint de uma SD' access='remote' returntype='Struct' output='true'>
		<cfargument name='SD_ID' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_producao.prc_ins_sd_prazo_desenv' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_DATA'  value='#arguments.DATA#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Prazo de desenvolvimento aprovado!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
<!--- 
    -- PROPSITO
    -- Insere uma ocorrencia para a SD
    -- CRISTOFER 16/02/2010 10:26:41 - CRIADO
    --->
    <cffunction name='sd_analista_negocio' displayname='Excluir vinculo entre a analise e habilidade' access='remote' returntype='Struct' output='true'>
        <cfargument name='SD_ID' required='yes'>
        <cfargument name='ANALISTA_NEGOCIO' required='yes'>
        <cftry>
                <cfstoredproc procedure='kmm.pkg_producao.prc_sd_analista_negocio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SD_ID'  value='#arguments.SD_ID#'  null='#iif(len(trim(arguments.SD_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ANALISTA_NEGOCIO'  value='#arguments.ANALISTA_NEGOCIO#'  null='#iif(len(trim(arguments.ANALISTA_NEGOCIO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
	            <cfset retorno.mensagem = JSStringFormat('Analista de Negcio alterado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
				<cfset retorno.mensagem_str = cfcatch.Detail>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>       
    

</cfcomponent>