<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Insere cargo
    -- guto 13/06/2008 14:58:00 - CRIADO
    --->
    <cffunction name='ins_cargo' displayname='Insere cargo' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_cargo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGO_ID' variable='retorno.CARGO_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Cargo inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Altera cargo
    -- guto 13/06/2008 15:06:30 - CRIADO
    --->
    <cffunction name='upd_cargo' displayname='Altera cargo' access='remote' returntype='Struct' output='true'>
        <cfargument name='CARGO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_cargo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGO_ID'  value='#arguments.CARGO_ID#'  null='#iif(len(trim(arguments.CARGO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Cargo alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Exclui cargo
    -- guto 13/06/2008 15:07:06 - CRIADO
    --->
    <cffunction name='del_cargo' displayname='Exclui cargo' access='remote' returntype='Struct' output='true'>
        <cfargument name='CARGO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_cargo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGO_ID'  value='#arguments.CARGO_ID#'  null='#iif(len(trim(arguments.CARGO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Cargo excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Insere nova operao
    -- guto 05/04/2008 14:23:10 - CRIADO
    --->
    <cffunction name='ins_operacao' displayname='Insere nova operao' access='remote' returntype='Struct' output='true'>
        <cfargument name='NOME' required='yes'>
        <cfargument name='OPERACAO_ID_PAI' required='yes'>
        <cfargument name='DATA_INICIO_OPERACAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_operacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID_PAI'  value='#arguments.OPERACAO_ID_PAI#'  null='#iif(len(trim(arguments.OPERACAO_ID_PAI)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO_OPERACAO'  value='#arguments.DATA_INICIO_OPERACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID' variable='retorno.OPERACAO_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Operao inserida com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera operao
    -- guto 05/04/2008 14:23:50 - CRIADO
    --->
    <cffunction name='upd_operacao' displayname='Altera operao' access='remote' returntype='Struct' output='true'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='NOME' required='yes'>
        <cfargument name='OPERACAO_ID_PAI' required='yes'>
        <cfargument name='DATA_INICIO_OPERACAO' required='yes'>
        <cfargument name='ATIVO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_operacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID_PAI'  value='#arguments.OPERACAO_ID_PAI#'  null='#iif(len(trim(arguments.OPERACAO_ID_PAI)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO_OPERACAO'  value='#arguments.DATA_INICIO_OPERACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVO'  value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Operao alterada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui operao
    -- guto 05/04/2008 14:24:26 - CRIADO
    --->
    <cffunction name='del_operacao' displayname='Exclui operao' access='remote' returntype='Struct' output='true'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_operacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Operao excluda com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Vincula operao ao item
    -- guto 09/04/2008 15:55:14 - CRIADO
    --->
    <cffunction name='ins_operacao_item' displayname='Vincula operao ao item' access='remote' returntype='Struct' output='true'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='ITEM_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_operacao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Operao vinculada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch.Detail>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Desvincula operao ao item
    -- guto 09/04/2008 16:00:16 - CRIADO
    --->
    <cffunction name='del_operacao_item' displayname='Desvincula operao ao item' access='remote' returntype='Struct' output='true'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='ITEM_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_operacao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Operao desvinculada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch.Detail>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Vincula veculo a operao
    -- GUTO 21/04/2008 11:39:49 - CRIADO
    --->
    <cffunction name='ins_operacao_veiculo' displayname='Vincula veculo a operao' access='remote' returntype='Struct' output='true'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='DATA_INICIO_VEICULO' required='yes'>
        <cfargument name='CONTRATO_ID_VEICULO' required='yes'>
        <cfargument name='VEICULO_MAQUINA' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_operacao_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO_VEICULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID_VEICULO#'  null='#iif(len(trim(arguments.CONTRATO_ID_VEICULO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEICULO_MAQUINA'  value='#arguments.VEICULO_MAQUINA#'  null='#iif(len(trim(arguments.VEICULO_MAQUINA)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Veculo vinculado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Desvincula veculo a operao
    -- GUTO 21/04/2008 11:40:46 - CRIADO
    --->
    <cffunction name='fecha_operacao_veiculo' displayname='Desvincula veculo a operao' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID_VEICULO' required='yes'>
        <cfargument name='DATA_TERMINO_VEICULO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.PRC_FECHA_OPERACAO_VEICULO' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID_VEICULO#'  null='#iif(len(trim(arguments.CONTROLE_ID_VEICULO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TERMINO'  value='#arguments.DATA_TERMINO_VEICULO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Veculo desvinculado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
	-- PROPSITO
	-- Exclui vinculo do veculo com a operao
	-- guto 06/05/2008 16:13:45 - CRIADO
	--->
	<cffunction name='del_operacao_veiculo' displayname='Exclui vinculo do veculo com a operao' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID_VEICULO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_operacao_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID_VEICULO#'  null='#iif(len(trim(arguments.CONTROLE_ID_VEICULO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Vinculo excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>      

	<!--- 
    -- PROPSITO
    -- Insere regio
    -- guto 01/05/2008 11:12:21 - CRIADO
    --->
    <cffunction name='ins_regiao' displayname='Insere regio' access='remote' returntype='Struct' output='true'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='NOME' required='yes'>
        <cfargument name='ATIVA' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_regiao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVA'  value='#arguments.ATIVA#'  null='#iif(len(trim(arguments.ATIVA)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGIAO_ID' variable='retorno.REGIAO_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Regio inserida com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Altera regio
    -- guto 01/05/2008 11:19:27 - CRIADO
    --->
    <cffunction name='upd_regiao' displayname='Altera regio' access='remote' returntype='Struct' output='true'>
        <cfargument name='REGIAO_ID' required='yes'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='NOME' required='yes'>
        <cfargument name='ATIVA' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_regiao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGIAO_ID'  value='#arguments.REGIAO_ID#'  null='#iif(len(trim(arguments.REGIAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVA'  value='#arguments.ATIVA#'  null='#iif(len(trim(arguments.ATIVA)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Regio alterada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Excluir regio
    -- guto 01/05/2008 11:20:48 - CRIADO
    --->
    <cffunction name='del_regiao' displayname='Excluir regio' access='remote' returntype='Struct' output='true'>
        <cfargument name='REGIAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_regiao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGIAO_ID'  value='#arguments.REGIAO_ID#'  null='#iif(len(trim(arguments.REGIAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Regio excluda com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Insere projeto
    -- guto 01/05/2008 15:38:03 - CRIADO
    --->
    <cffunction name='ins_projeto' displayname='Insere projeto' access='remote' returntype='Struct' output='true'>
        <cfargument name='NOME' required='yes'>
        <cfargument name='DISTANCIA_BASE' required='yes'>
        <cfargument name='REGIAO_ID' required='yes'>
        <cfargument name='REFERENCIA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_projeto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DISTANCIA_BASE'  value='#arguments.DISTANCIA_BASE#'  null='#iif(len(trim(arguments.DISTANCIA_BASE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGIAO_ID'  value='#arguments.REGIAO_ID#'  null='#iif(len(trim(arguments.REGIAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REFERENCIA_ID'  value='#arguments.REFERENCIA_ID#'  null='#iif(len(trim(arguments.REFERENCIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID' variable='retorno.PROJETO_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Projeto inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Altera projeto
    -- guto 01/05/2008 15:39:23 - CRIADO
    --->
    <cffunction name='upd_projeto' displayname='Altera projeto' access='remote' returntype='Struct' output='true'>
        <cfargument name='PROJETO_ID' required='yes'>
        <cfargument name='NOME' required='yes'>
        <cfargument name='DISTANCIA_BASE' required='yes'>
        <cfargument name='REGIAO_ID' required='yes'>
        <cfargument name='REFERENCIA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_projeto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DISTANCIA_BASE'  value='#arguments.DISTANCIA_BASE#'  null='#iif(len(trim(arguments.DISTANCIA_BASE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGIAO_ID'  value='#arguments.REGIAO_ID#'  null='#iif(len(trim(arguments.REGIAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REFERENCIA_ID'  value='#arguments.REFERENCIA_ID#'  null='#iif(len(trim(arguments.REFERENCIA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Projeto alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Excluir projeto
    -- guto 01/05/2008 15:40:38 - CRIADO
    --->
    <cffunction name='del_projeto' displayname='Excluir projeto' access='remote' returntype='Struct' output='true'>
        <cfargument name='PROJETO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_projeto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Projeto excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Insere local vinculado a operao
    -- guto 30/07/2008 11:42:12 - CRIADO
    --->
    <cffunction name='ins_local' displayname='Insere local vinculado a operao' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='REFERENCIA_ID' required='yes'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_local' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REFERENCIA_ID'  value='#arguments.REFERENCIA_ID#'  null='#iif(len(trim(arguments.REFERENCIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCAL_ID' variable='retorno.LOCAL_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Local inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Altera local vinculado a operao
    -- guto 30/07/2008 11:49:05 - CRIADO
    --->
    <cffunction name='upd_local' displayname='Altera local vinculado a operao' access='remote' returntype='Struct' output='true'>
        <cfargument name='LOCAL_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='REFERENCIA_ID' required='yes'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_local' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCAL_ID'  value='#arguments.LOCAL_ID#'  null='#iif(len(trim(arguments.LOCAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REFERENCIA_ID'  value='#arguments.REFERENCIA_ID#'  null='#iif(len(trim(arguments.REFERENCIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Local alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui local vinculado a operao
    -- guto 30/07/2008 11:49:38 - CRIADO
    --->
    <cffunction name='del_local' displayname='Exclui local vinculado a operao' access='remote' returntype='Struct' output='true'>
        <cfargument name='LOCAL_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_local' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCAL_ID'  value='#arguments.LOCAL_ID#'  null='#iif(len(trim(arguments.LOCAL_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Local excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Vincula operao ao contrato
    -- guto 05/05/2008 11:49:13 - CRIADO
    --->
    <cffunction name='abre_operacao_contrato' displayname='Vincula operao ao contrato' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTRATO_ID' required='yes'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='DATA_INICIO_CONTRATO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_abre_operacao_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO_CONTRATO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Operao vinculada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
    <!--- 
    -- PROPSITO
    -- Fecha vinculo da operao com o contrato
    -- guto 06/05/2008 10:39:46 - CRIADO
    --->
    <cffunction name='fecha_operacao_contrato' displayname='Fecha vinculo da operao com o contrato' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID_CONTRATO' required='yes'>
        <cfargument name='DATA_TERMINO_CONTRATO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_fecha_operacao_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID_CONTRATO#'  null='#iif(len(trim(arguments.CONTROLE_ID_CONTRATO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TERMINO'  value='#arguments.DATA_TERMINO_CONTRATO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Contrato fechado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
	-- PROPSITO
	-- Exclui vinculo do contrato com a operao
	-- guto 06/05/2008 16:13:45 - CRIADO
	--->
	<cffunction name='del_operacao_contrato' displayname='Exclui vinculo do contrato com a operao' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID_CONTRATO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_operacao_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID_CONTRATO#'  null='#iif(len(trim(arguments.CONTROLE_ID_CONTRATO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Vinculo excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir manuteno de veculos
	-- rafael 19/05/2008 09:58:28 - CRIADO
	--->
	<cffunction name='ins_veiculo_manutencao' displayname='Inserir manuteno de veculos' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA_OFICINA' required='yes'>
		<cfargument name='NUM_DOCTO' required='no'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='DATA_ENTRADA' required='yes'>
		<cfargument name='DATA_SAIDA' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='COD_MOEDA' required='yes'>
		<cfargument name='TIPO_MANUTENCAO' required='yes'>
		<cfargument name='OBSERVACOES' required='no'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_veiculo_manutencao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_OFICINA'  value='#arguments.COD_PESSOA_OFICINA#'  null='#iif(len(trim(arguments.COD_PESSOA_OFICINA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_DOCTO'  value='#arguments.NUM_DOCTO#'  null='#iif(len(trim(arguments.NUM_DOCTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTRADA'  value='#arguments.DATA_ENTRADA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_SAIDA'  value='#arguments.DATA_SAIDA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#Replace(arguments.VALOR, '.' , '')#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_MANUTENCAO'  value='#arguments.TIPO_MANUTENCAO#'  null='#iif(len(trim(arguments.TIPO_MANUTENCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACOES'  value='#arguments.OBSERVACOES#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Manuteno inserida com sucesso !')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Alterar a manuteno de veculos
	-- rafael 20/05/2008 16:50:38 - CRIADO
	--->
	<cffunction name='upd_veiculo_manutencao' displayname='Alterar a manuteno de veculos' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='COD_PESSOA_OFICINA' required='yes'>
		<cfargument name='NUM_DOCTO' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='DATA_ENTRADA' required='yes'>
		<cfargument name='DATA_SAIDA' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='COD_MOEDA' required='yes'>
		<cfargument name='TIPO_MANUTENCAO' required='yes'>
		<cfargument name='OBSERVACOES' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_veiculo_manutencao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_OFICINA'  value='#arguments.COD_PESSOA_OFICINA#'  null='#iif(len(trim(arguments.COD_PESSOA_OFICINA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_DOCTO'  value='#arguments.NUM_DOCTO#'  null='#iif(len(trim(arguments.NUM_DOCTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTRADA'  value='#arguments.DATA_ENTRADA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_SAIDA'  value='#arguments.DATA_SAIDA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_MANUTENCAO'  value='#arguments.TIPO_MANUTENCAO#'  null='#iif(len(trim(arguments.TIPO_MANUTENCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACOES'  value='#arguments.OBSERVACOES#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Manuteno alterada com sucesso !')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Deletar manuteno de veculos
	-- Rafael Rudnik 19/05/2008 10:05:52 - CRIADO
	--->
	<cffunction name='del_veiculo_manutencao' displayname='Deletar manuteno de veculos' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_veiculo_manutencao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Manuteno excluda com sucesso !')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 	
    -- PROPSITO
    -- Vincula usurio a operao
    -- guto 26/05/2008 10:15:58 - CRIADO
    --->
    <cffunction name='ins_operacao_usuario' displayname='Vincula usurio a operao' access='remote' returntype='Struct' output='true'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='USUARIO' required='yes'>
        <cfargument name='NIVEL_ACESSO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_operacao_usuario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NIVEL_ACESSO_ID'  value='#arguments.NIVEL_ACESSO_ID#'  null='#iif(len(trim(arguments.NIVEL_ACESSO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Usurio vinculado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Altera vinculo do usurio com a operao
    -- guto 26/05/2008 10:26:55 - CRIADO
    --->
    <cffunction name='upd_operacao_usuario' displayname='Altera vinculo do usurio com a operao' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID_USUARIO' required='yes'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='USUARIO' required='yes'>
        <cfargument name='NIVEL_ACESSO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_operacao_usuario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID_USUARIO#'  null='#iif(len(trim(arguments.CONTROLE_ID_USUARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NIVEL_ACESSO_ID'  value='#arguments.NIVEL_ACESSO_ID#'  null='#iif(len(trim(arguments.NIVEL_ACESSO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Item alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>             
    
    <!--- 
    -- PROPSITO
    -- Exclui vinculo do usurio com a operao
    -- guto 26/05/2008 10:27:34 - CRIADO
    --->
    <cffunction name='del_operacao_usuario' displayname='Exclui vinculo do usurio com a operao' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID_USUARIO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_operacao_usuario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID_USUARIO#'  null='#iif(len(trim(arguments.CONTROLE_ID_USUARIO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Item excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Insere estrutura de acesso da operao
    -- guto 31/05/2008 09:35:17 - CRIADO
    --->
    <cffunction name='ins_estrutura_acesso_operacao' displayname='Insere estrutura de acesso da operao' access='remote' returntype='Struct' output='true'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_estrutura_acesso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Estrutura de acesso criada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction> 
    
	<!--- 
    -- PROPSITO
    -- Insere vinculo entre a operao e o cargo
    -- guto 17/06/2008 17:18:18 - CRIADO
    --->
    <cffunction name='ins_operacao_cargo' displayname='Insere vinculo entre a operao e o cargo' access='remote' returntype='Struct' output='true'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='CARGO_ID' required='yes'>
        <cfargument name='DATA_VIGENCIA' required='yes'>
        <cfargument name='PERC_PERICULOSIDADE' required='yes'>
        <cfargument name='PERC_INSALUBRIDADE' required='yes'>
        <cfargument name='SALARIO_BASE' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_operacao_cargo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGO_ID'  value='#arguments.CARGO_ID#'  null='#iif(len(trim(arguments.CARGO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VIGENCIA'  value='#arguments.DATA_VIGENCIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERC_PERICULOSIDADE'  value='#arguments.PERC_PERICULOSIDADE#'  null='#iif(len(trim(arguments.PERC_PERICULOSIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERC_INSALUBRIDADE'  value='#arguments.PERC_INSALUBRIDADE#'  null='#iif(len(trim(arguments.PERC_INSALUBRIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SALARIO_BASE'  value='#arguments.SALARIO_BASE#'  null='#iif(len(trim(arguments.SALARIO_BASE)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vinculo inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>   

	<!--- 
    -- PROPSITO
    -- Altera vinculo entre a operao e o cargo
    -- guto 17/06/2008 17:20:33 - CRIADO
    --->
    <cffunction name='upd_operacao_cargo' displayname='Altera vinculo entre a operao e o cargo' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID_CARGO' required='yes'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='CARGO_ID' required='yes'>
        <cfargument name='DATA_VIGENCIA' required='yes'>
        <cfargument name='PERC_PERICULOSIDADE' required='yes'>
        <cfargument name='PERC_INSALUBRIDADE' required='yes'>
        <cfargument name='SALARIO_BASE' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_operacao_cargo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID_CARGO#'  null='#iif(len(trim(arguments.CONTROLE_ID_CARGO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGO_ID'  value='#arguments.CARGO_ID#'  null='#iif(len(trim(arguments.CARGO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VIGENCIA'  value='#arguments.DATA_VIGENCIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERC_PERICULOSIDADE'  value='#arguments.PERC_PERICULOSIDADE#'  null='#iif(len(trim(arguments.PERC_PERICULOSIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERC_INSALUBRIDADE'  value='#arguments.PERC_INSALUBRIDADE#'  null='#iif(len(trim(arguments.PERC_INSALUBRIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SALARIO_BASE'  value='#arguments.SALARIO_BASE#'  null='#iif(len(trim(arguments.SALARIO_BASE)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vinculo alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>       

	<!--- 
    -- PROPSITO
    -- Exclui vinculo entre a operao e o cargo
    -- guto 17/06/2008 17:21:08 - CRIADO
    --->
    <cffunction name='del_operacao_cargo' displayname='Exclui vinculo entre a operao e o cargo' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID_CARGO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_operacao_cargo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID_CARGO#'  null='#iif(len(trim(arguments.CONTROLE_ID_CARGO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vinculo excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Vincula funcionario a operao
    -- guto 23/06/2008 11:22:50 - CRIADO
    --->
    <cffunction name='ins_operacao_funcionario' displayname='Vincula funcionario a operao' access='remote' returntype='Struct' output='true'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='CARGO_ID_FUNCIONARIO' required='yes'>
        <cfargument name='DATA_INICIO_FUNCIONARIO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_operacao_funcionario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGO_ID'  value='#arguments.CARGO_ID_FUNCIONARIO#'  null='#iif(len(trim(arguments.CARGO_ID_FUNCIONARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO_FUNCIONARIO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vinculo inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Fecha vinculo do funcionario a operao
    -- guto 23/06/2008 11:24:58 - CRIADO
    --->
    <cffunction name='fecha_operacao_funcionario' displayname='Fecha/Altera vinculo do funcionario a operao' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID_FUNCIONARIO' required='yes'>
        <cfargument name='DATA_TERMINO_FUNCIONARIO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_fecha_operacao_funcionario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID_FUNCIONARIO#'  null='#iif(len(trim(arguments.CONTROLE_ID_FUNCIONARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TERMINO'  value='#arguments.DATA_TERMINO_FUNCIONARIO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vinculo alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>  
    
	<!--- 
    -- PROPSITO
    -- Fecha/Altera vinculo do funcionario a operao
    -- guto 23/06/2008 11:24:58 - CRIADO
    --->
    <cffunction name='upd_operacao_funcionario' displayname='Fecha/Altera vinculo do funcionario a operao' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID_FUNCIONARIO' required='yes'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='CARGO_ID_FUNCIONARIO' required='yes'>
        <cfargument name='DATA_INICIO_FUNCIONARIO' required='yes'>
        <cfargument name='DATA_TERMINO_FUNCIONARIO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_operacao_funcionario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID_FUNCIONARIO#'  null='#iif(len(trim(arguments.CONTROLE_ID_FUNCIONARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA_FUNCIONARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGO_ID'  value='#arguments.CARGO_ID_FUNCIONARIO#'  null='#iif(len(trim(arguments.CARGO_ID_FUNCIONARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO_FUNCIONARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TERMINO'  value='#arguments.DATA_TERMINO_FUNCIONARIO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vinculo alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
    <!--- 
    -- PROPSITO
    -- Exlcui vinculo do funcionario a operao
    -- guto 23/06/2008 11:25:29 - CRIADO
    --->
    <cffunction name='del_operacao_funcionario' displayname='Exlcui vinculo do funcionario a operao' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID_FUNCIONARIO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_operacao_funcionario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID_FUNCIONARIO#'  null='#iif(len(trim(arguments.CONTROLE_ID_FUNCIONARIO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vinculo excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Insere vinculo entre o evento e a operao
    -- guto 07/07/2008 13:54:36 - CRIADO
    --->
    <cffunction name='ins_operacao_evento' displayname='Insere vinculo entre o evento e a operao' access='remote' returntype='Struct' output='true'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='NUM_EVENTO' required='yes'>
        <cfargument name='CODIGO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_operacao_evento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_EVENTO'  value='#arguments.NUM_EVENTO#'  null='#iif(len(trim(arguments.NUM_EVENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type="IN" cfsqltype="cf_sql_varchar" dbvarname="P_CODIGO" value="#arguments.CODIGO#">
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vinculo inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
    <!--- 
    -- PROPSITO
    -- Exclui vinculo entre o evento e a operao
    -- guto 07/07/2008 13:55:28 - CRIADO
    --->
    <cffunction name='del_operacao_evento' displayname='Exclui vinculo entre o evento e a operao' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID_EVENTO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_operacao_evento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID_EVENTO#'  null='#iif(len(trim(arguments.CONTROLE_ID_EVENTO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vinculo excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>  
    
    <!--- 
	-- PROPSITO
	-- Insere um tipo de servio
	-- igor 15/08/2008 09:07:09 - CRIADO
	--->
	<cffunction name='ins_tipo_servico' displayname='Insere um tipo de servio' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_tipo_servico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERVICO_ID' variable='retorno.SERVICO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de servio inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>  
	
	<!--- 
	-- PROPSITO
	-- Altera um tipo de servio
	-- igor 15/08/2008 09:09:34 - CRIADO
	--->
	<cffunction name='upd_tipo_servico' displayname='Altera um tipo de servio' access='remote' returntype='Struct' output='true'>
		<cfargument name='SERVICO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_tipo_servico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERVICO_ID'  value='#arguments.SERVICO_ID#'  null='#iif(len(trim(arguments.SERVICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de servio alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Deleta um tipo de servio
	-- igor 15/08/2008 09:10:41 - CRIADO
	--->
	<cffunction name='del_tipo_servico' displayname='Deleta um tipo de servio' access='remote' returntype='Struct' output='true'>
		<cfargument name='SERVICO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_tipo_servico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERVICO_ID'  value='#arguments.SERVICO_ID#'  null='#iif(len(trim(arguments.SERVICO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de servio excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Inserir Produto transportado
	-- igor 15/08/2008 13:50:47 - CRIADO
	--->
	<cffunction name='ins_produto_transportado' displayname='Inserir Produto transportado' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_produto_transportado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID' variable='retorno.PRODUTO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produto cadastrado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera Produto transportado
	-- igor 15/08/2008 13:54:18 - CRIADO
	--->
	<cffunction name='upd_produto_transportado' displayname='Altera Produto transportado' access='remote' returntype='Struct' output='true'>
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_produto_transportado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produto alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Deleta Produto transportado
	-- igor 15/08/2008 13:55:16 - CRIADO
	--->
	<cffunction name='del_produto_transportado' displayname='Deleta Produto transportado' access='remote' returntype='Struct' output='true'>
		<cfargument name='PRODUTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_produto_transportado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produto excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere em Operacao de Producao
	-- igor 20/08/2008 17:41:32 - CRIADO
	--->
	<cffunction name='ins_operacao_producao' displayname='Insere em Operacao de Producao' access='remote' returntype='Struct' output='true'>
		<cfargument name='OPERACAO_ID' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='SERVICO_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_operacao_producao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERVICO_ID'  value='#arguments.SERVICO_ID#'  null='#iif(len(trim(arguments.SERVICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produo inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera em Operacao de Producao
	-- igor 20/08/2008 17:42:48 - CRIADO
	--->
	<cffunction name='upd_operacao_producao' displayname='Altera em Operacao de Producao' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='OPERACAO_ID' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='PROJETO_ID' required='yes'>
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='SERVICO_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_operacao_producao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROJETO_ID'  value='#arguments.PROJETO_ID#'  null='#iif(len(trim(arguments.PROJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERVICO_ID'  value='#arguments.SERVICO_ID#'  null='#iif(len(trim(arguments.SERVICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produo alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui em Operacao de Producao
	-- igor 20/08/2008 17:43:33 - CRIADO
	--->
	<cffunction name='del_operacao_producao' displayname='Exclui em Operacao de Producao' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_operacao_producao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produo excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere um Tipo de Pagamento
	-- ANDERSONC 15/04/2009 17:29:38 - CRIADO
	--->
	<cffunction name='ins_tipo_pagto' displayname='Insere um Tipo de Pagamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_tipo_pagto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_PAGTO_ID' value='#arguments.TIPO_PAGTO_ID#' variable='retorno.TIPO_PAGTO_ID' null='#iif(len(trim(arguments.TIPO_PAGTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de Pagamento inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Altera um Tipo de Pagamento
    -- ANDERSONC 15/04/2009 17:33:54 - CRIADO
    --->
    <cffunction name='upd_tipo_pagto' displayname='Altera um Tipo de Pagamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_PAGTO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_tipo_pagto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_PAGTO_ID'  value='#arguments.TIPO_PAGTO_ID#'  null='#iif(len(trim(arguments.TIPO_PAGTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de Pagamento alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui um Tipo de Pagamento
	-- ANDERSONC 15/04/2009 17:35:11 - CRIADO
	--->
	<cffunction name='del_tipo_pagto' displayname='Exclui um Tipo de Pagamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_PAGTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_tipo_pagto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_PAGTO_ID'  value='#arguments.TIPO_PAGTO_ID#'  null='#iif(len(trim(arguments.TIPO_PAGTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de Pagamento excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere um Planejamento de Viagem
    -- ANDERSONC 29/04/2009 09:49:03 - CRIADO
    --->
    <cffunction name='ins_viagem_planejamento' displayname='Insere um Planejamento de Viagem' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLANEJAMENTO_ID' required='yes'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='PLACA_CONTROLE' required='yes'>
        <cfargument name='PLACA_REFERENCIA' required='yes'>
        <cfargument name='LOCAL_ID_ORIGEM' required='yes'>
        <cfargument name='REGIAO_ID_ORIGEM' required='yes'>
        <cfargument name='LOCAL_ID_DESTINO' required='yes'>
        <cfargument name='REGIAO_ID_DESTINO' required='yes'>
        <cfargument name='DATA_PREVISAO_CARREGAMENTO' required='yes'>
        <cfdump var="#arguments#">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_viagem_planejamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PLANEJAMENTO_ID'  value='#arguments.PLANEJAMENTO_ID#' variable='retorno.PLANEJAMENTO_ID'  null='#iif(len(trim(arguments.PLANEJAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CONTROLE'  value='#UCase(REReplace(arguments.PLACA_CONTROLE, '-', ''))#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_REFERENCIA'  value='#UCase(REReplace(arguments.PLACA_REFERENCIA, '-', ''))#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCAL_ID_ORIGEM'  value='#arguments.LOCAL_ID_ORIGEM#'  null='#iif(len(trim(arguments.LOCAL_ID_ORIGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGIAO_ID_ORIGEM'  value='#arguments.REGIAO_ID_ORIGEM#'  null='#iif(len(trim(arguments.REGIAO_ID_ORIGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCAL_ID_DESTINO'  value='#arguments.LOCAL_ID_DESTINO#'  null='#iif(len(trim(arguments.LOCAL_ID_DESTINO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGIAO_ID_DESTINO'  value='#arguments.REGIAO_ID_DESTINO#'  null='#iif(len(trim(arguments.REGIAO_ID_DESTINO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PREVISAO_CARREGAMENTO'  value='#arguments.DATA_PREVISAO_CARREGAMENTO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Planejamento de Viagem inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Altera um Planejamento de Viagem
    -- ANDERSONC 29/04/2009 09:50:35 - CRIADO
    --->
    <cffunction name='upd_viagem_planejamento' displayname='Altera um Planejamento de Viagem' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLANEJAMENTO_ID' required='yes'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='PLACA_CONTROLE' required='yes'>
        <cfargument name='PLACA_REFERENCIA' required='yes'>
        <cfargument name='LOCAL_ID_ORIGEM' required='yes'>
        <cfargument name='REGIAO_ID_ORIGEM' required='yes'>
        <cfargument name='LOCAL_ID_DESTINO' required='yes'>
        <cfargument name='REGIAO_ID_DESTINO' required='yes'>
        <cfargument name='DATA_PREVISAO_CARREGAMENTO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_viagem_planejamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PLANEJAMENTO_ID'  value='#arguments.PLANEJAMENTO_ID#'  null='#iif(len(trim(arguments.PLANEJAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CONTROLE'  value='#UCase(REReplace(arguments.PLACA_CONTROLE, '-', ''))#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_REFERENCIA'  value='#UCase(REReplace(arguments.PLACA_REFERENCIA, '-', ''))#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCAL_ID_ORIGEM'  value='#arguments.LOCAL_ID_ORIGEM#'  null='#iif(len(trim(arguments.LOCAL_ID_ORIGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGIAO_ID_ORIGEM'  value='#arguments.REGIAO_ID_ORIGEM#'  null='#iif(len(trim(arguments.REGIAO_ID_ORIGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCAL_ID_DESTINO'  value='#arguments.LOCAL_ID_DESTINO#'  null='#iif(len(trim(arguments.LOCAL_ID_DESTINO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGIAO_ID_DESTINO'  value='#arguments.REGIAO_ID_DESTINO#'  null='#iif(len(trim(arguments.REGIAO_ID_DESTINO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PREVISAO_CARREGAMENTO'  value='#arguments.DATA_PREVISAO_CARREGAMENTO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Planejamento de Viagem alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Exclui um Planejamento de Viagem
    -- ANDERSONC 29/04/2009 09:51:56 - CRIADO
    --->
    <cffunction name='del_viagem_planejamento' displayname='Exclui um Planejamento de Viagem' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLANEJAMENTO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_viagem_planejamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PLANEJAMENTO_ID'  value='#arguments.PLANEJAMENTO_ID#'  null='#iif(len(trim(arguments.PLANEJAMENTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Planejamento de Viagem excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere Tipo de Despesa de Romaneio
    -- Rafael Costa 11/05/2009 11:06:53 - CRIADO
    --->
    <cffunction name='ins_tipo_despesa_romaneio' displayname='Insere Tipo de Despesa de Romaneio' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_DESPESA_ROMANEIO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_tipo_despesa_romaneio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DESPESA_ROMANEIO_ID'  value='#arguments.TIPO_DESPESA_ROMANEIO_ID#' variable='retorno.TIPO_DESPESA_ROMANEIO_ID'  null='#iif(len(trim(arguments.TIPO_DESPESA_ROMANEIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de Despesa de Romaneio inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera Tipo de Despesa de Romaneio
    -- Rafael Costa 11/05/2009 11:16:35 - CRIADO
    --->
    <cffunction name='upd_tipo_despesa_romaneio' displayname='Altera Tipo de Despesa de Romaneio' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_DESPESA_ROMANEIO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_tipo_despesa_romaneio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DESPESA_ROMANEIO_ID'  value='#arguments.TIPO_DESPESA_ROMANEIO_ID#'  null='#iif(len(trim(arguments.TIPO_DESPESA_ROMANEIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de Despesa de Romaneio alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui Tipo de Despesa de Romaneio
    -- rafael 11/05/2009 11:18:27 - CRIADO
    --->
    <cffunction name='del_tipo_despesa_romaneio' displayname='Exclui Tipo de Despesa de Romaneio' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_DESPESA_ROMANEIO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_tipo_despesa_romaneio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DESPESA_ROMANEIO_ID'  value='#arguments.TIPO_DESPESA_ROMANEIO_ID#'  null='#iif(len(trim(arguments.TIPO_DESPESA_ROMANEIO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de Despesa de Romaneio excluido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere uma Despesa para um Romaneio
    -- ANDERSONC 12/05/2009 09:34:26 - CRIADO
    --->
    <cffunction name='ins_despesa_romaneio' displayname='Insere uma Despesa para um Romaneio' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESPESA_ROMANEIO_ID' required='yes'>
        <cfargument name='DATA_LANCAMENTO' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='NUM_DOCUMENTO' required='yes'>
        <cfargument name='TIPO_DESPESA_ROMANEIO_ID' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cfargument name='COMPLEMENTO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_despesa_romaneio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESPESA_ROMANEIO_ID'  value='#arguments.DESPESA_ROMANEIO_ID#' variable='retorno.DESPESA_ROMANEIO_ID'  null='#iif(len(trim(arguments.DESPESA_ROMANEIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_DOCUMENTO'  value='#arguments.NUM_DOCUMENTO#'  null='#iif(len(trim(arguments.NUM_DOCUMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DESPESA_ROMANEIO_ID'  value='#arguments.TIPO_DESPESA_ROMANEIO_ID#'  null='#iif(len(trim(arguments.TIPO_DESPESA_ROMANEIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Despesa inserida com Sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera uma Despesa de um Romaneio
	-- ANDERSONC 12/05/2009 10:11:13 - CRIADO
	--->
	<cffunction name='upd_despesa_romaneio' displayname='Altera uma Despesa de um Romaneio' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESPESA_ROMANEIO_ID' required='yes'>
		<cfargument name='DATA_LANCAMENTO' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='NUM_DOCUMENTO' required='yes'>
		<cfargument name='TIPO_DESPESA_ROMANEIO_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='COMPLEMENTO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_despesa_romaneio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESPESA_ROMANEIO_ID'  value='#arguments.DESPESA_ROMANEIO_ID#'  null='#iif(len(trim(arguments.DESPESA_ROMANEIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_DOCUMENTO'  value='#arguments.NUM_DOCUMENTO#'  null='#iif(len(trim(arguments.NUM_DOCUMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DESPESA_ROMANEIO_ID'  value='#arguments.TIPO_DESPESA_ROMANEIO_ID#'  null='#iif(len(trim(arguments.TIPO_DESPESA_ROMANEIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Despesa alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui uma Despesa de um Romaneio
	-- ANDERSONC 12/05/2009 10:12:46 - CRIADO
	--->
	<cffunction name='del_despesa_romaneio' displayname='Exclui uma Despesa de um Romaneio' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESPESA_ROMANEIO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_despesa_romaneio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESPESA_ROMANEIO_ID'  value='#arguments.DESPESA_ROMANEIO_ID#'  null='#iif(len(trim(arguments.DESPESA_ROMANEIO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Despesa excluda com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Inserir Despesa de Manuteno
    -- rafael 14/05/2009 18:10:46 - CRIADO
    --->
    <cffunction name='ins_despesa_manutencao' displayname='Inserir Despesa de Manuteno' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESPESA_MANUTENCAO_ID' required='yes'>
        <cfargument name='NUM_DOCUMENTO' required='yes'>
        <cfargument name='DATA_LANCTO' required='yes'>
        <cfargument name='COD_OFICINA' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='TIPO_DESPESA' required='yes'>
        <cfargument name='DATA_ENTRADA' required='yes'>
        <cfargument name='DATA_SAIDA' required='yes'>
        <cfargument name='COD_MOTORISTA' required='yes'>
        <cfargument name='COD_RESPONSAVEL' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cfargument name='COMPLEMENTO' required='yes'>
        <cftry>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_despesa_manutencao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESPESA_MANUTENCAO_ID'  value='#arguments.DESPESA_MANUTENCAO_ID#' variable='retorno.DESPESA_MANUTENCAO_ID'  null='#iif(len(trim(arguments.DESPESA_MANUTENCAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_DOCUMENTO'  value='#arguments.NUM_DOCUMENTO#'  null='#iif(len(trim(arguments.NUM_DOCUMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCTO'  value='#arguments.DATA_LANCTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_OFICINA'  value='#arguments.COD_OFICINA#'  null='#iif(len(trim(arguments.COD_OFICINA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DESPESA'  value='#arguments.TIPO_DESPESA#'  null='#iif(len(trim(arguments.TIPO_DESPESA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_MANUTENCAO'  value='#arguments.TIPO_MANUTENCAO#'  null='#iif(len(trim(arguments.TIPO_MANUTENCAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTRADA'  value='#arguments.DATA_ENTRADA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_SAIDA'  value='#arguments.DATA_SAIDA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_RESPONSAVEL'  value='#arguments.COD_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_RESPONSAVEL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Despesa de Manuteno inserida com Sucesso')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
</cffunction>

	<!--- 
    -- PROPSITO
    -- Editar Despesa de Manuteno
    -- rafael 14/05/2009 18:13:38 - CRIADO
    --->
    <cffunction name='upd_despesa_manutencao' displayname='Editar Despesa de Manuteno' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESPESA_MANUTENCAO_ID' required='yes'>
        <cfargument name='NUM_DOCUMENTO' required='yes'>
        <cfargument name='DATA_LANCTO' required='yes'>
        <cfargument name='COD_OFICINA' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='TIPO_DESPESA' required='yes'>
        <cfargument name='TIPO_MANUTENCAO' required='yes'>
        <cfargument name='DATA_ENTRADA' required='yes'>
        <cfargument name='DATA_SAIDA' required='yes'>
        <cfargument name='COD_MOTORISTA' required='yes'>
        <cfargument name='COD_RESPONSAVEL' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cfargument name='COMPLEMENTO' required='yes'>
        <cftry>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_despesa_manutencao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESPESA_MANUTENCAO_ID'  value='#arguments.DESPESA_MANUTENCAO_ID#'  null='#iif(len(trim(arguments.DESPESA_MANUTENCAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_DOCUMENTO'  value='#arguments.NUM_DOCUMENTO#'  null='#iif(len(trim(arguments.NUM_DOCUMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCTO'  value='#arguments.DATA_LANCTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_OFICINA'  value='#arguments.COD_OFICINA#'  null='#iif(len(trim(arguments.COD_OFICINA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DESPESA'  value='#arguments.TIPO_DESPESA#'  null='#iif(len(trim(arguments.TIPO_DESPESA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_MANUTENCAO'  value='#arguments.TIPO_MANUTENCAO#'  null='#iif(len(trim(arguments.TIPO_MANUTENCAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTRADA'  value='#arguments.DATA_ENTRADA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_SAIDA'  value='#arguments.DATA_SAIDA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_RESPONSAVEL'  value='#arguments.COD_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_RESPONSAVEL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Despesa de Manuteno alterada com Sucesso')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
</cffunction>
   
<!--- 
    -- PROPSITO
    -- Editar Despesa de Manuteno
    -- rafael 14/05/2009 18:14:56 - CRIADO
    --->
    <cffunction name='del_despesa_manutencao' displayname='Editar Despesa de Manuteno' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESPESA_MANUTENCAO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_despesa_manutencao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESPESA_MANUTENCAO_ID'  value='#arguments.DESPESA_MANUTENCAO_ID#'  null='#iif(len(trim(arguments.DESPESA_MANUTENCAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Despesa de Manuteno exluida com Sucesso')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Apagar Romaneios
    -- rafael 08/06/2009 11:44:47 - CRIADO
    --->
    <cffunction name='del_romaneio' displayname='Apagar Romaenios' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_romaneio_dml.prc_del_romaneio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ITENS_EXCLUIDOS' variable='retorno.ITENS_EXCLUIDOS' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Romaneio excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>     
    
    <!--- 
	-- PROPSITO
	-- Insere um valor de frete por rota
	-- ANDERSONC 29/11/2010 11:05:44 - CRIADO
	--->
	<cffunction name='ins_local_rota_valor' displayname='Insere um Valor de Frete para uma Rota' access='remote' returntype='Struct' output='true'>
		<cfargument name='LOCAL_ROTA_ID' required='yes'>
		<cfargument name='VALOR_FRETE' required='yes'>
		<cfargument name='DATA_VIGENCIA' required='yes'>
		<cfargument name='CLASSIFICACAO_COMERCIAL_ID' required='yes'>
		<cfargument name='VALOR_KM' required='yes'>
		<cfargument name='VALOR_TON' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_local_rota_valor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_VALOR_ID' variable='retorno.ROTA_VALOR_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCAL_ROTA_ID'  value='#arguments.LOCAL_ROTA_ID#'  null='#iif(len(trim(arguments.LOCAL_ROTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_FRETE'  value='#arguments.VALOR_FRETE#'  null='#iif(len(trim(arguments.VALOR_FRETE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VIGENCIA'  value='#arguments.DATA_VIGENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLASSIFICACAO_COMERCIAL_ID'  value='#arguments.CLASSIFICACAO_COMERCIAL_ID#'  null='#iif(len(trim(arguments.CLASSIFICACAO_COMERCIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_KM'  value='#arguments.VALOR_KM#'  null='#iif(len(trim(arguments.VALOR_KM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_TON'  value='#arguments.VALOR_TON#'  null='#iif(len(trim(arguments.VALOR_TON)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Valor de Frete inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera um valor de frete por rota
	-- ANDERSONC 29/11/2010 11:41:09 - CRIADO
	--->
	<cffunction name='upd_local_rota_valor' displayname='Altera um valor de frete de uma rota' access='remote' returntype='Struct' output='true'>
		<cfargument name='ROTA_VALOR_ID' required='yes'>
		<cfargument name='LOCAL_ROTA_ID' required='yes'>
		<cfargument name='VALOR_FRETE' required='yes'>
		<cfargument name='DATA_VIGENCIA' required='yes'>
		<cfargument name='CLASSIFICACAO_COMERCIAL_ID' required='yes'>
		<cfargument name='VALOR_KM' required='yes'>
		<cfargument name='VALOR_TON' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_local_rota_valor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_VALOR_ID'  value='#arguments.ROTA_VALOR_ID#'  null='#iif(len(trim(arguments.ROTA_VALOR_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCAL_ROTA_ID'  value='#arguments.LOCAL_ROTA_ID#'  null='#iif(len(trim(arguments.LOCAL_ROTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_FRETE'  value='#arguments.VALOR_FRETE#'  null='#iif(len(trim(arguments.VALOR_FRETE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VIGENCIA'  value='#arguments.DATA_VIGENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLASSIFICACAO_COMERCIAL_ID'  value='#arguments.CLASSIFICACAO_COMERCIAL_ID#'  null='#iif(len(trim(arguments.CLASSIFICACAO_COMERCIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_KM'  value='#arguments.VALOR_KM#'  null='#iif(len(trim(arguments.VALOR_KM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_TON'  value='#arguments.VALOR_TON#'  null='#iif(len(trim(arguments.VALOR_TON)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Valor de Frete alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera um valor de frete por rota
	-- ANDERSONC 29/11/2010 11:48:51 - CRIADO
	--->
	<cffunction name='upd_local_rota_valores' displayname='Altera um valor de frete de uma rota' access='remote' returntype='Struct' output='true'>
		<cfargument name='ROTA_VALOR_ID' required='yes'>
		<cfargument name='VALOR_FRETE' required='yes'>
		<cfargument name='VALOR_KM' required='yes'>
		<cfargument name='VALOR_TON' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_local_rota_valores' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_VALOR_ID'  value='#arguments.ROTA_VALOR_ID#'  null='#iif(len(trim(arguments.ROTA_VALOR_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_FRETE'  value='#arguments.VALOR_FRETE#'  null='#iif(len(trim(arguments.VALOR_FRETE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_KM'  value='#arguments.VALOR_KM#'  null='#iif(len(trim(arguments.VALOR_KM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_TON'  value='#arguments.VALOR_TON#'  null='#iif(len(trim(arguments.VALOR_TON)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Valores alterados com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere um reajuste de valor de frete por rota
	-- ANDERSONC 29/11/2010 11:33:33 - CRIADO
	--->
	<cffunction name='reajuste_local_rota_valor' displayname='Insere um reajuste de valor de frete para uma rota' access='remote' returntype='Struct' output='true'>
		<cfargument name='ROTA_VALOR_ID' required='yes'>
		<cfargument name='VALOR_FRETE' required='yes'>
		<cfargument name='DATA_VIGENCIA' required='yes'>
		<cfargument name='VALOR_KM' required='yes'>
		<cfargument name='VALOR_TON' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_reajuste_local_rota_valor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_VALOR_ID'  value='#arguments.ROTA_VALOR_ID#'  null='#iif(len(trim(arguments.ROTA_VALOR_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_FRETE'  value='#arguments.VALOR_FRETE#'  null='#iif(len(trim(arguments.VALOR_FRETE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VIGENCIA'  value='#arguments.DATA_VIGENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_KM'  value='#arguments.VALOR_KM#'  null='#iif(len(trim(arguments.VALOR_KM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_TON'  value='#arguments.VALOR_TON#'  null='#iif(len(trim(arguments.VALOR_TON)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Reajuste inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Cancela um valor de frete por rota
	-- ANDERSONC 29/11/2010 11:55:15 - CRIADO
	--->
	<cffunction name='cancelar_local_rota_valor' displayname='Cancela um valor de frete por rota' access='remote' returntype='Struct' output='true'>
		<cfargument name='ROTA_VALOR_ID' required='yes'>
		<cfargument name='MOTIVO_CANCELAMENTO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_cancelar_local_rota_valor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_VALOR_ID'  value='#arguments.ROTA_VALOR_ID#'  null='#iif(len(trim(arguments.ROTA_VALOR_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO_CANCELAMENTO'  value='#arguments.MOTIVO_CANCELAMENTO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Valor de Frete cancelado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere um Tipo de Pagamento de Prmio
	-- ANDERSONC 29/06/2009 15:06:34 - CRIADO
	--->
	<cffunction name='ins_tipo_pagto_premio' displayname='Insere um Tipo de Pagamento de Prmio' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_PAGTO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_tipo_pagto_premio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_PAGTO_ID'  value='#arguments.TIPO_PAGTO_ID#' variable='retorno.TIPO_PAGTO_ID'  null='#iif(len(trim(arguments.TIPO_PAGTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de Pagamento inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera um Tipo de Pagamento de Prmio
	-- ANDERSONC 29/06/2009 15:07:51 - CRIADO
	--->
	<cffunction name='upd_tipo_pagto_premio' displayname='Altera um Tipo de Pagamento de Prmio' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_PAGTO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_tipo_pagto_premio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_PAGTO_ID'  value='#arguments.TIPO_PAGTO_ID#'  null='#iif(len(trim(arguments.TIPO_PAGTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de Pagamento alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui um Tipo de Pagamento de Prmio
	-- ANDERSONC 29/06/2009 15:10:06 - CRIADO
	--->
	<cffunction name='del_tipo_pagto_premio' displayname='Exclui um Tipo de Pagamento de Prmio' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_PAGTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_tipo_pagto_premio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_PAGTO_ID'  value='#arguments.TIPO_PAGTO_ID#'  null='#iif(len(trim(arguments.TIPO_PAGTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de Pagamento excludo com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere um Prmio
    -- ANDERSONC 29/06/2009 15:11:28 - CRIADO
    --->
    <cffunction name='ins_premio' displayname='Insere um Prmio' access='remote' returntype='Struct' output='true'>
        <cfargument name='PREMIO_ID' required='yes'>
        <cfargument name='TITULO' required='yes'>
        <cfargument name='ATIVO' required='yes'>
        <cfargument name='TIPO_PAGTO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_premio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PREMIO_ID'  value='#arguments.PREMIO_ID#' variable='retorno.PREMIO_ID'  null='#iif(len(trim(arguments.PREMIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVO'  value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_PAGTO_ID'  value='#arguments.TIPO_PAGTO_ID#'  null='#iif(len(trim(arguments.TIPO_PAGTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Prmio inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera um Prmio
    -- ANDERSONC 29/06/2009 15:12:20 - CRIADO
    --->
    <cffunction name='upd_premio' displayname='Altera um Prmio' access='remote' returntype='Struct' output='true'>
        <cfargument name='PREMIO_ID' required='yes'>
        <cfargument name='TITULO' required='yes'>
        <cfargument name='ATIVO' required='yes'>
        <cfargument name='TIPO_PAGTO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_premio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PREMIO_ID'  value='#arguments.PREMIO_ID#'  null='#iif(len(trim(arguments.PREMIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVO'  value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_PAGTO_ID'  value='#arguments.TIPO_PAGTO_ID#'  null='#iif(len(trim(arguments.TIPO_PAGTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Prmio alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui um Prmio
    -- ANDERSONC 29/06/2009 15:13:09 - CRIADO
    --->
    <cffunction name='del_premio' displayname='Exclui um Prmio' access='remote' returntype='Struct' output='true'>
        <cfargument name='PREMIO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_premio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PREMIO_ID'  value='#arguments.PREMIO_ID#'  null='#iif(len(trim(arguments.PREMIO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Prmio excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere uma Origem de Reclamao
    -- ANDERSONC 29/06/2009 15:15:01 - CRIADO
    --->
    <cffunction name='ins_origem_reclamacao' displayname='Insere uma Origem de Reclamao' access='remote' returntype='Struct' output='true'>
        <cfargument name='ORIGEM_RECLAMACAO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_origem_reclamacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORIGEM_RECLAMACAO_ID'  value='#arguments.ORIGEM_RECLAMACAO_ID#' variable='retorno.ORIGEM_RECLAMACAO_ID'  null='#iif(len(trim(arguments.ORIGEM_RECLAMACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Origem inserida com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera uma Origem de Reclamao
    -- ANDERSONC 29/06/2009 15:15:53 - CRIADO
    --->
    <cffunction name='upd_origem_reclamacao' displayname='Altera uma Origem de Reclamao' access='remote' returntype='Struct' output='true'>
        <cfargument name='ORIGEM_RECLAMACAO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_origem_reclamacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORIGEM_RECLAMACAO_ID'  value='#arguments.ORIGEM_RECLAMACAO_ID#'  null='#iif(len(trim(arguments.ORIGEM_RECLAMACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Origem alterada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui uma Origem de Reclamao
    -- ANDERSONC 29/06/2009 15:16:38 - CRIADO
    --->
    <cffunction name='del_origem_reclamacao' displayname='Exclui uma Origem de Reclamao' access='remote' returntype='Struct' output='true'>
        <cfargument name='ORIGEM_RECLAMACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_origem_reclamacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORIGEM_RECLAMACAO_ID'  value='#arguments.ORIGEM_RECLAMACAO_ID#'  null='#iif(len(trim(arguments.ORIGEM_RECLAMACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Origem excluda com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere uma Reclamao
    -- ANDERSONC 29/06/2009 15:17:43 - CRIADO
    --->
    <cffunction name='ins_reclamacao' displayname='Insere uma Reclamao' access='remote' returntype='Struct' output='true'>
        <cfargument name='RECLAMACAO_ID' required='yes'>
        <cfargument name='DATA_RECLAMACAO' required='yes'>
        <cfargument name='COD_MOTORISTA' required='yes'>
        <cfargument name='ORIGEM_RECLAMACAO_ID' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_reclamacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECLAMACAO_ID'  value='#arguments.RECLAMACAO_ID#' variable='retorno.RECLAMACAO_ID'  null='#iif(len(trim(arguments.RECLAMACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_RECLAMACAO'  value='#arguments.DATA_RECLAMACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORIGEM_RECLAMACAO_ID'  value='#arguments.ORIGEM_RECLAMACAO_ID#'  null='#iif(len(trim(arguments.ORIGEM_RECLAMACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Reclamao inserida com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera uma Reclamao
    -- ANDERSONC 29/06/2009 15:18:27 - CRIADO
    --->
    <cffunction name='upd_reclamacao' displayname='Altera uma Reclamao' access='remote' returntype='Struct' output='true'>
        <cfargument name='RECLAMACAO_ID' required='yes'>
        <cfargument name='DATA_RECLAMACAO' required='yes'>
        <cfargument name='COD_MOTORISTA' required='yes'>
        <cfargument name='ORIGEM_RECLAMACAO_ID' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_reclamacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER' dbvarname='PARAMETER' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECLAMACAO_ID'  value='#arguments.RECLAMACAO_ID#'  null='#iif(len(trim(arguments.RECLAMACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_RECLAMACAO'  value='#arguments.DATA_RECLAMACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORIGEM_RECLAMACAO_ID'  value='#arguments.ORIGEM_RECLAMACAO_ID#'  null='#iif(len(trim(arguments.ORIGEM_RECLAMACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Reclamao alterada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui uma Reclamao
    -- ANDERSONC 29/06/2009 15:19:30 - CRIADO
    --->
    <cffunction name='del_reclamacao' displayname='Exclui uma Reclamao' access='remote' returntype='Struct' output='true'>
        <cfargument name='RECLAMACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_reclamacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECLAMACAO_ID'  value='#arguments.RECLAMACAO_ID#'  null='#iif(len(trim(arguments.RECLAMACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Reclamao excluda com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Inserir Faixa de Prmios por Mdia de Consumo de Combustvel
    -- rafael 03/07/2009 08:59:44 - CRIADO
    --->
    <cffunction name='ins_premio_faixa_consumo' displayname='Inserir Faixa de Prmios por Mdia de Consumo de Combustvel' access='remote' returntype='Struct' output='true'>
        <cfargument name='FAIXA_ID' required='yes'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='FAIXA_INICIAL' required='yes'>
        <cfargument name='FAIXA_FINAL' required='yes'>
        <cfargument name='PREMIO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_premio_faixa_consumo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FAIXA_ID'  value='#arguments.FAIXA_ID#' variable='retorno.FAIXA_ID'  null='#iif(len(trim(arguments.FAIXA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FAIXA_INICIAL'  value='#arguments.FAIXA_INICIAL#'  null='#iif(len(trim(arguments.FAIXA_INICIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FAIXA_FINAL'  value='#arguments.FAIXA_FINAL#'  null='#iif(len(trim(arguments.FAIXA_FINAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PREMIO'  value='#arguments.PREMIO#'  null='#iif(len(trim(arguments.PREMIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Faixa de Prmio inserida com sucesso ')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Alterar Faixa de Prmios por Mdia de Consumo de Combustvel
    -- rafael 02/07/2009 09:48:43 - CRIADO
    --->
    <cffunction name='upd_premio_faixa_consumo' displayname='Alterar Faixa de Prmios por Mdia de Consumo de Combustvel' access='remote' returntype='Struct' output='true'>
        <cfargument name='FAIXA_ID' required='yes'>
        <cfargument name='OPERACAO_ID' required='yes'>
        <cfargument name='FAIXA_INICIAL' required='yes'>
        <cfargument name='FAIXA_FINAL' required='yes'>
        <cfargument name='PREMIO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_premio_faixa_consumo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FAIXA_ID'  value='#arguments.FAIXA_ID#'  null='#iif(len(trim(arguments.FAIXA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FAIXA_INICIAL'  value='#arguments.FAIXA_INICIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FAIXA_FINAL'  value='#arguments.FAIXA_FINAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PREMIO'  value='#arguments.PREMIO#'  null='#iif(len(trim(arguments.PREMIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Faixa de Prmio alterada com sucesso ')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Excluir Faixa de Prmios por Mdia de Consumo de Combustvel
    -- rafael 02/07/2009 09:49:48 - CRIADO
    --->
    <cffunction name='del_premio_faixa_consumo' displayname='Excluir Faixa de Prmios por Mdia de Consumo de Combustvel' access='remote' returntype='Struct' output='true'>
        <cfargument name='FAIXA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_premio_faixa_consumo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FAIXA_ID'  value='#arguments.FAIXA_ID#'  null='#iif(len(trim(arguments.FAIXA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Faixa de Prmio excluda com sucesso ')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
   <!--- 
	-- PROPSITO
	-- Manipula funes de manipulao de Valores para premiao
	-- jonas 02/07/2009 14:57:09 - CRIADO
	---> 
   <cffunction name='manipula_premio_valores' displayname='Manipula funes de manipulao de Valores para premiao' access='remote' returntype='Struct' output='true'>
		
      <cftry>
			<cftransaction action='begin'>
            
                
					<!--- Altera os items  --->
               
               <cfscript>		
						v_premio_valores_id = this.ListaToArray(lista = arguments, variavel = 'PREMIO_VALORES_ID_PREMIO_VALORES');
						v_valor_referencial = this.ListaToArray(lista = arguments, variavel = 'VALOR_REFERENCIAL_PREMIO_VALORES');
						v_nao_sinistro      = this.ListaToArray(lista = arguments, variavel = 'NAO_SINISTRO_PREMIO_VALORES');
						v_km_rodado         = this.ListaToArray(lista = arguments, variavel = 'KM_RODADO_PREMIO_VALORES');
						v_punicao           = this.ListaToArray(lista = arguments, variavel = 'PUNICAO_PREMIO_VALORES');
						v_premio_pago       = this.ListaToArray(lista = arguments, variavel = 'PREMIO_PAGO_PREMIO_VALORES');
						v_vigencia          = this.ListaToArray(lista = arguments, variavel = 'VIGENCIA_PREMIO_VALORES');
						
						v_excluir           = this.ListDiff(lista1 = arguments.lista_deleted_PREMIO_VALORES, lista2 = ArrayToList(v_premio_valores_id));
						
						//v_item_id      = this.ListaToArray(lista = arguments, variavel = 'ITEM_ID_ITEM');
						//v_data         = this.ListaToArray(lista = arguments, variavel = 'ITEM_DATA_ITEM');
						//v_hora_inicio  = this.ListaToArray(lista = arguments, variavel = 'ITEM_HORA_INICIO_ITEM');
						//v_hora_termino = this.ListaToArray(lista = arguments, variavel = 'ITEM_HORA_TERMINO_ITEM');
						//v_numero_horas =this.ListaToArray(lista = arguments, variavel = 'ITEM_NUMERO_HORAS_ITEM');
						
						//v_excluir     = this.ListDiff(lista1 = arguments.lista_deleted_ITEM, lista2 = ArrayToList(v_item_id));
               </cfscript>
               
					<!---Excluir os itens---> 
               <cfloop list="#v_excluir#" delimiters="," index="l_item_id">
						<cfscript>
                  	this.del_premio_valores(premio_valores_id  = l_item_id);	
                  </cfscript>
               </cfloop>
                
               <cfloop from="1" to="#ArrayLen(v_valor_referencial)#" index="count">
                  <cfscript>
                     if(Not Len(Trim(v_premio_valores_id[count]))) {
                        ret = this.ins_premio_valores(PREMIO_VALORES_ID = ''
																	  ,VALOR_REFERENCIAL = v_valor_referencial[count]
																	  ,NAO_SINISTRO      = v_nao_sinistro[count]
																	  ,KM_RODADO         = v_km_rodado[count]
																	  ,PUNICAO           = v_punicao[count]
																	  ,PREMIO_PAGO       = v_premio_pago[count]
																	  ,VIGENCIA          = v_vigencia[count]
																	  );
                     } else {
                        ret = this.upd_premio_valores(PREMIO_VALORES_ID = v_premio_valores_id[count]
																	  ,VALOR_REFERENCIAL = v_valor_referencial[count]
																	  ,NAO_SINISTRO      = v_nao_sinistro[count]
																	  ,KM_RODADO         = v_km_rodado[count]
																	  ,PUNICAO           = v_punicao[count]
																	  ,PREMIO_PAGO       = v_premio_pago[count]
																	  ,VIGENCIA          = v_vigencia[count]
																	  );																		
                     }
                  </cfscript>
                  <cfif ret.erro>
                  	<cfthrow object="#ret.mensagem#">
                  </cfif>
               </cfloop>
               <!---  Fim --->
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Operao realizada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
   
    
    <!--- 
	-- PROPSITO
	-- Insere valores para premiao
	-- jonas 02/07/2009 14:57:09 - CRIADO
	--->
	<cffunction name='ins_premio_valores' displayname='Insere valores para premiao' access='remote' returntype='Struct' output='true'>
		<cfargument name='PREMIO_VALORES_ID' required='yes'>
		<cfargument name='VALOR_REFERENCIAL' required='yes'>
		<cfargument name='NAO_SINISTRO' required='yes'>
		<cfargument name='KM_RODADO' required='yes'>
		<cfargument name='PUNICAO' required='yes'>
		<cfargument name='PREMIO_PAGO' required='yes'>
		<cfargument name='VIGENCIA' required='yes'>
      <cftry>
            <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_premio_valores' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
               <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PREMIO_VALORES_ID'  value='#arguments.PREMIO_VALORES_ID#' variable='retorno.PREMIO_VALORES_ID'  null='#iif(len(trim(arguments.PREMIO_VALORES_ID)), de('no'), de('yes'))#'>
               <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_REFERENCIAL'  value='#arguments.VALOR_REFERENCIAL#'  null='#iif(len(trim(arguments.VALOR_REFERENCIAL)), de('no'), de('yes'))#'>
               <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NAO_SINISTRO'  value='#arguments.NAO_SINISTRO#'  null='#iif(len(trim(arguments.NAO_SINISTRO)), de('no'), de('yes'))#'>
               <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_KM_RODADO'  value='#arguments.KM_RODADO#'  null='#iif(len(trim(arguments.KM_RODADO)), de('no'), de('yes'))#'>
               <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PUNICAO'  value='#arguments.PUNICAO#'  null='#iif(len(trim(arguments.PUNICAO)), de('no'), de('yes'))#'>
               <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PREMIO_PAGO'  value='#arguments.PREMIO_PAGO#'  null='#iif(len(trim(arguments.PREMIO_PAGO)), de('no'), de('yes'))#'>
               <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VIGENCIA'  value='#arguments.VIGENCIA#' >
               <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
      		<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Item inserido com sucesso!')>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
   
	<!--- 
   -- PROPSITO
   -- Altera valores para premiao
   -- jonas 02/07/2009 14:58:28 - CRIADO
   --->
   <cffunction name='upd_premio_valores' displayname='Altera valores para premiao' access='remote' returntype='Struct' output='true'>
      <cfargument name='PREMIO_VALORES_ID' required='yes'>
      <cfargument name='VALOR_REFERENCIAL' required='yes'>
      <cfargument name='NAO_SINISTRO' required='yes'>
      <cfargument name='KM_RODADO' required='yes'>
      <cfargument name='PUNICAO' required='yes'>
      <cfargument name='PREMIO_PAGO' required='yes'>
      <cfargument name='VIGENCIA' required='yes'>
      <cftry>
         <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_premio_valores' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PREMIO_VALORES_ID'  value='#arguments.PREMIO_VALORES_ID#'  null='#iif(len(trim(arguments.PREMIO_VALORES_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_REFERENCIAL'  value='#arguments.VALOR_REFERENCIAL#'  null='#iif(len(trim(arguments.VALOR_REFERENCIAL)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NAO_SINISTRO'  value='#arguments.NAO_SINISTRO#'  null='#iif(len(trim(arguments.NAO_SINISTRO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_KM_RODADO'  value='#arguments.KM_RODADO#'  null='#iif(len(trim(arguments.KM_RODADO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PUNICAO'  value='#arguments.PUNICAO#'  null='#iif(len(trim(arguments.PUNICAO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PREMIO_PAGO'  value='#arguments.PREMIO_PAGO#'  null='#iif(len(trim(arguments.PREMIO_PAGO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VIGENCIA'  value='#arguments.VIGENCIA#' >
         </cfstoredproc>
      	<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Item inserido com sucesso!')>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
      <cfreturn retorno />
   </cffunction>   
   
   <!--- 
	-- PROPSITO
	-- Exclui valores para premiao
	-- jonas 02/07/2009 14:59:14 - CRIADO
	--->
	<cffunction name='del_premio_valores' displayname='Exclui valores para premiao' access='remote' returntype='Struct' output='true'>
		<cfargument name='PREMIO_VALORES_ID' required='yes'>
      <cftry>
            <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_premio_valores' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
               <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PREMIO_VALORES_ID'  value='#arguments.PREMIO_VALORES_ID#'  null='#iif(len(trim(arguments.PREMIO_VALORES_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
         	<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Item inserido com sucesso!')>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere um Sinistro
    -- ANDERSONC 02/07/2009 17:13:16 - CRIADO
    --->
    <cffunction name='ins_sinistro' displayname='Insere um Sinistro' access='remote' returntype='Struct' output='true'>
        <cfargument name='SINISTRO_ID' required='yes'>
        <cfargument name='DATA_OCORRENCIA' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_MOTORISTA' required='yes'>
        <cfargument name='OCORRENCIA' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_sinistro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SINISTRO_ID'  value='#arguments.SINISTRO_ID#' variable='retorno.SINISTRO_ID'  null='#iif(len(trim(arguments.SINISTRO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_OCORRENCIA'  value='#arguments.DATA_OCORRENCIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OCORRENCIA'  value='#arguments.OCORRENCIA#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Sinistro inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera um Sinistro
    -- ANDERSONC 02/07/2009 17:14:39 - CRIADO
    --->
    <cffunction name='upd_sinistro' displayname='Altera um Sinistro' access='remote' returntype='Struct' output='true'>
        <cfargument name='SINISTRO_ID' required='yes'>
        <cfargument name='DATA_OCORRENCIA' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_MOTORISTA' required='yes'>
        <cfargument name='OCORRENCIA' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_sinistro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SINISTRO_ID'  value='#arguments.SINISTRO_ID#'  null='#iif(len(trim(arguments.SINISTRO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_OCORRENCIA'  value='#arguments.DATA_OCORRENCIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OCORRENCIA'  value='#arguments.OCORRENCIA#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Sinistro alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui um Sinistro
    -- ANDERSONC 02/07/2009 17:15:30 - CRIADO
    --->
    <cffunction name='del_sinistro' displayname='Exclui um Sinistro' access='remote' returntype='Struct' output='true'>
        <cfargument name='SINISTRO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_sinistro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SINISTRO_ID'  value='#arguments.SINISTRO_ID#'  null='#iif(len(trim(arguments.SINISTRO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Sinistro excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera uma rota de um romaneio dedicado
	-- ANDERSONC 30/11/2010 14:22:12 - CRIADO
	--->
	<cffunction name='upd_roo_operacao_dedicada' displayname='Altera uma rota de um romaneio dedicado' access='remote' returntype='Struct' output='true'>
		<cfargument name='ROMANEIO_OPERACAO_ID' required='yes'>
		<cfargument name='LOCAL_ROTA_ID' required='yes'>
		<cftry>

				<cfstoredproc procedure='oper.pkg_romaneio_dml.prc_alt_roo_operacao_dedicada' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROMANEIO_OPERACAO_ID'  value='#arguments.ROMANEIO_OPERACAO_ID#'  null='#iif(len(trim(arguments.ROMANEIO_OPERACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.LOCAL_ROTA_ID#'  null='#iif(len(trim(arguments.LOCAL_ROTA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Rota alterada com sucesso.')>

			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Conferir Viagem
	-- ANDERSONC 14/12/2010 04:28:15 - CRIADO
	--->
	<cffunction name='romaneio_ok' displayname='Conferir Viagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_romaneio_dml.prc_romaneio_ok' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Conferir Viagem
	-- ANDERSONC 14/12/2010 04:28:15 - CRIADO
	--->
	<cffunction name='conferir_viagem' displayname='Conferir Viagem' access='remote' returntype='Struct' output='true'>
		<cftry>
			<cftransaction action='begin'>
				<cfscript>
					set_rota = this.upd_roo_operacao_dedicada(ROMANEIO_OPERACAO_ID = arguments.ROMANEIO_OPERACAO_ID,
															  LOCAL_ROTA_ID		   = arguments.LOCAL_ROTA_ID);
				</cfscript>
                <cfif set_rota.erro>
                    <cfthrow object="#set_rota.mensagem#">
                </cfif>
                
                <cfscript>
					set_romaneio_ok = this.romaneio_ok(NUM_ROMANEIO = arguments.NUM_ROMANEIO);
				</cfscript>
                <cfif set_romaneio_ok.erro>
                    <cfthrow object="#set_romaneio_ok.mensagem#">
                </cfif>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Viagem conferida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Estornar OK da Viagem
	-- ANDERSONC 14/12/2010 04:29:44 - CRIADO
	--->
	<cffunction name='abre_romaneio' displayname='Estornar OK da Viagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_romaneio_dml.prc_abre_romaneio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('OK da viagem estornado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Vincula um usurio  uma operao dedicada para realizar auditoria
	-- ANDERSONC 29/12/2010 09:56:12 - CRIADO
	--->
	<cffunction name='ins_operacao_usuario_audit' displayname='Vincula um usurio  uma operao dedicada para realizar auditoria' access='remote' returntype='Struct' output='true'>
		<cfargument name='OPERACAO_ID' required='yes'>
		<cfargument name='USUARIO' required='yes'>
		<cftry>
            <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_operacao_usuario_audit' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_USUARIO_AUDIT_ID' variable='retorno.OPERACAO_USUARIO_AUDIT_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera o vnculo de um usurio com uma operao dedicada para realizar auditoria
	-- ANDERSONC 29/12/2010 09:57:34 - CRIADO
	--->
	<cffunction name='upd_operacao_usuario_audit' displayname='Altera o vnculo de um usurio com uma operao dedicada para realizar auditoria' access='remote' returntype='Struct' output='true'>
		<cfargument name='OPERACAO_USUARIO_AUDIT_ID' required='yes'>
		<cfargument name='OPERACAO_ID' required='yes'>
		<cfargument name='USUARIO' required='yes'>
		<cftry>
            <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_operacao_usuario_audit' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_USUARIO_AUDIT_ID'  value='#arguments.OPERACAO_USUARIO_AUDIT_ID#'  null='#iif(len(trim(arguments.OPERACAO_USUARIO_AUDIT_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui o vnculo de um usurio com uma operao dedicada para realizar auditoria
	-- ANDERSONC 29/12/2010 09:59:03 - CRIADO
	--->
	<cffunction name='del_operacao_usuario_audit' displayname='Exclui o vnculo de um usurio com uma operao dedicada para realizar auditoria' access='remote' returntype='Struct' output='true'>
		<cfargument name='OPERACAO_USUARIO_AUDIT_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_del_operacao_usuario_audit' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_USUARIO_AUDIT_ID'  value='#arguments.OPERACAO_USUARIO_AUDIT_ID#'  null='#iif(len(trim(arguments.OPERACAO_USUARIO_AUDIT_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Marca uma ocorrncia como lida
	-- ANDERSONC 30/12/2010 11:36:30 - CRIADO
	--->
	<cffunction name='marcar_ocorrencia_lida' displayname='Marca uma ocorrncia como lida' access='remote' returntype='Struct' output='true'>
		<cfargument name='OCORRENCIA_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_marcar_ocorrencia_lida' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OCORRENCIA_ID'  value='#arguments.OCORRENCIA_ID#'  null='#iif(len(trim(arguments.OCORRENCIA_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Marca umas ou mais ocorrncias como lidas
	-- ANDERSONC 30/12/2010 11:36:30 - CRIADO
	--->
	<cffunction name='marcar_ocorrencias_lidas' displayname='Conferir Viagem' access='remote' returntype='Struct' output='true'>
    	<cfargument name='OCORRENCIA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfloop list="#arguments.OCORRENCIA_ID#" delimiters="," index="ocorr">
                    <cfscript>
                        ret_ocorr_lida = this.marcar_ocorrencia_lida(OCORRENCIA_ID = ocorr);
                    </cfscript>
                    <cfif ret_ocorr_lida.erro>
                        <cfthrow object="#ret_ocorr_lida.mensagem#">
                    </cfif>
                </cfloop>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ocorrncia(s) lida(s) com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Vincula uma rota  uma operao dedicada
	-- ANDERSONC 11/01/2011 16:32:03 - CRIADO
	--->
	<cffunction name='ins_local_rota' displayname='Vincula uma rota  uma operao dedicada' access='remote' returntype='Struct' output='true'>
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='OPERACAO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_local_rota' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCAL_ROTA_ID' variable='retorno.LOCAL_ROTA_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Vincula rota(s)  uma operao dedicada
	-- ANDERSONC 11/01/2011 16:32:03 - CRIADO
	--->
	<cffunction name='vincula_rota_operacao_dedicada' displayname='Vincula uma rota  uma operao dedicada' access='remote' returntype='Struct' output='true'>
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='OPERACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfloop list="#arguments.ROTA_ID#" delimiters="," index="rota">
                    <cfscript>
                        ret_local_rota = this.ins_local_rota(ROTA_ID     = rota,
															 OPERACAO_ID = arguments.OPERACAO_ID);
                    </cfscript>
                    <cfif ret_local_rota.erro>
                        <cfthrow object="#ret_local_rota.mensagem#">
                    </cfif>
                </cfloop>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Rota(s) vinculada(s) com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Cancela o vnculo de uma rota com uma operao dedicada
	-- ANDERSONC 11/01/2011 16:33:47 - CRIADO
	--->
	<cffunction name='cancelar_local_rota' displayname='Cancela o vnculo de uma rota com uma operao dedicada' access='remote' returntype='Struct' output='true'>
		<cfargument name='LOCAL_ROTA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_cancelar_local_rota' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCAL_ROTA_ID'  value='#arguments.LOCAL_ROTA_ID#'  null='#iif(len(trim(arguments.LOCAL_ROTA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Rota cancelada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>