

<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de emissao de documentos" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Inserir CTE
	-- RAFAEL 28/12/2010 10:53:07 - CRIADO
	--->
	<cffunction name='ins_cte' displayname='Inserir CTE' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_CONHECIMENTO' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='NUM_PRODUTO' required='yes'>
		<cfargument name='SERIE' required='no'>
		<cfargument name='ST_ORIGEM_ID' required='yes'>
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='PAGADOR' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='COD_REDESPACHO' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='FRETE_UNITARIO' required='yes'>
		<cfargument name='FRETE_PESO' required='yes'>
		<cfargument name='FRETE_VALOR' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='BASE_CALCULO_ICMS' required='yes'>
		<cfargument name='ALIQUOTA_ICMS' required='yes'>
		<cfargument name='ADEME' required='yes'>
		<cfargument name='DESCONTO' required='yes'>
		<cfargument name='SEC_CAT' required='yes'>
		<cfargument name='GRIS' required='yes'>
		<cfargument name='PEDAGIO' required='yes'>
		<cfargument name='VALOR_ICMS' required='yes'>
		<cfargument name='VALOR_ICMS_SUBSTIT' required='yes'>
		<cfargument name='COLETA_ENTREGA' required='yes'>
		<cfargument name='IMPOSTOS' required='yes'>
		<cfargument name='TOTAL_CONHECIMENTO' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='COLETA_ENDERECO' required='yes'>
		<cfargument name='COLETA_COMPLEMENTO' required='no' default="null">
		<cfargument name='COLETA_BAIRRO' required='yes'>
		<cfargument name='COLETA_CEP' required='yes'>
		<cfargument name='COLETA_UF' required='yes'>
		<cfargument name='RED_ENDERECO' required='yes'>
		<cfargument name='RED_COMPLEMENTO' required='no' default="null">
		<cfargument name='RED_BAIRRO' required='yes'>
		<cfargument name='RED_CEP' required='yes'>
		<cfargument name='RED_UF' required='yes'>
		<cfargument name='PLACA_CONTROLE' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='NOME_MOTORISTA' required='yes'>
		<cfargument name='COD_PROPRIETARIO' required='yes'>
		<cfargument name='PROP_CNPJ_CPF' required='yes'>
		<cfargument name='PROP_RAZAO_SOCIAL' required='yes'>
		<cfargument name='PROP_ENDERECO' required='yes'>
		<cfargument name='PROP_UF' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='RODAPE' required='yes'>
		<cfargument name='ENTRADA_DADOS' required='yes'>
		<cfargument name='TIPO_CONHECIMENTO' required='no' default="0">
		<cfargument name='TEM_NOTA' required='yes'>
		<cfargument name='COLETA_MUNICIPIO_ID' required='yes'>
		<cfargument name='RED_MUNICIPIO_ID' required='yes'>
		<cfargument name='CARGA_ID' required='yes'>
		<cfargument name='COD_CLIENTE_COBRANCA' required='yes'>
		<cfargument name='COB_RAZAO_SOCIAL' required='yes'>
		<cfargument name='COB_ENDERECO' required='yes'>
		<cfargument name='COB_MUNICIPIO' required='yes'>
		<cfargument name='COB_UF' required='yes'>
		<cfargument name='COB_CEP' required='yes'>
		<cfargument name='COB_CNPJ_CPF' required='yes'>
		<cfargument name='COB_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='PRAZO_ENTREGA' required='yes'>
		<cfargument name='COD_ORGANOGRAMA_GERENCIAL' required='yes'>
		<cfargument name='REGRA_FISCAL_ID' required='yes'>
		<cfargument name='PLACA_TRACAO' required='yes'>
		<cfargument name='CONHECIMENTO_ID_SUB_CONTR' required='no' default="">
		<cfargument name='REDUCAO_BASE_ICMS' required='no' default="0">
		<cfargument name='REDUCAO_BASE_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='BASE_CALCULO_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='ALIQUOTA_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='VALOR_ICMS_PRESUMIDO' required='no' default="0">
		<cfargument name='NUM_CONHECIMENTO_SUB_CONTR' required='no' default="">
		<cfargument name='SERIE_CONHECIMENTO_SUB_CONTR' required='no' default="">
		<cfargument name='BASE_CALCULO_ISS' required='no' default="0">
		<cfargument name='ALIQUOTA_ISS' required='no' default="0">
		<cfargument name='VALOR_ISS' required='no' default="0">
		<cfargument name='VALOR_FATURAMENTO' required='no' default="0">
		<cfargument name='CFOP' required='yes'>
		<cfargument name='CFOP_ID' required='yes'>
		<cfargument name='NATUREZA_OPERACAO' required='yes'>
		<cfargument name='FUNDAMENTACAO_LEGAL' required='yes'>
		<cfargument name='COD_NEGOCIADOR' required='yes'>
		<cfargument name='PESO_KG' required='yes'>
		<cfargument name='TIPO_VENDA' required='no' default="1">
		<cfargument name='REM_ENDERECO_NUM' required='yes'>
		<cfargument name='REM_BAIRRO' required='yes'>
		<cfargument name='REM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DEST_ENDERECO_NUM' required='yes'>
		<cfargument name='DEST_BAIRRO' required='yes'>
		<cfargument name='DEST_MUNICIPIO_ID' required='yes'>
		<cfargument name='RED_ENDERECO_NUM' required='yes'>
		<cfargument name='COB_ENDERECO_NUM' required='yes'>
		<cfargument name='COB_BAIRRO' required='yes'>
		<cfargument name='COB_MUNICIPIO_ID' required='yes'>
		<cfargument name='CTRC_FATURAMENTO' required='no' default="0">
		<cfargument name='MODELO_DOCUMENTO' required='no' default="57">
		<cfargument name='TIPO_SERVICO_ID' required='no' default="0">
		<cfargument name='COLETA_COD_PESSOA' required='yes'>
		<cfargument name='COLETA_CNPJ_CPF' required='yes'>
		<cfargument name='COLETA_RAZAO_SOCIAL' required='yes'>
		<cfargument name='COLETA_ENDERECO_NUM' required='yes'>
		<cfargument name='RED_CNPJ_CPF' required='yes'>
		<cfargument name='RED_RAZAO_SOCIAL' required='yes'>
        <cfargument name='OPERACAO_ID_CTRC' required='yes'>
        <cfargument name='SUBSTITUTO' required='no' default="">
        <cfargument name='CONHECIMENTO_TIPO_ID' required='no' default="">
        <cfargument name='TERCEIRO' required='no' default="">
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
        <cfargument name='COD_ORGANIZACIONAL' required='no' default="">
        <cftry>
			<cftransaction action='begin'>
				<cfif arguments.terceiro eq 1>
					<cfset v_composicao = arguments.placa_tracao>
					<cfloop list="#arguments.placa_referencia_composicao#" index="v_pl">
						<cfset v_composicao = ListAppend(v_composicao,v_pl,',')>
					</cfloop>
                    
                    <cfif not len(trim(arguments.num_romaneio)) >
						<cfscript>
                            conn = CreateComponent("_transportes.manipulacao.cfc_contrato_transporte");
                            romaneio = conn.gera_romaneio_terceiro(	NUM_ROMANEIO		= arguments.num_romaneio,
                                                                    COMPOSICAO			= v_composicao,
                                                                    DATA_INICIO			= arguments.data_emissao,
                                                                    OPERACAO_ID			= arguments.operacao_id,
                                                                    VIAGEM_CARGA_ID		= arguments.viagem_carga_id,
                                                                    COD_MOTORISTA		= arguments.cod_motorista,
                                                                    COD_REMETENTE		= arguments.cod_remetente,
                                                                    COLETA_MUNICIPIO_ID	= arguments.coleta_municipio_id,
                                                                    COD_DESTINATARIO	= arguments.cod_destinatario,
                                                                    ENTREGA_MUNICIPIO_ID= arguments.red_municipio_id,
                                                                    VOLUME				= arguments.volume,
                                                                    PESO				= arguments.peso,
                                                                    M3					= arguments.m3,
                                                                    FRETE_VALOR			= arguments.frete_valor,
                                                                    NUM_NATUREZA		= arguments.num_natureza,
                                                                    NUM_ESPECIE			= arguments.num_especie,
                                                                    COD_UNIDADE			= arguments.cod_unidade,
                                                                    FRETE_EM			= arguments.frete_em,
                                                                    DESPACHO			= arguments.despacho,
                                                                    OBSERVACAO			= arguments.observacao,
                                                                    SUBSTITUTO			= arguments.substituto
                                                                    );
                        </cfscript>
                        <cfif romaneio.erro>
                            <cfthrow object="#romaneio.mensagem#">
                        <cfelse>
                            <cfset arguments.num_romaneio 	= romaneio.num_romaneio>
                            <cfset arguments.item_id 		= romaneio.item_id>
                        </cfif>
                    </cfif>
                    
				</cfif>
                
                <!---Inserindo uma nova entrega--->
				<cfif (arguments.item_id eq 0 or not Len(Trim(arguments.item_id))) and Len(Trim(arguments.placa_tracao)) and Len(Trim(arguments.num_romaneio))>
					<cfscript>
						conn = CreateObject("component","_transportes.manipulacao.cfc_controle_trafego");
						set_item = conn.ins_romaneio_item	(num_romaneio		= arguments.num_romaneio
															,num_lote			= arguments.num_lote
															,volume				= arguments.volume
															,cod_unidade		= arguments.cod_unidade
															,peso				= arguments.peso
															,m3					= arguments.m3
															,valor_frete		= arguments.frete_valor
															,cod_remetente		= arguments.cod_remetente
															,redespacho			= 0
															,rem_municipio_id	= arguments.rem_municipio_id
															,cod_destinatario	= arguments.cod_destinatario
															,dest_municipio_id	= arguments.dest_municipio_id
															,valor_frete_liquido= 0
															,despacho			= 0
															,observacao			= ''
															,manifesto_id		= ''
															,ordem				= arguments.ENTREGAS
															,data_previsao		= ''
															);
						
					</cfscript>
					<cfset arguments.item_id = set_item.item_id>
				</cfif>
	
				<cfif Len(Trim(arguments.placa_tracao)) and Len(Trim(arguments.num_romaneio))>
					<cfscript>
						conn = CreateObject("component","_transportes.manipulacao.cfc_controle_trafego");
						ins_rota = conn.ins_itinerario_item_romaneio(num_romaneio 		  = arguments.num_romaneio,
																	 item_id	  		  = arguments.item_id,
																	 municipio_origem_id  = arguments.coleta_municipio_id,
																	 municipio_destino_id = arguments.red_municipio_id);
					</cfscript>
					<cfif ins_rota.erro>
						<cfthrow object="#ins_rota.mensagem#">
					</cfif>
				</cfif>
                
                <cfstoredproc procedure='fiscal.pkg_cte.prc_ins_cte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_CONHECIMENTO'  value='#arguments.NUM_CONHECIMENTO#' variable='retorno.NUM_CONHECIMENTO'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#' variable='retorno.ITEM_ID'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' variable='retorno.DATA_EMISSAO' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_PRODUTO'  value='#arguments.NUM_PRODUTO#'  null='#iif(len(trim(arguments.NUM_PRODUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ORIGEM_ID'  value='0' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#arguments.ST_ICMS_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PAGADOR'  value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_REDESPACHO'  value='#arguments.COD_REDESPACHO#'  null='#iif(len(trim(arguments.COD_REDESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO'  value='#arguments.PESO#' variable='retorno.PESO'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VOLUME'  value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_UNITARIO'  value='#arguments.FRETE_UNITARIO#'  null='#iif(len(trim(arguments.FRETE_UNITARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_PESO'  value='#arguments.FRETE_PESO#'  null='#iif(len(trim(arguments.FRETE_PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_VALOR'  value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESPACHO'  value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BASE_CALCULO_ICMS'  value='#arguments.BASE_CALCULO_ICMS#'  null='#iif(len(trim(arguments.BASE_CALCULO_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALIQUOTA_ICMS'  value='#arguments.ALIQUOTA_ICMS#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ADEME'  value='#arguments.ADEME#'  null='#iif(len(trim(arguments.ADEME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCONTO'  value='#arguments.DESCONTO#'  null='#iif(len(trim(arguments.DESCONTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SEC_CAT'  value='#arguments.SEC_CAT#'  null='#iif(len(trim(arguments.SEC_CAT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRIS'  value='#arguments.GRIS#'  null='#iif(len(trim(arguments.GRIS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PEDAGIO'  value='#arguments.PEDAGIO#'  null='#iif(len(trim(arguments.PEDAGIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ICMS'  value='#arguments.VALOR_ICMS#'  null='#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ICMS_SUBSTIT'  value='#arguments.VALOR_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.VALOR_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_ENTREGA'  value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMPOSTOS'  value='#arguments.IMPOSTOS#'  null='#iif(len(trim(arguments.IMPOSTOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TOTAL_CONHECIMENTO'  value='#arguments.TOTAL_CONHECIMENTO#'  null='#iif(len(trim(arguments.TOTAL_CONHECIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_LOGRADOURO'  value='#arguments.COLETA_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_COMPLEMENTO'  value='#arguments.COLETA_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_BAIRRO'  value='#arguments.COLETA_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_CEP'  value='#arguments.COLETA_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_UF'  value='#arguments.COLETA_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_LOGRADOURO'  value='#arguments.RED_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_COMPLEMENTO'  value='#arguments.RED_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_BAIRRO'  value='#arguments.RED_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_CEP'  value='#arguments.RED_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_UF'  value='#arguments.RED_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA_REFERENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_MOTORISTA'  value='#arguments.NOME_MOTORISTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROPRIETARIO'  value='#arguments.COD_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RODAPE'  value='#arguments.RODAPE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTRADA_DADOS'  value='2'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_CONHECIMENTO'  value='#arguments.TIPO_CONHECIMENTO#'  null='#iif(len(trim(arguments.TIPO_CONHECIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID' variable='retorno.CONHECIMENTO_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TEM_NOTA'  value='1'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_MUNICIPIO_ID'  value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_MUNICIPIO_ID'  value='#arguments.RED_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.RED_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_ID'  value='#arguments.CARGA_ID#'  null='#iif(len(trim(arguments.CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CLIENTE_COBRANCA'  value='#arguments.COD_CLIENTE_COBRANCA#'  null='#iif(len(trim(arguments.COD_CLIENTE_COBRANCA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PRAZO_ENTREGA'  value='#arguments.PRAZO_ENTREGA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANOGRAMA_GERENCIAL'  value='#arguments.COD_ORGANOGRAMA_GERENCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGRA_FISCAL_ID'  value='#arguments.REGRA_FISCAL_ID#'  null='#iif(len(trim(arguments.REGRA_FISCAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_TRACAO'  value='#arguments.PLACA_TRACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID_SUB_CONTR'  value='#arguments.CONHECIMENTO_ID_SUB_CONTR#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID_SUB_CONTR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REDUCAO_BASE_ICMS' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REDUCAO_BASE_ICMS_SUBSTIT' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BASE_CALCULO_ICMS_SUBSTIT' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALIQUOTA_ICMS_SUBSTIT' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ICMS_PRESUMIDO' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_CONHECIMENTO_SUB_CONTR'  value='#arguments.NUM_CONHECIMENTO_SUB_CONTR#'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO_SUB_CONTR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE_CONHECIMENTO_SUB_CONTR'  value='#arguments.SERIE_CONHECIMENTO_SUB_CONTR#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BASE_CALCULO_ISS' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALIQUOTA_ISS' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ISS' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_FATURAMENTO' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CFOP'  value='#arguments.CFOP#'  null='#iif(len(trim(arguments.CFOP)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP_ID'  value='#arguments.CFOP_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_OPERACAO'  value='#arguments.NATUREZA_OPERACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FUNDAMENTACAO_LEGAL'  value='#arguments.FUNDAMENTACAO_LEGAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_NEGOCIADOR'  value='#arguments.COD_NEGOCIADOR#'  null='#iif(len(trim(arguments.COD_NEGOCIADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_REAL'  value='#arguments.PESO_KG#'  null='#iif(len(trim(arguments.PESO_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_VENDA'  value='#arguments.TIPO_VENDA#'  null='#iif(len(trim(arguments.TIPO_VENDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FATURADO' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_ENDERECO_NUM'  value='#arguments.REM_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_BAIRRO'  value='#arguments.REM_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REM_MUNICIPIO_ID'  value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_ENDERECO_NUM'  value='#arguments.DEST_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_BAIRRO'  value='#arguments.DEST_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEST_MUNICIPIO_ID' value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_ENDERECO_NUM' value='' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_BAIRRO' value='' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONS_MUNICIPIO_ID' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_ENDERECO_NUM'  value='#arguments.RED_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_BAIRRO'  value='#arguments.RED_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RED_MUNICIPIO_ID'  value='#arguments.RED_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.RED_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_ENDERECO_NUM'  value='#arguments.COB_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COB_MUNICIPIO_ID'  value='#arguments.COB_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COB_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MODELO_DOCUMENTO'  value='#arguments.MODELO_DOCUMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_SERVICO_ID'  value='#arguments.TIPO_SERVICO_ID#'  null='#iif(len(trim(arguments.TIPO_SERVICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_PESSOA'  value='#arguments.COLETA_COD_PESSOA#'  null='#iif(len(trim(arguments.COLETA_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_CNPJ_CPF'  value='#arguments.COLETA_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_RAZAO_SOCIAL'  value='#arguments.COLETA_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_NUM'  value='#arguments.COLETA_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_PESSOA'  value='#arguments.COD_REDESPACHO#' null='#iif(len(trim(arguments.COD_REDESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_CNPJ_CPF'  value='#arguments.RED_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_RAZAO_SOCIAL'  value='#arguments.RED_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_NUM'  value='#arguments.RED_ENDERECO_NUM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID_CTRC#' null='#iif(len(trim(arguments.OPERACAO_ID_CTRC)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SUBSTITUTO'  value='#arguments.SUBSTITUTO#' null='#iif(len(trim(arguments.SUBSTITUTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_TIPO_ID'  value='#arguments.CONHECIMENTO_TIPO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_TIPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORGANIZACIONAL_ID'  value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANIZACIONAL'  value='#arguments.COD_ORGANIZACIONAL#' >
				</cfstoredproc>
				
                <cfset arguments.conhecimento_id = retorno.conhecimento_id>
                <cfset retorno.num_romaneio 	= arguments.num_romaneio>
                    
				<!--- Insere Notas--->
                <cfscript>
                    ins_notas = this.ins_nfs_cte(argumentCollection = arguments);
                </cfscript>
                <cfif ins_notas.erro>
                    <cfthrow object="#ins_notas.mensagem#">
                </cfif>
                
                <!--- Verifica se para esse negociador  emitido por tabela de frete. Caso seja, aplica a tabela de frete --->
                <cfif arguments.EMITE_TABELA_FRETE eq 1>
                	<cfscript>
						if(IsDefined('arguments.PLACA_REFERENCIA_INTERNA')) {
							v_placa_referencia_interna = Replace(arguments.PLACA_REFERENCIA_INTERNA, ',', ' > ', 'all');
						}
						else {
							v_placa_referencia_interna = '';
						}
						
						conn_cons_tf = CreateComponent("_transportes.consulta.comercial.cfc_tabela_frete");
						qrTabelaFreteRotaId = conn_cons_tf.get_tabela_frete_rota_id(ORIGEM_MUNICIPIO_ID  = arguments.COLETA_MUNICIPIO_ID,
																					DESTINO_MUNICIPIO_ID = iif(arguments.FRETE_ULT_ENTREGA eq 0, de(arguments.red_municipio_id), de(arguments.MUNICIPIO_ULT_ENTREGA_ID)),
																					COD_NEGOCIADOR       = arguments.COD_NEGOCIADOR,
																					NUM_NATUREZA		 = arguments.NUM_NATUREZA,
																					COMPOSICAO			 = arguments.PLACA_TRACAO & ' > ' & v_placa_referencia_interna);
					</cfscript>
					<cfif qrTabelaFreteRotaId.erro>
						<cfthrow object="#qrTabelaFreteRotaId.mensagem#">
					</cfif>
					
					<cfscript>
						conn_cons_doc = CreateComponent("_transportes.consulta.cfc_emissao_documentos");
						qrDadosFiscais = conn_cons_doc.get_ctrc_dados_fiscais(NUM_ROMANEIO 		   = arguments.NUM_ROMANEIO,
																	 		  ITEM_ID 			   = arguments.ITEM_ID,
																			  COD_DESTINATARIO 	   = arguments.COD_DESTINATARIO,
																			  PRODUTO_ID  		   = arguments.NUM_PRODUTO,
																			  PAGO_POR 			   = arguments.PAGADOR,
																			  COLETA_UF 		   = arguments.COLETA_UF,
																			  ENTREGA_UF 		   = arguments.RED_UF,
																			  ST_ICMS_ID 		   = arguments.ST_ICMS_ID,
																			  COD_REMETENTE 	   = arguments.COD_REMETENTE,
																			  REGRA_FISCAL_ID 	   = arguments.REGRA_FISCAL,
																			  COB_UF 			   = arguments.COB_UF,
																			  COLETA_MUNICIPIO_ID  = arguments.COLETA_MUNICIPIO_ID,
																			  ENTREGA_MUNICIPIO_ID = iif(arguments.FRETE_ULT_ENTREGA eq 0, de(arguments.red_municipio_id), de(arguments.MUNICIPIO_ULT_ENTREGA_ID)),
																			  VIAGEM_CARGA_ID 	   = arguments.VIAGEM_CARGA_ID,
																			  COD_CLIENTE_COBRANCA = arguments.COD_CLIENTE_COBRANCA,
																			  UF_FILIAL 		   = arguments.UF_FILIAL_EMISSAO,
																			  NOTA_FISCAL 		   = 0);
					</cfscript>
					<cfif qrDadosFiscais.erro>
						<cfthrow object="#qrDadosFiscais.mensagem#">
					</cfif>
                    
                    <cfscript>
						conn_cons_vei = CreateComponent("_transportes.consulta.cfc_veiculo");
						qrNumeroEixos = conn_cons_vei.get_numero_eixos_composicao(PLACA = arguments.PLACA_TRACAO & ' > ' & v_placa_referencia_interna);
					</cfscript>
					<cfif qrNumeroEixos.erro>
						<cfthrow object="#qrNumeroEixos.mensagem#">
					</cfif>
                    
                    <cfscript>
						// Constantes
						arguments.CONSTANTE_VIAGEM_CARGA_ID		  = arguments.VIAGEM_CARGA_ID;
						arguments.CONSTANTE_PESO_BRUTO            = arguments.PESO_KG;
						arguments.CONSTANTE_PESO_COBRADO          = arguments.PESO;
						arguments.CONSTANTE_VALOR_MERCADORIA      = arguments.VALOR_MERCADORIA;
						arguments.CONSTANTE_MUNICIPIO_ID_ORIGEM   = arguments.COLETA_MUNICIPIO_ID;
						arguments.CONSTANTE_MUNICIPIO_ID_DESTINO  = iif(arguments.FRETE_ULT_ENTREGA eq 0, de(arguments.red_municipio_id), de(arguments.MUNICIPIO_ULT_ENTREGA_ID));
						arguments.CONSTANTE_FRETE_PROPRIO		  = qrDadosFiscais.FRETE_PROPRIO;
						arguments.CONSTANTE_UF_TOMADOR			  = qrDadosFiscais.TOMADOR_UF;
						arguments.CONSTANTE_COD_ATIVIDADE_TOMADOR = qrDadosFiscais.COD_ATIVIDADE_TOMADOR;
						arguments.CONSTANTE_ST_ICMS_ID			  = Trim(arguments.ST_ICMS_ID);
						arguments.CONSTANTE_PLACA_TRACAO	 	  = arguments.PLACA_CONTROLE;
						
						if(v_placa_referencia_interna eq '') {
							arguments.CONSTANTE_PLACA_CARRETA = '';
						}
						else {
							arguments.CONSTANTE_PLACA_CARRETA = ListGetAt(v_placa_referencia_interna, 1, ' > ');
						}
						
						arguments.CONSTANTE_NRO_EIXOS = qrNumeroEixos.EIXOS;
						// ----------
					</cfscript>
                    
                    <cfscript>
						qrTabelaFreteRota = conn_cons_tf.get_tabela_frete_rota(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
						qrConstante 	  = conn_cons_tf.get_constante();
						qrVariavel  	  = conn_cons_tf.get_tabela_frete_variavel(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
						
						conn_manip_tf = CreateComponent("_transportes.manipulacao.comercial.cfc_tabela_frete");
					</cfscript>
					
					<cfloop query="qrConstante">
						<cfscript>
							ret_cons = conn_manip_tf.set_constante(COD_CONSTANTE = qrConstante.COD_CONSTANTE,
														  		   VALOR		 = iif(IsDefined('arguments.CONSTANTE_#qrConstante.COD_CONSTANTE#'), de(arguments['CONSTANTE_' & qrConstante.COD_CONSTANTE]), de(qrConstante.VALOR_DEFAULT)));
						</cfscript>
						<cfif ret_cons.erro>
							<cfthrow object="#ret_cons.mensagem#">
						</cfif>
					</cfloop>
					
					<cfscript>
						ret_cons_tf = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ID',
														 		  VALOR		    = qrTabelaFreteRota.TABELA_FRETE_ID);
					</cfscript>
					<cfif ret_cons_tf.erro>
						<cfthrow object="#ret_cons_tf.mensagem#">
					</cfif>
					
					<cfscript>
						ret_cons_tfr = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ROTA_ID',
														  		   VALOR		 = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
					</cfscript>
					<cfif ret_cons_tfr.erro>
						<cfthrow object="#ret_cons_tfr.mensagem#">
					</cfif>
					
					<cfloop query="qrVariavel">
						<cfscript>
							ret_var = conn_manip_tf.ins_tabela_frete_var_temp(TABELA_FRETE_ID 		   = qrVariavel.TABELA_FRETE_ID,
																	 		  TABELA_FRETE_ROTA_ID 	   = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID,
																	 		  TABELA_FRETE_VARIAVEL_ID = qrVariavel.TABELA_FRETE_VARIAVEL_ID,
																	 		  VALOR					   = iif(IsDefined('arguments.VARIAVEl_#qrVariavel.COD_VARIAVEL#'), de(arguments['VARIAVEl_' & qrVariavel.COD_VARIAVEL]), de(qrVariavel.VALOR)));
						</cfscript>
						<cfif ret_var.erro>
							<cfthrow object="#ret_var.mensagem#">
						</cfif>
					</cfloop>
                    
                    <cfscript>
						conn_manip_ed = CreateComponent("_transportes.manipulacao.cfc_emissao_documentos");
						
						ret_calc = conn_manip_ed.calcula_ctrc_tabela_frete(CONHECIMENTO_ID = retorno.CONHECIMENTO_ID,
																  		   TABELA_FRETE_ID = qrTabelaFreteRota.TABELA_FRETE_ID);
					</cfscript>
					<cfif ret_calc.erro>
						<cfthrow object="#ret_calc.mensagem#">
					</cfif>
                </cfif>
                <!--- /// --->
                
                <!--- Envia CTE para SEFAZ--->
                <cfscript>
                    envia_cte = this.envia_cte(conhecimento_id = retorno.conhecimento_id);
                </cfscript>
                <cfif envia_cte.erro>
                    <cfthrow object="#envia_cte.mensagem#">
                </cfif>
					
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CTE inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
    <!--- 
	-- PROPSITO
	-- Inserir Nota Fiscal a CTE
	-- RAFAEL 28/12/2010 09:15:53 - CRIADO
	--->
	<cffunction name='ins_nf_cte' displayname='Inserir Nota Fiscal a CTE' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='NUMERO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='MODELO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='SUB_SERIE' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
		<cfargument name='NF_ELETRONICA' required='yes'>
		<cfargument name='VALOR_SEGURADO' required='yes'>
		<cfargument name='ORDEM_COMPRA_CLIENTE' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='PESO_CUBADO' required='yes'>
		<cfargument name='PESO_COBRADO' required='yes'>
		<cfargument name='QTDE_VOLUME' required='yes'>
		<cfargument name='ALTURA' required='yes'>
		<cfargument name='COMPRIMENTO' required='yes'>
		<cfargument name='LARGURA' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='CUBAGEM' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='COMPLEMENTO' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='TIPO_DOCUMENTO_ID' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='VALOR_BASE_CALCULO_ICMS' required='yes'>
		<cfargument name='VALOR_ICMS' required='yes'>
		<cfargument name='VALOR_BASE_CALCULO_ICMS_ST' required='yes'>
		<cfargument name='VALOR_ICMS_ST' required='yes'>
		<cfargument name='VALOR_PRODUTOS' required='yes'>
		<cfargument name='CFOP' required='yes'>
		<cfargument name='PIN_SUFRAMA' required='yes'>
		<cfargument name='CHAVE_ACESSO_NFE' required='yes'>
		<cfargument name='DESCRICAO_DOCTO' required='yes'>
		<cfargument name='NFE_XML' required='no' default="">
		<cfargument name='VERIFICAR_NF' required='no' default="1">
        <cfargument name='DOCUMENTO_ID' required='no' default="">
		<cftry>
			<cfstoredproc procedure='fiscal.pkg_cte.prc_ins_nf_cte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUMERO'  value='#arguments.NUMERO#'  null='#iif(len(trim(arguments.NUMERO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MODELO'  value='#arguments.MODELO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUB_SERIE'  value='#arguments.SUB_SERIE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_ELETRONICA'  value='#arguments.NF_ELETRONICA#'  null='#iif(len(trim(arguments.NF_ELETRONICA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_SEGURADO'  value='#arguments.VALOR_SEGURADO#'  null='#iif(len(trim(arguments.VALOR_SEGURADO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ORDEM_COMPRA_CLIENTE'  value='#arguments.ORDEM_COMPRA_CLIENTE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO'  value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_CUBADO'  value='#arguments.PESO_CUBADO#'  null='#iif(len(trim(arguments.PESO_CUBADO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_COBRADO'  value='#arguments.PESO_COBRADO#'  null='#iif(len(trim(arguments.PESO_COBRADO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_VOLUME'  value='#arguments.QTDE_VOLUME#'  null='#iif(len(trim(arguments.QTDE_VOLUME)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTURA'  value='#arguments.ALTURA#'  null='#iif(len(trim(arguments.ALTURA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COMPRIMENTO'  value='#arguments.COMPRIMENTO#'  null='#iif(len(trim(arguments.COMPRIMENTO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LARGURA'  value='#arguments.LARGURA#'  null='#iif(len(trim(arguments.LARGURA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CUBAGEM'  value='#arguments.CUBAGEM#'  null='#iif(len(trim(arguments.CUBAGEM)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DOCUMENTO_ID'  value='#arguments.TIPO_DOCUMENTO_ID#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_BASE_CALCULO_ICMS'  value='#arguments.VALOR_BASE_CALCULO_ICMS#'  null='#iif(len(trim(arguments.VALOR_BASE_CALCULO_ICMS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ICMS'  value='#arguments.VALOR_ICMS#'  null='#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_BASE_CALCULO_ICMS_ST'  value='#arguments.VALOR_BASE_CALCULO_ICMS_ST#'  null='#iif(len(trim(arguments.VALOR_BASE_CALCULO_ICMS_ST)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ICMS_ST'  value='#arguments.VALOR_ICMS_ST#'  null='#iif(len(trim(arguments.VALOR_ICMS_ST)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_PRODUTOS'  value='#arguments.VALOR_PRODUTOS#'  null='#iif(len(trim(arguments.VALOR_PRODUTOS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP'  value='#arguments.CFOP#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PIN_SUFRAMA'  value='#arguments.PIN_SUFRAMA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CHAVE_ACESSO_NFE'  value='#arguments.CHAVE_ACESSO_NFE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_DOCTO'  value='#arguments.DESCRICAO_DOCTO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_NFE_XML'  value='#arguments.NFE_XML#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERIFICA_NF'  value='#arguments.VERIFICAR_NF#'  null='#iif(len(trim(arguments.VERIFICAR_NF)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
			<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Busca Chave da NFE
	-- RAFAEL 16/07/2010 14:11:15 - CRIADO
	--->
	<cffunction name='busca_chave_nfe' displayname='Busca Chave da NFE' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTEUDO' required='yes'>
		<cftry>
        	<!---L o arquivo--->
            <cffile action="read" file="#arguments.CONTEUDO#" variable="VARQUIVO">
            
            <!---Busca os dados da NFE--->
            <cfscript>
				conn = CreateComponent("_transportes.consulta.cfc_cte");
			</cfscript>
            
            <cfscript>
				dados = conn.get_nfe_dados(NFE = VARQUIVO);
			</cfscript>
			<cfif dados.erro>
				<cfthrow object="#dados.mensagem#">
			<cfelse>
            	<cfset retorno.chave = dados.chave>
                <cfset retorno.numero = dados.numero>
                <cfset retorno.serie = dados.serie>
                <cfset retorno.data_emissao = dados.data_emissao>
                <cfset retorno.cnpj_emitente = dados.cnpj_emitente>
                <cfset retorno.emitente = dados.emitente>
                <cfset retorno.cnpj_destinatario = dados.cnpj_destinatario>
                <cfset retorno.destinatario = dados.destinatario>
                <cfset retorno.valor = replace(replace(dados.valor,',','.','all'),',''.','all')><!---                
                <cfset retorno.peso = replace(replace(dados.peso,',','.','all'),',''.','all')>
                <cfset retorno.especie = dados.especie>
                <cfset retorno.quantidade = dados.quantidade>
                <cfset retorno.quantidade_volumes = replace(replace(dados.quantidade_volumes,',','.','all'),',''.','all')>
                <cfset retorno.unidade = dados.unidade>--->
            </cfif>
            
			<!---Envia o Arquivo para o Servidor--->
            <cffile action="upload" destination="#expandPath("/")#temp" file="#arguments.CONTEUDO#" nameconflict="makeunique" result="VCONTEUDO" filefield="CONTEUDO">
            
            <cfset retorno.nome_arquivo = VCONTEUDO.serverfile>
            <cfset retorno.erro = false>
            <cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Enviar CTE para SEFAZ
	-- RAFAEL 27/07/2010 09:39:17 - CRIADO
	--->
	<cffunction name='envia_cte' displayname='Enviar CTE para SEFAZ' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_cte.prc_envia_cte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Atualizar o status do CTE
	-- RAFAEL 27/07/2010 14:01:21 - CRIADO
	--->
	<cffunction name='consulta_status' displayname='Atualizar o status do CTE' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte.prc_consulta_status' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
                
                <cfscript>
					conn = CreateComponent("_transportes.consulta..cfc_cte");
					qrStatus = conn.get_cte_resumo(CONHECIMENTO_ID = arguments.CONHECIMENTO_ID);
				</cfscript>
                <cfset retorno.cod_status = qrStatus.cod_status>
                <cfset retorno.situacao_id = qrStatus.situacao_id>
                <cfset retorno.descricao_status = qrStatus.descricao_status>
                <cfset retorno.permite_editar = qrStatus.permite_editar>
                <cfset retorno.emitido = qrStatus.emitido>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Status do CTE atualizado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Atualizar os dados do CTE e Reenvia para SEFAZ
	-- RAFAEL 27/07/2010 14:40:12 - CRIADO
	--->
	<cffunction name='atualiza_cte' displayname='Atualizar os dados do CTE' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte.prc_atualiza_cte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
                
                <!--- Envia CTE para SEFAZ--->
                <cfscript>
					envia_cte = this.envia_cte(conhecimento_id = arguments.conhecimento_id);
				</cfscript>
				<cfif envia_cte.erro>
					<cfthrow object="#envia_cte.mensagem#">
				</cfif>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CTE reenviado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Cancelar CTE
	-- RAFAEL 03/08/2010 17:03:33 - CRIADO
	--->
	<cffunction name='cancela_cte' displayname='Cancelar CTE' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte.prc_can_cte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO'  value='Cancelado pelo site' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CTE cancelado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inutiliza a Numerao do CTE
	-- RAFAEL 30/11/2010 10:08:26 - CRIADO
	--->
	<cffunction name='prc_inutilizar_cte' displayname='Inutiliza a Numerao do CTE' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='MOTIVO' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte.prc_inutilizar_cte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO'  value='#arguments.MOTIVO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CTE inutilizado.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Gerar PDF do DACTE
	-- RAFAEL 10/09/2010 14:54:31 - CRIADO
	--->
	<cffunction name='gerar_dacte' displayname='Gerar PDF do DACTE' access='remote' returntype='Struct' output='true'>
		<cfargument name='DOCUMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_impressao_cte.prc_gerar_dacte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB' dbvarname='P_ARQUIVO' variable='retorno.ARQUIVO' >
				</cfstoredproc>                
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Dacte gerado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Enviar email contendo o XML e o DACTE
	-- RAFAEL 22/09/2010 08:48:42 - CRIADO
	--->
	<cffunction name='envia_email' displayname='Enviar email contendo o XML e o DACTE' access='remote' returntype='Struct' output='true'>
		<cfargument name='DOCUMENTO_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='TIPO_EMAIL' required='yes'>
		<cfargument name='EMAIL' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte_email.prc_envia_email' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO'  value='#arguments.TIPO_EMAIL#'  null='#iif(len(trim(arguments.TIPO_EMAIL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL'  value='#arguments.EMAIL#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('E-mail gerado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Gerar CTE de Complemento
	-- RAFAEL 01/04/2011 11:43:11 - CRIADO
	--->
	<cffunction name='gera_cte_complemento' displayname='Gerar CTE de Complemento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID_COMPLEM' required='yes'>
		<cfargument name='NUM_CONHECIMENTO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='FRETE_UNITARIO' required='yes'>
		<cfargument name='FRETE_PESO' required='yes'>
		<cfargument name='FRETE_VALOR' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='BASE_CALCULO_ICMS' required='yes'>
		<cfargument name='ALIQUOTA_ICMS' required='yes'>
		<cfargument name='ADEME' required='yes'>
		<cfargument name='DESCONTO' required='yes'>
		<cfargument name='SEC_CAT' required='yes'>
		<cfargument name='GRIS' required='yes'>
		<cfargument name='PEDAGIO' required='yes'>
		<cfargument name='VALOR_ICMS' required='yes'>
		<cfargument name='VALOR_ICMS_SUBSTIT' required='yes'>
		<cfargument name='COLETA_ENTREGA' required='yes'>
		<cfargument name='IMPOSTOS' required='yes'>
		<cfargument name='TOTAL_CONHECIMENTO' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='PAGADOR' required='yes'>
		<cfargument name='REDUCAO_BASE_ICMS' required='no' default="0">
		<cfargument name='REDUCAO_BASE_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='BASE_CALCULO_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='ALIQUOTA_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='VALOR_ICMS_PRESUMIDO' required='no' default="0">
        <cfargument name='ST_ICMS_ID' required='no' default=''>
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
        <cfargument name='COD_ORGANIZACIONAL' required='no' default="">
        <cfargument name='CONHECIMENTO_TIPO_ID' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte.prc_gera_cte_complemento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID_COMPLEMENTO'  value='#arguments.CONHECIMENTO_ID_COMPLEM#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID_COMPLEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_CONHECIMENTO'  value='#arguments.NUM_CONHECIMENTO#'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' variable='retorno.DATA_EMISSAO' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO'  value='#arguments.PESO#' variable='retorno.PESO'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VOLUME'  value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_UNITARIO'  value='#arguments.FRETE_UNITARIO#'  null='#iif(len(trim(arguments.FRETE_UNITARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_PESO'  value='#arguments.FRETE_PESO#'  null='#iif(len(trim(arguments.FRETE_PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_VALOR'  value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESPACHO'  value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BASE_CALCULO_ICMS'  value='#arguments.BASE_CALCULO_ICMS#'  null='#iif(len(trim(arguments.BASE_CALCULO_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALIQUOTA_ICMS'  value='#arguments.ALIQUOTA_ICMS#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ADEME'  value='#arguments.ADEME#'  null='#iif(len(trim(arguments.ADEME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCONTO'  value='#arguments.DESCONTO#'  null='#iif(len(trim(arguments.DESCONTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SEC_CAT'  value='#arguments.SEC_CAT#'  null='#iif(len(trim(arguments.SEC_CAT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRIS'  value='#arguments.GRIS#'  null='#iif(len(trim(arguments.GRIS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PEDAGIO'  value='#arguments.PEDAGIO#'  null='#iif(len(trim(arguments.PEDAGIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ICMS'  value='#arguments.VALOR_ICMS#'  null='#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ICMS_SUBSTIT'  value='#arguments.VALOR_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.VALOR_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_ENTREGA'  value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMPOSTOS'  value='#arguments.IMPOSTOS#'  null='#iif(len(trim(arguments.IMPOSTOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TOTAL_CONHECIMENTO'  value='#arguments.TOTAL_CONHECIMENTO#'  null='#iif(len(trim(arguments.TOTAL_CONHECIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID' variable='retorno.CONHECIMENTO_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RELACAO_ID' variable='retorno.RELACAO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PAGADOR'  value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REDUCAO_BASE_ICMS'  value='#arguments.REDUCAO_BASE_ICMS#'  null='#iif(len(trim(arguments.REDUCAO_BASE_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REDUCAO_BASE_ICMS_SUBSTIT'  value='#arguments.REDUCAO_BASE_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.REDUCAO_BASE_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BASE_CALCULO_ICMS_SUBSTIT'  value='#arguments.BASE_CALCULO_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.BASE_CALCULO_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALIQUOTA_ICMS_SUBSTIT'  value='#arguments.ALIQUOTA_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ICMS_PRESUMIDO'  value='#arguments.VALOR_ICMS_PRESUMIDO#'  null='#iif(len(trim(arguments.VALOR_ICMS_PRESUMIDO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#Trim(arguments.ST_ICMS_ID)#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORGANIZACIONAL_ID'  value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANIZACIONAL'  value='#arguments.COD_ORGANIZACIONAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_TIPO_ID'  value='#arguments.CONHECIMENTO_TIPO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_TIPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
                
                <!--- Vicnula CTe ao Romaneio--->
				<cfscript>
                    connEmiDoc = CreateComponent("_transportes.manipulacao.cfc_emissao_documentos");
					vincula_romaneio = connEmiDoc.vincula_conhecimento_romaneio(num_romaneio			= arguments.COMPLEMENTO_NUM_ROMANEIO
																			   ,item_id					= arguments.COMPLEMENTO_ROMANEIO_ITEM_ID
																			   ,conhecimento_id			= retorno.conhecimento_id
																			   ,proprietario_consulta	= ''
																			   ,composicao				= ''
																			   ,num_lote				= ''
																			   ,vincular				= 'ROMANEIO');
                </cfscript>
                <cfif vincula_romaneio.erro>
                    <cfthrow object="#vincula_romaneio.mensagem#">
                </cfif>
				
				<!--- Envia CTE para SEFAZ--->
				<cfscript>
                    envia_cte = this.envia_cte(conhecimento_id = retorno.conhecimento_id);
                </cfscript>
                <cfif envia_cte.erro>
                    <cfthrow object="#envia_cte.mensagem#">
                </cfif>                
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Complemento de CTE gerado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Liberar o CTe para impresso
	-- RAFAEL 30/06/2011 19:00:22 - CRIADO
	--->
	<cffunction name='cte_liberado_impressao' displayname='Liberar o CTe para impresso' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte.prc_cte_liberado_impressao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CTe liberado para impresso com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Efetua edio do CTe
	-- RAFAEL 01/07/2011 10:55:23 - CRIADO
	--->
	<cffunction name='alt_cte' displayname='Efetua edio do CTe' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_CONHECIMENTO' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='NUM_PRODUTO' required='yes'>
		<cfargument name='SERIE' required='no'>
		<cfargument name='ST_ORIGEM_ID' required='yes'>
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='PAGADOR' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='COD_REDESPACHO' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='FRETE_UNITARIO' required='yes'>
		<cfargument name='FRETE_PESO' required='yes'>
		<cfargument name='FRETE_VALOR' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='BASE_CALCULO_ICMS' required='yes'>
		<cfargument name='ALIQUOTA_ICMS' required='yes'>
		<cfargument name='ADEME' required='yes'>
		<cfargument name='DESCONTO' required='yes'>
		<cfargument name='SEC_CAT' required='yes'>
		<cfargument name='GRIS' required='yes'>
		<cfargument name='PEDAGIO' required='yes'>
		<cfargument name='VALOR_ICMS' required='yes'>
		<cfargument name='VALOR_ICMS_SUBSTIT' required='yes'>
		<cfargument name='COLETA_ENTREGA' required='yes'>
		<cfargument name='IMPOSTOS' required='yes'>
		<cfargument name='TOTAL_CONHECIMENTO' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='COLETA_ENDERECO' required='yes'>
		<cfargument name='COLETA_COMPLEMENTO' required='no' default="null">
		<cfargument name='COLETA_BAIRRO' required='yes'>
		<cfargument name='COLETA_CEP' required='yes'>
		<cfargument name='COLETA_UF' required='yes'>
		<cfargument name='RED_ENDERECO' required='yes'>
		<cfargument name='RED_COMPLEMENTO' required='no' default="null">
		<cfargument name='RED_BAIRRO' required='yes'>
		<cfargument name='RED_CEP' required='yes'>
		<cfargument name='RED_UF' required='yes'>
		<cfargument name='PLACA_CONTROLE' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='NOME_MOTORISTA' required='yes'>
		<cfargument name='COD_PROPRIETARIO' required='yes'>
		<cfargument name='PROP_CNPJ_CPF' required='yes'>
		<cfargument name='PROP_RAZAO_SOCIAL' required='yes'>
		<cfargument name='PROP_ENDERECO' required='yes'>
		<cfargument name='PROP_UF' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='RODAPE' required='yes'>
		<cfargument name='ENTRADA_DADOS' required='yes'>
		<cfargument name='TIPO_CONHECIMENTO' required='no' default="0">
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='TEM_NOTA' required='yes'>
		<cfargument name='COLETA_MUNICIPIO_ID' required='yes'>
		<cfargument name='RED_MUNICIPIO_ID' required='yes'>
		<cfargument name='CARGA_ID' required='yes'>
		<cfargument name='COD_CLIENTE_COBRANCA' required='yes'>
		<cfargument name='COB_RAZAO_SOCIAL' required='yes'>
		<cfargument name='COB_ENDERECO' required='yes'>
		<cfargument name='COB_MUNICIPIO' required='yes'>
		<cfargument name='COB_UF' required='yes'>
		<cfargument name='COB_CEP' required='yes'>
		<cfargument name='COB_CNPJ_CPF' required='yes'>
		<cfargument name='COB_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='PRAZO_ENTREGA' required='yes'>
		<cfargument name='COD_ORGANOGRAMA_GERENCIAL' required='yes'>
		<cfargument name='REGRA_FISCAL_ID' required='yes'>
		<cfargument name='PLACA_TRACAO' required='yes'>
		<cfargument name='CONHECIMENTO_ID_SUB_CONTR' required='no' default="">
		<cfargument name='REDUCAO_BASE_ICMS' required='no' default="0">
		<cfargument name='REDUCAO_BASE_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='BASE_CALCULO_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='ALIQUOTA_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='VALOR_ICMS_PRESUMIDO' required='no' default="0">
		<cfargument name='NUM_CONHECIMENTO_SUB_CONTR' required='no' default="">
		<cfargument name='SERIE_CONHECIMENTO_SUB_CONTR' required='no' default="">
		<cfargument name='BASE_CALCULO_ISS' required='no' default="0">
		<cfargument name='ALIQUOTA_ISS' required='no' default="0">
		<cfargument name='VALOR_ISS' required='no' default="0">
		<cfargument name='VALOR_FATURAMENTO' required='no' default="0">
		<cfargument name='CFOP' required='yes'>
		<cfargument name='CFOP_ID' required='yes'>
		<cfargument name='NATUREZA_OPERACAO' required='yes'>
		<cfargument name='FUNDAMENTACAO_LEGAL' required='yes'>
		<cfargument name='COD_NEGOCIADOR' required='yes'>
		<cfargument name='PESO_KG' required='yes'>
		<cfargument name='TIPO_VENDA' required='no' default="1">
		<cfargument name='REM_ENDERECO_NUM' required='yes'>
		<cfargument name='REM_BAIRRO' required='yes'>
		<cfargument name='REM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DEST_ENDERECO_NUM' required='yes'>
		<cfargument name='DEST_BAIRRO' required='yes'>
		<cfargument name='DEST_MUNICIPIO_ID' required='yes'>
		<cfargument name='RED_ENDERECO_NUM' required='yes'>
		<cfargument name='COB_ENDERECO_NUM' required='yes'>
		<cfargument name='COB_BAIRRO' required='yes'>
		<cfargument name='COB_MUNICIPIO_ID' required='yes'>
		<cfargument name='CTRC_FATURAMENTO' required='no' default="0">
		<cfargument name='MODELO_DOCUMENTO' required='no' default="57">
		<cfargument name='TIPO_SERVICO_ID' required='no' default="0">
		<cfargument name='COLETA_COD_PESSOA' required='yes'>
		<cfargument name='COLETA_CNPJ_CPF' required='yes'>
		<cfargument name='COLETA_RAZAO_SOCIAL' required='yes'>
		<cfargument name='COLETA_ENDERECO_NUM' required='yes'>
		<cfargument name='RED_CNPJ_CPF' required='yes'>
		<cfargument name='RED_RAZAO_SOCIAL' required='yes'>
        <cfargument name='OPERACAO_ID_CTRC' required='yes'>
        <cfargument name='SUBSTITUTO' required='no' default="">
        <cfargument name='CONHECIMENTO_TIPO_ID' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte.prc_alt_cte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_CONHECIMENTO'  value='#arguments.NUM_CONHECIMENTO#'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#' variable='retorno.ITEM_ID'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#' variable='retorno.NUM_ROMANEIO'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_PRODUTO'  value='#arguments.NUM_PRODUTO#'  null='#iif(len(trim(arguments.NUM_PRODUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ORIGEM_ID'  value='#arguments.ST_ORIGEM_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#arguments.ST_ICMS_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PAGADOR'  value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_REDESPACHO'  value='#arguments.COD_REDESPACHO#'  null='#iif(len(trim(arguments.COD_REDESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO'  value='#arguments.PESO#' variable='retorno.PESO'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VOLUME'  value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_UNITARIO'  value='#arguments.FRETE_UNITARIO#'  null='#iif(len(trim(arguments.FRETE_UNITARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_PESO'  value='#arguments.FRETE_PESO#'  null='#iif(len(trim(arguments.FRETE_PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_VALOR'  value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESPACHO'  value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BASE_CALCULO_ICMS'  value='#arguments.BASE_CALCULO_ICMS#'  null='#iif(len(trim(arguments.BASE_CALCULO_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALIQUOTA_ICMS'  value='#arguments.ALIQUOTA_ICMS#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ADEME'  value='#arguments.ADEME#'  null='#iif(len(trim(arguments.ADEME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCONTO'  value='#arguments.DESCONTO#'  null='#iif(len(trim(arguments.DESCONTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SEC_CAT'  value='#arguments.SEC_CAT#'  null='#iif(len(trim(arguments.SEC_CAT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRIS'  value='#arguments.GRIS#'  null='#iif(len(trim(arguments.GRIS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PEDAGIO'  value='#arguments.PEDAGIO#'  null='#iif(len(trim(arguments.PEDAGIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ICMS'  value='#arguments.VALOR_ICMS#'  null='#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ICMS_SUBSTIT'  value='#arguments.VALOR_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.VALOR_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_ENTREGA'  value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMPOSTOS'  value='#arguments.IMPOSTOS#'  null='#iif(len(trim(arguments.IMPOSTOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TOTAL_CONHECIMENTO'  value='#arguments.TOTAL_CONHECIMENTO#'  null='#iif(len(trim(arguments.TOTAL_CONHECIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_LOGRADOURO'  value='#arguments.COLETA_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_COMPLEMENTO'  value='#arguments.COLETA_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_BAIRRO'  value='#arguments.COLETA_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_CEP'  value='#arguments.COLETA_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_UF'  value='#arguments.COLETA_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_LOGRADOURO'  value='#arguments.RED_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_COMPLEMENTO'  value='#arguments.RED_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_BAIRRO'  value='#arguments.RED_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_CEP'  value='#arguments.RED_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_UF'  value='#arguments.RED_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA_CONTROLE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_MOTORISTA'  value='#arguments.NOME_MOTORISTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROPRIETARIO'  value='#arguments.COD_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' variable='retorno.OBSERVACAO' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RODAPE'  value='#arguments.RODAPE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTRADA_DADOS'  value='2'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_CONHECIMENTO'  value='#arguments.TIPO_CONHECIMENTO#'  null='#iif(len(trim(arguments.TIPO_CONHECIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TEM_NOTA'  value='1'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_MUNICIPIO_ID'  value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_MUNICIPIO_ID'  value='#arguments.RED_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.RED_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_ID'  value='#arguments.CARGA_ID#'  null='#iif(len(trim(arguments.CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CLIENTE_COBRANCA'  value='#arguments.COD_CLIENTE_COBRANCA#'  null='#iif(len(trim(arguments.COD_CLIENTE_COBRANCA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PRAZO_ENTREGA'  value='#arguments.PRAZO_ENTREGA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANOGRAMA_GERENCIAL'  value='#arguments.COD_ORGANOGRAMA_GERENCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGRA_FISCAL_ID'  value='#arguments.REGRA_FISCAL_ID#'  null='#iif(len(trim(arguments.REGRA_FISCAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_TRACAO'  value='#arguments.PLACA_TRACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID_SUB_CONTR'  value='#arguments.CONHECIMENTO_ID_SUB_CONTR#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID_SUB_CONTR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REDUCAO_BASE_ICMS'  value='#arguments.REDUCAO_BASE_ICMS#'  null='#iif(len(trim(arguments.REDUCAO_BASE_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REDUCAO_BASE_ICMS_SUBSTIT'  value='#arguments.REDUCAO_BASE_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.REDUCAO_BASE_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BASE_CALCULO_ICMS_SUBSTIT'  value='#arguments.BASE_CALCULO_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.BASE_CALCULO_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALIQUOTA_ICMS_SUBSTIT'  value='#arguments.ALIQUOTA_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ICMS_PRESUMIDO'  value='#arguments.VALOR_ICMS_PRESUMIDO#'  null='#iif(len(trim(arguments.VALOR_ICMS_PRESUMIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_CONHECIMENTO_SUB_CONTR'  value='#arguments.NUM_CONHECIMENTO_SUB_CONTR#'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO_SUB_CONTR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE_CONHECIMENTO_SUB_CONTR'  value='#arguments.SERIE_CONHECIMENTO_SUB_CONTR#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BASE_CALCULO_ISS'  value='#arguments.BASE_CALCULO_ISS#'  null='#iif(len(trim(arguments.BASE_CALCULO_ISS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALIQUOTA_ISS'  value='#arguments.ALIQUOTA_ISS#'  null='#iif(len(trim(arguments.ALIQUOTA_ISS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ISS'  value='#arguments.VALOR_ISS#'  null='#iif(len(trim(arguments.VALOR_ISS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_FATURAMENTO'  value='#arguments.VALOR_FATURAMENTO#'  null='#iif(len(trim(arguments.VALOR_FATURAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CFOP'  value='#arguments.CFOP#'  null='#iif(len(trim(arguments.CFOP)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP_ID'  value='#arguments.CFOP_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_OPERACAO'  value='#arguments.NATUREZA_OPERACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FUNDAMENTACAO_LEGAL'  value='#arguments.FUNDAMENTACAO_LEGAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_NEGOCIADOR'  value='#arguments.COD_NEGOCIADOR#'  null='#iif(len(trim(arguments.COD_NEGOCIADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_REAL'  value='#arguments.PESO_KG#'  null='#iif(len(trim(arguments.PESO_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_VENDA'  value='#arguments.TIPO_VENDA#'  null='#iif(len(trim(arguments.TIPO_VENDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FATURADO' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_ENDERECO_NUM'  value='#arguments.REM_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_BAIRRO'  value='#arguments.REM_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REM_MUNICIPIO_ID'  value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_ENDERECO_NUM'  value='#arguments.DEST_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_BAIRRO'  value='#arguments.DEST_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEST_MUNICIPIO_ID'  value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_ENDERECO_NUM' value='' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_BAIRRO' value='' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONS_MUNICIPIO_ID' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_ENDERECO_NUM'  value='#arguments.RED_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_BAIRRO'  value='#arguments.RED_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RED_MUNICIPIO_ID'  value='#arguments.RED_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.RED_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_ENDERECO_NUM'  value='#arguments.COB_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COB_MUNICIPIO_ID'  value='#arguments.COB_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COB_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MODELO_DOCUMENTO'  value='#arguments.MODELO_DOCUMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_SERVICO_ID'  value='#arguments.TIPO_SERVICO_ID#'  null='#iif(len(trim(arguments.TIPO_SERVICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_PESSOA'  value='#arguments.COLETA_COD_PESSOA#'  null='#iif(len(trim(arguments.COLETA_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_CNPJ_CPF'  value='#arguments.COLETA_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_RAZAO_SOCIAL'  value='#arguments.COLETA_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_NUM'  value='#arguments.COLETA_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_PESSOA'  value='#arguments.COD_REDESPACHO#'  null='#iif(len(trim(arguments.COD_REDESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_CNPJ_CPF'  value='#arguments.RED_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_RAZAO_SOCIAL'  value='#arguments.RED_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_NUM'  value='#arguments.RED_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID_CTRC#'  null='#iif(len(trim(arguments.OPERACAO_ID_CTRC)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_TIPO_ID'  value='#arguments.CONHECIMENTO_TIPO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_TIPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
                
                <!--- Exclui as NFs de um CTe --->
                <cfscript>
                    del_notas = this.del_cte_nfs(CONHECIMENTO_ID = arguments.CONHECIMENTO_ID);
                </cfscript>
                <cfif del_notas.erro>
                    <cfthrow object="#del_notas.mensagem#">
                </cfif>
                
                <!--- Insere Notas--->
                <cfscript>
                    ins_notas = this.ins_nfs_cte(argumentCollection = arguments);
                </cfscript>
                <cfif ins_notas.erro>
                    <cfthrow object="#ins_notas.mensagem#">
                </cfif>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CTe alterado com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir Nota Fiscal a CTE
	-- RAFAEL 28/12/2010 09:15:53 - CRIADO
	--->
	<cffunction name='ins_nfs_cte' displayname='Inserir Nota Fiscal a CTE' access='remote' returntype='Struct' output='true'>
    	<cftry>
            <cftransaction action='begin'>
                
                
					<!---Se for substituto no verifica a nota fiscal.--->
                    <cfif arguments.SUBSTITUTO eq 1>
                       <cfset v_verificar_nf = 0>
                    <cfelse>                   
                       <cfset v_verificar_nf = 1>
                    </cfif>
                        
                    <!---Verifica o Tipo de Documento que vai ser vinculado--->
                    <cfswitch expression="#arguments.tipo_documento_id#">
                        <cfcase value="0">
                            <!--- Insere Notas fiscais --->
                            <cfscript>
                                v_nota_conhecimento  = this.ListaToArray (lista = arguments, variavel = "NF_CONHECIMENTO_ID_NOTAS_FISCAIS");
                                v_numero 	         = this.ListaToArray(lista = arguments, variavel  = "NOTA_NUMERO_NOTAS_FISCAIS");
                                v_data_emissao       = this.ListaToArray(lista = arguments, variavel  = "NOTA_DATA_EMISSAO_NOTAS_FISCAIS");
                                v_serie 	         = this.ListaToArray(lista = arguments, variavel  = "NOTA_SERIE_NOTAS_FISCAIS");
                                v_sub_serie          = this.ListaToArray(lista = arguments, variavel  = "NOTA_SUB_SERIE_NOTAS_FISCAIS");
                                v_modelo             = this.ListaToArray(lista = arguments, variavel  = "NOTA_MODELO_NOTAS_FISCAIS");
                                v_valor		         = this.ListaToArray(lista = arguments, variavel  = "NOTA_VALOR_NOTAS_FISCAIS");
                                v_valor_segurado     = this.ListaToArray(lista = arguments, variavel  = "NOTA_VALOR_SEGURADO_NOTAS_FISCAIS");
                                v_peso               = this.ListaToArray(lista = arguments, variavel  = "NOTA_PESO_NOTAS_FISCAIS");
                                v_peso_cobrado       = this.ListaToArray(lista = arguments, variavel  = 'NOTA_PESO_COBRADO_NOTAS_FISCAIS');
                                v_ordem_compra       = this.ListaToArray(lista = arguments, variavel  = "NOTA_ORDEM_COMPRA_NOTAS_FISCAIS");
                                v_qtde_volume        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_QTDE_VOLUME_NOTAS_FISCAIS');
                                v_cod_unidade        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_COD_UNIDADE_NOTAS_FISCAIS');
                                v_m3                 = this.ListaToArray(lista = arguments, variavel  = 'NOTA_M3_NOTAS_FISCAIS');
                                v_peso_cubado        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_PESO_CUBADO_NOTAS_FISCAIS');
                                v_num_natureza       = this.ListaToArray(lista = arguments, variavel  = 'NOTA_NUM_NATUREZA_NOTAS_FISCAIS');
                                v_natureza           = this.ListaToArray(lista = arguments, variavel  = 'NOTA_NATUREZA_NOTAS_FISCAIS');
                                v_complemento        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_COMPLEMENTO_NOTAS_FISCAIS');
                                v_num_especie        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_NUM_ESPECIE_NOTAS_FISCAIS');
                                v_especie            = this.ListaToArray(lista = arguments, variavel  = 'NOTA_ESPECIE_NOTAS_FISCAIS');
                                v_altura             = this.ListaToArray(lista = arguments, variavel  = 'NOTA_ALTURA_NOTAS_FISCAIS');
                                v_largura            = this.ListaToArray(lista = arguments, variavel  = 'NOTA_LARGURA_NOTAS_FISCAIS');
                                v_comprimento        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_COMPRIMENTO_NOTAS_FISCAIS');
                                v_cubagem            = this.ListaToArray(lista = arguments, variavel  = 'NOTA_CUBAGEM_NOTAS_FISCAIS');
                                v_cfop				 = this.ListaToArray(lista = arguments, variavel  = 'NOTA_CFOP_NOTAS_FISCAIS');
                            </cfscript>
                            
                            <cfloop from="1" to="#ArrayLen(v_numero)#" index="count">
                                <cfscript>
                                    ret_nf = this.ins_nf_cte(conhecimento_id 				= arguments.conhecimento_id,
                                                             numero							= v_numero[count],
                                                             numero_old						= v_numero[count],
                                                             data_emissao					= v_data_emissao[count],
                                                             modelo							= v_modelo[count],
                                                             serie							= v_serie[count],
                                                             sub_serie						= v_sub_serie[count],
                                                             valor_total					= v_valor[count],
                                                             nf_eletronica					= 0 ,
                                                             valor_segurado					= v_valor_segurado[count],
                                                             ordem_compra_cliente			= '',
                                                             peso							= v_peso[count],
                                                             peso_cubado					= v_peso_cubado[count],
                                                             peso_cobrado					= v_peso_cobrado[count],
                                                             qtde_volume					= v_qtde_volume[count],
                                                             altura							= v_altura[count],
                                                             comprimento					= v_comprimento[count],
                                                             largura						= v_largura[count],
                                                             m3								= v_m3[count],
                                                             cubagem						= v_cubagem[count],
                                                             num_natureza					= v_num_natureza[count],
                                                             complemento					= v_complemento[count],
                                                             num_especie					= v_num_especie[count],
                                                             cod_unidade					= v_cod_unidade[count],
                                                             tipo_documento_id				= arguments.tipo_documento_id,
                                                             num_romaneio					= '',
                                                             valor_base_calculo_icms		= '',
                                                             valor_icms						= '',
                                                             valor_base_calculo_icms_st		= '',
                                                             valor_icms_st					= '',
                                                             valor_produtos					= '',
                                                             cfop							= v_cfop[count],
                                                             pin_suframa					= '',
                                                             chave_acesso_nfe				= '',
                                                             descricao_docto				= '',
                                                             nfe_xml						= '',
                                                             verificar_nf                   = v_verificar_nf);
                                </cfscript>
                                <cfif ret_nf.erro>
                                    <cfthrow object="#ret_nf.mensagem#">
                                </cfif>
                            </cfloop>
                        </cfcase>
                        
                        <cfcase value="1">
                            <!--- Insere NFE --->
                            <cfscript>
                                v_nota_conhecimento     = this.ListaToArray (lista = arguments, variavel = "NF_CONHECIMENTO_ID_NFE");
                                v_chave_acesso_nfe		= this.ListaToArray (lista = arguments, variavel = "CHAVE_ACESSO_NFE_NFE");
                                v_nfe_valor				= this.ListaToArray (lista = arguments, variavel = "NFE_VALOR_NFE");
                                v_pin_suframa_nfe		= this.ListaToArray (lista = arguments, variavel = "PIN_SUFRAMA_NFE_NFE");
                                v_nome_arquivo			= this.ListaToArray (lista = arguments, variavel = "NOME_ARQUIVO_NFE");
                                v_data_emissao			= this.ListaToArray (lista = arguments, variavel = "DATA_EMISSAO_NFE");
                                v_numero				= this.ListaToArray (lista = arguments, variavel = "NUMERO_NFE");
                                v_modelo				= this.ListaToArray (lista = arguments, variavel = "MODELO_NFE");
                                v_serie					= this.ListaToArray (lista = arguments, variavel = "SERIE_NFE");
                                v_documento_id			= this.ListaToArray (lista = arguments, variavel = "NFE_DOCUMENTO_ID_NFE");
                                v_peso               	= this.ListaToArray(lista = arguments, variavel  = "NFE_PESO_NFE");
                                v_peso_cobrado       	= this.ListaToArray(lista = arguments, variavel  = 'NFE_PESO_COBRADO_NFE');
                                v_qtde_volume        	= this.ListaToArray(lista = arguments, variavel  = 'NFE_QTDE_VOLUME_NFE');
                                v_cod_unidade        	= this.ListaToArray(lista = arguments, variavel  = 'NFE_COD_UNIDADE_NFE');
                                v_m3                 	= this.ListaToArray(lista = arguments, variavel  = 'NFE_M3_NFE');
                                v_peso_cubado        	= this.ListaToArray(lista = arguments, variavel  = 'NFE_PESO_CUBADO_NFE');
                                v_num_natureza       	= this.ListaToArray(lista = arguments, variavel  = 'NFE_NUM_NATUREZA_NFE');
                                v_natureza           	= this.ListaToArray(lista = arguments, variavel  = 'NFE_NATUREZA_NFE');
                                v_complemento        	= this.ListaToArray(lista = arguments, variavel  = 'NFE_COMPLEMENTO_NFE');
                                v_num_especie        	= this.ListaToArray(lista = arguments, variavel  = 'NFE_NUM_ESPECIE_NFE');
                                v_especie            	= this.ListaToArray(lista = arguments, variavel  = 'NFE_ESPECIE_NFE');
                                v_altura             	= this.ListaToArray(lista = arguments, variavel  = 'NFE_ALTURA_NFE');
                                v_largura            	= this.ListaToArray(lista = arguments, variavel  = 'NFE_LARGURA_NFE');
                                v_comprimento        	= this.ListaToArray(lista = arguments, variavel  = 'NFE_COMPRIMENTO_NFE');
                                v_cubagem            	= this.ListaToArray(lista = arguments, variavel  = 'NFE_CUBAGEM_NFE');
                                v_ordem_compra       	= this.ListaToArray(lista = arguments, variavel  = "NFE_ORDEM_COMPRA_NFE");
                            </cfscript>
                            
                            <cfloop from="1" to="#ArrayLen(v_chave_acesso_nfe)#" index="count">
                                <!--- Busca arquivo --->
                                <cfif Len(Trim(v_nome_arquivo[count]))>
                                    <cffile action="read" file="#expandPath("/")#temp/#v_nome_arquivo[count]#" variable="VARQUIVO">
                                <cfelse>
                                    <cfset VARQUIVO = ''>
                                </cfif>
                                
                                <cfscript>
                                    ret_nfe = this.ins_nf_cte(conhecimento_id 				= arguments.conhecimento_id,
                                                              numero						= v_numero[count],
                                                              numero_old					= v_numero[count],
                                                              data_emissao					= v_data_emissao[count],
                                                              modelo						= v_modelo[count],
                                                              serie							= v_serie[count],
                                                              sub_serie						= '1',
                                                              valor_total					= v_nfe_valor[count],
                                                              nf_eletronica					= 1,
                                                              valor_segurado				= 0,
                                                              ordem_compra_cliente			= v_ordem_compra[count],
                                                              peso							= v_peso[count],
                                                              peso_cubado					= v_peso_cubado[count],
                                                              peso_cobrado					= v_peso_cobrado[count],
                                                              qtde_volume					= v_qtde_volume[count],
                                                              altura						= v_altura[count],
                                                              comprimento					= v_comprimento[count],
                                                              largura						= v_largura[count],
                                                              m3							= v_m3[count],
                                                              cubagem						= v_cubagem[count],
                                                              num_natureza					= v_num_natureza[count],
                                                              complemento					= v_complemento[count],
                                                              num_especie					= v_num_especie[count],
                                                              cod_unidade					= v_cod_unidade[count],
                                                              tipo_documento_id				= arguments.tipo_documento_id,
                                                              num_romaneio					= '',
                                                              valor_base_calculo_icms		= '',
                                                              valor_icms					= '',
                                                              valor_base_calculo_icms_st	= '',
                                                              valor_icms_st					= '',
                                                              valor_produtos				= '',
                                                              cfop							= '',
                                                              pin_suframa					= v_pin_suframa_nfe[count],
                                                              chave_acesso_nfe				= v_chave_acesso_nfe[count],
                                                              descricao_docto				= '',
                                                              nfe_xml						= VARQUIVO,
                                                              documento_id					= v_documento_id[count]);
                                </cfscript>
                                <cfif ret_nfe.erro>
                                    <cfthrow object="#ret_nfe.mensagem#">
                                </cfif>
                            </cfloop>
                        </cfcase>


                        <cfcase value="2">
                            <!--- Insere Outros Documentos--->
                            <cfscript>
                                v_nota_conhecimento  	= this.ListaToArray (lista = arguments, variavel = "NF_CONHECIMENTO_ID_OUTROS");
                                v_outros_numero			= this.ListaToArray (lista = arguments, variavel = "OUTROS_NUMERO_OUTROS");
                                v_outros_data_emissao	= this.ListaToArray (lista = arguments, variavel = "OUTROS_DATA_EMISSAO_OUTROS");
                                v_outros_descricao		= this.ListaToArray (lista = arguments, variavel = "OUTROS_DESCRICAO_OUTROS");
                                v_outros_valor			= this.ListaToArray (lista = arguments, variavel = "OUTROS_VALOR_OUTROS");
                                v_peso                  = this.ListaToArray (lista = arguments, variavel = "OUTROS_PESO_OUTROS");
                                v_peso_cobrado          = this.ListaToArray (lista = arguments, variavel = 'OUTROS_PESO_COBRADO_OUTROS');
                                v_qtde_volume           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_QTDE_VOLUME_OUTROS');
                                v_cod_unidade           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COD_UNIDADE_OUTROS');
                                v_m3                    = this.ListaToArray (lista = arguments, variavel = 'OUTROS_M3_OUTROS');
                                v_peso_cubado           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_PESO_CUBADO_OUTROS');
                                v_num_natureza          = this.ListaToArray (lista = arguments, variavel = 'OUTROS_NUM_NATUREZA_OUTROS');
                                v_complemento           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COMPLEMENTO_OUTROS');
                                v_num_especie           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_NUM_ESPECIE_OUTROS');
                                v_altura                = this.ListaToArray (lista = arguments, variavel = 'OUTROS_ALTURA_OUTROS');
                                v_largura               = this.ListaToArray (lista = arguments, variavel = 'OUTROS_LARGURA_OUTROS');
                                v_comprimento           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COMPRIMENTO_OUTROS');
                                v_cubagem               = this.ListaToArray (lista = arguments, variavel = 'OUTROS_CUBAGEM_OUTROS');
                            </cfscript>
                            
                            <cfloop from="1" to="#ArrayLen(v_outros_numero)#" index="count">
                                <cfscript>
                                    outros = this.ins_nf_cte(conhecimento_id 				= arguments.conhecimento_id,
                                                             numero							= v_outros_numero[count],
                                                             numero_old						= v_outros_numero[count],
                                                             data_emissao					= v_outros_data_emissao[count],
                                                             modelo							= '01',
                                                             serie							= 'U',
                                                             sub_serie						= '1',
                                                             valor_total					= v_outros_valor[count],
                                                             nf_eletronica					= 0,
                                                             valor_segurado					= v_outros_valor[count],
                                                             ordem_compra_cliente			= '',
                                                             peso							= v_peso[count],
                                                             peso_cubado					= v_peso_cubado[count],
                                                             peso_cobrado					= v_peso_cobrado[count],
                                                             qtde_volume					= v_qtde_volume[count],
                                                             altura							= v_altura[count],
                                                             comprimento					= v_comprimento[count],
                                                             largura						= v_largura[count],
                                                             m3								= v_m3[count],
                                                             cubagem						= v_cubagem[count],
                                                             num_natureza					= v_num_natureza[count],
                                                             complemento					= v_complemento[count],
                                                             num_especie					= v_num_especie[count],
                                                             cod_unidade					= v_cod_unidade[count],
                                                             tipo_documento_id				= arguments.tipo_documento_id,
                                                             num_romaneio					= '',
                                                             valor_base_calculo_icms		= '',
                                                             valor_icms						= '',
                                                             valor_base_calculo_icms_st		= '',
                                                             valor_icms_st					= '',
                                                             valor_produtos					= '',
                                                             cfop							= '',
                                                             pin_suframa					= '',
                                                             chave_acesso_nfe				= '',
                                                             descricao_docto				= v_outros_descricao[count],
                                                             nfe_xml						= '');
                                </cfscript>
                                <cfif outros.erro>
                                    <cfthrow object="#outros.mensagem#">
                                </cfif>
                            </cfloop>
                        </cfcase>                
                    </cfswitch>
    		<cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Notas Fiscais inseridas com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui as NFs de um CTe
	-- ANDERSONC 19/09/2011 11:51:40 - CRIADO
	--->
	<cffunction name='del_cte_nfs' displayname='Exclui as NFs de um CTe' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_cte.prc_del_cte_nfs' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>