<cfcomponent displayname="Controle e manipulao de veculos" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Insere comentrio na coluna determinada
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 22/11/2005 - criado
	--->
	<cffunction name="ins_comentario" displayname="Insere comentrio na coluna determinada" access="remote" returntype="struct" output="true">
		<cfargument name="placa" required="true">
		<cfargument name="num_romaneio" required="true">
		<cfargument name="cod_pessoa" required="true">
		<cfargument name="tipo_comentario" required="true" displayname="0 - Tempo Parado, 1 - Veculo, 2 - Motorista, 3 - Romaneio">
		<cfargument name="comentario" required="true">
		<cfargument name="referencia_id" required="true">
		<cfargument name="landmark" required="true">
	    <cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_rank_frota.prc_ins_comentario" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="inout" cfsqltype="cf_sql_integer"  null="yes" variable="retorno.id">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.placa#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.cod_pessoa#" null="#IIF(isDefined("arguments.cod_pessoa") and Len(Trim(arguments.cod_pessoa)),DE('no'),DE('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.num_romaneio#" null="#IIF(isDefined("arguments.num_romaneio") and Len(Trim(arguments.num_romaneio)),DE('no'),DE('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.referencia_id#">				
				<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.landmark#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.tipo_comentario#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.comentario#">
				<cfprocparam type="out" cfsqltype="cf_sql_varchar"  variable="retorno.rowid">
			</cfstoredproc>

			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_rank_frota.prc_atualiza_hints" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.placa#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.cod_pessoa#" null="#IIF(isDefined("arguments.cod_pessoa") and Len(Trim(arguments.cod_pessoa)),DE('no'),DE('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.num_romaneio#" null="#IIF(isDefined("arguments.num_romaneio") and Len(Trim(arguments.num_romaneio)),DE('no'),DE('yes'))#">
			</cfstoredproc>

			<cfset retorno.mensagem = 'Comentrio inserido com sucesso.'>				
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Envia mensagem veiculo
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 22/11/2005 - criado
	--->
	<cffunction name="envia_mensagem" displayname="Envia mensagem veiculo" access="remote" returntype="struct" output="true">
		<cfargument name="rastreador_id" required="true">
		<cfargument name="mensagem" required="true">
	    <cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_rastreador.prc_msg_envio" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="inout" cfsqltype="cf_sql_integer"  null="yes" variable="retorno.mensagem_id">
				<cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.rastreador_id#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer"  value="0">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#DateFormat(Now(),'dd/mm/yyyy')# #TimeFormat(Now(),'HH:MM')#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.mensagem#">				
			</cfstoredproc>
			<cfset retorno.mensagem = 'Mensagem enviada com sucesso.'>				
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Envia macro veiculo
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 22/11/2005 - criado
	--->
	<cffunction name="envia_macro" displayname="Envia macro veiculo" access="remote" returntype="struct" output="true">
		<cfargument name="rastreador_id" required="true">
		<cfargument name="macro_id" required="true">
		<cfargument name="texto" required="true">
	    <cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_rastreador.prc_msg_envio" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="inout" cfsqltype="cf_sql_integer"  null="yes" variable="retorno.mensagem_id">
				<cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.rastreador_id#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.macro_id#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#DateFormat(Now(),'dd/mm/yyyy')# #TimeFormat(Now(),'HH:MM')#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.texto#">				
			</cfstoredproc>
			<cfset retorno.mensagem = 'Macro enviada com sucesso.'>				
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um evento para o veiculo
	-- ANDERSONC 10/06/2009 09:58:10 - ALTERADO
	--->
	<cffunction name='ins_evento_operacao' displayname='Insere um evento para o veiculo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONTROLE_EVO_ID' required='yes'>
		<cfargument name='NUM_EVENTO' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='PLACA_CONTROLE' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='KM' required='yes'>
		<cfargument name='LATITUDE' required='yes'>
		<cfargument name='LONGITUDE' required='yes'>
		<cfargument name='DEBITAR_MOTORISTA' required='yes'>
		<cfargument name='REFERENCIA_ID' required='yes'>
		<cfargument name='REFERENCIA' required='yes'>
        <cfargument name='LOCAL_ROTA_ID' required='no'>
		<cftry>
			<cftransaction action='begin'>
				<!---Insere parametros---> 
				<cfloop index="fld" list="#arguments.FIELDNAMES#" delimiters=",">
					<cfif Find('PARAMETRO',fld)>
					   <cfscript>
					   	  this.ins_evento_dado_temp(dado_id = ListGetAt(fld,2,'_'), 
						                               valor   = UCase(arguments[fld]));
					   </cfscript>
					</cfif>
				</cfloop>
				
				<cfstoredproc procedure='oper.pkg_evento_controle.prc_ins_evento_operacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_EVO_ID#' variable='retorno.CONTROLE_EVO_ID'  null='#iif(len(trim(arguments.CONTROLE_EVO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_EVENTO#'  null='#iif(len(trim(arguments.NUM_EVENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#' variable='retorno.COD_PESSOA'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CONTROLE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM#' variable='retorno.KM'  null='#iif(len(trim(arguments.KM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='2'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LATITUDE#'  null='#iif(len(trim(arguments.LATITUDE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LONGITUDE#'  null='#iif(len(trim(arguments.LONGITUDE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DEBITAR_MOTORISTA#'  null='#iif(len(trim(arguments.DEBITAR_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REFERENCIA_ID#'  null='#iif(len(trim(arguments.REFERENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.REFERENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='0'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='0'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='0'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
                
                <cfif IsDefined("arguments.LOCAL_ROTA_ID")>
                	 <cfscript>
						 this.ins_evo_dedicado(CONTROLE_EVO_ID = retorno.CONTROLE_EVO_ID,
											   LOCAL_ROTA_ID   = arguments.LOCAL_ROTA_ID);
					 </cfscript>
                </cfif>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Evento inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<cffunction name='ins_evento_dado_temp' displayname='Insere um evento para o veiculo' access='remote' output='false'>;
		<cfargument name="dado_id" default="" required="no">
		<cfargument name="valor" default="" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			insert into oper.evento_dado_temp
			  (dado_id, valor)
			values
			  (#arguments.dado_id#, '#arguments.valor#')
		</cfquery>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera dados do evento
	-- ANDERSONC 10/06/2009 09:58:10 - ALTERADO
	--->
	<cffunction name='upd_evento_operacao' displayname='Altera dados do evento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONTROLE_EVO_ID' required='yes'>
		<cfargument name='PLACA_CONTROLE' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='KM' required='yes'>
		<cfargument name='LATITUDE' required='yes'>
		<cfargument name='LONGITUDE' required='yes'>
		<cfargument name='REFERENCIA' required='yes'>
		<cfargument name='DEBITAR_MOTORISTA' required='yes'>
		<cfargument name='REFERENCIA_ID' required='yes'>
        <cfargument name='LOCAL_ROTA_ID' required='no'>
		<cftry>
			<cftransaction action='begin'>
				<!---Insere parametros---> 
				<cfloop index="fld" list="#arguments.FIELDNAMES#" delimiters=",">
					<cfif Find('PARAMETRO',fld)>
					   <cfscript>
					   	  this.ins_evento_dado_temp(dado_id = ListGetAt(fld,2,'_'), 
						                            valor   = arguments[fld]);
					   </cfscript>
					</cfif>
				</cfloop>
				
				<cfstoredproc procedure='oper.pkg_evento_controle.prc_alt_evento_operacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_EVO_ID#'  null='#iif(len(trim(arguments.CONTROLE_EVO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CONTROLE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM#'  null='#iif(len(trim(arguments.KM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LATITUDE#'  null='#iif(len(trim(arguments.LATITUDE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LONGITUDE#'  null='#iif(len(trim(arguments.LONGITUDE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.REFERENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DEBITAR_MOTORISTA#'  null='#iif(len(trim(arguments.DEBITAR_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REFERENCIA_ID#'  null='#iif(len(trim(arguments.REFERENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='0'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='0'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='0'>
				</cfstoredproc>
                
                <cfif IsDefined("arguments.LOCAL_ROTA_ID")>
					<cfscript>
						conn = CreateComponent("_transportes.consulta.cfc_controle_trafego");
						qrRomaneioDedicado = conn.get_evento_operacao_dedicado(controle_evo_id = arguments.CONTROLE_EVO_ID);
						
						if(qrRomaneioDedicado.RecordCount eq 0) {
							 this.ins_evo_dedicado(CONTROLE_EVO_ID = arguments.CONTROLE_EVO_ID,
												   LOCAL_ROTA_ID   = arguments.LOCAL_ROTA_ID);
						}
						else {
							 this.upd_evo_dedicado(CONTROLE_EVO_ID = arguments.CONTROLE_EVO_ID,
												   LOCAL_ROTA_ID   = arguments.LOCAL_ROTA_ID);
						}
					</cfscript>
                </cfif>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Evento alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exlcuir evento
	-- guto 15/08/2006 16:06:54 - CRIADO
	--->
	<cffunction name='del_evento_operacao' displayname='Exlcuir evento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONTROLE_EVO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_evento_controle.prc_del_evento_operacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_EVO_ID#'  null='#iif(len(trim(arguments.CONTROLE_EVO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Evento excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset retorno.mensagem_str = cfcatch.Detail>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere um Evento de Operao Dedicado
    -- ANDERSONC 10/06/2009 09:58:10 - CRIADO
    --->
    <cffunction name='ins_evo_dedicado' displayname='Insere um Evento de Operao Dedicado' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_EVO_ID' required='yes'>
        <cfargument name='LOCAL_ROTA_ID' required='yes'>
            <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_ins_evo_dedicado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_EVO_ID#'  null='#iif(len(trim(arguments.CONTROLE_EVO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LOCAL_ROTA_ID#'  null='#iif(len(trim(arguments.LOCAL_ROTA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera um Evento de Operao Dedicado
	-- ANDERSONC 10/06/2009 09:58:10 - CRIADO
	--->
	<cffunction name='upd_evo_dedicado' displayname='Altera um Evento de Operao Dedicado' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_EVO_ID' required='yes'>
        <cfargument name='LOCAL_ROTA_ID' required='yes'>
            <cfstoredproc procedure='dedicado.pkg_operacao_dml.prc_alt_evo_dedicado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
            	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_EVO_ID#'  null='#iif(len(trim(arguments.CONTROLE_EVO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LOCAL_ROTA_ID#'  null='#iif(len(trim(arguments.LOCAL_ROTA_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Destina o veiculo
	-- cristofer 18/10/2006 09:48:11 - CRIADO
	--->
	<cffunction name='destina_veiculo' displayname='Destina o veiculo' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA_CONTROLE' required='yes'>
		<cfargument name='PLACA_REFERENCIA' required='yes'>
		
		<cfargument name='DATA_INICIO' required='no' default="#LSDateFormat(now())# #TimeFormat(now(),'HH:MM:SS')#">
		
		<cfargument name='COD_PESSOA_MOTORISTA' required='yes'>
		<cfargument name='ENVIA_MSG_MOTORISTA' required='no' default="0">
		<cfargument name='MENSAGEM_MOTORISTA' required='no' default="">
		<cfargument name='ENVIA_MSG_PREVISAO_VAZIO' required='no' default="0">
		<cfargument name='PREVISAO_CHEGADA_VAZIO' required='no' default="">
		
		<cfargument name='CARREGAMENTO' required='yes'>
		<cfargument name='ORIGEM' required='no' default="">
		<cfargument name='DESTINO' required='yes'>
		
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='FRETE_EM' required='yes'>
		
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='ORG_COD_UF' required='yes'>
		<cfargument name='ORG_COD_MUNICIPIO' required='yes'>
		<cfargument name='ORG_COD_DISTRITO' required='yes'>
		<cfargument name='ORG_COD_DV' required='yes'>
		<cfargument name='ORG_MUNICIPIO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_romaneio_dml.prc_destina_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CONTROLE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_REFERENCIA#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' variable='retorno.DATA_INICIO' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_MOTORISTA#'  null='#iif(len(trim(arguments.COD_PESSOA_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ENVIA_MSG_MOTORISTA#'  null='#iif(len(trim(arguments.ENVIA_MSG_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MENSAGEM_MOTORISTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ENVIA_MSG_PREVISAO_VAZIO#'  null='#iif(len(trim(arguments.ENVIA_MSG_PREVISAO_VAZIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PREVISAO_CHEGADA_VAZIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CARREGAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESTINO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.FRETE_EM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORG_COD_UF#'  null='#iif(len(trim(arguments.ORG_COD_UF)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORG_COD_MUNICIPIO#'  null='#iif(len(trim(arguments.ORG_COD_MUNICIPIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORG_COD_DISTRITO#'  null='#iif(len(trim(arguments.ORG_COD_DISTRITO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORG_COD_DV#'  null='#iif(len(trim(arguments.ORG_COD_DV)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.NUM_ROMANEIO' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORG_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORG_MUNICIPIO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<!---  --->

				<cfscript>
					/*if(	len(trim(arguments.NUM_LIBERACAO_RCTR_C)) or
						len(trim(arguments.NUM_LIBERACAO_RCF_DC)) or
						len(trim(arguments.NUM_LIBERACAO_RCTR_VI)) ) {
						this.ins_alt_roo_liberacao(	num_romaneio 		  = retorno.num_romaneio,
													SEGURADORA_ID_RCTRC   = arguments.SEGURADORA_ID_RCTRC,
													NUM_LIBERACAO_RCTR_C  = arguments.NUM_LIBERACAO_RCTR_C,
													SEGURADORA_ID_RCF_DC  = arguments.SEGURADORA_ID_RCF_DC,
													NUM_LIBERACAO_RCF_DC  = arguments.NUM_LIBERACAO_RCF_DC,
													SEGURADORA_ID_RCTR_VI = arguments.SEGURADORA_ID_RCTR_VI,
													NUM_LIBERACAO_RCTR_VI = arguments.NUM_LIBERACAO_RCTR_VI);
					}
					plano_viagem = this.ins_plano_viagem (	PLACA = arguments.placa_controle,
															ORIGEM = arguments.origem,
															DESTINO = arguments.destino,
															NUM_ROMANEIO = retorno.num_romaneio,
															DATA_INICIO = retorno.data_inicio);
					*/

					v_itinerario_id = this.ListaToArray(lista = arguments, variavel = "ROTA_ITINERARIO_ID_ITINERARIOS");
					v_abreviatura = this.ListaToArray(lista = arguments, variavel = "ROTA_ABREVIATURA_ITINERARIOS");
					v_descricao = this.ListaToArray(lista = arguments, variavel = "ROTA_DESCRICAO_ITINERARIOS");
					v_rota_id = this.ListaToArray(lista = arguments, variavel = "ROTA_ID_ITINERARIOS");
					v_previsao = this.ListaToArray(lista = arguments, variavel = "ROTA_DATA_PREVISAO_ESTIMADO_ITINERARIOS");
					v_ordem = this.ListaToArray(lista = arguments, variavel = "ROTA_ORDEM_ITINERARIOS");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_itinerario_id)#" index="count">
					<cfscript>
						if(len(trim(arguments.rota_id))) {
							this.gera_itinerario_romaneio_item (	num_romaneio	= retorno.num_romaneio,
																	rota_id			= v_rota_id[count],
																	data_previsao	= v_previsao[count],
																	data_chegada	= '',
																	vazio_carregado = 0,
																	ordem           = v_ordem[count]);	
						}
					</cfscript>
				</cfloop>
								
				<cfscript>
					v_num_lote = this.ListaToArray(lista = arguments, variavel = "LOTE_NUM_LOTE_ITEM_ROMANEIO");
					v_volume = this.ListaToArray(lista = arguments, variavel = "LOTE_VOLUME_ITEM_ROMANEIO");
					v_cod_unidade = this.ListaToArray(lista = arguments, variavel = "LOTE_COD_UNIDADE_ITEM_ROMANEIO");
					v_peso = this.ListaToArray(lista = arguments, variavel = "LOTE_PESO_ITEM_ROMANEIO");
					v_m3 = this.ListaToArray(lista = arguments, variavel = "LOTE_M3_ITEM_ROMANEIO");
//					v_valor_frete = this.ListaToArray(lista = arguments, variavel = "LOTE_VALOR_TOTAL_ITEM_ROMANEIO");
					v_cod_remetente = this.ListaToArray(lista = arguments, variavel = "LOTE_COD_REMETENTE_ITEM_ROMANEIO");
					v_redespacho = this.ListaToArray(lista = arguments, variavel = "LOTE_REDESPACHO_ITEM_ROMANEIO");
					v_rem_cod_uf = this.ListaToArray(lista = arguments, variavel = "LOTE_REM_COD_UF_ITEM_ROMANEIO");
					v_rem_cod_municipio = this.ListaToArray(lista = arguments, variavel = "LOTE_REM_COD_MUNICIPIO_ITEM_ROMANEIO");
					v_rem_cod_distrito = this.ListaToArray(lista = arguments, variavel = "LOTE_REM_COD_DISTRITO_ITEM_ROMANEIO");
					v_rem_cod_dv = this.ListaToArray(lista = arguments, variavel = "LOTE_REM_COD_DV_ITEM_ROMANEIO");
					v_rem_municipio_id = this.ListaToArray(lista = arguments, variavel = "LOTE_REM_MUNICIPIO_ID_ITEM_ROMANEIO");
					v_cod_destinatario = this.ListaToArray(lista = arguments, variavel = "LOTE_COD_DESTINATARIO_ITEM_ROMANEIO");
					v_dest_cod_uf = this.ListaToArray(lista = arguments, variavel = "LOTE_DEST_COD_UF_ITEM_ROMANEIO");
					v_dest_cod_municipio = this.ListaToArray(lista = arguments, variavel = "LOTE_DEST_COD_MUNICIPIO_ITEM_ROMANEIO");
					v_dest_cod_distrito = this.ListaToArray(lista = arguments, variavel = "LOTE_DEST_COD_DISTRITO_ITEM_ROMANEIO");
					v_dest_cod_dv = this.ListaToArray(lista = arguments, variavel = "LOTE_DEST_COD_DV_ITEM_ROMANEIO");
					v_dest_municipio_id = this.ListaToArray(lista = arguments, variavel = "LOTE_DEST_MUNICIPIO_ID_ITEM_ROMANEIO");
					v_valor_frete = this.ListaToArray(lista = arguments, variavel = "LOTE_VALOR_TOTAL_ITEM_ROMANEIO");
					v_manifesto_id = this.ListaToArray(lista = arguments, variavel = "LOTE_MANIFESTO_ID_ITEM_ROMANEIO");
					v_observacao = this.ListaToArray(lista = arguments, variavel = "LOTE_OBSERVACAO_ITEM_ROMANEIO");

					v_rota_id = this.ListaToArray(lista = arguments, variavel = "LOTE_ROTA_ID_ITEM_ROMANEIO");
					v_ordem = this.ListaToArray(lista = arguments, variavel = "LOTE_ORDEM_ITEM_ROMANEIO");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_num_lote)#" index="count">
					<cfscript>
						this.ins_romaneio_item	(num_romaneio		= retorno.num_romaneio
												,num_lote			= v_num_lote[count]
												,volume				= v_volume[count]
												,cod_unidade		= v_cod_unidade[count]
												,peso				= v_peso[count]
												,m3					= v_m3[count]
												,valor_frete		= v_valor_frete[count]
												,cod_remetente		= v_cod_remetente[count]
												,redespacho			= v_redespacho[count]
												,rem_municipio_id	= v_rem_municipio_id[count]
												,cod_destinatario	= v_cod_destinatario[count]
												,dest_municipio_id= v_dest_municipio_id[count]
												,valor_frete_liquido= v_valor_frete[count]
												,despacho			= 0
												,observacao			= v_observacao[count]
												,manifesto_id		= v_manifesto_id[count]
												,ordem				= v_ordem[count]
												,data_previsao		= v_previsao[count]
												);
												
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Veiculo destinado com sucesso! Romaneio: #NumberFormat(retorno.num_romaneio,0)#')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Redestina o veiculo
	-- cristofer 18/10/2006 09:54:05 - CRIADO
	--->
	<cffunction name='redestina_veiculo' displayname='Redestina o veiculo' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA_CONTROLE' required='yes'>
		<cfargument name='PLACA_REFERENCIA' required='yes'>
		<cfargument name='ENVIA_MSG_MOTORISTA' required='no' default="0">
		<cfargument name='MENSAGEM_MOTORISTA' required='no' default="">
		<cfargument name='ENVIA_MSG_PREVISAO_VAZIO' required='no' default="0">
		<cfargument name='PREVISAO_CHEGADA_VAZIO' required='no' default="">
		<cfargument name='CARREGAMENTO' required='yes'>
		<cfargument name='ORIGEM' required='no' default="">
		<cfargument name='DESTINO' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='FRETE_EM' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_romaneio_dml.prc_redestina_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CONTROLE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_REFERENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ENVIA_MSG_MOTORISTA#'  null='#iif(len(trim(arguments.ENVIA_MSG_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MENSAGEM_MOTORISTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ENVIA_MSG_PREVISAO_VAZIO#'  null='#iif(len(trim(arguments.ENVIA_MSG_PREVISAO_VAZIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PREVISAO_CHEGADA_VAZIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CARREGAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESTINO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.FRETE_EM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
				</cfstoredproc>

				<cfscript>
					v_itinerario_id = this.ListaToArray(lista = arguments, variavel = "ROTA_ITINERARIO_ID_ITINERARIOS");
					v_abreviatura = this.ListaToArray(lista = arguments, variavel = "ROTA_ABREVIATURA_ITINERARIOS");
					v_descricao = this.ListaToArray(lista = arguments, variavel = "ROTA_DESCRICAO_ITINERARIOS");
					v_rota_id = this.ListaToArray(lista = arguments, variavel = "ROTA_ID_ITINERARIOS");
					v_previsao = this.ListaToArray(lista = arguments, variavel = "ROTA_DATA_PREVISAO_ESTIMADO_ITINERARIOS");
					v_ordem = this.ListaToArray(lista = arguments, variavel = "ROTA_ORDEM_ITINERARIOS");
					v_excluir = 	this.ListDiff(lista1 = arguments.lista_deleted_ITINERARIOS, lista2 = ArrayToList(v_itinerario_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_romaneio_itinerario_item(itinerario_id   = l_item_id);
					</cfscript>
				</cfloop>				
				<cfloop from="1" to="#ArrayLen(v_rota_id)#" index="count">
					<cfscript>
						if(len(trim(v_rota_id[count]))) {
							this.gera_itinerario_romaneio_item (num_romaneio	= retorno.num_romaneio,
																rota_id			= v_rota_id[count],
																data_previsao	= v_previsao[count],
																data_chegada	= '',
																vazio_carregado = 0,
																	ordem           = v_ordem[count]);	
						}
					</cfscript>
				</cfloop>
				
				<cfscript>
					retorno.num_romaneio = arguments.num_romaneio;
					v_item_id = this.ListaToArray(lista = arguments, variavel = "LOTE_ITEM_ID_ITEM_ROMANEIO");
					v_num_lote = this.ListaToArray(lista = arguments, variavel = "LOTE_NUM_LOTE_ITEM_ROMANEIO");
					v_volume = this.ListaToArray(lista = arguments, variavel = "LOTE_VOLUME_ITEM_ROMANEIO");
					v_cod_unidade = this.ListaToArray(lista = arguments, variavel = "LOTE_COD_UNIDADE_ITEM_ROMANEIO");
					v_peso = this.ListaToArray(lista = arguments, variavel = "LOTE_PESO_ITEM_ROMANEIO");
					v_m3 = this.ListaToArray(lista = arguments, variavel = "LOTE_M3_ITEM_ROMANEIO");
					v_cod_remetente = this.ListaToArray(lista = arguments, variavel = "LOTE_COD_REMETENTE_ITEM_ROMANEIO");
					v_redespacho = this.ListaToArray(lista = arguments, variavel = "LOTE_REDESPACHO_ITEM_ROMANEIO");
					v_rem_cod_uf = this.ListaToArray(lista = arguments, variavel = "LOTE_REM_COD_UF_ITEM_ROMANEIO");
					v_rem_cod_municipio = this.ListaToArray(lista = arguments, variavel = "LOTE_REM_COD_MUNICIPIO_ITEM_ROMANEIO");
					v_rem_cod_distrito = this.ListaToArray(lista = arguments, variavel = "LOTE_REM_COD_DISTRITO_ITEM_ROMANEIO");
					v_rem_cod_dv = this.ListaToArray(lista = arguments, variavel = "LOTE_REM_COD_DV_ITEM_ROMANEIO");
					v_rem_municipio_id = this.ListaToArray(lista = arguments, variavel = "LOTE_REM_MUNICIPIO_ID_ITEM_ROMANEIO");
					v_cod_destinatario = this.ListaToArray(lista = arguments, variavel = "LOTE_COD_DESTINATARIO_ITEM_ROMANEIO");
					v_dest_cod_uf = this.ListaToArray(lista = arguments, variavel = "LOTE_DEST_COD_UF_ITEM_ROMANEIO");
					v_dest_cod_municipio = this.ListaToArray(lista = arguments, variavel = "LOTE_DEST_COD_MUNICIPIO_ITEM_ROMANEIO");
					v_dest_cod_distrito = this.ListaToArray(lista = arguments, variavel = "LOTE_DEST_COD_DISTRITO_ITEM_ROMANEIO");
					v_dest_cod_dv = this.ListaToArray(lista = arguments, variavel = "LOTE_DEST_COD_DV_ITEM_ROMANEIO");
					v_dest_municipio_id = this.ListaToArray(lista = arguments, variavel = "LOTE_DEST_MUNICIPIO_ID_ITEM_ROMANEIO");
					v_valor_frete = this.ListaToArray(lista = arguments, variavel = "LOTE_VALOR_TOTAL_ITEM_ROMANEIO");
					v_observacao = this.ListaToArray(lista = arguments, variavel = "LOTE_OBSERVACAO_ITEM_ROMANEIO");
					v_manifesto_id = this.ListaToArray(lista = arguments, variavel = "LOTE_MANIFESTO_ID_ITEM_ROMANEIO");

					v_rota_id = this.ListaToArray(lista = arguments, variavel = "LOTE_ROTA_ID_ITEM_ROMANEIO");
					v_ordem = this.ListaToArray(lista = arguments, variavel = "LOTE_ORDEM_ITEM_ROMANEIO");
					v_previsao = this.ListaToArray(lista = arguments, variavel = "LOTE_DATA_PREVISAO_ITEM_ROMANEIO");

					v_excluir = 	this.ListDiff(lista1 = arguments.lista_deleted_ITEM_ROMANEIO, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_romaneio_item (num_romaneio = arguments.num_romaneio,
											      item_id   = l_item_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_num_lote)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_romaneio_item	(num_romaneio		= retorno.num_romaneio
													,num_lote			= v_num_lote[count]
													,volume				= v_volume[count]
													,cod_unidade		= v_cod_unidade[count]
													,peso				= v_peso[count]
													,m3					= v_m3[count]
													,valor_frete		= v_valor_frete[count]
													,cod_remetente		= v_cod_remetente[count]
													,redespacho			= v_redespacho[count]
													,rem_municipio_id = v_rem_municipio_id[count]
													,cod_destinatario	= v_cod_destinatario[count]
													,dest_municipio_id= v_dest_municipio_id[count]
													,valor_frete_liquido= v_valor_frete[count]
													,despacho			= 0
													,observacao			= v_observacao[count]
													,manifesto_id		= v_manifesto_id[count]
													,ordem				= v_ordem[count]
													,rota_id			= v_rota_id[count]
													,data_previsao		= v_previsao[count]
													);
						} else {
							this.upd_romaneio_item	(item_id			= v_item_id[count]
													,num_romaneio		= retorno.num_romaneio
													,num_lote			= v_num_lote[count]
													,volume				= v_volume[count]
													,cod_unidade		= v_cod_unidade[count]
													,peso				= v_peso[count]
													,m3					= v_m3[count]
													,valor_frete		= v_valor_frete[count]
													,cod_remetente		= v_cod_remetente[count]
													,redespacho			= v_redespacho[count]
													,rem_cod_uf			= v_rem_cod_uf[count]
													,rem_cod_municipio	= v_rem_cod_municipio[count]
													,rem_cod_distrito	= v_rem_cod_distrito[count]
													,rem_cod_dv			= v_rem_cod_dv[count]
													,rem_municipio_id	= v_rem_municipio_id[count]
													,cod_destinatario	= v_cod_destinatario[count]
													,dest_cod_uf		= v_dest_cod_uf[count]
													,dest_cod_municipio	= v_dest_cod_municipio[count]
													,dest_cod_distrito	= v_dest_cod_distrito[count]
													,dest_cod_dv		= v_dest_cod_dv[count]
													,dest_municipio_id= v_dest_municipio_id[count]
													,valor_frete_liquido= v_valor_frete[count]
													,despacho			= 0
													,observacao			= v_observacao[count]
													,manifesto_id		= v_manifesto_id[count]
													,ordem				= v_ordem[count]
													,rota_id			= v_rota_id[count]
													,data_previsao		= v_previsao[count]
													);
						}
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Veiculo redestinado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um item no romaneio
	-- cristofer 18/10/2006 09:55:04 - CRIADO
	--->
	<cffunction name='ins_romaneio_item' displayname='Insere um item no romaneio' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='NUM_LOTE' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='VALOR_FRETE' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='REDESPACHO' required='yes'>
		<cfargument name='REM_MUNICIPIO_ID' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='DEST_MUNICIPIO_ID' required='yes'>
		<cfargument name='VALOR_FRETE_LIQUIDO' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='MANIFESTO_ID' required='no' default="">
		<cfargument name='ORDEM' required='no' default="">
		<cfargument name='DATA_PREVISAO' required='no' default="">
		<cfargument name='ROTA_ID' required='no' default="">
				<cfstoredproc procedure='oper.pkg_romaneio_dml.prc_ins_romaneio_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_LOTE#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_FRETE#'  null='#iif(len(trim(arguments.VALOR_FRETE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REDESPACHO#'  null='#iif(len(trim(arguments.REDESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_FRETE_LIQUIDO#'  null='#iif(len(trim(arguments.VALOR_FRETE_LIQUIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.ITEM_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM#'  null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfscript>
				    if(len(trim(arguments.manifesto_id))) {
						this.vincula_roo_item(manifesto_id = arguments.manifesto_id,
											  roo_item_id  = retorno.item_id);
					}
					if(len(trim(arguments.rota_id))) {
						this.gera_itinerario_romaneio_item (	num_romaneio	= arguments.num_romaneio,
																item_id			= retorno.item_id,
																rota_id			= arguments.rota_id,
																data_previsao	= arguments.data_previsao,
																data_chegada	= '',
																vazio_carregado = 1,
																ordem           = arguments.ORDEM);
					}
															
				</cfscript>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma liberacao para o romaneio
	-- cristofer 18/10/2006 09:58:15 - CRIADO
	--->
	<cffunction name='ins_alt_roo_liberacao' displayname='Insere uma liberacao para o romaneio' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='SEGURADORA_ID_RCTRC' required='yes'>
		<cfargument name='NUM_LIBERACAO_RCTR_C' required='yes'>
		<cfargument name='SEGURADORA_ID_RCF_DC' required='yes'>
		<cfargument name='NUM_LIBERACAO_RCF_DC' required='yes'>
		<cfargument name='SEGURADORA_ID_RCTR_VI' required='yes'>
		<cfargument name='NUM_LIBERACAO_RCTR_VI' required='yes'>
				<cfstoredproc procedure='oper.pkg_romaneio_dml.prc_ins_alt_roo_liberacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SEGURADORA_ID_RCTRC#'  null='#iif(len(trim(arguments.SEGURADORA_ID_RCTRC)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_LIBERACAO_RCTR_C#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SEGURADORA_ID_RCF_DC#'  null='#iif(len(trim(arguments.SEGURADORA_ID_RCF_DC)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_LIBERACAO_RCF_DC#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SEGURADORA_ID_RCTR_VI#'  null='#iif(len(trim(arguments.SEGURADORA_ID_RCTR_VI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_LIBERACAO_RCTR_VI#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um plano de viagem
	-- cristofer 25/10/2006 11:17:07 - CRIADO
	--->
	<cffunction name='ins_plano_viagem' displayname='Insere um plano de viagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='ORIGEM' required='yes'>
		<cfargument name='DESTINO' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
				<cfstoredproc procedure='oper.pkg_romaneio_dml.prc_ins_plano_viagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ORIGEM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESTINO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.PLANO_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'   variable='retorno.rowid' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um plano de viagem
	-- cristofer 25/10/2006 11:17:53 - CRIADO
	--->
	<cffunction name='upd_plano_viagem' displayname='Altera um plano de viagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLANO_ID' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='ORIGEM' required='yes'>
		<cfargument name='DESTINO' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
				<cfstoredproc procedure='oper.pkg_romaneio_dml.prc_alt_plano_viagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PLANO_ID#'  null='#iif(len(trim(arguments.PLANO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ORIGEM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESTINO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um plano de viagem
	-- cristofer 25/10/2006 11:18:47 - CRIADO
	--->
	<cffunction name='del_plano_viagem' displayname='Exclui um plano de viagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLANO_ID' required='yes'>
				<cfstoredproc procedure='oper.pkg_romaneio_dml.prc_del_plano_viagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PLANO_ID#'  null='#iif(len(trim(arguments.PLANO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Insere um itinerario
	-- cristofer 25/10/2006 14:20:37 - CRIADO
	--->
	<cffunction name='ins_itinerario' displayname='Insere um itinerario' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLANO_ID' required='yes'>
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='DATA_ORIGEM' required='yes'>
		<cfargument name='DATA_PREVISAO_ESTIMADO' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='PLACA_CONTROLE' required='yes'>
		<cfargument name='PLACA_REFERENCIA' required='yes'>
		<cfargument name='VAZIO_CARREGADO' required='no' default="0">
				<cfstoredproc procedure='oper.pkg_romaneio_dml.prc_ins_itinerario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PLANO_ID#'  null='#iif(len(trim(arguments.PLANO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_ORIGEM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_PREVISAO_ESTIMADO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CONTROLE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_REFERENCIA#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.ITINERARIO_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'   variable='retorno.rowid' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VAZIO_CARREGADO#'  null='#iif(len(trim(arguments.VAZIO_CARREGADO)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um itinerario
	-- cristofer 26/10/2006 11:06:53 - CRIADO
	--->
	<cffunction name='upd_itinerario' displayname='Altera um itinerario' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITINERARIO_ID' required='yes'>
		<cfargument name='PLANO_ID' required='yes'>
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='DATA_PREVISAO_ESTIMADO' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='PLACA_CONTROLE' required='yes'>
		<cfargument name='PLACA_REFERENCIA' required='yes'>
		<cfargument name='VAZIO_CARREGADO' required='no' default="0">
				<cfstoredproc procedure='oper.pkg_romaneio_dml.prc_alt_itinerario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITINERARIO_ID#'  null='#iif(len(trim(arguments.ITINERARIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PLANO_ID#'  null='#iif(len(trim(arguments.PLANO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_PREVISAO_ESTIMADO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CONTROLE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_REFERENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VAZIO_CARREGADO#'  null='#iif(len(trim(arguments.VAZIO_CARREGADO)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um itinerario
	-- cristofer 26/10/2006 11:07:48 - CRIADO
	--->
	<cffunction name='del_itinerario' displayname='Exclui um itinerario' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITINERARIO_ID' required='yes'>
				<cfstoredproc procedure='oper.pkg_romaneio_dml.prc_del_itinerario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITINERARIO_ID#'  null='#iif(len(trim(arguments.ITINERARIO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Valida as alteraes de itinerarios
	-- cristofer 26/10/2006 11:07:48 - CRIADO
	--->
	<cffunction name='valida_itinerarios' displayname='itinerario' access='remote' returntype='Struct' output='true'>
				<cfstoredproc procedure='oper.pkg_romaneio_dml.prc_valida_itinerarios' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Valida as alteraes de itinerarios
	-- cristofer 26/10/2006 11:07:48 - CRIADO
	--->
	<cffunction name='valida_itinerarios_placa' displayname='itinerario' access='remote' returntype='Struct' output='true'>
		<cfargument name="placa" required="yes">
				<cfstoredproc procedure='oper.pkg_romaneio_dml.prc_valida_itinerarios_placa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.placa#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera um item do romaneio
	-- cristofer 26/10/2006 11:24:09 - CRIADO
	--->
	<cffunction name='upd_romaneio_item' displayname='Altera um item do romaneio' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='NUM_LOTE' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='VALOR_FRETE' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='REDESPACHO' required='yes'>
		<cfargument name='REM_COD_UF' required='yes'>
		<cfargument name='REM_COD_MUNICIPIO' required='yes'>
		<cfargument name='REM_COD_DISTRITO' required='yes'>
		<cfargument name='REM_COD_DV' required='yes'>
		<cfargument name='REM_MUNICIPIO_ID' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='DEST_COD_UF' required='yes'>
		<cfargument name='DEST_COD_MUNICIPIO' required='yes'>
		<cfargument name='DEST_COD_DISTRITO' required='yes'>
		<cfargument name='DEST_COD_DV' required='yes'>
		<cfargument name='DEST_MUNICIPIO_ID' required='yes'>
		<cfargument name='VALOR_FRETE_LIQUIDO' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='MANIFESTO_ID' required='no' default="">
		<cfargument name='ORDEM' required='no' default="">
		<cfargument name='ROTA_ID' required='no' default="">
		<cfargument name='DATA_PREVISAO' required='no' default="">
				<cfstoredproc procedure='oper.pkg_romaneio_dml.prc_alt_romaneio_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_LOTE#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO*1000#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_FRETE#'  null='#iif(len(trim(arguments.VALOR_FRETE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REDESPACHO#'  null='#iif(len(trim(arguments.REDESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REM_COD_UF#'  null='#iif(len(trim(arguments.REM_COD_UF)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REM_COD_MUNICIPIO#'  null='#iif(len(trim(arguments.REM_COD_MUNICIPIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REM_COD_DISTRITO#'  null='#iif(len(trim(arguments.REM_COD_DISTRITO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REM_COD_DV#'  null='#iif(len(trim(arguments.REM_COD_DV)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DEST_COD_UF#'  null='#iif(len(trim(arguments.DEST_COD_UF)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DEST_COD_MUNICIPIO#'  null='#iif(len(trim(arguments.DEST_COD_MUNICIPIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DEST_COD_DISTRITO#'  null='#iif(len(trim(arguments.DEST_COD_DISTRITO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DEST_COD_DV#'  null='#iif(len(trim(arguments.DEST_COD_DV)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_FRETE_LIQUIDO#'  null='#iif(len(trim(arguments.VALOR_FRETE_LIQUIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM#'  null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfscript>
				    if(len(trim(arguments.manifesto_id))) {
						this.vincula_roo_item(manifesto_id = arguments.manifesto_id,
											  roo_item_id  = arguments.item_id);
					}
					if(len(trim(arguments.rota_id))) {
						this.gera_itinerario_romaneio_item (	num_romaneio	= arguments.num_romaneio,
																item_id			= arguments.item_id,
																rota_id			= arguments.rota_id,
																data_previsao	= arguments.data_previsao,
																data_chegada	= '',
																vazio_carregado = 1);																
					}
															
				</cfscript>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um item do romaneio
	-- cristofer 26/10/2006 11:24:48 - CRIADO
	--->
	<cffunction name='del_romaneio_item' displayname='Exclui um item do romaneio' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
				<cfstoredproc procedure='oper.pkg_romaneio_dml.prc_del_romaneio_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	
	<!--- 
	-- PROPSITO
	-- Vincula um item do romaneio ao manifesto
	-- cristofer 26/10/2006 11:24:48 - CRIADO
	--->
	<cffunction name='vincula_roo_item' displayname='Vincula um item do romaneio ao manifesto' access='remote' returntype='Struct' output='true'>
		<cfargument name='manifesto_id' required='yes'>
		<cfargument name='roo_item_id' required='yes'>
				<cfstoredproc procedure='oper.pkg_manifesto_dml.prc_vincula_roo_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.manifesto_id#'  null='#iif(len(trim(arguments.manifesto_id)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.roo_item_id#'  null='#iif(len(trim(arguments.roo_item_id)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>


	
	<!--- 
	-- PROPSITO
	-- Atualiza a relao de itinerarios do veiculo
	-- cristofer 26/10/2006 11:24:48 - CRIADO
	--->
	<cffunction name='upd_itinerarios_placa' displayname='' access='remote' returntype='Struct' output='true'>
		<cfargument name='placa' required='yes'>
		<cftry>
			<cftransaction action="begin">
				<cfscript>
					v_plano_id = this.ListaToArray(lista = arguments, variavel = "ROTA_PLANO_ID_ITINERARIOS");
					v_itinerario_id = this.ListaToArray(lista = arguments, variavel = "ROTA_ITINERARIO_ID_ITINERARIOS");
					v_abreviatura = this.ListaToArray(lista = arguments, variavel = "ROTA_ABREVIATURA_ITINERARIOS");
					v_descricao = this.ListaToArray(lista = arguments, variavel = "ROTA_DESCRICAO_ITINERARIOS");
					v_cod_pessoa = this.ListaToArray(lista = arguments, variavel = "ROTA_COD_PESSOA_ITINERARIOS");
					v_rota_id = this.ListaToArray(lista = arguments, variavel = "ROTA_ID_ITINERARIOS");
					v_previsao = this.ListaToArray(lista = arguments, variavel = "ROTA_DATA_PREVISAO_ESTIMADO_ITINERARIOS");
					v_placa_referencia = this.ListaToArray(lista = arguments, variavel = "ROTA_PLACA_REFERENCIA_ITINERARIOS");
					v_data_origem = this.ListaToArray(lista = arguments, variavel = "ROTA_DATA_ORIGEM_ITINERARIOS");
					v_carregado = this.ListaToArray(lista = arguments, variavel = "ROTA_VAZIO_CARREGADO_ITINERARIOS");
					v_excluir = 	this.ListDiff(lista1 = arguments.lista_deleted_ITINERARIOS, lista2 = ArrayToList(v_itinerario_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_itinerario(itinerario_id   = l_item_id);
					</cfscript>
				</cfloop>				
				<cfloop from="1" to="#ArrayLen(v_itinerario_id)#" index="count">
					<cfscript>
						if(not len(trim(v_itinerario_id[count]))) {
							this.ins_itinerario(PLANO_ID				= v_plano_id[count],
												ROTA_ID					= v_rota_id[count],
												DATA_ORIGEM				= v_data_origem[count],
												COD_PESSOA				= v_cod_pessoa[count],
												PLACA_CONTROLE			= arguments.placa,
												PLACA_REFERENCIA		= v_placa_referencia[count],
												DATA_PREVISAO_ESTIMADO 	= v_previsao[count],
												vazio_carregado			= v_carregado[count]);
						} else {
							this.upd_itinerario(itinerario_id		= v_itinerario_id[count],
												PLANO_ID			= v_plano_id[count],
												ROTA_ID				= v_rota_id[count],
												DATA_ORIGEM			= v_data_origem[count],
												COD_PESSOA			= v_cod_pessoa[count],
												PLACA_CONTROLE		= arguments.placa,
												PLACA_REFERENCIA	= v_placa_referencia[count],
												DATA_PREVISAO_ESTIMADO = v_previsao[count],
												vazio_carregado			= v_carregado[count]);
						}
					</cfscript>
				</cfloop>				
				<cfscript>
					this.valida_itinerarios_placa(placa = arguments.placa);
				</cfscript>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Itinerrios ajustados com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera o status das mensagens do rastreador (conferido = 0).
	-- wagner 18/12/2006 09:16:44 - CRIADO
	--->
	<cffunction name='altera_status_msg' displayname='Altera o status das mensagens do rastreador (conferido = 0).' access='remote' returntype='Struct' output='true'>
		<cfargument name='MODELO_ID' required='yes'>
		<cfargument name='NUM_MENSAGEM' required='yes'>
		<cfargument name='CONFERIDO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='rastreador.pkg_rastreador.prc_alt_msg_retorno_logerr' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_MENSAGEM#'  null='#iif(len(trim(arguments.NUM_MENSAGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONFERIDO#'  null='#iif(len(trim(arguments.CONFERIDO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Status alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
		
	</cffunction>
	
	
	<!--- 
	-- PROPSITO
	-- Reintegra mensagens no integradas
	-- wagner 18/12/2006 17:10:08 - CRIADO
	--->
	<cffunction name='reintegra_macro' displayname='Reintegra mensagens no integradas' access='remote' returntype='Struct' output='true'>
		<cfargument name='MODELO_ID' required='yes'>
		<cfargument name='NUM_MENSAGEM' required='yes'>
		<cfargument name='DEBITAR_MOTORISTA' required='yes'>
				<cfstoredproc procedure='rastreador.pkg_rastreador.prc_reintegra_macro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_MENSAGEM#'  null='#iif(len(trim(arguments.NUM_MENSAGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DEBITAR_MOTORISTA#'  null='#iif(len(trim(arguments.DEBITAR_MOTORISTA)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Altera a msg na tabela referente a cada modelo de rastreador
	-- wagner 18/12/2006 17:15:14 - CRIADO
	--->
	
	<cffunction name='upd_macro_retorno' displayname='Altera a msg na tabela referente a cada modelo de rastreador' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_MENSAGEM' required='yes'>
		<cfargument name='MODELO_ID' required='yes'>
		<cfargument name='MENSAGEM' required='yes'>
		<cfargument name='REFERENCIA' required='yes'>
		<cfargument name='DATA_HORA' required='yes'>
		<cfargument name='LATITUDE' required='yes'>
		<cfargument name='LONGITUDE' required='yes'>
		<cfargument name='DEBITAR_MOTORISTA' required='yes'>
		<cfargument name="CONTROLE_EVO_ID" required="no" default="">
		<cfargument name="MOTIVO_ID" required="NO" default="">
		<cfargument name="OBSERVACAO" required="no" default="">
		<cftry>
			<cftransaction action='begin'>
            	<cfdump var="#arguments#">
					<cfstoredproc procedure='rastreador.pkg_rastreador.prc_alt_macro_retorno' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_MENSAGEM#'  null='#iif(len(trim(arguments.NUM_MENSAGEM)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MENSAGEM#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.REFERENCIA#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_HORA#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LATITUDE#'  null='#iif(len(trim(arguments.LATITUDE)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LONGITUDE#'  null='#iif(len(trim(arguments.LONGITUDE)), de('no'), de('yes'))#'>
					</cfstoredproc>
					<cfscript>
						this.reintegra_macro(	MODELO_ID		  = arguments.MODELO_ID,
												NUM_MENSAGEM	  = arguments.NUM_MENSAGEM,
												DEBITAR_MOTORISTA = arguments.DEBITAR_MOTORISTA);
						
						conn = CreateObject("component","_transportes.consulta.cfc_controle_trafego");
						qrMensagem = conn.get_controle_mensagens(num_mensagem = arguments.num_mensagem);
						retorno.integrada = 0;
						if(qrMensagem.recordcount eq 1 and qrMensagem.integrada eq 1) {
							retorno.integrada = 1;
						}
					</cfscript>
					
					<!---// Insere motivo se for macro de abastecimento--->
					<cfif Len(Trim(arguments.MOTIVO_ID))> 
						<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
							  insert into oper.v$consumo_comb_ocorrencia 
    								(controle_evo_id, motivo_id, observacao) 
   							  values
							  		(arguments.controle_evo_id, arguments.motivo_id, arguments.observacao); 
						</cfquery>
					</cfif>
					<cfset retorno.erro = false>
                    <cfif retorno.integrada eq 1>
						<cfset retorno.mensagem = JSStringFormat('Macro reintegrada com sucesso.')>
                    <cfelse>
                    	<cfset retorno.mensagem = JSStringFormat('No foi possvel reintegrar a macro!')>
                    </cfif>
                    
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Gera o itinerario para o item de romaneio
	-- cristofer 03/01/2007 20:00:04 - CRIADO
	--->
	<cffunction name='gera_itinerario_romaneio_item' displayname='Gera o itinerario para o item de romaneio' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'> 
		<cfargument name='ITEM_ID' required='no' default="">
		<cfargument name='ITINERARIO_ID' required='no' default="">
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='DATA_PREVISAO' required='yes'>
		<cfargument name='DATA_CHEGADA' required='yes'>
		<cfargument name='VAZIO_CARREGADO' required='yes'>
		<cfargument name='ORDEM' required='yes'>
        <cfargument name='DATA_INICIO' required='no' default="">
		<cftry>
				<cfstoredproc procedure='oper.pkg_itinerario.prc_gera_itinerario_romaneio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_PREVISAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_CHEGADA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VAZIO_CARREGADO#'  null='#iif(len(trim(arguments.VAZIO_CARREGADO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.ITINERARIO_ID' value="#arguments.itinerario_id#" null='#iif(len(trim(arguments.itinerario_id)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM#'  null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>					
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Itinerario gerado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui itinerario do romaneio
	-- guto 08/01/2007 10:40:15 - CRIADO
	--->
	<cffunction name='del_romaneio_itinerario_item' displayname='Exclui itinerario do romaneio' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITINERARIO_ID' required='yes'>
				<cfstoredproc procedure='oper.pkg_itinerario.prc_del_romaneio_itinerario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITINERARIO_ID#'  null='#iif(len(trim(arguments.ITINERARIO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere inicio de viagem para o veiculo
	-- guto 11/01/2007 11:20:47 - CRIADO
	--->
	<cffunction name='ins_inicio_viagem' displayname='Insere inicio de viagem para o veiculo' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA_CONTROLE' required='yes'>
		<cfargument name='PLACA_REFERENCIA' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_PESSOA_RESPONSAVEL' required='yes'>
		<cfargument name='DEDICADO' required='no' default="0">
		<cfargument name='VEICULO_PROPRIETARIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_romaneio_dml.prc_ins_inicio_viagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CONTROLE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_REFERENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value="#arguments.COD_PESSOA_filial#" null="#iif(len(trim(arguments.cod_pessoa_filial)),de('no'),de('yes'))#">


					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.NUM_ROMANEIO' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value="#arguments.COD_PESSOA_responsavel#" null="#iif(len(trim(arguments.COD_PESSOA_responsavel)),de('no'),de('yes'))#">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value="1">
				</cfstoredproc>
				
				<cfif arguments.SEGUE_VAZIO eq 1>
					<cfscript>
						v_itinerario_id = this.ListaToArray(lista = arguments, variavel = "ROTA_ITINERARIO_ID_ITINERARIOS");
						v_abreviatura 	= this.ListaToArray(lista = arguments, variavel = "ROTA_ABREVIATURA_ITINERARIOS");
						v_descricao 	= this.ListaToArray(lista = arguments, variavel = "ROTA_DESCRICAO_ITINERARIOS");
						v_rota_id 		= this.ListaToArray(lista = arguments, variavel = "ROTA_ID_ITINERARIOS");
						v_previsao 		= this.ListaToArray(lista = arguments, variavel = "ROTA_DATA_PREVISAO_ESTIMADO_ITINERARIOS");
						v_ordem 		= this.ListaToArray(lista = arguments, variavel = "ROTA_ORDEM_ITINERARIOS");
					</cfscript>
					<cfloop from="1" to="#ArrayLen(v_itinerario_id)#" index="count">
						<cfscript>
							set_item_romaneio = this.gera_itinerario_romaneio_item (	num_romaneio	= retorno.num_romaneio,
																						rota_id			= v_rota_id[count],
																						data_previsao	= v_previsao[count],
																						data_chegada	= '',
																						vazio_carregado = 0,
																						ordem           = v_ordem[count]);	
						</cfscript>
						<cfif set_item_romaneio.erro>
							<cfthrow object="#set_item_romaneio.mensagem#">
						</cfif>
						
					</cfloop>								
				</cfif>
                
                <cfif arguments.DEDICADO eq 1>
					<cfscript>
                        set_item = this.ins_romaneio_item	(num_romaneio		= retorno.num_romaneio
                                                            ,num_lote			= arguments.DEDICADO_NUM_LOTE
                                                            ,volume				= 0
                                                            ,cod_unidade		= 'Kg'
                                                            ,peso				= 0
                                                            ,m3					= 0
                                                            ,valor_frete		= 0
                                                            ,cod_remetente		= arguments.DEDICADO_COD_REMETENTE
                                                            ,redespacho			= 0
                                                            ,rem_cod_uf			= ''
                                                            ,rem_cod_municipio	= ''
                                                            ,rem_cod_distrito	= ''
                                                            ,rem_cod_dv			= ''
                                                            ,rem_municipio_id	= arguments.DEDICADO_ORG_MUNICIPIO_ID
                                                            ,cod_destinatario	= arguments.DEDICADO_COD_DESTINATARIO
                                                            ,dest_cod_uf		= ''
                                                            ,dest_cod_municipio	= ''
                                                            ,dest_cod_distrito	= ''
                                                            ,dest_cod_dv		= ''
                                                            ,dest_municipio_id	= arguments.DEDICADO_DEST_MUNICIPIO_ID
                                                            ,valor_frete_liquido= 0
                                                            ,despacho			= 0
                                                            ,observacao			= ''
                                                            ,manifesto_id		= ''
                                                            ,ordem				= 1
                                                            ,data_previsao		= ''
                                                            );
                        
                    </cfscript>
                    
                    <cfset arguments.item_id = set_item.item_id>
                
                    <cfscript>
                        conn = CreateObject("component","_transportes.consulta.cfc_controle_trafego");
                        qrRota = conn.get_rota(origem_municipio_id = arguments.DEDICADO_ORG_MUNICIPIO_ID,
                                               destino_municipio_id = iif(len(trim(arguments.DEDICADO_DEST_MUNICIPIO_ID)),de(arguments.DEDICADO_DEST_MUNICIPIO_ID),de(arguments.DEDICADO_ORG_MUNICIPIO_ID)));
                    </cfscript>
                    <cfif qrRota.recordcount neq 1>
                        <cfthrow message="No existe uma rota criada para o municipio da filial" detail="No existe uma rota criada para o municipio da filial">
                    </cfif>
                    <cfscript>
                        set_item_romaneio = this.gera_itinerario_romaneio_item (	num_romaneio	= retorno.num_romaneio,
                                                                                    item_id			= arguments.item_id,
                                                                                    rota_id			= qrRota.rota_id,
                                                                                    data_previsao	= LSDateFormat(dateAdd('d',1,now())),
                                                                                    data_chegada	= '',
                                                                                    vazio_carregado = 1,
                                                                                    ordem           = 1);	
                    </cfscript>
                    <cfif set_item_romaneio.erro>
                        <cfthrow object="#set_item_romaneio.mensagem#">
                    </cfif>

					<cfscript>
						v_coleta_entrega_id = this.ListaToArray(lista = arguments, variavel = 'COLETA_ENTREGA_ID_COLETA_ENTREGA');
						v_ordem 			= this.ListaToArray(lista = arguments, variavel = 'COLETA_ENTREGA_ORDEM_COLETA_ENTREGA');
						v_cliente 			= this.ListaToArray(lista = arguments, variavel = 'COLETA_ENTREGA_CLIENTE_COLETA_ENTREGA');
						v_referencia_id 	= this.ListaToArray(lista = arguments, variavel = 'COLETA_ENTREGA_REFERENCIA_ID_COLETA_ENTREGA');
						v_referencia 		= this.ListaToArray(lista = arguments, variavel = 'COLETA_ENTREGA_REFERENCIA_COLETA_ENTREGA');
						v_previsao_chegada 	= this.ListaToArray(lista = arguments, variavel = 'COLETA_ENTREGA_PREVISAO_CHEGADA_COLETA_ENTREGA');
						v_volume 			= this.ListaToArray(lista = arguments, variavel = 'COLETA_ENTREGA_VOLUME_COLETA_ENTREGA');
						v_excluir 			= this.ListDiff(lista1 = arguments.lista_deleted_COLETA_ENTREGA, lista2 = ArrayToList(v_coleta_entrega_id));
                	</cfscript>
                    
                    <cfloop list="#v_excluir#" index="l_id">
                    	<cfscript>
							ret = this.del_coleta_entrega(coleta_entrega_id = l_id);
						</cfscript>
                        <cfif ret.erro>
                        	<cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfloop>
                    
                    <cfloop from="1" to="#ArrayLen(v_coleta_entrega_id)#" index="count">
                    	<cfscript>
							if(not len(trim(v_coleta_entrega_id[count]))) {
								ret = this.ins_coleta_entrega( num_romaneio = retorno.num_romaneio,
																		coleta_entrega = 1,
																		evo_inicio = '',
																		evo_termino = '',
																		referencia_id = v_referencia_id[count],
																		cod_pessoa_cliente = '',
																		cliente = v_cliente[count],
																		previsao_chegada = v_previsao_chegada[count],
																		num_relatorio = arguments.num_relatorio,
																		volume = v_volume[count]);
							} else {
								ret = this.upd_coleta_entrega( coleta_entrega_id = v_coleta_entrega_id[count],
																		evo_inicio = '',
																		evo_termino = '',
																		referencia_id = v_referencia_id[count],
																		cod_pessoa_cliente = '',
																		cliente = v_cliente[count],
																		previsao_chegada = v_previsao_chegada[count],
																		num_relatorio = arguments.num_relatorio,
																		volume = v_volume[count]);
							}
						</cfscript>
                        <cfif ret.erro>
                        	<cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfloop>
                </cfif>
				<cfif arguments.INTERNACIONAL eq 1>
					<cfscript>
						v_itinerario_id = this.ListaToArray(lista = arguments, variavel = "ROTAC_ITINERARIO_ID_ROTA_CARREGADO");
						v_num_lote		= this.ListaToArray(lista = arguments, variavel = "NUM_LOTE_ROTA_CARREGADO");
						v_cod_remetente = this.ListaToArray(lista = arguments, variavel = "COD_REMETENTE_ROTA_CARREGADO");
						v_cod_destinatario = this.ListaToArray(lista = arguments, variavel = "COD_DESTINATARIO_ROTA_CARREGADO");
						v_abreviatura 	= this.ListaToArray(lista = arguments, variavel = "ROTAC_ABREVIATURA_ROTA_CARREGADO");
						v_descricao 	= this.ListaToArray(lista = arguments, variavel = "ROTAC_DESCRICAO_ROTA_CARREGADO");
						v_rota_id 		= this.ListaToArray(lista = arguments, variavel = "ROTAC_ID_ROTA_CARREGADO");
						v_previsao 		= this.ListaToArray(lista = arguments, variavel = "ROTAC_DATA_PREVISAO_ESTIMADO_ROTA_CARREGADO");
						v_ordem 		= this.ListaToArray(lista = arguments, variavel = "ROTAC_ORDEM_ROTA_CARREGADO");
						v_org_municipio_id = this.ListaToArray(lista = arguments, variavel = "ORG_MUNICIPIO_ID_ROTA_CARREGADO");
						v_dest_municipio_id = this.ListaToArray(lista = arguments, variavel = "DEST_MUNICIPIO_ID_ROTA_CARREGADO");
					</cfscript>

					<cfloop from="1" to="#ArrayLen(v_itinerario_id)#" index="count">
						<cfscript>
							set_item = this.ins_romaneio_item	(num_romaneio		= retorno.num_romaneio
																,num_lote			= v_num_lote[count]
																,volume				= 0
																,cod_unidade		= 'Kg'
																,peso				= 0
																,m3					= 0
																,valor_frete		= 0
																,cod_remetente		= v_cod_remetente[count]
																,redespacho			= 0
																,rem_cod_uf			= ''
																,rem_cod_municipio	= ''
																,rem_cod_distrito	= ''
																,rem_cod_dv			= ''
																,rem_municipio_id	= v_org_municipio_id[count]
																,cod_destinatario	= v_cod_destinatario[count]
																,dest_cod_uf		= ''
																,dest_cod_municipio	= ''
																,dest_cod_distrito	= ''
																,dest_cod_dv		= ''
																,dest_municipio_id	= v_dest_municipio_id[count]
																,valor_frete_liquido= 0
																,despacho			= 0
																,observacao			= ''
																,manifesto_id		= ''
																,ordem				= v_ordem[count]
																,data_previsao		= ''
																);
							
						</cfscript>
						
						<cfset arguments.item_id = set_item.item_id>
					
						<cfscript>
							set_item_romaneio = this.gera_itinerario_romaneio_item (	num_romaneio	= retorno.num_romaneio,
																						item_id			= arguments.item_id,
																						rota_id			= v_rota_id[count],
																						data_previsao	= v_previsao[count],
																						data_chegada	= '',
																						vazio_carregado = 1,
																						ordem           = v_ordem[count]);	
						</cfscript>
						<cfif set_item_romaneio.erro>
							<cfthrow object="#set_item_romaneio.mensagem#">
						</cfif>
					</cfloop>								

					<cfscript>
						v_conhecimento_id = this.ListaToArray(lista = arguments, variavel = "INTC_CONHECIMENTO_ID_CRTS");
					</cfscript>

					<cfloop from="1" to="#ArrayLen(v_conhecimento_id)#" index="count">
						<cfscript>
							set_item = this.ins_romaneio_intc_conhecimento	(num_romaneio		= retorno.num_romaneio
																			,conhecimento_id	= v_conhecimento_id[count]);
						</cfscript>
						<cfif set_item.erro>
							<cfthrow object="#set_item.mensagem#">
						</cfif>
					</cfloop>								


				</cfif>

				<cfif arguments.SUBCONTRATADO eq 1>
					<cfscript>
						v_itinerario_id = this.ListaToArray(lista = arguments, variavel = "ROTAS_ITINERARIO_ID_ROTAS");
						v_num_lote		= this.ListaToArray(lista = arguments, variavel = "ROTAS_NUM_LOTE_ROTAS");
						v_cod_remetente = this.ListaToArray(lista = arguments, variavel = "ROTAS_COD_REMETENTE_ROTAS");
						v_cod_destinatario = this.ListaToArray(lista = arguments, variavel = "ROTAS_COD_DESTINATARIO_ROTAS");
						v_abreviatura 	= this.ListaToArray(lista = arguments, variavel = "ROTAS_ABREVIATURA_ROTAS");
						v_descricao 	= this.ListaToArray(lista = arguments, variavel = "ROTAS_DESCRICAO_ROTAS");
						v_rota_id 		= this.ListaToArray(lista = arguments, variavel = "ROTAS_ID_ROTAS");
						v_previsao 		= this.ListaToArray(lista = arguments, variavel = "ROTAS_DATA_PREVISAO_ESTIMADO_ROTAS");
						v_ordem 		= this.ListaToArray(lista = arguments, variavel = "ROTAS_ORDEM_ROTAS");
						v_org_municipio_id = this.ListaToArray(lista = arguments, variavel = "ROTAS_ORG_MUNICIPIO_ID_ROTAS");
						v_dest_municipio_id = this.ListaToArray(lista = arguments, variavel = "ROTAS_DEST_MUNICIPIO_ID_ROTAS");
					</cfscript>

					<cfloop from="1" to="#ArrayLen(v_itinerario_id)#" index="count">
						<cfscript>
							set_item = this.ins_romaneio_item	(num_romaneio		= retorno.num_romaneio
																,num_lote			= v_num_lote[count]
																,volume				= 0
																,cod_unidade		= 'Kg'
																,peso				= 0
																,m3					= 0
																,valor_frete		= 0
																,cod_remetente		= v_cod_remetente[count]
																,redespacho			= 0
																,rem_cod_uf			= ''
																,rem_cod_municipio	= ''
																,rem_cod_distrito	= ''
																,rem_cod_dv			= ''
																,rem_municipio_id	= v_org_municipio_id[count]
																,cod_destinatario	= v_cod_destinatario[count]
																,dest_cod_uf		= ''
																,dest_cod_municipio	= ''
																,dest_cod_distrito	= ''
																,dest_cod_dv		= ''
																,dest_municipio_id	= v_dest_municipio_id[count]
																,valor_frete_liquido= 0
																,despacho			= 0
																,observacao			= ''
																,manifesto_id		= ''
																,ordem				= v_ordem[count]
																,data_previsao		= ''
																);
							
						</cfscript>
						
						<cfset arguments.item_id = set_item.item_id>
					
						<cfscript>
							set_item_romaneio = this.gera_itinerario_romaneio_item (	num_romaneio	= retorno.num_romaneio,
																						item_id			= arguments.item_id,
																						rota_id			= v_rota_id[count],
																						data_previsao	= v_previsao[count],
																						data_chegada	= '',
																						vazio_carregado = 1,
																						ordem           = v_ordem[count]);	
						</cfscript>
						<cfif set_item_romaneio.erro>
							<cfthrow object="#set_item_romaneio.mensagem#">
						</cfif>
					</cfloop>								


					<cfscript>
						v_conhecimento_id = this.ListaToArray(lista = arguments, variavel = "INTC_CONHECIMENTO_ID_CRTS");
					</cfscript>

					<cfloop from="1" to="#ArrayLen(v_conhecimento_id)#" index="count">
						<cfscript>
							set_item = this.ins_romaneio_intc_conhecimento	(num_romaneio		= retorno.num_romaneio,
																			conhecimento_id		= v_conhecimento_id[count]);
						</cfscript>
						
						<cfif set_item.erro>
							<cfthrow object="#set_item.mensagem#">
						</cfif>
					</cfloop>								
                    
				</cfif>
				<cfif arguments.veiculo_proprietario eq 2>
                    <cfscript>
                        conn = CreateComponent("_transportes.manipulacao.cfc_agregados");
                        ret = conn.ins_viagem_despacho(
                                        num_romaneio		= retorno.NUM_ROMANEIO,
                                        gerar_cfa			= 0,
                                        num_formulario		= 0,
                                        valor_servico		= 0,
                                        valor_adiantamento	= 0,
                                        cancelar_viagem		= 0
                                        );
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Inicio de viagem inserido com sucesso! Romaneio: ' & #Round(retorno.NUM_ROMANEIO)#)>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Altera inicio de viagem para o veiculo
	-- guto 11/01/2007 11:20:47 - CRIADO
	--->
	<cffunction name='upd_inicio_viagem' displayname='Insere inicio de viagem para o veiculo' access='remote' returntype='Struct' output='true'>
		<cfargument name='VEICULO_PROPRIETARIO' required='yes'>
		<cftry>
			<cfstoredproc procedure='oper.pkg_romaneio_dml.prc_alt_inicio_viagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value="#session.COD_PESSOA#">

				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value="#session.COD_PESSOA#">
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value="1">
			</cfstoredproc>
			<cfset retorno.num_romaneio = arguments.num_romaneio>

			<cftransaction action='begin'>
				<cfif arguments.SEGUE_VAZIO eq 1>
					<cfscript>
						v_itinerario_id = this.ListaToArray(lista = arguments, variavel = "ROTA_ITINERARIO_ID_ITINERARIOS");
						v_abreviatura 	= this.ListaToArray(lista = arguments, variavel = "ROTA_ABREVIATURA_ITINERARIOS");
						v_descricao 	= this.ListaToArray(lista = arguments, variavel = "ROTA_DESCRICAO_ITINERARIOS");
						v_rota_id 		= this.ListaToArray(lista = arguments, variavel = "ROTA_ID_ITINERARIOS");
						v_previsao 		= this.ListaToArray(lista = arguments, variavel = "ROTA_DATA_PREVISAO_ESTIMADO_ITINERARIOS");
						v_ordem 		= this.ListaToArray(lista = arguments, variavel = "ROTA_ORDEM_ITINERARIOS");
						v_excluir 		= this.ListDiff(lista1 = arguments.lista_deleted_ITINERARIOS, lista2 = ArrayToList(v_itinerario_id));
					</cfscript>

					<cfloop list="#v_excluir#" delimiters="," index="l_item_id">
						<cfscript>
							this.del_romaneio_itinerario_item(itinerario_id   = l_item_id);
						</cfscript>
					</cfloop>				
					
					<cfloop from="1" to="#ArrayLen(v_itinerario_id)#" index="count">
						<cfscript>
							if (not Len(v_itinerario_id[count])) {
								set_item_romaneio = this.gera_itinerario_romaneio_item (	num_romaneio	= arguments.num_romaneio,
																							rota_id			= v_rota_id[count],
																							data_previsao	= v_previsao[count],
																							data_chegada	= '',
																							vazio_carregado = 0,
																							ordem           = v_ordem[count]);	
							}										
						</cfscript>
						<cfif not Len(v_itinerario_id[count]) and set_item_romaneio.erro>
							<cfthrow object="#set_item_romaneio.mensagem#">
						</cfif>
					</cfloop>								
				</cfif>
                <cfif arguments.DEDICADO eq 1>
						<cfscript>
							set_item = this.ins_romaneio_item	(num_romaneio		= retorno.num_romaneio
																,num_lote			= arguments.DEDICADO_NUM_LOTE
																,volume				= 0
																,cod_unidade		= 'Kg'
																,peso				= 0
																,m3					= 0
																,valor_frete		= 0
																,cod_remetente		= arguments.DEDICADO_COD_REMETENTE
																,redespacho			= 0
																,rem_cod_uf			= ''
																,rem_cod_municipio	= ''
																,rem_cod_distrito	= ''
																,rem_cod_dv			= ''
																,rem_municipio_id	= arguments.DEDICADO_ORG_MUNICIPIO_ID
																,cod_destinatario	= arguments.DEDICADO_COD_DESTINATARIO
																,dest_cod_uf		= ''
																,dest_cod_municipio	= ''
																,dest_cod_distrito	= ''
																,dest_cod_dv		= ''
																,dest_municipio_id	= arguments.DEDICADO_DEST_MUNICIPIO_ID
																,valor_frete_liquido= 0
																,despacho			= 0
																,observacao			= ''
																,manifesto_id		= ''
																,ordem				= 1
																,data_previsao		= ''
																);
							
						</cfscript>
						
						<cfset arguments.item_id = set_item.item_id>
					
						<cfscript>
							conn = CreateObject("component","_transportes.consulta.cfc_controle_trafego");
						    qrRota = conn.get_rota(origem_municipio_id = arguments.DEDICADO_ORG_MUNICIPIO_ID,
												   destino_municipio_id = iif(len(trim(arguments.DEDICADO_DEST_MUNICIPIO_ID)),de(arguments.DEDICADO_DEST_MUNICIPIO_ID),de(arguments.DEDICADO_ORG_MUNICIPIO_ID)));
						</cfscript>
                        <cfif qrRota.recordcount neq 1>
							<cfthrow message="No existe uma rota criada para o municipio da filial" detail="No existe uma rota criada para o municipio da filial">
						</cfif>
                        <cfscript>
							set_item_romaneio = this.gera_itinerario_romaneio_item (	num_romaneio	= retorno.num_romaneio,
																						item_id			= arguments.item_id,
																						rota_id			= qrRota.rota_id,
																						data_previsao	= LSDateFormat(dateAdd('d',1,now())),
																						data_chegada	= '',
																						vazio_carregado = 1,
																						ordem           = 1);	
						</cfscript>
						<cfif set_item_romaneio.erro>
							<cfthrow object="#set_item_romaneio.mensagem#">
						</cfif>   
                        
                        
					<cfscript>
						v_coleta_entrega_id = this.ListaToArray(lista = arguments, variavel = 'COLETA_ENTREGA_ID_COLETA_ENTREGA');
						v_ordem 			= this.ListaToArray(lista = arguments, variavel = 'COLETA_ENTREGA_ORDEM_COLETA_ENTREGA');
						v_cliente 			= this.ListaToArray(lista = arguments, variavel = 'COLETA_ENTREGA_CLIENTE_COLETA_ENTREGA');
						v_referencia_id 	= this.ListaToArray(lista = arguments, variavel = 'COLETA_ENTREGA_REFERENCIA_ID_COLETA_ENTREGA');
						v_referencia 		= this.ListaToArray(lista = arguments, variavel = 'COLETA_ENTREGA_REFERENCIA_COLETA_ENTREGA');
						v_previsao_chegada 	= this.ListaToArray(lista = arguments, variavel = 'COLETA_ENTREGA_PREVISAO_CHEGADA_COLETA_ENTREGA');
						v_volume 			= this.ListaToArray(lista = arguments, variavel = 'COLETA_ENTREGA_VOLUME_COLETA_ENTREGA');
						v_excluir 			= this.ListDiff(lista1 = arguments.lista_deleted_COLETA_ENTREGA, lista2 = ArrayToList(v_coleta_entrega_id));
                	</cfscript>
                    
                    <cfloop list="#v_excluir#" index="l_id">
                    	<cfscript>
							ret = this.del_coleta_entrega(coleta_entrega_id = l_id);
						</cfscript>
                        <cfif ret.erro>
                        	<cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfloop>
                    
                    <cfloop from="1" to="#ArrayLen(v_coleta_entrega_id)#" index="count">
                    	<cfscript>
							if(not len(trim(v_coleta_entrega_id[count]))) {
								ret = this.ins_coleta_entrega( num_romaneio = retorno.num_romaneio,
																		coleta_entrega = 1,
																		evo_inicio = '',
																		evo_termino = '',
																		referencia_id = v_referencia_id[count],
																		cod_pessoa_cliente = '',
																		cliente = v_cliente[count],
																		previsao_chegada = v_previsao_chegada[count],
																		num_relatorio = arguments.num_relatorio,
																		volume = v_volume[count]);
							} else {
								ret = this.upd_coleta_entrega( coleta_entrega_id = v_coleta_entrega_id[count],
																		evo_inicio = '',
																		evo_termino = '',
																		referencia_id = v_referencia_id[count],
																		cod_pessoa_cliente = '',
																		cliente = v_cliente[count],
																		previsao_chegada = v_previsao_chegada[count],
																		num_relatorio = arguments.num_relatorio,
																		volume = v_volume[count]);
							}
						</cfscript>
                        <cfif ret.erro>
                        	<cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfloop>             	
                </cfif>

				<cfif arguments.INTERNACIONAL eq 1>
					<cfscript>
						v_itinerario_id_carregado = this.ListaToArray(lista = arguments, variavel = "ROTAC_ITINERARIO_ID_ROTA_CARREGADO");
						v_item_id	    = this.ListaToArray(lista = arguments, variavel = "ITEM_ID_ROTA_CARREGADO");
						v_num_lote		= this.ListaToArray(lista = arguments, variavel = "NUM_LOTE_ROTA_CARREGADO");
						v_cod_remetente = this.ListaToArray(lista = arguments, variavel = "COD_REMETENTE_ROTA_CARREGADO");
						v_cod_destinatario = this.ListaToArray(lista = arguments, variavel = "COD_DESTINATARIO_ROTA_CARREGADO");
						v_abreviatura 	= this.ListaToArray(lista = arguments, variavel = "ROTAC_ABREVIATURA_ROTA_CARREGADO");
						v_descricao 	= this.ListaToArray(lista = arguments, variavel = "ROTAC_DESCRICAO_ROTA_CARREGADO");
						v_rota_id 		= this.ListaToArray(lista = arguments, variavel = "ROTAC_ID_ROTA_CARREGADO");
						v_previsao 		= this.ListaToArray(lista = arguments, variavel = "ROTAC_DATA_PREVISAO_ESTIMADO_ROTA_CARREGADO");
						v_ordem 		= this.ListaToArray(lista = arguments, variavel = "ROTAC_ORDEM_ROTA_CARREGADO");
						v_org_municipio_id = this.ListaToArray(lista = arguments, variavel = "ORG_MUNICIPIO_ID_ROTA_CARREGADO");
						v_dest_municipio_id = this.ListaToArray(lista = arguments, variavel = "DEST_MUNICIPIO_ID_ROTA_CARREGADO");
					</cfscript>
					
					<cfloop list="#arguments.lista_deleted_ROTA_CARREGADO#" delimiters="," index="l_item_id">
						<cfdump var="#l_item_id#">
						<cfscript>
							this.del_romaneio_item_itinerario(num_romaneio = arguments.num_romaneio,
							                                  item_id = GetToken(l_item_id,2,'_'),
															  itinerario_id = GetToken(l_item_id,1,'_'));
						</cfscript>
					</cfloop>				
					
					<cfloop from="1" to="#ArrayLen(v_itinerario_id_carregado)#" index="count">
						<cfscript>
						    if (not Len(Trim(v_itinerario_id_carregado[count]))) {
								set_item = this.ins_romaneio_item	(num_romaneio		= arguments.num_romaneio
																	,num_lote			= v_num_lote[count]
																	,volume				= 0
																	,cod_unidade		= 'Kg'
																	,peso				= 0
																	,m3					= 0
																	,valor_frete		= 0
																	,cod_remetente		= v_cod_remetente[count]
																	,redespacho			= 0
																	,rem_cod_uf			= ''
																	,rem_cod_municipio	= ''
																	,rem_cod_distrito	= ''
																	,rem_cod_dv			= ''
																	,rem_municipio_id	= v_org_municipio_id[count]
																	,cod_destinatario	= v_cod_destinatario[count]
																	,dest_cod_uf		= ''
																	,dest_cod_municipio	= ''
																	,dest_cod_distrito	= ''
																	,dest_cod_dv		= ''
																	,dest_municipio_id	= v_dest_municipio_id[count]
																	,valor_frete_liquido= 0
																	,despacho			= 0
																	,observacao			= ''
																	,manifesto_id		= ''
																	,ordem				= v_ordem[count]
																	,data_previsao		= ''
																	);

                                set_item_romaneio = this.gera_itinerario_romaneio_item (
								                                            num_romaneio	= arguments.num_romaneio,
                                                                            item_id			= set_item.item_id,
                                                                            rota_id			= v_rota_id[count],
                                                                            data_previsao	= v_previsao[count],
                                                                            data_chegada	= '',
                                                                            vazio_carregado = 1,
                                                                            ordem           = v_ordem[count]);	
																	
							 }							
						</cfscript>
						<cfif IsDefined("set_item_romaneio") and set_item_romaneio.erro>
                            <cfthrow object="#set_item_romaneio.mensagem#">
                        </cfif>
					</cfloop>					
                    
					<cfscript>
						v_conhecimento_id = this.ListaToArray(lista = arguments, variavel = "INTC_CONHECIMENTO_ID_CRTS");
						v_excluir 			= this.ListDiff(lista1 = arguments.lista_deleted_CRTS, lista2 = ArrayToList(v_conhecimento_id));
					</cfscript>

					<cfloop list="#v_excluir#" index="l_id">
						<cfscript>
							set_item = this.del_romaneio_intc_conhecimento	(num_romaneio		= retorno.num_romaneio
																			,conhecimento_id	= l_id);
						</cfscript>
						<cfif set_item.erro>
							<cfthrow object="#set_item.mensagem#">
						</cfif>
					</cfloop>								
					
					<cfloop from="1" to="#ArrayLen(v_conhecimento_id)#" index="count">
						<cfscript>
							set_item = this.ins_romaneio_intc_conhecimento	(num_romaneio		= retorno.num_romaneio
																			,conhecimento_id	= v_conhecimento_id[count]);
						</cfscript>
						<cfif set_item.erro>
							<cfthrow object="#set_item.mensagem#">
						</cfif>
					</cfloop>								
                    			
				</cfif>				
				<cfif arguments.SUBCONTRATADO eq 1>
					<cfscript>
						v_itinerario_id = this.ListaToArray(lista = arguments, variavel = "ROTAS_ITINERARIO_ID_ROTAS");
						v_num_lote		= this.ListaToArray(lista = arguments, variavel = "ROTAS_NUM_LOTE_ROTAS");
						v_cod_remetente = this.ListaToArray(lista = arguments, variavel = "ROTAS_COD_REMETENTE_ROTAS");
						v_cod_destinatario = this.ListaToArray(lista = arguments, variavel = "ROTAS_COD_DESTINATARIO_ROTAS");
						v_abreviatura 	= this.ListaToArray(lista = arguments, variavel = "ROTAS_ABREVIATURA_ROTAS");
						v_descricao 	= this.ListaToArray(lista = arguments, variavel = "ROTAS_DESCRICAO_ROTAS");
						v_rota_id 		= this.ListaToArray(lista = arguments, variavel = "ROTAS_ID_ROTAS");
						v_previsao 		= this.ListaToArray(lista = arguments, variavel = "ROTAS_DATA_PREVISAO_ESTIMADO_ROTAS");
						v_ordem 		= this.ListaToArray(lista = arguments, variavel = "ROTAS_ORDEM_ROTAS");
						v_org_municipio_id = this.ListaToArray(lista = arguments, variavel = "ROTAS_ORG_MUNICIPIO_ID_ROTAS");
						v_dest_municipio_id = this.ListaToArray(lista = arguments, variavel = "ROTAS_DEST_MUNICIPIO_ID_ROTAS");
					</cfscript>

					<cfloop from="1" to="#ArrayLen(v_itinerario_id)#" index="count">
						<cfscript>
							set_item = this.ins_romaneio_item	(num_romaneio		= arguments.num_romaneio
																,num_lote			= v_num_lote[count]
																,volume				= 0
																,cod_unidade		= 'Kg'
																,peso				= 0
																,m3					= 0
																,valor_frete		= 0
																,cod_remetente		= v_cod_remetente[count]
																,redespacho			= 0
																,rem_cod_uf			= ''
																,rem_cod_municipio	= ''
																,rem_cod_distrito	= ''
																,rem_cod_dv			= ''
																,rem_municipio_id	= v_org_municipio_id[count]
																,cod_destinatario	= v_cod_destinatario[count]
																,dest_cod_uf		= ''
																,dest_cod_municipio	= ''
																,dest_cod_distrito	= ''
																,dest_cod_dv		= ''
																,dest_municipio_id	= v_dest_municipio_id[count]
																,valor_frete_liquido= 0
																,despacho			= 0
																,observacao			= ''
																,manifesto_id		= ''
																,ordem				= v_ordem[count]
																,data_previsao		= ''
																);
							
						</cfscript>
						
						<cfset arguments.item_id = set_item.item_id>
					
						<cfscript>
							set_item_romaneio = this.gera_itinerario_romaneio_item (	num_romaneio	= arguments.num_romaneio,
																						item_id			= arguments.item_id,
																						rota_id			= v_rota_id[count],
																						data_previsao	= v_previsao[count],
																						data_chegada	= '',
																						vazio_carregado = 1,
																						ordem           = v_ordem[count]);	
						</cfscript>
						<cfif set_item_romaneio.erro>
							<cfthrow object="#set_item_romaneio.mensagem#">
						</cfif>
					</cfloop>
				</cfif>
                <cfscript>
					conn = CreateComponent("_transportes.consulta.cfc_controle_trafego");
					qrAgregViagem = conn.get_romaneio_agreg_viagem_vazio(num_romaneio = arguments.num_romaneio);
				</cfscript>
				<cfif qrAgregViagem.recordcount>
                    <cfif arguments.veiculo_proprietario eq 2 >
						<cfscript>
                            conn = CreateComponent("_transportes.manipulacao.cfc_agregados");
							ret = conn.ins_viagem_despacho(
											num_romaneio		= arguments.num_romaneio,
											gerar_cfa			= 0,
											num_formulario		= 0,
											valor_servico		= 0,
											valor_adiantamento	= 0,
											cancelar_viagem		= arguments.CANCELAR_VIAGEM_ANTERIOR
											);
                        </cfscript>
                        <cfif ret.erro>
                        	<cfthrow object="#ret.mensagem#">
                        </cfif>
                    <cfelse>
						<cfscript>
                            conn = CreateComponent("_transportes.consulta.cfc_agregados");
							ret = conn.cancelar_viagem(viagem_id = qrAgregViagem.viagem_id);
                        </cfscript>
                        <cfif ret.erro>
                        	<cfthrow object="#ret.mensagem#">
                        </cfif>                    	
                    </cfif>
                </cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Veculo redestinado com sucesso! Romaneio: ' & Round(arguments.NUM_ROMANEIO))>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui o romaneio item e tambem itinerario
	-- guto 13/01/2007 11:14:26 - CRIADO
	--->
	<cffunction name='del_romaneio_item_itinerario' displayname='Exclui o romaneio item e tambem itinerario' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='ITINERARIO_ID' required='yes'>
				<cfstoredproc procedure='oper.pkg_itinerario.prc_del_itinerario_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITINERARIO_ID#'  null='#iif(len(trim(arguments.ITINERARIO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn StructNew() />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere itinerario ao item do romaneio
	-- guto 11/01/2007 19:13:11 - CRIADO
	--->
	<cffunction name='ins_itinerario_item_romaneio' displayname='Insere itinerario ao item do romaneio' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='MUNICIPIO_ORIGEM_ID' required='yes'>
		<cfargument name='MUNICIPIO_DESTINO_ID' required='yes'>
		<cftry> 
				<cfstoredproc procedure='oper.pkg_itinerario.prc_ins_itinerario_romaneio_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='cf_sql_integer'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MUNICIPIO_ORIGEM_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ORIGEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MUNICIPIO_DESTINO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_DESTINO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.ITINERARIO_ID' >
					<cfprocparam type='OUT' cfsqltype='cf_sql_varchar'  variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Veculo redestinado com sucesso! Romaneio: ' & #Round(arguments.NUM_ROMANEIO)#)>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera o itinerrio de um romaneio.
	-- wagner 09/02/2007 14:02:24 - CRIADO
	--->
	<cffunction name='upd_romaneio_itinerario' displayname='Altera o itinerrio de um romaneio.' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITINERARIO_ID' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='PLACA_REFERENCIA' required='yes'>
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='DATA_PREVISAO' required='yes'>
		<cfargument name='DATA_CHEGADA' required='yes'>
		<cfargument name='VAZIO_CARREGADO' required='yes'>
		<cfargument name='ITINERARIO_ID_ANTERIOR' required='yes'>
		<cfargument name='ITINERARIO_ID_POSTERIOR' required='yes'>
		<cfargument name='ORDEM' required='yes'>
				<cfstoredproc procedure='oper.pkg_itinerario.prc_alt_romaneio_itinerario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITINERARIO_ID#'  null='#iif(len(trim(arguments.ITINERARIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_REFERENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_PREVISAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_CHEGADA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VAZIO_CARREGADO#'  null='#iif(len(trim(arguments.VAZIO_CARREGADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITINERARIO_ID_ANTERIOR#'  null='#iif(len(trim(arguments.ITINERARIO_ID_ANTERIOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITINERARIO_ID_POSTERIOR#'  null='#iif(len(trim(arguments.ITINERARIO_ID_POSTERIOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM#'  null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Altera o itinerrio de um veiculo.
	-- wagner 09/02/2007 - CRIADO
	--->
	<cffunction name='upd_itinerario_veiculo' displayname='Altera o itinerrio de um romaneio.' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='ITINERARIO_ID' required='yes'>
		<cfargument name='KM_ROTA' required='yes'>
		<cfargument name='VAZIO_CARREGADO' required='yes'>
		<cfargument name='ABREVIATURA' required='yes'>
		<cfargument name='CONTROLE' required='yes'>
		<cfargument name='ITINERARIO_ID_ANTERIOR' required='yes'>
		<cfargument name='ITINERARIO_ID_POSTERIOR' required='yes'>
		<cfargument name='ORDEM' required='yes'>
		<cfargument name='PLACA_REFERENCIA' required='yes'>
		<cftry>
			<cftransaction action="begin">
				<cfscript>
					v_num_romaneio = this.ListaToArray(lista = arguments, variavel 			  = "NUM_ROMANEIO_ITINERARIOS");
					v_rota_id = this.ListaToArray(lista = arguments, variavel 				  = "ROTA_ID_ITINERARIOS");
					v_itinerario_id = this.ListaToArray(lista = arguments, variavel 		  = "ITINERARIO_ID_ITINERARIOS");
					v_km_rota = this.ListaToArray(lista = arguments, variavel 				  = "KM_ROTA_ITINERARIOS");
					v_vazio_carregado = this.ListaToArray(lista = arguments, variavel 		  = "VAZIO_CARREGADO_ITINERARIOS");
					v_abreviatura = this.ListaToArray(lista = arguments, variavel 			  = "ROTA_ABREVIATURA_ITINERARIOS");
					v_controle = this.ListaToArray(lista = arguments, variavel 			  	  = "CONTROLE_ITINERARIOS");
					v_itinerario_id_anterior = this.ListaToArray(lista = arguments, variavel  = "ITINERARIO_ID_ANTERIOR_ITINERARIOS");
					v_itinerario_id_posterior = this.ListaToArray(lista = arguments, variavel = "ITINERARIO_ID_POSTERIOR_ITINERARIOS");
					v_data_previsao = this.ListaToArray(lista = arguments, variavel 		  = "DATA_PREVISAO_ITINERARIOS");
					v_data_chegada = this.ListaToArray(lista = arguments, variavel 			  = "DATA_CHEGADA_ITINERARIOS");
					v_ordem = this.ListaToArray(lista = arguments, variavel 				  = "ORDEM_ITINERARIOS");
					v_excluir = 	this.ListDiff(lista1 = arguments.lista_deleted_ITINERARIOS, lista2 = ArrayToList(v_itinerario_id));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_romaneio_itinerario_item(itinerario_id   = l_item_id);
					</cfscript>
				</cfloop>				
				<cfloop from="1" to="#ArrayLen(v_itinerario_id)#" index="count">
					<cfscript>
						if(v_controle[count] eq 1) {
							this.upd_romaneio_itinerario( 	ITINERARIO_ID			= v_itinerario_id[count] ,
															NUM_ROMANEIO			= v_num_romaneio[count] ,
															PLACA_REFERENCIA		= arguments.placa_referencia ,
															ROTA_ID					= v_rota_id[count] ,
															DATA_PREVISAO			= v_data_previsao[count] ,
															DATA_CHEGADA			= v_data_chegada[count] ,
															VAZIO_CARREGADO			= v_vazio_carregado[count] ,
															ITINERARIO_ID_ANTERIOR	= v_itinerario_id_anterior[count] ,
															ITINERARIO_ID_POSTERIOR	= v_itinerario_id_posterior[count] ,
															ORDEM					= v_ordem[count]);
						} 
					</cfscript>
				</cfloop>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Itinerrios ajustados com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno/>
	</cffunction>	
    
    
    <!--- 
    -- PROPSITO
    -- Insere uma coleta/entrega para o romaneio
    -- cristofer 22/08/2007 11:40:39 - CRIADO
    --->
    <cffunction name='ins_coleta_entrega' displayname='Insere uma coleta/entrega para o romaneio' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='COLETA_ENTREGA' required='yes'>
        <cfargument name='EVO_INICIO' required='yes'>
        <cfargument name='EVO_TERMINO' required='yes'>
        <cfargument name='REFERENCIA_ID' required='yes'>
        <cfargument name='COD_PESSOA_CLIENTE' required='yes'>
        <cfargument name='CLIENTE' required='yes'>
        <cfargument name='PREVISAO_CHEGADA' required='yes'>
        <cfargument name='VOLUME' required='yes'>
        <cfargument name='NUM_RELATORIO' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_coleta_entrega.prc_ins_coleta_entrega' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EVO_INICIO#'  null='#iif(len(trim(arguments.EVO_INICIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EVO_TERMINO#'  null='#iif(len(trim(arguments.EVO_TERMINO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REFERENCIA_ID#'  null='#iif(len(trim(arguments.REFERENCIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_CLIENTE#'  null='#iif(len(trim(arguments.COD_PESSOA_CLIENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CLIENTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PREVISAO_CHEGADA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_RELATORIO#'  null='#iif(len(trim(arguments.NUM_RELATORIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.COLETA_ENTREGA_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfif arguments.coleta_entrega eq 1>
                    <cfset retorno.mensagem = JSStringFormat('Entrega inserida com sucesso!')>
                <cfelse>
                    <cfset retorno.mensagem = JSStringFormat('Coleta inserida com sucesso!')>
                </cfif>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera uma coleta/entrega para o romaneio
    -- cristofer 22/08/2007 11:57:31 - CRIADO
    --->
    <cffunction name='upd_coleta_entrega' displayname='Altera uma coleta/entrega para o romaneio' access='remote' returntype='Struct' output='true'>
        <cfargument name='COLETA_ENTREGA_ID' required='yes'>
        <cfargument name='EVO_INICIO' required='yes'>
        <cfargument name='EVO_TERMINO' required='yes'>
        <cfargument name='REFERENCIA_ID' required='yes'>
        <cfargument name='COD_PESSOA_CLIENTE' required='yes'>
        <cfargument name='CLIENTE' required='yes'>
        <cfargument name='PREVISAO_CHEGADA' required='yes'>
        <cfargument name='VOLUME' required='yes'>
        <cfargument name='NUM_RELATORIO' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_coleta_entrega.prc_alt_coleta_entrega' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COLETA_ENTREGA_ID#'  null='#iif(len(trim(arguments.COLETA_ENTREGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EVO_INICIO#'  null='#iif(len(trim(arguments.EVO_INICIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EVO_TERMINO#'  null='#iif(len(trim(arguments.EVO_TERMINO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REFERENCIA_ID#'  null='#iif(len(trim(arguments.REFERENCIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_CLIENTE#'  null='#iif(len(trim(arguments.COD_PESSOA_CLIENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CLIENTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PREVISAO_CHEGADA#'  null='#iif(len(trim(arguments.PREVISAO_CHEGADA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_RELATORIO#'  null='#iif(len(trim(arguments.NUM_RELATORIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Coleta/Entrega alterada com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
	
    <!--- 
    -- PROPSITO
    -- Exclui uma coleta/entrega para o romaneio
    -- cristofer 22/08/2007 11:57:31 - CRIADO
    --->
    <cffunction name='del_coleta_entrega' displayname='Exclui uma coleta/entrega para o romaneio' access='remote' returntype='Struct' output='true'>
        <cfargument name='COLETA_ENTREGA_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_coleta_entrega.prc_del_coleta_entrega' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COLETA_ENTREGA_ID#'  null='#iif(len(trim(arguments.COLETA_ENTREGA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Entrega excluida com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
	
    
    <!--- 
    -- PROPSITO
    -- Insere um conhecimento internacional no romaneio
    -- cristofer 21/11/2007 15:00:46 - CRIADO
    --->
    <cffunction name='ins_romaneio_intc_conhecimento' displayname='Insere um conhecimento internacional no romaneio' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_romaneio_dml.prc_ins_roo_intc_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Conhecimento vinculado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui um conhecimento internacional no romaneio
    -- cristofer 21/11/2007 15:03:31 - CRIADO
    --->
    <cffunction name='del_romaneio_intc_conhecimento' displayname='Exclui um conhecimento internacional no romaneio' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_romaneio_dml.prc_del_roo_intc_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Conhecimento desvinculado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir referncia
	-- igor 21/10/2008 11:20:21 - CRIADO
	--->
	<cffunction name='ins_referencia' displayname='Inserir referncia' access='remote' returntype='Struct' output='true'>
		<cfargument name='REFERENCIA' required='yes'>
		<cfargument name='CLASSE_ID' required='yes'>
		<cfargument name='LATITUDE' required='yes'>
		<cfargument name='LONGITUDE' required='yes'>
		<cfargument name='MUNICIPIO_ID' required='yes'>
		<cfargument name='REFERENCIA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='rastreador.pkg_rastreador.prc_ins_referencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.REFERENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CLASSE_ID#'  null='#iif(len(trim(arguments.CLASSE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LATITUDE#'  null='#iif(len(trim(arguments.LATITUDE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LONGITUDE#'  null='#iif(len(trim(arguments.LONGITUDE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REFERENCIA_ID#' variable='retorno.REFERENCIA_ID'  null='#iif(len(trim(arguments.REFERENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Item inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
    -- PROPSITO
    -- Alterar referncia
    -- igor 21/10/2008 11:21:32 - CRIADO
    --->
    <cffunction name='upd_referencia' displayname='Alterar referncia' access='remote' returntype='Struct' output='true'>
        <cfargument name='REFERENCIA_ID' required='yes'>
        <cfargument name='REFERENCIA' required='yes'>
        <cfargument name='CLASSE_ID' required='yes'>
        <cfargument name='LATITUDE' required='yes'>
        <cfargument name='LONGITUDE' required='yes'>
        <cfargument name='MUNICIPIO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='rastreador.pkg_rastreador.prc_alt_referencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REFERENCIA_ID#'  null='#iif(len(trim(arguments.REFERENCIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.REFERENCIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CLASSE_ID#'  null='#iif(len(trim(arguments.CLASSE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LATITUDE#'  null='#iif(len(trim(arguments.LATITUDE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LONGITUDE#'  null='#iif(len(trim(arguments.LONGITUDE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Item alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Envia uma mensagem para um veculo rastreado
	-- ANDERSONC 28/02/2011 11:02:28 - CRIADO
	--->
	<cffunction name='envia_mensagem_rastreador' displayname='Envia uma mensagem para um veculo rastreado' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='DATA_ENVIO' required='yes'>
		<cfargument name='NUM_EVENTO' required='yes'>
		<cfargument name='PARAMETROS' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='integracao.pkg_integracao.prc_envia_mensagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_ENVIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_EVENTO#'  null='#iif(len(trim(arguments.NUM_EVENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PARAMETROS#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.MENSAGEM_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='1'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='0'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Mensagem gerada. Aguardando integrao...')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>
