<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Gerencia Controle de conexes, l arquivo de firewal, grava arquivo auxiliar de conexo
	-- JEFFERSON          30/07/2004 - criado
	--->			
	<cffunction name="controle_conexao" displayname="Gerencia controle de conexes com o Servidor de Arquivos" output="true" returntype="Struct">
		<cfargument name="controle_conexao_id" 	required="true" 	displayname="Nmero do Controle de Conexo"  				type="numeric"	 default="-1"/>
		<cfargument name="endereco_ip" 			required="true" 	displayname="Endereo de Ip que ter a conexo liberada" 	type="string"/>
		<cfargument name="servico_tipo_id"		required="true" 	displayname="Cdigo do Tipo do Servio"		 	 			type="string"/>
		<cfargument name="maquina" 				required="true" 	displayname="Nome da Mquina" 								type="string"/>
		<cfargument name="operacao" 			required="true" 	displayname="Operacao a ser executada, libera / remove" 	type="string"/>
			<cfset var retorno = StructNew() />
			<cftry>
				<cfscript>
					conn_file = CreateComponent("_transportes.funcoes.cfc_file");
					retorno.erro = false;
					status = 'liberar';
					switch( arguments.operacao ) {
					  case 2 : 
							status  = 'liberadas'; 
							retorno.conexao = this.ins_controle_conexao( ArgumentCollection = Arguments ); 
							break; // libera conexo
					  case 3 : 
							status  = 'removidas'; 
							retorno.conexao = this.upd_controle_conexao( ArgumentCollection = Arguments ); 
							break; // remove conexo
					}
				</cfscript>
                <cfif session.site eq "portalkmm/">
                    <cfhttp url="http://192.168.100.1/libera_conexoes.php"></cfhttp>
                    <cfhttp url="http://192.168.100.2:8090/libera_conexoes.php"></cfhttp>
                <cfelse>
	                <cfhttp url="http://#cgi.http_host#/libera_conexoes.php"></cfhttp>
                </cfif>
                <cfscript>
					retorno.mensagem = 'As conexes para o servio ' & this.get_servico_tipo( ArgumentCollection = Arguments ).descricao  & ' foram ' & status & ' com sucesso';
				</cfscript>
				<cfcatch type="any">
					<cfdump var="#cfcatch#">
				</cfcatch>
			</cftry>
		 <cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Seleciona servios vinculados ao tipo do servio
	-- JEFFERSON          04/11/2003 - criado
	--->			
	<cffunction name="get_servico" displayname="Consulta Todos os Servios" access="remote" returntype="Query" output="false">	  
		<cfargument name="tipo_servico_id" 			required="false" 	displayname="Identificador do Tipo do Servio"  		type="string"/>
		<cfquery name="qrServicos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select s.servico_id,s.descricao,s.porta,s.nome_servidor,s.path_servidor, 
				   s.servico_ativo, decode( s.servico_ativo, 1, 'Ativo', 'Inativo') situacao_servico
			  from atualizador.servico_tipo st
				   inner join atualizador.servico_tipo_servico sts
					  on sts.servico_tipo_id = st.servico_tipo_id
				   inner join atualizador.servico s
					  on s.servico_id = sts.servico_id
			<cfif StructKeyExists( arguments, 'tipo_servico_id' ) and IsNumeric( arguments['tipo_servico_id'] )>
			 where st.servico_tipo_id  = #val( arguments['tipo_servico_id'] )#
			</cfif>
			order by s.descricao
		</cfquery>  
		<cfreturn qrServicos />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Executa programa de linha de comando no servidor
	-- JEFFERSON          31/03/2004 - criado
	--->			
	<cffunction name="executa_programa" displayname="Executa programa de linha de comando" access="remote" output="false" returntype="void">
		<cfargument name="nome"  		displayname="Nome do Programa (incluindo path)" 	type="string"	required="true"/>
		<cfargument name="argumentos"   displayname="Comandos do Programa " 				type="string"	required="false"/>
		<cfif StructKeyExists( arguments, 'argumentos') and Len(Trim( arguments.argumentos ))>
		<cfexecute 
			name		= "#Trim(arguments.nome)#" 
			arguments	= "#Trim(arguments.argumentos)#"/>
		<cfelse>
			<cfexecute name		= "#Trim(arguments.nome)#"/>
		</cfif>			
	</cffunction>			

	<!--- 
	-- PROPSITO
	-- Libera conexo
	-- JEFFERSON          30/07/2004 - criado
	--->			
	<cffunction name="ins_controle_conexao" displayname="Libera conexo com o Servidor de Arquivos" output="false" returntype="Struct">
		<cfargument name="controle_conexao_id" 	required="true" 	displayname="Nmero do Controle de Conexo"  				type="numeric"	 default="-1"/>
		<cfargument name="endereco_ip" 			required="true" 	displayname="Endereo de Ip que ter a conexo liberada" 	type="string"/>
		<cfargument name="servico_tipo_id"		required="true" 	displayname="Cdigo do Tipo do Servio"		 	 			type="string"/>
		<cfargument name="maquina" 				required="true" 	displayname="Nome da Mquina" 								type="string" 	default="KMM"/>
		<cfset var retorno = StructNew() />
		<cfset retorno.erro = False />
		<cfstoredproc procedure="atualizador.pkg_controle_conexao.prc_ins_conexao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam 	dbvarname="p_controle_conexao_id"  	type="inOut" value="#arguments.controle_conexao_id#"  cfsqltype="cf_sql_integer" variable="retorno.controle_conexao_id"/>
			<cfprocparam 	dbvarname="p_endereco_ip" 	  		type="in" 	value="#arguments.endereco_ip#" 				cfsqltype="cf_sql_varchar" />
			<cfprocparam 	dbvarname="p_maquina" 	  			type="in" 	value="#arguments.maquina#" 					cfsqltype="cf_sql_varchar" />
			<cfprocparam 	dbvarname="p_servico_tipo_id" 	 	type="in" 	value="#val( arguments.servico_tipo_id )#" 	cfsqltype="cf_sql_integer" />
			<cfprocparam 	dbvarname="p_conexao_ativa" 	  	type="in" 	value="1" 										cfsqltype="cf_sql_integer" />
		</cfstoredproc>
		<cfreturn retorno />		
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Remove conexo
	-- JEFFERSON          30/07/2004 - criado
	--->			
	<cffunction name="upd_controle_conexao" displayname="Libera conexo com o Servidor de Arquivos" output="false" returntype="Struct">
		<cfargument name="endereco_ip" 			required="true" 	displayname="Endereo de Ip que ter a conexo liberada" 	type="string"/>
		<cfargument name="servico_tipo_id"		required="true" 	displayname="Cdigo do Tipo do Servio"		 	 			type="string"/>
		<cfargument name="maquina" 				required="true" 	displayname="Nome da Mquina" 								type="string" default="KMM"/>
		<cfset var retorno = StructNew() />
		<cfset retorno.erro = False />
		<cfstoredproc procedure="atualizador.pkg_controle_conexao.prc_upd_conexao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam 	dbvarname="p_endereco_ip" 	  		type="in" 	value="#arguments.endereco_ip#" 				cfsqltype="cf_sql_varchar" />
			<cfprocparam 	dbvarname="p_maquina" 	  			type="in" 	value="#arguments.maquina#" 					cfsqltype="cf_sql_varchar" />
			<cfprocparam 	dbvarname="p_servico_tipo_id" 	 	type="in" 	value="#val( arguments.servico_tipo_id )#" 	cfsqltype="cf_sql_integer" />
		</cfstoredproc>
		<cfreturn retorno />		
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Retorna string com todas regras ativas na Firewall
	-- JEFFERSON          30/07/2004 - criado
	--->			
	<cffunction name="get_string_conexoes_ativas" displayname="Retorna string com todas Conexes ativas" access="remote" returntype="String" output="false">	  
	    <cfquery name="qrStringFirewall" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select atualizador.pkg_controle_conexao.fnc_get_string_conexao_ativas conexoes_ativas
			  from dual
		</cfquery>  
		<cfreturn qrStringFirewall.conexoes_ativas />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Seleciona tipos de servio
	-- JEFFERSON          04/11/2003 - criado
	--->			
	<cffunction name="get_servico_tipo" displayname="Consulta Todos Tipos dos Servios" access="remote" returntype="Query" output="true">	  
		<cfargument name="servico_tipo_id" 			required="false" 	displayname="Identificador do Tipo do Servio"  		type="string"/>
		<cfargument name="descricao" 				required="false" 	displayname="Descrio do Servio" 						type="string"/>
		<cfquery name="qrServicosTipo" datasource="#session.dsn#" username="#Session.usuario#" password="#Session.senha#">
			select  st.servico_tipo_id, st.descricao
			  from atualizador.servico_tipo st
			 where 0 = 0
			<cfif StructKeyExists( arguments, 'servico_tipo_id' ) and IsNumeric( arguments['servico_tipo_id'] )>
			   and  st.servico_tipo_id  = #val( arguments['servico_tipo_id'] )#
			</cfif>
			<cfif StructKeyExists( arguments, 'descricao' ) and Len(Trim( arguments['descricao'] ))>
			   and instr( lower( st.descricao ), lower('#arguments['descricao']#') ) <> 0
			</cfif>
			order by st.descricao
		</cfquery>  
		<cfreturn qrServicosTipo />
	</cffunction>
</cfcomponent>