<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Insere uma nova requisio
    -- 11/01/2006 - criado
    --->
    <cffunction name="ins_requisicao" displayname="Insere uma nova requisio" access="remote" returntype="Struct" output="true">
        <cfargument name="CONTROLE_ID" required="yes">
        <cfargument name="NUM_REQUISICAO" required="yes">
        <cfargument name="ESTOQUE_ID" required="yes">
        <cfargument name="PLACA" required="yes">
        <cfargument name="KM" required="yes">
        <cfargument name="DATA_HORA" required="yes">
        <cfargument name="QUANTIDADE" required="yes">
        <cfargument name="BOMBA_ID" required="yes">
        <cfargument name="PRODUTO_ID" required="yes">
        <cftry>
                <cftransaction action="begin">
                    <cfstoredproc procedure='oper.pkg_abastecimento.prc_confirma_abastecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                        <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_CONTROLE_ID'  			value="#arguments.CONTROLE_ID#" variable="retorno.CONTROLE_ID" null="#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#">
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_COD_PESSOA_POSTO'  	value='#session.cod_pessoa#'  null="#iif(len(trim(session.cod_pessoa)), de('no'), de('yes'))#">
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_COD_PESSOA_MOTORISTA'  null='yes'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' 				dbvarname='P_DATA_HORA'  			value='#arguments.DATA_HORA#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_NUM_CUPOM_FISCAL'  	null="yes">
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_NUM_NOTA_ID'  			null='yes'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' 				dbvarname='P_PLACA'  				value='#UCase(replace(arguments.placa, '-', '', 'ALL'))#' >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_KM'  					value="#arguments.KM#"  null="#iif(len(trim(arguments.KM)), de('no'), de('yes'))#">
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_PRODUTO_ID'  			value="#arguments.PRODUTO_ID#" null="#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#">
                        <cfprocparam type='IN' cfsqltype='CF_SQL_FLOAT' 				dbvarname='P_QUANTIDADE'  			value='#arguments.QUANTIDADE#' null="#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#">
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_LANCTO_CRT_ID'  		null='yes'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_VALOR_UNITARIO'  		null="yes">
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_VALOR_TOTAL'  			null="yes">
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_ALIQUOTA_ICMS'  		null="yes">
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_NUM_REQUISICAO'  		value="#arguments.NUM_REQUISICAO#" null="#iif(len(trim(arguments.NUM_REQUISICAO)), de('no'), de('yes'))#">
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_ESTOQUE_ID'  			value="#arguments.ESTOQUE_ID#" null="#iif(len(trim(arguments.ESTOQUE_ID)), de('no'), de('yes'))#">
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_CONFERIDO'  			value='0'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_BOMBA_ID'  			value="#arguments.BOMBA_ID#" null="#iif(len(trim(arguments.BOMBA_ID)), de('no'), de('yes'))#" >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_ENCHEU'  				value='0'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_SUPLEMENTAR'  			value='0'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_TIPO_ENTRADA'  		value='2'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat("Requisio de abastecimento inserida com sucesso!")>
            </cftransaction>
            <cfcatch>
                <cftransaction action="rollback"/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera dados de uma nova requisio
    -- 11/01/2006 - criado
    --->
    <cffunction name="upd_requisicao" displayname="Altera dados de uma nova requisio" access="remote" returntype="Struct" output="true">
        <cfargument name="LANCTO_ID" required="no" default="">
        <cfargument name="CONTROLE_ID" required="yes">
        <cfargument name="NUM_REQUISICAO" required="yes">
        <cfargument name="ESTOQUE_ID" required="yes">
        <cfargument name="NUM_SAIDA" required="yes">
        <cfargument name="PLACA" required="yes">
        <cfargument name="KM" required="yes">
        <cfargument name="DATA_HORA" required="yes">
        <cfargument name="QUANTIDADE" required="yes">
        <cfargument name="BOMBA_ID" required="yes">
        <cftry>
        
            <cftransaction action="begin">
                <cfstoredproc procedure='oper.pkg_abastecimento.prc_confirma_abastecimento' datasource='#session.dsn#' username="#session.usuario#" password='#session.senha#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_CONTROLE_ID'  			value="#arguments.CONTROLE_ID#" null="#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#" variable="retorno.controle_id">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_COD_PESSOA_POSTO'  	value="#session.cod_pessoa#" null="#iif(len(trim(session.cod_pessoa)), de('no'), de('yes'))#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_COD_PESSOA_MOTORISTA'  null="yes">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' 				dbvarname='P_DATA_HORA'  			value='#arguments.DATA_HORA#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_NUM_CUPOM_FISCAL'  	null="yes">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_NUM_NOTA_ID'  			null='yes'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' 				dbvarname='P_PLACA'  				value="#UCase(replace(arguments.placa, '-', '', 'ALL'))#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_KM'  					value="#arguments.km#" null="#iif(len(trim(arguments.KM)), de('no'), de('yes'))#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_PRODUTO_ID'  			null="yes">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_QUANTIDADE'  			value="#arguments.QUANTIDADE#"  null="#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_LANCTO_CRT_ID'  		null="yes">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_VALOR_UNITARIO'  		null="yes">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_VALOR_TOTAL'  			null="yes">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_ALIQUOTA_ICMS'  		null="yes">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_NUM_REQUISICAO'  		value="#arguments.NUM_REQUISICAO#" null="#iif(len(trim(arguments.NUM_REQUISICAO)), de('no'), de('yes'))#" >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_ESTOQUE_ID'  			value="#arguments.ESTOQUE_ID#" null="#iif(len(trim(arguments.ESTOQUE_ID)), de('no'), de('yes'))#" >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_CONFERIDO'  			null="yes">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_BOMBA_ID'  			value="#arguments.BOMBA_ID#" null="#iif(len(trim(arguments.BOMBA_ID)), de('no'), de('yes'))#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_ENCHEU'  				null="yes">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_SUPLEMENTAR'  			value="0">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_TIPO_ENTRADA'  		value="2">
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat("Requisio de abastecimento alterada com sucesso!")>
            </cftransaction>
            <cfcatch>
                <cftransaction action="rollback"/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui requisio
    -- 11/01/2006 - criado
    --->
    <cffunction name="del_requisicao" displayname="Exclui requisio" access="remote" returntype="Struct" output="true">
        <cfargument name="CONTROLE_ID" required="yes">
        <cfargument name="MOTIVO_ID" required="yes">
        <cfargument name="TIPO_ENTRADA_ID" required="no" default="2">
        <cftry>
            <cftransaction action="begin">
                <cfstoredproc procedure="oper.pkg_abastecimento.prc_del_abastecimento" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONTROLE_ID" value="#arguments.CONTROLE_ID#" null="#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_MOTIVO_ID" value="#arguments.MOTIVO_ID#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_TIPO_ENTRADA_ID" value="2">
                </cfstoredproc>	
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat("Requisio de abastecimento excluda com sucesso!")>
            </cftransaction>
            <cfcatch>
                <cftransaction action="rollback"/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere nota fiscal de entrada
    -- 12/01/2006 - criado
    --->
    <cffunction name="ins_nft_entrada" displayname="Insere nota fiscal de entrada" access="remote" returntype="Struct" output="true">
        <cfargument name="NUM_NOTA_FISCAL" required="yes">
        <cfargument name="COD_EMITENTE" required="yes">
        <cfargument name="DATA_EMISSAO" required="yes">
        <cfargument name="DATA_ENTRADA" required="yes">
        <cfargument name="DATA_VENCIMENTO" required="yes">
        <cfargument name="QUANTIDADE" required="yes">
        <cfargument name="VALOR_UNITARIO" required="yes">
        <cfargument name="VALOR_TOTAL" required="yes">
        <cfargument name="DESCONTO_PERCENTUAL" required="yes">
        <cfargument name="BASE_CALC_ICMS" required="yes">
        <cfargument name="VALOR_ICMS" required="yes">
        <cfargument name="VALOR_TOTAL_PRODUTOS" required="yes">
        <cfargument name="VALOR_TOTAL_NOTA" required="yes">
        <cfargument name="VALOR_FRETE" required="yes">
        <cfargument name="VALOR_SEGURO" required="yes">
        <cfargument name="OUTRAS_DESPESAS" required="yes">
        <cfargument name="VALOR_TOTAL_IPI" required="yes">
        <cfargument name="ESTOQUE_ID" required="yes">
    
        <cftry>
            <cftransaction action="begin">
                <cfstoredproc procedure="oper.pkg_posto.prc_ins_nft_filial" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_NOTA_FISCAL" value="#arguments.NUM_NOTA_FISCAL#" null="#iif(len(trim(arguments.NUM_NOTA_FISCAL)), de('no'), de('yes'))#" >
                    <cfprocparam type="inout" cfsqltype="cf_sql_integer" dbvarname="P_NUM_NOTA_ID" null="yes" variable="retorno.NUM_NOTA_ID">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_EMITENTE" value="#arguments.COD_EMITENTE#" null="#iif(len(trim(arguments.COD_EMITENTE)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_EMISSAO" value="#arguments.DATA_EMISSAO#"  >
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_ENTRADA" value="#arguments.DATA_ENTRADA#"  >
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_VENCIMENTO" value="#arguments.DATA_VENCIMENTO#"  >
                    <cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_QUANTIDADE" value="#arguments.QUANTIDADE#" null="#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_VALOR_UNITARIO" value="#arguments.VALOR_UNITARIO#" null="#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_VALOR_TOTAL" value="#arguments.VALOR_TOTAL#" null="#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_DESCONTO_PERCENTUAL" value="#arguments.DESCONTO_PERCENTUAL#" null="#iif(len(trim(arguments.DESCONTO_PERCENTUAL)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_BASE_CALC_ICMS" value="#arguments.BASE_CALC_ICMS#" null="#iif(len(trim(arguments.BASE_CALC_ICMS)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_VALOR_ICMS" value="#arguments.VALOR_ICMS#" null="#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_VALOR_TOTAL_PRODUTOS" value="#arguments.VALOR_TOTAL_PRODUTOS#" null="#iif(len(trim(arguments.VALOR_TOTAL_PRODUTOS)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_VALOR_TOTAL_NOTA" value="#arguments.VALOR_TOTAL_NOTA#" null="#iif(len(trim(arguments.VALOR_TOTAL_NOTA)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_BASE_ICMS_SUBST" value="0">
                    <cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_VALOR_ICMS_SUBST" value="0">
                    <cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_VALOR_FRETE" value="#arguments.VALOR_FRETE#" null="#iif(len(trim(arguments.VALOR_FRETE)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_VALOR_SEGURO" value="#arguments.VALOR_SEGURO#" null="#iif(len(trim(arguments.VALOR_SEGURO)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_OUTRAS_DESPESAS" value="#arguments.OUTRAS_DESPESAS#" null="#iif(len(trim(arguments.OUTRAS_DESPESAS)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_VALOR_TOTAL_IPI" value="#arguments.VALOR_TOTAL_IPI#" null="#iif(len(trim(arguments.VALOR_TOTAL_IPI)), de('no'), de('yes'))#" >
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ESTOQUE_ID" value="#arguments.ESTOQUE_ID#" null="#iif(len(trim(arguments.ESTOQUE_ID)), de('no'), de('yes'))#" >
                    <cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="P_ROWID" variable="retorno.ROWID"  >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat("Nota fiscal inserida com sucesso!")>
            </cftransaction>
            <cfcatch>
                <cftransaction action="rollback"/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Insere lancamento de abastecimento de contingncia do CTF
    -- guto 28/08/2007 17:10:26 - CRIADO
    --->
    <cffunction name='ins_abastecimento_ctf' displayname='Insere lancamento de abastecimento de contingncia do CTF' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_POSTO' required='yes'>
        <cfargument name='CTF_CD_ABASTECIMENTO' required='yes'>
        <cfargument name='CTF_COD_POSTO' required='yes'>
        <cfargument name='CTF_DC_PLACA' required='yes'>
        <cfargument name='CTF_NR_QTD_LITROS' required='yes'>
        <cfargument name='CTF_DT_EVENTO' required='yes'>
        <cfargument name='CTF_CD_STATUS_ABASTECIMENTO' required='yes'>
        <cfargument name='CTF_NR_CNPJ' required='yes'>
        <cfargument name='KM_MANUAL' required='yes'>
        <cftry> 
            <cftransaction action='begin'>
                <cfdump var="#arguments#">
                <cfstoredproc procedure='oper.pkg_ctf.prc_ins_contingencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_POSTO'  value='#arguments.COD_POSTO#'  null='#iif(len(trim(arguments.COD_POSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CTF_CD_ABASTECIMENTO'  value='#arguments.CTF_CD_ABASTECIMENTO#'  null='#iif(len(trim(arguments.CTF_CD_ABASTECIMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CTF_COD_POSTO'  value='#arguments.CTF_COD_POSTO#'  null='#iif(len(trim(arguments.CTF_COD_POSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CTF_DC_PLACA'  value='#arguments.CTF_DC_PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CTF_NR_QTD_LITROS'  value='#arguments.CTF_NR_QTD_LITROS#'  null='#iif(len(trim(arguments.CTF_NR_QTD_LITROS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CTF_DT_EVENTO'  value='#arguments.CTF_DT_EVENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CTF_CD_STATUS_ABASTECIMENTO'  value='#arguments.CTF_CD_STATUS_ABASTECIMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CTF_NR_CNPJ'  value='#arguments.CTF_NR_CNPJ#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_KM_MANUAL'  value='#arguments.KM_MANUAL#'  null='#iif(len(trim(arguments.KM_MANUAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Abastecimento inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Cancela lancamento de abastecimento de contingncia do CTF
    -- guto 28/08/2007 17:11:26 - CRIADO
    --->
    <cffunction name='cancela_abastecimento_ctf' displayname='Cancela lancamento de abastecimento de contingncia do CTF' access='remote' returntype='Struct' output='true'>
        <cfargument name='CTF_ID' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_ctf.prc_cancela_registro_ctf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CTF_ID'  value='#arguments.CTF_ID#'  null='#iif(len(trim(arguments.CTF_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Abastecimento cancelado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Insere entrada no estoque
    -- guto 26/04/2009 09:58:25 - CRIADO
    --->
    <cffunction name='ins_estoque_entrada' displayname='Insere entrada no estoque' access='remote' returntype='Struct' output='true'>
        <cfargument name='UTILIZACAO' required='yes'>
        <cfargument name='DATA_ENTRADA' required='yes'>
        <cfargument name='NUM_ENTRADA' required='yes'>
        <cfargument name='NUM_NF_REMESSA' required='yes'>
        <cfargument name='ESTOQUE_ID' required='yes'>
        <cfargument name='QUANTIDADE' required='yes'>
        <cfargument name='PRECO_UNITARIO' required='yes'>
        <cfargument name='PRECO_TOTAL' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_almoxarifado.prc_ins_estoque_entrada' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UTILIZACAO'  value='#arguments.UTILIZACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTRADA'  value='#arguments.DATA_ENTRADA#' >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ENTRADA'  value='#arguments.NUM_ENTRADA#' variable='retorno.NUM_ENTRADA'  null='#iif(len(trim(arguments.NUM_ENTRADA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NF_REMESSA'  value='#arguments.NUM_NF_REMESSA#'  null='#iif(len(trim(arguments.NUM_NF_REMESSA)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
    
                <cfstoredproc procedure='oper.pkg_almoxarifado.prc_ins_estoque_entrada_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ENTRADA'  value='#retorno.NUM_ENTRADA#'  null='#iif(len(trim(retorno.NUM_ENTRADA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ESTOQUE_ID'  value='#arguments.ESTOQUE_ID#'  null='#iif(len(trim(arguments.ESTOQUE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRECO_UNITARIO'  value='#arguments.PRECO_UNITARIO#'  null='#iif(len(trim(arguments.PRECO_UNITARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRECO_TOTAL'  value='#arguments.PRECO_TOTAL#'  null='#iif(len(trim(arguments.PRECO_TOTAL)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Entrada inserida com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Altera entrada no estoque item
    -- guto 26/04/2009 10:49:19 - CRIADO
    --->
    <cffunction name='upd_estoque_entrada' displayname='Altera entrada no estoque item' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_ENTRADA' required='yes'>
        <cfargument name='UTILIZACAO' required='yes'>
        <cfargument name='DATA_ENTRADA' required='yes'>
        <cfargument name='NUM_NF_REMESSA' required='yes'>
        <cfargument name='ESTOQUE_ID' required='yes'>
        <cfargument name='QUANTIDADE' required='yes'>
        <cfargument name='PRECO_UNITARIO' required='yes'>
        <cfargument name='PRECO_TOTAL' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_almoxarifado.prc_alt_estoque_entrada' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ENTRADA'  value='#arguments.NUM_ENTRADA#'  null='#iif(len(trim(arguments.NUM_ENTRADA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UTILIZACAO'  value='#arguments.UTILIZACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTRADA'  value='#arguments.DATA_ENTRADA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NF_REMESSA'  value='#arguments.NUM_NF_REMESSA#'  null='#iif(len(trim(arguments.NUM_NF_REMESSA)), de('no'), de('yes'))#'>
                </cfstoredproc>
    
                <cfstoredproc procedure='oper.pkg_almoxarifado.prc_alt_estoque_entrada_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ENTRADA'  value='#arguments.NUM_ENTRADA#'  null='#iif(len(trim(arguments.NUM_ENTRADA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ESTOQUE_ID'  value='#arguments.ESTOQUE_ID#'  null='#iif(len(trim(arguments.ESTOQUE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRECO_UNITARIO'  value='#arguments.PRECO_UNITARIO#'  null='#iif(len(trim(arguments.PRECO_UNITARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRECO_TOTAL'  value='#arguments.PRECO_TOTAL#'  null='#iif(len(trim(arguments.PRECO_TOTAL)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Entrada alterada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Exclui entrada no estoque item
    -- guto 26/04/2009 10:53:20 - CRIADO
    --->
    <cffunction name='del_estoque_entrada' displayname='Exclui entrada no estoque item' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_ENTRADA' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_almoxarifado.prc_del_estoque_entrada' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ENTRADA'  value='#arguments.NUM_ENTRADA#'  null='#iif(len(trim(arguments.NUM_ENTRADA)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Entrada excluda com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
	-- PROPSITO
	-- Insere um recibo de viagem
	-- ANDERSONC 20/05/2009 16:46:24 - CRIADO
	--->
	<cffunction name='ins_viagem_recibo' displayname='Insere um recibo de viagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_RECIBO_VIAGEM' required='yes'>
		<cfargument name='NUM_DOCUMENTO' required='yes'>
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='COMPLEMENTO' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='KM' required='yes'>
		<cfargument name='ORIGEM' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_abastecimento.prc_ins_viagem_recibo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_RECIBO_VIAGEM'  value='#arguments.NUM_RECIBO_VIAGEM#' variable='retorno.NUM_RECIBO_VIAGEM'  null='#iif(len(trim(arguments.NUM_RECIBO_VIAGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_DOCUMENTO'  value='#arguments.NUM_DOCUMENTO#'  null='#iif(len(trim(arguments.NUM_DOCUMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_KM'  value='#arguments.KM#' variable='retorno.KM'  null='#iif(len(trim(arguments.KM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORIGEM'  value='#arguments.ORIGEM#'  null='#iif(len(trim(arguments.ORIGEM)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Recibo de Viagem inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>