<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulao da rea de caixa" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Exclui lancto no contas a pagar do posto
	-- CRISTOFER  30/12/2005
	--->
	<cffunction name="del_contas_pagar" access="remote" returntype="struct" output="true">
		<cfargument name="LANCTO_ID" required="yes">
		<cfargument name="contas_pagar_id" required="yes">
		<cfargument name="num_recibo" required="yes">
		<cfargument name="adiantamento" required="yes">
		<cfargument name="saldo" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					delete oper.v$contrato_transp_pagar
					 where lancto_id = #arguments.lancto_id#
					   and contas_pagar_id = #arguments.contas_pagar_id#
					   and num_recibo = #arguments.num_recibo#
					   and adiantamento = #arguments.adiantamento#
					   and saldo = #arguments.saldo#
				</cfquery>
				<cfset retorno.mensagem = 'Documento excludo com sucesso!'>				
				<cfset retorno.erro = false>						
			</cftransaction>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cftransaction action="rollback" />
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Insere um aporte de caixa
	-- CRISTOFER  30/12/2005
	--->
	<cffunction name="ins_lancto_caixa" displayname="Altera a gesto da modalidade passada" access="remote" returntype="struct" output="true">
		<cfargument name="data"				required="yes">
		<cfargument name="hora"				required="yes">
		<cfargument name="controle_id" 		required="yes">
		<cfargument name="cod_historico" 	required="yes">
		<cfargument name="complemento" 		required="no">
		<cfargument name="cod_pessoa" 		required="yes">
		<cfargument name="cod_departamento" required="no" default="2">
		<cfargument name="cod_setor" 		required="yes">
		<cfargument name="cod_centro_custo" required="no" default="1">
		<cfargument name="unidade_id" 		required="yes">
		<cfargument name="valor" 			required="yes">
		<cfargument name="receita" 			required="no" default="0">
		<cftry>
			<cftransaction action="begin">
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_caixa.prc_incluir_lancto_caixa" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="inout" dbvarname="p_lancamento_id" 	cfsqltype="cf_sql_integer" null="yes" variable="retorno.lancamento_id">
				<cfprocparam type="in" dbvarname="p_data_lancamento" 	cfsqltype="cf_sql_varchar" value="#arguments.data# #arguments.hora#:00">
				<cfprocparam type="in" dbvarname="p_controle_id" 		cfsqltype="cf_sql_integer" value="#arguments.controle_id#">
				<cfprocparam type="in" dbvarname="p_num_docto" 			cfsqltype="cf_sql_integer" value="#arguments.num_docto#">
				<cfprocparam type="in" dbvarname="p_cod_historico" 		cfsqltype="cf_sql_integer" value="#arguments.cod_historico#">
				<cfprocparam type="in" dbvarname="p_complemento" 		cfsqltype="cf_sql_varchar" value="#arguments.complemento#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa" 		cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa#">
				<cfprocparam type="in" dbvarname="p_cod_departamento" 	cfsqltype="cf_sql_integer" value="#arguments.cod_departamento#">
				<cfprocparam type="in" dbvarname="p_cod_setor" 			cfsqltype="cf_sql_integer" value="#arguments.cod_setor#">
				<cfprocparam type="in" dbvarname="p_cod_centro_custo" 	cfsqltype="cf_sql_integer" value="#arguments.cod_centro_custo#">
				<cfprocparam type="in" dbvarname="p_unidade_id" 		cfsqltype="cf_sql_integer" value="#arguments.unidade_id#">
				<cfprocparam type="in" dbvarname="p_valor" 				cfsqltype="cf_sql_float"   value="#arguments.valor#">
				<cfprocparam type="in" dbvarname="p_receita" 			cfsqltype="cf_sql_integer" value="#arguments.receita#">
				<cfprocparam type="in" dbvarname="p_transferencia" 		cfsqltype="cf_sql_integer" value="1">
				<cfprocparam type="inout" dbvarname="p_rowid" 			cfsqltype="cf_sql_varchar" variable="retorno.rowid" null="yes">					
			</cfstoredproc>
			<cfset retorno.mensagem = 'Aporte feito com sucesso!'>
			<cfset retorno.erro = false>						
			</cftransaction>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cftransaction action="rollback" />
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
	
	
	<!--- 
	-- PROPSITO
	-- Abre o caixa
	-- 03/01/2006 - criado
	--->
	<cffunction name="abre_caixa" displayname="Abre o caixa" access="remote" returntype="Struct" output="true">
		<cfargument name="COD_PESSOA" required="yes">
		<cfargument name="COD_DEPARTAMENTO" required="yes">
		<cfargument name="COD_SETOR" required="yes">
		<cfargument name="COD_CENTRO_CUSTO" required="yes">
		<cfargument name="NUM_CAIXA" required="yes">
		<cfargument name="SALDO_ABERTURA" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="oper.pkg_caixa.prc_abertura_controle" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="inout" cfsqltype="cf_sql_integer" dbvarname="P_CONTROLE_ID" variable="retorno.CONTROLE_ID" null="yes" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_PESSOA" value="#arguments.COD_PESSOA#" null="#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_DEPARTAMENTO" value="#arguments.COD_DEPARTAMENTO#" null="#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_SETOR" value="#arguments.COD_SETOR#" null="#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_CENTRO_CUSTO" value="#arguments.COD_CENTRO_CUSTO#" null="#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_CAIXA" value="#arguments.NUM_CAIXA#" null="#iif(len(trim(arguments.NUM_CAIXA)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_USUARIO" value="#session.USUARIO#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_ABERTURA" value="#DateFormat(Now(),'dd/mm/yyyy')# #TimeFormat(Now(),'HH:MM')#"  >				<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="P_SALDO_ABERTURA" value="#arguments.SALDO_ABERTURA#" >
					<cfprocparam type="inout" cfsqltype="cf_sql_varchar" dbvarname="P_ROWID" null="yes" variable="retorno.ROWID"  >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Caixa aberto com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Encerramento de caixa
	-- 04/01/2006 - criado
	--->
	<cffunction name="encerra_caixa" displayname="Encerramento de caixa" access="remote" returntype="Struct" output="true">
		<cfargument name="COD_PESSOA" required="yes">
		<cfargument name="COD_DEPARTAMENTO" required="yes">
		<cfargument name="COD_SETOR" required="yes">
		<cfargument name="COD_CENTRO_CUSTO" required="yes">
		<cfargument name="NUM_CAIXA" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="oper.pkg_caixa.prc_encerramento_controle" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_PESSOA" value="#arguments.COD_PESSOA#" null="#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_DEPARTAMENTO" value="#arguments.COD_DEPARTAMENTO#" null="#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_SETOR" value="#arguments.COD_SETOR#" null="#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_CENTRO_CUSTO" value="#arguments.COD_CENTRO_CUSTO#" null="#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_CAIXA" value="#arguments.NUM_CAIXA#" null="#iif(len(trim(arguments.NUM_CAIXA)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_USUARIO" value="#session.USUARIO#"  >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Caixa fechado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma solicitao de despesa
	-- CRISTOFER 04/01/2006 - criado
	--->
	<cffunction name="del_solicitacao" displayname="Exclui uma solicitao de despesa" access="remote" returntype="Struct" output="true">
		<cfargument name="cod_solicitacao" required="yes">
		<cftry>
			<cftransaction action="begin">
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				delete oper.v$caixa_solicitacao where cod_solicitacao = #arguments.cod_solicitacao#
			</cfquery>
			<cfset retorno.mensagem = 'Solicitacao excluida com sucesso.'>
			<cfset retorno.erro = false>						
			</cftransaction>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cftransaction action="rollback" />
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>	
		<cfreturn retorno>
	</cffunction>			
	
	<!--- 
	-- PROPSITO
	-- Confirma as solicitaes de crdito
	-- CRISTOFER 04/01/2006 - criado
	--->
	<cffunction name="confirma_solicitacao" displayname="" access="remote" returntype="struct" output="true">
		<cfargument name="num_caixa" 			required="yes">
		<cfargument name="cod_pessoa_filial" 	required="yes">
		<cfargument name="cod_departamento" 	required="no" default="2">
		<cfargument name="cod_setor" 			required="yes">
		<cfargument name="cod_centro_custo" 	required="no" default="1">
		<cftry>
			<cftransaction action="begin">
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_caixa.prc_confirma_solicitacao" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_num_caixa" value="#arguments.num_caixa#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_cod_pessoa" value="#arguments.cod_pessoa_filial#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_cod_departamento" value="#arguments.cod_departamento#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_cod_setor" value="#arguments.cod_setor#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_cod_centro_custo" value="#arguments.cod_centro_custo#">
			</cfstoredproc>
			<cfset retorno.mensagem = 'Despesas Confirmadas com sucesso.'>
			<cfset retorno.erro = false>						
			</cftransaction>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cftransaction action="rollback" />
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>	
		<cfreturn retorno>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Abre uma trasnferencias de caixa
	-- 04/01/2006 - criado
	--->
	<cffunction name="abre_transferencia" displayname="Abre uma trasnferencias de caixa" access="remote" returntype="Struct" output="true">
		<cfargument name="CONTROLE_ID_CRED" required="yes">
		<cfargument name="CONTROLE_ID_DEB" required="yes">
		<cfargument name="VALOR" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="oper.pkg_caixa.prc_incluir_caixa_transf" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="inout" cfsqltype="cf_sql_integer" dbvarname="P_COD_TRANSFERENCIA" null="yes" variable="retorno.COD_TRANSFERENCIA">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_TRANSFERENCIA" value="#DateFormat(Now(),'dd/mm/yyyy')# #TimeFormat(Now(),'HH:MM')#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONTROLE_ID_CREDITO" value="#arguments.CONTROLE_ID_CRED#" null="#iif(len(trim(arguments.CONTROLE_ID_CRED)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONTROLE_ID_DEBITO" value="#arguments.CONTROLE_ID_DEB#" null="#iif(len(trim(arguments.CONTROLE_ID_DEB)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="P_VALOR" value="#arguments.VALOR#" null="#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#" >
					<cfprocparam type="inout" cfsqltype="cf_sql_varchar" dbvarname="P_ROWID" null="yes" variable="retorno.ROWID"  >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Transferncia aberta com sucesso.")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	
	<!--- 
	-- PROPSITO
	-- Fecha uma trasnferencias de caixa
	-- 04/01/2006 - criado
	--->
	<cffunction name="fecha_transferencia" displayname="Fecha uma trasnferencias de caixa" access="remote" returntype="Struct" output="true">
		<cfargument name="COD_TRANSFERENCIA" required="yes">
		<cfargument name="COMPLEMENTO" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="oper.pkg_caixa.prc_confirmar_caixa_transf" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_TRANSFERENCIA" value="#arguments.COD_TRANSFERENCIA#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_HISTORICO" value="7">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_COMPLEMENTO" value="#arguments.COMPLEMENTO#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_UNIDADE_ID" value="1">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Transferncia fechada com sucesso.")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Excluir transferncia
	-- 04/01/2006 - criado
	--->
	<cffunction name="del_transferencia" displayname="Excluir transferncia" access="remote" returntype="Struct" output="true">
		<cfargument name="COD_TRANSFERENCIA" required="yes">
	
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="oper.pkg_caixa.prc_excluir_caixa_transf" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_TRANSFERENCIA" value="#arguments.COD_TRANSFERENCIA#">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Tranferncia excluda com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere solicitao de despesa no caixa
	-- 04/01/2006 - criado
	--->
	<cffunction name="ins_despesas" displayname="Insere solicitao de despesa no caixa" access="remote" returntype="Struct" output="true">
		<cfargument name="NUM_CAIXA" required="yes">
		<cfargument name="NUM_DOCUMENTO" required="no" default="1">
		<cfargument name="DESCRICAO" required="yes">
		<cfargument name="DATA_LANCAMENTO" required="yes">
		<cfargument name="VALOR" required="yes">

		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="oper.pkg_caixa.prc_ins_solicitacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_CAIXA" value="#arguments.NUM_CAIXA#" null="#iif(len(trim(arguments.NUM_CAIXA)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_DOCUMENTO" value="#arguments.NUM_DOCUMENTO#" null="#iif(len(trim(arguments.NUM_DOCUMENTO)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DESCRICAO" value="#arguments.DESCRICAO#"  >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_LANCAMENTO" value="#arguments.DATA_LANCAMENTO#"  >
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="P_VALOR" value="#arguments.VALOR#" null="#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#" >
					<cfprocparam type="inout" cfsqltype="cf_sql_integer" dbvarname="P_COD_SOLICITACAO" variable="retorno.COD_SOLICITACAO" null="yes">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="P_ROWID" variable="retorno.ROWID"  >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Despesa inserida com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera solicitao de despesa no caixa
	-- 05/01/2006 - criado
	--->
	<cffunction name="upd_despesas" displayname="Altera solicitao de despesa no caixa" access="remote" returntype="Struct" output="true">
		<cfargument name="COD_SOLICITACAO" required="yes">
		<cfargument name="NUM_CAIXA" required="yes">
		<cfargument name="NUM_DOCUMENTO" required="yes" default="1">
		<cfargument name="DESCRICAO" required="yes">
		<cfargument name="DATA_LANCAMENTO" required="yes">
		<cfargument name="VALOR" required="yes">
	
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="oper.pkg_caixa.prc_alt_solicitacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_SOLICITACAO" value="#arguments.COD_SOLICITACAO#" null="#iif(len(trim(arguments.COD_SOLICITACAO)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_CAIXA" value="#arguments.NUM_CAIXA#" null="#iif(len(trim(arguments.NUM_CAIXA)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_DOCUMENTO" value="#arguments.NUM_DOCUMENTO#" null="#iif(len(trim(arguments.NUM_DOCUMENTO)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DESCRICAO" value="#arguments.DESCRICAO#"  >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_LANCAMENTO" value="#arguments.DATA_LANCAMENTO#"  >
					<cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_VALOR" value="#arguments.VALOR#" >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Solicitao de despesas alterado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui solicitao de despesa no caixa
	-- 05/01/2006 - criado
	--->
	<cffunction name="del_despesas" displayname="Exclui solicitao de despesa no caixa" access="remote" returntype="Struct" output="true">
		<cfargument name="COD_SOLICITACAO" required="yes">
	
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="oper.pkg_caixa.prc_del_solicitacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_SOLICITACAO" value="#arguments.COD_SOLICITACAO#">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Solicitao de despesas excludo com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere contas a pagar
	-- 11/01/2006 - criado
	--->
	<cffunction name="set_contas_pagar" displayname="Insere contas a pagar" access="remote" returntype="struct" output="true">
		<cfargument name="lancto_id" required="yes">
		<cfargument name="cod_pessoa_favorecido" required="yes">
		<cfargument name="num_docto" required="yes">
		<cfargument name="data_emissao" required="yes">
		<cfargument name="data_vencto" required="yes">
		<cfargument name="valor" required="yes">
		<cfargument name="cod_pessoa_filial" required="yes">
		<cfargument name="adiantamento" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_contrato_transporte.prc_contas_pagar_contrato" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_lancto_id" value="#arguments.lancto_id#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_troca" value="#arguments.cod_pessoa_favorecido#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_num_docto" value="#arguments.num_docto#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_data_emissao" value="#arguments.data_emissao#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_data_vencto" value="#arguments.data_vencto#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_valor" value="#arguments.valor#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_filial" value="#arguments.cod_pessoa_filial#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_adiantamento" value="#arguments.adiantamento#">
					<cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="p_contas_pagar_id" variable="retorno.p_contas_pagar_id">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Recebimento do Contrato de Transporte feito com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere um item vinculado a carta frete
	-- 11/01/2006 - criado
	--->
	<cffunction name="ins_item_contrato" displayname="Insere um item vinculado a carta frete" access="remote" returntype="struct" output="true">
		<cfargument name="lancto_id" 	required="YES">
		<cfargument name="item_id" 		required="YES">
		<cfargument name="descricao" 	required="YES">
		<cfargument name="valor" 		required="YES">
		<cfargument name="desconto" 	required="YES">
		<cftry>
			<cfquery name="qr_lancado" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					select 'x'
					  from oper.v$contrato_transp_item
					 where lancto_id  = #arguments.lancto_id#
					   and item_id = #arguments.item_id#
				</cfquery>			
				<cfif qr_lancado.RecordCount gt 0>
					<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
						update oper.v$contrato_transp_item
						   set valor = #arguments.valor#
						 where lancto_id  = #arguments.lancto_id#
						   and item_id = #arguments.item_id#
					</cfquery>
				<cfelse>
					<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
						insert into oper.v$contrato_transp_item
						  (lancto_id, item_id, descricao, valor, desconto)
						values
						  (#arguments.lancto_id#, #arguments.item_id#, '#arguments.descricao#', #arguments.valor#, #arguments.desconto#)
					</cfquery>			
				</cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Item lanado com sucesso!")>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>				

	<!--- 
	-- PROPSITO
	-- Vincula um conhecimento a um CT
	-- 03/05/2006 - GUTO
	--->
	<cffunction name="vincula_ctrc_contrato" displayname="Vincula um conhecimento a um CT" access="remote" returntype="struct" output="true">
		<cfargument name="num_conhecimento" required="yes">
		<cfargument name="serie" required="yes">
		<cfargument name="ctrc_cod_pessoa_filial" required="yes">
		<cfargument name="ctrc_cod_departamento" required="yes">
		<cfargument name="ctrc_cod_setor" required="yes">
		<cfargument name="ctrc_cod_centro_custo" required="yes">
		<cfargument name="num_contrato" required="yes">
		<cfargument name="ct_cod_pessoa_filial" required="yes">
		<cfargument name="ct_cod_departamento" required="yes">
		<cfargument name="ct_cod_setor" required="yes">
		<cfargument name="ct_cod_centro_custo" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_contrato_transporte.prc_vincula_ctrc_contrato" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_conhecimento" value="#arguments.num_conhecimento#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_serie" value="#arguments.serie#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_contrato" value="#arguments.num_contrato#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa" value="#arguments.ctrc_cod_pessoa_filial#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_departamento" value="#arguments.ctrc_cod_departamento#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_setor" value="#arguments.ctrc_cod_setor#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_centro_custo" value="#arguments.ctrc_cod_centro_custo#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_filial_ct" value="#arguments.ct_cod_pessoa_filial#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_departamento_ct" value="#arguments.ct_cod_departamento#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_setor_ct" value="#arguments.ct_cod_setor#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_centro_custo_ct" value="#arguments.ct_cod_centro_custo#">
				</cfstoredproc>
				<cfset retorno.mensagem = 'Contrato de Transporte vinculado com sucesso.'>				
				<cfset retorno.erro = false>						
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Vincula um romaneio a um CTRC
	-- 03/05/2006 - GUTO
	--->
	<cffunction name="set_vincula_conhecimento_romaneio" displayname="Insere uma item vinculado a carta frete" access="remote" returntype="struct" output="true">
		<cfargument name="num_romaneio" required="yes" />
		<cfargument name="item_id" 		required="yes" />
		<cfargument name="num_conhecimento" required="yes" />
		<cfargument name="cod_pessoa_filial" required="no" default=""/>
		<cfargument name="cod_departamento" required="no" default=""/>
		<cfargument name="cod_setor" 		required="no" default=""/>
		<cfargument name="cod_centro_custo" required="no" default=""/>
		<cfargument name="serie" 			required="yes" />
		<cfargument name="organograma" required="no" default="">		
		<cfif Len(Trim(arguments.ORGANOGRAMA))>
			<cfset arguments.cod_pessoa_filial = ListGetAt(arguments.organograma,1,'_')>
			<cfset arguments.cod_departamento = ListGetAt(arguments.organograma,2,'_')>
			<cfset arguments.cod_setor = ListGetAt(arguments.organograma,3,'_')>
			<cfset arguments.cod_centro_custo = ListGetAt(arguments.organograma,4,'_')>
		</cfif>
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_romaneio.prc_vincula_ctrc_romaneio" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_romaneio" value="#arguments.num_romaneio#">
					<cfprocparam type="inout" cfsqltype="cf_sql_integer" dbvarname="v_item_id" value="#arguments.item_id#" variable="retorno.item_id">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_conhecimento" value="#arguments.num_conhecimento#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_filial" value="#arguments.cod_pessoa_filial#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_departamento" value="#arguments.cod_departamento#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_setor" value="#arguments.cod_setor#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_centro_custo" value="#arguments.cod_centro_custo#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_serie" value="#arguments.serie#">
				</cfstoredproc>
				<cfset retorno.erro = false>		
				<cfset retorno.mensagem = 'Conhecimento vinculado com sucesso.'>		
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Insere um novo lote
	-- guto 04/05/2006 11:50:01 - CRIADO
	--->
	<cffunction name='ins_lote' displayname='Insere um novo lote' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='DATA_INICIO_RETIRADA' required='yes'>
		<cfargument name='DATA_PRAZO_RETIRADA' required='yes'>
		<cfargument name='DATA_CONTRATO' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='FRETE_EM' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='QTDE_VIAGEM' required='yes'>
		<cfargument name='FRETE_PROPRIO' required='yes'>
		<cfargument name='FRETE_VALOR_UNITARIO' required='yes'>
		<cfargument name='FRETE_VALOR' required='yes'>
		<cfargument name='FRETE_POR_CONTA' required='yes'>
		<cfargument name='NUM_PRODUTO' required='yes'>
		<cfargument name='PEDAGIO_INCLUSO' required='yes'>
		<cfargument name='SITUACAO_TRIBUTARIA' required='yes'>
		<cfargument name='ALIQUOTA_ICMS' required='yes'>
		<cfargument name='REDUCAO_BASE_CALCULO' required='yes'>
		<cfargument name='ICMS_INCLUSO' required='yes'>
		<cfargument name='DESTACA_BASE_CALC_ICMS' required='yes'>
		<cfargument name='FUNDAMENTACAO_LEGAL' required='yes'>
		<cfargument name='COD_PESSOA_REMETENTE' required='yes'>
		<cfargument name='COD_PESSOA_DESTINATARIO' required='yes'>
		<cfargument name='COLETA_LOGRADOURO' required='yes'>
		<cfargument name='COLETA_COMPLEMENTO' required='yes'>
		<cfargument name='COLETA_BAIRRO' required='yes'>
		<cfargument name='COLETA_CEP' required='yes'>
		<cfargument name='COLETA_COD_UF' required='yes'>
		<cfargument name='COLETA_COD_MUNICIPIO' required='yes'>
		<cfargument name='COLETA_COD_DV' required='yes'>
		<cfargument name='COLETA_COD_DISTRITO' required='yes'>
		<cfargument name='ENTREGA_LOGRADOURO' required='yes'>
		<cfargument name='ENTREGA_COMPLEMENTO' required='yes'>
		<cfargument name='ENTREGA_CEP' required='yes'>
		<cfargument name='ENTREGA_BAIRRO' required='yes'>
		<cfargument name='ENTREGA_COD_UF' required='yes'>
		<cfargument name='ENTREGA_COD_MUNICIPIO' required='yes'>
		<cfargument name='ENTREGA_COD_DISTRITO' required='yes'>
		<cfargument name='ENTREGA_COD_DV' required='yes'>
		<cfargument name='CONTROLE_PESO' required='yes'>
		<cfargument name='CONTROLE_VIAGEM' required='yes'>
		<cfargument name='CONTROLE_PESO_VEICULO' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
		<cfargument name='REGRA_FISCAL' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='OBSERVACAO_EMITENTE' required='yes'>
		<cfargument name='NEGOCIADOR_ID' required='yes'>
		<cfargument name='SEGURO' required='yes'>
		<cfargument name='COM_RETORNO_EMBALAGEM' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_lote_dml.prc_ins_lote' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO_RETIRADA'  value='#arguments.DATA_INICIO_RETIRADA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PRAZO_RETIRADA'  value='#arguments.DATA_PRAZO_RETIRADA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CONTRATO'  value='#arguments.DATA_CONTRATO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO'  value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VOLUME'  value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FRETE_EM'  value='#arguments.FRETE_EM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_VIAGEM'  value='#arguments.QTDE_VIAGEM#'  null='#iif(len(trim(arguments.QTDE_VIAGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_PROPRIO'  value='#arguments.FRETE_PROPRIO#'  null='#iif(len(trim(arguments.FRETE_PROPRIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_VALOR_UNITARIO'  value='#arguments.FRETE_VALOR_UNITARIO#'  null='#iif(len(trim(arguments.FRETE_VALOR_UNITARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_VALOR'  value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_POR_CONTA'  value='#arguments.FRETE_POR_CONTA#'  null='#iif(len(trim(arguments.FRETE_POR_CONTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_PRODUTO'  value='#arguments.NUM_PRODUTO#'  null='#iif(len(trim(arguments.NUM_PRODUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PEDAGIO_INCLUSO'  value='#arguments.PEDAGIO_INCLUSO#'  null='#iif(len(trim(arguments.PEDAGIO_INCLUSO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SITUACAO_TRIBUTARIA'  value='#arguments.SITUACAO_TRIBUTARIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALIQUOTA_ICMS'  value='#arguments.ALIQUOTA_ICMS#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REDUCAO_BASE_CALCULO'  value='#arguments.REDUCAO_BASE_CALCULO#'  null='#iif(len(trim(arguments.REDUCAO_BASE_CALCULO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ICMS_INCLUSO'  value='#arguments.ICMS_INCLUSO#'  null='#iif(len(trim(arguments.ICMS_INCLUSO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESTACA_BASE_CALC_ICMS'  value='#arguments.DESTACA_BASE_CALC_ICMS#'  null='#iif(len(trim(arguments.DESTACA_BASE_CALC_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FUNDAMENTACAO_LEGAL'  value='#arguments.FUNDAMENTACAO_LEGAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_REMETENTE'  value='#arguments.COD_PESSOA_REMETENTE#'  null='#iif(len(trim(arguments.COD_PESSOA_REMETENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_DESTINATARIO'  value='#arguments.COD_PESSOA_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_PESSOA_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_LOGRADOURO'  value='#arguments.COLETA_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_COMPLEMENTO'  value='#arguments.COLETA_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_BAIRRO'  value='#arguments.COLETA_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_CEP'  value='#arguments.COLETA_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_UF'  value='#arguments.COLETA_COD_UF#'  null='#iif(len(trim(arguments.COLETA_COD_UF)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_MUNICIPIO'  value='#arguments.COLETA_COD_MUNICIPIO#'  null='#iif(len(trim(arguments.COLETA_COD_MUNICIPIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_DV'  value='#arguments.COLETA_COD_DV#'  null='#iif(len(trim(arguments.COLETA_COD_DV)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_DISTRITO'  value='#arguments.COLETA_COD_DISTRITO#'  null='#iif(len(trim(arguments.COLETA_COD_DISTRITO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_LOGRADOURO'  value='#arguments.ENTREGA_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_COMPLEMENTO'  value='#arguments.ENTREGA_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_CEP'  value='#arguments.ENTREGA_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_BAIRRO'  value='#arguments.ENTREGA_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_UF'  value='#arguments.ENTREGA_COD_UF#'  null='#iif(len(trim(arguments.ENTREGA_COD_UF)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_MUNICIPIO'  value='#arguments.ENTREGA_COD_MUNICIPIO#'  null='#iif(len(trim(arguments.ENTREGA_COD_MUNICIPIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_DISTRITO'  value='#arguments.ENTREGA_COD_DISTRITO#'  null='#iif(len(trim(arguments.ENTREGA_COD_DISTRITO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_DV'  value='#arguments.ENTREGA_COD_DV#'  null='#iif(len(trim(arguments.ENTREGA_COD_DV)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_PESO'  value='#arguments.CONTROLE_PESO#'  null='#iif(len(trim(arguments.CONTROLE_PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_VIAGEM'  value='#arguments.CONTROLE_VIAGEM#'  null='#iif(len(trim(arguments.CONTROLE_VIAGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_PESO_VEICULO'  value='#arguments.CONTROLE_PESO_VEICULO#'  null='#iif(len(trim(arguments.CONTROLE_PESO_VEICULO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGRA_FISCAL'  value='#arguments.REGRA_FISCAL#'  null='#iif(len(trim(arguments.REGRA_FISCAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_EMITENTE'  value='#arguments.OBSERVACAO_EMITENTE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NEGOCIADOR_ID'  value='#arguments.NEGOCIADOR_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SEGURO'  value='#arguments.SEGURO#'  null='#iif(len(trim(arguments.SEGURO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_LOTE' variable='retorno.NUM_LOTE'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COM_RETORNO_EMBALAGEM'  value='#arguments.COM_RETORNO_EMBALAGEM#'  null='#iif(len(trim(arguments.COM_RETORNO_EMBALAGEM)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lote inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	



	<!--- 
	-- PROPSITO
	-- 
	-- GUTO - 10/05/2006
	--->
	<cffunction name="ins_lote_consignatario" displayname="" access="remote" returntype="struct" output="true">
	
    <cfargument name='NUM_LOTE' required='yes' default="">
	<cfargument name='COD_CONSIGNATARIO' required='yes' default="">
	<cfargument name='RAZAO_SOCIAL' required='yes' default="">
	<cfargument name='CEP' required='yes' default="">
	<cfargument name='ENDERECO' required='no' default="">
	<cfargument name='CNPJ_CPF' required='no' default="">
	<cfargument name='INSCRICAO_ESTADUAL' required='no' default="">
	<cfargument name='MUNICIPIO' required='no' default="">
	<cfargument name='UF' required='no' default="">
	<cfargument name='COD_UF' required='no' default="">
	<cfargument name='COD_MUNICIPIO' required='no' default="">
	<cfargument name='COD_DV' required='no' default="">
	<cfargument name='COD_DISTRITO' required='no' default="">

    <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_lote_dml.prc_ins_lote_consignatario" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_lote" value="#retorno.num_lote#">
                        <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_consignatario" value="#arguments.CONS_COD_PESSOA#">
                        <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_razao_social" value="#arguments.CONS_NOME#">
                        <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_cep" value="#arguments.CONS_CEP#">
                        <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_endereco" value="#arguments.CONS_ENDERECO#">
                        <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_cnpj_cpf" value="#arguments.CONS_CNPJ_CPF#">
                        <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_inscricao_estadual" value="#arguments.CONS_INSC_ESTADUAL#">
                        <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_municipio" value="#arguments.CONS_MUNICIPIO#">
                        <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_uf" value="#arguments.CONS_UF#">
                        <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_uf" value="#arguments.CONS_COD_UF#">
                        <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_municipio" value="#arguments.CONS_COD_MUNICIPIO#">
                        <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_dv" value="#arguments.CONS_COD_DISTRITO#">
                        <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_distrito" value="#arguments.CONS_COD_DV#">
                        <cfprocparam type="inout" cfsqltype="cf_sql_varchar" dbvarname="p_rowid" variable="retorno.rowid" null="yes">
                    </cfstoredproc>
    <cfreturn StructNew() >
    </cffunction>


	<!--- 
	-- PROPSITO
	-- Insere lote, modelo antigo, excluir depois da alterao dos lotes
	-- GUTO - 10/05/2006
	--->
	<cffunction name="insere_lote" displayname="Insere Lote" access="remote" returntype="struct" output="true">
		<cfargument name="cod_pessoa_filial" required="yes">
		<cfargument name="cod_departamento" required="yes">
		<cfargument name="cod_setor" required="yes">
		<cfargument name="cod_centro_custo" required="yes">
		<cfargument name="data_inicio_retirada" required="yes">
		<cfargument name="data_prazo_retirada" required="yes">
		<cfargument name="data_contrato" required="yes">
		<cfargument name="num_natureza" required="yes">
		<cfargument name="num_especie" required="yes">
		<cfargument name="peso" required="yes">
		<cfargument name="volume" required="yes">
		<cfargument name="m3" required="yes">
		<cfargument name="frete_em" required="yes">
		<cfargument name="cod_unidade" required="yes">
		<cfargument name="qtde_viagem" required="yes">
		<cfargument name="frete_proprio" required="yes">
		<cfargument name="frete_valor_unitario" required="yes">
		<cfargument name="frete_valor" required="yes">
		<cfargument name="frete_por_conta" required="yes">
		<cfargument name="num_produto" required="yes">
		<cfargument name="pedagio_incluso" required="yes">
		<cfargument name="situacao_tributaria" required="yes">
		<cfargument name="aliquota_icms" required="yes">
		<cfargument name="reducao_base_calculo" required="no" default="0">
		<cfargument name="icms_incluso" required="yes">
		<cfargument name="regra_fiscal_id" required="yes">
		<cfargument name="destaca_base_calc_icms" required="yes">
		<cfargument name="fundamentacao_legal" required="no" default="">
		<cfargument name="rem_cod_pessoa" required="yes">
		<cfargument name="dest_cod_pessoa" required="no">
		<cfargument name="coleta_logradouro" required="yes">
		<cfargument name="coleta_complemento" required="no" default="">
		<cfargument name="coleta_bairro" required="yes">
		<cfargument name="coleta_cep" required="yes">
		<cfargument name="coleta_cod_uf" required="yes">
		<cfargument name="coleta_cod_municipio" required="yes">
		<cfargument name="coleta_cod_dv" required="yes">
		<cfargument name="coleta_cod_distrito" required="yes">
		<cfargument name="entrega_logradouro" required="no" default="">
		<cfargument name="entrega_complemento" required="no" default="">
		<cfargument name="entrega_cep" required="no" default="">
		<cfargument name="entrega_bairro" required="no" default="">
		<cfargument name="entrega_cod_uf" required="no">
		<cfargument name="entrega_cod_municipio" required="no">
		<cfargument name="entrega_cod_distrito" required="no">
		<cfargument name="entrega_cod_dv" required="no">
		<cfargument name="controle_peso" required="no" default="0">
		<cfargument name="controle_viagem" required="no" default="0">
		<cfargument name="controle_peso_veiculo" required="yes">
		<cfargument name="situacao_id" required="yes">
		<cfargument name="observacao" required="no" default="">
		<cfargument name="observacao_emitente" required="no" default="">
		<cfargument name="negociador_id" required="no" default="">
		<cfargument name="seguro_por_conta" required="no" default="">
		<!-- Materiais utilidos -->
		<cfargument name="materiais" required="yes">
		<!-- Agencias que poderam emitir os doctos -->
		<cfargument name="setor_doctos" required="yes">		
		<!-- Dados do Carregamento -->
		<cfargument name="carga_equipamento" required="yes" default="">
		<cfargument name="carga_ambiente" required="yes">
		<cfargument name="carga_por_conta" required="yes"> 
		<cfargument name="carga_num_carregadores" required="yes">
		<cfargument name="carga_nome" required="no">
		<cfargument name="carga_cargo" required="no">
		<cfargument name="carga_telefone" required="no">
		<cfargument name="carga_email" required="no">
		<cfargument name="imprime_ordem_cargto" required="no" default="0">
		<cfargument name="carga_observacao" required="no">
		<!-- Dados do Descarregamento -->
		<cfargument name="descarga_equipamento" required="yes">
		<cfargument name="descarga_ambiente" required="yes">
		<cfargument name="descarga_por_conta" required="yes">
		<cfargument name="descarga_num_descarregadores" required="yes">
		<cfargument name="descarga_nome" required="no">
		<cfargument name="descarga_cargo" required="no">
		<cfargument name="descarga_telefone" required="no">
		<cfargument name="descarga_email" required="no">
		<cfargument name="imprime_conhecimento" required="no" default="0">
		<cfargument name="descarga_observacao" required="no">
		<!-- Dados do Contratante -->
		<cfargument name="contratante_nome" required="yes">
		<cfargument name="contratante_cargo" required="no" >
		<cfargument name="contratante_telefone" required="yes">
		<cfargument name="contratante_email" required="no" >
		<cfargument name="negociacao_obs" required="no" >
		<!-- Dados do Faturamento -->
		<cfargument name="filial_fatura" required="yes">
		<cfargument name="setor_fatura" required="yes">
		<cfargument name="fat_cod_departamento" required="yes">
		<cfargument name="fat_cod_centro_custo" required="yes">
		<cfargument name="forma_pagto" required="yes">
		<cfargument name="agrupamento" required="yes">
		<cfargument name="fat_vencimento" required="yes">
		<cfargument name="num_dias" required="yes">
		<cfargument name="ccorrente_favorecido" required="yes">
		<cfargument name="fat_nome" required="yes">
		<cfargument name="fat_telefone" required="yes">
		<cfargument name="fat_email" required="yes">
		<cfargument name="fat_endereco" required="no" >
		<cfargument name="fat_complemento" required="no" >
		<cfargument name="fat_bairro" required="no" >
		<cfargument name="fat_cep" required="no" >
		<cfargument name="fat_cod_uf" required="no" >
		<cfargument name="fat_cod_municipio" required="no" >
		<cfargument name="fat_cod_distrito" required="no" >
		<cfargument name="fat_cod_dv" required="no" >
		<cfargument name="fat_observacoes" required="no" >		
		<!-- Percentuais de comisso -->
		<cfargument name="perc_comissao" required="yes" >
		<cfargument name="perc_negociador" required="yes" >
		<cfargument name="perc_embarcador" required="yes" >
		<cfargument name="perc_emissor" required="yes" >
		
		<!-- Seguro-->
		
		<cfargument name='ID_SEG_RCTR_C' required='no' default="">
		<cfargument name='RCF_DC' required='no' default="">
		<cfargument name='RESPONSAVEL_RCF_DC' required='no' default="">
		<cfargument name='ID_SEG_RCF_DC' required='no' default="">
		<cfargument name='VALOR_COB_RCF_DC_CLIENTE' required='no' default=""> 
		<cfargument name='NUM_LIBERACAO' required='no' default="">
		<cfargument name='EXIGE_GERENCIADORA' required='no' default="">
		<cfargument name='COD_GERENCIADORA' required='no' default="">
		<cfargument name='EXIGE_MONITORAMENTO' required='no' default="">
		<cfargument name='COD_PESSOA_MONITORA' required='no' default="">
		<cfargument name='TIPO_VALOR_MERCADORIA' required='no' default="">
		<cfargument name='VALOR_MEDIO_MERCADORIA' required='no' default="">
		<cfargument name='INTERVALO_MINUTO' required='no' default="">
		<cfargument name='RCTR_VI' required='no' default="">
		<cfargument name='ID_SEG_RCTR_VI' required='no' default="">
		<cfargument name='OBSERVACAO_SEG' required='no' default="">
		<cfargument name='ID_LOTE_SEGURO' required='no' default="">
		<cfargument name='NUM_LIBERACAO_RCTR_C' required='no' default="">
		<cfargument name='NUM_LIBERACAO_RCF_DC' required='no' default="">
		<cfargument name='NUM_LIBERACAO_RCTR_VI' required='no' default="">
		<cfargument name='CONS_COD_PESSOA' required='no' default="">
        <cfargument name="OPERACAO_ID_REPOM" required="no" default="">        
		<cfargument name='ROWID' required='no' default="">
		<cftry>
		<cftransaction action="begin">
				<!-- INSERE LOTE-->
			  		<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_lote_dml.prc_ins_lote" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_filial" value="#arguments.cod_pessoa_filial#" null='#iif(len(trim(arguments.cod_pessoa_filial)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_departamento" value="#arguments.cod_departamento#" null='#iif(len(trim(arguments.cod_departamento)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_setor" value="#arguments.cod_setor#" null='#iif(len(trim(arguments.cod_setor)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_centro_custo" value="#arguments.cod_centro_custo#" null='#iif(len(trim(arguments.cod_centro_custo)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_data_inicio_retirada" value="#arguments.data_inicio_retirada#" >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_data_prazo_retirada" value="#arguments.data_prazo_retirada#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_data_contrato" value="#arguments.data_contrato#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_natureza" value="#arguments.num_natureza#" null='#iif(len(trim(arguments.num_natureza)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_especie" value="#arguments.num_especie#">
					
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_peso" value="#arguments.peso#" null='#iif(len(trim(arguments.peso)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_volume" value="#arguments.volume#" null='#iif(len(trim(arguments.volume)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_m3" value="#arguments.m3#" null='#iif(len(trim(arguments.m3)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_frete_em" value="#arguments.frete_em#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_cod_unidade" value="#arguments.cod_unidade#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_qtde_viagem" value="#arguments.qtde_viagem#" null="#IIF(isDefined("arguments.qtde_viagem") and Len(Trim(arguments.qtde_viagem)),DE('no'),DE('yes'))#">>
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_frete_proprio" value="#arguments.frete_proprio#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_frete_valor_unitario" value="#arguments.frete_valor_unitario#" null='#iif(len(trim(arguments.frete_valor_unitario)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_frete_valor" value="#arguments.frete_valor#" null='#iif(len(trim(arguments.frete_valor)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_frete_por_conta" value="#arguments.frete_por_conta#" null='#iif(len(trim(arguments.frete_por_conta)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_produto" value="#arguments.num_produto#" null='#iif(len(trim(arguments.num_produto)), de('no'), de('yes'))#'>
					
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_pedagio_incluso" value="#arguments.pedagio_incluso#" null='#iif(len(trim(arguments.pedagio_incluso)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_situacao_tributaria" value="#left(arguments.situacao_tributaria,2)#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_aliquota_icms" value="#arguments.aliquota_icms#" null='#iif(len(trim(arguments.aliquota_icms)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_reducao_base_calculo" value="#arguments.reducao_base_calculo#" null='#iif(len(trim(arguments.reducao_base_calculo)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_icms_incluso" value="#arguments.icms_incluso#" null='#iif(len(trim(arguments.icms_incluso)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_destaca_base_calc_icms" value="#arguments.destaca_base_calc_icms#" null='#iif(len(trim(arguments.destaca_base_calc_icms)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_fundamentacao_legal" value="#arguments.fundamentacao_legal#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_remetente" value="#arguments.rem_cod_pessoa#" null='#iif(len(trim(arguments.rem_cod_pessoa)), de('no'), de('yes'))#'>
					<cfif Len(arguments.dest_cod_pessoa)>
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_destinatario" value="#arguments.dest_cod_pessoa#" null='#iif(len(trim(arguments.dest_cod_pessoa)), de('no'), de('yes'))#'>
					<cfelse>
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_destinatario" null="yes" >
					</cfif>
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_coleta_logradouro" value="#arguments.coleta_logradouro#" >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_coleta_complemento" value="#arguments.coleta_complemento#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_coleta_bairro" value="#arguments.coleta_bairro#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_coleta_cep" value="#arguments.coleta_cep#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_coleta_cod_uf" value="#arguments.coleta_cod_uf#" null='#iif(len(trim(arguments.coleta_cod_uf)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_coleta_cod_municipio" value="#arguments.coleta_cod_municipio#" null='#iif(len(trim(arguments.coleta_cod_municipio)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_coleta_cod_dv" value="#arguments.coleta_cod_dv#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_coleta_cod_distrito" value="#arguments.coleta_cod_distrito#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_entrega_logradouro" value="#arguments.entrega_logradouro#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_entrega_complemento" value="#arguments.entrega_complemento#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_entrega_cep" value="#arguments.entrega_cep#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_entrega_bairro" value="#arguments.entrega_bairro#">
					<cfif Len(arguments.entrega_cod_uf)>
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_entrega_cod_uf" value="#arguments.entrega_cod_uf#">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_entrega_cod_municipio" value="#arguments.entrega_cod_municipio#">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_entrega_cod_distrito" value="#arguments.entrega_cod_distrito#">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_entrega_cod_dv" value="#arguments.entrega_cod_dv#">
					<cfelse>
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_entrega_cod_uf" null="yes">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_entrega_cod_municipio" null="yes">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_entrega_cod_distrito" null="yes">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_entrega_cod_dv" null="yes">
					</cfif>
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_controle_peso" value="#arguments.controle_peso#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_controle_viagem" value="#arguments.controle_viagem#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_controle_peso_veiculo" value="#arguments.controle_peso_veiculo#" null="#IIF(isDefined("arguments.controle_peso_veiculo") and Len(Trim(arguments.controle_peso_veiculo)),DE('no'),DE('yes'))#">>
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_situacao_id" value="#arguments.situacao_id#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_regra_fiscal" value="#arguments.regra_fiscal_id#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_observacao" value="#arguments.observacao#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_observacao_emitente" value="#arguments.observacao_emitente#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_negociador_id" value="#arguments.negociador_id#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_seguro" value="#arguments.seguro_por_conta#">
					<cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="p_num_lote" variable="retorno.num_lote">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_rowid" variable="retorno.rowid">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COM_RETORNO_EMBALAGEM" value="0">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_REM_ENVIA_MONITORAMENTO" value="0">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_DEST_ENVIA_MONITORAMENTO" value="0">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_PERMITE_LANCTOCTRC_ANTESMACR" value="0">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_OPERACAO_ID_REPOM" value="#arguments.operacao_id_repom#">
                </cfstoredproc>

				<!-- INSERE CONSIGNATARIO-->
                <cfif Len(Trim(arguments.CONS_COD_PESSOA))>
                <cfscript>
                    this.ins_lote_consignatario(argumentCollection = arguments);
				</cfscript>
                </cfif>
				
				<!-- INSERE COMPARTILHAMENTO COM AGENCIAS-->
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_lote_dml.prc_ins_lote_setor_compto" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_lote" value="#retorno.num_lote#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_filial" value="#session.cod_pessoa#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_departamento" value="#session.cod_departamento#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_setor" value="#session.cod_setor#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_centro_custo" value="#session.cod_centro_custo#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_permite_destinar" value="1">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_rowid" variable="retorno.rowid">
				</cfstoredproc>
				
				<!-- INSERE EMISSO DE DOCTOS FISCAIS-->
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_lote_dml.prc_ins_lote_setor_docto" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_lote" value="#retorno.num_lote#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_filial" value="#session.cod_pessoa#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_departamento" value="#session.cod_departamento#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_setor" value="#session.cod_setor#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_centro_custo" value="#session.cod_centro_custo#">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_rowid" variable="retorno.rowid">
				</cfstoredproc>
				
				<!-- INSERE LOTE CARREGAMENTO-->
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_lote_dml.prc_ins_lote_carga" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_lote" value="#retorno.num_lote#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_equipamento" value="#arguments.carga_equipamento#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_ambiente" value="#arguments.carga_ambiente#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_por_conta" value="#arguments.carga_por_conta#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_carregador" value="#arguments.carga_num_carregadores#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_contato_nome" value="#arguments.carga_nome#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_contato_cargo" value="#arguments.carga_cargo#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_contato_telefone" value="#arguments.carga_telefone#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_contato_email" value="#arguments.carga_email#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_imprime_ordem_cargto" value="#arguments.imprime_ordem_cargto#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_observacao" value="#arguments.carga_observacao#">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_rowid" variable="retorno.rowid">
				</cfstoredproc>
	
				<!-- INSERE LOTE DESCARREGAMENTO-->
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_lote_dml.prc_ins_lote_descarga" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_lote" value="#retorno.num_lote#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_equipamento" value="#arguments.descarga_equipamento#" null="#IIF(isDefined("arguments.descarga_equipamento") and Len(Trim(arguments.descarga_equipamento)),DE('no'),DE('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_ambiente" value="#arguments.descarga_ambiente#" null="#IIF(isDefined("arguments.descarga_ambiente") and Len(Trim(arguments.descarga_ambiente)),DE('no'),DE('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_por_conta" value="#arguments.descarga_por_conta#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_descarregador" value="#arguments.descarga_num_descarregadores#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_contato_nome" value="#arguments.descarga_nome#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_contato_cargo" value="#arguments.descarga_cargo#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_contato_telefone" value="#arguments.descarga_telefone#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_contato_email" value="#arguments.descarga_email#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_imprime_conhecimento" value="#arguments.imprime_conhecimento#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_observacao" value="#arguments.descarga_observacao#">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_rowid" variable="retorno.rowid">
				</cfstoredproc>
	
				<!-- INSERE LOTE CONTRATANTE-->
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_lote_dml.prc_ins_lote_contratante" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_lote" value="#retorno.num_lote#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_nome" value="#arguments.contratante_nome#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_cargo" value="#arguments.contratante_cargo#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_telefone" value="#arguments.contratante_telefone#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_email" value="#arguments.contratante_email#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_observacao" value="#arguments.negociacao_obs#">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_rowid" variable="retorno.rowid">
				</cfstoredproc>
	
				<!-- INSERE LOTE FATURAMENTO-->
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_lote_dml.prc_ins_lote_faturamento" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_lote" value="#retorno.num_lote#" null="#iif(len(trim(arguments.num_lote)),de('no'),de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_filial" value="#arguments.filial_fatura#" null="#iif(len(trim(arguments.filial_fatura)),de('no'),de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_departamento" value="#arguments.fat_cod_departamento#" null="#iif(len(trim(arguments.fat_cod_departamento)),de('no'),de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_setor" value="#arguments.setor_fatura#" null="#iif(len(trim(arguments.setor_fatura)),de('no'),de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_centro_custo" value="#arguments.fat_cod_centro_custo#" null="#iif(len(trim(arguments.fat_cod_centro_custo)),de('no'),de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_forma_id" value="#arguments.forma_pagto#" null="#iif(len(trim(arguments.forma_pagto)),de('no'),de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_agrupamento_id" value="#arguments.agrupamento#" null="#iif(len(trim(arguments.agrupamento)),de('no'),de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_condicao_id" value="#arguments.fat_vencimento#" null="#iif(len(trim(arguments.fat_vencimento)),de('no'),de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_dias_vencto" value="#arguments.num_dias#" null="#iif(len(trim(arguments.num_dias)),de('no'),de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_conta_favorecido" value="#arguments.ccorrente_favorecido#" null="#iif(len(trim(arguments.ccorrente_favorecido)),de('no'),de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_contato_nome" value="#arguments.fat_nome#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_contato_telefone" value="#arguments.fat_telefone#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_contato_email" value="#arguments.fat_email#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_logradouro" value="#arguments.fat_endereco#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_complemento" value="#arguments.fat_complemento#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_bairro" value="#arguments.fat_bairro#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_cep" value="#arguments.fat_cep#">
					<cfif Len(arguments.fat_cod_uf)>
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_uf" value="#arguments.fat_cod_uf#" null="#iif(len(trim(arguments.fat_cod_uf)),de('no'),de('yes'))#">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_municipio" value="#arguments.fat_cod_municipio#" null="#iif(len(trim(arguments.fat_cod_municipio)),de('no'),de('yes'))#">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_distrito" value="#arguments.fat_cod_distrito#" null="#iif(len(trim(arguments.fat_cod_distrito)),de('no'),de('yes'))#">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_dv" value="#arguments.fat_cod_dv#" null="#iif(len(trim(arguments.fat_cod_dv)),de('no'),de('yes'))#">
					<cfelse>
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_uf" null="yes">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_municipio" null="yes">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_distrito" null="yes">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_dv" null="yes">
					</cfif>
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_observacao" value="#arguments.fat_observacoes#">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_rowid" variable="retorno.rowid">
				</cfstoredproc>
				
				<!-- INSERE PERCENTUAIS DE COMISSO DO LOTE-->
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_lote_dml.prc_ins_lote_participacao" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_lote" value="#retorno.num_lote#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_data_vigencia" value="#arguments.data_contrato#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_perc_comissao" value="#arguments.perc_comissao#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_perc_negociador" value="#arguments.perc_negociador#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_perc_embarcador" value="#arguments.perc_embarcador#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_perc_emissor" value="#arguments.perc_emissor#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_valor_comissao_frota" value="0">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="P_TIPO_COMISSAO_FROTA" value="0">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_rowid" variable="retorno.rowid">
				</cfstoredproc>
				
				<!-- INSERE SEGURO NO LOTE -->
				<cfstoredproc procedure='oper.pkg_lote_dml.prc_ins_lote_seguro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_LOTE'  value='#retorno.num_lote#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ID_SEG_RCTR_C'  value='#arguments.ID_SEG_RCTR_C#'  null='#iif(len(trim(arguments.ID_SEG_RCTR_C)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RCF_DC'  value='#arguments.RCF_DC#'  null='#iif(len(trim(arguments.RCF_DC)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RESPONSAVEL_RCF_DC'  value='#arguments.RESPONSAVEL_RCF_DC#'  null='#iif(len(trim(arguments.RESPONSAVEL_RCF_DC)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ID_SEG_RCF_DC'  value='#arguments.ID_SEG_RCF_DC#'  null='#iif(len(trim(arguments.ID_SEG_RCF_DC)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_COB_RCF_DC_CLIENTE'  value='#arguments.VALOR_COB_RCF_DC_CLIENTE#'  null='#iif(len(trim(arguments.VALOR_COB_RCF_DC_CLIENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXIGE_GERENCIADORA'  value='#arguments.EXIGE_GERENCIADORA#'  null='#iif(len(trim(arguments.EXIGE_GERENCIADORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_GERENCIADORA'  value='#arguments.COD_GERENCIADORA#'  null='#iif(len(trim(arguments.COD_GERENCIADORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXIGE_MONITORAMENTO'  value='#arguments.EXIGE_MONITORAMENTO#'  null='#iif(len(trim(arguments.EXIGE_MONITORAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_MONITORA'  value='#arguments.COD_PESSOA_MONITORA#'  null='#iif(len(trim(arguments.COD_PESSOA_MONITORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_VALOR_MERCADORIA'  value='#arguments.TIPO_VALOR_MERCADORIA#'  null='#iif(len(trim(arguments.TIPO_VALOR_MERCADORIA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_MEDIO_MERCADORIA'  value='#arguments.VALOR_MEDIO_MERCADORIA#'  null='#iif(len(trim(arguments.VALOR_MEDIO_MERCADORIA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INTERVALO_MINUTO'  value='#arguments.INTERVALO_MINUTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RCTR_VI'  value='#arguments.RCTR_VI#'  null='#iif(len(trim(arguments.RCTR_VI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ID_SEG_RCTR_VI'  value='#arguments.ID_SEG_RCTR_VI#'  null='#iif(len(trim(arguments.ID_SEG_RCTR_VI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO_SEG#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  dbvarname='P_NUM_LIBERACAO_RCTR_C'  value='#arguments.NUM_LIBERACAO_RCTR_C#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  dbvarname='P_NUM_LIBERACAO_RCF_DC'  value='#arguments.NUM_LIBERACAO_RCF_DC#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  dbvarname='P_NUM_LIBERACAO_RCTR_VI'  value='#arguments.NUM_LIBERACAO_RCTR_VI#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ID_LOTE_SEGURO'  value='#arguments.ID_LOTE_SEGURO#' variable='retorno.ID_LOTE_SEGURO'  null='#iif(len(trim(arguments.ID_LOTE_SEGURO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID'  value='#arguments.ROWID#' variable='retorno.ROWID'  null='#iif(len(trim(arguments.ROWID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<!-- INSERE MATERIAIS E ACESSRIOS UTILIZADOS NA CARGA E DESCARGA DO LOTE-->
				<cfset arguments.materiais = Replace(arguments.materiais,","," ,","all")>		
				<cfloop index="i" list="#arguments.materiais#" delimiters="||">
					<cfif i neq -1 and (ListLen(i,',') eq 3)>
						<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_lote_dml.prc_ins_lote_material" username="#session.usuario#" password="#session.senha#">
							<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_lote" value="#retorno.num_lote#">
							<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_material" value="#ListGetAt(i,1,",")#">
							<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_carga" value="#ListGetAt(i,2,",")#">
							<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_descarga" value="#ListGetAt(i,3,",")#">
							<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_rowid" variable="retorno.rowid">
						</cfstoredproc>
					</cfif>
				</cfloop>		
				
				<cfif isdefined("arguments.lista_doctos")>
					<cfloop index="i" list="#arguments.lista_doctos#" delimiters=",">
						<cfscript>
								set_documentos = this.set_documentos_faturamento(num_lote = retorno.num_lote,
								documento_id = i,
								embarcador = IIf(ListFind(arguments.EMBARCADOR,i,','),DE("1"),DE("0")),
								faturista = IIf(ListFind(arguments.FATURISTA,i,','),DE("1"),DE("0")),
								motorista = IIf(ListFind(arguments.MOTORISTA,i,','),DE("1"),DE("0")));
						</cfscript>
						<cfif set_documentos.erro>
							<cfthrow object="#set_documentos.mensagem#">
						</cfif>
					</cfloop>
				</cfif>	
				
				<cfset retorno.mensagem  = 'Lote N '& #retorno.num_lote# &' cadastrado com sucesso.' >					
				<cfset retorno.erro = false>						
				</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere documentos lote, modelo antigo, excluir depois da alterao dos lotes
	-- GUTO - 10/05/2006
	--->
		<cffunction name="set_documentos_faturamento" access="remote" returntype="struct" output="true">
           <cfargument name="num_lote" required="yes">
           <cfargument name="documento_id" required="yes">
           <cfargument name="embarcador" required="yes">
           <cfargument name="motorista" required="yes">
           <cfargument name="faturista" required="yes">
	       <cftry>
		   	  <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_lote_dml.prc_ins_lote_docto" username="#session.usuario#" password="#session.senha#">
				 <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_lote" value="#arguments.num_lote#">
				 <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_documento_id" value="#arguments.documento_id#">
			 	 <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_embarcador" value="#arguments.embarcador#">
				 <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_faturista" value="#arguments.faturista#">
				 <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_motorista" value="#arguments.motorista#">
				 <cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_rowid" null="yes" variable="retorno.rowid">
			  </cfstoredproc>
		      <cfset retorno.mensagem = 'Documentos inseridos com sucesso.'>				
			  <cfset retorno.erro = false>						
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
	       </cftry>
	       <cfreturn retorno>
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Insere o lote de servios contratado
	-- CRISTOFER - 12/06/2006
	--->
	
	<cffunction name="ins_lote_contrato" displayname="Insere lote para servio contratado e carga avulsa" access="remote" returntype="struct" output="true">
		<cfargument name="data_contrato" required="yes">
		<cfargument name="num_natureza" required="yes">
		<cfargument name="num_produto" required="yes">
		<cfargument name="num_especie" required="yes">
		<cfargument name="peso" required="yes">
		<cfargument name="volume" required="yes">
		<cfargument name="m3" required="yes">
		<cfargument name="frete_em" required="yes">
		<cfargument name="cod_unidade" required="yes">
		<cfargument name="qtde_viagem" required="yes">
		<cfargument name="destaca_base_calculo" required="yes">
		<cfargument name="pedagio_incluso" required="yes">
		<cfargument name="icms_incluso" required="yes">
		<cfargument name="regra_fiscal_id" required="yes">
		<cfargument name="frete_valor_unitario" required="yes">
		<cfargument name="frete_valor" required="yes">
		<cfargument name="cod_pessoa_remetente" required="yes">
		<cfargument name="coleta_logradouro" required="yes">
		<cfargument name="coleta_complemento" required="yes">
		<cfargument name="coleta_bairro" required="yes">
		<cfargument name="coleta_cep" required="yes">
		<cfargument name="coleta_cod_uf" required="yes">
		<cfargument name="coleta_cod_municipio" required="yes">
		<cfargument name="coleta_cod_distrito" required="yes">
		<cfargument name="coleta_cod_dv" required="yes">
		<cfargument name="controle_por" required="yes">
		<cfargument name="observacao" required="yes">
		<cfargument name="negociador_id" required="yes">
		<cfargument name="contato_nome" required="yes">
		<cfargument name="contato_telefone" required="yes">
		<cfargument name="contato_email" required="yes">
		<cfargument name="negociado_com" required="yes">
		<cfargument name="negociado_com_cargo" required="yes">
		<cfargument name="negociado_com_telefone" required="yes">
		<cfargument name="negociado_com_email" required="yes">
		<cfargument name="seguro_por_conta" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_contrato_transporte.prc_inclui_lote_contrato" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_data_contrato" value="#arguments.data_contrato#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_natureza" value="#Val(arguments.num_natureza)#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_produto" value="#Val(arguments.num_produto)#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_especie" value="#Val(arguments.num_especie)#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_peso" value="#Val(arguments.peso)#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_volume" value="#Val(arguments.volume)#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_m3" value="#Val(arguments.m3)#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_frete_em" value="#arguments.frete_em#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_cod_unidade" value="#arguments.cod_unidade#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_qtde_viagem" value="#arguments.qtde_viagem#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_frete_valor_unitario" value="#Val(arguments.frete_valor_unitario)#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_frete_valor" value="#Val(arguments.frete_valor)#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_destaca_base_calculo" value="#Val(arguments.destaca_base_calculo)#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_pedagio_incluso" value="#Val(arguments.pedagio_incluso)#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_icms_incluso" value="#Val(arguments.icms_incluso)#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_regra_fiscal_id" value="#Val(arguments.regra_fiscal_id)#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_remetente" value="#Val(arguments.cod_pessoa_remetente)#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_coleta_logradouro" value="#arguments.coleta_logradouro#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_coleta_complemento" value="#arguments.coleta_complemento#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_coleta_bairro" value="#arguments.coleta_bairro#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_coleta_cep" value="#Val(arguments.coleta_cep)#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_coleta_cod_uf" value="#Val(arguments.coleta_cod_uf)#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_coleta_cod_municipio" value="#Val(arguments.coleta_cod_municipio)#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_coleta_cod_dv" value="#Val(arguments.coleta_cod_dv)#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_coleta_cod_distrito" value="#Val(arguments.coleta_cod_distrito)#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_controle_por" value="#Val(arguments.controle_por)#">
					<!--- <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_negociado_com" value="#arguments.negociado_com#">--->
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_observacao" value="#arguments.observacao#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_negociador_id" value="#arguments.negociador_id#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_contato_nome" value="#arguments.contato_nome#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_contato_telefone" value="#arguments.contato_telefone#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_contato_email" value="#arguments.contato_email#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_negociado_com" value="#arguments.negociado_com#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_negociado_com_cargo" value="#arguments.negociado_com_cargo#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_negociado_com_telefone" value="#arguments.negociado_com_telefone#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_negociado_com_email" value="#arguments.negociado_com_email#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_seguro_por_conta" value="#arguments.seguro_por_conta#">
					<cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="p_num_lote" variable="retorno.num_lote">
				</cfstoredproc>
				<!-- INSERE PERCENTUAIS DE COMISSO DO LOTE-->
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_lote_dml.PRC_INS_LOTE_PARTICIPACAO" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_lote" value="#retorno.num_lote#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_data_vigencia" value="#arguments.data_contrato#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_perc_comissao" value="50">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_perc_negociador" value="50">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_perc_embarcador" value="25">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_perc_emissor" value="25">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="P_VALOR_COMISSAO_FROTA" value="0">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_TIPO_COMISSAO_FROTA" value="1">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_rowid" null="yes" variable="retorno.rowid" >
				</cfstoredproc>
				
				<cfif isdefined("arguments.lista_doctos")>
					<cfloop index="i" list="#arguments.lista_doctos#" delimiters=",">
						<cfscript>
							set_documentos = this.set_documentos_faturamento(num_lote = retorno.num_lote,
																			  documento_id = i,
																			  embarcador = IIf(ListFind(arguments.EMBARCADOR,i,','),DE("1"),DE("0")),
																			  faturista = IIf(ListFind(arguments.FATURISTA,i,','),DE("1"),DE("0")),
																			  motorista = IIf(ListFind(arguments.MOTORISTA,i,','),DE("1"),DE("0")));
																		
						</cfscript>
						<cfif set_documentos.erro>
							<cfthrow object="#set_documentos.mensagem#">
						</cfif>
					</cfloop>
				</cfif>
				<cfset retorno.mensagem = 'Lote inserido com sucesso.'>				
				<cfset retorno.erro = false>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
	<cfreturn retorno>
	</cffunction>
		
	
	<!--- 
	-- PROPSITO
	-- Insere o lote de servios contratado
	-- CRISTOFER - 12/06/2006
	--->
	<cffunction name="set_contrato_transporte" displayname="Insere Contrato Transporte" access="remote" returntype="struct" output="true">
		<cfargument name="num_romaneio" required="yes" type="numeric">
		<cfargument name="num_formulario" required="yes" type="numeric">
		<cfargument name="cod_pessoa_filial" required="yes"  type="numeric">
		<cfargument name="cod_departamento" required="yes" type="numeric">
		<cfargument name="cod_setor" required="yes" type="numeric">
		<cfargument name="cod_centro_custo" required="yes" type="numeric">
		<cfargument name="peso" required="yes" type="numeric">
		<cfargument name="volume" required="yes" type="numeric">
		<cfargument name="m3" required="yes" type="numeric">
		<cfargument name="frete_em" required="yes">
		<cfargument name="cod_unidade" required="yes">
		<cfargument name="tolerancia_falta" required="yes" type="numeric">
		<cfargument name="valor_unitario" required="yes" type="numeric">
		<cfargument name="valor_frete_bruto" required="yes" type="numeric">
		<cfargument name="valor_frete_liquido" required="yes" type="numeric">
		<cfargument name="motorista_cod_pessoa" required="yes" >
		<cfargument name="proprietario_nit" required="yes">
		<cfargument name="placa_controle" required="yes">
		<cfargument name="placa_referencia" required="yes">
		<cfargument name="cod_pessoa_proprietario" required="yes" type="numeric">
		<cfargument name="prop_endereco" required="yes">
		<cfargument name="proprietario_cod_uf" required="yes">
		<cfargument name="proprietario_cod_municipio" required="yes">
		<cfargument name="proprietario_cod_distrito" required="yes">
		<cfargument name="proprietario_cod_dv" required="yes">
		<cfargument name="observacao" required="yes">
		<cfargument name="valores" required="no" default=""> 
		<cftry>
			<cftransaction>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_contrato_transporte.prc_ins_contrato_transporte" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_romaneio" value="#Val(arguments.num_romaneio)#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_formulario" value="#Val(arguments.num_formulario)#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_serie_formulario" value="1">				
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_filial" value="#Val(arguments.cod_pessoa_filial)#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_departamento" value="#Val(arguments.cod_departamento)#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_setor" value="#Val(arguments.cod_setor)#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_centro_custo" value="#Val(arguments.cod_centro_custo)#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_data_emissao" value="#arguments.data_emissao#">
				<cfprocparam type="in" cfsqltype='cf_sql_numeric' scale='5' dbvarname="p_peso" value="#Val(arguments.peso)#">
				<cfprocparam type="in" cfsqltype='cf_sql_numeric' scale='5' dbvarname="p_volume" value="#Val(arguments.volume)#">
				<cfprocparam type="in" cfsqltype='cf_sql_numeric' scale='5' dbvarname="p_m3" value="#Val(arguments.m3)#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_frete_em" value="#arguments.frete_em#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_cod_unidade" value="#arguments.cod_unidade#">
				<cfprocparam type="in" cfsqltype='cf_sql_numeric' scale='5' dbvarname="p_tolerancia_falta" value="#Val(arguments.tolerancia_falta)#">
				<cfprocparam type="in" cfsqltype='cf_sql_numeric' scale='5' dbvarname="p_valor_unitario" value="#Val(arguments.valor_unitario)#">
				<cfprocparam type="in" cfsqltype='cf_sql_numeric' scale='5' dbvarname="p_valor_frete_bruto" value="#Val(arguments.valor_frete_bruto)#">
				<cfprocparam type="in" cfsqltype='cf_sql_numeric' scale='5' dbvarname="p_valor_frete_liquido" value="#Val(arguments.valor_frete_liquido)#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_motorista_cod_pessoa" value="#arguments.motorista_cod_pessoa#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_placa_controle" value="#arguments.placa_controle#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_placa_referencia" value="#arguments.placa_referencia#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_proprietario_cod_pessoa" value="#Val(arguments.cod_pessoa_proprietario)#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_proprietario_endereco" value="#arguments.prop_endereco#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_proprietario_cod_uf" value="#Val(arguments.proprietario_cod_uf)#" null="#IIF(isDefined("arguments.proprietario_cod_uf") and Len(Trim(arguments.proprietario_cod_uf)),DE('no'),DE('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_proprietario_cod_municipio" value="#Val(arguments.proprietario_cod_municipio)#" null="#IIF(isDefined("arguments.proprietario_cod_municipio") and Len(Trim(arguments.proprietario_cod_municipio)),DE('no'),DE('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_proprietario_cod_distrito" value="#Val(arguments.proprietario_cod_distrito)#" null="#IIF(isDefined("arguments.proprietario_cod_distrito") and Len(Trim(arguments.proprietario_cod_distrito)),DE('no'),DE('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_proprietario_cod_dv" value="#Val(arguments.proprietario_cod_dv)#" null="#IIF(isDefined("arguments.proprietario_cod_dv") and Len(Trim(arguments.proprietario_cod_dv)),DE('no'),DE('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_proprietario_nit" value="#arguments.proprietario_nit#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_observacao" value="#arguments.observacao#">
                <!--- campos adicionados repom --->
                <cfprocparam type="in" cfsqltype='cf_sql_numeric' scale='5' dbvarname="p_valor_saldo" null="yes">	
                <cfprocparam type="in" cfsqltype='cf_sql_numeric' scale='5' dbvarname="p_pagador_saldo" null="yes">
                
                <cfprocparam type="in" cfsqltype='cf_sql_numeric' scale='5' dbvarname="p_valor_adiantamento" null="yes">	
                <cfprocparam type="in" cfsqltype='cf_sql_numeric' scale='5' dbvarname="p_pagador_adiantamento" null="yes">
                
                <cfprocparam type="in" cfsqltype='cf_sql_numeric' scale='5' dbvarname="P_QUITACAO_REPOM_LIBERADA" null="yes">
				
                <cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="p_lancto_id" variable="retorno.lancto_id">
				<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_rowid" variable="retorno.rowid">
			</cfstoredproc>
			<cfset retorno.mensagem = 'Contrato de Transporte inserido com sucesso.'>				
			<cfset retorno.erro = false>
			<cfif isDefined("arguments.VALORES") and Len(Trim(arguments.VALORES))>
				<cfset arguments.VALORES = Replace(arguments.VALORES,","," ,","all")>					
				<cfloop index="i" list="#arguments.VALORES#" delimiters="||">
					<cfif i neq -1 and (ListLen(i,',') gt 3)>
						<cfscript>
							set_manipulacao = ins_item_contrato(lancto_id=retorno.lancto_id,
															item_id=ListGetAt(i,1,","),
															descricao=ListGetAt(i,2,","),
															desconto=ListGetAt(i,3,","),
															valor=ListGetAt(i,4,","));
						</cfscript>
						<cfif set_manipulacao.erro>
							<cfthrow object="#set_manipulacao.mensagem#" >
						</cfif>
					</cfif>
				</cfloop>	
			</cfif>	
			</cftransaction> 						
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
	
		
	<!--- 
-- PROPSITO
-- Inserir seguro no Lote 
-- wagner 28/06/2006 09:17:18 - CRIADO
--->
	<cffunction name='ins_lote_seguro' displayname='Inserir seguro no Lote' access='remote' returntype='Struct' output='true'>;
		<cfargument name='NUM_LOTE' required='yes'>
		<cfargument name='ID_SEG_RCTR_C' required='yes'>
		<cfargument name='RCF_DC' required='yes'>
		<cfargument name='RESPONSAVEL_RCF_DC' required='yes'>
		<cfargument name='ID_SEG_RCF_DC' required='yes'>
		<cfargument name='VALOR_COB_RCF_DC_CLIENTE' required='yes'>
		<cfargument name='NUM_LIBERACAO' required='yes'>
		<cfargument name='EXIGE_GERENCIADORA' required='yes'>
		<cfargument name='COD_GERENCIADORA' required='yes'>
		<cfargument name='EXIGE_MONITORAMENTO' required='yes'>
		<cfargument name='COD_PESSOA_MONITORA' required='yes'>
		<cfargument name='TIPO_VALOR_MERCADORIA' required='yes'>
		<cfargument name='VALOR_MEDIO_MERCADORIA' required='yes'>
		<cfargument name='INTERVALO_MINUTO' required='yes'>
		<cfargument name='RCTR_VI' required='yes'>
		<cfargument name='ID_SEG_RCTR_VI' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='ID_LOTE_SEGURO' required='no' default="">
		<cfargument name='ROWID' required='no' default="">
				<cfstoredproc procedure='oper.pkg_lote_dml.prc_ins_lote_seguro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_LOTE'  value='#arguments.NUM_LOTE#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ID_SEG_RCTR_C'  value='#arguments.ID_SEG_RCTR_C#'  null='#iif(len(trim(arguments.ID_SEG_RCTR_C)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RCF_DC'  value='#arguments.RCF_DC#'  null='#iif(len(trim(arguments.RCF_DC)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RESPONSAVEL_RCF_DC'  value='#arguments.RESPONSAVEL_RCF_DC#'  null='#iif(len(trim(arguments.RESPONSAVEL_RCF_DC)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ID_SEG_RCF_DC'  value='#arguments.ID_SEG_RCF_DC#'  null='#iif(len(trim(arguments.ID_SEG_RCF_DC)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_COB_RCF_DC_CLIENTE'  value='#arguments.VALOR_COB_RCF_DC_CLIENTE#'  null='#iif(len(trim(arguments.VALOR_COB_RCF_DC_CLIENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_LIBERACAO'  value='#arguments.NUM_LIBERACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXIGE_GERENCIADORA'  value='#arguments.EXIGE_GERENCIADORA#'  null='#iif(len(trim(arguments.EXIGE_GERENCIADORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_GERENCIADORA'  value='#arguments.COD_GERENCIADORA#'  null='#iif(len(trim(arguments.COD_GERENCIADORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXIGE_MONITORAMENTO'  value='#arguments.EXIGE_MONITORAMENTO#'  null='#iif(len(trim(arguments.EXIGE_MONITORAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_MONITORA'  value='#arguments.COD_PESSOA_MONITORA#'  null='#iif(len(trim(arguments.COD_PESSOA_MONITORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_VALOR_MERCADORIA'  value='#arguments.TIPO_VALOR_MERCADORIA#'  null='#iif(len(trim(arguments.TIPO_VALOR_MERCADORIA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_MEDIO_MERCADORIA'  value='#arguments.VALOR_MEDIO_MERCADORIA#'  null='#iif(len(trim(arguments.VALOR_MEDIO_MERCADORIA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INTERVALO_MINUTO'  value='#arguments.INTERVALO_MINUTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RCTR_VI'  value='#arguments.RCTR_VI#'  null='#iif(len(trim(arguments.RCTR_VI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ID_SEG_RCTR_VI'  value='#arguments.ID_SEG_RCTR_VI#'  null='#iif(len(trim(arguments.ID_SEG_RCTR_VI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ID_LOTE_SEGURO'  value='#arguments.ID_LOTE_SEGURO#' variable='retorno.ID_LOTE_SEGURO'  null='#iif(len(trim(arguments.ID_LOTE_SEGURO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_INTEGER' dbvarname='P_ROWID'  value='#arguments.ROWID#' variable='retorno.ROWID'  null='#iif(len(trim(arguments.ROWID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
		</cffunction>
		
		<!--- 
-- PROPSITO
-- Inserir Conhecimento
-- wagner 10/07/2006 09:17:18 - CRIADO
--->
	<cffunction name="ins_conhecimento" displayname="Insere conhecimento" access="remote" returntype="struct" output="true">
		<cfargument name="placa_controle" required="yes">
		<cfargument name="placa_referencia" required="yes">
		<cfargument name="cod_pessoa_filial" required="yes">
		<cfargument name="cod_departamento" required="yes">
		<cfargument name="cod_setor" required="yes">
		<cfargument name="cod_centro_custo" required="yes">
		<cfargument name="num_lote" required="yes">
		<cfargument name="peso_ctrc" required="yes">
		<cfargument name="volume" required="yes">
		<cfargument name="m3" required="yes">
		<cfargument name="frete_peso" required="yes">
		<cfargument name="frete_valor" required="yes">
		<cfargument name="coleta" required="yes">
		<cfargument name="cod_destinatario" required="yes">
		<cfargument name="entrega_uf" required="yes">
		<cfargument name="entrega_cod_uf" required="yes">
		<cfargument name="entrega_cod_municipio" required="yes">
		<cfargument name="entrega_cod_distrito" required="yes">
		<cfargument name="entrega_cod_dv" required="yes">
		<cfargument name="num_conhecimento" required="yes">
		<cfargument name="serie" required="yes">
		<cfargument name="data_emissao" required="no" default="">
		<cfargument name="despacho" required="yes">
		<cfargument name="base_calculo_icms" required="yes">
		<cfargument name="aliquota_icms" required="yes">
		<cfargument name="ademe" required="yes">
		<cfargument name="desconto" required="yes">
		<cfargument name="valor_icms" required="yes">
		<cfargument name="VALOR_ICMS_SUBSTIT" required="yes">		
		<cfargument name="coleta_entrega" required="yes">
		<cfargument name="impostos" required="yes">
		<cfargument name="total_conhecimento" required="yes">
		<cfargument name="cod_pessoa_motorista" required="yes">
		<cfargument name="nome_motorista" required="yes">
		<cfargument name="cod_pessoa_proprietario" required="yes">
		<cfargument name="prop_cnpj_cpf" required="yes">
		<cfargument name="prop_razao_social" required="yes">
		<cfargument name="prop_endereco" required="yes">
		<cfargument name="prop_uf" required="yes">
		<cfargument name="observacao"required="yes">
		<cfargument name="st_icms_id" required="yes">
		<cfargument name="notas"required="yes">
		<cftry>
        <cfif not Len(Trim(arguments.VALOR_ICMS_SUBSTIT))>
			<cfset arguments.VALOR_ICMS_SUBSTIT = 0>
        </cfif>
		<cftransaction action="begin">
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_contrato_transporte.prc_ins_ctrc_contrato_transp" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_placa_controle" value="#arguments.placa_controle#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_placa_referencia" value="#arguments.placa_referencia#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_filial" value="#arguments.cod_pessoa_filial#" null="#iif(len(trim(arguments.cod_pessoa_filial)), de('no'), de('yes'))#" >
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_departamento" value="#arguments.cod_departamento#" null="#iif(len(trim(arguments.cod_departamento)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_setor" value="#arguments.cod_setor#" null="#iif(len(trim(arguments.cod_setor)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_centro_custo" value="#arguments.cod_centro_custo#" null="#iif(len(trim(arguments.cod_centro_custo)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_lote" value="#arguments.num_lote#" null="#iif(len(trim(arguments.num_lote)), de('no'), de('yes'))#">
				<cfprocparam type="inout" cfsqltype="cf_sql_float" dbvarname="p_peso" value="#arguments.peso_ctrc#" variable="retorno.peso" null="#iif(len(trim(arguments.peso_ctrc)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_volume" value="#arguments.volume#" null="#iif(len(trim(arguments.volume)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_m3" value="#arguments.m3#" null="#iif(len(trim(arguments.m3)), de('no'), de('yes'))#">
				
				<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_frete_unitario" value="#arguments.frete_peso#" null="#iif(len(trim(arguments.frete_peso)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_frete_valor" value="#arguments.frete_valor#" null="#iif(len(trim(arguments.frete_valor)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_coleta_municipio" value="#arguments.coleta#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_destinatario" value="#arguments.cod_destinatario#" null="#iif(len(trim(arguments.cod_destinatario)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_char" dbvarname="p_entrega_uf" value="#Trim(arguments.entrega_uf)#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_entrega_cod_uf" value="#arguments.entrega_cod_uf#" null="#iif(len(trim(arguments.entrega_cod_uf)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_entrega_cod_municipio" value="#arguments.entrega_cod_municipio#" null="#iif(len(trim(arguments.entrega_cod_municipio)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_entrega_cod_distrito" value="#arguments.entrega_cod_distrito#" null="#iif(len(trim(arguments.entrega_cod_distrito)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_entrega_cod_dv" value="#arguments.entrega_cod_dv#" null="#iif(len(trim(arguments.entrega_cod_dv)), de('no'), de('yes'))#">
				<cfprocparam type="inout" cfsqltype="cf_sql_integer" dbvarname="p_num_conhecimento" value="#arguments.num_conhecimento#" null="#iif(len(trim(arguments.num_conhecimento)), de('no'), de('yes'))#">
				
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_serie" value="#arguments.serie#">
				<cfprocparam type="inout" cfsqltype="cf_sql_varchar" dbvarname="p_data_emissao" value="#arguments.data_emissao#">
				<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_despacho" value="#arguments.despacho#" null="#iif(len(trim(arguments.despacho)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_base_calculo_icms" value="#arguments.base_calculo_icms#" null="#iif(len(trim(arguments.base_calculo_icms)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_aliquota_icms" value="#arguments.aliquota_icms#" null="#iif(len(trim(arguments.aliquota_icms)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_ademe" value="#arguments.ademe#" null="#iif(len(trim(arguments.ademe)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_desconto" value="#arguments.desconto#" null="#iif(len(trim(arguments.desconto)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_valor_icms" value="#arguments.valor_icms#" null="#iif(len(trim(arguments.valor_icms)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_valor_icms_substit" value="#arguments.VALOR_ICMS_SUBSTIT#" null="#iif(len(trim(arguments.VALOR_ICMS_SUBSTIT)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_coleta_entrega" value="#arguments.coleta_entrega#" null="#iif(len(trim(arguments.coleta_entrega)), de('no'), de('yes'))#">
				
				<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_impostos" value="#arguments.impostos#" null="#iif(len(trim(arguments.impostos)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_total_conhecimento" value="#arguments.total_conhecimento#" null="#iif(len(trim(arguments.total_conhecimento)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_motorista" value="#arguments.cod_pessoa_motorista#" null="#iif(len(trim(arguments.cod_pessoa_motorista)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_nome_motorista" value="#arguments.nome_motorista#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_proprietario" value="#arguments.cod_pessoa_proprietario#" null="#iif(len(trim(arguments.cod_pessoa_proprietario)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_prop_cnpj_cpf" value="#arguments.prop_cnpj_cpf#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_prop_razao_social" value="#arguments.prop_razao_social#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_prop_endereco" value="#arguments.prop_endereco#">
				<cfprocparam type="in" cfsqltype="cf_sql_char" dbvarname="p_prop_uf" value="#Trim(arguments.prop_uf)#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_observacao" value="#arguments.observacao#">
				
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_st_icms_id" value="#NumberFormat(arguments.st_icms_id,'00')#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_entrada_dados" value="2">
				<cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="p_conhecimento_id" variable="retorno.conhecimento_id">
				<cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="p_num_romaneio" variable="retorno.num_romaneio">
				<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_rowid" variable="retorno.rowid">
			</cfstoredproc> 
			
			<!--- Insere Notas fiscais --->
				
				<cfscript>
					v_numero 	   = this.ListaToArray (lista = arguments, variavel = "NOTA_NUMERO_NOTAS_FISCAIS");
					v_data_emissao = this.ListaToArray (lista = arguments, variavel = "NOTA_DATA_EMISSAO_NOTAS_FISCAIS");
					v_serie 	   = this.ListaToArray (lista = arguments, variavel = "NOTA_SERIE_NOTAS_FISCAIS");
					v_sub_serie    = this.ListaToArray (lista = arguments, variavel = "NOTA_SUB_SERIE_NOTAS_FISCAIS");
					v_modelo       = this.ListaToArray (lista = arguments, variavel = "NOTA_MODELO_NOTAS_FISCAIS");
					v_valor		   = this.ListaToArray (lista = arguments, variavel = "NOTA_VALOR_NOTAS_FISCAIS");
				</cfscript>

				<cfloop from="1" to="#ArrayLen(v_numero)#" index="count">
					<cfscript>
						conn=CreateObject("component","_transportes.manipulacao.cfc_emissao_documentos");
						conn.ins_nf_conhecimento(conhecimento_id = retorno.conhecimento_id,
												 numero			 = v_numero[count],
												 data_emissao	 = v_data_emissao[count],
												 modelo 		 = v_modelo[count],
												 serie 			 = v_serie[count],
												 sub_serie 		 = v_sub_serie[count],
												 valor_total 	 = v_valor[count]);
					</cfscript>
				</cfloop>
			 <cfset retorno.mensagem = 'Conhecimento inserido com sucesso.'>
			 <cfset retorno.erro = false>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
	    <cfreturn retorno>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Gera um romaneio para o manifesto
	-- cristofer 27/11/2006 14:35:51 - CRIADO
	--->
	<cffunction name='gera_romaneio_manifesto' displayname='Gera um romaneio para o manifesto' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_LOTE' required='yes'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='COD_PESSOA_MOTORISTA' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
				<cfstoredproc procedure='oper.pkg_contrato_transporte.prc_gera_romaneio_manifesto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_LOTE'  value='#arguments.NUM_LOTE#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_MOTORISTA'  value='#arguments.COD_PESSOA_MOTORISTA#'  null='#iif(len(trim(arguments.COD_PESSOA_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO' variable='retorno.NUM_ROMANEIO' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID' variable='retorno.ITEM_ID' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Executa o engate de veiculos de terceiro
	-- guto 18/01/2007 09:17:31 - CRIADO
	--->
	<cffunction name='engata_composicao_terceiro' displayname='Executa o engate de veiculos de terceiro' access='remote' returntype='Struct' output='true'>
		<cfargument name='COMPOSICAO' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.prc_engata_composicao_terceiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPOSICAO'  value='#arguments.COMPOSICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Engate feito com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	 
    
    <!--- 
    -- PROPSITO
    -- Cancela uma carta frete
    -- cristofer 08/05/2008 10:47:53 - CRIADO
    --->
    <cffunction name='cancelar_contrato_transporte' displayname='Cancela uma carta frete' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cfargument name='DATA_CANCELAMENTO' required='yes'>
        <cfargument name='MOTIVO_CANCELAMENTO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_contrato_transp.prc_cancelar_contrato_transp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CANCELAMENTO'  value='#arguments.DATA_CANCELAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO_CANCELAMENTO'  value='#arguments.MOTIVO_CANCELAMENTO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Carta frete cancelada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!--- 
    -- PROPSITO
    -- Marca uma carta frete como impressa
    -- cristofer 08/05/2008 10:47:53 - CRIADO
    --->
    <cffunction name='imprimir_contrato_transporte' displayname='Cancela uma carta frete' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_contrato_transp.prc_imprimir_contrato_transp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Carta frete impressa com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
	
    <!--- 
	-- PROPSITO
	-- Liquida um Contrato CTF
	-- ANDERSONC 18/08/2009 10:13:27 - CRIADO
	--->
	<cffunction name='liquidar_contrato' displayname='Liquida um Contrato CTF' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_CONTRATO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='ctffrete.pkg_ctffrete.prc_liquidar_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONTRATO'  value='#arguments.COD_CONTRATO#'  null='#iif(len(trim(arguments.COD_CONTRATO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato liquidado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Aprovar uma carta-frete
	-- LEOPOLDOS 10/05/2010 14:43:19 - CRIADO
	--->
	<cffunction name='prc_aprova_contrato_trasp' displayname='Aprovar uma carta-frete' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_contrato_transp.prc_aprova_contrato_trasp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Carta Frete aprovada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Reprova uma carta-frete
	-- LEOPOLDOS 10/05/2010 14:44:20 - CRIADO
	--->
	<cffunction name='prc_reprova_contrato_trasp' displayname='Reprova uma carta-frete' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cfargument name='MOTIVO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_contrato_transp.prc_reprova_contrato_trasp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO'  value='#arguments.MOTIVO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Carta Frete aprovada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
    <!--- 
	-- PROPSITO
	-- Insere um Nm. Formulrio
	-- ANDERSONC 16/02/2011 13:47:00 - CRIADO
	--->
	<cffunction name='set_num_formulario' displayname='Insere um Nm. Formulrio' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cfargument name='NUM_FORMULARIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_contrato_transporte.prc_set_num_formulario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_FORMULARIO'  value='#arguments.NUM_FORMULARIO#'  null='#iif(len(trim(arguments.NUM_FORMULARIO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Nm. Formulrio inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Confirma o e-mail de aprovao de uma carta frete, podendo aprov-la ou reprov-la
	-- ANDERSONC 16/02/2011 13:58:03 - CRIADO
	--->
	<cffunction name='confirmar_email_aprovacao' displayname='Confirma o email de aprovao de uma carta frete, podendo aprov-la ou reprov-la' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cfargument name='CHAVE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_contrato_transp_liberacao.prc_confirmar_email_aprovacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CHAVE'  value='#arguments.CHAVE#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_RETORNO' variable='retorno.TIPO_RETORNO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MENSAGEM_RETORNO' variable='retorno.MENSAGEM_RETORNO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('E-mail confirmado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere um Contrato de transporte
	-- cristofer 27/11/2006 14:34:47 - CRIADO
	--->
	<cffunction name='ins_contrato_transporte' displayname='Insere um Contrato de transporte' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='no' default=''>
		<cfargument name='NUM_FORMULARIO' required='yes'>
		<cfargument name='SERIE_FORMULARIO' required='no' default="U">
		<cfargument name='TIPO_CONTRATO' required='no' default="0">        
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='FRETE_EM' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='TOLERANCIA_FALTA' required='yes'>
		<cfargument name='VALOR_UNITARIO' required='yes'>
		<cfargument name='VALOR_FRETE_BRUTO' required='yes'>
		<cfargument name='VALOR_FRETE_LIQUIDO' required='yes'>
		<cfargument name='MOTORISTA_COD_PESSOA' required='yes'>
		<cfargument name='PLACA_CONTROLE' required='yes'>
		<cfargument name='PLACA_REFERENCIA' required='yes'>
		<cfargument name='PROPRIETARIO_COD_PESSOA' required='yes'>
		<cfargument name='PROPRIETARIO_ENDERECO' required='yes'>
		<cfargument name='PROPRIETARIO_COD_UF' required='no' default="" >
		<cfargument name='PROPRIETARIO_COD_MUNICIPIO' required='no' default="">
		<cfargument name='PROPRIETARIO_COD_DISTRITO' required='no' default="">
		<cfargument name='PROPRIETARIO_COD_DV' required='no' default="">
		<cfargument name='PROPRIETARIO_NIT' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='PROPRIETARIO_MUNICIPIO_ID' required='yes'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='TIPO_CARGA' required='no' default="">
		<cfargument name='CONHECIMENTO_ID' required='no' default="">
		<cfargument name='NUM_LOTE' required='no' default="">
		<cfargument name='TOTAL_PARCELA' required='no' default="0">
		<cfargument name='CARGA_ID_COLETA' required='no' default="">
		<cfargument name='CARGA_ID_ENTREGA' required='no' default="">
		<cfargument name='CTF' required='no' default="0">
        <cfargument name='COD_MODELO' required='yes'>
		<cfargument name='COD_REMETENTE' required='no' default="">
		<cfargument name='COD_DESTINATARIO' required='no' default="">
        <cfargument name='OPERACAO_ID' required='no' default=''>
        <cfargument name='CTRC_ID' required='no' default=''>
        <cfargument name='DIARIA_CTRC_ID' required='no' default=''>
        <cfargument name='DIARIA_CRT_ID' required='no' default=''>
        <cfargument name='USUARIO_LIBERACAO' required='no' default=''>
        <cfargument name='SENHA_LIBERACAO' required='no' default=''>
        <cfargument name='VALOR_MAXIMO' required='yes'>
        <cfargument name='DIVISAO_ID' required='no' default=''>
        <cfargument name='REPOM' required='yes'>
		<cfargument name='COD_ORGANIZACIONAL' required='no' default="">
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
        <cfargument name='AVULSA' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfset retorno.num_romaneio = arguments.num_romaneio>
				<cfset retorno.conhecimento_id = arguments.conhecimento_id>
				<cfif arguments.tipo_carga eq 2>
					<!--- Gera um romaneio para o manifesto --->
					<cfscript>
						retorno_roo = this.gera_romaneio_manifesto(	NUM_LOTE             	= arguments.num_lote,
																	MANIFESTO_ID			= arguments.manifesto_id,
																	CONHECIMENTO_ID			= arguments.conhecimento_id,
																	COD_PESSOA_MOTORISTA	= arguments.motorista_cod_pessoa,
																	DATA_EMISSAO			= arguments.data_emissao,
																	OBSERVACAO				= arguments.observacao);
						retorno.num_romaneio = retorno_roo.num_romaneio;
					</cfscript>
				</cfif>
                <cfstoredproc procedure='oper.pkg_contrato_transp.prc_ins_contrato_transp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID' variable='retorno.LANCTO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_FORMULARIO'  value='#arguments.NUM_FORMULARIO#'  null='#iif(len(trim(arguments.NUM_FORMULARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE_FORMULARIO'  value='#arguments.SERIE_FORMULARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_CONTRATO'  value='#arguments.TIPO_CONTRATO#'  null='#iif(len(trim(arguments.TIPO_CONTRATO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO'  value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VOLUME'  value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FRETE_EM'  value='#arguments.FRETE_EM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TOLERANCIA_FALTA'  value='#arguments.TOLERANCIA_FALTA#'  null='#iif(len(trim(arguments.TOLERANCIA_FALTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_UNITARIO'  value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_FRETE_BRUTO'  value='#arguments.VALOR_FRETE_BRUTO#'  null='#iif(len(trim(arguments.VALOR_FRETE_BRUTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_FRETE_LIQUIDO'  value='#arguments.VALOR_FRETE_LIQUIDO#'  null='#iif(len(trim(arguments.VALOR_FRETE_LIQUIDO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOTORISTA_COD_PESSOA'  value='#arguments.MOTORISTA_COD_PESSOA#'  null='#iif(len(trim(arguments.MOTORISTA_COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CONTROLE'  value='#arguments.PLACA_CONTROLE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_REFERENCIA'  value='#arguments.PLACA_REFERENCIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROPRIETARIO_COD_PESSOA'  value='#arguments.PROPRIETARIO_COD_PESSOA#'  null='#iif(len(trim(arguments.PROPRIETARIO_COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROPRIETARIO_ENDERECO'  value='#arguments.PROPRIETARIO_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROPRIETARIO_MUNICIPIO_ID'  value='#arguments.PROPRIETARIO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.PROPRIETARIO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROPRIETARIO_NIT'  value='#arguments.PROPRIETARIO_NIT#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_MODELO'  value='#arguments.COD_MODELO#' null='#iif(len(trim(arguments.COD_MODELO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CTRC_ID'  value='#arguments.CTRC_ID#'  null='#iif(len(trim(arguments.CTRC_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIARIA_CTRC_ID'  value='#arguments.DIARIA_CTRC_ID#'  null='#iif(len(trim(arguments.DIARIA_CTRC_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIARIA_CRT_ID'  value='#arguments.DIARIA_CRT_ID#'  null='#iif(len(trim(arguments.DIARIA_CRT_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO_LIBERACAO'  value='#arguments.USUARIO_LIBERACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SENHA_LIBERACAO'  value='#arguments.SENHA_LIBERACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_MAXIMO'  value='#arguments.VALOR_MAXIMO#'  null='#iif(len(trim(arguments.VALOR_MAXIMO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANIZACIONAL'  value='#arguments.COD_ORGANIZACIONAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORGANIZACIONAL_ID'  value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AVULSA'  value='#arguments.AVULSA#'  null='#iif(len(trim(arguments.AVULSA)), de('no'), de('yes'))#'>
                </cfstoredproc>
				
                <!---Vincula ao CTRC--->
                <cfif Len(Trim(arguments.CONHECIMENTO_ID))>
					<cfscript>
                        set_vinculo = this.ins_vinculo_contrato_conhecimento(lancto_id = retorno.LANCTO_ID,
                                                                             conhecimento_id = arguments.conhecimento_id);
                    </cfscript>
                    <cfif set_vinculo.erro>
                        <cfthrow object="#set_vinculo.mensagem#">
                    </cfif>
                </cfif>
                
				<!--- Insere ITENS --->
				<cfscript>
					v_item_id 	   = this.ListaToArray (lista = arguments, variavel = "ACR_ITEM_ID");
					v_descricao    = this.ListaToArray (lista = arguments, variavel = "ACR_DESCRICAO");
					v_desconto 	   = this.ListaToArray (lista = arguments, variavel = "ACR_DESCONTO_COD");
					v_valor		   = this.ListaToArray (lista = arguments, variavel = "ACR_VALOR");
					v_cod_posto	   = this.ListaToArray (lista = arguments, variavel = "POSTO_COD_PESSOA_ACRESCIMOS");
					v_unitario	   = this.ListaToArray (lista = arguments, variavel = "POSTO_VALOR_UNITARIO_ACRESCIMOS");
					v_quantidade   = this.ListaToArray (lista = arguments, variavel = "POSTO_QUANTIDADE_ACRESCIMOS");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						v_item_contrato = this.ins_item_contrato(lancto_id	= retorno.lancto_id,
																 item_id	= v_item_id[count],
																 descricao	= v_descricao[count],
																 desconto	= v_desconto[count],
																 valor		= v_valor[count]);
					</cfscript>
					<cfif v_item_contrato.erro>
						<cfthrow object="#v_item_contrato.mensagem#">
					</cfif>
				</cfloop>
                
                <cfif arguments.tipo_carga eq 3>
                	<cfloop list="#arguments.carga_id_coleta#" index="v_id">
                    	<cfscript>
							ret = this.ins_contrato_transp_carga(lancto_id = retorno.lancto_id,
																 carga_id  = v_id,
																 tipo_operacao = 1);
						</cfscript>
                        <cfif ret.erro>
                        	<cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfloop>
                	<cfloop list="#arguments.carga_id_entrega#" index="v_id">
                    	<cfscript>
							ret = this.ins_contrato_transp_carga(lancto_id = retorno.lancto_id,
																 carga_id  = v_id,
																 tipo_operacao = 2);
						</cfscript>
                        <cfif ret.erro>
                        	<cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfloop>
                </cfif>
                
                <!---Diviso do CRT--->
                <cfset v_validar_divisao = 0 />
                
                <cfloop list="#arguments.DIVISAO_ID#" index="v_divisao_id">
					<cfscript>
                        conn = CreateComponent('_transportes.manipulacao.cfc_transp_internacional');
                        set_divisao = conn.embarque_divisao_contrato(lancto_id = retorno.lancto_id, divisao_id = v_divisao_id);
                    </cfscript>
                    
                    <cfif set_divisao.erro>
                    	<cfthrow object="#set_divisao.mensagem#">
                    </cfif>
                    
                    <cfset v_validar_divisao = 1 />
                </cfloop>
                
                <cfif v_validar_divisao eq 1>
                	<cfscript>
                        set_validar_divisao = conn.validar_divisao_contrato(lancto_id = retorno.lancto_id);
                    </cfscript>
                    <cfif set_validar_divisao.erro>
                    	<cfthrow object="#set_validar_divisao.mensagem#">
                    </cfif>
                </cfif>
                
				<cfif arguments.total_parcela gt 1>
                	<!--- Efetua o parcelamento da carta frete --->
                    <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_contrato_transp.prc_parcelar_contrato_transp" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_lancto_id" value="#retorno.lancto_id#" null="#iif(len(trim(retorno.lancto_id)),de('no'),de('yes'))#">
                        <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_total_parcelas" value="#arguments.total_parcela#" null="#iif(len(trim(arguments.total_parcela)),de('no'),de('yes'))#">
                    </cfstoredproc>
                    
                <cfelse>
					<!--- Recalcula os impostos sobre a carta frete --->
                    <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_contrato_transp.prc_recalcula_contrato_transp" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_lancto_id" value="#retorno.lancto_id#" null="#iif(len(trim(retorno.lancto_id)),de('no'),de('yes'))#">
                    </cfstoredproc>
                    
                    <!--- Insere no contas a pagar --->
                    <cfscript>
                        this.ins_contrato_transp_contas_pagar(lancto_id = retorno.lancto_id);
                    </cfscript>
				</cfif>
                
                <!---CTF--->
                <cfif arguments.CTF eq 1>
                    <cfscript>
                        conn_ct = CreateComponent("_transportes.manipulacao.cfc_contrato_transporte");
                        set_ctf = conn_ct.ins_contrato_ctf(lancto_id = retorno.LANCTO_ID);						
                    </cfscript>
                    
                    <cfif set_ctf.erro>
                        <cfthrow object="#set_ctf.mensagem#">
                    <cfelse>
                        <cfset retorno.mensagem_ctf = set_ctf.mensagem>                   
                    </cfif>      
                </cfif> 
                
                <!--- REPOM --->
                <cfif arguments.REPOM eq 1>
					<cfscript>
						conn = CreateComponent("_transportes.manipulacao.transporte.cfc_repom");
						ret_repom = conn.emitir_contrato(LANCTO_ID     = retorno.LANCTO_ID,
												 	     ROTA_ID       = arguments.ROTA_ID,
													     CARTAO_NUMERO = arguments.CARTAO_NUMERO);
					</cfscript>
					<cfif ret_repom.erro>
						<cfthrow object="#ret_repom.mensagem#">
                    <cfelse> 
                    	<cfset retorno.contrato_id = ret_repom.contrato_id>
					</cfif>                
                </cfif>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato de Transporte inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>