<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulao da rea de CONTA RESULTADO" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Insere um lanamento de debito na conta resultado
	-- CRISTOFER 20/02/2006
	--->
	<cffunction name="ins_debito_credito" access="remote" returntype="struct" output="true">
		<cfargument name="cod_pessoa" 		required="yes">
		<cfargument name="nome_funcionario" required="yes">
		<cfargument name="descricao" 		required="yes">
		<cfargument name="valor" 			required="yes">
		<cfargument name="multa" 			required="no">
		<cfargument name="deb_cred_pagto" 	required="no" default="1">
        <cfargument name="data_lancto"		required="no" default="#lsdateformat(now())# #lstimeformat(now())#">

		<cftry>
			<!---Se for lanamento de multa verifica o saldo da conta para fazer o lanamento--->
			<cfif IsDefined("arguments.multa")>
				<!---Seleciona em qual das modalidades de conta corrente deve ser lanado o dbito, conforme o limite estipulado no parametro--->
				<cfquery datasource="#session.dsn#" name="qr_ccorrente_modalidade" username="#session.usuario#" password="#session.senha#">
                   select modalidade_id
                     from (
					select case 
							 when oper.pkg_ccorrente.fnc_saldo_ccorrente_dia(cc.cod_conta, sysdate) > to_number(oper.pkg_global.FNC_GET_PARAMETRO(236,'LOGISTICA')) then 9
						   else 4 end modalidade_id
					  from oper.v$ccorrente cc 
					 where cc.cod_pessoa = #arguments.cod_pessoa#
                       and cc.ativo = 1 ) t
                    where t.modalidade_id = 9 
				</cfquery>
		    <cfelse>
				<cfset qr_ccorrente_modalidade.modalidade_id = 9 > 
			</cfif>
			<cfquery datasource="#session.dsn#" name="qr_ccorrente" username="#session.usuario#" password="#session.senha#">
				select /*+ORDERED */ cc.cod_conta  
				  from oper.v$ccorrente cc 
				 where cc.cod_pessoa = #arguments.cod_pessoa#
				   and cc.modalidade_id = #qr_ccorrente_modalidade.modalidade_id# 
				   and cc.ativo = 1
 			</cfquery>
			<cfif not qr_ccorrente.RecordCount>
				<cfthrow message="Impossvel fazer o lanamento, conta corrente no encontrada!"
						 detail="Impossvel fazer o lanamento, conta corrente no encontrada!">
			</cfif>
			<cfswitch expression="#arguments.deb_cred_pagto#">
				<cfcase value="0">
					<cfset cod_documento = 332>
					<cfset v_debito_credito = 1>
				</cfcase>
				<cfcase value="2">
					<cfset cod_documento = 373>
					<cfset v_debito_credito = 0>
				</cfcase>
				<cfdefaultcase>
					<cfset cod_documento = 93>
					<cfset v_debito_credito = 0>
				</cfdefaultcase>		
			</cfswitch>
			<cftransaction action='begin'>
            
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_ccorrente.prc_insere_lancto_ccorrente" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="inout"	dbvarname="p_num_lancamento" 	cfsqltype="cf_sql_integer" 	null="yes" variable="retorno.num_lancamento">
				<cfprocparam type="in" 		dbvarname="p_cod_conta" 		cfsqltype="cf_sql_integer" 	value="#qr_ccorrente.cod_conta#">
				<cfprocparam type="in" 		dbvarname="p_cod_pessoa_un" 	cfsqltype="cf_sql_integer" 	value="1">
				<cfprocparam type="in" 		dbvarname="p_cod_documento" 	cfsqltype="cf_sql_integer" 	value="#cod_documento#">
				<cfprocparam type="in" 		dbvarname="p_num_documento"		cfsqltype="cf_sql_integer" 	value="#LSDateFormat(arguments.data_lancto,'yyyy')##LSDateFormat(arguments.data_lancto,'mm')#">
				<cfprocparam type="in" 		dbvarname="p_data_lancamento" 	cfsqltype="cf_sql_varchar" 	value="#LSDateFormat(arguments.data_lancto,'dd/mm/yyyy')#">
				<cfprocparam type="in" 		dbvarname="p_data_vencto" 		cfsqltype="cf_sql_varchar" 	value="#LSDateFormat(arguments.data_lancto,'dd/mm/yyyy')#">
				<cfprocparam type="in" 		dbvarname="p_historico" 		cfsqltype="cf_sql_varchar" 	value="#arguments.descricao#">
				<cfprocparam type="in" 		dbvarname="p_valor_lancamento" 	cfsqltype="cf_sql_float" 	value="#arguments.valor#">
				<cfprocparam type="in" 		dbvarname="p_deb_cred" 			cfsqltype="cf_sql_integer" 	value="#v_debito_credito#">
				<cfprocparam type="in" 		dbvarname="p_favorecido" 		cfsqltype="cf_sql_varchar" 	value="#arguments.nome_funcionario#">
				<cfprocparam type="inout" 	dbvarname="p_rowid" 			cfsqltype="cf_sql_varchar" 	variable="retorno.rowid" null="yes">
			</cfstoredproc>
            
            	
            

                <!---Atualiza Lanamento_Id do auto de infrao e Insere Histrico Pessoal--->
                <cfif IsDefined("arguments.multa") and arguments.multa eq 1>
                    
                    <cfscript>
					
                        funcionario = CreateComponent("_transportes.manipulacao.cfc_funcionario");
                        ret = funcionario.prc_ins_historico_pessoal(COD_TIPO_HISTORICO	= 36,
                                                                    COD_FUNCIONARIO		= arguments.cod_funcionario,
                                                                    DATA_HISTORICO		= arguments.data_hora,
                                                                    DESCRICAO			= arguments.descricao,
                                                                    LANCTO_ID			= retorno.num_lancamento);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>
                
                <!---Insere parcelamento--->
                <cfif IsDefined("arguments.multa") and arguments.multa eq 1>
                    <cfif IsDefined("arguments.multa_valor") and arguments.multa_valor neq ''>
                        <cfscript>
                            ret = this.prc_ins_parcelamento(PARCELAMENTO_ID		= '',
                                                            FUNCIONARIO_ID		= arguments.cod_funcionario,
                                                            MES					= arguments.mes,
                                                            ANO					= arguments.ano_atual,
                                                            TIPO_RECIBO_ID		= 1,
                                                            EVENTO_ID			= arguments.cod_evento,
                                                            VALOR				= arguments.multa_valor,
                                                            QTDE_PARCELAS		= arguments.qtde_parcelas,
                                                            INICIAR_EM			= 1,
                                                            COMPLEMENTO_EVENTO	= arguments.placa & ' ' & arguments.data_hora,
                                                            OBSERVACAO			= 'Parcelamento de Auto de Infrao',
                                                            LANCTO_ID			= retorno.num_lancamento);
                        </cfscript>
                        <cfif ret.erro>
                            <cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfif>
                </cfif>
			</cftransaction>
            
			<cfset retorno.erro = false>		
			<cfset retorno.mensagem = 'Lanamento feito com sucesso!'>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
    
    
    
    <!--- 
	-- PROPSITO
	-- Insere um lanamento de debito na conta resultado
	-- CRISTOFER 20/02/2006
	--->
	<cffunction name="ins_debito_credito_auto_infracao" access="remote" returntype="struct" output="true">
		<cfargument name="cod_pessoa" 		required="yes">
		<cfargument name="nome_funcionario" required="yes">
		<cfargument name="descricao" 		required="yes">
		<cfargument name="valor" 			required="yes">
		<cfargument name="multa" 			required="no">
		<cfargument name="deb_cred_pagto" 	required="no" default="1">
        <cfargument name="data_lancto"		required="no" default="#lsdateformat(now())# #lstimeformat(now())#">
		<cftry>
			<!---Se for lanamento de multa verifica o saldo da conta para fazer o lanamento--->
			<cfif IsDefined("arguments.multa")>
				<!---Seleciona em qual das modalidades de conta corrente deve ser lanado o dbito, conforme o limite estipulado no parametro--->
				<cfquery datasource="#session.dsn#" name="qr_ccorrente_modalidade" username="#session.usuario#" password="#session.senha#">
                   select modalidade_id
                     from (
					select case 
							 when oper.pkg_ccorrente.fnc_saldo_ccorrente_dia(cc.cod_conta, sysdate) > to_number(oper.pkg_global.FNC_GET_PARAMETRO(236,'LOGISTICA')) then 9
						   else 4 end modalidade_id
					  from oper.v$ccorrente cc 
					 where cc.cod_pessoa = #arguments.cod_pessoa#
                       and cc.ativo = 1 ) t
                    where t.modalidade_id = 9 
				</cfquery>
		    <cfelse>
				<cfset qr_ccorrente_modalidade.modalidade_id = 9 > 
			</cfif>
			<cfquery datasource="#session.dsn#" name="qr_ccorrente" username="#session.usuario#" password="#session.senha#">
				select /*+ORDERED */ cc.cod_conta  
				  from oper.v$ccorrente cc 
				 where cc.cod_pessoa = #arguments.cod_pessoa#
				   and cc.modalidade_id = #qr_ccorrente_modalidade.modalidade_id# 
				   and cc.ativo = 1
 			</cfquery>
			<cfif not qr_ccorrente.RecordCount>
				<cfthrow message="Impossvel fazer o lanamento, conta corrente no encontrada!"
						 detail="Impossvel fazer o lanamento, conta corrente no encontrada!">
			</cfif>
			<cfswitch expression="#arguments.deb_cred_pagto#">
				<cfcase value="0">
					<cfset cod_documento = 332>
					<cfset v_debito_credito = 1>
				</cfcase>
				<cfcase value="2">
					<cfset cod_documento = 373>
					<cfset v_debito_credito = 0>
				</cfcase>
				<cfdefaultcase>
					<cfset cod_documento = 93>
					<cfset v_debito_credito = 0>
				</cfdefaultcase>		
			</cfswitch>

			<!--- Se o funcionario est demitido ento no gera o lanamento na conta resultado, 
				  parcelamento, histrico e no atualiza o auto de infrao para o lanamento gerado --->
            <cfif not arguments.func_demitido >
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_ccorrente.prc_insere_lancto_ccorrente" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="inout"	dbvarname="p_num_lancamento" 	cfsqltype="cf_sql_integer" 	null="yes" variable="retorno.num_lancamento">
                    <cfprocparam type="in" 		dbvarname="p_cod_conta" 		cfsqltype="cf_sql_integer" 	value="#qr_ccorrente.cod_conta#">
                    <cfprocparam type="in" 		dbvarname="p_cod_pessoa_un" 	cfsqltype="cf_sql_integer" 	value="1">
                    <cfprocparam type="in" 		dbvarname="p_cod_documento" 	cfsqltype="cf_sql_integer" 	value="#cod_documento#">
                    <cfprocparam type="in" 		dbvarname="p_num_documento"		cfsqltype="cf_sql_integer" 	value="#LSDateFormat(arguments.data_lancto,'yyyy')##LSDateFormat(arguments.data_lancto,'mm')#">
                    <cfprocparam type="in" 		dbvarname="p_data_lancamento" 	cfsqltype="cf_sql_varchar" 	value="#LSDateFormat(arguments.data_lancto,'dd/mm/yyyy')#">
                    <cfprocparam type="in" 		dbvarname="p_data_vencto" 		cfsqltype="cf_sql_varchar" 	value="#LSDateFormat(arguments.data_lancto,'dd/mm/yyyy')#">
                    <cfprocparam type="in" 		dbvarname="p_historico" 		cfsqltype="cf_sql_varchar" 	value="#arguments.descricao#">
                    <cfprocparam type="in" 		dbvarname="p_valor_lancamento" 	cfsqltype="cf_sql_float" 	value="#arguments.valor#">
                    <cfprocparam type="in" 		dbvarname="p_deb_cred" 			cfsqltype="cf_sql_integer" 	value="#v_debito_credito#">
                    <cfprocparam type="in" 		dbvarname="p_favorecido" 		cfsqltype="cf_sql_varchar" 	value="#arguments.nome_funcionario#">
                    <cfprocparam type="inout" 	dbvarname="p_rowid" 			cfsqltype="cf_sql_varchar" 	variable="retorno.rowid" null="yes">
                </cfstoredproc>
            

                <!---Atualiza Lanamento_Id do auto de infrao e Insere Histrico Pessoal--->
                <cfif IsDefined("arguments.multa") and arguments.multa eq 1>
					<cfscript>
						connGerContas = CreateComponent("_transportes.manipulacao.transporte.cfc_gerenciamento_multas");
						ret1 = connGerContas.upd_auto_infracao_lancto(  auto_infracao_id = arguments.auto_infracao_id,
																		lancamento_id	 = retorno.num_lancamento );
					</cfscript>
                    
                    <cfif ret1.erro>
                    	<cfthrow object="#ret.mensagem#">
                    </cfif>
                    
                    <cfscript>
					
                        funcionario = CreateComponent("_transportes.manipulacao.cfc_funcionario");
                        ret = funcionario.prc_ins_historico_pessoal(COD_TIPO_HISTORICO	= 36,
                                                                    COD_FUNCIONARIO		= arguments.cod_funcionario,
                                                                    DATA_HISTORICO		= arguments.data_hora,
                                                                    DESCRICAO			= arguments.descricao,
                                                                    LANCTO_ID			= retorno.num_lancamento);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>
                
                <!---Insere parcelamento--->
                <cfif IsDefined("arguments.multa") and arguments.multa eq 1>
                    <cfif IsDefined("arguments.multa_valor") and arguments.multa_valor neq ''>
                        <cfscript>
                            ret = this.prc_ins_parcelamento(PARCELAMENTO_ID		= '',
                                                            FUNCIONARIO_ID		= arguments.cod_funcionario,
                                                            MES					= arguments.mes,
                                                            ANO					= arguments.ano_atual,
                                                            TIPO_RECIBO_ID		= 1,
                                                            EVENTO_ID			= arguments.cod_evento,
                                                            VALOR				= arguments.multa_valor,
                                                            QTDE_PARCELAS		= arguments.qtde_parcelas,
                                                            INICIAR_EM			= 1,
                                                            COMPLEMENTO_EVENTO	= arguments.placa & ' ' & arguments.data_hora,
                                                            OBSERVACAO			= 'Parcelamento do Auto de Infrao ' & arguments.cod_auto_infracao,
                                                            LANCTO_ID			= retorno.num_lancamento);
                        </cfscript>
                        <cfif ret.erro>
                            <cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfif>
                </cfif>
                			
            </cfif>
            
			<cfset retorno.erro = false>		
			<cfset retorno.mensagem = 'Lanamento feito com sucesso!'>
			<cfcatch>
				
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
    
    
    
    
    <!--- 
	-- PROPSITO
	-- Atualiza o lanamento da conta corrente
	-- WAGNERS 14/02/2011 16:44:50 - CRIADO
	--->
	<cffunction name='upd_debito_credito' displayname='Atualiza o lanamento da conta corrente' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_LANCAMENTO' required='yes'>
        <cfargument name="cod_pessoa" 		required="yes">
		<cfargument name="nome_funcionario" required="yes">
		<cfargument name="descricao" 		required="yes">
		<cfargument name="valor" 			required="yes">
		<cfargument name="multa" 			required="no">
		<cfargument name="deb_cred_pagto" 	required="no" default="1">
        <cfargument name="data_lancto"		required="no" default="#lsdateformat(now())# #lstimeformat(now())#">
		<cftry>
        	<!---Se for lanamento de multa verifica o saldo da conta para fazer o lanamento--->
			<cfif IsDefined("arguments.multa")>
				<!---Seleciona em qual das modalidades de conta corrente deve ser lanado o dbito, conforme o limite estipulado no parametro--->
				<cfquery datasource="#session.dsn#" name="qr_ccorrente_modalidade" username="#session.usuario#" password="#session.senha#">
					select case 
							 when oper.pkg_ccorrente.fnc_saldo_ccorrente_dia(cc.cod_conta, sysdate) > to_number(oper.pkg_global.FNC_GET_PARAMETRO(236,'LOGISTICA')) then 9
						   else 4 end modalidade_id
					  from oper.v$ccorrente cc 
					 where cc.cod_pessoa = #arguments.cod_pessoa#
					   and cc.modalidade_id = 9 
					   and cc.ativo = 1 
				</cfquery>
		    <cfelse>
				<cfset qr_ccorrente_modalidade.modalidade_id = 9 > 
			</cfif>
			<cfquery datasource="#session.dsn#" name="qr_ccorrente" username="#session.usuario#" password="#session.senha#">
				select /*+ORDERED */ cc.cod_conta  
				  from oper.v$ccorrente cc 
				 where cc.cod_pessoa = #arguments.cod_pessoa#
				   and cc.modalidade_id = #qr_ccorrente_modalidade.modalidade_id# 
				   and cc.ativo = 1
 			</cfquery>
			<cfif not qr_ccorrente.RecordCount>
				<cfthrow message="Impossvel fazer o lanamento, conta corrente no encontrada!"
						 detail="Impossvel fazer o lanamento, conta corrente no encontrada!">
			</cfif>
			<cfswitch expression="#arguments.deb_cred_pagto#">
				<cfcase value="0">
					<cfset cod_documento = 332>
					<cfset v_debito_credito = 1>
				</cfcase>
				<cfcase value="2">
					<cfset cod_documento = 373>
					<cfset v_debito_credito = 0>
				</cfcase>
				<cfdefaultcase>
					<cfset cod_documento = 93>
					<cfset v_debito_credito = 0>
				</cfdefaultcase>		
			</cfswitch>
        
        	<!--- Se o funcionario est demitido ento no gera o lanamento na conta resultado, 
				  parcelamento, histrico e no atualiza o auto de infrao para o lanamento gerado --->
            <cfif not arguments.func_demitido >

				<cfstoredproc procedure='finan.pkg_ccorrente.prc_atualiza_lancto_ccorrente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_LANCAMENTO'  	value='#arguments.NUM_LANCAMENTO#'  null='#iif(len(trim(arguments.NUM_LANCAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONTA'  	  	value='#qr_ccorrente.cod_conta#'  >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_UN'   	value='1' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DOCUMENTO'   	value='#cod_documento#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_DOCUMENTO'  			  	value="#LSDateFormat(arguments.data_lancto,'yyyy')##LSDateFormat(arguments.data_lancto,'mm')#" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  		  	value="#LSDateFormat(arguments.data_lancto,'dd/mm/yyyy')#" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCTO'  			  	value="#LSDateFormat(arguments.data_lancto,'dd/mm/yyyy')#" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_HISTORICO'  				  	value='#arguments.descricao#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_LANCAMENTO'  value='#arguments.valor#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEB_CRED'  		value='#v_debito_credito#'  >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FAVORECIDO'  				value='#arguments.nome_funcionario#' >
				</cfstoredproc>
                
                
                <cfif IsDefined("arguments.multa") and arguments.multa eq 1>
                    <cfif IsDefined("arguments.multa_valor") and arguments.multa_valor neq ''>
                        <cfscript>
                            ret = this.upd_parcelamento(PARCELAMENTO_ID		= arguments.parcelamento_id,
														FUNCIONARIO_ID		= arguments.cod_funcionario,
														MES					= arguments.mes,
														ANO					= arguments.ano_atual,
														TIPO_RECIBO_ID		= 1,
														EVENTO_ID			= arguments.cod_evento,
														VALOR				= arguments.multa_valor,
														QTDE_PARCELAS		= arguments.qtde_parcelas,
														INICIAR_EM			= 1,
														COMPLEMENTO_EVENTO	= arguments.placa & ' ' & arguments.data_hora,
														OBSERVACAO			= 'Parcelamento do Auto de Infrao ' & arguments.cod_auto_infracao,
														LANCTO_ID			= arguments.num_lancamento
														);
                        </cfscript>
                        <cfif ret.erro>
                            <cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfif>
                </cfif>
                
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lanamento alterado com sucesso!')>

			</cfif>
            
			<cfcatch>

				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
	
	<!--- 
	-- PROPSITO
	-- Exclui um lanamento de debito
	-- CRISTOFER 20/02/2006
	--->
	<cffunction name="del_lancamento" displayname="Apaga lanamento de despesas avulsas" access="remote" returntype="struct" output="true">
		<cfargument name="num_lancamento" displayname="Nmero do lanamento"  required="true">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_ccorrente.prc_excluir_lancto_ccorrente" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_num_lancamento" cfsqltype="cf_sql_integer" value="#arguments.num_lancamento#">
			</cfstoredproc>
			<cfset retorno.erro = false>		
			<cfset retorno.mensagem = 'Lanamento excluido com sucesso!'>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>	
    
    <!--- 
	-- PROPSITO
	-- Gerar Parcelamentos
	-- RAFAEL 02/03/2010 13:48:50 - CRIADO
	--->
	<cffunction name='prc_ins_parcelamento' displayname='Gerar Parcelamentos' access='remote' returntype='Struct' output='true'>
		<cfargument name='PARCELAMENTO_ID' required='no'>
		<cfargument name='FUNCIONARIO_ID' required='yes'>
		<cfargument name='MES' required='yes'>
		<cfargument name='ANO' required='yes'>
		<cfargument name='TIPO_RECIBO_ID' required='yes'>
		<cfargument name='EVENTO_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='QTDE_PARCELAS' required='yes'>
		<cfargument name='INICIAR_EM' required='yes'>
		<cfargument name='COMPLEMENTO_EVENTO' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='LANCTO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='rh.pkg_parcelamento.prc_ins_parcelamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PARCELAMENTO_ID'  value='#arguments.PARCELAMENTO_ID#' variable='retorno.PARCELAMENTO_ID'  null='#iif(len(trim(arguments.PARCELAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FUNCIONARIO_ID'  value='#arguments.FUNCIONARIO_ID#'  null='#iif(len(trim(arguments.FUNCIONARIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MES'  value='#arguments.MES#'  null='#iif(len(trim(arguments.MES)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANO'  value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_RECIBO_ID'  value='#arguments.TIPO_RECIBO_ID#'  null='#iif(len(trim(arguments.TIPO_RECIBO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EVENTO_ID'  value='#arguments.EVENTO_ID#'  null='#iif(len(trim(arguments.EVENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_PARCELAS'  value='#arguments.QTDE_PARCELAS#'  null='#iif(len(trim(arguments.QTDE_PARCELAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INICIAR_EM'  value='#arguments.INICIAR_EM#'  null='#iif(len(trim(arguments.INICIAR_EM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO_EVENTO'  value='#arguments.COMPLEMENTO_EVENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Atualiza o parcelamento do lanamento
	-- WAGNERS 14/02/2011 16:52:30 - CRIADO
	--->
	<cffunction name='upd_parcelamento' displayname='Atualiza o parcelamento do lanamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='PARCELAMENTO_ID' required='yes'>
		<cfargument name='FUNCIONARIO_ID' required='yes'>
		<cfargument name='MES' required='yes'>
		<cfargument name='ANO' required='yes'>
		<cfargument name='TIPO_RECIBO_ID' required='yes'>
		<cfargument name='EVENTO_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='QTDE_PARCELAS' required='yes'>
		<cfargument name='INICIAR_EM' required='yes'>
		<cfargument name='COMPLEMENTO_EVENTO' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cftry>

				<cfstoredproc procedure='rh.pkg_parcelamento.prc_alt_parcelamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PARCELAMENTO_ID'  value='#arguments.PARCELAMENTO_ID#'  null='#iif(len(trim(arguments.PARCELAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FUNCIONARIO_ID'  value='#arguments.FUNCIONARIO_ID#'  null='#iif(len(trim(arguments.FUNCIONARIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MES'  value='#arguments.MES#'  null='#iif(len(trim(arguments.MES)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANO'  value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_RECIBO_ID'  value='#arguments.TIPO_RECIBO_ID#'  null='#iif(len(trim(arguments.TIPO_RECIBO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EVENTO_ID'  value='#arguments.EVENTO_ID#'  null='#iif(len(trim(arguments.EVENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_PARCELAS'  value='#arguments.QTDE_PARCELAS#'  null='#iif(len(trim(arguments.QTDE_PARCELAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INICIAR_EM'  value='#arguments.INICIAR_EM#'  null='#iif(len(trim(arguments.INICIAR_EM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO_EVENTO'  value='#arguments.COMPLEMENTO_EVENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Parcelamento alterado com sucesso!')>

			<cfcatch>

				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    
</cfcomponent>