<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulao da rea de pneus" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Exclui uma janela de carga no cliente
	-- CRISTOFER 06/03/2006
	--->
	<cffunction name="del_janela_carga" returntype="struct" access="remote">
		<cfargument name="cod_pessoa_carga" required="yes">
		<cfargument name="dia_semana" required="yes">
		<cfargument name="hora_inicio" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_logistica.prc_del_janela_carga" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_carga" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_carga#">
				<cfprocparam type="in" dbvarname="p_dia_semana" cfsqltype="cf_sql_varchar" value="#arguments.dia_semana#">
				<cfprocparam type="in" dbvarname="p_hora_inicio" cfsqltype="cf_sql_varchar" value="#arguments.hora_inicio#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Janela de carga exclu"&Chr(237)&"da com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui uma janela de descarga no cliente
	-- CRISTOFER 09/03/2006
	--->
	<cffunction name="del_janela_carga_por_data" returntype="struct" access="remote">
		<cfargument name="cod_pessoa_carga" required="yes">
		<cfargument name="data_hora_inicio" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_logistica.prc_del_data_carga" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_carga" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_carga#">
				<cfprocparam type="in" dbvarname="p_data_hora_inicio" cfsqltype="cf_sql_varchar" value="#arguments.data_hora_inicio#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Janela de carga exclu"&Chr(237)&"da com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui uma janela de descarga no cliente
	-- CRISTOFER 09/03/2006
	--->
	<cffunction name="del_janela_descarga" returntype="struct" access="remote">
		<cfargument name="cod_pessoa_descarga" required="yes">
		<cfargument name="dia_semana" required="yes">
		<cfargument name="hora_inicio" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_logistica.prc_del_janela_descarga" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_descarga" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_descarga#">
				<cfprocparam type="in" dbvarname="p_dia_semana" cfsqltype="cf_sql_varchar" value="#arguments.dia_semana#">
				<cfprocparam type="in" dbvarname="p_hora_inicio" cfsqltype="cf_sql_varchar" value="#arguments.hora_inicio#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Janela de descarga exclu"&Chr(237)&"da com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui uma janela de descarga no cliente por data
	-- CRISTOFER 09/03/2006
	--->
	<cffunction name="del_janela_descarga_por_data" returntype="struct" access="remote">
		<cfargument name="cod_pessoa_descarga" required="yes">
		<cfargument name="data_hora_inicio" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_logistica.prc_del_data_descarga" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_descarga" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_descarga#">
				<cfprocparam type="in" dbvarname="p_data_hora_inicio" cfsqltype="cf_sql_varchar" value="#arguments.data_hora_inicio#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Janela de descarga exclu"&Chr(237)&"da com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>			

	<!--- 
	-- PROPSITO
	-- Insere uma janela de carga no cliente
	-- CRISTOFER 06/03/2006
	--->
	<cffunction name="ins_janela_carga" returntype="struct" access="remote">
		<cfargument name="cod_pessoa_carga" required="yes">
		<cfargument name="dia_semana" required="yes">
		<cfargument name="hora_inicio" required="yes">
		<cfargument name="hora_fim" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_logistica.prc_ins_janela_carga" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_carga" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_carga#">
				<cfprocparam type="in" dbvarname="p_dia_semana" cfsqltype="cf_sql_varchar" value="#arguments.dia_semana#">
				<cfprocparam type="in" dbvarname="p_hora_inicio" cfsqltype="cf_sql_varchar" value="#arguments.hora_inicio#">
				<cfprocparam type="in" dbvarname="p_hora_fim" cfsqltype="cf_sql_varchar" value="#arguments.hora_fim#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Janela de carga cadastrada com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>		
	
	<!--- 
	-- PROPSITO
	-- Insere uma janela de carga por data no cliente
	-- CRISTOFER 09/03/2006
	--->
	<cffunction name="ins_janela_carga_por_data" returntype="struct" access="remote">
		<cfargument name="cod_pessoa_carga" required="yes">
		<cfargument name="data_operando" required="yes">
		<cfargument name="hora_inicio" required="yes">
		<cfargument name="hora_fim" required="yes">
		<cfargument name="operando" required="no" default="0">
		<cftry>
			<cfif arguments.operando eq 0>
				<cfset arguments.hora_inicio = '00:00'>
				<cfset arguments.hora_fim = '00:00'>
			</cfif>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_logistica.prc_ins_data_carga" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_carga" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_carga#">
				<cfprocparam type="in" dbvarname="p_data_hora_inicio" cfsqltype="cf_sql_varchar" value="#arguments.data_operando# #arguments.hora_inicio#:00">
				<cfprocparam type="in" dbvarname="p_data_hora_fim" cfsqltype="cf_sql_varchar" value="#arguments.data_operando# #arguments.hora_fim#:00">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Janela de carga cadastrada com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>			
		
	<!--- 
	-- PROPSITO
	-- Insere uma janela de descarga no cliente
	-- CRISTOFER 09/03/2006
	--->
	<cffunction name="ins_janela_descarga" returntype="struct" access="remote">
		<cfargument name="cod_pessoa_descarga" required="yes">
		<cfargument name="dia_semana" required="yes">
		<cfargument name="hora_inicio" required="yes">
		<cfargument name="hora_fim" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_logistica.prc_ins_janela_descarga" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_descarga" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_descarga#">
				<cfprocparam type="in" dbvarname="p_dia_semana" cfsqltype="cf_sql_varchar" value="#arguments.dia_semana#">
				<cfprocparam type="in" dbvarname="p_hora_inicio" cfsqltype="cf_sql_varchar" value="#arguments.hora_inicio#">
				<cfprocparam type="in" dbvarname="p_hora_fim" cfsqltype="cf_sql_varchar" value="#arguments.hora_fim#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Janela de descarga cadastrada com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere uma janela de descarga no cliente por data
	-- CRISTOFER 09/03/2006
	--->	
	<cffunction name="ins_janela_descarga_por_data" returntype="struct" access="remote">
		<cfargument name="cod_pessoa_descarga" required="yes">
		<cfargument name="data_operando" required="yes">
		<cfargument name="hora_inicio" required="yes">
		<cfargument name="hora_fim" required="yes">
		<cfargument name="operando" required="no" default="0">
		<cftry>
			<cfif arguments.operando eq 0>
				<cfset arguments.hora_inicio = '00:00'>
				<cfset arguments.hora_fim = '00:00'>
			</cfif>		
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_logistica.prc_ins_data_descarga" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_descarga" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_descarga#">
				<cfprocparam type="in" dbvarname="p_data_hora_inicio" cfsqltype="cf_sql_varchar" value="#arguments.data_operando# #arguments.hora_inicio#:00">
				<cfprocparam type="in" dbvarname="p_data_hora_fim" cfsqltype="cf_sql_varchar" value="#arguments.data_operando# #arguments.hora_fim#:00">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Janela de descarga cadastrada com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>			
</cfcomponent>