<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Insere um lancamento na conta corrente
    -- cristofer 22/12/2008 17:44:05 - CRIADO
    --->
    <cffunction name='ins_lancto_ccorrente' displayname='Insere um lancamento na conta corrente' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_LANCAMENTO' required='yes'>
        <cfargument name='COD_CONTA' required='yes'>
        <cfargument name='COD_PESSOA_UN' required='yes'>
        <cfargument name='COD_DOCUMENTO' required='yes'>
        <cfargument name='NUM_DOCUMENTO' required='yes'>
        <cfargument name='DATA_LANCAMENTO' required='yes'>
        <cfargument name='DATA_VENCTO' required='yes'>
        <cfargument name='HISTORICO' required='yes'>
        <cfargument name='VALOR_LANCAMENTO' required='yes'>
        <cfargument name='DEB_CRED' required='yes'>
        <cfargument name='FAVORECIDO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='finan.pkg_ccorrente.prc_insere_lancto_ccorrente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_LANCAMENTO'  value='#arguments.NUM_LANCAMENTO#' variable='retorno.NUM_LANCAMENTO'  null='#iif(len(trim(arguments.NUM_LANCAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONTA'  value='#arguments.COD_CONTA#'  null='#iif(len(trim(arguments.COD_CONTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_UN'  value='#arguments.COD_PESSOA_UN#'  null='#iif(len(trim(arguments.COD_PESSOA_UN)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DOCUMENTO'  value='#arguments.COD_DOCUMENTO#'  null='#iif(len(trim(arguments.COD_DOCUMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_DOCUMENTO'  value='#arguments.NUM_DOCUMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCTO'  value='#arguments.DATA_VENCTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_HISTORICO'  value='#arguments.HISTORICO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_LANCAMENTO'  value='#arguments.VALOR_LANCAMENTO#'  null='#iif(len(trim(arguments.VALOR_LANCAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEB_CRED'  value='#arguments.DEB_CRED#'  null='#iif(len(trim(arguments.DEB_CRED)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FAVORECIDO'  value='#arguments.FAVORECIDO#' >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID'  value='' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Lanamento n '&retorno.num_lancamento&' efetuado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Altera um lancamento na conta corrente
    -- cristofer 22/12/2008 17:44:05 - CRIADO
    --->
    <cffunction name='upd_lancto_ccorrente' displayname='Insere um lancamento na conta corrente' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_LANCAMENTO' required='yes'>
        <cfargument name='COD_CONTA' required='yes'>
        <cfargument name='COD_PESSOA_UN' required='yes'>
        <cfargument name='COD_DOCUMENTO' required='yes'>
        <cfargument name='NUM_DOCUMENTO' required='yes'>
        <cfargument name='DATA_LANCAMENTO' required='yes'>
        <cfargument name='DATA_VENCTO' required='yes'>
        <cfargument name='HISTORICO' required='yes'>
        <cfargument name='VALOR_LANCAMENTO' required='yes'>
        <cfargument name='DEB_CRED' required='yes'>
        <cfargument name='FAVORECIDO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='finan.pkg_ccorrente.prc_atualiza_lancto_ccorrente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_LANCAMENTO'  value='#arguments.NUM_LANCAMENTO#' null='#iif(len(trim(arguments.NUM_LANCAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONTA'  value='#arguments.COD_CONTA#'  null='#iif(len(trim(arguments.COD_CONTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_UN'  value='#arguments.COD_PESSOA_UN#'  null='#iif(len(trim(arguments.COD_PESSOA_UN)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DOCUMENTO'  value='#arguments.COD_DOCUMENTO#'  null='#iif(len(trim(arguments.COD_DOCUMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_DOCUMENTO'  value='#arguments.NUM_DOCUMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCTO'  value='#arguments.DATA_VENCTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_HISTORICO'  value='#arguments.HISTORICO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_LANCAMENTO'  value='#arguments.VALOR_LANCAMENTO#'  null='#iif(len(trim(arguments.VALOR_LANCAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEB_CRED'  value='#arguments.DEB_CRED#'  null='#iif(len(trim(arguments.DEB_CRED)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FAVORECIDO'  value='#arguments.FAVORECIDO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Lanamento n '&arguments.num_lancamento&' alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Exclui um lancamento na conta corrente
    -- cristofer 22/12/2008 17:44:05 - CRIADO
    --->
    <cffunction name='del_lancto_ccorrente' displayname='Exclui um lancamento na conta corrente' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_LANCAMENTO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='finan.pkg_ccorrente.prc_excluir_lancto_ccorrente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_LANCAMENTO'  value='#arguments.NUM_LANCAMENTO#' null='#iif(len(trim(arguments.NUM_LANCAMENTO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Lanamento excluido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
</cfcomponent>