<cfcomponent displayname="Controle e manipulao de caixas INTERNACIONAIS" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Insere lanamento no caixa
	-- guto 25/06/2007 15:14:57 - CRIADO
	--->
	<cffunction name='ins_lancamento_caixa' displayname='Insere lanamento no caixa' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_LANCAMENTO' required='yes'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='COD_HISTORICO_ARG' required='yes'>
		<cfargument name='COMPLEMENTO' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='RECEITA' required='yes'>
		<cfargument name='LANCAMENTO_ID_VINCULO' required='no' default="">
		<cfargument name='PAGAMENTO_ID' required='no' default="">
		<cfargument name='COD_PESSOA_FORNECEDOR' required='yes'>
		<cfargument name='VALOR_NETO' required='yes'>
		<cfargument name='VALOR_IVA' required='yes'>
		<cfargument name='VALOR_NO_GRAVADO' required='yes'>
		<cfargument name='VALOR_EXENTOS' required='yes'>
		<cfargument name='VALOR_RET_IR' required='yes'>
		<cfargument name='DATA_COMPROVANTE' required='yes'>
        <cfargument name='COD_COMPROVANTE' required='yes'>
        <cfargument name='PRECEP_IVA' required='yes'>
        <cfargument name='JURISDICAO_IB' required='yes'>
        <cfargument name='COD_TIPO_COMPROVANTE' required='yes'>
        <cfargument name='TIPO_FORMULARIO' required='yes'>
        <cfargument name='AGRUPAMENTO_ID' required='no' default="">
        <cfargument name='DOCTO_PAGAMENTO' required='no' default="">
        <cfargument name='VALOR_TOTAL' required='yes'>
        <cftry>
				<cfstoredproc procedure='finan.pkg_cxa_intc.prc_ins_caixa_lancamento_arg' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_COMPROVANTE'  value='#arguments.COD_COMPROVANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_HISTORICO_ARG'  value='#arguments.COD_HISTORICO_ARG#'  null='#iif(len(trim(arguments.COD_HISTORICO_ARG)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECEITA'  value='#arguments.RECEITA#'  null='#iif(len(trim(arguments.RECEITA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCAMENTO_ID_VINCULO'  value='#arguments.LANCAMENTO_ID_VINCULO#'  null='#iif(len(trim(arguments.LANCAMENTO_ID_VINCULO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FORNECEDOR'  value='#arguments.COD_PESSOA_FORNECEDOR#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_COMPROVANTE'  value='#arguments.DATA_COMPROVANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRECEP_IVA'  value='#arguments.PRECEP_IVA#'  null='#iif(len(trim(arguments.PRECEP_IVA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_JURISDICAO_IB'  value='#arguments.JURISDICAO_IB#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_TIPO_COMPROVANTE'  value='#arguments.COD_TIPO_COMPROVANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_FORMULARIO'  value='#arguments.TIPO_FORMULARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_NETO'  value='#arguments.VALOR_NETO#'  null='#iif(len(trim(arguments.VALOR_NETO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_IVA'  value='#arguments.VALOR_IVA#'  null='#iif(len(trim(arguments.VALOR_IVA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_NO_GRAVADO'  value='#arguments.VALOR_NO_GRAVADO#'  null='#iif(len(trim(arguments.VALOR_NO_GRAVADO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_EXENTOS'  value='#arguments.VALOR_EXENTOS#'  null='#iif(len(trim(arguments.VALOR_EXENTOS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_RET_IR'  value='#arguments.VALOR_RET_IR#'  null='#iif(len(trim(arguments.VALOR_RET_IR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCAMENTO_ID' variable='retorno.LANCAMENTO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AGRUPAMENTO_ID'  value='#arguments.AGRUPAMENTO_ID#'  null='#iif(len(trim(arguments.AGRUPAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PAGAMENTO_iD'  value='#arguments.PAGAMENTO_iD#'  null='#iif(len(trim(arguments.PAGAMENTO_iD)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DOCTO_PAGAMENTO'  value='#arguments.DOCTO_PAGAMENTO#'  null='#iif(len(trim(arguments.DOCTO_PAGAMENTO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lanamento (' & retorno.LANCAMENTO_ID & ') inserido com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui lanamento no caixa
	-- guto 25/06/2007 15:16:22 - CRIADO
	--->
	<cffunction name='del_lancamento_caixa' displayname='Exclui lanamento no caixa' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCAMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_cxa_intc.prc_del_caixa_lancamento_arg' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCAMENTO_ID'  value='#arguments.LANCAMENTO_ID#'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lanamento excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere novo histrico de caixa para argentina
	-- guto 27/06/2007 14:57:47 - CRIADO
	--->
	<cffunction name='ins_caixa_historico_arg' displayname='Insere novo histrico de caixa para argentina' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_HISTORICO_ARG' required='yes'>
		<cfargument name='COD_HISTORICO_BR' required='yes'>
		<cfargument name='HISTORICO_ARG' required='yes'>
		<cfargument name='COD_CONTABIL_ARG' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_cxa_intc.prc_ins_caixa_historico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_HISTORICO_ARG'  value='#arguments.COD_HISTORICO_ARG#' variable='retorno.COD_HISTORICO_ARG'  null='#iif(len(trim(arguments.COD_HISTORICO_ARG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_HISTORICO'  value='#arguments.COD_HISTORICO_BR#'  null='#iif(len(trim(arguments.COD_HISTORICO_BR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_HISTORICO_ARG'  value='#arguments.HISTORICO_ARG#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_CONTABIL_ARG'  value='#arguments.COD_CONTABIL_ARG#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Histrico ('& Round(retorno.COD_HISTORICO_ARG) &') inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera histrico de caixa para argentina
	-- guto 27/06/2007 14:58:39 - CRIADO
	--->
	<cffunction name='upd_caixa_historico_arg' displayname='Altera histrico de caixa para argentina' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_HISTORICO_ARG' required='yes'>
		<cfargument name='COD_HISTORICO_BR' required='yes'>
		<cfargument name='HISTORICO_ARG' required='yes'>
		<cfargument name='COD_CONTABIL_ARG' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_cxa_intc.prc_alt_caixa_historico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_HISTORICO_ARG'  value='#arguments.COD_HISTORICO_ARG#'  null='#iif(len(trim(arguments.COD_HISTORICO_ARG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_HISTORICO'  value='#arguments.COD_HISTORICO_BR#'  null='#iif(len(trim(arguments.COD_HISTORICO_BR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_HISTORICO_ARG'  value='#arguments.HISTORICO_ARG#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_CONTABIL_ARG'  value='#arguments.COD_CONTABIL_ARG#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Histrico alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui histrico de caixa para argentina
	-- guto 27/06/2007 14:59:22 - CRIADO
	--->
	<cffunction name='del_caixa_historico_arg' displayname='Exclui histrico de caixa para argentina' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_HISTORICO_ARG' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_cxa_intc.prc_del_caixa_historico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_HISTORICO_ARG'  value='#arguments.COD_HISTORICO_ARG#'  null='#iif(len(trim(arguments.COD_HISTORICO_ARG)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Histrico excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere um honorario de fronteira
	-- CRISTOFER 04/06/2007 16:52:53 - CRIADO
	--->
	<cffunction name='ins_honorarios_fronteira' displayname='Insere um honorario de fronteira' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_LANCAMENTO' required='yes'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='NUM_DOCTO' required='yes'>
		<cfargument name='COD_HISTORICO' required='yes'>
		<cfargument name='COMPLEMENTO' required='no' default="">
		<cfargument name='VALOR' required='yes'>
		<cfargument name='VALOR_IVA' required='yes'>
        <cfargument name='RECEITA' required='no' default="0">
        <cfargument name='DATA_COMPROVANTE' required='yes'>
        <cfargument name='COD_COMPROVANTE' required='yes'>
        <cfargument name='PRECEP_IVA' required='yes'>
        <cfargument name='COD_TIPO_COMPROVANTE' required='yes'>
        <cfargument name='TIPO_FORMULARIO' required='yes'>
        <cfargument name='AGRUPAMENTO_ID' required='no' default="">
		<cfargument name='LANCAMENTO_ID_VINCULO' required='no' default="">
		<cfargument name='PAGAMENTO_ID' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfscript>
					conn = CreateObject("component", "_transportes.consulta.cfc_caixa_internacional");
					qrRateio = conn.get_rateio_honorarios_fronteira_rateio(argumentCollection = arguments );
				</cfscript>
                  <cfloop query="qrRateio">
						<cfscript>
                            // Efetua o lancamento para o centro de custo
                            ret = this.ins_lancamento_caixa(receita 				= 0,
                                                            controle_id				= arguments.controle_id,
                                                            data_lancamento			= arguments.data_lancamento,
                                                            num_docto				= arguments.num_docto,
                                                            cod_historico_arg		= arguments.cod_historico,
                                                            complemento				= arguments.complemento,
                                                            cod_centro_custo		= qrRateio.cod_centro_custo,
															cod_comprovante		    = arguments.cod_comprovante,
															cod_tipo_comprovante	= arguments.cod_tipo_comprovante,
															tipo_formulario	        = arguments.tipo_formulario,
															data_comprovante		= arguments.data_comprovante,
															precep_iva				= arguments.precep_iva,	
                                                            lancamento_id_vinculo	= arguments.lancamento_id_vinculo,
                                                            cod_pessoa_fornecedor	= arguments.cod_pessoa_fornecedor,
                                                            valor_neto				= qrRateio.total_servico,
                                                            valor_iva				= qrRateio.total_iva,
                                                            valor_no_gravado		= 0,
															jurisdicao_ib			= '',	  
                                                            valor_exentos			= 0,
                                                            valor_ret_ir			= 0,
                                                            valor_total				= qrRateio.total_servico + qrRateio.total_iva + arguments.precep_iva,
															pagamento_id	        = arguments.pagamento_id);
                        </cfscript>
                        <cfif ret.erro>
                            <cfthrow object="#ret.mensagem#">
                        <cfelse>
							  <!--- Insere o vinculo dos mics com o lancamento --->
                              <cfset v_lancamento_id = ret.lancamento_id>
                              <cfset v_array = ListToArray(qrRateio.lista_manifesto)>
                              <cfloop from="1" to="#ArrayLen(v_array)#" index="count">
                                  <cfstoredproc procedure='finan.pkg_cxa_intc.prc_ins_intc_manifesto_caixa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                                      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MANIFESTO_ID'  value='#v_array[count]#'  null='#iif(len(trim(v_array[count])), de('no'), de('yes'))#'>
                                      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCAMENTO_ID'  value='#v_lancamento_id#'  null='#iif(len(trim(v_lancamento_id)), de('no'), de('yes'))#'>
                                      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRONTEIRA_ID'  value='#arguments.FRONTEIRA_ID#'  null='#iif(len(trim(arguments.FRONTEIRA_ID)), de('no'), de('yes'))#'>
                                  </cfstoredproc>
                              </cfloop>
                            </cfif>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Honorrios inseridos com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
			
	<!--- 
	-- PROPSITO
	-- Insere a Baixa de DTI
	-- cristofer 22/06/2007 16:57:22 - CRIADO
	--->
	<cffunction name='ins_baixa_dti' displayname='Insere a Baixa de DTI' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_LANCAMENTO' required='yes'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='NUM_DESPACHO' required='yes'>
		<cfargument name='COD_HISTORICO_ARG' required='yes'>
		<cfargument name='COMPLEMENTO' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='no' default="#session.cod_centro_custo#">
		<cfargument name='LANCAMENTO_ID_VINCULO' required='no' default="">
		<cfargument name='COD_PESSOA_FORNECEDOR' required='yes'>
		<cfargument name='VALOR_NETO' required='yes'>
		<cfargument name='VALOR_IVA' required='yes'>
		<cfargument name='VALOR_NO_GRAVADO' required='yes'>
		<cfargument name='VALOR_EXENTOS' required='yes'>
		<cfargument name='VALOR_RET_IR' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
		<cfargument name='DESPACHO_ID' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='TIPO_PAGTO' required='yes'>
		<cfargument name='VALOR' required='yes'>
        <cfargument name='DATA_COMPROVANTE' required='yes'>
        <cfargument name='COD_COMPROVANTE' required='yes'>
        <cfargument name='PRECEP_IVA' required='yes'>
        <cfargument name='JURISDICAO_IB' required='yes'>
        <cfargument name='COD_TIPO_COMPROVANTE' required='yes'>
        <cfargument name='TIPO_FORMULARIO' required='yes'>
        <cfargument name='AGRUPAMENTO_ID' required='no' default="">
		<cfargument name='PAGAMENTO_ID' required='no' default="">
        <cfargument name='DOCTO_PAGAMENTO' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_cxa_intc.prc_ins_pagamento_dti' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_COMPROVANTE'  value='#arguments.COD_COMPROVANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_HISTORICO_ARG'  value='#arguments.COD_HISTORICO_ARG#'  null='#iif(len(trim(arguments.COD_HISTORICO_ARG)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FORNECEDOR'  value='#arguments.COD_PESSOA_FORNECEDOR#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_COMPROVANTE'  value='#arguments.DATA_COMPROVANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRECEP_IVA'  value='#arguments.PRECEP_IVA#'  null='#iif(len(trim(arguments.PRECEP_IVA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_JURISDICAO_IB'  value='#arguments.JURISDICAO_IB#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_TIPO_COMPROVANTE'  value='#arguments.COD_TIPO_COMPROVANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_FORMULARIO'  value='#arguments.TIPO_FORMULARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_NETO'  value='#arguments.VALOR_NETO#'  null='#iif(len(trim(arguments.VALOR_NETO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_IVA'  value='#arguments.VALOR_IVA#'  null='#iif(len(trim(arguments.VALOR_IVA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_NO_GRAVADO'  value='#arguments.VALOR_NO_GRAVADO#'  null='#iif(len(trim(arguments.VALOR_NO_GRAVADO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_EXENTOS'  value='#arguments.VALOR_EXENTOS#'  null='#iif(len(trim(arguments.VALOR_EXENTOS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_RET_IR'  value='#arguments.VALOR_RET_IR#'  null='#iif(len(trim(arguments.VALOR_RET_IR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESPACHO_ID'  value='#arguments.DESPACHO_ID#'  null='#iif(len(trim(arguments.DESPACHO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_PAGTO'  value='#arguments.TIPO_PAGTO#'  null='#iif(len(trim(arguments.TIPO_PAGTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCAMENTO_ID' variable='retorno.LANCAMENTO_ID' >				
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PAGAMENTO_iD'  value='#arguments.PAGAMENTO_iD#'  null='#iif(len(trim(arguments.PAGAMENTO_iD)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DOCTO_PAGAMENTO'  value='#arguments.DOCTO_PAGAMENTO#' >
                 </cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Baixa do DTI efetuada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Abertura de caixa
	-- LOUIS 22/06/2007 10:48:02 - CRIADO
	--->
	<cffunction name='abertura_caixa' displayname='Abertura de caixa' access='remote' returntype='Struct' output='true'>
		<cfargument name='CAIXA_ID' required='yes'>
		<cfargument name='VERIFICA_LOTACAO' required='no' default="1">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_cxa.prc_caixa_abertura' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAIXA_ID'  value='#arguments.CAIXA_ID#'  null='#iif(len(trim(arguments.CAIXA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERIFICA_LOTACAO'  value='#arguments.VERIFICA_LOTACAO#'  null='#iif(len(trim(arguments.VERIFICA_LOTACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_ROWID' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Abertura de caixa realizada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Fechamento de caixa
	-- louis 22/06/2007 10:50:04 - CRIADO
	--->
	<cffunction name='fechamento_caixa' displayname='Fechamento de caixa' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='USUARIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_cxa.prc_caixa_fechamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Fechamento de caixa realizado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere a Baixa de DTI
	-- cristofer 22/06/2007 16:57:22 - CRIADO
	--->
	<cffunction name='del_pagamento_dti' displayname='Insere a Baixa de DTI' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCAMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_cxa_intc.prc_del_pagamento_dti' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCAMENTO_ID'  value='#arguments.LANCAMENTO_ID#'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pagamento excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere um lanamento de abastecimento
	-- louis 25/06/2007 14:02:14 - CRIADO
	--->
	<cffunction name='ins_abastecimento' displayname='Efetua um lanamento de abastecimento' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_LANCAMENTO' required='yes'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='NUM_DOCTO' required='yes'>
		<cfargument name='COD_HISTORICO_ARG' required='yes'>
		<cfargument name='COMPLEMENTO' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='LANCAMENTO_ID_VINCULO' required='no' default="">
		<cfargument name='COD_PESSOA_FORNECEDOR' required='yes'>
		<cfargument name='VALOR_NETO' required='yes'>
		<cfargument name='VALOR_IVA' required='yes'>
		<cfargument name='VALOR_NO_GRAVADO' required='yes'>
		<cfargument name='VALOR_EXENTOS' required='yes'>
		<cfargument name='VALOR_RET_IR' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='KM' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='COD_PESSOA_MOTORISTA' required='yes'>
        <cfargument name='DATA_COMPROVANTE' required='yes'>
        <cfargument name='COD_COMPROVANTE' required='yes'>
        <cfargument name='PRECEP_IVA' required='yes'>
        <cfargument name='JURISDICAO_IB' required='yes'>
        <cfargument name='COD_TIPO_COMPROVANTE' required='yes'>
        <cfargument name='TIPO_FORMULARIO' required='yes'>
        <cfargument name='AGRUPAMENTO_ID' required='no' default="">
		<cfargument name='PAGAMENTO_ID' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_cxa_intc	.prc_ins_abastecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_COMPROVANTE'  value='#arguments.COD_COMPROVANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_HISTORICO_ARG'  value='#arguments.COD_HISTORICO_ARG#'  null='#iif(len(trim(arguments.COD_HISTORICO_ARG)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FORNECEDOR'  value='#arguments.COD_PESSOA_FORNECEDOR#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_COMPROVANTE'  value='#arguments.DATA_COMPROVANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRECEP_IVA'  value='#arguments.PRECEP_IVA#'  null='#iif(len(trim(arguments.PRECEP_IVA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_JURISDICAO_IB'  value='#arguments.JURISDICAO_IB#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_TIPO_COMPROVANTE'  value='#arguments.COD_TIPO_COMPROVANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_FORMULARIO'  value='#arguments.TIPO_FORMULARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_NETO'  value='#arguments.VALOR_NETO#'  null='#iif(len(trim(arguments.VALOR_NETO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_IVA'  value='#arguments.VALOR_IVA#'  null='#iif(len(trim(arguments.VALOR_IVA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_NO_GRAVADO'  value='#arguments.VALOR_NO_GRAVADO#'  null='#iif(len(trim(arguments.VALOR_NO_GRAVADO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_EXENTOS'  value='#arguments.VALOR_EXENTOS#'  null='#iif(len(trim(arguments.VALOR_EXENTOS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_RET_IR'  value='#arguments.VALOR_RET_IR#'  null='#iif(len(trim(arguments.VALOR_RET_IR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_KM'  value='#arguments.KM#'  null='#iif(len(trim(arguments.KM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_MOTORISTA'  value='#arguments.COD_PESSOA_MOTORISTA#'  null='#iif(len(trim(arguments.COD_PESSOA_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCAMENTO_ID' variable='retorno.LANCAMENTO_ID' >				
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PAGAMENTO_iD'  value='#arguments.PAGAMENTO_iD#'  null='#iif(len(trim(arguments.PAGAMENTO_iD)), de('no'), de('yes'))#'>
                    </cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lanamento efetuado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Cancela um abastecimento
	-- louis 28/06/2007 14:07:46 - CRIADO
	--->
	<cffunction name='del_abastecimento' displayname='Cancela um abastecimento' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCAMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_cxa_intc.prc_del_abastecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCAMENTO_ID'  value='#arguments.LANCAMENTO_ID#'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Abastecimento cancelado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
    -- PROPSITO
    -- Insere pagamento
    -- guto 16/11/2007 17:16:05 - CRIADO
    --->
    <cffunction name='ins_finan_caixa_pagto_arg' displayname='Insere pagamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_COMPROVANTE' required='yes'>
        <cfargument name='TIPO_PAGAMENTO_ID' required='yes'>
        <cfargument name='DATA_LANCAMENTO' required='yes'>
        <cfargument name='DATA_COMPROVANTE' required='yes'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='COD_HISTORICO_ARG' required='yes'>
        <cfargument name='COMPLEMENTO' required='yes'>
        <cfargument name='VALOR_TOTAL' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='finan.pkg_cxa_intc.prc_ins_finan_caixa_pagto_arg' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_COMPROVANTE'  value='#arguments.COD_COMPROVANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_PAGAMENTO_ID'  value='#arguments.TIPO_PAGAMENTO_ID#'  null='#iif(len(trim(arguments.TIPO_PAGAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_COMPROVANTE'  value='#arguments.DATA_COMPROVANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_HISTORICO_ARG'  value='#arguments.COD_HISTORICO_ARG#'  null='#iif(len(trim(arguments.COD_HISTORICO_ARG)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PAGAMENTO_ID' variable='retorno.PAGAMENTO_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Pagamento inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Altera dados do pagamento
    -- guto 17/11/2007 11:44:32 - CRIADO
    --->
    <cffunction name='upd_finan_caixa_pagto_arg' displayname='Altera dados do pagamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='PAGAMENTO_ID' required='yes'>
        <cfargument name='COD_COMPROVANTE' required='yes'>
        <cfargument name='TIPO_PAGAMENTO_ID' required='yes'>
        <cfargument name='DATA_LANCAMENTO' required='yes'>
        <cfargument name='DATA_COMPROVANTE' required='yes'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='COD_HISTORICO_ARG' required='yes'>
        <cfargument name='COMPLEMENTO' required='yes'>
        <cfargument name='VALOR_TOTAL' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='finan.pkg_cxa_intc.prc_alt_finan_caixa_pagto_arg' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PAGAMENTO_ID'  value='#arguments.PAGAMENTO_ID#'  null='#iif(len(trim(arguments.PAGAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_COMPROVANTE'  value='#arguments.COD_COMPROVANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_PAGAMENTO_ID'  value='#arguments.TIPO_PAGAMENTO_ID#'  null='#iif(len(trim(arguments.TIPO_PAGAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_COMPROVANTE'  value='#arguments.DATA_COMPROVANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_HISTORICO_ARG'  value='#arguments.COD_HISTORICO_ARG#'  null='#iif(len(trim(arguments.COD_HISTORICO_ARG)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Exclui pagamento
    -- guto 17/11/2007 11:44:32 - CRIADO
    --->
    <cffunction name='del_finan_caixa_pagto_arg' displayname='Altera dados do pagamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='PAGAMENTO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='finan.pkg_cxa_intc.prc_del_finan_caixa_pagto_arg' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PAGAMENTO_ID'  value='#arguments.PAGAMENTO_ID#'  null='#iif(len(trim(arguments.PAGAMENTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>        

		<!--- 
  -- PROPSITO
  -- Insere pagamento do ADV e vincula ao lanamento de caixa
  -- guto 17/03/2008 09:36:12 - CRIADO
  --->
  <cffunction name='ins_pagamento_adv' displayname='Insere pagamento do ADV e vincula ao lanamento de caixa' access='remote' returntype='Struct' output='true'>
   <cfargument name='DATA_LANCAMENTO' required='yes'>
   <cfargument name='CONTROLE_ID' required='yes'>
   <cfargument name='COD_COMPROVANTE' required='yes'>
   <cfargument name='COD_HISTORICO_ARG' required='yes'>
   <cfargument name='COMPLEMENTO' required='yes'>
   <cfargument name='COD_PESSOA_FORNECEDOR' required='yes'>
   <cfargument name='DATA_COMPROVANTE' required='yes'>
   <cfargument name='PRECEP_IVA' required='yes'>
   <cfargument name='JURISDICAO_IB' required='yes'>
   <cfargument name='COD_TIPO_COMPROVANTE' required='yes'>
   <cfargument name='TIPO_FORMULARIO' required='yes'>
   <cfargument name='VALOR_NETO' required='yes'>
   <cfargument name='VALOR_IVA' required='yes'>
   <cfargument name='VALOR_NO_GRAVADO' required='yes'>
   <cfargument name='VALOR_EXENTOS' required='yes'>
   <cfargument name='VALOR_RET_IR' required='yes'>
   <cfargument name='VALOR_TOTAL' required='yes'>
   <cfargument name='ADV_ID' required='yes'>
   <cfargument name='PAGAMENTO_ID' required='yes'>
   <cftry>
    <cftransaction action='begin'>
     <cfstoredproc procedure='finan.pkg_cxa_intc.prc_ins_pagamento_adv' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
      <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
      <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_COMPROVANTE'  value='#arguments.COD_COMPROVANTE#' >
      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_HISTORICO_ARG'  value='#arguments.COD_HISTORICO_ARG#'  null='#iif(len(trim(arguments.COD_HISTORICO_ARG)), de('no'), de('yes'))#'>
      <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FORNECEDOR'  value='#arguments.COD_PESSOA_FORNECEDOR#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDOR)), de('no'), de('yes'))#'>
      <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_COMPROVANTE'  value='#arguments.DATA_COMPROVANTE#' >
      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRECEP_IVA'  value='#arguments.PRECEP_IVA#'  null='#iif(len(trim(arguments.PRECEP_IVA)), de('no'), de('yes'))#'>
      <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_JURISDICAO_IB'  value='#arguments.JURISDICAO_IB#' >
      <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_TIPO_COMPROVANTE'  value='#arguments.COD_TIPO_COMPROVANTE#' >
      <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_FORMULARIO'  value='#arguments.TIPO_FORMULARIO#' >
      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_NETO'  value='#arguments.VALOR_NETO#'  null='#iif(len(trim(arguments.VALOR_NETO)), de('no'), de('yes'))#'>
      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_IVA'  value='#arguments.VALOR_IVA#'  null='#iif(len(trim(arguments.VALOR_IVA)), de('no'), de('yes'))#'>
      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_NO_GRAVADO'  value='#arguments.VALOR_NO_GRAVADO#'  null='#iif(len(trim(arguments.VALOR_NO_GRAVADO)), de('no'), de('yes'))#'>
      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_EXENTOS'  value='#arguments.VALOR_EXENTOS#'  null='#iif(len(trim(arguments.VALOR_EXENTOS)), de('no'), de('yes'))#'>
      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_RET_IR'  value='#arguments.VALOR_RET_IR#'  null='#iif(len(trim(arguments.VALOR_RET_IR)), de('no'), de('yes'))#'>
      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ADV_ID'  value='#arguments.ADV_ID#'  null='#iif(len(trim(arguments.ADV_ID)), de('no'), de('yes'))#'>
      <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCAMENTO_ID' variable='retorno.LANCAMENTO_ID' >
      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PAGAMENTO_ID'  value='#arguments.PAGAMENTO_ID#'  null='#iif(len(trim(arguments.PAGAMENTO_ID)), de('no'), de('yes'))#'>
     </cfstoredproc>
     <cfset retorno.erro = false>
     <cfset retorno.mensagem = JSStringFormat('Pagamento registrado com sucesso!')>
    </cftransaction>
    <cfcatch>
     <cftransaction action='rollback'/>
     <cfset retorno.erro = true>
     <cfset retorno.mensagem = cfcatch>
     <cfset request.erro = cfcatch>
    </cfcatch>
   </cftry>
   <cfreturn retorno />
  </cffunction>    

		<!--- 
  -- PROPSITO
  -- Exclui pagamento do ADV vinculado ao lanamento de caixa
  -- guto 17/03/2008 09:37:17 - CRIADO
  --->
  <cffunction name='del_pagamento_adv' displayname='Exclui pagamento do ADV vinculado ao lanamento de caixa' access='remote' returntype='Struct' output='true'>
   <cfargument name='LANCAMENTO_ID' required='yes'>
   <cftry>
    <cftransaction action='begin'>
     <cfstoredproc procedure='finan.pkg_cxa_intc.prc_del_pagamento_adv' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
      <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCAMENTO_ID'  value='#arguments.LANCAMENTO_ID#'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>
     </cfstoredproc>
     <cfset retorno.erro = false>
     <cfset retorno.mensagem = JSStringFormat('Pagamento excludo com sucesso!')>
    </cftransaction>
    <cfcatch>
     <cftransaction action='rollback'/>
     <cfset retorno.erro = true>
     <cfset retorno.mensagem = cfcatch>
     <cfset request.erro = cfcatch>
    </cfcatch>
   </cftry>
   <cfreturn retorno />
  </cffunction>  

	<!--- 
	-- PROPSITO
	-- Insere a Baixa de CFA
	-- Guto 14/01/2009 16:57:22 - CRIADO
	--->
	<cffunction name='ins_baixa_cfa' displayname='Insere a Baixa de CFA' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_LANCAMENTO' required='yes'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='COD_HISTORICO_ARG' required='yes'>
		<cfargument name='COMPLEMENTO' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='no' default="#session.cod_centro_custo#">
		<cfargument name='LANCAMENTO_ID_VINCULO' required='no' default="">
		<cfargument name='COD_PESSOA_FORNECEDOR' required='yes'>
		<cfargument name='VALOR_NETO' required='yes'>
		<cfargument name='VALOR_IVA' required='yes'>
		<cfargument name='VALOR_NO_GRAVADO' required='yes'>
		<cfargument name='VALOR_EXENTOS' required='yes'>
		<cfargument name='VALOR_RET_IR' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='TIPO_PAGTO' required='yes'>
		<cfargument name='VALOR' required='yes'>
        <cfargument name='DATA_COMPROVANTE' required='yes'>
        <cfargument name='COD_COMPROVANTE' required='yes'>
        <cfargument name='PRECEP_IVA' required='yes'>
        <cfargument name='JURISDICAO_IB' required='yes'>
        <cfargument name='COD_TIPO_COMPROVANTE' required='yes'>
        <cfargument name='TIPO_FORMULARIO' required='yes'>
        <cfargument name='AGRUPAMENTO_ID' required='no' default="">
		<cfargument name='PAGAMENTO_ID' required='no' default="">
        <cfargument name='DOCTO_PAGAMENTO' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_cxa_intc.prc_ins_pagamento_cfa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_COMPROVANTE'  value='#arguments.COD_COMPROVANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_HISTORICO_ARG'  value='#arguments.COD_HISTORICO_ARG#'  null='#iif(len(trim(arguments.COD_HISTORICO_ARG)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FORNECEDOR'  value='#arguments.COD_PESSOA_FORNECEDOR#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_COMPROVANTE'  value='#arguments.DATA_COMPROVANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRECEP_IVA'  value='#arguments.PRECEP_IVA#'  null='#iif(len(trim(arguments.PRECEP_IVA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_JURISDICAO_IB'  value='#arguments.JURISDICAO_IB#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_TIPO_COMPROVANTE'  value='#arguments.COD_TIPO_COMPROVANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_FORMULARIO'  value='#arguments.TIPO_FORMULARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_NETO'  value='#arguments.VALOR_NETO#'  null='#iif(len(trim(arguments.VALOR_NETO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_IVA'  value='#arguments.VALOR_IVA#'  null='#iif(len(trim(arguments.VALOR_IVA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_NO_GRAVADO'  value='#arguments.VALOR_NO_GRAVADO#'  null='#iif(len(trim(arguments.VALOR_NO_GRAVADO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_EXENTOS'  value='#arguments.VALOR_EXENTOS#'  null='#iif(len(trim(arguments.VALOR_EXENTOS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_RET_IR'  value='#arguments.VALOR_RET_IR#'  null='#iif(len(trim(arguments.VALOR_RET_IR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_PAGTO'  value='#arguments.TIPO_PAGTO#'  null='#iif(len(trim(arguments.TIPO_PAGTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCAMENTO_ID' variable='retorno.LANCAMENTO_ID' >				
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PAGAMENTO_iD'  value='#arguments.PAGAMENTO_iD#'  null='#iif(len(trim(arguments.PAGAMENTO_iD)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DOCTO_PAGAMENTO'  value='#arguments.DOCTO_PAGAMENTO#' >
                 </cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Baixa da CFA efetuada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	  

	<!--- 
	-- PROPSITO
	-- Exclui pagamento CFA
	-- Guto 15/01/2008 13:35 - CRIADO
	--->
	<cffunction name='del_pagamento_cfa' displayname='Insere a Baixa de DTI' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCAMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_cxa_intc.prc_del_pagamento_cfa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCAMENTO_ID'  value='#arguments.LANCAMENTO_ID#'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pagamento excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir uma transferncia entre caixas
	-- RAFAEL 16/11/2009 08:40:24 - CRIADO
	--->
	<cffunction name='ins_caixa_transf_web' displayname='Inserir uma transferncia entre caixas' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_TRANSFERENCIA' required='yes'>
		<cfargument name='CONTROLE_ID_DEBITO' required='yes'>
		<cfargument name='CAIXA_ID_CREDITO' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='COD_HISTORICO' required='yes'>
		<cfargument name='COMPLEMENTO' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO_DEBITO' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO_CREDITO' required='yes'>
        <cfargument name='NUM_COMPROVANTE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_cxa.prc_ins_caixa_transf_web' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TRANSFERENCIA'  value='#arguments.DATA_TRANSFERENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID_DEBITO'  value='#arguments.CONTROLE_ID_DEBITO#'  null='#iif(len(trim(arguments.CONTROLE_ID_DEBITO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAIXA_ID_CREDITO'  value='#arguments.CAIXA_ID_CREDITO#'  null='#iif(len(trim(arguments.CAIXA_ID_CREDITO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_HISTORICO'  value='#arguments.COD_HISTORICO#'  null='#iif(len(trim(arguments.COD_HISTORICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO_DEBITO'  value='#arguments.COD_CENTRO_CUSTO_DEBITO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO_DEBITO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO_CREDITO'  value='#arguments.COD_CENTRO_CUSTO_CREDITO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO_CREDITO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_COMPROVANTE'  value='#arguments.NUM_COMPROVANTE#'  null='#iif(len(trim(arguments.NUM_COMPROVANTE)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Transferncia efetuada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

</cfcomponent>