<cfcomponent displayname="Manipulao da rea de caixa" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Insere um aporte de caixa
	-- CRISTOFER  30/12/2005
	--->
	<cffunction name="ins_lancto_caixa" displayname="Altera a gesto da modalidade passada" access="remote" returntype="struct" output="true">
		<cfargument name="data"				required="yes">
		<cfargument name="hora"				required="yes">
		<cfargument name="controle_id" 		required="yes">
		<cfargument name="num_docto"	 	required="yes">
		<cfargument name="cod_historico" 	required="yes">
		<cfargument name="complemento" 		required="no">
		<cfargument name="cod_pessoa" 		required="yes">
		<cfargument name="cod_departamento" required="no" default="2">
		<cfargument name="cod_setor" 		required="yes">
		<cfargument name="cod_centro_custo" required="no" default="1">
		<cfargument name="unidade_id" 		required="yes">
		<cfargument name="valor" 			required="yes">
		<cfargument name="receita" 			required="no" default="0">
		<cftry>
			<cftransaction action="begin">
			<cfstoredproc datasource="#session.dsn#" procedure="finan.pkg_caixa.prc_incluir_lancto_caixa" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="inout" dbvarname="p_lancamento_id" 	cfsqltype="cf_sql_integer" null="yes" variable="retorno.lancamento_id">
				<cfprocparam type="in" dbvarname="p_data_lancamento" 	cfsqltype="cf_sql_varchar" value="#arguments.data# #arguments.hora#:00">
				<cfprocparam type="in" dbvarname="p_controle_id" 		cfsqltype="cf_sql_integer" value="#arguments.controle_id#">
				<cfprocparam type="in" dbvarname="p_num_docto" 			cfsqltype="cf_sql_integer" value="#arguments.num_docto#">
				<cfprocparam type="in" dbvarname="p_cod_historico" 		cfsqltype="cf_sql_integer" value="#arguments.cod_historico#">
				<cfprocparam type="in" dbvarname="p_complemento" 		cfsqltype="cf_sql_varchar" value="#Left(arguments.complemento,60)#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa" 		cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa#">
				<cfprocparam type="in" dbvarname="p_cod_departamento" 	cfsqltype="cf_sql_integer" value="#arguments.cod_departamento#">
				<cfprocparam type="in" dbvarname="p_cod_setor" 			cfsqltype="cf_sql_integer" value="#arguments.cod_setor#">
				<cfprocparam type="in" dbvarname="p_cod_centro_custo" 	cfsqltype="cf_sql_integer" value="#arguments.cod_centro_custo#">
				<cfprocparam type="in" dbvarname="p_unidade_id" 		cfsqltype="cf_sql_integer" value="#arguments.unidade_id#">
				<cfprocparam type="in" dbvarname="p_valor" 				cfsqltype="cf_sql_float"   value="#arguments.valor#">
				<cfprocparam type="in" dbvarname="p_receita" 			cfsqltype="cf_sql_integer" value="#arguments.receita#">
				<cfprocparam type="in" dbvarname="p_transferencia" 		cfsqltype="cf_sql_integer" value="1">
				<cfprocparam type="inout" dbvarname="p_rowid" 			cfsqltype="cf_sql_varchar" variable="retorno.rowid" null="yes">					
			</cfstoredproc>
			<cfset retorno.mensagem = 'Lanamento feito com sucesso!'>
			<cfset retorno.erro = false>						
			</cftransaction>
	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cftransaction action="rollback" />
			<cfset request.erro = cfcatch>
	   </cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Abre o caixa
	-- 03/01/2006 - criado
	--->
	<cffunction name="abre_caixa" displayname="Abre o caixa" access="remote" returntype="Struct" output="true">
		<cfargument name="COD_PESSOA" required="yes">
		<cfargument name="COD_DEPARTAMENTO" required="yes">
		<cfargument name="COD_SETOR" required="yes">
		<cfargument name="COD_CENTRO_CUSTO" required="yes">
		<cfargument name="NUM_CAIXA" required="yes">
		<cfargument name="SALDO_ABERTURA" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="finan.pkg_caixa.prc_abertura_controle" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="inout" cfsqltype="cf_sql_integer" dbvarname="P_CONTROLE_ID" variable="retorno.CONTROLE_ID" null="yes" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_PESSOA" value="#arguments.COD_PESSOA#" null="#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_DEPARTAMENTO" value="#arguments.COD_DEPARTAMENTO#" null="#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_SETOR" value="#arguments.COD_SETOR#" null="#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_CENTRO_CUSTO" value="#arguments.COD_CENTRO_CUSTO#" null="#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_CAIXA" value="#arguments.NUM_CAIXA#" null="#iif(len(trim(arguments.NUM_CAIXA)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_USUARIO" value="#session.USUARIO#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_ABERTURA" value="#DateFormat(Now(),'dd/mm/yyyy')# #TimeFormat(Now(),'HH:MM')#"  >				<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="P_SALDO_ABERTURA" value="#arguments.SALDO_ABERTURA#" >
					<cfprocparam type="inout" cfsqltype="cf_sql_varchar" dbvarname="P_ROWID" null="yes" variable="retorno.ROWID"  >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Caixa aberto com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Encerramento de caixa
	-- 04/01/2006 - criado
	--->
	<cffunction name="encerra_caixa" displayname="Encerramento de caixa" access="remote" returntype="Struct" output="true">
		<cfargument name="COD_PESSOA" required="yes">
		<cfargument name="COD_DEPARTAMENTO" required="yes">
		<cfargument name="COD_SETOR" required="yes">
		<cfargument name="COD_CENTRO_CUSTO" required="yes">
		<cfargument name="NUM_CAIXA" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="finan.pkg_caixa.prc_encerramento_controle" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_PESSOA" value="#arguments.COD_PESSOA#" null="#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_DEPARTAMENTO" value="#arguments.COD_DEPARTAMENTO#" null="#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_SETOR" value="#arguments.COD_SETOR#" null="#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_CENTRO_CUSTO" value="#arguments.COD_CENTRO_CUSTO#" null="#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_CAIXA" value="#arguments.NUM_CAIXA#" null="#iif(len(trim(arguments.NUM_CAIXA)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_USUARIO" value="#session.USUARIO#"  >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Caixa fechado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma solicitao de despesa
	-- CRISTOFER 04/01/2006 - criado
	--->
	<cffunction name="del_solicitacao" displayname="Exclui uma solicitao de despesa" access="remote" returntype="Struct" output="true">
		<cfargument name="cod_solicitacao" required="yes">
		<cftry>
			<cftransaction action="begin">
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				delete finan.v$caixa_solicitacao where cod_solicitacao = #arguments.cod_solicitacao#
			</cfquery>
			<cfset retorno.mensagem = 'Solicitacao excluida com sucesso.'>
			<cfset retorno.erro = false>						
			</cftransaction>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cftransaction action="rollback" />
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>	
		<cfreturn retorno>
	</cffunction>			
	
	<!--- 
	-- PROPSITO
	-- Confirma as solicitaes de crdito
	-- CRISTOFER 04/01/2006 - criado
	--->
	<cffunction name="confirma_solicitacao" displayname="" access="remote" returntype="struct" output="true">
		<cfargument name="num_caixa" 			required="yes">
		<cfargument name="cod_pessoa_filial" 	required="yes">
		<cfargument name="cod_departamento" 	required="no" default="2">
		<cfargument name="cod_setor" 			required="yes">
		<cfargument name="cod_centro_custo" 	required="no" default="1">
		<cftry>
			<cftransaction action="begin">
			<cfstoredproc datasource="#session.dsn#" procedure="finan.pkg_caixa.prc_confirma_solicitacao" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_num_caixa" value="#arguments.num_caixa#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_cod_pessoa" value="#arguments.cod_pessoa_filial#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_cod_departamento" value="#arguments.cod_departamento#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_cod_setor" value="#arguments.cod_setor#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_cod_centro_custo" value="#arguments.cod_centro_custo#">
			</cfstoredproc>
			<cfset retorno.mensagem = 'Despesas Confirmadas com sucesso.'>
			<cfset retorno.erro = false>						
			</cftransaction>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cftransaction action="rollback" />
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>	
		<cfreturn retorno>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Abre uma trasnferencias de caixa
	-- 04/01/2006 - criado
	--->
	<cffunction name="abre_transferencia" displayname="Abre uma trasnferencias de caixa" access="remote" returntype="Struct" output="true">
		<cfargument name="CONTROLE_ID_CRED" required="yes">
		<cfargument name="CONTROLE_ID_DEB" required="yes">
		<cfargument name="VALOR" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="finan.pkg_caixa.prc_incluir_caixa_transf" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="inout" cfsqltype="cf_sql_integer" dbvarname="P_COD_TRANSFERENCIA" null="yes" variable="retorno.COD_TRANSFERENCIA">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_TRANSFERENCIA" value="#DateFormat(Now(),'dd/mm/yyyy')# #TimeFormat(Now(),'HH:MM')#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONTROLE_ID_CREDITO" value="#arguments.CONTROLE_ID_CRED#" null="#iif(len(trim(arguments.CONTROLE_ID_CRED)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONTROLE_ID_DEBITO" value="#arguments.CONTROLE_ID_DEB#" null="#iif(len(trim(arguments.CONTROLE_ID_DEB)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="P_VALOR" value="#arguments.VALOR#" null="#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#" >
					<cfprocparam type="inout" cfsqltype="cf_sql_varchar" dbvarname="P_ROWID" null="yes" variable="retorno.ROWID"  >
				</cfstoredproc> 
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Transferncia aberta com sucesso.")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	
	<!--- 
	-- PROPSITO
	-- Fecha uma trasnferencias de caixa
	-- 04/01/2006 - criado
	--->
	<cffunction name="fecha_transferencia" displayname="Fecha uma trasnferencias de caixa" access="remote" returntype="Struct" output="true">
		<cfargument name="COD_TRANSFERENCIA" required="yes">
		<cfargument name="COMPLEMENTO" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="finan.pkg_caixa.prc_confirmar_caixa_transf" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_TRANSFERENCIA" value="#arguments.COD_TRANSFERENCIA#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_HISTORICO" value="7">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_COMPLEMENTO" value="#arguments.COMPLEMENTO#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_UNIDADE_ID" value="1">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Transferncia fechada com sucesso.")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Excluir transferncia
	-- 04/01/2006 - criado
	--->
	<cffunction name="del_transferencia" displayname="Excluir transferncia" access="remote" returntype="Struct" output="true">
		<cfargument name="COD_TRANSFERENCIA" required="yes">
	
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="finan.pkg_caixa.prc_excluir_caixa_transf" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_TRANSFERENCIA" value="#arguments.COD_TRANSFERENCIA#">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Tranferncia excluda com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere solicitao de despesa no caixa
	-- 04/01/2006 - criado
	--->
	<cffunction name="ins_despesas" displayname="Insere solicitao de despesa no caixa" access="remote" returntype="Struct" output="true">
		<cfargument name="NUM_CAIXA" required="yes">
		<cfargument name="NUM_DOCUMENTO" required="no" default="1">
		<cfargument name="DESCRICAO" required="yes">
		<cfargument name="DATA_LANCAMENTO" required="yes">
		<cfargument name="VALOR" required="yes">
        <cfargument name="COD_HISTORICO" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="finan.pkg_caixa.prc_ins_solicitacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_CAIXA" value="#arguments.NUM_CAIXA#" null="#iif(len(trim(arguments.NUM_CAIXA)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_DOCUMENTO" value="#arguments.NUM_DOCUMENTO#" null="#iif(len(trim(arguments.NUM_DOCUMENTO)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DESCRICAO" value="#arguments.DESCRICAO#"  >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_LANCAMENTO" value="#arguments.DATA_LANCAMENTO#"  >
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="P_VALOR" value="#arguments.VALOR#" null="#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_HISTORICO" value="#arguments.COD_HISTORICO#" null="#iif(len(trim(arguments.COD_HISTORICO)), de('no'), de('yes'))#" >
					<cfprocparam type="inout" cfsqltype="cf_sql_integer" dbvarname="P_COD_SOLICITACAO" variable="retorno.COD_SOLICITACAO" null="yes">
					<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="P_ROWID" variable="retorno.ROWID"  >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Despesa inserida com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera solicitao de despesa no caixa
	-- 05/01/2006 - criado
	--->
	<cffunction name="upd_despesas" displayname="Altera solicitao de despesa no caixa" access="remote" returntype="Struct" output="true">
		<cfargument name="COD_SOLICITACAO" required="yes">
		<cfargument name="NUM_CAIXA" required="yes">
		<cfargument name="NUM_DOCUMENTO" required="yes" default="1">
		<cfargument name="DESCRICAO" required="yes">
		<cfargument name="DATA_LANCAMENTO" required="yes">
		<cfargument name="VALOR" required="yes">
	
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="finan.pkg_caixa.prc_alt_solicitacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_SOLICITACAO" value="#arguments.COD_SOLICITACAO#" null="#iif(len(trim(arguments.COD_SOLICITACAO)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_CAIXA" value="#arguments.NUM_CAIXA#" null="#iif(len(trim(arguments.NUM_CAIXA)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_DOCUMENTO" value="#arguments.NUM_DOCUMENTO#" null="#iif(len(trim(arguments.NUM_DOCUMENTO)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DESCRICAO" value="#arguments.DESCRICAO#"  >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_LANCAMENTO" value="#arguments.DATA_LANCAMENTO#"  >
		   			<cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="P_VALOR" value="#arguments.VALOR#" >
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_HISTORICO" value="#arguments.COD_HISTORICO#" null="#iif(len(trim(arguments.COD_HISTORICO)), de('no'), de('yes'))#" >
        		</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Solicitao de despesas alterado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui solicitao de despesa no caixa
	-- 05/01/2006 - criado
	--->
	<cffunction name="del_despesas" displayname="Exclui solicitao de despesa no caixa" access="remote" returntype="Struct" output="true">
		<cfargument name="COD_SOLICITACAO" required="yes">
	
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="finan.pkg_caixa.prc_del_solicitacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_SOLICITACAO" value="#arguments.COD_SOLICITACAO#">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Solicitao de despesas excludo com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
    -- PROPSITO
    -- Procedimento de lanamento de adiantamentos para funcionrio atravs do caixa
    -- guto 01/12/2007 09:13:24 - CRIADO
    --->
    <cffunction name='ins_adiantamento_func' displayname='Procedimento de lanamento de adiantamentos para funcionrio atravs do caixa' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_CAIXA' required='yes'>
        <cfargument name='DATA_LANCAMENTO' required='yes'>
        <cfargument name='COD_FUNCIONARIO' required='yes'>
        <cfargument name='COD_TIPO_ADIANTAMENTO' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='finan.pkg_caixa.prc_incluir_adiantamento_func' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_CAIXA'  value='#arguments.NUM_CAIXA#'  null='#iif(len(trim(arguments.NUM_CAIXA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_FUNCIONARIO'  value='#arguments.COD_FUNCIONARIO#'  null='#iif(len(trim(arguments.COD_FUNCIONARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_TIPO_ADIANTAMENTO'  value='#arguments.COD_TIPO_ADIANTAMENTO#'  null='#iif(len(trim(arguments.COD_TIPO_ADIANTAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Adiantamento inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Insere rateio para o contas a pagar
    -- guto 15/12/2008 17:20:14 - CRIADO
    --->
    <cffunction name='ins_finan_contas_pagar_rateio' displayname='Insere rateio para o contas a pagar' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTAS_PAGAR_ID' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='COD_DEPARTAMENTO' required='yes'>
        <cfargument name='COD_SETOR' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='PERC_RATEIO' required='yes'>
        <cfargument name='VALOR_RATEIO' required='yes'>
        <cftry>
                <cfstoredproc procedure='finan.pkg_contas_pagar.prc_insere_rateio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTAS_PAGAR_ID'  value='#arguments.CONTAS_PAGAR_ID#' variable='retorno.CONTAS_PAGAR_ID'  null='#iif(len(trim(arguments.CONTAS_PAGAR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERC_RATEIO'  value='#arguments.PERC_RATEIO#'  null='#iif(len(trim(arguments.PERC_RATEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_RATEIO'  value='#arguments.VALOR_RATEIO#'  null='#iif(len(trim(arguments.VALOR_RATEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ok')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction> 
   
</cfcomponent>