<cfcomponent displayname="Controle e manipulao de veculos" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Insere nova cidade
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 01/12/2005 - criado
	--->
	<cffunction name="ins_cidade" displayname="Insere nova cidade" access="remote" returntype="struct" output="true">
		<cfargument name="municipio" required="yes">
		<cfargument name="pais_id" required="yes">
		<cfargument name="uf_id" required="yes">
		<cfargument name="cep" required="no">
		<cfargument name="intc_cod_municipio" required="no">
	    <cftry>
			<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				insert into cep.municipio
				  (municipio_id, municipio, pais_id, uf_id, cep, intc_cod_municipio)
				values
				  (-1, '#arguments.municipio#', #arguments.pais_id#, '#arguments.uf_id#', '#arguments.cep#', '#arguments.intc_cod_municipio#')
			</cfquery>

			<cfset retorno.mensagem = 'Cidade inserida com sucesso.'>				
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>
	
	
	<cffunction name="ins_posto" displayname="Insere Posto" access="remote" returntype="struct" output="true">
		<cfargument name="cod_pessoa" required="yes">
		<cfargument name="cupom_fiscal" required="no" default="0">
		<cfargument name="prazo" required="yes">
		<cfargument name="forma_pgto" required="yes">
		<cfargument name="banco" required="yes">
		<cfargument name="agencia" required="yes">
		<cfargument name="conta_corrente" required="yes">
		<cfargument name="conta_corrente_dv" required="yes">
		<cfargument name="distribuidora" required="yes">
		<cfargument name="pista" required="yes">
		<cfargument name="sentido" required="yes">
		<cfargument name="dist_capital" required="yes">
		<cfargument name="dist_base" required="yes">
		<cfargument name="ck_retorno" required="no" default="0">
		<cfargument name="inicio" required="yes">
		<cfargument name="termino" required="yes">
		<cfargument name="piso" required="yes">
		<cfargument name="tamanho_patio" required="no" default="0">
		<cfargument name="controle_entrada" required="no" default="0">
		<cfargument name="vigiado" required="no" default="0">
		<cfargument name="oficina" required="no" default="0">
		<cfargument name="pecas" required="no" default="0"> 
		<cfargument name="borracharia" required="no" default="0"> 
		<cfargument name="observacoes" required="no">
		<cfargument name="retorno_distancia" required="no" default="null">
		<cftry>
			<cfscript>
				arguments.inicio = replace(arguments.inicio, ' hs', '', 'ALL');
				arguments.termino = replace(arguments.termino, ' hs', '', 'ALL');
				conn = CreateObject("component", "_transportes.manipulacao.cfc_pessoa");
				retorno = conn.ins_pessoa(argumentCollection = arguments);
			</cfscript>
			<cftry>
				<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					insert into oper.posto
					  (cod_pessoa, cupom_fiscal, prazo, agrupamento, forma_id, 
					   banco_id, agencia_id, conta_corrente, conta_corrente_dv, distribuidora_id, 
					   pista, sentido, distancia_capital, distancia_base_combustivel, retorno, 
					   hora_inicio, hora_termino, piso_id, tam_patio, controle_entrada, vigiado, 
					   oficina, pecas, borracharia, observacao, retorno_distancia)
					values 
					  ('#retorno.cod_pessoa#', #arguments.cupom_fiscal#, #arguments.prazo#, '05/20', #arguments.forma_pgto#,
					   '#arguments.banco#', '#arguments.agencia#', '#arguments.conta_corrente#', '#arguments.conta_corrente_dv#', #arguments.distribuidora#,
					   '#arguments.pista#', 
					   '#arguments.sentido#', 
					   #arguments.dist_capital#, 
					   #arguments.dist_base#, 
					   #arguments.distancia_retorno#, 
					   '#arguments.inicio#', '#arguments.termino#', #arguments.piso#, #arguments.tamanho_patio#, #arguments.controle_entrada#, #arguments.vigiado#,
					   #arguments.oficina#, #arguments.pecas#, #arguments.borracharia#, '#arguments.observacoes#', #arguments.retorno_distancia#)
				</cfquery>
				<cfcatch type="database">
					
				</cfcatch>
			</cftry>
			<cfscript>
				v_produto_id = this.ListaToArray (lista = arguments, variavel = "PRODUTO_ID_PRODUTOS");
				v_preco = this.ListaToArray (lista = arguments, variavel = "PRECO_PRODUTOS");
			</cfscript>
			<cfloop from="1" to="#ArrayLen(v_produto_id)#" index="count">
				<cfscript>
					this.ins_posto_produto(	cod_pessoa = retorno.cod_pessoa,
					               			produto_id = v_produto_id[count],
								   			preco = v_preco[count]);
				</cfscript>
			</cfloop>
			<cfset retorno.mensagem = 'Posto inserido com sucesso.'>
			<cfset retorno.erro = false>
	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>
	
				
	<cffunction name="ins_posto_produto" displayname="Insere Produtos para Posto" access="remote" returntype="struct" output="true">
		<cfargument name="cod_pessoa" required="yes">
		<cfargument name="produto_id" required="yes">
		<cfargument name="preco" required="yes">
		<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			insert into oper.posto_produto_autorizado
			  (cod_pessoa, produto_id, preco, permite_reajuste, liberado, preco_maximo, icms)
			values
			  (#arguments.cod_pessoa#, #arguments.produto_id#, #arguments.preco#, 0, 0, #arguments.preco#, 0)			
		</cfquery>
		<cfreturn StructNew()>
	</cffunction>
</cfcomponent>	
