<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Cria os diretorios no servidor caso ainda nao existam
	-- CRISTOFER  15/08/2006
	--->
	<cffunction name="cria_arvore_diretorios" displayname="" access="remote" returntype="void" output="true">
		<cfargument name="path" required="yes">
		<cfset caminho = "/">
		<cfloop list="#arguments.path#" index="nome_dir">
			<cfset caminho = caminho&nome_dir&"/">
						<cfif not DirectoryExists(caminho)>
         <cfdirectory action="create"
                      directory="#caminho#"
                      mode="750">
      </cfif>
		</cfloop>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Copia o arquivo do diretorio de origem para o diretorio destino
	-- CRISTOFER  15/08/2006
	--->
	<cffunction name="copia_arquivo" displayname="" access="remote" returntype="struct" output="true">
		<cfargument name="origem"	required="yes">
		<cfargument name="destino"	required="yes">
		<cftry>
			<cffile action="copy"
					 source="#arguments.origem#"
					 destination="#arguments.destino#"
					 nameconflict="overwrite"
					 mode="750">
			<cfset retorno.mensagem = 'Arquivo sincronizado com sucesso'>
			<cfset retorno.erro = false>				
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Copia o arquivo do diretorio de origem para o diretorio destino
	-- CRISTOFER  15/08/2006
	--->
	<cffunction name="excluir_arquivo" displayname="" access="remote" returntype="struct" output="true">
		<cfargument name="destino"	required="yes">
		<cftry>
			<cffile action="delete"
					 file="#arguments.destino#">
			<cfset retorno.mensagem = 'Arquivo excluido com sucesso'>
			<cfset retorno.erro = false>				
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Abre um historico de sincronizao
	-- cristofer 16/08/2006 14:49:25 - CRIADO
	--->
	<cffunction name='sincronizar' displayname='Abre um historico de sincronizao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='COD_PROJETO' required='yes'>
		<cfargument name='COD_APLICACAO' required='yes'>
		<cfargument name="arquivo" required="no" default="">
		<cfargument name="arquivo_excluir" required="no" default="">
		<cftry>
			<cftransaction action='begin'>
				<cfif not len(trim(arguments.arquivo&arguments.arquivo_excluir))>
					<cfthrow errorcode="-20000" message="Nenhum arquivo foi selecionado para a sincronizao!">
				</cfif>
				<cfstoredproc procedure='liveupdate.pkg_sincronizador.prc_abre_historico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROJETO'  value='#arguments.COD_PROJETO#'  null='#iif(len(trim(arguments.COD_PROJETO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_APLICACAO'  value='#arguments.COD_APLICACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#ucase(session.USUARIO)#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#LSDateFormat(now())# #TimeFormat(now(), "HH:MM:SS")#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_HISTORICO_ID' variable='retorno.HISTORICO_ID'>
				</cfstoredproc>
				<cfloop list="#arguments.arquivo#" index="v_arquivos">
					<cfscript>
						origem = ListFirst(v_arquivos, '||');
						destino = ListGetAt(v_arquivos, 2, '||');
						dir_origem = ListDeleteAt(origem, ListLen(origem,'/'), '/');
						dir_destino = ListDeleteAt(destino, ListLen(destino,'/'), '/');
						this.cria_arvore_diretorios(path = dir_destino);
						v_log = this.copia_arquivo(	origem = origem,
													destino = destino);
						if(v_log.erro) {
							v_mensagem = v_log.mensagem.detail;
						} else {
							v_mensagem = v_log.mensagem;
							v_diretorio_id = this.get_diretorio_id(diretorio = dir_destino&"/");
							this.ins_arquivo(	DIRETORIO_ID = v_diretorio_id,
												NOME_ARQUIVO = ListLast(origem, '/'),
												ASSINATURA = ListGetAt(v_arquivos, 6, '||'),
												TAMANHO = ListGetAt(v_arquivos, 4, '||'),
												DATA_ARQUIVO = ListGetAt(v_arquivos, 5, '||'),
												VERSAO = 0);
						}
						this.ins_historico_log(	COD_PROJETO			= arguments.cod_projeto,
												COD_APLICACAO		= arguments.cod_aplicacao,
												HISTORICO_ID		= retorno.historico_id,
												USUARIO				= ucase(session.usuario),
												NOME_ARQUIVO		= ListLast(origem, '/'),
												PASTA_INSTALACAO	= ListGetAt(v_arquivos, 3, '||'),
												COMENTARIO			= v_mensagem,
												DIR_ORIGEM			= dir_origem,
												DIR_DESTINO			= dir_destino,
												ULTIMA_MODIFICACAO	= ListGetAt(v_arquivos, 5, '||'),
												TAMANHO 			= ListGetAt(v_arquivos, 4, '||'),
												SINCRONIZADO		= iif(v_log.erro, de(0), de(1)));
					</cfscript>
				</cfloop>
				<cfloop list="#arguments.arquivo_excluir#" index="v_arquivos">
					<cfscript>
						origem = ListFirst(v_arquivos, '||');
						destino = ListGetAt(v_arquivos, 2, '||');
						dir_origem = ListDeleteAt(origem, ListLen(origem,'/'), '/');
						dir_destino = ListDeleteAt(destino, ListLen(destino,'/'), '/');
						v_log = this.excluir_arquivo(destino = destino);
						if(v_log.erro) {
							v_mensagem = v_log.mensagem.detail;
						} else {
							v_mensagem = v_log.mensagem;
						}
						v_diretorio_id = this.get_diretorio_id(diretorio = dir_destino&"/");
						this.del_arquivo(	DIRETORIO_ID = v_diretorio_id,
											NOME_ARQUIVO = ListLast(origem, '/'));
						this.ins_historico_log(	COD_PROJETO			= arguments.cod_projeto,
												COD_APLICACAO		= arguments.cod_aplicacao,
												HISTORICO_ID		= retorno.historico_id,
												USUARIO				= ucase(session.usuario),
												NOME_ARQUIVO		= ListLast(origem, '/'),
												PASTA_INSTALACAO	= ListGetAt(v_arquivos, 3, '||'),
												COMENTARIO			= v_mensagem,
												DIR_ORIGEM			= "",
												DIR_DESTINO			= dir_destino,
												ULTIMA_MODIFICACAO	= ListGetAt(v_arquivos, 5, '||'),
												TAMANHO 			= ListGetAt(v_arquivos, 4, '||'),
												SINCRONIZADO		= iif(v_log.erro, de(0), de(1)));
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Arquivos sincronizados com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um log de sincronizacao de arquivo
	-- cristofer 16/08/2006 15:16:14 - CRIADO
	--->
	<cffunction name='ins_historico_log' displayname='Insere um log de sincronizacao de arquivo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='COD_PROJETO' required='yes'>
		<cfargument name='COD_APLICACAO' required='yes'>
		<cfargument name='HISTORICO_ID' required='yes'>
		<cfargument name='USUARIO' required='yes'>
		<cfargument name='NOME_ARQUIVO' required='yes'>
		<cfargument name='PASTA_INSTALACAO' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cfargument name='DIR_ORIGEM' required='yes'>
		<cfargument name='DIR_DESTINO' required='yes'>
		<cfargument name='ULTIMA_MODIFICACAO' required='yes'>
		<cfargument name='TAMANHO' required='yes'>
		<cfargument name='SINCRONIZADO' required='no' default="1">
				<cfstoredproc procedure='liveupdate.pkg_sincronizador.prc_ins_historico_log' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROJETO'  value='#arguments.COD_PROJETO#'  null='#iif(len(trim(arguments.COD_PROJETO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_APLICACAO'  value='#arguments.COD_APLICACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_HISTORICO_ID'  value='#arguments.HISTORICO_ID#'  null='#iif(len(trim(arguments.HISTORICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_ARQUIVO'  value='#arguments.NOME_ARQUIVO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PASTA_INSTALACAO'  value='#arguments.PASTA_INSTALACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DIR_ORIGEM'  value='#arguments.DIR_ORIGEM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DIR_DESTINO'  value='#arguments.DIR_DESTINO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ULTIMA_MODIFICACAO'  value='#arguments.ULTIMA_MODIFICACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAMANHO'  value='#arguments.TAMANHO#'  null='#iif(len(trim(arguments.TAMANHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SINCRONIZADO'  value='#arguments.SINCRONIZADO#'  null='#iif(len(trim(arguments.SINCRONIZADO)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere ou altera os dados do arquivo
	-- cristofer 17/08/2006 11:19:36 - CRIADO
	--->
	<cffunction name='ins_arquivo' displayname='Insere ou altera os dados do arquivo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DIRETORIO_ID' required='yes'>
		<cfargument name='NOME_ARQUIVO' required='yes'>
		<cfargument name='ASSINATURA' required='yes'>
		<cfargument name='TAMANHO' required='yes'>
		<cfargument name='DATA_ARQUIVO' required='yes'>
		<cfargument name='VERSAO' required='no' default="">
				<cfstoredproc procedure='liveupdate.pkg_arquivo.prc_ins_arquivo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIRETORIO_ID'  value='#arguments.DIRETORIO_ID#'  null='#iif(len(trim(arguments.DIRETORIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_ARQUIVO'  value='#arguments.NOME_ARQUIVO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ASSINATURA'  value='#arguments.ASSINATURA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAMANHO'  value='#arguments.TAMANHO#'  null='#iif(len(trim(arguments.TAMANHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ARQUIVO'  value='#arguments.DATA_ARQUIVO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VERSAO'  value='#arguments.VERSAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ARQUIVO_ID' variable='retorno.ARQUIVO_ID'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Exclui um arquivo
	-- cristofer 17/08/2006 11:19:36 - CRIADO
	--->
	<cffunction name='del_arquivo' displayname='Insere ou altera os dados do arquivo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DIRETORIO_ID' required='yes'>
		<cfargument name='NOME_ARQUIVO' required='yes'>
				<cfstoredproc procedure='liveupdate.pkg_arquivo.prc_del_arquivo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIRETORIO_ID'  value='#arguments.DIRETORIO_ID#'  null='#iif(len(trim(arguments.DIRETORIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_ARQUIVO'  value='#arguments.NOME_ARQUIVO#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca o id do diretorio
	-- CRISTOFER  17/08/2006
	--->		
	<cffunction name="get_diretorio_id" access="remote" returntype="string" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select liveupdate.pkg_arquivo.fnc_get_diretorio('#replace(arguments.diretorio&"/", "//","/","all")#') as diretorio
			  from dual
		</cfquery>
		<cfreturn qr_result.diretorio>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Fecha um historico de sincronizacao
	-- cristofer 18/08/2006 11:04:11 - CRIADO
	--->
	<cffunction name='fecha_historico' displayname='Fecha um historico de sincronizacao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='COD_PROJETO' required='yes'>
		<cfargument name='COD_APLICACAO' required='yes'>
		<cfargument name='HISTORICO_ID' required='yes'>
		<cfargument name='USUARIO' required='yes'>
		<cfargument name='GERA_VERSAO' required='no' default="0">
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='EMAIL_TECNICO' required="no" default="">
		<cfargument name="EMAIL" required="no" default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='liveupdate.pkg_sincronizador.prc_fecha_historico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROJETO'  value='#arguments.COD_PROJETO#'  null='#iif(len(trim(arguments.COD_PROJETO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_APLICACAO'  value='#arguments.COD_APLICACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_HISTORICO_ID'  value='#arguments.HISTORICO_ID#'  null='#iif(len(trim(arguments.HISTORICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FIM'  value='#LSDateFormat(now())# #TimeFormat(now(), "HH:MM:SS")#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GERA_VERSAO'  value='#arguments.GERA_VERSAO#'  null='#iif(len(trim(arguments.GERA_VERSAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfif arguments.gera_versao eq 1>
					<cfscript>
						conn = CreateObject("component", "_transportes.consulta.cfc_atualizador");
						qrVersao = conn.get_sincronizador_historico(cod_projeto 	= arguments.COD_PROJETO,
																	cod_aplicacao 	= arguments.COD_APLICACAO,
																	historico_id	= arguments.historico_id,
																	usuario			= arguments.usuario);
					</cfscript>
					<cfloop list="#arguments.email_tecnico#,#arguments.email#" index="v_email_id">
						<cfscript>
							this.ins_email_versao(	cod_projeto 	= arguments.COD_PROJETO,
													cod_aplicacao 	= arguments.COD_APLICACAO,
													v_major 		= qrVersao.v_major,
													v_minor			= qrVersao.v_minor,
													v_release 		= qrVersao.v_release,
													v_build 		= qrVersao.v_build,
													email_id 		= v_email_id);
						</cfscript>
					</cfloop>
					<cfset retorno.mensagem = JSStringFormat('Verso gerada com sucesso!')>
				<cfelse>
					<cfset retorno.mensagem = JSStringFormat('Historico finalizado sem gerar verso com sucesso!')>
				</cfif>
				<cfset retorno.erro = false>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere um email de notificao de versao
	-- cristofer 18/08/2006 15:44:08 - CRIADO
	--->
	<cffunction name='ins_email_versao' displayname='Insere um email de notificao de versao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='COD_PROJETO' required='yes'>
		<cfargument name='COD_APLICACAO' required='yes'>
		<cfargument name='V_MAJOR' required='yes'>
		<cfargument name='V_MINOR' required='yes'>
		<cfargument name='V_RELEASE' required='yes'>
		<cfargument name='V_BUILD' required='yes'>
		<cfargument name='EMAIL_ID' required='yes'>
				<cfstoredproc procedure='liveupdate.pkg_sincronizador.prc_ins_email_versao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROJETO'  value='#arguments.COD_PROJETO#'  null='#iif(len(trim(arguments.COD_PROJETO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_APLICACAO'  value='#arguments.COD_APLICACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_V_MAJOR'  value='#arguments.V_MAJOR#'  null='#iif(len(trim(arguments.V_MAJOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_V_MINOR'  value='#arguments.V_MINOR#'  null='#iif(len(trim(arguments.V_MINOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_V_RELEASE'  value='#arguments.V_RELEASE#'  null='#iif(len(trim(arguments.V_RELEASE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_V_BUILD'  value='#arguments.V_BUILD#'  null='#iif(len(trim(arguments.V_BUILD)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMAIL_ID'  value='#arguments.EMAIL_ID#'  null='#iif(len(trim(arguments.EMAIL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMAIL_VERSAO_ID' variable='retorno.EMAIL_VERSAO_ID'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um diretorio no servidor
	-- cristofer 21/08/2006 15:41:53 - CRIADO
	--->
	<cffunction name='ins_diretorio' displayname='Insere um diretorio no servidor' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DIRETORIO_PAI' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='liveupdate.pkg_arquivo.prc_ins_diretorio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIRETORIO_PAI'  value='#arguments.DIRETORIO_PAI#'  null='#iif(len(trim(arguments.DIRETORIO_PAI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIRETORIO_ID' variable='retorno.DIRETORIO_ID'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Diretorio criado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Altera um diretorio
	-- cristofer 22/08/2006 09:05:35 - CRIADO
	--->
	<cffunction name='upd_diretorio' displayname='Exclui um diretorio' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DIRETORIO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<!--- Tipos de arquivo --->
				<cfscript>
					v_cod_tipo_arquivo = this.ListaToArray (lista = arguments, variavel = "COD_TIPO_ARQUIVO_TIPOS");
					v_tipos = ArrayToList(v_cod_tipo_arquivo);
					conn = CreateObject("component","_transportes.consulta.cfc_atualizador");
					qrTipos = conn.get_arquivo_diretorio_tipo_arq(diretorio_id = arguments.diretorio_id);
				</cfscript>
				<cfoutput query="qrTipos">
					<cfif not listFind(v_tipos, qrTipos.cod_tipo_arquivo)>
						<cfscript>
							this.del_diretorio_tipo_arq(diretorio_id = arguments.diretorio_id,
														cod_tipo_arquivo = qrTipos.cod_tipo_arquivo);
						</cfscript>
					</cfif>
				</cfoutput>
				<cfloop from="1" to="#ArrayLen(v_cod_tipo_arquivo)#" index="count">
					<cfscript>
						this.ins_diretorio_tipo_arq(diretorio_id = arguments.diretorio_id,
													cod_tipo_arquivo = v_cod_tipo_arquivo[count]);
					</cfscript>
				</cfloop>				

				<!--- Aplicacoes --->
				<cfscript>
					v_cod_produto = this.ListaToArray (lista = arguments, variavel = "COD_PRODUTO_PRODUTOS");
					v_cod_projeto = this.ListaToArray (lista = arguments, variavel = "COD_PROJETO_PRODUTOS");
					v_cod_aplicacao = this.ListaToArray (lista = arguments, variavel = "COD_APLICACAO_PRODUTOS");
					v_sincronizar = this.ListaToArray (lista = arguments, variavel = "SINCRONIZAR_PRODUTOS");
					v_aplicacoes = ArrayToList(v_cod_produto);
					conn = CreateObject("component","_transportes.consulta.cfc_atualizador");
					qrAplicacoes = conn.get_aplicacao_diretorio(diretorio_id = arguments.diretorio_id);
				</cfscript>
				<cfoutput query="qrAplicacoes">
					<cfif not listFind(v_aplicacoes, qrAplicacoes.cod_projeto&"|"&qrAplicacoes.cod_aplicacao)>
						<cfscript>
							this.del_aplicacao_diretorio(diretorio_id = arguments.diretorio_id,
														 cod_projeto = qrAplicacoes.cod_projeto,
														 cod_aplicacao = qrAplicacoes.cod_aplicacao);
						</cfscript>
					</cfif>
				</cfoutput>
				<cfloop from="1" to="#ArrayLen(v_cod_produto)#" index="count">
					<cfscript>
						this.ins_aplicacao_diretorio(diretorio_id = arguments.diretorio_id,
													 cod_projeto = v_cod_projeto[count],
													 cod_aplicacao = v_cod_aplicacao[count],
													 sincronizar = v_sincronizar[count]);
					</cfscript>
				</cfloop>				

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Diretorio alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um diretorio
	-- cristofer 21/08/2006 16:50:35 - CRIADO
	--->
	<cffunction name='del_diretorio' displayname='Exclui um diretorio' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DIRETORIO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='liveupdate.pkg_arquivo.prc_del_diretorio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIRETORIO_ID'  value='#arguments.DIRETORIO_ID#'  null='#iif(len(trim(arguments.DIRETORIO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Diretorio excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere um tipo de arquivo para o diretorio
	-- cristofer 22/08/2006 09:13:38 - CRIADO
	--->
	<cffunction name='ins_diretorio_tipo_arq' displayname='Insere um tipo de arquivo para o diretorio' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DIRETORIO_ID' required='yes'>
		<cfargument name='COD_TIPO_ARQUIVO' required='yes'>
				<cfstoredproc procedure='liveupdate.pkg_arquivo.prc_ins_diretorio_tipo_arq' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIRETORIO_ID'  value='#arguments.DIRETORIO_ID#'  null='#iif(len(trim(arguments.DIRETORIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_TIPO_ARQUIVO'  value='#arguments.COD_TIPO_ARQUIVO#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um tipo de arquivo para o diretorio
	-- cristofer 22/08/2006 09:14:16 - CRIADO
	--->
	<cffunction name='del_diretorio_tipo_arq' displayname='Exclui um tipo de arquivo para o diretorio' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DIRETORIO_ID' required='yes'>
		<cfargument name='COD_TIPO_ARQUIVO' required='yes'>
				<cfstoredproc procedure='liveupdate.pkg_arquivo.prc_del_diretorio_tipo_arq' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIRETORIO_ID'  value='#arguments.DIRETORIO_ID#'  null='#iif(len(trim(arguments.DIRETORIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_TIPO_ARQUIVO'  value='#arguments.COD_TIPO_ARQUIVO#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um diretorio na aplicacao
	-- cristofer 22/08/2006 09:28:18 - CRIADO
	--->
	<cffunction name='ins_aplicacao_diretorio' displayname='Insere um diretorio na aplicacao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='COD_PROJETO' required='yes'>
		<cfargument name='COD_APLICACAO' required='yes'>
		<cfargument name='DIRETORIO_ID' required='yes'>
		<cfargument name='SINCRONIZAR' required='yes'>
				<cfstoredproc procedure='liveupdate.pkg_arquivo.prc_ins_aplicacao_diretorio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROJETO'  value='#arguments.COD_PROJETO#'  null='#iif(len(trim(arguments.COD_PROJETO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_APLICACAO'  value='#arguments.COD_APLICACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIRETORIO_ID'  value='#arguments.DIRETORIO_ID#'  null='#iif(len(trim(arguments.DIRETORIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SINCRONIZAR'  value='#arguments.SINCRONIZAR#'  null='#iif(len(trim(arguments.SINCRONIZAR)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um diretorio na aplicacao
	-- cristofer 22/08/2006 09:28:54 - CRIADO
	--->
	<cffunction name='del_aplicacao_diretorio' displayname='Exclui um diretorio na aplicacao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='COD_PROJETO' required='yes'>
		<cfargument name='COD_APLICACAO' required='yes'>
		<cfargument name='DIRETORIO_ID' required='yes'>
				<cfstoredproc procedure='liveupdate.pkg_arquivo.prc_del_aplicacao_diretorio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROJETO'  value='#arguments.COD_PROJETO#'  null='#iif(len(trim(arguments.COD_PROJETO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_APLICACAO'  value='#arguments.COD_APLICACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIRETORIO_ID'  value='#arguments.DIRETORIO_ID#'  null='#iif(len(trim(arguments.DIRETORIO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere uma aplicacao para atualizacao
	-- cristofer 28/08/2006 16:57:53 - CRIADO
	--->
	<cffunction name='ins_aplicacao_atualizacao' displayname='Insere uma aplicacao para atualizacao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='COD_PROJETO' required='yes'>
		<cfargument name='COD_APLICACAO' required='yes'>
		<cfargument name='PRODUTO' required='yes'>
		<cfargument name='ATIVO' required='yes'>
		<cfargument name='MENSAGEM' required='yes'>
		<cfargument name='SITE_PRODUTO' required='yes'>
		<cfargument name='ALTERA_SENHA' required='yes'>
		<cfargument name='USUARIO' required='yes'>
		<cfargument name='SENHA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='liveupdate.pkg_sincronizador.prc_ins_aplicacao_atualizacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROJETO'  value='#arguments.COD_PROJETO#'  null='#iif(len(trim(arguments.COD_PROJETO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_APLICACAO'  value='#arguments.COD_APLICACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PRODUTO'  value='#arguments.PRODUTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVO'  value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MENSAGEM'  value='#arguments.MENSAGEM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SITE_PRODUTO'  value='#arguments.SITE_PRODUTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTERA_SENHA'  value='#arguments.ALTERA_SENHA#'  null='#iif(len(trim(arguments.ALTERA_SENHA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SENHA'  value='#arguments.SENHA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produto inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma aplicacao para atualizacao
	-- cristofer 28/08/2006 16:57:53 - CRIADO
	--->
	<cffunction name='upd_aplicacao_atualizacao' displayname='Altera uma aplicacao para atualizacao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='COD_PROJETO' required='yes'>
		<cfargument name='COD_APLICACAO' required='yes'>
		<cfargument name='PRODUTO' required='yes'>
		<cfargument name='ATIVO' required='yes'>
		<cfargument name='MENSAGEM' required='yes'>
		<cfargument name='SITE_PRODUTO' required='yes'>
		<cfargument name='ALTERA_SENHA' required='yes'>
		<cfargument name='USUARIO' required='yes'>
		<cfargument name='SENHA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='liveupdate.pkg_sincronizador.prc_alt_aplicacao_atualizacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROJETO'  value='#arguments.COD_PROJETO#'  null='#iif(len(trim(arguments.COD_PROJETO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_APLICACAO'  value='#arguments.COD_APLICACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PRODUTO'  value='#arguments.PRODUTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVO'  value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MENSAGEM'  value='#arguments.MENSAGEM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SITE_PRODUTO'  value='#arguments.SITE_PRODUTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTERA_SENHA'  value='#arguments.ALTERA_SENHA#'  null='#iif(len(trim(arguments.ALTERA_SENHA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SENHA'  value='#arguments.SENHA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produto alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui uma aplicacao para atualizacao
	-- cristofer 28/08/2006 16:57:53 - CRIADO
	--->
	<cffunction name='del_aplicacao_atualizacao' displayname='Exclui uma aplicacao para atualizacao' access='remote' returntype='Struct' output='true'>;
		<cfargument name='COD_PROJETO' required='yes'>
		<cfargument name='COD_APLICACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='liveupdate.pkg_sincronizador.prc_del_aplicacao_atualizacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROJETO'  value='#arguments.COD_PROJETO#'  null='#iif(len(trim(arguments.COD_PROJETO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_APLICACAO'  value='#arguments.COD_APLICACAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produto excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere um email de atualizacao
	-- cristofer 04/09/2006 11:11:05 - CRIADO
	--->
	<cffunction name='ins_atualizacao_email' displayname='Insere um email de atualizacao' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PROJETO' required='yes'>
		<cfargument name='COD_APLICACAO' required='yes'>
		<cfargument name='EMAIL' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='liveupdate.pkg_sincronizador.prc_ins_atualizacao_email' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROJETO'  value='#arguments.COD_PROJETO#'  null='#iif(len(trim(arguments.COD_PROJETO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_APLICACAO'  value='#arguments.COD_APLICACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL'  value='#arguments.EMAIL#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMAIL_ID' variable='retorno.EMAIL_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Email inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um email de atualizacao
	-- cristofer 04/09/2006 11:12:18 - CRIADO
	--->
	<cffunction name='upd_atualizacao_email' displayname='Altera um email de atualizacao' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PROJETO' required='yes'>
		<cfargument name='COD_APLICACAO' required='yes'>
		<cfargument name='EMAIL_ID' required='yes'>
		<cfargument name='EMAIL' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='liveupdate.pkg_sincronizador.prc_alt_atualizacao_email' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROJETO'  value='#arguments.COD_PROJETO#'  null='#iif(len(trim(arguments.COD_PROJETO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_APLICACAO'  value='#arguments.COD_APLICACAO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMAIL_ID'  value='#arguments.EMAIL_ID#'  null='#iif(len(trim(arguments.EMAIL_ID)), de('no'), de('yes'))#' variable="retorno.email_id">
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL'  value='#arguments.EMAIL#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Email alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um email de atualizacao
	-- cristofer 04/09/2006 11:12:56 - CRIADO
	--->
	<cffunction name='del_atualizacao_email' displayname='Exclui um email de atualizacao' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PROJETO' required='yes'>
		<cfargument name='COD_APLICACAO' required='yes'>
		<cfargument name='EMAIL_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='liveupdate.pkg_sincronizador.prc_del_atualizacao_email' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROJETO'  value='#arguments.COD_PROJETO#'  null='#iif(len(trim(arguments.COD_PROJETO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_APLICACAO'  value='#arguments.COD_APLICACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMAIL_ID'  value='#arguments.EMAIL_ID#'  null='#iif(len(trim(arguments.EMAIL_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Email excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Atualiza o status de um email de atualizacao
	-- cristofer 04/09/2006 14:34:40 - CRIADO
	--->
	<cffunction name='upd_email_versao' displayname='Atualiza o status de um email de atualizacao' access='remote' returntype='Struct' output='true'>
		<cfargument name='EMAIL_VERSAO_ID' required='yes'>
		<cfargument name='ENVIADO' required='yes'>
		<cfargument name='ERRO' required='yes'>
		<cfargument name='MENSAGEM_ERRO' required='yes'>
		<cftry>
			<cftransaction action='begin'>		
				<cfstoredproc procedure='liveupdate.pkg_sincronizador.prc_upd_email_versao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMAIL_VERSAO_ID'  value='#arguments.EMAIL_VERSAO_ID#'  null='#iif(len(trim(arguments.EMAIL_VERSAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENVIADO'  value='#arguments.ENVIADO#'  null='#iif(len(trim(arguments.ENVIADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ERRO'  value='#arguments.ERRO#'  null='#iif(len(trim(arguments.ERRO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MENSAGEM_ERRO'  value='#arguments.MENSAGEM_ERRO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('E-mail atualizado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Atualiza todos os tecnicos da aplicacao
	-- cristofer 05/09/2006 09:34:40 - CRIADO
	--->
	<cffunction name='upd_aplicacao_tecnicos' displayname='Atualiza o status de um email de atualizacao' access='remote' returntype='Struct' output='true'>
		<cfargument name="cod_projeto" required="yes">
		<cfargument name="cod_aplicacao" required="yes">
		<cftry>
			<cftransaction action='begin'>		
				<cfscript>
					v_usuario = this.ListaToArray (lista = arguments, variavel = "USUARIO_USUARIOS");
					v_usuario_old = this.ListaToArray (lista = arguments, variavel = "USUARIO_OLD_USUARIOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_USUARIOS, lista2 = ArrayToList(v_usuario, ','));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_usuario">
					<cfscript>
						this.del_aplicacao_tecnico (cod_projeto = arguments.cod_projeto,
													cod_aplicacao = arguments.cod_aplicacao,
													usuario = l_usuario);
					</cfscript>
				</cfloop>			
				<cfloop from="1" to="#ArrayLen(v_usuario)#" index="count">
					<cfscript>
					if(not len(trim(v_usuario_old[count]))) {
						this.ins_aplicacao_tecnico(cod_projeto = arguments.cod_projeto,
													cod_aplicacao = arguments.cod_aplicacao,
													usuario = v_usuario[count]);
					} else {
						this.upd_aplicacao_tecnico(cod_projeto = arguments.cod_projeto,
													cod_aplicacao = arguments.cod_aplicacao,
													usuario = v_usuario[count],
													usuario_old = v_usuario_old[count]);
					}
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tecnicos atualizados com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Insere um tecnico para a aplicacao
	-- cristofer 05/09/2006 09:20:42 - CRIADO
	--->
	<cffunction name='ins_aplicacao_tecnico' displayname='Insere um tecnico para a aplicacao' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PROJETO' required='yes'>
		<cfargument name='COD_APLICACAO' required='yes'>
		<cfargument name='USUARIO' required='yes'>
				<cfstoredproc procedure='liveupdate.pkg_sincronizador.prc_ins_aplicacao_tecnico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROJETO'  value='#arguments.COD_PROJETO#'  null='#iif(len(trim(arguments.COD_PROJETO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_APLICACAO'  value='#arguments.COD_APLICACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Edita um tecnico para a aplicacao
	-- cristofer 05/09/2006 09:21:24 - CRIADO
	--->
	<cffunction name='upd_aplicacao_tecnico' displayname='Edita um tecnico para a aplicacao' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PROJETO' required='yes'>
		<cfargument name='COD_APLICACAO' required='yes'>
		<cfargument name='USUARIO' required='yes'>
		<cfargument name='USUARIO_OLD' required='yes'>
				<cfstoredproc procedure='liveupdate.pkg_sincronizador.prc_alt_aplicacao_tecnico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROJETO'  value='#arguments.COD_PROJETO#'  null='#iif(len(trim(arguments.COD_PROJETO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_APLICACAO'  value='#arguments.COD_APLICACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO_OLD'  value='#arguments.USUARIO_OLD#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um tecnico para a aplicacao
	-- cristofer 05/09/2006 09:21:55 - CRIADO
	--->
	<cffunction name='del_aplicacao_tecnico' displayname='Exclui um tecnico para a aplicacao' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PROJETO' required='yes'>
		<cfargument name='COD_APLICACAO' required='yes'>
		<cfargument name='USUARIO' required='yes'>
				<cfstoredproc procedure='liveupdate.pkg_sincronizador.prc_del_aplicacao_tecnico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROJETO'  value='#arguments.COD_PROJETO#'  null='#iif(len(trim(arguments.COD_PROJETO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_APLICACAO'  value='#arguments.COD_APLICACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere uma copia
	-- cristofer 06/09/2006 15:02:46 - CRIADO
	--->
	<cffunction name='ins_copia' displayname='Insere uma copia' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_SERIE' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='COD_PROJETO' required='yes'>
		<cfargument name='COD_APLICACAO' required='yes'>
		<cfargument name='DATA_INSTALACAO' required='yes'>
		<cfargument name='DIREITO_USO' required='no' default="0">
		<cfargument name='ATUALIZACAO' required='no' default="0">
		<cfargument name='USUARIO' required='yes'>
		<cfargument name='SENHA' required='yes'>
		<cfargument name='USUARIO_ADMINISTRADOR' required='yes'>
		<cfargument name='SENHA_ADMINISTRADOR' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='liveupdate.pkg_sincronizador.prc_ins_copia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_SERIE'  value='#replace(arguments.NUM_SERIE,'-','','all')#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROJETO'  value='#arguments.COD_PROJETO#'  null='#iif(len(trim(arguments.COD_PROJETO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_APLICACAO'  value='#arguments.COD_APLICACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INSTALACAO'  value='#arguments.DATA_INSTALACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIREITO_USO'  value='#arguments.DIREITO_USO#'  null='#iif(len(trim(arguments.DIREITO_USO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATUALIZACAO'  value='#arguments.ATUALIZACAO#'  null='#iif(len(trim(arguments.ATUALIZACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SENHA'  value='#arguments.SENHA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO_ADMINISTRADOR'  value='#arguments.USUARIO_ADMINISTRADOR#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SENHA_ADMINISTRADOR'  value='#arguments.SENHA_ADMINISTRADOR#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Copia inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma copia
	-- cristofer 06/09/2006 15:03:33 - CRIADO
	--->
	<cffunction name='del_copia' displayname='Exclui uma copia' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_SERIE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='liveupdate.pkg_sincronizador.prc_del_copia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_SERIE'  value='#arguments.NUM_SERIE#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Copia excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>