<cfcomponent>
	<!--- 
	-- PROPSITO
	-- Insere um atendimento
	-- cristofer 31/05/2006 09:19:02 - CRIADO
	--->
	<cffunction name='ins_atendimento' displayname='Insere um atendimento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='APLICACAO_ID' required='yes'>
		<cfargument name='USUARIO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_atendimento.prc_ins_atendimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICACAO_ID'  value='#arguments.APLICACAO_ID#'  null='#iif(len(trim(arguments.APLICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATENDIMENTO_ID' variable='retorno.ATENDIMENTO_ID'  >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atendimento inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um atendimento
	-- cristofer 31/05/2006 09:19:53 - CRIADO
	--->
	<cffunction name='upd_atendimento' displayname='Altera um atendimento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ATENDIMENTO_ID' required='yes'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='APLICACAO_ID' required='yes'>
		<cfargument name='USUARIO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_atendimento.prc_alt_atendimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATENDIMENTO_ID'  value='#arguments.ATENDIMENTO_ID#'  null='#iif(len(trim(arguments.ATENDIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICACAO_ID'  value='#arguments.APLICACAO_ID#'  null='#iif(len(trim(arguments.APLICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atendimento alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera a situacao de um atendimento
	-- cristofer 31/05/2006 09:23:48 - CRIADO
	--->
	<cffunction name='situacao_atendimento' displayname='Altera a situacao de um atendimento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ATENDIMENTO_ID' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_atendimento.prc_set_situacao_atendimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATENDIMENTO_ID'  value='#arguments.ATENDIMENTO_ID#'  null='#iif(len(trim(arguments.ATENDIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atendimento alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma mensagem no atendimento
	-- cristofer 31/05/2006 09:25:17 - CRIADO
	--->
	<cffunction name='ins_atendimento_mensagem' displayname='Insere uma mensagem no atendimento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ATENDIMENTO_ID' required='yes'>
		<cfargument name='MENSAGEM' required='yes'>
		<cfargument name='TIPO_ID' required='no' default="1">
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_atendimento.prc_ins_atendimento_mensagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATENDIMENTO_ID'  value='#arguments.ATENDIMENTO_ID#'  null='#iif(len(trim(arguments.ATENDIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MENSAGEM'  value='#arguments.MENSAGEM#'  null='#iif(len(trim(arguments.MENSAGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_INTEGER' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MENSAGEM_ID' variable='retorno.MENSAGEM_ID'  >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Mensagem inserida com sucesso!')>
			</cftransaction>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera o status do usuario no atendimento
	-- cristofer 31/05/2006 09:26:16 - CRIADO
	--->
	<cffunction name='status_atendimento' displayname='Altera o status do usuario no atendimento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ATENDIMENTO_ID' required='yes'>
		<cfargument name='DIGITANDO' required='yes'>
		<cfargument name='REFRESH' required='yes'>
		<cfargument name='MENSAGEM_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_atendimento.prc_set_atendimento_status' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATENDIMENTO_ID'  value='#arguments.ATENDIMENTO_ID#'  null='#iif(len(trim(arguments.ATENDIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIGITANDO'  value='#arguments.DIGITANDO#'  null='#iif(len(trim(arguments.DIGITANDO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REFRESH'  value='#arguments.REFRESH#'  null='#iif(len(trim(arguments.REFRESH)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MENSAGEM_ID'  value='#arguments.MENSAGEM_ID#'  null='#iif(len(trim(arguments.MENSAGEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Status alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!------------------------------------------------------------------------------------------>	
	<!------------------------------------------------------------------------------------------>	
	<!----------------------------- SOLICITACAO DE ATENDIMENTO --------------------------------->
	<!------------------------------------------------------------------------------------------>	
	<!------------------------------------------------------------------------------------------>	

	<!--- 
	-- PROPSITO
	-- Insere solicitao de atendimento
	-- guto 10/03/2007 11:55:07 - CRIADO
	--->
	<cffunction name='ins_solicitacao' displayname='Insere solicitao de atendimento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='FILIAL' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='FORMA_ID' required='yes'>
		<cfargument name='PLATAFORMA_ID' required='yes'>
		<cfargument name='COD_MENU' required='yes'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='TEXTO' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm_atendimento.pkg_suporte.prc_ins_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FILIAL'  value='#arguments.FILIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECURSO_ID'  value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORMA_ID'  value='#arguments.FORMA_ID#'  null='#iif(len(trim(arguments.FORMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PLATAFORMA_ID'  value='#arguments.PLATAFORMA_ID#'  null='#iif(len(trim(arguments.PLATAFORMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_MENU'  value='#arguments.COD_MENU#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_TEXTO'  value='#arguments.TEXTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLICITACAO_ID' variable='retorno.SOLICITACAO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitao inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
</cfcomponent>