<cfcomponent extends="_transportes.funcoes.cfc_init">

<cffunction name="ins_contato" displayname="Insere um novo contato na agenda" access="remote" returntype="Struct" output="true">
   <!--- -
   	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 22/07/2005 - criado
	--->			
	<cfargument name="nome" required="yes">
	<cfargument name="sobrenome" required="yes">
	<cfargument name="apelido" required="yes">
	<cfargument name="particular" required="no" default="0">
	<cfargument name="empresa" required="yes">
	<cfargument name="cargo" required="yes">
	<cfargument name="url" required="yes">
	<cfargument name="foto" required="no" default="">

	<cfargument name="telefone_id" required="no" default="">
	<cfargument name="telefone" required="no" default="">
	<cfargument name="ramal_fone" required="no" default="">
	<cfargument name="TELEFONE_PADRAO" required="no" default="">
	<cfargument name="tipo_telefone" required="no" default="">
	<cfargument name="observacao" required="no" default="">	

	<cfargument name="email_id" required="no" default="">
	<cfargument name="endereco_email" required="no" default="">
	<cfargument name="email_padrao" required="no" default="">

	<cfargument name="msn_id" required="no" default="">
	<cfargument name="tipo_messenger" required="no" default="">
	<cfargument name="messenger" required="no" default="">
	<cfargument name="messenger_padrao" required="no" default="">

	<cfargument name="endereco_id" required="no" default="">	
	<cfargument name="endere" required="no" default="">	
	<cfargument name="end_tipo" required="no" default="">	
	<cfargument name="municipio" required="no" default="">	
	<cfargument name="end_corresp" required="no" default="">	
	<cfargument name="end_padrao" required="no" default="">	
	<cfargument name="cep_end" required="no" default="">	
	<cftry>
		<cftransaction action="begin">
			<cfset vFoto = "">
			<cfif len(trim(arguments.foto))>
				<cffile action="readbinary"
						file="#arguments.foto#"
						variable="vFoto">
			</cfif>
			<cfstoredproc procedure="contatos.pkg_contatos.prc_ins_contato" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_nome" type="in" value="#arguments.nome#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_sobrenome" type="in" value="#arguments.sobrenome#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_apelido" type="in" value="#arguments.apelido#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_particular" type="in" value="#arguments.particular#" cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_cargo" type="in" value="#arguments.cargo#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_empresa" type="in" value="#arguments.empresa#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_url" type="in" value="#arguments.url#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_foto" type="in" value="#vFoto#" cfsqltype="cf_sql_blob" null="#iif(len(trim(arguments.foto)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="p_contato_id" type="out" variable="retorno.contato_id" cfsqltype="cf_sql_integer">
			</cfstoredproc>							
			<cfset arguments.contato_id = retorno.contato_id>
			<cfscript>
			//Exclui os emails do contato
				this.del_email_contato(contato_id = arguments.contato_id, lista_email_id = arguments.email_id);
			</cfscript>							
			<cfset pos = 1>
			<cfloop list="#arguments.email_id#" index="v_email_id">
				<cfscript>
				//Insere e altera os email do contato
					retorno.erro_email = this.ins_email_contato(contato_id = arguments.contato_id,
															   email = ListGetAt(arguments.endereco_email, pos, ','),
															   principal = ListGetAt(arguments.email_padrao, pos, ','));
					pos = pos + 1;
				</cfscript>
				
			</cfloop>
			<cfscript>
			//
				this.del_telefone_contato(contato_id = arguments.contato_id, lista_telefone_id = arguments.telefone_id);
			</cfscript>							
			<cfset pos = 1>
			<cfloop list="#arguments.telefone_id#" index="v_telefone_id">
				<cfscript>
					retorno.erro_fone = this.ins_telefone_contato(contato_id = arguments.contato_id,
																  telefone_tipo = ListGetAt(arguments.tipo_telefone, pos, ','),
																  telefone = ListGetAt(arguments.telefone, pos, ','),
																  ramal = ListGetAt(arguments.ramal_fone, pos, ','),
																  principal = ListGetAt(arguments.telefone_padrao, pos, ','),
																  observacao = trim(ListGetAt(arguments.observacao, pos, '|,|')));
					pos = pos + 1;
				</cfscript>
				
			</cfloop>
			<cfscript>
			//
				this.del_msg_contato(contato_id = arguments.contato_id, lista_telefone_id = arguments.telefone_id);
			</cfscript>							
			<cfset pos = 1>
			<cfloop list="#arguments.msn_id#" index="v_msn_id">
				<cfscript>
					retorno.erro_msn = this.ins_msg_contato(contato_id = arguments.contato_id,
															 tipo = ListGetAt(arguments.tipo_messenger, pos, ','),
															 usuario = ListGetAt(arguments.messenger, pos, ','),
  														     principal = ListGetAt(arguments.messenger_padrao, pos, ','));
					pos = pos + 1;
				</cfscript>
				
			</cfloop>
			<cfscript>
			//
				this.del_endereco_contato(contato_id = arguments.contato_id);
			</cfscript>							
			<cfset pos = 1>
			<cfloop list="#arguments.endereco_id#" index="v_endereco_id">
				<cfscript>
					if(ListGetAt(arguments.endere, pos, ',') neq 0) {
						v_endereco = ListGetAt(arguments.endere, pos, ',');
					} else {
						v_endereco = '';
					}
					if(ListGetAt(arguments.cep_end, pos, ',') neq 0) {
						v_cep = ListGetAt(arguments.cep_end, pos, ',');
					} else {
						v_cep = '';
					}
					retorno.erro_endereco = this.ins_endereco_contato(contato_id = arguments.contato_id,
															 		  endereco = v_endereco, //replace(trim(replace(ListGetAt(arguments.endere, pos, '|,|'), '|', '', 'ALL')), "%", ",", 'ALL'),
																	  endereco_tipo = ListGetAt(arguments.end_tipo, pos, ','),
																	  cep = v_cep,
																	  municipio_id = ListGetAt(arguments.municipio, pos, ','),
																	  correspondencia = ListGetAt(arguments.end_corresp, pos, ','),
 		 														      principal = ListGetAt(arguments.end_padrao, pos, ','));
					pos = pos + 1;
				</cfscript>
				
			</cfloop>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Contato inserido com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback" />
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>
<cffunction name="upd_contato" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 22/07/2005 - criado
	--->			
	<cfargument name="contato_id" required="yes">
	<cfargument name="nome" required="yes">
	<cfargument name="sobrenome" required="yes">
	<cfargument name="apelido" required="yes">
	<cfargument name="particular" required="no" default="0">
	<cfargument name="empresa" required="yes">
	<cfargument name="cargo" required="yes">
	<cfargument name="url" required="yes">
	<cfargument name="foto" required="no" default="">
	
	<cfargument name="telefone_id" required="no" default="">
	<cfargument name="telefone" required="no" default="">
	<cfargument name="ramal_fone" required="no" default="">
	<cfargument name="TELEFONE_PADRAO" required="no" default="">
	<cfargument name="tipo_telefone" required="no" default="">
	<cfargument name="observacao" required="no" default="">	
	
	<cfargument name="email_id" required="no" default="">
	<cfargument name="endereco_email" required="no" default="">
	<cfargument name="email_padrao" required="no" default="">
	
	<cfargument name="msn_id" required="no" default="">
	<cfargument name="tipo_messenger" required="no" default="">
	<cfargument name="messenger" required="no" default="">
	<cfargument name="messenger_padrao" required="no" default="">

	<cfargument name="endereco_id" required="no" default="">	
	<cfargument name="endere" required="no" default="">	
	<cfargument name="end_tipo" required="no" default="">	
	<cfargument name="municipio" required="no" default="">	
	<cfargument name="end_corresp" required="no" default="">	
	<cfargument name="end_padrao" required="no" default="">	
	<cfargument name="cep_end" required="no" default="">	
	
	<cftry>
		<cftransaction action="begin">      	
			<cfset vFoto = "">
			<cfif len(trim(arguments.foto))>         	
				<cffile action="readbinary" file="#arguments.foto#" variable="vFoto">
			</cfif>
			<cfstoredproc procedure="contatos.pkg_contatos.prc_alt_contato" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_contato_id" type="in" value="#arguments.contato_id#" cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_nome" type="in" value="#arguments.nome#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_sobrenome" type="in" value="#arguments.sobrenome#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_apelido" type="in" value="#arguments.apelido#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_particular" type="in" value="#arguments.particular#" cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_cargo" type="in" value="#arguments.cargo#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_empresa" type="in" value="#arguments.empresa#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_url" type="in" value="#arguments.url#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_foto" type="in" value="#vFoto#" cfsqltype="cf_sql_blob" null="#iif(len(trim(arguments.foto)), de('no'), de('yes'))#">
         </cfstoredproc>
			<cfscript>
			//Exclui os emails do contato
				this.del_email_contato(contato_id = arguments.contato_id, lista_email_id = arguments.email_id);
			</cfscript>							
			<cfset pos = 1>
			<cfloop list="#arguments.email_id#" index="v_email_id">
				<cfscript>
				//Insere e altera os email do contato
					retorno.erro_email = this.ins_email_contato(contato_id = arguments.contato_id,
															   email = ListGetAt(arguments.endereco_email, pos, ','),
															   principal = ListGetAt(arguments.email_padrao, pos, ','));
					pos = pos + 1;
				</cfscript>
				
			</cfloop>
			<cfscript>
			//
				this.del_telefone_contato(contato_id = arguments.contato_id, lista_telefone_id = arguments.telefone_id);
			</cfscript>							
			<cfset pos = 1>
			<cfloop list="#arguments.telefone_id#" index="v_telefone_id">
				<cfscript>
					retorno.erro_fone = this.ins_telefone_contato(contato_id = arguments.contato_id,
																  telefone_tipo = ListGetAt(arguments.tipo_telefone, pos, ','),
																  telefone = ListGetAt(arguments.telefone, pos, ','),
																  ramal = ListGetAt(arguments.ramal_fone, pos, ','),
																  principal = ListGetAt(arguments.telefone_padrao, pos, ','),
																  observacao = trim(ListGetAt(arguments.observacao, pos, '|,|')));
					pos = pos + 1;
				</cfscript>
				
			</cfloop>
			<cfscript>
			//
				this.del_msg_contato(contato_id = arguments.contato_id, lista_telefone_id = arguments.telefone_id);
			</cfscript>							
			<cfset pos = 1>
			<cfloop list="#arguments.msn_id#" index="v_msn_id">
				<cfscript>
					retorno.erro_msn = this.ins_msg_contato(contato_id = arguments.contato_id,
															 tipo = ListGetAt(arguments.tipo_messenger, pos, ','),
															 usuario = ListGetAt(arguments.messenger, pos, ','),
  														     principal = ListGetAt(arguments.messenger_padrao, pos, ','));
					pos = pos + 1;
				</cfscript>
				
			</cfloop>
			<cfscript>
			//
				this.del_endereco_contato(contato_id = arguments.contato_id);
			</cfscript>							
			<cfset pos = 1>
			<cfloop list="#arguments.endereco_id#" index="v_endereco_id">
				<cfscript>
					if(ListGetAt(arguments.endere, pos, ',') neq 0) {
						v_endereco = ListGetAt(arguments.endere, pos, ',');
					} else {
						v_endereco = '';
					}
					if(ListGetAt(arguments.cep_end, pos, ',') neq 0) {
						v_cep = ListGetAt(arguments.cep_end, pos, ',');
					} else {
						v_cep = '';
					}
					retorno.erro_endereco = this.ins_endereco_contato(contato_id = arguments.contato_id,
															 		  endereco = v_endereco,//replace(trim(replace(ListGetAt(arguments.endere, pos, '|,|'), '|', '', 'ALL')), "%", ",", 'ALL'),
																	  endereco_tipo = ListGetAt(arguments.end_tipo, pos, ','),
																	  cep = v_cep,
																	  municipio_id = ListGetAt(arguments.municipio, pos, ','),
																	  correspondencia = ListGetAt(arguments.end_corresp, pos, ','),
 		 														      principal = ListGetAt(arguments.end_padrao, pos, ','));
					pos = pos + 1;
				</cfscript>
			</cfloop>

			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Contato alterado com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>
<cffunction name="ins_telefone_contato" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 22/07/2005 - criado
	--->			
	<cfargument name="contato_id" required="yes">
	<cfargument name="telefone" required="yes">
	<cfargument name="ramal" required="yes">
	<cfargument name="principal" required="yes">
	<cfargument name="telefone_tipo" required="yes">
	<cfargument name="observacao" required="yes">
		<cfstoredproc procedure="contatos.pkg_contatos.prc_ins_contato_telefone" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_contato_id" type="in" value="#arguments.contato_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_telefone_tipo" type="in" value="#arguments.telefone_tipo#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_telefone" type="in" value="#arguments.telefone#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_ramal" type="in" value="#removechars(arguments.ramal, 1, 1)#" cfsqltype="cf_sql_varchar" null="#iif(arguments.RAMAL eq 0, de('yes'), de('no'))#">
			<cfprocparam dbvarname="p_observacao" type="in" value="#arguments.observacao#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_principal" type="in" value="#arguments.principal#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_telefone_id" type="out" variable="retorno.telefone_id" cfsqltype="cf_sql_integer">
		</cfstoredproc>							
	<cfreturn retorno />		
</cffunction>
<cffunction name="del_telefone_contato" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 22/07/2005 - criado
	--->			
	<cfargument name="contato_id" required="yes">
	<cfargument name="telefone_id" required="no" default="">
	<cfargument name="lista_telefone_id" required="no" default="">
		<cfstoredproc procedure="contatos.pkg_contatos.prc_del_contato_telefone" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_contato_id" type="in" value="#arguments.contato_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_telefone_id" type="in" value="#arguments.telefone_id#" cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.telefone_id)), de('no'), de('yes'))#">
			<cfprocparam dbvarname="p_lista_telefone_id" type="in" value="#arguments.lista_telefone_id#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>							
		
	<cfreturn StructNew() />		
</cffunction>
<cffunction name="ins_email_contato" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 22/07/2005 - criado
	--->			
	<cfargument name="contato_id" required="yes">
	<cfargument name="email" required="yes">
	<cfargument name="principal" required="no" default="0">
		<cfstoredproc procedure="contatos.pkg_contatos.prc_ins_contato_email" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_contato_id" type="in" value="#arguments.contato_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_email" type="in" value="#arguments.email#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_principal" type="in" value="#arguments.principal#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_email_id" type="out" variable="retorno.email_id" cfsqltype="cf_sql_integer">
		</cfstoredproc>							
	<cfreturn retorno />		
</cffunction>
<cffunction name="del_email_contato" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 22/07/2005 - criado
	--->			
	<cfargument name="contato_id" required="yes">
	<cfargument name="email_id" required="no" default="">
	<cfargument name="lista_email_id" required="no" default="">
		<cfstoredproc procedure="contatos.pkg_contatos.prc_del_contato_email" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_contato_id" type="in" value="#arguments.contato_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_email_id" type="in" value="#arguments.email_id#" cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.email_id)), de('no'), de('yes'))#">
			<cfprocparam dbvarname="p_lista_email_id" type="in" value="#arguments.lista_email_id#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>							
		
	<cfreturn StructNew() />		
</cffunction>
<cffunction name="ins_msg_contato" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 22/07/2005 - criado
	--->			
	<cfargument name="contato_id" required="yes">
	<cfargument name="usuario" required="yes">
	<cfargument name="tipo" required="yes">
	<cfargument name="principal" required="no" default="0">
		<cfstoredproc procedure="contatos.pkg_contatos.prc_ins_contato_msg_inst" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_contato_id" type="in" value="#arguments.contato_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_tipo" type="in" value="#arguments.tipo#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_usuario" type="in" value="#arguments.usuario#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_principal" type="in" value="#arguments.principal#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_msg_instantanea_id" type="out" variable="retorno.msg_instantanea_id" cfsqltype="cf_sql_integer">
		</cfstoredproc>							
	<cfreturn retorno />		
</cffunction>
<cffunction name="del_msg_contato" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 22/07/2005 - criado
	--->			
	<cfargument name="contato_id" required="yes">
	<cfargument name="msg_instantanea_id" required="no" default="">
	<cfargument name="lista_msg_instantanea_id" required="no" default="">
		<cfstoredproc procedure="contatos.pkg_contatos.prc_del_contato_msg_inst" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_contato_id" type="in" value="#arguments.contato_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_msg_instantanea_id" type="in" value="#arguments.msg_instantanea_id#" cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.msg_instantanea_id)), de('no'), de('yes'))#">
			<cfprocparam dbvarname="p_lista_msg_instantanea_id" type="in" value="#arguments.lista_msg_instantanea_id#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>							
		
	<cfreturn StructNew() />		
</cffunction>
<cffunction name="ins_endereco_contato" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 22/07/2005 - criado
	--->			
	<cfargument name="contato_id" required="yes">
	<cfargument name="endereco" required="yes">
	<cfargument name="endereco_tipo" required="yes">
	<cfargument name="cep" required="yes">
	<cfargument name="municipio_id" required="yes">
	<cfargument name="correspondencia" required="yes">
	<cfargument name="principal" required="no" default="0">

		<cfstoredproc procedure="contatos.pkg_contatos.prc_ins_contato_endereco" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_contato_id" type="in" value="#arguments.contato_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_endereco" type="in" value="#arguments.endereco#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_endereco_tipo" type="in" value="#arguments.endereco_tipo#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_cep" type="in" value="#arguments.cep#" cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.cep)), de('no'), de('yes'))#">
			<cfprocparam dbvarname="p_municipio_id" type="in" value="#arguments.municipio_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_correspondencia" type="in" value="#arguments.correspondencia#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_principal" type="in" value="#arguments.principal#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_endereco_id" type="out" variable="retorno.endereco_id" cfsqltype="cf_sql_integer">
		</cfstoredproc>							
	<cfreturn retorno />		
</cffunction>
<cffunction name="del_endereco_contato" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 22/07/2005 - criado
	--->			
	<cfargument name="contato_id" required="yes">
	<cfargument name="endereco_id" required="no" default="">
	<cfargument name="lista_endereco_id" required="no" default="">
		<cfstoredproc procedure="contatos.pkg_contatos.prc_del_contato_endereco" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_contato_id" type="in" value="#arguments.contato_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_endereco_id" type="in" value="#arguments.endereco_id#" cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.endereco_id)), de('no'), de('yes'))#">
			<cfprocparam dbvarname="p_lista_endereco_id" type="in" value="#arguments.lista_endereco_id#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>							
		
	<cfreturn StructNew() />		
</cffunction>
<cffunction name="del_foto_contato" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 22/07/2005 - criado
	--->			
	<cfargument name="contato_id" required="yes">
	<cftry>
		<cfstoredproc procedure="contatos.pkg_contatos.prc_del_foto_contato" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_contato_id" type="in" value="#arguments.contato_id#" cfsqltype="cf_sql_integer">
		</cfstoredproc>							
			<cfset retorno.erro = false>
		<cfcatch>
			<cfset retorno.erro = true>
		</cfcatch>
	</cftry>	
	<cfreturn retorno/>
</cffunction>
<cffunction name="del_contato" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 22/07/2005 - criado
	--->			
	<cfargument name="contato_id" required="yes">
	<cftry>
		<cfstoredproc procedure="contatos.pkg_contatos.prc_del_contato" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_contato_id" type="in" value="#arguments.contato_id#" cfsqltype="cf_sql_integer">
		</cfstoredproc>							
			<cfset retorno.erro = false>
			<cfset retorno.erro = true>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Contato excluido com sucesso!")>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>	
	<cfreturn retorno/>
</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere um tipo de evento
	-- cristofer 17/04/2006 13:27:25 - CRIADO
	--->
	<cffunction name='ins_evento_tipo' displayname='Insere um tipo de evento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='contatos.pkg_contatos.prc_ins_evento_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID' variable='retorno.TIPO_ID'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera um tipo de evento
	-- cristofer 17/04/2006 13:28:11 - CRIADO
	--->
	<cffunction name='upd_evento_tipo' displayname='Altera um tipo de evento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='contatos.pkg_contatos.prc_alt_evento_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui um tipo de evento
	-- cristofer 17/04/2006 13:28:59 - CRIADO
	--->
	<cffunction name='del_evento_tipo' displayname='Exclui um tipo de evento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TIPO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='contatos.pkg_contatos.prc_del_evento_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere um novo evento
	-- cristofer 17/04/2006 13:53:26 - CRIADO
	--->
	<cffunction name='ins_evento' displayname='Insere um novo evento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='LOCAL' required='yes'>
		<cfargument name='DETALHES' required='yes'>
		<cfargument name='DATA_HORA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='contatos.pkg_contatos.prc_ins_evento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LOCAL'  value='#arguments.LOCAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DETALHES'  value='#arguments.DETALHES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_TIMESTAMP' dbvarname='P_DATA_HORA'  value='#DateFormat(arguments.DATA_HORA, "dd/mm/yyyy")# #TimeFormat(arguments.DATA_HORA, "HH:MM:ss")#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EVENTO_ID' variable='retorno.EVENTO_ID'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Evento inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um novo evento
	-- cristofer 17/04/2006 13:54:55 - CRIADO
	--->
	<cffunction name='upd_evento' displayname='Altera um novo evento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='EVENTO_ID' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='LOCAL' required='yes'>
		<cfargument name='DETALHES' required='yes'>
		<cfargument name='DATA_HORA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='contatos.pkg_contatos.prc_alt_evento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EVENTO_ID'  value='#arguments.EVENTO_ID#'  null='#iif(len(trim(arguments.EVENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LOCAL'  value='#arguments.LOCAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DETALHES'  value='#arguments.DETALHES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_TIMESTAMP' dbvarname='P_DATA_HORA'  value='#DateFormat(arguments.DATA_HORA, "dd/mm/yyyy")# #TimeFormat(arguments.DATA_HORA, "HH:MM:ss")#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Evento alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um novo evento
	-- cristofer 17/04/2006 13:55:30 - CRIADO
	--->
	<cffunction name='del_evento' displayname='Exclui um novo evento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='EVENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='contatos.pkg_contatos.prc_del_evento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EVENTO_ID'  value='#arguments.EVENTO_ID#'  null='#iif(len(trim(arguments.EVENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Evento excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	
</cfcomponent>