<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulao da rea de administrao" extends="_transportes.funcoes.cfc_init">
<!--- 
-- PROPSITO 
-- Seta os Parametros da gestao atual
-- CRISTOFER  28/12/2005
--->
<cffunction name="set_altera_gestao" displayname="Altera a gesto da modalidade passada" access="remote" returntype="struct" output="true">
	<!-- Postos -->
	<cfargument name="modalidade" 					required="yes">
	<cfargument name="data_limite" 					required="no" default="">
	<cfargument name="km_limiar_final" 				required="no" default="">
	<cfargument name="intervalo_inventario_diesel" 	required="no" default="">
	<cfargument name="KM_revisao" 					required="no" default="">
	<cfargument name="LIMITE_SALDO_CC_MOTORISTA" 	required="no" default="">
	<cfargument name="frase_acidente" 				required="no" default="">
	<cfargument name="LIMITE_DEBITO_CARTAO_PEDAGIO" required="no" default="">
    <cfargument name="dias_pagto_postos"			required="no" default="">
	<!-- Conta Resultado -->
	<cfargument name="MULTIPLICADOR_KM" 			required="no" default="">
	<cfargument name="TOLERANCIA_CONTA_RESULTADO" 	required="no" default="">
	<!-- Contrato_transporte -->
	<cfargument name="perc_custo_financeiro" 		required="no" default="">
	<cfargument name="desconto_seguro" 				required="no" default="">
	<cfargument name="dias_carencia" 				required="no" default="">
	<cfargument name="perc_comissao" 				required="no" default="">
	<cfargument name="perc_negociador" 				required="no" default="">
	<cfargument name="perc_embarcador" 				required="no" default="">
	<cfargument name="perc_emissor" 				required="no" default="">
	<!-- Controle de Pneus -->
	<cfargument name="tolerancia_inspecao" 			required="no" default="">
	<cfargument name="mm_minimo_reforma" 			required="no" default="">
	<cfargument name="mm_liberacao_primeiro_eixo" 	required="no" default="">
	<cfargument name="valor_por_conserto" 			required="no" default="">
	<!-- Recursos Humanos -->
	<cfargument name="mes_ano_inicio" 				required="no" default="">
	<cfargument name="mes_ano_fim" 					required="no" default=""> 
	<cftry>
		<cftransaction action="begin">
		<cfif Arguments.modalidade eq 'POSTOS'>
			<cfif IsDefined("arguments.frase_acidente") and Len(Trim(arguments.frase_acidente))>
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="8">
					<cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="LOGISTICA">
					<cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_varchar" value="#arguments.frase_acidente#">
				</cfstoredproc>
			</cfif>
			
            <cfif Len(Trim(arguments.data_limite))>
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="8">
                    <cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="ABASTECIMENTO">
                    <cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_integer" value="#arguments.data_limite#">
                </cfstoredproc>
            </cfif>

            <cfif Len(Trim(arguments.km_limiar_final))>
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="10">
                    <cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="ABASTECIMENTO">
                    <cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_integer" value="#arguments.km_limiar_final#">
                </cfstoredproc>
            </cfif>

            <cfif Len(Trim(arguments.intervalo_inventario_diesel))>
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="6">
                    <cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="ABASTECIMENTO">
                    <cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_integer" value="#arguments.intervalo_inventario_diesel#">
                </cfstoredproc>
            </cfif>


            <cfif Len(Trim(arguments.KM_revisao))>
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="4">
                    <cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="LOGISTICA">
                    <cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_integer" value="#Arguments.KM_revisao#">
                </cfstoredproc>
            </cfif>

			<cfif Len(Trim(arguments.MULTIPLICADOR_KM))>
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="12">
                    <cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="LOGISTICA">
                    <cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_integer" value="#Arguments.MULTIPLICADOR_KM#">
                </cfstoredproc>
            </cfif>
			
            <cfif Len(Trim(Arguments.TOLERANCIA_CONTA_RESULTADO))>
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="13">
                    <cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="LOGISTICA">
                    <cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_integer" value="#Arguments.TOLERANCIA_CONTA_RESULTADO#">
                </cfstoredproc>
            </cfif>

			<cfif Len(Trim(Arguments.LIMITE_DEBITO_CARTAO_PEDAGIO))>
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="16">
                    <cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="LOGISTICA">
                    <cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_integer" value="#Arguments.LIMITE_DEBITO_CARTAO_PEDAGIO#">
                </cfstoredproc>
            </cfif>

			<cfif Len(Trim(Arguments.LIMITE_SALDO_CC_MOTORISTA))>
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="17">
                    <cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="LOGISTICA">
                    <cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_integer" value="#Arguments.LIMITE_SALDO_CC_MOTORISTA#">
                </cfstoredproc>
            </cfif>
			
            <cfif Len(Trim(arguments.perc_comissao))>
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="1">
                    <cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="CONTRATO_TRANSP">
                    <cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_integer" value="#arguments.perc_comissao#">
                </cfstoredproc>
            </cfif>
            
            <cfif Len(Trim(arguments.perc_negociador))>
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="2">
                    <cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="CONTRATO_TRANSP">
                    <cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_integer" value="#arguments.perc_negociador#">
                </cfstoredproc>
            </cfif>

            <cfif Len(Trim(arguments.perc_embarcador))>
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="3">
                    <cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="CONTRATO_TRANSP">
                    <cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_integer" value="#arguments.perc_embarcador#">
                </cfstoredproc>
            </cfif>

            <cfif Len(Trim(arguments.perc_emissor))>
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="4">
                    <cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="CONTRATO_TRANSP">
                    <cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_integer" value="#arguments.perc_emissor#">
                </cfstoredproc>
            </cfif>

            <cfif Len(Trim(arguments.perc_custo_financeiro))>
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="5">
                    <cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="CONTRATO_TRANSP">
                    <cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_varchar" value="#Trim(arguments.perc_custo_financeiro)#">
                </cfstoredproc>
            </cfif>

            <cfif Len(Trim(arguments.dias_carencia))>
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="6">
                    <cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="CONTRATO_TRANSP">
                    <cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_integer" value="#arguments.dias_carencia#">
                </cfstoredproc>
            </cfif>

            <cfif Len(Trim(arguments.dias_pagto_postos))>
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="7">
                    <cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="CONTRATO_TRANSP">
                    <cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_integer" value="#arguments.dias_pagto_postos#">
                </cfstoredproc>
            </cfif>

            <cfif Len(Trim(arguments.desconto_seguro))>
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="8">
                    <cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="CONTRATO_TRANSP">
                    <cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_integer" value="#arguments.desconto_seguro#">
                </cfstoredproc>
            </cfif>

            <cfif Len(Trim(arguments.tolerancia_inspecao))>
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="1">
                    <cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="PNEU">
                    <cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_integer" value="#arguments.tolerancia_inspecao#">
                </cfstoredproc>
            </cfif>

            <cfif Len(Trim(arguments.mm_minimo_reforma))>
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="2">
                    <cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="PNEU">
                    <cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_integer" value="#arguments.mm_minimo_reforma#">
                </cfstoredproc>
            </cfif>

            <cfif Len(Trim(arguments.mm_liberacao_primeiro_eixo))>
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="3">
                    <cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="PNEU">
                    <cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_integer" value="#arguments.mm_liberacao_primeiro_eixo#">
                </cfstoredproc>
            </cfif>

            <cfif Len(Trim(arguments.valor_por_conserto))>
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" dbvarname="p_id" cfsqltype="cf_sql_integer" value="4">
                    <cfprocparam type="in" dbvarname="p_modulo" cfsqltype="cf_sql_varchar" value="PNEU">
                    <cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_integer" value="#arguments.valor_por_conserto#">
                </cfstoredproc>
            </cfif>
		</cfif>

		<cfset retorno.mensagem = 'Alteraes feitas com sucesso!'>
		<cfset retorno.erro = false>						
		</cftransaction>
  <cfcatch>
		<cfset retorno.erro = true>
		<cfset retorno.mensagem = cfcatch>
		<cftransaction action="rollback" />
		<cfset request.erro = cfcatch>
   </cfcatch>
	</cftry>
	<cfreturn retorno>
</cffunction>


<!--- 
-- PROPSITO 
-- insere uma mensagem no mural
-- CRISTOFER  30/12/2005
--->
<cffunction name="ins_mural_internet" displayname="Altera a gesto da modalidade passada" access="remote" returntype="struct" output="true">
	<cfargument name="titulo" required="yes">
	<cfargument name="mensagem" required="yes">
	<cfargument name="data_inicio" required="yes">
	<cfargument name="data_termino" required="yes">
	<cfargument name="tipo_recado_id" required="yes">
	<cfargument name="cod_grupo" required="yes">
	<cftry>
		<cftransaction action="begin">
		<cfquery datasource="#session.dsn#" name="qr_cnae" username="#session.usuario#" password="#session.senha#">
			insert into oper.v$mural_internet
			  (titulo, mensagem, data_inicio, data_termino, tipo_recado_id, cod_grupo)
			values
			  ('#arguments.titulo#', '#arguments.mensagem#', '#arguments.data_inicio#', '#arguments.data_termino#', #arguments.tipo_recado_id#, '#arguments.cod_grupo#')
		</cfquery>
		<cfset retorno.mensagem = 'Mensagem inserida com sucesso!'>
		<cfset retorno.erro = false>						
		</cftransaction>
  <cfcatch>
		<cfset retorno.erro = true>
		<cfset retorno.mensagem = cfcatch>
		<cftransaction action="rollback" />
		<cfset request.erro = cfcatch>
   </cfcatch>
	</cftry>
	<cfreturn retorno>
</cffunction>
<!--- 
-- PROPSITO 
-- Altera uma mensagem no mural
-- CRISTOFER  30/12/2005
--->
<cffunction name="upd_mural_internet" displayname="Altera a gesto da modalidade passada" access="remote" returntype="struct" output="true">
	<cfargument name="id" required="yes">
	<cfargument name="titulo" required="yes">
	<cfargument name="mensagem" required="yes">
	<cfargument name="data_inicio" required="yes">
	<cfargument name="data_termino" required="yes">
	<cfargument name="tipo_recado_id" required="yes">
	<cfargument name="cod_grupo" required="yes">
	<cftry>
		<cftransaction action="begin">
		<cfquery datasource="#session.dsn#" name="qr_cnae" username="#session.usuario#" password="#session.senha#">
			update oper.v$mural_internet
			   set titulo = '#arguments.titulo#', 
			   	   mensagem = '#arguments.mensagem#', 
				   data_inicio = '#arguments.data_inicio#', 
				   data_termino = '#arguments.data_termino#', 
				   tipo_recado_id = '#arguments.tipo_recado_id#', 
				   cod_grupo = '#arguments.cod_grupo#'
		     where id = '#arguments.id#'
		</cfquery>
		<cfset retorno.mensagem = 'Mensagem alterada com sucesso!'>
		<cfset retorno.erro = false>						
		</cftransaction>
  <cfcatch>
		<cfset retorno.erro = true>
		<cfset retorno.mensagem = cfcatch>
		<cftransaction action="rollback" />
		<cfset request.erro = cfcatch>
   </cfcatch>
	</cftry>
	<cfreturn retorno>
</cffunction>
<!--- 
-- PROPSITO 
-- Exclui uma mensagem no mural
-- CRISTOFER  30/12/2005
--->
<cffunction name="del_mural_internet" displayname="Altera a gesto da modalidade passada" access="remote" returntype="struct" output="true">
	<cfargument name="id" required="yes">
	<cftry>
		<cftransaction action="begin">
		<cfquery datasource="#session.dsn#" name="qr_cnae" username="#session.usuario#" password="#session.senha#">
			delete oper.v$mural_internet
		     where id = '#arguments.id#'
		</cfquery>
		<cfset retorno.mensagem = 'Mensagem excluida com sucesso!'>
		<cfset retorno.erro = false>						
		</cftransaction>
  <cfcatch>
		<cfset retorno.erro = true>
		<cfset retorno.mensagem = cfcatch>
		<cftransaction action="rollback" />
		<cfset request.erro = cfcatch>
   </cfcatch>
	</cftry>
	<cfreturn retorno>
</cffunction>

<!--- 
-- PROPSITO 
-- Insere uma bomba de combustivel
-- CRISTOFER  02/01/2006
--->
<cffunction name="ins_bomba_combustivel" access="remote" returntype="struct" output="true">
	<cfargument name="cod_pessoa_filial" required="yes">
	<cfargument name="contador" 		 required="yes">
	<cftry>
		<cftransaction action="begin">
		<cfif isdefined("arguments.situacao_0")>
			<cfset situacao=1>
		<cfelse>
			<cfset situacao=0>
		</cfif>
		<cfquery datasource="#session.dsn#" name="qr_cnae" username="#session.usuario#" password="#session.senha#">
			insert into oper.v$bomba_combustivel
			  (cod_pessoa, contador, situacao)
			values
			  (#arguments.cod_pessoa_filial#, #arguments.contador#, #situacao#)
		</cfquery>
		<cfset retorno.mensagem = 'Bomba de combustivel inserida com sucesso!'>
		<cfset retorno.erro = false>						
		</cftransaction>
  <cfcatch>
		<cfset retorno.erro = true>
		<cfset retorno.mensagem = cfcatch>
		<cftransaction action="rollback" />
		<cfset request.erro = cfcatch>
   </cfcatch>
	</cftry>
	<cfreturn retorno>
</cffunction>
<!--- 
-- PROPSITO 
-- Altera uma bomba de combustivel
-- CRISTOFER  02/01/2006
--->
<cffunction name="upd_bomba_combustivel" access="remote" returntype="struct" output="true">
	<cfargument name="cod_pessoa_filial" required="yes">
	<cfargument name="contador" 		 required="yes">
	<cfargument name="bomba_id" 		 required="yes">
	<cftry>
		<cftransaction action="begin">
		<cfif isdefined("arguments.situacao_#arguments.bomba_id#")>
			<cfset situacao=1>
		<cfelse>
			<cfset situacao=0>
		</cfif>
		<cfquery datasource="#session.dsn#" name="qr_cnae" username="#session.usuario#" password="#session.senha#">
			update oper.v$bomba_combustivel
			   set contador = #arguments.contador#, situacao = #situacao#
			 where bomba_id = #arguments.bomba_id#
		</cfquery>
		<cfset retorno.mensagem = 'Bomba de combustivel alterada com sucesso!'>
		<cfset retorno.erro = false>						
		</cftransaction>
  <cfcatch>
		<cfset retorno.erro = true>
		<cfset retorno.mensagem = cfcatch>
		<cftransaction action="rollback" />
		<cfset request.erro = cfcatch>
   </cfcatch>
	</cftry>
	<cfreturn retorno>
</cffunction>
<!--- 
-- PROPSITO 
-- Exclui uma bomba de combustivel
-- CRISTOFER  02/01/2006
--->
<cffunction name="del_bomba_combustivel" access="remote" returntype="struct" output="true">
	<cfargument name="bomba_id" 		 required="yes">
	<cftry>
		<cftransaction action="begin">
		<cfquery datasource="#session.dsn#" name="qr_cnae" username="#session.usuario#" password="#session.senha#">
			delete oper.v$bomba_combustivel
			 where bomba_id = #arguments.bomba_id#
		</cfquery>
		<cfset retorno.mensagem = 'Bomba de combustivel excluida com sucesso!'>
		<cfset retorno.erro = false>						
		</cftransaction>
  <cfcatch>
		<cfset retorno.erro = true>
		<cfset retorno.mensagem = cfcatch>
		<cftransaction action="rollback" />
		<cfset request.erro = cfcatch>
   </cfcatch>
	</cftry>
	<cfreturn retorno>
</cffunction>
<!--- 
-- PROPSITO 
-- Altera a situacao de uma bomba de combustivel
-- CRISTOFER  02/01/2006
--->
<cffunction name="situacao_bomba_combustivel" access="remote" returntype="struct" output="true">
	<cfargument name="cod_pessoa_filial" required="yes">
	<cfargument name="situacao" 		 required="yes">
	<cfargument name="bomba_id" 		 required="yes">
	<cftry>
		<cftransaction action="begin">
		<cfquery datasource="#session.dsn#" name="qr_cnae" username="#session.usuario#" password="#session.senha#">
			update oper.v$bomba_combustivel 
			   set situacao = #arguments.situacao#
			 where bomba_id = #arguments.bomba_id#
		</cfquery>
		<cfset retorno.mensagem = 'Situacao da Bomba de Combustivel alterada com sucesso!'>
		<cfset retorno.erro = false>						
		</cftransaction>
  <cfcatch>
		<cfset retorno.erro = true>
		<cfset retorno.mensagem = cfcatch>
		<cftransaction action="rollback" />
		<cfset request.erro = cfcatch>
   </cfcatch>
	</cftry>
	<cfreturn retorno>
</cffunction>


<!--- 
-- PROPSITO 
-- Altera algumas propriedades do produto
-- CRISTOFER  02/01/2006
--->
<cffunction name="upd_produto" displayname="Altera algumas propriedades do produto" access="remote" returntype="struct" output="true">
	<cfargument name="produto_id" 			required="yes">		
	<cfargument name="cod_pessoa_filial" 	required="yes">
	<cfargument name="cod_departamento" 	required="yes">
	<cfargument name="cod_setor" 			required="yes">
	<cfargument name="capacidade" 			required="no" default="null">		
	<cfargument name="preco_venda" 			required="no" default="null">		
	<cfargument name="estoque_minimo" 		required="no" default="0">		
	<cfargument name="situacao" 			required="no" default="1">		
	<cfif not len(trim(arguments.capacidade))><cfset arguments.capacidade = 0></cfif>
	<cftry>
		<cftransaction action="begin">
		<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			update oper.v$estoque
			   set estoque_minimo = #Arguments.estoque_minimo#,
				   preco_venda = #rereplace(arguments.preco_venda, ',', '.', 'ALL')#,
				   ativo = #Arguments.situacao#,
				   capacidade_maxima = #Arguments.capacidade#
			 where produto_id = #Arguments.produto_id#
			   and cod_pessoa_filial = #Arguments.cod_pessoa_filial#
			   and cod_departamento = #Arguments.cod_departamento#
			   and cod_setor = #Arguments.cod_setor#
		</cfquery>
		<cfset retorno.mensagem = 'Dados do produto alterados com sucesso.'>
		<cfset retorno.erro = false>						
		</cftransaction>
	<cfcatch>
		<cfset retorno.erro = true>
		<cfset retorno.mensagem = cfcatch>
		<cftransaction action="rollback" />
		<cfset request.erro = cfcatch>
	</cfcatch>
	</cftry>	
	<cfreturn retorno>
</cffunction>	
<!--- 
-- PROPSITO 
-- Faz o inventrio a um produto.
-- CRISTOFER  02/01/2006
--->
<cffunction name="ins_inventario" displayname="Faz o inventrio a um produto." access="remote" returntype="struct" output="true">
	<cfargument name="data_inventario" 	required="yes">
	<cfargument name="quantidade" 		required="yes">
	<cfargument name="estoque_id" 		required="yes">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_almoxarifado.prc_ins_estoque_inventario" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_estoque_id" cfsqltype="cf_sql_integer" value="#arguments.estoque_id#">
				<cfprocparam type="in" dbvarname="p_data_inventario" cfsqltype="cf_sql_varchar" value="#arguments.data_inventario#">
				<cfprocparam type="in" dbvarname="p_qtde_estoque" cfsqltype="cf_sql_float" value="#arguments.quantidade#">
				<cfprocparam type="in" dbvarname="p_custo_medio" cfsqltype="cf_sql_float" value="1">
				<cfprocparam type="out" dbvarname="p_rowid" cfsqltype="cf_sql_varchar" variable="retorno.rowid">
			</cfstoredproc>											
			<cfset retorno.mensagem = 'Inventrio feito com sucesso.'>		
			<cfset retorno.erro = false>		
		</cftransaction>
	<cfcatch>
		<cfset retorno.erro = true>
		<cfset retorno.mensagem = cfcatch>
		<cftransaction action="rollback" />
		<cfset request.erro = cfcatch>
	</cfcatch>
	</cftry>	
	<cfreturn retorno>
</cffunction>
<!--- 
-- PROPSITO 
-- Exclui um inventrio a um produto.
-- CRISTOFER  02/01/2006
--->
<cffunction name="del_inventario" displayname="Exclui um inventrio a um produto." access="remote" returntype="struct" output="true">
	<cfargument name="data_inventario" 	required="yes">
	<cfargument name="estoque_id" 		required="yes">
	<cftry>
		<cftransaction action="begin">
		<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			delete oper.v$estoque_inventario
			 where estoque_id = #arguments.estoque_id#
			   and data_inventario = '#arguments.data_inventario#'
		</cfquery>
			<cfset retorno.mensagem = 'Inventrio excluido com sucesso.'>
			<cfset retorno.erro = false>		
		</cftransaction>
	<cfcatch>
		<cfset retorno.erro = true>
		<cfset retorno.mensagem = cfcatch>
		<cftransaction action="rollback" />
		<cfset request.erro = cfcatch>
	</cfcatch>
	</cftry>	
	<cfreturn retorno>
</cffunction>
</cfcomponent>