<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- insero de adv
    -- kathlyn 21/01/2008 15:09:35 - CRIADO
    --->
    <cffunction name='ins_adv' displayname='insero de adv' access='remote' returntype='Struct' output='true'>
      <cfargument name='ADV_TIPO' required='yes'>
      <cfargument name='VALOR' required='yes'>
      <cfargument name='COD_PESSOA' required='yes'>
      <cfargument name='COD_PESSOA_GERENTE' required='yes'>
      <cfargument name='NUM_ROMANEIO' required='yes'>
      <cfargument name='OBSERVACAO' required='yes'>  
      <cftry>
        <cftransaction action='begin'>
          <cfstoredproc procedure='oper.pkg_adv.prc_ins_adv' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
            <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ADV_ID' variable='retorno.ADV_ID' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ADV_TIPO'  value='#arguments.ADV_TIPO#'  null='#iif(len(trim(arguments.ADV_TIPO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_GERENTE'  value='#arguments.COD_PESSOA_GERENTE#'  null='#iif(len(trim(arguments.COD_PESSOA_GERENTE)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ADV_ID_ORIGEM' null="yes" >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO' value="#arguments.OBSERVACAO#">
            <cfprocparam type='OUT' cfsqltype='cf_sql_varchar' dbvarname='P_ROWID' variable='retorno.ROWID' >
          </cfstoredproc>
          <cfset retorno.erro = false>
          <cfset retorno.mensagem = JSStringFormat('Adv inserida com sucesso!')>
        </cftransaction>
        <cfcatch>
          <cftransaction action='rollback'/>
          <cfset retorno.erro = true>
          <cfset retorno.mensagem = cfcatch>
          <cfset request.erro = cfcatch>
        </cfcatch>
      </cftry>
      <cfreturn retorno />
    </cffunction>
	<!--- 
    -- PROPSITO
    -- Cancelar ADV
    -- kathlyn 29/01/2008 18:06:12 - CRIADO
    --->
    <cffunction name='cancelar_adv' displayname='cancelar ADV' access='remote' returntype='Struct' output='true'>
      <cfargument name='ADV_ID' required='yes'>
      <cfargument name='MOTIVO_CANCEL' required='yes'>
      <cfargument name='TRAVA_POR_TEMPO' required='yes' default="1">
      <cftry>
        <cftransaction action='begin'>
          <cfstoredproc procedure='oper.pkg_adv.prc_cancelar_adv' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ADV_ID'  value='#arguments.ADV_ID#'  null='#iif(len(trim(arguments.ADV_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO_CANCEL'  value='#arguments.MOTIVO_CANCEL#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRAVA_POR_TEMPO'  value='#arguments.TRAVA_POR_TEMPO#'  null='#iif(len(trim(arguments.TRAVA_POR_TEMPO)), de('no'), de('yes'))#'>
          </cfstoredproc>
          <cfset retorno.erro = false>
          <cfset retorno.mensagem = JSStringFormat('ADV cancelada com sucesso!')>
        </cftransaction>
        <cfcatch>
          <cftransaction action='rollback'/><cfset retorno.erro = true>
          <cfset retorno.mensagem = cfcatch>
          <cfset request.erro = cfcatch>
        </cfcatch>
      </cftry>
      <cfreturn retorno />
    </cffunction>

	<cffunction name="upd_adv_despesas" displayname="Insere despesas em uma adv" access="remote" returntype="Struct" output="true">
  	<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- KAthlyn 29/01/2008 - criado
	--->
    <cfargument name='ADV_ID' required='yes'>
    <cfargument name='COD_CENTRO_CUSTO' required='yes'>
    <cfargument name='DESPESA_ID' required='no'>
    <cfargument name='NUM_NOTA_ID' required='no' default="">
    <cftry>
    <cftransaction action="begin">
      <!---Inseres/alteraes de Despesas de ADV--->
    
        <cfscript>
                v_adv_id = '#arguments.ADV_ID#';
                v_classe_id = this.ListaToArray (lista = arguments, variavel = "CLASSE_ID_DESPESA");
                v_valor_despesa = this.ListaToArray (lista = arguments, variavel = "VALOR_DESPESA_DESPESA");
                v_complemento = this.ListaToArray (lista = arguments, variavel = "COMPLEMENTO_DESPESA");
                v_num_docto = this.ListaToArray (lista = arguments, variavel = "NUM_DOCTO_DESPESA");
                v_cod_contabil = this.ListaToArray (lista = arguments, variavel = "COD_CONTABIL_DESPESA");
                v_cod_centro_custo = '#arguments.COD_CENTRO_CUSTO#';
                v_cnpj_cpf_emitente = this.ListaToArray (lista = arguments, variavel = "CNPJ_CPF_EMITENTE_DESPESA");
                v_cod_emitente = this.ListaToArray (lista = arguments, variavel = "COD_PESSOA_EMITENTE_DESPESA");
                v_num_nota_id = '#arguments.NUM_NOTA_ID#';
                v_despesa_id = this.ListaToArray (lista = arguments, variavel = "DESPESA_ID_DESPESA");
                v_despesa_excluir = this.ListDiff(lista1 = arguments.lista_deleted_despesa, lista2 = ArrayToList(v_despesa_id));				
            </cfscript>
        <cfloop list="#v_despesa_excluir#" delimiters="," index="l_despesa_id">
          <cfscript>
                    this.del_despesa(DESPESA_ID  = l_despesa_id);
          </cfscript>
        </cfloop>
        <cfloop from="1" to="#ArrayLen(v_despesa_id)#" index="count">
           <cfscript>
                if(not len(trim(v_despesa_id[count]))) {
                    this.ins_despesa(									
                                   ADV_ID= v_adv_id,
                                   CLASSE_ID= v_classe_id[count],								   
                                   VALOR = v_valor_despesa[count],
                                   COMPLEMENTO = v_complemento[count],
                                   NUM_DOCTO = v_num_docto[count],
                                   COD_CONTABIL = v_cod_contabil[count],
                                   COD_CENTRO_CUSTO = v_cod_centro_custo,
           COD_EMITENTE = v_cod_emitente[count],
                                   EMIT_CNPJ_CPF = v_cnpj_cpf_emitente[count],								   
                                   NUM_NOTA_ID	= v_num_nota_id			   								   
                                   );
                }else{
                    this.upd_despesa( 								
                                   DESPESA_ID = v_despesa_id[count],
                                   ADV_ID= v_adv_id,
                                   CLASSE_ID= v_classe_id[count],								   
                                   VALOR = v_valor_despesa[count],
                                   COMPLEMENTO = v_complemento[count],
                                   NUM_DOCTO = v_num_docto[count],
                                   COD_CONTABIL = v_cod_contabil[count],
                                   COD_CENTRO_CUSTO = v_cod_centro_custo,
           COD_EMITENTE = v_cod_emitente[count],
                                   EMIT_CNPJ_CPF = v_cnpj_cpf_emitente[count],								   
                                   NUM_NOTA_ID	= v_num_nota_id								   
                                   );
                                   }
                </cfscript>
        </cfloop>        
       
      <cfset retorno.erro = false>
      <cfset retorno.mensagem = JSStringFormat("Despesa de ADV alteradas com sucesso!")>
    </cftransaction>
    <cfcatch type="database">
      <cftransaction action="rollback" />
      <cfset retorno.erro = true>
      <cfset retorno.mensagem = cfcatch>
      <cfset request.erro = cfcatch>
    </cfcatch>
    </cftry>
    <cfreturn retorno />
    </cffunction>
	<!--- 
    -- PROPSITO
    -- Inserir despesas de viagem
    -- kathlyn 25/01/2008 17:12:31 - CRIADO
    --->
    <cffunction name='ins_despesa' displayname='Inserir despesas de viagem' access='remote' returntype='Struct' output='true'>
      <cfargument name='ADV_ID' required='yes'>
      <cfargument name='CLASSE_ID' required='yes'>
      <cfargument name='VALOR' required='yes'>
      <cfargument name='COMPLEMENTO' required='yes'>
      <cfargument name='NUM_DOCTO' required='yes'>
      <cfargument name='COD_CONTABIL' required='yes'>
      <cfargument name='COD_CENTRO_CUSTO' required='yes'>
      <cfargument name='COD_EMITENTE' required='yes'>
      <cfargument name='EMIT_CNPJ_CPF' required='yes'>
      <cfargument name='NUM_NOTA_ID' required='no' default="">
        <cfstoredproc procedure='oper.pkg_adv.prc_ins_despesa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
        <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_DESPESA_ID' variable='retorno.DESPESA_ID' >
        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_ADV_ID'  value='#arguments.ADV_ID#'  null='#iif(len(trim(arguments.ADV_ID)), de('no'), de('yes'))#'>
        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_CLASSE_ID'  value='#arguments.CLASSE_ID#'  null='#iif(len(trim(arguments.CLASSE_ID)), de('no'), de('yes'))#'>
        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_NUM_DOCTO'  value='#arguments.NUM_DOCTO#'  null='#iif(len(trim(arguments.NUM_DOCTO)), de('no'), de('yes'))#'>
        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_CONTABIL'  value='#arguments.COD_CONTABIL#' >
        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_COD_EMITENTE'  value='#arguments.COD_EMITENTE#'  null='#iif(len(trim(arguments.COD_EMITENTE)), de('no'), de('yes'))#'>
        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_CNPJ_CPF'  value='#arguments.EMIT_CNPJ_CPF#' >
        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
        <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
      </cfstoredproc>
      <cfreturn retorno />
    </cffunction>
    <!--- 
    -- PROPSITO
    -- altera despesas de viagem
    -- kathlyn 25/01/2008 17:14:49 - CRIADO
    --->
    <cffunction name='upd_despesa' displayname='altera despesas de viagem' access='remote' returntype='Struct' output='true'>
      <cfargument name='DESPESA_ID' required='yes'>
      <cfargument name='CLASSE_ID' required='yes'>
      <cfargument name='VALOR' required='yes'>
      <cfargument name='COMPLEMENTO' required='yes'>
      <cfargument name='NUM_DOCTO' required='yes'>
      <cfargument name='COD_CONTABIL' required='yes'>
      <cfargument name='COD_CENTRO_CUSTO' required='yes'>
      <cfargument name='COD_EMITENTE' required='yes'>
      <cfargument name='EMIT_CNPJ_CPF' required='yes'>
      <cfargument name='NUM_NOTA_ID' required='no' default="">
      <cfstoredproc procedure='oper.pkg_adv.prc_alt_despesa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_DESPESA_ID'  value='#arguments.DESPESA_ID#'  null='#iif(len(trim(arguments.DESPESA_ID)), de('no'), de('yes'))#'>
        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_CLASSE_ID'  value='#arguments.CLASSE_ID#'  null='#iif(len(trim(arguments.CLASSE_ID)), de('no'), de('yes'))#'>
        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value= '#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_NUM_DOCTO'  value='#arguments.NUM_DOCTO#'  null='#iif(len(trim(arguments.NUM_DOCTO)), de('no'), de('yes'))#'>
        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_CONTABIL'  value='#arguments.COD_CONTABIL#' >
        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_COD_EMITENTE'  value='#arguments.COD_EMITENTE#'  null='#iif(len(trim(arguments.COD_EMITENTE)), de('no'), de('yes'))#'>
        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_CNPJ_CPF'  value='#arguments.EMIT_CNPJ_CPF#' >
        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#)'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
      </cfstoredproc>
      <cfreturn structnew() />
    </cffunction>
    <!--- 
    -- PROPSITO
    -- Deleta despesas de viagem
    -- kathlyn 25/01/2008 17:17:14 - CRIADO
    --->
    <cffunction name='del_despesa' displayname='Deleta despesas de viagem' access='remote' returntype='Struct' output='true'>
      <cfargument name='DESPESA_ID' required='yes'>
      <cfstoredproc procedure='oper.pkg_adv.PRC_DEL_DESPESA' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_DESPESA_ID'  value='#arguments.DESPESA_ID#'  null='#iif(len(trim(arguments.DESPESA_ID)), de('no'), de('yes'))#'>
      </cfstoredproc>
      <cfreturn structnew() />
    </cffunction>
    <!--- 
    -- PROPSITO
    -- Alterar data de impresso.
    -- kathlyn 28/01/2008 13:50:48 - CRIADO
    --->
    <cffunction name= 'upd_data' displayname='Alterar data de impresso.' access='remote' returntype='Struct' output='true'>
      <cfargument name='ADV_ID' required='yes'>
      <cftry>
        <cftransaction action='begin'>
          <cfstoredproc procedure='oper.pkg_adv.prc_imprimir_adv' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ADV_ID'  value='#arguments.ADV_ID#'  null='#iif(len(trim(arguments.ADV_ID)), de('no'), de('yes'))#'>
          </cfstoredproc>
          <cfset retorno.erro = false>
          <cfset retorno.mensagem = JSStringFormat('Data de impressao inserida com sucesso')>
        </cftransaction>
        <cfcatch>
          <cftransaction action='rollback'/><cfset retorno.erro = true>
          <cfset retorno.mensagem = cfcatch>
          <cfset request.erro = cfcatch>
        </cfcatch>
      </cftry>
      <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Insere uma Despesa (RAP)
    -- ANDERSONC 14/05/2009 10:01:06 - CRIADO
    --->
    <cffunction name='ins_despesa_rap' displayname='Insere uma Despesa (RAP)' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESPESA_ID' required='yes'>
        <cfargument name='DESPESA_TIPO_ID' required='yes'>
        <cfargument name='DATA_EMISSAO' required='yes'>
        <cfargument name='MUNICIPIO_ID' required='yes'>
        <cfargument name='VALOR_SERVICO' required='yes'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='COD_PESSOA_FILIAL' required='yes'>
        <cfargument name='REMETENTE' required='yes'>
        <cfargument name='REM_MUNICIPIO_ID' required='yes'>
        <cfargument name='DESTINATARIO' required='yes'>
        <cfargument name='DEST_MUNICIPIO_ID' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_MOTORISTA' required='yes'>
        <cfargument name='COD_PROPRIETARIO' required='yes'>
        <cfargument name='COD_BENEFICIARIO' required='yes'>
        <cfargument name='BEN_CNPJ_CPF' required='yes'>
        <cfargument name='BEN_RAZAO_SOCIAL' required='yes'>
        <cfargument name='BEN_NIT' required='yes'>
        <cfargument name='BEN_DATA_NASCIMENTO' required='yes'>
        <cfargument name='BEN_CART_IDENT_NUM' required='yes'>
        <cfargument name='BEN_CART_IDENT_ORGAO' required='yes'>
        <cfargument name='ADV_ID' required='yes'>
        <cfargument name='NUM_NOTA_ID' required='no' default=''>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_rap.prc_ins_despesa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESPESA_ID'  value='#arguments.DESPESA_ID#' variable='retorno.DESPESA_ID'  null='#iif(len(trim(arguments.DESPESA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESPESA_TIPO_ID'  value='#arguments.DESPESA_TIPO_ID#'  null='#iif(len(trim(arguments.DESPESA_TIPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID'  value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_SERVICO'  value='#arguments.VALOR_SERVICO#'  null='#iif(len(trim(arguments.VALOR_SERVICO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REMETENTE'  value='#arguments.REMETENTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REM_MUNICIPIO_ID'  value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESTINATARIO'  value='#arguments.DESTINATARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEST_MUNICIPIO_ID'  value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROPRIETARIO'  value='#arguments.COD_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PROPRIETARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_BENEFICIARIO'  value='#arguments.COD_BENEFICIARIO#'  null='#iif(len(trim(arguments.COD_BENEFICIARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BEN_CNPJ_CPF'  value='#arguments.BEN_CNPJ_CPF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BEN_RAZAO_SOCIAL'  value='#arguments.BEN_RAZAO_SOCIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BEN_NIT'  value='#arguments.BEN_NIT#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BEN_DATA_NASCIMENTO'  value='#arguments.BEN_DATA_NASCIMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BEN_CART_IDENT_NUM'  value='#arguments.BEN_CART_IDENT_NUM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BEN_CART_IDENT_ORGAO'  value='#arguments.BEN_CART_IDENT_ORGAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ADV_ID'  value='#arguments.ADV_ID#'  null='#iif(len(trim(arguments.ADV_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Despesa inserida com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera uma Despesa (RAP)
	-- ANDERSONC 14/05/2009 10:04:35 - CRIADO
	--->
	<cffunction name='upd_despesa_rap' displayname='Altera uma Despesa (RAP)' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESPESA_ID' required='yes'>
		<cfargument name='DESPESA_TIPO_ID' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='MUNICIPIO_ID' required='yes'>
		<cfargument name='VALOR_SERVICO' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='REMETENTE' required='yes'>
		<cfargument name='REM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DESTINATARIO' required='yes'>
		<cfargument name='DEST_MUNICIPIO_ID' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='COD_PROPRIETARIO' required='yes'>
		<cfargument name='COD_BENEFICIARIO' required='yes'>
		<cfargument name='BEN_CNPJ_CPF' required='yes'>
		<cfargument name='BEN_RAZAO_SOCIAL' required='yes'>
		<cfargument name='BEN_NIT' required='yes'>
		<cfargument name='BEN_DATA_NASCIMENTO' required='yes'>
		<cfargument name='BEN_CART_IDENT_NUM' required='yes'>
		<cfargument name='BEN_CART_IDENT_ORGAO' required='yes'>
		<cfargument name='ADV_ID' required='yes'>
		<cfargument name='NUM_NOTA_ID' required='no' default=''>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_rap.prc_alt_despesa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESPESA_ID'  value='#arguments.DESPESA_ID#'  null='#iif(len(trim(arguments.DESPESA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESPESA_TIPO_ID'  value='#arguments.DESPESA_TIPO_ID#'  null='#iif(len(trim(arguments.DESPESA_TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID'  value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_SERVICO'  value='#arguments.VALOR_SERVICO#'  null='#iif(len(trim(arguments.VALOR_SERVICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REMETENTE'  value='#arguments.REMETENTE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REM_MUNICIPIO_ID'  value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESTINATARIO'  value='#arguments.DESTINATARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEST_MUNICIPIO_ID'  value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PROPRIETARIO'  value='#arguments.COD_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_BENEFICIARIO'  value='#arguments.COD_BENEFICIARIO#'  null='#iif(len(trim(arguments.COD_BENEFICIARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BEN_CNPJ_CPF'  value='#arguments.BEN_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BEN_RAZAO_SOCIAL'  value='#arguments.BEN_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BEN_NIT'  value='#arguments.BEN_NIT#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BEN_DATA_NASCIMENTO'  value='#arguments.BEN_DATA_NASCIMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BEN_CART_IDENT_NUM'  value='#arguments.BEN_CART_IDENT_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BEN_CART_IDENT_ORGAO'  value='#arguments.BEN_CART_IDENT_ORGAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ADV_ID'  value='#arguments.ADV_ID#'  null='#iif(len(trim(arguments.ADV_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Despesa alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui uma Despesa (RAP)
	-- ANDERSONC 14/05/2009 10:17:23 - CRIADO
	--->
	<cffunction name='del_despesa_rap' displayname='Exclui uma Despesa (RAP)' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESPESA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper. pkg_rap.prc_del_despesa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESPESA_ID'  value='#arguments.DESPESA_ID#'  null='#iif(len(trim(arguments.DESPESA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Despesa excluda com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>