<!-- KM&M Componentes --> 
<cfcomponent displayname="Manipulao de acesso do sistema" extends="_transportes.funcoes.cfc_init">
	<cfparam name="session.dsn_menu" default="#session.dsn#">
	<!--- 
	-- PROPSITO 
	-- 
	-- CRISTOFER  30/03/2006
	--->
	<cffunction name="lembrar_senha" displayname="" access="remote" returntype="struct" output="true">
		<cfargument name="usuario"	required="yes">
		<cfargument name="email"	required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc datasource="#session.dsn#" procedure="acesso.pkg_acesso.PRC_LEMBRAR_SENHA" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" dbvarname="p_usuario"	 cfsqltype="cf_sql_varchar" value="#arguments.usuario#">
					<cfprocparam type="in" dbvarname="p_email"	 cfsqltype="cf_sql_varchar" value="#arguments.email#">
				</cfstoredproc>
				<cfset retorno.mensagem = 'Senha enviada para seu email com sucesso!'>
				<cfset retorno.erro = false>				
			</cftransaction>
		  <cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cftransaction action="rollback" />
				<cfset request.erro = cfcatch>
		   </cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Altera a senha do usuario corrente
	-- CRISTOFER  02/02/2006
	--->
	<cffunction name="altera_senha" displayname="Altera a gesto da modalidade passada" access="remote" returntype="struct" output="true">
		<cfargument name="senha_atual"	required="yes">
		<cfargument name="nova_senha"	required="yes">
		<cftry>
			<cftransaction action="begin">
			<cfif arguments.senha_atual neq session.senha>
				<script>
					alert('A Senha atual no est correta!');
				</script>
				<cfabort>
			<cfelse>
				<cfstoredproc datasource="#session.dsn#" procedure="acesso.PRC_ALTERA_SENHA_CORRENTE" username="#session.usuario#" password="#arguments.senha_atual#">
					<cfprocparam type="in" dbvarname="p_senha"	 cfsqltype="cf_sql_varchar" value="#arguments.nova_senha#">
				</cfstoredproc>
				<cfset retorno.mensagem = 'Senha alterada com sucesso!'>
				<cfset retorno.erro = false>				
				<cfset session.senha = arguments.nova_senha>		
			</cfif>
			</cftransaction>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cftransaction action="rollback" />
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere um item no menu
	-- CRISTOFER 09/09/2005 - criado
	--->			
	<cffunction name="ins_acesso_item" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
		<cfargument name="item_acesso_pai"		required="no"  default="">
		<cfargument name="item_acesso_cod"		required="yes">
		<cfargument name="descricao" 			required="yes">
		<cfargument name="dll_name" 			required="yes">
		<cfargument name="exported_function" 	required="yes">
		<cfargument name="act_caption" 			required="yes">
		<cfargument name="act_enabled" 			required="no"  default="false">
		<cfargument name="act_visible" 			required="no"  default="false">
		<cfargument name="act_hint" 			required="yes">
		<cfargument name="act_image" 			required="yes">
		<cfargument name="act_shortcut" 		required="yes">
		<cfargument name="act_tag" 				required="yes">
		<cfargument name="web_url" 				required="yes">
		<cfargument name="web_url_image" 		required="yes">
		<cfargument name="web_target" 			required="yes">
		<cfargument name="ordem" 				required="yes">
		<cfargument name="separar" 				required="no" default="0">
		<cfargument name="publico" 				required="no" default="0">
		<cfargument name="ajuda_id" 			required="no" default="">		
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="acesso.pkg_acesso.prc_ins_acesso_item" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_item_acesso_pai"		type="in"	value="#arguments.item_acesso_pai#"		cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.item_acesso_pai)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="p_item_acesso_cod"		type="in"	value="#arguments.item_acesso_cod#"		cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_descricao"			type="in"	value="#arguments.descricao#"			cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_dll_name"				type="in"	value="#arguments.dll_name#"			cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_exported_function"	type="in"	value="#arguments.exported_function#"	cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_act_caption"			type="in"	value="#arguments.act_caption#"			cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_act_enabled"			type="in"	value="#arguments.act_enabled#"			cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_act_visible"			type="in"	value="#arguments.act_visible#"			cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_act_hint"				type="in"	value="#arguments.act_hint#"			cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_act_image"			type="in"	value="#arguments.act_image#"			cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.act_image)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="p_act_shortcut"			type="in"	value="#arguments.act_shortcut#"		cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_act_tag"				type="in"	value="#arguments.act_tag#"				cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_web_url"				type="in"	value="#arguments.web_url#"				cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_web_url_image"		type="in"	value="#arguments.web_url_image#"		cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_web_target"			type="in"	value="#arguments.web_target#"			cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_ordem"				type="in"	value="#arguments.ordem#"				cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.ordem)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="p_separar"				type="in"	value="#arguments.separar#"				cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_publico"				type="in"	value="#arguments.publico#"				cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_ajuda_id"				type="in"	value="#arguments.ajuda_id#"			cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.ajuda_id)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="p_item_acesso_id" 		type="out" 	variable="retorno.item_acesso_id" 		cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Item de Menu inserido com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera um item do menu
	-- CRISTOFER 09/09/2005 - criado
	--->	
	<cffunction name="upd_acesso_item" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
		<cfargument	name="item_acesso_id"		required="yes">	
		<cfargument name="item_acesso_pai"		required="no" default="">
		<cfargument name="item_acesso_cod"		required="yes">
		<cfargument name="descricao" 			required="yes">
		<cfargument name="dll_name" 			required="yes">
		<cfargument name="exported_function" 	required="yes">
		<cfargument name="act_caption" 			required="yes">
		<cfargument name="act_enabled" 			required="no"  default="false">
		<cfargument name="act_visible" 			required="no"  default="false">
		<cfargument name="act_hint" 			required="yes">
		<cfargument name="act_image" 			required="yes">
		<cfargument name="act_shortcut" 		required="yes">
		<cfargument name="act_tag" 				required="yes">
		<cfargument name="web_url" 				required="yes">
		<cfargument name="web_url_image" 		required="yes">
		<cfargument name="web_target" 			required="yes">
		<cfargument name="ordem" 				required="yes">
		<cfargument name="separar" 				required="no" default="0">
		<cfargument name="publico" 				required="no" default="0">
		<cfargument name="ajuda_id" 			required="no" default="">		
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="acesso.pkg_acesso.prc_alt_acesso_item" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_item_acesso_id" 		type="in" 	value="#arguments.item_acesso_id#" 		cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_item_acesso_pai"		type="in"	value="#arguments.item_acesso_pai#"		cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.item_acesso_pai)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="p_item_acesso_cod"		type="in"	value="#arguments.item_acesso_cod#"		cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_descricao"			type="in"	value="#arguments.descricao#"			cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_dll_name"				type="in"	value="#arguments.dll_name#"			cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_exported_function"	type="in"	value="#arguments.exported_function#"	cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_act_caption"			type="in"	value="#arguments.act_caption#"			cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_act_enabled"			type="in"	value="#arguments.act_enabled#"			cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_act_visible"			type="in"	value="#arguments.act_visible#"			cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_act_hint"				type="in"	value="#arguments.act_hint#"			cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_act_image"			type="in"	value="#arguments.act_image#"			cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.act_image)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="p_act_shortcut"			type="in"	value="#arguments.act_shortcut#"		cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_act_tag"				type="in"	value="#arguments.act_tag#"				cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_web_url"				type="in"	value="#arguments.web_url#"				cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_web_url_image"		type="in"	value="#arguments.web_url_image#"		cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_web_target"			type="in"	value="#arguments.web_target#"			cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_ordem"				type="in"	value="#arguments.ordem#"				cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_separar"				type="in"	value="#arguments.separar#"				cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_publico"				type="in"	value="#arguments.publico#"				cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_ajuda_id"				type="in"	value="#arguments.ajuda_id#"			cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.ajuda_id)), de('no'), de('yes'))#">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Item de Menu alterado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui um item do menu
	-- CRISTOFER 09/09/2005 - criado
	--->	
	<cffunction name="del_acesso_item" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
		<cfargument	name="item_acesso_id"		required="yes">	
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="acesso.pkg_acesso.prc_del_acesso_item" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_item_acesso_id" 		type="in" 	value="#arguments.item_acesso_id#" 		cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Item de Menu excluido com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Sobe um item do menu
	-- CRISTOFER 09/09/2005 - criado
	--->	
	<cffunction name="sobe_acesso_item" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
		<cfargument	name="item_acesso_id"		required="yes">	
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="acesso.pkg_acesso.prc_sobe_acesso_item" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_item_acesso_id" 		type="in" 	value="#arguments.item_acesso_id#" 		cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Item de Menu alterado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Desce um item do menu
	-- CRISTOFER 09/09/2005 - criado
	--->		
	<cffunction name="desce_acesso_item" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
	  
		<cfargument	name="item_acesso_id"		required="yes">	
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="acesso.pkg_acesso.prc_desce_acesso_item" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_item_acesso_id" 		type="in" 	value="#arguments.item_acesso_id#" 		cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Item de Menu alterado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Libera os acessos para o modulo
	-- CRISTOFER 09/09/2005 - criado
	--->			
	<cffunction name="ins_acesso_modulo" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
		<cfargument name="nivel_acesso" required="yes">
		<cfargument name="modulo_id" required="yes">
		<cfargument name="item_acesso_id" required="no" default="">
		<cftry>
			<cftransaction action="begin">
				<cfquery name="excluir" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					select item_acesso_id
                      from acesso.v$item_acesso_modulo
					 where modulo_id = #arguments.modulo_id#
					   and nivel_minimo <= #arguments.nivel_acesso#
					 <cfif len(trim(arguments.item_acesso_id))>
					   and item_acesso_id not in (#arguments.item_acesso_id#)
					  </cfif>
				</cfquery>
                
                <cfoutput query="excluir">
                	<cfstoredproc procedure="acesso.pkg_acesso.prc_del_acesso_modulo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
						<cfprocparam dbvarname="p_item_acesso_id" type="in" value="#excluir.item_acesso_id#" cfsqltype="cf_sql_integer">
						<cfprocparam dbvarname="p_modulo_id" type="in" value="#arguments.modulo_id#" cfsqltype="cf_sql_integer">
						<cfprocparam dbvarname="p_nivel_acesso" type="in" value="#arguments.nivel_acesso#" cfsqltype="cf_sql_integer">
					</cfstoredproc>
				</cfoutput>
                
                <cfloop list="#arguments.item_acesso_id#" index="v_item_acesso">
					<cfstoredproc procedure="acesso.pkg_acesso.prc_ins_acesso_modulo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
						<cfprocparam dbvarname="p_item_acesso_id" type="in" value="#v_item_acesso#" cfsqltype="cf_sql_integer">
						<cfprocparam dbvarname="p_modulo_id" type="in" value="#arguments.modulo_id#" cfsqltype="cf_sql_integer">
						<cfprocparam dbvarname="p_nivel_acesso" type="in" value="#arguments.nivel_acesso#" cfsqltype="cf_sql_integer">
					</cfstoredproc>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Acessos liberados com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui os acessos para o modulo
	-- RAFAEL 14/12/2009 11:29:01 - CRIADO
	--->
	<cffunction name='prc_del_acesso_modulo' displayname='Excluir itens de Acesso de Um Mdulo' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITEM_ACESSO_ID' required='yes'>
		<cfargument name='MODULO_ID' required='yes'>
		<cfargument name='NIVEL_MINIMO' required='yes'>
				<cfstoredproc procedure='acesso.pkg_acesso.prc_del_acesso_modulo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ACESSO_ID'  value='#arguments.ITEM_ACESSO_ID#'  null='#iif(len(trim(arguments.ITEM_ACESSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODULO_ID'  value='#arguments.MODULO_ID#'  null='#iif(len(trim(arguments.MODULO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NIVEL_MINIMO'  value='#arguments.NIVEL_MINIMO#'  null='#iif(len(trim(arguments.NIVEL_MINIMO)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Libera o acesso dos usuarios
	-- CRISTOFER 09/09/2005 - criado
	--->			
	<cffunction name="ins_acesso_usuario" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
		<cfargument name="usuario" required="yes">
		<cfargument name="item_acesso_id" required="no" default="">
		<cftry>
			<cftransaction action="begin">
				<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					delete acesso.v$item_acesso_usuario iu
					 where usuario = '#arguments.usuario#'
                       and not exists (select 1
                                         from acesso.v$item_acesso ia
                                         where ia.dll_name is not null
										   and ia.item_acesso_id = iu.item_acesso_id)
					 <cfif len(trim(arguments.item_acesso_id))>
					   and item_acesso_id not in (#arguments.item_acesso_id#)
					 </cfif>
				</cfquery>
				<cfloop list="#arguments.item_acesso_id#" index="v_item_acesso">
                	<cfparam name="session.cod_pessoa" default="1">
					<cfstoredproc procedure="acesso.pkg_acesso.prc_ins_acesso_usuario" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
						<cfprocparam dbvarname="p_item_acesso_id" type="in" value="#v_item_acesso#" cfsqltype="cf_sql_integer">
						<cfprocparam dbvarname="p_usuario"    type="in" value="#arguments.usuario#" cfsqltype="cf_sql_varchar">
						<cfprocparam dbvarname="p_cod_pessoa" type="in" value="#session.cod_pessoa#" cfsqltype="cf_sql_numeric" scale="5">
					</cfstoredproc>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Acessos liberados com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere uma modulo
	-- CRISTOFER 09/09/2005 - criado
	--->			
	<cffunction name="ins_modulo" access="remote" returntype="Struct" output="true">
		<cfargument name="descricao" required="yes">
		<cfargument name="role" required="yes">
		<cfargument name="usuario_modulo" required="no" default="">
		<cfargument name="nivel_modulo" required="no" default="">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="acesso.pkg_acesso.prc_ins_modulo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_descricao" type="in" value="#arguments.descricao#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_role" 	 type="in" value="#arguments.role#" 	 cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_modulo_id" type="out" variable="retorno.modulo_id" cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<cfif len(trim(arguments.usuario_modulo))>
					<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
						delete acesso.v$modulo_usuario
						 where usuario not in ('' <cfloop list="#arguments.usuario_modulo#" index="v_usuario">, '#v_usuario#'</cfloop>)
					</cfquery>
					<cfset count = 1>
					<cfloop list="#arguments.usuario_modulo#" index="v_usuario">
						<cfstoredproc procedure="acesso.pkg_acesso.prc_ins_modulo_usuario" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
							<cfprocparam dbvarname="p_modulo_id" type="in" value="#retorno.modulo_id#" cfsqltype="cf_sql_integer">
							<cfprocparam dbvarname="p_usuario" type="in" value="#v_usuario#" cfsqltype="cf_sql_varchar">
							<cfprocparam dbvarname="p_nivel_acesso" type="in" value="#ListGetAt(arguments.nivel_modulo, count, ',')#" cfsqltype="cf_sql_integer">
						</cfstoredproc>
						<cfset count = count + 1>
					</cfloop>
				</cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Modulo inserido com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um modulo
	-- CRISTOFER 09/09/2005 - criado
	--->			
	<cffunction name="upd_modulo" access="remote" returntype="Struct" output="true">
		<cfargument name="modulo_id" required="yes">
		<cfargument name="descricao" required="yes">
		<cfargument name="role" required="yes">
		<cfargument name="usuario_modulo" required="no" default="">
		<cfargument name="nivel_modulo" required="no" default="">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="acesso.pkg_acesso.prc_alt_modulo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_modulo_id" type="in" value="#arguments.modulo_id#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_descricao" type="in" value="#arguments.descricao#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_role" type="in" value="#arguments.role#" cfsqltype="cf_sql_varchar">
				</cfstoredproc>
				<cfif len(trim(arguments.usuario_modulo))>
	
					<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
						delete acesso.v$modulo_usuario
						 where usuario not in ('_' <cfloop list="#arguments.usuario_modulo#" index="v_usuario">, '#v_usuario#'</cfloop>)
						   and modulo_id = #arguments.modulo_id#
					</cfquery>
					<cfset count = 1>
					<cfloop list="#arguments.usuario_modulo#" index="v_usuario">
						<cfstoredproc procedure="acesso.pkg_acesso.prc_ins_modulo_usuario" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
							<cfprocparam dbvarname="p_modulo_id" type="in" value="#arguments.modulo_id#" cfsqltype="cf_sql_integer">
							<cfprocparam dbvarname="p_usuario" type="in" value="#v_usuario#" cfsqltype="cf_sql_varchar">
							<cfprocparam dbvarname="p_nivel_acesso" type="in" value="#ListGetAt(arguments.nivel_modulo, count, ',')#" cfsqltype="cf_sql_integer">
						</cfstoredproc>
						<cfset count = count + 1>
					</cfloop>
				</cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Modulo alterado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui um modulo
	-- CRISTOFER 09/09/2005 - criado
	--->			
	<cffunction name="del_modulo" access="remote" returntype="Struct" output="true">
		<cfargument name="modulo_id" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="acesso.pkg_acesso.prc_del_modulo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_modulo_id" type="in" value="#arguments.modulo_id#" cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Modulo excluido com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Insere um novo usurio no sistema
	-- CRISTOFER  20/02/2006
	--->
	<cffunction name="ins_usuario" access="remote" returntype="struct" output="true">
		<cfargument name="usuario" required="yes">
		<cfargument name="nome" required="yes">
		<cfargument name="cod_pessoa" required="yes">
		<cfargument name="descricao" required="no">
		<cfargument name="ativo" required="yes">
		<cfargument name="email" required="yes">
		<cfargument name="senha" required="no" default="">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc datasource="#session.dsn#" procedure="acesso.pkg_acesso.prc_ins_usuario" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" dbvarname="p_usuario" cfsqltype="cf_sql_varchar" value="#arguments.usuario#">
					<cfprocparam type="in" dbvarname="p_nome" cfsqltype="cf_sql_varchar" value="#arguments.nome#">
					<cfprocparam type="in" dbvarname="p_descricao" cfsqltype="cf_sql_varchar" value="#arguments.descricao#">
					<cfprocparam type="in" dbvarname="p_cod_pessoa" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa#">
					<cfprocparam type="in" dbvarname="p_profile" cfsqltype="cf_sql_varchar" value="DEFAULT">
					<cfprocparam type="in" dbvarname="p_senha" cfsqltype="cf_sql_varchar" value="#arguments.senha#">
					<cfprocparam type="in" dbvarname="p_username" cfsqltype="cf_sql_varchar" value="#GetToken(arguments.email,1,'@')#">
					<cfprocparam type="in" dbvarname="p_provedor" cfsqltype="cf_sql_varchar" value="#GetToken(arguments.email,2,'@')#">
				</cfstoredproc>
			</cftransaction>
			<!--- Insere os modulos --->
			<cfscript>
				v_modulo_id = this.ListaToArray (lista = arguments, variavel = "MODULO_ID_MODULOS");
				v_nivel = this.ListaToArray (lista = arguments, variavel = "NIVEL_ACESSO_MODULOS");
			</cfscript>
			<cfloop from="1" to="#ArrayLen(v_modulo_id)#" index="count">
				<cfstoredproc procedure="acesso.pkg_acesso.prc_ins_modulo_usuario" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_modulo_id" type="in" value="#v_modulo_id[count]#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_usuario" type="in" value="#arguments.usuario#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_nivel_acesso" type="in" value="#v_nivel[count]#" cfsqltype="cf_sql_integer">
				</cfstoredproc>	
			</cfloop>			
			<cfset retorno.mensagem = 'Usurio ' & #nome# & ' inserido com sucesso!'>
			<cfset retorno.erro     = false >	
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Altera um usurio no sistema
	-- CRISTOFER  20/02/2006
	--->
	<cffunction name="upd_usuario" displayname="Inserir usuario no sistema" access="remote" returntype="struct" output="true">
		<cfargument name="usuario" required="yes">
		<cfargument name="nome" required="yes">
		<cfargument name="cod_pessoa" required="yes">
		<cfargument name="descricao" required="no">
		<cfargument name="ativo" required="yes">
		<cfargument name="email" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc datasource="#session.dsn#" procedure="acesso.pkg_acesso.prc_upd_usuario" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" dbvarname="p_usuario" cfsqltype="cf_sql_varchar" value="#arguments.usuario#">
					<cfprocparam type="in" dbvarname="p_nome" cfsqltype="cf_sql_varchar" value="#arguments.nome#">
					<cfprocparam type="in" dbvarname="p_descricao" cfsqltype="cf_sql_varchar" value="#arguments.descricao#">
					<cfprocparam type="in" dbvarname="p_cod_pessoa" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa#">
					<cfprocparam type="in" dbvarname="p_ativo" cfsqltype="cf_sql_integer" value="#arguments.ativo#">
					<cfprocparam type="in" dbvarname="p_username" cfsqltype="cf_sql_varchar" value="#GetToken(arguments.email,1,'@')#">
					<cfprocparam type="in" dbvarname="p_provedor" cfsqltype="cf_sql_varchar" value="#GetToken(arguments.email,2,'@')#">
				</cfstoredproc>
			</cftransaction>
			<cfscript>
				v_modulo_id = this.ListaToArray (lista = arguments, variavel = "MODULO_ID_MODULOS");
				v_nivel = this.ListaToArray (lista = arguments, variavel = "NIVEL_ACESSO_MODULOS");
				v_modulo_excluir = this.ListDiff(lista1 = arguments.lista_deleted_MODULOS, lista2 = ArrayToList(v_modulo_id));
			</cfscript>
			<cfloop list="#v_modulo_excluir#" delimiters="," index="l_modulo_id">
				<cfstoredproc procedure="acesso.pkg_acesso.prc_del_modulo_usuario" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_modulo_id" type="in" value="#l_modulo_id#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_usuario" type="in" value="#arguments.usuario#" cfsqltype="cf_sql_varchar">
				</cfstoredproc>
			</cfloop>
			<cfloop from="1" to="#ArrayLen(v_modulo_id)#" index="count">
				<cfstoredproc procedure="acesso.pkg_acesso.prc_ins_modulo_usuario" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_modulo_id" type="in" value="#v_modulo_id[count]#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_usuario" type="in" value="#arguments.usuario#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_nivel_acesso" type="in" value="#v_nivel[count]#" cfsqltype="cf_sql_integer">
				</cfstoredproc>	
			</cfloop>			
			<cfset retorno.mensagem = 'Usurio ' & #nome# & ' alterado com sucesso!'>
			<cfset retorno.erro     = false >	
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
	<cfreturn retorno>	
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere um nivel de acesso
	-- CRISTOFER 09/09/2005 - criado
	--->			
	<cffunction name="ins_nivel_acesso" access="remote" returntype="Struct" output="true">
		<cfargument name="nivel_acesso" required="yes">
		<cfargument name="descricao" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="acesso.pkg_acesso.prc_ins_nivel_acesso" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_nivel_acesso" type="in" value="#arguments.nivel_acesso#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_descricao" type="in" value="#arguments.descricao#" cfsqltype="cf_sql_varchar">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Nivel de acesso inserido com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um nivel de acesso
	-- CRISTOFER 09/09/2005 - criado
	--->			
	<cffunction name="upd_nivel_acesso" displayname="Altera um contato na agenda" access="remote" returntype="Struct" output="true">
		<cfargument name="nivel_acesso" required="yes">
		<cfargument name="descricao" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="acesso.pkg_acesso.prc_alt_nivel_acesso" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_nivel_acesso" type="in" value="#arguments.nivel_acesso#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_descricao" type="in" value="#arguments.descricao#" cfsqltype="cf_sql_varchar">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Nivel de acesso alterado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um nivel de acesso
	-- CRISTOFER 09/09/2005 - criado
	--->			
	<cffunction name="del_nivel_acesso" access="remote" returntype="Struct" output="true">
		<cfargument name="nivel_acesso" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="acesso.pkg_acesso.prc_del_nivel_acesso" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_nivel_acesso" type="in" value="#arguments.nivel_acesso#" cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Nivel de acesso excluido com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere o item de ajuda
	-- guto 06/07/2006 15:17:29 - CRIADO
	--->
	<cffunction name='ins_ajuda' displayname='Insere o item de ajuda' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TITULO' required='yes'>
		<cfargument name='DESCRICAO_CAMPOS' required='yes'>
		<cfargument name='CONTEUDO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='acesso.pkg_ajuda.prc_ins_ajuda' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_CLOB' dbvarname='P_DESCRICAO_CAMPOS'  value='#arguments.DESCRICAO_CAMPOS#'  null='#iif(len(trim(arguments.DESCRICAO_CAMPOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_CLOB' dbvarname='P_CONTEUDO'  value='#arguments.CONTEUDO#'  null='#iif(len(trim(arguments.CONTEUDO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AJUDA_ID' variable='retorno.AJUDA_ID'  null='#iif(len(trim(arguments.AJUDA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Item inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Altera o item de ajuda
	-- guto 06/07/2006 15:36:09 - CRIADO
	--->
	<cffunction name='upd_ajuda' displayname='Altera o item de ajuda' access='remote' returntype='Struct' output='true'>;
		<cfargument name='AJUDA_ID' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='DESCRICAO_CAMPOS' required='yes'>
		<cfargument name='CONTEUDO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='acesso.pkg_ajuda.prc_alt_ajuda' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AJUDA_ID'  value='#arguments.AJUDA_ID#'  null='#iif(len(trim(arguments.AJUDA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_CLOB' dbvarname='P_DESCRICAO_CAMPOS'  value='#arguments.DESCRICAO_CAMPOS#'  null='#iif(len(trim(arguments.DESCRICAO_CAMPOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_CLOB' dbvarname='P_CONTEUDO'  value='#arguments.CONTEUDO#'  null='#iif(len(trim(arguments.CONTEUDO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Item alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Exclui o item de ajuda
	-- guto 06/07/2006 15:38:19 - CRIADO
	--->
	<cffunction name='del_ajuda' displayname='Exclui o item de ajuda' access='remote' returntype='Struct' output='true'>;
		<cfargument name='AJUDA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='acesso.pkg_ajuda.prc_del_ajuda' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AJUDA_ID'  value='#arguments.AJUDA_ID#'  null='#iif(len(trim(arguments.AJUDA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Item excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- ALtera IDIOMA
	-- guto 03/02/2008 - CRIADO
	--->
	<cffunction name='altera_idioma' access='remote' returntype='Struct' output='true'>;
		<cfargument name='IDIOMA' required='yes'>
			
			<cfset session.idioma = arguments.idioma>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Idioma alterado com sucesso!')>
            
		<cfreturn retorno />
	</cffunction>	
    
    
    <!--- 
	-- PROPSITO
	-- Registra login do usuario no sistema
	-- WAGNERS 17/06/2010 17:25:46 - CRIADO
	--->
	<cffunction name='registra_login' displayname='Registra login do usuario no sistema' access='remote' returntype='Struct' output='true'>
		<cfargument name='IP' required='yes'>
		<cfargument name='PROGRAM' required='yes'>
		<cfargument name='COD_PORTAL' required='yes' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='acesso.pkg_acesso.prc_registra_login' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_IP'  value='#arguments.IP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROGRAM'  value='#arguments.PROGRAM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_PORTAL'  value='#arguments.COD_PORTAL#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONEXAO_ID' variable='retorno.CONEXAO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Registro efetuado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
</cfcomponent>