<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Libera solicitao para compra
    -- GUTO 08/02/2010 17:29:58 - CRIADO
    --->
    <cffunction name='libera_compra' displayname='Libera solicitao para compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='compras.pkg_compras.prc_libera_solic_compra' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SOLICITACAO_ID'  value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Compra liberada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset retorno.mensagemStr = cfcatch.Detail>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Aprova cotao
    -- GUTO 08/02/2010 17:29:58 - CRIADO
    --->
    <cffunction name='aprova_cotacao' displayname='Libera solicitao para compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='COTACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='compras.pkg_compras.prc_aprova_cotacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COTACAO_ID'  value='#arguments.COTACAO_ID#'  null='#iif(len(trim(arguments.COTACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Cotao aprovada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset retorno.mensagemStr = cfcatch.Detail>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    
    <!--- 
    -- PROPSITO
    -- Desaprova cotao
    -- GUTO 08/02/2010 17:29:58 - CRIADO
    --->
    <cffunction name='desaprova_cotacao' displayname='Libera solicitao para compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='COTACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='compras.pkg_compras.prc_desaprova_cotacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COTACAO_ID'  value='#arguments.COTACAO_ID#'  null='#iif(len(trim(arguments.COTACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Cotao desaprovada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset retorno.mensagemStr = cfcatch.Detail>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Simular parcelamento mensal.
    -- LINCOLNS 29/03/2011 16:22:57 - CRIADO
    --->
    <cffunction name='simular_parcelas_mes' displayname='Simular parcelamento mensal.' access='remote' returntype='Struct' output='true'>
        <cfargument name='DATA_PRIM_VENCTO' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cfargument name='QTDE_PARCELAS' required='yes'>
        <cftry>
            <cfstoredproc procedure='compras.pkg_compras.prc_simular_parcelas_mes' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PRIM_VENCTO'  value='#arguments.DATA_PRIM_VENCTO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_PARCELAS'  value='#arguments.QTDE_PARCELAS#'  null='#iif(len(trim(arguments.QTDE_PARCELAS)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Simular parcelamento dirio.
	-- LINCOLNS 29/03/2011 16:24:41 - CRIADO
	--->
	<cffunction name='simular_parcelas_dias' displayname='Simular parcelamento dirio.' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_PRIM_VENCTO' required='yes'>
		<cfargument name='QTDE_DIAS_VENCTO' required='yes'>
		<cfargument name='QTDE_PARCELAS' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cftry>
            <cfstoredproc procedure='compras.pkg_compras.prc_simular_parcelas_dias' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PRIM_VENCTO'  value='#arguments.DATA_PRIM_VENCTO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_DIAS_VENCTO'  value='#arguments.QTDE_DIAS_VENCTO#'  null='#iif(len(trim(arguments.QTDE_DIAS_VENCTO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_PARCELAS'  value='#arguments.QTDE_PARCELAS#'  null='#iif(len(trim(arguments.QTDE_PARCELAS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>