<cffunction name="fnc_trata_erros" displayname="Manipulao dos erros para interface amigavel para o usuario" access="public" output="true">
	<cfargument name="struct_erro" required="yes">
	<cfargument name="mostra_msg_ok" required="no" default="true">
	<cfargument name="iframe" required="no" default="false">
    <cfargument name="format_erro" required="no" default="true">
    <cfargument name="abort_on_error" required="no" default="true">
    <cfargument name="abre_popup" required="no" default="true" >
    <cfset retorno = structnew()>
    
    <cfif struct_erro.erro>
	   	<cfset session.last_session_error = struct_erro.mensagem>
	</cfif>
    <cfif format_erro>
		<cfset retorno.mensagem = fnc_format_erro(argumentCollection = struct_erro)>
    </cfif>

	<cfif not struct_erro.erro>
		<!--- Caso no haja erro --->
		<cfif arguments.mostra_msg_ok eq 'true'>
			<script language="javascript1.2">
				alert('<cfoutput>#JSStringFormat(struct_erro.mensagem)#</cfoutput>');
			</script>
		</cfif>
		<cfreturn>
	<cfelse>
		<cftry>
			<cfstoredproc procedure="dbms_session.reset_package" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			</cfstoredproc>
			<cfcatch>
				<!--- No executa nada --->
			</cfcatch>
		</cftry>
		<script language="javascript1.2" src="/_scripts/scripts_db.js"></script>
		<cfif arguments.iframe eq "false">
			<script language="javascript1.2">
				try {
					parent.document.forms[0].CONFIRMA.value = 1;
				} catch(e) {}
			</script>
			<!--- Para o caso de erro monta estrutura para enviar os dados do erro --->
			<html>
<body>
<div><form name="form_erro" id="form_erro" method="post" action="/publico/mensagem_erro.cfm" target="msg_erro">
				<cfoutput>
					<cfif isdefined("arguments.struct_erro.mensagem.NativeErrorCode")>
					<input type="hidden" name="native_error_code" id="native_error_code" value="#arguments.struct_erro.mensagem.NativeErrorCode#" />
					</cfif>
                    <cfif not isstruct(retorno.mensagem)>
                        <input type="hidden" name="mensagem" value="#URLEncodedFormat(retorno.mensagem)#">
                    <cfelse>
                        <input type="hidden" name="mensagem" value="Nao foi possivel identificar o erro. Por favor, envie-o para o suporte!">
                    </cfif>
                    
					<cfset erro = fnc_dump(estrutura = arguments.struct_erro.mensagem)>
                    <cfloop from="1" to="#ArrayLen(erro)#" index="v_index">
							
						<cfif StructKeyExists(erro[v_index],'valor') and isSimpleValue(erro[v_index].valor)>
							<cfif UCase(erro[v_index].nome) eq "WHERE">
								<cfset erro[v_index].valor = fnc_format_params(where = erro[v_index].valor)>
							</cfif>
							<input type="hidden" name="Error_nome_#v_index#" value="#erro[v_index].nome#" />
							<input type="hidden" name="Error_valor_#v_index#" value="#URLEncodedFormat(Replace(erro[v_index].valor, '"', "'", 'All'))#" />
						</cfif>
					</cfloop>
					<input type="hidden" name="Error_nome_#ArrayLen(erro)+1#" value="Local de Origem" />
					<input type="hidden" name="Error_valor_#ArrayLen(erro)+1#" value="#cgi.HTTP_REFERER#" />
					<input type="hidden" name="Error_nome_#ArrayLen(erro)+2#" value="Local" />
					<input type="hidden" name="Error_valor_#ArrayLen(erro)+2#" value="#cgi.SCRIPT_NAME#" />
                    <cfif not isdefined("vars")>
                    		<cfscript>
									vars = StructNew();
									
									if (isDefined("URL")) {
										for (key in URL) {
											vars[key] = evaluate('URL.'&key);	
										}
									}
									if (isDefined("FORM")) {
										for (key in FORM) {
											vars[key] = evaluate('FORM.'&key);	
										}
									}	
							</cfscript>	
                    </cfif>
                    
<!---                    <cfset vars_ordered = StructSort(vars,'textnocase')>
                    <cfset struct_vars = StructNew()>
					<cfloop array="#vars_ordered#" index="v_index">
                    	<cfset struct_vars[v_index] = vars[v_index]>
                    </cfloop>
                    <cfset variaveis = fnc_dump(estrutura = struct_vars)>                    
                    <cfdump var="#vars_ordered#">
                    <cfdump var="#struct_vars#">
                    <cfdump var="#variaveis#">
--->					
                    <cfset variaveis = fnc_dump(estrutura = vars)>                    
					<cfloop from="1" to="#ArrayLen(variaveis)#" index="v_index">
						<cfif isSimpleValue(variaveis[v_index].valor)>
							<input type="hidden" name="Vars_nome_#v_index#" value="#variaveis[v_index].nome#" />
							<input type="hidden" name="Vars_valor_#v_index#" value="#variaveis[v_index].valor#" />
						</cfif>
					</cfloop>
				</cfoutput>
			</form></div>
</body>
</html>
			<script language="javascript1.2" src="/_scripts/scripts_db.js"></script>
			<script language="javascript1.2">
				try {
					parent.f_reabilitar_confirmar();
				} catch(e) {}
				try {
					opener.f_reabilitar_confirmar();
				} catch(e) {}
				
				<cfif arguments.abre_popup eq 'true' >
					showModal('<cf_url>/publico/mensagem_erro.cfm</cf_url>', 'msg_erro', 'yes', 'yes', 'no', 600, 600);
					document.form_erro.submit();
				</cfif>
			</script>
		<cfelse>
			<script>
				alert('#JSStringFormat(retorno.mensagem)#');
			</script>
		</cfif>
        <cfif abort_on_error>
			<cfabort>
        </cfif>
	</cfif>
</cffunction>
<cffunction name="fnc_get_parameters" displayname="Busca os valores passados para um procedimento do banco" returntype="array" access="public">
	<cfargument name="str_params" required="yes">
  
</cffunction>

<cffunction name="fnc_dump" displayname="desmenbra uma estrutura em um array" returntype="array" access="public">
	<cfargument name="estrutura" required="yes">
    <cftry>
		<cfscript>
            ar = ArrayNew(1);
			for (chave in estrutura) {
				ar[arrayLen(ar)+1] = StructNew();
				ar[arrayLen(ar)].nome = chave;
				ar[arrayLen(ar)].valor = fnc_dump_struct(estrutura[chave]);
				if(ucase(chave) eq "GENERATEDCONTENT") {
					ar[arrayLen(ar)].valor = "[No Disponivel para Visualizao]";
				}
			}
            return ar;
        </cfscript>
    	<cfcatch>
        </cfcatch>
    </cftry>
    <cfreturn ar>
</cffunction>
<cffunction name="fnc_dump_struct" displayname="desmenbra uma estrutura em um array" returntype="string" access="public">
	<cfargument name="estrutura" required="yes">
    <cftry>
		<cfscript>
            v_result = "";
            if(isarray(arguments.estrutura)) {
                v_result = "<table class='borda' cellpadding='3' cellspacing='1' border='0'>";
                v_result = v_result&"<thead onclick='f_show_hide(this.parentNode.tBodies[0])' style='cursor: pointer'><tr class='titulo_1'><td>Variavel</td><td>Valor</td></tr></thead><tbody style='display:'>";
                for (i=1;i le arraylen(arguments.estrutura);i = i + 1) {
                    v_result = v_result&"<tr class='linha_2'><td>#i#</td><td>#fnc_dump_struct(arguments.estrutura[i])#</td></tr>";
                }
                v_result = v_result&"</tbody></table>";
            } else if (isstruct(arguments.estrutura) or isobject(arguments.estrutura)) {
                v_result = "<table class='borda' cellpadding='3' cellspacing='1' border='0'>";
                v_result = v_result&"<thead onclick='f_show_hide(this.parentNode.tBodies[0])' style='cursor: pointer'><tr class='titulo_1'><td>Variavel</td><td>Valor</td></tr></thead><tbody style='display:'>";
                for (chave in estrutura) {
					if(chave eq 'SQL' and isSimpleValue(estrutura[chave])) {
						v_result = v_result&"<tr class='linha_2'><td>#ucase(chave)#</td><td><pre>#fnc_dump_struct(arguments.estrutura[chave])#</pre></td></tr>";
					} else { 
	                    v_result = v_result&"<tr class='linha_2'><td>#ucase(chave)#</td><td>#fnc_dump_struct(arguments.estrutura[chave])#</td></tr>";
					}
                }
                v_result = v_result&"</tbody></table>";
            } else {
                v_result = estrutura;
            }
            return v_result;
        </cfscript>
        <cfcatch>
        	<cfreturn "[No foi possvel Detalhar o Objeto]">
        </cfcatch>
    </cftry>
</cffunction>

<cffunction name="fnc_format_erro" displayname="Trata a mensagem de erro gerada para tornar mais clara ao usurio" returntype="string" access="public" output="true">
	<cfargument name="type" required="no" default="">
	<cfargument name="detail" required="no" default="">
	<cfargument name="paramName" required="no" default="">
	<cfargument name="FunctionName" required="no" default="">
	<cfargument name="ErrorCode" required="no" default="">
	<cfargument name="NativeErrorCode" required="no" default="">
	<cfargument name="Message" required="no" default="">
	<cfargument name="Mensagem" required="no" default="">
	<!--- Tratamento de deadlocks --->
	<cfscript>
		retorno.mensagem = '';
		if (not Len(Trim(arguments.Detail)) and IsDefined("arguments.mensagem.Detail")) {
			arguments.Detail = arguments.mensagem.Detail;
		}
		if (not Len(Trim(arguments.type)) and IsDefined("arguments.mensagem.type")) {
			arguments.type = arguments.mensagem.type;
		}
		if (not Len(Trim(arguments.paramName)) and IsDefined("arguments.mensagem.paramName")) {
			arguments.paramName = arguments.mensagem.paramName;
		}
		if (not Len(Trim(arguments.FunctionName)) and IsDefined("arguments.mensagem.FunctionName")) {
			arguments.FunctionName = arguments.mensagem.FunctionName;
		}
		if (not Len(Trim(arguments.ErrorCode)) and IsDefined("arguments.mensagem.ErrorCode") ) {
			arguments.ErrorCode = arguments.mensagem.ErrorCode;
		}
		if (not Len(Trim(arguments.Message)) and IsDefined("arguments.mensagem.Message")) {
			arguments.Message = arguments.mensagem.Message;
		}
		if (not Len(Trim(arguments.NativeErrorCode)) and IsDefined("arguments.mensagem.NativeErrorCode")) {
			arguments.NativeErrorCode = arguments.mensagem.NativeErrorCode;
		}
		
		if(isdefined("arguments.mensagem.type")) {
			switch ( arguments.mensagem.Type ) {
				case 'Database' :
					retorno.mensagem = arguments.mensagem.detail; 
					if (arguments.mensagem.NativeErrorCode eq 12889)
						retorno.mensagem = Replace(Replace(Replace(Mid(arguments.mensagem.Detail, Find('column',arguments.mensagem.Detail)+6,Len(arguments.mensagem.Detail)),'"','','all'),'actual','digitado'),'maximum','mximo');
					if (arguments.mensagem.NativeErrorCode eq 12889)
						retorno.mensagem = Replace(Replace(Replace(Mid(arguments.mensagem.Detail, Find('column',arguments.mensagem.Detail)+6,Len(arguments.mensagem.Detail)),'"','','all'),'actual','digitado'),'maximum','mximo');
					if(FindNoCase('ORA-', retorno.mensagem)) {
						retorno.mensagem = Mid(retorno.mensagem,FindNoCase(': ',retorno.mensagem)+2,Len(retorno.mensagem));
					}
					if(FindNoCase('ORA-', retorno.mensagem)) {
						retorno.mensagem = Mid(retorno.mensagem,1,FindNoCase('ORA',retorno.mensagem)-1);
					}
					// Limpa erro quando for uma CC
//					if (arguments.ErrorCode eq 1400 or arguments.NativeErrorCode eq 1400)
//						retorno.mensagem = Replace(Replace(Replace(Replace(retorno.mensagem & ' ' & RemoveChars(struct_erro.Detail,1,Find('"."',struct_erro.Detail,Find('"."',struct_erro.Detail)+2)),'"','','all'),')','','all'),'.','','all'),'_',' ','all');
					if (arguments.ErrorCode eq 1 or arguments.NativeErrorCode eq 1)
						retorno.mensagem = 'Chave nica violada! Os campos de identificao no podem ser repetidos.';
					if (arguments.ErrorCode eq 1031 or  arguments.NativeErrorCode eq 1031)
						retorno.mensagem = 'Privilgios insuficientes.';
					if (arguments.ErrorCode eq 2292 or  arguments.NativeErrorCode eq 2292)
						retorno.mensagem = 'Chave pai violada, este item est sendo usado em outro cadastro';
					if (FindNoCase("FKC_PSU_PF",retorno.mensagem))
						retorno.mensagem = 'Usurio no vinculado a uma pessoa fsica, verifique o cadastro do usurio.';
					if (FindNoCase("CC_RHV_00",retorno.mensagem))
						retorno.mensagem = 'O KM do inicio da viagem no pode ser igual ao KM de fim. Verifique os dados.';
					if (FindNoCase("CC_PLOC_00",retorno.mensagem))
						retorno.mensagem = 'Data de previso de chegada deve ser maior que a data de hoje.';
					if (FindNoCase("FISCAL.UKC_CNTO",retorno.mensagem))
						retorno.mensagem = 'Documento j inserido no sistema.';
					break; 	  
				case 'Application' : 
					if (IsDefined("arguments.paramName")) {
						retorno.mensagem = "O campo " & arguments.paramName & "  obrigatrio.|" & arguments.detail;
					}
					if (Isdefined("arguments.detail") and len(trim(arguments.detail))) {
						retorno.mensagem = arguments.detail;
					}
					if (Isdefined("arguments.message") and len(trim(arguments.message))) {
						retorno.mensagem = arguments.message;
					}
					break; 	 
				case 'numeric' : 
					retorno.mensagem = "O campo " & arguments.arg & " deve ser preenchido com um valor numrico.";
					break; 	  						  
				case 'date' : 
					retorno.mensagem = "O campo " & Replace(struct_erro.arg,"_"," ","all") & " deve ser preenchido com uma data vlida.";
					if (not isDefined("SESSION.erro")) 
						session.erro_tecnico = 'FUNO: ' & arguments.functionName  & ' ERRO: ' & arguments.Message ;
					break; 	 
				default:
					retorno.mensagem = 'No foi possvel identificar o erro, envie-o para a equipe de suporte!';
					break;
											  
			}
		} else {
			retorno.mensagem = arguments.mensagem;
		}
		
		if (Len(Trim(retorno.mensagem)) and IsDefined("arguments.mensagem.detail") and len(trim(arguments.mensagem.detail)) ) {
			retorno.mensagem = arguments.mensagem.detail;
		}
		if (Len(Trim(retorno.mensagem)) and IsDefined("arguments.detail") and ((not isdefined("arguments.type")) or ucase(arguments.type) neq 'APPLICATION'  ) ) {
			if(arguments.NativeErrorCode gte 20000 and arguments.NativeErrorCode lte 20999) {
				retorno.mensagem = replace(arguments.detail,'[Macromedia][Oracle JDBC Driver][Oracle]ORA-' & arguments.NativeErrorCode & ':','');
				retorno.mensagem = replace(arguments.detail,'ORA-' & arguments.NativeErrorCode & ':','');
				if(find('ORA-',retorno.mensagem) gt 1) {
					retorno.mensagem = Left(retorno.mensagem,find('ORA-',retorno.mensagem)-1);
				}
			} else {
				retorno.mensagem = replace(arguments.detail,'[Macromedia][Oracle JDBC Driver][Oracle]','');
			}
		}
	</cfscript>	
	<cfreturn retorno.mensagem>
</cffunction>

<cffunction name="fnc_format_params" displayname="Formata os parametros de um procedure" access="public" returntype="string">
	<cfargument name="where" required="yes">
	<cfset retorno = Replace(arguments.where, '(param ', chr(140), 'all')>
	<cftry>
		<cfset ar = arrayNew(1)>
		<cfset ar2 = arrayNew(1)>
		<cfloop list="#retorno#" delimiters="#chr(140)#" index="v_index2">
			<cfif len(trim(v_index2))>
				<cfset ar[ArrayLen(ar)+1] = v_index2>
			</cfif>
		</cfloop>
		<cfset retorno = "<table class='borda'><thead><tr class='titulo_2' onclick='sortColumn(event);' style='cursor: pointer'><td type='number'>Nro</td><td type='caseinsensitivestring'>Valor</td><td type='caseinsensitivestring'>TYPE</td><td type='caseinsensitivestring'>SQLTYPE</td><td type='nao_ordenar'></td></tr></thead><tbody>">
		<cfloop from="1" to="#arrayLen(ar)#" index="v_index2">
			<cftry>
				<cfset ar2[v_index2] = StructNew()>
				<cfset start = Find("value='", ar[v_index2])+7>
				<cfset ar2[v_index2].value = Mid(ar[v_index2], start, Find("'", ar[v_index2], start) - start)> 
				<cfset start = Find("sqltype='", ar[v_index2])+9>
				<cfset ar2[v_index2].sqltype = Mid(ar[v_index2], start, Find("'", ar[v_index2], start) - start)> 
				<cfset start = Find("type='", ar[v_index2])+6>
				<cfset ar2[v_index2].type = Mid(ar[v_index2], start, Find("'", ar[v_index2], start) - start)> 
				<cfif ucase(trim(ar2[v_index2].type)) eq 'OUT'>
					<cfset ar2[v_index2].value = "[No definido]"> 
				</cfif>
				<cfset v_verificado = ''>
				<cfif listFindnocase("cf_sql_integer,cf_sql_numeric,cf_sql_float",ar2[v_index2].sqltype)>
					<cfif isnumeric(ar2[v_index2].value) or ar2[v_index2].value eq "null" or ucase(trim(ar2[v_index2].type)) eq 'OUT'>
						<cfset v_verificado = '<img width="16" height="16" src="http://#cgi.HTTP_HOST#/_imagens/botoes/16x16/confirmar.gif">'>
					<cfelse>
						<cfset v_verificado = '<img width="16" height="16" src="http://#cgi.HTTP_HOST#/_imagens/botoes/16x16/cancelar.gif">'>
					</cfif>
				</cfif>
				<cfset retorno = retorno&"<tr class='linha_2'><td>#v_index2#</td><td>#ar2[v_index2].value#</td><td>#ar2[v_index2].type#</td><td>#ar2[v_index2].sqltype#</td><td>#v_verificado#</td></tr>">
				<cfcatch>
					<cfset retorno = retorno&"<tr class='linha_2'><td colspan='4'>"&ar[v_index2]&"</td></tr>">
				</cfcatch>
			</cftry>
		</cfloop>
		<cfset retorno = retorno&"</tbody></table>">
		<cfcatch>
			<cfset retorno = Replace(arguments.where, ', (param ', ',<br>(param ', 'all')>
		</cfcatch>
	</cftry>
	<cfreturn retorno>
</cffunction>
<cffunction name="listUniqueNocase" returntype="string">
	<cfargument name="list" required="yes">
    <cfargument name="delimiter" required="no" default=",">
    <cfset v_result = ''>
	<cfloop list="#arguments.list#" delimiters="#arguments.delimiter#" index="l_id">
    	<cfif not listFindNoCase(v_result,l_id,arguments.delimiter)>
	    	<cfset v_result = listAppend(v_result,l_id,arguments.delimiter)>
        </cfif>
    </cfloop>
    <cfreturn v_result>
</cffunction>
<cffunction name="listUnique" returntype="string">
	<cfargument name="list" required="yes">
    <cfargument name="delimiter" required="no" default=",">
    <cfset v_result = ''>
	<cfloop list="#arguments.list#" delimiters="#arguments.delimiter#" index="l_id">
    	<cfif not listFind(v_result,l_id,arguments.delimiter)>
	    	<cfset v_result = listAppend(v_result,l_id,arguments.delimiter)>
        </cfif>
    </cfloop>
    <cfreturn v_result>
</cffunction>
<cfscript>
function ListDeleteDuplicatesNoCase(list){
	var i = 1;
	var delimiter = ',';
	var returnValue = '';
	if(ArrayLen(arguments) GTE 2)
		delimiter = arguments[2];
	list = ListToArray(list, delimiter);
	for(i = 1; i LTE ArrayLen(list); i = i + 1)
	if(NOT ListFindNoCase(returnValue, list[i], delimiter))
		returnValue = ListAppend(returnValue, list[i], delimiter);
	return returnValue;
}

function LimpaTags(text) {
	return rereplace(text,"(<[^>]*>)",'','all');
}

function TextCut(text,length) {
	v_result = left(LimpaTags(text),length);
	v_fim = mid(LimpaTags(text),length+1,200);
	if(left(v_fim,1) eq " ") 
		v_result = v_result&" ";
	if(listlen(v_fim,' ') gt 0) {
		v_result = v_result&listgetat(v_fim,1,' ');
	}
	return trim(v_result);
}

function RichEditUnFormat(text) {
	return replacenocase(replacenocase(replacenocase(replacenocase(text,'<p','<span','all'),'</p','</span','all'),' face=','&nbsp;face=','all'),'<img','<imasdfasd','all');
}

function DestacaLista(text,lista,delimiters,className) {

	/*
	v_result = text;
	return v_result;
	v_texto_clean = StringClean(text);
	v_lista_clean = StringClean(lista);
	for(i=1;i le listlen(v_lista_clean,delimiters);i=i+1) {
		v_texto_clean = StringClean(v_result);
		v_not_find = false;
		v_fim = 0;
		v_compensacao = 0;
		while (not v_not_find) {
			v_inicio = FindNoCase(listGetAt(v_lista_clean,i,delimiters),v_texto_clean,v_fim-1);
			if(v_inicio) {
				v_fim = Len(listGetAt(v_lista_clean,i,delimiters))+v_inicio;
				v_result = Insert('</span>',v_result,v_fim-1+v_compensacao);
				v_result = Insert('<span class="'&arguments.className&'">',v_result,v_inicio-1+v_compensacao);
				v_compensacao = v_compensacao + Len('<span class="'&arguments.className&'"></span>');
			} else {
				v_not_find = true;
			}
		}
	}
	return v_result;
	*/
	return text;
}

function StringClean(text) {
	return ReplaceList(text
		,',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
		,'a,a,a,a,a,A,A,A,A,A,e,e,e,e,E,E,E,E,i,i,i,i,I,I,I,I,o,o,o,o,o,O,O,O,O,O,u,u,u,u,U,U,U,U,n,N,c,C');
}

function lpad(text,length,compl) {
	v_result = text;
	if(len(v_result) lt length) {
		while(len(v_result) lt length) {
			v_result = compl&v_result;
		}
	}
	if(len(v_result) gt length) {
		v_result = right(v_result,length);
	}
	return v_result;
}

function rpad(text,length,compl) {
	v_result = text;
	if(len(v_result) lt length) {
		while(len(v_result) lt length) {
			v_result = v_result&compl;
		}
	}
	if(len(v_result) gt length) {
		v_result = left(v_result,length);
	}
	return v_result;
}

function nvl(value,nullvalue) {
	if(not len(trim(value)))
		return nullvalue;
	else
		return value;
}

function initcap(str) {
	str = ucase(left(str,1)) & lcase(right(str,len(str)-1));	
	
	return str;
}

function f_url(v_url) {
    v_content = v_url;
    if (Find('?',v_url)) {
	   v_content = Mid(v_url,1,Find('?',v_url)-1);
    }	
	if(listgetat(v_url,1,'/') eq "_transportes") {
		v_content = ListSetAt(v_content,1,'_componentes','/');
	}

	if(FileExists(Replace(ExpandPath("/")&session.site&v_content, "//", "/", "ALL"))) {
		v_url = JSStringFormat(trim(Replace(Replace("/"&session.site&v_content, "//", "/", "ALL"), "//", "/", "ALL")));
	} else v_url = v_content;
	
	return trim(v_url);
}

</cfscript>
 

<cffunction name="formataCpfCnpj" access="public" returntype="string">
    <cfargument name="cpf_cnpj" required="yes">
    <cfset v_result = ''>
    <cfscript>
	if(Len(trim(cpf_cnpj))<=11){
	for(i=1; i <= len(cpf_cnpj); i++){
						if(i==4||i==7)
							v_result &= ".";
						if(i==10)
							v_result &= "-";
							
					    v_result &= Mid(cpf_cnpj,i,1);	
					}
	}
	else
	if(Len(Trim(cpf_cnpj))>=12){
    for(i=1; i <= len(cpf_cnpj); i++){
						if(i==3||i==6)
							v_result &= ".";
						if(i==13)
							v_result &= "-";
                        if(i==9)
                        	v_result &= "/";
							
					    v_result &= Mid(cpf_cnpj,i,1);	
					}
    }else v_result = cpf_cnpj; 
    
    </cfscript>
    <cfreturn v_result>
</cffunction>

<cffunction name="CreateComponent" access="public" returntype="any">
    <cfargument name="class_name" required="yes">
    <cfscript>
		v_interno = arguments.class_name;
    	if(lcase(ListGetAt(v_interno,1,'.')) eq "_transportes") {
			v_interno = ListSetAt(v_interno,1,replace(session.site&'_componentes','/','.','all'),'.');
		} else {
			v_interno = v_interno;
		}
		if(FileExists(expandPath('/'&replace(v_interno,'.','/','all')&".cfc"))) {
			v_class_name = v_interno;
		} else {
			v_class_name = arguments.class_name;
		}
		
		return CreateObject("component",v_class_name);
	</cfscript>
    <cfreturn v_result>
</cffunction>


<cffunction name="listDeleteNulls" access="public" returntype="string">
    <cfargument name="list" required="yes">
    <cfargument name="delimiter" required="no" default=",">
    <cfset v_result = ''>
    <cfloop list="#arguments.list#" delimiters="#arguments.delimiter#" index="value">
        <cfif len(trim(value))>
            <cfset v_result = ListAppend(v_result,value,arguments.delimiter)>
        </cfif>
    </cfloop>
    <cfreturn v_result>
</cffunction>

<!--- 
-- PROPSITO 
-- Criptografa uma palavra
-- CRISTOFER  20/06/2007
--->		
<cffunction name="get_encrypt" access="remote" returntype="String" output="true">
	<cfargument name="text" required="yes">
	<cfreturn Encrypt(arguments.text,'KMMCORPORATION','CFMX_COMPAT','HEX')>
</cffunction>

<!--- 
-- PROPSITO 
-- Descriptografa uma palavra
-- CRISTOFER  20/06/2007
--->		
<cffunction name="get_decrypt" access="remote" returntype="String" output="true">
	<cfargument name="text" required="yes">        
	<cfreturn Decrypt(arguments.text,'KMMCORPORATION','CFMX_COMPAT','HEX')>
</cffunction>
