<cfcomponent >
<cfscript>

/**
 * @descritivo	: Deleta Duplicatas
 * @parametro	: lista   : string. ( Requerido )
 * @retorno		: lista
 * @autor       : Jefferson Petilo( jefferson@kmm.com.br ) 
 * @verso		: 1, 22  de Fevereiro 2004
 */					
 
function deletaDuplicatas( lista )
{
  var i 		 = 1;
  var delim 	 = ',';
  var nova_lista = '';
  
  if(	ArrayLen( arguments ) gte 2 ) delim = arguments[ 2 ];
		
  lista = ListToArray( lista , delim );
	
	for( i = 1; i LTE ArrayLen( lista ); i = i + 1 )
	 if( NOT ListFind( nova_lista, lista[ i ], delim ) )
	     nova_lista = ListAppend( nova_lista , lista[ i ], delim );
				  
  return ( nova_lista );
}

/**
 * @descritivo	: Verifica se  o Texto  no-numrico
 * @parametro	: string   : string. ( Requerido )
 * @retorno		: string
 * @autor       : Jefferson Petilo( jefferson@kmm.com.br ) 
 * @verso		: 1, 18  de Fevereiro 2004
 */					
 
function IsString( string )
{ 
  return ( NOT ReFindNoCase("[^A-Z\.[:space:]]", string ) ); 
}
 
/**
 * @descritivo	: Converte uma string em um Array Unidimensional
 * @parametro	: string   : string. ( Requerido )
 * @retorno		: Array
 * @autor       : Jefferson Petilo( jefferson@kmm.com.br ) 
 * @verso		: 1, 18  de Fevereiro 2004
 */					
 
function stringToArray( string , count )
{
  var v_array = ArrayNew( 1 );

   while ( len( string ) )
   {
	  ArrayAppend( v_array , Left( string, Min( count, Len( string ) ) ) );
	  
	  if (( len( string ) / count ) gt 1) 
		  string = right( string, len( string ) - count );
	  else 
		string 	 = '';
   }
	
   return ( v_array );
}			

/**
 * @descritivo	: Gera Nmero de Serial
 * @parametro	: sem parmetros
 * @retorno		: string
 * @autor       : Jefferson Petilo( jefferson@kmm.com.br ) 
 * @verso		: 1, 21  de Fevereiro 2004
 */					
 
function serial()
{
   var lista   = 'C|9|G|K|3|M|R|Z|S|5|W|Y|B|6|D|Q|F|8|H|V|J|7|N|P|4|T|X|2|L';
   var erro    = '';
   var serial  = '';
		
	  for ( i = 1; i lte 5; i = i + 1 )
	  {
		 num  = RandRange( 1 , ListLen( lista , '|' ) );
		letra = ListGetAt( lista  , num , '|');
			   serial = ListAppend( serial ,  letra, chr( 32 ) );
	  }
			
	 serial  = Replace( ListChangeDelims( deletaDuplicatas( serial,  chr( 32 ) ), '', chr( 32 ) ), ',','','ALL');
			
		
	if( len ( serial ) eq 5 ) 
		return ( serial );
	else 
		return ( validateSerial ( serial ) 	);
}

/**
 * @descritivo	: Valida Nmero de Serial
 * @parametro	: sKey   : string. ( Requerido )
 * @retorno		: string
 * @autor       : Jefferson Petilo( jefferson@kmm.com.br ) 
 * @verso		: 1, 20  de Fevereiro 2004
 */					

function validateSerial ( skey )
{
	if (  ( len ( skey )  neq 5 )  or ( IsNumeric( skey ) )  or ( IsString ( skey ) ) )
		return ( serial() );
	else
		return (  skey );	
} 

/**
 * @descritivo	: Retorna Mascara de Serial
 * @parametro	: sem paramametros
 * @retorno		: string
 * @autor       : Jefferson Petilo( jefferson@kmm.com.br ) 
 * @verso		: 1, 20 de Fevereiro 2004
 */					
   
function criaSerial()
{
  var prodkey 	 = '';
  var nserie 	 = ArrayNew( 1 );
	 nserie[ 1 ] =   serial() ;
	 nserie[ 2 ] =   serial() ;
	 nserie[ 3 ] =   serial() ;
	 nserie[ 4 ] =   serial() ;
	
	num_serie = StringToArray( ListChangeDelims( ArrayToList( nserie ), chr( 32 ) ) , 6 );
			 
	for ( i = 1; i lte ArrayLen( num_serie ) ; i = i + 1 )
		  prodkey =  ListAppend( prodkey,  Trim( num_serie [ i ]  ) , ('-') ) ; 
		
 return ( prodkey );
}
/**
 * @descritivo	: Adiciona Mscara no serial
 * @parametro		: skey
 * @retorno		: string
 * @autor         : Jefferson Petilo( jefferson@kmm.com.br ) 
 * @verso		: 1, 23 de Fevereiro 2004
 */					
function maskSerial( skey )
{   
  var num_serie 	= stringToArray( skey  , 5 );
  var novo_serial = '';		 
			  
	for ( i = 1; i lte ArrayLen( num_serie ) ; i = i + 1 )
		  novo_serial =  ListAppend( novo_serial ,  Trim( num_serie[ i ]  ) , ('-') ) ; 
			
			
 return ( novo_serial );
 
} 
</cfscript>

</cfcomponent>