<cfcomponent  displayname="KM&M Suporte Tcnico"
			  hint="<b>Site de Suporte da KM&M  de Engenharia de Sistemas</b><br>
				   <b>Autor					: Jefferson Petilo ( jefferson@kmm.com.br )</b><br>
				   <b>Data Criao</b> 		: 20/05/2004<br> 
				   <b>Atualizador			: </b><br>
				   <b>Data Atualizao</b> 	: <br> 
				   <b>Descrio				: </b><br> <div align='justify'>Esse Componente  reponsvel por reunir mtodos de Inicializao dos Componentes.</div>"
>	
			   
<cffunction name="init" displayname="Construtor de Inicializao" access="public" returntype="void" output="true">
   <!--- 
   	-- PROPSITO
	-- Insert na tabela de Acesso Corrente e Persistencia de dados
	-- NOTAS EXPLICATIVAS
	--  
	-- JEFFERSON          20/05/2004 - criado
	--->			
	<cfif IsDefined('Session.usuario') and Len(Trim('Session.usuario'))
	  and IsDefined('Session.usuario') and Len(Trim('Session.senha'))
	  and IsDefined('Session.dsn') and len(trim(session.usuario))>
		<cfset this.usuario = Session.usuario />
		<cfset this.senha	= Session.senha />
		<cfset this.dsn		= Session.dsn />
        <cfscript>
           v_numero = '';
        </cfscript>
		<cftry>
            <!--- seta a role --->
            <cftry>
                <cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    set role kss_corporativo identified by "()##3F20L13RJ@"
                </cfquery>
                
                <!--- Ajusta o idioma --->
				<cfif isdefined("session.idioma") and len(trim(session.idioma))>
                    <cftry>
                        <cfstoredproc procedure='kss.set_cod_idioma' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5'   value='#session.IDIOMA#'  null='#iif(len(trim(session.IDIOMA)), de('no'), de('yes'))#'>
                        </cfstoredproc>
                        <cfcatch>
                        </cfcatch>
                    </cftry>
                </cfif>
                
				<!--- delete na tabela de acesso corrente --->
                <cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    delete from kss.pessoa_usuario_acesso_cur c
                </cfquery>
                
            <cfcatch type="database">
              <cfscript>
                    e = cfcatch;
                    session.erro = e;
                    v_erro = true;
                    v_mensagem = e.getDetail();
                    v_numero = e.getNativeErrorCode();
                    mensagem_erro.erro = true;
                    mensagem_erro.mensagem = e;
                </cfscript>
            </cfcatch>
            <cfcatch type="any">
                <cfscript>
                    e = cfcatch;
                    session.erro = e;
                    v_erro = true;
                    v_numero = 0;
                    v_mensagem = e.getDetail();			
                    mensagem_erro.erro = true;
                    mensagem_erro.mensagem = e;	
                </cfscript>
            </cfcatch>    
            </cftry>
    
    		<cfswitch expression="#v_numero#">
                <cfcase value="1017">
                    <script>
                        alert('Problemas com a conex'+ String.fromCharCode(227)+'o, verifique o usu'+ String.fromCharCode(225)+'rio/senha digitado.');
                        history.go(-1);
                    </script>
                </cfcase>
                <cfcase value="28000">
					<script>
                    	alert('Usu'+ String.fromCharCode(225)+'rio bloqueado. Entre em contato com o administrador do site.');
                    	history.go(-1);
                  	</script>
                </cfcase>
                <cfcase value="28001">
                    <script language="javascript1.2">
                        alert('A senha do usu'+ String.fromCharCode(225)+'rio est expirada.');
                        NewWindow('/aplicacoes/mudar_senha/mudar_senha.cfm?EXPIRADA=1&usuario=' + <cfoutput>'#session.usuario#'</cfoutput>,'_blank', 600,400, 'no');
                    </script>
                    <cfabort>
                </cfcase>
            </cfswitch>

		<cfif isdefined("session.cod_gestao_force")>
                   <cfset session.cod_pessoa_gestao = "">
                   <cfset session.cod_gestao_lock = session.cod_gestao_force>
                </cfif>
            
			<cfif IsDefined("session.cod_pessoa_gestao") and Len(Trim(session.cod_pessoa_gestao))>
                <cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					insert into kss.pessoa_usuario_acesso_cur
					  (cod_pessoa, usuario)
					values
					  (#session.cod_pessoa_gestao#, user)
				</cfquery>		
			<cfelse>
            	
            	<cfparam name="session.cod_gestao_lock" default="1">
                
				<cfif IsDefined("session.cod_gestao_lock") and Len(Trim(session.cod_gestao_lock))>
					<cfquery name="qr_gestao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#"> 
						select cod_pessoa as cod_pessoa, 
							   user as usuario
						  from kss.pessoa_unidade_negocio 
						 where cod_gestao in (#session.cod_gestao_lock#)
					</cfquery>
					
					<cfloop query="qr_gestao">
						
						<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#"> 
							insert into kss.pessoa_usuario_acesso_cur 
								(cod_pessoa, usuario) 
							values
								(#qr_gestao.cod_pessoa#,'#qr_gestao.usuario#')
						</cfquery>
					</cfloop>
				</cfif>
			</cfif>
            
			<cfquery name="session.qrAcessoCur" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				  select * from kss.pessoa_usuario_acesso_cur
			</cfquery>	
			<cfif true or ( not IsDefined("session.cod_gestao") or Len(Trim(session.cod_gestao)) eq 0) >
				<cfquery name="qrEmpresa" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					select kss.getgestao as cod_gestao
					  from dual
				</cfquery>
				<cfset session.cod_gestao = qrEmpresa.cod_gestao>	
				<cfquery name="qrEmpresa" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                        select e.cod_pessoa, e.razao_social, e.nome_fantasia, 
                               p.cnpj_cpf as cnpj,
                               decode(p.tipo_pessoa,2/*Estrangeira*/, pes.endereco, pe.logradouro || decode(pe.numero, '', '', ', ') || pe.numero || decode(pe.complemento, '', '', ' - ') || pe.complemento) as endereco,
                               pe.bairro, 
                               decode(p.tipo_pessoa,2/*Estrangeira*/, pes.codigo_postal, to_char(pe.cep)) as cep, 
                               decode(p.tipo_pessoa,2/*Estrangeira*/, pes.municipio, pe.municipio) as municipio, 
                               decode(p.tipo_pessoa,2/*Estrangeira*/, 'EX', pe.uf) as uf, 
                               decode(p.tipo_pessoa,2/*Estrangeira*/, pes.municipio, pe.municipio) || decode(nvl(pe.uf,'EX'), 'EX', (select decode(pe.estado_provincia,null,'',' - ' || to_char(pe.estado_provincia)) from kss.v$pessoa_estrangeira pe where pe.cod_pessoa = p.cod_pessoa), ' - ' || pe.uf) municipio_uf, 
                               decode(p.tipo_pessoa,2/*Estrangeira*/, pes.municipio_id, pe.municipio_id) as municipio_id,
                               decode(t.telefone_id, null, '', '(' || t.fone_ddd || ')' || t.fone_prefixo || '-' || t.fone_numero) telefone, 
                               m.pais_id, 
                               decode(p.tipo_pessoa,2/*Estrangeira*/, pes.pais,ps.descricao) as pais
                          from kss.v$empresa e
                         inner join kss.v$pessoa p
                                 on p.cod_pessoa = e.cod_pessoa
                          left join kss.v$pessoa_endereco pe 
                                 on pe.cod_pessoa = e.cod_pessoa
                                and pe.endereco_padrao = 1
                          left join kss.v$pessoa_estrangeira pes
                                 on pes.cod_pessoa = e.cod_pessoa
                          left join kss.v$pessoa_telefone pt 
                                 on pt.cod_pessoa = e.cod_pessoa
                                and pt.telefone_padrao = 1
                          left join kss.v$telefone t 
                                 on t.telefone_id = pt.telefone_id
                          left join cep.municipio m
                                 on m.municipio_id = pe.municipio_id
                          left join cep.pais ps 
                                 on ps.pais_id = m.pais_id
				</cfquery>	
				<cfset session.empresa = qrEmpresa>			
			</cfif>
			<cfif true or  not IsDefined("session.cod_pessoa") or not Len(Trim(session.cod_pessoa)) >            	
                <cfquery name="qrLotacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                       select cliente
                            , cod_pessoa
                            , cod_departamento
                            , cod_setor
                            , cod_centro_custo
                            , cod_unidade_negocio
                            , usuario
                            , nome
                            , cod_pessoa_usuario
                            , setor
                            , cod_organograma
                      from kss.v$autenticacao_web
                </cfquery>
				<!---Grava a lotao do usuario no session--->
				<cfif qrLotacao.recordcount gt 0>
					<cfloop index="i" list="#qrLotacao.ColumnList#">
						<cfif i neq "USUARIO">
							<cfset session[i] = qrLotacao[i][1]>
                        </cfif>
					</cfloop>
				</cfif>
            </cfif>	
		<cfcatch>
			<cfthrow object="#cfcatch#">
		</cfcatch>
		</cftry>
	</cfif>
	 
 </cffunction>
 
 
<cffunction name="formataCpfCnpj" access="public" returntype="string">
    <cfargument name="cpf_cnpj" required="yes">
    <cfset v_result = ''>
    <cfscript>
	if(Len(trim(cpf_cnpj))<=11){
	for(i=1; i <= len(cpf_cnpj); i++){
						if(i==4||i==7)
							v_result &= ".";
						if(i==10)
							v_result &= "-";
							
					    v_result &= Mid(cpf_cnpj,i,1);	
					}
	}
	else
	if(Len(Trim(cpf_cnpj))>=12){
    for(i=1; i <= len(cpf_cnpj); i++){
						if(i==3||i==6)
							v_result &= ".";
						if(i==13)
							v_result &= "-";
                        if(i==9)
                        	v_result &= "/";
							
					    v_result &= Mid(cpf_cnpj,i,1);	
					}
    }else v_result = cpf_cnpj; 
    
    </cfscript>
    <cfreturn v_result>
</cffunction>
 
 	<cffunction name="ListaToArray" access="remote" returntype="array" output="false">
		<!---Captura todas as ocorrencias de uma variavel lancada por uma lista--->
		<!---Lista de todas as variaveis passadas para a pagina--->
		<cfargument name="lista" required="yes">
		<!---Nome da variavel a ser capturada--->
		<cfargument name="variavel" required="yes">
		<!---Lista de campos passados (FieldList)--->
		<cfargument name="fieldNames" required="no" default="#lista.fieldnames#">
		<cfscript>
			array = ArrayNew(1);
		</cfscript>
		<cfset count = 1>
		<cfloop list="#arguments.fieldnames#" delimiters="," index="campo">
			<cfif find("#arguments.variavel#_", "#campo#") eq 1>
				<cfset array[count] = lista[campo]>
				<cfset count = count + 1>
			</cfif>
		</cfloop>
		<cfreturn array>
	</cffunction>
	<cffunction name="ListDiff" access="remote" returntype="string" output="false">
		<!---Cria uma lista com os itens que existem na lista 1 e nao na 2--->
		<cfargument name="lista1" required="yes">
		<cfargument name="lista2" required="yes">
		<cfset resultado = ''>
		<cfloop list="#arguments.lista1#" delimiters="," index="v_valor">
			<cfif not listFind(lista2, v_valor, ',')>
				<cfset resultado = ListAppend(resultado, v_valor, ',')>
			</cfif>
		</cfloop>
		<cfreturn resultado>
	</cffunction>
	
	<cffunction name="ListDeleteDuplicatesNoCase" returntype="string">
		<cfargument name="list" required="yes">
		<cfargument name="delimiter" required="no" default=",">
		<cfset var i = 1>
	  	<cfset var returnValue = ''>
	  	<cfset list = ListToArray(arguments.list, arguments.delimiter)>
		<cfloop from="1" to="#ArrayLen(arguments.list)#" index="i">
			<cfif NOT ListFindNoCase(returnValue, list[i], arguments.delimiter)>
		  		<cfset returnValue = ListAppend(returnValue, list[i], delimiter)>
			</cfif>
		</cfloop>
		<cfreturn returnValue>
	</cffunction>

	<cffunction name="queryConcat" access="public" returntype="query">
		<cfargument name="query1" required="yes" type="query">
		<cfargument name="query2" required="yes" type="query">
		<cfif query1.columnlist neq query2.columnlist>
			<cfthrow message="As colunas das querys nao coincidem!">
		</cfif>
		<cfoutput query="query2">
			<cfset QueryAddRow(query1)>
			<cfloop list="#query1.columnlist#" index="valor">
				<cfset QuerySetCell(query1,valor,query2[valor][query2.currentrow])>
			</cfloop>
		</cfoutput>				
		<cfreturn query1>		
	</cffunction>
	
	<cffunction name="listconcat" access="public" returntype="string">
		<cfargument name="lista1" required="yes">
		<cfargument name="lista2" required="yes">
		<cfargument name="unique" required="no" default="0">
		<cfset lista_result = ''>
		<cfloop list="#arguments.lista1#" delimiters="," index="idx">
			<cfif arguments.unique eq 0 or (not listFind(lista_result,idx,','))>
				<cfset lista_result = ListAppend(lista_result,idx,',')>
			</cfif>
		</cfloop>
		<cfloop list="#arguments.lista2#" delimiters="," index="idx">
			<cfif arguments.unique eq 0 or (not listFind(lista_result,idx,','))>
				<cfset lista_result = ListAppend(lista_result,idx,',')>
			</cfif>
		</cfloop>
		<cfreturn lista_result>
	</cffunction>	

	<cffunction name="listDeleteNulls" access="public" returntype="string">
		<cfargument name="list" required="yes">
		<cfargument name="delimiter" required="no" default=",">
		<cfset v_result = ''>
		<cfloop list="#arguments.list#" delimiters="#arguments.delimiter#" index="value">
			<cfif len(trim(value))>
				<cfset v_result = ListAppend(v_result,value,arguments.delimiter)>
			</cfif>
		</cfloop>
		<cfreturn v_result>
	</cffunction>


    <cffunction name="CreateComponent" access="public" returntype="any">
        <cfargument name="class_name" required="yes">
        <cfscript>
            v_interno = arguments.class_name;
            if(lcase(ListGetAt(v_interno,1,'.')) eq "_transportes") {
                v_interno = ListSetAt(v_interno,1,replace(session.site&'_componentes','/','.','all'),'.');
            } else {
                v_interno = v_interno;
            }
            if(FileExists(expandPath('/'&replace(v_interno,'.','/','all')&".cfc"))) {
                v_class_name = v_interno;
            } else {
                v_class_name = arguments.class_name;
            }
            
            return CreateObject("component",v_class_name);
        </cfscript>
        <cfreturn v_result>
    </cffunction>
	
<!--- inicializa persistncia --->
 <cfset init() /> 
    <cfset SetLocale("Portuguese (Brazilian)")>
 
</cfcomponent>
