<cfcomponent extends="_transportes.funcoes.cfc_init">
	<cffunction name="createGrid" access="public" returntype="struct">
		<cfargument name="cod_grid" type="string" required="yes">
		<cfargument name="local" type="string" required="yes">
        <cfargument name="default_order" required="yes">
        <cfargument name="descricoes" required="yes">
        <cfset retorno = structNew()>
		<cftransaction action="begin">
        <cfstoredproc procedure="acesso.pkg_grid.prc_ins_grid" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	<cfprocparam type="IN" dbvarname="P_COD_GRID" cfsqltype="cf_sql_varchar" value="#arguments.cod_grid#">
        	<cfprocparam type="IN" dbvarname="P_LOCAL" cfsqltype="cf_sql_varchar" value="#arguments.local#">
        	<cfprocparam type="IN" dbvarname="P_COLUNAS" cfsqltype="cf_sql_varchar" value="#arguments.default_order#">
        	<cfprocparam type="IN" dbvarname="P_DESCRICOES" cfsqltype="cf_sql_varchar" value="#arguments.descricoes#">
        	<cfprocparam type="OUT" dbvarname="P_COD_GRID" cfsqltype="cf_sql_numeric" scale="5" variable="retorno.grid_id">
        </cfstoredproc>
        </cftransaction>
        <cftransaction action="commit">
        <cfset retorno.ordem_colunas = arguments.default_order>
        <cfset retorno.cod_grid = arguments.cod_grid>
        <cfreturn retorno>
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca a ordem de colunas do modelo
	-- CRISTOFER  04/07/2007
	--->		
	<cffunction name="get_grid_modelo_coluna" access="remote" returntype="query" output="true">
    	<cfargument name="modelo_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select c.cod_coluna,
                   mc.ordem,
                   mc.visivel,
                   mc.modelo_id,
                   mc.agrupamento
              from acesso.v$grid_modelo_coluna mc
             inner join acesso.v$grid_coluna c
                     on c.coluna_id = mc.coluna_id
             where mc.modelo_id = #arguments.modelo_id#
               and mc.visivel = 1
             order by ordem
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    
    <cffunction name="get_modelo_padrao" access="public" returntype="numeric">
    	<cfargument name="grid_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select modelo_id
              from acesso.v$grid
             where grid_id = #arguments.grid_id#
        </cfquery>
        <cfreturn qr_result.modelo_id>
    </cffunction>

    <cffunction name="get_grid_coluna" access="public" returntype="query">
    	<cfargument name="grid_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select cod_coluna,
            	   coluna_id,
                   descricao,
                   grid_id
              from acesso.v$grid_coluna
             where grid_id = #arguments.grid_id#
             order by cod_coluna
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca os modelos salvos para o usuario
	-- CRISTOFER  04/07/2007
	--->		
	<cffunction name="get_grid_modelo" access="remote" returntype="query" output="true">
    	<cfargument name="usuario" required="no" default="">
    	<cfargument name="grid_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gm.grid_id,
                   gm.modelo_id,
                   gm.usuario,
                   gm.publico,
                   gm.titulo,
                   gm.descricao,
                   gm.date_update,
                   case
                      when gm.usuario = user then 1
                      else 0
                   end editavel
              from acesso.v$grid_modelo gm
             where 1=1
             <cfif len(trim(arguments.usuario))>
               and (usuario = '#Ucase(arguments.usuario)#' or publico = 1)
             </cfif>
             <cfif len(trim(arguments.grid_id))>
               and grid_id = #arguments.grid_id#
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere um modelo do grid
	-- CRISTOFER
	--->
	<cffunction name='ins_grid_modelo' displayname='Insere dados adicionais de produtores.' access='remote' returntype='Struct' output='true'>
		<cfargument name='GRID_ID' required='yes'>
		<cfargument name='USUARIO' required='yes'>
		<cfargument name='PUBLICO' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='COLUNAS' required='yes'>
		<cfargument name='GRUPOS' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='acesso.pkg_grid.prc_ins_grid_modelo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRID_ID'  value='#arguments.GRID_ID#'  null='#iif(len(trim(arguments.GRID_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PUBLICO'  value='#arguments.PUBLICO#'  null='#iif(len(trim(arguments.PUBLICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#'>
					<cfprocparam type="OUT" cfsqltype="CF_SQL_NUMERIC" dbvarname='P_MODELO_ID' variable="retorno.modelo_id">
				</cfstoredproc>
                
				<cfstoredproc procedure='acesso.pkg_grid.prc_ins_modelo_colunas' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID'  value='#retorno.modelo_id#'  null='#iif(len(trim(retorno.modelo_id)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLUNAS'  value='#arguments.COLUNAS#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_GRUPOS'  value='#arguments.GRUPOS#'>
				</cfstoredproc>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Modelo salvo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Seta as variaveis de modelo do grid
	-- CRISTOFER
	--->
	<cffunction name='set_session_grid_data' displayname='Insere dados adicionais de produtores.' access='remote' returntype='Struct' output='true'>
		<cfargument name='GRID_ID' required='yes'>
		<cfargument name='MODELO_ID' required='no' default="">
		<cfargument name='COLUNAS' required='no' default="">
		<cfargument name='GRUPOS' required='no' default="">
        <cfparam name="session.modelo_grid.GID_#arguments.grid_id#" default="#StructNew()#">
        <cfset session.modelo_grid['GID_#arguments.grid_id#'] = structNew()>
        <cfset session.modelo_grid['GID_#arguments.grid_id#'].modelo_id = arguments.modelo_id>
        <cfset session.modelo_grid['GID_#arguments.grid_id#'].colunas = arguments.colunas>
        <cfset session.modelo_grid['GID_#arguments.grid_id#'].grupos = arguments.grupos>
        <cfset retorno = structNew()>
        <cfset retorno.sucesso = 'true'>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Insere um modelo do grid
	-- CRISTOFER
	--->
	<cffunction name='ins_grid_modelo_usuario' displayname='Insere dados adicionais de produtores.' access='remote' returntype='Struct' output='true'>
		<cfargument name='GRID_ID' required='yes'>
		<cfargument name='USUARIO' required='no' default="#Ucase(session.usuario)#">
		<cfargument name='modelo_id' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='acesso.pkg_grid.prc_ins_modelo_usuario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRID_ID'  value='#arguments.GRID_ID#'  null='#iif(len(trim(arguments.GRID_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID'  value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Modelo salvo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere um modelo do grid
	-- CRISTOFER
	--->
	<cffunction name='ins_grid_modelo_colunas' displayname='Insere dados adicionais de produtores.' access='remote' returntype='Struct' output='true'>
		<cfargument name='MODELO_ID' required='yes'>
		<cfargument name='COLUNAS' required='yes'>
		<cfargument name='GRUPOS' required='no' default=''>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='acesso.pkg_grid.prc_ins_modelo_colunas' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID'  value='#arguments.modelo_id#'  null='#iif(len(trim(arguments.modelo_id)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLUNAS'  value='#arguments.COLUNAS#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_GRUPOS'  value='#arguments.GRUPOS#'>
				</cfstoredproc>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Modelo salvo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	
	<!--- 
	-- PROPSITO 
	-- Busca o modelo padrao do usuario
	-- CRISTOFER  04/07/2007
	--->		
	<cffunction name="get_modelo_padrao_usuario" access="remote" returntype="numeric" output="true">
    	<cfargument name="usuario" required="no" default="#session.usuario#">
        <cfargument name="grid_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select acesso.pkg_grid.fnc_get_modelo_usuario(#arguments.grid_id#,'#Ucase(arguments.usuario)#') modelo_id
              from dual
		</cfquery>
		<cfreturn qr_result.modelo_id>		
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Exclui um modelo
	-- CRISTOFER  04/07/2007
	--->		
	<cffunction name="del_grid_modelo" access="remote" returntype="Struct" output="true">
        <cfargument name="modelo_id" required="yes">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='acesso.pkg_grid.prc_del_grid_modelo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID'  value='#arguments.modelo_id#'  null='#iif(len(trim(arguments.modelo_id)), de('no'), de('yes'))#'>
				</cfstoredproc>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Modelo excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>