<cfcomponent>
<cfscript>
/**
 * @descritivo	: Data Completa
 * @parametro	: p_data   : data. ( Requerido )
 * @retorno		: Data
 * @autor       : Jefferson Petilo( jefferson@kmm.com.br ) 
 * @verso		: 1, 23 de Maro  de  2004
 */					

function f_data_completa( p_data ) {
	var data = LsDateFormat( CreateDate( Year( p_data), Month( p_data), Day( p_data )  ) , 'dd/mm/yyyy') & ' ' & LsTimeFormat( CreateTime( Hour( p_data), Minute( p_data), Second( p_data )  ) ,'HH:MM:ss');
	if ( LsIsDate( data ) ) return ( data );
}		   

/**
 * @descritivo	: Verifica se o arquivo  script
 * @parametro   : p_arquivo   : string. ( Requerido )
 * @retorno		: string
 * @autor       : Jefferson Petilo( jefferson@kmm.com.br ) 
 * @verso		: 1, 24 de Maro de  2004
 */					
function IsScript( p_arquivo ) {
	var arquivo = ListLast( p_arquivo, '.');
	switch( lcase( arquivo ) ) {
		case 'sql':
		case 'bat':
		case 'qrx': 
			return 1; 
			break;
		default: 
			return 0; 
			break;
	}			
}

/**
 * @descritivo	: Verifica se o arquivo  script
 * @parametro   : p_arquivo   : string. ( Requerido )
 * @retorno		: string
 * @autor       : Jefferson Petilo( jefferson@kmm.com.br ) 
 * @verso		: 1, 24 de Maro de  2004
 */					
function IsRelatorio( p_arquivo ) {
	var arquivo = ListLast( p_arquivo, '.');
	switch( lcase( arquivo ) ) {
		case 'rtx':	 
			return 1; 
			break;
		default:  
			return 0; 
			break;
	}			
}

/**
 * @descritivo	: Converte tamanho de arquivo
 * @parametro	: p_tamanho_arquivo   : numrico. ( Requerido )
 * @retorno		: string
 * @autor       : Jefferson Petilo( jefferson@kmm.com.br ) 
 * @verso		: 1, 12 de Janeiro de  2004
 */					
function f_tamanho_arquivo( p_tamanho_arquivo ) {
	var strRetorno = '';
	if( p_tamanho_arquivo gte 1099511627776 )
		strRetorno = Trim( LSNumberFormat( p_tamanho_arquivo / 1024 / 1024 / 1024 / 1024 , '-__________.__')) & ' TB';
	else if( p_tamanho_arquivo gte 1073741824 )
		strRetorno = Trim( LSNumberFormat( p_tamanho_arquivo / 1024 / 1024 / 1024 , '-__________.__')) & ' GB';
	else if( p_tamanho_arquivo gte 1048576 )
		strRetorno = Trim( LSNumberFormat( p_tamanho_arquivo / 1024 / 1024, '-__________.__')) & ' MB';
	else if ( p_tamanho_arquivo gte 1024 ) 
		strRetorno = Trim( LSNumberFormat( p_tamanho_arquivo / 1024, '-__________.__')) & ' KB'; 
	else 
		strRetorno = Trim( LSNumberFormat( p_tamanho_arquivo / 1024, '-__________.__'))  & ' bytes'; 
	return strRetorno;
}



/**
 * @descritivo	: Comentrio do Log de Sincronizao
 * @parametro	: p_umdf1  : data. ( Requerido )		   
				  p_umdf2  : data. ( Requerido )		   
				  p_tm1    : data. ( Requerido )		   
				  p_tm2    : data. ( Requerido )		   		   		   		   
 * @retorno		: string
 * @autor       : Jefferson Petilo( jefferson@kmm.com.br ) 
 * @verso		: 1, 20  de Fevereiro 2004
 */					
function f_comentario ( p_umdf1, p_umdf2, p_tm1, p_tm2 ) {
	var comentario = '';
	switch( DateCompare( p_umdf1 , p_umdf2 ) ) {
		case -1: 
			comentario_data = 'A Data ' & this.f_data_completa( p_umdf1 ) & chr ( 32 ) & chr ( 233 ) & ' menor do que ' & this.f_data_completa( p_umdf2 ); 	
			break;
		case 0: 
			comentario_data = false;
			break;
		case 1: 
			comentario_data = 'A Data ' & this.f_data_completa( p_umdf1 ) & chr ( 32 ) & chr ( 233 ) & ' maior do que ' & this.f_data_completa( p_umdf2 );	
			break;
	}
	switch( Compare( p_tm1 , p_tm2 ) ) {
		case -1: 
			comentario_size = 'O Tamanho '  & this.f_tamanho_arquivo( p_tm1 ) & chr ( 32 ) & chr ( 233 ) & ' menor do que '  &  this.f_tamanho_arquivo( p_tm2 );	
			break;
		case  0: 
			comentario_size = false;
			break;
		case  1: 
			comentario_size = 'O Tamanho '  & this.f_tamanho_arquivo( p_tm1 ) & chr ( 32 ) & chr ( 233 ) & ' maior do que '  &  this.f_tamanho_arquivo( p_tm2 );	
			break;
	}
	if( ( not IsBoolean( comentario_data ) and not IsBoolean( comentario_size ) ) )
		comentario  = comentario_data & ' e ' & comentario_size;  					
	else if ( not IsBoolean( comentario_data ) and IsBoolean( comentario_size )  )
		comentario  = comentario_data;
	else if ( IsBoolean( comentario_data ) and not IsBoolean( comentario_size )  )	 
		comentario  = comentario_size;
	return ( comentario );
}

/**
 * @descritivo	: Converte a data para a Zona do Tempo 
 * @retorno		: string
 * @autor       : Jefferson Petilo( jefferson@kmm.com.br ) 
 * @verso		: 1, 12 de Janeiro de  2004
 */					
function DateConvertZ(conversionType, dateObj, zoneInfo) {
	var targetZone = "";
	var targetSpan = 0;
	var targetDate = "";
	var utcDate = "";
	var hourDiff = 0;
	var minDiff = 0;
	var zoneModOffSet = 0;
	var zoneMod = 0;
	
	//timeZone object
	var timeZone = StructNew();
	timeZone.UTC  =   0;     // Universal Time Coordinate or universal time zone
	timeZone.GMT  =   0;     // Greenwich Mean Time same as UTC
	timeZone.BST  =   1;     // British Summer time
	timeZone.IST  =   1;     // Irish Summer Time
	timeZone.WET  =   1;     // Western Europe Time
	timeZone.WEST =   1;     // Western Europe Summer Time
	timeZone.CET  =   1;     // Central Europe Time
	timeZone.CEST =   2;     // Central Europe Summer Time
	timeZone.EET  =   2;     // Eastern Europe Time
	timeZone.EEST =   3;     // Eastern Europe Summer Time
	timeZone.MSK  =   3;     // Moscow time
	timeZone.MSD  =   4;     // Moscow Summer Time
	timeZone.AST  =  -4;     // Atlantic Standard Time
	timeZone.ADT  =  -3;     // Atlantic Daylight Time
	timeZone.EST  =  -5;     // Eastern Standard Time
	timeZone.EDT  =  -4;     // Eastern Daylight Saving Time
	timeZone.CST  =  -6;     // Eastern Time
	timeZone.CDT  =  -5;     // Central Standard Time
	timeZone.MST  =  -7;     // Mountain Standard Time
	timeZone.MDT  =  -6;     // Mountain Daylight Saving Time
	timeZone.PST  =  -8;     // Pacific Standard Time
	timeZone.HST  = -10;     // Hawaiian Standard Time
	timeZone.AKST =  -9;     // Alaska Standard Time
	timeZone.AKDT =  -8;     // Alaska Standard Daylight Saving Time
	timeZone.AEST =  10;     // Australian Eastern Standard Time
	timeZone.AEDT =  11;     // Australian Eastern Daylight Time
	timeZone.ACST = 9.5;     // Australian Central Standard Time
	timeZone.ACDT = 10.5;    // Australian Central Daylight Time
	timeZone.AWST =   8;     // Australian Western Standard Time
	
	//Check for +- timezone mod such as PST-4
	zoneModOffSet = FindOneOf("+-", zoneInfo);
	if(zoneModOffSet) {
		//Extract out the zoneInfo and zoneMod
		zoneMod = Val(Right(zoneInfo, Len(zoneInfo) - zoneModOffSet + 1));
		zoneInfo = Left(zoneInfo, zonemodOffSet - 1);			
  	}
	
	targetZone = timeZone[zoneInfo] + zoneMod;
	
	// Grab Target Zone Info
	hourDiff = fix(targetZone);
	minDiff = (targetZone - hourDiff) * 60; 
	
	targetSpan = CreateTimeSpan(0, hourDiff, minDiff, 0);
	
	if (conversionType IS "local2zone") {
		// date is local time so convert it to utc first
		utcDate = DateConvert("Local2Utc", dateObj) ;
		// Add the target zone difference
		targetDate = utcDate + targetSpan;
		return "{ts '" & DateFormat(targetDate, "yyyy-mm-dd ") & TimeFormat(targetDate, "HH:mm:ss") & "'}";
	} else if (conversionType is "zone2local") {
		//date is in the target zone so convert it to utc first
		targetDate = dateObj - targetSpan;
		//convert it back from utc to local
		targetDate = DateConvert("Utc2local", targetDate);	
		return "{ts '" & DateFormat(targetDate, "yyyy-mm-dd ") & TimeFormat(targetDate, "HH:mm:ss") & "'}";
	}
	return "{ts 'yyyy-mm-dd HH:mm:ss'}"; // error return
}
</cfscript>

	<!--- 
	-- PROPSITO
	-- Upload de Arquivos ( grava arquivo no servidor )
	-- JEFFERSON          04/11/2003 - criado
	--->
<cffunction name="uploadArquivo" displayname="Envia arquivo para o servidor" access="remote" output="false" returntype="struct">
  <cfargument name="variavel" 		displayname="Variavel de formulario" 			type="string" 	required="true" />
  <cfargument name="caminho_destino"  displayname="Caminho de Destino do arquivo" 	type="string"	required="true"/>
  <cfset var strRetorno 		= structNew() />
  <cfset strRetorno['erro'] 	= False  />
  <cftry>
    <cffile action = "upload" filefield	 = "#arguments['variavel']#" destination  = "#arguments['caminho_destino']#" nameconflict = "OverWrite" />
    <cfif cffile['FileWasSaved']>
      <cfscript>
						strRetorno['nome_arquivo'] 		= cffile['ServerFile'];
						strRetorno['diretorio_arquivo'] = cffile['ServerDirectory'];
						strRetorno['tamanho_arquivo'] 	= cffile['FileSize'];
						strRetorno['sobrescrito']		= cffile['FileWasOverWritten'];
						strRetorno['salvo']				= cffile['FileWasSaved'];
						
					</cfscript>
    </cfif>
    <cfcatch type="any">
      <cfscript>
					  
					  
						strRetorno['erro'] 		= true;
						strRetorno['mensagem']  = cfcatch.Detail;
						
				</cfscript>
    </cfcatch>
  </cftry>
  <cfreturn strRetorno / >
</cffunction>
<cffunction name="gravaArquivo" displayname="Grava arquivo para o servidor" output="true" returntype="void">
  <!--- 
   	-- PROPSITO
	-- Grava Arquivo
	-- NOTAS EXPLICATIVAS
	--  
	-- JEFFERSON          04/11/2003 - criado
	--->
  <cfargument name="arquivo" 			 displayname="Nome do Arquivo" 			type="string" 	required="true"  />
  <cfargument name="output" 			 displayname="Variavel de Retorno" 		type="string" 	required="true"  />
  <cfargument name="adiciona_linha"	 displayname="Adiciona Linha" 			type="string" 	required="false" default="yes" />
  <cftry>
    <cffile action="Write" file="#arguments['arquivo']#" output="#ToString(arguments['output'])#" addnewline="#arguments['adiciona_linha']#" charset= "iso-8859-1" />
    <cfcatch type="any">
      <cfdump var="#cfcatch#">
    </cfcatch>
  </cftry>
</cffunction>
<cffunction name="readArquivo" displayname="L arquivo do servidor" access="remote"  output="false" returntype="string">
  <!--- 
   	-- PROPSITO
	-- l Arquivo
	-- NOTAS EXPLICATIVAS
	--  
	-- JEFFERSON          04/11/2003 - criado
	--->
  <cfargument name="arquivo" 			 displayname="Nome do Arquivo" 			type="string" 	required="true"  />
  <cfargument name="charset" 			 displayname="CharSet do Arquivo" 		type="string" 	required="false" default="iso-8859-1"  />
  <cfset var strRetorno =	'' />
  <cftry>
    <cfif FileExists( arguments['arquivo'] )>
      <cffile action="Read" file="#arguments['arquivo']#" variable="strRetorno" charset="#arguments['charset']#" />
    </cfif>
    <cfcatch type="any"></cfcatch>
  </cftry>
  <cfreturn strRetorno />
</cffunction>
<cffunction name="appendArquivo" displayname="Atualiza arquivo para o servidor" access="remote"  output="false" returntype="void">
  <!--- 
   	-- PROPSITO
	-- incrementa Arquivo
	-- NOTAS EXPLICATIVAS
	--  
	-- JEFFERSON          04/11/2003 - criado
	--->
  <cfargument name="arquivo" 			 displayname="Nome do Arquivo" 			type="string" 	required="true"  />
  <cfargument name="output" 			 displayname="Variavel de Retorno" 		type="string" 	required="true"  />
  <cfargument name="adiciona_linha"	 displayname="Adiciona Linha" 			type="string" 	required="false" default="yes" />
  <cfargument name="charset" 			 displayname="CharSet do Arquivo" 		type="string" 	required="false" default="iso-8859-1"  />
  <cftry>
    <cffile action="Append" file="#arguments['arquivo']#" output="#ToString(arguments['output'])#" addnewline="#arguments['adiciona_linha']#" charset="#arguments['charset']#" />
    <cfcatch type="any">
      <cfscript>
					
			</cfscript>
    </cfcatch>
  </cftry>
</cffunction>
<cffunction name="md5_file" displayname="Captura o Hash MD5 do Arquivo" access="remote" returntype="string" output="false">
    <cfargument name="file" required="yes">
    <cfargument name="expand" required="yes">
    <cfif arguments.expand eq 1>
        <cfset arguments.file = expandPath(arguments.file)>
    </cfif>
    <cfhttp url="#cgi.HTTP_HOST#/KMM/md5_file.php?file=#arguments.file#" method="get"></cfhttp>
    <cfreturn cfhttp.FileContent />
</cffunction>
<cffunction name="renomeiaArquivo" displayname="Renomeia arquivo no servidor"  access="remote"  output="false" returntype="void">
  <cfargument name="caminho_origem"   displayname="Caminho de Origem do arquivo" 	    type="string"	required="true"/>
  <cfargument name="caminho_destino"  displayname="Caminho de Destino do arquivo" 	type="string"	required="true"/>
  <cffile action="rename" source= "#arguments['caminho_origem']#" destination="#arguments['caminho_destino']#" nameconflict= "overwrite" />
</cffunction>
<cffunction name="copiaArquivo" displayname="Copia arquivo no servidor"  access="remote"  output="false" returntype="void">
  <cfargument name="caminho_origem"   displayname="Caminho de Origem do arquivo" 	    type="string"	required="true"/>
  <cfargument name="caminho_destino"  displayname="Caminho de Destino do arquivo" 	type="string"	required="true"/>
  <cffile action			= "copy" 
source			= "#arguments['caminho_origem']#" 
destination		= "#arguments['caminho_destino']#" mode="774" />
</cffunction>
<cffunction name="deletaArquivo" displayname="Deleta arquivo no servidor"  access="remote" output="false" returntype="void">
  <cfargument name="caminho_arquivo"  displayname="Caminho do arquivo" 	type="string"	required="true"/>
  <cffile action		= "delete" 
file		= "#arguments['caminho_arquivo']#" />
</cffunction>
<cffunction name="moveArquivo" displayname="Move arquivo no servidor" access="remote" output="false" returntype="void">
  <cfargument name="caminho_origem"   displayname="Caminho de Origem do arquivo" 	    type="string"	required="true"/>
  <cfargument name="caminho_destino"  displayname="Caminho de Destino do arquivo" 	type="string"	required="true"/>
  <cffile action			= "move" 
source			= "#arguments['caminho_origem']#" 
destination		= "#arguments['caminho_destino']#" 
nameconflict	= "overwrite" />
</cffunction>
<cffunction name="infoArquivo" displayname="Informaes sobre o  arquivo no servidor" access="remote" output="false" returntype="query">
  <cfargument name="caminho_arquivo"  displayname="Caminho do arquivo" 	type="string"	required="true"/>
  <cfset var diretorio = '' />
  <cfset var qrArquivo = queryNew('') />
  <cfif NOT FileExists( arguments['caminho_arquivo'] )>
    <cfthrow message="Arquivo no existe" />
  </cfif>
  <cfset qrArquivo  = this.listaDiretorio( getDirectoryFromPath( arguments['caminho_arquivo'] ) ) />
  <cfreturn qrArquivo />
</cffunction>
<cffunction name="criaDiretorio" displayname="Cria Diretorio no servidor"  access="remote" output="true" returntype="void">
  <cfargument name="diretorio" displayname="Nome do Diretorio" 	  type="string"	required="true" />
  <cfif not DirectoryExists(arguments['diretorio'])>
	  <cfdirectory action="create" directory="#arguments['diretorio']#" mode="770" />
  </cfif>
</cffunction>
<cffunction name="deletaDiretorio"  displayname="Deleta Diretorio no servidor" access="remote" output="false" returntype="void">
  <cfargument name="diretorio" displayname="Nome do Diretorio" 	  type="string"	required="true"/>
  <cfdirectory action		= "delete" 
 directory	= "#arguments['diretorio']#" />
</cffunction>
<cffunction name="xCopy"  displayname="Cpia Recursiva de arquivos e Diretrio" access="remote" output="false" returntype="void">
  <cfargument 	name="dir_origem" 			type="string" 	required="true" />
  <cfargument 	name="dir_destino" 	 		type="string" 	required="true" />
  <cfargument 	name="file_list" 	 		type="string" 	required="true" />
  <cfscript>

qrFiles  = this.ListaDiretorio( diretorio = arguments['dir_origem']  ,  recursiva = false );

if ( NOT DirectoryExists( arguments['dir_destino'] ) ) this.criaDiretorio ( arguments['dir_destino']  ); // criando diretrio no destino 

	for ( j = 1; j lte qrFiles.recordcount; j = j + 1 )
	{
		if ( 
						FindNoCase ( 'Dir', qrFiles['type'][ j ]   )  
			 and not ListFindNoCase( '.,..', qrFiles['name'][ j ]  ) 
				 and ListFindNoCase( arguments['file_list'] , qrFiles['name'][ j ]  ) 
			)
		
						xCopy( 
								dir_origem     = arguments['dir_origem']  & slash & qrFiles['name'][ j ] , 
								dir_destino    = arguments['dir_destino'] & slash & qrFiles['name'][ j ] 
							  ); // chamando a funo Xcopy Recursivamente
				  
		else if ( 
							FindNoCase ( 'File', qrFiles['type'][ j ]  ) 
					 and ListFindNoCase( arguments['file_list'] , qrFiles['name'][ j ]  )  
				 )
		
			this.copiaArquivo( 
								dir_origem  = arguments['dir_origem']   & slash & qrFiles['name'][ j ], 
								dir_destino = arguments['dir_destino']  & slash & qrFiles['name'][ j ]  
							 ); // chamando funo de cpia comum
							 
	}	
</cfscript>
</cffunction>

	<!--- 
	-- PROPSITO 
	-- Converte em tamanho de arquivo
	-- CRISTOFER  14/08/2006
	--->
	<cffunction name="get_tamanho_arquivo" returntype="string" output="false">
		<cfargument name="p_tamanho_arquivo" required="yes">
		<cfset strRetorno = "">
		<cfif p_tamanho_arquivo gte 1099511627776>
			<cfset strRetorno = Trim( LSNumberFormat( p_tamanho_arquivo / 1024 / 1024 / 1024 / 1024 , '-__________.__')) & ' TB'>
		<cfelseif p_tamanho_arquivo gte 1073741824 >
			<cfset strRetorno = Trim( LSNumberFormat( p_tamanho_arquivo / 1024 / 1024 / 1024 , '-__________.__')) & ' GB'>
		<cfelseif p_tamanho_arquivo gte 1048576 >
			<cfset strRetorno = Trim( LSNumberFormat( p_tamanho_arquivo / 1024 / 1024, '-__________.__')) & ' MB'>
		<cfelseif p_tamanho_arquivo gte 1024 >
			<cfset strRetorno = Trim( LSNumberFormat( p_tamanho_arquivo / 1024, '-__________.__')) & ' KB'>
		<cfelse>
			<cfset strRetorno = Trim( LSNumberFormat( p_tamanho_arquivo / 1024, '-__________.__'))  & ' bytes'>
		</cfif>
		<cfreturn strRetorno>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca o conteudo de um diretorio
	-- CRISTOFER  16/08/2006
	--->		
	<cffunction name="get_diretorio_conteudo" access="remote" returntype="query" output="true">
		<cfargument name="diretorio" required="yes">
		<cfdirectory directory="#arguments.diretorio#"
					 recurse="no"
					 sort="type asc, name asc"
					 name="qr_result">
		<cfreturn qr_result>		
	</cffunction>
</cfcomponent>
