<!--- 
	NAME: 
	CF_LPAD
	
	AUTHOR:
	Dennis Whipstock 
	dwhipstock@usa.net

	DESCRIPTION: 
	Simple tag that Mimics VB's and Oracle's LPAD function.  
	
	USEAGE:
	<cf_lpad length=4 addChar="0" varName = "newSeven">7</cf_lpad>
	Will poplulate newSeven with "0007" and blank GeneratedContent.
	
	<cf_lpad length=4 addChar="0">7</cf_lpad>
	Will not populate a variable, instead will change GeneratedContent to
	"0007".
	
	Works fine like this too...
	<cfoutput>
		<cfset myVar = 7>
		<cf_lpad length=2 addChar="0" varName = "newSeven">#myVar#</cf_lpad>
		newSeven: #newSeven#
	</cfoutput>

	ATTRIBUTES: 
	length  - Total length of the string that you want after lpad.
	addChar  - The character that you want to add to the front. 	
	varName - The name of the variable you want to populate.  If not
	included this tag will simply alter the GeneratedContent.		
 --->
<cfparam name="attributes.length" default="10">
<cfparam name="attributes.addChar" default="0">

<cfscript>
   output = ThisTag.GeneratedContent;
	if (ThisTag.ExecutionMode is "END") {
		while (len(output) LT attributes.length) {
			output = attributes.addChar & output;
		}
	}
	
	if (isDefined("attributes.varName")) {
		"Caller.#attributes.varName#" = output;
		ThisTag.GeneratedContent = "";
	} else {
		ThisTag.GeneratedContent = output;
	}	
</cfscript>
