<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de pneus" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca FROTA
	-- NOTAS EXPLICATIVAS
	--->
	<cffunction name="get_placa" returntype="string" access="remote">
		<cfargument name="cod_veiculo" required="no">
		<cfquery name="qr_result"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_veiculo.fnc_get_placa('#arguments.cod_veiculo#') as placa
			  from dual
 		</cfquery>		
		<cfreturn qr_result.placa>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca todas as borrachas cadastradas
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 01/02/2006
	--->
	<cffunction name="get_borrachas" returntype="query" access="remote">
		<cfargument name="borracha_id" required="no">
		<cfquery datasource="#session.dsn#" name="qrBorracha" username="#session.usuario#" password="#session.senha#">
			select distinct borracha_id, descricao
			  from oper.v$pneu_borracha
			 where 1=1
		   <cfif IsDefined("arguments.borracha_id") and Len(Trim(arguments.borracha_id))>
			   and borracha_id in (#arguments.borracha_id#)
		   </cfif>
 		</cfquery>		
		<cfreturn qrBorracha>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca todas as borrachas cadastradas
	-- NOTAS EXPLICATIVAS
	-- LEOPOLDOS 06/07/2010
	--->
	<cffunction name="get_borrachas_xml" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qrBorracha" username="#session.usuario#" password="#session.senha#">
		select dbms_xmlgen.getxml(' 	
			select distinct borracha_id, descricao
			  from oper.v$pneu_borracha
			 where 1=1') as resultado
          from dual		   
 		</cfquery>		
		<cfreturn qrBorracha>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca dados para o relatrio de calibragem
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  16/02/2006
	--->		
	<cffunction name="get_calibragem" access="remote" returntype="query" output="true">
		<cfargument name="marca_id" required="no" default="">
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="medida_id" required="no" default="">
		<cfargument name="tipo_veiculo_id" required="no" default="">
		<cfargument name="comparador_pressao" required="yes">
		<cfargument name="pressao" required="yes">
		<cfargument name="pressao_2" required="no" default="">
		<cfargument name="agrupado_por" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfswitch expression="#LCase(arguments.agrupado_por)#">
			<cfcase value="marca">
				<cfset campo = 'pm.descricao'>
				<cfset titulo = 'Marca'>
			</cfcase>
			<cfcase value="medida">
				<cfset campo = 'm.descricao'>
				<cfset titulo = 'Medida'>
			</cfcase>  
			<cfcase value="placa">
				<cfset campo = 'pi.placa'>
				<cfset titulo = 'Placa'>
			</cfcase>
			<cfcase value="motorista">
				<cfset campo = 'oper.pkg_global.fnc_busca_nome_pessoa(vm.cod_pessoa)'>
				<cfset titulo = 'Motorista'>
			</cfcase>		
		</cfswitch>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select #campo# as grupo,
				   '#titulo#' as agrupado_por,
				   count(*) as total,
				   sum(case 
						 when pi.pressao_encontrada #arguments.comparador_pressao# #arguments.pressao#
						 then 1
						 else 0
					   end) as irregulares,
				   round(((sum(case 
						 when pi.pressao_encontrada #arguments.comparador_pressao# #arguments.pressao#
						 then 1
						 else 0
					   end)/count(*))*100),2) as perc        
			  from oper.v$pneu_calibragem pi
			 inner join oper.v$pneu p
					 on pi.pneu_id = p.pneu_id
			 inner join oper.v$pneu_medida m
					 on m.medida_id = p.medida_id
			 inner join oper.v$pneu_marca pm
					 on pm.marca_id = p.marca_id
		     inner join oper.v$veiculo_dados vd
			         on vd.placa = pi.placa
			 inner join oper.v$veiculo_motorista vm
         			 on vm.placa = pi.placa
        			and pi.data_calibragem between vm.data_inicio and nvl(vm.data_fim,sysdate)
			 where pi.pressao_encontrada is not null
			 <cfif len(trim(arguments.modelo_id))>
			   and p.modelo_id in (#arguments.modelo_id#)
			 </cfif>
			 <cfif len(trim(arguments.marca_id))>
			   and p.marca_id in (#arguments.marca_id#)
			 </cfif>
			 <cfif len(trim(arguments.medida_id))>
			   and p.medida_id in (#arguments.medida_id#)
			 </cfif>
			 <cfif len(trim(arguments.tipo_veiculo_id))>
			   and vd.tipo_id in (#arguments.tipo_veiculo_id#)
			 </cfif>
			 <cfif len(trim(arguments.data_inicial))>
			   and pi.data_calibragem >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and pi.data_calibragem <= '#arguments.data_final#'
			 </cfif>
			 group by #campo#
			 order by #campo#
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca a composicao da placa
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 20/01/2006
	--->
	<cffunction name="get_composicao" returntype="string" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="sem_aspas" required="no">		
		<cfif Len(Trim(arguments.cod_veiculo))>
			<cfset arguments.placa = this.get_placa(arguments.COD_VEICULO)>
		</cfif>		
		<cfquery datasource="#session.dsn#" name="qr_veiculo" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_pneu.fnc_lista_placa_composicao(oper.pkg_veiculo.fnc_get_placa(upper('#arguments.placa#'))) as composicao
		  	  from dual
		</cfquery>
		<cfif not IsDefined("arguments.sem_aspas")>
			<cfset j = 0>
			<cfloop index="i" from="1" to="#int(Len(qr_veiculo.COMPOSICAO)/7)#">
				<cfset qr_veiculo.COMPOSICAO = Insert("','",qr_veiculo.COMPOSICAO,(i*7)+j)>
				<cfset j = j+3>
			</cfloop>
			<cfset qr_veiculo.COMPOSICAO = "'" & qr_veiculo.COMPOSICAO & "'">		
		<cfelse>	
			<cfset j = 0>
			<cfloop index="i" from="1" to="#int(Len(qr_veiculo.COMPOSICAO)/7)#">
				<cfset qr_veiculo.COMPOSICAO = Insert(",",qr_veiculo.COMPOSICAO,(i*7)+j)>
				<cfset j = j+1>
			</cfloop>
		</cfif>
		<cfreturn qr_veiculo.COMPOSICAO>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os custos do pneu efetuados na estrada
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 08/02/2006
	--->
	<cffunction name="get_custos_estrada" returntype="query" access="remote">
		<cfargument name="num_pneu" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_mms" username="#session.usuario#" password="#session.senha#">
			select v.controle_km_id,
				   v.controle_id,
				   v.num_recibo_viagem,
				   v.relacao_id,
				   v.num_documento,
				   v.produto_id,
				   v.complemento,
				   v.placa,
				   oper.fnc_get_cod_veiculo(v.placa) as cod_veiculo,
				   v.data,
				   v.valor,
				   v.cod_pessoa,
				   v.quantidade,
				   v.num_lancto_ccorrente,
				   v.pneu_id,
				   v.num_liberacao,
				   v.km,
				   v.origem,
				   v.confirmado,
				   p.razao_social as nome
			  from oper.v$viagem_recibo v	
			 inner join kss.v$pessoa p
					 on p.cod_pessoa = v.cod_pessoa
			 where pneu_id = #arguments.num_pneu#
			 order by data
  		</cfquery>
		<cfreturn qr_mms>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca todos os consertos no confirmados de pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 02/02/2006
	--->
	<cffunction name="get_consertos_nao_confirmados" returntype="query" access="remote">
		<cfargument name="num_pneu" required="no">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfif Len(Trim(arguments.cod_veiculo))>
			<cfset arguments.placa = this.get_placa(arguments.COD_VEICULO)>
		</cfif>
		<cfquery name="qrConsertos"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS */ vr.num_recibo_viagem, vr.num_documento, vr.complemento, 
				   vr.cod_pessoa, pf.nome,  vr.data, vr.placa, vr.valor, vr.pneu_id
			  from oper.v$viagem_recibo vr
			 inner join kss.v$pessoa_fisica pf
			         on pf.cod_pessoa = vr.cod_pessoa
			 where vr.pneu_id is not null
			   and not exists (select 'x'
								 from oper.v$pneu_reforma p
								where p.num_recibo_viagem = vr.num_recibo_viagem)
			   and vr.confirmado = 0			
			   <cfif  IsDefined("arguments.placa") and Len(Trim(arguments.placa))>
				  and vr.placa = '#arguments.placa#'
		       </cfif>
			   <cfif  IsDefined("arguments.num_pneu") and Len(Trim(arguments.num_pneu))>
				  and vr.pneu_id = #arguments.num_pneu#
		       </cfif>
			   order by vr.pneu_id
   		</cfquery>		
		<cfreturn qrConsertos>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Os dados da ficha de inspecao do veiculo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 30/01/2006
	--->
	<cffunction name="get_dados_inspecao" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfif Len(Trim(arguments.cod_veiculo))>
			<cfset arguments.placa = this.get_placa(arguments.COD_VEICULO)>
		</cfif>
		<cfset qr_veiculo.COMPOSICAO = this.get_composicao(placa = arguments.placa, sem_aspas = true)>
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select pneu_id, num_pneu, situacao_id, marca_id, marca,
			   modelo_id, modelo, sulco, medida_id, medida,
			   medida_roda_id, medida_roda, reformas, posicao, 
			   placa, oper.pkg_veiculo.fnc_get_cod_veiculo(placa) as frota,
			   data_inspecao, data_ult_inspecao, user_insert, num_inspecao, nvl(mm_montagem,0) as mm_montagem, 
 			   sulco_atual,  oper.pkg_global.fnc_get_parametro(1,'PNEU')/100 as tolerancia
		  from ( 	select p.pneu_id, p.num_pneu, p.situacao_id, p.marca_id, p.marca,
						   p.modelo_id, p.modelo, p.sulco, p.medida_id, p.medida,
						   p.medida_roda_id, p.medida_roda, p.reformas, pm.posicao, pi.placa,
						   pi.data_inspecao, pi.data_ult_inspecao, pi.user_insert, pi.num_inspecao, 
						   case 
      					     when nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(p.pneu_id),1),0) >= mm_montagem then -1
      				       else nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(p.pneu_id),1),0)
      				       end sulco_atual,						   
						   pvp.num_eixo, pvp.ordem, pm.km_montagem, pm.mm_montagem
					  from oper.v$pneu_inspecao pi
					 inner join oper.v$pneu_dados p 
							 on p.pneu_id = pi.pneu_id
							and pi.mm_inspecao is null
					 inner join oper.v$pneu_veiculo_posicao pvp 
 						     on pvp.placa = pi.placa
					        and pvp.posicao = pi.posicao
					 inner join oper.v$pneu_movimentacao pm 
							 on pm.placa = pi.placa
									and pm.pneu_id = pi.pneu_id
								  and pm.data_desmontagem is null
					 where instr('#qr_veiculo.COMPOSICAO#',pi.placa) > 0)
		 order by instr('#qr_veiculo.COMPOSICAO#',placa)
		 , num_eixo ,ordem
   		</cfquery>		
		<cfreturn qrPneus>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Os dados da ficha de inspecao do veiculo - xml
	-- NOTAS EXPLICATIVAS
	-- LEOPOLDOS 12/07/2010
	--->
	<cffunction name="get_dados_inspecao_xml" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfif Len(Trim(arguments.cod_veiculo))>
			<cfset arguments.placa = this.get_placa(arguments.COD_VEICULO)>
		</cfif>
		<cfset qr_veiculo.COMPOSICAO = this.get_composicao(placa = arguments.placa, sem_aspas = true)>
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select dbms_xmlgen.getxml(' 
            select pneu_id, num_pneu, situacao_id, marca_id, marca,
                   modelo_id, modelo, sulco, medida_id, medida,
                   medida_roda_id, medida_roda, reformas, posicao, 
                   placa, oper.pkg_veiculo.fnc_get_cod_veiculo(placa) as frota,
                   data_inspecao, data_ult_inspecao, user_insert, num_inspecao, nvl(mm_montagem,0) as mm_montagem, 
                   sulco_atual,  oper.pkg_global.fnc_get_parametro(1,'PNEU')/100 as tolerancia
              from ( 	select p.pneu_id, p.num_pneu, p.situacao_id, p.marca_id, p.marca,
                               p.modelo_id, p.modelo, p.sulco, p.medida_id, p.medida,
                               p.medida_roda_id, p.medida_roda, p.reformas, pm.posicao, pi.placa,
                               pi.data_inspecao, pi.data_ult_inspecao, pi.user_insert, pi.num_inspecao, 
                               case 
                                 when nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(pneu_id),1),0) >= mm_montagem then -1
                               else nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(pneu_id),1),0)
                               end sulco_atual,						   
                               pvp.num_eixo, pvp.ordem, pm.km_montagem, pm.mm_montagem
                          from oper.v$pneu_inspecao pi
                         inner join oper.v$pneu_dados p 
                                 on p.pneu_id = pi.pneu_id
                                and pi.mm_inspecao is null
                         inner join oper.v$pneu_veiculo_posicao pvp 
                                 on pvp.placa = pi.placa
                                and pvp.posicao = pi.posicao
                         left join oper.v$pneu_movimentacao pm 
                                 on pm.placa = pi.placa
                                        and pm.pneu_id = pi.pneu_id
                                      and pm.data_desmontagem is null
                         where instr(' || chr(39) || '#qr_veiculo.COMPOSICAO#' || chr(39) ||  ',pi.placa) > 0)
             order by instr('|| chr(39) || '#qr_veiculo.COMPOSICAO#' || chr(39) || ',placa)
             , num_eixo ,ordem') as resultado
         from dual
   		</cfquery>		
		<cfreturn qrPneus>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os dados para a montagem dos pneus
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 25/01/2006
	--->
	<cffunction name="get_dados_pneu_montagem" returntype="query" access="remote">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfargument name="posicao" required="yes">
		<cfif Len(Trim(arguments.COD_VEICULO))>
			<cfset arguments.placa = this.get_placa(arguments.COD_VEICULO)>
		</cfif>
		<cfquery name="qrPneu"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_pneu.fnc_pneu_geminado('#arguments.placa#','#arguments.posicao#') as parceiro,
				   oper.pkg_pneu.fnc_medida_roda_veiculo('#arguments.placa#') as medida_roda_id,
				   num_gabarito, num_eixo, null as medida_id, null as marca_id, null as modelo_id, null as reformas,
				   null as borracha_id, null as desenho_id, 
				   null as parc_num_pneu, null as parc_data_inspecao, null as parc_mm_inspecao, null as parc_mm_estimado
			  from oper.v$pneu_veiculo_posicao 
			  where placa = '#arguments.placa#'
			    and posicao = '#arguments.posicao#'  
   		</cfquery>		
		<cfif Len(Trim(qrPneu.parceiro)) and len(trim(qrPneu.parc_num_pneu)) >
			<cfquery name="qrPneuParceiro"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select /*+ FIRST_ROWS */ p.num_pneu as PARC_NUM_PNEU, 
					   oper.pkg_pneu.fnc_sulco_atual_estimado(p.pneu_id) as PARC_MM_ESTIMADO,  
					   data_inspecao as PARC_DATA_INSPECAO, oper.pkg_pneu.fnc_sulco_atual(p.pneu_id) as PARC_MM_INSPECAO,
			           marca_id, modelo_id, medida_id, reformas, borracha_id, desenho_id,
					   #qrPneu.medida_roda_id# as medida_roda_id, #qrPneu.num_gabarito# as num_gabarito, 
					   #qrPneu.num_eixo# as num_eixo, #qrPneu.parceiro# as parceiro, sulco
				  from (select pd.pneu_id, pd.num_pneu, pm.mm_montagem, 
							   oper.pkg_pneu.fnc_km_rodado(pm.placa, nvl(pi.data_inspecao,pm.data_montagem), pvp.suspenso) as km_rodado,
							   oper.pkg_pneu.fnc_rendimento_pneu(pm.pneu_id, pvp.modelo_eixo_id, pvp.num_eixo, 0/*pvp.tipo_veiculo*/) as rendimento,
							   pm.num_gabarito, pm.num_eixo, pd.marca_id, pd.modelo_id, pd.medida_id, pd.reformas, pr.borracha_id, pr.desenho_id, pd.medida_roda_id, 
							   pd.marca, pd.modelo, d.descricao as desenho, pb.descricao as borracha, pd.medida, pd.medida_roda,
							   pm.placa, pm.data_montagem, pm.km_montagem, pvp.suspenso, pvp.geminado, pvp.cod_posicao,
							   oper.pkg_pneu.fnc_pneu_geminado(pm.pneu_id) as parceiro, 
							   pi.data_inspecao, pi.mm_inspecao, trunc(sysdate - pi.data_inspecao) as dias_ult_inspecao, 
							   oper.pkg_pneu.fnc_sulco_atual(pd.pneu_id) as sulco
						  from oper.v$pneu_dados pd
						 inner join oper.v$pneu_movimentacao pm
									 on pm.pneu_id = pd.pneu_id 
						 inner join oper.v$pneu_veiculo_posicao pvp
									 on pvp.placa = pm.placa
									and pvp.num_gabarito = pm.num_gabarito
									and pvp.num_eixo = pm.num_eixo
									and pvp.posicao = pm.posicao
						 left join oper.v$pneu_inspecao pi
								 on pd.pneu_id = pi.pneu_id
						 left join oper.v$pneu_reforma pr
							    on pr.pneu_id = pd.pneu_id
						 left join oper.v$pneu_borracha pb
							 	on pb.borracha_id = pr.borracha_id
						 left join oper.v$pneu_desenho d
								on d.borracha_id = pr.borracha_id
							   and d.desenho_id = pr.desenho_id														 
						where pm.data_desmontagem is null
						  and pd.pneu_id = #qrPneu.parceiro# 
						  and (pi.data_inspecao = (select max(pi2.data_inspecao)
						                            from oper.v$pneu_inspecao pi2
						                           where pi2.pneu_id = pi.pneu_id)
					           or pi.data_inspecao is null)
						  and (pr.data_retorno_reforma = (select max(r2.data_retorno_reforma)
															from oper.v$pneu_reforma r2
														   where r2.pneu_id = pr.pneu_id
															 and r2.data_retorno_reforma is not null
															 and r2.conserto = 0)
							   or (select max(r2.data_retorno_reforma)
															from oper.v$pneu_reforma r2
														   where r2.pneu_id = pr.pneu_id
															 and r2.data_retorno_reforma is not null
															 and r2.conserto = 0) is null)) p

			</cfquery>		
			<cfreturn qrPneuParceiro>
		</cfif>		
		<cfreturn qrPneu>		
	</cffunction>
	<!--- 
	-- PROPSITO 
	-- Busca os dados para a troca dos pneus
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 24/01/2006
	--->
	<cffunction name="get_dados_pneu_troca" returntype="query" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfquery name="qrPneu"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ ORDERED */ pneu_id, num_pneu, num_gabarito, num_eixo ,marca_id, mm_montagem, data_montagem, pmov_id, 
				   modelo_id, reformas, borracha_id, desenho_id, medida_roda_id, marca, modelo, desenho, borracha,
				   medida, medida_roda, placa, data_montagem, km_montagem, suspenso, geminado, cod_posicao, parceiro,
				   null as parc_num_pneu, null as parc_data_inspecao, null as parc_mm_inspecao, null as parc_mm_estimado,
				   0 as dias_ult_inspecao, posicao,
				   case 
				      when trunc(sysdate - oper.pkg_pneu.fnc_ultima_inspecao(pneu_id)) >= 2 then mm_montagem
					  when trunc(sysdate - oper.pkg_pneu.fnc_ultima_inspecao(pneu_id)) < 2 then oper.pkg_pneu.fnc_sulco_atual(pneu_id)
				   end sulco_parametro, medida_id, tempo_montagem
 			  from (select pm.pneu_id, pd.num_pneu, pm.mm_montagem, pm.posicao, pm.pmov_id, 
						   pm.num_gabarito, pm.num_eixo, pd.marca_id, pd.modelo_id, pd.reformas, 
						   pr.borracha_id, pr.desenho_id, pd.medida_roda_id, pd.medida_id,
						   pd.marca, pd.modelo, d.descricao as desenho, pb.descricao as borracha, 
						   pd.medida, pd.medida_roda, pm.placa, to_char(pm.data_montagem,'dd/mm/yyyy hh24:mi') as data_montagem, pm.km_montagem, 
                           round(sysdate - pm.data_montagem)*24 as tempo_montagem,
						   pvp.suspenso, pvp.geminado, pvp.cod_posicao,
						   oper.pkg_pneu.fnc_pneu_geminado(pm.pneu_id) as parceiro
					  from oper.v$pneu_dados pd
					 inner join oper.v$pneu_movimentacao pm
								 on pm.pneu_id = pd.pneu_id 
					 inner join oper.v$pneu_veiculo_posicao pvp
								 on pvp.placa = pm.placa
								and pvp.num_eixo = pm.num_eixo
								and pvp.posicao = pm.posicao
    				  left join oper.v$pneu_reforma pr
						     on pr.pneu_id = pd.pneu_id
					  left join oper.v$pneu_borracha pb
							 on pb.borracha_id = pr.borracha_id
					  left join oper.v$pneu_desenho d
							 on d.borracha_id = pr.borracha_id
						    and d.desenho_id = pr.desenho_id												  
					where pd.pneu_id = #arguments.pneu_id#
					  and pm.data_desmontagem is null
					  and (pr.data_retorno_reforma = (select max(r2.data_retorno_reforma)
													 from oper.v$pneu_reforma r2
													where r2.pneu_id = pr.pneu_id
													  and r2.data_retorno_reforma is not null
													  and r2.conserto = 0)
						   or (select max(r2.data_retorno_reforma)
													 from oper.v$pneu_reforma r2
													where r2.pneu_id = pr.pneu_id
													  and r2.data_retorno_reforma is not null
													  and r2.conserto = 0) is null)
					  ) 
   		</cfquery>		
		<cfif Len(Trim(qrPneu.parceiro)) >
			<cfquery name="qrPneuParceiro"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select /*+ FIRST_ROWS */ p.num_pneu as PARC_NUM_PNEU, 
					   decode(p.rendimento,0,-1, round(nvl(mm_inspecao, p.mm_montagem) - (p.km_rodado/p.rendimento),1)) as PARC_MM_ESTIMADO, 
					   data_inspecao as PARC_DATA_INSPECAO, 
					   mm_inspecao as PARC_MM_INSPECAO, parceiro,
					   num_gabarito, num_eixo ,marca_id, 
					   #qrPneu.mm_montagem# as mm_montagem,
					   modelo_id, reformas, borracha_id, desenho_id, medida_roda_id, marca, modelo, desenho, borracha,
					   medida, medida_roda, placa, data_montagem as data_montagem_parceiro,  km_montagem, suspenso, geminado, cod_posicao, 
					   #qrPneu.num_pneu# as num_pneu,
					   dias_ult_inspecao, '#qrPneu.posicao#' as posicao, sulco, to_date('#LSDateFormat(qrPneu.DATA_MONTAGEM)#','dd/mm/yyyy') as data_montagem,
					   '#qrPneu.PMOV_ID#' as pmov_id, '#qrPneu.sulco_parametro#' as sulco_parametro, medida_id,
                       tempo_montagem
				  from (select pd.pneu_id, pd.num_pneu, pm.mm_montagem, 
							   oper.pkg_pneu.fnc_km_rodado(pm.placa, nvl(pi.data_inspecao,pm.data_montagem), pvp.suspenso) as km_rodado,
							   oper.pkg_pneu.fnc_rendimento_pneu(pm.pneu_id, pvp.modelo_eixo_id, pvp.num_eixo, pvp.tipo_carroceria_id) as rendimento,
							   pm.num_gabarito, pm.num_eixo, pd.marca_id, pd.modelo_id, pd.reformas, pr.borracha_id, pr.desenho_id, pd.medida_roda_id, 
							   pd.marca, pd.modelo, d.descricao as desenho, pb.descricao as borracha, pd.medida, pd.medida_roda,
							   pm.placa, to_char(pm.data_montagem,'dd/mm/yyyy hh24:mi') as data_montagem, pm.km_montagem, pvp.suspenso, pvp.geminado, pvp.cod_posicao,
							   oper.pkg_pneu.fnc_pneu_geminado(pm.pneu_id) as parceiro, 
							   nvl(pi.data_inspecao,pm.data_montagem) as data_inspecao, nvl(pi.mm_inspecao,pm.mm_montagem) as mm_inspecao, trunc(sysdate - pi.data_inspecao) as dias_ult_inspecao,
							   oper.pkg_pneu.fnc_sulco_atual(pd.pneu_id) as sulco, pd.medida_id,
                               round(sysdate - pm.data_montagem)*24 as tempo_montagem
						  from oper.v$pneu_dados pd
						 inner join oper.v$pneu_movimentacao pm
									 on pm.pneu_id = pd.pneu_id 
						 inner join oper.v$pneu_veiculo_posicao pvp
									 on pvp.placa = pm.placa
									and pvp.num_eixo = pm.num_eixo
									and pvp.posicao = pm.posicao
						 left join oper.v$pneu_inspecao pi
								 on pd.pneu_id = pi.pneu_id
						 left join oper.v$pneu_reforma pr
							    on pr.pneu_id = pd.pneu_id
						 left join oper.v$pneu_borracha pb
							 	on pb.borracha_id = pr.borracha_id
						 left join oper.v$pneu_desenho d
								on d.borracha_id = pr.borracha_id
							   and d.desenho_id = pr.desenho_id														 
						where pm.data_desmontagem is null
						  and pd.pneu_id = #qrPneu.parceiro#
						  and (pi.data_inspecao = (select max(pi2.data_inspecao)
												  from oper.v$pneu_inspecao pi2
												 where pi2.pneu_id = pi.pneu_id)
							   or pi.data_inspecao is null)
						  and (pr.data_retorno_reforma = (select max(r2.data_retorno_reforma)
															from oper.v$pneu_reforma r2
														   where r2.pneu_id = pr.pneu_id
															 and r2.data_retorno_reforma is not null
															 and r2.conserto = 0)
							   or (select max(r2.data_retorno_reforma)
															from oper.v$pneu_reforma r2
														   where r2.pneu_id = pr.pneu_id
															 and r2.data_retorno_reforma is not null
															 and r2.conserto = 0) is null)) p	
			</cfquery>			
			<cfreturn qrPneuParceiro>
		</cfif>		
		<cfreturn qrPneu>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca outros custos do pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 08/02/2006
	--->
	<cffunction name="get_demais_custos" returntype="query" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_mms" username="#session.usuario#" password="#session.senha#">
			select r.reforma_id,
				   r.pneu_id,
				   prb.cod_pessoa as cod_pessoa_reformador,
                   r.reformador_id,
				   r.borracha_id,
				   r.desenho_id,
				   r.data_envio_reforma,
				   r.data_retorno_reforma,
				   r.num_relacao,
				   r.num_nota_fiscal,
				   r.custo,
				   r.cod_moeda,
				   r.pneu_id_garantia,
				   r.garantia_carcaca,
				   r.garantia_reforma,
				   r.conserto,
				   r.tipo_conserto_id,
				   r.furo,
				   r.analise_garantia,
				   p.razao_social as local,
				   t.descricao as tipo
			  from oper.v$pneu_reforma r
             inner join oper.v$pneu_reformador_bandeira prb
                     on prb.reformador_id = r.reformador_id
			 inner join kss.v$pessoa p
					 on p.cod_pessoa = prb.cod_pessoa
			 inner join oper.v$pneu_tipo_conserto t
					 on r.TIPO_CONSERTO_ID = t.tipo_conserto_id
			 where r.pneu_id = #arguments.pneu_id#
  		</cfquery>
		<cfreturn qr_mms>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as marcas cadastradas
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 18/01/2006
	--->
	<cffunction name="get_desenhos" returntype="query" access="remote">
		<cfargument name="borracha_id" required="no">
		<cfargument name="desenho_id" required="no">
		<cfargument name="descricao" required="no" default="">
		<cfargument name="descricao_d" required="no" default="">
		<cfargument name="sem_imagem" required="no" default="0">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select t.desenho_id, t.borracha_id, t.descricao as descricao_d, 
				   t.descricao,
				   t.sulco, t.formato_id, t.modalidade_id,
				   <cfif arguments.sem_imagem eq 0>t.imagem, </cfif>t.eixo_tracionado, t.eixo_direcional, t.eixo_suspenso,
				   pb.descricao as borracha   
				from oper.v$pneu_desenho t
			inner join oper.v$pneu_borracha pb
			        on pb.borracha_id = t.borracha_id
			 where 1 = 1
			   <cfif IsDefined("arguments.borracha_id")>			   
				   and pb.borracha_id = #arguments.borracha_id# 
			   </cfif>
			   <cfif IsDefined("arguments.desenho_id") and Len(Trim(arguments.desenho_id))>
				   and desenho_id in (#arguments.desenho_id#)
			   </cfif>
			   <cfif len(trim(arguments.descricao))>
			   and upper(t.descricao) like upper('%#arguments.descricao#%')
			</cfif>
			order by pb.descricao, t.formato_id, t.sulco, t.descricao 
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca a listagem de pneus do resumo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_detalhes" returntype="query" access="remote">
	    <cfargument name="status" required="yes">
	    <cfargument name="situacao_id" required="yes">
	    <cfargument name="cod_pessoa" required="yes">
        <cfargument name="cod_centro_custo" required="no" default="">
		<!--- novos / 0 KM --->
		<cfif arguments.status eq 1>
			<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select pd.pneu_id, pd.num_pneu, pd.marca, pd.modelo, pd.medida, pd.medida_roda, pd.marca || pd.modelo || pd.medida as marca_modelo,
					   oper.pkg_pneu.fnc_sulco_atual(pd.pneu_id) as sulco
				  from oper.v$pneu_dados pd
				 inner join oper.v$pneu_localizacao_atual pl
						 on pl.pneu_id = pd.pneu_id						
						and pd.reformas = 0
						and pl.data_entrada is not null
					and pl.cod_pessoa = #arguments.cod_pessoa#                    
				 where pl.cod_pessoa = pl.cod_pessoa
                 <cfif len(trim(arguments.cod_centro_custo)) >
                   and pl.cod_centro_custo = #arguments.cod_centro_custo#
                 </cfif>
				   and pd.situacao_id = #arguments.situacao_id#
				   and not exists (select 'x'
									 from oper.v$pneu_movimentacao pm
									where pm.pneu_id = pd.pneu_id)
				  order by pd.marca || pd.modelo || pd.medida, num_pneu
   			</cfquery>		
			<cfreturn qrPneus>
		</cfif>
		<!--- novos / rodados --->		
		<cfif arguments.status eq 2>
			<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select p2.pneu_id, p2.num_pneu, p2.marca, p2.modelo, p2.medida, p2.medida_roda, p2.marca || p2.modelo || p2.medida as marca_modelo,
					   oper.pkg_pneu.fnc_sulco_atual(p2.pneu_id) as sulco
				  from oper.v$pneu_dados p2
				 inner join oper.v$pneu_localizacao_atual pl2
						 on pl2.pneu_id = p2.pneu_id						
						and p2.reformas = 0
						and pl2.DATA_ENTRADA is not null
				 where pl2.cod_pessoa = #arguments.cod_pessoa#
                 <cfif len(trim(arguments.cod_centro_custo)) >
                   and pl2.cod_centro_custo = #arguments.cod_centro_custo#
                 </cfif>
				   and p2.situacao_id = #arguments.situacao_id#
		           and exists (select 'x'
								  from oper.v$pneu_movimentacao pm
								 where pm.pneu_id = p2.pneu_id)
				  order by p2.marca || p2.modelo || p2.medida   , num_pneu    
   			</cfquery>		
			<cfreturn qrPneus>
		</cfif>
		<!--- reformados / 0 km --->		
		<cfif arguments.status eq 3>
			<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select /*+ USE_HASH(p2 pl2 pr) */
                       p2.pneu_id,
                       p2.num_pneu,
                       p2.marca,
                       p2.modelo,
                       p2.medida,
                       p2.medida_roda,
                       decode(prb.descricao,
                              null,
                              'Marca/Modelo No Identificado',
                              p2.marca || '/' || prb.descricao || '/' || prd.descricao) as marca_modelo,
                       decode(prb.descricao,
                              null,
                              'Borracha no Identificada',
                              prb.descricao) as borracha,
                       decode(prd.descricao,
                              null,
                              'Desenho no Identificado',
                              prd.descricao) as desenho,
                       oper.pkg_pneu.fnc_sulco_atual(p2.pneu_id) as sulco
		  	     from oper.v$pneu_dados p2
				inner join oper.v$pneu_localizacao_atual pl2
                                 on pl2.pneu_id = p2.pneu_id
                                and p2.reformas > 0
                                and pl2.data_entrada is not null
                left join oper.v$pneu_reforma pr
                        on pr.pneu_id = p2.pneu_id
                       and pr.conserto = 0
                left join oper.v$pneu_borracha prb
                        on prb.BORRACHA_ID = pr.BORRACHA_ID
                left join oper.v$pneu_desenho prd
                        on prd.desenho_ID = pr.desenho_ID
                where pl2.cod_pessoa = #arguments.cod_pessoa#
                  and p2.reformas > 0
				 <cfif len(trim(arguments.cod_centro_custo)) >
                   and pl2.cod_centro_custo = #arguments.cod_centro_custo#
                 </cfif>
                   and p2.situacao_id = #arguments.situacao_id#
                   and (pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
                                     from oper.v$pneu_reforma pr2
                                    where pr2.pneu_id = pr.pneu_id
                                      and pr2.conserto = 0) 
                         or not exists (select 'x'
                                             from oper.v$pneu_reforma pr2
                                            where pr2.pneu_id = p2.pneu_id) )
                   and not exists (select 'x'
                                     from oper.v$pneu_movimentacao pm
                                    where pm.pneu_id = pr.pneu_id
                                      and pm.data_montagem >= pr.data_retorno_reforma)
          	      order by p2.marca ||'/'|| prb.descricao ||'/'|| prd.descricao
                      , num_pneu
   			</cfquery>		
			<cfreturn qrPneus>
		</cfif>


		<!--- reformados / 0 km --->		
		<cfif arguments.status eq 4>
			<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select /*+ USE_HASH(p2 pl2 pr) */ p2.pneu_id, p2.num_pneu, p2.marca, p2.modelo, p2.medida, p2.medida_roda, p2.marca ||'/'|| prb.descricao ||'/'|| prd.descricao as marca_modelo, prb.descricao as borracha, prd.descricao as desenho,
					   oper.pkg_pneu.fnc_sulco_atual(p2.pneu_id) as sulco
							   from oper.v$pneu_dados p2
							  inner join oper.v$pneu_localizacao_atual pl2
										 on pl2.pneu_id = p2.pneu_id						
										and p2.reformas > 0
										and pl2.DATA_ENTRADA is not null
						  inner join oper.v$pneu_reforma pr
								  on pr.pneu_id = p2.pneu_id
								 and pr.conserto = 0
						  inner join oper.v$pneu_borracha prb
								  on prb.BORRACHA_ID = pr.BORRACHA_ID
						  inner join oper.v$pneu_desenho prd
								  on prd.desenho_ID = pr.desenho_ID
				
								 where pl2.cod_pessoa = #arguments.cod_pessoa#
                                 <cfif len(trim(arguments.cod_centro_custo)) >
                                   and pl2.cod_centro_custo = #arguments.cod_centro_custo#
                                 </cfif>
								   and p2.situacao_id = #arguments.situacao_id#
								 and pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
																  from oper.v$pneu_reforma pr2
																 where pr2.pneu_id = pr.pneu_id
																   and pr2.conserto = 0)
								   and exists (select 'x'
													 from oper.v$pneu_movimentacao pm
													where pm.pneu_id = pr.pneu_id
													  and pm.data_montagem >= pr.data_retorno_reforma)
								  order by p2.marca ||'/'|| prb.descricao ||'/'|| prd.descricao, num_pneu
   			</cfquery>		
			<cfreturn qrPneus>
		</cfif>
	</cffunction>
		
	<!--- 
	-- PROPSITO 
	-- Monta a ficha de inspecao do veiculo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 30/01/2006
	--->
	<cffunction name="get_ficha_inspecao" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
        <cfargument name="individual" required="no" default="0">
		<cfargument name="ficha_inspecao" hint="Quando for uma ficha para inspeo e no movimentacao" required="no">
        
		<cfif Len(Trim(arguments.cod_veiculo))>
			<cfset arguments.placa = this.get_placa(arguments.COD_VEICULO)>
		</cfif>
		
        <cfif arguments.individual eq 1>
        	<cfset qr_veiculo.COMPOSICAO = arguments.placa>
        <cfelse>
        	<cfset qr_veiculo.COMPOSICAO = this.get_composicao(placa = arguments.placa, sem_aspas = 1)>
        </cfif>
        
        <cfquery datasource="#session.dsn#" name="qr_pneus" username="#session.usuario#" password="#session.senha#">
			select p.num_pneu,
				   p.modelo,
				   p.marca,
				   p.borracha,
				   p.desenho,
				   pmov_id,
				   p.num_gabarito,
				   p.num_eixo,
                   pn.ano_fabricacao as dot,
				   caminho_imagem,
				   posicao,
				   placa,
				   oper.pkg_veiculo.fnc_get_cod_veiculo(placa) as frota,
				   p.pneu_id,
				   data_montagem,
				   mm_montagem,
				   km_montagem,
				   eixo_posicao,
				   posicao_gabarito,
				   ordem,
				   veiculo_modelo,
				   suspenso,
				   modelo_eixo_id,
				   '' as tipo_veiculo,
				   decode(p.num_eixo,0,0,(oper.pkg_pneu.fnc_km_rodado(p.placa, p.data_montagem, suspenso)))as km_rodado,
				   oper.pkg_pneu.fnc_km_atual(placa) as km_atual,
				   p.reformas,
				   oper.pkg_pneu.fnc_reforma_bloqueada(p.pneu_id) as reforma_bloqueada,
				   pj.cliente as reformador,
				   (select count(*)
					  from oper.v$pneu_reforma
					 where pneu_id = p.pneu_id
					   and conserto = 1
					   and furo = 0) quant_reparos,
				   0 quant_consertos_enviados,
				   case
					 when nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(p.pneu_id), 1), 0) >= mm_montagem 
					 then -1
					 else nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(p.pneu_id), 1), 0)
				   end mm_estimado,
				   to_number(kss.pkg_global.fnc_obtem_parametro_str(11, 'OPERACIONAL', 18, 1)) as tolerancia,
				   decode(pn.observacoes, null, 0, 1) as possui_observacoes,
                   1 as ordem_placa,
                   0 as dias_ult_inspecao, 
       null as ordem_placa
			  from oper.v$pneu_veiculo_gabarito p
			  left join oper.v$pneu pn on pn.pneu_id = p.pneu_id
			  left join kss.v$pessoa pj on pj.cod_pessoa =
													 p.cod_pessoa_reformador
			 where instr('#qr_veiculo.COMPOSICAO#', placa) > 0
			 order by instr('#qr_veiculo.COMPOSICAO#', placa), num_eixo, ordem
			 </cfquery>
		<cfreturn qr_pneus>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Monta busca fichas de envio 
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 10/02/2006
	--->	
	<cffunction name="get_fichas_reforma" returntype="query" access="remote">
		<cfargument name="num_relacao" required="no">
		<cfquery datasource="#session.dsn#" name="qr_pneus" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS */  r.num_relacao, r.data_envio, prb.cod_pessoa as cod_pessoa_reformador, pj.cliente as reformador, pb.imagem,
  				   oper.pkg_global.fnc_busca_nome_pessoa(u.cod_pessoa) as usuario,
  				   pd.num_pneu, pd.marca, pd.modelo, d.descricao as desenho, pr.data_envio_reforma,
  				   rel.num_pneus, kss.fnc_concat_all(kss.to_concat_expr(pr.pneu_id,',')) over(partition by r.num_relacao order by r.num_relacao) as pneus
			  from oper.v$pneu_relacao_envio_reforma r
		     inner join oper.v$pneu_reforma pr
			         on pr.num_relacao = r.num_relacao
					and pr.reformador_id = r.reformador_id
					and pr.data_retorno_reforma is null
             inner join oper.v$pneu_reformador_bandeira prb
                     on prb.reformador_id = pr.reformador_id
			 inner join kss.v$pessoa pj
			         on pj.cod_pessoa = prb.cod_pessoa
			 left join oper.v$pneu_borracha pb
					 on pb.borracha_id = pr.borracha_id
			 left join oper.v$pneu_desenho d
					 on d.borracha_id = pr.borracha_id
					and d.desenho_id = pr.desenho_id
			 inner join oper.v$pneu_dados pd
					 on pd.pneu_id = pr.pneu_id
			 inner join kss.kss_usuarios u
					 on u.usuario = pr.user_insert,
				   (select r2.num_relacao, count(*) as num_pneus
				      from oper.v$pneu_reforma r2					    
					 group by r2.num_relacao) rel
		    where rel.num_relacao = r.num_relacao
			  <cfif IsDefined("arguments.num_relacao")>
				  and r.num_relacao = #arguments.num_relacao#
			  </cfif>	 
			  order by num_relacao
		</cfquery>
		<cfreturn qr_pneus>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os Formatos de Borracha
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 13/02/2006
	--->	
	<cffunction name="get_formato_borracha" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qr_pneus" username="#session.usuario#" password="#session.senha#">
			select formato_id,
				   descricao
			  from oper.v$pneu_formato_borracha
  		</cfquery>
		<cfreturn qr_pneus>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca o gabarito do veculo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 20/01/2006
	--->
	<cffunction name="get_gabarito_veiculo" returntype="query" access="remote">
		<cfargument name="placa" 	required="no" default="">
		<cfargument name="cod_veiculo" 	required="no" default="">
		<cfargument name="pneu_id" 	required="no" default="">
        <cfargument name="individual" 	required="no" default="0">
		<cfif Len(Trim(arguments.COD_VEICULO))>
			<cfset arguments.placa = this.get_placa(arguments.COD_VEICULO)>
		</cfif>
		
		<cfif arguments.individual eq 1>
        	<cfset qr_veiculo.COMPOSICAO = arguments.placa>
        <cfelse>
        	<cfset qr_veiculo.COMPOSICAO = this.get_composicao(placa = arguments.placa, sem_aspas = 1)>
        </cfif>
		
		<cfquery datasource="#session.dsn#" name="qr_pneus" username="#session.usuario#" password="#session.senha#">
			select /*+ ORDERED */ 
            	   num_pneu, 
                   modelo, 
                   marca, 
                   borracha , 
                   desenho,  
                   pmov_id, 
                   num_gabarito, 
                   num_eixo, 
                   caminho_imagem, 
                   posicao, 
				   placa, 
                   oper.pkg_veiculo.fnc_get_cod_veiculo(placa) as frota,
				   pneu_id, 
                   data_montagem, 
                   mm_montagem, 
                   km_montagem, 
                   eixo_posicao, 
                   posicao_gabarito, 
                   ordem, 
				   suspenso, 
                   modelo_eixo_id, 
                   veiculo_modelo,
 			       decode(data_montagem,null,0,decode(num_eixo,0,0,oper.pkg_pneu.fnc_km_rodado(placa, data_montagem, suspenso))) as km_rodado,
				   trunc(sysdate - oper.pkg_pneu.fnc_ultima_inspecao(pneu_id)) as dias_ult_inspecao,
				   oper.pkg_pneu.fnc_ultima_inspecao(pneu_id) as data_ult_inspecao,
				   oper.pkg_pneu.fnc_km_atual(placa) as km_atual, 
                   reformas,
				   case 
					 when nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(pneu_id),1),0) >= mm_montagem then -1
				     else nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(pneu_id),1),0)
				   end mm_estimado,
                   (select pmr.MEDIDA_RODA
                      from oper.v$pneu_medida_roda pmr
                     where medida_roda_id = oper.pkg_pneu.fnc_medida_roda_veiculo(placa)) as medida_roda
			  from oper.v$pneu_veiculo_gabarito pg
			 where instr('#qr_veiculo.COMPOSICAO#', placa) > 0
			 <cfif len(trim(arguments.pneu_id))>
			   and pg.pneu_id = #arguments.pneu_id#
			 </cfif>
		     order by instr('#qr_veiculo.COMPOSICAO#', placa), posicao_gabarito, ordem, num_eixo
		</cfquery>
		<cfreturn qr_pneus>
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Busca dados para a montagem do grafico de desmontagem
	-- CRISTOFER  03/05/2006
	--->		
	<cffunction name="get_grafico_desmontagem" access="remote" returntype="query" output="true">
		<cfargument name="laudo_id" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select count(*) as ocorrencias,
				   sum(count(*)) over() as total,
				   round((count(*)/sum(count(*)) over())*100, 2) as percentual,
				   pm.laudo_desmontagem_id,
				   pd.DESCRICAO as laudo
			  from oper.v$pneu_movimentacao pm
			 inner join oper.v$pneu_laudo_desmontagem pd
					 on pd.laudo_id = pm.laudo_desmontagem_id
			 where 1=1
			 <cfif len(trim(arguments.laudo_id))>
			   and laudo_desmontagem_id in (#arguments.laudo_id#)
			 </cfif>
			 <cfif len(trim(arguments.data_inicial))>
			   and trunc(pm.data_desmontagem) >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and trunc(pm.data_desmontagem) <= '#arguments.data_final#'
			 </cfif>
			 group by pm.laudo_desmontagem_id,
					  pd.DESCRICAO
			 order by pd.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>			 

	<!--- 
	-- PROPSITO 
	-- Busca as inspecoes em aberto nos veiculos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 30/01/2006
	--->
	<cffunction name="get_grupos_veiculos" access="remote" returntype="query" output="true">
		<cfargument name="cod_grupo" required="no">
		<cfquery datasource="#session.dsn#" name="qr_grupos" username="#session.usuario#" password="#session.senha#">
			select cod_grupo, cod_grupo || decode(situacao_id,1,' (Ativo)',' (Inativo)')  as cod_grupo_situacao, descricao
            		/*,  limite_veiculo*/
			  from oper.v$veiculo_grupo_setup
             where 1=1
			<cfif IsDefined("arguments.COD_GRUPO") and Len(Trim(arguments.COD_GRUPO))>
			   and cod_grupo in (#ListQualify(arguments.COD_GRUPO,"'")#)
			</cfif>
			order by situacao_id desc, cod_grupo
   		</cfquery>	
		<cfreturn qr_grupos>
	</cffunction>	
		
	<!--- 
	-- PROPSITO 
	-- Busca as inspecoes em aberto nos veiculos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 30/01/2006
	--->
	<cffunction name="get_inspecoes_abertas" returntype="query" access="remote">
		<cfargument name="todas" required="no" default="0">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfif arguments.todas eq 1>
				select /*+ FIRST_ROWS*/ 
					    oper.pkg_veiculo.fnc_get_cod_veiculo(pi.placa) as frota, pi.placa, pi.km_inspecao as km_veiculo, 
						max(pi.data_inspecao) as data_inspecao, pi.user_insert, max(pi.data_insert) as data_insert,
						(select distinct cod_pessoa
						   from kss.v$kss_usuario_lotacao 
						  where usuario = pi.user_insert) as cod_pessoa_filial
				  from oper.v$pneu_inspecao pi
				 where pi.mm_inspecao is null
				 group by pi.placa, pi.km_inspecao, pi.user_insert
				
				union 
			</cfif>
			select /*+ FIRST_ROWS*/ 
					oper.pkg_veiculo.fnc_get_cod_veiculo(pi.placa) as frota, pi.placa, pi.km_inspecao as km_veiculo, 
					max(pi.data_inspecao) as data_inspecao, pi.user_insert, max(pi.data_insert) as data_insert,
					(select distinct cod_pessoa
					   from kss.v$kss_usuario_lotacao 
					  where usuario = pi.user_insert) as cod_pessoa_filial
			  from oper.v$pneu_inspecao pi
			 where pi.mm_inspecao is null
			   and (oper.pkg_veiculo.fnc_veiculo_tracao(pi.placa) = 1 or
					  not exists (select 'x'
									from oper.v$veiculo_composicao vc
								   where vc.placa_2 = pi.placa
									 and vc.DATA_HORA_DESENGATE is null))
			 group by pi.placa, pi.km_inspecao, pi.user_insert
			
			 order by 3
   		</cfquery>		
		<cfreturn qrPneus>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os laudos de analise
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 24/01/2006
	--->	
	<cffunction name="get_laudo_analise" returntype="query" access="remote">
		<cfquery name="qrLaudos"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select l.laudo_id, l.descricao, 
			       (select count(*)
				      from oper.v$pneu_inspecao pi
					 where pi.laudo_analise_id = l.laudo_id) as uso,
					decode(rd.responsavel_id,null,0,1) as resp_motorista 
			  from oper.v$pneu_laudo_analise l
			  left join oper.v$pneu_resp_desgaste rd
			         on rd.laudo_id = l.laudo_id
					and rd.responsavel_id = 5
			 order by 3 desc
   		</cfquery>		
		<cfreturn qrLaudos>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os laudos de analise
	-- NOTAS EXPLICATIVAS
	-- LEOPOLDOS 12/07/2010
	--->	
	<cffunction name="get_laudo_analise_xml" returntype="query" access="remote">
		<cfquery name="qrLaudos"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select dbms_xmlgen.getxml(' 
			select l.laudo_id, l.descricao, 
			       (select count(*)
				      from oper.v$pneu_inspecao pi
					 where pi.laudo_analise_id = l.laudo_id) as uso,
					decode(rd.responsavel_id,null,0,1) as resp_motorista 
			  from oper.v$pneu_laudo_analise l
			  left join oper.v$pneu_resp_desgaste rd
			         on rd.laudo_id = l.laudo_id
					and rd.responsavel_id = 5
			 order by 3 desc') as resultado
         from dual
   		</cfquery>		
		<cfreturn qrLaudos>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os laudos de desmontagem
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 24/01/2006
	--->	
	<cffunction name="get_laudo_desmontagem" returntype="query" access="remote">
		<cfargument name="mostrar_uso" required="no" default="1">
		<cfquery name="qrLaudos"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select laudo_id, 
			<cfif arguments.mostrar_uso eq 1>
				   (select count(*)
				       from oper.v$pneu_movimentacao pm
				  	  where pm.laudo_desmontagem_id = l.laudo_id) as uso,
			</cfif>
				   descricao
			  from oper.v$pneu_laudo_desmontagem l
			 order by 2 desc
   		</cfquery>		
		<cfreturn qrLaudos>
	</cffunction>
			
	<!--- 
	-- PROPSITO 
	-- Busca os laudos de sucateamento
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 01/02/2006
	--->	
	<cffunction name="get_laudo_sucateamento" returntype="query" access="remote">
		<cfargument name="laudo_id" required="no">
		<cfargument name="com_sucateamento" required="no">
		<cfargument name="com_venda" required="no" default="0">
		<cfargument name="sem_imagem" required="no" default="0">
		<cfquery name="qrLaudos"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select s.laudo_id, s.descricao, s.observacao, 
					<cfif arguments.SEM_IMAGEM eq 0>s.imagem,</cfif>
			       decode(rs.responsavel_id,null,0,1) as resp_motorista
			  from oper.v$pneu_laudo_sucateamento s
 			  left join oper.v$pneu_resp_sucateamento rs
			         on rs.laudo_id = s.laudo_id
					and rs.responsavel_id = 1
			 where 1=1
			 <cfif arguments.com_venda neq 1>
			   and s.laudo_id not in ('C43','F72')
			 </cfif>
			 <cfif IsDefined("arguments.LAUDO_ID")>
				 and s.laudo_id = '#arguments.LAUDO_ID#'
			 </cfif>
			 <cfif IsDefined("arguments.com_sucateamento")>
			     and exists (select 'x'
				               from oper.v$pneu_sucateamento ps2
							  where ps2.laudo_id = s.laudo_id)
			 </cfif>
			 order by s.laudo_id
   		</cfquery>		
		<cfreturn qrLaudos>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca a lista de pneus em descarte da filial
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 18/01/2006
	--->
	<cffunction name="get_lista_pneus_descarte" returntype="query" access="remote">
		<cfargument name="cod_pessoa" required="yes">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.pneu_id,p.num_pneu,p.marca, p.modelo, 
			       oper.pkg_pneu.fnc_sulco_atual(p.pneu_id) as sulco
			  from oper.v$pneu_dados p
			 inner join oper.v$pneu_localizacao pl 
			         on pl.pneu_id = p.pneu_id
					and pl.cod_pessoa = #arguments.cod_pessoa#
					and data_saida is null
					and data_transferencia is null 
	         left join kss.v$pessoa pj
                    on pj.cod_pessoa = pl.cod_pessoa
	         left join (oper.v$pneu_proprietario pp
						inner join kss.v$pessoa pj2
		                   on pj2.cod_pessoa = pp.cod_pessoa)
                    on p.pneu_id = pp.pneu_id
			 left join oper.v$pneu_reforma pr
			        on pr.pneu_id = p.pneu_id
				   and pr.conserto = 0
			 left join oper.v$pneu_borracha pb
					on pb.borracha_id = pr.borracha_id
			left join oper.v$pneu_desenho pd
					on pd.borracha_id = pr.borracha_id
				   and pd.desenho_id = pr.desenho_id													 
			 where situacao_id = 6
			 and (pr.pneu_id is null or pr.data_retorno_reforma =
                                  (select max(pr2.data_retorno_reforma)
                                         from oper.v$pneu_reforma pr2
                                        where pr2.pneu_id = pr.pneu_id
                                          and pr2.conserto = 0))	
   		</cfquery>		
		<cfreturn qrPneus>
	</cffunction>		
		
	<!--- 
	-- PROPSITO 
	-- Busca as marcas cadastradas
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 18/01/2006
	--->
	<cffunction name="get_marcas" returntype="query" access="remote">
		<cfargument name="com_pneus" required="no">
		<cfargument name="marca_id" required="no">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select marca_id, initcap(descricao) as descricao
			  from oper.v$pneu_marca m
			  where 1=1
			  <cfif IsDefined("arguments.com_pneus") and arguments.com_pneus eq 1>
			  	and exists (select 'x'
				              from oper.v$pneu_movimentacao pm
							 inner join oper.v$pneu p 
							         on pm.pneu_id = p.pneu_id
							 where p.marca_id      = m.marca_id)
			  </cfif>
			  <cfif IsDefined("arguments.marca_id") and Len(Trim(arguments.marca_id))>
			  	and marca_id in (#arguments.marca_id#)
			  </cfif>
			order by  descricao
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	
    
    <!--- 
	-- PROPSITO 
	-- Busca as marcas cadastradas - xml
	-- NOTAS EXPLICATIVAS
	-- LEOPOLDOS 06/07/2010
	--->
	<cffunction name="get_marcas_xml" returntype="query" access="remote">
		<cfargument name="marca_id" required="no">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select dbms_xmlgen.getxml('
                    select marca_id, initcap(descricao) as descricao
                      from oper.v$pneu_marca m
                    order by  descricao
                    ') as resultado 
              from dual
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca todas as medidas de roda cadastradas
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_medida_roda" returntype="query" access="remote">
		<cfargument name="medida_roda_id" required="no">
		<cfargument name="com_pneus" required="no">
		<cfquery datasource="#session.dsn#" name="qrMedidas" username="#session.usuario#" password="#session.senha#">
			select medida_roda_id, medida_roda
			  from oper.v$pneu_medida_roda pr
              where 1=1
			  <cfif IsDefined("arguments.com_pneus") and arguments.com_pneus eq 1>
			  	and exists (select 'x'
				              from oper.v$pneu_movimentacao pm
							 inner join oper.v$pneu p 
							         on pm.pneu_id = p.pneu_id
							 where p.medida_roda_id = pr.medida_roda_id)
			  </cfif>
			  <cfif IsDefined("arguments.medida_roda_id") and Len(Trim(arguments.medida_roda_id))>
			  	and medida_roda_id in (#arguments.medida_roda_id#)
			  </cfif>
   		</cfquery>		
		<cfreturn qrMedidas>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca a medida das rodas do veiculo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 20/01/2006
	--->
	<cffunction name="get_medida_roda_veiculo" returntype="string" access="remote">
		<cfargument name="cod_veiculo" required="yes">
		<cfset arguments.placa = this.get_placa(arguments.COD_VEICULO)>
		<cfquery name="qrMedidaRoda"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select medida_roda_id, medida_roda
			  from oper.v$pneu_medida_roda
			 where medida_roda_id = oper.pkg_pneu.fnc_medida_roda_veiculo('#arguments.placa#')
   		</cfquery>		
		<cfreturn qrMedidaRoda.medida_roda>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca todas as medidas cadastradas
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_medidas" returntype="query" access="remote">
		<cfargument name="medida_id" required="no">
		<cfargument name="com_pneus" required="no">
		<cfquery datasource="#session.dsn#" name="qrMedidas" username="#session.usuario#" password="#session.senha#">
			select medida_id, descricao
			  from oper.v$pneu_medida pe
              where 1=1
			  <cfif IsDefined("arguments.com_pneus") and arguments.com_pneus eq 1>
			  	and exists (select 'x'
				              from oper.v$pneu_movimentacao pm
							 inner join oper.v$pneu p 
							         on pm.pneu_id = p.pneu_id
							 where p.medida_id = pe.medida_id)
			  </cfif>
			  <cfif IsDefined("arguments.medida_id") and Len(Trim(arguments.medida_id))>
			  	and medida_id in (#arguments.medida_id#)
			  </cfif>
   		</cfquery>		
		<cfreturn qrMedidas>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os totais de MM inspecionados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_mm_inspecionados" returntype="query" access="remote">
		<cfargument name="data_inicial" required="yes">
		<cfargument name="data_final" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_mms" username="#session.usuario#" password="#session.senha#">
			select 
				  (select sum(pi.mm_ult_inspecao - pi.mm_inspecao)
					 from oper.v$pneu_inspecao pi
					where pi.data_inspecao between '#arguments.data_inicial#' and '#arguments.data_final#') as total_inspecionado,

				  (select sum(pi.km_carregado + pi.km_vazio)
					 from oper.v$pneu_inspecao pi
					where pi.data_inspecao between '#arguments.data_inicial#' and '#arguments.data_final#') as total_inspecionado_km,

				  (select sum(pi.mm_ult_inspecao - pi.mm_inspecao)
					 from oper.v$pneu_inspecao pi
					where pi.data_inspecao between '#arguments.data_inicial#' and '#arguments.data_final#'
					  and pi.LAUDO_ANALISE_ID is not null
					  and pi.LAUDO_ANALISE_ID <> 18) as mm_com_laudo,
				   (select sum(pi.mm_ult_inspecao - pi.mm_inspecao)
					  from oper.v$pneu_inspecao pi
					 where pi.data_inspecao between '#arguments.data_inicial#' and '#arguments.data_final#'
					   and pi.movimentacao = 0) as mm_de_inspecao,
					   
				   (select sum(pi.km_carregado + pi.km_vazio)
					  from oper.v$pneu_inspecao pi
					 where pi.data_inspecao between '#arguments.data_inicial#' and '#arguments.data_final#'
					   and pi.movimentacao = 0) as mm_de_inspecao_km,
					   
				   (select sum(pi.mm_ult_inspecao - pi.mm_inspecao)
					  from oper.v$pneu_inspecao pi
					 where pi.data_inspecao between '#arguments.data_inicial#' and '#arguments.data_final#'
					   and pi.movimentacao = 1) as mm_de_movimentacao,
					   
				   (select sum(pi.km_carregado + pi.km_vazio)
					  from oper.v$pneu_inspecao pi
					 where pi.data_inspecao between '#arguments.data_inicial#' and '#arguments.data_final#'
					   and pi.movimentacao = 1) as mm_de_movimentacao_km,
					   
				   (select sum(pi.mm_ult_inspecao - pi.mm_inspecao)
					  from oper.v$pneu_inspecao pi
					 where pi.data_inspecao between '#arguments.data_inicial#' and '#arguments.data_final#'
					   and pi.LAUDO_ANALISE_ID = 18) as mm_nada_anormal
			  from dual
  		</cfquery>
		<cfreturn qr_mms>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca MM inspecionados desgaste
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_mm_inspecionados_desgaste" returntype="query" access="remote">
		<cfargument name="data_inicial" required="yes">
		<cfargument name="data_final" required="yes">
		<cfargument name="por_usuario" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_mms" username="#session.usuario#" password="#session.senha#">
			select pla.descricao, sum(pi.mm_ult_inspecao - pi.mm_inspecao) as mm_totais, sum(pi.sulco_estimado - pi.mm_inspecao) as mm_excesso
			<cfif len(trim(arguments.por_usuario))>
			, pi.user_update as usuario
			</cfif>
			  from oper.v$pneu_inspecao pi
			 inner join oper.v$pneu_laudo_analise pla
					 on pla.laudo_id = pi.laudo_analise_id
			 where pi.data_inspecao between '#arguments.data_inicial#' and '#arguments.data_final#'
			   and pi.laudo_analise_id <> 18
			   and pi.sulco_estimado >= 0
			group by pla.descricao
			<cfif len(trim(arguments.por_usuario))>
			, pi.user_update
			</cfif>
			<cfif len(trim(arguments.por_usuario))>
			order by pi.user_update
			<cfelse>
			order by 2 desc
			</cfif>
  		</cfquery>
		<cfreturn qr_mms>
	</cffunction>	
					
	<!--- 
	-- PROPSITO 
	-- Busca MM inspecionados do usuario
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_mm_inspecionados_usuario" returntype="query" access="remote">
		<cfargument name="data_inicial" required="yes">
		<cfargument name="data_final" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_mms" username="#session.usuario#" password="#session.senha#">
			select pi.user_update as usuario, sum(pi.mm_ult_inspecao - pi.mm_inspecao) as mm
			  from oper.v$pneu_inspecao pi
			 where pi.data_inspecao between '#arguments.data_inicial#' and '#arguments.data_final#'
			group by pi.user_update
			order by 2 desc
  		</cfquery>
		<cfreturn qr_mms>
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca os Modelos de Pneus
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 18/01/2006
	--->
	<cffunction name="get_modelos" returntype="query" access="remote">
		<cfargument name="marca_id" required="no" default="">
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS */ ma.marca_id, ma.descricao as marca, 
             mo.modelo_id, mo.descricao as modelo,
			 ml.lona_id, ml.descricao as lona,
             me.medida_id, me.descricao as medida,
			 mf.formato_id, mf.descricao as formato,
		 	 mo.cod_indice_carga_simples, mo.cod_indice_carga_duplo,
			 mo.cod_indice_velocidade, mo.situacao_id, mo.sulco, mo.maximo_reformas, mo.maximo_consertos,
			 mo.maximo_furos, mo.pressao_ideal, mo.largura_manta, mo.possui_camara, mo.eixo_tracionado, mo.eixo_direcional,
			 mo.eixo_suspenso,  			 
             mr.medida_roda_id, mr.medida_roda,
			 ma.descricao || '-' || mo.descricao || '-' || me.descricao || '-' || mr.medida_roda as descricao_completa
			  from oper.v$pneu_modelo mo
			 inner join oper.v$pneu_marca ma
				on ma.marca_id = mo.marca_id	
			 inner join oper.v$pneu_medida me
			 	on me.medida_id = mo.medida_id	
			 left join oper.v$pneu_indice_carga mc
			 	on mc.cod_indice_carga = mo.cod_indice_carga_simples 
			 inner join oper.v$pneu_lona ml
			  	on ml.lona_id = mo.lona_id
			 inner join oper.v$pneu_formato_borracha mf
			 	on mf.formato_id = mo.formato_id
			 inner join oper.v$pneu_medida_roda mr
				on mr.medida_roda_id = mo.medida_roda_id
			 where 1=1
			   <cfif Len(Trim(arguments.marca_id))>
				   and ma.marca_id = #arguments.marca_id#
			   </cfif>
			   <cfif Len(Trim(arguments.modelo_id))>
				   and mo.modelo_id in (#arguments.modelo_id#)
			   </cfif>
			  <cfif len(trim(arguments.descricao))>
			   and upper(descricao) like upper('%#arguments.descricao#%')
			</cfif>
			
			order by ma.descricao, mo.descricao, me.descricao, mr.medida_roda 
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	
    
    <!--- 
	-- PROPSITO 
	-- Busca os Modelos de Pneus
	-- NOTAS EXPLICATIVAS
	-- LEOPOLDOS 06/07/2010
	--->
	<cffunction name="get_modelos_xml" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
		select dbms_xmlgen.getxml(' 
              select ma.marca_id, 
                     ma.descricao as marca, 
	                 mo.modelo_id, 
                     mo.descricao as modelo,
                     ml.lona_id, 
                     ml.descricao as lona,
                     me.medida_id, 
                     me.descricao as medida,
                     mf.formato_id, 
                     mf.descricao as formato,
                     mo.cod_indice_carga_simples, 
                     mo.cod_indice_carga_duplo,
                     mo.cod_indice_velocidade, 
                     mo.situacao_id, 
                     mo.sulco, 
                     mo.maximo_reformas, 
                     mo.maximo_consertos,
                     mo.maximo_furos, 
                     mo.pressao_ideal, 
                     mo.largura_manta, 
                     mo.possui_camara, 
                     mo.eixo_tracionado, 
                     mo.eixo_direcional,
                     mo.eixo_suspenso,      
                     mr.medida_roda_id, 
                     mr.medida_roda,
                     ma.descricao || ' || chr(39) || '-' || chr(39) || ' || mo.descricao || ' || chr(39) || '-' || chr(39) || ' ||  me.descricao || ' || chr(39) || '-' || chr(39) || ' ||  mr.medida_roda as descricao_completa
                from oper.v$pneu_modelo mo
               inner join oper.v$pneu_marca ma
                       on ma.marca_id = mo.marca_id 
               inner join oper.v$pneu_medida me
                       on me.medida_id = mo.medida_id 
                left join oper.v$pneu_indice_carga mc
                       on mc.cod_indice_carga = mo.cod_indice_carga_simples 
               inner join oper.v$pneu_lona ml
                       on ml.lona_id = mo.lona_id
               inner join oper.v$pneu_formato_borracha mf
                       on mf.formato_id = mo.formato_id
               inner join oper.v$pneu_medida_roda mr
                       on mr.medida_roda_id = mo.medida_roda_id
               where 1=1
               order by ma.descricao, mo.descricao, me.descricao, mr.medida_roda') as resultado
                 from dual
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	


	<!--- 
	-- PROPSITO 
	-- Busca as ocorrencias do pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 07/02/2006
	--->
	<cffunction name="get_ocorrencias" returntype="query" access="remote">
		<cfargument name="num_pneu" required="no">
		<cfargument name="pneu_id" required="no">
		<cfargument name="data_inicial" required="no">
		<cfargument name="data_final" required="no">
		<cfargument name="operacao" required="no" default="">
		<cfargument name="usuario" required="no" default="">
		<cfargument name="num_ocorrencia" required="no" default="">		
		<cfquery datasource="#session.dsn#" name="qr_ocorrencias" username="#session.usuario#" password="#session.senha#">
			select /*+ first_rows_1000 */ pd.pneu_id
                 , pd.num_pneu
                 , pd.situacao_id
                 , pd.data_aquisicao
                 , pd.marca_id
                 , pd.marca 
				 , pd.modelo_id
                 , pd.modelo
                 , pd.sulco
                 , pd.medida_id
                 , pd.medida
                 , pd.medida_roda_id
                 , pd.medida_roda 
				 , pd.reformas
                 , pd.situacao
                 , pd.formato_borracha
                 , p.operacao
                 , p.usuario
                 , to_char(p.data_ocorrencia,'dd/mm/yyyy hh24:mi') as data_ocorrencia
			  from oper.v$pneu_dados pd
			 inner join oper.v$pneu_ocorrencia p
					 on p.pneu_id = pd.pneu_id
			 where 1 = 1 
			 <cfif IsDefined("arguments.num_pneu") and Len(Trim(arguments.num_pneu)) and arguments.num_pneu neq -1> 
			  and pd.num_pneu = #arguments.num_pneu#
			 </cfif>
			 <cfif IsDefined("arguments.pneu_id") and Len(Trim(arguments.pneu_id)) and arguments.pneu_id neq -1> 
			  and pd.pneu_id = #arguments.pneu_id#
			 </cfif>
			 <cfif IsDefined("arguments.data_inicial") and Len(Trim(arguments.data_inicial)) and IsDefined("arguments.data_final") and Len(Trim(arguments.data_final))>
			  and trunc(p.data_ocorrencia) between '#arguments.data_inicial#' and '#arguments.data_final#'
			 <cfelseif IsDefined("arguments.data_inicial") and Len(Trim(arguments.data_inicial))>
			  and trunc(p.data_ocorrencia) >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.operacao))>			 	
			  and ( 1=0 
				  <cfloop list="#arguments.operacao#" index="v_item" delimiters=",">
				  or upper(p.operacao) like upper('%#v_item#%')
				  </cfloop>
				  )
			 </cfif>
			 <cfif len(trim(arguments.num_ocorrencia))>			 	
			  and p.num_ocorrencia in (#arguments.num_ocorrencia#)
			 </cfif>
			 <cfif len(trim(arguments.usuario))>
			 	and p.usuario in (''
				<cfloop list="#arguments.usuario#" delimiters="," index="v_item">
					, '#v_item#'
				</cfloop>
				)
			 </cfif>
			 order by p.pneu_id, p.data_ocorrencia, p.ocorrencia_id
		</cfquery>
		<cfreturn qr_ocorrencias>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as ocorrencias de pneus no veiculo 
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_ocorrencias_veiculo" returntype="query" access="remote">
		<cfargument name="cod_veiculo" required="yes">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="data_inicial_desmontagem" required="no" default="">
		<cfargument name="data_final_desmontagem" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_mms" username="#session.usuario#" password="#session.senha#">
			select case when pm.data_desmontagem is null then 1 else 0 end as montado,
				   p.num_pneu,
				   pm.pmov_id,
				   pm.num_eixo,
				   pm.posicao,
				   pg.COD_POSICAO,
				   oper.pkg_veiculo.fnc_get_cod_veiculo(pm.placa) placa,
				   pm.pneu_id,
				   pm.data_montagem,
				   pm.mm_montagem,
				   pm.km_montagem,
				   pm.data_desmontagem,
				   pm.mm_desmontagem,
				   pm.km_desmontagem,
				   pm.laudo_desmontagem_id,
				   pl.descricao as laudo,
				   pm.medida_1,
				   pm.medida_2,
				   pm.medida_3,
				   pm.user_insert as inserido_por,
				   pm.user_update as alterado_por
			  from oper.v$pneu_movimentacao pm
			 inner join oper.v$pneu_dados p
					 on p.pneu_id = pm.pneu_id
			 inner join oper.v$pneu_gabarito_posicao pg
					 on pm.NUM_GABARITO = pg.NUM_GABARITO
					and pm.NUM_EIXO = pg.NUM_EIXO
					and pm.POSICAO = pg.POSICAO
			  left join oper.v$pneu_laudo_desmontagem pl
					 on pl.LAUDO_ID = pm.LAUDO_DESMONTAGEM_ID
			 inner join oper.v$pneu_posicao pp
					 on pg.cod_posicao = pp.COD_POSICAO
			 where placa = oper.pkg_veiculo.fnc_get_placa('#arguments.cod_veiculo#')
			 <cfif len(trim(arguments.data_inicial))>
			 	and trunc(data_montagem) >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			 	and trunc(data_montagem) <= '#arguments.data_final#'
			 </cfif>
			 <cfif len(trim(arguments.data_inicial_desmontagem))>
			 	and trunc(data_desmontagem) >= '#arguments.data_inicial_desmontagem#'
			 </cfif>
			 <cfif len(trim(arguments.data_final_desmontagem))>
			 	and trunc(data_desmontagem) <= '#arguments.data_final_desmontagem#'
			 </cfif>
			 order by 1 desc , pm.num_eixo, pp.ordem
  		</cfquery>
		<cfreturn qr_mms>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as Borrachas para o painel
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_painel_borrachas" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qrBorrachas" username="#session.usuario#" password="#session.senha#">
			select borracha, sum(quantidade) as quantidade
			from (select case
							  when quantidade/total < 0.05 then 'Outras'
							  else borracha end borracha, quantidade
					from (select pb.descricao as borracha, count(*) as quantidade,
								 (select count(*)
										  from oper.v$pneu_dados p
										 inner join oper.v$pneu_reforma pr
												on pr.pneu_id = p.pneu_id
											   and pr.conserto = 0
										inner join oper.v$pneu_borracha pb
												on pb.borracha_id = pr.borracha_id
										inner join oper.v$pneu_desenho pd
												on pd.borracha_id = pr.borracha_id
											   and pd.desenho_id = pr.desenho_id
									   where pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
																		from oper.v$pneu_reforma pr2
																	   where pr2.pneu_id = pr.pneu_id
																		 and pr2.conserto = 0)) as total
								  from oper.v$pneu_dados p
								 inner join oper.v$pneu_reforma pr
										on pr.pneu_id = p.pneu_id
									   and pr.conserto = 0
								inner join oper.v$pneu_borracha pb
										on pb.borracha_id = pr.borracha_id
								inner join oper.v$pneu_desenho pd
										on pd.borracha_id = pr.borracha_id
									   and pd.desenho_id = pr.desenho_id
								where p.situacao_id in (1,2,3,4,5,6,8,9,10)	   
								   and pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
																	from oper.v$pneu_reforma pr2
																   where pr2.pneu_id = pr.pneu_id
																	 and pr2.conserto = 0)
							group by pb.descricao))
			group by borracha
			order by 2 desc
		</cfquery>
		<cfreturn qrBorrachas>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as Desenhos para o painel
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_painel_desenhos" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qrDesenhos" username="#session.usuario#" password="#session.senha#">
			select borracha || '/' || desenho as borracha_desenho, sum(quantidade) as quantidade
			from (select case
							  when quantidade/total < 0.05 then 'Outras'
							  else borracha end borracha,
						 case
							  when quantidade/total < 0.05 then 'Outras'
							  else desenho end desenho,
						 quantidade
					from (select pb.descricao as borracha, pd.descricao as desenho, count(*) as quantidade,
								 (select count(*)
										  from oper.v$pneu_dados p
										 inner join oper.v$pneu_reforma pr
												on pr.pneu_id = p.pneu_id
											   and pr.conserto = 0
										inner join oper.v$pneu_borracha pb
												on pb.borracha_id = pr.borracha_id
										inner join oper.v$pneu_desenho pd
												on pd.borracha_id = pr.borracha_id
											   and pd.desenho_id = pr.desenho_id
									  where pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
																		from oper.v$pneu_reforma pr2
																	   where pr2.pneu_id = pr.pneu_id
																		 and pr2.conserto = 0)) as total
								  from oper.v$pneu_dados p
								 inner join oper.v$pneu_reforma pr
										on pr.pneu_id = p.pneu_id
									   and pr.conserto = 0
								inner join oper.v$pneu_borracha pb
										on pb.borracha_id = pr.borracha_id
								inner join oper.v$pneu_desenho pd
										on pd.borracha_id = pr.borracha_id
									   and pd.desenho_id = pr.desenho_id
								where p.situacao_id in (1,2,3,4,5,6,8,9,10)
								  and pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
																	from oper.v$pneu_reforma pr2
																   where pr2.pneu_id = pr.pneu_id
																	 and pr2.conserto = 0)
								
							group by pb.descricao, pd.descricao))
			group by borracha, desenho
			order by 2 desc
		</cfquery>
		<cfreturn qrDesenhos>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as Formata Borracha para o painel
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_painel_formato_borracha" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qrFormatoBorracha" username="#session.usuario#" password="#session.senha#">
			select sum(quantidade) as quantidade, formato_borracha
			from (select
				formato_borracha,
						quantidade, total
					from (select formato_borracha, count(*) as quantidade,
									(select count(*)
									   from oper.v$pneu_dados) as total
								  from oper.v$pneu_dados p
								  where p.situacao_id in (1,2,3,4,5,6,8,9,10)
							group by formato_borracha))
			group by formato_borracha
			order by 1 desc
		</cfquery>
		<cfreturn qrFormatoBorracha>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as Marcas para o painel
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_painel_marcas" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qrMarcas" username="#session.usuario#" password="#session.senha#">
			select sum(quantidade) as quantidade, marca
			  from (select
						  case
							 when (quantidade/total) < 0.05 then 'Outros'
						  else marca end marca,
						  quantidade, total
					 from (select marca, count(*) as quantidade,
								 (select count(*)
									from oper.v$pneu_dados) as total
							 from oper.v$pneu_dados p
							where p.situacao_id in (1,2,3,4,5,6,8,9,10)
							group by marca))
			group by marca
  		</cfquery>
		<cfreturn qrMarcas>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as Medidas da roda para o painel
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_painel_medida_roda" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qrMedidaRoda" username="#session.usuario#" password="#session.senha#">
			select sum(quantidade) as quantidade, 'Med.: ' || medida_roda as medida_roda
			from (select
						case
						   when (quantidade/total) < 0.03 then 'Outros'
						else medida_roda end medida_roda,
						quantidade, total
					from (select medida_roda, count(*) as quantidade,
									(select count(*)
									   from oper.v$pneu_dados) as total
								  from oper.v$pneu_dados p
								  where p.situacao_id in (1,2,3,4,5,6,8,9,10)
							group by medida_roda))
			group by medida_roda
			order by 1 desc
		</cfquery>
		<cfreturn qrMedidaRoda>
	</cffunction>
	

	<!--- 
	-- PROPSITO 
	-- Busca as Medidas para o painel
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_painel_medidas" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qrMedidas" username="#session.usuario#" password="#session.senha#">
			select sum(quantidade) as quantidade, medida
			from (select
						case
						   when (quantidade/total) < 0.01 then 'Outros'
						else medida end medida,
						quantidade, total
					from (select medida, count(*) as quantidade,
									(select count(*)
									   from oper.v$pneu_dados) as total
								  from oper.v$pneu_dados p
								  where p.situacao_id in (1,2,3,4,5,6,8,9,10)
							group by medida))
			group by medida
		</cfquery>
		<cfreturn qrMedidas>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as Modelos para o painel
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_painel_modelos" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qrModelos" username="#session.usuario#" password="#session.senha#">
			select sum(quantidade) as quantidade, modelo as marca_modelo
			from (select
						case
						   when (quantidade/total) < 0.03 then 'Outros'
						else modelo end modelo,
						case
						   when (quantidade/total) < 0.03 then 'Outros'
						else marca end marca,
						quantidade, total
					from (select marca, modelo, count(*) as quantidade,
									(select count(*)
									   from oper.v$pneu_dados) as total
								  from oper.v$pneu_dados p
								 where p.situacao_id in (1,2,3,4,5,6,8,9,10) 
							group by marca, modelo))
			group by marca, modelo
			order by 1 desc
		</cfquery>
		<cfreturn qrModelos>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as Reformadores para o painel
	-- NOTAS EXPLICATIVAS
	-- ANDERSONC 17/04/2009
	--->
	<cffunction name="get_painel_reformadores" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qrReformadores" username="#session.usuario#" password="#session.senha#">
			select cod_pessoa_reformador, nvl(cliente,'Outros') as reformador, sum(quantidade) as quantidade
			from (select case
							  when quantidade/total < 0.05 then 0
							  else cod_pessoa_reformador end cod_pessoa_reformador, quantidade
					from (select prb.cod_pessoa as cod_pessoa_reformador, count(*) as quantidade,
								 (select count(*)
										  from oper.v$pneu_dados p
										 inner join oper.v$pneu_reforma pr
												on pr.pneu_id = p.pneu_id
											   and pr.conserto = 0
										inner join oper.v$pneu_borracha pb
												on pb.borracha_id = pr.borracha_id
										inner join oper.v$pneu_desenho pd
												on pd.borracha_id = pr.borracha_id
											   and pd.desenho_id = pr.desenho_id
										  where pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
																			from oper.v$pneu_reforma pr2
																		   where pr2.pneu_id = pr.pneu_id
																			 and pr2.conserto = 0)) as total
								  from oper.v$pneu_dados p
								 inner join oper.v$pneu_reforma pr
										on pr.pneu_id = p.pneu_id
									   and pr.conserto = 0
								inner join oper.v$pneu_borracha pb
										on pb.borracha_id = pr.borracha_id
								inner join oper.v$pneu_desenho pd
										on pd.borracha_id = pr.borracha_id
									   and pd.desenho_id = pr.desenho_id
								 left join oper.v$pneu_reformador_bandeira prb
                                        on prb.reformador_id = pr.reformador_id
								where p.situacao_id in (1,2,3,4,5,6,8,9,10)
								   and pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
																	from oper.v$pneu_reforma pr2
																   where pr2.pneu_id = pr.pneu_id
																	 and pr2.conserto = 0)
							group by prb.cod_pessoa))
			left join kss.v$pessoa pj
					on pj.cod_pessoa = cod_pessoa_reformador
			group by cod_pessoa_reformador, cliente
		</cfquery>
		<cfreturn qrReformadores>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os dados para o Painel de Sucateamento
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 10/02/2006
	--->
	<cffunction name="get_painel_sucateamento" returntype="query" access="remote">
		<cfargument name="laudo_id" required="no" default="">
		<cfargument name="relatorio_por" required="yes">
		<cfargument name="reformados" required="no">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfquery name="qr_sucatas" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select #relatorio_por# as label,
				   round(avg(decode(oper.pkg_pneu.fnc_sulco_atual_estimado(ps.pneu_id),-1,0,oper.pkg_pneu.fnc_sulco_atual_estimado(ps.pneu_id))),2) as media_mm_perdido,
				   sum(decode(oper.pkg_pneu.fnc_sulco_atual_estimado(ps.pneu_id),-1,0,oper.pkg_pneu.fnc_sulco_atual_estimado(ps.pneu_id))) as mm_perdido,
				   count(*) as num_pneus
		      from oper.v$pneu_sucateamento ps
			 inner join oper.v$pneu_dados pd
					 on pd.pneu_id = ps.pneu_id
			 <cfif IsDefined("arguments.reformados") and Len(Trim(arguments.reformados))>
				 inner join oper.v$pneu_reforma pr
						 on pr.pneu_id = ps.pneu_id
						and pr.conserto = 0
                 inner join oper.v$pneu_reformador_bandeira prb
                         on prb.reformador_id = pr.reformador_id
				 inner join kss.v$pessoa pj
				         on pj.cod_pessoa = prb.cod_pessoa
				 inner join oper.v$pneu_borracha b
						 on b.borracha_id = pr.borracha_id			 
			  </cfif>
			  where 1=1
                and ps.situacao_id = 1
			  <cfif IsDefined("arguments.reformados") and Len(Trim(arguments.reformados))>
				and pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
												 from oper.v$pneu_reforma pr2
												where pr2.pneu_id = pr.pneu_id
												  and pr2.conserto = 0)
			  </cfif>
			  <cfif IsDefined("arguments.DATA_INICIO") and Len(Trim(arguments.DATA_INICIO)) AND IsDefined("arguments.DATA_FIM") and Len(Trim(arguments.DATA_FIM))>
					and ps.data_sucateamento between '#arguments.DATA_INICIO#' and '#arguments.DATA_FIM#'
			  </cfif>			  
			  <cfif IsDefined("arguments.laudo_id") and Len(Trim(arguments.laudo_id))>
				 and laudo_id  in (#ListQualify(arguments.laudo_id,"'",",")#) 
			 </cfif>
			group by #relatorio_por#
			order by 2 desc
		</cfquery>
		<cfreturn qr_sucatas>
	</cffunction>	
				
	<!--- 
	-- PROPSITO 
	-- Busca os parametros
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 20/01/2006
	--->
	<cffunction name="get_parametros" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qrParametros" username="#session.usuario#" password="#session.senha#">
			select to_number(kss.pkg_global.fnc_obtem_parametro_str(11, 'OPERACIONAL', 18, 1)) as tolerancia_inspecao,
				   to_number(kss.pkg_global.fnc_obtem_parametro_str(11, 'OPERACIONAL', 18, 2)) as mm_minimo_reforma, 
				   to_number(kss.pkg_global.fnc_obtem_parametro_str(11, 'OPERACIONAL', 18, 3)) as mm_liberacao_primeiro_eixo
			  from dual
 		</cfquery>		
		<cfset session.tolerancia_inspecao = qrParametros.tolerancia_inspecao>
		<cfset session.mm_minimo_reforma = qrParametros.mm_minimo_reforma>
		<cfset session.mm_liberacao_primeiro_eixo = qrParametros.mm_liberacao_primeiro_eixo>
		<cfreturn qrParametros>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os pares para o pneu no estoque
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_parceiros_disponiveis_estoque" returntype="query" access="remote">
		<cfargument name="num_pneu" required="no">
		<cfquery name="qr_dados_pneu"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.pneu_id, pm.num_gabarito, pm.num_eixo, p.medida_roda_id, p.medida_id, p.marca_id, p.modelo_id, p.reformas, pr.borracha_id, pr.desenho_id, 
				   oper.pkg_pneu.fnc_sulco_atual_estimado(p.pneu_id) as sulco
			  from oper.v$pneu_dados p
			 inner join oper.v$pneu_movimentacao pm
					 on pm.pneu_id = p.pneu_id
			 left join oper.v$pneu_reforma pr
					on pr.pneu_id = p.pneu_id
			 where p.num_pneu = #arguments.num_pneu#
			   and p.situacao_id in (1,3,4,5,6,8,9,10)
			   and (pr.data_retorno_reforma = (select max(pr.data_retorno_reforma)
												from oper.v$pneu_reforma pr2
											   where pr2.pneu_id = pr.pneu_id)
					or pr.data_retorno_reforma is null)
   		</cfquery>		
		<cfif qr_dados_pneu.recordCount eq 0>
		 	<cfthrow detail="Pneu no encontrado ou sucateado." errorcode="1" />
		</cfif>
		<cfquery name="qr_conf_eixo"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select reformas, integridade_marca, integridade_modelo, integridade_status,
				   integridade_borracha, integridade_desenho, pem.direcional, pem.tracionado,
        	       pem.suspenso, t.prefixo
			  from oper.v$pneu_gabarito_setup t
		     inner join oper.v$pneu_eixo_modelo pem
                on pem.modelo_eixo_id = t.modelo_eixo_id
			 where t.num_gabarito = #qr_dados_pneu.num_gabarito#
			   and t.num_eixo = #qr_dados_pneu.num_eixo# 
   		</cfquery>	
		<cfif qr_dados_pneu.RecordCount eq 0 or qr_conf_eixo.RecordCount eq 0>
			<cfquery name="qr_pneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select pneu_id, num_pneu, situacao_id as situacao, marca_id, marca, modelo_id, modelo,
					   borracha_id, desenho_id, desenho, borracha, oper.pkg_pneu.fnc_sulco_atual(pneu_id) as sulco, 
					   medida_id, medida, reformas, medida_roda_id, medida_roda, 
					   status, substr(formato_borracha,1,1) as formato
				  from (
							select /*+ RULE */ p.pneu_id, p.num_pneu, p.situacao_id, p.marca_id, ma.descricao as marca, 
							 p.modelo_id, pm.descricao as modelo,
								   null borracha_id, null desenho_id, null as desenho, 
							 null as borracha, 
							 p.medida_roda_id, mr.medida_roda, 
								   oper.pkg_pneu.fnc_sulco_atual(p.pneu_id) as sulco,
								   p.medida_id, me.descricao as medida,
								   p.reformas, 'Novos' as status, pfb.descricao as formato_borracha
							  from oper.v$pneu p
						inner join oper.v$pneu_localizacao pl
								on pl.pneu_id = p.pneu_id
							   and pl.data_saida is null
						inner join oper.v$pneu_marca ma
								on ma.marca_id = p.marca_id
						inner join oper.v$pneu_modelo pm
								on pm.marca_id = p.marca_id
							   and pm.modelo_id = p.modelo_id
							   and pm.medida_id = p.medida_id
							   and pm.medida_roda_id = p.medida_roda_id
							<cfif qr_conf_eixo.RecordCount and qr_conf_eixo.direcional eq 1>
							   and pm.eixo_direcional = 1
							</cfif>
							<cfif qr_conf_eixo.RecordCount and qr_conf_eixo.tracionado eq 1>
							   and pm.eixo_tracionado = 1
							</cfif>
							<cfif qr_conf_eixo.RecordCount and qr_conf_eixo.suspenso eq 1>
							   and pm.eixo_suspenso = 1
							</cfif>
						inner join oper.v$pneu_medida me
								on me.medida_id = p.medida_id
						inner join oper.v$pneu_medida_roda mr
								on mr.medida_roda_id = p.medida_roda_id
						inner join oper.v$pneu_formato_borracha pfb
								on pfb.formato_id = pm.formato_id
							 where p.situacao_id = 1
						 and p.reformas = 0
						 and pl.cod_pessoa = #session.cod_pessoa#
				union
							select /*+ RULE */ p.pneu_id, p.num_pneu, p.situacao_id, p.marca_id, ma.descricao as marca, 
								   p.modelo_id, pm.descricao as modelo,
								   pr.borracha_id, pr.desenho_id, 
								   pd.descricao as desenho, 
								   pb.descricao as borracha, 
								   p.medida_roda_id, mr.medida_roda, 
								   oper.pkg_pneu.fnc_sulco_atual(p.pneu_id) as sulco,
								   p.medida_id, me.descricao as medida,
								   p.reformas, 'Recapados' as status, pfb.descricao as formato_borracha
							  from oper.v$pneu p
						inner join oper.v$pneu_localizacao pl
								on pl.pneu_id = p.pneu_id
							   and pl.data_saida is null
						inner join oper.v$pneu_marca ma
								on ma.marca_id = p.marca_id
						inner join oper.v$pneu_modelo pm
								on pm.marca_id = p.marca_id
							   and pm.modelo_id = p.modelo_id
							   and pm.medida_id = p.medida_id
							   and pm.medida_roda_id = p.medida_roda_id
						inner join oper.v$pneu_medida me
								on me.medida_id = p.medida_id
						inner join oper.v$pneu_medida_roda mr
								on mr.medida_roda_id = p.medida_roda_id
						  inner join oper.v$pneu_reforma pr
									on pr.pneu_id = p.pneu_id
						inner join oper.v$pneu_borracha pb
								on pb.borracha_id = pr.borracha_id
						inner join oper.v$pneu_desenho pd
								on pd.borracha_id = pr.borracha_id
							   and pd.desenho_id = pr.desenho_id
							<cfif qr_conf_eixo.RecordCount and qr_conf_eixo.direcional eq 1>
							   and pd.eixo_direcional = 1
							</cfif>
							<cfif qr_conf_eixo.RecordCount and qr_conf_eixo.tracionado eq 1>
							   and pd.eixo_tracionado = 1
							</cfif>
							<cfif qr_conf_eixo.RecordCount and qr_conf_eixo.suspenso eq 1>
							   and pd.eixo_suspenso = 1
							</cfif>
						inner join oper.v$pneu_formato_borracha pfb
								on pfb.formato_id = pd.formato_id
							 where p.situacao_id = 1
							   and p.reformas > 0
							   and pl.cod_pessoa = #session.cod_pessoa#) p
				 where 1 = 1
					and (pr.data_retorno_reforma = (select max(r2.data_retorno_reforma)
																		 from oper.v$pneu_reforma r2
																		where r2.pneu_id = pr.pneu_id
																		  and r2.data_retorno_reforma is not null
																		  and r2.conserto = 0)
						 or pr.data_retorno_reforma is null)
					 <cfif Len(Trim(qr_dados_pneu.sulco)) and qr_dados_pneu.num_eixo neq 0>
					   and #qr_dados_pneu.sulco#  between sulco - to_number(oper.pkg_global.FNC_GET_PARAMETRO(9,'PNEU')) and sulco + to_number(oper.pkg_global.FNC_GET_PARAMETRO(9,'PNEU'))
					 </cfif>
					 
					 <cfif Len(Trim(qr_dados_pneu.medida_roda_id)) and qr_dados_pneu.num_eixo neq 0>
					   and p.medida_roda_id = #qr_dados_pneu.medida_roda_id#			 
					 </cfif>

					 <cfif Len(Trim(qr_dados_pneu.medida_id)) and qr_dados_pneu.num_eixo neq 0>
					   and p.medida_id = #qr_dados_pneu.medida_id#			 
					 </cfif>
								 
					 <cfif qr_conf_eixo.reformas gte 0 and qr_dados_pneu.num_eixo neq 0 <!--- numero maximo de REFORMAS ---> >
					   and p.reformas <= #qr_conf_eixo.reformas#			 
					 </cfif>
		
					 <cfif qr_conf_eixo.integridade_status eq 1 and Len(Trim(qr_dados_pneu.reformas)) and qr_dados_pneu.num_eixo neq 0<!--- integridade de STATUS ---> >
					   and p.reformas = #qr_dados_pneu.reformas#
					 </cfif>
		
					 <cfif qr_conf_eixo.integridade_marca eq 1 and Len(Trim(qr_dados_pneu.marca_id)) and qr_dados_pneu.num_eixo neq 0<!--- integridade de MARCA --->>
					   and p.marca_id = #qr_dados_pneu.marca_id#			 
					 </cfif>
		
					 <cfif qr_conf_eixo.integridade_modelo eq 1 and Len(Trim(qr_dados_pneu.modelo_id)) and qr_dados_pneu.num_eixo neq 0<!--- integridade de MODELO --->>
					   and p.modelo_id = #qr_dados_pneu.modelo_id#			 
					 </cfif>
		
					 <cfif qr_dados_pneu.reformas gt 0 and qr_conf_eixo.integridade_borracha eq 1 and Len(Trim(qr_dados_pneu.borracha_id)) and qr_dados_pneu.num_eixo neq 0<!--- integridade de BORRACHA --->>
					   and p.borracha_id = #qr_dados_pneu.borracha_id#
					 </cfif>
		
					 <cfif qr_dados_pneu.reformas gt 0 and qr_conf_eixo.integridade_desenho eq 1 and Len(Trim(qr_dados_pneu.desenho_id)) and qr_dados_pneu.num_eixo neq 0<!--- integridade de DESENHO --->>
					   and p.desenho_id = #qr_dados_pneu.desenho_id#
					 </cfif>
				 <cfif qr_conf_eixo.PREFIXO eq '1' and Len(Trim(qr_dados_pneu.sulco))>
					 or sulco < #session.mm_liberacao_primeiro_eixo# 
				 </cfif>
				 order by p.reformas, p.num_pneu, p.marca, p.modelo, 12 desc, p.borracha, p.desenho 
			</cfquery>						
			<cfreturn qr_pneus>
		<cfelse>
		 	<cfthrow detail="Dados do pneu ou veculo no encontrados" errorcode="1" />
		</cfif>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os pares perfeitos para o pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_parceiros_par_perfeito" returntype="query" access="remote">
		<cfargument name="num_pneu" required="no">
		<cfquery name="qr_dados_pneu"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.medida_roda_id, p.marca_id, p.medida_id, p.medida_roda_id, p.modelo_id, p.reformas, pr.borracha_id, pr.desenho_id, 
				   oper.pkg_pneu.fnc_sulco_atual(p.pneu_id) as sulco
			  from oper.v$pneu_dados p
			  left join oper.v$pneu_reforma pr
					 on pr.pneu_id = p.pneu_id
					and pr.conserto = 0
			 where p.num_pneu = #arguments.num_pneu#
			   and p.situacao_id in (1,3,4,5,6,8,9,10)
			   and (pr.data_retorno_reforma = (select max(pr.data_retorno_reforma) 
												 from oper.v$pneu_reforma pr2
											    where pr2.pneu_id = pr.pneu_id
											  	  and pr2.conserto = 0)
				or pr.data_retorno_reforma is null)
   		</cfquery>		
		<cfif qr_dados_pneu.recordCount eq 0>
		 	<cfthrow detail="Pneu no encontrado ou sucateado." errorcode="1" />
		</cfif>
		<cfquery name="qr_pneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pd.pneu_id, pd.num_pneu, pd.marca, pd.modelo, pd.medida, pd.medida_roda, pd.reformas, 
				   oper.pkg_pneu.fnc_sulco_atual(pd.pneu_id) as sulco, pb.descricao as borracha,
				   d.descricao as desenho
			  from oper.v$pneu_dados pd
			 inner join oper.v$pneu_localizacao_atual pla
					 on pla.pneu_id = pd.pneu_id
			  left join oper.v$pneu_reforma pr
					 on pr.pneu_id = pd.pneu_id
					and pr.conserto = 0
			  left join oper.v$pneu_borracha pb
					 on pb.borracha_id = pr.borracha_id
			  left join oper.v$pneu_desenho d
					 on d.borracha_id = pr.borracha_id
					and d.desenho_id = pr.desenho_id
			<cfif qr_dados_pneu.recordcount gt 0>
			 where pd.num_pneu <> #arguments.num_pneu#
			   and pla.cod_pessoa = #session.cod_pessoa#
			   and #qr_dados_pneu.SULCO# between oper.pkg_pneu.fnc_sulco_atual(pd.pneu_id)-to_number(kss.pkg_global.fnc_obtem_parametro_str(11, 'OPERACIONAL', 18, 9)) and oper.pkg_pneu.fnc_sulco_atual(pd.pneu_id)+to_number(kss.pkg_global.fnc_obtem_parametro_str(11, 'OPERACIONAL', 18, 9))
			   and pd.reformas = #qr_dados_pneu.REFORMAS#
			   and pd.marca_id = #qr_dados_pneu.MARCA_ID#
			   and pd.modelo_id = #qr_dados_pneu.MODELO_ID#
			   and pd.medida_id = #qr_dados_pneu.MEDIDA_ID#
			   and pd.medida_roda_id = #qr_dados_pneu.MEDIDA_RODA_ID#
			   and (pr.data_retorno_reforma = (select max(pr.data_retorno_reforma) 
												from oper.v$pneu_reforma pr2
											   where pr2.pneu_id = pr.pneu_id
												 and pr2.conserto = 0)
	            or pr.data_retorno_reforma is null)
			   <cfif qr_dados_pneu.REFORMAS GT 0>
				   and pr.borracha_id = #qr_dados_pneu.BORRACHA_ID#
				   and pr.desenho_id = #qr_dados_pneu.DESENHO_ID#
			   </cfif>
			 order by pd.reformas, pd.num_pneu, pd.marca, pd.modelo, 7 desc <cfif qr_dados_pneu.REFORMAS GT 0>, pb.descricao, d.descricao </cfif> 
			<cfelse>
				where 1=0
			</cfif>
   		</cfquery>						
		<cfreturn qr_pneus>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os dados de analise do pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 01/02/2006
	--->
	<cffunction name="get_pneu_analise" returntype="query" access="remote">
		<cfargument name="pneu_id" required="no">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pd.num_pneu, pf.cliente as nome, ps.psu_id, ps.pneu_id, ps.cod_pessoa_sucateador,
				   ps.data_sucateamento, ps.situacao_id, ps.laudo_id, ps.cod_pessoa_tecnico_analise,
				   ps.data_analise, ps.valor_venda, oper.pkg_pneu.fnc_valor_pneu(#arguments.pneu_id#) as valor_venda_estimado,
				   ps.cod_pessoa_mot_resp, ps.observacao
  			  from oper.v$pneu_dados pd
			 inner join oper.v$pneu_sucateamento ps 
					 on ps.pneu_id = pd.pneu_id
			 inner join kss.v$pessoa pf 
					 on pf.cod_pessoa = ps.cod_pessoa_sucateador
			 where pd.pneu_id = #arguments.pneu_id#
   		</cfquery>		
		<cfreturn qrPneus>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os custos de um pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 07/02/2006
	--->
	<cffunction name="get_pneu_custo" returntype="query" access="remote">
	    <cfargument name="num_pneu" required="yes">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.custo as custo_novo, p.sulco as sulco_novo, 
				   pr.custo as custo_reforma, pd.sulco as sulco_reforma, nvl(pc.valor,0) as custo_carcaca,
				   case 
					  when p.reformas = 0 then ROUND((p.custo - nvl(pc.valor,0)) / (p.sulco-2),2)
					  else ROUND((pr.custo + nvl(pc.valor,0)) / (pd.sulco-2),2) end custo_mm,
					oper.pkg_pneu.fnc_valor_pneu(p.pneu_id) as valor_pneu  
			  from oper.v$pneu_dados p
			 left join oper.v$pneu_carcaca pc
					on pc.marca_id = p.marca_id
				   and pc.medida_id = p.medida_id
				   and pc.data_fim is null
			 left join oper.v$pneu_reforma pr
					on pr.pneu_id = p.pneu_id
				   and pr.conserto = 0  
			 left join oper.v$pneu_desenho pd
					on pd.borracha_id = pr.borracha_id
				   and pd.desenho_id = pr.desenho_id
				 where 1=1
				   and (pr.data_envio_reforma = (select max(pr2.data_envio_reforma)
												  from oper.v$pneu_reforma pr2
												 where pr2.pneu_id = pr.pneu_id)
												 or(select max(pr2.data_envio_reforma)
												  from oper.v$pneu_reforma pr2
												 where pr2.pneu_id = pr.pneu_id) is null)
			 <cfif IsDefined("arguments.num_pneu") and Len(Trim(arguments.num_pneu))>
			   and p.num_pneu = #arguments.num_pneu#
			 </cfif>
		</cfquery>		
		<cfreturn qrPneus>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca o rendimento dos pneus
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_pneu_custo_km" returntype="query" access="remote">
		<cfargument name="tipo_veiculo_id" required="no">
		<cfargument name="marca_id" required="no">
		<cfargument name="modelo_id" required="no">
		<cfargument name="borracha_id" required="no">
		<cfargument name="desenho_id" required="no">
		<cfargument name="eixo" required="no">
		<cfargument name="lado" required="no">
		<cfargument name="faixa_peso_inicio" required="no">
		<cfargument name="faixa_peso_final" required="no">
		<cfargument name="inspecoes_desde" required="no" default="">
		<cfargument name="inspecoes_ate" required="no" default="">
		<cfargument name="grupo" required="no">
		<cfargument name="considerar" required="no" default="">
		<cfargument name="data_aquisicao" required="no" default="">
		<cfargument name="data_aquisicao_final" required="no" default="">
		<cfargument name="tipo_eixo" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_desenhos" username="#session.usuario#" password="#session.senha#">
			select r.pneu_id,
				   r.num_pneu,
				   r.marca,
				   r.marca_id,
				   r.modelo,
				   r.modelo_id,
				   r.borracha,
				   r.borracha_id,
				   r.desenho_id,
				   r.desenho,
--				   r.placa,
				   r.sulco_manta,
				   r.data_aquisicao,
				   decode(r.reformas, 0, 'Novo', 'Reforma ' || r.reformas) as reformas,
				   sum(r.mm_consumido) as mm_consumido,
				   sum(r.km_percorrido) as km_percorrido,
				   decode(r.reformas, 0, r.marca, r.borracha) as marca_borracha,
				   decode(r.reformas, 0, r.modelo || ' - ' || r.medida, r.desenho) as modelo_desenho,
				   round(avg(r.peso_tracionado) / 1000) as peso_tracionado,
				   decode(sum(r.mm_consumido),
						  0,
						  sum(r.km_percorrido),
						  round(sum(r.km_percorrido) / sum(r.mm_consumido))) as rendimento,
				   round((r.sulco_manta - 2) *
						 decode(sum(r.mm_consumido),
								0,
								sum(r.km_percorrido),
								round(sum(r.km_percorrido) / sum(r.mm_consumido)))) as projetado,
				   r.situacao,
				   round(((sum(r.mm_consumido)) / (r.sulco_manta - 2)) * 100) as perc_consumido,
				   r.sulco_manta,
				   case
					 when exists (select 'x'
							 from oper.v$pneu_movimentacao pm
							where /*pm.placa = r.placa
							  and */pm.PNEU_ID = r.pneu_id
							  and pm.data_desmontagem is null) then
					  1
					 else
					  0
				   end as montado,
				   pr.DATA_RETORNO_REFORMA,
				   nvl(pr.CUSTO,0) as custo_ultima_reforma,
				   r.data_proxima_reforma,
				   (select nvl(sum(decode(pem.suspenso,1,pr4.KM_CARREGADO,pr4.KM_CARREGADO+pr4.KM_VAZIO)),0)
					  from oper.v$pneu_inspecao pr4
					 inner join oper.v$pneu_gabarito_setup pgs
								  on pgs.num_gabarito = pr4.num_gabarito
								 and pgs.num_eixo = pr4.num_eixo
						 inner join oper.v$pneu_eixo_modelo pem
									 on pem.modelo_eixo_id = pgs.modelo_eixo_id 
					 where pr4.pneu_id = r.pneu_id
					   and pr4.DATA_INSPECAO between pr.DATA_RETORNO_REFORMA and nvl(nvl(r.data_proxima_troca, r.data_proxima_reforma), sysdate)) as km_reforma,
				   (select nvl(sum(pr3.CUSTO),0)
					  from oper.v$pneu_reforma pr3
					 where pr3.pneu_id = r.pneu_id
					   and pr3.conserto = 1
					   and pr3.DATA_RETORNO_REFORMA between pr.DATA_RETORNO_REFORMA and nvl(nvl(r.data_proxima_troca, r.data_proxima_reforma), sysdate)) as consertos_reforma,
				   ((nvl(pr.CUSTO,0) +
				   (select nvl(sum(pr3.CUSTO),0)
					  from oper.v$pneu_reforma pr3
					 where pr3.pneu_id = r.pneu_id
					   and pr3.conserto = 1
					   and pr3.DATA_RETORNO_REFORMA between pr.DATA_RETORNO_REFORMA and nvl(nvl(r.data_proxima_troca, r.data_proxima_reforma), sysdate)))/
				   (select decode(sum(pr4.KM_CARREGADO+pr4.KM_VAZIO),0,1,sum(pr4.KM_CARREGADO+pr4.KM_VAZIO))
					  from oper.v$pneu_inspecao pr4
					 where pr4.pneu_id = r.pneu_id
					   and pr4.DATA_INSPECAO between pr.DATA_RETORNO_REFORMA and nvl(nvl(r.data_proxima_troca, r.data_proxima_reforma), sysdate))
					   
					   
					   )*1000 as custo_final_reforma,
       			  r.tipo_eixo,
                        '' posicao,
                        '' placa,
                        0 num_eixo,
                        0 tipo_veiculo_id,
                        '' tipo_veiculo,
                        '' eixo

			   	 
		 <cfif IsDefined("arguments.DESGASTE_EXCESSIVO") AND arguments.DESGASTE_EXCESSIVO EQ 1>
			  from oper.v$pneu_rendimento_total r
		 <cfelse>
			  from oper.v$pneu_rendimento r
		 </cfif>
		 	 inner join oper.v$pneu_dados pd
			         on pd.pneu_id = r.pneu_id
			 inner join oper.v$pneu_reforma pr
					 on pr.pneu_id = r.pneu_id
 			 where 1=1
			   and pr.conserto_id = r.reforma_id
			   and pr.conserto = 0			 
			 	and r.reformas > 0
				 <cfif IsDefined("arguments.tipo_veiculo_id") and Len(Trim(arguments.tipo_veiculo_id))>
				   and r.tipo_veiculo_id in (#arguments.tipo_veiculo_id#)
				 </cfif>
				 <cfif IsDefined("arguments.marca_id") and Len(Trim(arguments.marca_id))>
				   and r.marca_id = #arguments.marca_id#
				 </cfif>
				 <cfif IsDefined("arguments.tipo_eixo") and Len(Trim(arguments.tipo_eixo))>
				   			and r.tipo_eixo = '#arguments.tipo_eixo#'
				 </cfif>
				 <cfif IsDefined("arguments.formato_borracha") and Len(Trim(arguments.formato_borracha))>
				   and pd.formato_borracha = '#arguments.formato_borracha#'
				 </cfif>
				 <cfif IsDefined("arguments.modelo_id") and Len(Trim(arguments.modelo_id))>
				   and r.modelo_id in (#arguments.modelo_id#)
				 </cfif>
				 <cfif IsDefined("arguments.borracha_id") and  Len(Trim(arguments.borracha_id))>
				   and r.borracha_id = #arguments.borracha_id#
				 </cfif>
				 <cfif IsDefined("arguments.desenho_id") and Len(Trim(arguments.desenho_id))>
				   and r.desenho_id = #arguments.desenho_id#
				 </cfif>
				 <cfif IsDefined("arguments.reformas") and Len(Trim(arguments.reformas))>
				   and r.reformas in (#arguments.reformas#)
				 </cfif>
				 <cfif IsDefined("arguments.eixo") and Len(Trim(arguments.eixo))>
				   and r.eixo = '#arguments.eixo#'
				 </cfif>
				 <cfif len(trim(arguments.faixa_peso_inicio))>
				   and round(peso_tracionado/1000) between #arguments.faixa_peso_inicio# and #arguments.faixa_peso_final#
				 </cfif>
				 <cfif len(trim(arguments.inspecoes_desde))>
				   and trunc(data_inspecao) >= '#arguments.inspecoes_desde#'
				 </cfif>
				 <cfif len(trim(arguments.inspecoes_ate))>
				   and trunc(data_inspecao) <= '#arguments.inspecoes_ate#'
				 </cfif>
				 <cfif len(trim(arguments.grupo))>
				   and r.grupo in (#ListQualify(arguments.grupo, "'", ",")#)
				 </cfif>
				 <cfif IsDefined("arguments.lado") and Len(Trim(arguments.lado))>
				   and r.cod_posicao in (#ListQualify(UCase(arguments.lado),"'",",")#)
				 </cfif>				 
				 <cfif len(trim(arguments.data_aquisicao))>
				   and trunc(r.data_aquisicao) >= '#arguments.data_aquisicao#'
				 </cfif>
				 <cfif len(trim(arguments.data_aquisicao_final))>
				   and trunc(r.data_aquisicao) <= '#arguments.data_aquisicao_final#'
				 </cfif>
				 
				 group by r.pneu_id,
						  r.num_pneu,
						  r.marca,
						  r.marca_id,
						  r.modelo,
						  r.modelo_id,
						  r.medida,
						  r.borracha,
						  r.borracha_id,
						  r.desenho_id,
						  r.desenho,
						  r.tipo_eixo,
						  decode(r.reformas, 0, 'Novo', 'Reforma ' || r.reformas),
						  r.reformas,
						  decode(r.reformas, 0, r.marca, r.borracha),
						  decode(r.reformas, 0, r.modelo, r.desenho),
						  r.sulco_manta,
						  r.data_aquisicao,
						  r.situacao,
						  pr.DATA_RETORNO_REFORMA,
						  pr.CUSTO,
						  r.data_proxima_reforma,
						  r.data_proxima_troca
				   having 
				  <cfif arguments.considerar eq 1>
				   		((round(((sum(mm_consumido))/(sulco_manta-2))*100) >= 100) or r.situacao = 'Sucateado')
				  <cfelseif arguments.considerar eq 3>
				   		(round(((sum(mm_consumido))/(sulco_manta-2))*100) >= 100)
				  <cfelse>
				  		r.situacao = 'Sucateado'
				  </cfif>
					 order by r.reformas, r.tipo_eixo, 
							  decode(r.reformas, 0, marca, borracha),	
							  decode(r.reformas, 0, modelo, desenho)
			</cfquery>
		<cfreturn qr_desenhos>
	</cffunction>
		
	<!--- 
	-- PROPSITO 
	-- Busca o rendimento dos pneus
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_pneu_custo_km_novos" returntype="query" access="remote">
		<cfargument name="tipo_veiculo_id" required="no">
		<cfargument name="marca_id" required="no">
		<cfargument name="modelo_id" required="no">
		<cfargument name="faixa_peso_inicio" required="no">
		<cfargument name="faixa_peso_final" required="no">
		<cfargument name="grupo" required="no">
		<cfargument name="considerar" required="no" default="">
		<cfargument name="data_aquisicao" required="no" default="">
		<cfargument name="data_aquisicao_final" required="no" default="">
		<cfargument name="tipo_eixo" required="no" default="">
		<cfargument name="desgaste" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_desenhos" username="#session.usuario#" password="#session.senha#">
			select r.pneu_id,
				   r.num_pneu,
				   r.marca,
				   r.marca_id,
				   r.modelo,
				   r.modelo_id,
				   r.borracha,
				   r.borracha_id,
				   r.desenho_id,
				   r.desenho,
				   r.sulco_manta,
				   r.data_aquisicao,
				   decode(r.reformas, 0, 'Novo', 'Reforma ' || r.reformas) as reformas,
				   sum(r.mm_consumido) as mm_consumido,
				   sum(r.km_percorrido) as km_percorrido,
				   decode(r.reformas, 0, r.marca, r.borracha) as marca_borracha,
				   decode(r.reformas, 0, r.modelo || ' - ' || r.medida, r.desenho) as modelo_desenho,
				   round(avg(r.peso_tracionado) / 1000) as peso_tracionado,
				   decode(sum(r.mm_consumido),
						  0,
						  sum(r.km_percorrido),
						  round(sum(r.km_percorrido) / sum(r.mm_consumido))) as rendimento,
				   round((r.sulco_manta - 2) *
						 decode(sum(r.mm_consumido),
								0,
								sum(r.km_percorrido),
								round(sum(r.km_percorrido) / sum(r.mm_consumido)))) as projetado,
				   r.situacao,
				   round(((sum(r.mm_consumido)) / (r.sulco_manta - 2)) * 100) as perc_consumido,
				   r.sulco_manta,
				   case
					 when exists (select 'x'
							 from oper.v$pneu_movimentacao pm
							where /*pm.placa = r.placa
							  and */pm.PNEU_ID = r.pneu_id
							  and pm.data_desmontagem is null) then
					  1
					 else
					  0
				   end as montado,
				   nvl(pd.CUSTO,0) as custo_ultima_reforma,
				   r.data_proxima_reforma,
				   (select nvl(sum(decode(pem.suspenso,1,pr4.KM_CARREGADO,pr4.KM_CARREGADO+pr4.KM_VAZIO)),0)
					  from oper.v$pneu_inspecao pr4
					 inner join oper.v$pneu_gabarito_setup pgs
								  on pgs.num_gabarito = pr4.num_gabarito
								 and pgs.num_eixo = pr4.num_eixo
						 inner join oper.v$pneu_eixo_modelo pem
									 on pem.modelo_eixo_id = pgs.modelo_eixo_id 
					 where pr4.pneu_id = r.pneu_id
					   and pr4.DATA_INSPECAO between r.data_aquisicao and nvl((Select min(pr1.DATA_ENVIO_REFORMA)
					   											from  oper.v$pneu_reforma pr1
															   where pr1.pneu_id = r.pneu_id),sysdate)) as km_reforma,
				   (select nvl(sum(pr3.CUSTO),0)
					  from oper.v$pneu_reforma pr3
					 where pr3.pneu_id = r.pneu_id
					   and pr3.conserto = 1
					   and pr3.DATA_RETORNO_REFORMA between r.data_aquisicao and nvl((Select min(pr1.DATA_ENVIO_REFORMA)
					   																	from  oper.v$pneu_reforma pr1
																					   where pr1.pneu_id = r.pneu_id),sysdate)) as consertos_reforma,
				  ((nvl(pd.CUSTO, 0) +
       				(select nvl(sum(pr3.CUSTO), 0)
            		   from oper.v$pneu_reforma pr3
           			  where pr3.pneu_id = r.pneu_id and pr3.conserto = 1
             			and pr3.DATA_RETORNO_REFORMA between r.data_aquisicao and nvl((Select min(pr1.DATA_ENVIO_REFORMA)
                       																	 from  oper.v$pneu_reforma pr1
                      																	where pr1.pneu_id = r.pneu_id),sysdate))) /
       				case
					when
						(select sum(pr4.KM_CARREGADO + pr4.KM_VAZIO)
						   from oper.v$pneu_inspecao pr4
						  where pr4.pneu_id = r.pneu_id
							and pr4.DATA_INSPECAO between r.data_aquisicao and nvl((Select min(pr.DATA_ENVIO_REFORMA)
																					  from  oper.v$pneu_reforma pr
																					 where pr.pneu_id = r.pneu_id),sysdate))=0
					then
           			1
           			else
					(select sum(pr4.KM_CARREGADO + pr4.KM_VAZIO)
           			   from oper.v$pneu_inspecao pr4
          			  where pr4.pneu_id = r.pneu_id
            			and pr4.DATA_INSPECAO between r.data_aquisicao and nvl((Select min(pr.DATA_ENVIO_REFORMA)
                    															  from  oper.v$pneu_reforma pr
                   																 where pr.pneu_id = r.pneu_id),sysdate))
       			  	 end
					 ) * 1000 as custo_final_reforma,
				  r.tipo_eixo,
                        '' posicao,
                        '' placa,
                        0 num_eixo,
                        0 tipo_veiculo_id,
                        '' tipo_veiculo,
                        '' eixo,
                        case
						   when nvl((select nvl(sum(decode(pem.suspenso,1,pr4.KM_CARREGADO,pr4.KM_CARREGADO+pr4.KM_VAZIO)),0)
                                       from oper.v$pneu_inspecao pr4
                                      inner join oper.v$pneu_gabarito_setup pgs
                                              on pgs.num_gabarito = pr4.num_gabarito
                                             and pgs.num_eixo = pr4.num_eixo
                                      inner join oper.v$pneu_eixo_modelo pem
                                              on pem.modelo_eixo_id = pgs.modelo_eixo_id
                                      where pr4.pneu_id = r.pneu_id
                                        and pr4.DATA_INSPECAO between r.data_aquisicao and nvl((Select min(pr1.DATA_ENVIO_REFORMA)
                                                                                                  from oper.v$pneu_reforma pr1
                                                                                                 where pr1.pneu_id = r.pneu_id),sysdate)),0) = 0 then 0 
                           else
								((nvl(pd.CUSTO,0)+nvl((select nvl(sum(pr3.CUSTO),0)
                                                         from oper.v$pneu_reforma pr3
                                                        where pr3.pneu_id = r.pneu_id
                                                          and pr3.conserto = 1
                                                          and pr3.DATA_RETORNO_REFORMA between r.data_aquisicao and nvl((select min(pr1.DATA_ENVIO_REFORMA)
																											               from oper.v$pneu_reforma pr1
																											              where pr1.pneu_id = r.pneu_id),sysdate)),0) ) * 1000)/
                                nvl((select nvl(sum(decode(pem.suspenso,1,pr4.KM_CARREGADO,pr4.KM_CARREGADO+pr4.KM_VAZIO)),0)
                                       from oper.v$pneu_inspecao pr4
                                      inner join oper.v$pneu_gabarito_setup pgs
                                              on pgs.num_gabarito = pr4.num_gabarito
                                             and pgs.num_eixo = pr4.num_eixo
                                      inner join oper.v$pneu_eixo_modelo pem
                                              on pem.modelo_eixo_id = pgs.modelo_eixo_id
                                      where pr4.pneu_id = r.pneu_id
                                        and pr4.DATA_INSPECAO between r.data_aquisicao and nvl((Select min(pr1.DATA_ENVIO_REFORMA)
                                                                                                  from oper.v$pneu_reforma pr1
                                                                                                 where pr1.pneu_id = r.pneu_id),sysdate)),0) end as rendimento
		 <cfif IsDefined("arguments.DESGASTE_EXCESSIVO") AND arguments.DESGASTE_EXCESSIVO EQ 1>
			  from oper.v$pneu_rendimento_total r
		 <cfelse>
			  from oper.v$pneu_rendimento r
		 </cfif>
		 	 inner join oper.v$pneu_dados pd
			         on pd.pneu_id = r.pneu_id
			 where 1=1
			   and r.reformas = 0
				 <cfif IsDefined("arguments.marca_id") and Len(Trim(arguments.marca_id))>
				   and r.marca_id = #arguments.marca_id#
				 </cfif>
				 <cfif IsDefined("arguments.tipo_eixo") and Len(Trim(arguments.tipo_eixo))>
				   			and r.tipo_eixo = '#arguments.tipo_eixo#'
				 </cfif>
				 <cfif IsDefined("arguments.modelo_id") and Len(Trim(arguments.modelo_id))>
				   and r.modelo_id in (#arguments.modelo_id#)
				 </cfif>
				 <cfif len(trim(arguments.grupo))>
				   and r.grupo in (#ListQualify(arguments.grupo, "'", ",")#)
				 </cfif>
				 <cfif IsDefined("arguments.lado") and Len(Trim(arguments.lado))>
				   and r.cod_posicao in (#ListQualify(UCase(arguments.lado),"'",",")#)
				 </cfif>				 
				 <cfif len(trim(arguments.data_aquisicao))>
				   and trunc(r.data_aquisicao) >= '#arguments.data_aquisicao#'
				 </cfif>
				 <cfif len(trim(arguments.data_aquisicao_final))>
				   and trunc(r.data_aquisicao) <= '#arguments.data_aquisicao_final#'
				 </cfif>
				 group by r.pneu_id,
						  r.num_pneu,
						  r.marca,
						  r.marca_id,
						  r.modelo,
						  r.modelo_id,
						  r.medida,
						  r.borracha,
						  r.borracha_id,
						  r.desenho_id,
						  r.desenho,
						  r.tipo_eixo,
						  decode(r.reformas, 0, 'Novo', 'Reforma ' || r.reformas),
						  r.reformas,
						  decode(r.reformas, 0, r.marca, r.borracha),
						  decode(r.reformas, 0, r.modelo, r.desenho),
						  r.sulco_manta,
						  r.data_aquisicao,
						  r.situacao,
						  r.data_proxima_reforma,
						  r.data_proxima_troca,
						  pd.custo
				    
				  <cfif len(trim(arguments.desgaste))>
						having
						round( ( (sum (mm_consumido) ) / (sulco_manta-2))*100 ) >= #arguments.desgaste#
				  </cfif>
					 order by r.reformas, r.tipo_eixo, 
							  decode(r.reformas, 0, marca, borracha),	
							  decode(r.reformas, 0, modelo, desenho)
			</cfquery>
		<cfreturn qr_desenhos>
	</cffunction>
		
	<!--- 
	-- PROPSITO 
	-- Busca o KM total do pneu
	-- CRISTOFER  18/04/2006
	--->		
	<cffunction name="get_pneu_km_total" access="remote" returntype="query" output="true">
		<cfargument name="pneu_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select sum(km_vazio+km_carregado) as total
			  from oper.v$pneu_movimentacao
			 where pneu_id = #arguments.pneu_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os dados do pneu para envio para reforma
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 10/02/2006
	--->
	<cffunction name="get_pneu_envio_reforma" returntype="query" access="remote">
		<cfargument name="num_relacao" required="no">
		<cfquery datasource="#session.dsn#" name="qr_pneus" username="#session.usuario#" password="#session.senha#">
			select prb.cod_pessoa as cod_pessoa_reformador, pj.cliente || ' - ' || pj.razao_social as reformador, pb.imagem,
				   oper.pkg_global.fnc_busca_nome_pessoa(u.cod_pessoa) as usuario,
				   pd.num_pneu, pd.marca, pd.modelo, d.descricao as desenho, pr.data_envio_reforma, 
				   pr.data_retorno_reforma, pd.medida, 
				   m.largura_manta, r.observacao, r.situacao, r.num_relacao
			  from oper.v$pneu_relacao_envio_reforma r
			 inner join oper.v$pneu_reforma pr
			         on pr.num_relacao = r.num_relacao
					and pr.reformador_id = r.reformador_id
             inner join oper.v$pneu_reformador_bandeira prb
                     on prb.reformador_id = r.reformador_id
			 inner join kss.v$pessoa pj 
			         on pj.cod_pessoa = prb.cod_pessoa
			 left join oper.v$pneu_borracha pb
					 on pb.borracha_id = pr.borracha_id
			 left join oper.v$pneu_desenho d
					 on d.borracha_id = pr.borracha_id
					and d.desenho_id = pr.desenho_id
			 inner join oper.v$pneu_dados pd
					 on pd.pneu_id = pr.pneu_id
		     inner join oper.v$pneu_modelo m
			         on m.marca_id = pd.marca_id
					and m.modelo_id = pd.modelo_id
					and m.medida_id = pd.medida_id
					and m.medida_roda_id = pd.medida_roda_id
			 inner join kss.v$kss_usuarios u
					 on u.usuario = pr.user_insert
			  where 1=1
			  <cfif IsDefined("arguments.num_relacao")>
				and pr.num_relacao = #arguments.num_relacao#
			  <cfelse>
			    and pr.data_retorno_reforma is null 
			  </cfif>
			  order by prb.cod_pessoa
		</cfquery>
		<cfreturn qr_pneus>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as inspees de um pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 08/02/2006
	--->
	<cffunction name="get_pneu_inspecoes" returntype="query" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_inspecoes" username="#session.usuario#" password="#session.senha#">
            select pi.num_inspecao,
                   p.num_pneu,
                   pi.placa,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(pi.placa) as cod_veiculo,
                   pi.posicao,
                   pi.data_ult_inspecao,
                   pi.km_ult_inspecao,
                   pi.mm_ult_inspecao,
                   pi.data_inspecao,
                   pi.km_inspecao,
                   pi.mm_inspecao,
                   pi.medida_1,
                   pi.medida_2,
                   pi.medida_3,
                   pi.movimentacao,
                   pa.descricao as laudo,
                   pi.pressao_encontrada,
                   pi.user_insert,
                   nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(pi.pneu_id), 1), 0) as sulco_atual,
                   nvl(pm.mm_montagem, 0) as mm_montagem,
                   oper.pkg_global.fnc_get_parametro(1, 'PNEU') / 100 as tolerancia,
                   p.pneu_id,
                   pi.medida_1,
                   pi.medida_2,
                   pi.medida_3,
                   pi.pressao_encontrada,
                   pi.km_carregado,
                   pi.km_vazio
              from oper.v$pneu_dados p
             inner join oper.v$pneu_inspecao pi
                     on pi.pneu_id = p.pneu_id
              left join oper.v$pneu_laudo_analise pa
                     on pa.laudo_id = pi.laudo_analise_id
              left join oper.v$pneu_movimentacao pm
                     on pm.pneu_id = p.pneu_id
                    and pm.pmov_id = pi.pmov_id
             where 1 = 1       
			<cfif IsDefined("arguments.PNEU_ID")>
			   and pi.pneu_id = #arguments.PNEU_ID#
			</cfif>
			 order by pi.data_inspecao
		</cfquery>
		<cfreturn qr_inspecoes>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as movimentaes de um pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 07/02/2006
	--->
	<cffunction name="get_pneu_movimentacao" returntype="query" access="remote">
		<cfargument name="num_pneu" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_movimentacao" username="#session.usuario#" password="#session.senha#">
			select pm.placa, 
            	   oper.pkg_veiculo.fnc_get_placa(pm.placa) as cod_veiculo, 
                   pm.posicao, 
                   pm.data_montagem, 
                   pm.mm_montagem, 
                   pm.mm_desmontagem, 
                   pm.data_desmontagem, 
                   pm.km_carregado, 
                   pm.km_vazio, 
                   pem.suspenso
			  from oper.v$pneu_dados pd
			 inner join oper.v$pneu_movimentacao pm
					 on pm.pneu_id = pd.pneu_id
			 left join oper.v$pneu_gabarito_setup pgs
					 on pgs.num_gabarito = pm.num_gabarito
					and pgs.num_eixo = pm.num_eixo
			 left join oper.v$pneu_eixo_modelo pem
					 on pem.modelo_eixo_id = pgs.modelo_eixo_id
			where pd.num_pneu = #arguments.num_pneu#
			 order by pm.data_montagem	
		</cfquery>
		<cfreturn qr_movimentacao>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as observacoes de um pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 08/02/2006
	--->
	<cffunction name="get_pneu_observacao" returntype="query" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfquery datasource="#session.dsn#" name="qrObservacao" username="#session.usuario#" password="#session.senha#">
			select observacoes
			  from oper.v$pneu
			 where pneu_id = #arguments.pneu_id#
   		</cfquery>		
		<cfreturn qrObservacao>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as reformas de um pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 08/02/2006
	--->
	<cffunction name="get_pneu_reformas" returntype="query" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_inspecoes" username="#session.usuario#" password="#session.senha#">
			select /*+ ORDERED */ pr.custo, pr.reforma_id as conserto_id, pd.num_pneu, pd.pneu_id, pr.data_envio_reforma, pr.data_retorno_reforma, pb.descricao as borracha,
				   pr.desenho_id, d.descricao as desenho, pr.borracha_id, pj.cliente as nome_fantasia
			  from oper.v$pneu_dados pd
			 inner join oper.v$pneu_reforma pr
					 on pr.pneu_id = pd.pneu_id
					and pr.conserto = 0
			 inner join oper.v$pneu_borracha pb
					 on pb.borracha_id = pr.borracha_id
			 inner join oper.v$pneu_desenho d
					 on d.borracha_id = pr.borracha_id
					and d.desenho_id = pr.desenho_id        
             inner join oper.v$pneu_reformador_bandeira prb
                     on prb.reformador_id = pr.reformador_id
			 inner join kss.v$pessoa pj
					 on pj.cod_pessoa = prb.cod_pessoa
			<cfif IsDefined("arguments.PNEU_ID")>
				 where pd.pneu_id = #arguments.pneu_id#          
			</cfif>
			order by pr.data_envio_reforma
		</cfquery>
		<cfreturn qr_inspecoes>
	</cffunction>
			
	<!--- 
	-- PROPSITO 
	-- Busca o rendimento dos pneus
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_pneu_rendimento" returntype="query" access="remote">
        <cfargument name="tipo_carroceria_id" required="no">
		<cfargument name="marca_id" required="no">
		<cfargument name="modelo_id" required="no">
		<cfargument name="borracha_id" required="no">
		<cfargument name="medida_id" required="no">
		<cfargument name="medida_roda_id" required="no">
		<cfargument name="desenho_id" required="no">
		<cfargument name="eixo" required="no">
		<cfargument name="lado" required="no">
		<cfargument name="faixa_peso_inicio" required="no">
		<cfargument name="faixa_peso_final" required="no">
		<cfargument name="de_perc_consumido" required="no">
		<cfargument name="ate_perc_consumido" required="no">
		<cfargument name="ordem" required="no" default="num_pneu">
		<cfargument name="inspecoes_desde" required="no" default="">
		<cfargument name="inspecoes_ate" required="no" default="">
		<cfargument name="data_aquisicao" required="no" default="">
		<cfargument name="data_aquisicao_final" required="no" default="">
		<cfargument name="grupo" required="no">
		<cfargument name="desgaste_excessivo" required="no">		
		<cfquery datasource="#session.dsn#" name="qr_desenhos" username="#session.usuario#" password="#session.senha#">
		select r.pneu_id, 
		       r.num_pneu, 
			   r.marca, 
			   r.marca_id, 
			   r.modelo, 
			   r.modelo_id, 
			   r.borracha,
			   r.borracha_id, 
			   r.desenho_id, 
			   r.desenho, 
			   posicao, placa, sulco_manta, 
			   data_aquisicao,
			   decode(r.reformas,0,'Novo','Reforma ' || r.reformas) as reformas, num_eixo, tipo_carroceria_id as tipo_veiculo_id, tipo_veiculo, eixo,
			   sum(mm_consumido) as mm_consumido, sum(km_percorrido) as km_percorrido,
			   decode(r.reformas, 0, marca, borracha) as marca_borracha,
			   decode(r.reformas, 0, modelo || ' - ' || medida, desenho) as modelo_desenho, 
			   round(avg(peso_tracionado)/1000) as peso_tracionado, 
			   decode( sum(mm_consumido),0, sum(km_percorrido),round(sum(km_percorrido) / sum(mm_consumido))) as rendimento,
			   round((r.sulco_manta-2) * decode(sum(mm_consumido),0,sum(km_percorrido), round(sum(km_percorrido) / sum(mm_consumido)))) as projetado,
			   situacao, round(((sum(mm_consumido))/(sulco_manta-2))*100) as perc_consumido,  
			   r.sulco_manta,
			   case when exists (select 'x' 
								 from oper.v$pneu_movimentacao pm 
								where pm.placa = r.placa 
								  and pm.PNEU_ID = r.pneu_id
								  and pm.data_desmontagem is null) then 1 else 0 end as montado,
	           pr.custo as custo_reforma
		 <cfif IsDefined("arguments.DESGASTE_EXCESSIVO") AND arguments.DESGASTE_EXCESSIVO EQ 1>
			  from oper.v$pneu_rendimento_total r
		 <cfelse>
			  from oper.v$pneu_rendimento r
		 </cfif>
			  left join oper.v$pneu_reforma pr
					 on pr.reforma_id = r.reforma_id
 			 where 1=1
			 <cfif IsDefined("arguments.tipo_carroceria_id") and Len(Trim(arguments.tipo_carroceria_id))>
			   and tipo_carroceria_id in (#arguments.tipo_carroceria_id#)
			 </cfif>
			 <cfif IsDefined("arguments.marca_id") and Len(Trim(arguments.marca_id))>
			   and marca_id = #arguments.marca_id#
			 </cfif>
			 <cfif IsDefined("arguments.modelo_id") and Len(Trim(arguments.modelo_id))>
			   and modelo_id in (#arguments.modelo_id#)
			 </cfif>
			 <cfif IsDefined("arguments.borracha_id") and  Len(Trim(arguments.borracha_id))>
			   and borracha_id = #arguments.borracha_id#
			 </cfif>
			 <cfif IsDefined("arguments.medida_roda_id") and Len(Trim(arguments.medida_roda_id))>
			   and medida_roda_id in (#arguments.medida_roda_id#)
			 </cfif>
			 <cfif IsDefined("arguments.medida_id") and  Len(Trim(arguments.medida_id))>
			   and medida_id in (#arguments.medida_id#)
			 </cfif>
			 <cfif IsDefined("arguments.desenho_id") and Len(Trim(arguments.desenho_id))>
			   and desenho_id = #arguments.desenho_id#
			 </cfif>
			 <cfif IsDefined("arguments.reformas") and Len(Trim(arguments.reformas))>
			   and reformas in (#arguments.reformas#)
			 </cfif>
			 <cfif IsDefined("arguments.eixo") and Len(Trim(arguments.eixo))>
			   and eixo = '#arguments.eixo#'
			 </cfif>
			 <cfif len(trim(arguments.faixa_peso_inicio))>
			   and round(peso_tracionado/1000) between #arguments.faixa_peso_inicio# and #arguments.faixa_peso_final#
			 </cfif>
			 <cfif len(trim(arguments.inspecoes_desde))>
			   and trunc(data_inspecao) >= '#arguments.inspecoes_desde#'
			 </cfif>
			 <cfif len(trim(arguments.inspecoes_ate))>
			   and trunc(data_inspecao) <= '#arguments.inspecoes_ate#'
			 </cfif>
			 <cfif len(trim(arguments.data_aquisicao))>
			   and trunc(data_aquisicao) >= '#arguments.data_aquisicao#'
			 </cfif>
			 <cfif len(trim(arguments.data_aquisicao_final))>
			   and trunc(data_aquisicao) <= '#arguments.data_aquisicao_final#'
			 </cfif>
			 <cfif len(trim(arguments.grupo))>
			   and grupo in (#ListQualify(arguments.grupo, "'", ",")#)
			 </cfif>
			 <cfif IsDefined("arguments.lado") and Len(Trim(arguments.lado))>
			   and cod_posicao in (#ListQualify(UCase(arguments.lado),"'",",")#)
			 </cfif>
			 
			 group by r.pneu_id, 
			          r.num_pneu, 
					  r.marca, 
					  r.marca_id, 
					  r.modelo, 
					  r.modelo_id, 
					  r.medida, 
					  r.borracha,
					  r.borracha_id, 
					  r.desenho_id, 
					  r.desenho, 
					  r.posicao, 
					  placa,
					  pr.custo,
					  decode(r.reformas, 0, 'Novo', 'Reforma ' || r.reformas), 
                      r.reformas, 
                      num_eixo,
                      tipo_carroceria_id, 
                      tipo_veiculo, 
                      eixo,
                      decode(r.reformas, 0, marca, borracha),
                      decode(r.reformas, 0, modelo, desenho), 
                      sulco_manta, 
                      data_aquisicao,
                      situacao
			 having 1=1
			 <cfif IsDefined("arguments.de_perc_consumido") and Len(Trim(arguments.de_perc_consumido))>
			   and round(((sum(mm_consumido))/(sulco_manta-2))*100) >= #arguments.de_perc_consumido#
			 </cfif>
			 <cfif IsDefined("arguments.ate_perc_consumido") and Len(Trim(arguments.ate_perc_consumido))>
			   and round(((sum(mm_consumido))/(sulco_manta-2))*100) <= #arguments.ate_perc_consumido#
			 </cfif>

				 order by r.reformas, tipo_carroceria_id, eixo, decode(r.reformas, 0, marca, borracha),	
						  decode(r.reformas, 0, modelo, desenho)
			</cfquery>
		<cfreturn qr_desenhos>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as situaes do pneu
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_pneu_situacao" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select situacao_id,
				   descricao 
			  from oper.v$pneu_situacao
			 order by descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os pneus com verificacao urgente
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_pneu_tempo_situacao" returntype="query" access="remote">
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select t.*
			  from (select pneu_id, num_pneu, data_ocorrencia, marca, modelo, medida, 
							   medida_roda, reformas, tempo, situacao, situacao_id, situacao_atual 
						  from oper.v$pneu_tempo_situacao
						 where tempo > 40
						   and situacao_atual in (3,4,5,6,8,9,10)         
						 order by situacao_atual, tempo desc) t
			where situacao_id not in (1,2)
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os dados do laudo de sucateamento
	-- CRISTOFER  18/04/2006
	--->		
	<cffunction name="get_pneu_sucateamento" access="remote" returntype="query" output="true">
		<cfargument name="pneu_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ps.psu_id,
				   ps.pneu_id,
				   ps.cod_pessoa_sucateador,
				   ps.data_sucateamento,
				   ps.situacao_id,
				   ps.laudo_id,
				   ps.cod_pessoa_tecnico_analise,
				   ps.data_analise,
				   ps.valor_venda,
				   ps.cod_pessoa_mot_resp,
				   ps.observacao,
				   pl.descricao as laudo
			  from oper.v$pneu_sucateamento ps
			 inner join oper.v$pneu_laudo_sucateamento pl
					 on pl.laudo_id = ps.laudo_id
			 where 1=1
			   and ps.pneu_id = #arguments.pneu_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>			
	
	<!--- 
	-- PROPSITO 
	-- Busca os pneus apartir de uma lista
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 31/01/2006
	--->
	<cffunction name="get_pneus" returntype="query" access="remote">
		<cfargument name="lista_pneus" required="no">
		<cfargument name="lista_localizacao" required="no">
		<cfargument name="pneu_id" required="no">
		<cfargument name="num_pneu" required="no">
		<cfargument name="situacao_id" required="no">
		<cfargument name="transferencia" required="no">
		<cfargument name="varios" required="no" default="">	
		<cfquery name="qr_result"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.pneu_id, p.num_pneu, p.situacao_id, 
            	   to_char(p.data_aquisicao,'dd/mm/yyyy') as data_aquisicao,  p.custo, 
				   p.nota_fiscal_numero, p.nota_fiscal_serie, pj2.cnpj_cpf as cnpj_cpf, p.ano_fabricacao, p.marca_id, p.marca,
				   p.modelo_id, p.modelo, pb.borracha_id, pb.descricao as borracha, pd.desenho_id, pd.descricao as desenho, 
				   p.sulco, p.medida_id, p.medida, p.medida_roda_id,
				   p.medida_roda, p.reformas, decode(p.reformas,0,'Novo','Reforma ' || p.reformas) as status,
				   oper.pkg_pneu.fnc_valor_pneu(p.pneu_id) as valor_estimado,
				   p.situacao,p.situacao_id,p.formato_borracha,
				   pj.cliente as filial, pl.cod_pessoa,
				   pr.data_retorno_reforma,
				   p.observacoes,
                   pj.cod_pessoa as cod_filial,
				   oper.pkg_pneu.fnc_km_rodado_pneu(p.pneu_id) as km_rodado_total,
				   (select count(*)
					  from oper.v$pneu_reforma
					 where pneu_id = p.pneu_id
					   and conserto = 1
					   and furo = 0) quant_reparos,
				   (select count(*)
					  from oper.v$pneu_reforma
					 where pneu_id = p.pneu_id
					   and conserto = 1
					   and furo = 1) quant_furos,
					oper.pkg_pneu.fnc_reforma_bloqueada(p.pneu_id) as reforma_bloqueada, 
					p.libera_reforma_manual,
					nvl(p.usuario_bloqueio,'Sistema') as usuario_bloqueio,
					oper.pkg_pneu.fnc_sulco_atual_estimado(p.pneu_id) as sulco_estimado,
					oper.pkg_pneu.fnc_sulco_atual(p.pneu_id) as sulco_atual,
					nvl((select pm.placa
					  from oper.v$pneu_movimentacao pm
					 where pm.pneu_id = p.pneu_id
					   and pm.data_desmontagem is null),'Desmontado') as montado_em,
					 pj2.razao_social as proprietario, 
					 (select cliente
					    from kss.v$pessoa pj
                       inner join oper.v$pneu_reformador_bandeira pb1
                               on pb1.cod_pessoa = pj.cod_pessoa
					   where pb1.reformador_id = pr.reformador_id) as reformador,
					 0 as conserto_estrada,
					  (select nvl(sum(custo),0)
						 from oper.v$pneu_reforma pc
					    where pc.pneu_id = p.pneu_id
						  and pc.conserto = 1) as outros_consertos					 			
			  from oper.v$pneu_dados p
			 left join oper.v$pneu_localizacao_atual pl 
			         on pl.pneu_id = p.pneu_id
	         left join kss.v$pessoa pj
                    on pj.cod_pessoa = pl.cod_pessoa
	         left join oper.v$pneu_proprietario pp
                    on p.pneu_id = pp.pneu_id
				   and pp.data_fim is null
			 left join kss.v$pessoa pj2
	 			    on pj2.cod_pessoa = pp.cod_pessoa
			 left join oper.v$pneu_reforma pr
			        on pr.pneu_id = p.pneu_id
				   and pr.conserto = 0
			left join oper.v$pneu_borracha pb
					on pb.borracha_id = pr.borracha_id
			left join oper.v$pneu_desenho pd
					on pd.borracha_id = pr.borracha_id
				   and pd.desenho_id = pr.desenho_id													 
			 where 1=1
			 and (pr.data_retorno_reforma is null or pr.data_envio_reforma = (select max(pr2.data_envio_reforma)
                                         from oper.v$pneu_reforma pr2
                                        where pr2.pneu_id = pr.pneu_id
                                         and pr2.conserto = 0))
			 <cfif IsDefined("arguments.lista_pneus") and Len(Trim(arguments.lista_pneus))>
			   and p.pneu_id in (#arguments.lista_pneus#)
			 </cfif>  			 
			 <cfif ((Len(trim(arguments.varios))) and (IsDefined("arguments.pneu_id") and Len(Trim(arguments.pneu_id))))>
			   	and p.pneu_id in (#arguments.pneu_id#)
			 <cfelse>
			 		<cfif IsDefined("arguments.pneu_id") and Len(Trim(arguments.pneu_id))>
			   			and p.pneu_id = #arguments.pneu_id#
			 		</cfif>
			 </cfif>
			 <cfif IsDefined("arguments.num_pneu") and Len(Trim(arguments.num_pneu))>
			   and p.num_pneu = #arguments.num_pneu#
			 </cfif>  
			 <cfif IsDefined("arguments.lista_localizacao") and Len(Trim(arguments.lista_localizacao))>
			   and pl.localizacao_id in (#arguments.lista_localizacao#)
			 </cfif>
			 <cfif IsDefined("arguments.situacao_id") and Len(Trim(arguments.situacao_id))>
			   and p.situacao_id = #arguments.situacao_id#
			 </cfif>
			 order by p.num_pneu		 
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os pneus adquiridos no periodo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  27/03/2006
	--->		
	<cffunction name="get_pneus_adquiridos" access="remote" returntype="query" output="true">
		<cfargument name="data_inicio" required="yes">
		<cfargument name="data_fim" required="yes">
		<cfargument name="marca_id" required="no" default="">
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="formato_borracha" required="no" default="">
		<cfargument name="medida_id" required="no" default="">
		<cfargument name="situacao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select 	pd.pneu_id,
						pd.num_pneu,
						pd.situacao_id,
						pd.data_aquisicao,
						pd.custo,
						pd.marca,
						pd.modelo,
						pd.medida,
						pd.situacao,
						pd.formato_borracha,
						ps.cliente as filial
					 from oper.v$pneu_dados pd
				left join oper.v$pneu_localizacao_atual pl
					   on pd.pneu_id = pl.pneu_id and pl.data_saida is null
				left join kss.v$pessoa ps
					   on pl.cod_pessoa = ps.cod_pessoa
			 	where 1=1
			   and trunc(pd.data_aquisicao) >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
			   and trunc(pd.data_aquisicao) <= to_date('#arguments.data_fim#', 'dd/mm/yyyy')
			  <cfif len(trim(marca_id))>
			   and pd.marca_id in (#arguments.marca_id#)
			  </cfif> 
			  <cfif len(trim(modelo_id))>
			   and pd.modelo_id in (#arguments.modelo_id#)
			  </cfif> 
			  <cfif len(trim(formato_borracha))>
			   and pd.formato_borracha in (#ListQualify(arguments.formato_borracha, "'", ',')#)
			  </cfif> 
			  <cfif len(trim(medida_id))>
			   and pd.medida_id in (#arguments.medida_id#)
			  </cfif>
			  <cfif len(trim(arguments.situacao)) and arguments.situacao eq 1>
			   and pd.nota_fiscal_numero is not null
			  </cfif> 
			 order by data_aquisicao
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os pneus disponiveis no estoque
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 25/01/2006
	--->
	<cffunction name="get_pneus_disponiveis_estoque" returntype="query" access="remote">
		<cfargument name="num_gabarito" required="no">
		<cfargument name="num_eixo" required="no">
		<cfargument name="medida_id" required="no">
		<cfargument name="medida_roda_id" required="no" default="">
		<cfargument name="marca_id" required="no">
		<cfargument name="modelo_id" required="no">
		<cfargument name="num_reformas_pneu" required="no">
		<cfargument name="borracha_id" required="no">
		<cfargument name="desenho_id" required="no">
		<cfargument name="sulco" required="no">
		<cfquery name="qr_conf_eixo"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select reformas, integridade_marca, integridade_modelo, integridade_status,
				   integridade_borracha, integridade_desenho, pem.direcional, pem.tracionado,
        	       pem.suspenso, t.prefixo, to_number(kss.pkg_global.fnc_obtem_parametro_str(11, 'OPERACIONAL', 18, 9)) as mm_permitido_parceiro
			  from oper.v$pneu_gabarito_setup t
		     inner join oper.v$pneu_eixo_modelo pem
                on pem.modelo_eixo_id = t.modelo_eixo_id
			 where t.num_gabarito = #arguments.num_gabarito#
			   and t.num_eixo = #arguments.num_eixo# 
   		</cfquery>		
		<cfquery name="qr_pneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pneu_id, num_pneu, situacao_id as situacao, marca_id, marca, modelo_id, modelo,
				   borracha_id, desenho_id, desenho, borracha, oper.pkg_pneu.fnc_sulco_atual(pneu_id) as sulco, 
				   medida_id, medida, reformas, medida_roda_id, medida_roda, 
				   status, substr(formato_borracha,1,1) as formato
			  from (
						select /*+ RULE */ p.pneu_id, p.num_pneu, p.situacao_id, p.marca_id, ma.descricao as marca, 
						 p.modelo_id, pm.descricao as modelo,
							   null borracha_id, null desenho_id, null as desenho, 
						 null as borracha, 
						 p.medida_roda_id, mr.medida_roda, 
							   oper.pkg_pneu.fnc_sulco_atual(p.pneu_id) as sulco,
							   p.medida_id, me.descricao as medida,
							   p.reformas, 'Novos' as status, pfb.descricao as formato_borracha
						  from oper.v$pneu p
					inner join oper.v$pneu_localizacao pl
							on pl.pneu_id = p.pneu_id
						   and pl.data_saida is null
					inner join oper.v$pneu_marca ma
							on ma.marca_id = p.marca_id
					inner join oper.v$pneu_modelo pm
							on pm.marca_id = p.marca_id	
						   and pm.modelo_id = p.modelo_id
						   and pm.medida_id = p.medida_id
						   and pm.medida_roda_id = p.medida_roda_id
						<cfif qr_conf_eixo.RecordCount and qr_conf_eixo.direcional eq 1>
						   and pm.eixo_direcional = 1
						</cfif>
						<cfif qr_conf_eixo.RecordCount and qr_conf_eixo.tracionado eq 1>
						   and pm.eixo_tracionado = 1
						</cfif>
						<cfif qr_conf_eixo.RecordCount and qr_conf_eixo.suspenso eq 1>
						   and pm.eixo_suspenso = 1
						</cfif>
					inner join oper.v$pneu_medida me
							on me.medida_id = p.medida_id
					inner join oper.v$pneu_medida_roda mr
							on mr.medida_roda_id = p.medida_roda_id
					inner join oper.v$pneu_formato_borracha pfb
							on pfb.formato_id = pm.formato_id
						 where p.situacao_id = 1
					 and p.reformas = 0
					 and pl.cod_pessoa = #session.cod_pessoa#
			union
						select /*+ RULE */ p.pneu_id, p.num_pneu, p.situacao_id, p.marca_id, ma.descricao as marca, 
							   p.modelo_id, pm.descricao as modelo,
							   pr.borracha_id, pr.desenho_id, 
							   pd.descricao as desenho, 
							   pb.descricao as borracha, 
							   p.medida_roda_id, mr.medida_roda, 
							   oper.pkg_pneu.fnc_sulco_atual(p.pneu_id) as sulco,
							   p.medida_id, me.descricao as medida,
							   p.reformas, 'Recapados' as status, pfb.descricao as formato_borracha
						  from oper.v$pneu p
					inner join oper.v$pneu_localizacao pl
							on pl.pneu_id = p.pneu_id
						   and pl.data_saida is null
					inner join oper.v$pneu_marca ma
							on ma.marca_id = p.marca_id
					inner join oper.v$pneu_modelo pm
							on pm.marca_id = p.marca_id
						   and pm.modelo_id = p.modelo_id
						   and pm.medida_id = p.medida_id
						   and pm.medida_roda_id = p.medida_roda_id
					inner join oper.v$pneu_medida me
							on me.medida_id = p.medida_id
					inner join oper.v$pneu_medida_roda mr
							on mr.medida_roda_id = p.medida_roda_id
					  inner join oper.v$pneu_reforma pr
								on pr.pneu_id = p.pneu_id
					inner join oper.v$pneu_borracha pb
							on pb.borracha_id = pr.borracha_id
					inner join oper.v$pneu_desenho pd
							on pd.borracha_id = pr.borracha_id
						   and pd.desenho_id = pr.desenho_id
						<cfif qr_conf_eixo.RecordCount and qr_conf_eixo.direcional eq 1>
						   and pd.eixo_direcional = 1
						</cfif>
						<cfif qr_conf_eixo.RecordCount and qr_conf_eixo.tracionado eq 1>
						   and pd.eixo_tracionado = 1
						</cfif>
						<cfif qr_conf_eixo.RecordCount and qr_conf_eixo.suspenso eq 1>
						   and pd.eixo_suspenso = 1
						</cfif>
					inner join oper.v$pneu_formato_borracha pfb
							on pfb.formato_id = pd.formato_id
						 where p.situacao_id = 1
						   and p.reformas > 0
					       and pl.cod_pessoa = #session.cod_pessoa#
						   and (pr.data_retorno_reforma = (select max(r2.data_retorno_reforma)
																				 from oper.v$pneu_reforma r2
																				where r2.pneu_id = pr.pneu_id
																				  and r2.data_retorno_reforma is not null
																				  and r2.conserto = 0)
								or (select max(r2.data_retorno_reforma)
																				 from oper.v$pneu_reforma r2
																				where r2.pneu_id = pr.pneu_id
																				  and r2.data_retorno_reforma is not null
																				  and r2.conserto = 0) is null	)					   ) p
			 where 1 = 1

				 <cfif Len(Trim(arguments.sulco)) and arguments.num_eixo neq 0>
				   and #arguments.sulco# between sulco - #qr_conf_eixo.mm_permitido_parceiro# and sulco + #qr_conf_eixo.mm_permitido_parceiro#
				 </cfif>
				 
				 <cfif Len(Trim(arguments.medida_roda_id)) and arguments.num_eixo neq 0>
				   and p.medida_roda_id = #arguments.medida_roda_id#			 
				 </cfif>

				 <cfif Len(Trim(arguments.medida_id)) and arguments.num_eixo neq 0>
				   and p.medida_id = #arguments.medida_id#			 
				 </cfif>
							 
				 <cfif qr_conf_eixo.reformas gte 0 and arguments.num_eixo neq 0 <!--- numero maximo de REFORMAS ---> >
				   and p.reformas <= #qr_conf_eixo.reformas#			 
				 </cfif>
	
				 <cfif qr_conf_eixo.integridade_status eq 1 and Len(Trim(arguments.num_reformas_pneu)) and arguments.num_eixo neq 0<!--- integridade de STATUS ---> >
				   and p.reformas = #arguments.num_reformas_pneu#
				 </cfif>
	
				 <cfif qr_conf_eixo.integridade_marca eq 1 and Len(Trim(arguments.marca_id)) and arguments.num_eixo neq 0<!--- integridade de MARCA --->>
				   and p.marca_id = #arguments.marca_id#			 
				 </cfif>
	
				 <cfif qr_conf_eixo.integridade_modelo eq 1 and Len(Trim(arguments.modelo_id)) and arguments.num_eixo neq 0<!--- integridade de MODELO --->>
				   and p.modelo_id = #arguments.modelo_id#			 
				 </cfif>
	
				 <cfif arguments.num_reformas_pneu gt 0 and qr_conf_eixo.integridade_borracha eq 1 and Len(Trim(arguments.borracha_id)) and arguments.num_eixo neq 0<!--- integridade de BORRACHA --->>
				   and p.borracha_id = #arguments.borracha_id#
				 </cfif>
	
				 <cfif arguments.num_reformas_pneu gt 0 and qr_conf_eixo.integridade_desenho eq 1 and Len(Trim(arguments.desenho_id)) and arguments.num_eixo neq 0<!--- integridade de DESENHO --->>
				   and p.desenho_id = #arguments.desenho_id#
				 </cfif>
			 <cfif qr_conf_eixo.PREFIXO eq '1'>
			     or sulco < #session.mm_liberacao_primeiro_eixo# 
			 </cfif>
			 order by p.reformas, p.num_pneu, p.marca, p.modelo, 12 desc, p.borracha, p.desenho
             
   		</cfquery>									
		<cfreturn qr_pneus>
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca todos os pneus enviados para conserto
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_pneus_enviados_conserto" returntype="query" access="remote">
		<cfargument name="reforma_id" required="no" default="">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS*/  pr.reforma_id, p.num_pneu, pr.pneu_id, prb.cod_pessoa cod_pessoa_reformador, 
				   pj.cliente as nome_fantasia, pr.data_envio_reforma,
				   p.marca, p.modelo, p.reformas, pr.user_insert as usuario,
          		   greatest(pi.medida_1, pi.medida_2, pi.medida_3) as medida_maxima
			  from oper.v$pneu_reforma pr
			 inner join oper.v$pneu_dados p 
					 on p.pneu_id = pr.pneu_id
             inner join oper.v$pneu_reformador_bandeira prb
                     on prb.reformador_id = pr.reformador_id
			 inner join kss.v$pessoa pj
					 on pj.cod_pessoa = prb.cod_pessoa
			 inner join oper.v$pneu_localizacao_atual pl
					 on pl.pneu_id = pr.pneu_id
					and pl.data_saida is null
       		  left join oper.v$pneu_inspecao pi
					  on pi.pneu_id = pr.pneu_id
			 where pr.data_retorno_reforma is null         
			   and pr.conserto = 1
			   and pl.cod_pessoa = #session.cod_pessoa#
			   and (pi.data_inspecao = (select max(pi2.data_inspecao)
										   from oper.v$pneu_inspecao pi2
										  where pi2.pneu_id = pi.pneu_id)   
				    or pi.data_inspecao is null)
			   <cfif Len(Trim(arguments.reforma_id))>
				   and pr.reforma_id = #arguments.reforma_id#
			   </cfif>
			   order by p.num_pneu
   		</cfquery>		
		<cfreturn qrPneus>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca todos os pneus em analise de garantia
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 01/02/2006
	--->
	<cffunction name="get_pneus_enviados_garantia" returntype="query" access="remote">
		<cfargument name="pneu_id" required="no">
		<cfargument name="cod_pessoa_fornecedor" required="no">
		<cfargument name="data_envio_analise" required="no">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS*/ p.num_pneu, pr.pneu_id, pr.cod_pessoa_fornecedor, 
				   pj.cliente as nome_fantasia, pr.data_envio_analise,
				   p.marca, p.modelo, p.reformas, pr.user_insert as usuario,
				   p.situacao
			  from oper.v$pneu_garantia pr
			 inner join oper.v$pneu_dados p 
					 on p.pneu_id = pr.pneu_id
			 inner join kss.v$pessoa pj
					 on pj.cod_pessoa = pr.cod_pessoa_fornecedor
			 inner join oper.v$pneu_localizacao_atual pl
					 on pl.pneu_id = pr.pneu_id
					and pl.data_saida is null
			 where pr.valor is null
               and p.situacao_id = 10
			   and pl.cod_pessoa = #session.cod_pessoa#
			<cfif IsDefined("arguments.pneu_id") and IsDefined("arguments.cod_pessoa_fornecedor") and IsDefined("arguments.data_envio_analise")>
               and pr.pneu_id = #arguments.pneu_id#
               and pr.cod_pessoa_fornecedor = #arguments.cod_pessoa_fornecedor#
               and trunc(pr.data_envio_analise) = trunc(to_date('#arguments.data_envio_analise#'))
			</cfif>
			 order by p.num_pneu
   		</cfquery>		
		<cfreturn qrPneus>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca todos os pneus enviados para a reforma
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_pneus_enviados_reforma" returntype="query" access="remote">
		<cfargument name="reforma_id" required="no">
		<cfargument name="sem_ficha" required="no">
		<cfargument name="inclui_consertos" required="no">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS*/  
            	   pr.reforma_id, 
                   p.num_pneu, 
                   pr.pneu_id, 
                   pr.reformador_id,
                   prb.cod_pessoa cod_pessoa_reformador, 
				   pj.cliente as nome_fantasia, 
                   pr.data_envio_reforma,
				   p.marca, 
                   p.modelo, 
                   p.reformas, 
                   p.medida, 
                   p.medida_roda,
				   bo.descricao as borracha, 
                   de.descricao as desenho, 
                   pr.user_insert as usuario,
				   decode(pr.conserto,1,'Conserto','Reforma') as tipo
			  from oper.v$pneu_reforma pr
             inner join oper.v$pneu_reformador_bandeira prb
                     on prb.reformador_id = pr.reformador_id
			 inner join oper.v$pneu_dados p 
					 on p.pneu_id = pr.pneu_id
			 inner join kss.v$pessoa pj
					 on pj.cod_pessoa = prb.cod_pessoa
			 inner join oper.v$pneu_localizacao_atual pl
					 on pl.pneu_id = pr.pneu_id
					and pl.data_saida is null
			 left join	oper.v$pneu_borracha bo
			         on bo.borracha_id = pr.borracha_id
		     left join oper.v$pneu_desenho de
			         on de.borracha_id = pr.borracha_id
					and de.desenho_id = pr.desenho_id
			 where pr.data_retorno_reforma is null      
			   <cfif not IsDefined("arguments.inclui_consertos")>
				   and pr.conserto = 0
			   </cfif>
			   <cfif IsDefined("arguments.reforma_id")>
				   and pr.reforma_id = #arguments.reforma_id#
			   </cfif>
			   <cfif IsDefined("arguments.sem_ficha")>
				   and num_relacao is null
			   </cfif>
			   order by p.num_pneu
   		</cfquery>		
		<cfreturn qrPneus>
	</cffunction>	
		
	<!--- 
	-- PROPSITO 
	-- Busca todos os pneus do estoque
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 31/01/2006
	--->
	<cffunction name="get_pneus_estoque" returntype="query" access="remote">
		<cfargument name="cod_pessoa" required="yes">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.pneu_id, p.num_pneu, pl.data_entrada, ma.descricao as marca, mo.descricao as modelo,
			       oper.pkg_pneu.fnc_sulco_atual(p.pneu_id) as sulco
			  from oper.v$pneu p   
			 inner join oper.v$pneu_marca ma
			         on ma.marca_id = p.marca_id
		     inner join oper.v$pneu_modelo mo
			         on mo.marca_id = p.marca_id
					and mo.modelo_id = p.modelo_id
					and mo.medida_id = p.medida_id
					and mo.medida_roda_id = p.medida_roda_id
			 inner join oper.v$pneu_localizacao pl
			         on p.pneu_id = pl.pneu_id
					and pl.data_entrada is not null
					and pl.data_transferencia is null
					and pl.data_saida is null
			 where p.situacao_id = 1
			   and pl.cod_pessoa = #arguments.cod_pessoa#					  
			  order by p.num_pneu
   		</cfquery>		
		<cfreturn qrPneus>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os pneus reformados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 10/02/2006
	--->
	<cffunction name="get_pneus_reformados" returntype="query" access="remote">
	    <cfargument name="num_pneu" required="yes">
	    <cfargument name="data_inicio" required="yes">
	    <cfargument name="data_termino" required="yes">
	    <cfargument name="somente_reformados" required="no">
		<cfargument name="marca_id" required="no" default="">
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="medida_id" required="no" default="">
		<cfargument name="reformas_1" required="no" default="">
		<cfargument name="borracha_id" required="no" default="">
		<cfargument name="desenho_id" required="no" default="">
		<cfargument name="localizacao" required="no" default="">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+ FIRST_ROWS */ pd.num_pneu
                 , pd.marca
                 , pd.modelo
                 , pd.medida
                 , pd.medida_roda
                 , prb.cod_pessoa as cod_pessoa_reformador
                 , pj.cliente as reformador
                 , pr.data_envio_reforma
                 , pr.data_retorno_reforma
                 , pb.descricao as borracha
                 , d.descricao as desenho
                 , pr.custo
                 , sum(pr.custo) over(partition by prb.cod_pessoa order by prb.cod_pessoa) as total_por_reformador
                 , sum(pr.custo) over() as custo_total
                 , count(*) over() as recordcount
                 , pr.agrupamento_id
                 , (select max(pc.num_lancamento_contabil)
                      from oper.v$pneu_contabilizacao pc
                     where pc.agrupamento_id = pr.agrupamento_id
                   ) as num_lancamento_contabil
              from oper.v$pneu_reforma pr
             inner join oper.v$pneu_reformador_bandeira prb
                     on prb.reformador_id = pr.reformador_id
             inner join oper.v$pneu_dados pd
                     on pd.pneu_id = pr.pneu_id
             inner join kss.v$pessoa pj
                     on pj.cod_pessoa = prb.cod_pessoa
             inner join oper.v$pneu_borracha pb
                     on pr.borracha_id = pb.borracha_id
             inner join oper.v$pneu_desenho d
                     on d.borracha_id = pr.borracha_id
                    and d.desenho_id = pr.desenho_id
              left join oper.v$pneu_proprietario pp
                     on pp.pneu_id = pr.pneu_id
                    and pp.data_fim is null
              left join oper.v$pneu_localizacao_atual pla
                     on pla.pneu_id = pr.pneu_id
             where 1 = 1
			 <cfif IsDefined("arguments.data_inicio") and Len(Trim(arguments.data_inicio))>
			   and pr.data_envio_reforma between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
			<cfelse>
			   and pr.conserto = 0
			   and pr.data_envio_reforma = (select max(pr2.data_envio_reforma) 
			                                  from oper.v$pneu_reforma pr2
											 where pr2.pneu_id = pr.pneu_id
											   and pr2.conserto = 0)
			 </cfif>
			 <cfif IsDefined("arguments.somente_reformados")>
			   and pr.data_retorno_reforma is not null
			 </cfif>
			 <cfif IsDefined("arguments.num_pneu") and Len(Trim(arguments.num_pneu))>
			   and pd.num_pneu = #arguments.num_pneu#
			 </cfif>
			 <cfif len(trim(arguments.marca_id))>
			   and pd.marca_id in (#arguments.marca_id#)
			 </cfif>
			 <cfif len(trim(arguments.modelo_id))>
			   and pd.modelo_id in (#arguments.modelo_id#)
			 </cfif>
			 <cfif len(trim(arguments.medida_id))>
			   and pd.medida_id in (#arguments.medida_id#)
			 </cfif>
			 <cfif len(trim(arguments.cod_pessoa_filial))>
			   and pp.cod_pessoa = #arguments.cod_pessoa_filial#
			 </cfif>
			 <cfif len(trim(arguments.reformas_1))>
			 	<cfif IsDefined("arguments.data_inicio") and Len(Trim(arguments.data_inicio))>
				and #arguments.reformas_1# = (select count(*)
					  from oper.v$pneu_reforma pr2
					 where pr2.pneu_id = pr.pneu_id
						   and pr2.conserto = 0
						   and pr2.data_envio_reforma < to_date('#arguments.data_inicio#','dd/mm/yyyy'))
				<cfelse>
				   and pd.reformas - 1 = #arguments.reformas_1#
				</cfif>
			 </cfif>
			 <cfif len(trim(arguments.borracha_id))>
			   and pr.borracha_id in (#arguments.borracha_id#)
			 </cfif>
			 <cfif len(trim(arguments.desenho_id))>
			   and pr.desenho_id in (#arguments.desenho_id#)
			 </cfif>
			  <cfif len(trim(arguments.localizacao))>
			   and pla.cod_pessoa = #arguments.localizacao#
			  </cfif>
			   and pr.conserto = 0
			order by pj.cliente, pd.marca, pd.modelo, pd.medida, pd.medida_roda 
		</cfquery>		
		<cfreturn qrPneus>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os pneus Concertados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 10/02/2006
	--->
	<cffunction name="get_pneus_consertados" returntype="query" access="remote">
	    <cfargument name="num_pneu" required="yes">
	    <cfargument name="data_inicio" required="yes">
	    <cfargument name="data_termino" required="yes">
	    <cfargument name="somente_reformados" required="no">
		<cfargument name="marca_id" required="no" default="">
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="medida_id" required="no" default="">
		<cfargument name="reformas_1" required="no" default="">
		<cfargument name="conserto_reforma" required="no" default="">
        <cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS */ pd.num_pneu, pd.marca, pd.modelo, pd.medida, pd.medida_roda,
				   pr.cod_pessoa_reformador, pj.cliente as reformador, pr.data_envio_reforma, pr.data_retorno_reforma,
				   pr.custo,pc.descricao,
                   '' as borracha,
                   '' as desenho,
	               sum(pr.custo) over(partition by pr.cod_pessoa_reformador order by pr.cod_pessoa_reformador) as total_por_reformador,
		           sum(pr.custo) over() as custo_total,
                   count(*) over () as recordcount
			  from oper.v$pneu_reforma pr
			 inner join oper.v$pneu_dados pd
					 on pd.pneu_id = pr.pneu_id
			 <cfif IsDefined("arguments.somente_reformados")>
             inner join oper.v$pneu_tipo_conserto pc 
                     on pc.tipo_conserto_id = pr.tipo_conserto_id
             <cfelse>
             left join oper.v$pneu_tipo_conserto pc 
                     on pc.tipo_conserto_id = pr.tipo_conserto_id
			 </cfif>
             left join kss.v$pessoa pj
					 on pj.cod_pessoa = pr.cod_pessoa_reformador        
			 where 1=1
			 <cfif IsDefined("arguments.data_inicio") and Len(Trim(arguments.data_inicio))>
			   and pr.data_envio_reforma >= to_date('#arguments.data_inicio#','dd/mm/yyyy')
			 </cfif>
			 <cfif IsDefined("arguments.data_termino") and Len(Trim(arguments.data_termino))>
			   and pr.data_envio_reforma <= to_date('#arguments.data_termino#','dd/mm/yyyy')
			 </cfif>
			 <cfif IsDefined("arguments.somente_reformados")>
			   and pr.data_retorno_reforma is not null
			 </cfif>
			 <cfif IsDefined("arguments.num_pneu") and Len(Trim(arguments.num_pneu))>
			   and pd.num_pneu = #arguments.num_pneu#
			 </cfif>
			 <cfif len(trim(arguments.marca_id))>
			   and pd.marca_id in (#arguments.marca_id#)
			 </cfif>
			 <cfif len(trim(arguments.modelo_id))>
			   and pd.modelo_id in (#arguments.modelo_id#)
			 </cfif>
			 <cfif len(trim(arguments.medida_id))>
			   and pd.medida_id in (#arguments.medida_id#)
			 </cfif>
			 <cfif len(trim(arguments.reformas_1))>
				   and pd.reformas = #arguments.reformas_1#
			 </cfif>
			 <cfif len(trim(arguments.conserto_reforma)) and  arguments.conserto_reforma eq 0>
			   and not exists(select 0
              				  	from oper.v$pneu_reforma pr2
             				   where pr.pneu_id = pr2.pneu_id
               					 and pr2.DATA_ENVIO_REFORMA >= pr.data_envio_reforma
               					 and (pr2.DATA_ENVIO_REFORMA <= pr.data_retorno_reforma or pr.data_retorno_reforma is null)
               					 and pr2.conserto = 0)
 			   and conserto = 1
			 </cfif>
			 <cfif len(trim(arguments.conserto_reforma)) and arguments.conserto_reforma eq 1>
			   and exists(	 select 'x'
                				from oper.v$pneu_reforma pr2
             				   where pr.pneu_id = pr2.pneu_id
               					 and pr2.DATA_ENVIO_REFORMA >= pr.data_envio_reforma
               					 and (pr2.DATA_ENVIO_REFORMA <= pr.data_retorno_reforma or pr.data_retorno_reforma is null)
               					 and pr2.conserto = 0)
			   and conserto = 1 
			 </cfif>
             and pr.conserto = 1
			order by pj.cliente, pd.marca, pd.modelo, pd.medida, pd.medida_roda 
		</cfquery>		
		<cfreturn qrPneus>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca pneus sucateados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 10/02/2006
	--->
	<cffunction name="get_pneus_sucateados" returntype="query" access="remote">
		<cfargument name="cod_pessoa_reformador" required="no" default="">
		<cfargument name="borracha_id" required="no" default="">
		<cfargument name="laudo_id" required="no" default="">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfargument name="marca_id" required="no" default="">
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="medida_id" required="no" default="">
		<cfargument name="reformas" required="no" default="">
		<cfargument name="num_pneu" required="no" default="">
		<cfquery name="qr_sucatas" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			  select /*+ FIRST_ROWS */ pls.laudo_id, pls.descricao as laudo, count(*) as num_pneus, round(avg(pd.sulco),2) as mm_inicial,
			         round(sum(pd.sulco),2) as total_mm_inicial,
					 sum(oper.pkg_pneu.fnc_sulco_atual(ps.pneu_id)) as mm_perdido,
					 round(avg(oper.pkg_pneu.fnc_sulco_atual(ps.pneu_id)),1) as media_mm_perdido
				  from oper.v$pneu_sucateamento ps
				 inner join oper.v$pneu_laudo_sucateamento pls
						 on pls.laudo_id = ps.laudo_id         
				 inner join oper.v$pneu_dados pd
						 on pd.pneu_id = ps.pneu_id                  
				 <cfif (IsDefined("arguments.COD_PESSOA_REFORMADOR") and Len(Trim(arguments.COD_PESSOA_REFORMADOR)))
					 or (IsDefined("arguments.BORRACHA_ID") and Len(Trim(arguments.BORRACHA_ID)))>
				 inner join oper.v$pneu_reforma pr
						 on pr.pneu_id = ps.pneu_id
						and pr.conserto = 0
						<cfif IsDefined("arguments.COD_PESSOA_REFORMADOR") and Len(Trim(arguments.COD_PESSOA_REFORMADOR))>
							and pr.cod_pessoa_reformador = #arguments.COD_PESSOA_REFORMADOR#
						</cfif>
				  <cfif IsDefined("arguments.BORRACHA_ID") and Len(Trim(arguments.BORRACHA_ID))>
				  inner join oper.v$pneu_borracha b
						  on b.borracha_id = pr.borracha_id
						 and b.borracha_id = #arguments.BORRACHA_ID#
				  </cfif>
				 </cfif>
				 where 1=1
				 <cfif (IsDefined("arguments.COD_PESSOA_REFORMADOR") and Len(Trim(arguments.COD_PESSOA_REFORMADOR)))
					 or (IsDefined("arguments.BORRACHA_ID") and Len(Trim(arguments.BORRACHA_ID)))>
						and pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma) 
														from oper.v$pneu_reforma pr2
													   where pr2.pneu_id = pr.pneu_id
														<cfif IsDefined("arguments.COD_PESSOA_REFORMADOR") and Len(Trim(arguments.COD_PESSOA_REFORMADOR))>
															 and pr2.cod_pessoa_reformador = #arguments.COD_PESSOA_REFORMADOR#
														</cfif>
														 and pr2.conserto = 0)
				 </cfif>
				 <cfif len(trim(arguments.num_pneu))>
				   and pd.num_pneu in (#arguments.num_pneu#)
				 </cfif>
				 <cfif IsDefined("arguments.LAUDO_ID") and Len(Trim(arguments.LAUDO_ID))>
						and ps.laudo_id in (#ListQualify(arguments.LAUDO_ID,"'",",")#)
				 </cfif>
				 <cfif IsDefined("arguments.DATA_INICIO") and Len(Trim(arguments.DATA_INICIO)) AND IsDefined("arguments.DATA_FIM") and Len(Trim(arguments.DATA_FIM))>
						and ps.data_analise between '#arguments.DATA_INICIO#' and '#arguments.DATA_FIM#'
				 </cfif>
				 <cfif IsDefined("arguments.MARCA_ID") and Len(Trim(arguments.MARCA_ID))>
				   and pd.marca_id = #arguments.MARCA_ID#
				 </cfif>
				 <cfif IsDefined("arguments.MODELO_ID") and Len(Trim(arguments.MODELO_ID))>
					 and pd.modelo_id in (#arguments.MODELO_ID#)
				 </cfif>
				 <cfif IsDefined("arguments.MEDIDA_ID") and Len(Trim(arguments.MEDIDA_ID))>
					 and pd.medida_id in (#arguments.MEDIDA_ID#)
				 </cfif>
				 <cfif IsDefined("arguments.REFORMAS") and Len(Trim(arguments.REFORMAS))>
					 and pd.reformas in (#arguments.REFORMAS#)
				 </cfif>
				 group by pls.laudo_id, pls.descricao
				 order by media_mm_perdido desc 
		</cfquery>
		<cfreturn qr_sucatas>
	</cffunction>	


	<!--- 
	-- PROPSITO 
	-- Busca lista de pneus sucateados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 10/02/2006
	--->
	<cffunction name="get_pneus_sucateados_lista" returntype="query" access="remote">
		<cfargument name="cod_pessoa_reformador" required="no" default="">
		<cfargument name="borracha_id" required="no" default="">
		<cfargument name="laudo_id" required="no" default="">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfargument name="marca_id" required="no" default="">
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="medida_id" required="no" default="">
		<cfargument name="reformas" required="no" default="">
		<cfargument name="num_pneu" required="no" default="">
		<cfquery name="qr_sucatas_lista" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select laudo_id, nvl(laudo,'Laudo no especificado') as laudo, num_pneus, mm_perdido, media_mm_perdido, mm_inicial,
            		sum(mm_inicial*num_pneus) over() as total_mm_inicial,
                    round(avg(mm_inicial) over(),2) as media_mm_inicial,
				  	round((num_pneus * 100) /sum(num_pneus) over(),2) as percentual,
				  	sum(num_pneus) over() as total_pneus,
				  	sum(reformas) over() as total_reformas, 
				   	sum(mm_perdido) over() as total_mm_perdidos, lista_pneus,
                    (select kss.fnc_concat_all(kss.to_concat_expr(ps.pneu_id,','))
                      from oper.v$pneu_sucateamento ps
                      left join oper.v$pneu_laudo_sucateamento pls 
                        on pls.laudo_id = ps.laudo_id
                     inner join oper.v$pneu_dados pd 
                        on pd.pneu_id = ps.pneu_id
                     where 1 = 1
					<cfif IsDefined("arguments.DATA_INICIO") and Len(Trim(arguments.DATA_INICIO))>
                   	   and trunc(ps.data_sucateamento) >= to_date('#arguments.DATA_INICIO#')
					</cfif>
                    <cfif IsDefined("arguments.DATA_FIM") and Len(Trim(arguments.DATA_FIM))>
                       and trunc(ps.data_sucateamento) <= to_date('#arguments.DATA_FIM#')
                    </cfif>
                       and t.laudo_id = pls.LAUDO_ID ) as lista_pneu_id
			  from (select /*+ FIRST_ROWS */ pls.laudo_id,  pls.descricao as laudo, count(*) as num_pneus,round(avg(pd.sulco),2) as mm_inicial,
			             round(sum(pd.sulco),2) as total_mm_inicial,
						 sum(oper.pkg_pneu.fnc_sulco_atual(ps.pneu_id)) as mm_perdido,
						 round(avg(oper.pkg_pneu.fnc_sulco_atual(ps.pneu_id)),1) as media_mm_perdido, -1 as lista_pneus,
						 sum(pd.reformas) as reformas
					  from oper.v$pneu_sucateamento ps
					 left join oper.v$pneu_laudo_sucateamento pls
							 on pls.laudo_id = ps.laudo_id         
					 inner join oper.v$pneu_dados pd
							 on pd.pneu_id = ps.pneu_id                  
					 <cfif (IsDefined("arguments.COD_PESSOA_REFORMADOR") and Len(Trim(arguments.COD_PESSOA_REFORMADOR)))
						 or (IsDefined("arguments.BORRACHA_ID") and Len(Trim(arguments.BORRACHA_ID)))>
						 inner join oper.v$pneu_reforma pr
								on pr.pneu_id = ps.pneu_id
							   and pr.conserto = 0
							   <cfif IsDefined("arguments.COD_PESSOA_REFORMADOR") and Len(Trim(arguments.COD_PESSOA_REFORMADOR))>
								   and pr.cod_pessoa_reformador = #arguments.COD_PESSOA_REFORMADOR#
							   </cfif>
						  <cfif IsDefined("arguments.BORRACHA_ID") and Len(Trim(arguments.BORRACHA_ID))>
						  inner join oper.v$pneu_borracha b
								  on b.borracha_id = pr.borracha_id
								 and b.borracha_id = #arguments.BORRACHA_ID#
						  </cfif>
					  </cfif>
					  where 1=1
					 <cfif (IsDefined("arguments.COD_PESSOA_REFORMADOR") and Len(Trim(arguments.COD_PESSOA_REFORMADOR)))
						 or (IsDefined("arguments.BORRACHA_ID") and Len(Trim(arguments.BORRACHA_ID)))>
							   and pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma) 
																from oper.v$pneu_reforma pr2
															   where pr2.pneu_id = pr.pneu_id
																<cfif IsDefined("arguments.COD_PESSOA_REFORMADOR") and Len(Trim(arguments.COD_PESSOA_REFORMADOR))>
																 and pr2.cod_pessoa_reformador = #arguments.COD_PESSOA_REFORMADOR#
																</cfif>
																 and pr2.conserto = 0)
					  </cfif>
					  <cfif len(trim(arguments.num_pneu))>
					    and pd.num_pneu in (#arguments.num_pneu#)
					  </cfif>					  
					  <cfif IsDefined("arguments.DATA_INICIO") and Len(Trim(arguments.DATA_INICIO))>
                   		and trunc(ps.data_sucateamento) >= to_date('#arguments.DATA_INICIO#')
					  </cfif>
                      <cfif IsDefined("arguments.DATA_FIM") and Len(Trim(arguments.DATA_FIM))>
                        and trunc(ps.data_sucateamento) <= to_date('#arguments.DATA_FIM#')
                      </cfif>
					  <cfif IsDefined("arguments.LAUDO_ID") and Len(Trim(arguments.LAUDO_ID))>
						  and pls.laudo_id in (#ListQualify(arguments.LAUDO_ID,"'",",")#)
					  </cfif>
					  <cfif IsDefined("arguments.MARCA_ID") and Len(Trim(arguments.MARCA_ID))>
						 and pd.marca_id = #arguments.MARCA_ID#
					  </cfif>
					  <cfif IsDefined("arguments.MODELO_ID") and Len(Trim(arguments.MODELO_ID))>
						 and pd.modelo_id in (#arguments.MODELO_ID#)
					  </cfif>
					  <cfif IsDefined("arguments.MEDIDA_ID") and Len(Trim(arguments.MEDIDA_ID))>
						 and pd.medida_id in (#arguments.MEDIDA_ID#)
					  </cfif>
					  <cfif IsDefined("arguments.REFORMAS") and Len(Trim(arguments.REFORMAS))>
							 and pd.reformas in (#arguments.REFORMAS#)
					  </cfif>
					 group by pls.laudo_id, pls.descricao
					 order by media_mm_perdido desc 
		) t
		</cfquery>
		<cfreturn qr_sucatas_lista>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca lista de pneus sucateados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 10/02/2006
	--->
	<cffunction name="get_pneus_sucateados_lista_pneus" returntype="query" access="remote">
		<cfargument name="cod_pessoa_reformador" required="no" default="">
		<cfargument name="borracha_id" required="no" default="">
		<cfargument name="laudo_id" required="no" default="">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfargument name="marca_id" required="no" default="">
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="medida_id" required="no" default="">
		<cfargument name="reformas" required="no" default="">
		<cfargument name="num_pneu" required="no" default="">
		<cfquery name="qr_sucatas_lista" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS */ ps.pneu_id
					  from oper.v$pneu_sucateamento ps
					 inner join oper.v$pneu_laudo_sucateamento pls
							 on pls.laudo_id = ps.laudo_id         
					 inner join oper.v$pneu_dados pd
							 on pd.pneu_id = ps.pneu_id                  
					 <cfif (IsDefined("arguments.COD_PESSOA_REFORMADOR") and Len(Trim(arguments.COD_PESSOA_REFORMADOR)))
						 or (IsDefined("arguments.BORRACHA_ID") and Len(Trim(arguments.BORRACHA_ID)))>
						 inner join oper.v$pneu_reforma pr
								on pr.pneu_id = ps.pneu_id
							   and pr.conserto = 0
							   <cfif IsDefined("arguments.COD_PESSOA_REFORMADOR") and Len(Trim(arguments.COD_PESSOA_REFORMADOR))>
								   and pr.cod_pessoa_reformador = #arguments.COD_PESSOA_REFORMADOR#
							   </cfif>
						  <cfif IsDefined("arguments.BORRACHA_ID") and Len(Trim(arguments.BORRACHA_ID))>
						  inner join oper.v$pneu_borracha b
								  on b.borracha_id = pr.borracha_id
								 and b.borracha_id = #arguments.BORRACHA_ID#
						  </cfif>
					  </cfif>
					  where 1=1
					 <cfif (IsDefined("arguments.COD_PESSOA_REFORMADOR") and Len(Trim(arguments.COD_PESSOA_REFORMADOR)))
						 or (IsDefined("arguments.BORRACHA_ID") and Len(Trim(arguments.BORRACHA_ID)))>
							   and pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma) 
																from oper.v$pneu_reforma pr2
															   where pr2.pneu_id = pr.pneu_id
																<cfif IsDefined("arguments.COD_PESSOA_REFORMADOR") and Len(Trim(arguments.COD_PESSOA_REFORMADOR))>
																 and pr2.cod_pessoa_reformador = #arguments.COD_PESSOA_REFORMADOR#
																</cfif>
																 and pr2.conserto = 0)
					  </cfif>
					  <cfif len(trim(arguments.num_pneu))>
					    and pd.num_pneu in (#arguments.num_pneu#)
					  </cfif>
                      <cfif IsDefined("arguments.DATA_INICIO") and Len(Trim(arguments.DATA_INICIO))>
                   		and trunc(ps.data_sucateamento) >= to_date('#arguments.DATA_INICIO#')
					  </cfif>
                      <cfif IsDefined("arguments.DATA_FIM") and Len(Trim(arguments.DATA_FIM))>
                        and trunc(ps.data_sucateamento) <= to_date('#arguments.DATA_FIM#')
                      </cfif>
					  <cfif IsDefined("arguments.LAUDO_ID") and Len(Trim(arguments.LAUDO_ID))>
						  and pls.laudo_id in (#ListQualify(arguments.LAUDO_ID,"'",",")#)
					  </cfif>
					  <cfif IsDefined("arguments.MARCA_ID") and Len(Trim(arguments.MARCA_ID))>
						 and pd.marca_id = #arguments.MARCA_ID#
					  </cfif>
					  <cfif IsDefined("arguments.MODELO_ID") and Len(Trim(arguments.MODELO_ID))>
						 and pd.modelo_id in (#arguments.MODELO_ID#)
					  </cfif>
					  <cfif IsDefined("arguments.MEDIDA_ID") and Len(Trim(arguments.MEDIDA_ID))>
						 and pd.medida_id in (#arguments.MEDIDA_ID#)
					  </cfif>
					  <cfif IsDefined("arguments.REFORMAS") and Len(Trim(arguments.REFORMAS))>
							 and pd.reformas in (#arguments.REFORMAS#)
					  </cfif>
		</cfquery>
		<cfreturn qr_sucatas_lista>
	</cffunction>
	<!--- 
	-- PROPSITO 
	-- Busca listagem de pneus sucateados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 10/02/2006
	--->
	<cffunction name="get_pneus_sucateados_listagem" returntype="query" access="remote">
		<cfargument name="lista_pneus" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_mms" username="#session.usuario#" password="#session.senha#">
			select pls.laudo_id, 
				   pls.descricao,
				   p.num_pneu,
				   p.marca,
				   p.modelo,
				   case 
				      when pr.pneu_id is null then 
					       p.modelo 
				      else pb.descricao||'/'||pd.descricao 
				   end as modelo_desenho,
				   p.medida,
				   p.medida_roda,
				   ps.observacao,
				   ps.data_sucateamento,
				   oper.pkg_pneu.fnc_km_rodado_pneu(p.pneu_id) as km_rodado
			  from oper.v$pneu_dados p
			 inner join oper.v$pneu_sucateamento ps
					 on ps.pneu_id = p.pneu_id
			 inner join oper.v$pneu_laudo_sucateamento pls
					 on pls.laudo_id = ps.laudo_id
			  left join oper.v$pneu_reforma pr
					 on pr.PNEU_ID = p.pneu_id
				    and pr.conserto = 0
			  left join oper.v$pneu_borracha pb
					 on pb.BORRACHA_ID = pr.BORRACHA_ID
			  left join oper.v$pneu_desenho pd
					 on pd.DESENHO_ID = pr.desenho_id
			 where p.pneu_id in (#arguments.lista_pneus#)
				and (pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
												 from oper.v$pneu_reforma pr2
												where pr2.pneu_id = pr.pneu_id
												  and pr2.conserto = 0)
					 or pr.data_retorno_reforma  is null)
			 order by p.reformas, p.marca_id, p.modelo_id, pr.borracha_id, pr.desenho_id	
  		</cfquery>
		<cfreturn qr_mms>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca todas os pneus em transferencia para a filial
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 31/01/2006
	--->
	<cffunction name="get_pneus_transferencia" returntype="query" access="remote">
		<cfargument name="cod_pessoa" required="yes">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.pneu_id, p.num_pneu, pl.data_entrada, pl.data_saida, 
 				   pl.data_transferencia, pl.data_previsao_chegada,
				   p.marca, p.modelo, p.medida, p.medida_roda,
           		   pl.cod_pessoa, pl.cod_departamento, pl.cod_setor, pl.cod_centro_custo,
           		   p.reformas, pl.localizacao_id,
				   (select pj.cliente
					  from oper.v$pneu_localizacao pl1
					 inner join kss.v$pessoa pj
							 on pj.cod_pessoa = pl1.cod_pessoa
					 where pl1.pneu_id = p.pneu_id
					   and pl1.data_entrada is not null
					   and pl1.data_saida is null) as origem
		   	  from oper.v$pneu_dados p   
			 inner join oper.v$pneu_localizacao pl
			         on p.pneu_id = pl.pneu_id
					and pl.data_entrada is null
		     inner join kss.v$pessoa pj
			         on pj.cod_pessoa = pl.cod_pessoa
			 where p.situacao_id in (3,6)
			   and pl.cod_pessoa = #arguments.cod_pessoa#					  
   		</cfquery>		
		<cfreturn qrPneus>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca todas as posicoes vagas nos veiculos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 30/01/2006
	--->	
	<cffunction name="get_posicoes_veiculo" returntype="query" access="remote">
		<cfargument name="cod_veiculo" required="yes">
		<cfargument name="order_posicao" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
         select pvp.placa
              , pvp.cod_veiculo
              , pvp.num_gabarito
              , pvp.num_eixo
              , pvp.posicao
              , pvp.cod_posicao
           from oper.v$pneu_veiculo_posicao pvp 
          where upper(pvp.placa) = upper(oper.pkg_veiculo.fnc_get_placa('#ucase(arguments.cod_veiculo)#'))
            and not exists (select 'x'
                              from oper.v$pneu_movimentacao pm
                             where pm.num_gabarito = pvp.num_gabarito
                               and pm.placa = pvp.placa
                               and pm.num_eixo = pvp.num_eixo
                               and pm.posicao = pvp.posicao
                               and pm.data_desmontagem is null)	
			<cfif len(trim(arguments.order_posicao))>
          order by pvp.posicao
         </cfif>						 
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
    
    <!--- 
	-- PROPSITO 
	-- Busca todas as posicoes vagas nos veiculos
	-- NOTAS EXPLICATIVAS
	-- LEOPOLDOS 06/07/2010
	--->	
	<cffunction name="get_posicoes_veiculo_xml" returntype="query" access="remote">
		<cfargument name="cod_veiculo" required="yes">
		<cfargument name="order_posicao" required="no" default="1">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
	    select dbms_xmlgen.getxml(' 
				select pvp.placa,
                       pvp.cod_veiculo, 
                       pvp.num_gabarito, 
                       pvp.num_eixo, 
                       pvp.posicao, 
                       pvp.cod_posicao
				  from oper.v$pneu_veiculo_posicao pvp 
				 where upper(pvp.placa) = upper(oper.pkg_veiculo.fnc_get_placa(' || chr(39) || '#arguments.cod_veiculo#' || chr(39) || '))
				   and not exists (select '|| chr(39) || 'x'|| chr(39) || '
									 from oper.v$pneu_movimentacao pm
									where pm.num_gabarito = pvp.num_gabarito
                       				  and pm.placa = pvp.placa
                                      and pm.num_eixo = pvp.num_eixo
			                          and pm.posicao = pvp.posicao
			                          and pm.data_desmontagem is null)  
                order by pvp.posicao') as resultado
         from dual
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca todas as posicoes vagas nos veiculos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 30/01/2006
	--->	
	<cffunction name="get_posicoes_vagas" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qr_posicoes_vagas" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_veiculo.fnc_get_cod_veiculo(pvp.placa) as placa,
				   pvp.num_gabarito,
				   pvp.num_eixo,
				   pvp.posicao,
				   pvp.cod_posicao,
				   pvp.ordem,
				   pvp.modelo_eixo_id,
				   pvp.caminho_imagem,
				   pvp.veiculo_modelo,
				   /*pvp.tipo_veiculo, */
				   pvp.suspenso,
				   pvp.geminado,
				   pvp.num_veiculos,
				   pvp.pmov_id,
				   pmv.data_desmontagem,
				   pmv.user_update as usuario_desmontagem,
				   (select num_pneu
					  from oper.v$pneu p1
					 where p1.pneu_id = pmv.pneu_id) as num_pneu,
				   pld.DESCRICAO as laudo_desmontagem,
				   (select t.landmark
					  from oper.v$rank_frota t
					 where (placa_controle = pvp.placa or placa_referencia = pvp.placa)
					   and rownum = 1) as ultima_posicao
			  from (select /*+ ORDERED */
					 pvp.placa,
					 pvp.num_gabarito,
					 pvp.num_eixo,
					 pvp.posicao,
					 pvp.cod_posicao,
					 pvp.ordem,
					 pvp.modelo_eixo_id,
					 pvp.caminho_imagem,
					 pvp.veiculo_modelo,
					 /*pvp.tipo_veiculo, */
					 pvp.suspenso,
					 pvp.geminado,
					 (select count(*)
						from (select distinct pvp.placa
								from oper.v$pneu_veiculo_posicao pvp
							   where not exists (select 'x'
										from oper.v$pneu_movimentacao pm
									   where pm.placa = pvp.placa
										 and pm.num_gabarito = pvp.num_gabarito
										 and pm.num_eixo = pvp.num_eixo
										 and pm.posicao = pvp.posicao
										 and pm.data_desmontagem is null)
								 and pvp.empresa = 1
							   group by pvp.placa)) as num_veiculos
					 /* ------------------------------------------------- */,
					 (select max(pmov_id)
						from oper.v$pneu_movimentacao pm
					   where pm.placa = pvp.placa
						 and pm.num_gabarito = pvp.num_gabarito
						 and pm.num_eixo = pvp.num_eixo
						 and pm.posicao = pvp.posicao
						 and pm.data_desmontagem =
							 (select max(data_desmontagem)
								from oper.v$pneu_movimentacao pm
							   where pm.placa = pvp.placa
								 and pm.num_gabarito = pvp.num_gabarito
								 and pm.num_eixo = pvp.num_eixo
								 and pm.posicao = pvp.posicao)) as pmov_id
					/* ------------------------------------------------- */
					  from oper.v$pneu_veiculo_posicao pvp
                      where not exists (select 'x'
                                          from oper.v$pneu_movimentacao pm
                                         where pm.placa = pvp.placa
                                           and pm.num_gabarito = pvp.num_gabarito
                                           and pm.num_eixo = pvp.num_eixo
                                           and pm.posicao = pvp.posicao
                                           and pm.data_desmontagem is null
                                       )
                        and pvp.empresa = 1 
                        and exists (select 1
                                      from oper.v$veiculo_hist_situacao_atual vhsa
                                     where vhsa.placa = pvp.placa
                                       and vhsa.situacao_id = 1
                                   )
                        and exists (select 1
                                      from oper.v$veiculo_modalidade_atual vma
                                     where vma.placa = pvp.placa
                                       and vma.modalidade <> 'TERCEIRO'
                                   )
					 order by pvp.placa, num_eixo, ordem) pvp
			  left join oper.v$pneu_movimentacao pmv 
					 on pmv.pmov_id = pvp.pmov_id
			  left join oper.v$pneu_laudo_desmontagem pld
					 on pld.LAUDO_ID = pmv.laudo_desmontagem_id
		</cfquery>
		<cfreturn qr_posicoes_vagas>
	</cffunction>
	
	
	<!--- 
	-- PROPSITO 
	-- Busca os reformadores
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 13/02/2006
	--->
	<cffunction name="get_proprietario_pneu" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select distinct pp.cod_pessoa, p.cliente as nome
			  from oper.v$pneu_proprietario pp
			 inner join kss.v$pessoa p
					 on p.cod_pessoa = pp.cod_pessoa
			 where pp.data_fim is null	
			 order by p.cliente
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os pneus que tiveram reformas recusadas
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_reformas_recusadas" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="marca_id" required="no" default="">
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="borracha_id" required="no" default="">
		<cfargument name="medida_id" required="no" default="">
		<cfargument name="reformas_1" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.pneu_id,a.num_pneu,a.marca_id,a.marca,a.modelo_id,a.modelo,a.conserto_id,a.reformador,a.data_envio_reforma,a.data_retorno_reforma,a.medida_id,a.
				   medida,a.borracha_id,a.borracha,a.situacao_id,a.situacao,a.reformas,a.reforma_recusada,a.total_reformas,a.total_reformas_recusadas, 
				   round((a.total_reformas_recusadas * 100 ) /a.total_reformas,2) as percentual
			  from 
			   (select pd.pneu_id,
					   pd.num_pneu,
					   pd.marca_id,
					   pd.marca,
					   pd.modelo_id,
					   pd.modelo,
					   prr.conserto_id,
					   p.cliente as reformador,
					   prr.data_envio_reforma,
					   prr.data_retorno_reforma,
					   pd.medida_id,
					   pd.medida,
					   prr.BORRACHA_ID,
					   pb.DESCRICAO as borracha,
					   pd.situacao_id,
					   pd.situacao,
					   decode(pd.reformas,0,'Novo',1,'1 reforma',pd.reformas||' reformas') as reformas,
					   prr.reforma_recusada,
					   count(*) over(partition by prr.cod_pessoa_reformador order by prr.cod_pessoa_reformador) as total_reformas,
					   sum(case when prr.reforma_recusada = 1 then 1 else 0 end) over(partition by prr.cod_pessoa_reformador order by prr.cod_pessoa_reformador) as total_reformas_recusadas
				  from oper.v$pneu_dados pd
				 inner join oper.v$pneu_reforma_completo prr
						 on pd.pneu_id = prr.pneu_id
				 inner join oper.v$pneu_borracha pb
						 on pb.borracha_id = prr.borracha_id 
				 inner join kss.v$pessoa p
						 on p.cod_pessoa = prr.cod_pessoa_reformador
				 where 1=1
				 <cfif len(trim(arguments.data_inicial))>
				   and trunc(prr.data_envio_reforma) >= '#arguments.data_inicial#'
				 </cfif>
				 <cfif len(trim(arguments.data_final))>
				   and trunc(prr.data_envio_reforma) <= '#arguments.data_final#'
				 </cfif>
				 <cfif len(trim(arguments.marca_id))>
				   and pd.marca_id in (#arguments.marca_id#)   
				 </cfif>
				 <cfif len(trim(arguments.modelo_id))>
				   and pd.modelo_id in (#arguments.modelo_id#)
				 </cfif>
				 <cfif len(trim(arguments.medida_id))>
				   and pd.medida_id in (#arguments.medida_id#)
				 </cfif>
				 <cfif len(trim(arguments.borracha_id))>
				   and prr.borracha_id in (#arguments.borracha_id#)
				 </cfif>
				 <cfif len(trim(arguments.reformas_1))>
					   and pd.reformas = #arguments.reformas_1#
				 </cfif>
				 order by pd.num_pneu) a
			where a.reforma_recusada = 1
				order by a.reformador
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>   
   			
	<!--- 
	-- PROPSITO 
	-- Busca os reformadores
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 18/01/2006
	--->
	<cffunction name="get_reformadores" returntype="query" access="remote">
		<cfargument name="cod_pessoa_reformador" required="no">
		<cfargument name="borracha_id" required="no" default="">
		<cfargument name="sem_imagem" required="no" default="0">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select pj.cliente as nome_fantasia, 
				   prb.cod_pessoa as cod_pessoa_reformador, 
                   prb.reformador_id,
				   pb.borracha_id, 
				   pb.descricao as borracha
					<cfif arguments.sem_imagem eq 0>
						,pb.imagem
					</cfif>
			  from oper.v$pneu_reformador_bandeira prb
			 inner join oper.v$pneu_borracha pb
					 on pb.borracha_id = prb.borracha_id
			 inner join kss.v$pessoa pj
					 on pj.cod_pessoa = prb.cod_pessoa
			 where 1=1
			   <cfif IsDefined("arguments.cod_pessoa_reformador")>
			   and prb.cod_pessoa = #arguments.cod_pessoa_reformador#
			   </cfif>
			   <cfif len(trim(arguments.borracha_id))>
			   and pb.borracha_id = #arguments.borracha_id#
			   </cfif>
			order by pj.cliente		 
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	
    
	<!--- 
	-- PROPSITO 
	-- Busca todos os pneus cadastrados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_relacao_pneus" returntype="query" access="remote">
		<cfargument name="sulco" required="no">
		<cfargument name="sulco_final" required="no">
		<cfargument name="situacao_id" required="no">
		<cfargument name="medida_id" required="no">
		<cfargument name="medida_roda_id" required="no">
		<cfargument name="modelo_id" required="no">
		<cfargument name="eixo" required="no">
		<cfargument name="cod_pessoa_filial" required="no">
		<cfargument name="operador" required="no">
		<cfargument name="reformas" required="no" default="">
		<cfargument name="borracha_id" required="yes">
		<cfargument name="desenho_id" required="yes">
		<cfargument name="proprietario" required="no" default="">
		<cfargument name="formato_borracha" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_desenhos" username="#session.usuario#" password="#session.senha#" timeout="300">
			select pneu_id,
				   num_pneu,
				   modelo_id,
				   decode(reformas, 0, 'Novo', 'Reforma ' || reformas) as reformas,
				   reformas as nro_reformas,
				   marca,
				   modelo,
				   medida,
				   medida_roda,
				   sulco,
				   oper.pkg_veiculo.fnc_get_cod_veiculo(placa) as placa,
				   posicao,
				   borracha,
				   desenho,
				   filial,
				   cod_pessoa,
				   zero_km,
				   formato_borracha,
				   cliente,
                   centro_custo,
       			   cod_pessoa_proprietario
				   
			  from (select /*+ USE_HASH(PVP R) */ r.pneu_id,
						   r.num_pneu,
						   r.modelo_id,
						   r.reformas,
						   r.marca,
						   r.modelo,
						   r.medida,
						   r.medida_roda,
						   r.medida_roda_id,
						   r.medida_id,
						   r.num_eixo,
						   r.num_gabarito,
						   r.sulco,
						   r.placa,
						   r.posicao,
						   r.borracha,
						   r.desenho,
						   r.filial,
                           r.centro_custo,
						   r.situacao_id,
						   r.cod_pessoa,
						   r.borracha_id,
						   r.desenho_id,
						   r.zero_km,
						   pvp.prefixo as eixo,
						   formato_borracha,
						   r.cliente,
               			   r.cod_pessoa_proprietario
					  from oper.v$pneu_veiculo_posicao pvp 
					  right join (select pd.pneu_id,
								   pd.num_pneu,
								   pd.modelo_id,
								   pd.reformas,
								   pd.marca,
								   pd.modelo,
								   pd.medida,
								   pd.medida_roda,
								   pd.medida_roda_id,
								   pm.num_gabarito,
								   pm.num_eixo,
								   pd.medida_id,
								   case
									 when p.sulco < 0 then
									  0
									 when p.sulco is null then
									  oper.pkg_pneu.fnc_sulco_atual(pd.pneu_id)
									 else
									  p.sulco
								   end sulco,
								   nvl(pm.placa, pm2.placa) as placa,
								   nvl(pm.posicao, pm2.posicao) as posicao,
								   null as borracha,
								   null as desenho,
								   (select cliente
									  from kss.v$pessoa
									 where cod_pessoa = pl.cod_pessoa) as filial,
                                   (select centro_custo
                                      from kss.v$centro_custo cc
                                     where cc.cod_centro_custo = pl.COD_CENTRO_CUSTO) as centro_custo,
								   pd.situacao_id,
								   pl.cod_pessoa,
								   null as borracha_id,
								   null as desenho_id,
								   case
									 when not exists (select 'x'
											 from oper.v$pneu_movimentacao pm4
											where pm4.pneu_id = pd.pneu_id) then
									  1
									 else
									  0
								   end as zero_km,
								   pd.formato_borracha,
								   ps.cliente,
                       			   pp.cod_pessoa as cod_pessoa_proprietario
							  from oper.v$pneu_dados pd
							  
							  left join oper.v$pneu_localizacao_atual pl on pd.pneu_id =
																			pl.pneu_id
																		and pl.data_saida is null
							  left join oper.v$pneu_sulco_estimado p on p.pneu_id =
																	  pd.pneu_id
							  left join oper.v$pneu_movimentacao pm on pm.pneu_id =
																	   pd.pneu_id
																   and pm.data_desmontagem is null
							  left join oper.v$pneu_movimentacao pm2 on pm2.pneu_id =
																		pm.pneu_id
																	and pm2.data_desmontagem is not null
							  																		
							  left join oper.v$pneu_proprietario pp on pp.pneu_id = pd.pneu_id
                 			  left join kss.v$pessoa ps on ps.cod_pessoa = pp.cod_pessoa 
							 where pd.reformas = 0
							 and pp.data_fim is null
				<cfif arguments.situacao_id neq 2>
							   and not exists (select 'x'
											  from oper.v$pneu_movimentacao pm3
											 where pm3.pneu_id = p.pneu_id
											   and pm3.data_desmontagem is null)
				</cfif>
			 <cfif IsDefined("arguments.situacao_id") and Len(Trim(arguments.situacao_id))>
				<cfif arguments.situacao_id eq 2>
					and pd.situacao_id = 2
				<cfelseif arguments.situacao_id eq 1>
					and pd.situacao_id = 1
				</cfif>
			 <cfelse>
				   and pd.situacao_id in (1, 2, 3, 4, 5, 6, 8, 9, 10)
			 </cfif> 	
							   ) r
					  on pvp.placa = r.placa
															   and pvp.num_gabarito =
																   r.num_gabarito
															   and pvp.num_eixo =
																   r.num_eixo
															   and pvp.posicao =
																   r.posicao
					union
					select /*+ USE_HASH(PVP R) */ r.pneu_id,
						   r.num_pneu,
						   r.modelo_id,
						   r.reformas,
						   r.marca,
						   r.modelo,
						   r.medida,
						   r.medida_roda,
						   r.medida_roda_id,
						   r.medida_id,
						   r.num_eixo,
						   r.num_gabarito,
						   r.sulco,
						   r.placa,
						   r.posicao,
						   r.borracha,
						   r.desenho,
						   r.filial,
                           r.centro_custo,
						   r.situacao_id,
						   r.cod_pessoa,
						   r.borracha_id,
						   r.desenho_id,
						   r.zero_km,
						   pvp.prefixo as eixo,
						   r.formato_borracha,
						   r.cliente,
               			   r.cod_pessoa_proprietario               
					  from oper.v$pneu_veiculo_posicao pvp 
					  right join (select 
							 pd.pneu_id,
							 pd.num_pneu,
							 pd.modelo_id,
							 pd.reformas,
							 pd.marca,
							 pd.modelo,
							 pd.medida,
							 pd.medida_roda,
							 pd.medida_roda_id,
							 pd.medida_id,
							 pm.num_gabarito,
							 pm.num_eixo,
							 case
							   when p.sulco < 0 then
								0
							   when p.sulco is null then
								oper.pkg_pneu.fnc_sulco_atual(pd.pneu_id)
							   else
								p.sulco
							 end sulco,
							 nvl(pm.placa, pm2.placa) as placa,
							 nvl(pm.posicao, pm2.posicao) as posicao,
							 pb.descricao as borracha,
							 d.descricao as desenho,
							 (select cliente
								from kss.v$pessoa
							   where cod_pessoa = pl.cod_pessoa) as filial,
                             (select centro_custo
                                      from kss.v$centro_custo cc
                                     where cc.cod_centro_custo = pl.COD_CENTRO_CUSTO) as centro_custo,
							 pd.situacao_id,
							 pl.cod_pessoa,
							 pb.borracha_id as borracha_id,
							 d.desenho_id as desenho_id,
							 case
							   when not exists
								(select 'x'
									   from oper.v$pneu_movimentacao pm4
									  where pm4.pneu_id = pd.pneu_id
										and pm4.data_montagem > pr.data_retorno_reforma) then
								1
							   else
								0
							 end as zero_km,
							 pd.formato_borracha,
							 ps.cliente,
                 			 pp.cod_pessoa as cod_pessoa_proprietario
							  from oper.v$pneu_dados pd
							  
							 inner join oper.v$pneu_reforma pr on pr.pneu_id = pd.pneu_id
															  and pr.conserto = 0
							 inner join oper.v$pneu_borracha pb on pb.borracha_id =
																   pr.borracha_id
							 inner join oper.v$pneu_desenho d on d.borracha_id =
																 pr.borracha_id
															 and d.desenho_id =
																 pr.desenho_id
							  left join oper.v$pneu_localizacao_atual pl on pd.pneu_id =
																			pl.pneu_id
																		and pl.data_saida is null
							  left join oper.v$pneu_sulco_estimado p on p.pneu_id =
																	  pd.pneu_id
							  left join oper.v$pneu_movimentacao pm on pm.pneu_id =
																	   pd.pneu_id
																   and pm.data_desmontagem is null
							  left join oper.v$pneu_movimentacao pm2 on pm2.pneu_id =
																		pm.pneu_id
																	and pm2.data_desmontagem is not null
							  left join oper.v$pneu_proprietario pp on pp.pneu_id = pd.pneu_id
                  			 left join kss.v$pessoa ps on ps.cod_pessoa = pp.cod_pessoa
							 where pd.reformas > 0
							 and pp.data_fim is null
				<cfif arguments.situacao_id neq 2>
							   and not exists
							 (select 'x'
									  from oper.v$pneu_movimentacao pm3
									 where pm3.pneu_id = p.pneu_id
									   and pm3.data_desmontagem is null) 
				</cfif>
							   and pr.data_retorno_reforma =
								   (select max(pr2.data_retorno_reforma)
									  from oper.v$pneu_reforma pr2
									 where pr2.pneu_id = pr.pneu_id
									   and pr2.conserto = 0)
			 <cfif IsDefined("arguments.situacao_id") and Len(Trim(arguments.situacao_id))>
				<cfif arguments.situacao_id eq 2>
					and pd.situacao_id = 2
				<cfelseif arguments.situacao_id eq 1>
					and pd.situacao_id = 1
				</cfif>
			 <cfelse>
				   and pd.situacao_id in (1, 2, 3, 4, 5, 6, 8, 9, 10)
			 </cfif> 									   
							   ) r
					   on pvp.placa = r.placa
															   and pvp.num_gabarito =
																   r.num_gabarito
															   and pvp.num_eixo =
																   r.num_eixo
															   and pvp.posicao =
																   r.posicao)
			 where 1 = 1	
			 <cfif arguments.operador eq 'BETWEEN'>
			   and sulco between #arguments.sulco# and #arguments.sulco_final#
			 <cfelse>
			   and sulco #arguments.operador# #arguments.sulco# 
			 </cfif>
			 <cfif IsDefined("arguments.cod_pessoa_filial") and Len(Trim(arguments.cod_pessoa_filial))>
			   and cod_pessoa = #arguments.cod_pessoa_filial#
			 </cfif>
			 <cfif IsDefined("arguments.medida_id") and Len(Trim(arguments.medida_id))>
			   and medida_id = #arguments.medida_id#
			 </cfif>
			 <cfif IsDefined("arguments.medida_roda_id") and Len(Trim(arguments.medida_roda_id))>
			   and medida_roda_id = #arguments.medida_roda_id#
			 </cfif>
			 <cfif IsDefined("arguments.eixo") and Len(Trim(arguments.eixo))>
			   and eixo = '#arguments.eixo#'
			 </cfif>
			 <cfif IsDefined("arguments.modelo_id") and Len(Trim(arguments.modelo_id))>
			   and modelo_id in (#arguments.modelo_id#)
			 </cfif>
			 <cfif IsDefined("arguments.reformas") and Len(Trim(arguments.reformas))>
			   and reformas in (#arguments.reformas#)
			 </cfif>
			 <cfif IsDefined("arguments.situacao_id") and Len(Trim(arguments.situacao_id))>
				<cfif arguments.situacao_id eq 2>
					and situacao_id = 2
				<cfelseif arguments.situacao_id eq 1>
					and situacao_id = 1
				</cfif>
			 </cfif>  
			 <cfif len(trim(arguments.borracha_id))>
				and borracha_id = #arguments.borracha_id# and reformas > 0
			 </cfif>
			 <cfif len(trim(arguments.proprietario))>
				and cod_pessoa_proprietario in (#arguments.proprietario#)
			 </cfif>
			 <cfif len(trim(arguments.desenho_id))>
				and desenho_id = #arguments.desenho_id# and reformas > 0
			 </cfif>
			 <cfif len(trim(arguments.formato_borracha))>
			    and formato_borracha = '#arguments.formato_borracha#'
			 </cfif>
			 order by cod_pessoa_proprietario, reformas, marca, num_pneu, modelo, medida, medida_roda, sulco 
		</cfquery>

		<cfreturn qr_desenhos>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca o rendimento dos pneus do veiculo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 01/02/2006
	--->
	<cffunction name="get_rendimento" returntype="query" access="remote" output="true">
		<cfargument name="cod_veiculo" required="no">
		<cfset qr_veiculo.COMPOSICAO = this.get_composicao(placa = '#this.get_placa(arguments.cod_veiculo)#', sem_aspas = true)>
		<cfquery datasource="#session.dsn#" name="qr_rendimento" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select /*+ RULE */  num_pneu, modelo, marca, borracha, desenho, pmov_id, num_gabarito, num_eixo, caminho_imagem, posicao,
					   oper.pkg_veiculo.fnc_get_cod_veiculo(placa) as placa, pneu_id, data_montagem, km_montagem, eixo_posicao, posicao_gabarito, ordem, veiculo_modelo,
					   suspenso, modelo_eixo_id, tipo_carroceria_id, mm_montagem, km_rodado, mm_estimado, rendimento, mm_gastos,
					   peso_tracionado, peso_tracionado_familia, dias_ult_inspecao, reformas, '' as tipo_veiculo,
					  case 
						 when mm_estimado <= 0 then 'SP'
					  else  to_char(round(km_rodado / decode((mm_montagem - mm_estimado),0,1,(mm_montagem - mm_estimado)))) end rendimento_pneu
			  from (
							select num_pneu, modelo, marca, borracha , desenho,  pmov_id, num_gabarito, num_eixo, caminho_imagem, posicao, placa, 
								   pneu_id, data_montagem, km_montagem, eixo_posicao, posicao_gabarito, ordem, 
								   veiculo_modelo, suspenso, modelo_eixo_id, tipo_carroceria_id, mm_montagem,
									oper.pkg_pneu.fnc_km_rodado(placa,data_montagem,suspenso) as km_rodado,		
								   decode(oper.pkg_pneu.fnc_rendimento_pneu(pneu_id,modelo_eixo_id, num_eixo, tipo_carroceria_id), 0, -1,
								   round(mm_montagem - ((oper.pkg_pneu.fnc_km_atual(placa) - decode(suspenso,0,0,oper.pkg_pneu.fnc_km_vazio(placa, data_montagem, sysdate)) - km_montagem) / 
								   oper.pkg_pneu.fnc_rendimento_pneu(pneu_id, modelo_eixo_id, num_eixo, tipo_carroceria_id)), 1)) as mm_estimado,
								   oper.pkg_pneu.fnc_rendimento_pneu(pneu_id,modelo_eixo_id, num_eixo, tipo_carroceria_id) as rendimento, 
								   oper.pkg_pneu.fnc_rendimento_pneu_mm(pneu_id,modelo_eixo_id, num_eixo, tipo_carroceria_id) as mm_gastos, 
								   oper.pkg_pneu.fnc_peso_medio_tracionado(pneu_id) as peso_tracionado, 
								   oper.pkg_pneu.fnc_peso_medio_tracionado(pneu_id, modelo_eixo_id, num_eixo, tipo_carroceria_id) as peso_tracionado_familia, 
								   trunc(sysdate - oper.pkg_pneu.fnc_ultima_inspecao(pneu_id)) as dias_ult_inspecao, reformas
							  from (select num_pneu, modelo, marca, borracha , desenho,  pmov_id, num_gabarito, num_eixo, caminho_imagem, posicao, placa, 
												   pneu_id, data_montagem, km_montagem, eixo_posicao, posicao_gabarito, ordem, 
												   veiculo_modelo, suspenso, modelo_eixo_id, tipo_carroceria_id, 
										   mm_montagem, reformas
									  from oper.v$pneu_veiculo_gabarito
									 where instr('#qr_veiculo.COMPOSICAO#',placa) > 0)
								     order by instr('#qr_veiculo.COMPOSICAO#',placa), num_eixo, ordem) 
		</cfquery>
		<cfreturn qr_rendimento>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca o rendimento sintetico
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_rendimento_sintetico" returntype="query" access="remote">
		<cfargument name="reformas" required="no">
		<cfargument name="tipo_veiculo_id" required="no">
		<cfargument name="perc_consumido" required="no">
		<cfargument name="considera_peso" required="no">
		<cfquery datasource="#session.dsn#" name="qr_rendimento" username="#session.usuario#" password="#session.senha#">
			select a.marca_borracha || '-' || medida as marca_borracha,  
				   <cfif IsDefined("arguments.considera_peso") and arguments.considera_peso eq 1>
					   round(decode(a.peso_tracionado,1,a.rendimento, a.rendimento * (a.peso_tracionado/b.max_peso))) as rendimento,
				   <cfelse>
					   a.rendimento,
				   </cfif>
				   a.peso_tracionado,b.max_peso, mm_consumido,
				   case 
					  when eixo = 'D' then 1
					  when eixo = 'T' then 2
					  when eixo = 'R' then 3
					  when eixo = '1' then 4
					  when eixo = '2' then 5 
					  when eixo = '3' then 6
				   end ordem,
				   case 
					  when eixo = 'D' then 'eixo Dianteiro'
					  when eixo = 'T' then 'eixo Tracao'
					  when eixo = 'R' then 'eixo Truck'
					  when eixo = '1' then 'Primeiro eixo'
					  when eixo = '2' then 'Segundo eixo'
					  when eixo = '3' then 'Terceiro eixo'
				   end eixo				   
			  from (select eixo, marca_borracha, medida, round(km_percorrido/mm_consumido) as rendimento, 
						   round(decode(eixo,'T',peso_tracionado,1)) as peso_tracionado, mm_consumido
					  from (select eixo,  decode(r.reformas, 0, marca, borracha) as marca_borracha,r.medida,
								   sum(mm_consumido) as mm_consumido, sum(km_percorrido) as km_percorrido,
								   avg(peso_tracionado) as peso_tracionado
									  from oper.v$pneu_rendimento r
								 where 1=1
								  <cfif IsDefined("arguments.reformas") and Len(Trim(arguments.reformas))>
									  and reformas in (#arguments.reformas#)
								  </cfif>
								  <cfif IsDefined("arguments.tipo_veiculo_id") and Len(Trim(arguments.tipo_veiculo_id))>
									  and tipo_veiculo_id in (#arguments.tipo_veiculo_id#)
								  </cfif>
								  <cfif IsDefined("arguments.perc_consumido") and Len(Trim(arguments.perc_consumido))>
								     and r.perc_consumido >= #arguments.perc_consumido#
								  </cfif>
									 group by eixo, decode(r.reformas, 0,  marca, borracha), r.medida
									 order by eixo,  decode(r.reformas, 0,marca, borracha)
								 )) a,
					(select max(round(decode(eixo,'T',peso_tracionado,1))) as max_peso
					  from (select eixo, decode(r.reformas, 0, marca || ' / ' || modelo, borracha) as marca_borracha,r.medida,	
								   sum(mm_consumido) as mm_consumido, sum(km_percorrido) as km_percorrido,
								   avg(peso_tracionado) as peso_tracionado
							  from oper.v$pneu_rendimento r
								 where 1=1
								  <cfif IsDefined("arguments.reformas") and Len(Trim(arguments.reformas))>
									  and reformas in (#arguments.reformas#)
								  </cfif>
								  <cfif IsDefined("arguments.tipo_veiculo_id") and Len(Trim(arguments.tipo_veiculo_id))>
									  and tipo_veiculo_id in (#arguments.tipo_veiculo_id#)
								  </cfif>
									 group by eixo, decode(r.reformas, 0, marca || ' / ' || modelo, borracha), r.medida
									 order by eixo, decode(r.reformas, 0, marca || ' / ' || modelo, borracha)
								 )) b
				where a.mm_consumido > 50
				  order by ordem 
		</cfquery>			
		<cfreturn qr_rendimento>				 
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca o rendimento sintetico parcial
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_rendimento_sintetico_parcial" returntype="query" access="remote">
		<cfargument name="reformas" required="no">
		<cfargument name="tipo_carroceria_id" required="no">
		<cfargument name="considera_peso" required="no">
		<cfargument name="mm_ate" required="yes">
		<cfargument name="perc_consumido" required="no">
		<cfquery datasource="#session.dsn#" name="qr_rendimento" username="#session.usuario#" password="#session.senha#">
		  <cfif IsDefined("arguments.reformas") and ((ListLen(arguments.reformas) gte 1 and ListFind(arguments.reformas,'0')) or not Len(Trim(arguments.reformas)))>
				select marca || '-' || medida as marca_borracha,  max_peso, peso_tracionado,
						   case 
							  when eixo = 'D' then 1
							  when eixo = 'T' then 2
							  when eixo = 'R' then 3
							  when eixo = '1' then 4
							  when eixo = '2' then 5 
							  when eixo = '3' then 6
						   end ordem,
						   case 
							  when eixo = 'D' then 'eixo Dianteiro'
							  when eixo = 'T' then 'eixo Tracao'
							  when eixo = 'R' then 'eixo Truck'
							  when eixo = '1' then 'Primeiro eixo'
							  when eixo = '2' then 'Segundo eixo'
							  when eixo = '3' then 'Terceiro eixo'
						   end eixo, 
						   <cfif IsDefined("arguments.considera_peso") and arguments.considera_peso eq 1>
							   round(decode(peso_tracionado,1,round(km / decode(mm,0,1,mm)), round(km / decode(mm,0,1,mm)) * (peso_tracionado/max_peso))) as rendimento,
						   <cfelse>
							   round(km / decode(mm,0,1,mm)) as rendimento,
						   </cfif>
					   mm as mm_consumido
				  from (select max_peso, peso_tracionado, marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, marca, modelo, data_inspecao,
							   mm, mm_proximo, km, reformas, eixo, 
							   row_number() over (partition by marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, reformas order by data_inspecao, km) rank
						  from (select max_peso, peso_tracionado, marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, marca, modelo, data_inspecao, reformas, eixo,
									   mm, mm_proximo, km,
									   last_value(mm) over (partition by marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, reformas) maior
								 from (select max(round(decode(eixo,'T',peso_tracionado,1))) over() as max_peso, round(decode(eixo,'T',peso_tracionado,1)) as peso_tracionado, marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, r.marca, r.modelo, r.data_inspecao, reformas, eixo,
											  sum(r.mm_consumido) 
												  over (partition by r.marca_id, r.modelo_id, r.medida, tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc 
														rows unbounded preceding ) mm,
											  sum(r.mm_consumido) 
												  over (partition by r.marca_id, r.modelo_id, r.medida,tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc 
														rows between unbounded preceding and 1 following) mm_proximo,
											  sum(r.km_percorrido) 
												  over (partition by r.marca_id, r.modelo_id, r.medida, tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc rows unbounded preceding) km
										 from oper.v$pneu_rendimento r
										where reformas = 0
										<cfif IsDefined("arguments.tipo_carroceria_id") and Len(Trim(arguments.tipo_carroceria_id))>
										  and tipo_carroceria_id in (#arguments.tipo_carroceria_id#)
										</cfif>                         
										<cfif IsDefined("arguments.perc_consumido") and Len(Trim(arguments.perc_consumido))>
											 and r.perc_consumido >= #arguments.perc_consumido#
										</cfif>
										 ))
						 where #arguments.mm_ate# between mm and mm_proximo
							or maior < #arguments.mm_ate#) 
				   where rank =1 
				     and mm > 50
			   <cfif IsDefined("arguments.reformas") and (ListLen(arguments.reformas) gt 1 or not Len(Trim(arguments.reformas)))>
				   union 
			   </cfif>
			</cfif>
		   
		   <cfif IsDefined("arguments.reformas") and (ListLen(arguments.reformas) gt 1 or not Len(Trim(arguments.reformas)))>

				select marca || '-' || medida as marca_borracha,  max_peso, peso_tracionado,
						   case 
							  when eixo = 'D' then 1
							  when eixo = 'T' then 2
							  when eixo = 'R' then 3
							  when eixo = '1' then 4
							  when eixo = '2' then 5 
							  when eixo = '3' then 6
						   end ordem,
						   case 
							  when eixo = 'D' then 'eixo Dianteiro'
							  when eixo = 'T' then 'eixo Tracao'
							  when eixo = 'R' then 'eixo Truck'
							  when eixo = '1' then 'Primeiro eixo'
							  when eixo = '2' then 'Segundo eixo'
							  when eixo = '3' then 'Terceiro eixo'
						   end eixo, 
						   <cfif IsDefined("arguments.considera_peso") and arguments.considera_peso eq 1>
							   round(decode(peso_tracionado,1,round(km / decode(mm,0,1,mm)), round(km / decode(mm,0,1,mm)) * (peso_tracionado/max_peso))) as rendimento,
						   <cfelse>
							   round(km / decode(mm,0,1,mm)) as rendimento,
						   </cfif>
					   mm as mm_consumido
				  from (select max_peso, peso_tracionado, marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, marca, modelo, data_inspecao,
							   mm, mm_proximo, km, reformas, eixo, 
							   row_number() over (partition by marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, reformas order by data_inspecao, km) rank
						  from (select max_peso, peso_tracionado, marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, marca, modelo, data_inspecao, reformas, eixo,
									   mm, mm_proximo, km,
									   last_value(mm) over (partition by marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, reformas) maior
								 from (select max(round(decode(eixo,'T',peso_tracionado,1))) over() as max_peso, round(decode(eixo,'T',peso_tracionado,1)) as peso_tracionado, 
								 			  borracha_id as marca_id, desenho_id as modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, 
											  r.borracha as marca, r.desenho as modelo, r.data_inspecao, reformas, eixo,
											  sum(r.mm_consumido) 
												  over (partition by r.borracha_id, r.desenho_id, r.medida, tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc 
														rows unbounded preceding ) mm,
											  sum(r.mm_consumido) 
												  over (partition by r.borracha_id, r.desenho_id, r.medida,tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc 
														rows between unbounded preceding and 1 following) mm_proximo,
											  sum(r.km_percorrido) 
												  over (partition by r.borracha_id, r.desenho_id, r.medida, tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc rows unbounded preceding) km
										 from oper.v$pneu_rendimento r
										where 1=1
										<cfif Len(Trim(arguments.reformas))>
										  and reformas in (#arguments.reformas#)
										<cfelse>  
										  and reformas > 0
										</cfif>
										<cfif IsDefined("arguments.tipo_veiculo_id") and Len(Trim(arguments.tipo_veiculo_id))>
										   and tipo_veiculo_id in (#arguments.tipo_veiculo_id#)
										</cfif>   
										<cfif IsDefined("arguments.perc_consumido") and Len(Trim(arguments.perc_consumido))>
											 and r.perc_consumido >= #arguments.perc_consumido#
										</cfif>										                      
										 ))
						 where #arguments.mm_ate# between mm and mm_proximo
							or maior < #arguments.mm_ate#) 
				   where rank =1 
				     and mm > 50				   
			  </cfif>
				  order by ordem, 1
		</cfquery>			
		<cfreturn qr_rendimento>				 
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca todas as borrachas para a montagem do relatorio de borrachas
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 31/01/2006
	--->
	<cffunction name="get_resumo_borracha" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qr_borrachas" username="#session.usuario#" password="#session.senha#">
			select borracha, quantidade, pb.borracha_id, pb.imagem
			  from (select pb.descricao as borracha, count(*) as quantidade, pb.borracha_id
						  from oper.v$pneu_dados p
						 inner join oper.v$pneu_reforma pr
								on pr.pneu_id = p.pneu_id
							   and pr.conserto = 0
						inner join oper.v$pneu_borracha pb
								on pb.borracha_id = pr.borracha_id
						inner join oper.v$pneu_desenho pd
								on pd.borracha_id = pr.borracha_id
							   and pd.desenho_id = pr.desenho_id		
					where p.situacao_id in (1,2,3,4,5,6,8,9,10)
					   and pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
														from oper.v$pneu_reforma pr2
													   where pr2.pneu_id = pr.pneu_id
														 and pr2.conserto = 0)
					group by pb.descricao, pb.borracha_id
					order by 2 desc) a
			 inner join oper.v$pneu_borracha pb 
					 on pb.borracha_id = a.borracha_id
		</cfquery>
		<cfreturn qr_borrachas>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca todas os desenhos para a montagem do relatorio de desenhos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 31/01/2006
	--->
	<cffunction name="get_resumo_desenho" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qr_desenhos" username="#session.usuario#" password="#session.senha#">
			select pb.descricao as borracha, pd.descricao as desenho, count(*) as quantidade
			  from oper.v$pneu_dados p
			 inner join oper.v$pneu_reforma pr
			        on pr.pneu_id = p.pneu_id
				   and pr.conserto = 0
			inner join oper.v$pneu_borracha pb
					on pb.borracha_id = pr.borracha_id
			inner join oper.v$pneu_desenho pd
					on pd.borracha_id = pr.borracha_id
				   and pd.desenho_id = pr.desenho_id		
 				 where p.situacao_id in (1,2,3,4,5,6,8,9,10)
				   and pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
													from oper.v$pneu_reforma pr2
												   where pr2.pneu_id = pr.pneu_id
													 and pr2.conserto = 0)
			    group by pb.descricao, pd.descricao
			order by 3 desc
		</cfquery>
		<cfreturn qr_desenhos>
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca Resumo de situacao dos pneus
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_resumo_detalhes" returntype="query" access="remote">
	    <cfargument name="situacao_id" required="yes">
		<cfargument name="localidade" required="no" default="">
		<cfif arguments.situacao_id eq 1>
			<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select pl.cod_pessoa, pj.cliente as nome_fantasia, count(*) as num_pneus,    
					   (select count(*)
						  from oper.v$pneu_dados p2
						 inner join oper.v$pneu_localizacao_atual pl2
								 on pl2.pneu_id = p2.pneu_id
								and p2.situacao_id = 1
								and p2.reformas = 0
						 where pl2.cod_pessoa = pl.cod_pessoa) as novos,
					   (select count(*)
						  from oper.v$pneu_dados p2
						 inner join oper.v$pneu_localizacao_atual pl2
								 on pl2.pneu_id = p2.pneu_id
								and p2.situacao_id = 1
								and p2.reformas > 0
						 where pl2.cod_pessoa = pl.cod_pessoa) as reformados         
				  from oper.v$pneu_dados p
				 inner join oper.v$pneu_localizacao_atual pl
						 on pl.pneu_id = p.pneu_id
						and p.situacao_id = 1
				 inner join kss.v$pessoa pj
						 on pj.cod_pessoa = pl.cod_pessoa
				 group by pl.cod_pessoa, pj.cliente
   			</cfquery>		
			<cfreturn qrPneus>
		</cfif>		
		
		<cfif arguments.situacao_id eq 3>
			<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select p.pneu_id, p.num_pneu, p.marca, p.modelo, pjo.cliente as origem, pjd.cliente as destino, plr.data_previsao_chegada, plr.user_insert as usuario
				  from oper.v$pneu_dados p
				 inner join oper.v$pneu_localizacao ple
						 on ple.pneu_id = p.pneu_id
						and ple.data_entrada is not null              
						and ple.data_saida is null
				 inner join oper.v$pneu_localizacao plr
						 on plr.pneu_id = p.pneu_id
						and plr.data_entrada is null
				 inner join kss.v$pessoa pjo
						 on pjo.cod_pessoa = ple.cod_pessoa
				 inner join kss.v$pessoa pjd
						 on pjd.cod_pessoa = plr.cod_pessoa
				 where situacao_id = 3  
				 order by pjo.cliente, pjd.cliente, p.num_pneu    
			</cfquery>		
			<cfreturn qrPneus>
		</cfif>

		<cfif arguments.situacao_id eq 6>
			<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select pd.pneu_id, pd.medida,pd.num_pneu, pd.marca, pd.modelo, ps.DATA_SUCATEAMENTO, ps.observacao,
                       ps.user_insert as usuario, oper.pkg_pneu.FNC_SULCO_ATUAL(pd.pneu_id) as sulco_atual, 
                       pd.reformas,
                       case
                         when pd.reformas = 0 then oper.pkg_pneu.fnc_km_rodado_pneu(pd.pneu_id)
                       else (select oper.pkg_pneu.fnc_km_rodado_pneu(pd.pneu_id, pd.data_aquisicao, pr.data_envio_reforma)
                               from oper.v$pneu_dados pd2
                              inner join oper.v$pneu_reforma pr
                                      on pr.pneu_id = pd2.pneu_id
                                     and pr.conserto = 0
                                     and pr.data_envio_reforma = (select min(pr3.data_envio_reforma)
                                                                    from oper.v$pneu_reforma pr3
                                                                   where pr3.pneu_id = pr.pneu_id
                                                                     and pr3.conserto = 0)
                                   where pd2.pneu_id = pd.pneu_id) end km_rodado_novo,
                       case
                         when pd.reformas = 0 then 0
                       else (select oper.pkg_pneu.fnc_km_rodado_pneu(pd.pneu_id, pr.DATA_RETORNO_REFORMA,sysdate)
                               from oper.v$pneu_dados pd2
                              inner join oper.v$pneu_reforma pr
                                      on pr.pneu_id = pd2.pneu_id
                                     and pr.conserto = 0
                                     and pr.data_envio_reforma = (select min(pr3.data_envio_reforma)
                                                                    from oper.v$pneu_reforma pr3
                                                                   where pr3.pneu_id = pr.pneu_id
                                                                     and pr3.conserto = 0)
                                   where pd2.pneu_id = pd.pneu_id) end km_rodado_reformado,
                       oper.pkg_pneu.fnc_km_rodado_pneu(pd.pneu_id) as km_rodado_total
                  from oper.v$pneu_dados pd
                   inner join oper.v$pneu_sucateamento ps
                       on ps.pneu_id = pd.pneu_id
                   where pd.situacao_id = 6
                   order by pd.num_pneu 
   			</cfquery>		
			<cfreturn qrPneus>
		</cfif>

		<cfif arguments.situacao_id eq 7>
			<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				  select p.pneu_id, p.num_pneu, p.marca, p.modelo, ps.observacao, ps.user_insert as usuario
					from oper.v$pneu_dados p
				   inner join oper.v$pneu_sucateamento ps
						   on ps.pneu_id = p.pneu_id
				   where p.situacao_id = 7
				     and ps.data_sucateamento > sysdate - 60
				   order by p.num_pneu	 
				
   			</cfquery>		
			<cfreturn qrPneus>
		</cfif>
		
		<cfif arguments.situacao_id eq 5>
			<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select /*+ FIRST_ROWS*/  pr.conserto_id, p.num_pneu, pr.pneu_id, pr.cod_pessoa_reformador, 
					   pj.cliente as nome_fantasia, pr.data_envio_reforma,
					   p.marca, p.modelo, p.reformas, pr.user_insert as usuario
				  from oper.v$pneu_reforma pr
				 inner join oper.v$pneu_dados p 
						 on p.pneu_id = pr.pneu_id
				 inner join kss.v$pessoa pj
						 on pj.cod_pessoa = pr.cod_pessoa_reformador
				 inner join oper.v$pneu_localizacao_atual pl
						 on pl.pneu_id = pr.pneu_id
						and pl.data_saida is null
				 where pr.data_retorno_reforma is null         
				   and pr.conserto = 1
				   and pl.cod_pessoa = #session.cod_pessoa#
				   order by pj.cliente, pr.data_envio_reforma, p.num_pneu
   			</cfquery>		
			<cfreturn qrPneus>
		</cfif>

		<cfif arguments.situacao_id eq 9>
			<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select p.pneu_id, p.num_pneu, p.marca, p.modelo, p.medida, p.reformas, po.operacao, po.data_ocorrencia, po.usuario
				  from oper.v$pneu_dados p
				 inner join oper.v$pneu_ocorrencia po
						 on po.pneu_id = p.pneu_id
						and po.situacao_id = p.situacao_id
				 where p.situacao_id = 9
				 order by p.num_pneu
   			</cfquery>		
			<cfreturn qrPneus>
		</cfif>		

		<cfif arguments.situacao_id eq 8>
			<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select p.pneu_id, p.num_pneu, p.marca, p.modelo, p.medida, p.reformas, po.operacao, po.data_ocorrencia, po.usuario,
               (select po2.situacao_id
                  from oper.v$pneu_ocorrencia po2
                 where po2.pneu_id = p.pneu_id
                   and po2.data_ocorrencia = (select max(po3.data_ocorrencia)
                                               from oper.v$pneu_ocorrencia po3
                                              where po3.pneu_id = po2.pneu_id
											    and po3.situacao_id <> 3
                                                and po3.data_ocorrencia < po.data_ocorrencia)
					and rownum = 1) as ult_situacao
				  from oper.v$pneu_dados p
				 inner join oper.v$pneu_ocorrencia po
						 on po.pneu_id = p.pneu_id
						and po.situacao_id = p.situacao_id
				 <cfif IsDefined("arguments.localidade") and Len(Trim(arguments.localidade))>
				 inner join oper.v$pneu_localizacao_atual pl
						 on pl.pneu_id = p.pneu_id
				 </cfif>
				 where p.situacao_id = 8
				 <cfif IsDefined("arguments.localidade") and Len(Trim(arguments.localidade))>
				 	and pl.cod_pessoa ='#session.cod_pessoa#'
          			and pl.cod_setor ='#session.cod_setor#'
          			and pl.cod_departamento = '#session.cod_departamento#'
				 </cfif>
				 order by p.num_pneu 
   			</cfquery>		
			<cfreturn qrPneus>
		</cfif>				

		<cfif arguments.situacao_id eq 10>
			<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select /*+ FIRST_ROWS */ pd.pneu_id, pd.num_pneu, pd.marca, pd.medida,
                             pd.modelo, pd.medida_roda, pg.data_envio_analise, pj.cliente as fornecedor, pd.reformas,
                             oper.pkg_pneu.fnc_valor_pneu(pd.pneu_id) as valor_atual,
                             case
                               when pd.reformas = 0 then oper.pkg_pneu.fnc_km_rodado_pneu(pd.pneu_id)
                             else (select oper.pkg_pneu.fnc_km_rodado_pneu(pd.pneu_id<!---, pd.data_aquisicao, pr.data_envio_reforma--->)
                                     from oper.v$pneu_dados pd2
                                    inner join oper.v$pneu_reforma pr
                                            on pr.pneu_id = pd2.pneu_id
                                           and pr.conserto = 0
                                           and pr.data_envio_reforma = (select min(pr3.data_envio_reforma)
                                                                          from oper.v$pneu_reforma pr3
                                                                         where pr3.pneu_id = pr.pneu_id
                                                                           and pr3.conserto = 0)
                                         where pd2.pneu_id = pd.pneu_id) end km_rodado_novo,
                             case
                               when pd.reformas = 0 then 0
                             else (select oper.pkg_pneu.fnc_km_rodado_pneu(pd.pneu_id<!---, pr.DATA_RETORNO_REFORMA,sysdate--->)
                                     from oper.v$pneu_dados pd2
                                    inner join oper.v$pneu_reforma pr
                                            on pr.pneu_id = pd2.pneu_id
                                           and pr.conserto = 0
                                           and pr.data_envio_reforma = (select min(pr3.data_envio_reforma)
                                                                          from oper.v$pneu_reforma pr3
                                                                         where pr3.pneu_id = pr.pneu_id
                                                                           and pr3.conserto = 0)
                                         where pd2.pneu_id = pd.pneu_id) end km_rodado_reformado
                          from oper.v$pneu_dados pd
                         inner join oper.v$pneu_garantia pg
                             on pg.pneu_id = pd.pneu_id
                         inner join kss.v$pessoa pj
                             on pj.cod_pessoa = pg.cod_pessoa_fornecedor
                         where pd.situacao_id = 10
                         order by pd.num_pneu
   			</cfquery>		
			<cfreturn qrPneus>
		</cfif>	  			
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Resumo Geral dos pneus
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_resumo_geral" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qr_marcas" username="#session.usuario#" password="#session.senha#">
			select cod_pessoa
                 , nome_fantasia
                 , situacao
                 , situacao_id
                 , descricao
                 , cliente
                 , cod_centro_custo
                 , centro_custo
                 , novos_0km
                 , novos
                 , reformados_0km
                 , reformados
                 , novos_0km + novos + reformados_0km + reformados as quantidade
              from(
                   select t.cod_pessoa
                        , t.nome_fantasia
                        , t.situacao
                        , t.situacao_id
                        , t.descricao
                        , t.cliente
                        , t.cod_centro_custo
                        , (select centro_custo
                             from kss.v$centro_custo
                            where cod_centro_custo = t.cod_centro_custo) as centro_custo
                        , t.novos_0km
                        , t.novos
                        , t.reformados_0km
                        , t.reformados
                     from (select /*+ PARALLEL */
                                  pl.cod_pessoa
                                , pl.cod_centro_custo
                                , nvl(pj.cliente, 'No identificado') as nome_fantasia
                                , ps.descricao as situacao
                                , p.situacao_id
                                , ps.descricao
                                , pj.cliente
                                , (select count(*)
                                     from oper.v$pneu_dados p2
                                     left join oper.v$pneu_localizacao_atual pl2 
                                       on pl2.pneu_id = p2.pneu_id
                                    where nvl(pl2.cod_pessoa,-1) = nvl(pl.cod_pessoa,-1)
                                      and nvl(pl2.cod_centro_custo,-1) = nvl(pl.cod_centro_custo,-1)
                                      and p2.situacao_id = p.situacao_id
                                      and p2.reformas = 0
                                      and not exists (select 'x'
                                                        from oper.v$pneu_movimentacao pm
                                                       where pm.pneu_id = p2.pneu_id)) as novos_0km
                                , (select count(*)
                                     from oper.v$pneu_dados p2
                                     left join oper.v$pneu_localizacao_atual pl2 
                                       on pl2.pneu_id = p2.pneu_id
                                    where nvl(pl2.cod_pessoa,-1) = nvl(pl.cod_pessoa,-1)
                                      and nvl(pl2.cod_centro_custo,-1) = nvl(pl.cod_centro_custo,-1)
                                      and p2.situacao_id = p.situacao_id
                                      and p2.reformas = 0
                                      and exists (select 'x'
                                                    from oper.v$pneu_movimentacao pm
                                                   where pm.pneu_id = p2.pneu_id)) as novos
                                , (select nvl(sum(b.total_pneus), 0)
                                     from (select /*+ USE_HASH(p2 pl2 pr) */
                                                  count(*) as total_pneus
                                                , pl2.cod_pessoa
                                                , pl2.cod_centro_custo
                                                , p2.situacao_id
                                             from oper.v$pneu_dados p2
                                             left join oper.v$pneu_localizacao_atual pl2
                                               on pl2.pneu_id = p2.pneu_id
                                             left join oper.v$pneu_reforma_completo pr 
                                               on pr.pneu_id = p2.pneu_id
                                              and pr.conserto = 0
                                            where p2.reformas > 0
                                              and (pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
                                                                                from oper.v$pneu_reforma pr2
                                                                               where pr2.pneu_id = pr.pneu_id
                                                                                 and pr2.conserto = 0)
                                                   or (pr.data_envio_reforma = (select max(pr2.data_envio_reforma)
                                                                                  from oper.v$pneu_reforma_completo pr2
                                                                                 where pr2.pneu_id = pr.pneu_id
                                                                                   and pr2.conserto = 0)
                                                       and not exists (select 1
                                                                         from oper.v$pneu_reforma pr2
                                                                        where pr2.pneu_id = pr.pneu_id
                                                                          and pr2.conserto = 0)
                                                      )                       
                                                                                
                                                  )
                                              and not exists (select 'x'
                                                                from oper.v$pneu_movimentacao pm
                                                               where pm.pneu_id = pr.pneu_id
                                                                 and pm.data_montagem > pr.data_retorno_reforma)
                                         group by pl2.cod_pessoa
                                                , pl2.cod_centro_custo
                                                , p2.situacao_id                                    
                                                ) b
                                    where 1 = 1
                                      and nvl(b.cod_pessoa, -1) = nvl(pl.cod_pessoa, -1)
                                      and nvl(b.cod_centro_custo, -1) = nvl(pl.cod_centro_custo, -1)
                                      and b.situacao_id = p.situacao_id
                                      ) as reformados_0km
                                , (select nvl(sum(b.total_pneus), 0)
                                     from (select /*+ USE_HASH(p2 pl2 pr) */
                                                  count(*) as total_pneus
                                                , pl2.cod_pessoa
                                                , pl2.cod_centro_custo
                                                , p2.situacao_id
                                             from oper.v$pneu_dados p2
                                             left join oper.v$pneu_localizacao_atual pl2
                                               on pl2.pneu_id = p2.pneu_id
                                             left join oper.v$pneu_reforma_completo pr 
                                               on pr.pneu_id = p2.pneu_id
                                              and pr.conserto = 0
                                            where p2.reformas > 0
                                              and (pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
                                                                                from oper.v$pneu_reforma pr2
                                                                               where pr2.pneu_id = pr.pneu_id
                                                                                 and pr2.conserto = 0)
                                                   or (pr.data_envio_reforma = (select max(pr2.data_envio_reforma)
                                                                                  from oper.v$pneu_reforma_completo pr2
                                                                                 where pr2.pneu_id = pr.pneu_id
                                                                                   and pr2.conserto = 0)
                                                       and not exists (select 1
                                                                         from oper.v$pneu_reforma pr2
                                                                        where pr2.pneu_id = pr.pneu_id
                                                                          and pr2.conserto = 0)
                                                      )                       
                                                                                
                                                  )
                                              and exists (select 'x'
                                                            from oper.v$pneu_movimentacao pm
                                                           where pm.pneu_id = pr.pneu_id
                                                             and pm.data_montagem > pr.data_retorno_reforma)
                                         group by pl2.cod_pessoa
                                                , pl2.cod_centro_custo
                                                , p2.situacao_id                                    
                                                ) b
                                    where 1 = 1
                                      and nvl(b.cod_pessoa, -1) = nvl(pl.cod_pessoa, -1)
                                      and nvl(b.cod_centro_custo, -1) = nvl(pl.cod_centro_custo, -1)
                                      and b.situacao_id = p.situacao_id) as reformados
                             from oper.v$pneu p
                            inner join oper.v$pneu_situacao ps 
                               on ps.situacao_id = p.situacao_id
                             left join oper.v$pneu_localizacao_atual pl 
                               on pl.pneu_id = p.pneu_id
                              and pl.data_entrada is not null
                             left join kss.v$pessoa pj 
                               on pj.cod_pessoa = pl.cod_pessoa
                               
                               
                               ) t
                    where 1 = 1  
                                           
                 group by t.situacao_id
                        , t.descricao
                        , t.cod_pessoa
                        , t.cod_centro_custo
                        , t.cliente
                        , t.nome_fantasia
                        , t.novos_0km
                        , t.novos
                        , t.reformados_0km
                        , t.reformados
                 order by t.situacao_id
                        , t.descricao
                        , t.cod_pessoa
                        , t.cod_centro_custo
                        , t.cliente
                  ) y



		</cfquery>
		<cfreturn qr_marcas>
	</cffunction>
	  	
	<!--- 
	-- PROPSITO 
	-- Busca todas as marcas para a montagem do relatorio de marcas
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 31/01/2006
	--->
	<cffunction name="get_resumo_marcas" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qr_marcas" username="#session.usuario#" password="#session.senha#">
				select sum(quantidade) as quantidade, marca
 				  from (select 
							  case 
							     when (quantidade/total) < 0.00 then 'Outros'
							  else marca end marca, 
							  quantidade, total
						 from (select marca, count(*) as quantidade,
									 (select count(*)
										from oper.v$pneu_dados) as total
							     from oper.v$pneu_dados p
								where p.situacao_id in (1,2,3,4,5,6,8,9,10)
								group by marca))
				group by marca     	
				order by 1 desc
		</cfquery>
		<cfreturn qr_marcas>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca todas as medidas para a montagem do relatorio de medidas
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 31/01/2006
	--->
	<cffunction name="get_resumo_medidas" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qr_medidas" username="#session.usuario#" password="#session.senha#">
			select sum(quantidade) as quantidade, medida
			from (select 
						case 
						   when (quantidade/total) < 0.01 then 'Outros'
						else medida end medida, 
						quantidade, total
					from (select medida, count(*) as quantidade,
									(select count(*)
									   from oper.v$pneu_dados) as total
								  from oper.v$pneu_dados p
								 where p.situacao_id in (1,2,3,4,5,6,8,9,10)
							group by medida))
			group by medida  
		</cfquery>
		<cfreturn qr_medidas>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca todas os modelos para a montagem do relatorio de modelos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 31/01/2006
	--->
	<cffunction name="get_resumo_modelos" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qr_modelos" username="#session.usuario#" password="#session.senha#">
			select sum(quantidade) as quantidade, marca, modelo
			from (select 
						case 
						   when (quantidade/total) < 0.00 then 'Outros'
						else modelo end modelo, 
						case 
						   when (quantidade/total) < 0.00 then 'Outros'
						else marca end marca, 
						quantidade, total
					from (select marca, modelo, count(*) as quantidade,
									(select count(*)
									   from oper.v$pneu_dados) as total
								  from oper.v$pneu_dados p
								 where p.situacao_id in (1,2,3,4,5,6,8,9,10)
							group by marca, modelo))
			group by marca, modelo      
			order by 1 desc
		</cfquery>
		<cfreturn qr_modelos>
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca todas os reformadores de pneu para a montagem do relatorio de reformadores
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 31/01/2006
	--->
	<cffunction name="get_resumo_reformador" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qr_desenhos" username="#session.usuario#" password="#session.senha#">
			select cod_pessoa_reformador, nvl(cliente,'Outros') as reformador, sum(quantidade) as quantidade
			from (select cod_pessoa_reformador, quantidade
					from (select prb.cod_pessoa as cod_pessoa_reformador, count(*) as quantidade,
								 (select count(*)
										  from oper.v$pneu_dados p
										 inner join oper.v$pneu_reforma pr
												on pr.pneu_id = p.pneu_id
											   and pr.conserto = 0
										inner join oper.v$pneu_borracha pb
												on pb.borracha_id = pr.borracha_id
										inner join oper.v$pneu_desenho pd
												on pd.borracha_id = pr.borracha_id
											   and pd.desenho_id = pr.desenho_id
                    where pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
                  																		from oper.v$pneu_reforma pr2
                  																	   where pr2.pneu_id = pr.pneu_id
                  																		 and pr2.conserto = 0)) as total      
								  from oper.v$pneu_dados p
								 inner join oper.v$pneu_reforma pr
										on pr.pneu_id = p.pneu_id
									   and pr.conserto = 0
								inner join oper.v$pneu_borracha pb
										on pb.borracha_id = pr.borracha_id
								inner join oper.v$pneu_desenho pd
										on pd.borracha_id = pr.borracha_id
									   and pd.desenho_id = pr.desenho_id
                                 left join oper.v$pneu_reformador_bandeira prb
                                        on prb.reformador_id = pr.reformador_id  		
								where  p.situacao_id in (1,2,3,4,5,6,8,9,10)   	   
							   and pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
																from oper.v$pneu_reforma pr2
															   where pr2.pneu_id = pr.pneu_id
																 and pr2.conserto = 0)
                
							group by prb.cod_pessoa))
			left join kss.v$pessoa pj
					on pj.cod_pessoa = cod_pessoa_reformador              
			group by cod_pessoa_reformador, cliente
		  order by 3 desc
		</cfquery>
		<cfreturn qr_desenhos>
	</cffunction>		
		
	<!--- 
	-- PROPSITO 
	-- Busca os graficos de status 
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->		
	<cffunction name="get_resumo_status" returntype="query" access="remote">
		<cfargument name="total" required="no">
		<cfif IsDefined("arguments.total")>
			<cfquery datasource="#session.dsn#" name="qr_status" username="#session.usuario#" password="#session.senha#">
				select decode(reformas,0,'Novo','Reforma ' || reformas) as reformas , 
					   count(*) as quantidade
					  from oper.v$pneu_dados
					 where situacao_id in (1,2,3,4,5,6,8,9,10)
					 having count(*) > 10
					 group by reformas
					 order by 2 desc
			</cfquery>	
			<cfreturn qr_status>
		<cfelseif IsDefined("arguments.milimetro")>
			<cfquery datasource="#session.dsn#" name="qr_status" username="#session.usuario#" password="#session.senha#">
                select a.reformas, round(sum(a.total)) as total, round(sum(a.usado)) as usado, 
                       round(sum(a.sobrando)) as sobrando
                  from (
                        select decode(reformas,0,'Novo', 'Reforma ' || reformas) as  reformas, 
                             case 
                               when reformas = 0 then round(pd.sulco-2)
                               else round(d.sulco-2) end total,        
                             case 
                               when reformas = 0 then round(pd.sulco-2 - decode(oper.pkg_pneu.fnc_sulco_atual_estimado(pd.pneu_id),-1,0,oper.pkg_pneu.fnc_sulco_atual_estimado(pd.pneu_id)-2))
                               else round(d.sulco-2 - decode(oper.pkg_pneu.fnc_sulco_atual_estimado(pd.pneu_id),-1,0,oper.pkg_pneu.fnc_sulco_atual_estimado(pd.pneu_id)-2)) end usado,             
                             case 
                              when oper.pkg_pneu.fnc_sulco_atual_estimado(pd.pneu_id) <= 0 then 0
                              else (oper.pkg_pneu.fnc_sulco_atual_estimado(pd.pneu_id)-2) end sobrando
                          from oper.v$pneu_dados pd
                         LEFT join oper.v$pneu_reforma pr
                             on pr.pneu_id = pd.pneu_id
                            and pr.conserto = 0
                         LEFT join oper.v$pneu_desenho d
                             on d.borracha_id = pr.borracha_id
                            and d.desenho_id = pr.desenho_id                                       
                             where situacao_id in (1,2,3,4,5,6,8,9,10)
                               and (pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma) 
                                   from oper.v$pneu_reforma pr2
                                  where pr2.pneu_id = pr.pneu_id
                                    and pr2.conserto = 0)
                                  or pr.data_retorno_reforma is null)
                        ) a
                            group by a.reformas
			</cfquery>	
			<cfreturn qr_status>
		<cfelse>		
			<cfquery datasource="#session.dsn#" name="qr_status" username="#session.usuario#" password="#session.senha#">
			  select reformas, 100 as total, round(usado/total * 100) as usado, round(sobrando/total * 100) as sobrando
				  from ( 
  				select /*+ FIRST_ROWS */ decode(reformas,0,'Novo', 'Reforma ' || reformas) as  reformas, 
					   case 
               when reformas = 0 then round(sum(pd.sulco-2))
               else round(sum(d.sulco-2)) end total,        
					   case 
               when reformas = 0 then round(sum(pd.sulco-2) - sum(decode(oper.pkg_pneu.fnc_sulco_atual_estimado(pd.pneu_id),-1,0,oper.pkg_pneu.fnc_sulco_atual_estimado(pd.pneu_id)-2)))
               else round(sum(d.sulco-2) - sum(decode(oper.pkg_pneu.fnc_sulco_atual_estimado(pd.pneu_id),-1,0,oper.pkg_pneu.fnc_sulco_atual_estimado(pd.pneu_id)-2))) end usado,
					   round(sum(decode(oper.pkg_pneu.fnc_sulco_atual_estimado(pd.pneu_id),-1,0,oper.pkg_pneu.fnc_sulco_atual_estimado(pd.pneu_id)-2))) sobrando
				  from oper.v$pneu_dados pd
				 left join oper.v$pneu_reforma pr
						 on pr.pneu_id = pd.pneu_id
						and pr.conserto = 0
														  
				 left join oper.v$pneu_desenho d
						 on d.borracha_id = pr.borracha_id
						and d.desenho_id = pr.desenho_id                                       
						 where situacao_id in (1,2,3,4,5,6,8,9,10)
							and (pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma) 
									 from oper.v$pneu_reforma pr2
									where pr2.pneu_id = pr.pneu_id
									  and pr2.conserto = 0)
							     or pr.data_retorno_reforma is null)
						group by reformas)

			</cfquery>	
			<cfreturn qr_status>
		</cfif>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os tipos de conserto
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 02/02/2006
	--->
	<cffunction name="get_tipo_conserto" returntype="query" access="remote">
		<cfquery name="qrTipoConsertos"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select tipo_conserto_id, descricao, bloqueia_reforma, prejudica_carcaca 
			  from oper.v$pneu_tipo_conserto		
			 order by descricao desc
   		</cfquery>		
		<cfreturn qrTipoConsertos>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os tipos basicos de ocorrencia
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 07/02/2006
	--->
	<cffunction name="get_tipo_ocorrencia" returntype="query" access="remote">
		<cfquery name="qr"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select os.num_ocorrencia, os.nome as descricao
			  from oper.v$pneu_ocorrencia_setup os
			order by os.nome  
   		</cfquery>		
		<cfreturn qr>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os tipos de veiculo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_tipo_veiculo" displayname="Consulta todos as Marcas dos Veculos" access="remote" output="true" returntype="query">
		<cfargument name="com_pneus" required="false">
		<cfargument name="tipo_id" required="false">
		<cfquery name="qr_tipo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 			select distinct vt.tipo_id, vt.tipo
 			  from oper.v$veiculo v 
			 inner join oper.v$veiculo_modelo vm 
					 on vm.marca_id = v.marca_id
					and vm.modelo_id = v.modelo_id
			 inner join oper.v$veiculo_tipo vt 
					 on vm.tipo_id = vt.tipo_id
			 inner join oper.v$veiculo_frota_geral2 vfg
					 on vfg.placa = v.placa
			   where 1=1
			 <cfif IsDefined("arguments.com_pneus") and arguments.com_pneus eq 1>
			     and exists (select 'x'  
			                   from oper.v$pneu_movimentacao p
					  		  where p.placa = v.placa)
			 <cfif IsDefined("arguments.tipo_id") and Len(Trim(arguments.tipo_id))>
			    and vt.tipo_id in (#arguments.tipo_id#)
			 </cfif>
			 </cfif>			 
             order by tipo
		</cfquery>
		<cfreturn qr_tipo>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os tipos de veiculo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_veiculo_tipo_carroceria" displayname="Consulta todos as Marcas dos Veculos" access="remote" output="true" returntype="query">
		<cfargument name="com_pneus" required="false" default="0">
		<cfargument name="tipo_carroceria_id" required="false" default="">
		<cfquery name="qr_tipo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 			select distinct 
                   vtc.tipo_carroceria_id,
                   vtc.descricao as tipo_veiculo,
                   vtc.descricao 
              from oper.v$veiculo v 
             inner join oper.v$veiculo_tipo_carroceria vtc
                     on vtc.tipo_carroceria_id = v.tipo_carroceria_id
             where 1=1
			 <cfif arguments.com_pneus eq 1>
			     and exists (select 'x'  
			                   from oper.v$pneu_movimentacao p
					  		  where p.placa = v.placa)
			 <cfif Len(Trim(arguments.tipo_carroceria_id))>
			    and vtc.tipo_carroceria_id in (#arguments.tipo_carroceria_id#)
			 </cfif>
			 </cfif>			 
             order by vtc.descricao
		</cfquery>
		<cfreturn qr_tipo>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os relatorios de vendas de pneus
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 10/02/2006
	--->	
	<cffunction name="get_venda_carcaca" returntype="query" access="remote">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_termino" required="no" default="">
		<cfargument name="marca_id" required="no" default="">
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="reformas_1" required="no" default="">
		<cfargument name="comprador" required="no" default="">
		<cfargument name="laudo_id" required="no" default="">
		<cfargument name="num_pneu" required="no" default="">
		<cfquery name="qr_sucatas" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pd.num_pneu,
				   p.cliente as sucateador,
				   ps.psu_id,
				   pd.marca_id,
				   pd.marca,
				   pd.modelo_id,
				   pd.modelo,
				   pd.medida,
       			   pd.medida_roda,
				   ps.pneu_id,
				   ps.cod_pessoa_sucateador,
				   ps.data_sucateamento,
				   ps.situacao_id,
				   ps.laudo_id,
				   ps.cod_pessoa_tecnico_analise,
				   ps.data_analise,
				   ps.valor_venda,
				   ps.cod_pessoa_mot_resp,
				   ps.observacao,
				   ps.user_insert,
				   ps.date_insert,
				   ps.user_update,
				   ps.date_update,
				   ps.site,
			       pdes.DESCRICAO as desenho,
				   pls.descricao as laudo,
			       count(*) over (partition by ps.cod_pessoa_sucateador order by ps.cod_pessoa_sucateador) as total_por_sucateador,
				   p2.cliente as comprador
			  from oper.v$pneu_sucateamento ps
			 inner join oper.v$pneu_dados pd
					 on ps.pneu_id = pd.pneu_id
			 inner join oper.v$pneu_laudo_sucateamento pls
					 on pls.laudo_id = ps.laudo_id
			  left join kss.v$pessoa p
					 on p.cod_pessoa = ps.cod_pessoa_sucateador
			  left join oper.v$pneu_reforma pr
				     on pr.pneu_id = ps.pneu_id
		            and pr.conserto = 0
			  left join oper.v$pneu_desenho pdes
				     on pdes.desenho_id = pr.desenho_id
			  left join oper.v$pneu_borracha pbor
					 on pbor.borracha_id = pr.borracha_id
			  left join oper.v$pneu_proprietario pp
				     on pp.pneu_id = pd.pneu_id
				    and data_fim is null
			  left join kss.v$pessoa p2
				     on p2.cod_pessoa = pp.cod_pessoa					
			 where ps.valor_venda > 0
			   and data_sucateamento is not null
				and (pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
															 from oper.v$pneu_reforma pr2
															where pr2.pneu_id = pr.pneu_id
															  and pr2.conserto = 0)
				  or pr.data_retorno_reforma is null)			   
			<cfif len(trim(arguments.data_inicio))>
				and trunc(ps.data_analise) >= '#arguments.data_inicio#'
			</cfif>			  
			<cfif len(trim(arguments.comprador))>
				and p2.cod_pessoa in (#arguments.comprador#)
			</cfif>			  
			<cfif len(trim(arguments.laudo_id))>
				and ps.laudo_id in (#ListQualify(arguments.laudo_id, "'", ',')#)
			</cfif>			  
			<cfif len(trim(arguments.num_pneu))>
				and pd.num_pneu in (#arguments.num_pneu#)
			</cfif>			  
			<cfif len(trim(arguments.data_termino))>
				and trunc(ps.data_analise) <= '#arguments.data_termino#'
			</cfif>			  
			<cfif len(trim(arguments.marca_id))>
				and pd.marca_id in (#arguments.marca_id#)
			</cfif>			  
			<cfif len(trim(arguments.modelo_id))>
				and pd.modelo_id in (#arguments.modelo_id#)
			</cfif>
			<cfif len(trim(arguments.medida_id))>
				and pd.medida_id in (#arguments.medida_id#)
			</cfif>
			<cfif len(trim(arguments.reformas_1))>
				and pd.reformas in (#arguments.reformas_1#)
			</cfif>			  
			 order by pls.descricao, user_update, marca, data_analise	
		</cfquery>
		<cfreturn qr_sucatas>
	</cffunction>
	<!--- 
	-- PROPSITO 
	-- Indice de perda dos pneus vendidos, sucateados e reformados de um determinado periodo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_indice_perda" displayname="Indice de perda dos pneus" access="remote" output="true" returntype="query">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfargument name="marca_id" required="no" default="">
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="medida_id" required="no" default="">
	
		<cfquery name="qr_indice" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 		select t.*, 
       		count(*) over (partition by situacao order by situacao) as total,
       		count(*) over (order by pneu_id rows between unbounded preceding and unbounded following) total_geral,
       		sum(case when situacao = 'REFORMADO' then 1 else 0 end) over (order by pneu_id rows between unbounded preceding and unbounded following) total_reformado,
       		sum(case when situacao = 'SUCATEADO' then 1 else 0 end) over (order by pneu_id rows between unbounded preceding and unbounded following) total_sucateado,
       		sum(case when situacao = 'VENDIDO' then 1 else 0 end) over (order by pneu_id rows between unbounded preceding and unbounded following) total_vendido
  		   from(select DISTINCT pd.pneu_id, pd.num_pneu,pd.marca,pd.modelo,
						pb.descricao as borracha, pde.descricao as desenho,'REFORMADO' as situacao
				 from oper.v$pneu_reforma pr
		   inner join oper.v$pneu_dados pd on pd.pneu_id = pr.pneu_id
			      and pr.conserto = 0  
		   inner join oper.v$pneu_borracha pb on pb.borracha_id = pr.borracha_id
		   inner join oper.v$pneu_desenho pde on pde.desenho_id = pr.desenho_id
		        where 1=1
				<cfif Len(Trim(arguments.MEDIDA_ID))>
					and pd.medida_id = #arguments.MEDIDA_ID#
				</cfif>
				<cfif Len(Trim(arguments.MARCA_ID))>
					and pd.marca_id = #arguments.MARCA_ID#
				</cfif>
				<cfif Len(Trim(arguments.MODELO_ID))>
					and pd.modelo_id = #arguments.MODELO_ID#
				</cfif>
		   		<cfif IsDefined("arguments.DATA_INICIO") and Len(Trim(arguments.DATA_INICIO)) or IsDefined("arguments.DATA_FIM") and Len(Trim(arguments.DATA_FIM))>
					<cfif IsDefined("arguments.DATA_INICIO") and Len(Trim(arguments.DATA_INICIO))>
					   and trunc(pr.data_envio_reforma) >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
					</cfif>
					<cfif IsDefined("arguments.DATA_FIM") and Len(Trim(arguments.DATA_FIM))>
					   and trunc(pr.data_envio_reforma) <= to_date('#arguments.data_fim#', 'dd/mm/yyyy')
					</cfif>
				</cfif>
				  and pr.data_retorno_reforma is not null

		 		union all

	           select distinct pd.pneu_id, pd.num_pneu,pd.marca,pd.modelo,'----' as borracha,'----' as desenho,'VENDIDO' as situacao
				 from oper.v$pneu_ocorrencia po
		   inner join oper.v$pneu_dados pd on pd.pneu_id = po.pneu_id
			    where po.situacao_id = 11
	     	 	<cfif IsDefined("arguments.DATA_INICIO") and Len(Trim(arguments.DATA_INICIO)) or IsDefined("arguments.DATA_FIM") and Len(Trim(arguments.DATA_FIM))>
					<cfif IsDefined("arguments.DATA_INICIO") and Len(Trim(arguments.DATA_INICIO))>
					   and trunc(po.data_ocorrencia) >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
					</cfif>
					<cfif IsDefined("arguments.DATA_FIM") and Len(Trim(arguments.DATA_FIM))>
					   and trunc(po.data_ocorrencia) <= to_date('#arguments.data_fim#', 'dd/mm/yyyy')
					</cfif>
				</cfif>
				<cfif Len(Trim(arguments.MEDIDA_ID))>
					and pd.medida_id = #arguments.MEDIDA_ID#
				</cfif>
				<cfif Len(Trim(arguments.MARCA_ID))>
					and pd.marca_id = #arguments.MARCA_ID#
				</cfif>
				<cfif Len(Trim(arguments.MODELO_ID))>
					and pd.modelo_id = #arguments.MODELO_ID#
				</cfif>
		   					
				union all
    
			   select distinct pd.pneu_id, pd.num_pneu,pd.marca,pd.modelo,'----' as borracha,'----' as desenho,'SUCATEADO' as situacao
           		 from oper.v$pneu_ocorrencia po
     	   inner join oper.v$pneu_dados pd on pd.pneu_id = po.pneu_id
			where po.situacao_id = 7
				<cfif Len(Trim(arguments.MEDIDA_ID))>
					and pd.medida_id = #arguments.MEDIDA_ID#
				</cfif>
				<cfif Len(Trim(arguments.MARCA_ID))>
					and pd.marca_id = #arguments.MARCA_ID#
				</cfif>
				<cfif Len(Trim(arguments.MODELO_ID))>
					and pd.modelo_id = #arguments.MODELO_ID#
				</cfif>
				
			<cfif IsDefined("arguments.DATA_INICIO") and Len(Trim(arguments.DATA_INICIO)) or IsDefined("arguments.DATA_FIM") and Len(Trim(arguments.DATA_FIM))>
             	  and po.DATA_OCORRENCIA =(
				  		select max(po2.data_ocorrencia)
                          from oper.v$pneu_ocorrencia po2
						 where 1=1
  						 <cfif IsDefined("arguments.DATA_INICIO") and Len(Trim(arguments.DATA_INICIO))>
						   and trunc(po2.DATA_OCORRENCIA) >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
						 </cfif>
						 <cfif IsDefined("arguments.DATA_FIM") and Len(Trim(arguments.DATA_FIM))>
						   and trunc(po2.DATA_OCORRENCIA) <= to_date('#arguments.data_fim#', 'dd/mm/yyyy')
						 </cfif>
						   and po2.pneu_id = po.pneu_id)
			</cfif>
			
			) t
		order by situacao, pneu_id 
		</cfquery>
	<cfreturn qr_indice>
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca as borracharias
	-- CRISTOFER  31/08/2006
	--->		
	<cffunction name="get_borracharia" access="remote" returntype="query" output="true">
        <cfargument name="todas" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select s.cod_organograma,
                     p.cliente as filial,
                     cc.centro_custo,
                     s.municipio,
                     r.latitude, r.longitude
                from kss.v$setor_informacoes s
                inner join kss.v$pessoa p 
                        on p.cod_pessoa = s.cod_pessoa_filial
                inner join kss.v$organograma o
                        on o.cod_organograma = s.cod_organograma
                inner join kss.v$centro_custo cc
                        on cc.cod_centro_custo = o.cod_centro_custo  
                left join oper.v$referencia r
                       on r.referencia_id = s.referencia_id
               where 1=1
                  <cfif not Len(Trim(arguments.TODAS))>
                    and possui_borracharia = 1
                  </cfif>
               order by filial
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca aplicaes
	-- NOTAS EXPLICATIVAS
	-- ARLEN 05/10/2006
	--->
	<cffunction name="get_pneu_tipo_conserto" returntype="query" access="remote">
		<cfargument name="tipo_conserto_id" required="yes" default="">
		<cfargument name="descricao" required="yes" default="">
		<cfargument name="bloqueia_reforma" required="no" default="0">
		<cfargument name="prejudica_carcaca" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 			 select tipo_conserto_id, descricao, bloqueia_reforma, prejudica_carcaca 
			   from oper.v$pneu_tipo_conserto
			  where 1=1
  			  <cfif Len(Trim(arguments.tipo_conserto_id))>
			 	and tipo_conserto_id = #arguments.tipo_conserto_id#
			  </cfif>
  			  <cfif Len(Trim(arguments.descricao))>
			 	and upper(descricao) like upper('%#arguments.descricao#%')
			  </cfif>
			  order by descricao
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Vendas
	-- NOTAS EXPLICATIVAS
	-- WAGNER 07/10/2006
	--->
	<cffunction name="get_venda_pneu" returntype="query" access="remote">
		<cfargument name="num_pneu" required="no" default="">
		<cfargument name="data_inicial" required="yes">
		<cfargument name="data_final" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select  p.pneu_id
				   ,p.num_pneu
                   ,( select pp1.cod_pessoa
                           from oper.v$pneu_proprietario pp1
                          where pp1.pneu_id = p.pneu_id              
                          and pp1.data_fim is not null
                          and pp1.data_fim = (   select max(pp2.data_fim) 
                                          from oper.v$pneu_proprietario pp2
                                         where pp2.pneu_id = p.pneu_id
                                         and pp2.data_fim is not null)
                       and pp1.data_inicio = (select max(pp2.data_inicio) 
                                          from oper.v$pneu_proprietario pp2
                                         where pp2.pneu_id = p.pneu_id
                                         and pp2.data_fim is not null)) as cod_ultimo_proprietario
                   ,nvl(kss.pkg_global.fnc_busca_nome_pessoa(
                   		( select max(pp1.cod_pessoa)
                           from oper.v$pneu_proprietario pp1
                          where pp1.pneu_id = p.pneu_id
                          and pp1.DATA_FIM is not null
                          and pp1.data_fim = (select max(pp2.data_fim) 
                                          from oper.v$pneu_proprietario pp2
                                        where pp2.pneu_id = p.pneu_id
                                          and pp2.DATA_FIM is not null)
                          and pp1.data_inicio = (select max(pp2.data_inicio) 
                                                        from oper.v$pneu_proprietario pp2
                                                       where pp2.pneu_id = p.pneu_id
                                                       and pp2.data_fim is not null))),'No Consta.') as ultimo_proprietario				   
				   ,( select pp3.cod_pessoa 
						   from oper.v$pneu_proprietario pp3
						  where pp3.pneu_id = p.pneu_id
							and pp3.data_fim is null) as cod_proprietario
				   ,kss.pkg_global.fnc_busca_nome_pessoa(
						(select pp3.cod_pessoa 
						   from oper.v$pneu_proprietario pp3
						  where pp3.pneu_id = p.pneu_id
							and pp3.data_fim is null)) as proprietario
				   ,po.situacao_id
				   ,po.date_insert as data_venda
				   ,po.operacao
			  from oper.v$pneu p
	    inner join oper.v$pneu_ocorrencia po
				on po.pneu_id = p.pneu_id
			   and po.situacao_id in (11,7)
			 where 1=1
			   and p.situacao_id in (11,7)
               and po.date_insert  =  (select max(po2.date_insert)
                                        from oper.v$pneu_ocorrencia po2
                                       where po2.pneu_id = p.pneu_id)
			 <cfif Len(Trim(arguments.data_inicial)) and Len(Trim(arguments.data_final))>
			   and trunc(po.date_insert) between  '#arguments.data_inicial#' and '#arguments.data_final#'
			 </cfif>
			 <cfif Len(Trim(arguments.num_pneu))>
			   and p.num_pneu = #arguments.num_pneu#
			 </cfif>
             order by p.pneu_id
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca Usuarios que cadastraram inspees no sistema
	-- NOTAS EXPLICATIVAS
	--->
	<cffunction name="get_usuarios" returntype="query" access="remote">
		<cfquery name="qr_result"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct pi.user_insert as usuario
			  from oper.v$pneu_inspecao pi
			  where pi.data_inspecao > sysdate - 365
			 order by usuario
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Busca inspees com desgaste excessivo
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 26/02/2007 - criado
	--->	
	<cffunction name="get_mm_gasto_excessivamente" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="data_inicio" required="no" default=""/>
		<cfargument name="data_fim" required="no" default=""/>
		<cfargument name="laudo_id" required="no" default=""/>
		<cfargument name="usuario" required="no" default=""/>
        <cfargument name="not_sulco_negativo" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select /*+ index (ccl pkc_ccl) */ pl.descricao as laudo,
				   p.pneu_id,
				   p.num_pneu,
				   p.marca,
				   p.modelo,
				   p.reformas,
				   nvl(oper.pkg_pneu.fnc_valor_desgaste_excessivo(p.pneu_id),0) as valor_mm,
				   pi.sulco_estimado - pi.mm_inspecao as mm_perdido,
				   pi.placa,
				   cc.cod_pessoa,
				   oper.pkg_global.fnc_get_cod_funcionario(cc.cod_pessoa) as cod_funcionario,
				   nvl(ccl.valor_lancamento,0) as valor_lancamento,
				   oper.pkg_global.fnc_busca_nome_pessoa(cc.cod_pessoa) as motorista
			  from oper.v$pneu_inspecao pi
			 inner join oper.v$pneu_laudo_analise pl 
					 on pl.laudo_id = pi.laudo_analise_id
			 inner join oper.v$pneu_dados p 
					 on pi.pneu_id = p.pneu_id
			 left join oper.v$pneu_inspecao_ccorrente pcc
					 on pcc.num_inspecao = pi.num_inspecao
			  left join finan.v$ccorrente_lancamento ccl 
					 on ccl.num_lancamento = pcc.num_lancamento
			  left join finan.v$ccorrente cc 
					 on cc.cod_conta = ccl.cod_conta
			 where 1=1
			 <cfif Len(Trim(arguments.DATA_INICIO))>
			   and pi.data_inspecao >= '#arguments.DATA_INICIO#'
			 </cfif>
			 <cfif Len(Trim(arguments.DATA_FIM))>
			   and pi.data_inspecao <= '#arguments.DATA_FIM#'
			 </cfif>
			 <cfif Len(Trim(arguments.LAUDO_ID))>
			   and pl.laudo_id in (#arguments.LAUDO_ID#)
			 </cfif>
			 <cfif Len(Trim(arguments.USUARIO))>
			   and pi.user_update in (#ListQualify(arguments.USUARIO,"'")#)
			 </cfif>
             <cfif Len(Trim(arguments.not_sulco_negativo)) >
             	and pi.sulco_estimado >= 0
             </cfif>
			 order by laudo, num_pneu
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>		
	
	<!--- 
	-- PROPSITO
	-- Busca inspees com desgaste excessivo
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 26/02/2007 - criado
	--->	
	<cffunction name="get_pneu_marca" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="pneu_id" required="no" default=""/>
		<cfargument name="descricao" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select marca_id,
				   descricao,
				   user_insert,
				   date_insert,
				   user_update,
				   date_update,
				   site
			  from oper.v$pneu_marca
			 where 1=1
			<cfif len(trim(arguments.pneu_id))>
			   and pneu_id = #arguments.pneu_id#
			</cfif>
			<cfif len(trim(arguments.descricao))>
			   and upper(descricao) like upper('%#arguments.descricao#%')
			</cfif>
			order by descricao
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca as situaes do pneu
	-- LOUIS  09/03/2007
	--->		
	<cffunction name="get_pneu_lona" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select lona_id,
				   descricao 
			  from oper.v$pneu_lona
			 order by descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os ndices de velocidade mxima
	-- LOUIS  09/03/2007
	--->		
	<cffunction name="get_pneu_indice_velocidade" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_indice_velocidade,
				   velocidade_maxima 
			  from oper.v$pneu_indice_velocidade
			 order by velocidade_maxima
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os ndices de carga
	-- LOUIS  09/03/2007
	--->		
	<cffunction name="get_pneu_indice_carga" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_indice_carga,
				   carga 
			  from oper.v$pneu_indice_carga
			 order by carga
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca os ndices de carga
	-- LOUIS  12/03/2007
	--->		
	<cffunction name="get_pneu_modalidade" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select modalidade_id,
				   descricao 
			  from oper.v$pneu_modalidade_reforma
			 order by descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca as placas com calibragem em aberto
	-- NOTAS EXPLICATIVAS
	-- GUTO 02/04/2007
	--->
	<cffunction name="get_calibragens_abertas" returntype="query" access="remote">
		<cfargument name="todas" required="no" default="0">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfif arguments.todas eq 1>
				select /*+ FIRST_ROWS*/ 
					    oper.pkg_veiculo.fnc_get_cod_veiculo(pi.placa) as frota,
                        pi.placa, 
						to_char(max(pi.data_calibragem), 'dd/mm/yyyy hh24:mi') as data_calibragem,
                        pi.user_insert, 
						to_char(max(pi.date_insert), 'dd/mm/yyyy hh24:mi') as date_insert,
						(select distinct cod_pessoa
						   from kss.v$kss_usuario_lotacao 
						  where usuario = pi.user_insert) as cod_pessoa_filial
				  from oper.v$pneu_calibragem pi
				 where pi.pressao_encontrada is null
				 group by pi.placa, pi.user_insert
				
				union 
			</cfif>
			select /*+ FIRST_ROWS*/ 
					oper.pkg_veiculo.fnc_get_cod_veiculo(pi.placa) as frota,
                    pi.placa, 
					to_char(max(pi.data_calibragem), 'dd/mm/yyyy hh24:mi') as data_calibragem,
                    pi.user_insert,
					to_char(max(pi.date_insert), 'dd/mm/yyyy hh24:mi') as date_insert,
					(select distinct cod_pessoa
					   from kss.v$kss_usuario_lotacao 
					  where usuario = pi.user_insert) as cod_pessoa_filial
			  from oper.v$pneu_calibragem pi
			 where pi.pressao_encontrada is null
			   and (oper.pkg_veiculo.fnc_veiculo_tracao(pi.placa) = 1 or
					  not exists (select 'x'
									from oper.v$veiculo_composicao vc
								   where vc.placa_2 = pi.placa
									 and vc.DATA_HORA_DESENGATE is null))
			 group by pi.placa, pi.user_insert
			
			 order by 3
   		</cfquery>		
		<cfreturn qrPneus>
	</cffunction>			

	<!--- 
	-- PROPSITO
	-- Busca ficha de calibragem em aberto
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 02/04/2007 - criado
	--->	
	<cffunction name="get_dados_calibragem" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
             select pc.controle_id, 
                	pc.placa, 
                	p.num_pneu, 
                	pm.posicao, 
                	to_char(pc.data_calibragem, 'dd/mm/yyyy hh24:mi') as data_calibragem,
				    pc.pressao_calibrada, 
                    pc.user_insert as gerada_por,
				    oper.pkg_veiculo.fnc_get_cod_veiculo(pc.placa) as frota, 
                    0 as km_atual, 
                    0 as pressao_ideal
			  from oper.v$pneu_calibragem pc
			 inner join oper.v$pneu_movimentacao pm
					 on pm.pneu_id = pc.pneu_id
					and pm.placa = pc.placa
					and pm.data_desmontagem is null
			 inner join oper.v$pneu_veiculo_posicao pvp 
					 on pvp.placa = pm.placa
					and pvp.posicao = pm.posicao
			 inner join oper.v$pneu p
					 on p.pneu_id = pc.pneu_id
			 inner join (select column_value placa, rownum as composicao,
									 oper.pkg_veiculo.fnc_get_cod_veiculo(column_value) cod_veiculo
							  from table(kss.pkg_string.fnc_split(oper.pkg_veiculo.fnc_get_composicao(oper.pkg_veiculo.fnc_get_placa('#arguments.placa#')),'|')) t,
									 (select oper.pkg_veiculo.fnc_capacidade_carga_compo(oper.pkg_veiculo.fnc_get_placa('#arguments.placa#'), sysdate) as capacidade from dual)
							 where column_value is not null) vc
					 on vc.placa = pc.placa
			where pc.pressao_encontrada is null
			order by vc.composicao, pvp.num_eixo, pvp.ordem
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO -  - criado
	--->	
	<cffunction name="get_pneu_calibragens" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="num_pneu" required="no" default=""/>
		<cfargument name="pneu_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select pc.controle_id, 
            	   pc.placa, 
                   oper.pkg_veiculo.fnc_get_cod_veiculo(pc.placa) as frota, 
                   p.num_pneu, 
                   pm.posicao, 
                   pc.data_calibragem,
				   pc.pressao_encontrada, 
                   pc.pressao_calibrada
			  from oper.v$pneu_calibragem pc
			 inner join oper.v$pneu_movimentacao pm
					 on pm.pneu_id = pc.pneu_id
					and pm.placa = pc.placa
					and pm.data_desmontagem is null
			 inner join oper.v$pneu_veiculo_posicao pvp 
					 on pvp.placa = pm.placa
					and pvp.posicao = pm.posicao
			 inner join oper.v$pneu p
					 on p.pneu_id = pc.pneu_id
			where 1=1
			<cfif Len(Trim(arguments.PNEU_ID)) >
			  and pc.pneu_id = #arguments.PNEU_ID#
		    </cfif>
			<cfif Len(Trim(arguments.NUM_PNEU)) >
			  and p.num_pneu = #arguments.NUM_PNEU#
		    </cfif>
			order by pc.data_calibragem
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>		
    
   	<!--- 
	-- PROPSITO 
	-- Busca as inspees de veiculos
	-- NOTAS EXPLICATIVAS
	-- LOUIS 20/07/2007 SQL criada pelo GUTO
	--->
	<cffunction name="get_inspecoes_veiculo" returntype="query" access="remote">
	    <cfargument name="modalidade" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select placa, cod_veiculo, marca, modelo, num_inspecao, data_inspecao, round(sysdate - data_inspecao) as dias,
                   round(avg(round(sysdate - data_inspecao)) over()) as media_dias
              from (select vd.placa, vd.cod_veiculo, 
                   vd.marca, vd.modelo, 
                   max(pi.num_inspecao) keep (dense_rank last order by pi.data_inspecao) num_inspecao,
                   max(pi.data_inspecao) keep (dense_rank last order by pi.data_inspecao) data_inspecao
              from oper.v$veiculo_dados vd
        inner join oper.v$veiculo_frota_geral vfg
                on vd.placa = vfg.placa
        inner join oper.v$pneu_veiculo_gabarito vg
                on vg.placa = vd.placa 
         left join oper.v$pneu_inspecao pi
                on pi.placa = vfg.placa  
                 where 1=1
                 and vd.situacao_id = 1
            <cfif len(trim(arguments.modalidade))>
            	and vfg.empresa = #arguments.modalidade#
            <cfelse>
            	and vfg.empresa in (1,2)
            </cfif>
          group by vd.placa, vd.cod_veiculo,
                   vd.marca, vd.modelo) 
        </cfquery>
        <cfreturn qr_result>
     </cffunction> 	
	<!--- 
	-- PROPSITO 
	-- Busca CONTA CORRENTE de compradores de pneus
	-- NOTAS EXPLICATIVAS
	--->
	<cffunction name="get_compradores_conta" returntype="query" access="remote">
		<cfquery name="qr_result"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cc.cod_conta, cc.descricao_conta, cc.cod_pessoa, cc.data_abertura,
            	   p.cliente as favorecido 
              from finan.v$ccorrente cc
              inner join kss.v$pessoa p 
                      on p.cod_pessoa = cc.cod_pessoa
             where cc.modalidade_id = 12
               and cc.ativo = 1
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>     

	<!--- 
	-- PROPSITO 
	-- Busca CONTA CORRENTE de compradores de pneus
	-- NOTAS EXPLICATIVAS
	--->
	<cffunction name="get_pagamento_lancamentos" returntype="query" access="remote">
    	<cfargument name="data_inicio" required="no" default=""/>
        <cfargument name="data_termino" required="no" default=""/>
		<cfquery name="qr_result"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select l.num_lancamento, l.cod_conta, l.cod_documento, l.num_documento,
                   l.data_lancamento, l.data_vencto, l.historico, l.valor_lancamento,
                   l.deb_cred, cc.descricao_conta
              from finan.v$ccorrente_lancamento l
             inner join finan.v$ccorrente cc
                     on cc.cod_conta = l.cod_conta
            where cc.modalidade_id = 12 /* venda de pneus*/
              <cfif Len(Trim(arguments.DATA_INICIO))>
              	and trunc(l.data_lancamento) >= '#arguments.DATA_INICIO#'
              </cfif>
              <cfif Len(Trim(arguments.DATA_TERMINO))>
              	and trunc(l.data_lancamento) <= '#arguments.DATA_TERMINO#'
              </cfif>
            order by data_vencto             
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>     
    
    <!--- 
	-- PROPSITO 
	-- Busca o prximo NUM_PNEU
	-- JONAS 15/05/2009
	--->		
	<cffunction name="get_pneu_proximo_num_pneu" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select max(to_number(num_pneu))+1 proximo_pneu
		 	from oper.v$pneu
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>		
   
   <!--- 
	-- PROPSITO 
	-- Busca o pneus
	-- JONAS 15/05/2009
	--->		
	<cffunction name="get_pneu" access="remote" returntype="query" output="true">
	   <cfargument name="pneu_id" required="no" default=""/>
      <cfargument name="num_pneu" required="no" default=""/>
      <cfargument name="num_interno" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+FIRST_ROWS*/
            			 p.pneu_id, p.num_pneu, p.num_pneu_serie, p.num_interno,
                      pma.descricao as marca,pmo.DESCRICAO as modelo,
                      p.num_interno_serie, p.num_serie, p.marca_id, p.modelo_id,
                      p.medida_id, p.medida_roda_id, p.cod_pessoa_fornecedor,
                      to_char(p.data_aquisicao,'dd/mm/yyyy') as data_aquisicao, p.nota_fiscal_numero, p.nota_fiscal_serie,
                      p.garantia, p.custo, p.cod_moeda, p.situacao_id, p.bloqueia_reforma,
                      p.usuario_bloqueio, p.reformas, p.ano_fabricacao, p.rowid,
                      pj.cnpj_cpf cnpjcpf_fornecedor,
                      pj.razao_social razao_social_fornecedor,
                      pl.cod_pessoa, pl.cod_departamento, pl.cod_setor, pl.cod_centro_custo,
                      u.cod_unidade_negocio, u.unidade_negocio, d.descricao departamento,
                      s.descricao setor, cc.centro_custo,
                      case
                         when p.situacao_id = 2 then
                            (select 'Montado no '|| decode(oper.pkg_global.fnc_get_parametro(202,'LOGISTICA'),2,substr(v.placa, 1, 3)||'-'||substr(v.placa, 4, 4),1,v.cod_veiculo)||' no eixo '||pgs.prefixo||' na posio '||pmv.posicao
                               from oper.v$pneu_movimentacao pmv
                              inner join oper.v$veiculo v
                                      on v.placa = pmv.placa
                              inner join oper.v$pneu_gabarito_setup pgs
                                      on pgs.num_gabarito = pmv.num_gabarito
                                     and pgs.num_eixo = pmv.num_eixo
                              where pmv.pneu_id = p.pneu_id
                                and pmv.data_desmontagem is null)
                         else ps.descricao
                      end situacao,
                      0 pneu_reformado, null borracha_id, null desenho_id,
                      to_char(modelo_id,'000000') || to_char(medida_roda_id,'000000') || to_char(medida_id,'000000') modelo_concatenado_id,
                      p.num_nota_id, p.valor_bruto
                 from oper.v$pneu p
                inner join oper.v$pneu_marca pma
                        on pma.marca_id = p.marca_id
                inner join oper.v$pneu_modelo pmo
                        on pmo.MARCA_ID = p.MARCA_ID 
                       and pmo.modelo_id = p.modelo_id
                inner join kss.v$pessoa pj
                        on pj.cod_pessoa = p.cod_pessoa_fornecedor
                inner join oper.v$pneu_situacao ps
                        on ps.situacao_id = p.situacao_id
                inner join oper.v$pneu_localizacao_atual pl
                        on pl.pneu_id = p.pneu_id
                       and pl.data_entrada = (select max(pl1.data_entrada)
                                                from oper.v$pneu_localizacao_atual pl1
                                               where pl1.pneu_id = pl.pneu_id)
                left join kss.v$unidade_negocio u
                        on u.cod_pessoa = pl.cod_pessoa
                left join kss.v$departamento d
                        on d.cod_departamento = pl.cod_departamento
                left join kss.v$setor s
                        on s.cod_setor = pl.cod_setor
                left join kss.v$centro_custo cc
                        on cc.cod_centro_custo = pl.cod_centro_custo
                where 
                1=1
                <cfif Len(Trim(arguments.PNEU_ID))>
                  	and p.pneu_id = #arguments.PNEU_ID#
                <cfelse>                
						 <cfif Len(Trim(arguments.NUM_PNEU))>
                   and upper(p.num_pneu) LIKE upper('#arguments.NUM_PNEU#%')
                   </cfif>
                   <cfif Len(Trim(arguments.NUM_INTERNO))>
                   and p.num_interno = '#arguments.NUM_INTERNO#'
                   </cfif>
                </cfif>
               union all
               select /*+FIRST_ROWS*/p.pneu_id, p.num_pneu, p.num_pneu_serie, p.num_interno,
		                pma.descricao as marca,pmo.DESCRICAO as modelo,
                      p.num_interno_serie, p.num_serie, p.marca_id, p.modelo_id,
                      p.medida_id, p.medida_roda_id, p.cod_pessoa_fornecedor,
                      to_char(p.data_aquisicao,'dd/mm/yyyy') as data_aquisicao, p.nota_fiscal_numero, p.nota_fiscal_serie,
                      p.garantia, p.custo, p.cod_moeda, p.situacao_id, p.bloqueia_reforma,
                      p.usuario_bloqueio, p.reformas, p.ano_fabricacao, p.rowid,
                      pj.cnpj_cpf cnpjcpf_fornecedor,
                      pj.razao_social razao_social_fornecedor,
                      null cod_pessoa, null cod_departamento, null cod_setor, null cod_centro_custo,
                      null cod_unidade_negocio, '' unidade_negocio, '' departamento,
                      '' setor, '' centro_custo,
                      case
                         when p.situacao_id = 2 then
                            (select 'Montado no '|| decode(oper.pkg_global.fnc_get_parametro(202,'LOGISTICA'),2,substr(v.placa, 1, 3)||'-'||substr(v.placa, 4, 4),1,v.cod_veiculo)||' no eixo '||pgs.prefixo||' na posio '||pmv.posicao
                               from oper.v$pneu_movimentacao pmv
                              inner join oper.v$veiculo v
                                      on v.placa = pmv.placa
                              inner join oper.v$pneu_gabarito_setup pgs
                                      on pgs.num_gabarito = pmv.num_gabarito
                                     and pgs.num_eixo = pmv.num_eixo
                              where pmv.pneu_id = p.pneu_id
                                and pmv.data_desmontagem is null)
                         else ps.descricao
                      end situacao,
                      0 pneu_reformado, null borracha_id, null desenho_id,
                      to_char(modelo_id,'000000') || to_char(medida_roda_id,'000000') || to_char(medida_id,'000000') modelo_concatenado_id,
                      p.num_nota_id, p.valor_bruto
                 from oper.v$pneu p
                 inner join oper.v$pneu_marca pma
                        on pma.marca_id = p.marca_id
                inner join oper.v$pneu_modelo pmo
                        on pmo.MARCA_ID = p.MARCA_ID 
                       and pmo.modelo_id = p.modelo_id
                inner join kss.v$pessoa pj
                        on pj.cod_pessoa = p.cod_pessoa_fornecedor
                inner join oper.v$pneu_situacao ps
                        on ps.situacao_id = p.situacao_id
                where
                 1=1
                 	<cfif Len(Trim(arguments.PNEU_ID))>
                  	and p.pneu_id = #arguments.PNEU_ID#
                  <cfelse>
							<cfif Len(Trim(arguments.NUM_PNEU))>
                        and upper(p.num_pneu) LIKE upper('#arguments.NUM_PNEU#%')
                     </cfif>
                     <cfif Len(Trim(arguments.NUM_INTERNO))>
                   	and p.num_interno = '#arguments.NUM_INTERNO#'
                   	</cfif>
                  </cfif>
                 and not exists(select '*'
                                   from oper.v$pneu_localizacao_atual pl
                                  where pl.pneu_id = p.pneu_id)

		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca km atual do veculo
	-- NOTAS EXPLICATIVAS
	-- GUTO 04/10/2006
	--->
	<cffunction name="get_km_atual" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="data" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_pneu.fnc_km_data(oper.pkg_veiculo.fnc_get_placa('#arguments.placa#'),'#arguments.DATA#') as km_atual
			  from dual
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca tempo parado do veculo na filial
	-- NOTAS EXPLICATIVAS
	-- GUTO 29/03/2010
	--->
	<cffunction name="get_tempo_veiculo_filial" returntype="query" access="remote">
		<cfargument name="latitude" required="no" default="">
		<cfargument name="longitude" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select oper.pkg_veiculo.fnc_get_cod_veiculo(a.placa) as frota, a.placa,
                   60*tempo tempo_min,
                   kss.to_tempo(60*tempo,3).retorno tempo,
                   to_char((select max(pi.data_inspecao) 
                     from oper.v$pneu_inspecao pi
                     where pi.placa = a.placa),'dd/mm/yyyy hh24:mi') as inspecao,
                   (select count(pm.pneu_id)
                      from oper.v$pneu_movimentacao pm
                     where pm.placa = a.placa
                       and pm.data_desmontagem is null) as pneus_montados,
                   (select count(pga.placa)
                     from oper.v$pneu_veiculo_gabarito pga
                     where pga.placa = a.placa
                       and pga.pneu_id is null) as posicoes_vagas
            from (
            select placa, max(tempo) keep(dense_rank last order by tempo) tempo
            from (select b.placa, b.landmark, b.agrupamento,  
                   (sum(b.intervalo)/60/60) tempo
            from (select a.*,
                   sum(case when (a.dist_ponto > 1 ) then 1
                       else 0 end) over (partition by a.placa order by a.data rows unbounded preceding) agrupamento 
              from (select p.placa, p.landmark, p.data, p.latitude, p.longitude,
                                        round(cep.pkg_coord_geografica.fnc_haversine1(p.latitude, p.longitude, lag(p.latitude, 1, p.latitude) over (partition by placa order by data), lag(p.longitude, 1, p.longitude) over (order by data)), 2) distancia,
                                        round(cep.pkg_coord_geografica.fnc_haversine1(p.latitude, p.longitude, #arguments.latitude#,#arguments.longitude#), 2) dist_ponto,
                                        trunc((p.data-lag(p.data, 1, p.data) over (partition by p.placa order by data) ) * 24*60*60) intervalo          
                        from oper.v$posicao p
                    where p.data between '#arguments.data_inicial#' and '#arguments.data_final#') a) b
            where b.dist_ponto < 1                        
            group by b.placa, b.landmark, b.agrupamento 
            )
            group by placa) a
            where tempo > 1
            order by tempo_min desc
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>    
    <!--- 
	-- PROPSITO 
	-- Busca as inspecoes em aberto em um determinado veculo
	-- NOTAS EXPLICATIVAS
	-- LEOPOLDOS 12/07/2010
	--->
	<cffunction name="get_inspecoes_abertas_veiculo_xml" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="todas" required="no" default="0">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select dbms_xmlgen.getxml('
            select oper.pkg_veiculo.fnc_get_cod_veiculo(pi.placa) as frota, pi.placa, pi.km_inspecao as km_veiculo, 
                   max(pi.data_inspecao) as data_inspecao, pi.user_insert, max(pi.data_insert) as data_insert,
                                (select distinct cod_pessoa
                                   from kss.v$kss_usuario_lotacao 
                                  where usuario = pi.user_insert) as cod_pessoa_filial
              from oper.v$pneu_inspecao pi
             where pi.mm_inspecao is null
             <cfif Len(Trim(arguments.PLACA)) gt 0>
               and pi.placa = oper.pkg_veiculo.fnc_get_placa(' || chr(39) || '#arguments.PLACA#' || chr(39) ||')
             </cfif>
             <cfif arguments.TODAS eq 0>
               and (oper.pkg_veiculo.fnc_veiculo_tracao(pi.placa) = 1 or
                      not exists (select ' || chr(39) || 'x' || chr(39) || '
                                    from oper.v$veiculo_composicao vc
                                   where vc.placa_2 = pi.placa
                                     and vc.DATA_HORA_DESENGATE is null))
             </cfif>
             group by pi.placa, pi.km_inspecao, pi.user_insert') as resultado
         from dual
   		</cfquery>		
		<cfreturn qrPneus>
	</cffunction>
    <!--- 
	-- PROPSITO 
	-- Busca os pneus a serem inspecionados
	-- NOTAS EXPLICATIVAS
	-- LEOPOLDOS 12/07/2010
	--->
	<cffunction name="get_pneus_inspecionar_veiculo_xml" returntype="query" access="remote">
		<cfargument name="placa" required="yes" default="0">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select dbms_xmlgen.getxml('
             select pm.pneu_id
                 , pd.num_pneu
                 , pd.sulco
                 , pd.reformas
                 , pm.posicao
                 , pm.placa
                 , vp.cod_posicao
                 , null as data_inspecao
                 , null as data_ult_inspecao
                 , pm.user_insert
                 , -1 as num_inspecao
                 , case 
                      when nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(pm.pneu_id),1),0) >= pm.mm_montagem then -1
                      else nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(pm.pneu_id),1),0)
                    end sulco_atual
                 , vp.num_eixo
                 , vp.ordem
                 , pm.km_montagem
                 , pm.mm_montagem
                 , 0 as inspecionar
              from oper.v$pneu_movimentacao pm
             inner join oper.v$pneu_veiculo_posicao vp
                     on pm.placa = vp.placa
                    and pm.posicao = vp.posicao
             inner join oper.v$pneu_dados pd
                     on pd.pneu_id = pm.pneu_id
             where pm.placa = oper.pkg_veiculo.fnc_get_placa('|| chr(39) || '#arguments.PLACA#'|| chr(39) || ')
               and pm.data_desmontagem is null
               and pm.pneu_id not in (select pi.pneu_id
                                        from oper.v$pneu_inspecao pi
                                       inner join oper.v$pneu_dados p 
                                          on p.pneu_id = pi.pneu_id
                                         and pi.mm_inspecao is null
                                        left join oper.v$pneu_movimentacao pm 
                                               on pm.placa = pi.placa
                                              and pm.pneu_id = pi.pneu_id
                                              and pm.data_desmontagem is null
                                       where pi.placa = oper.pkg_veiculo.fnc_get_placa('|| chr(39) || '#arguments.PLACA#'|| chr(39) || '))
             
             
             union all
             
             select p.pneu_id
                  , p.num_pneu
                  , p.sulco
                  , p.reformas
                  , pm.posicao
                  , pi.placa
                  , pvp.cod_posicao
                  , pi.data_inspecao
                  , pi.data_ult_inspecao
                  , pi.user_insert
                  , pi.num_inspecao
                  , case 
                      when nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(pneu_id),1),0) >= mm_montagem then -1
                      else nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(pneu_id),1),0)
                    end sulco_atual
                  , pvp.num_eixo
                  , pvp.ordem
                  , pm.km_montagem
                  , pm.mm_montagem
                  , 1 as inspecionar
               from oper.v$pneu_inspecao pi
              inner join oper.v$pneu_dados p 
                 on p.pneu_id = pi.pneu_id
                and pi.mm_inspecao is null
              inner join oper.v$pneu_veiculo_posicao pvp 
                      on pvp.placa = pi.placa
                     and pvp.posicao = pi.posicao
               left join oper.v$pneu_movimentacao pm 
                      on pm.placa = pi.placa
                     and pm.pneu_id = pi.pneu_id
                     and pm.data_desmontagem is null
              where pi.placa = oper.pkg_veiculo.fnc_get_placa(' || chr(39) || '#arguments.PLACA#'|| chr(39) || ')') as resultado
             from dual
   		</cfquery>		
		<cfreturn qrPneus>
	</cffunction>
    <!--- 
	-- PROPSITO 
	-- Busca o gabarito de pneus
	-- NOTAS EXPLICATIVAS
	-- LEOPOLDOS 13/07/2010
	--->
	<cffunction name="get_gabarito_pneus_xml" returntype="query" access="remote">
		<cfargument name="placa" required="yes" default="0">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select dbms_xmlgen.getxml('
              select pp.num_eixo
                   , pp.cod_posicao
                   , pp.posicao
                   , ps.prefixo
                   , pm.direcional
                   , pm.tracionado
                   , pm.suspenso
                from oper.v$pneu_gabarito pg
               inner join oper.v$pneu_gabarito_posicao pp
                       on pg.NUM_GABARITO = pp.num_gabarito
               inner join oper.v$pneu_gabarito_setup ps
                       on pg.num_gabarito = ps.num_gabarito
                      and pp.num_eixo = ps.num_eixo
               inner join oper.v$pneu_eixo_modelo pm
                       on ps.modelo_eixo_id = pm.modelo_eixo_id
               where pg.num_gabarito = (select (select tc.num_gabarito
                                                  from oper.v$veiculo_tipo_carroceria tc
                                                 where tc.tipo_carroceria_id = v.tipo_carroceria_id) 
                                          from oper.v$veiculo v
                                         where v.placa = oper.pkg_veiculo.fnc_get_placa(' || chr(39) || '#arguments.PLACA#' || chr(39) || '))
               order by pp.num_eixo') as resultado
        from dual
   		</cfquery>		
		<cfreturn qrPneus>
	</cffunction>
    <!--- 
	-- PROPSITO 
	-- Busca os dados para a troca dos pneus - xml
	-- NOTAS EXPLICATIVAS
	-- LEANDRO 12/07/2010
	--->
	<cffunction name="get_dados_pneu_troca_xml" returntype="query" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfquery name="qrPneu"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select dbms_xmlgen.getxml('
                    select /*+ ORDERED */ pneu_id, num_pneu, num_gabarito, num_eixo ,marca_id, mm_montagem, data_montagem, pmov_id, 
                           modelo_id, reformas, borracha_id, desenho_id, medida_roda_id, marca, modelo, desenho, borracha,
                           medida, medida_roda, placa, data_montagem, km_montagem, suspenso, geminado, cod_posicao, parceiro,
                           null as parc_num_pneu, null as parc_data_inspecao, null as parc_mm_inspecao, null as parc_mm_estimado,
                           0 as dias_ult_inspecao, posicao,
                           case 
                              when trunc(sysdate - oper.pkg_pneu.fnc_ultima_inspecao(pneu_id)) >= 2 then mm_montagem
                              when trunc(sysdate - oper.pkg_pneu.fnc_ultima_inspecao(pneu_id)) < 2 then oper.pkg_pneu.fnc_sulco_atual(pneu_id)
                           end sulco_parametro, medida_id, tempo_montagem
                      from (select pm.pneu_id, pd.num_pneu, pm.mm_montagem, pm.posicao, pm.pmov_id, 
                                   pm.num_gabarito, pm.num_eixo, pd.marca_id, pd.modelo_id, pd.reformas, 
                                   pr.borracha_id, pr.desenho_id, pd.medida_roda_id, pd.medida_id,
                                   pd.marca, pd.modelo, d.descricao as desenho, pb.descricao as borracha, 
                                   pd.medida, pd.medida_roda, pm.placa, to_char(pm.data_montagem,' || chr(39) || 'dd/mm/yyyy hh24:mi' || chr(39) || ') as data_montagem, pm.km_montagem, 
                                   round(sysdate - pm.data_montagem)*24 as tempo_montagem,
                                   pvp.suspenso, pvp.geminado, pvp.cod_posicao,
                                   oper.pkg_pneu.fnc_pneu_geminado(pm.pneu_id) as parceiro
                              from oper.v$pneu_dados pd
                             inner join oper.v$pneu_movimentacao pm
                                         on pm.pneu_id = pd.pneu_id 
                             inner join oper.v$pneu_veiculo_posicao pvp
                                         on pvp.placa = pm.placa
                                        and pvp.num_gabarito = pm.num_gabarito
                                        and pvp.num_eixo = pm.num_eixo
                                        and pvp.posicao = pm.posicao
                              left join oper.v$pneu_reforma pr
                                     on pr.pneu_id = pd.pneu_id
                              left join oper.v$pneu_borracha pb
                                     on pb.borracha_id = pr.borracha_id
                              left join oper.v$pneu_desenho d
                                     on d.borracha_id = pr.borracha_id
                                    and d.desenho_id = pr.desenho_id												  
                            where pd.pneu_id = #arguments.pneu_id#
                              and pm.data_desmontagem is null
                              and (pr.data_retorno_reforma = (select max(r2.data_retorno_reforma)
                                                             from oper.v$pneu_reforma r2
                                                            where r2.pneu_id = pr.pneu_id
                                                              and r2.data_retorno_reforma is not null
                                                              and r2.conserto = 0)
                                   or (select max(r2.data_retorno_reforma)
                                                             from oper.v$pneu_reforma r2
                                                            where r2.pneu_id = pr.pneu_id
                                                              and r2.data_retorno_reforma is not null
                                                              and r2.conserto = 0) is null)
                              )') as resultado
              from dual 
   		</cfquery>		
		<cfif Len(Trim(qrPneu.parceiro)) >
			<cfquery name="qrPneuParceiro"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select dbms_xmlgen.getxml('
                            select /*+ FIRST_ROWS */ p.num_pneu as PARC_NUM_PNEU, 
                                  decode(p.rendimento,0,-1, round(nvl(mm_inspecao, p.mm_montagem) - (p.km_rodado/p.rendimento),1)) as PARC_MM_ESTIMADO, 
                                  data_inspecao as PARC_DATA_INSPECAO, 
                                  mm_inspecao as PARC_MM_INSPECAO, parceiro,
                                  num_gabarito, num_eixo ,marca_id, 
                                  #qrPneu.mm_montagem# as mm_montagem,
                                  modelo_id, reformas, borracha_id, desenho_id, medida_roda_id, marca, modelo, desenho, borracha,
                                  medida, medida_roda, placa, data_montagem as data_montagem_parceiro,  km_montagem, suspenso, geminado, cod_posicao, 
                                  #qrPneu.num_pneu# as num_pneu,
                                  dias_ult_inspecao,' || chr(39) || '#qrPneu.posicao#' || chr(39) || ' as posicao, sulco, to_date(' || chr(39) || '#LSDateFormat(qrPneu.DATA_MONTAGEM)#'|| chr(39) || ' ,' || chr(39) || 'dd/mm/yyyy' || chr(39) || ') as data_montagem,
                                  ' || chr(39) || '#qrPneu.PMOV_ID#' || chr(39) || ' as pmov_id, ' || chr(39) || '#qrPneu.sulco_parametro#' || chr(39) || ' as sulco_parametro, medida_id,
                                       tempo_montagem
                              from (select pd.pneu_id, pd.num_pneu, pm.mm_montagem, 
                                        oper.pkg_pneu.fnc_km_rodado(pm.placa, nvl(pi.data_inspecao,pm.data_montagem), pvp.suspenso) as km_rodado,
                                        oper.pkg_pneu.fnc_rendimento_pneu(pm.pneu_id, pvp.modelo_eixo_id, pvp.num_eixo, pvp.tipo_carroceria_id) as rendimento,
                                        pm.num_gabarito, pm.num_eixo, pd.marca_id, pd.modelo_id, pd.reformas, pr.borracha_id, pr.desenho_id, pd.medida_roda_id, 
                                        pd.marca, pd.modelo, d.descricao as desenho, pb.descricao as borracha, pd.medida, pd.medida_roda,
                                        pm.placa, to_char(pm.data_montagem,' || chr(39) || 'dd/mm/yyyy hh24:mi' || chr(39) || ') as data_montagem, pm.km_montagem, pvp.suspenso, pvp.geminado, pvp.cod_posicao,
                                        oper.pkg_pneu.fnc_pneu_geminado(pm.pneu_id) as parceiro, 
                                        nvl(pi.data_inspecao,pm.data_montagem) as data_inspecao, nvl(pi.mm_inspecao,pm.mm_montagem) as mm_inspecao, trunc(sysdate - pi.data_inspecao) as dias_ult_inspecao,
                                        oper.pkg_pneu.fnc_sulco_atual(pd.pneu_id) as sulco, pd.medida_id,
                                               round(sysdate - pm.data_montagem)*24 as tempo_montagem
                                    from oper.v$pneu_dados pd
                                   inner join oper.v$pneu_movimentacao pm
                                            on pm.pneu_id = pd.pneu_id 
                                   inner join oper.v$pneu_veiculo_posicao pvp
                                            on pvp.placa = pm.placa
                                           and pvp.num_gabarito = pm.num_gabarito
                                           and pvp.num_eixo = pm.num_eixo
                                           and pvp.posicao = pm.posicao
                                   left join oper.v$pneu_inspecao pi
                                         on pd.pneu_id = pi.pneu_id
                                   left join oper.v$pneu_reforma pr
                                         on pr.pneu_id = pd.pneu_id
                                   left join oper.v$pneu_borracha pb
                                         on pb.borracha_id = pr.borracha_id
                                   left join oper.v$pneu_desenho d
                                        on d.borracha_id = pr.borracha_id
                                        and d.desenho_id = pr.desenho_id                                           
                                  where pm.data_desmontagem is null
                                    and pd.pneu_id = #qrPneu.parceiro#
                                    and (pi.data_inspecao = (select max(pi2.data_inspecao)
                                                      from oper.v$pneu_inspecao pi2
                                                     where pi2.pneu_id = pi.pneu_id)
                                        or pi.data_inspecao is null)
                                    and (pr.data_retorno_reforma = (select max(r2.data_retorno_reforma)
                                                             from oper.v$pneu_reforma r2
                                                             where r2.pneu_id = pr.pneu_id
                                                              and r2.data_retorno_reforma is not null
                                                              and r2.conserto = 0)
                                        or (select max(r2.data_retorno_reforma)
                                                             from oper.v$pneu_reforma r2
                                                             where r2.pneu_id = pr.pneu_id
                                                              and r2.data_retorno_reforma is not null
                                                                 and r2.conserto = 0) is null)) p') as resultado
                      from dual
			</cfquery>			
			<cfreturn qrPneuParceiro>
		</cfif>		
		<cfreturn qrPneu>
	</cffunction>
    <!--- 
	-- PROPSITO 
	-- Busca os laudos de desmontagem - xml
	-- NOTAS EXPLICATIVAS
	-- LEANDRO 12/07/2010
	--->	
	<cffunction name="get_laudo_desmontagem_xml" returntype="query" access="remote">
		<cfargument name="mostrar_uso" required="no" default="1">
		<cfquery name="qrLaudos"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select dbms_xmlgen.getxml('
                select laudo_id, 
                <cfif arguments.mostrar_uso eq 1>
                       (select count(*)
                           from oper.v$pneu_movimentacao pm
                          where pm.laudo_desmontagem_id = l.laudo_id) as uso,
                </cfif>
                       descricao
                  from oper.v$pneu_laudo_desmontagem l
                 order by 2 desc') as resultado
              from dual 
   		</cfquery>		
		<cfreturn qrLaudos>
	</cffunction>
    <!--- 
	-- PROPSITO 
	-- Busca os pneus disponiveis no estoque - xml
	-- NOTAS EXPLICATIVAS
	-- LEANDRO 12/07/2010
	--->
	<cffunction name="get_pneus_disponiveis_estoque_xml" returntype="query" access="remote">
		<cfargument name="num_gabarito" required="no">
		<cfargument name="num_eixo" required="no">
		<cfargument name="medida_id" required="no">
		<cfargument name="medida_roda_id" required="no" default="">
		<cfargument name="marca_id" required="no">
		<cfargument name="modelo_id" required="no">
		<cfargument name="num_reformas_pneu" required="no">
		<cfargument name="borracha_id" required="no">
		<cfargument name="desenho_id" required="no">
		<cfargument name="sulco" required="no">
		<cfquery name="qr_conf_eixo"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select reformas
                         , integridade_marca
                         , integridade_modelo
                         , integridade_status
                         , integridade_borracha
                         , integridade_desenho
                         , pem.direcional
                         , pem.tracionado
                         , pem.suspenso
                         , t.prefixo
                         , to_number(kss.pkg_global.fnc_obtem_parametro_str(11, 'OPERACIONAL', 18, 9)) as mm_permitido_parceiro
                      from oper.v$pneu_gabarito_setup t
                     inner join oper.v$pneu_eixo_modelo pem
                        on pem.modelo_eixo_id = t.modelo_eixo_id
                     where t.num_gabarito = #arguments.num_gabarito#
                       and t.num_eixo = #arguments.num_eixo#
   		</cfquery>		
		<cfquery name="qr_pneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select xmlelement("ROWSET"
          ,xmlagg(
             xmlelement("ROW",xmlconcat(
                xmlelement("PNEU_ID",pneu_id)
               ,xmlelement("NUM_PNEU",num_pneu)
               ,xmlelement("SITUACAO", situacao_id)
               ,xmlelement("MARCA_ID",marca_id)
               ,xmlelement("MARCA",marca)
               ,xmlelement("MODELO_ID", modelo_id)
               ,xmlelement("MODELO", modelo)
               ,xmlelement("BORRACHA_ID", borracha_id)
               ,xmlelement("DESENHO_ID", desenho_id)
               ,xmlelement("DESENHO",desenho)
               ,xmlelement("BORRACHA",borracha)
               ,xmlelement("SULCO", oper.pkg_pneu.fnc_sulco_atual(pneu_id))
               ,xmlelement("MEDIDA_ID", medida_id)
               ,xmlelement("MEDIDA", medida)
               ,xmlelement("REFORMAS", reformas)
               ,xmlelement("MEDIDA_RODA_ID", medida_roda_id)
               ,xmlelement("MEDIDA_RODA", medida_roda)
               ,xmlelement("STATUS", status)
               ,xmlelement("FORMATO", substr(formato_borracha,1,1))
               )))).getClobVal() as resultado
                      from (
                                select p.pneu_id, p.num_pneu, p.situacao_id, p.marca_id, ma.descricao as marca, 
                                 p.modelo_id, pm.descricao as modelo,
                                       null borracha_id, null desenho_id, null as desenho, 
                                 null as borracha, 
                                 p.medida_roda_id, mr.medida_roda, 
                                       oper.pkg_pneu.fnc_sulco_atual(p.pneu_id) as sulco,
                                       p.medida_id, me.descricao as medida,
                                       p.reformas,'Novos'  as status, pfb.descricao as formato_borracha
                                  from oper.v$pneu p
                            inner join oper.v$pneu_localizacao pl
                                    on pl.pneu_id = p.pneu_id
                                   and pl.data_saida is null
                            inner join oper.v$pneu_marca ma
                                    on ma.marca_id = p.marca_id
                            inner join oper.v$pneu_modelo pm
                                    on pm.marca_id = p.marca_id 
                                   and pm.modelo_id = p.modelo_id
                                   and pm.medida_id = p.medida_id
                                   and pm.medida_roda_id = p.medida_roda_id
                                   and pm.eixo_tracionado = 1
                            inner join oper.v$pneu_medida me
                                    on me.medida_id = p.medida_id
                            inner join oper.v$pneu_medida_roda mr
                                    on mr.medida_roda_id = p.medida_roda_id
                            inner join oper.v$pneu_formato_borracha pfb
                                    on pfb.formato_id = pm.formato_id
                                 where p.situacao_id = 1
                             and p.reformas = 0
                             and pl.cod_pessoa = 1
                    union
                                select p.pneu_id, p.num_pneu, p.situacao_id, p.marca_id, ma.descricao as marca, 
                                       p.modelo_id, pm.descricao as modelo,
                                       pr.borracha_id, pr.desenho_id, 
                                       pd.descricao as desenho, 
                                       pb.descricao as borracha, 
                                       p.medida_roda_id, mr.medida_roda, 
                                       oper.pkg_pneu.fnc_sulco_atual(p.pneu_id) as sulco,
                                       p.medida_id, me.descricao as medida,
                                       p.reformas, 'Recapados'  as status, pfb.descricao as formato_borracha
                                  from oper.v$pneu p
                            inner join oper.v$pneu_localizacao pl
                                    on pl.pneu_id = p.pneu_id
                                   and pl.data_saida is null
                            inner join oper.v$pneu_marca ma
                                    on ma.marca_id = p.marca_id
                            inner join oper.v$pneu_modelo pm
                                    on pm.marca_id = p.marca_id
                                   and pm.modelo_id = p.modelo_id
                                   and pm.medida_id = p.medida_id
                                   and pm.medida_roda_id = p.medida_roda_id
                            inner join oper.v$pneu_medida me
                                    on me.medida_id = p.medida_id
                            inner join oper.v$pneu_medida_roda mr
                                    on mr.medida_roda_id = p.medida_roda_id
                              inner join oper.v$pneu_reforma pr
                                        on pr.pneu_id = p.pneu_id
                            inner join oper.v$pneu_borracha pb
                                    on pb.borracha_id = pr.borracha_id
                            inner join oper.v$pneu_desenho pd
                                    on pd.borracha_id = pr.borracha_id
                                   and pd.desenho_id = pr.desenho_id
                                   and pd.eixo_tracionado = 1
                            inner join oper.v$pneu_formato_borracha pfb
                                    on pfb.formato_id = pd.formato_id
                                 where p.situacao_id = 1
                                   and p.reformas > 0
                                   and pl.cod_pessoa = 1
                                   and (pr.data_retorno_reforma = (select max(r2.data_retorno_reforma)
                                                                                         from oper.v$pneu_reforma r2
                                                                                        where r2.pneu_id = pr.pneu_id
                                                                                          and r2.data_retorno_reforma is not null
                                                                                          and r2.conserto = 0)
                                        or (select max(r2.data_retorno_reforma)
                                                                                         from oper.v$pneu_reforma r2
                                                                                        where r2.pneu_id = pr.pneu_id
                                                                                          and r2.data_retorno_reforma is not null
                                                                                          and r2.conserto = 0) is null )        ) p
                     where 1 = 1

                           and p.medida_roda_id = 2  
                           and rownum < 10
                     --order by p.reformas, p.num_pneu, p.marca, p.modelo, 12 desc, p.borracha, p.desenho
   		</cfquery>									
		<cfreturn qr_pneus>
	</cffunction>	
    <!--- 
	-- PROPSITO 
	-- Busca os parametros - xml
	-- NOTAS EXPLICATIVAS
	-- LEANDRO 12/07/2010
	--->
	<cffunction name="get_parametros_xml" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qrParametros" username="#session.usuario#" password="#session.senha#">
            select dbms_xmlgen.getxml('
                select to_number(kss.pkg_global.fnc_obtem_parametro_str(11,'||chr(39) || 'OPERACIONAL' || chr(39) ||', 18, 1)) as tolerancia_inspecao,
                       to_number(kss.pkg_global.fnc_obtem_parametro_str(11,'|| chr(39) || 'OPERACIONAL' || chr(39) ||', 18, 2)) as mm_minimo_reforma, 
                       to_number(kss.pkg_global.fnc_obtem_parametro_str(11,'|| chr(39) || 'OPERACIONAL'|| chr(39) ||', 18, 3)) as mm_liberacao_primeiro_eixo
                  from dual') as resultado
              from dual                 
 		</cfquery>		
		<cfreturn qrParametros>
	</cffunction>
    <!--- 
	-- PROPSITO 
	-- Busca os pneus do veculo - xml
	-- NOTAS EXPLICATIVAS
	-- LEOPOLDOS 15/07/2010
	--->
	<cffunction name="get_pneus_veiculo_xml" returntype="query" access="remote">
		<cfargument name="placa" 	required="yes" default="0">
		<cfquery datasource="#session.dsn#" name="qr_pneus" username="#session.usuario#" password="#session.senha#">
		select dbms_xmlgen.getxml('
        select pm.pneu_id
                 , pd.num_pneu
                 , pd.sulco
                 , pd.reformas
                 , pm.posicao
                 , pm.placa
                 , pd.marca
                 , pd.modelo
                 , pd.medida
                 , pd.medida_roda
                 , vp.cod_posicao
                 , null as data_inspecao
                 , null as data_ult_inspecao
                 , pm.user_insert
                 , -1 as num_inspecao
                 , case 
                      when nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(pm.pneu_id),1),0) >= pm.mm_montagem then -1
                      else nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(pm.pneu_id),1),0)
                    end sulco_atual
                 , vp.num_eixo
                 , vp.ordem
                 , pm.km_montagem
                 , pm.mm_montagem
                 , pd.medida_id
                 , pd.medida_roda_id
                 , pd.marca_id
                 , pd.modelo_id
                 , pd.reformas
                 , pd.sulco
              from oper.v$pneu_movimentacao pm
             inner join oper.v$pneu_veiculo_posicao vp
                     on pm.placa = vp.placa
                    and pm.posicao = vp.posicao
             inner join oper.v$pneu_dados pd
                     on pd.pneu_id = pm.pneu_id
             where pm.placa = oper.pkg_veiculo.fnc_get_placa(' || chr(39) || '#arguments.PLACA#' || chr(39) || ')
               and pm.data_desmontagem is null') as resultado
          from dual
		</cfquery>
		<cfreturn qr_pneus>
	</cffunction>
    <!--- 
    -- PROPSITO 
    -- Retorna Pneu_ID
    -- LEOPOLDOS 17/07/2010 - CRIADO
    --->		
    <cffunction name="get_pneu_id" access="remote" returntype="query" output="true">
    	<cfargument name="num_pneu" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.pneu_id
              from oper.v$pneu p
             where p.num_pneu = '#arguments.NUM_PNEU#'
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!--- 
	-- PROPSITO 
	-- Busca os reformadores - xml
	-- NOTAS EXPLICATIVAS
	-- LEOPOLDOS 19/07/2010
	--->
	<cffunction name="get_reformadores_xml" returntype="query" access="remote">
		<cfargument name="borracha_id" required="no" default="">
		<cfargument name="sem_imagem" required="no" default="0">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
		select dbms_xmlgen.getxml('
			select pj.cliente as nome_fantasia, 
				   prb.cod_pessoa as cod_pessoa_reformador, 
                   prb.reformador_id,
				   pb.borracha_id, 
				   pb.descricao as borracha
					<cfif arguments.sem_imagem eq 0>
						,pb.imagem
					</cfif>
			  from oper.v$pneu_reformador_bandeira prb
			 inner join oper.v$pneu_borracha pb
					 on pb.borracha_id = prb.borracha_id
			 inner join kss.v$pessoa pj
					 on pj.cod_pessoa = prb.cod_pessoa
			 where 1=1
			   <cfif len(trim(arguments.borracha_id))>
			   and pb.borracha_id = #arguments.borracha_id#
			   </cfif>
			order by pj.cliente') as resultado
         from dual	 
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	
    <!--- 
	-- PROPSITO 
	-- Busca as marcas cadastradas - xml
	-- NOTAS EXPLICATIVAS
	-- LEOPOLDOS 19/07/2010
	--->
	<cffunction name="get_desenhos_xml" returntype="query" access="remote">
		<cfargument name="borracha_id" required="no">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
		select dbms_xmlgen.getxml('
			select t.desenho_id, t.borracha_id, t.descricao as descricao_d, 
				   t.descricao,
				   t.sulco, 
                   t.formato_id, 
                   t.modalidade_id,
                   t.eixo_tracionado, 
                   t.eixo_direcional, 
                   t.eixo_suspenso,
				   pb.descricao as borracha 
				from oper.v$pneu_desenho t
			inner join oper.v$pneu_borracha pb
			        on pb.borracha_id = t.borracha_id
			 where 1 = 1
			   <cfif IsDefined("arguments.borracha_id")>			   
				   and pb.borracha_id = #arguments.borracha_id# 
			   </cfif>
			order by pb.descricao, t.formato_id, t.sulco, t.descricao') as resultado 
          from dual
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna Num Gabarito de um veculo
    -- LEOPOLDOS 19/07/2010 - CRIADO
    --->		
    <cffunction name="get_num_gabarito" access="remote" returntype="query" output="true">
    	<cfargument name="placa" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select v.placa
                 , tc.num_gabarito
              from oper.v$veiculo v
             inner join oper.v$veiculo_tipo_carroceria tc
                     on v.tipo_carroceria_id = tc.tipo_carroceria_id
             where v.placa = oper.pkg_veiculo.fnc_get_placa('#arguments.PLACA#')
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna agrupamento veiculo
    -- LEOPOLDOS 99/99/2010 - CRIADO
    --->		
    <cffunction name="get_agrupamento_veiculo" access="remote" returntype="query" output="true">
    	<cfargument name="cod_veiculo" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select va.tracao
                 , va.articulado
              from oper.v$veiculo v
             inner join oper.v$veiculo_tipo_carroceria vc
                     on vc.tipo_carroceria_id = v.tipo_carroceria_id
             inner join oper.v$veiculo_agrupamento  va
                     on va.agrupamento_id = vc.agrupamento_id
             where v.placa = oper.pkg_veiculo.fnc_get_placa('#arguments.COD_VEICULO#')
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
     <!--- 
    -- PROPSITO 
    -- Retorna Dados do pneu XML
    -- LEOPOLDOS 26/08/2010 - CRIADO
    --->		
    <cffunction name="get_dados_pneu_xml" access="remote" returntype="query" output="true">
    	<cfargument name="num_pneu" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select xmlelement("ROWSET",
                         xmlagg(
                         xmlelement("ROW", 
                          xmlconcat(
                              xmlelement("PNEU_ID", a.pneu_id),
                              xmlelement("NUM_PNEU", a.num_pneu),
                              xmlelement("SITUACAO_ID", a.situacao_id),
                              xmlelement("SITUACAO", a.situacao),
                              xmlelement("MM_MONTAGEM", a.mm_montagem),
                              xmlelement("MM_DESMONTAGEM", a.mm_desmontagem),
                              xmlelement("PLACA", a.placa),
                              xmlelement("FROTA", a.frota),
                              xmlelement("MARCA", a.marca),
                              xmlelement("MODELO", a.modelo),
                              xmlelement("REFORMADOR", a.reformador),
                              xmlelement("TIPO_CONSERTO", a.tipo_conserto),
                              xmlelement("BORRACHA", a.borracha),
                              xmlelement("DESENHO", a.desenho)
                              )
                          )
                         )
                        ).getClobVal() as resultado
                from (select p.pneu_id
                           , p.num_pneu
                           , p.situacao_id
                            , (select upper(ps.descricao)
                                 from oper.v$pneu_situacao ps
                                where ps.situacao_id = p.situacao_id) as situacao
                           , pm.mm_montagem
                           , pm.mm_desmontagem
                           , pm.placa
                           , oper.pkg_veiculo.fnc_get_cod_veiculo(pm.placa) as frota
                           , (select pmc.descricao
                                from oper.v$pneu_marca pmc 
                               where pmc.marca_id = p.marca_id) as marca
                           , (select pmo.descricao
                                from oper.v$pneu_modelo pmo 
                               where pmo.modelo_id = p.modelo_id
                                 and pmo.marca_id = p.marca_id) as modelo
                           , (select kss.pkg_pessoa.fnc_get_cliente(prd.cod_pessoa)
                                from oper.v$pneu_reformador_bandeira prd
                               where prd.reformador_id = pr.reformador_id) as reformador
                           , (select ptc.descricao
                                from oper.v$pneu_tipo_conserto ptc
                               where ptc.tipo_conserto_id = pr.tipo_conserto_id) as tipo_conserto
                           , (select pb.descricao
                                from oper.v$pneu_borracha pb
                               where pb.borracha_id = pr.borracha_id ) as borracha
                           , (select pd.descricao
                                from oper.v$pneu_desenho pd
                               where pd.desenho_id = pr.desenho_id ) as desenho
                        from oper.v$pneu p
                        left join oper.v$pneu_movimentacao pm
                               on pm.pneu_id = p.pneu_id
                        left join oper.v$pneu_reforma_completo pr
                               on pr.pneu_id = p.pneu_id
                       where p.num_pneu = '#arguments.NUM_PNEU#'
                         and (pm.pmov_id = (select max(pm2.pmov_id)
                                             from oper.v$pneu_movimentacao pm2
                                            where pm2.pneu_id = p.pneu_id) 
                          or (select max(pm2.pmov_id)
                              from oper.v$pneu_movimentacao pm2
                             where pm2.pneu_id = p.pneu_id) is null)
                             
                         and (pr.reforma_id = (select max(pr2.reforma_id)
                                                from oper.v$pneu_reforma pr2
                                               where pr2.pneu_id = p.pneu_id )
                          or (select max(pr2.reforma_id)
                               from oper.v$pneu_reforma pr2
                              where pr2.pneu_id = p.pneu_id ) is null)) a
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os pneus inventariados
    -- ANDERSON 14/01/2010 - CRIADO
    --->		
    <cffunction name="get_pneus_inventariados" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa_filial" required="no" default="" />
        <cfargument name="cod_departamento" required="no" default="" />
        <cfargument name="cod_setor" required="no" default="" />
        <cfargument name="cod_centro_custo" required="no" default="" />
        <cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_fim" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.pneu_id
                 , p.num_pneu
                 , (select pm.descricao
                      from oper.v$pneu_marca pm
                     where pm.marca_id = p.marca_id
                   ) as marca
                 , (select pm.descricao
                      from oper.v$pneu_modelo pm
                     where pm.marca_id = p.marca_id
                       and pm.modelo_id = p.modelo_id
                       and pm.medida_id = p.medida_id
                       and pm.medida_roda_id = p.medida_roda_id
                   ) as modelo
                 , (select pm.descricao
                      from oper.v$pneu_medida pm
                     where pm.medida_id = p.medida_id
                   ) as medida
                 , (select pmr.medida_roda
                      from oper.v$pneu_medida_roda pmr
                     where pmr.medida_roda_id = p.medida_roda_id
                   ) as medida_roda
                 , (select pb.descricao
                      from oper.v$pneu_reforma pr
                     inner join oper.v$pneu_borracha pb
                             on pb.borracha_id = pr.borracha_id
                     where pr.pneu_id = p.pneu_id
                       and pr.reforma_id = (select max(pr2.reforma_id) keep(dense_rank last order by pr2.data_envio_reforma)
                                              from oper.v$pneu_reforma pr2
                                             where pr2.pneu_id = pr.pneu_id
                                           )
                   ) as borracha
                 , (select pd.descricao
                      from oper.v$pneu_reforma pr
                     inner join oper.v$pneu_desenho pd
                             on pd.desenho_id = pr.desenho_id
                            and pd.borracha_id = pr.borracha_id
                     where pr.pneu_id = p.pneu_id
                       and pr.reforma_id = (select max(pr2.reforma_id) keep(dense_rank last order by pr2.data_envio_reforma)
                                              from oper.v$pneu_reforma pr2
                                             where pr2.pneu_id = pr.pneu_id
                                           )
                   ) as desenho
                 , p.user_insert
                 , to_char(p.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , (select un.unidade_negocio
                      from kss.v$unidade_negocio un
                     where un.cod_pessoa = pla.cod_pessoa
                   ) as unidade_negocio
                 , case
                      when p.situacao_id = 2 then
                         (select 'Montado no '|| v.cod_veiculo||' no eixo '||pgs.prefixo||' na posio '||pmv.posicao
                            from oper.v$pneu_movimentacao pmv
                           inner join oper.v$veiculo v
                                   on v.placa = pmv.placa
                           inner join oper.v$pneu_gabarito_setup pgs
                                   on pgs.num_gabarito = pmv.num_gabarito
                                  and pgs.num_eixo = pmv.num_eixo
                           where pmv.pneu_id = p.pneu_id
                             and pmv.data_desmontagem is null
                         )
                      else
                         (select ps.descricao
                            from oper.v$pneu_situacao ps
                           where ps.situacao_id = p.situacao_id
                         )
                   end as situacao_atual
                 , (select min(ps.sulco) keep(dense_rank last order by ps.data)
                      from oper.v$pneu_sulco ps
                     where ps.pneu_id = p.pneu_id
                   ) as sulco_atual
                 , case
                      when p.situacao_id = 2 then
                         (select to_char(pmv.data_montagem, 'dd/mm/yyyy hh24:mi:ss')
                            from oper.v$pneu_movimentacao pmv
                           where pmv.pneu_id = p.pneu_id
                             and pmv.data_desmontagem is null)
                      else 'Desmontado'
                   end as montado_em
              from oper.v$pneu p
              left join oper.v$pneu_localizacao_atual pla
                     on pla.pneu_id = p.pneu_id
             where p.inventariado = 1
			<cfif Len(Trim(arguments.cod_pessoa_filial))>
               and pla.cod_pessoa = #arguments.cod_pessoa_filial#
			</cfif>
            <cfif Len(Trim(arguments.cod_departamento))>
               and pla.cod_departamento = #arguments.cod_departamento#
            </cfif>
            <cfif Len(Trim(arguments.cod_setor))>
               and pla.cod_setor = #arguments.cod_setor#
            </cfif>
            <cfif Len(Trim(arguments.cod_centro_custo))>
               and pla.cod_centro_custo = #arguments.cod_centro_custo#
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
               and pla.data_entrada >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
               and pla.data_entrada <= to_date('#arguments.data_fim#', 'dd/mm/yyyy')
            </cfif>
             order by p.date_insert
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
</cfcomponent>