<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Busca os tipos de vales
    -- 26/12/2009 - criado
    --->	
    <cffunction name="get_vale_tipo" displayname="" output="true" returntype="query" access="public">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tipo_id, 
                   descricao, 
                   user_insert, 
                   date_insert, 
                   user_update, 
                   date_update, 
                   site
              from oper.v$vale_tipo t
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Busca os vales
    -- 23/12/2009 - criado
    --->	
    <cffunction name="get_vale" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="not_situacao_id" required="no" default="">
    	<cfargument name="num_vale" required="no" default="">
    	<cfargument name="data_inicial" required="no" default="">
    	<cfargument name="data_final" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select v.num_vale, 
                   v.valor, 
                   v.cod_pessoa_funcionario,
                   ps.razao_social as motorista,
                   to_char(v.data_troca,'dd/mm/yyyy hh24:mi:ss') as data_troca, 
                   vt.descricao as tipo,
                   vv.cod_veiculo,
                   v.situacao_id
              from oper.v$vale v
             inner join oper.v$vale_tipo vt
                     on vt.tipo_id = v.tipo_id
              left join oper.v$veiculo vv
                     on vv.placa = v.placa
              left join kss.v$pessoa ps
                     on ps.cod_pessoa = v.cod_pessoa_funcionario
             where 1=1
             <cfif len(trim(arguments.not_situacao_id))>
               and v.situacao_id <> #arguments.not_situacao_id#
             </cfif>
             <cfif len(trim(arguments.num_vale))>
               and v.num_vale = #arguments.num_vale#
             </cfif>
             <cfif len(trim(arguments.data_inicial))>
               and v.data_troca >= '#arguments.data_inicial# 00:00:00'
             </cfif>
             <cfif len(trim(arguments.data_final))>
               and v.data_troca <= '#arguments.data_final# 23:59:59'
             </cfif>
             order by v.num_vale
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
 
</cfcomponent>