<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca as rotas
	-- CRISTOFER  25/10/2006
	--->		
	<cffunction name="get_rota" access="remote" returntype="query" output="true">
		<cfargument name="abreviatura" required="no" default="">
		<cfargument name="rapida" required="no" default="0">
		<cfargument name="origem_municipio_id" required="no" default="">
		<cfargument name="destino_municipio_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.rota_id,
				   r.abreviatura,
				   r.descricao_rota,
				   r.descricao_via,
				   r.origem_municipio_id,
				   cep.fnc_municipio_uf(r.origem_municipio_id,'/') origem,
				   r.origem_cod_pessoa,
				   r.origem_latitude,
				   r.origem_longitude,
				   r.destino_municipio_id,
				   cep.fnc_municipio_uf(r.destino_municipio_id,'/') destino,
				   r.destino_cod_pessoa,
				   r.destino_latitude,
				   r.destino_longitude,
				   r.distancia_padrao,
				   r.distancia_hodometro,
				   r.consolidado,
				   r.user_insert,
				   r.date_insert,
				   r.user_update,
				   r.date_update,
				   r.site
			  from oper.v$rota r	
			 where 1=1
			 <cfif len(trim(arguments.abreviatura))>
			   and upper(r.abreviatura) like upper('#arguments.abreviatura#%')
			 </cfif>
			 <cfif len(trim(arguments.origem_municipio_id))>
			   and r.origem_municipio_id = #arguments.origem_municipio_id#
			 </cfif>
			 <cfif len(trim(arguments.destino_municipio_id))>
			   and r.destino_municipio_id = #arguments.destino_municipio_id#
			 </cfif>
			 <cfif arguments.rapida eq 1>
			   and rownum = 1 
			 </cfif> 			 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
</cfcomponent>