<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!--- 
    -- PROPSITO
    -- Busca os dados do romaneio
    -- 26/12/2009 - criado
    --->	
    <cffunction name="get_romaneio" displayname="" output="true" returntype="query" access="remote">
    	<cfargument name="num_romaneio" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select num_romaneio, 
                   carregamento, 
                   destino, 
                   cliente, 
                   remetente, 
                   destinatario, 
                   data_inicio, 
                   data_destinado, 
                   data_termino, 
                   data_previsao_descarga, 
                   data_previsao_vazio, 
                   data_previsao_carregado, 
                   data_vazio_planejado, 
                   data_carregado_planejado, 
                   num_natureza, 
                   num_especie, 
                   cod_unidade, 
                   frete_em, 
                   peso_total, 
                   peso_cobrado, 
                   volume_total, 
                   m3_total, 
                   frete_liquido, 
                   despacho, 
                   frete_total, 
                   valor_entregue, 
                   km_vazio, 
                   km_carregado, 
                   valor_pedagio_vazio, 
                   valor_pedagio_carregado, 
                   valor_descarga, 
                   org_logradouro, 
                   org_complemento, 
                   org_bairro, 
                   org_cep, 
                   org_municipio_id, 
                   dest_logradouro, 
                   dest_complemento, 
                   dest_bairro, 
                   dest_cep, 
                   dest_municipio_id, 
                   situacao_id, 
                   data_inicio_carga, 
                   data_termino_carga, 
                   data_inicio_descarga, 
                   data_termino_descarga, 
                   placa_controle, 
                   placa_referencia, 
                   cod_pessoa_filial, 
                   mensagem_motorista, 
                   cod_pessoa_atraso_vazio, 
                   bloquear_previsao_vazio, 
                   mensagem_prev_carregado, 
                   cod_pessoa_atraso_carr, 
                   bloquear_previsao_carr, 
                   peso_retorno, 
                   cod_pessoa_responsavel, 
                   muda_filial_responsavel, 
                   observacao, 
                   user_insert, 
                   date_insert, 
                   user_update, 
                   site, 
                   date_update
              from oper.v$romaneio r
             where 1=1
             <cfif len(trim(arguments.num_romaneio))>
               and r.num_romaneio = #arguments.num_romaneio#
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Busca os motoristas do romaneio
    -- 31/12/2008 - criado
    --->	
    <cffunction name="get_romaneio_motoristas" displayname="" output="true" returntype="query" access="remote">
    	<cfargument name="num_romaneio" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mr.cod_registro,
                   p.cod_pessoa,
                   p.cliente as nome
              from oper.v$romaneio_hist_veiculo rh
             inner join kss.v$pessoa p
                     on p.cod_pessoa = rh.cod_pessoa
             inner join oper.v$motorista_reg_historico mr
                     on mr.cod_pessoa = rh.cod_pessoa
                    and rh.DATA_INICIO between mr.data_inicio and nvl(mr.data_fim,rh.data_inicio)
             where 1=1
             <cfif len(trim(arguments.num_romaneio))>
               and num_romaneio = #arguments.num_romaneio#
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
  
  <!--- 
    -- PROPSITO
    -- Busca item de romaneio - operacao internacional
    -- 31/12/2008 - criado
    --->	
    <cffunction name="get_romaneio_item_internacional" displayname="" output="true" returntype="query" access="remote">
    	<cfargument name="num_romaneio" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.num_romaneio,
                   o.internacional                    
              from oper.v$romaneio r
             inner join oper.v$romaneio_item ri
                     on ri.num_romaneio = r.num_romaneio
             left join logistica.v$operacao o
                     on o.operacao_id = ri.operacao_id
             where r.num_romaneio = #arguments.num_romaneio#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
      <!--- 
    -- PROPSITO
    -- Busca dados do romaneio
    -- 23/07/2010 - criado
    --->	
    <cffunction name="get_romaneio_dados" displayname="" output="true" returntype="query" access="remote">
    	<cfargument name="num_romaneio" required="no" default="">
        <cfargument name="placa" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.num_romaneio
            	 , r.data_inicio
                 , cep.fnc_municipio_uf(r.org_municipio_id) || ' - ' || cep.fnc_municipio_uf(r.dest_municipio_id) as origem_destino
                 , rhv.cod_pessoa as cod_motorista
                 , (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = rhv.cod_pessoa) as motorista
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = rhv.cod_pessoa) as cpf
                 , v.veiculo_id
                 , v.cod_veiculo
                 , v.placa
                 , (select v.cod_veiculo
                      from oper.v$veiculo v
                     where v.veiculo_id = oper.pkg_veiculo.fnc_veiculo_id(r.placa_controle)) as frota
             	 ,  r.placa_controle
              from oper.v$romaneio r
              left join oper.v$romaneio_hist_veiculo rhv
                     on rhv.num_romaneio = r.num_romaneio
              left join oper.v$veiculo v
                     on v.veiculo_id = (oper.pkg_veiculo.fnc_veiculo_id(r.placa_controle))                     
             where 1 = 1
             <cfif len(trim(arguments.num_romaneio))>
               	and r.num_romaneio = #arguments.num_romaneio#
             </cfif>
             <cfif not len(trim(arguments.data_inicial))>
               and r.data_inicio >= sysdate - 180
             <cfelse>
               and trunc(r.data_inicio) >= '#arguments.data_inicial#'
             </cfif>
             <cfif len(trim(arguments.data_final))>
               and trunc(r.data_inicio) <= '#arguments.data_final#'
             </cfif>
             <cfif len(trim(arguments.placa))>
               and upper(rhv.placa_controle) like upper('#arguments.placa#%')
             </cfif>
             order by r.data_inicio, r.num_romaneio
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
</cfcomponent>