<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO 
    -- Retorna os roteiros de uma requisio
    -- ANDERSON 10/06/2011 - CRIADO
    --->		
    <cffunction name="get_roteiro" access="remote" returntype="Struct" output="true">
    	<cfargument name="origem_municipio_id" required="no" default="" />
        <cfargument name="destino_municipio_id" required="no" default="" />
        <cftry>
        	<cftransaction action='begin'>
                <cfscript>
					conn = CreateComponent("_transportes.manipulacao.transporte.cfc_repom");
                    ret_cons_rot = conn.consulta_roteiros(ORIGEM_MUNICIPIO_ID  = arguments.origem_municipio_id,
														  DESTINO_MUNICIPIO_ID = arguments.destino_municipio_id);
                </cfscript>
                <cfif ret_cons_rot.erro>
                    <cfthrow object="#ret_cons_rot.mensagem#">
                </cfif>
                
                <cfquery name="qr_roteiro" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select distinct 
                           r.roteiro_id
                         , r.roteiro_codigo
                         , r.percurso_codigo
                         , r.percurso_descricao
                         , r.cidade_origem
                         , r.estado_origem
                         , r.cidade_destino
                         , r.estado_destino
                         , r.processo_transporte_tipo
                         , case
                               when r.processo_transporte_tipo = 0 then 'Contrato'
                               when r.processo_transporte_tipo = 1 then 'Frota'
                               when r.processo_transporte_tipo = 3 then 'Ambos'
                               when r.processo_transporte_tipo = 4 then 'VPR'
                               else ''
                            end as processo_transporte_tipo_desc
                      from repom.v$roteiro r
                     inner join cep.municipio mo
                             on repom.pkg_repom.fnc_formata_texto(mo.municipio) like repom.pkg_repom.fnc_formata_texto(r.cidade_origem)
                            and mo.uf_id = r.estado_origem
                     inner join cep.municipio md
                             on repom.pkg_repom.fnc_formata_texto(md.municipio) like repom.pkg_repom.fnc_formata_texto(r.cidade_destino)
                            and md.uf_id = r.estado_destino
                     where mo.municipio_id = #arguments.origem_municipio_id#
                       and md.municipio_id = #arguments.destino_municipio_id#
                </cfquery>
                
                <cfset retorno.qr_roteiro = qr_roteiro>
                <cfset retorno.erro = false>
            </cftransaction>
			<cfcatch>
            	<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
        </cftry>
        <cfreturn retorno>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as cargas que esto configuradas para a Repom
    -- ANDERSON 13/06/2011 - CRIADO
    --->		
    <cffunction name="get_cargas" access="remote" returntype="query" output="true">
    	<cfargument name="solicitacao_carga_id" required="no" default="" />
        <cfargument name="viagem_id" required="no" default="" />
        <cfargument name="num_romaneio" required="no" default="" />
        <cfargument name="processo_transporte_codigo" required="no" default="" />
        <cfargument name="cod_pessoa_filial" required="no" default="" />
        <cfargument name="cod_centro_custo" required="no" default="" />
        <cfargument name="origem_municipio_id" required="no" default="" />
        <cfargument name="destino_municipio_id" required="no" default="" />
        <cfargument name="veiculo_id_cavalo" required="no" default="" />
        <cfargument name="veiculo_id_carreta" required="no" default="" />
        <cfargument name="cod_motorista" required="no" default="" />
        <cfargument name="modalidade" required="no" default="" />
        <cfargument name="tipo_pagamento_id" required="no" default="" />
        <cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_termino" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.solicitacao_carga_id
                 , c.viagem_id
                 , c.num_romaneio
                 , c.situacao
                 , c.tipo_pagamento
                 , c.operacao_repom
                 , c.cartao_ok
                 , c.cartao_numero
                 , c.cartao_taxa_ativacao
                 , case
                      when c.contrato_emitido = 1 then 1
                      else c.rota_ok
                   end as rota_ok
                 , c.valor_pedagio_rota
                 , case
                      when c.contrato_emitido = 1 then 1
                      else c.contratado_ok
                   end as contratado_ok
                 , case
                      when c.contrato_emitido = 1 then 1
                      else c.motorista_ok
                   end as motorista_ok
                 , case
                      when c.contrato_emitido = 1 then 1
                      else c.veiculo_ok
                   end as veiculo_ok
                 , c.adto_trajeto_vazio
                 , c.contrato_emitido
                 , c.numero_contrato
                 , c.valor_contrato
                 , c.cnpj_cpf_remetente
                 , c.remetente
                 , c.origem
                 , to_char(c.data_carregamento_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_carregamento_inicio
                 , to_char(c.data_carregamento_fim, 'dd/mm/yyyy hh24:mi:ss') as data_carregamento_fim
                 , c.cnpj_cpf_destinatario
                 , c.destinatario
                 , c.destino
                 , to_char(c.data_entrega_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_entrega_inicio
                 , to_char(c.data_entrega_fim, 'dd/mm/yyyy hh24:mi:ss') as data_entrega_fim
                 , c.dias_atraso
                 , c.operacao_id
                 , c.operacao
                 , c.modalidade_desc
                 , c.composicao
                 , oper.pkg_veiculo.fnc_numero_eixos_composicao(oper.pkg_veiculo.fnc_placa(c.veiculo_id_cavalo), oper.pkg_veiculo.fnc_placa(c.veiculo_id_carreta)) as numero_eixos
                 , c.motorista
                 , c.num_natureza
                 , c.natureza
                 , c.grupo_natureza
                 , c.peso_m3
                 , c.frete_em
                 , c.user_insert
                 , to_char(c.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , c.user_update
                 , to_char(c.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update
              from repom.v$cargas c
             where 1 = 1
			<cfif Len(Trim(arguments.solicitacao_carga_id))>
               and c.solicitacao_carga_id = #arguments.solicitacao_carga_id#
            <cfelseif Len(Trim(arguments.viagem_id))>
               and c.viagem_id = #arguments.viagem_id#
            <cfelseif Len(Trim(arguments.num_romaneio))>
               and c.num_romaneio = #arguments.num_romaneio#
            <cfelseif Len(Trim(arguments.processo_transporte_codigo))>
               and exists (select 1
                             from repom.v$contrato ct
                            where ct.num_romaneio = c.num_romaneio
                              and ct.processo_transporte_codigo = #arguments.processo_transporte_codigo#
                          )
            <cfelse>
                and c.situacao_id <> 5
            	<cfif Len(Trim(arguments.cod_pessoa_filial))>
					and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                </cfif>
                <cfif Len(Trim(arguments.cod_centro_custo))>
					and c.cod_centro_custo = #arguments.cod_centro_custo#
                </cfif>
                <cfif Len(Trim(arguments.origem_municipio_id))>
					and c.origem_municipio_id = #arguments.origem_municipio_id#
                </cfif>
                <cfif Len(Trim(arguments.destino_municipio_id))>
					and c.destino_municipio_id = #arguments.destino_municipio_id#
                </cfif>
                <cfif Len(Trim(arguments.veiculo_id_cavalo))>
					and c.veiculo_id_cavalo = #arguments.veiculo_id_cavalo#
                </cfif>
                <cfif Len(Trim(arguments.veiculo_id_carreta))>
					and c.veiculo_id_carreta = #arguments.veiculo_id_carreta#
                </cfif>
                <cfif Len(Trim(arguments.cod_motorista))>
					and c.cod_motorista = #arguments.cod_motorista#
                </cfif>
                <cfif Len(Trim(arguments.modalidade))>
					and c.modalidade = '#arguments.modalidade#'
                </cfif>
                <cfif Len(Trim(arguments.tipo_pagamento_id))>
					and c.tipo_pagamento_id = #arguments.tipo_pagamento_id#
                </cfif>
                <cfif Len(Trim(arguments.data_inicio))>
                    and c.data_carregamento_inicio >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
                </cfif>
                <cfif Len(Trim(arguments.data_termino))>
                    and c.data_carregamento_fim <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                </cfif>
            </cfif>
             order by c.data_carregamento_inicio, c.data_carregamento_fim
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os contratos
    -- ANDERSONC 01/11/2011 - CRIADO
    --->		
    <cffunction name="get_contrato" access="remote" returntype="query" output="true">
    	<cfargument name="contrato_id" required="no" default="" />
        <cfargument name="solicitacao_carga_id" required="no" default="" />
        <cfargument name="viagem_id" required="no" default="" />
        <cfargument name="num_romaneio" required="no" default="" />
        <cfargument name="lancto_id" required="no" default="" />
        <cfargument name="processo_transporte_codigo" required="no" default="" />
        <cfargument name="internacional" required="no" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.contrato_id
                 , c.tipo_contrato
                 , kss.fnc_ref_code('REPOM', 'REPOM.TIPO_CONTRATO', c.tipo_contrato) as tipo_contrato_desc
                 , c.cod_pessoa_filial
                 , kss.pkg_pessoa.fnc_get_cliente(c.cod_pessoa_filial, 1) as filial
                 , c.num_romaneio
                 , c.processo_cliente_codigo
                 , c.cartao_id
                 , (select crt.cartao_numero
                      from repom.v$cartao crt
                     where crt.cartao_id = c.cartao_id
                   ) as cartao_numero
                 , c.cod_proprietario
                 , kss.pkg_pessoa.fnc_get_cliente(c.cod_proprietario, 1) as proprietario
                 , c.cod_motorista
                 , kss.pkg_pessoa.fnc_get_cliente(c.cod_motorista, 1) as motorista
                 , c.veiculo_id_cavalo
                 , oper.pkg_veiculo.fnc_placa(c.veiculo_id_cavalo) as placa_cavalo
                 , c.veiculo_id_carreta
                 , oper.pkg_veiculo.fnc_placa(c.veiculo_id_carreta) as placa_carreta
                 , c.rota_id
                 , c.valor_inicial_adiantamento
                 , c.valor_inicial_frete
                 , c.internacional
                 , c.situacao_id
                 , kss.fnc_ref_code('REPOM', 'CONTRATO_MOVIMENTO.SITUACAO_ID', c.situacao_id) as situacao
                 , c.requisicao_id
                 , c.processo_transporte_codigo
                 , c.lancto_id
                 , c.usuario_cancelamento
                 , to_char(c.data_cancelamento, 'dd/mm/yyyy hh24:mi:ss') as data_cancelamento
                 , (select sign(count(1))
                      from repom.v$contrato_quitacao cq
                     where cq.contrato_id = c.contrato_id
                   ) as contrato_quitado
                 , (select cq.contrato_quitacao_id
                      from repom.v$contrato_quitacao cq
                     where cq.contrato_id = c.contrato_id
                   ) as contrato_quitacao_id
                 , (select sign(count(1))
                      from repom.v$contrato_pagamento cp
                     where cp.contrato_id = c.contrato_id 
                   ) as pagamento_autorizado
                 , (select count(1)
                      from repom.v$contrato_pagamento cp
                     where cp.contrato_id = c.contrato_id 
                   ) as contrato_pagamento
              from repom.v$contrato c
             where 1 = 1
            <cfif Len(Trim(arguments.contrato_id))>
              and c.contrato_id = #arguments.contrato_id#
            </cfif>
            <cfif Len(Trim(arguments.solicitacao_carga_id))>
               and exists (select 1
                             from logistica.v$viagem v
                            inner join logistica.v$viagem_carga vc
                                    on vc.viagem_id = v.viagem_id
                            where v.num_romaneio = c.num_romaneio
                              and vc.solicitacao_carga_id = #arguments.solicitacao_carga_id#
                          )
            </cfif>
            <cfif Len(Trim(arguments.viagem_id))>
               and exists (select 1
                             from logistica.v$viagem v
                            where v.num_romaneio = c.num_romaneio
                              and v.viagem_id = #arguments.viagem_id#
                          )
            </cfif>
            <cfif Len(Trim(arguments.num_romaneio))>
               and c.num_romaneio = #arguments.num_romaneio#
            </cfif>
            <cfif Len(Trim(arguments.lancto_id))>
               and c.lancto_id = #arguments.lancto_id#
            </cfif>
            <cfif Len(Trim(arguments.processo_transporte_codigo))>
               and c.processo_transporte_codigo = #arguments.processo_transporte_codigo#
            </cfif>
            <cfif Len(Trim(arguments.internacional))>
               and c.internacional = #arguments.internacional#
            </cfif>
             order by c.processo_transporte_codigo
		</cfquery>
		<cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os dados do romaneio/repom
    -- FABIOG 15/06/2011 - CRIADO
    --->		
    <cffunction name="get_dados_romaneio" access="remote" returntype="query" output="true">
    	<cfargument name="solicitacao_carga_id" required="no" default="" />
        <cfargument name="viagem_id" required="no" default="" />
        <cfargument name="num_romaneio" required="no" default="" />
        <cfargument name="processo_transporte_codigo" required="no" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.num_romaneio
                 , r.placa_controle
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_controle) as cod_veiculo_controle
                 , r.placa_referencia
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_referencia) as cod_veiculo_referencia
                 , r.remetente
                 , r.carregamento
                 , r.destinatario
                 , r.destino
                 , (select n.descricao
                      from oper.v$natureza n
                     where n.num_natureza = r.num_natureza
                   ) as natureza 
                 , (select e.descricao
                      from oper.v$especie e
                     where e.num_especie = r.num_especie
                   ) as especie 
                 , (select um.unidade
                      from fiscal.v$unidade_medida um
                     where um.cod_unidade = r.cod_unidade
                   ) as unidade 
                 , r.frete_em
                 , r.peso_total
                 , r.peso_cobrado
                 , r.frete_total
                 , r.valor_pedagio_vazio
                 , r.valor_pedagio_carregado
                 , r.frete_liquido 
                 , to_char(r.data_inicio, 'dd/mm/yyyy hh24:mi') as data_inicio
                 , to_char(r.data_destinado, 'dd/mm/yyyy hh24:mi') as data_destinado
                 , to_char(r.data_inicio_carga, 'dd/mm/yyyy hh24:mi') as data_inicio_carga
                 , to_char(r.data_termino_carga, 'dd/mm/yyyy hh24:mi') as data_termino_carga
                 , to_char(r.data_inicio_descarga, 'dd/mm/yyyy hh24:mi') as data_inicio_descarga
                 , to_char(r.data_termino_descarga, 'dd/mm/yyyy hh24:mi') as data_termino_descarga
              from oper.v$romaneio r
             where r.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os dados do romaneio/repom
    -- FABIOG 16/06/2011 - CRIADO
    --->		
    <cffunction name="get_dados_contrato" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.contrato_id
                 , c.processo_transporte_codigo
                 , c.num_romaneio
                 , c.lancto_id
                 , (select ca.cartao_numero
                      from repom.v$cartao ca
                     where ca.cartao_id = c.cartao_id 
                   ) as cartao_numero
                 , c.valor_inicial_adiantamento
                 , c.valor_inicial_frete
                 , c.usuario_cancelamento
                 , to_char(c.data_cancelamento, 'dd/mm/yyyy hh24:mi') as data_cancelamento
                 , (select count(1)
                      from repom.v$contrato_quitacao cq
                     where cq.contrato_id = c.contrato_id
                   ) as contrato_quitado
                 , (select cq.contrato_quitacao_id
                      from repom.v$contrato_quitacao cq
                     where cq.contrato_id = c.contrato_id
                   ) as contrato_quitacao_id
                 , (select count(1)
                      from repom.v$contrato_pagamento cp
                     where cp.contrato_id = c.contrato_id 
                   ) as contrato_pagamento
              from repom.v$contrato c
             where c.num_romaneio = #arguments.num_romaneio#
             order by c.processo_transporte_codigo
		</cfquery>
		<cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os dados do contrato/repom para o n processo_transporte
    -- FABIOG 16/06/2011 - CRIADO
    --->		
    <cffunction name="get_dados_contr_proc_trans" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select extractvalue(t.xml_retorno, 'processo_transporte/processo_transporte_codigo') as processo_transporte_codigo
                     , extractvalue(t.xml_retorno, 'processo_transporte/processo_transporte_codigo_cliente') as processo_transporte_cod_cli
                     , extractvalue(t.xml_retorno, 'processo_transporte/processo_cliente_filial_codigo_cliente') as processo_cli_filial_cod_cli
                     , extractvalue(t.xml_retorno, 'processo_transporte/status_descricao') as status_descricao
                     , extractvalue(t.xml_retorno, 'processo_transporte/valor_saldo') as valor_saldo
                     , extractvalue(t.xml_retorno, 'processo_transporte/data_quitacao') as data_quitacao
                     , extractvalue(t.xml_retorno, 'processo_transporte/data_pagamento') as data_pagamento
                     , extractvalue(t.xml_retorno, 'processo_transporte/valor_pedagio') as valor_pedagio
                     , extractvalue(t.xml_retorno, 'processo_transporte/status_pedagio_descricao') as status_pedagio_descricao
                     , extractvalue(t.xml_retorno, 'processo_transporte/data_carregamento_pedagio') as data_carregamento_pedagio
                     , extractvalue(t.xml_retorno, 'processo_transporte/valor_pedagio_descargas') as valor_pedagio_descargas
                     , extractvalue(t.xml_retorno, 'processo_transporte/ordem_servico_codigo') as ordem_servico_codigo
                     , extractvalue(t.xml_retorno, 'processo_transporte/cidade_origem_nome') as cidade_origem_nome
                     , extractvalue(t.xml_retorno, 'processo_transporte/cidade_origem_estado') as cidade_origem_estado
                     , extractvalue(t.xml_retorno, 'processo_transporte/cidade_destino_nome') as cidade_destino_nome
                     , extractvalue(t.xml_retorno, 'processo_transporte/cidade_destino_estado') as cidade_destino_estado
                     , extractvalue(t.xml_retorno, 'processo_transporte/percurso_descricao') as percurso_descricao
                     , extractvalue(t.xml_retorno, 'processo_transporte/operacao_codigo') as operacao_codigo
                     , extractvalue(t.xml_retorno, 'processo_transporte/operacao_descricao') as operacao_descricao
                     , extractvalue(t.xml_retorno, 'processo_transporte/filial_codigo') as filial_codigo
                     , extractvalue(t.xml_retorno, 'processo_transporte/filial_codigo_cliente') as filial_codigo_cliente
                     , extractvalue(t.xml_retorno, 'processo_transporte/filial_descricao') as filial_descricao
                     , extractvalue(t.xml_retorno, 'processo_transporte/cavalo_placa') as cavalo_placa
                     , extractvalue(t.xml_retorno, 'processo_transporte/cavalo_estado') as cavalo_estado
                     , extractvalue(t.xml_retorno, 'processo_transporte/cavalo_marca') as cavalo_marca
                     , (select un.cod_unidade_negocio || ' - ' || un.unidade_negocio
                          from kss.v$unidade_negocio un
                         where un.cod_unidade_negocio = extractvalue(t.xml_retorno, 'processo_transporte/processo_cliente_filial_codigo_cliente')
                       ) as unidade_negocio
                  from (
                        select repom.pkg_comunicacao.fnc_xml_retorno_requisicao(#arguments.REQUISICAO_ID#) as xml_retorno
                          from dual
                       ) t
		</cfquery>
		<cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os dados do contrato/repom para o n movimento/movimentos
    -- FABIOG 16/06/2011 - CRIADO
    --->		
    <cffunction name="get_dados_contr_proc_trans_movi" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select nvl((select tp.descricao
                          from repom.v$tipo_movimento tp
                         where tp.movimento_codigo = extractvalue(t.column_value, 'movimento/movimento_codigo')
                       ), 'DESCRIO NO DEFINIDA'
                      ) as descricao
                 , to_char(replace(extractvalue(t.column_value, 'movimento/valor'), ',', ''), 'FM9G9999G990D00', 'nls_numeric_characters=,.') as valor
                 , extractvalue(t.column_value, 'movimento/data') as data
              from table(xmlsequence(extract(repom.pkg_comunicacao.fnc_xml_retorno_requisicao(#arguments.REQUISICAO_ID#), '/processo_transporte/movimentos/movimento'))) t
		</cfquery>
		<cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os dados do contrato/repom para o n cupons/cupom   
    -- FABIOG 16/06/2011 - CRIADO
    --->		
    <cffunction name="get_dados_contr_proc_trans_cupom" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select extractvalue(t.column_value, 'cupom/cupom_codigo') as cupom_codigo
                     , extractvalue(t.column_value, 'cupom/posto') as posto
                     , extractvalue(t.column_value, 'cupom/data') as data
                     , extractvalue(t.column_value, 'cupom/hora') as hora
                  from table(xmlsequence(extract(repom.pkg_comunicacao.fnc_xml_retorno_requisicao(#arguments.REQUISICAO_ID#), '/processo_transporte/cupons/cupom'))) t
		</cfquery>
		<cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os dados do contrato/repom para o n itens/item   
    -- FABIOG 16/06/2011 - CRIADO
    --->		
    <cffunction name="get_dados_contr_proc_trans_item" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select extractvalue(t.column_value, 'item/quantidade') as quantidade
                     , extractvalue(t.column_value, 'item/valor') as valor
                     , extractvalue(t.column_value, 'item/data_vencimento_nf') as data_vencimento_nf
                     , extractvalue(t.column_value, 'item/produto') as produto
                  from table(xmlsequence(extract(repom.pkg_comunicacao.fnc_xml_retorno_requisicao(#arguments.REQUISICAO_ID#), '/processo_transporte/cupons/cupom/itens/item'))) t
		</cfquery>
		<cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os dados do contrato/repom para o n itens/item   
    -- FABIOG 16/06/2011 - CRIADO
    --->		
    <cffunction name="get_dados_cartao" access="remote" returntype="query" output="true">
    	<cfargument name="solicitacao_carga_id" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select sc.solicitacao_carga_dados_id
                     , sc.solicitacao_carga_id
                     , sc.cartao_id
                     , (select c.cartao_numero
                          from repom.v$cartao c
                         where c.cartao_id = sc.cartao_id
                       )as cartao_numero
                     , sc.adto_trajeto_vazio 
                  from repom.v$solicitacao_carga_dados sc
                 where sc.solicitacao_carga_id = #arguments.SOLICITACAO_CARGA_ID#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>
    
      <!--- 
	  -- PROPSITO 
      -- Retorna os dados de Grupo de Mercadoria 
	  -- FABIOG 17/07/2011 - CRIADO
	  --->		
    <cffunction name="get_romaneio_itens" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select logistica.pkg_operacao.fnc_descricao_completa(ri.operacao_id) as operacao
                     , kss.pkg_pessoa.fnc_get_cliente(ri.cod_remetente) as remetente
                     , kss.pkg_pessoa.fnc_get_cliente(ri.cod_destinatario) as destinatario  
                     , (select case
                                 when o.internacional = 0 then 'No'
                                 else 'Sim'
                               end as internacional
                          from logistica.v$operacao o
                         where o.operacao_id = ri.operacao_id
                       )as internacional
                     , case
                        when exists (select 1
                                       from fiscal.v$conhecimento c 
                                      where c.num_romaneio = ri.num_romaneio
                                      
                                     union all
                                       
                                     select 1
                                       from fiscal.v$nf_es_frete f
                                      where f.num_romaneio = ri.num_romaneio
                                       
                                      union all
                                       
                                     select 1
                                       from oper.v$romaneio_intc_conhecimento c
                                      where c.num_romaneio = ri.num_romaneio
                                    ) then 'Sim'
                         else 'No'
                       end as documento_emitido
                  from oper.v$romaneio_item ri
                 where ri.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>
    
     <!--- 
	  -- PROPSITO 
      -- Retorna os dados de Grupo de Mercadoria 
	  -- FABIOG 18/07/2011 - CRIADO
	  --->		
    <cffunction name="get_dados_agendamento" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select v.composicao
                     , kss.pkg_pessoa.fnc_get_cliente(v.cod_motorista) as motorista
                     , to_char(v.data_inicio, 'dd/mm/yyyy hh24:mi') as data_inicio
                     , to_char(v.data_termino, 'dd/mm/yyyy hh24:mi') as data_termino
                  from logistica.v$viagem v
                 where v.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>
    
     <!--- 
	  -- PROPSITO 
      -- Retorna os dados de Grupo de Mercadoria 
	  -- FABIOG 18/07/2011 - CRIADO
	  --->		
    <cffunction name="get_solicitacoes" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
               select kss.pkg_pessoa.fnc_get_cliente(sc.cod_remetente) as remetente
                     , kss.pkg_pessoa.fnc_get_cliente(sc.cod_destinatario) as destinatario
                     , (select m.municipio || ' - ' || m.uf_id
                          from cep.municipio m
                         where m.municipio_id = sc.origem_municipio_id
                       ) as origem 
                      , (select m.municipio || ' - ' || m.uf_id
                          from cep.municipio m
                         where m.municipio_id = sc.destino_municipio_id
                       ) as destino 
                     , (select n.descricao
                          from oper.v$natureza n
                         where n.num_natureza = sc.num_natureza
                       ) as natureza
                  from logistica.v$solicitacao_carga sc
                 inner join logistica.v$viagem_carga vc
                         on vc.solicitacao_carga_id = sc.solicitacao_carga_id
                 inner join logistica.v$viagem v
                         on v.viagem_id = vc.viagem_id
                 where  v.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>
    
      <!--- 
	  -- PROPSITO 
      -- Retorna os dados do itinerario
	  -- FABIOG 18/07/2011 - CRIADO
	  --->		
    <cffunction name="get_itinerarios" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (select r.descricao_rota
                      from oper.v$rota r
                     where r.rota_id = ri.rota_id
                   ) as descricao
            	 , (select m.municipio || ' - ' || m.uf_id
                      from cep.municipio m
                     where m.municipio_id = ri.origem_municipio_id
                   ) as origem
                 , (select m.municipio || ' - ' || m.uf_id
                      from cep.municipio m
                     where m.municipio_id = ri.destino_municipio_id
                   ) as destino 
                 , to_char(ri.data_chegada, 'dd/mm/yyyy hh24:mi') as data
                 , null as tipo
              from oper.v$romaneio_itinerario ri
             where ri.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>
    
    
      <!--- 
	  -- PROPSITO 
      -- Retorna os dados do itinerario
	  -- FABIOG 18/07/2011 - CRIADO
	  --->		
    <cffunction name="get_contrato_transp" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select kss.pkg_pessoa.fnc_get_cliente(ct.cod_pessoa_filial) as filial
                 , to_char(ct.data_emissao, 'dd/mm/yyyy hh24:mi') as data_emissao
                 , ct.lancto_id
                 , ct.valor_frete_bruto as valor
                 , kss.pkg_pessoa.fnc_get_cliente(ct.proprietario_cod_pessoa) as proprietario
                 , kss.pkg_pessoa.fnc_get_cliente(ct.motorista_cod_pessoa) as motorista
              from oper.v$contrato_transp ct
             where ct.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>
    
        <!--- 
	  -- PROPSITO 
      -- Retorna os dados do itinerario
	  -- FABIOG 18/07/2011 - CRIADO
	  --->		
    <cffunction name="get_documetos" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select 'CTRC' as tipo
                 , to_char(c.data_emissao, 'dd/mm/yyyy hh24:mi') as data_emissao
                 , c.num_conhecimento as num_documento
                 , kss.pkg_pessoa.fnc_get_cliente(c.cod_pessoa_filial) as filial
                 , kss.pkg_pessoa.fnc_get_cliente(c.cod_remetente) as remetente
                 , kss.pkg_pessoa.fnc_get_cliente(c.cod_destinatario) as destinatario 
              from fiscal.v$conhecimento c 
             where c.num_romaneio = #arguments.num_romaneio#
                                                     
              union all
                                                      
            select 'NF Frete' as tipo
                 , null as data_emissao
                 , null as num_documento
                 , null as filial
                 , kss.pkg_pessoa.fnc_get_cliente(f.cod_remetente) as remetente
                 , kss.pkg_pessoa.fnc_get_cliente(f.cod_destinatario) as destinatario 
              from fiscal.v$nf_es_frete f
             where f.num_romaneio = #arguments.num_romaneio#
                                                      
              union all
                                                      
            select 'CRT' as tipo
                 , to_char(c2.data_emissao, 'dd/mm/yyyy hh24:mi') as data_emissao
                 , c2.num_conhecimento as num_documento
                 , kss.pkg_pessoa.fnc_get_cliente(c2.cod_pessoa_filial) as filial
                 , kss.pkg_pessoa.fnc_get_cliente(c2.cod_remetente) as remetente
                 , kss.pkg_pessoa.fnc_get_cliente(c2.cod_destinatario) as destinatario 
              from oper.v$romaneio_intc_conhecimento ic
             inner join fiscal.v$conhecimento c2
                     on c2.conhecimento_id = ic.conhecimento_id
             where c2.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o histrico da utilizao dos cartes Repom
    -- ANDERSON 10/09/2011 - CRIADO
    --->		
    <cffunction name="get_historico_cartao" access="remote" returntype="query" output="true">
    	<cfargument name="cartao_numero" required="no" default="" />
        <cfargument name="cod_motorista" required="no" default="" />
        <cfargument name="cod_proprietario" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.processo_transporte_codigo
                 , t.num_romaneio
                 , t.unidade_negocio
                 , t.centro_custo
                 , t.cartao_numero
                 , t.proprietario_cnpj_cpf
                 , t.proprietario_razao_social
                 , t.proprietario
                 , t.motorista_cpf
                 , t.motorista
                 , t.cod_veiculo_cavalo
                 , t.placa_cavalo
                 , t.cod_veiculo_carreta
                 , t.placa_carreta
                 , t.user_insert
                 , to_char(t.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , t.usuario_cancelamento
                 , to_char(t.data_cancelamento, 'dd/mm/yyyy hh24:mi:ss') as data_cancelamento
              from (
                    select ct.processo_transporte_codigo
                         , ct.num_romaneio
                         , (select o.cod_unidade_negocio || ' - ' || kss.pkg_pessoa.fnc_get_cliente(o.cod_pessoa, 1)
                              from logistica.v$viagem v
                             inner join logistica.v$viagem_carga vc
                                     on vc.viagem_id = v.viagem_id
                             inner join logistica.v$solicitacao_carga sc
                                     on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                             inner join kss.v$organograma o
                                     on o.cod_organograma = sc.cod_organograma
                             where v.num_romaneio = ct.num_romaneio
                               and rownum = 1
                           ) as unidade_negocio
                         , (select o.cod_centro_custo || ' - ' || cc.centro_custo
                              from logistica.v$viagem v
                             inner join logistica.v$viagem_carga vc
                                     on vc.viagem_id = v.viagem_id
                             inner join logistica.v$solicitacao_carga sc
                                     on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                             inner join kss.v$organograma o
                                     on o.cod_organograma = sc.cod_organograma
                             inner join kss.v$centro_custo cc
                                     on cc.cod_centro_custo = o.cod_centro_custo
                             where v.num_romaneio = ct.num_romaneio
                               and rownum = 1
                           ) as centro_custo
                         , c.cartao_numero
                         , kss.pkg_pessoa.fnc_get_identificador(ct.cod_proprietario) as proprietario_cnpj_cpf
                         , kss.pkg_pessoa.fnc_get_cliente(ct.cod_proprietario) as proprietario_razao_social
                         , kss.pkg_pessoa.fnc_get_cliente(ct.cod_proprietario, 1) as proprietario
                         , kss.pkg_pessoa.fnc_get_identificador(ct.cod_motorista) as motorista_cpf
                         , kss.pkg_pessoa.fnc_get_cliente(ct.cod_motorista, 1) as motorista
                         , oper.pkg_veiculo.fnc_placa(ct.veiculo_id_cavalo) as placa_cavalo
                         , oper.pkg_veiculo.fnc_cod_veiculo(ct.veiculo_id_cavalo) as cod_veiculo_cavalo
                         , oper.pkg_veiculo.fnc_placa(ct.veiculo_id_carreta) as placa_carreta
                         , oper.pkg_veiculo.fnc_cod_veiculo(ct.veiculo_id_carreta) as cod_veiculo_carreta
                         , ct.user_insert
                         , ct.date_insert
                         , ct.usuario_cancelamento
                         , ct.data_cancelamento
                      from repom.v$contrato ct
                     inner join repom.v$cartao c
                             on c.cartao_id = ct.cartao_id
                     where 1 = 1
                       and (
                            <cfif Len(Trim(arguments.cartao_numero))>
								c.cartao_numero = #arguments.cartao_numero#
                            </cfif>
                            
                            <cfif Len(Trim(arguments.cod_motorista))>
								<cfif Len(Trim(arguments.cartao_numero))>
                                	or
                                </cfif>
                                ct.cod_motorista = #arguments.cod_motorista#
                            </cfif>
                            
                            <cfif Len(Trim(arguments.cod_proprietario))>
                            	<cfif Len(Trim(arguments.cartao_numero)) or Len(Trim(arguments.cod_motorista))>
                                    or
                                </cfif>
                                ct.cod_proprietario = #arguments.cod_proprietario#
                            </cfif>
                           )
                     order by ct.date_insert desc
                   ) t
             where rownum <= 10
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o status de validao das integraes com a Repom
    -- ANDERSON 22/09/2011 - CRIADO
    --->		
    <cffunction name="get_validacao_romaneio" access="remote" returntype="query" output="true">
        <cfargument name="num_romaneio" required="yes" />
        <cfargument name="cartao_numero" required="yes" />
        <cfargument name="rota_id" required="yes" />
        <cfargument name="cod_contratado" required="yes" />
        <cfargument name="cod_motorista" required="yes" />
        <cfargument name="placa_cavalo" required="yes" />
        <cfargument name="placa_carreta" required="yes" />
        
        <cfif arguments.placa_carreta eq arguments.placa_cavalo>
			<cfset arguments.placa_carreta = '' />
        </cfif>
        <cfif Len(Trim(arguments.num_romaneio))>
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select case
                          when '#arguments.cartao_numero#' is not null then
                             (select sign(count(1))
                                from repom.v$cartao c
                               where c.cartao_numero = '#arguments.cartao_numero#'
                                 and c.requisicao_id is not null
                             )
                          else
                             (select sign(count(1))
                                from logistica.v$viagem_carga vc
                               inner join repom.v$solicitacao_carga_dados scd
                                       on scd.solicitacao_carga_id = vc.solicitacao_carga_id
                               inner join repom.v$cartao c
                                       on c.cartao_id = scd.cartao_id
                               where vc.viagem_id = v.viagem_id
                                 and vc.solicitacao_carga_id = (select max(scd2.solicitacao_carga_id) keep(dense_rank last order by scd2.date_insert)
                                                                  from logistica.v$viagem_carga vc2
                                                                 inner join repom.v$solicitacao_carga_dados scd2
                                                                         on scd2.solicitacao_carga_id = vc2.solicitacao_carga_id
                                                                 where vc2.viagem_id = vc.viagem_id
                                                               )
                                 and c.requisicao_id is not null
                             )
                       end as cartao_ok
                     , case
                          when '#arguments.rota_id#' is not null then
                             repom.pkg_logistica.fnc_rota_ok(null, v.viagem_id, '#arguments.rota_id#')
                          else 0
                       end as rota_ok
                     , case
                          when '#arguments.cod_contratado#' is not null then
                             repom.pkg_logistica.fnc_contratado_ok(null, v.viagem_id, '#arguments.cod_contratado#')
                          else 0
                       end as contratado_ok
                     , case
                          when '#arguments.cod_motorista#' is not null then
                             repom.pkg_logistica.fnc_motorista_ok(null, v.viagem_id, '#arguments.cod_motorista#')
                          else 0
                       end as motorista_ok
                     , case
                          when '#arguments.placa_cavalo#' is not null and '#arguments.placa_carreta#' is not null then
                             repom.pkg_logistica.fnc_veiculo_ok(null, v.viagem_id, '#arguments.placa_cavalo#', '#arguments.placa_carreta#')
                          else 0
                       end as veiculo_ok
                     , case
                          when '#arguments.placa_cavalo#' is not null then
                             oper.pkg_veiculo.fnc_numero_eixos_composicao('#arguments.placa_cavalo#', '#arguments.placa_carreta#')
                          else 0
                       end as numero_eixos
                  from logistica.v$viagem v
                 where v.num_romaneio = #arguments.num_romaneio#
            </cfquery>
		<cfelse>
        	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select (select sign(count(1))
                          from repom.v$cartao c
                         where c.cartao_numero = '#arguments.cartao_numero#'
                           and c.requisicao_id is not null
                       ) as cartao_ok
                     , case
                          when '#arguments.rota_id#' is not null then
                             repom.pkg_logistica.fnc_rota_ok(null, null, '#arguments.rota_id#')
                          else 0
                       end as rota_ok
                     , case
                          when '#arguments.cod_contratado#' is not null then
                             repom.pkg_logistica.fnc_contratado_ok(null, null, '#arguments.cod_contratado#')
                          else 0
                       end as contratado_ok
                     , case
                          when '#arguments.cod_motorista#' is not null then
                             repom.pkg_logistica.fnc_motorista_ok(null, null, '#arguments.cod_motorista#')
                          else 0
                       end as motorista_ok
                     , case
                          when '#arguments.placa_cavalo#' is not null and '#arguments.placa_carreta#' is not null then
                             repom.pkg_logistica.fnc_veiculo_ok(null, null, '#arguments.placa_cavalo#', '#arguments.placa_carreta#')
                          else 0
                       end as veiculo_ok
                     , case
                          when '#arguments.placa_cavalo#' is not null then
                             oper.pkg_veiculo.fnc_numero_eixos_composicao('#arguments.placa_cavalo#', '#arguments.placa_carreta#')
                          else 0
                       end as numero_eixos
                  from dual
            </cfquery>
        </cfif>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os mtodos da Repom
    -- ANDERSON 03/10/2011 - CRIADO
    --->		
    <cffunction name="get_metodo" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.metodo
              from repom.v$metodo m
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as requisies da Repom
    -- ANDERSON 03/10/2011 - CRIADO
    --->		
    <cffunction name="get_requisicao" access="remote" returntype="query" output="true">
    	<cfargument name="metodo" required="no" default="" />
        <cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_termino" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.requisicao_id
                 , r.metodo
                 , kss.to_tempo(r.tempo_execucao, 5).retorno as tempo_execucao
                 , case
                      when r.erro is not null then 1
                      else 0
                   end as possui_erro
                 , r.user_insert
                 , to_char(r.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , r.user_update
                 , to_char(r.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update
              from repom.v$requisicao r
             where 1 = 1
			<cfif Len(Trim(arguments.metodo))>
               and upper(r.metodo) = upper('#arguments.metodo#')
			</cfif>
            
            <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
               and r.date_insert between to_date('#arguments.data_inicio#:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_termino#:59', 'dd/mm/yyyy hh24:mi:ss')
			<cfelseif Len(Trim(arguments.data_inicio))>
               and r.date_insert >= to_date('#arguments.data_inicio#:00', 'dd/mm/yyyy hh24:mi:ss')
			<cfelseif Len(Trim(arguments.data_termino))>
               and r.date_insert <= to_date('#arguments.data_termino#:59', 'dd/mm/yyyy hh24:mi:ss')
			</cfif>
             order by r.date_insert desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o XML de Envio de uma requisio
    -- ANDERSON 03/10/2011 - CRIADO
    --->		
    <cffunction name="get_requisicao_xml_envio" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.xml_envio.getClobVal() as xml_envio
              from repom.v$requisicao r
             where r.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o XML de Retorno de uma requisio
    -- ANDERSON 03/10/2011 - CRIADO
    --->		
    <cffunction name="get_requisicao_xml_retorno" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select xml_retorno
              from repom.v$requisicao r
             where r.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o Erro de uma requisio
    -- ANDERSON 03/10/2011 - CRIADO
    --->		
    <cffunction name="get_requisicao_erro" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.erro
              from repom.v$requisicao r
             where r.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
</cfcomponent>