<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Busca a planilha de produo estimada
    -- 26/03/2009 - criado
    --->	
    <cffunction name="get_producao_estimada" displayname="" output="true" returntype="query" access="remote">
    	<cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfargument name="cod_cliente" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pe.controle_id,
                   pe.cod_cliente,
                   pe.cod_pessoa_filial,
                   p.cnpj_cpf,
                   p.cliente,
                   p.razao_social,
                   to_char(pe.data,'dd/mm/yyyy hh24:mi:ss') as data,
                   pe.origem_municipio_id,
                   pe.destino_municipio_id,
                   cep.fnc_municipio_uf(pe.origem_municipio_id,'-') origem_municipio_uf,
                   cep.fnc_municipio_uf(pe.destino_municipio_id,'-') destino_municipio_uf,
                   pe.num_natureza,
                   n.descricao as natureza,
                   pe.valor,
                   pe.valor_unitario,
                   pe.valor_em,
                   pe.peso,
                   pe.m3,
                   pe.qtde_volume,
                   pe.peso_volume,
                   to_char(pe.data_solicitado,'dd/mm/yyyy hh24:mi:ss') as data_solicitado,
                   pe.atendido,
                   pe.observacao,
                   to_char(pe.date_insert,'dd/mm/yyyy hh24:mi:ss') as date_insert,
                   pe.user_insert,
                   to_char(pe.date_update,'dd/mm/yyyy hh24:mi:ss') as date_update,
                   pe.user_update,
                   pe.site
              from logistica.v$producao_estimada pe
             inner join kss.v$pessoa p
                     on p.cod_pessoa = pe.cod_cliente
             inner join oper.v$natureza n
                     on n.num_natureza = pe.num_natureza
             where 1=1
             <cfif len(trim(arguments.data_inicial))>
               and trunc(pe.data_solicitado) >= '#arguments.data_inicial#'
             </cfif>
             <cfif len(trim(arguments.data_final))>
               and trunc(pe.data_solicitado) <= '#arguments.data_final#'
             </cfif>
             <cfif len(trim(arguments.cod_cliente))>
               and pe.cod_cliente in (#arguments.cod_cliente#)
             </cfif>
             order by pe.data_solicitado
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

</cfcomponent>