<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca os dados do Romaneio
	-- LEANDRO  25/05/2010
	--->		
	<cffunction name="get_romaneio" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="no" default="">
        <cfargument name="origem" required="no" default="">
        <cfargument name="destino" required="no" default="">
        <cfargument name="remetente" required="no" default="">
        <cfargument name="destinatario" required="no" default="">
        <cfargument name="romaneio_integrado_pamcary" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="situacao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.num_romaneio
                 , r.carregamento
                 , r.destino
                 , r.cliente
                 , r.remetente
                 , r.destinatario
                 , to_char(r.data_inicio, 'dd/mm/yyyy') as data_inicio
                 , r.data_destinado
                 , r.data_termino
                 , r.peso_total
                 , r.peso_cobrado
                 , r.volume_total
                 , r.num_natureza       
                 , n.descricao as natureza 
                 , tr.transacao_id              
                 , tr.situacao_id as situacao_integracao
                 ,(select rc.rv_abbreviation
                     from kss.cg_ref_codes rc
                    where rc.rv_domain = 'TRANSACAO.SITUACAO_ID'
                      and rc.owner = 'PAMCARY'
                      and rc.rv_low_value = tr.situacao_id) as situacao_integracao_descricao 
                 --, tr.conteudo          
                 , tr.retorno_codigo        
                 , tr.retorno_descricao
                 , tr.retorno_viagem_id
                 , tr.retorno_valor
                 , tr.retorno_qtd
                 , case
                       when tr.roteirizado = 1 then 'Sim'
                        when tr.roteirizado = 0 then 'No'
                   end roteirizado
                 , case
                       when tr.pagar_somente_carregado = 1 then 'Sim'
                        when tr.pagar_somente_carregado = 0 then 'No'
                   end pagar_somente_carregado
            from oper.v$romaneio r
             left join oper.v$natureza n
                 on r.num_natureza = n.num_natureza   
             left join pamcary.v$transacao tr
                 on tr.num_romaneio = r.num_romaneio
            where 1= 1
           <cfif Len(Trim(arguments.num_romaneio))>
           	  and r.num_romaneio = #arguments.num_romaneio#
           </cfif>
           <cfif Len(Trim(arguments.situacao_id))>
           	  and tr.situacao_id = #arguments.situacao_id#
           </cfif>
           <cfif Len(Trim(arguments.origem))>
           	  and upper(r.carregamento) like upper('#arguments.origem#%')
           </cfif>
           <cfif Len(Trim(arguments.destino))>
           	  and upper(r.destino) like upper('#arguments.destino#%')
           </cfif>
           <cfif Len(Trim(arguments.remetente))>
           	  and upper(r.remetente) like upper('#arguments.remetente#%')
           </cfif>
           <cfif Len(Trim(arguments.destinatario))>
           	  and upper(r.destinatario) like upper('#arguments.destinatario#%')
           </cfif>           
           <cfif Len(Trim(arguments.romaneio_integrado_pamcary))>
              and r.num_romaneio in (select t.num_romaneio
                                       from pamcary.v$transacao t
                                      where t.num_romaneio = r.num_romaneio)
           </cfif> 
           <cfif Len(Trim(arguments.data_inicio))>
           	  and tr.date_insert >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
           </cfif>              
           <cfif Len(Trim(arguments.data_fim))>
           	  and tr.date_insert <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
           </cfif> 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    	<!--- 
	-- PROPSITO 
	-- Busca os dados do Romaneio
	-- LEANDRO  26/05/2010
	--->		
	<cffunction name="get_tipo_pamcard" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select rc.rv_low_value as codigo
                 , rc.rv_abbreviation as descricao       
              from kss.cg_ref_codes rc 
             where rc.rv_domain = 'PAMCARD.TIPOCARTAO'           
               and rc.owner = 'PAMCARY'
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    
    <!--- 
	-- PROPSITO 
	-- Busca os dados do Romaneio
	-- LEANDRO  26/05/2010
	--->		
	<cffunction name="get_pamcard" access="remote" returntype="query" output="true">
   		<cfargument name="numero" required="no" default="">
        <cfargument name="cod_pessoa_portador" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.pamcard_id
		         , p.numero
        		 , p.cod_pessoa_portador
                 , (select pe.cnpj_cpf
                      from kss.v$pessoa pe
                     where pe.cod_pessoa = p.cod_pessoa_portador) as cpf_portador
				 , (select pe.razao_social 
                      from kss.v$pessoa pe
                     where pe.cod_pessoa = p.cod_pessoa_portador) as nome_portador                     
		         , p.tipo
                 , (select rc.rv_abbreviation
                    from kss.cg_ref_codes rc
                   where rc.owner = 'PAMCARY'
                     and rc.rv_domain = 'PAMCARD.TIPOCARTAO'
                     and rc.rv_low_value = p.tipo) as tipo_descricao
      		 from pamcary.v$pamcard p
            where 1 = 1
        <cfif Len(Trim(arguments.numero))>
              and p.numero = #arguments.numero#
        </cfif>
        <cfif Len(Trim(arguments.cod_pessoa_portador))>
              and p.cod_pessoa_portador = #arguments.cod_pessoa_portador#
        </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca as situaes da transaa
	-- WAGNER  26/05/2010
	--->		
	<cffunction name="get_cg_ref_codes" access="remote" returntype="query" output="true">
   		<cfargument name="rv_domain" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cg.rv_low_value as situacao_id,
                   cg.rv_abbreviation as descricao
                   
            from kss.cg_ref_codes cg
            where owner = 'PAMCARY'
            
        	<cfif Len(Trim(arguments.rv_domain))>
              and cg.rv_domain = '#arguments.rv_domain#'
	        </cfif>
        
        	order by situacao_id
        
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
        
</cfcomponent>