<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Busca as despesas de viagem
    -- 31/12/2008 - criado
    --->	
    <cffunction name="get_motorista_despesa_viagem" displayname="" output="true" returntype="query" access="remote">
    	<cfargument name="mot_despesa_id" required="no" default="">
    	<cfargument name="data_inicial" required="no" default="">
    	<cfargument name="data_final" required="no" default="">
    	<cfargument name="num_romaneio" required="no" default="">
    	<cfargument name="nome_motorista" required="no" default="">
    	<cfargument name="cancelado" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mvd.mot_despesa_id, 
            	   mvd.cod_pessoa, 
                   mvd.num_romaneio,
                   mvd.produto_id,
                   to_char(mvd.data_lancamento,'dd/mm/yyyy hh24:mi:ss') as data_lancamento, 
                   mvd.num_lancamento, 
                   mvd.rowid,
                   pf.cliente motorista, 
                   cc.historico, 
                   cc.favorecido,
                   cc.deb_cred,
                   cc.user_insert,
                   mr.cod_registro,
                   cc.valor_lancamento,
                   to_char(cc.data_vencto,'dd/mm/yyyy hh24:mi:ss') as data_vencto, 
                   to_char(cc.data_cancelamento,'dd/mm/yyyy hh24:mi:ss') as data_cancelamento,
                   (select remetente||' ('||carregamento ||') - '||destino
                      from oper.v$romaneio
                     where num_romaneio = mvd.num_romaneio) descr_viagem
              from oper.v$motorista_viagem_despesa mvd
             inner join finan.v$ccorrente_lancamento_todos cc
                     on cc.num_lancamento = mvd.num_lancamento
             inner join kss.v$pessoa pf
                     on pf.cod_pessoa = mvd.cod_pessoa
              left join oper.v$motorista_reg_historico mr
                     on mr.cod_pessoa = pf.cod_pessoa
                    and cc.data_vencto between mr.data_inicio and nvl(mr.data_fim,cc.data_vencto)
             where 1=1
             <cfif len(trim(arguments.mot_despesa_id))>
               and mvd.mot_despesa_id = #arguments.mot_despesa_id#
             </cfif>
             <cfif len(trim(arguments.data_inicial))>
               and cc.data_vencto >= '#arguments.data_inicial# 00:00:00'
             </cfif>
             <cfif len(trim(arguments.data_final))>
               and cc.data_vencto <= '#arguments.data_final# 23:59:59'
             </cfif>
             <cfif len(trim(arguments.num_romaneio))>
               and mvd.num_romaneio = #arguments.num_romaneio#
             </cfif>
             <cfif arguments.cancelado eq 1>
               and cc.data_cancelamento is not null
             </cfif>
             <cfif arguments.cancelado eq 0>
               and cc.data_cancelamento is null
             </cfif>
             <cfif len(trim(arguments.nome_motorista))>
               and kss.pkg_string.fnc_string_clean(upper(trim(cc.favorecido))) like kss.pkg_string.fnc_string_clean(upper(trim('#arguments.nome_motorista#%')))
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os produtos liberados para as agencias
	-- NOTAS EXPLICATIVAS
	-- GUTO 24/01/2009
	--->
	<cffunction name="get_produtos_viagem" displayname="Busca os produtos liberados para as agencias e tambm os produtos liberados para o funcionrio selecionado." access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.produto_id, p.descricao
			  from fiscal.v$produto p 
			 where p.disponivel_setor = 1
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
</cfcomponent>