<cfcomponent extends="_transportes.funcoes.cfc_init">
    <!--- 
	-- PROPSITO
	-- Retorna os lotes cadastrados
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 30/03/2009
	--->
	<cffunction name="get_lotes" displayname="Retorna os lotes cadastrados" output="true" returntype="query" access="remote">
		<cfargument name="num_lote" required="no" default="">
        <cfargument name="situacao_id" required="no" default="">
        <cfargument name="frete_proprio" required="no" default="">
        <cfargument name="neg_nome_fantasia" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+ ORDERED FIRST_ROWS USE_NL(L)*/
                   -- Dados Lote
                   l.num_lote, un.unidade_negocio, depto.descricao departamento, st.descricao setor,
                   to_char(l.data_contrato, 'dd/mm/yyyy hh24:mi:ss') as data_contrato,
                   to_char(l.data_inicio_retirada, 'dd/mm/yyyy hh24:mi:ss') as data_inicio_retirada,
                   to_char(l.data_prazo_retirada, 'dd/mm/yyyy hh24:mi:ss') as data_prazo_retirada,
                   nt.descricao natureza,
                   esp.descricao especie, l.peso, l.volume, l.m3, l.frete_em,
                   l.cod_unidade, l.qtde_viagem,p.descricao tipo_frete,
                   (select /*+ PUSH_SUBQ */
                           rv_meaning
                     from oper.cg_ref_codes
                    where rv_low_value = l.frete_por_conta
                      and rv_domain = 'LOTE.FRETE_POR_CONTA') frete_por_conta,
                   l.cod_pessoa_remetente,
                   l.cod_pessoa_destinatario, l.coleta_logradouro,
                   l.coleta_complemento, l.coleta_bairro,
                   l.coleta_cep, ib.uf_id uf_coleta,
                   ib.municipio coleta_municipio, l.entrega_logradouro,
                   l.entrega_complemento, l.entrega_bairro,
                   l.entrega_cep, ibg.uf_id uf_entrega,
                   ibg.municipio entrega_municipio, lrf.descricao regra_fiscal,
                   -- Situao
                   case l.situacao_id
                     when 1 then
                        'Disponvel'
                     when 2 then
                        'Bloqueado'
                     when 3 then
                        'Cancelado'
                     when 4 then
                        'Encerrado'
                   end situacao_id,
                   -- Dados Remetente e Destinatrio
                   rm.cliente remetente,
                   oper.pkg_global.fnc_mascara_cnpj_cpf(rm.cod_pessoa) cnpj_cpf_rem,
                   rme.logradouro ||' '|| rme.numero logradouro_rem,
                   rme.complemento compl_rem, rme.bairro bairro_rem, rme.municipio mun_rem, rme.uf u_rem,
                   to_char(rme.CEP) cep_rem, 
                   rmd.cliente destinatario,
                   oper.pkg_global.fnc_mascara_cnpj_cpf(rmd.cod_pessoa) cnpj_cpf_dest,
                   rmde.logradouro ||' '|| rmde.numero logradouro_dest,
                   rmde.complemento compl_dest, rmde.bairro bairro_dest, rmde.municipio mun_dest, rmde.uf uf_dest,
                   to_char(rmde.CEP) cep_dest, 
                   
                   -- Carga, Descarga, Faturamento e Documento, Lote com os setores e Doctos fiscais emitidos pelos setores
                   -- so colocados estes campos pois na lista eles iro abrir um subGrid com os detalhes de cada um
                   'Faturamento e Documento' faturamento, 
                   'Compartilha Lotes com os Setores' compartilha_lote, 'Doctos Fiscais que podem ser Emitidos pelos Setores' doctos_fiscais,
                   
                   trunc(l.data_contrato) data_contratacao,
                   to_char(l.data_contrato, 'hh24:mi:ss') as hora_contrato,
                   trunc(l.data_inicio_retirada) data_ini_retirada,
                   to_char(l.data_inicio_retirada, 'hh24:mi:ss') as hora_ini_retirada,
                   trunc(l.data_prazo_retirada) data_praz_retirada,
                   to_char(l.data_prazo_retirada, 'hh24:mi:ss') as hora_praz_retirada,
                   fiscal.pkg_fiscal.fnc_converte_peso(l.peso, 'Kg', l.cod_unidade) peso_real,
                   decode(l.com_retorno_embalagem, 0, 'Sim', 'No') retorno_embalagem,
                  
                   -- Dados Contratante
                  l.cod_negociador
                 , kss.pkg_pessoa.fnc_get_cliente(l.cod_negociador,1) as neg_nome_fantasia
                 , kss.pkg_pessoa.fnc_get_identificador(l.cod_negociador) as neg_identificador
                 , l.user_insert
                 , to_char(l.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , l.user_update
                 , to_char(l.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update
              from oper.v$lote l
             inner join kss.v$unidade_negocio un
                     on un.cod_pessoa = l.cod_pessoa_filial
             inner join kss.v$departamento depto
                     on depto.cod_departamento = l.cod_departamento
             inner join kss.v$setor st
                     on st.cod_setor = l.cod_setor
             inner join oper.v$especie esp
                     on esp.num_especie = l.num_especie
             inner join oper.v$natureza nt
                     on nt.num_natureza = l.num_natureza
             inner join fiscal.v$produto p
                     on p.produto_id = l.num_produto
                    and p.conhecimento = 1
                    and p.ativo = 1 
             inner join cep.municipio ib
                     on ib.municipio_id = l.coleta_municipio_id
              left join cep.municipio ibg
                     on ibg.municipio_id = l.entrega_municipio_id
              left join oper.v$lote_regra_fiscal lrf
                     on lrf.regra_fiscal_id = l.regra_fiscal_id
              left join kss.v$pessoa rm
                     on rm.cod_pessoa = l.cod_pessoa_remetente
              left join kss.v$pessoa_endereco_padrao rme
                     on rme.cod_pessoa = rm.cod_pessoa      
              left join kss.v$pessoa rmd
                     on rmd.cod_pessoa = l.cod_pessoa_destinatario
              left join kss.v$pessoa_endereco_padrao rmde
                     on rmde.cod_pessoa = rmd.cod_pessoa      
              where l.frete_proprio <> 2
			<cfif Len(Trim(arguments.num_lote))>
                and l.num_lote in (#arguments.num_lote#)
            </cfif>
            <cfif Len(Trim(arguments.situacao_id))>
                and l.situacao_id = #arguments.situacao_id#
            </cfif>
            <cfif Len(Trim(arguments.frete_proprio))>
                and l.frete_proprio = #arguments.frete_proprio#
            </cfif>
            <cfif Len(Trim(arguments.neg_nome_fantasia))>
                and upper(kss.pkg_pessoa.fnc_get_cliente(l.cod_negociador,1)) like upper('#arguments.neg_nome_fantasia#%')
            </cfif>
              order by l.num_lote asc
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna as possveis situaes para um lote
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 01/04/2009
	--->
	<cffunction name="get_situacoes" displayname="Retorna as possveis situaes para um lote" output="true" returntype="query" access="remote">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_number(rv_low_value) as situacao_id
                 , InitCap(rv_abbreviation) as descricao
              from oper.v$cg_ref_codes
             where rv_domain = 'LOTE.SITUACAO_ID'
             order by 1
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
</cfcomponent>