<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!--- 
    -- PROPSITO
    -- Busca a sequencia de itinerarios para a correo
    -- 02/01/2009 - criado
    --->	
    <cffunction name="get_romaneio_itinerario_correcao" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="placa_referencia" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfargument name="num_romaneio" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select it.itinerario_id,
                   it.num_romaneio,
                   roi.item_id,
                   it.placa_referencia,
                   it.origem_municipio_id,
                   cep.fnc_municipio_uf(it.origem_municipio_id,'/') as origem,
                   it.destino_municipio_id,
                   cep.fnc_municipio_uf(it.destino_municipio_id,'/') as destino,
                   it.rota_id,
                   it.km_rota,
                   rot.abreviatura,
                   to_char(it.data_previsao,'dd/mm/yyyy hh24:mi:ss') as data_previsao,
                   to_char(it.data_chegada,'dd/mm/yyyy hh24:mi:ss') as data_chegada,
                   it.itinerario_id_anterior,
                   it.itinerario_id_posterior,
                   it.vazio_carregado,
                   decode(it.vazio_carregado,0,'Vazio',1,'Carregado') as desc_vazio_carregado,
                   nvl(rot.descricao_rota,cep.fnc_municipio_uf(it.origem_municipio_id,'/')) as descricao_rota,
                   it.ordem,
                   oper.pkg_itinerario.fnc_verifica_romaneio(it.num_romaneio) as romaneio_ok,
                   it.sequencia
              from (select a.itinerario_id,
                           num_romaneio,
                           itinerario_id_anterior,
                           num_romaneio_anterior,
                           data_inicio,
                           data_inicio_anterior,
                           placa_referencia, 
                           origem_municipio_id,
                           rota_id,
                           vazio_carregado,
                           itinerario_id_posterior,
                           data_chegada,
                           data_previsao,
                           km_rota,
                           destino_municipio_id,
                           ordem,
                           level as sequencia
                      from (select ri.itinerario_id,
                                   ri.num_romaneio,
                                   ri.itinerario_id_anterior,
                                   ria.num_romaneio num_romaneio_anterior,
                                   r.data_inicio,
                                   (select ra.data_inicio
                                      from oper.v$romaneio ra
                                     where ra.num_romaneio = ria.num_romaneio) as data_inicio_anterior,
                                   ri.placa_referencia,
                                   ri.origem_municipio_id,
                                   ri.destino_municipio_id,
                                   ri.rota_id,
                                   ri.vazio_carregado,
                                   ri.itinerario_id_posterior,
                                   ri.data_chegada,
                                   ri.data_previsao,
                                   ri.km_rota,
                                   ri.ordem
                              from oper.v$romaneio_itinerario ri
                             inner join oper.v$romaneio r
                                     on r.num_romaneio = ri.num_romaneio 
                              left join oper.v$romaneio_itinerario ria
                                     on ria.itinerario_id = ri.itinerario_id_anterior
                             where 1=1
							<cfif len(trim(arguments.num_romaneio))>
                               and ri.num_romaneio = #arguments.num_romaneio#
                            <cfelseif len(trim(arguments.placa_referencia)) and len(trim(arguments.data_inicial))>
                               and r.data_inicio >= '#arguments.data_inicial# 00:00:00'
                               and ri.placa_referencia = '#arguments.placa_referencia#'
								<cfif len(trim(arguments.data_final))>
                                   and r.data_inicio <= '#arguments.data_final# 23:59:59'
                                </cfif>
                            <cfelse>
                               and 1=0
                            </cfif>
                           ) a
				<cfif len(trim(arguments.num_romaneio))>
                   start with nvl(num_romaneio,-1) <> nvl(num_romaneio_anterior,-1)
                <cfelseif len(trim(arguments.placa_referencia)) and len(trim(arguments.data_inicial))>
                   start with nvl(data_inicio_anterior,to_date('01/01/1900','dd/mm/yyyy')) < '#arguments.data_inicial# 00:00:00'
                <cfelse>
                   start with 1=0
                </cfif>
                    connect by prior itinerario_id = itinerario_id_anterior) it
             left join oper.v$rota rot
                     on rot.rota_id = it.rota_id
              left join oper.v$romaneio_item roi
                     on roi.itinerario_id = it.itinerario_id
             order by it.sequencia
        </cfquery>
        <cfreturn qr_result>
    </cffunction>


	<!--- 
    -- PROPSITO
    -- Busca o itinerario na sequencia
    -- 02/01/2009 - criado
    --->	
    <cffunction name="get_romaneio_itinerario_sequencia" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="itinerario_id" required="no" default="">
    	<cfargument name="placa_referencia" required="no" default="">
        <cfargument name="anterior" required="no" default="">
        <cfargument name="posterior" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ri.itinerario_id,
                   ri.num_romaneio,
                   ri.origem_municipio_id,
                   cep.fnc_municipio_uf(ri.origem_municipio_id,'/') as origem,
                   ri.destino_municipio_id,
                   cep.fnc_municipio_uf(ri.destino_municipio_id,'/') as destino
              from oper.v$romaneio_itinerario ri
             where 1=1
             <cfif len(trim(arguments.placa_referencia))>
               and ri.placa_referencia = '#arguments.placa_referencia#'
             </cfif>
             <cfif arguments.anterior eq 1>
                <cfif arguments.itinerario_id eq -1>
               and ri.itinerario_id_posterior is null
                <cfelse> 
               and ri.itinerario_id_posterior = #arguments.itinerario_id#
                </cfif>
             <cfelseif arguments.posterior eq 1>
               and ri.itinerario_id_anterior = #arguments.itinerario_id#
             <cfelse>
               and 1=0
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
            

   
	<!--- 
    -- PROPSITO
    -- Busca os itinerarios do romaneio
    -- 07/01/2009 - criado
    --->	
    <cffunction name="get_romaneio_itinerarios" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="num_romaneio" required="yes">
        <cfargument name="vazio_carregado" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select a.itinerario_id,
                           num_romaneio,
                           itinerario_id_anterior,
                           num_romaneio_anterior,
                           origem_municipio_id,
                           cep.fnc_municipio_uf(origem_municipio_id,'/') origem,
                           destino_municipio_id,
                           cep.fnc_municipio_uf(destino_municipio_id,'/') destino,
                           rota_id,
                           vazio_carregado,
                           itinerario_id_posterior,
                           to_char(data_chegada,'dd/mm/yyyy hh24:mi:ss') as data_chegada,
                           to_char(data_previsao,'dd/mm/yyyy hh24:mi:ss') as data_previsao,
                           km_rota,
                           ordem,
                           level as sequencia
                      from (select ri.itinerario_id,
                                   ri.num_romaneio,
                                   ri.itinerario_id_anterior,
                                   ria.num_romaneio num_romaneio_anterior,
                                   ri.origem_municipio_id,
                                   ri.destino_municipio_id,
                                   ri.rota_id,
                                   ri.vazio_carregado,
                                   ri.itinerario_id_posterior,
                                   ri.data_chegada,
                                   ri.data_previsao,
                                   ri.km_rota,
                                   ri.ordem
                              from oper.v$romaneio_itinerario ri
                              left join oper.v$romaneio_itinerario ria
                                     on ria.itinerario_id = ri.itinerario_id_anterior
                             where 1=1
                               and ri.num_romaneio = #arguments.num_romaneio#
                           ) a
                   where 1=1
                   <cfif len(trim(vazio_carregado))>
                     and a.vazio_carregado = #arguments.vazio_carregado#
                   </cfif>
                   start with nvl(num_romaneio,-1) <> nvl(num_romaneio_anterior,-1)
                    connect by prior itinerario_id = itinerario_id_anterior
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
                    
</cfcomponent>