<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca as integraes da GV
	-- LEOPOLDO  10/04/2012
	--->		
	<cffunction name="get_integracoes" access="remote" returntype="query" output="true">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfargument name="num_romaneio" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select rom.num_romaneio
		         , op.descricao as operacao
                 , rom.carregamento
                 , rom.destino
                 , rom.placa_referencia
                 , req.metodo
                 , to_char(rom.data_inicio, 'dd/mm/yyyy') as data_inicio
                 , to_char(req.date_insert, 'dd/mm/yyyy hh24:mi:ss') as data_integracao
                 , req.user_insert as usuario_integracao
                 , 'Visualizar' as xml_envio
                 , 'Visualizar' as xml_retorno
                 , to_char(req.erro) as erro
              from oper.v$romaneio rom 
             inner join oper.v$romaneio_item romi
                     on romi.num_romaneio = rom.num_romaneio
             inner join logistica.v$operacao op
                     on op.operacao_id = romi.operacao_id
             inner join logistica.v$operacao_seguro ops
                     on ops.operacao_id = op.operacao_id
              left join grisco.v$romaneio_requisicao rreq
                     on rreq.num_romaneio = rom.num_romaneio
              left join grisco.v$requisicao req
                     on req.requisicao_id = rreq.requisicao_id
             where ops.exige_monitoramento = 1
			 <cfif len(trim(arguments.data_inicio))>
			   and trunc(rom.data_inicio) >= '#arguments.data_inicio#'
			 </cfif>
			 <cfif len(trim(arguments.data_fim))>
			   and trunc(rom.data_inicio) <= '#arguments.data_fim#'
			 </cfif>
			 <cfif len(trim(arguments.num_romaneio))>
			   and rom.num_romaneio = #arguments.num_romaneio#
			 </cfif> 			 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
</cfcomponent>