<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!--- 
	-- PROPSITO 
	-- Busca o tipo de Infrator
	-- ERIC  18/06/2010
	--->		
	<cffunction name="get_tipo_infrator" access="remote" returntype="query" output="true">
		<cfargument name="tipo_infrator_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ti.tipo_infrator_id
                 , ti.descricao
              from oper.v$multa_tipo_infrator ti
             where 1 = 1
			<cfif Len(Trim(arguments.tipo_infrator_id))>
               and ti.tipo_infrator_id = #arguments.tipo_infrator_id#
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(ti.descricao) like upper('#arguments.descricao#%')
            </cfif>
             order by ti.descricao
        </cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca a Gravidade de Infrao
	-- ERIC  21/06/2010
	--->		
	<cffunction name="get_gravidade_infracao" access="remote" returntype="query" output="true">
		<cfargument name="gravidade_infracao_id" required="no" default=""> 
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gi.gravidade_infracao_id
                 , gi.descricao
                 , gi.pontuacao
              from oper.v$multa_gravidade_infracao gi
             where 1 = 1
			<cfif Len(Trim(arguments.gravidade_infracao_id))>
               and gi.gravidade_infracao_id = #arguments.gravidade_infracao_id#
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(gi.descricao) like upper('#arguments.descricao#%')
            </cfif>
             order by gi.descricao              
        </cfquery>
		<cfreturn qr_result>		
	</cffunction>   
    
	<!--- 
	-- PROPSITO 
	-- Busca o rgo Autuador
	-- ERIC  22/06/2010
	--->		
	<cffunction name="get_orgao_autuador" access="remote" returntype="query" output="true">
		<cfargument name="orgao_autuador_id" required="no" default=""> 
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select oa.orgao_autuador_id
                 , oa.descricao
              from oper.v$multa_orgao_autuador oa 
             where 1 = 1
			<cfif Len(Trim(arguments.orgao_autuador_id))>
               and oa.orgao_autuador_id = #arguments.orgao_autuador_id#
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(oa.descricao) like upper('#arguments.descricao#%')
            </cfif>
             order by oa.descricao              
        </cfquery>
		<cfreturn qr_result>		
	</cffunction> 
    
	<!--- 
	-- PROPSITO 
	-- Busca a Instncia
	-- ERIC  22/06/2010
	--->		
	<cffunction name="get_instancia" access="remote" returntype="query" output="true">
		<cfargument name="instancia_id" required="no" default=""> 
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select i.instancia_id
                 , i.descricao
              from oper.v$multa_instancia i  
             where 1 = 1
			<cfif Len(Trim(arguments.instancia_id))>
               and i.instancia_id = #arguments.instancia_id#
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(i.descricao) like upper('#arguments.descricao#%')
            </cfif>
             order by i.descricao              
        </cfquery>
		<cfreturn qr_result>		
	</cffunction>     
    
	<!--- 
	-- PROPSITO 
	-- Busca a situao
	-- ERIC  22/06/2010
	--->		
	<cffunction name="get_situacao" access="remote" returntype="query" output="true">
		<cfargument name="situacao_id" required="no" default=""> 
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select s.situacao_id
                 , s.descricao
              from oper.v$multa_situacao s  
             where 1 = 1
			<cfif Len(Trim(arguments.situacao_id))>
               and s.situacao_id = #arguments.situacao_id#
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(s.descricao) like upper('#arguments.descricao#%')
            </cfif>
             order by s.descricao              
        </cfquery>
		<cfreturn qr_result>		
	</cffunction>    
    
	<!--- 
	-- PROPSITO 
	-- Busca o Motivo de No Apresentao de Condutor
	-- ERIC  22/06/2010
	--->		
	<cffunction name="get_motivo_nao_apresentacao_condutor" access="remote" returntype="query" output="true">
		<cfargument name="motivo_id" required="no" default=""> 
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mna.motivo_id
                 , mna.descricao
              from oper.v$multa_motivo_nao_apresent mna 
             where 1 = 1
			<cfif Len(Trim(arguments.motivo_id))>
               and mna.motivo_id = #arguments.motivo_id#
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(mna.descricao) like upper('#arguments.descricao#%')
            </cfif>
             order by mna.descricao              
        </cfquery>
		<cfreturn qr_result>		
	</cffunction> 
    
	<!--- 
	-- PROPSITO 
	-- Busca o Tipo de Infrao
	-- ERIC  22/06/2010
	--->		
	<cffunction name="get_tipo_infracao" access="remote" returntype="query" output="true">
		<cfargument name="tipo_infracao_id" required="no" default=""> 
        <cfargument name="cod_infracao" required="no" default="">
        <cfargument name="inciso" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ti.tipo_infracao_id
                 , ti.cod_infracao
                 , ti.inciso
                 , ti.descricao
                 , ti.tipo_infrator_id
                 , i.descricao as tipo_infrator
                 , ti.gravidade_infracao_id
                 , gi.descricao as gravidade_infracao
                 , ti.pontuacao
                 , ti.valor_ufir
                 , ti.valor_reais
                 , ti.penalidade
                 , ti.medida_adm
              from oper.v$multa_tipo_infracao ti
             inner join oper.v$multa_tipo_infrator i
                on i.tipo_infrator_id = ti.tipo_infrator_id
             inner join oper.v$multa_gravidade_infracao gi
                on gi.gravidade_infracao_id = ti.gravidade_infracao_id
             where 1 = 1
			<cfif Len(Trim(arguments.tipo_infracao_id))>
               and ti.tipo_infracao_id = #arguments.tipo_infracao_id#
            </cfif>
            <cfif Len(Trim(arguments.cod_infracao))>
               and upper(ti.cod_infracao) like upper('#arguments.cod_infracao#')
            </cfif>
            <cfif Len(Trim(arguments.inciso))>
               and upper(ti.inciso) like upper('#arguments.inciso#')
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(ti.descricao) like upper('#arguments.descricao#%')
            </cfif>            
             order by ti.descricao
        </cfquery>
		<cfreturn qr_result>		
	</cffunction>    
    
	<!--- 
	-- PROPSITO 
	-- Busca a Auto Infrao
	-- ERIC  23/06/2010
	--->		
	<cffunction name="get_auto_infracao" access="remote" returntype="query" output="true">
		<cfargument name="auto_infracao_id" required="no" default="">
        <cfargument name="cod_auto_infracao" required="no" default=""> 
        <cfargument name="cod_funcionario" required="no" default=""> 
        <cfargument name="num_protocolo" required="no" default=""> 
        <cfargument name="data_inicio_lancamento" required="no" default=""> 
        <cfargument name="data_fim_lancamento" required="no" default=""> 
        <cfargument name="data_inicio" required="no" default=""> 
        <cfargument name="data_fim" required="no" default=""> 
        <cfargument name="num_protocolo_null" required="no" default=""> 
        
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mai.auto_infracao_id
                 , mai.orgao_autuador_id
                 , moa.descricao as orgao_autuador
                 , mai.cod_auto_infracao
                 , to_char(mai.data_impressao, 'dd/mm/yyyy') as data_impressao
                 , to_char(mai.data_infracao, 'dd/mm/yyyy HH:mm') as data_infracao
                 , to_char(mai.date_insert, 'dd/mm/yyyy HH:mm') as data_lancamento
                 , mai.local_infracao
                 , mai.numero_km_infracao
                 , mai.sentido_infracao
                 , mai.cod_municipio
                 , cep.pkg_municipio.fnc_cidade_completa(mai.cod_municipio) as municipio
                 , mai.placa
                 , mai.num_romaneio
                 , mai.cod_pessoa_motorista
                 , mai.num_protocolo
                 , kss.pkg_pessoa.fnc_get_cliente(mai.cod_pessoa_motorista) as motorista
                 , mai.condutor_apresentado
                 , mai.motivo_apresentacao_id
                 , mai.lancamento_id
                 , mai.usuario_protocolo
                 , mmna.descricao as motivo_nao_apresentacao
                 , (select cl.valor_lancamento
                      from finan.v$ccorrente_lancamento cl
                     where cl.num_lancamento = mai.lancamento_id) as valor_lancamento
              from oper.v$multa_auto_infracao mai
             inner join oper.v$multa_orgao_autuador moa
                     on moa.orgao_autuador_id = mai.orgao_autuador_id
             left join oper.v$multa_motivo_nao_apresent mmna
                     on mmna.motivo_id = mai.motivo_apresentacao_id
             where 1 = 1
			<cfif Len(Trim(arguments.auto_infracao_id))>
               and mai.auto_infracao_id in (#arguments.auto_infracao_id#)
            </cfif>
            <cfif Len(Trim(arguments.cod_auto_infracao))>
               and upper(mai.cod_auto_infracao) like upper('#arguments.cod_auto_infracao#%')
            </cfif>
            <cfif Len(Trim(arguments.data_inicio_lancamento))>
               and trunc(mai.date_insert) >= '#arguments.data_inicio_lancamento#'
            </cfif>
            <cfif Len(Trim(arguments.data_fim_lancamento))>
               and trunc(mai.date_insert) <= '#arguments.data_fim_lancamento#'
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
            	<cfswitch expression="#arguments.DATA_FILTRO#" >
                	<cfcase value="impressao"> and trunc(mai.data_impressao) >= '#arguments.data_inicio#' </cfcase>
                	<cfcase value="infracao"> and trunc(mai.data_infracao) >= '#arguments.data_inicio#' </cfcase>
                    <cfcase value="lancamento"> and trunc(mai.date_insert) >= '#arguments.data_inicio#' </cfcase>
                    <cfdefaultcase>and trunc(mai.date_insert) >= '#arguments.data_inicio#'</cfdefaultcase>
                </cfswitch>
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
            	<cfswitch expression="#arguments.DATA_FILTRO#" >
                	<cfcase value="impressao"> and trunc(mai.data_impressao) <= '#arguments.data_fim#' </cfcase>
                	<cfcase value="infracao"> and trunc(mai.data_infracao) <= '#arguments.data_fim#' </cfcase>
                    <cfcase value="lancamento"> and trunc(mai.date_insert) <= '#arguments.data_fim#' </cfcase>
                    <cfdefaultcase>and trunc(mai.date_insert) <= '#arguments.data_fim#'</cfdefaultcase>
                </cfswitch>
            </cfif>
            <cfif Len(Trim(arguments.cod_funcionario)) >
            	and lancamento_id in (select cl.num_lancamento
                                       from finan.v$ccorrente_lancamento cl
                                       inner join rh.rh_funcionario_hist_pessoal fhp
                                            on fhp.lancto_id = cl.num_lancamento
                                           and fhp.cod_tipo_historico = 36
                                      where fhp.cod_funcionario = #arguments.cod_funcionario# ) 
            </cfif>

            <cfif Len(Trim(arguments.num_protocolo))>
               and mai.num_protocolo = #arguments.num_protocolo#
            </cfif>
            <cfif Len(Trim(arguments.num_protocolo_null))>
            	and mai.num_protocolo is null
            </cfif>
            
             order by mai.cod_auto_infracao
        </cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca Item da Auto Infrao (tipos de multas)
	-- ERIC  23/06/2010
	--->		
	<cffunction name="get_auto_infracao_item" access="remote" returntype="query" output="true">
		<cfargument name="auto_infracao_id" required="no" default="">
        <cfargument name="tipo_infracao_id" required="no" default=""> 
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select maii.auto_infracao_id
                 , maii.tipo_infracao_id
                 , mti.cod_infracao
                 , mti.descricao
                 , maii.cod_renainf
                 , nvl( mti.valor_reais, round(mti.valor_ufir * 1.0641) ) as valor_reais
              from oper.v$multa_auto_infracao_item maii
             inner join oper.v$multa_tipo_infracao mti
                     on mti.tipo_infracao_id = maii.tipo_infracao_id
             where 1 = 1
			<cfif Len(Trim(arguments.auto_infracao_id))>
               and maii.auto_infracao_id = #arguments.auto_infracao_id#
            </cfif>
            <cfif Len(Trim(arguments.tipo_infracao_id))>
               and maii.tipo_infracao_id = #arguments.tipo_infracao_id#
            </cfif>
             order by maii.auto_infracao_id              
        </cfquery>
		<cfreturn qr_result>		
	</cffunction>    
    
	<!--- 
	-- PROPSITO 
	-- Busca a Ocorrncia de Auto Infrao
	-- ERIC  23/06/2010
	--->		
	<cffunction name="get_auto_infracao_ocorrencia" access="remote" returntype="query" output="true">
		<cfargument name="ocorrencia_id" required="no" default="">
        <cfargument name="auto_infracao_id" required="no" default=""> 
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select maio.ocorrencia_id
                 , maio.auto_infracao_id
                 , mai.cod_auto_infracao
                 , to_char(maio.data_ocorrencia, 'dd/mm/yyyy') as data_ocorrencia
                 , maio.situacao_id
                 , ms.descricao as situacao
                 , maio.instancia_id
                 , mi.descricao as instancia
                 , maio.observacoes
              from oper.v$multa_auto_infracao_ocorr maio
             inner join oper.v$multa_auto_infracao mai
                     on mai.auto_infracao_id = maio.auto_infracao_id
             inner join oper.v$multa_situacao ms
                     on ms.situacao_id = maio.situacao_id
             inner join oper.v$multa_instancia mi
                     on mi.instancia_id = maio.instancia_id
             where 1 = 1
			<cfif Len(Trim(arguments.ocorrencia_id))>
               and maio.ocorrencia_id = #arguments.ocorrencia_id#
            </cfif>
			<cfif Len(Trim(arguments.auto_infracao_id))>
               and maio.auto_infracao_id = #arguments.auto_infracao_id#
            </cfif>
             order by data_ocorrencia              
        </cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Consulta os dados para gerar o PDF de acompanhamento de infrao
    -- GUSTAVOC 25/06/2010 - CRIADO
    --->		
    <cffunction name="get_acompanhamento_infracao" access="remote" returntype="query" output="true">
    	<cfargument name="auto_infracao_id" required="no" default="">
        <cfargument name="motorista_cod" required="no" default=""> 
        <cfargument name="veiculo_placa" required="no" default=""> 
        <cfargument name="orgao_autuador_id" required="no" default=""> 
        <cfargument name="num_romaneio" required="no" default=""> 
        <cfargument name="situacao" required="no" default=""> 
        <cfargument name="infracao" required="no" default=""> 
        <cfargument name="data_inicial" required="no" default=""> 
        <cfargument name="data_final" required="no" default=""> 
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.auto_infracao_id
                 , a.cod_auto_infracao
                 , a.orgao_autuador_id
                 , a.orgao_autuador
                 , to_char(a.data_impressao, 'dd/mm/yyyy') as data_impressao
                 , to_char(a.data_infracao, 'dd/mm/yyyy HH24:MI') as data_infracao
                 , a.local_infracao
                 , a.numero_km_infracao
                 , a.sentido_infracao
                 , a.municipio
                 , a.uf_id
                 , a.veiculo_placa
                 , a.veiculo_marca_modelo
                 , a.agrupamento
                 , a.viagem
                 , a.motorista_cod
                 , a.motorista_nome
                 , a.motorista_endereco
                 , a.motorista_cpf
                 , a.motorista_rg
                 , a.motorista_cnh
                 , mai.num_romaneio
              from oper.v$acompanhamento_auto_infracao a
             inner join oper.v$multa_auto_infracao mai
                on mai.auto_infracao_id = a.auto_infracao_id
             where 1 = 1
            <cfif Len(Trim(arguments.auto_infracao_id))>
               and a.auto_infracao_id in (#arguments.auto_infracao_id#)
            </cfif>
            <cfif Len(Trim(arguments.motorista_cod))>
               and a.motorista_cod = #arguments.motorista_cod#
            </cfif>
            <cfif Len(Trim(arguments.veiculo_placa))>
               and a.veiculo_placa = '#arguments.veiculo_placa#'
            </cfif>
            <cfif Len(Trim(arguments.orgao_autuador_id))>
               and a.orgao_autuador_id = #arguments.orgao_autuador_id#
            </cfif>
            <cfif Len(Trim(arguments.num_romaneio))>
               and mai.num_romaneio = #arguments.num_romaneio#
            </cfif>
            <cfif Len(Trim(arguments.situacao))>
               <!---and a.cod_auto_infracao = #arguments.situacao#--->
                and a.auto_infracao_id in (select mo.auto_infracao_id
                                               from oper.v$multa_auto_infracao_ocorr mo
                                              inner join oper.v$multa_situacao ms
                                                 on mo.situacao_id = ms.situacao_id
                                                and ms.situacao_id = #arguments.situacao#)
            </cfif>
            <cfif Len(Trim(arguments.infracao))>
               <!---and a.cod_auto_infracao = #arguments.infracao#--->
                and a.auto_infracao_id in (select ai.auto_infracao_id
                                              from oper.v$multa_auto_infracao_item ai
                                             inner join oper.v$multa_tipo_infracao ti
                                                on ti.tipo_infracao_id = ai.tipo_infracao_id
                                             where ai.auto_infracao_id = a.auto_infracao_id
                                               and ti.tipo_infracao_id = #arguments.infracao#)

            </cfif>
            <cfif Len(Trim(arguments.data_inicial))>
               and a.data_infracao >= '#arguments.data_inicial#'
            </cfif>
            <cfif Len(Trim(arguments.data_final))>
               and a.data_infracao <= '#arguments.data_final# 23:59:59'
            </cfif>
            order by mai.cod_auto_infracao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Buscar dados da placa
    -- ERICG 28/06/2010 - CRIADO
    --->		
    <cffunction name="get_placa_dados" access="remote" returntype="query" output="true">
    	<cfargument name="placa" required="yes" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">    
            select v.veiculo_id
                 , v.cod_veiculo
                 , v.placa as placa
                 , v.renavan, v.uf
                 , vm.marca, vmo.modelo
                 , v.chassis
                 , vm.marca || '/' || vmo.modelo as marca_modelo
                 , va.descricao as agrupamento
              from oper.v$veiculo v
             inner join oper.v$veiculo_marca vm
                on vm.marca_id = v.marca_id
              left join oper.v$veiculo_modelo vmo
                on vmo.marca_id = v.marca_id
               and vmo.modelo_id = v.modelo_id
             inner join oper.v$veiculo_tipo_carroceria tc
                      on tc.tipo_carroceria_id = v.tipo_carroceria_id
             inner join oper.v$veiculo_agrupamento va
                      on va.agrupamento_id = tc.agrupamento_id
             where v.placa = upper('#arguments.placa#')
             order by v.cod_veiculo    
        </cfquery>
        <cfreturn qr_result>
    </cffunction>  
    
    <!--- 
    -- PROPSITO 
    -- Buscar romaneio
    -- ERICG 28/06/2010 - CRIADO
    --->		
    <cffunction name="get_romaneio" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.num_romaneio
                 , r.carregamento as origem
                 , r.destino
                 , vm.marca || '/' || vmo.modelo as marca_modelo
                 , va.descricao as agrupamento
                 , v.placa
                 , rhv.cod_pessoa as cod_pessoa_motorista
              from oper.v$romaneio r
             inner join oper.v$romaneio_hist_veiculo rhv
                     on rhv.num_romaneio = r.num_romaneio
                    and rhv.data_inicio = (select max(rhv2.data_inicio)
                                             from oper.v$romaneio_hist_veiculo rhv2
                                            where rhv2.num_romaneio = rhv.num_romaneio
                                          )
             inner join oper.v$veiculo v
                     on v.placa = rhv.placa_controle
             inner join oper.v$veiculo_marca vm
                on vm.marca_id = v.marca_id
              left join oper.v$veiculo_modelo vmo
                on vmo.marca_id = v.marca_id
               and vmo.modelo_id = v.modelo_id
             inner join oper.v$veiculo_tipo_carroceria tc
                      on tc.tipo_carroceria_id = v.tipo_carroceria_id
             inner join oper.v$veiculo_agrupamento va
                      on va.agrupamento_id = tc.agrupamento_id
             where r.data_inicio >= sysdate - 60  
            <cfif Len(Trim(arguments.num_romaneio))>
               and r.num_romaneio = upper('#arguments.num_romaneio#')
            </cfif> 
             order by v.cod_veiculo  
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    
    <!--- 
    -- PROPSITO 
    -- Buscar romaneio
    -- WAGNER 11/02/2011 - CRIADO
    --->		
    <cffunction name="get_romaneio_situacao" access="remote" returntype="query" output="true">
    	<cfargument name="placa" required="no" default="">
        <cfargument name="data" required="no" default="now()">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select num_romaneio,
            	   (select case
                           when '#data#' <= nvl(r.data_termino_carga,'#data#') then 'Vazio'
                           when '#data#' <= nvl(r.data_inicio_descarga,'#data#') then 'Viagem'
                           else 'Descarregando'
                        end
                      from oper.v$romaneio r
                     where r.num_romaneio = pl.NUM_ROMANEIO) as situacao
              from oper.v$romaneio_hist_veiculo pl
             where 1=1
             <cfif Len(Trim(arguments.placa))>
             	and pl.placa_controle = '#arguments.placa#'
             </cfif>
             <cfif Len(Trim(arguments.data))>
               and '#data#' between pl.data_inicio and nvl(pl.data_termino, '#data#')
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction> 
    
    
    <!--- 
    -- PROPSITO 
    -- Buscar romaneio
    -- WAGNER 14/02/2011 - CRIADO
    --->		
    <cffunction name="get_funcionario" access="remote" returntype="query" output="true">
    	<cfargument name="cpf" required="no" default="">
        <cfargument name="ativo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.cod_funcionario, 
            	   r.nome_funcionario, 
                   r.cpf_funcionario
			  from rh.v$rh_funcionario r
             where 1=1
             <cfif Len(Trim(arguments.cpf))>
             	and r.cpf_funcionario = '#arguments.cpf#'
             </cfif>
             <cfif Len(Trim(arguments.ativo)) >
             	and r.data_demissao is null
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction> 
    
    
    <!--- 
    -- PROPSITO 
    -- Buscar romaneio
    -- WAGNER 14/02/2011 - CRIADO
    --->		
    <cffunction name="get_motorista_veiculo" access="remote" returntype="query" output="true">
    	<cfargument name="placa" required="no" default="">
        <cfargument name="data" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select oper.pkg_global.fnc_get_cod_funcionario(pf.cod_pessoa) as cod_funcionario,
                   pf.cod_pessoa,
                   pf.nome,
                   pf.cpf||pf.cpf_dv as cnpj_cpf,
                   pf.cart_ident_num as rg,
                   pf.uf_naturalidade,
                   pf.cnh_num_registro as cnh,
                   pep.municipio,
                   pep.logradouro ||', '|| pep.numero || ' - ' || pep.bairro as endereco,
                   pep.logradouro,
                   pep.numero,
                   pep.bairro
                   
              from oper.v$veiculo_motorista vm
             inner join kss.v$pessoa_fisica pf on pf.cod_pessoa = vm.cod_pessoa 
             inner join kss.v$pessoa_endereco_padrao pep on pep.cod_pessoa = pf.cod_pessoa
             inner join table(kss.pkg_string.fnc_split(oper.pkg_veiculo.fnc_get_composicao('#arguments.placa#', to_date('#arguments.data#', 'dd/mm/yyyy hh24:mi')), '|')) t 
                     on t.column_value = vm.placa
             where 
             	to_date('#arguments.data#', 'dd/mm/yyyy hh24:mi') between vm.DATA_INICIO and nvl(vm.DATA_FIM, sysdate)
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    
    <!--- 
    -- PROPSITO 
    -- Buscar romaneio
    -- WAGNER 14/02/2011 - CRIADO
    --->		
    <cffunction name="get_dados_empresa_protocolo" access="remote" returntype="query" output="true">
    	<cfargument name="cpf" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select e.razao_social,
                   e.razao_social_resumida,
                   e.nome_fantasia,
                   e.logotipo,
                   e.cod_pessoa,
                   e.inscricao_estadual,
                   e.inscricao_municipal,
                   pe.cod_pessoa,
                   pe.cod_endereco,
                   pe.cep,
                   pe.logradouro,
                   pe.numero,
                   pe.complemento,
                   pe.bairro,
                   pe.uf,
                   pe.municipio,
                   pe.cod_endereco_tipo,
                   pe.endereco_padrao,
                   pe.municipio_id,
                   p.cnpj_cpf
              from kss.v$empresa e
             inner join kss.v$pessoa_endereco pe on e.cod_pessoa = pe.cod_pessoa
             inner join kss.v$pessoa p on p.cod_pessoa = e.cod_pessoa
             
             where 1=1
             <cfif Len(Trim(arguments.cod_pessoa))>
             	and e.cod_pessoa = '#arguments.cod_pessoa#'
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    
    <!--- 
    -- PROPSITO 
    -- Buscar romaneio
    -- WAGNER 11/02/2011 - CRIADO
    --->		
    <cffunction name="get_pessoa_usuario" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa" required="no" default="">
        <cfargument name="usuario" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.cod_pessoa,
                   p.tipo_pessoa,
                   p.cnpj_cpf,
                   p.identificador,
                   p.inscricao_estadual,
                   p.razao_social,
                   p.cliente,
                   p.cod_atividade_fiscal
              from kss.v$pessoa p
             <cfif len(Trim(arguments.usuario)) >
             	inner join kss.kss_usuarios ku
                   on ku.cod_pessoa = p.cod_pessoa
                  and ku.usuario = '#arguments.usuario#'
             </cfif>
             where 1=1
             <cfif Len(Trim(arguments.cod_pessoa))>
             	and p.cod_pessoa = '#arguments.cod_pessoa#'
             </cfif>

        </cfquery>
        <cfreturn qr_result>
    </cffunction> 
    
</cfcomponent>

