<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO 
    -- Retorna os grupos de embalagem
    -- ANDERSON 28/12/2009 - CRIADO
    --->		
    <cffunction name="get_grupo_embalagem" access="remote" returntype="query" output="true">
        <cfargument name="grupo_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select ge.grupo_id
                 , ge.descricao
              from embalagens.v$grupo_embalagem ge
             where 1 = 1
			<cfif Len(Trim(arguments.grupo_id))>
               and ge.grupo_id = #arguments.grupo_id#
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(ge.descricao) like upper('#arguments.descricao#%')
            </cfif>
             order by ge.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os tipos de embalagem
    -- ANDERSON 29/12/2009 - CRIADO
    --->		
    <cffunction name="get_tipo_embalagem" access="remote" returntype="query" output="true">
        <cfargument name="tipo_id" required="no" default="">
        <cfargument name="grupo_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfargument name="abreviatura" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select te.tipo_id
                 , te.grupo_id
                 , (select ge.descricao
                      from embalagens.v$grupo_embalagem ge
                     where ge.grupo_id = te.grupo_id) as grupo
                 , te.descricao
                 , te.abreviatura
                 , te.capacidade
                 , te.cod_unidade
                 , (select um.unidade
                      from fiscal.v$unidade_medida um
                     where um.cod_unidade = te.cod_unidade) as unidade
                 , te.altura
                 , te.comprimento
                 , te.largura
                 , te.cubagem
                 , te.produto_id
                 , (select p.descricao
                      from fiscal.v$produto p
                     where p.produto_id = te.produto_id) as produto
                 , (select p.categoria_id
                      from fiscal.v$produto p
                     where p.produto_id = te.produto_id) as categoria
                 , te.controlada
                 , te.exige_nf
                 , te.valor
              from embalagens.v$tipo_embalagem te
             where 1 = 1
			<cfif Len(Trim(arguments.tipo_id))>
               and te.tipo_id = #arguments.tipo_id#
            </cfif>
            <cfif Len(Trim(arguments.grupo_id))>
               and te.grupo_id = #arguments.grupo_id#
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(te.descricao) like upper('#arguments.descricao#%')
            </cfif>
            <cfif Len(Trim(arguments.abreviatura))>
               and upper(te.abreviatura) like upper('#arguments.abreviatura#%')
            </cfif>
             order by te.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os fabricantes
    -- ANDERSON 29/12/2009 - CRIADO
    --->		
    <cffunction name="get_fabricante" access="remote" returntype="query" output="true">
        <cfargument name="fabricante_id" required="no" default="">
        <cfargument name="cod_pessoa" required="no" default="">
        <cfargument name="situacao" required="no" default="">
        <cfargument name="tipo_embalagem_id" required="no" default="">
        <cfargument name="fabricante" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select f.fabricante_id
                 , f.cod_pessoa
                 , p.cnpj_cpf
                 , p.identificador
                 , trim(p.razao_social) as razao_social
                 , p.cliente as nome_fantasia
                 , p.inscricao_estadual
                 , decode(p.tipo_pessoa, 2 /*Estrangeira*/, pe.endereco, ped.logradouro || ', ' || ped.numero || decode(ped.complemento, null, '', ' - ' || ped.complemento) || decode(ped.bairro, null, '', ' - ' || ped.bairro)) as endereco
                 , decode(p.tipo_pessoa, 2 /*Estrangeira*/, pe.municipio, ped.municipio) as municipio
                 , decode(p.tipo_pessoa, 2 /*Estrangeira*/, 'EX', ped.uf) as uf
                 , decode(t.telefone_id, null, '', '(' || t.fone_ddd || ')' || t.fone_prefixo || '-' || t.fone_numero) as telefone
                 , f.situacao
                 , decode(f.situacao, 1, 'Ativo', 0, 'Inativo') as situacao_desc
              from embalagens.v$fabricante f
             inner join kss.v$pessoa p
                     on p.cod_pessoa = f.cod_pessoa
              left join kss.v$pessoa_estrangeira pe
                     on pe.cod_pessoa = p.cod_pessoa
              left join kss.v$pessoa_endereco ped
                     on ped.cod_pessoa = p.cod_pessoa
                    and ped.endereco_padrao = 1
              left join kss.v$pessoa_telefone pt
                     on pt.cod_pessoa = p.cod_pessoa
                    and pt.telefone_padrao = 1
              left join kss.v$telefone t
                     on t.telefone_id = pt.telefone_id
             where 1 = 1
			<cfif Len(Trim(arguments.fabricante_id))>
               and f.fabricante_id = #arguments.fabricante_id#
            </cfif>
            <cfif Len(Trim(arguments.cod_pessoa))>
               and f.cod_pessoa = #arguments.cod_pessoa#
            </cfif>
            <cfif Len(Trim(arguments.situacao))>
               and f.situacao = #arguments.situacao#
            </cfif>
            <cfif Len(Trim(arguments.tipo_embalagem_id))>
               and f.fabricante_id in (select ef.fabricante_id
              							 from embalagens.v$embalagem_fabricante ef
                                        where ef.tipo_embalagem_id = #arguments.tipo_embalagem_id#)
            </cfif>
            <cfif Len(Trim(arguments.fabricante))>
            	and upper(kss.pkg_string.fnc_string_clean(razao_social)) like upper(kss.pkg_string.fnc_string_clean('%#arguments.fabricante#%'))
            </cfif>            
             order by trim(p.razao_social)
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os tipos de embalagem de um fabricante
    -- ANDERSON 29/12/2009 - CRIADO
    --->		
    <cffunction name="get_embalagem_fabricante" access="remote" returntype="query" output="true">
        <cfargument name="fabricante_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ef.emb_fabricante_id
                 , ef.tipo_embalagem_id
                 , te.abreviatura
                 , ef.fabricante_id
              from embalagens.v$embalagem_fabricante ef
             inner join embalagens.v$tipo_embalagem te
                     on te.tipo_id = ef.tipo_embalagem_id
             where ef.fabricante_id = #arguments.fabricante_id#
             order by te.abreviatura
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os tipos de movimentao de estoque
    -- RAFAEL 29/12/2009 - CRIADO
    --->		
    <cffunction name="get_movimentacao_ponto_estoque" access="remote" returntype="query" output="true">
        <cfargument name="estoque_mov_tipo_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select tem.estoque_mov_tipo_id
                 , tem.descricao
              from embalagens.v$tipo_estoque_movimentacao tem
             where 1 = 1
			<cfif Len(Trim(arguments.estoque_mov_tipo_id))>
               and tem.estoque_mov_tipo_id = #arguments.estoque_mov_tipo_id#
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(tem.descricao) like upper('#arguments.descricao#%')
            </cfif>
             order by tem.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os tipos de ponto de estoque
    -- RAFAEL 29/12/2009 - CRIADO
    --->		
    <cffunction name="get_tipo_ponto_estoque" access="remote" returntype="query" output="true">
        <cfargument name="pe_tipo_id" required="no" default="">
        <cfargument name="reformadora" required="no" default="1">
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select tpe.pe_tipo_id
                 , tpe.descricao
              from embalagens.v$ponto_estoque_tipo tpe
             where 1 = 1
			<cfif Len(Trim(arguments.pe_tipo_id))>
               and tpe.pe_tipo_id = #arguments.pe_tipo_id#
            </cfif>
            <cfif arguments.reformadora eq 0>
               and tpe.pe_tipo_id <> 3
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(tpe.descricao) like upper('#arguments.descricao#%')
            </cfif>
             order by tpe.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
   
   <!--- 
    -- PROPSITO 
    -- Retorna os tipos de movimentao de um ponto de estoque
    -- RAFAEL 29/12/2009 - CRIADO
    --->		
    <cffunction name="get_ponto_estoque_movimentacoes" access="remote" returntype="query" output="true">
        <cfargument name="pem_id" required="no" default="">
        <cfargument name="pe_tipo_id" required="no" default="">
        <cfargument name="estoque_mov_tipo_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select pem.pem_id
                 , pem.pe_tipo_id
                 , pem.estoque_mov_tipo_id
              from embalagens.v$ponto_estoque_movimentacao pem
             where 1 = 1
			<cfif Len(Trim(arguments.pem_id))>
               and pem.pem_id = #arguments.pem_id#
            </cfif>
            <cfif Len(Trim(arguments.pe_tipo_id))>
               and pem.pe_tipo_id = #arguments.pe_tipo_id#
            </cfif>
			<cfif Len(Trim(arguments.estoque_mov_tipo_id))>
               and pem.estoque_mov_tipo_id = #arguments.estoque_mov_tipo_id#
            </cfif>            
             order by pem.pem_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os pontos de estoque
    -- RAFAEL 30/12/2009 - CRIADO
    --->		
    <cffunction name="get_ponto_estoque" access="remote" returntype="query" output="true">
        <cfargument name="ponto_estoque_id" required="no" default="">
        <cfargument name="pe_tipo_id" required="no" default="">
        <cfargument name="situacao" required="no" default="">
        <cfargument name="reformadora" required="no" default="1">
        <cfargument name="cod_pessoa" required="no" default="">
        <cfargument name="movimentacao_tipo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select pe.ponto_estoque_id
            	 , pe.pe_tipo_id
                 , (select pet.descricao
                      from embalagens.v$ponto_estoque_tipo pet
                     where pet.pe_tipo_id = pe.pe_tipo_id) as tipo
                 , pe.cod_pessoa
                 , p.cnpj_cpf
                 , p.identificador
                 , p.razao_social
                 , p.cliente as nome_fantasia
                 , p.inscricao_estadual
                 , decode(p.tipo_pessoa, 2 /*Estrangeira*/, pes.endereco, ped.logradouro || ', ' || ped.numero || decode(ped.complemento, null, '', ' - ' || ped.complemento) || decode(ped.bairro, null, '', ' - ' || ped.bairro)) as endereco
                 , decode(p.tipo_pessoa, 2 /*Estrangeira*/, pes.municipio, ped.municipio) as municipio
                 , decode(p.tipo_pessoa, 2 /*Estrangeira*/, 'EX', ped.uf) as uf
                 , decode(t.telefone_id, null, '', '(' || t.fone_ddd || ')' || t.fone_prefixo || '-' || t.fone_numero) as telefone
                 , pe.situacao
                 , decode(pe.situacao, 1, 'Ativo', 0, 'Inativo') as situacao_desc
              from embalagens.v$ponto_estoque pe
             inner join kss.v$pessoa p
                 	 on p.cod_pessoa = pe.cod_pessoa
          	  left join kss.v$pessoa_estrangeira pes
                 	 on pes.cod_pessoa = pe.cod_pessoa
          	  left join kss.v$pessoa_endereco ped
                 	 on ped.cod_pessoa = pe.cod_pessoa
                	and ped.endereco_padrao = 1
          	  left join kss.v$pessoa_telefone pt
                	 on pt.cod_pessoa = pe.cod_pessoa
               	    and pt.telefone_padrao = 1
         	  left join kss.v$telefone t
                	 on t.telefone_id = pt.telefone_id
             where 1 = 1
			<cfif Len(Trim(arguments.ponto_estoque_id))>
               and pe.ponto_estoque_id = #arguments.ponto_estoque_id#
            </cfif>
            <cfif Len(Trim(arguments.pe_tipo_id))>
               and pe.pe_tipo_id in (#arguments.pe_tipo_id#)
            </cfif>
            <cfif Len(Trim(arguments.situacao))>
               and pe.situacao = #arguments.situacao#
            </cfif>
            <cfif arguments.reformadora eq 0>
               and pe.pe_tipo_id <> 3
            </cfif>
            <cfif Len(Trim(arguments.movimentacao_tipo)) >
               and exists (select 1
                             from embalagens.v$ponto_estoque_movimentacao pem
                            where pem.pe_tipo_id = pe.pe_tipo_id
                             and pem.estoque_mov_tipo_id in (#arguments.movimentacao_tipo#) )
            </cfif>
            <cfif Len(Trim(arguments.cod_pessoa))>
               and pe.cod_pessoa = #arguments.cod_pessoa#
            </cfif>
			 order by p.razao_social
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as reformadoras
    -- ANDERSON 30/12/2009 - CRIADO
    --->		
    <cffunction name="get_reformadora" access="remote" returntype="query" output="true">
        <cfargument name="reformadora_id" required="no" default="">
        <cfargument name="cod_pessoa" required="no" default="">
        <cfargument name="situacao" required="no" default="">
        <cfargument name="tipo_embalagem_id" required="no" default="">
        <cfargument name="ativo" required="no" default="">
        <cfargument name="reformadora" required="no" default="">
         <cfargument name="ponto_estoque_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select distinct r.reformadora_id
                         , r.ponto_estoque_id
                         , pte.cod_pessoa
                         , p.cnpj_cpf
                         , p.identificador
                         , trim(p.razao_social) as razao_social
                         , p.cliente as nome_fantasia
                         , p.inscricao_estadual
                         , decode(p.tipo_pessoa, 2 /*Estrangeira*/, pe.endereco, ped.logradouro || ', ' || ped.numero || decode(ped.complemento, null, '', ' - ' || ped.complemento) || decode(ped.bairro, null, '', ' - ' || ped.bairro)) as endereco
                         , decode(p.tipo_pessoa, 2 /*Estrangeira*/, pe.municipio, ped.municipio) as municipio
                         , decode(p.tipo_pessoa, 2 /*Estrangeira*/, 'EX', ped.uf) as uf
                         , decode(t.telefone_id, null, '', '(' || t.fone_ddd || ')' || t.fone_prefixo || '-' || t.fone_numero) as telefone
                         , pte.situacao
                         , decode(pte.situacao, 1, 'Ativo', 0, 'Inativo') as situacao_desc
                      from embalagens.v$reformadora r
                     inner join embalagens.v$ponto_estoque pte
                             on pte.ponto_estoque_id = r.ponto_estoque_id
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = pte.cod_pessoa
                      left join kss.v$pessoa_estrangeira pe
                             on pe.cod_pessoa = p.cod_pessoa
                      left join kss.v$pessoa_endereco ped
                             on ped.cod_pessoa = p.cod_pessoa
                            and ped.endereco_padrao = 1
                      left join kss.v$pessoa_telefone pt
                             on pt.cod_pessoa = p.cod_pessoa
                            and pt.telefone_padrao = 1
                      left join kss.v$telefone t
                             on t.telefone_id = pt.telefone_id
                    <cfif Len(Trim(arguments.tipo_embalagem_id))>
                      inner join embalagens.v$embalagem_reformadora er
                              on er.reformadora_id = r.reformadora_id
                             and er.tipo_embalagem_id = #arguments.tipo_embalagem_id#
                    </cfif>
                     where 1 = 1
                    <cfif Len(Trim(arguments.reformadora_id))>
                       and r.reformadora_id = #arguments.reformadora_id#
                    </cfif>
                    <cfif Len(Trim(arguments.cod_pessoa))>
                       and pte.cod_pessoa = #arguments.cod_pessoa#
                    </cfif>
                    <cfif Len(Trim(arguments.situacao))>
                       and pte.situacao = #arguments.situacao#
                    </cfif>
                    <cfif Len(Trim(arguments.ativo))>
                       and pte.situacao = 1
                    </cfif>
                    <cfif Len(Trim(arguments.reformadora))>
                        and upper(kss.pkg_string.fnc_string_clean(razao_social)) like upper(kss.pkg_string.fnc_string_clean('%#arguments.reformadora#%'))
                    </cfif>
                    <cfif Len(Trim(arguments.ponto_estoque_id))>
                        and r.ponto_estoque_id = #arguments.ponto_estoque_id#
                    </cfif>
                     order by trim(p.razao_social)
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os tipos de embalagem de uma reformadora
    -- ANDERSON 30/12/2009 - CRIADO
    --->		
    <cffunction name="get_embalagem_reformadora" access="remote" returntype="query" output="true">
        <cfargument name="reformadora_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select er.emb_reformadora_id
                 , er.tipo_embalagem_id
                 , te.abreviatura
                 , er.reformadora_id
              from embalagens.v$embalagem_reformadora er
             inner join embalagens.v$tipo_embalagem te
                     on te.tipo_id = er.tipo_embalagem_id
             where er.reformadora_id = #arguments.reformadora_id#
             order by te.abreviatura
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os tipos de reforma
    -- ANDERSON 30/12/2009 - CRIADO
    --->		
    <cffunction name="get_tipo_reforma" access="remote" returntype="query" output="true">
        <cfargument name="tipo_reforma_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfargument name="tipo_embalagem_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tr.tipo_reforma_id
                 , tr.descricao
              from embalagens.v$tipo_reforma tr
             where 1 = 1
			<cfif Len(Trim(arguments.tipo_reforma_id))>
               and tr.tipo_reforma_id = #arguments.tipo_reforma_id#
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(tr.descricao) like upper('#arguments.descricao#%')
            </cfif>
            <cfif Len(Trim(arguments.tipo_embalagem_id))>
               and exists(select 'x'
                            from embalagens.v$tipo_reforma_embalagem tre
                           where tre.tipo_embalagem_id = #arguments.tipo_embalagem_id#
                             and tre.tipo_reforma_id = tr.tipo_reforma_id)
            </cfif>
             order by tr.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os tipos de reforma
    -- ANDERSON 30/12/2009 - CRIADO
    --->		
    <cffunction name="get_tipo_embalagem_reforma" access="remote" returntype="query" output="true">
        <cfargument name="tipo_embalagem_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tre.tipo_reforma_embalagem_id
                 , tre.tipo_reforma_id
                 , tre.tipo_embalagem_id
              from embalagens.v$tipo_reforma_embalagem tre
             where 1 = 1
			<cfif Len(Trim(arguments.tipo_embalagem_id))>
               and tre.tipo_embalagem_id = #arguments.tipo_embalagem_id#
            </cfif>
             order by tre.tipo_reforma_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os motivos de descarte
    -- ANDERSON 31/12/2009 - CRIADO
    --->		
    <cffunction name="get_motivo_descarte" access="remote" returntype="query" output="true">
        <cfargument name="motivo_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfargument name="tipo_embalagem_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select md.motivo_id
                 , md.descricao
              from embalagens.v$motivo_descarte md
             where 1 = 1
			<cfif Len(Trim(arguments.motivo_id))>
               and md.motivo_id = #arguments.motivo_id#
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(md.descricao) like upper('#arguments.descricao#%')
            </cfif>
            <cfif Len(Trim(arguments.tipo_embalagem_id))>
               and exists(select 'x'
                            from embalagens.v$motivo_descarte_embalagem mde
                           where mde.tipo_embalagem_id = #arguments.tipo_embalagem_id#
                             and mde.motivo_id = md.motivo_id)
            </cfif>
             order by md.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os tipos de reforma
    -- ANDERSON 30/12/2009 - CRIADO
    --->		
    <cffunction name="get_tipo_embalagem_motivo_descarte" access="remote" returntype="query" output="true">
        <cfargument name="tipo_embalagem_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mde.mot_tipo_embalagem_id
                 , mde.tipo_embalagem_id
                 , mde.motivo_id
                 , mde.tipo_embalagem_id
              from embalagens.v$motivo_descarte_embalagem mde
             where 1 = 1
			<cfif Len(Trim(arguments.tipo_embalagem_id))>
               and mde.tipo_embalagem_id = #arguments.tipo_embalagem_id#
            </cfif>
             order by mde.motivo_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as movimentaes
    -- ANDERSON 31/12/2009 - CRIADO
    --->		
    <cffunction name="get_movimentacao" access="remote" returntype="query" output="true">
        <cfargument name="movimentacao_id" required="no" default="">
        <cfargument name="num_embalagem" required="no" default="">
        <cfargument name="tipo_embalagem_id" required="no" default="">
        <cfargument name="ponto_estoque_entrada_id" required="no" default="">
        <cfargument name="ponto_estoque_saida_id" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="tipo_movimentacao" required="no" default="">
        <cfargument name="embalagem_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.movimentacao_id
                 , m.movimentacao_tipo_id
                 , (select mt.descricao
                      from embalagens.v$movimentacao_tipo mt
                     where mt.movimentacao_tipo_id = m.movimentacao_tipo_id) as tipo
                 , m.embalagem_id
                 , e.num_embalagem
                 , (select p.identificador
                      from embalagens.v$fabricante f
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = f.cod_pessoa
                     where f.fabricante_id = e.fabricante_id) as cnpj_fabricante
                 , (select p.cliente
                      from embalagens.v$fabricante f
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = f.cod_pessoa
                     where f.fabricante_id = e.fabricante_id) as razao_social_fabricante
                 , m.tipo_embalagem_id
                 , (select ge.descricao
                      from embalagens.v$grupo_embalagem ge
                     where ge.grupo_id = te.grupo_id) as grupo_embalagem
                 , te.descricao as tipo_embalagem
                 , te.capacidade
                 , (select um.unidade
                      from fiscal.v$unidade_medida um
                     where um.cod_unidade = te.cod_unidade) as unidade_medida
                 , te.produto_id
                 , (select p.descricao
                      from fiscal.v$produto p
                     where p.produto_id = te.produto_id) as produto
                 , m.ponto_estoque_entrada_id
                 , (select p.identificador
                      from embalagens.v$ponto_estoque pe
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = pe.cod_pessoa
                     where pe.ponto_estoque_id = m.ponto_estoque_entrada_id) as cnpj_pto_est_entrada
                 , (select p.cliente
                      from embalagens.v$ponto_estoque pe
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = pe.cod_pessoa
                     where pe.ponto_estoque_id = m.ponto_estoque_entrada_id) as razao_social_pto_est_entrada
                 , m.ponto_estoque_saida_id
                 , (select p.identificador
                      from embalagens.v$ponto_estoque pe
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = pe.cod_pessoa
                     where pe.ponto_estoque_id = m.ponto_estoque_saida_id) as cnpj_pto_est_saida
                 , (select p.cliente
                      from embalagens.v$ponto_estoque pe
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = pe.cod_pessoa
                     where pe.ponto_estoque_id = m.ponto_estoque_saida_id) as razao_social_pto_est_saida
                 , m.estoque_tipo_entrada
                 , (select tem.descricao
                      from embalagens.v$tipo_estoque_movimentacao tem
                     where tem.estoque_mov_tipo_id = estoque_tipo_entrada) as estoque_tipo_entrada_desc
                 , m.estoque_tipo_saida
                 , (select tem.descricao
                      from embalagens.v$tipo_estoque_movimentacao tem
                     where tem.estoque_mov_tipo_id = estoque_tipo_saida) as estoque_tipo_saida_desc
                 , m.quantidade
                 , to_char(m.data_movimentacao, 'dd/mm/yyyy hh24:mi:ss') as data_movimentacao
              from embalagens.v$movimentacao m
             inner join embalagens.v$tipo_embalagem te
                     on te.tipo_id = m.tipo_embalagem_id
              left join embalagens.v$embalagem e
                     on e.embalagem_id = m.embalagem_id
             where 1 = 1
            <cfif Len(Trim(arguments.embalagem_id))>
               and e.embalagem_id = #arguments.embalagem_id#
            </cfif> 
			<cfif Len(Trim(arguments.movimentacao_id))>
               and m.movimentacao_id = #arguments.movimentacao_id#
            </cfif>
            <cfif Len(Trim(arguments.num_embalagem))>
               and e.num_embalagem = #arguments.num_embalagem#
            </cfif>
            <cfif Len(Trim(arguments.tipo_embalagem_id))>
               and m.tipo_embalagem_id = #arguments.tipo_embalagem_id#
            </cfif>
            <cfif Len(Trim(arguments.ponto_estoque_entrada_id))>
               and m.ponto_estoque_entrada_id = #arguments.ponto_estoque_entrada_id#
            </cfif>
            <cfif Len(Trim(arguments.ponto_estoque_saida_id))>
               and m.ponto_estoque_saida_id = #arguments.ponto_estoque_saida_id#
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
               and m.data_movimentacao >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
               and m.data_movimentacao <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>
            <cfif Len(Trim(arguments.tipo_movimentacao))>
               and m.movimentacao_tipo_id = #arguments.tipo_movimentacao#
            </cfif>
             order by m.data_movimentacao desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as embalagens
    -- RAFAEL 04/01/2010 - CRIADO
    --->		
    <cffunction name="get_embalagens" access="remote" returntype="query" output="true">
        <cfargument name="num_embalagem" required="no" default="">
        <cfargument name="tipo_embalagem_id" required="no" default="">
        <cfargument name="situacao" required="no" default="">
        <cfargument name="ponto_estoque_atual" required="no" default="">
        <cfargument name="estoque_tipo_movimentacao" required="no" default="1">
        <cfargument name="com_saldo_disponivel" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select e.embalagem_id
            	 , e.num_embalagem
                 , e.situacao
                 , e.tipo_embalagem_id
                 , e.fabricante_id
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = (select f.cod_pessoa
                                             from embalagens.v$fabricante f
                                            where f.fabricante_id = e.fabricante_id)) as fabricante
				 , (select te.descricao  
                      from embalagens.v$tipo_embalagem te
                     where te.tipo_id = e.tipo_embalagem_id
                   ) as tipo_embalagem
            <cfif Len(Trim(arguments.ponto_estoque_atual))>
                 , embalagens.pkg_movimentacao.fnc_saldo_ponto_estoque(e.num_embalagem, e.tipo_embalagem_id, #arguments.ponto_estoque_atual# ,'', #arguments.estoque_tipo_movimentacao#) as quantidade_disponivel
            </cfif>
              from embalagens.v$embalagem e
             where 1 = 1             
        	<cfif Len(Trim(arguments.num_embalagem))>
              and e.num_embalagem = #arguments.num_embalagem#
            </cfif>
			<cfif Len(Trim(arguments.tipo_embalagem_id))>
              and e.tipo_embalagem_id = #arguments.tipo_embalagem_id#
            </cfif>
            <cfif Len(Trim(arguments.situacao))>
              and e.situacao = #arguments.situacao#
            </cfif>
            <cfif Len(Trim(arguments.ponto_estoque_atual)) and arguments.com_saldo_disponivel eq 1>
              and embalagens.pkg_movimentacao.fnc_saldo_ponto_estoque(e.num_embalagem, e.tipo_embalagem_id, #arguments.ponto_estoque_atual# ,'', #arguments.estoque_tipo_movimentacao#) <> 0
            </cfif>
          order by fabricante
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as embalagens
    -- RAFAEL 11/02/2010 - 11:57 -  CRIADO
    --->		
    <cffunction name="get_saldo_embalagem_tipo" access="remote" returntype="query" output="true">
        <cfargument name="tipo_embalagem_id" required="no" default="">
        <cfargument name="ponto_estoque_atual" required="no" default="">
        <cfargument name="estoque_tipo_movimentacao" required="no" default="1">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select pe.ponto_estoque_id
                 , te.tipo_id
                 , te.descricao
                 , embalagens.pkg_movimentacao.fnc_saldo_ponto_estoque('', te.tipo_id,pe.ponto_estoque_id, '', #arguments.estoque_tipo_movimentacao#) as quantidade_disponivel
              from embalagens.v$tipo_embalagem te
        cross join embalagens.v$ponto_estoque pe
             where 1=1
      <cfif Len(Trim(arguments.tipo_embalagem_id))>
        and te.tipo_id = #arguments.tipo_embalagem_id#
      </cfif>
      <cfif Len(Trim(arguments.ponto_estoque_atual))>
        and pe.ponto_estoque_id = #arguments.ponto_estoque_atual#
      </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as reformas
    -- RAFAEL 05/01/2010 - CRIADO
    --->		
    <cffunction name="get_reforma" access="remote" returntype="query" output="true">
        <cfargument name="reforma_id" required="no" default="">
        <cfargument name="tipo_reforma_id" required="no" default="">
        <cfargument name="tipo_embalagem_id" required="no" default="">
        <cfargument name="nao_reformadas" required="no" default="0" hint="Mostrar somente reformas no executadas caso valor = 1">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.reforma_id 
                 , r.tipo_embalagem_id
                 , (select te.descricao
                      from embalagens.v$tipo_embalagem te
                     where te.tipo_id = r.tipo_embalagem_id) as tipo_embalagem
                 , (select te.controlada
                      from embalagens.v$tipo_embalagem te
                     where te.tipo_id = r.tipo_embalagem_id) as controlada
                 , r.reformadora_id
                 , (select r2.ponto_estoque_id
                      from embalagens.v$reformadora r2
                     where r2.reformadora_id = r.reformadora_id) as ponto_estoque_reformadora
                 , (select ma.ponto_estoque_saida_id
                      from embalagens.v$movimentacao_agrupamento ma
                     where ma.movimentacao_agrupamento_id = r.movimentacao_agrup_id)as ponto_estoque_id
                 , (select ma.cod_centro_custo
                     from embalagens.v$movimentacao_agrupamento ma
                    where ma.movimentacao_agrupamento_id = r.movimentacao_agrup_id ) as cod_centro_custo
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = (select pe.cod_pessoa
                                             from embalagens.v$ponto_estoque pe
                                            where pe.ponto_estoque_id = (select ref.ponto_estoque_id
                                                                           from embalagens.v$reformadora ref
                                                                          where ref.reformadora_id = r.reformadora_id))) as reformadora
                 , (select nvl(sum(er.quantidade),0)
                      from embalagens.v$embalagem_reforma er
                     where er.reforma_id = r.reforma_id) as quantidade_embalagens
                 , (select nvl(sum(rr.quantidade),0)
                      from embalagens.v$retorno_reforma rr
                     where rr.embalagem_reforma_id in (select er2.embalagem_reforma_id
                                                         from embalagens.v$embalagem_reforma er2
                                                        where er2.reforma_id = r.reforma_id)) as embalagens_reformadas
                 , (select nvl(sum(ade.quantidade), 0)
                      from embalagens.v$analise_descarte_embalagem ade
                     where ade.reforma_id = r.reforma_id) as embalagens_descartadas
                 , (select to_char(min(er.data_entrada), 'dd/mm/yyyy hh24:mi:ss')
                      from embalagens.v$embalagem_reforma er
                     where er.reforma_id = r.reforma_id) as data_envio
                 , r.user_insert
              from embalagens.v$reforma r
        	 where 1 = 1
			<cfif Len(Trim(arguments.reforma_id))>
               and r.reforma_id = #arguments.reforma_id#
            </cfif>
            <cfif Len(Trim(arguments.tipo_embalagem_id))>
               and r.tipo_embalagem_id = #arguments.tipo_embalagem_id#
            </cfif>
             <cfif arguments.nao_reformadas eq 1>
               and exists (select 'x'
                             from embalagens.v$embalagem_reforma er
                            where er.reforma_id = r.reforma_id
                             and  er.data_saida is null)
            </cfif>
          order by data_envio desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as embalagens
    -- RAFAEL 04/01/2010 - CRIADO
    --->		
    <cffunction name="get_reforma_embalagens" access="remote" returntype="query" output="true">
        <cfargument name="reforma_id" required="no" default="">
        <cfargument name="nao_reformadas" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select er.embalagem_reforma_id
                 , er.embalagem_id
                 , (select r.tipo_embalagem_id
                      from embalagens.v$reforma r
                     where r.reforma_id = er.reforma_id) as tipo_embalagem_id
                 , er.quantidade
                 , embalagens.pkg_movimentacao.fnc_qtde_reformas_restantes(er.embalagem_reforma_id) - (select nvl(sum(ade.quantidade),0)
                                                                                                         from embalagens.v$analise_descarte_embalagem ade
                                                                                                        where ade.REFORMA_ID = er.reforma_id) as quantidade_restante
                 , er.quantidade - embalagens.pkg_movimentacao.fnc_qtde_reformas_restantes(er.embalagem_reforma_id) as quantidade_reformada
                 , (select nvl(sum(ade.quantidade),0)
                      from embalagens.v$analise_descarte_embalagem ade
                     where ade.reforma_id = er.reforma_id) as quantidade_descartada
                 , nvl((select te.controlada
                      from embalagens.v$tipo_embalagem te
                     where te.tipo_id = e.tipo_embalagem_id), 0) as controlada
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = (select f.cod_pessoa
                                             from embalagens.v$fabricante f
                                            where f.fabricante_id = e.fabricante_id)) as fabricante
                  , e.num_embalagem
                  , er.observacao
                  , (select embalagens.pkg_embalagens.fnc_proprietario_embalagem(e.embalagem_id) from  dual) as proprietario                  
              from embalagens.v$embalagem_reforma er
         left join embalagens.v$embalagem e
                on e.embalagem_id = er.embalagem_id
             where 1 = 1
               and er.data_saida is null
         <cfif Len(Trim(arguments.reforma_id))>
              and er.reforma_id = #arguments.reforma_id#
         </cfif>
         <cfif arguments.nao_reformadas eq 1>
              and embalagens.pkg_movimentacao.fnc_qtde_reformas_restantes(er.embalagem_reforma_id) > 0
         </cfif>
          order by fabricante
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as reformas
    -- RAFAEL 05/01/2010 - CRIADO
    --->		
    <cffunction name="get_reforma_itens" access="remote" returntype="query" output="true">
        <cfargument name="reforma_id" required="no" default="">
        <cfargument name="tipo_reforma_id" required="no" default="">
        <cfargument name="tipo_embalagem_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select er.embalagem_reforma_id
                 , er.embalagem_id
                 , er.quantidade
                 , embalagens.pkg_movimentacao.fnc_qtde_reformas_restantes(er.embalagem_reforma_id) - (select nvl(sum(ade.quantidade),0)
                                                                                                         from embalagens.v$analise_descarte_embalagem ade
                                                                                                        where ade.REFORMA_ID = er.reforma_id) as quantidade_restante
                 , er.quantidade - embalagens.pkg_movimentacao.fnc_qtde_reformas_restantes(er.embalagem_reforma_id) as quantidade_reformada
                 , (select nvl(sum(ade.quantidade),0)
                      from embalagens.v$analise_descarte_embalagem ade
                     where ade.reforma_id = er.reforma_id) as quantidade_descartada
                 , (select e.num_embalagem
                      from embalagens.v$embalagem e
                     where e.embalagem_id = er.embalagem_id) as num_embalagem
                 , er.observacao
                 , embalagens.pkg_embalagens.fnc_fabricante_embalagem(er.embalagem_id) as fabricante
                 , tre.tipo_reforma_id
                 , (select tr.descricao
                      from embalagens.v$tipo_reforma tr
                     where tr.tipo_reforma_id = tre.tipo_reforma_id) as tipo_reforma
                 , r.tipo_embalagem_id
              from embalagens.v$embalagem_reforma er
         left join embalagens.v$reforma r
                on r.reforma_id = er.reforma_id 
         left join embalagens.v$tipo_reforma_embalagem tre
                on tre.tipo_embalagem_id = r.tipo_embalagem_id
             where 1 = 1
               and er.data_saida is null
               and embalagens.pkg_movimentacao.fnc_qtde_reformas_restantes(er.embalagem_reforma_id) <> 0
            <cfif Len(Trim(arguments.reforma_id))>
               and r.reforma_id = #arguments.reforma_id#
            </cfif>            
          order by num_embalagem,  fabricante, tipo_reforma
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as reformas
    -- RAFAEL 05/01/2010 - CRIADO
    --->		
    <cffunction name="get_descarte" access="remote" returntype="query" output="true">
        <cfargument name="analise_descarte_id" required="no" default="">
        <cfargument name="ponto_estoque_id" required="no" default="">
        <cfargument name="tipo_embalagem_id" required="no" default="">
        <cfargument name="nao_descartadas" required="no" default="0" hint="Mostrar somente descartes no executadas caso valor = 1">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ad.analise_descarte_id 
                 , ad.tipo_embalagem_id
                 , (select te.descricao
                      from embalagens.v$tipo_embalagem te
                     where te.tipo_id = ad.tipo_embalagem_id) as tipo_embalagem
                 , (select te.controlada
                      from embalagens.v$tipo_embalagem te
                     where te.tipo_id = ad.tipo_embalagem_id) as controlada
                 , (select ma.ponto_estoque_entrada_id
                      from embalagens.v$movimentacao_agrupamento ma
                     where ma.movimentacao_agrupamento_id = ad.movimentacao_agrup_id ) as ponto_estoque_id
                 , (select p.cliente || ' - ' || p.identificador
                      from kss.v$pessoa p
                     where p.cod_pessoa = ( select pe.cod_pessoa
                                              from embalagens.v$ponto_estoque pe
                                             where pe.ponto_estoque_id = (select ma.ponto_estoque_entrada_id
                                                                            from embalagens.v$movimentacao_agrupamento ma
                                                                           where ma.movimentacao_agrupamento_id = ad.movimentacao_agrup_id ))) as ponto_estoque_descricao
                 , (select nvl(sum(ade.quantidade),0)
                      from embalagens.v$analise_descarte_embalagem ade
                     where ade.analise_descarte_id = ad.analise_descarte_id) as quantidade_embalagens
                 , (select nvl(sum(d.quantidade),0)
                      from embalagens.v$descarte d
                     where d.analise_embalagem_id in (select ade2.analise_embalagem_id
                                                         from embalagens.v$analise_descarte_embalagem ade2
                                                        where ade2.analise_descarte_id = ad.analise_descarte_id)) as embalagens_descartadas
                 , (select nvl(sum(re.quantidade),0)
                      from embalagens.v$retorno_estoque re
                     where re.analise_embalagem_id in ((select ade.analise_embalagem_id
                                                         from embalagens.v$analise_descarte_embalagem ade
                                                        where ade.analise_descarte_id = ad.analise_descarte_id))) as embalagens_retornadas
                 , (select to_char(min(ade3.data_entrada), 'dd/mm/yyyy hh24:mi:ss')
                      from embalagens.v$analise_descarte_embalagem ade3
                     where ade3.analise_descarte_id = ad.analise_descarte_id) as data_envio
                 , ad.user_insert
                 , (select ma.cod_centro_custo
                      from embalagens.v$movimentacao_agrupamento ma
                     where ma.movimentacao_agrupamento_id = ad.movimentacao_agrup_id)as cod_centro_custo
                 , (select ma.ponto_estoque_entrada_id
                      from embalagens.v$movimentacao_agrupamento ma
                     where ma.movimentacao_agrupamento_id = ad.movimentacao_agrup_id)as ponto_estoque_entrada_id
              from embalagens.v$analise_descarte ad
           where 1 = 1
			<cfif Len(Trim(arguments.analise_descarte_id))>
               and ad.analise_descarte_id = #arguments.analise_descarte_id#
            </cfif>
            <cfif Len(Trim(arguments.ponto_estoque_id))>
               and ad.ponto_estoque_id = #arguments.ponto_estoque_id#
            </cfif>
            <cfif Len(Trim(arguments.tipo_embalagem_id))>
               and ad.tipo_embalagem_id = #arguments.tipo_embalagem_id#
            </cfif>
             <cfif arguments.nao_descartadas eq 1>
               and exists (select 'x'
                             from embalagens.v$analise_descarte_embalagem ade
                            where ade.analise_descarte_id = ad.analise_descarte_id
                             and  ade.data_saida is null)
            </cfif>
          order by data_envio desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as embalagens
    -- RAFAEL 04/01/2010 - CRIADO
    --->		
    <cffunction name="get_descarte_embalagens" access="remote" returntype="query" output="true">
        <cfargument name="analise_descarte_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ade.analise_embalagem_id
                 , ade.analise_descarte_id
            	 , ade.embalagem_id
                 , nvl((select te.controlada
                          from embalagens.v$tipo_embalagem te
                         where te.tipo_id = e.tipo_embalagem_id), 0) as controlada
                 , (select ad.tipo_embalagem_id
                     from embalagens.v$analise_descarte ad
                    where ad.analise_descarte_id = ade.analise_descarte_id) as tipo_embalagem_id
                  , (select te.descricao
                       from embalagens.v$tipo_embalagem te
                      where te.tipo_id = (select ad.tipo_embalagem_id
                                            from embalagens.v$analise_descarte ad
                                           where ad.analise_descarte_id = ade.analise_descarte_id)) as tipo_descricao
                 , ade.quantidade
                 , embalagens.pkg_movimentacao.fnc_qtde_descartes_restantes(ade.analise_embalagem_id) as quantidade_restante
                 , (select nvl(sum(d.quantidade),0)
                      from embalagens.v$descarte d
                     where d.analise_embalagem_id = ade.analise_embalagem_id) as embalagens_descartadas
                 , (select nvl(sum(re.quantidade),0)
                      from embalagens.v$retorno_estoque re
                     where re.analise_embalagem_id = ade.analise_embalagem_id) as embalagens_retornadas
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = (select f.cod_pessoa
                                             from embalagens.v$fabricante f
                                            where f.fabricante_id = e.fabricante_id)) as fabricante
                  , e.num_embalagem
                  , ade.observacao
                  , (select embalagens.pkg_embalagens.fnc_proprietario_embalagem(e.embalagem_id) from  dual) as proprietario
              from embalagens.v$analise_descarte_embalagem ade
         left join embalagens.v$embalagem e
                on e.embalagem_id = ade.embalagem_id
             where 1 = 1
               and embalagens.pkg_movimentacao.fnc_qtde_descartes_restantes(ade.analise_embalagem_id) <> 0 
         <cfif Len(Trim(arguments.analise_descarte_id))>
              and ade.analise_descarte_id = #arguments.analise_descarte_id#
         </cfif>
          order by fabricante
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as reformas
    -- RAFAEL 05/01/2010 - CRIADO
    --->		
    <cffunction name="get_descarte_itens" access="remote" returntype="query" output="true">
        <cfargument name="analise_descarte_id" required="no" default="">
        <cfargument name="tipo_embalagem_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ade.analise_embalagem_id
                 , ade.analise_descarte_id
                 , ade.embalagem_id
                 , ade.quantidade
                 , embalagens.pkg_movimentacao.fnc_qtde_descartes_restantes(ade.analise_embalagem_id) as quantidade_restante
                 , ade.quantidade - embalagens.pkg_movimentacao.fnc_qtde_descartes_restantes(ade.analise_embalagem_id) as quantidade_descartada
                 , (select e.num_embalagem
                      from embalagens.v$embalagem e

                     where e.embalagem_id = ade.embalagem_id) as num_embalagem
                 , ade.observacao
                 , embalagens.pkg_embalagens.fnc_fabricante_embalagem(ade.embalagem_id) as fabricante
                 , ad.tipo_embalagem_id
                 , mde.motivo_id
                 , (select md.descricao
                      from embalagens.v$motivo_descarte md
                     where md.motivo_id = mde.motivo_id) as motivo_descarte
              from embalagens.v$analise_descarte_embalagem ade
         left join embalagens.v$analise_descarte ad
                on ad.analise_descarte_id = ade.analise_descarte_id
         left join embalagens.v$motivo_descarte_embalagem mde
                on mde.tipo_embalagem_id = ad.tipo_embalagem_id
             where 1 = 1
              and embalagens.pkg_movimentacao.fnc_qtde_descartes_restantes(ade.analise_embalagem_id) <> 0
			<cfif Len(Trim(arguments.analise_descarte_id))>
               and ad.analise_descarte_id = #arguments.analise_descarte_id#
            </cfif>            
          order by num_embalagem, motivo_descarte
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as reformas
    -- RAFAEL 05/01/2010 - CRIADO
    --->		
    <cffunction name="get_transferencia" access="remote" returntype="query" output="true">
        <cfargument name="transferencia_id" required="no" default="">
        <cfargument name="tipo_embalagem_id" required="no" default="">
        <cfargument name="nao_confirmadas" required="no" default="0" hint="Mostrar somente transferencias no confirmadas caso valor = 1">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.transferencia_id 
                 , t.tipo_embalagem_id
                 , (select te.descricao
                      from embalagens.v$tipo_embalagem te
                     where te.tipo_id = t.tipo_embalagem_id) as tipo_embalagem
                 , (select te.controlada
                      from embalagens.v$tipo_embalagem te
                     where te.tipo_id = t.tipo_embalagem_id) as controlada
                 , (select ma.ponto_estoque_entrada_id
                      from embalagens.v$movimentacao_agrupamento ma
                     where ma.movimentacao_agrupamento_id = t.movimentacao_agrup_id ) as ponto_estoque_id
                 , (select p.cliente || ' - ' || p.identificador
                      from kss.v$pessoa p
                     where p.cod_pessoa = ( select pe.cod_pessoa
                                              from embalagens.v$ponto_estoque pe
                                             where pe.ponto_estoque_id = (select ma.ponto_estoque_entrada_id
                                                                            from embalagens.v$movimentacao_agrupamento ma
                                                                           where ma.movimentacao_agrupamento_id = t.movimentacao_agrup_id))) as ponto_estoque_descricao
                 , (select nvl(sum(tre.quantidade),0)
                      from embalagens.v$transferencia_embalagem tre
                     where tre.transferencia_id = t.transferencia_id) as quantidade_embalagens
                 , (select nvl(sum(tec.quantidade),0)
                      from embalagens.v$transf_emb_confirmacao tec
                     where tec.transferencia_embalagem_id in (select trae.transferencia_embalagem_id
                                                                from embalagens.v$transferencia_embalagem trae
                                                               where trae.transferencia_id = t.transferencia_id)) as quantidade_confirmada      
                 , t.user_insert
                 , (select to_char(min(tre.data_entrada), 'dd/mm/yyyy hh24:mi:ss')
                      from embalagens.v$transferencia_embalagem tre
                     where tre.transferencia_id = t.transferencia_id) as data_envio
              from embalagens.v$transferencia t
           where 1 = 1
			<cfif Len(Trim(arguments.transferencia_id))>
               and t.transferencia_id = #arguments.transferencia_id#
            </cfif>
            <cfif Len(Trim(arguments.tipo_embalagem_id))>
               and t.tipo_embalagem_id = #arguments.tipo_embalagem_id#
            </cfif>
            <cfif arguments.nao_confirmadas eq 1>
               and exists (select 'x'
                             from embalagens.v$transferencia_embalagem t2
                            where t2.transferencia_id =  t.transferencia_id
                             and  t2.data_saida is null)
            </cfif>
          order by t.transferencia_id desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as embalagens
    -- RAFAEL 04/01/2010 - CRIADO
    --->		
    <cffunction name="get_transferencia_embalagens" access="remote" returntype="query" output="true">
        <cfargument name="transferencia_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select tre.transferencia_embalagem_id
                , tre.transferencia_id
                , tre.embalagem_id
                , nvl((select te.controlada
                        from embalagens.v$tipo_embalagem te
                       where te.tipo_id = e.tipo_embalagem_id), 0) as controlada
                , (select t.tipo_embalagem_id
                     from embalagens.v$transferencia t
                    where t.transferencia_id = tre.transferencia_id) as tipo_embalagem_id
                , (select te.descricao
                     from embalagens.v$tipo_embalagem te
                    where te.tipo_id = (select t.tipo_embalagem_id
                                          from embalagens.v$transferencia t
                                         where t.transferencia_id = tre.transferencia_id)) as tipo_descricao
                , tre.quantidade
                , tre.quantidade -  embalagens.pkg_movimentacao.fnc_qtde_transf_confirmadas(tre.transferencia_embalagem_id) as quantidade_restante
                , (select p.cliente
                    from kss.v$pessoa p
                   where p.cod_pessoa = (select f.cod_pessoa
                                           from embalagens.v$fabricante f
                                          where f.fabricante_id = e.fabricante_id)) as fabricante
                , e.num_embalagem
                , tre.observacao
                , (select embalagens.pkg_embalagens.fnc_proprietario_embalagem(e.embalagem_id) from  dual) as proprietario
                , (select t.movimentacao_agrup_id
                     from embalagens.v$transferencia t
                    where t.transferencia_id = tre.transferencia_id) as movimentacao_agrup_id
              from embalagens.v$transferencia_embalagem tre
         left join embalagens.v$embalagem e
                on e.embalagem_id = tre.embalagem_id
             where 1 = 1
               and tre.quantidade -  embalagens.pkg_movimentacao.fnc_qtde_transf_confirmadas(tre.transferencia_embalagem_id) <> 0
         <cfif Len(Trim(arguments.transferencia_id))>
              and tre.transferencia_id = #arguments.transferencia_id#
         </cfif>
          order by fabricante
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as transferncias pendentes de confirmao de um cliente
    -- ANDERSON 15/04/2010 - CRIADO
    --->
    <cffunction name="get_transferencia_cliente" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa_cliente" required="yes">
        <cfargument name="transferencia_id" required="no" default="">
        <cfargument name="tipo_embalagem_id" required="no" default="">
        <cfargument name="nao_confirmadas" required="no" default="0" hint="Retorna somente as transferncias no confirmadas caso o valor seja 1 (Um)">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.transferencia_id 
                 , t.tipo_embalagem_id
                 , (select te.descricao
                      from embalagens.v$tipo_embalagem te
                     where te.tipo_id = t.tipo_embalagem_id) as tipo_embalagem
                 , (select te.controlada
                      from embalagens.v$tipo_embalagem te
                     where te.tipo_id = t.tipo_embalagem_id) as controlada
                 , (select ma.ponto_estoque_entrada_id
                      from embalagens.v$movimentacao_agrupamento ma
                     where ma.movimentacao_agrupamento_id = t.movimentacao_agrup_id) as ponto_estoque_id
                 , (select p.cliente || ' - ' || p.identificador
                      from kss.v$pessoa p
                     where p.cod_pessoa = (select pe.cod_pessoa
                                             from embalagens.v$ponto_estoque pe
                                            where pe.ponto_estoque_id = (select ma.ponto_estoque_entrada_id
                                                                           from embalagens.v$movimentacao_agrupamento ma
                                                                          where ma.movimentacao_agrupamento_id = t.movimentacao_agrup_id))) as ponto_estoque_descricao
                 , (select nvl(sum(tci.quantidade), 0)
                      from embalagens.v$transferencia_cliente_it tci
                     where tci.transferencia_id = t.transferencia_id) as quantidade_embalagens
                 , (select nvl(sum(tcic.quantidade), 0)
                      from embalagens.v$transf_cliente_it_conf tcic
                     where tcic.transferencia_cliente_it_id in (select tci.transferencia_cliente_it_id
                                                                  from embalagens.v$transferencia_cliente_it tci
                                                                 where tci.transferencia_id = t.transferencia_id)) as quantidade_confirmada      
                 , t.user_insert
                 , (select to_char(min(tci.date_insert), 'dd/mm/yyyy hh24:mi:ss')
                      from embalagens.v$transferencia_cliente_it tci
                     where tci.transferencia_id = t.transferencia_id) as data_envio
              from embalagens.v$transferencia_cliente t
             where (select pe.cod_pessoa
                      from embalagens.v$movimentacao_agrupamento ma
                     inner join embalagens.v$ponto_estoque pe
                             on pe.ponto_estoque_id = ma.ponto_estoque_entrada_id
                     where ma.movimentacao_agrupamento_id = t.movimentacao_agrup_id) = #arguments.cod_pessoa_cliente#
			<cfif Len(Trim(arguments.transferencia_id))>
               and t.transferencia_id = #arguments.transferencia_id#
            </cfif>
            <cfif Len(Trim(arguments.tipo_embalagem_id))>
               and t.tipo_embalagem_id = #arguments.tipo_embalagem_id#
            </cfif>
            <cfif arguments.nao_confirmadas eq 1>
               and exists (select 'x'
                             from embalagens.v$transferencia_cliente_it tci
                            where tci.transferencia_id = t.transferencia_id
                              and tci.data_fechamento is null)
            </cfif>
             order by t.transferencia_id desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os itens de uma transferncia de um cliente
    -- ANDERSON 15/04/2010 - CRIADO
    --->		
    <cffunction name="get_transferencia_cliente_it" access="remote" returntype="query" output="true">
        <cfargument name="transferencia_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tci.transferencia_cliente_it_id
                 , tci.transferencia_id
                 , tci.embalagem_id
                 , nvl((select te.controlada
                          from embalagens.v$tipo_embalagem te
                         where te.tipo_id = e.tipo_embalagem_id), 0) as controlada
                 , (select t.tipo_embalagem_id
                      from embalagens.v$transferencia_cliente t
                     where t.transferencia_id = tci.transferencia_id) as tipo_embalagem_id
                 , (select te.descricao
                      from embalagens.v$tipo_embalagem te
                     where te.tipo_id = (select t.tipo_embalagem_id
                                           from embalagens.v$transferencia_cliente t
                                          where t.transferencia_id = tci.transferencia_id)) as tipo_descricao
                 , tci.quantidade
                 , tci.quantidade - embalagens.pkg_movimentacao.fnc_qtde_transf_cliente_conf(tci.transferencia_cliente_it_id) as quantidade_restante
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = (select f.cod_pessoa
                                             from embalagens.v$fabricante f
                                            where f.fabricante_id = e.fabricante_id)) as fabricante
                 , e.num_embalagem
                 , embalagens.pkg_embalagens.fnc_proprietario_embalagem(e.embalagem_id) as proprietario
                 , (select t.movimentacao_agrup_id
                      from embalagens.v$transferencia_cliente t
                     where t.transferencia_id = tci.transferencia_id) as movimentacao_agrup_id
              from embalagens.v$transferencia_cliente_it tci
              left join embalagens.v$embalagem e
                     on e.embalagem_id = tci.embalagem_id
             where tci.quantidade - embalagens.pkg_movimentacao.fnc_qtde_transf_cliente_conf(tci.transferencia_cliente_it_id) <> 0
			<cfif Len(Trim(arguments.transferencia_id))>
               and tci.transferencia_id = #arguments.transferencia_id#
         	</cfif>
             order by fabricante
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as embalagens
    -- ANDERSON 15/04/2010 - CRIADO
    --->		
    <cffunction name="get_retorno_cliente" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa_cliente" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rc.retorno_id
                 , rc.embalagem_id
                 , nvl((select te.controlada
                          from embalagens.v$tipo_embalagem te
                         where te.tipo_id = e.tipo_embalagem_id), 0) as controlada
                 , rc.tipo_embalagem_id
                 , (select te.descricao
                      from embalagens.v$tipo_embalagem te
                     where te.tipo_id = rc.tipo_embalagem_id) as tipo_descricao
                 , rc.quantidade
                 , embalagens.pkg_movimentacao.fnc_qtde_retornos_restantes(rc.retorno_id) as quantidade_restante
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = (select f.cod_pessoa
                                             from embalagens.v$fabricante f
                                            where f.fabricante_id = e.fabricante_id)) as fabricante
                 , e.num_embalagem
                 , embalagens.pkg_embalagens.fnc_proprietario_embalagem(e.embalagem_id) as proprietario
                 , rc.num_nota_id
                 , nvl((select to_char(nf.num_nota_fiscal)
                          from fiscal.v$nf_es nf
                         where nf.num_nota_id = rc.num_nota_id), 'Sem Nota Fiscal') as num_nota_fiscal
                 , (select tc.movimentacao_agrup_id
                      from embalagens.v$transf_cliente_it_conf tcic
                     inner join embalagens.v$transferencia_cliente_it tci
                             on tci.transferencia_cliente_it_id = tcic.transferencia_cliente_it_id
                     inner join embalagens.v$transferencia_cliente tc
                             on tc.transferencia_id = tci.transferencia_id
                     where tcic.transf_cliente_it_conf_id = rc.transf_cliente_it_conf_id) as movimentacao_agrup_id
              from embalagens.v$retorno_cliente rc
              left join embalagens.v$embalagem e
                     on e.embalagem_id = rc.embalagem_id
             where (select pe.cod_pessoa
                      from embalagens.v$ponto_estoque pe
                     where pe.ponto_estoque_id = rc.ponto_estoque_id) = #arguments.cod_pessoa_cliente#
               and embalagens.pkg_movimentacao.fnc_qtde_retornos_restantes(rc.retorno_id) <> 0
             order by num_nota_fiscal, rc.tipo_embalagem_id, fabricante, e.num_embalagem
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as embalagens retornadas de um cliente
    -- ANDERSON 15/04/2010 - CRIADO
    --->		
    <cffunction name="get_retorno_cliente_conf" access="remote" returntype="query" output="true">
    	<cfargument name="retorno_cliente_conf_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.identificador as rem_cnpj_cpf
                 , p.razao_social as rem_razao_social
                 , p.cliente as rem_nome_fantasia
                 , nvl((select to_char(nf.num_nota_fiscal)
                          from fiscal.v$nf_es nf
                         where nf.num_nota_id = rc.num_nota_id), 'Sem Nota Fiscal') as num_nota_fiscal
                 , rc.tipo_embalagem_id
                 , (select te.descricao
                      from embalagens.v$tipo_embalagem te
                     where te.tipo_id = rc.tipo_embalagem_id) as tipo_descricao
                 , rcci.quantidade
                 , nvl((select te.controlada
                          from embalagens.v$tipo_embalagem te
                         where te.tipo_id = e.tipo_embalagem_id), 0) as controlada
                 , e.num_embalagem
              from embalagens.v$retorno_cliente_conf_it rcci
             inner join embalagens.v$retorno_cliente rc
                     on rc.retorno_id = rcci.retorno_id
             inner join embalagens.v$ponto_estoque pe
                     on pe.ponto_estoque_id = rc.ponto_estoque_id
             inner join kss.v$pessoa p
                     on p.cod_pessoa = pe.cod_pessoa
              left join embalagens.v$embalagem e
                     on e.embalagem_id = rc.embalagem_id
             where rcci.retorno_cliente_conf_id = #arguments.retorno_cliente_conf_id#
             order by num_nota_fiscal, rc.tipo_embalagem_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as reformas
    -- RAFAEL 05/01/2010 - CRIADO
    --->		
    <cffunction name="get_movimentacao_agrupamento" access="remote" returntype="query" output="true">
        <cfargument name="movimentacao_agrupamento_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ma.movimentacao_agrupamento_id
                 , ma.movimentacao_tipo_id
                 , ma.num_nota_id
                 , to_char(ma.data_movimentacao,'dd/mm/yyyy hh24:mi') as data_movimentacao
                 , ma.ponto_estoque_saida_id
                 , ma.estoque_tipo_saida
                 , ma.ponto_estoque_entrada_id
                 , ma.estoque_tipo_entrada
                 , ma.cod_centro_custo
              from embalagens.v$movimentacao_agrupamento ma             
			<cfif Len(Trim(arguments.movimentacao_agrupamento_id))>
             where ma.movimentacao_agrupamento_id = #arguments.movimentacao_agrupamento_id#
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os Tipos de Movimentao
    -- ERIC 29/03/2010 - CRIADO
    --->		
    <cffunction name="get_movimentacao_tipo" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mt.movimentacao_tipo_id
                 , mt.descricao
              from embalagens.v$movimentacao_tipo mt
             order by mt.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Relatrio de Posio por Ponto de Estoque, Tipo de Movimentao e Tipo de Embalagem.
    -- ANDREF 01/04/2010 - CRIADO
    --->		
    <cffunction name="get_posicao_ponto_estoque" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select t.tipo_embalagem_id
                , t.descricao
                , t.ponto_estoque_entrada_id
                , t.ponto_estoque
                , t.estoque + t.transito + t.reforma + t.analise_descarte + t.descartada + t.utilizacao as quantidade_total
                , t.estoque
                , t.transito
                , t.reforma
                , t.analise_descarte
                , t.descartada
                , t.utilizacao
             from ( 
            select m.tipo_embalagem_id
                 , (select te.descricao
                      from embalagens.v$tipo_embalagem te
                     where te.tipo_id = m.tipo_embalagem_id ) as descricao
                 , nvl(m.ponto_estoque_entrada_id, 0) as ponto_estoque_entrada_id
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = (select pe.cod_pessoa
                                             from embalagens.v$ponto_estoque pe
                                            where pe.ponto_estoque_id = m.ponto_estoque_entrada_id)) as ponto_estoque
                 , sum(m.quantidade) as quantidade_total
                 , (
                    (select to_number(nvl(sum(m1.quantidade),0))
                      from embalagens.v$movimentacao m1
                     where m1.estoque_tipo_entrada = 1
                       and m1.tipo_embalagem_id = m.tipo_embalagem_id
                       and m1.ponto_estoque_entrada_id = m.ponto_estoque_entrada_id)
                  - (select to_number(nvl(sum(m1.quantidade),0))
                      from embalagens.v$movimentacao m1
                     where m1.estoque_tipo_saida = 1
                       and m1.tipo_embalagem_id = m.tipo_embalagem_id
                       and m1.ponto_estoque_saida_id = m.ponto_estoque_entrada_id)
                   ) as estoque
                 , (
                    (select to_number(nvl(sum(m2.quantidade),0))
                       from embalagens.v$movimentacao m2
                      where m2.estoque_tipo_entrada = 2
                        and m2.tipo_embalagem_id = m.tipo_embalagem_id
                        and m2.ponto_estoque_entrada_id = m.ponto_estoque_entrada_id)
                  - (select nvl(sum(m6.quantidade),0)
                       from embalagens.v$movimentacao m6
                      where m6.estoque_tipo_saida = 2
                        and m6.tipo_embalagem_id = m.tipo_embalagem_id
                        and m6.ponto_estoque_saida_id = m.ponto_estoque_entrada_id)
                   ) as transito
                 , (
                    (select nvl(sum(m3.quantidade),0)
                       from embalagens.v$movimentacao m3
                      where m3.estoque_tipo_entrada = 3
                        and m3.tipo_embalagem_id = m.tipo_embalagem_id
                        and m3.ponto_estoque_entrada_id = m.ponto_estoque_entrada_id)
                  - (select nvl(sum(m3.quantidade),0)
                       from embalagens.v$movimentacao m3
                      where m3.estoque_tipo_saida = 3
                        and m3.tipo_embalagem_id = m.tipo_embalagem_id
                        and m3.ponto_estoque_saida_id = m.ponto_estoque_entrada_id)
                    ) as reforma
                 , (
                    (select nvl(sum(m4.quantidade),0)
                       from embalagens.v$movimentacao m4
                      where m4.estoque_tipo_entrada = 4
                        and m4.tipo_embalagem_id = m.tipo_embalagem_id
                        and m4.ponto_estoque_entrada_id = m.ponto_estoque_entrada_id)
                  - (select nvl(sum(m4.quantidade),0)
                       from embalagens.v$movimentacao m4
                      where m4.estoque_tipo_saida = 4
                        and m4.tipo_embalagem_id = m.tipo_embalagem_id
                        and m4.ponto_estoque_saida_id = m.ponto_estoque_entrada_id)
                   ) as analise_descarte
                 , 0 as descartada
                 , (
                    (select nvl(sum(m6.quantidade),0)
                       from embalagens.v$movimentacao m6
                      where m6.estoque_tipo_entrada = 6
                        and m6.tipo_embalagem_id = m.tipo_embalagem_id
                        and m6.ponto_estoque_entrada_id = m.ponto_estoque_entrada_id)
                  - (select nvl(sum(m6.quantidade),0)
                      from embalagens.v$movimentacao m6
                     where m6.estoque_tipo_saida = 6
                       and m6.tipo_embalagem_id = m.tipo_embalagem_id
                       and m6.ponto_estoque_saida_id = m.ponto_estoque_entrada_id)
                   ) as utilizacao
              from embalagens.v$movimentacao m
              where m.ponto_estoque_entrada_id is not null
              group by m.tipo_embalagem_id, m.ponto_estoque_entrada_id
              
              union all
              
              select m.tipo_embalagem_id
                 , (select te.descricao
                      from embalagens.v$tipo_embalagem te
                     where te.tipo_id = m.tipo_embalagem_id ) as descricao
                 , nvl(m.ponto_estoque_entrada_id, 0) as ponto_estoque_entrada_id
                 , 'Descarte' as ponto_estoque
                 , sum(m.quantidade) as quantidade_total
                 , to_number(0) as estoque
                 , to_number(0) as transito
                 , 0 as reforma
                 , 0 as analise_descarte
                 , (select nvl(sum(m6.quantidade),0)
                      from embalagens.v$movimentacao m6
                     where m6.tipo_embalagem_id = m.tipo_embalagem_id
                       and m6.ponto_estoque_entrada_id is null) as descartada
                 , 0 as utilizacao
              from embalagens.v$movimentacao m
             where m.ponto_estoque_entrada_id is null   
              group by m.tipo_embalagem_id, m.ponto_estoque_entrada_id) t
              order by t.ponto_estoque_entrada_id, t.tipo_embalagem_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
       <!--- 
    -- PROPSITO 
    -- Consulta de Embalagens Controladas.
    -- LEANDROR 09/04/2010 - CRIADO
    --->		
    <cffunction name="get_embalagens_controladas" access="remote" returntype="query" output="true">          		
		<cfargument name="embalagem_id" required="no" default="">    
   		<cfargument name="tipo_embalagem_id" required="no" default="">
  		<cfargument name="situacao" required="no" default="">        
  		<cfargument name="possui_reforma" required="no" default="">        
   		<cfargument name="data_aquisicao_inicio" required="no" default="">
   		<cfargument name="data_aquisicao_fim" required="no" default="">
   		<cfargument name="data_descarte_inicio" required="no" default="">
   		<cfargument name="data_descarte_fim" required="no" default="">                
  		<cfargument name="ponto_estoque_atual_id" required="no" default="">                
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">        
            select e.embalagem_id
            	 , e.num_embalagem
                 , (select p.cliente
                      from embalagens.v$fabricante f
                     inner join kss.v$pessoa p
                             on  p.cod_pessoa = f.cod_pessoa
                     where e.fabricante_id = f.fabricante_id
                       ) as fabricante                   
                       
                 , te.descricao as tipo_embalagem                           
                 
                 , decode((select count(er.embalagem_reforma_id)
                             from embalagens.v$embalagem_reforma er
                            where er.embalagem_id = e.embalagem_id), 0, 'No','Sim') possui_reforma                 
                            
                 , nvl(to_char((select max(er.data_entrada)
                      		      from embalagens.v$embalagem_reforma er
                     		     where er.embalagem_id = e.embalagem_id), 'dd/mm/yyyy hh24:mi:ss'),'No possui') as ultima_reforma                 
                     
                 , nvl(to_char((select m.data_movimentacao
                         from embalagens.v$movimentacao m
                        where m.movimentacao_tipo_id = 3
                          and m.embalagem_id = e.embalagem_id),'dd/mm/yyyy hh24:mi:ss'),
                      to_char((select m.data_movimentacao
                         from embalagens.v$movimentacao m
                        where m.movimentacao_tipo_id = 1
                          and m.embalagem_id = e.embalagem_id),'dd/mm/yyyy hh24:mi:ss')) as data_aquisicao                          
                          
                , (select count(m.estoque_tipo_entrada) as num_viagem
                                      from embalagens.v$movimentacao m
                                     where m.estoque_tipo_entrada = 6
                                     and m.embalagem_id = e.embalagem_id) as num_viagens_carga                     
                     
                 , te.capacidade 
                 , te.cod_unidade        
                 
                 , nvl(to_char((select m.data_movimentacao
                          from embalagens.v$movimentacao m
                         where m.movimentacao_tipo_id = 6
                           and m.embalagem_id = e.embalagem_id), 'dd/mm/yyyy hh24:mi:ss'), 'Em uso' ) as data_descarte
                                 
                 , trunc(nvl((select m.data_movimentacao
                                from embalagens.v$movimentacao m
                               where m.movimentacao_tipo_id = 6 
                                 and m.embalagem_id = e.embalagem_id), sysdate)) -
                   trunc(nvl((select m.data_movimentacao
                                from embalagens.v$movimentacao m
                               where m.movimentacao_tipo_id = 3         
                                 and m.embalagem_id = e.embalagem_id),
                             (select m.data_movimentacao
                                from embalagens.v$movimentacao m
                               where m.movimentacao_tipo_id = 1 
                                 and m.embalagem_id = e.embalagem_id))) as tempo_utilizacao
                                 
               , nvl(to_char((select m.ponto_estoque_entrada_id 
                        from embalagens.v$movimentacao m
                       where m.embalagem_id = e.embalagem_id
                         and m.data_movimentacao = (select max(me.data_movimentacao) 
                                                     from embalagens.v$movimentacao me 
                                                    where me.embalagem_id = e.embalagem_id))), 'Descartada') as ponto_estoque_atual_id
                                                    
                ,  nvl(to_char((select p.cliente || ' (' ||pet.descricao || ') ' || ' - ' || p.identificador 
                                         from embalagens.v$movimentacao m
                                        inner join embalagens.v$ponto_estoque pe
                                                on pe.ponto_estoque_id = m.ponto_estoque_entrada_id
                                        inner join embalagens.v$ponto_estoque_tipo pet
                                                on pet.pe_tipo_id = pe.pe_tipo_id
                                        inner join kss.v$pessoa p
                                                on p.cod_pessoa = pe.cod_pessoa                                
                                        where m.embalagem_id = e.embalagem_id
                                          and m.data_movimentacao = (select max(me.data_movimentacao) 
                                                                         from embalagens.v$movimentacao me 
                                                                        where me.embalagem_id = e.embalagem_id))),'Descartada') as ponto_estoque_atual
                                 
                                                                                                 
              from embalagens.v$embalagem e
             inner join embalagens.v$tipo_embalagem te
                   on te.tipo_id = e.tipo_embalagem_id
           
     		 where te.controlada = 1

            <cfif Len(Trim(arguments.embalagem_id))>
                 and e.embalagem_id = #arguments.embalagem_id#
            </cfif>         	
            <cfif Len(Trim(arguments.tipo_embalagem_id))>
                 and te.tipo_id = #arguments.tipo_embalagem_id#
            </cfif>
             <cfif Len(Trim(arguments.situacao))>
                  and e.situacao = #arguments.situacao#
            </cfif>                                
             <cfif Len(Trim(arguments.situacao))>
                  and e.situacao = #arguments.situacao#
            </cfif>                                
             <cfif Len(Trim(arguments.possui_reforma))>
                  and e.possui_reforma = #arguments.possui_reforma#
            </cfif>                                
             <cfif Len(Trim(arguments.data_aquisicao_inicio))>
                  and e.embalagem_id in (select m.embalagem_id
                                        from  embalagens.v$movimentacao m
                                       where m.movimentacao_tipo_id in(1,3)
                                         and m.data_movimentacao between to_date('#arguments.data_aquisicao_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_aquisicao_fim#', 'dd/mm/yyyy'))
            </cfif>                                
             <cfif Len(Trim(arguments.data_descarte_inicio))>
                  and e.embalagem_id in (select m.embalagem_id
                                        from  embalagens.v$movimentacao m
                                       where m.movimentacao_tipo_id = 6
                                         and m.data_movimentacao between to_date('#arguments.data_descarte_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_descarte_fim#', 'dd/mm/yyyy'))
            </cfif>                                
             <cfif Len(Trim(arguments.ponto_estoque_atual_id))>
                  and e.embalagem_id in (select m.embalagem_id 
                                        from embalagens.v$movimentacao m
                                       where m.data_movimentacao = (select max(m.data_movimentacao) as data_movimentacao
                                                                      from embalagens.v$movimentacao m 
                                                                     where m.embalagem_id = e.embalagem_id)
                                         and m.ponto_estoque_entrada_id = #arguments.ponto_estoque_atual_id#)
            </cfif> 
             order by ponto_estoque_atual_id, e.num_embalagem                                                                    
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
        <!--- 
		-- PROPSITO 
		-- Valida Embalagem
		-- LEANDROR 13/04/2010 - CRIADO
		--->		
    <cffunction name="get_embalagem_id" access="remote" returntype="query" output="true">
	    <cfargument name="num_embalagem" required="no" default="">
        <cfargument name="tipo_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">        
            select e.embalagem_id
              from embalagens.v$embalagem e
             where 1 = 1
            <cfif Len(Trim(arguments.num_embalagem))>
                  and e.num_embalagem = #arguments.num_embalagem#
            </cfif>
            <cfif Len(Trim(arguments.tipo_id))>
                  and e.tipo_embalagem_id = #arguments.tipo_id#
            </cfif>    
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as embalagens
    -- FABIOG 13/04/2011 - CRIADO
    --->		
    <cffunction name="get_embalagens_situacao_atual" access="remote" returntype="query" output="true">
        <cfargument name="num_embalagem" required="no" default="">
        <cfargument name="tipo_embalagem_id" required="no" default="">
        <cfargument name="situacao" required="no" default="">
        <cfargument name="ponto_estoque_atual" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select e.embalagem_id
                 , e.num_embalagem
                 , (select te.descricao
                      from embalagens.v$tipo_embalagem te
                     where te.tipo_id = e.tipo_embalagem_id
                   )as tipo_embalagem  
                 , nvl(to_char((select m.ponto_estoque_entrada_id 
                                  from embalagens.v$movimentacao m
                                 where m.embalagem_id = e.embalagem_id
                                   and m.data_movimentacao = (select max(me.data_movimentacao) 
                                                                from embalagens.v$movimentacao me 
                                                               where me.embalagem_id = e.embalagem_id))), 'Descartada') as ponto_estoque_atual_id
                 , nvl(to_char((select p.cliente || ' (' ||pet.descricao || ') ' || ' - ' || p.identificador 
                                  from embalagens.v$movimentacao m
                                 inner join embalagens.v$ponto_estoque pe
                                         on pe.ponto_estoque_id = m.ponto_estoque_entrada_id
                                 inner join embalagens.v$ponto_estoque_tipo pet
                                         on pet.pe_tipo_id = pe.pe_tipo_id
                                 inner join kss.v$pessoa p
                                         on p.cod_pessoa = pe.cod_pessoa                                
                                 where m.embalagem_id = e.embalagem_id
                                   and m.data_movimentacao = (select max(me.data_movimentacao) 
                                                                from embalagens.v$movimentacao me 
                                                               where me.embalagem_id = e.embalagem_id))),'Descartada') as ponto_estoque_atual
                 , to_char(m.data_movimentacao, 'dd/mm/yyyy hh24:MM:ss') as data_movimentacao 
                 , m.user_insert as usuario_movimentacao
                 , m.estoque_tipo_entrada
              from embalagens.v$embalagem e 
             inner join embalagens.v$movimentacao m
                     on m.embalagem_id = e.embalagem_id
                    and m.movimentacao_id = (select max(m2.movimentacao_id) keep(dense_rank last order by m2.data_movimentacao)
                                               from embalagens.v$movimentacao m2
                                              where m2.embalagem_id = e.embalagem_id
                                            )
        <cfif Len(Trim(arguments.ponto_estoque_atual)) and not Len(Trim(arguments.num_embalagem))>
                 inner join embalagens.v$ponto_estoque pe
        				 on pe.ponto_estoque_id = m.ponto_estoque_entrada_id
                        and m.embalagem_id = e.embalagem_id
                        and pe.ponto_estoque_id = #arguments.ponto_estoque_atual#
        </cfif> 
             where 1 = 1     
		<cfif Len(Trim(arguments.num_embalagem))>
                 and e.num_embalagem = #arguments.num_embalagem#
        </cfif>  
        <cfif Len(Trim(arguments.tipo_embalagem_id)) and not Len(Trim(arguments.num_embalagem))>
                 and e.tipo_embalagem_id = #arguments.tipo_embalagem_id#
        </cfif>
        <cfif Len(Trim(arguments.situacao)) and not Len(Trim(arguments.num_embalagem))>
                and m.estoque_tipo_entrada = #arguments.situacao#
        </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
     <!--- 
	-- PROPSITO 
	-- Retorna as situaes possveis da embalagem
	-- FABIOG 14/04/2011 - CRIADO
	--->		
    <cffunction name="get_situacao_embalagem" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">        
            select em.estoque_mov_tipo_id
                 , em.descricao
              from embalagens.v$tipo_estoque_movimentacao em
             order by em.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>  
    
      <!--- 
	-- PROPSITO 
	-- Verifica se o destinatrio  um ponto de estoque
	-- FABIOG 14/04/2011 - CRIADO
	--->		
    <cffunction name="get_destinatario_ponto_estoque" access="remote" returntype="query" output="true">
	    <cfargument name="cod_pessoa" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">        
            select pe.ponto_estoque_id
                 , et.pe_tipo_id as tipo_movimentacao_entrada
                 , case
                      when et.pe_tipo_id = 1 then 19
                      when et.pe_tipo_id = 2 then 13
                      else 18
                    end as movimentacao_tipo
              from embalagens.v$ponto_estoque pe
             inner join embalagens.v$ponto_estoque_tipo et
                     on et.pe_tipo_id = pe.pe_tipo_id
             where pe.cod_pessoa = #arguments.cod_pessoa#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as transferncias para envio ao estoque
    -- FABIOG 19/04/2011 - CRIADO
    --->
    <cffunction name="get_retorno_filial" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rf.retorno_filial_id
                 , rf.embalagem_id
                 , nvl((select te.controlada
                          from embalagens.v$tipo_embalagem te
                         where te.tipo_id = e.tipo_embalagem_id), 0) as controlada
                 , rf.tipo_embalagem_id
                 , (select te.descricao
                      from embalagens.v$tipo_embalagem te
                     where te.tipo_id = rf.tipo_embalagem_id) as tipo_descricao
                 , rf.quantidade
                 , embalagens.pkg_movimentacao.fnc_qtde_ret_filial_restantes(rf.retorno_filial_id) as quantidade_restante
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = (select f.cod_pessoa
                                             from embalagens.v$fabricante f
                                            where f.fabricante_id = e.fabricante_id)) as fabricante
                 , e.num_embalagem
                 , embalagens.pkg_embalagens.fnc_proprietario_embalagem(e.embalagem_id) as proprietario
                 , rf.num_nota_id
                 , nvl((select to_char(nf.num_nota_fiscal)
                          from fiscal.v$nf_es nf
                         where nf.num_nota_id = rf.num_nota_id), 'Sem Nota Fiscal') as num_nota_fiscal
                 , (select rcci.movimentacao_agrup_id
                      from embalagens.v$retorno_cliente_conf_it rcci
                     where rcci.retorno_cliente_conf_it_id = rf.retorno_cliente_conf_it_id
                   ) as movimentacao_agrup_id
              from embalagens.v$retorno_filial rf
              left join embalagens.v$embalagem e
                     on e.embalagem_id = rf.embalagem_id
             where (select pe.cod_pessoa
                      from embalagens.v$ponto_estoque pe
                     where pe.ponto_estoque_id = rf.ponto_estoque_id) = #session.cod_pessoa#
               and embalagens.pkg_movimentacao.fnc_qtde_ret_filial_restantes(rf.retorno_filial_id) <> 0
             order by num_nota_fiscal, rf.tipo_embalagem_id, fabricante
        </cfquery>
        <cfreturn qr_result>
    </cffunction>             
</cfcomponent>