<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Busca ocorrecias EMPRESA
    -- 19/01/2009 - criado
    --->	
    <cffunction name="get_ocorrencias_proceda" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="ocorrencia_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select op.ocorrencia_id
                 , op.descricao
              from oper.v$ocorrencia_proceda op
            where 1=1
            <cfif Len(Trim(arguments.DESCRICAO))>
              and upper(op.descricao) like upper('%#arguments.DESCRICAO#%')
            </cfif>
            <cfif Len(Trim(arguments.OCORRENCIA_ID))>
              and op.ocorrencia_id = #arguments.OCORRENCIA_ID#
            </cfif>
            order by op.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
	
	<!--- 
    -- PROPSITO
    -- Busca ocorrecias CTRC
    -- 19/01/2009 - criado
    --->	 
    <cffunction name="get_ocorrencias_ctrc" displayname="" output="true" returntype="query" access="remote">
    	<cfargument name="conhecimento_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select co.carga_ocorrencia_id, cc.carga_id, cc.conhecimento_id, 
                   co.ocorrencia_id, to_char(co.data,'dd/mm/yyyy hh24:mi') as data,
                   co.observacao
              from oper.v$carga_ctrc cc
             inner join oper.v$carga_ocorrencia co
                     on cc.carga_id = co.carga_id
             inner join oper.v$ocorrencia_proceda op
                     on op.ocorrencia_id = co.ocorrencia_id
                where 1=1
            <cfif Len(Trim(arguments.CONHECIMENTO_ID))>
				and cc.conhecimento_id = #arguments.CONHECIMENTO_ID#
            </cfif>
			order by data         
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Busca ocorrecias CTRC
    -- 19/01/2009 - criado
    --->	 
    <cffunction name="get_ocorrencias_ctrc_lista" displayname="" output="true" access="remote" returntype="query">
    	<cfargument name="cod_pessoa_filial" required="no" default=""/>
    	<cfargument name="cod_departamento" required="no" default=""/>
    	<cfargument name="cod_setor" required="no" default=""/>
    	<cfargument name="cod_centro_custo" required="no" default=""/>
    	<cfargument name="rem_cnpj" required="no" default=""/>
    	<cfargument name="data_entrega_inicio" required="no" default=""/>
    	<cfargument name="data_entrega_fim" required="no" default=""/>
    	<cfargument name="data_emissao_inicio" required="no" default=""/>
    	<cfargument name="data_emissao_fim" required="no" default=""/>
        <cfargument name="num_conhecimento" required="no" default=""/>
        <cfargument name="conhecimento_id" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.conhecimento_id, 
                   c.num_conhecimento, c.serie,
                   c.cod_pessoa_filial,
                   kss.fnc_get_identificador(c.cod_pessoa_filial) as filial_cnpj_cpf,
                   kss.fnc_get_cliente(c.cod_pessoa_filial) as filial_descricao,
                   (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = c.cod_pessoa_filial)  as filial_nome_fantasia,
                   c.cod_remetente,
                   kss.fnc_get_identificador(c.cod_remetente) as remetente_cnpj,
                   kss.fnc_get_cliente(c.cod_remetente) as remetente_descricao,
                   -- Dados da Nota Fiscal
                   cn.numero, 
                   to_char(cn.data_emissao,'dd/mm/yyy hh24:mi') as data_emissao,
                   -- Ocorrencias
                   to_char(co.data,'dd/mm/yyy hh24:mi') as data, 
                   co.ocorrencia_id,
                   op.descricao,
                   -- Auditoria
                   co.user_insert,
                   to_char(co.date_insert,'dd/mm/yyy hh24:mi') as date_insert,
                   co.user_update,
                   to_char(co.date_update,'dd/mm/yyy hh24:mi') as date_update
              from fiscal.v$conhecimento c
             inner join oper.v$carga_ctrc ct
                     on ct.conhecimento_id = c.conhecimento_id
             inner join oper.v$carga ca
                     on ca.carga_id = ct.carga_id
             inner join fiscal.v$conhecimento_nota_fiscal cn
                     on cn.conhecimento_id = ct.conhecimento_id
             inner join oper.v$carga_ocorrencia co
                     on co.carga_id = ca.carga_id
             left join oper.v$ocorrencia_empresa op
                     on op.ocorrencia_id = co.ocorrencia_id
             where 1 = 1 
               <cfif Len(Trim(arguments.cod_pessoa_filial))>
	               and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
               </cfif>
               <cfif Len(Trim(arguments.cod_departamento))>
	               and c.cod_departamento = #arguments.cod_departamento#
               </cfif>
               <cfif Len(Trim(arguments.cod_setor))>
	               and c.cod_setor = #arguments.cod_setor#
               </cfif>
               <cfif Len(Trim(arguments.cod_centro_custo))>
	               and c.cod_centro_custo = #arguments.cod_centro_custo#
               </cfif>
               <cfif Len(Trim(arguments.num_conhecimento))>
	               and c.num_conhecimento = #arguments.num_conhecimento#
               </cfif>
               <cfif Len(Trim(arguments.conhecimento_id))>
	               and c.conhecimento_id = #arguments.conhecimento_id#
               </cfif>
               <cfif Len(Trim(arguments.rem_cnpj))>
	               and c.rem_cnpj_cpf = #arguments.rem_cnpj#
               </cfif>
               <cfif Len(Trim(arguments.data_entrega_inicio))>
	               and trunc(c.data_entrega) >= to_date('#arguments.data_entrega_inicio#','dd/mm/yyyy') 
               </cfif>
               <cfif Len(Trim(arguments.data_entrega_fim))>
                   and trunc(c.data_entrega) <= to_date('#arguments.data_entrega_fim#','dd/mm/yyyy')
               </cfif>
               <cfif Len(Trim(arguments.data_emissao_inicio))>
	               and trunc(c.data_emissao) >= to_date('#arguments.data_emissao_inicio#','dd/mm/yyyy') 
               </cfif>
               <cfif Len(Trim(arguments.data_emissao_fim))>
                   and trunc(c.data_emissao) <= to_date('#arguments.data_emissao_fim#','dd/mm/yyyy')
               </cfif>
             order by c.conhecimento_id
        </cfquery>
        <cfreturn qr_result/>
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Busca ocorrecias para visualizao de  CTRC
    -- 19/01/2009 - criado
    --->	 
    <cffunction name="get_ocorrencias_ctrc_visualizacao" displayname="" output="true" returntype="query" access="remote">
    	<cfargument name="conhecimento_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select co.carga_ocorrencia_id
                 , cc.carga_id
                 , cc.conhecimento_id
                 , co.ocorrencia_id
                 , to_char(co.data, 'dd/mm/yyyy hh24:mi') as data
                 , co.observacao
                 , op.descricao
                 , co.user_insert
                 , to_char(co.date_insert,'dd/mm/yyy hh24:mi') as date_insert
                 , co.user_update
                 , to_char(co.date_update,'dd/mm/yyy hh24:mi') as date_update
              from oper.v$carga_ctrc cc
        inner join oper.v$carga_ocorrencia co
                on cc.carga_id = co.carga_id
        inner join oper.v$ocorrencia_empresa op
                on op.ocorrencia_id = co.ocorrencia_id
             where 1=1
            <cfif Len(Trim(arguments.CONHECIMENTO_ID))>
			   and cc.conhecimento_id = #arguments.CONHECIMENTO_ID#
            </cfif>
			order by data         
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
</cfcomponent>