<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPÓSITO
    -- Busca transações
    -- 27/02/2012 - criado
    --->	
    <cffunction name="get_transacao" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.transacao_id
                 , t.nome_arquivo
                 , t.status status_id 
                 , case when t.status = 0 then 'Pendente'
                        when t.status = 1 then 'Em Processamento'
                        when t.status = 2 then 'Integrado'
                        when t.status = 3 then 'Com Falha'
                   end as status
                 , null as conteudo
                 , t.observacao
                 , to_char(t.date_insert, 'dd/mm/yyyy hh24:mi') date_insert
                 , ct.lancto_id
                 , ct.num_romaneio
                 , ct.num_formulario
                 , ct.serie_formulario
                 , to_char(ct.data_emissao, 'dd/mm/yyyy hh24:mi') data_emissao
                 , ct.peso
                 , ct.peso_entregue
                 , co.num_conhecimento
                 , co.serie
                 , co.rem_razao_social
                 , co.rem_cnpj_cpf
                 , co.dest_razao_social
                 , co.dest_cnpj_cpf
                 , c.num_nota_fiscal as nota_integracao
                 , c.serie as serie_integracao
                 , cnf.numero as nota_conhecimento
                 , cnf.serie as serie_conhecimento
              from ediall.v$transacao t
              left join oper.v$contrato_transp_edi c
                     on t.transacao_id = c.transacao_id
              left join oper.v$contrato_transp ct
                     on ct.lancto_id = c.lancto_id
              left join fiscal.v$conhecimento co
                     on co.conhecimento_id = c.conhecimento_id
              left join fiscal.v$conhecimento_nota_fiscal cnf
                     on cnf.conhecimento_id = co.conhecimento_id
             where 1=1
               <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_fim))>
               and trunc(t.date_insert) between to_date('#arguments.data_inicio#','dd/mm/yyyy') and to_date('#arguments.data_fim#','dd/mm/yyyy')
               <cfelse> 
                 and 1=0 /* não busca resultado */
               </cfif>
             order by t.date_insert
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
    -- PROPÓSITO
    -- Busca transações
    -- 27/02/2012 - criado
    --->	
    <cffunction name="get_transacao_xml" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="transacao_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.transacao_id
                 , t.conteudo
              from ediall.v$transacao t
             where t.transacao_id = #arguments.transacao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    
	

</cfcomponent>