<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Busca autenticacao do CTF FRETE
    -- 13/02/2009 - criado
    --->	
    <cffunction name="get_autenticacao" displayname="" output="true" returntype="query" access="public">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select usuario, senha, cnpj_acesso, 
            	   url_webservice, url_impressao, 
                   cod_contratante 
              from ctffrete.v$autenticacao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>	

	<!--- 
    -- PROPSITO
    -- Busca dados contrato
    -- 13/02/2009 - criado
    --->	
    <cffunction name="get_contrato_ctf" displayname="" output="true" returntype="query" access="public">
        <cfargument name="transacao_id" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ct.controle_id, ct.lancto_id, ct.cod_contrato_ctf, ct.transacao_id 
              from ctffrete.v$contrato_transp_ctf ct
             where 1=1
               <cfif Len(Trim(arguments.transacao_id))>
	               and ct.transacao_id = #arguments.transacao_id#
               </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>	

	<!--- 
    -- PROPSITO
    -- Busca dados das operaoes vinculadas ao contrato
    -- 13/02/2009 - criado
    --->	
    <cffunction name="get_contrato_operacao" displayname="" output="true" returntype="query" access="public">
        <cfargument name="transacao_id" required="no" default=""/>
        <cfargument name="cod_contrato_ctf" required="no" default=""/>        
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cg.rv_meaning as operacao, co.tipo_operacao, co.transacao_id, co.id_operacao, co.nr_cpf_motorista, co.cod_contrato_frete, 
                   co.cod_contrato_frota, co.num_conhecimento, nvl(co.valor_lancamento,0) as valor_lancamento, co.flag_abastecimento, 
                   co.preco_litro_combustivel, to_char(co.data_realizacao_operacao,'dd/mm/yyyy hh24:mm') as data_realizacao_operacao, 
                   co.flag_contingencia, co.nome_posto, co.cod_posto, 
                   co.data_criacao_contrato, 
                   co.cod_controle, co.nr_cnpj_posto, (select coalesce(ct.valor_frete_liquido,0)
                                                         from ctffrete.v$contrato_transp_ctf ctc
                                                        inner join oper.v$contrato_transp ct
                                                                on ct.lancto_id = ctc.lancto_id 
                                                        where ctc.cod_contrato_ctf = co.cod_contrato_frete) as total,
                   coalesce((select sum(ct.valor)
                      from ctffrete.v$contrato_transp_ctf ctc
                     inner join oper.v$contrato_transp_item ct
                             on ct.lancto_id = ctc.lancto_id 
                     where ct.item_id in (7)
                       and ctc.cod_contrato_ctf = co.cod_contrato_frete),0) as adto,
                    	coalesce(sum(case 
                            when co.tipo_operacao in ('ADIA','LIQ') and co.flag_abastecimento = 1 then co.valor_lancamento
                        else 0 end)  over(),0) as valor_abastecimento_total_adto,
                    coalesce(sum(case 
                          when co.tipo_operacao in ('ADIA','LIQ') and co.flag_abastecimento = 0 then co.valor_lancamento
                        else 0 end)  over(),0) as valor_dinheiro_total_adto,
                    coalesce(sum(case 
                          when co.tipo_operacao in ('QUIT') and co.flag_abastecimento = 1 then co.valor_lancamento
                        else 0 end)  over(),0) as valor_abastecimento_total_quit,
                    coalesce(sum(case 
                          when co.tipo_operacao in ('QUIT') and co.flag_abastecimento = 0 then co.valor_lancamento
                        else 0 end)  over(),0) as valor_dinheiro_total_quit,
                    kss.pkg_global.FNC_OBTEM_PARAMETRO_NUM(11,'OPERACIONAL',306) as perc_abastecimento
              from ctffrete.v$contrato_operacao co
              left join ctffrete.v$cg_ref_codes cg
                     on cg.rv_abbreviation = co.tipo_operacao
                    and cg.rv_domain = 'CTF_OPERACAO_TIPO_OPERACAO' 
             where 1=1
               <cfif Len(Trim(arguments.transacao_id))>
	               and co.transacao_id = #arguments.transacao_id#
               </cfif>
               <cfif Len(Trim(arguments.cod_contrato_ctf))>
	               and co.cod_contrato_frete = #arguments.cod_contrato_ctf#
               </cfif>
              order by co.data_realizacao_operacao 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>	

	<!--- 
    -- PROPSITO
    -- Busca dados das operaoes vinculadas ao contrato
    -- 13/02/2009 - criado
    --->	
    <cffunction name="get_contrato_resumo" displayname="" output="true" returntype="query" access="public">
        <cfargument name="cod_contrato_ctf" required="no" default=""/>        
        <cfargument name="lancto_id" required="no" default=""/>        
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select ctc.cod_contrato_ctf, 
                	   coalesce(ct.valor_frete_liquido, 0) as total,
                       coalesce((select sum(coalesce(ct.valor,0))
                          from ctffrete.v$contrato_transp_ctf ctc2
                         inner join oper.v$contrato_transp_item ct 
                                 on ct.lancto_id = ctc2.lancto_id
                         where ct.item_id in (7)
                           and ctc2.cod_contrato_ctf = ctc.cod_contrato_ctf), 0) as adto,
                       kss.pkg_global.FNC_OBTEM_PARAMETRO_NUM(11,'OPERACIONAL',306) as perc_abastecimento
                  from ctffrete.v$contrato_transp_ctf ctc
                 inner join oper.v$contrato_transp ct 
                         on ct.lancto_id = ctc.lancto_id
                 where 1=1
               <cfif Len(Trim(arguments.cod_contrato_ctf))>
	               and ctc.cod_contrato_ctf = #arguments.cod_contrato_ctf#
               </cfif>
               <cfif Len(Trim(arguments.lancto_id))>
	               and ctc.lancto_id = #arguments.lancto_id#
               </cfif>               
        </cfquery>
        <cfreturn qr_result>
    </cffunction>	    

	<!--- 
    -- PROPSITO
    -- Busca dados das operaoes vinculadas ao contrato
    -- 13/02/2009 - criado
    --->	
    <cffunction name="get_contrato_lancamento" displayname="" output="true" returntype="query" access="public">
        <cfargument name="transacao_id" required="no" default=""/>
        <cfargument name="cod_contrato_ctf" required="no" default=""/>        
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cl.transacao_id, cl.id_operacao, cl.cod_contrato_frete, cl.cod_contrato_frota, 
                   cl.num_conhecimento, cl.status_lancamento, cl.dc_status_lancamento, cl.valor_lancamento, 
                   cl.flag_abastecimento, cl.preco_litro_combustivel, 
                   to_char(cl.data_realizacao_operacao,'dd/mm/yyyy hh24:ss') as data_realizacao_operacao, 
                   to_char(cl.data_debito_frota,'dd/mm/yyyy hh24:ss') as data_debito_frota, 
                   to_char(cl.data_credito_posto,'dd/mm/yyyy hh24:ss') as data_credito_posto, 
                   cl.flag_contingencia, cl.nome_posto, cl.cod_posto, cl.tipo_operacao, 
                   cl.data_criacao_contrato, cl.cod_controle, 
                   cl.nr_agencia, cl.nr_cc, cl.nr_dig_cc, cl.nr_cnpj_posto
              from ctffrete.v$contrato_lancamento cl
             where 1=1
               <cfif Len(Trim(arguments.transacao_id))>
	               and cl.transacao_id = #arguments.transacao_id#
               </cfif>
               <cfif Len(Trim(arguments.cod_contrato_ctf))>
	               and cl.cod_contrato_frete = #arguments.cod_contrato_ctf#
               </cfif>
              order by cl.data_realizacao_operacao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>	

	<!--- 
    -- PROPSITO
    -- Busca doctos
    -- 13/02/2009 - criado
    --->	
    <cffunction name="get_tipo_documentos" displayname="" output="true" returntype="query" access="public">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select codigo, nome 
              from ctffrete.v$tipo_documento
          </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca as transaes do CTF Frete
    -- ANDERSON 23/07/2009 - CRIADO
    --->		
    <cffunction name="get_ctf_transacao" access="remote" returntype="query" output="true">
    	<cfargument name="transacao_id" required="no" default="">
        <cfargument name="lancto_id" required="no" default="">
        <cfargument name="num_formulario" required="no" default="">        
        <cfargument name="cod_contrato_ctf" required="no" default="">        
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ctc.lancto_id
                 , ct.num_formulario
                 , (select p.cliente
                     from kss.v$pessoa p
                    where p.cod_pessoa = ct.cod_pessoa_filial) as filial
                 , ctc.cod_contrato_ctf
                 , ctc.transacao_id
                 , decode(ctc.bloquear_contrato, 1, 'Sim', 'No') as bloquear_contrato
                 , decode(ctc.liquidado_manualmente, 1, 'Sim', 'No') as liquidado_manualmente
                 , to_char(ctc.date_insert, 'dd/mm/yyyy') as date_insert
                 , ctc.user_insert
                 , t.xml_enviado.getCLOBVal() as xml_enviado
                 , t.xml_retorno.getCLOBVal() as xml_retorno
                 , t.cod_erro
                 , t.erro
              from ctffrete.v$contrato_transp_ctf ctc
             inner join ctffrete.v$transacao t
                     on t.transacao_id = ctc.transacao_id
             inner join oper.v$contrato_transp ct
                     on ct.lancto_id = ctc.lancto_id
             where 1 = 1
			<cfif Len(Trim(arguments.transacao_id))>
               and ctc.transacao_id = #arguments.transacao_id#
            </cfif>
            <cfif Len(Trim(arguments.lancto_id))>
               and ctc.lancto_id = #arguments.lancto_id#
            </cfif>
            <cfif Len(Trim(arguments.num_formulario))>
               and ct.num_formulario = #arguments.num_formulario#
            </cfif>
            <cfif Len(Trim(arguments.cod_contrato_ctf))>
               and ctc.cod_contrato_ctf = #arguments.cod_contrato_ctf#
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
               and trunc(ctc.date_insert) >= '#arguments.data_inicio#'
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
               and trunc(ctc.date_insert) <= '#arguments.data_fim#'
            </cfif>
             order by ctc.date_insert
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca os Logs transaes do CTF Frete
    -- RAFAEL 24/07/2009 - CRIADO
    --->		
    <cffunction name="get_ctf_log_transacao" access="remote" returntype="query" output="true">
    	<cfargument name="transacao_id" required="no" default="">
        <cfargument name="operacao" required="no" default="">        
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select t.transacao_id
               ,ctf.lancto_id
               ,ct.num_formulario
               ,(select p.cliente
                   from kss.v$pessoa p
                  where p.cod_pessoa = ct.cod_pessoa_filial) as filial
               ,ctf.cod_contrato_ctf
               ,o.nome as operacao
               ,to_char(ctf.date_insert, 'dd/mm/yyyy') as date_insert
               ,ctf.user_insert
               ,t.xml_enviado.getCLOBVal() as xml_enviado
               ,t.xml_retorno.getCLOBVal() as xml_retorno
               ,t.cod_erro
               ,t.erro
           from ctffrete.v$transacao t
     inner join ctffrete.v$operacao o
             on o.operacao_id = t.operacao_id
      left join ctffrete.v$contrato_transp_ctf ctf
             on ctf.transacao_id = t.transacao_id
      left join oper.v$contrato_transp ct
             on ct.lancto_id = ctf.lancto_id
          where 1 = 1
          	<cfif Len(Trim(arguments.transacao_id))>
               and t.transacao_id = #arguments.transacao_id#
            </cfif>
			<cfif Len(Trim(arguments.operacao))>
               and t.operacao_id = '#arguments.operacao#'
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
               and trunc(t.date_insert) >= '#arguments.data_inicio#'
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
               and trunc(t.date_insert) <= '#arguments.data_fim#'
            </cfif>
             order by ctf.date_insert
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca as operaes de  transaes do CTF Frete
    -- RAFAEL 24/07/2009 - CRIADO
    --->		
    <cffunction name="get_operacao_transacao" access="remote" returntype="query" output="true">
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select o.operacao_id
                  ,o.nome
              from ctffrete.v$operacao o
          order by o.nome
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca os dados do contrato
    -- ANDERSON 02/09/2009 - CRIADO
    --->		
    <cffunction name="get_dados_contrato" access="remote" returntype="query" output="true">
        <cfargument name="lancto_id" required="no" default="">
        <cfargument name="num_formulario" required="no" default="">
        <cfargument name="cod_contrato_ctf" required="no" default="">
        <cfargument name="historico" required="no" default="0" hint="0-No; 1-Sim">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            <!---Caso seja somente busca--->
			<cfif arguments.historico neq 1>
            select distinct
                   case
                     when c.data_atualizacao is null then
                      1
                     else
                      0
                   end as atualizar,
                   c.consulta_id,
                   t.lancto_id,
                   ct.num_formulario,
                   t.cod_contrato_ctf as cod_contrato,
                   to_char(c.data_consulta, 'dd/mm/yyyy hh24:mi:ss') as data_consulta,
                   to_char(c.data_atualizacao, 'dd/mm/yyyy hh24:mi:ss') as data_atualizacao,
                   c.total_consumido,
                   c.total_contratado,
                   c.saldo_total,
                   c.adto_consumido,
                   c.adto_contratado,
                   c.quitacao_consumido,
                   c.quitacao_contratado,
                   c.adto_comb_consumido,
                   c.adto_comb_contratado,
                   c.quitacao_comb_consumido,
                   c.quitacao_comb_contratado,
                   c.adto_saque_consumido,
                   c.adto_saque_contratado,
                   c.quitacao_saque_consumido,
                   c.quitacao_saque_contratado,
                   (select cg.rv_meaning
                      from kss.cg_ref_codes cg
                     where cg.rv_domain = 'STATUS CONTRATO'
                       and cg.owner = 'CTFFRETE'
                       and cg.rv_low_value = c.status_contrato) as status_contrato,
                   c.credito_adicional,
                   c.debito_adicional,
                   t.cod_contrato_ctf
              from (select distinct
                   max(c.consulta_id) as consulta_id,
                   max(ctc.lancto_id) as lancto_id,
                   max(ct.num_formulario) as num_formulario,
                   max(c.cod_contrato) as cod_contrato,
                   max(ctc.cod_contrato_ctf) as cod_contrato_ctf
              from ctffrete.v$contrato_transp_ctf ctc
             inner join oper.v$contrato_transp ct
                     on ct.lancto_id = ctc.lancto_id
              left join ctffrete.v$contrato_transp_dados_ctf c
                     on c.cod_contrato = ctc.cod_contrato_ctf
                  where 1 = 1
                    <cfif Len(Trim(arguments.lancto_id))>
                       and ctc.lancto_id = #arguments.lancto_id#
                    </cfif>
                    <cfif Len(Trim(arguments.num_formulario))>
                       and ct.num_formulario = #arguments.num_formulario#
                    </cfif>
                    <cfif Len(Trim(arguments.cod_contrato_ctf))>
                       and ctc.cod_contrato_ctf = #arguments.cod_contrato_ctf#
                    </cfif>
                    <cfif Len(Trim(arguments.data_inicio))>
                       and trunc(ctc.date_insert) >= '#arguments.data_inicio#'
                    </cfif>
                    <cfif Len(Trim(arguments.data_fim))>
                       and trunc(ctc.date_insert) <= '#arguments.data_fim#'
                    </cfif>
               group by ct.num_formulario)t
             inner join oper.v$contrato_transp ct
                     on ct.lancto_id = t.lancto_id
              left join ctffrete.v$contrato_transp_dados_ctf c
                     on c.cod_contrato = t.cod_contrato_ctf
                    and c.consulta_id = t.consulta_id
             order by t.cod_contrato_ctf
            <cfelse>
              select case
                       when c.data_atualizacao is null then
                        1
                       else
                        0
                     end as atualizar,
                     c.consulta_id,
                     t.lancto_id,
                     ct.num_formulario,
                     t.cod_contrato_ctf as cod_contrato,
                     to_char(c.data_consulta, 'dd/mm/yyyy hh24:mi:ss') as data_consulta,
                     to_char(c.data_atualizacao, 'dd/mm/yyyy hh24:mi:ss') as data_atualizacao,
                     c.total_consumido,
                     c.total_contratado,
                     c.saldo_total,
                     c.adto_consumido,
                     c.adto_contratado,
                     c.quitacao_consumido,
                     c.quitacao_contratado,
                     c.adto_comb_consumido,
                     c.adto_comb_contratado,
                     c.quitacao_comb_consumido,
                     c.quitacao_comb_contratado,
                     c.adto_saque_consumido,
                     c.adto_saque_contratado,
                     c.quitacao_saque_consumido,
                     c.quitacao_saque_contratado,
                     (select cg.rv_meaning
                        from kss.cg_ref_codes cg
                       where cg.rv_domain = 'STATUS CONTRATO'
                         and cg.owner = 'CTFFRETE'
                         and cg.rv_low_value = c.status_contrato) as status_contrato,
                     c.credito_adicional,
                     c.debito_adicional,
                     t.cod_contrato_ctf
                from (select c.consulta_id as consulta_id,
                             ctc.lancto_id as lancto_id,
                             ct.num_formulario as num_formulario,
                             c.cod_contrato as cod_contrato,
                             ctc.cod_contrato_ctf as cod_contrato_ctf
                        from ctffrete.v$contrato_transp_ctf ctc
                  inner join oper.v$contrato_transp ct
                          on ct.lancto_id = ctc.lancto_id
                   left join ctffrete.v$contrato_transp_dados_ctf c
                          on c.cod_contrato = ctc.cod_contrato_ctf
                       where 1 = 1
                       <cfif Len(Trim(arguments.lancto_id))>
                           and ctc.lancto_id = #arguments.lancto_id#
                        </cfif>
                        <cfif Len(Trim(arguments.num_formulario))>
                           and ct.num_formulario = #arguments.num_formulario#
                        </cfif>
                        <cfif Len(Trim(arguments.cod_contrato_ctf))>
                           and ctc.cod_contrato_ctf = #arguments.cod_contrato_ctf#
                        </cfif>
                        <cfif Len(Trim(arguments.data_inicio))>
                           and trunc(ctc.date_insert) >= '#arguments.data_inicio#'
                        </cfif>
                        <cfif Len(Trim(arguments.data_fim))>
                           and trunc(ctc.date_insert) <= '#arguments.data_fim#'
                        </cfif>
                         )t
               inner join oper.v$contrato_transp ct
                       on ct.lancto_id = t.lancto_id
                left join ctffrete.v$contrato_transp_dados_ctf c
                       on c.cod_contrato = t.cod_contrato_ctf
                      and c.consulta_id = t.consulta_id
               where 1 = 1
               order by c.data_consulta
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction> 

    <!--- 
    -- PROPSITO 
    -- Busca os dados do contrato para abastecimento interno
    -- GUTO 02/09/2009 - CRIADO
    --->		
    <cffunction name="get_dados_contrato_abastecimento_interno" access="remote" returntype="query" output="true">
        <cfargument name="lancto_id" required="no" default="">
        <cfargument name="num_formulario" required="no" default="">
        <cfargument name="cod_contrato_ctf" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ct.cod_contrato, ctc.lancto_id,
                   ct.data_consulta, ctp.placa_controle, oper.pkg_veiculo.fnc_get_cod_veiculo(ctp.placa_controle) as frota,
                   oper.pkg_veiculo.fnc_km_atual(ctp.placa_controle) as km,
                   case
                     when ct.status_contrato = 2 and (ct.adto_contratado - ct.adto_consumido) < ct.saldo_total then
                          ct.adto_contratado - ct.adto_consumido
                     when ct.status_contrato = 2 and (ct.adto_contratado - ct.adto_consumido) > ct.saldo_total then
                     	  ct.saldo_total
                     when ct.status_contrato = 5 and ct.adto_contratado - ct.adto_consumido > 0 then
                          ct.adto_contratado - ct.adto_consumido
                     when ct.status_contrato = 5 and ct.adto_contratado - ct.adto_consumido < 0 then
                     	  ct.saldo_total
                   else ct.saldo_total end saldo_contrato,
                   (select cg.rv_meaning
                      from kss.cg_ref_codes cg
                     where cg.rv_domain = 'STATUS CONTRATO'
                       and cg.owner = 'CTFFRETE'
                       and cg.rv_low_value = ct.status_contrato) as status_contrato
              from ctffrete.v$contrato_transp_dados_ctf ct
              inner join ctffrete.v$contrato_transp_ctf ctc
                      on ctc.cod_contrato_ctf = ct.cod_contrato
              inner join oper.v$contrato_transp ctp
                      on ctp.lancto_id = ctc.lancto_id
             where ct.data_atualizacao is null
            <cfif Len(Trim(arguments.lancto_id))>
               and ctc.lancto_id = #arguments.lancto_id#
            </cfif>
            <cfif Len(Trim(arguments.num_formulario))>
               and ct.num_formulario = #arguments.num_formulario#
            </cfif>
            <cfif Len(Trim(arguments.cod_contrato_ctf))>
               and ct.cod_contrato = #arguments.cod_contrato_ctf#
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
        <!--- 
    -- PROPSITO 
    -- Busca os contratos de transportes
    -- LEANDRO 31/05/2010 - CRIADO
    --->		
    <cffunction name="get_contrato_transp" access="remote" returntype="query" output="true">       
        <cfargument name="cod_contrato" required="no" default="">
        <cfargument name="num_romaneio" required="no" default="">
        <cfargument name="recebido" required="no" default="">
       	<cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="atualiza_dados" required="no" default="">
        <cfif arguments.ATUALIZA_DADOS eq 1 and Len(Trim(arguments.cod_contrato))>
        	<cfscript>
			   conn = CreateComponent('_transportes.manipulacao.transporte.cfc_ctffrete');
			   conn.busca_dados_contrato(cod_contrato = arguments.cod_contrato);
			</cfscript>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ct.lancto_id
                  , ct.num_romaneio
                  , ctf.cod_contrato_ctf
                  
                  -- dados remetente
                 , ct.cod_remetente
                 , cf.cf_remetente as remetente
                 , cf.cf_remetente_cnpj as remetente_cnpj
                 , cf.cf_rem_endereco as remetente_endereco
                 , cf.cf_rem_municipio as remetente_municipio
                 , cf.cf_rem_uf as remetente_uf      
                     
                  -- dados destinatrio
                  , ct.cod_destinatario
                  , cf.cf_destinatario as destinatario
                  , cf.cf_destinatario_cnpj as destinatario_cnpj
                  , cf.cf_dest_endereco as destinatario_endereco
                  , cf.cf_dest_municipio as destinatario_municipio
                  , cf.cf_dest_uf as destinatario_uf
                     
                  -- proprietrio do veculo      
                  , ct.proprietario_cod_pessoa
                  , cf.cf_proprietario as proprietario
                  , cf.cf_prop_cnpj_cpf as proprietario_cnpj_cpf
                  , cf.cf_prop_endereco as proprietario_endereco
                  , cf.cf_prop_municipio as proprietario_municipio
                  , cf.cf_prop_uf as proprietario_uf
                     
                  -- dados do motorista      
                  , ct.motorista_cod_pessoa
                  , cf.cf_motorista as motorista
                  , cf.cf_mot_cpf as motorista_cpf
                  , cf.cf_mot_endereco as motorista_endereco
                  , cf.cf_mot_municipio as motorista_municipio
                  , cf.cf_mot_uf as motorista_uf
                                          
                 , ct.placa_controle as placa_cavalo
                 , ct.placa_referencia as placa_carreta
                 
                 , nvl((select cr.contrato_recebimento_id
                          from ctffrete.v$contrato_recebimento cr
                          where cr.lancto_id = ct.lancto_id),0) as recibo_id
                 
                 , (select ctfd.saldo_total
                      from ctffrete.v$contrato_transp_dados_ctf ctfd
                     where ctfd.data_consulta = (select max(ctfdd.data_consulta)
                                                      from ctffrete.v$contrato_transp_dados_ctf ctfdd
                                                     where ctfdd.cod_contrato = ctf.cod_contrato_ctf) 
                       and ctfd.cod_contrato = ctf.cod_contrato_ctf) as saldo_total
                 
                 , (select cg.rv_abbreviation
                      from ctffrete.v$contrato_transp_dados_ctf ctfd
                     inner join ctffrete.v$cg_ref_codes cg 
                             on cg.rv_domain = 'STATUS CONTRATO'
                             and cg.rv_low_value = ctfd.status_contrato
                     where ctfd.data_consulta = (select max(ctfdd.data_consulta)
                                                      from ctffrete.v$contrato_transp_dados_ctf ctfdd
                                                     where ctfdd.cod_contrato = ctf.cod_contrato_ctf) 
                       and ctfd.cod_contrato = ctf.cod_contrato_ctf) as situacao

                 , (select ctfd.status_contrato
                      from ctffrete.v$contrato_transp_dados_ctf ctfd
                     where ctfd.data_consulta = (select max(ctfdd.data_consulta)
                                                      from ctffrete.v$contrato_transp_dados_ctf ctfdd
                                                     where ctfdd.cod_contrato = ctf.cod_contrato_ctf) 
                       and ctfd.cod_contrato = ctf.cod_contrato_ctf) as situacao_id
              from oper.v$contrato_transp ct
             inner join oper.v$contrato_transp_form cf
                     on cf.documento_id = ct.lancto_id
             inner join ctffrete.v$contrato_transp_ctf ctf
                     on ctf.lancto_id = ct.lancto_id
                    and ctf.cod_contrato_ctf is not null
              where 1 = 1            
            <cfif Len(Trim(arguments.cod_contrato))>
                and ctf.cod_contrato_ctf = #arguments.cod_contrato#
            </cfif>
            <cfif Len(Trim(arguments.num_romaneio))>
                and ct.num_romaneio = #arguments.num_romaneio#
            </cfif>
            <cfif Len(Trim(arguments.recebido))>
                and not exists (select 0
                                 from ctffrete.v$contrato_recebimento cr
                                 where cr.lancto_id = ct.lancto_id)
            </cfif>
            <cfif Len(Trim(arguments.cod_pessoa_filial))>
                and ct.cod_pessoa_filial = #arguments.cod_pessoa_filial#
            </cfif>
            <cfif Len(Trim(arguments.cod_centro_custo))>
               and ct.cod_centro_custo = #arguments.cod_centro_custo#
            </cfif>            
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca os contratos de transportes recebidos
    -- LEANDRO 14/06/2010 - CRIADO
    --->	
    
    <cffunction name="get_contrato_transp_recebido_dados" access="remote" returntype="query" output="true">
        <cfargument name="contrato_recebimento_id" required="no" default="">
        <cfargument name="lancto_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cr.contrato_recebimento_id
            	 ,	ct.lancto_id            	  
                 , ct.num_romaneio
                 , ctf.cod_contrato_ctf
                                                   
                 -- dados do motorista      
                 , ct.motorista_cod_pessoa
                 , cf.cf_motorista as motorista
                 , cf.cf_mot_cpf as motorista_cpf
                 , cf.cf_mot_endereco as motorista_endereco
                 , cf.cf_mot_municipio as motorista_municipio
                 , cf.cf_mot_uf as motorista_uf                                                         
                 
                 ,cr.valor_pago as saldo_total
                   
                 , to_char(cr.data_recebimento, 'dd/mm/yyyy') as data_recebimento
                 , (select p.razao_social
                      from kss.v$usuarios u
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = u.cod_pessoa
                     where u.usuario =  cr.usuario_recebimento) as usuario_recebimento                  
              from oper.v$contrato_transp ct
             inner join oper.v$contrato_transp_form cf
                     on cf.documento_id = ct.lancto_id
             inner join ctffrete.v$contrato_transp_ctf ctf
                     on ctf.lancto_id = ct.lancto_id
                    and ctf.cod_contrato_ctf is not null
			 inner join ctffrete.v$contrato_recebimento cr
             		 on cr.lancto_id = ct.lancto_id                    
             where 1 = 1
            <cfif Len(Trim(arguments.contrato_recebimento_id))>
                and cr.contrato_recebimento_id = #arguments.contrato_recebimento_id#
            </cfif>   
            <cfif Len(Trim(arguments.lancto_id))>
                and ct.lancto_id = #arguments.lancto_id#
            </cfif>                        
        </cfquery>
        <cfreturn qr_result>
    </cffunction>                   
</cfcomponent>