<cfcomponent displayname="Componentes de consulta para o Controle de Trfego" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Retorna grupos de veculos ativos
	-- NOTAS EXPLICATIVAS
	-- GUTO 21/11/2005 - criado
	--->	
	<cffunction name="get_grupos_veiculos" displayname="Retorna grupos de veculos ativos" output="true" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select vgs.cod_grupo
			  from oper.v$veiculo_grupo_setup vgs
			 where vgs.situacao_id = 1
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna todos os status de eventos possiveis para os veculos
	-- NOTAS EXPLICATIVAS
	-- GUTO 21/11/2005 - criado
	--->	
	<cffunction name="get_status_eventos" displayname="Retorna todos os status de eventos possiveis para os veculos" output="true" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select descricao_resumida 
			  from oper.v$evento_operacao_setup
			 where num_grupo = 1
			   and prioridade = 1
			   and situacao = 1
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Todos os veculos do controle de trfego
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 08/06/2009
	--->	
	<cffunction name="get_controle_trafego" displayname="Todos os veculos do controle de trfego" output="true" returntype="query" access="remote">
		<cfargument name="COD_GRUPO" required="no">
		<cfargument name="VEICULOS" required="no">
		<cfargument name="RASTREADOS" required="no">
		<cfargument name="ENCOSTADOS" required="no">
		<cfargument name="ACIDENTADOS" required="no">
		<cfargument name="STATUS" required="no">
		<cfargument name="PROPRIETARIO" required="no">
		<cfargument name="OPERACAO_ID" required="no" default="">
		<cfargument name="AGREGADO" required="no" default="0">
		<cfargument name="COD_PESSOA_RESPONSAVEL" required="no" default="">
		<cfargument name="COD_FILIAL_ORIGEM" required="no" default="">
		<cfargument name="COD_FILIAL_DESTINO" required="no" default="">
		<cfargument name="COD_VEICULO" required="no" default="">
        <cfargument name="DEDICADO" required="no" default="0">
        <cfif arguments.dedicado eq 1>
			<cfscript>
				qrGrupos = this.get_veiculo_grupo_usuario(usuario = UCase(Trim(session.usuario)));
				if(qrGrupos.RecordCount) {
					arguments.COD_GRUPO = ValueList(qrGrupos.cod_grupo);
				}
				else {
					arguments.COD_GRUPO = -1;
				}
            </cfscript>        
        </cfif>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ct.rastreador_id,
                   upper(kss.pkg_string.fnc_string_clean(ct.destino)) as destino_clear,
                   upper(kss.pkg_string.fnc_string_clean(ct.origem)) as origem_clear,
                   ct.placa_tracao,
                   ct.placa_reboque,
                   ct.placa_controle,
                   ct.num_rastreador,
                   ct.rastreador_com_problemas,
                   (select kss.fnc_concat_all(kss.to_concat_expr(c.solicitacao_carga_id,' / '))
                      from logistica.v$viagem_carga c
                     where c.viagem_id = ct.viagem_id) as solicitacao_carga_id,
                   case
                      when (ct.articulado = 0 or ct.engatada = 1 or (ct.engatada = 0 and ct.placa_referencia is null)) then ct.km_30dias
                      else 0
                   end as km_30dias,
                   case
                      when (ct.articulado = 0 or ct.engatada = 1 or (ct.engatada = 0 and ct.placa_referencia is null)) then ct.km_atual
                      else 0
                   end as km_atual,
                   case
                      when ct.placa_controle is null then 0
                      else ct.km_revisao
                   end as km_revisao,
                   ct.cod_grupo,
                   ct.placa_referencia,
                   ct.engatada,
                   ct.posicao_id,
                   ct.ignicao,
                   ct.ignicao_desc,
                   ct.cod_pessoa,
                   ct.cod_funcionario,
                   ct.com_motorista,
                   ct.aniversario_motorista,
                   to_char(ct.maxdatahora, 'dd/mm/yyyy hh24:mi') as maxdatahora,
                   ct.distancia,
                   ct.referencia,
                   ct.latitude,
                   ct.longitude,
                   ct.tempo,
                   ct.status,
                   nvl(ct.status_msg_destina, 'E') as status_msg_destina,
                   ct.segundos,
                   ct.problema_macro,
                   ct.num_romaneio,
                   ct.num_entrega,
                   ct.origem,
                   ct.carregamento,
                   ct.destino,
                   ct.distancia_destino,
                   ct.remetente,
                   ct.destinatario,
                   to_char(ct.data_inicio, 'dd-mm hh24') as data_inicio_resumida,
                   ct.previsao_vazio,
                   ct.previsao_carregado,
                   ct.pisca_status,
                   ct.motivo,
                   ct.comentario_veiculo,
                   ct.comentario_motorista,
                   ct.comentario_viagem,
                   decode(ct.num_romaneio, null, 0, fiscal.pkg_fiscal.fnc_converte_peso(ct.peso_total, 'Kg', 'Ton')) as peso_total,
                   ct.referencia_id,
                   ct.previsao_texto_descarga,
                   ct.temp_minima_descarga,
                   ct.temp_maxima_descarga,
                   ct.previsao_texto_carga,
                   ct.temp_minima_carga,
                   ct.temp_maxima_carga,
                   ct.cnh_status,
                   ct.cnh_mensagem,
                   ct.laudo_tracao,
                   ct.laudo_reboque,
                   ct.status_cavalo,
                   ct.filial_origem,
                   ct.filial_responsavel,
                   ct.comp_cod_classificacao,
                   ct.comp_classificacao,
                   ct.comp_cap_carga_real,
                   ct.num_entregas,
                   ct.num_entregas_concluidas,
                   kss.pkg_global.fnc_parametro_num(11, 'OPERACIONAL', 17, 495) as permitir_ordem_carregamento,
                   (ct.filial_mais_proxima || '(' || round(ct.distancia_filial, 1) || ' Km)') as filial_mais_proxima,
                   ct.monitorado_por,
                   case
                      when ct.num_evento = any(100, 1, 2) then
                       to_char(ct.previsao_vazio, 'DD Dy HH24:MI ' || '"(' || decode(ct.num_motorista_vazio, 0, '', ct.num_motorista_vazio) || decode(ct.bloquear_previsao_vazio, 1, 'B') || ')"')
                      when num_evento = 5 then
                       ''
                      else
                       to_char(ct.previsao_carregado, 'DD Dy HH24:MI ' || '"(' || decode(ct.num_motorista_carregado, 0, '', ct.num_motorista_carregado) || decode(ct.bloquear_previsao_carr, 1, 'B') || ')"')
                   end as previsao_chegada,
                   case
                      when ct.laudo_tracao = 0 then 'Possui laudo(s) vencido(s)'
                      when ct.laudo_tracao = 1 then 'Possui laudo(s) a vencer'
                      else 'Laudo(s) ok'
                   end as desc_laudo_tracao,
                   case
                      when ct.laudo_reboque = 0 then 'Possui laudo(s) vencido(s)'
                      when ct.laudo_reboque = 1 then 'Possui Laudo(s) a vencer'
                      else 'Laudo(s) ok'
                   end desc_laudo_reboque,
                   ct.modelo_rastreador
              from oper.v$controle_trafego ct
             where 1 = 1
			<cfif Len(Trim(arguments.OPERACAO_ID))>
               and (ct.placa_controle in (select ov.placa
                                            from dedicado.v$operacao_veiculo ov
                                           where ov.data_termino is null
                                             and ov.operacao_id in (select a.operacao_id
                                                                      from table(dedicado.pkg_operacao.fnc_operacao_antecessoras(#arguments.OPERACAO_ID#)) a))
                    or ct.placa_referencia in (select ov.placa
                                                 from dedicado.v$operacao_veiculo ov
                                                where ov.data_termino is null
                                                  and ov.operacao_id in (select a.operacao_id
                                                                           from table(dedicado.pkg_operacao.fnc_operacao_antecessoras(#arguments.OPERACAO_ID#)) a))
                   )                                                      
			</cfif>
            
			<cfif Len(Trim(arguments.COD_VEICULO))>
               and (ct.placa_tracao = '#arguments.COD_VEICULO#' or ct.placa_reboque = '#arguments.COD_VEICULO#')
            <cfelse>
				<cfif Len(Trim(arguments.COD_PESSOA_RESPONSAVEL)) and Not Len(Trim(arguments.OPERACAO_ID))>
               		and ct.cod_pessoa_responsavel = #arguments.COD_PESSOA_RESPONSAVEL#
            	</cfif>
                
            	<cfif Len(Trim(arguments.COD_FILIAL_ORIGEM))>
               		and nvl(ct.cod_filial_origem,1) in (#arguments.COD_FILIAL_ORIGEM#)
            	</cfif>
                
				<cfif Len(Trim(arguments.COD_FILIAL_DESTINO))>
                   	and nvl(ct.cod_filial_destino,1) in (#arguments.COD_FILIAL_DESTINO#)
                </cfif>
                
                <cfif IsDefined("arguments.COD_GRUPO") and Len(Trim(arguments.COD_GRUPO))>
                   	and ct.cod_grupo = any(#ListQualify(arguments.COD_GRUPO,"'")#)
                <cfelseif IsDefined("arguments.COD_GRUPO")>
                    and ct.cod_grupo is null
                </cfif>
            
             	<cfif IsDefined("arguments.VEICULO")>
					<cfswitch expression="#arguments.VEICULO#">
                    	<cfcase value="2">
                        	and ct.engatada = 1
                        </cfcase>
                        <cfcase value="3">
                            and ct.placa_referencia is null
                        </cfcase>
                        <cfcase value="4">
                            and ct.engatada = 1
                        </cfcase>
                        <cfcase value="5">
                            and ct.engatada = 0 and ct.placa_referencia is not null
                        </cfcase>
                    	<cfdefaultcase></cfdefaultcase>
                  	</cfswitch>
              	</cfif>
            
				<cfif IsDefined("arguments.STATUS") and Len(Trim(arguments.STATUS))>
                	and (ct.descricao_resumida = any(#ListQualify(arguments.STATUS,"'")#) or ct.descricao_resumida is null)
                <cfelseif IsDefined("arguments.STATUS")>
                	and ct.descricao_resumida is null
                </cfif>
                
                <cfif IsDefined("arguments.PROPRIETARIO") and arguments.PROPRIETARIO eq 1>
                	and ct.placa_controle = any(#ListQualify(v_lista_placas,"'")#)		
                </cfif>
			</cfif>            
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os grupos do usuario
	-- CRISTOFER  01/08/2007
	--->		
	<cffunction name="get_veiculo_grupo_usuario" access="remote" returntype="query" output="true">
    	<cfargument name="USUARIO" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cod_grupo,
            	   usuario
              from oper.v$veiculo_grupo_setup_usuario t
             where 1=1
             <cfif len(trim(arguments.USUARIO))>
               and upper(trim(usuario)) = '#arguments.USUARIO#'
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os dados do Monitoramento Externo (Controle de Trfego para Gerenciadora)
    -- ANDERSON 05/02/2010 - CRIADO
    --->		
    <cffunction name="get_ctrl_trafego_gerenciadora" access="remote" returntype="query" output="true">
        <cfargument name="veiculos" required="no" default="">
        <cfargument name="rastreados" required="no" default="">
        <cfargument name="engatados" required="no" default="">
        <cfargument name="encostados" required="no" default="">
        <cfargument name="acidentados" required="no" default="">
        <cfargument name="status" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select ctg.placa_controle
                 , ctg.placa_referencia
                 , ctg.placa_referencia_2
                 , ctg.comentario_veiculo
                 , ctg.num_romaneio
                 , ctg.status
                 , ctg.cod_pessoa
                 , ctg.cod_funcionario
                 , ctg.comentario_motorista
                 , ctg.segundos
                 , ctg.tempo
                 , ctg.num_rastreador
                 , ctg.cod_grupo
                 , ctg.origem
                 , ctg.carregamento
                 , ctg.destino
                 , ctg.mercadoria
                 , ctg.num_entrega
                 , ctg.latitude
                 , ctg.longitude
                 , ctg.referencia_id
                 , ctg.referencia
                 , to_char(ctg.maxdatahora, 'dd/mm/yyyy hh24:mi:ss') as maxdatahora
                 , ctg.previsao_vazio_resumida
                 , ctg.previsao_carregado_resumida
                 , to_char(ctg.sensor_data_desengate, 'dd/mm/yyyy hh24:mi:ss') as sensor_data_desengate
                 , ctg.sensor_status_desengate
                 , to_char(ctg.sensor_data_5roda, 'dd/mm/yyyy hh24:mi:ss') as sensor_data_5roda
                 , ctg.sensor_status_5roda
                 , to_char(ctg.sensor_data_bloqueio, 'dd/mm/yyyy hh24:mi:ss') as sensor_data_bloqueio
                 , ctg.sensor_status_bloqueio
                 , ctg.cod_gerenciadora
                 , ctg.articulado
                 , ctg.engatada
                 , ctg.possui_rastreador
                 , ctg.rastreador_com_problemas
                 , ctg.obc_com_problemas
                 , ctg.controle_situacao_id
                 , ctg.descricao_resumida
              from oper.v$ctrl_trafego_gerenciadora ctg
             where 1 = 1
			<cfif Len(Trim(arguments.veiculos))>
            	<cfif arguments.veiculos eq 2>
                	and (ctg.articulado = 0 or ctg.engatada = 1 or (ctg.engatada = 0 and ctg.placa_referencia is null))
                </cfif>
                <cfif arguments.veiculos eq 3>
                	and ctg.placa_referencia is not null
                </cfif>
            </cfif>
            
            <cfif Len(Trim(arguments.rastreados)) and arguments.rastreados eq 1>
               and ctg.possui_rastreador = 1
          	</cfif>
            <cfif Len(Trim(arguments.engatados)) and arguments.engatados eq 1>
               and ctg.engatada = 1
          	</cfif>
            <cfif Len(Trim(arguments.encostados)) and arguments.encostados eq 1 and Len(Trim(arguments.acidentados)) and arguments.acidentados eq 1>
               and ctg.controle_situacao_id in (1, 2, 3, 4)
          	</cfif>
            <cfif Len(Trim(arguments.encostados)) and arguments.encostados eq 1>
               and ctg.controle_situacao_id in (1, 3, 4)
          	</cfif>
            <cfif Len(Trim(arguments.acidentados)) and arguments.acidentados eq 1>
               and ctg.controle_situacao_id in (1, 2, 4)
          	</cfif>
            
            <cfif Len(Trim(arguments.status))>
               and (ctg.descricao_resumida = any(#ListQualify(arguments.STATUS, "'")#) or ctg.descricao_resumida is null)
            <cfelse>
               and ctg.descricao_resumida is null
            </cfif>
             order by ctg.placa_controle asc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna a lista de viagens
    -- FABIOG 02/03/2011 - CRIADO
    --->		
    <cffunction name="get_lista_viagens"  displayname="Lista de Viagens" access="remote" returntype="query" output="true">
        <cfargument name="placa" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select r.num_romaneio  
                 , r.carregamento  
                 , r.destino  
                 , r.cliente  
                 , r.remetente  
                 , r.destinatario  
                 , to_char(r.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_inicio  
                 , to_char(r.data_destinado, 'dd/mm/yyyy hh24:mi:ss') as data_destinado
                 , to_char(r.data_inicio_carga, 'dd/mm/yyyy hh24:mi:ss') as data_inicio_carga 
                 , to_char(r.data_termino_carga, 'dd/mm/yyyy hh24:mi:ss') as data_termino_carga
                 , to_char(r.data_inicio_descarga, 'dd/mm/yyyy hh24:mi:ss') as data_inicio_descarga
                 , to_char(r.data_termino_descarga, 'dd/mm/yyyy hh24:mi:ss') as data_termino_descarga 
                 , to_char( r.data_termino, 'dd/mm/yyyy hh24:mi:ss') as data_termino
                 , r.num_natureza
                 , (select n.descricao
                      from oper.v$natureza n
                     where n.num_natureza = r.num_natureza
                   ) as natureza
                 , r.num_especie
                 , (select e.descricao
                     from oper.v$especie e
                    where e.num_especie = r.num_especie
                   ) as especie
                 , r.cod_unidade  
                 , r.frete_em  
                 , r.peso_total  
                 , r.peso_cobrado  
                 , r.volume_total  
                 , r.m3_total  
                 , r.frete_liquido  
                 , r.despacho  
                 , r.frete_total  
                 , r.valor_entregue  
                 , r.km_vazio  
                 , r.km_carregado  
                 , r.valor_descarga  
                 , cep.pkg_municipio.fnc_cidade_completa(r.org_municipio_id) as org_municipio_completo  
                 , cep.pkg_municipio.fnc_cidade_completa(r.dest_municipio_id) as dest_municipio_completo  
                 , kss.fnc_ref_code('LOGISTICA', 'VIAGEM.SITUACAO_ID',r.situacao_id) as situacao  
                 , r.placa_controle  
                 , r.placa_referencia  
                 , kss.fnc_get_cliente(r.cod_pessoa_filial) as pessoa_filial  
                 , kss.fnc_get_cliente(r.cod_pessoa_responsavel) as filial_responsavel
                 , kss.fnc_ref_code('LOGISTICA', 'VIAGEM.SITUACAO_ID', r.situacao_viagem_id) as situacao_viagem
                 , to_char(r.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , r.user_insert
                 , to_char(r.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update
                 , r.user_update
              from oper.v$romaneio r
             where 1 = 1
			<cfif Len(Trim(arguments.placa))>
               and r.placa_controle = '#arguments.placa#'
            </cfif>            
            <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_fim))>
               and r.data_inicio between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>          
             order by r.data_inicio asc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Todos os veculos do controle de trfego simplificado
	-- NOTAS EXPLICATIVAS
	-- FABIOG 03/03/2011
	--->	
	<cffunction name="get_controle_trafego_simplificado" displayname="Todos os veculos do controle de trfego" output="true" returntype="query" access="remote">
		<cfargument name="COD_GRUPO" required="no">
		<cfargument name="VEICULOS" required="no">
		<cfargument name="RASTREADOS" required="no">
		<cfargument name="ENCOSTADOS" required="no">
		<cfargument name="ACIDENTADOS" required="no">
		<cfargument name="STATUS" required="no">
		<cfargument name="PROPRIETARIO" required="no">
		<cfargument name="OPERACAO_ID" required="no" default="">
		<cfargument name="AGREGADO" required="no" default="0">
		<cfargument name="COD_PESSOA_RESPONSAVEL" required="no" default="">
		<cfargument name="COD_FILIAL_ORIGEM" required="no" default="">
		<cfargument name="COD_FILIAL_DESTINO" required="no" default="">
		<cfargument name="COD_VEICULO" required="no" default="">
        <cfargument name="DEDICADO" required="no" default="0">
        <cfif arguments.dedicado eq 1>
			<cfscript>
				qrGrupos = this.get_veiculo_grupo_usuario(usuario = UCase(Trim(session.usuario)));
				if(qrGrupos.RecordCount) {
					arguments.COD_GRUPO = ValueList(qrGrupos.cod_grupo);
				}
				else {
					arguments.COD_GRUPO = -1;
				}
            </cfscript>        
        </cfif>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#"> 
            select ct.placa_tracao 
                 , ct.placa_reboque 
                 , ct.placa_controle
                 , ct.placa_referencia
                 , (select e.equipamento_id
                      from almoxarifado.v$equipamento e
                     where e.placa = ct.placa_controle) 
                   as equipamento_id_controle
                 , (select e.equipamento_id
                      from almoxarifado.v$equipamento e
                     where e.placa = ct.placa_referencia) 
                   as equipamento_id_referencia
                 , ct.num_rastreador
                 , ct.rastreador_com_problemas
                 , case
                      when (ct.articulado = 0 or ct.engatada = 1 or (ct.engatada = 0 and ct.placa_referencia is null)) then ct.km_30dias
                      else 0
                   end as km_30dias
                 , case
                      when (ct.articulado = 0 or ct.engatada = 1 or (ct.engatada = 0 and ct.placa_referencia is null)) then ct.km_atual
                      else 0
                   end as km_atual
                 , ct.cod_grupo
                 , ct.cod_pessoa
                 , ct.cod_funcionario 
                 , ct.com_motorista
                 , ct.aniversario_motorista
                 , to_char(ct.maxdatahora, 'dd/mm/yyyy hh24:mi') as maxdatahora 
                 , ct.distancia 
                 , ct.referencia
                 , ct.latitude
                 , ct.longitude
                 , ct.tempo
                 , ct.status
                 , ct.problema_macro
                 , ct.num_romaneio 
                 , ct.carregamento 
                 , ct.destino
                 , ct.remetente 
                 , ct.destinatario
                 , ct.referencia_id
                 , ct.cnh_status
                 , ct.engatada
			     , ct.viagem_id
                 , ct.comentario_veiculo
                 , ct.comentario_motorista
                 , ct.comentario_viagem
                 , ct.cnh_mensagem
                 , ct.pisca_status
                 , ct.status_msg_destina
                 , ct.segundos
                 , ct.motivo 
              from oper.v$controle_trafego ct
             where 1 = 1
               and ((ct.controle_situacao_id in (1, 4) and ct.placa_referencia is null)
                or (ct.engatada = 0 and ct.referencia_situacao_id in (1, 4))
                or (ct.engatada = 1 and (ct.controle_situacao_id in (1, 4) or ct.referencia_situacao_id in (1, 4)))) 
             
			<cfif Len(Trim(arguments.OPERACAO_ID))>
               and (ct.placa_controle in (select ov.placa
                                            from dedicado.v$operacao_veiculo ov
                                           where ov.data_termino is null
                                             and ov.operacao_id in (select a.operacao_id
                                                                      from table(dedicado.pkg_operacao.fnc_operacao_antecessoras(#arguments.OPERACAO_ID#)) a))
                    or ct.placa_referencia in (select ov.placa
                                                 from dedicado.v$operacao_veiculo ov
                                                where ov.data_termino is null
                                                  and ov.operacao_id in (select a.operacao_id
                                                                           from table(dedicado.pkg_operacao.fnc_operacao_antecessoras(#arguments.OPERACAO_ID#)) a))
                   )                                                      
			</cfif>
            
			<cfif Len(Trim(arguments.COD_VEICULO))>
               and (ct.placa_tracao = '#arguments.COD_VEICULO#' or ct.placa_reboque = '#arguments.COD_VEICULO#')
            <cfelse>
				<cfif Len(Trim(arguments.COD_PESSOA_RESPONSAVEL)) and Not Len(Trim(arguments.OPERACAO_ID))>
               		and ct.cod_pessoa_responsavel = #arguments.COD_PESSOA_RESPONSAVEL#
            	</cfif>
                
            	<cfif Len(Trim(arguments.COD_FILIAL_ORIGEM))>
               		and nvl(ct.cod_filial_origem,1) in (#arguments.COD_FILIAL_ORIGEM#)
            	</cfif>
                
				<cfif Len(Trim(arguments.COD_FILIAL_DESTINO))>
                   	and nvl(ct.cod_filial_destino,1) in (#arguments.COD_FILIAL_DESTINO#)
                </cfif>
                
                <cfif IsDefined("arguments.COD_GRUPO") and Len(Trim(arguments.COD_GRUPO))>
                    and (ct.cod_grupo = any(#ListQualify(arguments.COD_GRUPO,"'")#)
                    	 or ct.cod_grupo_tracao = any(#ListQualify(arguments.COD_GRUPO,"'")#))
                </cfif>
            
             	<cfif IsDefined("arguments.VEICULO")>
					<cfswitch expression="#arguments.VEICULO#">
                    	<cfcase value="2">
                        	and ct.engatada = 1
                        </cfcase>
                        <cfcase value="3">
                            and ct.placa_referencia is null
                        </cfcase>
                        <cfcase value="4">
                            and ct.engatada = 1
                        </cfcase>
                        <cfcase value="5">
                            and ct.engatada = 0 and ct.placa_referencia is not null
                        </cfcase>
                    	<cfdefaultcase></cfdefaultcase>
                  	</cfswitch>
              	</cfif>
            
				<cfif IsDefined("arguments.STATUS") and Len(Trim(arguments.STATUS))>
                	and (ct.descricao_resumida = any(#ListQualify(arguments.STATUS,"'")#) or ct.descricao_resumida is null)
                <cfelseif IsDefined("arguments.STATUS")>
                	and ct.descricao_resumida is null
                </cfif>
                
                <cfif IsDefined("arguments.PROPRIETARIO") and arguments.PROPRIETARIO eq 1>
                	and ct.placa_controle = any(#ListQualify(v_lista_placas,"'")#)		
                </cfif>
			</cfif>            
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os dados para destinar o veculo
    -- FABIOG 04/03/2011 - CRIADO
    --->		
    <cffunction name="get_dados_veiculo"  displayname="Lista de Viagens" access="remote" returntype="query" output="true">
        <cfargument name="placa" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select oper.pkg_global.fnc_get_cod_funcionario(vm.cod_pessoa) ||
                       (select ' - '||pf.nome
                          from kss.v$pessoa_fisica pf
                         where pf.cod_pessoa = vm.cod_pessoa) 
                         as motorista 
                      ,(select vc.placa_2
                          from oper.v$veiculo_composicao vc
                         where vc.placa_1 = v.placa
                           and vc.data_hora_desengate is null
                        union
                        select vei.placa as placa_2
                          from oper.v$veiculo vei
                         inner join oper.v$veiculo_tipo_carroceria vtc
                                 on vtc.tipo_carroceria_id = vei.tipo_carroceria_id
                         inner join oper.v$veiculo_agrupamento va
                                 on va.agrupamento_id = vtc.agrupamento_id
                                and va.tracao = 1
                                and va.controla = 1
                                and va.articulado = 0
                         where vei.placa = v.placa) 
                         as placa_referencia
                      , v.cod_veiculo placa_tracao
                      , (select kss.fnc_concat_all(kss.to_concat_expr(j.cod_veiculo,' > '))
                           from (select v.cod_veiculo, c.posicao
                                   from (select column_value as placa, rownum-1 as posicao
                                		   from table(kss.pkg_string.fnc_split(rtrim(ltrim(oper.pkg_veiculo.fnc_get_composicao('#arguments.placa#'),'|'),'|'),'|'))) c
                                          inner join oper.v$veiculo v
                                       			  on v.placa = c.placa
                               			order by posicao) j) as composicao                
                  from oper.v$veiculo_dados v 
                  left join oper.v$veiculo_motorista vm
                         on vm.placa = v.placa
                        and vm.data_fim is null       
                 where v.placa = '#arguments.placa#'
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os itens vinculados ao romaneio
    -- FABIOG 08/03/2011 - CRIADO
    --->		
    <cffunction name="get_itens_romaneio"  displayname="Lista de Viagens" access="remote" returntype="query" output="true">
        <cfargument name="num_romaneio" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select ri.item_id
                	 , kss.pkg_pessoa.fnc_get_cliente(ri.cod_remetente) as remetente
                     , cep.fnc_municipio_uf(ri.rem_municipio_id) as origem 
                     , kss.pkg_pessoa.fnc_get_cliente(ri.cod_destinatario ) as destinatario
                     , cep.fnc_municipio_uf(ri.dest_municipio_id) as destino
                     , fiscal.pkg_fiscal.fnc_converte_peso(ri.peso, 'Kg', sc.cod_unidade) as peso 
                     , ri.valor_frete
                  from oper.v$romaneio r
                 inner join oper.v$romaneio_item ri
                         on ri.num_romaneio = r.num_romaneio
                 inner join logistica.v$viagem_carga vcg
                         on vcg.viagem_carga_id = ri.viagem_carga_id
                 inner join logistica.v$solicitacao_carga sc
                         on sc.solicitacao_carga_id = vcg.solicitacao_carga_id 
                 where r.num_romaneio = #arguments.num_romaneio#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os itens vinculados ao romaneio
    -- FABIOG 08/03/2011 - CRIADO
    --->		
    <cffunction name="get_nome_arquivo_ordem_carregamento"  displayname="Lista de Viagens" access="remote" returntype="query" output="true">
        <cfargument name="num_romaneio" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                 select v.num_romaneio || '_' || v.num_viagem_ctrc_cliente || '.pdf' 
                     as nome_arquivo
                   from logistica.v$viagem v
                  where v.num_romaneio = #arguments.num_romaneio#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
</cfcomponent>