<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPÓSITO
    -- Busca latitude e longitude do organograma consultado
    -- 13/02/2009 - criado
    --->	
    <cffunction name="get_referencia" displayname="" output="true" returntype="query" access="public">
        <cfargument name="cod_organograma" required="yes"/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.latitude, r.longitude, cc.centro_custo
              from kss.v$setor_informacoes st
             inner join oper.v$referencia r
                     on r.referencia_id = st.referencia_id 
             inner join kss.v$centro_custo cc
                     on cc.cod_centro_custo =  st.cod_centro_custo
            where cod_organograma = #arguments.cod_organograma#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
    -- PROPÓSITO
    -- Busca veículos que se encontram na latitude e longitude consultada
    -- 13/02/2009 - criado
    --->	
    <cffunction name="get_veiculos_patio" displayname="" output="true" returntype="query" access="public">
        <cfargument name="latitude" required="yes"/>
        <cfargument name="longitude" required="yes"/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select placa_tracao,       
                   case
                     when (ct.articulado = 0 or ct.engatada = 1 or (ct.engatada = 0 and ct.placa_referencia is null)) then 1
                   else 0 end tracao,
                   placa_reboque,
                   case
                     when (ct.placa_referencia is not null) then 1
                   else 0 end semi_reboque,
                   placa_controle, 
                   placa_referencia,
                   cast(controle_situacao_id as number(6)) as controle_situacao_id_imagem,
                   case controle_situacao_id
                        when 0 then
                           'Inativo'||chr(13)  
                        when 1 then
                           ''  
                        when 2 then
                           'Acidentado'||chr(13)  
                        when 3 then
                           'Encostado'||chr(13)  
                        when 4 then
                           'Em Manutenção'||chr(13)  
                        else
                           'Não definido'||chr(13)
                   end ||comentario_veiculo as controle_situacao_id_status,
                   num_rastreador,
                   possui_rastreador,
                   rastreador_com_problemas,
                   case
                      when (ct.articulado = 0 or ct.engatada = 1 or (ct.engatada = 0 and ct.placa_referencia is null)) then km_30dias
                   else 0 end km_30dias,
                   case
                      when (ct.articulado = 0 or ct.engatada = 1 or (ct.engatada = 0 and ct.placa_referencia is null)) then km_atual
                   else 0 end km_atual,
                   case
                      when ct.placa_controle is null then 0
                   else km_revisao end km_revisao,
                   km_revisao_local,
                   cod_grupo,
                   cod_grupo_tracao,
                   marca,
                   cast(carreta_situacao_id as number(6)) as carreta_situacao_id,
                   case carreta_situacao_id
                        when 0 then
                           'Inativo'  
                        when 1 then
                           ''  
                        when 2 then
                           'Acidentado'  
                        when 3 then
                           'Encostado'  
                        when 4 then
                           'Em Manutenção'  
                        else
                           'Não definido'
                   end as carreta_situacao_id_status,       
                   
                   engatada,
                   articulado,
                   cod_pessoa,
                   cod_funcionario,
                   com_motorista,
                   maxdatahora as data_ultima_posicao,
                   case ct.status
                      when 'Vazio' then null
                      when 'Destinado' then ct.distancia_origem
                      when 'Carga' then null
                      when 'Descarga' then null
                      when 'Viagem' then ct.distancia_destino
                      else null
                   end as distancia,
                   referencia||' ('||trim(to_char(round(distancia,2),'9999990D99'))||' Km)' referencia,
                   latitude,
                   longitude,
                   num_evento,
                   tempo,
                   tempo_evento,
                   status,
                   segundos,
                   segundos_tempo_evento,
                   num_romaneio,
                   origem,
                   carregamento,
                   destino,
                   cliente,
                   remetente,
                   destinatario,
                   data_evento,
                   data_evento_resumida,
                   ct.data_inicio,
                   to_char(ct.data_inicio,'dd-mm hh24') data_inicio_resumida,
                   comentario_veiculo,
                   referencia_id, cast(referencia_situacao_id as number(6)) as referencia_situacao_id, referencia_situacao,
                   laudo_tracao, laudo_reboque,
                   case
                      when laudo_tracao = 0 then
                         'Possui laudo(s) vencido(s)'
                      when laudo_tracao = 1 then
                         'Possui laudo(s) a vencer'
                      else 'Laudo(s) ok'
                   end desc_laudo_tracao,
                   case
                      when laudo_reboque = 0 then
                         'Possui laudo(s) vencido(s)'
                      when laudo_reboque = 1 then
                         'Possui Laudo(s) a vencer'
                      else 'Laudo(s) ok'
                   end desc_laudo_reboque, ct.revisao_motivo,
                   case
                      when num_evento =any(100,1,2) then
                         to_char(previsao_vazio, 'DD Dy HH24:MI ' || '"('|| decode(num_motorista_vazio, 0, '', num_motorista_vazio) ||
                                 decode(bloquear_previsao_vazio, 1, 'B') ||  ')"' )
                      when num_evento = 5 then ''
                      else
                         to_char(previsao_carregado, 'DD Dy HH24:MI ' || '"('|| decode(num_motorista_carregado, 0, '', num_motorista_carregado) ||
                                  decode(bloquear_previsao_carr, 1, 'B')|| ')"' )
                   end previsao_chegada,
                   case
                      when num_evento =any(100,1,2) then
                        decode(status_msg_destina,null, 'E', status_msg_destina)
                      else decode(status_msg_previsao,null, 'E', status_msg_previsao)
                   end status_msg_previsao_chegada,
                   distancia_destino,
                   distancia_filial,
                   filial_mais_proxima||' ('||round(distancia_filial,1)||' Km)' filial_mais_proxima,
                   status_cavalo, 
                   cod_pessoa_responsavel, filial_responsavel,
                   comp_cod_classificacao, comp_classificacao,
                   comp_cap_carga_bruta, comp_tara, comp_cap_carga_real,
                   ct.ctrl_tempo, 
                   case
                      when ct.ctrl_tempo < 0 then oper.pkg_global.fnc_tempo_formatado((ct.ctrl_tempo * -1 * 60))
                      else oper.pkg_global.fnc_tempo_formatado(ct.ctrl_tempo * 60)
                   end ctrl_tempo_formatado
                 , ct.viagem_id
                 , case 
                      when ((ct.engatada = 0) and (placa_tracao is null) and (not placa_reboque is null)) then
                         null 
                      else nvl(ct.ignicao,0)   
                   end as ignicao     
                 , nvl2(#arguments.latitude#,round(cep.pkg_coord_geografica.fnc_haversine2(ct.latitude,ct.longitude,#arguments.latitude#,#arguments.longitude#),2),0) as dist_referencia
                 , substr(ct.destino, length(ct.destino)-1, 2) uf_destino
                 , ct.minutos_msg_comunicacao
                 , ordem_servico_id
                 , data_prev_lib_oficina
                 , data_prev_lib_oficina_str
                 , motivo_adiamento_oficina         
                ,  case
                      when (ct.data_prev_lib_oficina is null) then 0 -- deixa em branco
                      -- se estourou a previsão para liberação pinta de vermelho
                      when (sysdate > ct.data_prev_lib_oficina) then 2
                      -- se faltar menos de uma hora para a previsão de liberação pinta de amarelo
                      when ((ct.data_prev_lib_oficina-  sysdate) * 86400) <= 3600 then 1
                      else 0 -- deixa em branco
                   end pinta_data_prev_lib_oficina 
                , ct.fora_raio
                , ct.em_manutencao
                , to_char(decode(ct.em_manutencao,1,'Sim','Não')) as em_manutencao_desc
                , ct.data_entrada_oficina
                , oficina_nome
                , responsavel_os
                , num_ordem_servico
                , ult_insp_pneus_cavalo
                , ult_insp_pneus_carreta
                , prox_tab_revisao_cavalo
                , prox_tab_revisao_carreta
                , classificacao_id_cavalo
                , agrupamento_id_cavalo
                , classificacao_id_carreta
                , agrupamento_id_carreta 
                , to_char(data_macro) as data_macro
                , ct.operador
                , sign((select count(*)
                     from oper.v$material_veiculo mv
                     inner join oper.v$material_veiculo_status ms
                             on ms.material_veiculo_id = mv.material_veiculo_id
                    where ms.data_verificacao > sysdate - 2
                      and mv.PLACA = ct.placa_controle)) as check_list_cavalo         
                , sign((select count(*)
                     from oper.v$material_veiculo mv
                     inner join oper.v$material_veiculo_status ms
                             on ms.material_veiculo_id = mv.material_veiculo_id
                    where ms.data_verificacao > sysdate - 2
                      and mv.placa = ct.placa_referencia)) as check_list_carreta                  
                , sign((select count(*)
                          from oper.v$romaneio_item ri
                         where ri.num_romaneio = ct.num_romaneio)) as carregado
              from oper.v$controle_trafego ct
              where ((ct.controle_situacao_id in (1, 4) and ct.placa_referencia is null)
                or (ct.engatada = 0 and ct.referencia_situacao_id in (1, 4))
                or (ct.engatada = 1 and (ct.controle_situacao_id in (1, 4) or ct.referencia_situacao_id in (1, 4)))) 
               and cep.pkg_coord_geografica.fnc_haversine2(ct.latitude,ct.longitude,#arguments.latitude#,#arguments.longitude#) <= 1
               order by segundos desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>	
</cfcomponent>